' uBasic/4tH - ISBN, EAN and GTIN check - Copyright 2021 J.L. Bezemer
' You can redistribute this file and/or modify it under
' the terms of the GNU General Public License

' Although labeled as ISBN, EAN and GTIN numbers can be checked
' as well by this routine.

a := "978-1734314502" 
Print Show (a), Show (Iif (Func(_IsISBN (a)), "OK", "Fail"))

a := "978-1734314509"
Print Show (a), Show (Iif (Func(_IsISBN (a)), "OK", "Fail"))

a := "978-1788399081"
Print Show (a), Show (Iif (Func(_IsISBN (a)), "OK", "Fail"))

a := "978-1788399083"
Print Show (a), Show (Iif (Func(_IsISBN (a)), "OK", "Fail"))

End

_IsISBN
  Param (1)
  Local (4)

  c@ = 0 : e@ = 1                      ' set sum and multiplier

  For b@ = Len (a@) - 1 To 0 Step -1   ' scan string in reverse
    d@ = Peek(a@, b@) - Ord ("0")      ' get character
    If ((d@ < 0) + (d@ > 9)) = 0 Then c@ = c@ + (d@ * e@)
    e@ = (e@ * 3) % 8                  ' evaluate character, change multiplier
  Next

Return ((c@ % 10) = 0)                 ' modulus 10 must be zero

