/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import java.io.IOException;
import org.apache.commons.lang3.tuple.Pair;
import org.xmlpull.v1.XmlSerializer;

public class ResAttr
extends ResBagValue
implements ResValuesXmlSerializable {
    private static final int BAG_KEY_ATTR_MIN = 0x1000001;
    private static final int BAG_KEY_ATTR_MAX = 0x1000002;
    private static final int BAG_KEY_ATTR_L10N = 0x1000003;
    private static final int TYPE_REFERENCE = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_INT = 4;
    private static final int TYPE_BOOL = 8;
    private static final int TYPE_COLOR = 16;
    private static final int TYPE_FLOAT = 32;
    private static final int TYPE_DIMEN = 64;
    private static final int TYPE_FRACTION = 128;
    private static final int TYPE_ANY_STRING = 238;
    private static final int TYPE_ENUM = 65536;
    private static final int TYPE_FLAGS = 131072;
    private final int mType;
    private final Integer mMin;
    private final Integer mMax;
    private final Boolean mL10n;

    ResAttr(ResReferenceValue parent, int type, Integer min, Integer max, Boolean l10n) {
        super(parent);
        this.mType = type;
        this.mMin = min;
        this.mMax = max;
        this.mL10n = l10n;
    }

    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        return null;
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        String type = this.getTypeAsString();
        serializer.startTag(null, "attr");
        serializer.attribute(null, "name", res.getResSpec().getName());
        if (type != null) {
            serializer.attribute(null, "format", type);
        }
        if (this.mMin != null) {
            serializer.attribute(null, "min", this.mMin.toString());
        }
        if (this.mMax != null) {
            serializer.attribute(null, "max", this.mMax.toString());
        }
        if (this.mL10n != null && this.mL10n.booleanValue()) {
            serializer.attribute(null, "localization", "suggested");
        }
        this.serializeBody(serializer, res);
        serializer.endTag(null, "attr");
    }

    public static ResAttr factory(ResReferenceValue parent, Pair<Integer, ResScalarValue>[] items, ResValueFactory factory) throws AndrolibException {
        int i;
        Integer min = null;
        Integer max = null;
        Boolean l10n = null;
        block9: for (i = 1; i < items.length; ++i) {
            Pair<Integer, ResScalarValue> item = items[i];
            switch (item.getLeft()) {
                case 0x1000001: {
                    min = item.getRight().getRawIntValue();
                    continue block9;
                }
                case 0x1000002: {
                    max = item.getRight().getRawIntValue();
                    continue block9;
                }
                case 0x1000003: {
                    l10n = item.getRight().getRawIntValue() != 0;
                    continue block9;
                }
            }
        }
        int rawValue = items[0].getRight().getRawIntValue();
        int scalarType = rawValue & 0xFFFF;
        if (i == items.length) {
            return new ResAttr(parent, scalarType, min, max, l10n);
        }
        ResPackage pkg = parent.getPackage();
        Pair[] attrItems = new Pair[items.length - i];
        int j = 0;
        while (i < items.length) {
            Pair<Integer, ResScalarValue> item = items[i];
            int resId = item.getLeft();
            pkg.addSynthesizedRes(resId);
            attrItems[j] = Pair.of(factory.newReference(resId, null), item.getRight());
            ++i;
            ++j;
        }
        switch (rawValue & 0xFF0000) {
            case 65536: {
                return new ResEnumAttr(parent, scalarType, min, max, l10n, attrItems);
            }
            case 131072: {
                return new ResFlagsAttr(parent, scalarType, min, max, l10n, attrItems);
            }
        }
        throw new AndrolibException("Could not decode attr value");
    }

    protected void serializeBody(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
    }

    protected String getTypeAsString() {
        StringBuilder sb = new StringBuilder();
        if ((this.mType & 1) != 0) {
            sb.append("|reference");
        }
        if ((this.mType & 2) != 0) {
            sb.append("|string");
        }
        if ((this.mType & 4) != 0) {
            sb.append("|integer");
        }
        if ((this.mType & 8) != 0) {
            sb.append("|boolean");
        }
        if ((this.mType & 0x10) != 0) {
            sb.append("|color");
        }
        if ((this.mType & 0x20) != 0) {
            sb.append("|float");
        }
        if ((this.mType & 0x40) != 0) {
            sb.append("|dimension");
        }
        if ((this.mType & 0x80) != 0) {
            sb.append("|fraction");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(1);
    }
}

