/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public final class DirUtils {
    private static final Logger LOGGER = Logger.getLogger("");

    private DirUtils() {
    }

    public static void copyToDir(Directory in, Directory out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtils.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String[] fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            DirUtils.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String fileName) throws DirectoryException {
        DirUtils.copyToDir(in, out, fileName, fileName);
    }

    public static void copyToDir(Directory in, Directory out, String inFileName, String outFileName) throws DirectoryException {
        try {
            if (in.containsDir(inFileName)) {
                in.getDir(inFileName).copyToDir(out.createDir(outFileName));
            } else {
                BrutIO.copyAndClose(in.getFileInput(inFileName), out.getFileOutput(outFileName));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + inFileName, ex);
        }
    }

    public static void copyToDir(Directory in, File out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtils.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String[] fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            DirUtils.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String fileName) throws DirectoryException {
        DirUtils.copyToDir(in, out, fileName, fileName);
    }

    public static void copyToDir(Directory in, File out, String inFileName, String outFileName) throws DirectoryException {
        try {
            if (in.containsDir(inFileName)) {
                File outDir = new File(out, outFileName);
                OS.rmdir(outDir);
                in.getDir(inFileName).copyToDir(outDir);
            } else if (in.containsFile(inFileName) && !(outFileName = BrutIO.sanitizePath(out, outFileName)).isEmpty()) {
                File outFile = new File(out, outFileName);
                OS.mkdir(outFile.getParentFile());
                BrutIO.copyAndClose(in.getFileInput(inFileName), Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
            }
        }
        catch (FileSystemException ex) {
            LOGGER.warning(String.format("Skipping file %s (%s)", inFileName, ex.getReason()));
        }
        catch (InvalidUnknownFileException | RootUnknownFileException | TraversalUnknownFileException | IOException ex) {
            LOGGER.warning(String.format("Skipping file %s (%s)", inFileName, ex.getMessage()));
        }
        catch (BrutException ex) {
            throw new DirectoryException("Error copying file: " + inFileName, ex);
        }
    }
}

