/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FileDirectory
extends AbstractDirectory {
    private final File mDir;

    public FileDirectory(ExtFile dir, String folder) throws DirectoryException {
        this(new File(dir.toString().replaceAll("%20", " "), folder));
    }

    public FileDirectory(String dir) throws DirectoryException, UnsupportedEncodingException {
        this(new File(URLDecoder.decode(dir, "UTF-8")));
    }

    public FileDirectory(File dir) throws DirectoryException {
        if (!dir.isDirectory()) {
            throw new DirectoryException("file must be a directory: " + dir);
        }
        this.mDir = dir;
    }

    @Override
    public long getSize(String fileName) throws DirectoryException {
        File file = new File(this.generatePath(fileName));
        if (!file.isFile()) {
            throw new DirectoryException("file must be a file: " + file);
        }
        return file.length();
    }

    @Override
    public long getCompressedSize(String fileName) throws DirectoryException {
        return this.getSize(fileName);
    }

    @Override
    protected AbstractDirectory createDirLocal(String name) throws DirectoryException {
        File dir = new File(this.generatePath(name));
        OS.mkdir(dir);
        return new FileDirectory(dir);
    }

    @Override
    protected InputStream getFileInputLocal(String name) throws DirectoryException {
        try {
            File file = new File(this.generatePath(name));
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
    }

    @Override
    protected OutputStream getFileOutputLocal(String name) throws DirectoryException {
        try {
            File file = new File(this.generatePath(name));
            return Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
    }

    @Override
    protected void loadDirs() {
        this.loadAll();
    }

    @Override
    protected void loadFiles() {
        this.loadAll();
    }

    @Override
    protected void removeFileLocal(String name) {
        File file = new File(this.generatePath(name));
        OS.rmfile(file);
    }

    private String generatePath(String name) {
        return this.getDir().getPath() + '/' + name;
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] files = this.getDir().listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    public File getDir() {
        return this.mDir;
    }
}

