/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;

public final class BrutIO {
    private BrutIO() {
    }

    public static byte[] readAndClose(InputStream in) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            IOUtils.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static long recursiveModifiedTime(File[] files) {
        long modified = 0L;
        for (File file : files) {
            long submodified = BrutIO.recursiveModifiedTime(file);
            if (submodified <= modified) continue;
            modified = submodified;
        }
        return modified;
    }

    public static long recursiveModifiedTime(File file) {
        long modified = file.lastModified();
        if (file.isDirectory()) {
            File[] subfiles;
            for (File subfile : subfiles = file.listFiles()) {
                long submodified = BrutIO.recursiveModifiedTime(subfile);
                if (submodified <= modified) continue;
                modified = submodified;
            }
        }
        return modified;
    }

    public static CRC32 calculateCrc(InputStream in) throws IOException {
        int bytesRead;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            crc.update(buffer, 0, bytesRead);
        }
        return crc;
    }

    public static String sanitizePath(File baseDir, String path) throws InvalidUnknownFileException, RootUnknownFileException, TraversalUnknownFileException, IOException {
        if (path.isEmpty()) {
            throw new InvalidUnknownFileException("Invalid Unknown File");
        }
        if (new File(path).isAbsolute()) {
            throw new RootUnknownFileException("Absolute Unknown Files is not allowed");
        }
        String canonicalDirPath = baseDir.getCanonicalPath() + File.separator;
        String canonicalEntryPath = new File(baseDir, path).getCanonicalPath();
        if (!canonicalEntryPath.startsWith(canonicalDirPath)) {
            throw new TraversalUnknownFileException("Directory Traversal is not allowed");
        }
        return canonicalEntryPath.substring(canonicalDirPath.length());
    }

    public static boolean detectPossibleDirectoryTraversal(String path) {
        return path.contains("../") || path.contains("/..") || path.contains("..\\") || path.contains("\\..");
    }

    public static String adaptSeparatorToUnix(String path) {
        char separator = File.separatorChar;
        if (separator != '/') {
            return path.replace(separator, '/');
        }
        return path;
    }
}

