// SPDX-License-Identifier: Apache-2.0
// 
// Copyright 2008-2016 Conrad Sanderson (https://conradsanderson.id.au)
// Copyright 2008-2016 National ICT Australia (NICTA)
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// https://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ------------------------------------------------------------------------


//! \addtogroup fn_nonzeros
//! @{


template<typename T1>
arma_warn_unused
inline
const Op<T1,op_nonzeros>
nonzeros(const Base<typename T1::elem_type,T1>& X)
  {
  arma_debug_sigprint();
  
  return Op<T1,op_nonzeros>(X.get_ref());
  }



template<typename T1>
arma_warn_unused
inline
const SpToDOp<T1, op_sp_nonzeros>
nonzeros(const SpBase<typename T1::elem_type,T1>& X)
  {
  arma_debug_sigprint();
  
  return SpToDOp<T1, op_sp_nonzeros>(X.get_ref());
  }



//! @}
