/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class RangeSeq
extends Seq {
    private final long start;
    private final boolean ascending;

    private RangeSeq(long start, long size, boolean ascending) {
        super(size, AtomType.INTEGER);
        this.start = start;
        this.ascending = ascending;
    }

    public static Value get(long start, long size, boolean ascending) {
        return size < 1L ? Empty.VALUE : (size == 1L ? Itr.get(start) : new RangeSeq(start, size, ascending));
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        long size = in.readLong();
        long start = in.readLong();
        boolean ascending = in.readBool();
        return RangeSeq.get(start, size, ascending);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.size);
        out.writeLong(this.start);
        out.writeBool(this.ascending);
    }

    public boolean ascending() {
        return this.ascending;
    }

    public long min() {
        return this.ascending ? this.start : this.start - this.size + 1L;
    }

    public long max() {
        return this.ascending ? this.start + this.size - 1L : this.start;
    }

    public long get(long pos) {
        return this.start + (this.ascending ? pos : -pos);
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        return pos != 0L ? pos >= this.min() && pos <= this.max() : super.test(qc, ii, pos);
    }

    @Override
    public Object toJava() {
        long[] obj = new long[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.start + (long)(this.ascending ? s : -s);
            ++s;
        }
        return obj;
    }

    @Override
    public Itr itemAt(long index) {
        return Itr.get(this.get(index));
    }

    @Override
    protected Seq subSeq(long pos, long length, QueryContext qc) {
        return new RangeSeq(this.get(pos), length, this.ascending);
    }

    @Override
    public Value insertValue(long pos, Value val, QueryContext qc) {
        if (val instanceof Itr) {
            long step;
            Itr itr = (Itr)val;
            long i = itr.itr();
            long l = step = this.ascending ? 1L : -1L;
            if (pos == 0L && this.get(0L) - step == i || pos == this.size() && this.get(this.size - 1L) + step == i) {
                return new RangeSeq(pos == 0L ? i : this.start, this.size + 1L, this.ascending);
            }
        }
        return super.insertValue(pos, val, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        return RangeSeq.get(this.get(this.size - 1L), this.size(), !this.ascending);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) {
        return this;
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) {
        return true;
    }

    @Override
    public Expr optimizePos(CmpV.OpV op, CompileContext cc) {
        long min = this.min();
        long max = this.max();
        switch (op) {
            case LE: {
                return max <= 0L ? Bln.FALSE : Itr.get(max);
            }
            case LT: {
                return max <= 1L ? Bln.FALSE : Itr.get(max);
            }
            case GE: {
                return min <= 1L ? Bln.TRUE : Itr.get(min);
            }
            case GT: {
                return min <= 0L ? Bln.TRUE : Itr.get(min);
            }
            case EQ: {
                if (min <= 1L && max == Long.MAX_VALUE) {
                    return Bln.TRUE;
                }
                if (max > 0L) break;
                return Bln.FALSE;
            }
            case NE: {
                if (min <= 1L && max == Long.MAX_VALUE) {
                    return Bln.FALSE;
                }
                if (max > 0L) break;
                return Bln.TRUE;
            }
        }
        return min >= 1L ? this : RangeSeq.get(1L, max, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof RangeSeq) {
            RangeSeq rs = (RangeSeq)obj;
            if (this.start != rs.start) return false;
            if (this.size != rs.size) return false;
            if (this.ascending != rs.ascending) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public boolean refineType() {
        return true;
    }

    @Override
    public Value shrink(QueryContext qc) {
        return this;
    }

    @Override
    public String description() {
        return "range sequence";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "from", this.get(0L), "to", this.get(this.size - 1L)), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        String arg = new QueryString().token(this.min()).token("to").token(this.max()).toString();
        if (this.ascending) {
            qs.paren(arg);
        } else {
            qs.function(Function.REVERSE, " " + arg);
        }
    }
}

