<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:custom="custom"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:output method="text" />

	<xsl:param name="major-version" />
	<xsl:param name="minor-version" />
	<xsl:param name="patch-version" />

	<xsl:param name="xqj2-major-version" />
	<xsl:param name="xqj2-minor-version" />
	<xsl:param name="xqj2-patch-version" />

	<xsl:param name="product-name" />
	<xsl:param name="product-version-string" />
	<xsl:param name="build-number" />

	<xsl:template match="/">
package net.xqj.core;

/**
 * MACHINE GENERATED SOURCE FILE.
 * DO NOT EDIT.
**/

public class Version
{
  private static final int PRODUCT_MAJOR_VERSION     = <xsl:value-of select="$major-version" />;
  private static final int PRODUCT_MINOR_VERSION     = <xsl:value-of select="$minor-version" />;
  private static final int PRODUCT_PATCH_VERSION     = <xsl:value-of select="$patch-version" />;

  private static final int XQJ2_MAJOR_VERSION        = <xsl:value-of select="$xqj2-major-version" />;
  private static final int XQJ2_MINOR_VERSION        = <xsl:value-of select="$xqj2-minor-version" />;
  private static final int XQJ2_PATCH_VERSION        = <xsl:value-of select="$xqj2-patch-version" />;

  private static final String PRODUCT_NAME           = "<xsl:value-of select="$product-name" />";
  private static final int BUILD_NUMBER              = <xsl:value-of select="$build-number" />;
  private static final String PRODUCT_VERSION_STRING = "<xsl:value-of select="$product-version-string" />. Build <xsl:value-of select="$build-number" /> / <xsl:value-of select="custom:british-date(fn:current-date())" />.";
  private static final String BUILD_DATE             = "<xsl:value-of select="custom:british-date(fn:current-date())" />";

  public static final int getProductMajorVersion()
  {
    return PRODUCT_MAJOR_VERSION;
  }

  public static final int getProductMinorVersion()
  {
    return PRODUCT_MINOR_VERSION;
  }

  public static final int getProductPatchVersion()
  {
    return PRODUCT_PATCH_VERSION;
  }

  public static final int getXQJ2MajorVersion()
  {
    return XQJ2_MAJOR_VERSION;
  }

  public static final int getXQJ2MinorVersion()
  {
    return XQJ2_MINOR_VERSION;
  }

  public static final int getXQJ2PatchVersion()
  {
    return XQJ2_PATCH_VERSION;
  }

  public static final String getProductName()
  {
    return PRODUCT_NAME;
  }

  public static final String getProductVersion()
  {
    return PRODUCT_VERSION_STRING;
  }

  public static final String getBuildDate()
  {
    return BUILD_DATE;
  }

  public static final int getBuildNumber()
  {
    return BUILD_NUMBER;
  }
}
	</xsl:template>

	<xsl:variable name="datetime">
		<xsl:value-of select="current-dateTime()" />
	</xsl:variable>

	<xsl:variable name="months">
		<month>January</month>
		<month>February</month>
		<month>March</month>
		<month>April</month>
		<month>May</month>
		<month>June</month>
		<month>July</month>
		<month>August</month>
		<month>September</month>
		<month>October</month>
		<month>November</month>
		<month>December</month>
	</xsl:variable>

	<xsl:function name="custom:british-date">
		<xsl:param name="date" as="xs:date"/>
		<xsl:value-of select="day-from-date($date)" />
		<xsl:choose>
			<xsl:when test="fn:day-from-date($date) = (1,21,31)">st</xsl:when>
			<xsl:when test="fn:day-from-date($date) = (2,22)">nd</xsl:when>
			<xsl:when test="fn:day-from-date($date) = (3,23)">rd</xsl:when>
			<xsl:otherwise>th</xsl:otherwise>
		</xsl:choose>
		<xsl:text> </xsl:text>
		<xsl:value-of select="($months/child::*)[month-from-date($date)]" /><xsl:text> </xsl:text>
		<xsl:value-of select="year-from-date($date)" />
	</xsl:function>

</xsl:stylesheet>


