/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class EntityModel {
    private PersistCatalog catalog;

    protected EntityModel() {
    }

    public final boolean isOpen() {
        return this.catalog != null;
    }

    public final void registerClass(Class clazz) {
        if (this.catalog != null) {
            throw new IllegalStateException("Store is already open");
        }
        String string = clazz.getName();
        ClassMetadata classMetadata = this.getClassMetadata(string);
        if (classMetadata == null) {
            throw new IllegalArgumentException("Class is not persistent: " + string);
        }
    }

    void setCatalog(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
    }

    public abstract ClassMetadata getClassMetadata(String var1);

    public abstract EntityMetadata getEntityMetadata(String var1);

    public abstract Set<String> getKnownClasses();

    public final RawType getRawType(String string) {
        if (this.catalog != null) {
            return this.catalog.getFormat(string);
        }
        throw new IllegalStateException("Store is not open");
    }

    public final RawType getRawTypeVersion(String string, int n) {
        if (this.catalog != null) {
            Format format = this.catalog.getLatestVersion(string);
            while (format != null) {
                if (n != format.getVersion()) continue;
                return format;
            }
            return null;
        }
        throw new IllegalStateException("Store is not open");
    }

    public final List<RawType> getAllRawTypeVersions(String string) {
        if (this.catalog != null) {
            Format format = this.catalog.getLatestVersion(string);
            if (format != null) {
                ArrayList<Format> arrayList = new ArrayList<Format>();
                while (format != null) {
                    arrayList.add(format);
                    format = format.getPreviousVersion();
                }
                return Collections.unmodifiableList(arrayList);
            }
            return null;
        }
        throw new IllegalStateException("Store is not open");
    }

    public final List<RawType> getAllRawTypes() {
        if (this.catalog != null) {
            return this.catalog.getAllRawTypes();
        }
        throw new IllegalStateException("Store is not open");
    }

    public final Object convertRawObject(RawObject rawObject) {
        return this.catalog.convertRawObject(rawObject, null);
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string);
        }
    }
}

