/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.asm.ClassReader;
import com.sleepycat.asm.ClassVisitor;
import com.sleepycat.asm.ClassWriter;
import com.sleepycat.persist.model.BytecodeEnhancer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class ClassEnhancer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX = "enhance:";
    private Set<String> packagePrefixes;
    private boolean verbose;

    public static void main(String[] stringArray) throws Exception {
        try {
            boolean bl = false;
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("-")) {
                    if ("-v".equals(stringArray[i])) {
                        bl = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown arg: " + string);
                }
                arrayList.add(new File(string));
            }
            ClassEnhancer classEnhancer = new ClassEnhancer();
            classEnhancer.setVerbose(bl);
            int n = 0;
            for (File file : arrayList) {
                n += classEnhancer.enhanceFile(file);
            }
            if (n > 0) {
                System.out.println("Enhanced: " + n + " files");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static void premain(String string, Instrumentation instrumentation) {
        Object object;
        if (!string.startsWith(AGENT_PREFIX)) {
            throw new IllegalArgumentException("Unknown javaagent args: " + string + " Args must start with: \"" + AGENT_PREFIX + '\"');
        }
        string = string.substring(AGENT_PREFIX.length());
        HashSet<String> hashSet = null;
        boolean bl = false;
        if (string.length() > 0) {
            hashSet = new HashSet<String>();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.startsWith("-")) {
                    if (string2.equals("-v")) {
                        bl = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown javaagent arg: " + string2);
                }
                hashSet.add(string2);
            }
        }
        object = new ClassEnhancer(hashSet);
        ((ClassEnhancer)object).setVerbose(bl);
        instrumentation.addTransformer((ClassFileTransformer)object);
    }

    public ClassEnhancer() {
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public ClassEnhancer(Set<String> set) {
        if (set != null) {
            this.packagePrefixes = new HashSet<String>();
            for (String string : set) {
                this.packagePrefixes.add(string + '.');
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        string = string.replace('/', '.');
        byte[] byArray2 = this.enhance(string, byArray);
        if (this.verbose && byArray2 != null) {
            System.out.println("Enhanced: " + string);
        }
        return byArray2;
    }

    public byte[] enhance(String string, byte[] byArray) {
        if (string != null && this.packagePrefixes != null) {
            for (String string2 : this.packagePrefixes) {
                if (!string.startsWith(string2)) continue;
                return this.enhanceBytes(byArray);
            }
            return null;
        }
        return this.enhanceBytes(byArray);
    }

    int enhanceFile(File file) throws IOException {
        byte[] byArray;
        int n = 0;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    n += this.enhanceFile(new File(file, stringArray[i]));
                }
            }
        } else if (file.getName().endsWith(".class") && (byArray = this.enhanceBytes(this.readFile(file))) != null) {
            long l = file.lastModified();
            this.writeFile(file, byArray);
            file.setLastModified(l);
            ++n;
            if (this.verbose) {
                System.out.println("Enhanced: " + file);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.read(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
        }
    }

    private byte[] enhanceBytes(byte[] byArray) {
        ClassWriter classWriter;
        ClassVisitor classVisitor = classWriter = new ClassWriter(true);
        classVisitor = new BytecodeEnhancer(classVisitor);
        ClassReader classReader = new ClassReader(byArray);
        try {
            classReader.accept(classVisitor, false);
            return classWriter.toByteArray();
        }
        catch (BytecodeEnhancer.NotPersistentException notPersistentException) {
            return null;
        }
    }
}

