/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryExecutionContext;
import org.jkiss.dbeaver.ext.bigquery.model.BigQuerySQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class BigQueryDataSource
extends GenericDataSource {
    public BigQueryDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new BigQuerySQLDialect());
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) throws DBCException {
        return new BigQueryExecutionContext(instance, type);
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String connectionURL = super.getConnectionURL(connectionInfo);
        if (CommonUtils.isNotEmpty((String)connectionURL) && (connectionURL.contains("OAuthPvtKeyPath={server};") || connectionURL.contains("OAuthServiceAcctEmail=;"))) {
            DBPDriver driver = this.getContainer().getDriver();
            return driver.getDataSourceProvider().getConnectionURL(driver, connectionInfo);
        }
        return connectionURL;
    }

    @NotNull
    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("ProjectId", connectionInfo.getDatabaseName());
        if (connectionInfo.getUserName() != null) {
            props.put("OAuthServiceAcctEmail", connectionInfo.getUserName());
        } else {
            props.put("OAuthServiceAcctEmail", "");
        }
        String additionalProjects = connectionInfo.getProviderProperty("AdditionalProjects");
        if (CommonUtils.isNotEmpty((String)additionalProjects)) {
            props.put("AdditionalProjects", additionalProjects);
        }
        return props;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        if (typeName.equals("STRUCT")) {
            return DBPDataKind.STRUCT;
        }
        return super.resolveDataKind(typeName, valueType);
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case STRING: {
                return "STRING";
            }
        }
        return super.getDefaultDataTypeName(dataKind);
    }

    protected boolean isSessionModeEnabled() {
        return false;
    }
}

