/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CGOps.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace fir {
namespace cg {
class XArrayCoorOp;
} // namespace cg
} // namespace fir
namespace fir {
namespace cg {
class XDeclareOp;
} // namespace cg
} // namespace fir
namespace fir {
namespace cg {
class XEmboxOp;
} // namespace cg
} // namespace fir
namespace fir {
namespace cg {
class XReboxOp;
} // namespace cg
} // namespace fir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XArrayCoorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class XArrayCoorOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 7>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  XArrayCoorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fircg.ext_array_coor", odsAttrs.getContext());
  }

  XArrayCoorOpGenericAdaptorBase(XArrayCoorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class XArrayCoorOpGenericAdaptor : public detail::XArrayCoorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::XArrayCoorOpGenericAdaptorBase;
public:
  XArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  XArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : XArrayCoorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  XArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : XArrayCoorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  XArrayCoorOpGenericAdaptor(RangeT values, const XArrayCoorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = XArrayCoorOp, typename = std::enable_if_t<std::is_same_v<LateInst, XArrayCoorOp>>>
  XArrayCoorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getShift() {
    return getODSOperands(2);
  }

  RangeT getSlice() {
    return getODSOperands(3);
  }

  RangeT getSubcomponent() {
    return getODSOperands(4);
  }

  RangeT getIndices() {
    return getODSOperands(5);
  }

  RangeT getLenParams() {
    return getODSOperands(6);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class XArrayCoorOpAdaptor : public XArrayCoorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using XArrayCoorOpGenericAdaptor::XArrayCoorOpGenericAdaptor;
  XArrayCoorOpAdaptor(XArrayCoorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class XArrayCoorOp : public ::mlir::Op<XArrayCoorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = XArrayCoorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = XArrayCoorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fircg.ext_array_coor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getShift() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getSlice() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getSubcomponent() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(5);
  }

  ::mlir::Operation::operand_range getLenParams() {
    return getODSOperands(6);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getShiftMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getSubcomponentMutable();
  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getLenParamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange indices, ::mlir::ValueRange lenParams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange indices, ::mlir::ValueRange lenParams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  unsigned getRank();

  // Shape is optional, but if it exists, it will be at offset 1.
  unsigned getShapeOperandIndex() { return 1; }
  unsigned getShiftOperandIndex() {
    return getShapeOperandIndex() + getShape().size();
  }
  unsigned getSliceOperandIndex() {
    return getShiftOperandIndex() + getShift().size();
  }
  unsigned getSubcomponentOperandIndex() {
    return getSliceOperandIndex() + getSlice().size();
  }
  unsigned getIndicesOperandIndex() {
    return getSubcomponentOperandIndex() + getSubcomponent().size();
  }
  unsigned getLenParamsOperandIndex() {
  return getIndicesOperandIndex() + getIndices().size();
  }
};
} // namespace cg
} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::cg::XArrayCoorOp)

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XDeclareOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class XDeclareOpGenericAdaptorBase {
public:
  struct Properties {
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() {
      auto &propStorage = this->uniq_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  XDeclareOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fircg.ext_declare", odsAttrs.getContext());
  }

  XDeclareOpGenericAdaptorBase(XDeclareOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::mlir::StringAttr getUniqName();
};
} // namespace detail
template <typename RangeT>
class XDeclareOpGenericAdaptor : public detail::XDeclareOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::XDeclareOpGenericAdaptorBase;
public:
  XDeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  XDeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : XDeclareOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  XDeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : XDeclareOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  XDeclareOpGenericAdaptor(RangeT values, const XDeclareOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = XDeclareOp, typename = std::enable_if_t<std::is_same_v<LateInst, XDeclareOp>>>
  XDeclareOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getShift() {
    return getODSOperands(2);
  }

  RangeT getTypeparams() {
    return getODSOperands(3);
  }

  ValueT getDummyScope() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class XDeclareOpAdaptor : public XDeclareOpGenericAdaptor<::mlir::ValueRange> {
public:
  using XDeclareOpGenericAdaptor::XDeclareOpGenericAdaptor;
  XDeclareOpAdaptor(XDeclareOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class XDeclareOp : public ::mlir::Op<XDeclareOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = XDeclareOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = XDeclareOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fircg.ext_declare");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getShift() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::fir::DummyScopeType> getDummyScope() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::fir::DummyScopeType>{} : ::llvm::cast<::mlir::TypedValue<::fir::DummyScopeType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getShiftMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getDummyScopeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::mlir::StringAttr getUniqName();
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, ::mlir::StringAttr uniq_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, ::mlir::StringAttr uniq_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Shape is optional, but if it exists, it will be at offset 1.
  unsigned getShapeOperandIndex() { return 1; }
  unsigned getShiftOperandIndex() {
    return getShapeOperandIndex() + getShape().size();
  }
};
} // namespace cg
} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::cg::XDeclareOp)

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XEmboxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class XEmboxOpGenericAdaptorBase {
public:
  struct Properties {
    using allocator_idxTy = ::mlir::IntegerAttr;
    allocator_idxTy allocator_idx;

    auto getAllocatorIdx() {
      auto &propStorage = this->allocator_idx;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAllocatorIdx(const ::mlir::IntegerAttr &propValue) {
      this->allocator_idx = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 8>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.allocator_idx == this->allocator_idx &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  XEmboxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fircg.ext_embox", odsAttrs.getContext());
  }

  XEmboxOpGenericAdaptorBase(XEmboxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAllocatorIdxAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().allocator_idx);
    return attr;
  }

  ::std::optional<uint32_t> getAllocatorIdx();
};
} // namespace detail
template <typename RangeT>
class XEmboxOpGenericAdaptor : public detail::XEmboxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::XEmboxOpGenericAdaptorBase;
public:
  XEmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  XEmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : XEmboxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  XEmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : XEmboxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  XEmboxOpGenericAdaptor(RangeT values, const XEmboxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = XEmboxOp, typename = std::enable_if_t<std::is_same_v<LateInst, XEmboxOp>>>
  XEmboxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getShift() {
    return getODSOperands(2);
  }

  RangeT getSlice() {
    return getODSOperands(3);
  }

  RangeT getSubcomponent() {
    return getODSOperands(4);
  }

  RangeT getSubstr() {
    return getODSOperands(5);
  }

  RangeT getLenParams() {
    return getODSOperands(6);
  }

  ValueT getSourceBox() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class XEmboxOpAdaptor : public XEmboxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using XEmboxOpGenericAdaptor::XEmboxOpGenericAdaptor;
  XEmboxOpAdaptor(XEmboxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class XEmboxOp : public ::mlir::Op<XEmboxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = XEmboxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = XEmboxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("allocator_idx"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAllocatorIdxAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAllocatorIdxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fircg.ext_embox");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getShift() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getSlice() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getSubcomponent() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getSubstr() {
    return getODSOperands(5);
  }

  ::mlir::Operation::operand_range getLenParams() {
    return getODSOperands(6);
  }

  ::mlir::TypedValue<::fir::ClassType> getSourceBox() {
    auto operands = getODSOperands(7);
    return operands.empty() ? ::mlir::TypedValue<::fir::ClassType>{} : ::llvm::cast<::mlir::TypedValue<::fir::ClassType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getShiftMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getSubcomponentMutable();
  ::mlir::MutableOperandRange getSubstrMutable();
  ::mlir::MutableOperandRange getLenParamsMutable();
  ::mlir::MutableOperandRange getSourceBoxMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAllocatorIdxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().allocator_idx);
  }

  ::std::optional<uint32_t> getAllocatorIdx();
  void setAllocatorIdxAttr(::mlir::IntegerAttr attr) {
    getProperties().allocator_idx = attr;
  }

  void setAllocatorIdx(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeAllocatorIdxAttr() {
      auto &attr = getProperties().allocator_idx;
      attr = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr, ::mlir::ValueRange lenParams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::IntegerAttr allocator_idx);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr, ::mlir::ValueRange lenParams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::IntegerAttr allocator_idx);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // The rank of the entity being emboxed
  unsigned getRank() { return getShape().size(); }

  // The rank of the result. A slice op can reduce the rank.
  unsigned getOutRank();

  // The shape operands are mandatory and always start at 1.
  unsigned getShapeOperandIndex() { return 1; }
  unsigned getShiftOperandIndex() {
    return getShapeOperandIndex() + getShape().size();
  }
  unsigned getSliceOperandIndex() {
    return getShiftOperandIndex() + getShift().size();
  }
  unsigned getSubcomponentOperandIndex() {
    return getSliceOperandIndex() + getSlice().size();
  }
  unsigned getSubstrOperandIndex() {
    return getSubcomponentOperandIndex() + getSubcomponent().size();
  }
  unsigned getLenParamOperandIndex() {
    return getSubstrOperandIndex() + getSubstr().size();
  }
  unsigned getSourceBoxOperandIndex() {
    return getLenParamOperandIndex() + getLenParams().size();
  }
};
} // namespace cg
} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::cg::XEmboxOp)

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XReboxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class XReboxOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 6>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  XReboxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fircg.ext_rebox", odsAttrs.getContext());
  }

  XReboxOpGenericAdaptorBase(XReboxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class XReboxOpGenericAdaptor : public detail::XReboxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::XReboxOpGenericAdaptorBase;
public:
  XReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  XReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : XReboxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  XReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : XReboxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  XReboxOpGenericAdaptor(RangeT values, const XReboxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = XReboxOp, typename = std::enable_if_t<std::is_same_v<LateInst, XReboxOp>>>
  XReboxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getShift() {
    return getODSOperands(2);
  }

  RangeT getSlice() {
    return getODSOperands(3);
  }

  RangeT getSubcomponent() {
    return getODSOperands(4);
  }

  RangeT getSubstr() {
    return getODSOperands(5);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class XReboxOpAdaptor : public XReboxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using XReboxOpGenericAdaptor::XReboxOpGenericAdaptor;
  XReboxOpAdaptor(XReboxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class XReboxOp : public ::mlir::Op<XReboxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = XReboxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = XReboxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fircg.ext_rebox");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getShift() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getSlice() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getSubcomponent() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getSubstr() {
    return getODSOperands(5);
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getShiftMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getSubcomponentMutable();
  ::mlir::MutableOperandRange getSubstrMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  // The rank of the entity being reboxed
  unsigned getRank();
  // The rank of the result box
  unsigned getOutRank();

  unsigned getShapeOperandIndex() { return 1; }
  unsigned getShiftOperandIndex() {
    return getShapeOperandIndex() + getShape().size();
  }
  unsigned getSliceOperandIndex() {
    return getShiftOperandIndex() + getShift().size();
  }
  unsigned getSubcomponentOperandIndex() {
    return getSliceOperandIndex() + getSlice().size();
  }
  unsigned getSubstrOperandIndex() {
    return getSubcomponentOperandIndex() + getSubcomponent().size();
  }
};
} // namespace cg
} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::cg::XReboxOp)


#endif  // GET_OP_CLASSES

