import { Request, Express, RequestHandler, ErrorRequestHandler } from 'express';
import { U as User, a as UnauthenticatedUser, A as A2ARequestHandler } from '../../a2a_request_handler-B3LxMq3P.cjs';
import { ae as AgentCard } from '../../extensions-DvruCIzw.cjs';

type UserBuilder = (req: Request) => Promise<User>;
declare const UserBuilder: {
    noAuthentication: () => Promise<UnauthenticatedUser>;
};

/**
 * @deprecated Use specific middlewares ({@link jsonRpcHandler}, {@link agentCardHandler}) directly.
 */
declare class A2AExpressApp {
    private requestHandler;
    private userBuilder;
    constructor(requestHandler: A2ARequestHandler, userBuilder?: UserBuilder);
    /**
     * Adds A2A routes to an existing Express app.
     * @param app Optional existing Express app.
     * @param baseUrl The base URL for A2A endpoints (e.g., "/a2a/api").
     * @param middlewares Optional array of Express middlewares to apply to the A2A routes.
     * @param agentCardPath Optional custom path for the agent card endpoint (defaults to .well-known/agent-card.json).
     * @returns The Express app with A2A routes.
     */
    setupRoutes(app: Express, baseUrl?: string, middlewares?: Array<RequestHandler | ErrorRequestHandler>, agentCardPath?: string): Express;
}

interface JsonRpcHandlerOptions {
    requestHandler: A2ARequestHandler;
    userBuilder: UserBuilder;
}
/**
 * Creates Express.js middleware to handle A2A JSON-RPC requests.
 * @example
 *
 * ```ts
 * // Handle at root
 * app.use(jsonRpcHandler({ requestHandler: a2aRequestHandler, userBuilder: UserBuilder.noAuthentication }));
 * // or
 * app.use('/a2a/json-rpc', jsonRpcHandler({ requestHandler: a2aRequestHandler, userBuilder: UserBuilder.noAuthentication }));
 * ```
 */
declare function jsonRpcHandler(options: JsonRpcHandlerOptions): RequestHandler;

interface AgentCardHandlerOptions {
    agentCardProvider: AgentCardProvider;
}
type AgentCardProvider = {
    getAgentCard(): Promise<AgentCard>;
} | (() => Promise<AgentCard>);
/**
 * Creates Express.js middleware to handle agent card requests.
 *
 * @example
 * ```ts
 * // With an existing A2ARequestHandler instance:
 * app.use('/.well-known/agent-card.json', agentCardHandler({ agentCardProvider: a2aRequestHandler }));
 * // or with a factory lambda:
 * app.use('/.well-known/agent-card.json', agentCardHandler({ agentCardProvider: async () => agentCard }));
 * ```
 */
declare function agentCardHandler(options: AgentCardHandlerOptions): RequestHandler;

/**
 * Options for configuring the HTTP+JSON/REST handler.
 */
interface RestHandlerOptions {
    requestHandler: A2ARequestHandler;
    userBuilder: UserBuilder;
}
/**
 * Creates Express.js middleware to handle A2A HTTP+JSON/REST requests.
 *
 * This handler implements the A2A REST API specification with snake_case
 * field names, providing endpoints for:
 * - Agent card retrieval (GET /v1/card)
 * - Message sending with optional streaming (POST /v1/message:send|stream)
 * - Task management (GET/POST /v1/tasks/:taskId:cancel|subscribe)
 * - Push notification configuration
 *
 * The handler acts as an adapter layer, converting between REST format
 * (snake_case) at the API boundary and internal TypeScript format (camelCase)
 * for business logic.
 *
 * @param options - Configuration options including the request handler
 * @returns Express router configured with all A2A REST endpoints
 *
 * @example
 * ```ts
 * const app = express();
 * const requestHandler = new DefaultRequestHandler(...);
 * app.use('/api/rest', restHandler({ requestHandler, userBuilder: UserBuilder.noAuthentication }));
 * ```
 */
declare function restHandler(options: RestHandlerOptions): RequestHandler;

export { A2AExpressApp, type AgentCardHandlerOptions, type AgentCardProvider, type JsonRpcHandlerOptions, type RestHandlerOptions, UserBuilder, agentCardHandler, jsonRpcHandler, restHandler };
