/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.util;

import java.util.Locale;
import org.kordamp.jarviz.util.StringUtils;

public enum Algorithm {
    MD5,
    SHA_1,
    SHA_256,
    SHA_512;


    public String formatted() {
        return this.name().toUpperCase(Locale.ENGLISH).replace("_", "-");
    }

    public String extension() {
        return "." + this.name().toLowerCase(Locale.ENGLISH).replace("_", "");
    }

    public static Algorithm of(String str) {
        String value;
        if (StringUtils.isBlank(str)) {
            return null;
        }
        switch (value = str.toUpperCase(Locale.ENGLISH).trim().replace("-", "_")) {
            case "SHA1": {
                return SHA_1;
            }
            case "SHA256": {
                return SHA_256;
            }
            case "SHA512": {
                return SHA_512;
            }
        }
        return Algorithm.valueOf(value);
    }
}

