/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jflex.core.RegExp;
import jflex.core.RegExp1;
import jflex.core.RegExp2;
import jflex.exceptions.MacroException;
import jflex.l10n.ErrorMessages;

public final class Macros {
    private final Map<String, RegExp> macros = new HashMap<String, RegExp>();
    private final Map<String, Boolean> used = new HashMap<String, Boolean>();

    public boolean insert(String name, RegExp definition) {
        this.used.put(name, Boolean.FALSE);
        return this.macros.put(name, definition) == null;
    }

    public boolean markUsed(String name) {
        return this.used.put(name, Boolean.TRUE) != null;
    }

    public boolean isUsed(String name) {
        return this.used.get(name);
    }

    public List<String> unused() {
        ArrayList<String> unUsed = new ArrayList<String>();
        for (String name : this.used.keySet()) {
            Boolean isUsed = this.used.get(name);
            if (isUsed.booleanValue()) continue;
            unUsed.add(name);
        }
        return unUsed;
    }

    public RegExp getDefinition(String name) {
        return this.macros.get(name);
    }

    public void expand() throws MacroException {
        HashSet<String> keys = new HashSet<String>(this.macros.keySet());
        for (String name : keys) {
            if (!this.isUsed(name)) continue;
            this.macros.replace(name, this.expandMacro(name, this.getDefinition(name)));
        }
    }

    private RegExp expandMacro(String name, RegExp definition) throws MacroException {
        switch (definition.type) {
            case 41: 
            case 57: {
                RegExp2 binary = (RegExp2)definition;
                binary.r1 = this.expandMacro(name, binary.r1);
                binary.r2 = this.expandMacro(name, binary.r2);
                return definition;
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)definition;
                unary.content = this.expandMacro(name, (RegExp)unary.content);
                return definition;
            }
            case 49: {
                String usename = (String)((RegExp1)definition).content;
                if (Objects.equals(name, usename)) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_CYCLE, name));
                }
                RegExp usedef = this.getDefinition(usename);
                if (usedef == null) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_DEF_MISSING, usename, name));
                }
                this.markUsed(usename);
                return this.expandMacro(name, usedef);
            }
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                return definition;
            }
            case 52: 
            case 53: {
                RegExp1 cclass = (RegExp1)definition;
                ArrayList<RegExp> classes = new ArrayList<RegExp>();
                for (RegExp regexp : (List)cclass.content) {
                    classes.add(this.expandMacro(name, regexp));
                }
                cclass.content = classes;
                return cclass;
            }
            case 54: {
                RegExp2 cclassOp = (RegExp2)((RegExp1)definition).content;
                cclassOp.r1 = this.expandMacro(name, cclassOp.r1);
                cclassOp.r2 = this.expandMacro(name, cclassOp.r2);
                return definition;
            }
        }
        throw new MacroException("unknown expression type " + definition.typeName() + " in macro expansion");
    }
}

