/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons.feign;

import feign.Logger;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class FeignLogger
extends Logger {
    private final JReleaserLogger logger;

    public FeignLogger(JReleaserLogger logger) {
        this.logger = logger;
    }

    protected void log(String configKey, String format, Object ... args) {
        this.logger.trace(String.format(FeignLogger.methodTag((String)configKey) + format, args));
    }

    public static Logger.Level resolveLevel(JReleaserContext context) {
        String value;
        Properties vars = context.getModel().getEnvironment().getVars();
        if (null == vars) {
            vars = new Properties();
        }
        if (StringUtils.isBlank((String)(value = Env.resolve((Collection)CollectionUtils.listOf((Object[])new String[]{"feign.logger.level"}), (Properties)vars)))) {
            return Logger.Level.NONE;
        }
        return Logger.Level.valueOf((String)value.trim().toUpperCase(Locale.ENGLISH));
    }
}

