/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class SpecPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.SpecPackager, SpecPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 3054130455318535496L;
    private final List<String> requires = new ArrayList<String>();
    private final SpecRepository repository = new SpecRepository();
    private String packageName;
    private String release;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.SpecPackager immutable = new org.jreleaser.model.api.packagers.SpecPackager(){
        private static final long serialVersionUID = -457526873236886772L;

        public String getPackageName() {
            return SpecPackager.this.packageName;
        }

        public String getRelease() {
            return SpecPackager.this.release;
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return SpecPackager.this.repository.asImmutable();
        }

        public List<String> getRequires() {
            return Collections.unmodifiableList(SpecPackager.this.requires);
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return SpecPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return SpecPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(SpecPackager.this.getSkipTemplates());
        }

        public String getType() {
            return SpecPackager.this.getType();
        }

        public String getDownloadUrl() {
            return SpecPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return SpecPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return SpecPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return SpecPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return SpecPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return SpecPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return SpecPackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return SpecPackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return SpecPackager.this.getActive();
        }

        public boolean isEnabled() {
            return SpecPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SpecPackager.this.asMap(full));
        }

        public String getPrefix() {
            return SpecPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SpecPackager.this.getExtraProperties());
        }
    };

    public SpecPackager() {
        super("spec");
    }

    @Override
    public org.jreleaser.model.api.packagers.SpecPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SpecPackager source) {
        super.merge(source);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.release = this.merge(this.release, source.release);
        this.setRepository(source.repository);
        this.setRequires(this.merge(this.requires, source.requires));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public SpecRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SpecRepository repository) {
        this.repository.merge(repository);
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        this.requires.clear();
        this.requires.addAll(requires);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("release", this.release);
        props.put("requires", this.requires);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipSpec"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class SpecRepository
    extends PackagerRepository {
        private static final long serialVersionUID = -4727714362653863706L;

        public SpecRepository() {
            super("spec", "spec");
        }
    }
}

