/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.configuration.internal;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.bean.DeclaredMembers;
import org.eclipse.sisu.plexus.TypeArguments;

public final class EnhancedCompositeBeanHelper {
    private static final ConcurrentMap<Class<?>, Map<String, MethodInfo>> METHOD_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Field, Boolean> ACCESSIBLE_FIELD_CACHE = new ConcurrentHashMap<Field, Boolean>();
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    public EnhancedCompositeBeanHelper(ConverterLookup lookup, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    public void setDefault(Object bean, Object defaultValue, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Class<?> beanType = bean.getClass();
        MethodInfo setterInfo = this.findCachedMethod(beanType, "", null);
        if (setterInfo == null) {
            Map classMethodCache = METHOD_CACHE.computeIfAbsent(beanType, this::buildMethodCache);
            setterInfo = (MethodInfo)classMethodCache.get("set");
        }
        if (setterInfo == null) {
            throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + String.valueOf(beanType));
        }
        Object value = defaultValue;
        TypeLiteral paramType = TypeLiteral.get((Type)setterInfo.parameterType);
        if (!paramType.getRawType().isInstance(value)) {
            if (configuration.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
            }
            value = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration);
        }
        if (value != null) {
            try {
                if (this.listener != null) {
                    this.listener.notifyFieldChangeUsingSetter("", value, bean);
                }
                setterInfo.method.invoke(bean, value);
            }
            catch (IllegalAccessException | LinkageError | InvocationTargetException e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
    }

    public void setProperty(Object bean, String propertyName, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Field field;
        Class<?> beanType = bean.getClass();
        MethodInfo methodInfo = this.findCachedMethod(beanType, propertyName, valueType);
        if (methodInfo != null) {
            try {
                Object value = this.convertPropertyForMethod(beanType, methodInfo, valueType, configuration);
                if (value != null) {
                    if (this.listener != null) {
                        this.listener.notifyFieldChangeUsingSetter(propertyName, value, bean);
                    }
                    methodInfo.method.invoke(bean, value);
                    return;
                }
            }
            catch (IllegalAccessException | LinkageError | InvocationTargetException value) {
                // empty catch block
            }
        }
        if ((field = this.findCachedField(beanType, propertyName)) != null) {
            try {
                Object value = this.convertPropertyForField(beanType, field, valueType, configuration);
                if (value != null) {
                    if (this.listener != null) {
                        this.listener.notifyFieldChangeUsingReflection(propertyName, value, bean);
                    }
                    this.setFieldValue(bean, field, value);
                    return;
                }
            }
            catch (IllegalAccessException | LinkageError throwable) {
                // empty catch block
            }
        }
        if (methodInfo == null && field == null) {
            throw new ComponentConfigurationException(configuration, "Cannot find '" + propertyName + "' in " + String.valueOf(beanType));
        }
    }

    private MethodInfo findCachedMethod(Class<?> beanType, String propertyName, Class<?> valueType) {
        String title;
        Map classMethodCache = METHOD_CACHE.computeIfAbsent(beanType, this::buildMethodCache);
        MethodInfo setter = (MethodInfo)classMethodCache.get("set" + (title = Character.toTitleCase(propertyName.charAt(0)) + propertyName.substring(1)));
        if (setter != null && this.isMethodCompatible(setter.method, valueType)) {
            return setter;
        }
        MethodInfo adder = (MethodInfo)classMethodCache.get("add" + title);
        if (adder != null && this.isMethodCompatible(adder.method, valueType)) {
            return adder;
        }
        return setter != null ? setter : adder;
    }

    private Map<String, MethodInfo> buildMethodCache(Class<?> beanType) {
        HashMap<String, MethodInfo> methodMap = new HashMap<String, MethodInfo>();
        for (Method method : beanType.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1) continue;
            Type[] paramTypes = method.getGenericParameterTypes();
            methodMap.putIfAbsent(method.getName(), new MethodInfo(method, paramTypes[0]));
        }
        return methodMap;
    }

    private boolean isMethodCompatible(Method method, Class<?> valueType) {
        if (valueType == null) {
            return true;
        }
        return method.getParameterTypes()[0].isAssignableFrom(valueType);
    }

    private Field findCachedField(Class<?> beanType, String fieldName) {
        Map classFieldCache = FIELD_CACHE.computeIfAbsent(beanType, this::buildFieldCache);
        return (Field)classFieldCache.get(fieldName);
    }

    private Map<String, Field> buildFieldCache(Class<?> beanType) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Object member : new DeclaredMembers(beanType, new DeclaredMembers.View[]{DeclaredMembers.View.FIELDS})) {
            Field field = (Field)member;
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldMap.put(field.getName(), field);
        }
        return fieldMap;
    }

    private Object convertPropertyForMethod(Class<?> beanType, MethodInfo methodInfo, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        TypeLiteral paramType = TypeLiteral.get((Type)methodInfo.parameterType);
        return this.convertProperty(beanType, valueType, configuration, paramType);
    }

    private Object convertPropertyForField(Class<?> beanType, Field field, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        TypeLiteral fieldType = TypeLiteral.get((Type)field.getGenericType());
        return this.convertProperty(beanType, valueType, configuration, fieldType);
    }

    private Object convertProperty(Class<?> beanType, Class<?> valueType, PlexusConfiguration configuration, TypeLiteral<?> paramType) throws ComponentConfigurationException {
        Class<?> rawPropertyType = paramType.getRawType();
        if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
            rawPropertyType = valueType;
        }
        return this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration);
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] propertyTypeArgs = TypeArguments.get((Type)genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, propertyTypeArgs, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private void setFieldValue(Object bean, Field field, Object value) throws IllegalAccessException {
        Boolean isAccessible = (Boolean)ACCESSIBLE_FIELD_CACHE.get(field);
        if (isAccessible == null) {
            isAccessible = field.canAccess(bean);
            if (!isAccessible.booleanValue()) {
                field.setAccessible(true);
                isAccessible = true;
            }
            ACCESSIBLE_FIELD_CACHE.put(field, isAccessible);
        } else if (!isAccessible.booleanValue()) {
            field.setAccessible(true);
            ACCESSIBLE_FIELD_CACHE.put(field, true);
        }
        field.set(bean, value);
    }

    public static void clearCaches() {
        METHOD_CACHE.clear();
        FIELD_CACHE.clear();
        ACCESSIBLE_FIELD_CACHE.clear();
    }

    private record MethodInfo(Method method, Type parameterType) {
    }
}

