/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeStrategy;
import org.jdom2.Document;

@Named
@Singleton
public class StrategyOrchestrator {
    private final List<UpgradeStrategy> strategies;

    @Inject
    public StrategyOrchestrator(List<UpgradeStrategy> strategies) {
        this.strategies = strategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult executeStrategies(UpgradeContext context, Map<Path, Document> pomMap) {
        context.println();
        context.info("Maven Upgrade Tool");
        this.logUpgradeOptions(context);
        UpgradeResult overallResult = UpgradeResult.empty();
        ArrayList<String> executedStrategies = new ArrayList<String>();
        for (UpgradeStrategy strategy : this.strategies) {
            context.indent();
            if (strategy.isApplicable(context)) {
                context.info("");
                context.action("Executing strategy: " + strategy.getDescription());
                context.indent();
                executedStrategies.add(strategy.getDescription());
                try {
                    UpgradeResult result = strategy.apply(context, pomMap);
                    overallResult = overallResult.merge(result);
                    if (result.success()) {
                        context.success("Strategy completed successfully");
                    }
                    context.warning("Strategy completed with " + result.errorCount() + " error(s)");
                }
                catch (Exception e) {
                    context.failure("Strategy execution failed: " + e.getMessage());
                    Set<Path> allPoms = pomMap.keySet();
                    UpgradeResult failureResult = UpgradeResult.failure(allPoms, Set.of());
                    overallResult = overallResult.merge(failureResult);
                }
                finally {
                    context.unindent();
                }
            } else {
                context.detail("Skipping strategy: " + strategy.getDescription() + " (not applicable)");
            }
            context.unindent();
        }
        this.logOverallSummary(context, overallResult, executedStrategies);
        return overallResult;
    }

    private void logUpgradeOptions(UpgradeContext context) {
        UpgradeOptions options = context.options();
        context.action("Upgrade options:");
        context.indent();
        if (options.all().orElse(false).booleanValue()) {
            context.detail("--all (enables all upgrade options)");
        } else {
            if (options.modelVersion().isPresent()) {
                context.detail("--model-version " + (String)options.modelVersion().get());
            }
            if (options.model().orElse(false).booleanValue()) {
                context.detail("--model");
            }
            if (options.plugins().orElse(false).booleanValue()) {
                context.detail("--plugins");
            }
            if (options.infer().orElse(false).booleanValue()) {
                context.detail("--infer");
            }
            if (options.modelVersion().isEmpty() && options.model().isEmpty() && options.plugins().isEmpty() && options.infer().isEmpty()) {
                context.detail("(using defaults: --model --plugins --infer)");
            }
        }
        context.unindent();
    }

    private void logOverallSummary(UpgradeContext context, UpgradeResult overallResult, List<String> executedStrategies) {
        context.println();
        context.info("Overall Upgrade Summary:");
        context.indent();
        context.info(overallResult.processedCount() + " POM(s) processed");
        context.info(overallResult.modifiedCount() + " POM(s) modified");
        context.info(overallResult.unmodifiedCount() + " POM(s) needed no changes");
        context.info(overallResult.errorCount() + " error(s) encountered");
        context.unindent();
        if (!executedStrategies.isEmpty()) {
            context.println();
            context.info("Executed Strategies:");
            context.indent();
            for (String strategy : executedStrategies) {
                context.detail(strategy);
            }
            context.unindent();
        }
        if (overallResult.modifiedCount() > 0 && overallResult.errorCount() == 0) {
            context.success("All upgrades completed successfully!");
        } else if (overallResult.modifiedCount() > 0 && overallResult.errorCount() > 0) {
            context.warning("Upgrades completed with some errors");
        } else if (overallResult.modifiedCount() == 0 && overallResult.errorCount() == 0) {
            context.success("No upgrades needed - all POMs are up to date");
        } else {
            context.failure("Upgrade process failed");
        }
    }
}

