/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.impl.RepositorySystemValidator;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.internal.impl.session.DefaultSessionBuilder;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.artifact.decorator.ArtifactDecorator;
import org.eclipse.aether.spi.artifact.decorator.ArtifactDecoratorFactory;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.visitor.LevelOrderDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.graph.visitor.PostorderDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.repository.ChainedLocalRepositoryManager;

@Singleton
@Named
public class DefaultRepositorySystem
implements RepositorySystem {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicInteger sessionIdCounter = new AtomicInteger(0);
    private final VersionResolver versionResolver;
    private final VersionRangeResolver versionRangeResolver;
    private final ArtifactResolver artifactResolver;
    private final MetadataResolver metadataResolver;
    private final ArtifactDescriptorReader artifactDescriptorReader;
    private final DependencyCollector dependencyCollector;
    private final Installer installer;
    private final Deployer deployer;
    private final LocalRepositoryProvider localRepositoryProvider;
    private final SyncContextFactory syncContextFactory;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final Map<String, ArtifactDecoratorFactory> artifactDecoratorFactories;
    private final RepositorySystemValidator repositorySystemValidator;

    @Inject
    public DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, RepositorySystemLifecycle repositorySystemLifecycle, Map<String, ArtifactDecoratorFactory> artifactDecoratorFactories, RepositorySystemValidator repositorySystemValidator) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle, "repository system lifecycle cannot be null");
        this.artifactDecoratorFactories = Objects.requireNonNull(artifactDecoratorFactories, "artifact decorator factories cannot be null");
        this.repositorySystemValidator = Objects.requireNonNull(repositorySystemValidator, "repository system validator cannot be null");
    }

    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateVersionRequest(session, request);
        return this.versionResolver.resolveVersion(session, request);
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateVersionRangeRequest(session, request);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateArtifactDescriptorRequest(session, request);
        ArtifactDescriptorResult descriptorResult = this.artifactDescriptorReader.readArtifactDescriptor(session, request);
        for (ArtifactDecorator artifactDecorator : Utils.getArtifactDecorators(session, this.artifactDecoratorFactories)) {
            descriptorResult.setArtifact(artifactDecorator.decorateArtifact(descriptorResult));
        }
        return descriptorResult;
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateArtifactRequests(session, Collections.singleton(request));
        return this.artifactResolver.resolveArtifact(session, request);
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(requests, "requests cannot be null");
        this.repositorySystemValidator.validateArtifactRequests(session, requests);
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        Objects.requireNonNull(requests, "requests cannot be null");
        this.repositorySystemValidator.validateMetadataRequests(session, requests);
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateCollectRequest(session, request);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List results;
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateDependencyRequest(session, request);
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new NullPointerException("dependency node and collect request cannot be null");
        }
        List<DependencyNode> dependencyNodes = this.doFlattenDependencyNodes(session, result.getRoot(), request.getFilter());
        List requests = dependencyNodes.stream().map(n -> {
            if (n.getDependency() != null) {
                ArtifactRequest artifactRequest = new ArtifactRequest(n);
                artifactRequest.setTrace(trace);
                return artifactRequest;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setDependencyNodeResults(dependencyNodes);
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    public List<DependencyNode> flattenDependencyNodes(RepositorySystemSession session, DependencyNode root, DependencyFilter dependencyFilter) {
        this.validateSession(session);
        Objects.requireNonNull(root, "root cannot be null");
        return this.doFlattenDependencyNodes(session, root, dependencyFilter);
    }

    private List<DependencyNode> doFlattenDependencyNodes(RepositorySystemSession session, DependencyNode root, DependencyFilter dependencyFilter) {
        ArrayList<DependencyNode> dependencyNodes = new ArrayList<DependencyNode>();
        if (root != null) {
            root.accept(this.getDependencyVisitor(session, dependencyNodes::add, dependencyFilter));
        }
        return dependencyNodes;
    }

    private DependencyVisitor getDependencyVisitor(RepositorySystemSession session, Consumer<DependencyNode> nodeConsumer, DependencyFilter dependencyFilter) {
        String strategy;
        switch (strategy = ConfigUtils.getString((RepositorySystemSession)session, (String)"levelOrder", (String[])new String[]{"aether.system.dependencyVisitor"})) {
            case "preOrder": {
                return new PreorderDependencyNodeConsumerVisitor(nodeConsumer, dependencyFilter);
            }
            case "postOrder": {
                return new PostorderDependencyNodeConsumerVisitor(nodeConsumer, dependencyFilter);
            }
            case "levelOrder": {
                return new LevelOrderDependencyNodeConsumerVisitor(nodeConsumer, dependencyFilter);
            }
        }
        throw new IllegalArgumentException("Invalid dependency visitor strategy: " + strategy);
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateInstallRequest(session, request);
        return this.installer.install(session, request);
    }

    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        this.repositorySystemValidator.validateDeployRequest(session, request);
        return this.deployer.deploy(session, request);
    }

    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        this.validateSystem();
        this.repositorySystemValidator.validateLocalRepositories(session, Collections.singleton(localRepository));
        return this.createLocalRepositoryManager(session, localRepository);
    }

    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository ... localRepositories) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(localRepositories, "localRepositories cannot be null");
        this.validateSystem();
        this.repositorySystemValidator.validateLocalRepositories(session, Arrays.asList(localRepositories));
        return this.createLocalRepositoryManager(session, Arrays.asList(localRepositories));
    }

    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, List<LocalRepository> localRepositories) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(localRepositories, "localRepositories cannot be null");
        this.validateSystem();
        this.repositorySystemValidator.validateLocalRepositories(session, localRepositories);
        return this.createLocalRepositoryManager(session, localRepositories);
    }

    private LocalRepositoryManager createLocalRepositoryManager(RepositorySystemSession session, List<LocalRepository> localRepositories) {
        if (localRepositories.isEmpty()) {
            throw new IllegalArgumentException("empty localRepositories");
        }
        if (localRepositories.size() == 1) {
            return this.createLocalRepositoryManager(session, localRepositories.get(0));
        }
        LocalRepositoryManager head = this.createLocalRepositoryManager(session, localRepositories.get(0));
        List tail = localRepositories.subList(1, localRepositories.size()).stream().map(l -> this.createLocalRepositoryManager(session, (LocalRepository)l)).collect(Collectors.toList());
        return new ChainedLocalRepositoryManager(head, tail, session);
    }

    private LocalRepositoryManager createLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.validateSession(session);
        this.validateRepositories(repositories);
        this.repositorySystemValidator.validateRemoteRepositories(session, repositories);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        this.validateSession(session);
        Objects.requireNonNull(repository, "repository cannot be null");
        this.repositorySystemValidator.validateRemoteRepositories(session, Collections.singletonList(repository));
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy = session.getProxySelector().getProxy(repository);
        builder.setProxy(proxy);
        return builder.build();
    }

    public void addOnSystemEndedHandler(Runnable handler) {
        this.validateSystem();
        this.repositorySystemLifecycle.addOnSystemEndedHandler(handler);
    }

    public RepositorySystemSession.SessionBuilder createSessionBuilder() {
        this.validateSystem();
        return new DefaultSessionBuilder(this, this.repositorySystemLifecycle, () -> "id-" + this.sessionIdCounter.incrementAndGet());
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.repositorySystemLifecycle.systemEnded();
        }
    }

    private void validateSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.invalidSession(session.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session.getSystemProperties(), "system properties");
        this.invalidSession(session.getUserProperties(), "user properties");
        this.invalidSession(session.getConfigProperties(), "config properties");
        this.invalidSession(session.getMirrorSelector(), "mirror selector");
        this.invalidSession(session.getProxySelector(), "proxy selector");
        this.invalidSession(session.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session.getData(), "data");
        this.validateSystem();
    }

    private void validateSystem() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }

    private void validateRepositories(List<RemoteRepository> repositories) {
        Objects.requireNonNull(repositories, "repositories cannot be null");
        for (RemoteRepository repository : repositories) {
            Objects.requireNonNull(repository, "repository cannot be null");
        }
    }

    private void invalidSession(Object obj, String name) {
        Objects.requireNonNull(obj, "repository system session's " + name + " cannot be null");
    }
}

