#|
   Modular polynomials for p <= 151
   -------------------------------------------------------------------------
   
   The coefficients were copied from PARI/GP (license GPL) and coded in hex 
   if this saved some characters.
   PARI/GP extracted the polynomials from the ECHIDNA databases available at 
   http://echidna.maths.usyd.edu.au/kohel/dbs/
   They were computed by David R. Kohel, University of Sydney.
|#

(defvar *ec-g* (make-array 152 :element-type 'list :initial-element nil))
(defvar *ec-g1* (make-array 152 :element-type 'list :initial-element nil))

(defvar *ec-sea-data?* t "has this file been loaded?")

(setf 
  (svref *ec-g*  2) 
    '( 3 1 2 48 1 (1 -1 0 768) 0 4096)
  (svref *ec-g*  3) 
    '( 4 1 3 36 2 270 1 (1 -1 0 756) 0 729)
  (svref *ec-g*  5) 
    '( 6 1 5 30 4 315 3 1300 2 1575 1 (1 -1 0 750) 0 125)
  (svref *ec-g*  7) 
    '( 8 1 7 28 6 322 5 1904 4 5915 3 8624 2 4018 1 (1 -1 0 748) 0 49)
  (svref *ec-g* 11) 
    '(12 1 11 -5940 10 14701434 9 (1 -139755 0 -19264518900) 8 (1 723797800 0 13849401061815) 7 (2 67496 1 -1327909897380 0 -4875351166521000) 6 (2 2291468355 1 1036871615940600 0 400050977713074380) 5 (3 -5346 2 4231762569540 1 -310557763459301490 0 122471154456433615800) 4 (3 161201040 2 755793774757450 1 17309546645642506200 0 6513391734069824031615) 3 (4 132 3 -49836805205 2 6941543075967060 1 -64815179429761398660 0 104264884483130180036700) 2 (4 468754 3 51801406800 2 214437541826475 1 77380735840203400 0 804140494949359194) 1 (5 -1 4 3732 3 -4586706 2 2059075976 1 -253478654715 0 2067305393340) 0 1771561)
  (svref *ec-g* 13) 
    '(14 1 13 26 12 325 11 2548 10 13832 9 54340 8 157118 7 333580 6 509366 5 534820 4 354536 3 124852 2 15145 1 (1 -1 0 746) 0 13) 
  (svref *ec-g* 17) 
    '(18 1 17 510 16 125001 15 19248080 14 2058738420 13 (1 10846 0 160172066760) 12 (1 6027384 0 9242645403716) 11 (1 1273189500 0 396142696578480) 10 (1 149639194520 0 12417332467452654) 9 (2 -2601 1 10935992495298 0 274068816038694900) 8 (2 13895953 1 512956753613040 0 3930522394593478542) 7 (2 -6334200306 1 15050663748715720 0 29822585665567020720) 6 (2 582813995247 1 249498731117744880 0 25265814014664728452) 5 (3 102 2 -12771700921226 1 1855481229180865218 0 -782798617139667376440) 4 (3 304164 2 57276026369631 1 3208047335393719960 0 1674871156833326914740) 3 (3 14192620 2 -30176599785714 1 527256473998693500 0 -1020930937750503845680) 2 (3 13396068 2 281395910081 1 249471554573688 0 5170904888984217) 1 (4 -1 3 2982 2 -2547081 1 567877726 0 -8730057090) 0 4913)
  (svref *ec-g* 19) 
    '(20 1 19 -152 18 11020 17 -509732 16 16884502 15 -423717176 14 8284685786 13 (1 -950 0 -127757600560) 12 (1 316312 0 1555736163737) 11 (1 -30558479 0 -14818816436876) 10 (1 1393783456 0 107820178372660) 9 (1 -35139121246 0 -570206255492636) 8 (1 516859448264 0 1951802961922337) 7 (2 76 1 -4417019896714 0 -2792663674453360) 6 (2 52003 1 20685669251624 0 -6236737094541574) 5 (2 3153696 1 -46304956732366 0 21913915458273064) 4 (2 32293274 1 37088471763616 0 37717059200889382) 3 (2 52948896 1 -5786452184639 0 14998237694760268) 2 (2 6707323 1 24879503032 0 1299029281420) 1 (3 -1 2 2236 1 -1075910 0 37507528) 0 361)
  (svref *ec-g* 23) 
    '(24 1 23 94392 22 4240527204 21 (1 108774498 0 119018915927208) 20 (1 10878863167112 0 2312685039625868946) 19 (2 6572911756 1 486347994127404012 0 32632069839738383848104) 18 (2 10986406052484447 1 12912207948258050068776 0 341285607804807625093861108) 17 (3 -58067982999 2 1168818895070567424108 1 225761533672199462844703434 0 2650608342993812156260532722296) 16 (3 723384925175280480 2 54064996028492445892247208 1 2700707992214226449258027221920 0 15041873256098475677733339269786847) 15 (4 44708287800 3 351532180266149773299444 2 1369741546220510297322212674752 1 22024041274207574837908883917424784 0 59871567580771894167162192878014210224) 14 (4 23393861142915784156 3 16686360639142949251488869808 2 21189345526516019813010928565628804 1 115567473705785704112446218852139445664 0 153096134937726783810089802839545644023880) 13 (5 -10606694030 4 14312261694369785015540640 3 228345785168536669554919310222196 2 207898875301946165915269006643129499936 1 314440946443098786344332532591071996909092 0 202911975784608590775317222505977467294087440) 12 (5 42290314588327717656 4 2435210970944627261862350101479 3 2405425958755932792085104090262485488 2 1286982775610970561768194170864691199117912 1 -134439166825650315326430805209518271189466512 0 61564851253465959593615718276263687647017525180) 11 (6 1112074380 5 -307060908265283661332418294 4 -42747633761920344268125739754798616 3 14614273940535423350496984726126478560492 2 4792968923665613836570059843063128567750703480 1 -3710921525623387022263005027197134299238571238264 0 142454163118811650492804158939562881681672602304720) 10 (6 11115934012456534713 5 89981958024814090011141030460888 4 1014569368644533301533423863997193691704 3 -47105533575991120886816271918347534460369984 2 9972325584770184312054319867359413619717613009050 1 -9293714699266694747378297541528225920889653363400528 0 615249411715480835951687027322013375942940790358740360) 9 (7 -60482847 6 139173366806129751769291180 5 -3432678143419592037337749621781816440 4 -984266971812219285515785065202499278546752 3 -450753509177042611658093908948016692071013987098 2 10345844681612328522651912877761376117448079653446680 1 -5716887633691582518475654572776473752979146092820123708 0 -631984928849214699061458297499299609335830369461288894096) 8 (7 616461430046303936 6 38551619584004286542015484087816 5 26087924089615130138047325010132412503576 4 9907503231234187116750759201991712487549446970 3 -688457686722329973330256471680929082006983682931776 2 4429183565115505767769062975863353067541838165902549528 1 4873791526026402467748799773484570992138370428828700463136 0 795626819465545167493091389015450776735056932796747136178383) 7 (8 1830248 7 -4264035794392141478576244 6 630121001328828075733421164380988116 5 -38881951594609508657884890140946871337174792 4 7464957325436587544771045573504766568723780905408 3 -159358193685796372569156788422778696142453378929716788 2 -252813386738178858483657311116164576672332367210645082464 1 1682785524465044489622407062136335349295825108582429136677264 0 -345984911769465042150097709335980564214121167596316940501334504) 6 (8 7554053404553400 7 302314900239490930328870187600 6 746894439974422430126087474154503070655 5 8165573020429059895242111781060604496450057144 4 1627738758702528170490551019223088528563508353393656 3 3660308153664609623031256911426615569798786618728337072 2 18386898205616952374190437317817079863901599847348525751236 1 -128189303886826290519627193802510572539276510153127814552006880 0 155939386253359966442979944233172344703951618705879307990663993172) 5 (9 -31050 8 7991967325633213927824 7 -432404144636194767329958305917121 6 46967317270322620819679198266981554748356 5 -121685326762989612603867415903526255008407165240 4 19662128654923892332253899278755467537976225956109064 3 -347519640879866637613413689816907012651931500183010542924 2 1116221908095060418095743037338606697929938711435596866396352 1 -878604895540324400644666500090309335114012214930928337312528646 0 32325509632661596809171593847585556147476287097047388898430286024) 4 (9 15190145704800 8 24177431685223325522969965 7 8531223228090548195370484332020880 6 65176650105429905308519330098932987538504 5 37892443516205245281865920949607162675785344952 4 3090051613897576194413565636438204359264264627480151 3 47784999065193777711474851555463144637136853510846692592 2 152073743253728535282327882573172751424035709062861057805672 1 81570968438358203181799665793929676804312281942905534115294024 0 2233186143564339588183429241496950640166826741183334906313798354) 3 (10 276 9 -278325861938860326 8 103873351179891929519062224 7 -633431596026591461045945860430484 6 324069422334247196603311294052674131100 5 -30909902276033986609609367466367931203637334 4 850054432860748199774599221631049959113998182560 3 -8743136490235619740139859374390713016112583448586156 2 38582561447041128168349076981090710016102981207078211228 1 -74348030654125334007717094363959263055430830741124295575188 0 51423428181843613996683463888259490155213952655349100627907848) 2 (10 968860740 9 84769621956810720 8 54204777814103883675000 7 3446331570553500854957457344 6 46957695364375901363868253981257 5 185970483732950021039673439984697784 4 239538910153344978633829352591877913084 3 99290421535996270030537686584531947745760 2 11467496066733382528854669850967994629598783 1 246653660694738273566980243037563038978572648 0 219457760975451466088018040204147379510047876) 1 (11 -1 10 8196 9 -28368090 8 53962467848 7 -61514962720527 6 43007336651707740 5 -18144237478297458590 4 4374793948754527714200 3 -541459535600500383823479 2 28035152457942175237515676 1 -389561380516779182551042062 0 312190445452533657242901912) 0 148035889)
  (svref *ec-g* 29) 
    '(30 1 29 -1218 28 750375 27 -312177460 26 97844061669 25 (1 -236321 0 -24383203360230) 24 (1 946283688 0 4982726503407419) 23 (1 -918333591588 0 -850163374333900680) 22 (1 468914573398264 0 122299698587208167085) 21 (2 6353784 1 -159048632406057810 0 -14889547174675349431602) 20 (2 181683445194 1 39521617215649214328 0 1531482578360042345865291) 19 (2 -599495756089788 1 -7525314653950183937716 0 -132053255611129182007121100) 18 (2 872166392854025202 1 1125236249523414971501160 0 9398965955840521375481753105) 17 (3 -2679600 2 -635753765158606880840 1 -133035555552296396053296831 0 -536696277312844909527193355910) 16 (3 2460313056888 2 265669846532097539666760 1 12232203740834071213437442832 0 23299231190793504046801208153535) 15 (3 -32087992514334642 2 -68894383123971116583133968 1 -834949492435227719556023516616 0 -681763223892219053764025800415600) 14 (3 59323448811972508848 2 11563182492764030151599198152 1 36972179799740818555754873108784 0 8470066345824882395649837679971315) 13 (4 275326 3 -38085149726123235863988 2 -1275435500089928780930717533680 1 -443087242206261908787262755559996 0 161710237490998966157816070290122890) 12 (4 807685777416 3 12513644190592212185525088 2 91942321261000673722533440225292 1 -63478730671286180160622238706224784 0 -1227146145936734144132486656222766555) 11 (4 31540743785702484 3 -2308795648645507634558522718 2 -4218070197843435969098237035703272 1 4341174590523757741277102791186180344 0 -466990356879076849550536283703690837900) 10 (4 113761557895931097933 3 240937674269923368605787691032 2 116997595394750640955290901668767388 1 -119808651165801153971926767964434376112 0 14051175522038903879253479624997551931519) 9 (5 -10701 4 77539950465963755743056 3 -14189968006241257041223318812728 2 -1797379600307124462440849792392806000 1 891196368503420306064658203451671564369 0 989580041023783362657963930615868144271838) 8 (5 23772237628 4 13153747084806559120161231 3 438835121709779261743834199028408 2 13195719509595301940639141676871951208 1 33582185924543200905582508660855190802120 0 25666866633788908453789789685877357552896385) 7 (5 -391444687085364 4 590082664788695856781687308 3 -5894040785483433228050322786676878 2 -34070364530233296215500865758744128528 1 -329034722236791682594672836478128057641236 0 308861932392128889367800125988879418155575160) 6 (5 286125333478092252 4 6352292091622541943159967299 3 24632566010160750053593192366876512 2 274902994740173921203071431810019994920 1 -1264298445676474340233751379145699268114088 0 1875013858467132799321393242673848632123205151) 5 (6 174 5 -16648001798743234379 4 12417572871968070882485935056 3 -18730974407035972857488425100509428 2 575613446317440589496951838477227787640 1 -1353923326418571032234620965443434740239250 0 192864632773325458848251534365289489908239210) 4 (6 50814873 5 69237803149795442988 4 2503481023034697525017367057 3 1107227846877530247324109207846512 2 29339927420537416362206681864525852538 1 69784895987445289222272641163663201521816 0 6663184774603066906031133518632160995669161) 3 (6 11369273796 5 -11419076943842818644 4 15857569245109083466257684 3 -1318232739963563981380977137442 2 18607952018105725597811472432037572 1 -71417245623968563975406649262314853188 0 76881312068041531479464613856635540877580) 2 (6 7185710277 5 6037858449607532 4  170793646173018426984 3 652351585797377982775512 2 446285544177060259658065026 1 44241368232920303555266561992 0 157301589185173845501486910155) 1 (7 -1 6 5214 5 -10272861 4 9480438286 3 -4108842162480 2 728011816505784 1 -35575638370254161 0 107281337499515022) 0 24389)
  (svref *ec-g* 31) 
    '(32 1 31 124 30 2914 29 -318184 28 -20921125 27 -41302912 26 34311338718 25 (1 -48825 0 958759972116) 24 (1 -18205184 0 -17018660197623) 23 (1 -1204873466 0 -1285520457216824) 22 (1 36378044672 0 -10926207212966012) 21 (1 6603405420108 0 683598271231694680) 20 (1 190752057502872 0 17054367600512622350) 19 (2 46376 1 -5241259110533354 0 -78581176872582117856) 18 (2 655275024 1 -421228867437385712 0 -7621075705566170995528) 17 (2 403669259124 1 -5649198456929790560 0 -62415191494215705685272) 16 (2 83827652482682 1 214568721525413522344 0 1232415383170363633424946) 15 (2 8154338419182664 1 8021364116515873955086 0 20967837815502237313373448) 14 (2 569190870359543025 1 38795726350888490541256 0 -32016091440584052822775048) 13 (3 -4526 2 23912109648959366552 1 -2370859254757514585641034 0 -1473127278102340479588365536) 12 (3 226831216 2 796471245618195513026 1 -42759325636234340951173784 0 12505662256874162119449297710) 11 (3 -495771626193 2 17280292686691366826908 1 -62770478788994799056212514 0 140680272596760752517320822200) 10 (3 188678616639408 2 283578090178813680294631 1 3765948938282554637835888904 0 -1135175840836914174790220720732) 9 (3 -20213788862464738 2 3032138248042651439574028 1 21634488097464030106044000160 0 -994762043582345318793833936984) 8 (3 736107124649718784 2 21222078864602797502757746 1 -32119999741574075423277651632 0 76616227165432356586240070504937) 7 (4 124 3 -9581309583607766072 2 82199747575275732008219192 1 -262459878559265722293623284154 0 -405955219081543779235970201632284) 6 (4 2751994 3 42357259405004886784 2 142595230421228760576616545 1 -299507119349293592254219069128 0 1009270814070817578425306282629998) 5 (4 913025392 3 -53883493233372484498 2 73361278207573894806370024 1 -577547164335834807060247389492 0 211966131441935603877890886299648) 4 (4 20357117417 3 13902342669987449328 2 5914812889053378341225162 1 57200037568797587721494928512 0 14316763912842090579355094401355) 3 (4 32232122032 3 -353159103595099713 2 27383222232374474205924 1 -212511458929091139774418346 0 319542275553772078094659193336) 2 (4 1402297834 3 106579683315376 2 397683291921333264 1 136668531009916550656 0 1383719001913543927474) 1 (5 -1 4 3724 3 -4562846 2 2038690376 1 -248931317385 0 1997313645004) 0 961)
  (svref *ec-g* 37) 
    '(38 1 37 -74 36 2923 35 -80364 34 1708179 33 -29669634 32 435578393 31 -5527234048 30 61576674206 29 -609089044812 28 5393759970426 27 -43022415314760 26 310467691158446 25 (1 -851 0 -2033326533306724) 24 (1 132164 0 12109774297290146) 23 (1 -5202940 0 -65652295038031584) 22 (1 125423044 0 324046151692822851) 21 (1 -2168974373 0 -1455089762721554526) 20 (1 29231986012 0 5934737012925361097) 19 (1 -320070266972 0 -21930159274875768340) 18 (1 2922082721900 0 73158453942129216101) 17 (1 -22594430462194 0 -219285278035079647566) 16 (1 149337243921348 0 586950056678008174767) 15 (1 -847581143086748 0 -1391871588081328894176) 14 (1 4132343374686052 0 2894505306278890999418) 13 (2 74 1 -17250429949760481 0 -5209071338378851654084) 12 (2 63825 1 61189771760924884 0 7970399984056882856582) 11 (2 8050460 1 -182138971323872252 0 -10118560675839787909320) 10 (2 325849639 1 446168350452578004 0 10281484152303245260818) 9 (2 5517967916 1 -873344562301680274 0 -7883727665747688475692) 8 (2 43765830693 1 1304897459560425980 0 4057439288686298695382) 7 (2 168955781020 1 -1382543441496469628 0 -964509517660111192192) 6 (2 312684193809 1 912542762491193356 0 -202886274707963972251) 5 (2 258140132876 1 -297211336623010373 0 127005727208358860046) 4 (2 81172957603 1 31256403287705908 0 27015683552857755663) 3 (2 6950541020 1 -553028681237980 0 1391276123624654484) 2 (2 67749405 1 241622699732 0 12457728941119) 1 (3 -1 2 2234 1 -1072931 0 37185766) 0 37) 
  (svref *ec-g* 41) 
    '(42 1 41 -738 40 -80811 39 194653896 38 #x-5e87957e6 37 (1 -10943556 0 #x-121cc6fb01bc) 36 (1 #x-125899530 0 #xffa7e68f77d2a) 35 (1 #x4c2f251ef68 0 #xfe6709020134008) 34 (1 #x1418650ad6bf50 0 #x-fdd55788981fc2737) 33 (2 #x-2A49F0CE 1 #x-345729fa34025564 0 #x-e712c2675e2553380fa) 32 (2 #x4c4bcd7419b6 1 #x-2e9cfb1f13734e5b80 0 #xa30308a6e7b6c4fe29bf5) 31 (2 #xd353ec2cca8a7c 1 #xdba00fcacdb945efbfc0 0 #xf9db741d7860a0224a05da0) 30 (2 #x-1fb1864ff84b5674e 1 #x-56545092c5c05f4751d980 0 #x-837eafd998460b6df06127968) 29 (3 #xf58098d2 2 #x-ec162ef9dae6d3e8998 1 #x-14dcf16f7de911e5ad0907cd0 0 #x-b29024eab42a7440709e3404bd0) 28 (3 #x14467e1070f568 2 #x74d96ac2daef8a32fe4de 1 #x1819145b82fe542adc38ddec7c0 0 #x545871800b773246be675e4396998) 27 (3 #x-cc01d4eb0716134f0 2 #x391dd572252ee822accc8c54 1 #x6bab868e4d32619abdc90eaf0160 0 #x55282451be6b1aa7a8d786573058220) 26 (3 #x-b91faf6d02a7160a2e18 2 #x-1f79874fed11b9539936fab506 1 #x-1b2b58f9647fb00c752c7dda3ef6c40 0 #x-12bf9242fd57b6660a7a9185f5c61ae7e) 25 (4 #x-8957838b 3 #x-18ffc43199dd2888e32bc8a 2 #x-66f89c9df2d8fd7657a1ed404718 1 #xc05de0d0756482be28bb98e4fb739df0 0 #x-33758ba3fe2b9709827084e15d3b60b6ce4) 24 (4 #x2caa0920f918f21 3 #x5049df7fa51a6a6f09e35e5d0 2 #x572c770319779d777d25ada585201e 1 #x9db25db1c01da238d2f8657c20892b5d80 0 #x5d1c9c0e6e95265556392ae275e1f85f218a) 23 (4 #x-1d9086d5fb7b27a1970 3 #x751d6f1d2190c01ce8df927ef00 2 #x4c439ca60b5be802ad3549121211535c 1 #x-b7d84bba3a19834a1e67d2473dc08b4ad1c0 0 #x19d353fb4ba87f19f333442e841b51b03e864f0) 22 (4 #xc1c78a1a47c9cdada0f598 3 #x-1c377933e8ce0cbccf399523c139b0 2 #x-60b2fd33d070a821fc27861e08378047b6 1 #x1c4424d54ffc85a96143c4a8eb1a86e2ad9f80 0 #x-79052008ca09237667fb0b1bd63295eb7fcc2944) 21 (5 400555404 4 #x1865cd3e7a06545fe3cd0df1b8 3 #x-2d5b2f525c7d6c24f4a93ff37f2abf6e 2 #x-132fe0c457835c2b54a3222a73a795e9abe8 1 #x2eab4d66e35bef7683e4eed8c5fe1a5fe6b1e4c8 0 #x-44e950d0d613cdad9f1eb1cb5380096987e5d362e8) 20 (5 #x3e1d071eb71e704 4 #x1029665ead7c17ba9e177778f8a9c 3 #x1747fd31f1f5456095925bc7216a75df58 2 #x3be78214c88d47ccaa1b400969e8718a013486 1 #x-1a61f569a8d60146df324b5425a130a3a79f1eaa20 0 #x42a6619d1d4693cfdd0fc67f77cd3e357d9273e1d5c) 19 (5 #x544f48e4988739cb9f8e 4 #x53357eef700062f5350d83347b218e0 3 #x33126a9990a0ee96b1b7af284be7778039f0 2 #x-b21e6f661665f24cc69f7de31948c6463d105ac 1 #xb02d65f2324dd149625275a5ec6fa1db02e8562e70 0 #x1b04fef684e0afeba3f409f35e097d173426f2f1daa1f0) 18 (5 #x3c8cb6cdedcf8f591ff81d88 4 #xf820d94dc123984822b357ceb4a1b9351 3 #x-bd6e692b209b4005a27caac1373415718f4a8 2 #x-1081dfeda2ae366b4b71eaf9b480c4c1e1a9bb7c6e 1 #x36223148413d7ca4b9cdbacd499757fe53298759f36e0 0 #x315957808ebb6beeff0258152e79de1cf37f0d7b82fcc5a) 17 (6 -30532782 5 #x552fa84a248fd7e40905d570754 4 #x1c5e007a17e665ccfa4f27162f65c4c73743 3 #x-2040c0e11933f7256f4bba3e63224439ebe54e1a 2 #x6716b7e610edf8568903ce94e9389f94406f529410c 1 #x-d64c107602f5de20385fc0c5a3077c3efe6b50797a7db8 0 #x-110ee1b7185607d4cb5157f1db59d8991d142c8c1f71b14664) 16 (6 #xb17ffb8e11ef2b 5 #x2aaa1c7f3aafa17026c05e901c5b1c 4 #x21b9fdd0419a09b5663b807b4daffe24ce755e 3 #x153d21bedeb45457bde528380c3c10b7b243de660 2 #x1d7c8034095c36ab2d409b2a3f1ab89f92d2a31594582 1 #x-1603714e62ef5b8cf56543627e6547e30d9d2ab5c524f480 0 #xa31142cfecc768613747b3532452aa7950a836528653087e8f2) 15 (6 #x-250f4830ebba4a6cfd75 5 #x92a3e45443535255ee24a1481d4d6f18 4 #x1a264481fe7332bae7bd4e97c364994c47b017d0 3 #x95499ddea92ed24c173b3d16e7b2e01b8294ab55500 2 #x-1043e0900d8bdab4694c7b5a2f6a245815ddc9c09d0446c 1 #x811dd33a39dbb0328e01182292e3c5366335898ad75ab4640 0 #x-302aea1f42598ede29c2906a257a74eb3ed78fe318b12d000cbe0) 14 (6 #x448ac8b3a9494a684bf2e545 5 #xfbdfdd364f8133e2ed120fa65a587a0034 4 #xd52aab75830248e8784ee524699882ea53471b164 3 #xc985ee46f8995116bffb5446872918fb153270e3a360 2 #x-1b46748a0403c8de595f4b3490269e3050f04f17f29a430a 1 #x402d62e5888d32f977eaf8dddf8bd4eea7b7e1422074699c180 0 #x7dc6061a9965e942f68a6fb22d158126d322f17a7d3509669d1158) 13 (7 1177438 6 #x-e50360da422674e2bf805b1f1d2 5 #x141f9e7914cee4e5e394393168a710d55e960 4 #x450b8582317afc077b877ebc7d2bd403dc515288ca0 3 #x-ee467d0af46ea296334adaa64669e9f1e31f45155ae13a 2 #xf1cf2817e5062bf2c0706347d8a8eab5402c1fee150f66598 1 #x-1b94c93ce06263f00da430f6463da17833a6d695e2940823c0b10 0 #x-a6210493b4580e75686968238d94ef802c139dd019683e1e6ec07d0) 12 (7 #x5d46f08574ea8 6 #x9b8ea5ae3356a8e5667672cd9b7707 5 #xd747082cfdf74a57f84be58c22d2bb7ce07cc4 4 #xda6bf4f2f3cb2956b85a6863c0de1bdc45c1bd681a44 3 #x-27cab2429d884c0f7e168d3cabab888cffe65d66406f3a68 2 #x2bfb3a90a546dfede19e0d9f1df61eb497f059307cecd4d963a 1 #x3376d08ac310ba9ebb1067a0dfd334ef5556843e9ac4d62d0251c0 0 #x435496e688da0d37e013295ff646f1a3c2d471db7bdf28a8df8ef0d8) 11 (7 #xcbec4e8cc8ab74b564 6 #x-1cbbde1702ed4a467dfddc92cf0b8294b 5 #x52cf06a113421e8bdcadd716b99f66770f407f34 4 #x1830ce2314084760aa99de008e11aee9afaa2deb5ddc50 3 #x73d848383091370a549bc88efa46ed05a5d2aec8e4d25170 2 #x-e709758c488c06e2227ddce9850f4bcf33c0004919f32c88af64 1 #x635e99e4887d317362128f9383e48b3b7433921b70711fd7cbc960 0 #x124441a74cf1af0f6079befaacaa160f9de71db3fc861d0ca0786c3a0) 10 (7 #xbc24cb08db5f68f9f6d848 6 #x1a41dacc042d0005de87ce1b1b8071ea999 5 #x1366124b13e4ccf58eb8a8257f8a428dbaa3af9824 4 #x159f18591aaab3fe8d5ce4fd4ed28a15350aa14bc1409ce 3 #x305123371f047b6cdc0b2513830bd5ef1a1b0870af431ed618 2 #x17760ef0512b9c3d01396f06a7c8342312dc7d75ff08346560bd8e 1 #x-60d6bed5a8d04df71bb18eea34250db69549c9d8e808700d31d28640 0 #x2932652a2f2c7673527426968239d35a6e936bd2f5540bd4a915fa739d) 9 (8 -23985 7 #xd370cd9a887562c9b3f9f0042 6 #x-7919ee01d55892f7c3202305c735cbfa3c60 5 #x21e0e8b0d1cbae2a788a72b849257d38d68c790ac60 4 #x8c44a9ed9c6aabc1059562224dd61332d329f59e0ab2643 3 #x-1cbfdbea63dc33409c33e61fd4d0fd6af849d4126b21d9d5e8e 2 #x-c9cc41050dded424aa121716156c8d5c4e0753b1a4d47ecc9b7d98 1 #x2c6a750e60088755bd7ef84bb655b5ddfa5a5b354531f2d9dc2d77030 0 #xbae190198630948b06609572e56bbb70b9563c0ee16ebb114fb5580fc6) 8 (8 #x868dd76a28b 7 #x1cb8a4ff5c0fc597d8f70705c050 6 #xa3e0c4dd352f0ed94aafc3974e01f6d4fa711 5 #x170a144b9a56c27b520049cc1adf9f4070d1f73cbfd4 4 #x17266b75aa670f66ce1fd3759c4bfcfcf82b3a4167910609 3 #x-185e9ee18051eb0135d2ccb1d6a84fe739862153df706716b930 2 #x2b52b90e2f1ca25497d92926190b9372adc9f162d64e53e36c6df2a 1 #x8422b19c17d9dc877f2ab11f7f832a59f239bc5c9d885628f01588a80 0 #x4fa482022e42981a0a1acad791656cf45eecc471e99d97e5e228d27c601) 7 (8 #x-29bca502484f3356 7 #x8b6bb02b1ff00c6fd144f77ad85b8 6 #x-3692ebfe29d8a515a8dff48e446b97b37eca1b 5 #x447d06413a5cce8aa4763b9acd21eaabd232435d9c18 4 #x-559393b4698ff8681a8ddd5bab0b3a972201ec9e760b6fe0 3 #x1ff401e078edb602ffc2c5d4ebf772268d9eff6d1cc89b49e900 2 #x10a3dcbaa221181ec2b91bf4b8508b3989645046431cb44a9524e94 1 #x-1425884b793adeff2b52000decd6a17580e4f2d66f0fd62d937783c840 0 #xadab556c065a1f732d749f666fafe2ab0ea13b8cf0e2fcbdbd68e5f1a88) 6 (8 #x26a156978ab9056a89d 7 #x57f954c5ea3fe5067e4406b8b43ed0 6 #x3454d9ab25638a4eaeda96b6c2c473329b875f 5 #x214015f20fac5eb4157638117b69eea06edf38c1843c 4 #x61212d22aaf3376f179b93f2c1114a32b7563f305a38803c 3 #x3f727b3ff7ec22e83fe69c012311cd9bc31d44ae5f3e0f83150 2 #x3c57737e489f5e722a8fbbc5b47c6d29dac2e80077a8aa4347578e 1 #x-712d0381d8e5ec1d4a865b71ed0a1e0ca2d89c1695e48fd16d499af80 0 #x21c766787397878bc24ad9b5ce99c1ae4d72bb1d0391efcd7f2053963b3a) 5 (9 246 8 #x-1387fd7baccd70ea1a332 7 #x56ccb20e7b2e70d660bdd439228c62 6 #x-56277400dc00f3963552566bf725d36825a92 5 #x15ade48cd637c37309a99dea4a73075d3612479b914 4 #x-4808aa3c3ae3eed8df5db76333d14fb1c207c0952aaa9c8 3 #x17417ef7d5160199e3dff3c7bb51be35a5b8b6e0b65fd06a3d6 2 #x-141e721c3375de09e9eca8b219aa5a99b7b66383abbfa7c908ea18 1 #x436063ac70bfb3696ae32a9247327bfeafe5006fb36a08008f58ff5c 0 #x-b05496ccb2c96219533b3c7fba1e20170c6956042edb15841eb602bbc) 4 (9 #xe846211c 8 #x4b8de0aa019143e93b415 7 #x488a1eb224aa93de9fb2149f00908 6 #x65879aef7435f648f0b6bc95fe049237cbd 5 #x6ddc96d46b47091c5d8c2f22f5809c16a5079d48 4 #xd277fda7d67dbd8b4ff6e89ca0d1eb7b95ccac49ac98 3 #x429ef33fe583eb986ffd5a6766b4e433f7991bd6059952a8 2 #x3fdee157e4c9824f1a932772c1674f2d24d35227458f7cdf1e2 1 #x9ce8ec164b2b24877081c337ee7866c99a1d5393da4ab66f68dd0 0 #x132c4594c1044ef41fabf196e565f995ec2e39851ff227a53d0cd0a) 3 (9 #x2b00fa2105c 8 #x-512ba2c788d7dca52736 7 #xc440f0e2c412b7469d0fd509e4 6 #x-113586d8ee8e6834d8c8f25e509e5e05 5 #x2edff01c00f2f3b89a7834cf094f7cd74c0e 4 #x-1cef8f42488b3840ca48abc6cf9a198b7e22feb0 3 #x5c978675d3dbf80bf214a419d859d2fb8e98f7f9c90 2 #x-74b8076dffc8b0d81552b44300487efb863569f5a23f44 1 #x3d1160e4c9a692492f59b84c9845c6d43fa9e98d47048ab68 0 #x-b1e39241fbe6a33bdd4673ae5c99f7a2f95a61904028d2b67b8) 2 (9 #x1208d30b2bc 8 #x109ad2f3005d0a3a3 7 #x431a8728c2a8da21c54e8 6 #x21086e8cae653e075d8e777c3 5 #x3aac560bbcf1dd07a8a0388729e4 4 #x1d91ac5b031ba12a25a6a8f268cdfa9 3 #x46b6d0a89e62d759d6872661dfa7bb1a8 2 #x2cbec2fc2b7343319fcadc74799d9780e66 1 #x519a2ff0b6af45765ccd62f5e57298b02450 0 #x607f1424e0ee3f22be23c2666248169843bd) 1 (10 -1 9 7446 8 -22980465 7 #x8da78b2fe 6 #x-2126c0725bae 5 #x488e2688bcb64c 4 #x-592ceb3465f8338b 3 #x37d2f9c75c461bad32 2 #x-e9d9adb86a35af7518e 1 #x1088431eed14ce26264fc 0 #x-1172c0dac8138c7dcf4a2) 0 68921) 
  (svref *ec-g* 43) 
    '(44 1 43 -344 42 70348 41 -10457084 40 #x4A5ECC16 39 #x-1d23532198 38 #x9e555e0a506 37 (1 -25542 0 #x-2f8157ab1e720) 36 (1 -5748584 0 #xcc47b783777729) 35 (1 #x-1037668d9 0 #x-31a67ee8a6bc8db4) 34 (1 #x1b01b87aca0 0 #xafdd9dbfed25044fc) 33 (1 #x-151a9453ae806 0 #x-23a414fe2a19b860df4) 32 (1 #xb38fcfa2127f90 0 #x6a2f906f592e535a088f) 31 (2 5233788 1 #x-49b7cc5b008bb96e 0 #x-123602bc73f08b9e2ea110) 30 (2 #xfd5f5fb53 1 #x18d97fce4099ae6368 0 #x2e177346cc135021ef6d14e) 29 (2 #x-5a5e6a584bd8 1 #x-72023bf070d64ec8702 0 #x-6ba767cd7f2858d51e389790) 28 (2 #x87b5d27ec69ba6 1 #x1c6ef466f148c9c97a290 0 #xe7f7beae13bec748e31b575ba) 27 (2 #x-5618ba71b501fba8 1 #x-641c2288233e32f59f6b71 0 #x-1cc94a3df5ac7d906c594f5e62c) 26 (2 #x29922185e75a92946a 1 #x139edba40b95c262de1d3c50 0 #x348fbc2941844b1dbe81dfe73a80) 25 (3 -2432725 2 #x-e1ba745b3e2bcafe3cc 1 #x-371d400a73856e14910378d22 0 #x-57fdf4e2b67b2ee0f44d551f80c98) 24 (3 #x18229830400 2 #x436339d4d571fc9c956cc 1 #x8b14314328a9101e1639c47758 0 #x86802974db7c57ca09b202b7ec57f7) 23 (3 #x-1ec09426956b3a 2 #x-10c1737f2d35eabad23e81c 1 #x-13b734fc6a5c624839f7a2c41aae 0 #x-baaf6a81ba844e54014b806d3559f88) 22 (3 #x22af5042512cc2a0 2 #x3bbb632ac117a95d7b982a4a 1 #x281f974e5c39f9af9f37832c28490 0 #xe99421f2b111bc4d515bdff561ed1488) 21 (3 #x1d32089f4a7c1e960e 2 #x-b4725b7bffb4b728a9bfd14f8 1 #x-48fdd87909b2c34b432a5cc5d3b950 0 #x-104e3907a83663c7e5f887e09dece54868) 20 (3 #x234f6469d39f20f1b4f0 2 #x1e789dd36f6ac48c6aa395c259e 1 #x75f2fa96045a078aacb87d581247f68 0 #x100b0a82aafbf4ed49989fc1f79ab4ddf4f) 19 (4 261096 3 #x-4b963d22d485b625a9e8a 2 #x-47a578f3f696e4b246850013bad8 1 #x-a7d00fcfc97b686bfa1577894d6f08d4 0 #x-da51ffea56921038994ffdd4bdccf563878) 18 (4 #xb1a32234a0 3 #x-7b91d05afd4d894caa6aac0 2 #x98557c7f52a7101a55f7751f45341 1 #xcf843ea8ed23c1fd5bd92914f9cfcabc8 0 #x9c010ed520390e1a7870dfdc2e664a20f680) 17 (4 #x698e798de67bd4 3 #x-1182d3a8cc455265830ce44f5 2 #x-11877853b9f99509514296bfdd92644 1 #x-db4176126db43c7902105bff9c5ba17bd0 0 #x-5945e51964e2e3d26d6989211f414ed56c13c) 16 (4 #x6469209b1a946ceca 3 #x4440d54cb31d3a216d1c422dd0 2 #x1c673e959c99a1af930c298f32f2a8a0 1 #xc0ea9c56fe42de4b5604fc4b7dfd456a7d0 0 #x251d94c45db58c9b37ecbc544bcf6c23690aea) 15 (4 #x168389eabb8ad55c79b0 3 #xb48efeb282d1ec4e22925ea493c 2 #x-26b6a729985b01f4bf7243f4bba639234 1 #x-884db5adf8d5ad14c0617148bb376af4758e 0 #x-83a7292e0dcad8963db08c75fffa4a6dfe6850) 14 (4 #x1cc0964fd8a8aaf89a51e6 3 #x-2bedca235005a2538f62a5386da0 2 #x2cb4a34a1dcd3fa469c81a8a7097fab5a9 1 #x4844d9497daa039b532b626bce961bf87d878 0 #x-13b9871bf3bbc6a0504d93c2c2887f70db636f2) 13 (5 -10406 4 #x10167b637b228ee4ae6f6e24 3 #x-166e732e756c470074296a8e2ef1d8 2 #x-290392ffaad5bb4af0d74d6e7a1edc8ffb8 1 #x-18f43757534bbfe745e925b23a2c3e14b9e812 0 #x1614d2f61f9a60cc58a855660f26b9fba1a222b0) 12 (5 #x6bf51e410 4 #x46335c9a16d94a71d90834333 3 #x-562a47795c9c65a74f40df7eac20a0 2 #x1d0b7216ecccc523d22e9f7094c6a7ac717e 1 #x2a4436bbb20984f28b9a36c605f6c56dc19510 0 #x-1b8f02fb5ae5ad8cb04f59d51bf22c17a6fc0f79) 11 (5 #x-2fa4412bfe225 4 #x9c52505093d865cccdae65d074 3 #x2ca0b3621359a8fae765cd7b8e2619c 2 #x-e21ff0b3c8d264ab2355620027f08553d798 1 #x1d23dffc069bdbda028a4514e80d3f7af2a396f 0 #x-2795ae130af824fb1c286b75b7cfa19c31406f044) 10 (5 #x19ad3f288621f100 4 #xb22bebdb2589dc492754e785d3a 3 #x4b3cb501f7f855f14e48d27871265b90 2 #x4456ff3f09e9f234ba3afc087fd18ee25c6fa 1 #x-9ae5a0e103eb3f7473fe5c8826cae9cfbda4e30 0 #x30ec41ecfd7028fed63e18b8abf5a4df240d3543c) 9 (5 #x-23ff6912318373b49c 4 #x64278e12991c67236e7f1d110324 3 #x-1d0e048b1dde55033ce7f076e3754a145 2 #x-aed9ce99baea4485c61b7020f82e99d137a4c 1 #xa69535e4cbce47fe7cfbf6320b20f63787793ee 0 #x46b2b7d2d30de412e3aaf2e192149bb8bd331d85dc) 8 (5 #xb0f68321c7bb9efb770 4 #x198e7515d20f79f1e8710ef8e7beb 3 #xd57d25eab4c50a5feef9feb4a0b264ac0 2 #xc570b4f5790af7b661271270239943499fe4c 1 #x2e0183b12db64fe4b40a7072b952993fadce8e08 0 #xf54c89df0b04e596c7f49e860147da9040cf80d501) 7 (6 172 5 #x-d2b799fe35e37094db9b 4 #x28f0a5e5b5f56b3e7300afd7068b4 3 #x-2532b17aca346c3e1f3dbe5e3cd1b3263a 2 #x-43bfd5fc24f1932702ae88243ff854ad5da9c 1 #x-44be6af6138376202b44a3d0131be40df3d7400e 0 #x175bdb224b28028822a253bb20df51782432cc597e0) 6 (6 84881914 5 #x3a7fa2098d6267f2bd0b0 4 #x14446b4d7527bf233d2987dcb0246 3 #x15317dc3f5d09dbba88208fff45ef5a430 2 #x1da6257ca258fade6b4436d34d221505cdfba 1 #x-29c014354078119be337f2bac145740090f988b0 0 #xe7b3d12226cadf9c34ba7fbb70c8d57b8a0d6b2686) 5 (6 #x1a6bcc4b20 5 #x-3291f11dae61740bc61fc 4 #x21cae97f26da205df7a14ee569f0 3 #x-19e3d2faa12b3297bca43fa5e83491632 2 #x8fbe4209b39086e8162072863e95670cc9b8 1 #x-4a3a0382b75b82dfa75abb7be87867b569d9e96 0 #x2558d762ae55eab5f43363bc1f445fe0c6f8dbe48) 4 (6 #x4348fcf659e 5 #x5b1d3e7c469832429f80 4 #x64eb079490d06425a40b84167a 3 #x202d56cca0f080956e38998eda47a20 2 #xb2c1754e33daf977a0dc14cf65ff05aac6 1 #x5e2276ae625a37bb93b2fccca123d12e38ba0 0 #x20573392e92b1a9ad73b20eec1be90e3633f586) 3 (6 #x6296d244da0 5 #x-98cb90877018bd9775 4 #xa3f4ff804951825994e9064 3 #x-bde98da7403e726c3273c3b3a0a 2 #x273a14a37beec3f45b60d5730000f88 1 #x-23fff370aeefaa5f75e5525586cb03ed19 0 #x95a2e05be9cd462156c0f65823a983a97894) 2 (6 #x1b0335238a 5 #x12d3e4ae84016d0 4 #x7cfc83a66d76a2c0a0 3 #x7267e6f4bc48bfedd1000 2 #x12e79a33f6e67cbc52d44b1b 1 #x745718d6b5518faa5e2d249b8 0 #x19bdc98c6d9991f38cef7fe28c) 1 (7 -1 6 5212 5 -10263926 4 #x2343a45c8 3 #x-3ba66030ec5 2 #x293bcd793822c 1 #x-7db269416fddb6 0 #x179df4053052408) 0 1849) 
  (svref *ec-g* 47) 
    nil
  (svref *ec-g* 53) 
    nil
  (svref *ec-g* 59) 
    nil
  (svref *ec-g* 61) 
    '(62 1 61 -122 60 7015 59 -250100 58 6086641 57 #x-62C2CD6 56 #x454521B7 55 #x-151a91e28 54 #x-118730d4ad 53 #x1ea7aa0989a 52 #x-16c720c7b92b 51 #x87d98832fb1c 50 #x142459e7caba7 49 (1 -35075 0 #x-4193af5c89e8e2) 48 (1 2531500 0 #x2ec51ba2d5f2d09) 47 (1 61685152 0 #x-10a3557a26558120) 46 (1 #x-36f8ea7e4 0 #x-a00696864d8996c) 45 (1 #xc64cd78d6d 0 #x4c183c7a5c91dc4d8) 44 (1 #x-1984516946fc 0 #x-3226e289708c93b36c) 43 (1 #x213d601069ca4 0 #x10545a138d68a9b45e0) 42 (1 #x-188677c5e5f68c 0 #x-33cfd5a26db04a2bc) 41 (1 #x-416335ab92669 0 #x-32b464ae1158342d1368) 40 (1 #x1a016a32e26f6f10 0 #x1e5a13d3a8c911b7a9054) 39 (1 #x-24044ce822f49272c 0 #x-8f345023f936bd07f14c0) 38 (1 #x1b356678331ebc6940 0 #x35bca6b3f85526daf3c72) 37 (2 41846 1 #x-a745dda3d37a4266e4 0 #x1326a6807c69d25e2fdb4cc) 36 (2 387719355 1 #x-1d9595ef937f3b410f8 0 #x-a5e3f42c9dcca52857790f2) 35 (2 #x-18bda3c04 1 #x589db744117a564ac4ec 0 #x2c05f233aa74ad30b69104f8) 34 (2 #x2f1fec6ab7d 1 #x-3d8de9bf9b7530f7cf698 0 #x-1c02d5fe58502c050734d552) 33 (2 #x-21f2dc1612a68 1 #x14a7c98b2ee68d2ee8f2e5 0 #x-3e8d290de57a99a26819ff784) 32 (2 #xbf0cbb17487aa7 1 #xef33f80e35ebaf4476d8c 0 #x1dff464f864dd5d5046810929a) 31 (2 #x-2b30f9879d3955e0 1 #x-50e3a25b84925be9fad7924 0 #x-6c9f6ff3c651a204ec836bbcf0) 30 (2 #x6f6ac0597cc91747b 1 #x2de5ad903259fa34d11af8dc 0 #x32fbd1ba83711dbcaf2106e3e2) 29 (2 #x-d839e4b0887329e62a 1 #x-c98750a4197ee719cbb19819 0 #x6dafc050f3233a8e4f7424d009c) 28 (2 #x1466ae2f67788797b166 1 #x14fefa1e52ffcc529fb0b15c 0 #x-28374586b01bd7ac3b414b6a9f6a) 27 (2 #x-18840e05da54dd33b8fdc 1 #x18a55732e39d14d75474a2d120 0 #x595889d7706fa75e789a0d7c47f8) 26 (2 #x17d85d6611fd30b2b1fbf2 1 #x-bcbac552e0a4bc59bb1aeafb84 0 #xce93573a09bc05b59e1e36966b86) 25 (3 -4331 2 #x-13006f68894e1828778279e 1 #x2f43242926fb388db678a552cae 0 #x-8fcf0edfa9baa5412db48aef35154) 24 (3 224545880 2 #xc83b4e2f64b554f71d48a99 1 #x-4d92671fe481e6de99241553554 0 #x1c7185643cf19f0fb071d4465900aa) 23 (3 #x-7c6465d6ac 2 #x-6da3bd588720b44b9b7474f0 1 #x-133b76d32a0e5ec1453b46c8df60 0 #x-253e096889a39a14f37e06afb8240) 22 (3 #xe94ab60ad7a0 2 #x3217b9c6dc90e01b5bd30d075 1 #xad17aed31ddfd200f28b884d0a2c 0 #x-1498e7179f5ba63f18e5745ba11739c) 21 (3 #x-9f304d00bfc42e 2 #x-131fd5dfcfafc550e0cc495556 1 #x-2971674bc5c692658433832a715c9 0 #x4c3aaa7c689984fea757c0102c6c0d8) 20 (3 #x34b1e72edaf42748 2 #x619037c3f3b570f70be5b8c45c 1 #x5b4bf9a4b6eb45a8772845ddacf4c 0 #x-3098a24518edfeb35ba58cf348e064c) 19 (3 #x-9e9ee2846630e1986 2 #x-19e9ed33b4385af6116ecababa0 1 #x-40fbc42c4ed1987e4bb26091dca44 0 #x-22bacc4eec7181e85cf59b6b45fa9720) 18 (3 #x12a258d1eacf1b49018 2 #x5b51766a6744aa72109bc01a2cc 1 #x-1585393b3427b54f245bf7109930a4 0 #x805b5d112961840923c3e71d25018fa4) 17 (3 #x-172f6240cbc282fac0b9 2 #x-10903d775713236e65fe12adb126 1 #x64b4c9c41c6aeaf36fa2a90dd74745 0 #x-619e4352cb34f14e46018eb78355f268) 16 (3 #x13cd80090cae98d260e00 2 #x273779a9aad51f54ebdd4b960591 1 #x-f18112efec7933f137a1a5b6a2bb78 0 #x-2341931528fe232fa05f3542be122afbc) 15 (3 #x-bdc7f8f277a49de261b5e 2 #x-4ad241151f617781a023ff005070 1 #x1838f355ad689bb61404b7535afbc0c 0 #x7237a2355862feca8be2e69a7cddcb160) 14 (3 #x508449cb835f774d2178a8 2 #x71341ed57b999fd224949405787d 1 #x-1ea505a412898f3781158fd7b537498 0 #x-56ad24a04b88e59f1a7855b83b19a8343) 13 (4 122 3 #x-1833eb20151acdbca490bfc 2 #x-850cf4c7489d893b3f9fe7049f4e 1 #x335df337140f6fb65b50b34005863dc 0 #x-fe0303994c6d4384e618a3b0eb04618d2) 12 (4 3894728 3 #x51ba0dbdcba9f7f307b1448 2 #x7644791bfba177e9b764b4df9caa 1 #x-8187cfa7dbbef4c34ba84c2d318ecc0 0 #x334c1ee7508b21f811028a008508e2e81b) 11 (4 #xe8db24ec 3 #x-be0e3685b2419f539c740ee 2 #x-4cc0ac556545f0efd3d2a3c69b5c 1 #xfde1a4bf75a64856771469b6dd86674 0 #x-4bc7526d99c7380c95e8150f9fcf9edfa4) 10 (4 #x99512db0dd 3 #x126e2a4abd57378ce8cba180 2 #x22cf8dc46dd07d9ae7e9995e86de 1 #x-10b48c5705cb1a455319616b47f6d730 0 #x49cde3985383f086771ea8446257229c69) 9 (4 #x1b84536344dc 3 #x-122ef85b4eab32e46e27a8a9 2 #x-abff07a739d4481895bea37999a 1 #x55dad25475144d79808ec8833010b57 0 #x-313cc26f6e348641b53f73ce2acaa9da56) 8 (4 #x1a561f077c497 3 #xa9f1bc42d2158b8188bf278 2 #x1a81559845f03a72ee0ff18ff3f 1 #x2a3317ad6ae8b6deba72d645971c904 0 #x178975a08c41b63aa23d3b642fd20c7ee7) 7 (4 #x910e58a48692c 3 #x-34d75961e350552a30f78b6 2 #x82037757c541ffd82fcd6fbe7a0 1 #x-e39bedbc6b1813ef3bca1eff27f0fc 0 #x-717dd66471f3772628fb259c6f9b7dda8) 6 (4 #x11d8444fc45fa3 3 #x770f6e12dcf791b4259e28 2 #x34d8aca8de878b6d95ac94221e3 1 #x-15cbd8f7ca9037bd89dbca01e12b4c 0 #x14a2bfd34ec14e3c94e0be9e5677fe363) 5 (4 #xb7e3510482f7c 3 #x-5e613c78c5a1cbc53a56e 2 #x2fb6c538611f81ced2facaec58 1 #x-49f8e4021e651d21dfc81fedb5663 0 #x5b8ddb3f92e9997be5189ee5de79b9a) 4 (4 #x1f828e17d3cd9 3 #x115f0ce3bfa4a4255ca0 2 #x4a9d3242c046db45fe933ec9 1 #x954877be0cbb048d59145b1ae8c 0 #x8209fbb8e29312dbbf1ee56f2ddfd) 3 (4 #xeadd1a4fe2c 3 #x-58d3e0823d955128c 2 #x5cdaec1b86da03f62a87c 1 #x-a8c97a3cb9a53b061a62efe0 0 #x3cf7a20969e15a4f574b10e194c) 2 (4 #x5bb3140a8 3 #x61f9f660f4af8 2 #x570ddca80f7dd397 1 #x73788e2bc25c9e8bfc 0 #x4898ffa8590f7a83623) 1 (5 -1 4 3722 3 -4556891 2 #x793685C6 1 #x-39b257b0e3 0 #x1cd0c78a8b6) 0 61) 
  (svref *ec-g* 67) 
    nil
  (svref *ec-g* 71) 
    nil
  (svref *ec-g* 73) 
    '(74 1 73 146 72 11023 71 574656 70 23258019 69 778221318 68 #x535d0273f 67 #x84223b0040 66 #xbc252c539f4 65 #xf3f739acd4fc 64 #x123191575a6720 63 #x1423a43cd0a6830 62 #x14d0feac37288cc7 61 (1 77234 0 #x14329535d2313cfd6) 60 (1 31717624 0 #x1279dd3911bcdfef7f) 59 (1 #xccd4b010 0 #xffde1a688cf8216240) 58 (1 #x3068033e50 0 #xd22d53db5f07bec29ec) 57 (1 #x7f1cdf929c6 0 #xa442fd57113841faada4) 56 (1 #x101336d7a6578 0 #x7a6741174bceff4d1d1e0) 55 (1 #x1a9529ba8d45a4 0 #x571fb35fe3b137a6a78af0) 54 (1 #x253fc8988183bf0 0 #x3b52c1b74d5ff5f3ebfd07f) 53 (1 #x2d427bb7a88d04bc 0 #x26b0e1244f40d01d00c3fd16) 52 (1 #x306062dfedf31b050 0 #x18323e8293bc00f78ebcd1873) 51 (1 #x2dd5a995c94068d51c 0 #xe8591ddba4aecadb01027a9d0) 50 (1 #x268650d01b43d7f8248 0 #x85eb71c792e5817b8626d36b69) 49 (2 -504357 1 #x1c7a6b712bf870bda60c 0 #x4a2b272a1a5f1137fa5bb1b4d86) 48 (2 #x11e493367 1 #x120476106d0448e945778 0 #x277c4ff99ceb5001ce890503dadf) 47 (2 #x16977f935d8 1 #x9003ac6993314a27e7fd8 0 #x143659eda9c7f2f0b42db012b1770) 46 (2 #x106e68afc8293 1 #x26ec70f3bc70fbd4559a48 0 #x9f3217267347f95f6cca68b0f337a) 45 (2 #x548926e30b4eef 1 #x-1888f539163596c4a9672ca 0 #x4b5c99289ac617e4bddb76bd6e3234) 44 (2 #x1081c1e694bf579a 1 #x-3553166adff6200b8b0053d0 0 #x224de550d6803d6298e9781a93e8542) 43 (2 #x24838334cc37a9e1e 1 #x-3a79680edb36262937d5f982c 0 #xf02f5ab4edd0fb3a4d2275444af04d0) 42 (2 #x3ee0c0d3a184bfda4c 1 #x-32c27610811d25f1ded8bcd4a0 0 #x6501e47b8cf6b2f638c86b39326c3f94) 41 (2 #x59ee372643cdda8c482 1 #x-2653de4318bf0d1636fdb0616b6 0 #x28cd718dfaf4b1dd2d816d0eb0e37a110) 40 (2 #x6f350b2f1b80685a256e 1 #x-1a1b7f95ac82de2c8a4013a09018 0 #xfd2b0b047cc413ceb40165223da1318fc) 39 (2 #x79b3808eab6bccdcfa706 1 #x-10556ecb986a4bdc77a0e6e7c8100 0 #x5e2e66c8174f0674706f0eb031aaf0cb90) 38 (2 #x77afe32e1409190276a10c 1 #x-97b354817aa95f2d8cc4240ad09c8 0 #x2194d30ff4f8ff3f0a2822ea2db5d8a2e6a) 37 (3 117238 2 #x6b036a304f547139585c121 1 #x-52335f1ab3362c5d7a7324d044e1de 0 #xb770508a470e69bdc3fb75ea65e68a0c0a4) 36 (3 #x5c58bfd9c 2 #x57ca8f0bb99eec9312ee8457 1 #x-29bc2eec9de44e0862143f67c9a0bf0 0 #x3be552026142d685a2fe16a633d30470c1fa) 35 (3 #x510febd04390 2 #x4292bd195a0c25dcc3d66c01c 1 #x-13e64410eb746eedf00b23dc05ba5fc4 0 #x12add15bd2bf4be962517a299a60239224290) 34 (3 #x51dea0715294b4 2 #x2eec3c8b33baac2368f85f4067 1 #x-8ebc18ed406912993a8b0584f39e1390 0 #x58e22b6d3e5d3d5adbaa1fc2c8100fe0ad91c) 33 (3 #xa7c75e6d3905e14 2 #x1ed8e475bcd0212b4f34a9e7978 1 #x-3c2f2c55f95ee08c3d8a99c8ff9fa1c22 0 #x192a79998ef1b5d40a8f64be8db3af3c370e10) 32 (3 #x20dc4cbc3f24b136c 2 #x12f45ec7da42cef3b289bee98831 1 #x-17dc53c73d0a3e05034564c5565214cc78 0 #x6c5302052ebd40555f4a82c5b00a20070b3234) 31 (3 #x-1575bf33fa51e20ad8 2 #xae7479fbfa649ed8ec0fdbccc914 1 #x-8e2e838b3b654ebc8155a877dd960ce7b0 0 #x1ba1256b081d63fb8e9d7f94c37034e868cbdd0) 30 (3 #x1106557f9b0d8158e74 2 #x5e11a8dbcd1cea6d75c900f2dffa1 1 #x-31aad63975c50a7ee9dc5964b78d39a8b38 0 #x6aa48be44548c6124c3ba97b04b6aef789962f2) 29 (3 #xde04939447c0fffad224 2 #x2f96cc0ef6392fe39c79ebe5a36fd3 1 #x-103d53b5a17f12c089467d194d13b52fc0c2 0 #x1843b9aaa4e90b2b06159fe010a8b2bbb7feaf34) 28 (3 #x-3345676dd0712608e76f4 2 #x16978d78ba9511407afbc889662b1a8 1 #x-4f4e0211341aee92c30874c8016a6c2f0710 0 #x530ffaa09cf0173b157a2fa5312262ad0e1a9a0a) 27 (3 #x-1163b8db247125be3adeee0 2 #xa0ea5f6f11891013e37802e4cfa894a 1 #x-1684c914bada09435dae8a86564266dac8244 0 #x10a73ddbb1bd568c2be0c0e88f1530e82c2ba6a70) 26 (3 #x763824a2635deb019bb3e84 2 #x43114fdf8e92b625b7f6d02dea37cb26 1 #x-5eca6c7e3a8fe92e0809562d3f7ddb5147770 0 #x31de85c3e1a024198e68a813a74bda9d3f1fa1767) 25 (4 -6935 3 #xee52ad6cf2359714e7900cca 2 #x1a1d2e5461993bc75b6fc382540611c44 1 #x-16fe1696b17d870dadc4b8c4ace74b8e7769fe 0 #x8acec79d575b19ee6ac1f61bd909ac9919bdfffc6) 24 (4 #xbc555074 3 #x-2bd2429d4fac6062b8498f480 2 #x9791d98fb89d48acc813fb05dea957196 1 #x-51ca1e889d65600f26718f3e2d1e7526681e88 0 #x1656291783f91067a57ead695aa32dcea9d78a1031) 23 (4 #x-20098841b39a 3 #x-5e50a1250402dce32feabb53b0 2 #x330c461698f5b8df35138cbc16af07dfaa 1 #x-108d47b8963b6ca64077162efee678f0c5ec400 0 #x34e761dd87875fe666ffae5c802d19752adff4c050) 22 (4 #xc6abecb6128f81 3 #xa335b005871cf2b035a4905a20 2 #xfe3c623d720aba9f94ff2e8f71a101b0a8 1 #x-3063a6f3365718d68c3bdf720a8db64b1fd99d8 0 #x7289fd1b1519958ede00c93088770e4b50f85e85bb) 21 (4 #x-160f48dd0bc3199be 3 #x174f32d146af9e47a731b097c588 2 #x48b481cb54f1031074dfcf087c788a8eb33 1 #x-7e895b62bd2415f413f6bd9998b5198811a8316 0 #xe101d9816634842ff08936ee696656abb4d39a9896) 20 (4 #xfe062979e3d5334eff 3 #x137c27417931334e50b809b8540 2 #x12f4d41322416fde2e85e967205ae4c9e649 1 #x-124e366a4063f2b112a0118fce868392b7def3a0 0 #x18d881a7d04d2474edad40fbf85e9ea761c554e1dd7) 19 (4 #x-5a0a0daa2846cf904e0e 3 #x-2a549f27aa728d7857dc18c6a0110 2 #x4766b51619ecadaaf03f6054f8aba98cd794 1 #x-251982ca26d44238702772e395fbe3c53b5f6dac 0 #x270d82ab3245fe319c0c7606de38c3e4d765d5a2270) 18 (4 #x11b19e5ffb04d383efbef3 3 #x420674006b5b74fd592f1a6afc40 2 #xefd8a083217247b42ae9c112c30adf032829 1 #x-413ce51b7a95f7fa432fe12c9353a87191a53650 0 #x35defc9716a80b5eaefe8400e67416ecc65f61d6fe0) 17 (4 #x-213bf2f19d197b875dfc36e 3 #x340e9223ed322c6bbc70620864a708 2 #x2c3372228768f3540ca054566a149cc29ed78 1 #x-6354d424aabe903528bbc9964deb66cb433862aa 0 #x40141bc2c73ce86f8d72ef5cf671f4fd31096769924) 16 (4 #x2718e3f8d12ea1eb6f4e6523 3 #x2362992e141d54fda1edb65df3d420 2 #x701567f9417794df6a6ed1e1af52f8376795f 1 #x-85002b3af0a6cb66c8089ae0692edd92b2c3e2f8 0 #x40376e6fd3a534603010c21c878508643ef4d212d4c) 15 (4 #x-1da48d411271ca6aab1ed31aa 3 #x-ea559c2cc2f56825bd2a75f05b81b0 2 #xee0a214548ef93e464a13f74e1a7c62e2671c 1 #x-a36a69fe8fd6cb726d674d1b79cda4fd1b4ce728 0 #x3499e04f638231277cc8e1e343d4eefc759e58c9ec0) 14 (4 #xeb208b57979998ad2e863de72 3 #x2ca9afe2558686f97fa594695bd6a80 2 #x1994dc7a2b921ed91d1c22fc455ad7b07dca7f 1 #x-c130378b7e7315a773ff30efcdbaeda6d72bb1c8 0 #x2202594f1caae4a774b0dd3faabca438f47f5fe2ca7) 13 (5 146 4 #x-4c6a1e62d1bcdd2310566cb76e 3 #xd6c58095abebe8df387deb41c61c6ea 2 #x221f0936c38b20efd03f8a57d78464037b4901 1 #x-d7c6e6f5c5bea8aa95f216cce4aa058110672534 0 #x112774e216330eeed05cf9bae43ef194ef61b94e0d6) 12 (5 24301700 4 #x1023c81da829a7166e2889eed02 3 #x19ab9ed33fb028392b6468d62a3866e4 2 #x2174957871cc6dbcb99428ca96e27e5d4b332c 1 #x-cc09d672078a9efef6ace0a56151d6cca9d88ff8 0 #x7b0c06d3b3789eddf4885287ac045039aeabc6141f) 11 (5 #xde35542cc 4 #x-22b991aadbb88a3ef221766d78a 3 #x4bc405c88cccd029f366edb2c3f2ff20 2 #x1687d4d91e0766210aeaa03eabf8c371e35066 1 #x-8c4333d6e846b17f657d72a51f46e1033f7849e4 0 #x40ad0780d4c19e7090fea7064d1631429bcf47f5b0) 10 (5 #x10c07db0972c 4 #x2df15c997aa6cf1bdb9e8bc3a8b 3 #xa69b368b846986e60f094685d45ceeec 2 #x98fc359c3f2452e9773f8da77ea0fd2eeb9be 1 #x-37ab03f884d3d27ee3cbf9b83a8f87f31ea0e130 0 #x1ad9d27e761ac49b02c18234cf52f153c1f3f16420) 9 (5 #x490efe3320a6c 4 #x-237446a6a60f678dabba5b6f76e 3 #xe6e415b919fcdc704cbe3ca54df07ee4 2 #x246472de3437d9d2299c131cfe9b3392cbf82 1 #x-235efdf04ac0eb8665b9fc14f0f395b7a634a04 0 #x-5c845b94b6939baec575d8b27f5326f925797484) 8 (5 #x5ba457d2a53ae4 4 #xec2be6d0d9586e0d7110dd138b 3 #xa29a5c20c6e9c5f021dbdfe55536cad4 2 #x4068e8940548186f9b4cd7f432feebb2386c 1 #x685b45a6de7f5ef3d2f8956d5dced4a70eae470 0 #x67a6c3f2d759c90ed8e0e296089d3c6a31ba84d94) 7 (5 #x244bad82ce871f4 4 #x-2f493b435b6bb20b4a179c086e 3 #x29421f7b6970fa0de710a30325343228 2 #x11837c3cd9ed6edd3762c37e7de10cb2f3e 1 #xe1845ebad452fc96ddd1a09071e951de093a24 0 #x-e3289bb83df18d2b425b9e317f3b623dcc24f940) 6 (5 #x4877ad0b4d91f04 4 #x3d5265f881dc426b120280267 3 #x2d078bfcee9ebbd3c4cd7c334bfd1cc 2 #x111a94d113cb029a5849dd8b877461f784a 1 #x-e80227c09c2d661d53a13a94edd165b374bc8 0 #x61cba52521dc6355fa0602ed12b07e984f410727) 5 (5 #x2977b8b7b41e12c 4 #x-18a5b9c9a9f678d96ac86f7e 3 #x979b4a90cf4d4f935e322e5e94f54 2 #x-907b9346e75c179537b945e8d2924aeb1 1 #x6a716110c7bc6a533c23a153dfe6fa9d8326 0 #x-4f58e8972e2307d9b7b3298fc28cec845ff27a) 4 (5 #x56ac0b1580f34c 4 #x1fa01134b3c77977089f29 3 #x39e93f10463394ac304a386c994 2 #x3046abf039f7c0c636c9e59fd08590b 1 #x2aacf2f2084965b78e1c7b693f93476fd0 0 #x15879f4aec121fddbfddc673dda4285e9c1b) 3 (5 #x192dbe4fb7c4c 4 #x-39843b1bf0ec21f7efa 3 #xeb895a829afd456f72d0590 2 #x-564aef84dce5365da6a8f877168 1 #x67decd9690d9905919b0b096a05790 0 #x-1f2e7e21092d2dcc0fe8f8f2b141bafc0) 2 (5 #x468040ca24 4 #xf03d38e20f0a14 3 #x27191543a974c13ffc 2 #xd072134360d811dfa1af 1 #x8aa8b99cc23a91f87e6ab8 0 #x314b15ed416eb701c2d7957) 1 (6 -1 5 4466 4 -7129175 3 #x121a03b96 2 #x-13099b44925 1 #x58629c981b12 0 #x-19f99b726362e) 0 73) 
  (svref *ec-g* 79) 
    nil
  (svref *ec-g* 83) 
    nil
  (svref *ec-g* 89) 
    nil
  (svref *ec-g* 97) 
    '(98 1 97 194 96 18139 95 1080968 94 45689425 93 #x55BBF23A 92 #x7fb4ab0c5 91 #x8dac65f0c0 90 #x6bcc9a72b31 89 #x253f3f95e326 88 #x-1cd5ee75e3525 87 #x-32ba5a9ca410d8 86 #x-17f5b624b56a144 85 (1 -990564 0 #x12f18342cc46fee0) 84 (1 #x-88365D0 0 #x284714aed43ed0480) 83 (1 #x-17b79ba5a 0 #x1d274414f01a6bf228) 82 (1 #x4affc724ac 0 #x3a7c6282f34d166a95) 81 (1 #x3c8cd3d8033e 0 #x-c98d86f1ae91d7587c6) 80 (1 #x1268dfbd7c6084 0 #x-bab1ff41251e4149e5ad) 79 (1 #x3b06fcce84ddef6 0 #x-20985956405c0820cd5c0) 78 (1 #x8ba7c3d6766598e8 0 #x4d007bea4e2a5ad854c79f) 77 (1 #xfd49f3453189977d0 0 #x4e8eaaa5d6223df702441e6) 76 (1 #x16193848dcd834d9810 0 #x18238a12bf5661f448e01a4f) 75 (1 #x16f44685955de8396000 0 #x-108e7d99aef7a4bde6443cb18) 74 (1 #xf78a03918c1467876fe8 0 #x-14f2624c00f07a2c2f3f50be22) 73 (2 -25827802 1 #x1d5a761882b60a5173634 0 #x-6b437fe2d61a74115b6f9966a8) 72 (2 #x4a1c69dd7e 1 #x-af2632cf0769331bf1b810 0 #x449d902fe8e2682412c22c67e8a) 71 (2 #x-8cdbdb3c471 1 #x-fef7f003268378ff2f601fe 0 #x58eea71e465d54dee7cf02864ed8) 70 (2 #x-374e4239b253dc 1 #x-bacd3f6c12f8f093b23afa0c 0 #x210f92049a4d4c8ba342c281b3d9d) 69 (2 #x-230624d382600e09 1 #x-2f670171efacb625416e1b326 0 #x-9b0f6e902f33dbe5515556d58a5ae) 68 (2 #x-b7d4914cc3b4d74ed 1 #x39d3b306e7bf51dd97e87f13dc 0 #x-104c6d33e3d5041afdcea2521861e7b) 67 (2 #x-250b152198cdba76967 1 #x4daf550b3a3b4865386574fd75c 0 #x-60a9d880263c26464f004edb468e400) 66 (2 #x-472874883a3d38f371c5 1 #x24238753a946c293dae87b50308c 0 #x1da53aa731b1f6ba17c2f8e6ac162c21) 65 (2 #x-251d27a94b6c588ae45ae 1 #x-b090a9b93c4bc0ee19d8a6fa19ce 0 #x3043f12279f67f1fb25b49c20246f6bce) 64 (2 #x10935c52fd70db886279b83 1 #x-1cec68e02be5afa196a4304c94acdc 0 #x13b81f193968e492ac7f98c0399f06e8ef) 63 (2 #x461e09a97f9a322546ad5740 1 #x-139828e2052e3d04b7873c802218a46 0 #x-1d17c65f42f3de2e07aed86f725518dde8) 62 (2 #xa809d62f689b22d8592f02b05 1 #x-34119a69a6a621072c2438405b3aaf0 0 #x-5cf7f9cc175a40debc53075b75094f11ff8) 61 (3 30674698 2 #x1234b5285015bbe35073d198982 1 #x577cb02ac11c418b6f4f1f89c8074e3c 0 #x-2635e8d874c416d30b824a6682ebf72f36e0) 60 (3 #x1129b3770360 2 #x17e737dfa4cf95d940de8426ea6d 1 #x538109e571e6975c6393d85f7c45279c8 0 #x4c2c849e5a721a15c76cdadb6b3f7f320c7c) 59 (3 #x-7626ee105d5878 2 #x1701cc4f2f02aae2e6340ab923e1c 1 #x19df9120d675d1fedd891d0126dd5d381c 0 #xc6bc49c0b507c600234ea8a392b8749650218) 58 (3 #xa206bff4371477e8 2 #xd3f2178485420dcf22b3873e6be7b 1 #x-c75b99b551013598c714e1cb05bc757eb8 0 #x5c1fce6c965c66fd58b822d3ef6db59c0319a1) 57 (3 #x13a8e691c8b43af8976 2 #x-27d1fc4596033e70ff02eb526fc6e2 1 #x-117e5699c5c9de35139213ed4d9c705937e4 0 #x809a779418ff66a65cf8bc92674b9e71156b52) 56 (3 #xa6acb543d66abd3a37b0 2 #x-10d6e17ddffb5182e8cb3f7d2b1a3b49 1 #x-78cdb686088aa1f780b4470796dfdd9ddc70 0 #x-c5d6c2c78112a6edb48d3a45060c69f0d0ce6e5) 55 (3 #x21a279af10bdb5f83fd258 2 #x-169d4abecf1674db36ebb47d350ef2b3b 1 #x917da8bd137669e341f26627191ffcdd85aa 0 #x-645cc0c6d9f6ee910d9bf2aff62dae5229afd280) 54 (3 #x-397aad9fde7eefbc279aee8 2 #x-11dc46b74a0fa4928ce470daecf940f3d1 1 #x29e44dc117aadba6f63f690b4a717e2f1ab884 0 #x-17ac80a9c01510ab587de2e6d62c00b158096829) 53 (3 #x-3eca24d271dd32706b77eb3ca 2 #x-6f3c00ba0a93b77daa1e3cbb388933eaa9 1 #x17c178d508d45bfac0716ae08154da77764f976 0 #x1592fc21135361ba5cd272763087b4c92af751c28e) 52 (3 #x-11dd4b1bd331abb3f6239968768 2 #x31f1d9f15287913b54a832188463bf13d00 1 #x37ce14aa764a2a35834ec77318aa70a80c603bc 0 #xc916fae81f31d1273bb00b4f2d34c4c15fc8751643) 51 (3 #x-2c6ac221834f44aa5d85495993a0 2 #x7c18ac96229c9756e5c751c18c16f2629c67 1 #x-3caa190c8fc18992c9460cea8ce968c8131ebea2 0 #x38fd340dbd9793082ebba462d94ba5a901af823aab8) 50 (3 #x-3274c0569026dfc4e5d98681fb9d8 2 #x6e4f2b4100e82bc39647aadc339259bbb938a 1 #x-2f9cabf1a521522ff4127b9cc98cc48f1964cd720 0 #x5928a8c8a4706f59a74fde4c3bd396aed4c50807cdc) 49 (4 -6256985 3 #x4302f86c40ecabe1524f557e442012 2 #x3775f4db417c4ad007f66e3f8386a7b0b79b02 1 #x-cf6ae2adc86887ef4e81694cb2ec64f3a29d8df8c 0 #x-11575a62efeddd200d10f8e7c5472ab74c35482199f4) 48 (4 #x39dd1b2fd727 3 #x1bd9ddca246494a6d0573010c09cfdb8 2 #x6ed647f66c823fb1044599eeb4df714df06a40 1 #x3320cbb2cee771574f45d6fe2276955d1eaa1daf40 0 #x977df0d1a3c53f55e220c94dd7d41956f818f6dbd91c) 47 (4 #x-25a293bea7b88598 3 #x44f84d080ced656a36e9a1ed4d09605b8 2 #x-f3e6533693f6348c40d2254b653c92d723168de 1 #x48fac3eaa45a02c369cbddfa5e7c8c6a5a30d7b9c24 0 #x11d56d665a90eb1316f961dd2fce9fd2428d27d66a9778) 46 (4 #x768467fe13e678ae5a 3 #x6f4ddc3b85e47632ff42ef916ca7173330 2 #x-ff66e41c0340e374b4daf573c9fc9ed147f7bd5c 1 #x1f917b23cde774c618c2c44fa0ce84f02f7a8422e028 0 #xbb94d549b576faa424dd69147912e9fa2e0d9e779009a3) 45 (4 #x103bd013bc7dc5513a6d1 3 #x7df53d4d596436ba4c0fd212346e32063b8 2 #x-8888186f83589211607e092ebb41e83c2b81a0ac6 1 #x487295731f0e3b147b1e8b42ee3d9d11eb1c6c39d754 0 #x596d35afa6f342dc6eb1e7dc19ec00ec93914a8db779f0e) 44 (4 #x230cf41d1c26832add8f39b 3 #x5e166898e83196e716f30e388a085bf32a58 2 #x-22c9c9f47868449e70f182548349c9a1f413034ac2 1 #x-2cc28a3f9db59a437477ce69c0ce1ed4835e603eaa6e8 0 #x261c027167482d38ae9629f8b6f46447a84c46e20537fff7) 43 (4 #x2d39caef18137f7789e5dc128 3 #x1b6dc7bf12fe3c7cb1f461538e5a33843b9c0 2 #x999fc5f9bca2fed574408de4c4a5279d436c59b2c2 1 #x-24560529bbb849d69183cbdc700c58d9522e1ffd3eed78 0 #xfbeb713bc6f7b7e24f583b3b14de7f5658a4368f4606fac0) 42 (4 #x22c8fc1b37d002baa8e2a07e7e9 3 #x-25685a043438ecc1fe1a6621ef555533aef578 2 #xf48e40898eb7eef239e335346c34db74e197e51654e 1 #x-ddfdadd850cd8d4995f7ef50738612f0d47c8700c60fe8 0 #x63f6943231c22896f9199e184315dbe4778a8a3954acb303b) 41 (4 #x1180721efd12f4a33ce02b5ef4c67 3 #x-43edd52a85f159b8c25dc34acb54e02256ae948 2 #x875d11c8bf98ddc6e1f33904910f81a071a9070d1a28 1 #x-2ff1e56b94a410156582be6e9657b55e91e3a1666a20f2c 0 #x24ecaea8e066ea24adf1bf9c2626d6aba0beb30747ef9ec592) 40 (4 #x632c89c3e5f2a61fe7680709deeb1a 3 #x-3b2ffa909c96c672df3780f61744e48973f0e930 2 #x28fc63a236ff7f702826baf684ff1ec2b27cc7e11613a 1 #x-3376baecddeb4873b00c8290190eeffe036e53cf3179d8 0 #xca36636a120f646f6dd34c8585085951d41daf4d8b49ea5281) 39 (4 #x1a1122d1e6abc36a6f5db78e81cbafa8 3 #x-1eb0c470304b92db482af5c906af25d530d502878 2 #x1b78ea1a1114d15bb6baf3b72bf8ff46efd87e1bef22c 1 #x56440bc39bc6e43330029de0b2bb0e3fa69ce5ab454a41a4 0 #x41742525224c9a2f4de427d9cea68e70b8ba4b770355bc5cf98) 38 (4 #x5493892d2dc399e153a76d6c3de585b71 3 #x-561ffbbb621e3c1fb9b44d958920bfdb5f0403dd8 2 #x-57a82b7a04f530bf6a6acb9202c05df5edaa03cb37ca7a 1 #x341196cc96690f468d10c3e02f3f0a7f5bfdfdedf621be440 0 #x1471e48a6ca7f9a340697506b02004ee5b68de839012714dc2fc) 37 (5 446006 4 #xd9f67a15bf6e735aa1e81d6d73b08bd20c 3 #x664a637e287e2ad4599b1dc4dc7556b3d40f642c64 2 #x-35522c2d81f1647fb4015d44307990d265fdb248ee960d4 1 #x1643ff9aed40a754669b4b341886039b8d563d7f1927566ff4 0 #x62c16c1fe39eebc2870b1cfb58d8c516d85f374577c012877ea0) 36 (5 #xbc821146070 4 #x1c82b780aa59a07bf2c81b016157727f8813 3 #x733b7307f72997825bcaceb625051cabd5ecdf97118 2 #x-116456881fa8123a7dfc64cb90432ee8d9e4bd446576d77a 1 #x7d22f54b6fda070edfb4535cc05eec87a862b226498dbddfe0 0 #x1c88a6cd6bf5a9abf44e7b69a98d473870ea143b0b00dd54ac288) 35 (5 #x2475315550f8b5cc 4 #x314b9318904cc2d23450aadb53bfb97fdfa20 3 #x3f0d0913faf929a012075a2aa485885d1dca85552158 2 #x-2c8e2815e89437fe652ddf3c2ccdb5e4c2ce668210dc63d4 1 #x244c14a96cddf47b78fa7b7c29a012ee4fe31f5787bb0e70a9e 0 #x7df474dc28cddc75231bd50bfe80dad6d664c8b5fd1ad78420718) 34 (5 #x71d34b782d202417930 4 #x475bbae260b8a39f2b411d827c56b3aff85fd6 3 #x12b394f79f46df548d0a891e376f8c2d6adb40015d500 2 #x6a2f30f95f84863b13e49946ded1a54fff2ab352036d74ba 1 #x867fa436b497d2b790763d6ae0bd1ad320cd1da53c12474a13c 0 #x217f88ad736ea44b8bfe33d4ca2ee73693f2b9527446e230e44dcf) 33 (5 #x39ad93f564eece5373529c 4 #x5761ff9e57a6c1f5359c79d680cfcf96412e51d 3 #x-5e1e1eb80529c93a3f53ba50fd8081b1ef7c6b3ee01c 2 #x70eca9cb6396d9e749a53f245983febbd7fd066bf0815d7a8 1 #x1739083fb99f8672cbe364af658f9786ceb7eb8f570ac29da0b6 0 #x8a79c463b7b3d949bff11c1d779999515ebd5fa8996d77e8718d8e) 32 (5 #x83a471ee2827bb3e63e22698 4 #x5b3f392ccec6e8e9ae3841649a3fafa6e8e67813 3 #x-3a2053ece6fc9bed86afbd1b51649f43b8e57091c6a4a8 2 #x290c7f5eba7bd5abc73e7f8356c833b335e54cea0b50abb24e 1 #x2578d09143c94c10046def8d7c77b93ee383b4228c776eeee584 0 #x22966fe2baa1996c403c64485e81cce2f175dcacd4d2f9099119d41) 31 (5 #x7a0ff49f6a98f53656f9baa0a4 4 #x51bddbae335155666e8eb4a393f021c2d341f6fb8 3 #x-21ce82661f4dee05768941a21f98c1bb612de3e98610ab0 2 #x94abfd656d348239b141fbac71eb31ac19edb683ea22a64802 1 #x-31dd83d49f584714b75bcf53e06fdd4ba8b117280ccc39d77296 0 #x8476741a99250b18e75daf53b90ef5126552b47528353afa7542d40) 30 (5 #x3b30fb3b21104b2d911c5d4cadb8 4 #x3f189a88e9032c18a786db4468678e3043244f4689 3 #x-afffd3d01fd8d8e2faf939e24ac01d10f660682c09f66a8 2 #x13bc1fea7635024489c85310e4b4e9b568dabb069881256d1be 1 #x-327fe5dd4b37e36fe1fb6b74c730941b480f7705b0b6ef288a5f0 0 #x1e6fbe24a14f9f1dcad72d96ffd09aa7ab51406a203c5f78353177a5) 29 (5 #x11a5bd4414fc6624ae8c7e54014da4 4 #x2a16c8d901612b192da7e173c38ca062d759977820b 3 #x-1d26b66e96b8f869005087bafd27a1f79d70e56d3c31a79c 2 #x-2963470e249a46972b4b5d6b19a9c0fc965b90612b194c106 1 #x-13ed3fe880aac20e20b9b2a6f8aee1311f3007ee8d9fe27042f3e4 0 #x6c6a39147e70008cc08dc8b624d1018f989847e558ca2433d382ab52) 28 (5 #x394a0cb04fd43a3cae5a81345da9f80 4 #x184d594c1dcfe844031c771d72b2c2500d1ec9598cb6 3 #x30067f9936c37f5e18188ef84f8b32331ad4baf547dd4e00 2 #x-bee033c895baf946df4b2bb1904d1396389b7107221b4efd0dc 1 #x-635561aca9b5e595c9408c12e4aa1283b5ba05777e90c9251ca238 0 #x1761971eea649d81aef483f75af7a9b4d39592cf856c03dc0295bbefd) 27 (5 #x874a8b3fb464a26ac826f5bcb5968bd4 4 #xc2693224c63fa0f894b6c0aad4f65d7549c423a7e9f0 3 #x3a9b767036da95127477de076ce3e31de83e08382c03b22d8 2 #x-344c0cf8a9061c519e66f736b2e9dabefcabc2789c44d881869e 1 #x-19bc1219a0c795ea556f1b713bc87f3c431472f5faad29cad711be4 0 #x4d31dcf4c0c7f88ba261db782644046094cc4b0add92792dadfd9a418) 26 (5 #xf300018954c65cdc979e542f00b3bc8a0 4 #x541a52529ca44298ce80f9ab99c52a8365b238110db35 3 #x147df5aac20162240d42cc19b55d7254fb2aced572d7931818 2 #x-75e89e0010d1031f609eff29150e0c27cee5e28f7d42e3f4e640 1 #x-58fed82eddf513669aa699768a07a6b7398fdaa7d61b13ffcba0ab8 0 #xf26da1cae50f6069a9357c5359371637e404db7fd7cf494f89420a60a) 25 (6 -13871 5 #x155f0dc100b6f6ccb9fbe373ab918f1ff6a 4 #x1f6ad6d6d126bb5292c6fec63aae59c7af22e23a451d9a 3 #x4625b3d298124a3e54ba97e71ca6c8281cb8a9baa00389e464 2 #x-2c5a45647970c2b1a2872f8552faac4f76f8ec8b904e8d7f26fe 1 #x-10755db024ee407e29a57b619a0ce352353d565cf8f097da9612e9c4 0 #x2daf5a213e6714c0683fe7fb603f28abaf8da9b8ffb6ce80e52c9adad8) 24 (6 #x493a6b4739 5 #x180d1007f486f9b575922039bc227384a690 4 #xa1a08bff1c87acdd41822a60d94bb1e0e65f13a57ac655 3 #x932ce3d22fb06884b4b0e13472e60258bc883f3b70d89db428 2 #x3305aafedee729aef33c6c0627fde64df81a4a2410624a11a1f0a 1 #x-2c25944810ce459201915446d9b1fab64b7c6d5ea28e57065b44f970 0 #x84ab4370ce715bdeabd82e824fc6adcf36a1d4c9c8f4ca47be4bd89a5e) 23 (6 #x-b3c37c2526ab16 5 #x15f78a676ccd04167423a7dd5001bae6fbce0 4 #x2c86f9fef34f2b2aa0978815c0b8190fc31f062eebd1670 3 #x5cc11eaac141476d659ae52e50e3e4886db230b237a408de08 2 #xf421d78034a41fda1062dcc4ea87141bc1153d26c8c7c6bcff7c7 1 #x-7359cfba6ccbb3dbec9a59d1560dd05bb345673d4da8521556f82406 0 #x16bae309e8d5235b1e56f89a19ab5d7f107a7a06ddbf303f5a20e634628) 22 (6 #x215e0d1b0ae644714c 5 #x106f9c8e075bcd53eec6b062dc84c1ee0927d0 4 #xa728bb1147f7a8e2f77772122e808198539a0968969feb6 3 #x-252e7411aceedb99c9282329bd3ab4285fbeb4df8a93c609b30 2 #x2c2438111ed26085082ff3f939febe5cec15569ad5511d2f280e40 1 #x-130b366679f6c8edb52aea82dd98b9bee8c2f1ad8061f1b8fd39f95dc 0 #x39c19ab9ee5c22512b51e20e1d5e084296014983836af0de585c370b52f) 21 (6 #x-130ef01aa590ee96036b6 5 #xa1f0feb24d894664f068342bec18deda4d6240 4 #x2125d7739b807dc26d7e243b3da42094eb8c9e078b15bb0b 3 #x-a82c3b2ed9b152656dc0394b2d26deddc4891bc838e1783bac8 2 #x673ac9096ab18f0ca811cae2480e7432f8e97248a97cf0b0bf74f7 1 #x-3168a06b6507594f0aa2da9d0a8edfafb1dcb70e383b46587b25c358e 0 #x899f8f8d12e330d77cce6389e0d7345f6dcc6e9dabe1511b95a161dd5e6) 20 (6 #x3458c117c26090410f793d4 5 #x522f64ef8c064eab005e72bf6d773a6a1678f10 4 #x580a35570d74d3f164386b49c22b6feb6a599ae7dc3e5569 3 #x-19754a202077661c9d80d2ab0e97542af4f7ed629f3310eeb578 2 #xef02c5489d08550de22ab36b5118b418123bda9852a6d9b931dc2f 1 #x-75a55fbd211dabeb80c48ef4f279c36b88d0549bb9df3f5e41fde16f4 0 #x13632b4e84ab8991c534b8b11560e32f231b197bea0aa7aadd4d850a363f) 19 (6 #x-37b669de370d01d6245c9be26 5 #x2251e1ae74373ec080b2023c292fdc6b468c96f8 4 #xc17069ca2a027f10b6ed1b84c75c79facd74185096c8e7f8 3 #x-2b36bb8a2f9af97359eade50f2854ac75684ce8c6528f0695940 2 #x23bb8f323a8624c31ce9faec824b4e009a626ae305d30e0761684a5 1 #x-f32094c90514cd2f4673c031aa69869e4ebe390d31d09e36ff3b577a4 0 #x27867a59c30c4dacbc9fef6a10dba8143e3a9bf84c855124e4b631902080) 18 (6 #x1adf2a1e518e70eced47b264a1a 5 #xbbb6aa43b4d707c8c2c9714067e9dc40dc902e10 4 #x15a86d2e8ebbe65360740c88bee9d10d51805f68e1382e0f3 3 #x-38e5a1906d5b0f1f242cb411637408a0a8b9df0e6de3d95015a8 2 #x4aa3b29a216a150b67b9a125da7793e654685b68c24b2154332d977 1 #x-1b663ebc740721dad264b02776364134cde781c48627b65e90150812a4 0 #x455c3e7e398ac2ced213b555449eabaa986dbecf4964d5e9785fc04797f3) 17 (6 #x-67eba79c08998ba503140192e8e6 5 #x340a7e16131a9115c192109124614c683ac8c9d40 4 #x1f12da2a7684b42ed7657782f810150953b63d237279e075d 3 #x-415ee9b5859e5bab92645e33b402cb5b4c38236ae75dac9783c8 2 #x71cefc24d526ab0e36d7c662de656c9bff439389e11a142ae21c95e 1 #x-2da043ee94578030dcf2c71de2bac07944ff58d2dd6831a3a371858466 0 #x6b26b5072fca346a2033a0dac0556f9cb564f4388577c5a8e5e1894701fa) 16 (6 #xd6ee47365f2e48c4f699c571bea5c 5 #xb8a7de656b6717484dd13a26e885c5c67be7b2ed0 4 #x22eed51c034081056b82c8a55e77cb15714e74ccd9e0077d6 3 #x-4afe47401bb4c6e487dcfbad6f51fab1a670df8af1ac785dcad0 2 #x6d91dfb91f15bcc81978cb23770908a708239e50a8046eae1f43a3b 1 #x-4059c34370fbc49b1503d0e3996d93d477ba601910378348f9dd94d90c 0 #x8da2cc69e15028ad29b7e455732868322779ebbff230e544dded1db0caf5) 15 (6 #x-f792c54173ae89a37279ce5755b776 5 #x202321ce34aa6d4398175d6c6feec7b258dd27fbe0 4 #x1df366e5f7e01fe2ed27eba3e695f8214fc8ed620c5d786e0 3 #x-551d4b46fdeb350695d66798346e6d1fae8cf610cdd03d15b5c8 2 #x36beef645e0c3981b36a075a4d1aa58b99d9d06f64e46af98e9681c 1 #x-30ce924ee10a05a72ace9dcb8010ea5a1bea40cb02ef92f6cf4b59bd3e 0 #x8450bdf3c1dfb94d91291fca501a9023dc122e04c78a9d40f32d9ebc1c28) 14 (6 #xa25fd7acf6ee79c1c266a6fc6a2be41 5 #x44639846309943fb589de0360e2519e27f63de7f90 4 #x12f04fa22e5454338c49803a5dfbb2845efdac0b8db926133 3 #x-4d7f8e533417705ba44a6a1b5c06cd02000b27bc99570ed78c48 2 #xfcd9bade2ad1af6d7f83895289ae4a44ca8fd8d886e40080cc5b2d 1 #x6698d9d22904060ada42c8552e28a321b34ebb67f3b9ef66e2edcec70 0 #x9235dbdb485b175ca783047783c3b1f76a68e32455a0e2805e5ca6bab500) 13 (7 194 6 #x-3d0c55dd46a256118ac56885f8465906 5 #x6b351dc853072850e1ec76f9d31fd603f627a6ae2a 4 #x87826f3caed3bea61385af45a9abc8bd9281f7efda9cf88c 3 #x-26f0c280f452dcef0271b2052e49ced0ad151b4244270957856e 2 #x187dad11583d282e52f8e697d6a420d98c35afda091b035b2c37202 1 #x-187369f599e0061751a9dd732ff9d6fba5b3891910864ccd57d378ccc 0 #x1e0a7dd2d2fee6eab0da7d0c2f03d189217d435c4711a151b8fb6286b260) 12 (7 698972300 6 #xd0f3e6f6d99dcc2ec23258c24dce3681 5 #x75b49856ad4b1a22b9745aeea7b8e79e76b8e1a920 4 #x28a14dde3a94bb1282ae15a2e1519ee2beb96cb74ffc5311 3 #x56a3115d3f4bf8a1c0a3d31352b01b11b42dfc26f1192b1bda8 2 #x130041e10f76afcb684b73561ba565f91011be3e3f94fe081dde4c5 1 #x-1d3f72dd5697061e391364cceb878bb464d04813b55525184f12b12998 0 #x40c48712e1116bcc69db40614223a468954beb55882a72bece3ecdddd33c) 11 (7 #x7c037c6591c 6 #x-18e03f7631f4cb03266dab27fb0d14bb6 5 #x546b518943e690e3d426dfe4c5fe3f6f6ddbee34d4 4 #x796676a5f7ca56675bc8399136d6606fdd4935f796d75e8 3 #x1141226fb3670603bc77381bbe868cd9ff9b26398633100d6f60 2 #x-4a53d0806a11dcd016b3a99d01d45fce8005f473e4c5ef78f831c0 1 #x3dbaecc52c515513bcf0d752b025d9a0c1e065e2aee6bc99727ec5180 0 #x-2a10f379e8e1caa3d091f127a1dc57b78bb3d7061ce688b6c75dbf426658) 10 (7 #x1b5becc9ec186c 6 #x195c90011042c43bbad6845994185269c 5 #x23ef01251be5cbcf7113cd4eee1d9e3aa44d5a5200 4 #xc18ebdb4d21f47ff8bb139fa567407777711f19706771a 3 #x54c4f43b8a15f2182e8abc79bd93f82bd1b6fb0fcb45837db18 2 #xca7aee188c48e8dcfd0ce8f22927831cdd6b23d001d84d7ebeafc3 1 #x-4cd8f3c5b58a34217a3ea24d2e9ddda15031dbbae7363d0222c4e9770 0 #xb09a2b0fff4b79341b6ce6f45b3b4a6886b1aa5397734d3369de26d073b) 9 (7 #xf8d72ff4dbc641c 6 #x-d0864bac2755d7e38075864101a91a26 5 #x7f9dc722519d61ddf0c3494a38122bf27738336a4 4 #x8bdac69529cc64e6d9795a7bcad5e4711890af76d5827 3 #x-387801db57c3665f53b8510fcec2002fef03c54fb58ff5ce4a 2 #x1ab1d8e82c4960c8c1d1324e33921b43420ae300ed8814950b6012 1 #xc49ff91efa91e5ba661b5bb4b6c5c91ade6daf4a6f8e4cca8a385550 0 #x-199ce98b53be9b38470e6cb0a23b667f4f22e2e218988b28e82ac53729a) 8 (7 #x1f387bc4246f8b44c 6 #x3170556cae64ab0c4f99ba9df79c879a 5 #xc78b6ea88f857f4480b43a517a40539cdf757338 4 #xcd7bd61f80fd260dc6a33d4fbe573ffd636b70f907249 3 #x-a66be53531dc2e44432954d2b52e49ff0b9a696b30f7fabe8 2 #x40e92f404befc4f142efc40631fe6cb7c59b76a4aa78a306cedfb 1 #x1833ceb6a6552ecf3fe3b7e8d0dca46ee5cb217fae5492910397868 0 #x2380ca8dad5053fe740aa4e2cde6fdff136b01fb46e69f4cc922bb86d1) 7 (7 #xfac0546b5fc110684 6 #x-4c06af64561723e4fa3cf9cb9ec4666 5 #x6e8d3d64b923bde1971f154047b51e6024ba6a4 4 #x-13abd67c01c9c02bdaa1798162a0283b713634a31b798 3 #x6084104ac6aa51d18c07a9d739da2b2848c46829da241fd8 2 #x198f8037656e583de2a528a7953241d98b72aeec0224ffdc2f39 1 #x-881126e0439ed6fb0056496c59b7b0b1b3664ed5caf1342caf044a 0 #x-1c1624825e7b93a5106e08e707bcf4ad1b3852e350a7c2e40f99a2d00) 6 (7 #x1faa133e371864e54c 6 #x2719f62557a568f60e0a29651b2cd4 5 #x10549739c3e5ac1a0970e7f0c56aab6fda0d18 4 #x3c2adcde7d46ef9e54eaabcd1202a9f705b5a01b3fb 3 #x28b685aff8e49529a6e109ca68e7ffca068a5e3cc2f7cb0 2 #x54efbec49b1082c409b17ff7a1197a219d09a8c8eed437693 1 #x-1fd115d3cc688dfec3ddb42963fec7b2bc9b445736e7e76fc817c 0 #xa4488937056e2c879707f5e64bab740b93c817f6643ad0085f02965) 5 (7 #xe797e2bb811229c1c 6 #x-4ff28cb4a84a4b00ca52ec4815f6 5 #x6e77f6fa18aee859b957f87eb5be64a149c 4 #x-11dce8a90de04587e49b84780a588159e9d2812af 3 #x19e65c1655037cf4fdfa53149f6dff6b8ce12ce5a6c76 2 #x-303e0c3d069def5c0ee2bb055b221b95605f3f6146ece529 1 #x1005b087c026a5ddd4a022f7a172e24a42194f2092f3de1dffe 0 #x-4b71974c1f62d5fbb91188f5cf6f84848fe9804cdeb2a4190646) 4 (7 #x12657351936a1546c 6 #x18c94eddd6ed1a736b7cc69e8c 5 #x47318641cb5d5de9f099019d624bbcb0 4 #x44bef66238939225553b0c956620f856e145a 3 #x50478af304483107b793200ee49789fd9e6c6ad68 2 #xb9e5c146131a4e7db9215014ec532d6667119cc77ce4 1 #x368170b45b5101d31731bd926daf478fb6774feb224062c 0 #xb92edb6e4e05f5819df7929a42961f6f26a9ec5c33cb3f31) 3 (7 #x245b17a0d5a411c 6 #x-78c8b5593aabe1a5e6db56 5 #x14b883c7c3a514abe75e38cd73cc 4 #x-3acdf504128a2dddba6605905266fb98 3 #x1c07a73150e2488347ebc86d1593d5f88b08 2 #x-3ad540d88f9104fd571641bb099c0e7d71a1451 1 #x2a39331ea5fb100b85d05f0495fdc388dc81f6d066 0 #x-97995051be83599b51ec6bdfb58a7c20e03d6e3540b8) 2 (7 #x180bef3ef98c 6 #x271297bd10c3b8cf9 5 #x22771141165e6d77967f0 4 #x4514d710cbbf920efdb970c7 3 #x1d580510e66a59b00b326604fe0 2 #x2bb955733da5e30f44d9f3661957e 1 #xa7ee4f42749edf8aa82ffa9fbd1430 0 #x187e687fda2050470b66d0ad971c47b) 1 (8 -1 7 5954 6 -13934351 5 #x3c70427f6 4 #x-8e912cb5819 3 #xa512af19c7d8a 2 #x-4f407cc08850eda 1 #xa6b08338f23d1f1c 0 #x-151b3dde5209753fe) 0 97) 
  (svref *ec-g* 101) 
    nil
  (svref *ec-g* 103) 
    nil
  (svref *ec-g* 107) 
    nil
  (svref *ec-g* 109) 
    nil
  (svref *ec-g* 113) 
    nil
  (svref *ec-g* 127) 
    nil
  (svref *ec-g* 131) 
    nil
  (svref *ec-g* 137) 
    nil
  (svref *ec-g* 139) 
    nil
  (svref *ec-g* 149) 
    nil
  (svref *ec-g* 151) 
    nil
)

(setf 
  (svref *ec-g1*  2) 
    nil
  (svref *ec-g1*  3) 
    nil
  (svref *ec-g1*  5) 
    nil
  (svref *ec-g1*  7) 
    nil
  (svref *ec-g1* 11)
    nil
  (svref *ec-g1* 13) 
    nil
  (svref *ec-g1* 17)
    nil
  (svref *ec-g1* 19)
    nil
  (svref *ec-g1* 23)
    nil
  (svref *ec-g1* 29)
    nil
  (svref *ec-g1* 31)
    nil
  (svref *ec-g1* 37) 
    nil
  (svref *ec-g1* 41) 
    nil
  (svref *ec-g1* 43) 
    nil
  (svref *ec-g1* 47) 
    '(48 1 47 (1 -1 0 696) 46 (1 47 0 162996) 45 (1 -1034 0 13191208) 44 (1 14194 0 81388866) 43 (1 -136864 0 20652552) 42 (1 990431 0 665885284) 41 (1 -5617769 0 2604180888) 40 (1 25770006 0 -8547400401) 39 (1 -97893151 0 45781641936) 38 (1 313468474 0 -76906587672) 37 (1 -856757031 0 -8989611792) 36 (1 2013138357 0 1174498953116) 35 (1 -4071881378 0 -6377048363760) 34 (1 7040645261 0 24928157826216) 33 (1 -10182603298 0 -79386966441296) 32 (1 11611941072 0 220781990489967) 31 (1 -8435506655 0 -548693998864296) 30 (1 -2065827049 0 1240662966641892) 29 (1 20241250112 0 -2576093348764152) 28 (1 -41879296232 0 4947522566169666) 27 (1 57873890484 0 -8828818785245464) 26 (1 -57280402355 0 14688679731301812) 25 (1 33364599371 0 -22835198524494024) 24 (1 10454018992 0 33223244819270977) 23 (1 -59196883097 0 -45278532989847648) 22 (1 92028642340 0 57829488935011968) 21 (1 -93046207239 0 -69218710269643424) 20 (1 60791892299 0 77619428640291072) 19 (1 -9942017442 0 -81489106118337408) 18 (1 -36612252089 0 80016735337075008) 17 (1 60426283952 0 -73390580942103552) 16 (1 -56657584158 0 62769783247211520) 15 (1 34288012648 0 -49958767046766592) 14 (1 -8421580132 0 36908277988294656) 13 (1 -9100068184 0 -25231808379076608) 12 (1 14673798654 0 15902151817441280) 11 (1 -11705275552 0 -9197157268586496) 10 (1 5945275904 0 4853861392711680) 9 (1 -1469334304 0 -2321153314652160) 8 (1 -552981696 0 996905126461440) 7 (1 845669120 0 -380191523733504) 6 (1 -508021120 0 126848627113984) 5 (1 187217920 0 -36291068559360) 4 (1 -38598656 0 8657458692096) 3 (1 96256 0 -1652757102592) 2 (1 2502656 0 236558745600) 1 (1 -688128 0 -22548578304) 0 (2 1 1 65536 0 1073741824)) 
  (svref *ec-g1* 53) 
    '(54 1 53 (2 -1 1 1487 0 -159132) 52 (2 106 1 43026778 0 #x1f7511d92) 51 (2 -4929 1 #x8fe1ce794 0 #x-880dfcf71ac8) 50 (2 131122 1 #x585369a475b 0 #x208f026f30ecc7) 49 (2 -2170668 1 #x1296cfccea17c 0 #x-9127e714c87990) 48 (2 22495426 1 #x1d3961464e507f 0 #x-3296abcbaa27c12a) 47 (2 #x-7F20229 1 #x19d4bc8aa39bf3b 0 #x-165c58d174f7806c4) 46 (2 260369390 1 #xe5e2778f5b0745b 0 #x1d3f99af8b030ec46b) 45 (2 #x665A7B11 1 #x553d0030053d322c 0 #x33f4d0465a06cc2e080) 44 (2 #x-227de3cfc 1 #x151880ffc0e9dd5f8 0 #x2be69b633e58cc1cb5b0) 43 (2 #x-36bda968e 1 #x314ce659acad51a64 0 #x19f317eaf13ab46112618) 42 (2 #x237452c59c 1 #xa921244d78cb87c6 0 #xbf472428ee3dfbc936d48) 41 (2 #x26809c7882 1 #x-1acb21c002c74652d6 0 #x48426fe566c5b67943bf30) 40 (2 #x-1991fa13364 1 #x-75c1dd74f19bd67e54 0 #x170e6d0e52b0c68ef4169bc) 39 (2 #x-2956cbe785a 1 #x-106de0e4608e05dae88 0 #x655f02eb77bd52f3b53f050) 38 (2 #xc4eb071e8e4 1 #x-cede9e77dcd894ad82 0 #x1852e480ec694a8b1c8a2835) 37 (2 #x22d104872a8f 1 #x2f434cd0fd2f2b57ec1 0 #x526565bd30500007a70b26ac) 36 (2 #x-2b3c1befa6b6 1 #xd60ed1e670c325ef4e6 0 #xf84dad4e0c309e4c4e452092) 35 (2 #x-117ee850a8ca5 1 #x1b7a86ddff8522a867c8 0 #x29e21d0778e5b26f086e86148) 34 (2 #x-a912e07059a2 1 #x1a8387c418e934179123 0 #x65cc37598659fe0c60b9d8251) 33 (2 #x46ccd7fb07594 1 #x-1839ef57115ecf5775b0 0 #xdfdfab8189bc9eb4e194cf6e8) 32 (2 #x9c2c74cc42d8e 1 #x-947521e6cd9b1facb56b 0 #x1bf48a13fe392a42271e95f08a) 31 (2 #x-232d8d90bf9af 1 #x-132110be67c46ec8bfb3b 0 #x32ea6e24c9d2036c9f575fc114) 30 (2 #x-25de3fb9cce572 1 #x-166235b3f3a697efcdad7 0 #x54c922d67d87c7a25729e4fed6) 29 (2 #x-344072606b657e 1 #x-7517c226a9830735c21b 0 #x816772d30c6b8ca12fa3bd69f4) 28 (2 #x1a5417349ad38e 1 #x1f47c4a21e380eb0ff974 0 #xb56488b8d4d61e1aad416b6fd2) 27 (2 #xadf20c809fd805 1 #x521c15c3d6d20c657fd6a 0 #xe9ea74ed581264da35799c8818) 26 (3 53 2 #xcbf959b712a41b 1 #x75376824f45bd52809333 0 #x115dca204e5e87b78749a7d5f51) 25 (3 3657 2 #x-3694802296c73c 1 #x6ac0b9bc0fb504343a726 0 #x13052de1071e0771b860b5fde48) 24 (3 25440 2 #x-1cd3474382a9fa1 1 #x2898435be0993bb3ab7dd 0 #x1337efe8c4896ce654f61a3265a) 23 (3 -1961 2 #x-23f9ebc2be8c877 1 #x-3c1b5bef6829ad483e8a7 0 #x11eb785797e1cda14215cd8518c) 22 (3 -282702 2 #x-75c72607e11076 1 #x-98a683e60a0fcd30dbae5 0 #xf6af7b854b39244b520ccb174d) 21 (3 -511132 2 #x26c96014b937109 1 #x-c6096c72c279724694836 0 #xc3c321d06d0b10e545ae699a10) 20 (3 -446578 2 #x3d93c1673addc4a 1 #x-b731e3d2fe9a2bf254e76 0 #x8f2d6d9a2201b7c8b98c219e1c) 19 (3 4481892 2 #x2730899562a438a 1 #x-7ccbb3542dc298d7a9b56 0 #x6066e4da2c0798d450d13fbc60) 18 (3 13411756 2 #x-878ad5090210ea 1 #x-36b12669320e29a7cf4b6 0 #x3ba96a19db57e9cf159a4c0958) 17 (3 -10365528 2 #x-29408bce0d20f40 1 #x-1c891b846a641e6f156 0 #x21df81d4f565e4bcc096594b28) 16 (3 -59799794 2 #x-254a01e7607bef0 1 #x1bc6ba19322055ae9f332 0 #x119986ca56540b3b78e50d0440) 15 (3 -11052938 2 #x-726233e29e31b6 1 #x20cf1a552049b1ca115f2 0 #x85804d27162ae0171533e2ee0) 14 (3 144773899 2 #x17c94cf0dd7a77f 1 #x19908ad4d4d848be157dc 0 #x398b96204bd16b592d82bd713) 13 (3 136166063 2 #x26f8b7c63cfc513 1 #xf8660c74abba862deda5 0 #x16750ad35241faa68d6b9851c) 12 (3 #x-C99CA51 2 #x260553ebc26f594 1 #x7b135b72ab01e0fb4eb6 0 #x7e5021f40c807020b118dc7e) 11 (3 #x-209C76FD 2 #x1cfb2bca931af1d 1 #x324ca9d6c58f19523274 0 #x27c241213eb4140cf4813ff0) 10 (3 #x-14780552 2 #x1306bee6d0d58ef 1 #x10ccdb6cc1bf08d1f037 0 #xb200e530f143bc86febd0d7) 9 (3 350245518 2 #xb42cf54e873c4c 1 #x46f1bee4a23de1fc302 0 #x2be5c8834ab5a4b500aea08) 8 (3 914287895 2 #x60dfb49f7dda8e 1 #xd7ae0c1846fcace681 0 #x970fe77186c8e2d5eff04a) 7 (3 909191097 2 #x2e5dad845be06f 1 #x13671fc03c30771fa5 0 #x1bf8ea8d337bb5e681abf4) 6 (3 497891010 2 #x13206be8b6175a 1 #x-44e0feddf5d190b31 0 #x463430474d3e10ec7c849) 5 (3 105260120 2 #x692ee32186277 1 #x-265494f266d600cd8 0 #x922938675858dfe1ed50) 4 (3 -60211180 2 #x1d192e8a998b1 1 #x-968826a0fb2b377c 0 #xf56557a089c373d45c0) 3 (3 -62352009 2 #x63762089159a 1 #x-17a6a1457acebbb0 0 #x13f0f811fade45cd800) 2 (3 -26065188 2 #xf6f22ecc444 1 #x-26c6455cfc05180 0 #x12d70a9f17b8627000) 1 (3 -5821308 2 #x18e3b056c60 1 #x-25bc401e430400 0 #xb84105d686550000) 0 (4 1 3 -578448 2 #x13b52e9840 1 #x-1055c4d446000 0 #x36cd25c06640000)) 
  (svref *ec-g1* 59) 
    '(60 1 59 (1 -1 0 684) 58 (1 59 0 154698) 57 (1 -1652 0 11272776) 56 (1 29205 0 -68149425) 55 (1 -365800 0 -254674680) 54 (1 3452149 0 3877836950) 53 (1 -25475079 0 -13711375092) 52 (1 150487052 0 -13349432925) 51 (1 -721829600 0 329200563512) 50 (1 2830320860 0 -1558102995768) 49 (1 -9059054346 0 3735989286408) 48 (1 23352309386 0 -381273241352) 47 (1 -46651654354 0 -41317930342608) 46 (1 64236756338 0 229646257166028) 45 (1 -28871590941 0 -845276716050976) 44 (1 -134398080099 0 2492163643688901) 43 (1 459184355769 0 -6266255573703564) 42 (1 -800595050760 0 13831135797954554) 41 (1 748989116551 0 -27213399044228664) 40 (1 179519591637 0 48121142249437401) 39 (1 -1987950394792 0 -76730788652728176) 38 (1 3658171840037 0 110232349753031706) 37 (1 -3397583328372 0 -141898380096710604) 36 (1 54249978263 0 161744114389979902) 35 (1 5190227733987 0 -159507682075098204) 34 (1 -8713332734648 0 129472607335062834) 33 (1 6917286294515 0 -75056034850751832) 32 (1 315658868113 0 10182513299911401) 31 (1 -8512399456274 0 44753891769796080) 30 (1 11643540780203 0 -71835796874025430) 29 (1 -7131088674129 0 65276926719339420) 28 (1 -1742977715620 0 -35319362148289707) 27 (1 8488557160148 0 2199389217288920) 26 (1 -8772457933356 0 16786026446381652) 25 (1 3589340274442 0 -17463689707638960) 24 (1 2342393877496 0 8127577100259800) 23 (1 -4920423266916 0 195336063910632) 22 (1 3566756201696 0 -2653475157814800) 21 (1 -614906882627 0 1309614951349328) 20 (1 -1373184591667 0 96559798589427) 19 (1 1549365239197 0 -231030174236652) 18 (1 -682044179678 0 -123728996005626) 17 (1 -121615007703 0 193224309825552) 16 (1 372641172307 0 -31047158986353) 15 (1 -230682514316 0 -60637794384032) 14 (1 33068562195 0 33986478726762) 13 (1 51342089572 0 3869157433332) 12 (1 -41679530185 0 -7116999811727) 11 (1 10887235780 0 -801253700328) 10 (1 3953349811 0 2027273375592) 9 (1 -4310971231 0 -9234999072) 8 (1 1262437160 0 -525356415888) 7 (1 170978932 0 118111663872) 6 (1 -241324042 0 54246786304) 5 (1 60792184 0 -14394716160) 4 (1 5127336 0 -8275104000) 3 (1 -5573376 0 2190080000) 2 (1 783520 0 1132800000) 1 (1 67200 0 -537600000) 0 (2 1 1 -16000 0 64000000)) 
  (svref *ec-g1* 61) 
    nil
  (svref *ec-g1* 67) 
    '(68 1 67 (3 -1 2 2231 1 -1068471 0 36709032) 66 (3 402 2 #x9d17c71b 1 #x812bf5c298e 0 #x198894c63f594) 65 (3 -75375 2 #xc6ecc2ae190 1 #x-a8a297c58c6edd0 0 #x6353e845cd17f74908) 64 (3 8766950 2 #x1eb74dbbfb3753 1 #x497ff30d8491ab3c2a 0 #xc12e4cccf371c55dc2a2) 63 (3 #x-2A4ECC4B 2 #x1114d75ec42ef104 1 #x-48ed858a7322c03142b0 0 #x5a6564b81a5d4a5920cac8) 62 (3 #x9e8ee03d0 2 #x17cbb82550838438e 1 #x1654623e6e33683672bc17 0 #x-f793f96e4d0177a3760aadc) 61 (3 #x-1c946d4ceaa 2 #x-44c880d56d9359f383 1 #x-392f377a275269357afda0c 0 #x-7427096033f123f0b7f826468) 60 (3 #x4112ab5b7c0e 2 #x-81796607aa79e8d733 1 #x5d1621b83d866552928dfcd2 0 #x2fc03158bec3e3db92d1472c24f) 59 (3 #x-7719fd113d8db 2 #x708cf9bf407fee4c8833 1 #x-6a02761846990bacdad2305c3 0 #x-8dfc3109333dcca7055086d445c0) 58 (3 #xb185cf99306ad6 2 #x-683b105367da17fdac36e 1 #x58d5d1d3bc11471017a163ea78 0 #x11711eb1bd11f83d6749214bebcd08) 57 (3 #x-d980bb4c1112107 2 #x15ab5c28a82874ddeacb56 1 #x-37f7172b09c8cb57ee8da076d50 0 #x-198d2a11516a99ea09705f34b998e70) 56 (3 #xdc70d47993879808 2 #x1f86c02a495e331398c8f4b 1 #x1a4f43528185ed108ce60c7f78ce 0 #x1da3cdd01e18ce505231446a5563e4dc) 55 (3 #x-b96f6ccf38195bbad 2 #x-200c754af75082840c82b865 1 #x-8b6fadfd4e29ee33908ab58645c4 0 #x-1c40e5bced4e1f80566d7dd1d79a10d70) 54 (3 #x8172a314c79bf232c8 2 #xdf5702f59298d355e6d22b4e 1 #x1a1cca26790433de8667d13a9ddcd 0 #x16b28f5083e2628fc10b93900952925828) 53 (3 #x-4a97bea444069e48ea5 2 #x-23ac2ecc99f66b3be46aea657 1 #x7e15a6de16184cdb2f6f4d7e5438 0 #x-fa733b6efdc6f572d66eaf72dfa43bb350) 52 (3 #x22f9086eb18774e5dfac 2 #x-ec60727ff6bb6e9539e224500 1 #x-5a04f5afb8b2253a05d99c3ed4b68 0 #x9660ae2b178243bd69fb1062aac522257af) 51 (3 #x-ce2f73692e54c56ef4fd 2 #xb46d153822db09acc409d67542 1 #x-2075a77e9d46e959f68382c1a8db6e1 0 #x-4f7dde1a6b286d7b9b7f3346ffb687b41ed8) 50 (3 #x3638b60e828ae829fcb48 2 #x-33025062ca189d58f96badbce39 1 #x22ee751cff84beda81a94d1d817eb4ae 0 #x2554689aea55221a47558f349ed7d0941d004) 49 (3 #x-649d6a35fa1517247c304 2 #x2b36bb9353ef5ac903db31dcc6c 1 #x-154f3c88b76d6cb30bb6553874d70b1b0 0 #x-fb0958083dab0dfeb7d21dd6cc8e031be96d8) 48 (3 #x-29e9ca9bb9ba813d27f05c 2 #x3ac7cfa8bc1b552811ad64045f49 1 #x96aedbb8983b0992fb4df085130c6386c 0 #x5f064a5458dc88a580c8c83af759f2839b3022) 47 (3 #x1f534c391577b1540e7cb61 2 #x-1bf91faf8e34c54acb6b96aaaceec 1 #x-3379213655d13217c77d69b86a0b7a6de0 0 #x-2090e432742a323aa1436355faa51daf5812cd8) 46 (3 #x-b100d3e44378d85617a3f04 2 #x76338bf2491b38f17f4e9ca0a3be6 1 #xd89a4e8ded0e09892e3a24521b53f5d151 0 #xa26795d38bee84f99e97c90ed8af962f4d0fc74) 45 (3 #x25fe8a89cda7ce59d975bedf 2 #x-179b54cea4f3336cbf8956cd3ecf37 1 #x-2769edb751b56d93e025273cd939100e58c 0 #x-2e36f11ce187abf9f3ce6500ed693ba3a83c0cc8) 44 (4 938 3 #x-2f3c50dace7530f76df361f8 2 #x57182211fa8c1f55f835e39d93f298 1 #x1e142e0d1d9a95b59892f67232d5eaad862 0 #xc0c045a5446a2658fe98cdb0de583c1758c8f5e1) 43 (4 394295 3 #x-15605c37dce133d9c3fc9089f 2 #x-1faec3efd9121908f38600edd971dc5 1 #x21c2d573c94de4d7c0018b7fe08526178b6f 0 #x-2e28ecb27fa81573622aa1aacd3e2f4ba1c431290) 42 (4 20338989 3 #xac002063d29c70a9e89ad4c24 2 #xca1f50b8416271c34662589b20f50ee 1 #x-121c320f9afd6f70805342c469206dd4abc3c 0 #xa2e51c286ef914bb0653cf608cae4d6a0c730fb60) 41 (4 #x-149BEC40 3 #x-2a301947948523cd16edd03835 2 #x-44be84e57f57a4c36c98354169fec142 1 #x61dd09a5e9a452773eebce2457b5867b5bd00 0 #x-212928640d0fece05dc4f83157058727c237e8b940) 40 (4 #x-d6bdf3ae 3 #x5b90ed1980a6a8646ce45df4b7 2 #x1387d60ae8fa8f4a376dfaff9f9544735 1 #x-1a471565723e8e43b2e60edb709e324839fd82 0 #x63e0743c773523d4b8421b4b182060e1aa3e6d4480) 39 (4 #x186e82c86c 3 #xc92a2d4de0a841980b50aa0c7 2 #x-4c843b713d6509a477ec3b4bb45033c19 1 #x5ffb8a089007deeff8db0fde396d9bf78cf9f4 0 #x-1169ce55f26a20f214b40272f514c0052a5b6568c00) 38 (4 #x-3e73b1b0aa 3 #x-3f372e25cbf284298a2178425bf 2 #x10b4b462c5f27b0e1c030871094c308e7e 1 #x-132f44e3f18e07fb20399121730331a285ab855 0 #x2d0d11df7b26d1653cbdc439bee46ccb94350164040) 37 (4 #x-1340fe30dfa6 3 #x12031d2cd52166eb2d6549960208 2 #x-35755bddb2f29986b831ddab3e03b4a6d9 1 #x368fab2b879495b2e7175a4fd3485a8724ab340 0 #x-6c3896ecad67ce97e9fa00e24bf5265e81e3786c600) 36 (4 #x20db315caf2f3 3 #x-2ebba7f2b93ae91530e99db8e937 2 #x9f5dd22cfeddd6b8aee4b262c0c7178d47 1 #x-8b42638ccdadecb97c38e86a67c38cc1354f92c 0 #xf19b94acd6b859b4823e09eb868c92b1a57dccbac00) 35 (4 #x-274f55f6fcd226 3 #x3be40a900723df7d6c46151b194f 2 #x-1bd5fbc42d2d4d381898d7cfa09c0758367 1 #x140bdf6312f802582b0272cc3ecc876bd3e9938c 0 #x-1f5af4675765eff6624abf4233228e9fb411161eb000) 34 (4 #x282187f6dca0056 3 #x55702143698e34167bc9e90d9f91 2 #x48cbca7ff25a4807acc2b3f4c708e47de00 1 #x-29cade887b3754b240178f7141feca71f0f99e98 0 #x3c972b8a0b3791de446a98e40b619584d3830cb00000) 33 (4 #x-23538a39d3ed83e5 3 #x-2d4cca114a0508174691fcdfea8f7 2 #x-b12bc76ce365b119fdbd47f15b42a1989c0 1 #x4ef62d912b22fa0a23d5d4263d8167148af75db0 0 #x-6d01b270394be847123801d99b19bc0ca5bb95f98000) 32 (4 #x1aaca31e5621e470b 3 #x8cbc94f4776c5a1cb876fb8e0e154 2 #x18f0d3e63431fb14fdabb0535fe0b07b9502 1 #x-87210462b0e4f67fcdf0264009b9a3a14406f302 0 #xb6a0c366660cb5f8681450107d7f4b3d3e8e7f80b000) 31 (4 #x-114f04e16d5a445e56 3 #x-110897628c5ab9bf2ebdb1ca088802 2 #x-33ca286dcd89d76a646de3dd5a609d4f1816 1 #xd0e9f8b954685a7a38a50bc0decefce2eb0abfc0 0 #x-11cf71b4306e0b2a9a82afcd975ab6bee633c772e0000) 30 (4 #x9b3f7e1ae78cd1825d 3 #x115d2dadac1031b1db4e08d5d423ab 2 #x62fbc953c689d4c5bba1d49bf95e2831e78c 1 #x-12235418e55426bd84921182022d4d4d39bce1d40 0 #x19e19637bceaa735741edff35192c4054a52ffe9c0000) 29 (4 #x-4b9cb50a76845439aa1 3 #xf771aef5b47e07ee3de93638a3d8c 2 #x-ae27c136b4c7a77d280aa9e086c3d010d0be 1 #x1668e5b074d564327969f7b030829fdb226b0a640 0 #x-2304b4a076a5e86c257b6ee770777c252ae1b029c0000) 28 (4 #x202889e907e5a07295ff 3 #x-75140d9023b1a19e7157852ae99314 2 #x11a73bbe7afd0edffdccc8072ff25d3a80f9b 1 #x-1826596b0f25bc9c9ef131d79cf1951563218e980 0 #x2c19ef1fd52a8743e3124c13bbb78b167176976d80000) 27 (4 #x-bff4d9265f8308856e9a 3 #x1310b01a16364a3d8fd4d88800ff620 2 #x-1a7109b1e8ac9372cddb472be5607dcd35160 1 #x15c20f71e07eb5e10f4575216a8dbcfa71dfb7000 0 #x-33ab27d3acd254d9d3cf6673d9045ef81f88627000000) 26 (4 #x3f1104a3599ee09d30fd6 3 #x-2103ef33753bd2c884e8b0f7edc1e23 2 #x24a516a3e2d9723c7851ab14a86a55761878e 1 #x-e860e434c7f341acec2593a1b0978457788e7f80 0 #x3846c20b9e173bbd6dad1e1638da770b0e92ac24c0000) 25 (4 #x-124fa9e4cff2ad5197b87d 3 #x273fef67491ed25a8055f718a093557 2 #x-2f0da5fb3e1b8f4bca9c3aadb0ab7ad5b8f00 1 #x336fece1c1c18d3b318efe81def0a2647c4ecc00 0 #x-38ef6ed7ebaad9f5d2cb26681f7c78b2bfb02cbe00000) 24 (4 #x4b677e172ea41899671d23 3 #x-1711ea54e80b33140e97fea92d8186d 2 #x3800e3a49a631591c3203aca5f01514c3a2fa 1 #x9e809f519ac63c12ed1bc9255bdeeb7528f8b800 0 #x35731321b845fd044de1bdfa011445f8f3e3d7ec00000) 23 (4 #x-113f5779d4e2a93d69a2113 3 #x-1ab08c3318164d07ed38128209e2efa 2 #x-3dbe6b58b49a14c86cad7ad48dcf38ba5c974 1 #x-15c89d839b10821f7121ac1612ea91b5575491000 0 #x-2e80bb121e5ede36adf67f27f7bd1f4dd3f5679000000) 22 (5 67 4 #x3837e5ef778794ff9fa3fb5 3 #x6a77ef6f5c666d2a8fd0b26d54e669e 2 #x3ef01a59d6467e31d50b8b452273d9e38b1a4 1 #x1db41bb1cc7d21497dc42337e32fa49dd536a2000 0 #x25713e45279cf48a267ff060c7a040a79e94484000000) 21 (5 2077 4 #x-a37ca2c90174835c95db30d 3 #x-c0b6b90663582d2fdf5dcc0548ee9bc 2 #x-3b23990b175d195b9941aae8772e9a81ffce8 1 #x-204d76d32ca794a3b0e43120bb2f21a73dd9e0000 0 #x-1bda46b927fae27ec567302f66caa4ca620df50000000) 20 (5 200866 4 #x1a8b5ca80a96450e4a2355d3 3 #xfa0dbfa74c6a0bb5a711632efbf2355 2 #x3306374377b242ce69f047ec71cb2bf9a0be1 1 #x1def12cec70ba8b74b2050dd72d674f6e33a20000 0 #x131ae2140a107409b3db30a36e91961bf1af680000000) 19 (5 -2674506 4 #x-3da6eabdb8433b31f28117fb 3 #x-fab736fc3dbb0653c804c41667b640f 2 #x-283bf78cb0e6d7c6f27742f3450c0a105bbb0 1 #x-1843f80d9f4b82f5ee4cec38fdc56bbc4e5980000 0 #x-c0e90424bed6e3fbcf2181368062f2bca59100000000) 18 (5 -36286597 4 #x8011ee6032944caab9c638cb 3 #xc040ea4c1b22d88ebadbe551ca0bf52 2 #x1cd80352194e8f1f6ef6521cdbdba32415d60 1 #x116ab300d59d390ff17968303770427eccf400000 0 #x6fb865b4b37d33f30e307e084ebd9c18333400000000) 17 (5 #x40467A45 4 #x-edeae1067ed033a9ec357e4e 3 #x-63ca9ee490960146e057f5c6287e129 2 #x-12b106e989f871f692452af318cb80567f5c0 1 #x-b21814800e5d932fd43eba3f14665c44f0800000 0 #x-3b32c10311e610315f5bb626668ac148a30000000000) 16 (5 #x-296dcc938 4 #x18b048097c60bb4ee3f25c2e1 3 #xa9caea69e42b25218d9df25b5883f4 2 #xae158e80958f677df5617271d2c2396c4000 1 #x658c917b42bddee2f3722cc816ad3556f6000000 0 #x1c9a1a347c36b29b4a42a426cca50a00ecc000000000) 15 (5 #xebceeb78b 4 #x-2497ad2a552c0cfad1d8d46eb 3 #x2f1c376fd2f2d51c49927234dddbe44 2 #x-5a65d7aae7c33daeb46a3921bb0cf15cc000 1 #x-33a66d011c9bd469f689b661ae751cca00000000 0 #x-c8cf1f32cc01861826394b4b2043c2f3f0000000000) 14 (5 #x-2c4c1e3132 4 #x3054aae0ad93045d6994a2afe 3 #x-4242dc85366bda472b3238788402f82 2 #x298e9707331d3e3001300b7b8076ae153000 1 #x1763e25ead5450846bab05d9a3b0c1d6e0000000 0 #x4fa79e6e7cc87cd5bbeac3bb179c5d5ec0000000000) 13 (5 #x-5dc9c2606 4 #x-38be94a2b03662d471457c12c 3 #x39a7b55425942d287ab3106845359b0 2 #x-10c56850e985c5eef48a9302eb63dfd40000 1 #x-966c94e5ad46e921431e12dcec34e9a80000000 0 #x-1c682a7e69916611226436b48736f76900000000000) 12 (5 #x308ea572137 4 #x3b07ed9d2b3d8184b19926f44 3 #x-261ee205ccb4554ccc2293608d30aa0 2 #x5e37f6d14fa0f6aac97edc464032d1e0000 1 #x356f741a06be848c4572d649831fabc00000000 0 #x90c81874255a34c824c54cee4e3534000000000000) 11 (5 #x-1131793ca99f 4 #x-362f217735ef62679189f1ea0 3 #x14294325eb1c807039d3aef8ac87480 2 #x-1c8a63d4c93a947317c6bff0993f1d40000 1 #x-10aff2d45b3cdb8e452f7c37c8ce20800000000 0 #x-28df8b9597122a61eceee059d425af000000000000) 10 (5 #x3b810f4cf5ad 4 #x2ba652ca5b89b55e11e3c066a 3 #x-8a03c0413ef6c7c438a525e1875000 2 #x76cc94df9492faf7284daaad3185c00000 1 #x48d82209e2ca856dbea6cf4565168000000000 0 #xa20feab84a85f137d8a2764e04370000000000000) 9 (5 #x-94fb14c51d31 4 #x-1ea715b4a1020b851935cea4c 3 #x2f486f6a28b73caf8282a00ee53800 2 #x-1ac274851c6a632418aa3bb4c8b1000000 1 #x-113d4efc80195dfdbe4ce9ae47200000000000 0 #x-22d5d3fc288bd1aedb85cebc6e2c0000000000000) 8 (5 #x11c83a1f248d5 4 #x129a7a58ee358d5406f82e3e1 3 #x-c86b1be7e0792064548d262520000 2 #x56b33e3b35b1ed3bdd85cdbfff0000000 1 #x382d93ec14a44c1ac2686e0f5200000000000 0 #x6658abc7aba9918b4ea57cef1c00000000000000) 7 (5 #x-1a6b685fe355b 4 #x-9a68552e577c87b2a88d98c0 3 #x256ce88e4c91e2d575c5d2a060000 2 #x-11056f2e7e1a9286597cfd954c0000000 1 #x-9c26b9425f7ba53ff223993b000000000000 0 #x-fbc43de32e7e38dda8d1cf59000000000000000) 6 (5 #x1ea8fd9d65a23 4 #x437abab718ddae4c31431040 3 #x-351af8b39c49365032b78a800000 2 #x36e48b9aed41ee7e4aa0d08400000000 1 #x16e4aed5ababe5d2553b9a78000000000000 0 #x1f86f9bbce4e024bb9106cd0000000000000000) 5 (5 #x-1b98ac34ed0e4 4 #x-185dd170b868a50764bb5000 3 #x-97ed583eddb96ffeccc0b800000 2 #x-ac659a700f8314682c40a3000000000 1 #x-2ca25d8a0396c0c25867600000000000000 0 #x-316baf1789c9756ee69cb40000000000000000) 4 (5 #x12eabb9bc31fe 4 #x713801cd86e006cdf36b000 3 #x4dfab8763d7ddae9abde0000000 2 #x1cf031d951f326f4f32f70000000000 1 #x466727ac49fd4ef9f59200000000000000 0 #x38dbcfd0820efd9067f400000000000000000) 3 (5 #x-98dc56e6ca80 4 #x-1969bc412e4b41866840000 3 #x-1046239b056c4a4f34ae0000000 2 #x-3acec34f3afbdcaefd900000000000 1 #x-551b91a82d933636da800000000000000 0 #x-2ab50cc0385443b1ec000000000000000000) 2 (5 #x35a660e9d080 4 #x4233d4a4158c477e8c0000 3 #x20aa0888c09f223af000000000 2 #x50e4e6e85af497d6a000000000000 1 #x463bdd4f4a02d7fc0000000000000000 0 #xfb7fac9fa080f8c0000000000000000000) 1 (5 #x-bb058564800 4 #x-6f4f9758b8f1a0c000000 3 #x-26fc974cb2bc99e0000000000 2 #x-40a33f445f864900000000000000 1 #x-1d6f2fc6d6eb6000000000000000000) 0 (6 1 5 #x130bb040000 4 #x5aaf2cacb99780000000 3 #x1607a4ac6667000000000000 2 #x156822bf27f1000000000000000)) 
  (svref *ec-g1* 71) 
    '(72 1 71 (1 -1 0 672) 70 (1 71 0 146544) 69 (1 -2414 0 9453224) 68 (1 52327 0 #x-BA1AF10) 67 (1 -812240 0 #x44D25050) 66 (1 9613968 0 #x782C81D4) 65 (1 -90223321 0 #x-f0b61e940) 64 (1 689157169 0 #x56cafe8110) 63 (1 #x-10425c7b3 0 #x-9e70c3d9c8) 62 (1 #x5688a4845 0 #x-3acd84bddf0) 61 (1 #x-186de7ed2c 0 #x221ff62f4310) 60 (1 #x5e541f8fb5 0 #x-8f8b68a30b1e) 59 (1 #x-138e988bb4f 0 #x15918fcf3c120) 58 (1 #x37e58dfae8d 0 #x-5866562677b0) 57 (1 #x-89ba831721c 0 #x-f0a33a2210e08) 56 (1 #x123cc56f6905 0 #x5d5bb5ea1cb3d0) 55 (1 #x-20f58ffcb068 0 #x-1812decad5ed050) 54 (1 #x31db24d850e1 0 #x50afe428d3c6d84) 53 (1 #x-3c391ff99fff 0 #x-ea83904fe41ef00) 52 (1 #x31e6edb560ef 0 #x261d33b572d7ad30) 51 (1 #x-4aae2e8cd05 0 #x-5a4a6ab8e86ccbd8) 50 (1 #x-4f95ae213e65 0 #xc525ccf0e7bce230) 49 (1 #xba90fd3ae930 0 #x-18ffdbe6a0b151690) 48 (1 #x-1151fffc0c4dc 0 #x2f691641e7d5dfe0f) 47 (1 #x12cb8a5e2c656 0 #x-546ca718718bafcc0) 46 (1 #x-db60fcc2b6ca 0 #x8daa0e02a8fad1360) 45 (1 #x2100cdd9fccc 0 #x-e0a68ccc772f796f0) 44 (1 #xd18b0930d3d6 0 #x1517c7e7f913678860) 43 (1 #x-1a7d8c41cc7e0 0 #x-1e148c2f10a4f496e0) 42 (1 #x20cbfa9e13e24 0 #x28cb98aa3488d688a8) 41 (1 #x-1d2003d51e73a 0 #x-34b3aa0f64661dd780) 40 (1 #x1079bb6050fca 0 #x40f2b084cec2c9fba0) 39 (1 #xa224c72f042 0 #x-4c74b5d2b401f2f650) 38 (1 #x-102c49a2dd8ee 0 #x5613bd4be3f933a5a0) 37 (1 #x19309839e4f78 0 #x-5cc895cca0aaa94160) 36 (1 #x-19af5eb3b69dc 0 #x5fd93a0a10e96538dc) 35 (1 #x12fc7c291f482 0 #x-5ef9704f684bfa1ec0) 34 (1 #x-8a93e9332ae6 0 #x5a55efaee62afa6ba0) 33 (1 #x-1479c3e6f7d8 0 #x-528823dd806dc7cb90) 32 (1 #x7f5c1872d26a 0 #x4876bb77279b355aa0) 31 (1 #x-a60eb806f7a0 0 #x-3d2b92d76471c914a0) 30 (1 #x938d37ce27ba 0 #x31a91d32e146355ca8) 29 (1 #x-6171700cdb5e 0 #x-26c80e6302cdecf700) 28 (1 #x2a23aa07c66e 0 #x1d22985aa0f6764760) 27 (1 #x6d0e41e74e 0 #x-150e6e0484d4ac6e30) 26 (1 #x-178ec788017a 0 #xea336761c12bc4160) 25 (1 #x1d6fbd8e40c0 0 #x-9c900103e5078fb20) 24 (1 #x-18900c8cac4a 0 #x649c7a5709a628f2f) 23 (1 #xfa90068693b 0 #x-3e1f9bb001bbcfde0) 22 (1 #x-75e78e0f92d 0 #x24d5842d5bdb14f30) 21 (1 #x1c16f234742 0 #x-14f4a26edae808d38) 20 (1 #x10b2ba202d3 0 #xb6dda6c6e9c23db0) 19 (1 #x-1d6868b6c30 0 #x-5f81d60bc0637270) 18 (1 #x198603d904c 0 #x2fb4c7e7f9ad0984) 17 (1 #x-108a853bfdd 0 #x-16c183db58bb4140) 16 (1 #x8845a313d5 0 #xa58e86ab4701450) 15 (1 #x-35aed9372f 0 #x-479cc43089de868) 14 (1 #xc6e0687b9 0 #x1d650d5b695e950) 13 (1 #x2c2e75474 0 #x-b6a8e8d2840ab0) 12 (1 #x-580d077d1 0 #x42e36199de3e62) 11 (1 #x41410fc3d 0 #x-16ff3b729b6a60) 10 (1 #x-23345e5f7 0 #x7629ac56a6d10) 9 (1 #xf3c5af54 0 #x-233744f2f40e8) 8 (1 #x-55F2CC7F 0 #x9a936186da90) 7 (1 399596520 0 #x-269fca38a210) 6 (1 -75190491 0 #x8aabecf59d4) 5 (1 2486349 0 #x-1b6737c5800) 4 (1 4854483 0 #x4a2cda7a70) 3 (1 -2263977 0 #x-a47920d78) 2 (1 603855 0 #x115a82b70) 1 (1 -97200 0 #x-138DA550) 0 (2 1 1 6750 0 11390625)) 
  (svref *ec-g1* 73) 
    nil
  (svref *ec-g1* 79) 
    '(80 1 79 (2 -1 1 1487 0 -159184) 78 (2 158 1 42949456 0 #x1f7cf60f8) 77 (2 -11850 1 #x878daf644 0 #x-88743d10e678) 76 (2 561374 1 #x3be707c3fd8 0 #x3c3849afd1d024) 75 (2 -18856273 1 #x37e8c25abf4b 0 #x-9ddeffe6e52a360) 74 (2 477855279 1 #x-592cb9210c316 0 #xbbd15e867bcece0c) 73 (2 #x-235b3a83c 1 #x-6aaacdad5878d 0 #x-693fce1f41976b500) 72 (2 #x2344e8bdb5 1 #x2d6b90655f18a47 0 #x232514142ef4c8fbea) 71 (2 #x-1cc156d1e16 1 #x-150c7ebcc4d3f628 0 #x-90b5ab2dd3eab3af68) 70 (2 #x13615d953a3e 1 #xfbc382ffb3db7a1 0 #x21d0325d6a4680e50c8) 69 (2 #x-adfa3914dcad 1 #x2493c5b8909127d9a 0 #x-64245c919ff27fc63f0) 68 (2 #x5183fcca07374 1 #x-dab7bad25bad5c2de 0 #xb1dd9a36f2d2cb57816) 67 (2 #x-1fdddb7ff52b27 1 #x191fdea695b724d3c0 0 #x-595d289afe3d8c5a580) 66 (2 #xa54e3ccd1cc498 1 #x403c5bdf59cd4ffdf2 0 #x-21b9e109c8ab6ea2b840) 65 (2 #x-2bd54da12475f7f 1 #x-18e7e1b2a079e72fd14 0 #xdb6c838ea95c8c689138) 64 (2 #x93ba891d1d79065 1 #x1a229cb67909cb9c4fb 0 #x-312069ec0b7fc4a8a9cd5) 63 (2 #x-171a855d10bead54 1 #x778fd438ebfb9b28108 0 #x434414178e0a55c5c7c60) 62 (2 #x224dcd096dbff686 1 #x-1834e1c416d859e72c3e 0 #x64ceb1abeebc829d49684) 61 (2 #xf51ac61d54774ce 1 #x1f77e28671be1872681 0 #x-1e29c47daa1b2c7d646d68) 60 (2 #x-fae54642125ce249 1 #x6b5c5ece205426368d06 0 #x37b10c9aea44b966d0ee4c) 59 (2 #x2b485aef119b97f13 1 #x-94279879a07e73db2e95 0 #x-7895233046c1992a873398) 58 (2 #x-2bfc109de365795d7 1 #x-d3abb13d886ef9c892ca 0 #x41b81425ddb1ff1cbbfd0c) 57 (2 #x-53da72c06e50d0501 1 #x29bae56fa638863963cff 0 #x428ca95e3e0293e06ef8890) 56 (2 #x175e300780ddeeb0f1 1 #x5acdcaa7755d9b70700f 0 #x-bd7905cd7a70552babdb6f5) 55 (2 #x-1c42ad2ebf7a5a65c8 1 #x-7697972d61778b3132565 0 #x-25957124e5e8496e86d5da8) 54 (2 #x-1df11d87edd5ebc7bc 1 #x38967e5004a91b8d28bea 0 #x393d8f3cbfb174d3aa6b6010) 53 (2 #x909c947ba290b98c9a 1 #x10a7f74649674c32ebc922 0 #x-3d88497c5e7cc26f8f342770) 52 (2 #x-8649ac27dd8e31315f 1 #x-124a4c1610ca50699003d6 0 #x-77f712f517c831ebce547826) 51 (2 #x-dc1e71049faa3bd05f 1 #x-193ac2e11893c7f86cdd40 0 #x11c64ca705f341705fdec6630) 50 (2 #x28213c1c790fee799c7 1 #x33bef95b3b32ec40c293ea 0 #x400d4832ac0dd7586f559fa0) 49 (2 #x-dec93038320de454db 1 #x9e9488052216b5577cb3c 0 #x-2965da3f4d19ec40fb28b7db8) 48 (2 #x-4caa1b495af1331b8fd 1 #x-4fc423a70b16a850dcd88d 0 #x10df52e9cd7551c92b09726eb) 47 (2 #x69e3435dd91f7689d06 1 #x28767580098c524a2ba396 0 #x402e5611aa464969607fd1020) 46 (2 #x37695145605e053674c 1 #x1d46f1253032340c471dd0 0 #x-34223fa57d6c22ee29d17e8e4) 45 (2 #x-f0bcf2d76dc0a562780 1 #x-2788f4e4f70983b9a71c7d 0 #x-523249b9771ad6953ab464a98) 44 (2 #x57bbaef1243eb5de157 1 #x74e63ef5202414fcc6a9f6 0 #x5fc4de565f5e82d0dc6a94a0c) 43 (2 #x1414a5f6cdb7b4752cf7 1 #x-b869865014d757f4c8ea03 0 #x64fc6b690e9ef1d6a098f8998) 42 (2 #x-14ab36704ef1005a6945 1 #x-a058ea506cfed9d5c7de2e 0 #x-9d45cba627a9ddae9caba89cc) 41 (2 #x-f9e5ea9edd9ccb7af09 1 #x27ba4f346d5e098d987cba1 0 #x-6835fd4293491982c44affab0) 40 (2 #x2215a815ff41203f0057 1 #x-c715c6625c2c3728e515b5 0 #xe5996e18e7b06af035888da8b) 39 (3 79 2 #x281d0727e8d8e6bf5b2 1 #x-3ae838cf45a35dbc345d635 0 #x4483929de11f7a2b8a19ecfc8) 38 (3 14536 2 #x-25a4bc972921a7204204 1 #x39ad25ff5118ec889a7d12e 0 #x-10eea5cce78dd436932508c210) 37 (3 366560 2 #xb10c120519e9965b5c4 1 #x29b6633c15a62c7146a688a 0 #x-10dbee28c4c2fc4fe80df15e0) 36 (3 -2618376 2 #x1eb9c7db43743d7443f1 1 #x-5bf769d6bf004ae8523fc14 0 #x10daa973eb7922aea08df53cf6) 35 (3 -37496639 2 #x-1133c4ba3fecbea3e08d 1 #x667ee29ab8f2f658819a8a 0 #x-14bf32e0a18ee3392915b65d0) 34 (3 371395590 2 #x-13c6ad4670727cc3023f 1 #x543b0e795362bff831c9e9a 0 #x-fdc0c001551eb1f1d6775c718) 33 (3 #x-BBE6081 2 #xefdeee0e7b550ce4f27 1 #x-2ea471b17d52b68dba98232 0 #x3c5ac3b8ff2d43f83dc03c3f8) 32 (3 #x-2326ac6cd 2 #xb3bd25fafc663c143dd 1 #x-2ba3fdfe5dddebc40171341 0 #xd9273d28c1cb8a4a04a17b5ca) 31 (3 #x92104bdbf 2 #x-92d028badf09f3d8f5d 1 #x32a23039e970617233db569 0 #x-65f83595b7853c6d5037b96e0) 30 (3 862075413 2 #x-6b8d3159855c7337930 1 #x70621e50de2cea8f512016 0 #x-914d35e16759b181c06e3fe94) 29 (3 #x-5ad579070e 2 #x44fd59e44c0b3797e2a 1 #x-1cfd362ce3e25c7d67cbfab 0 #x6d77af97656609f7420485e20) 28 (3 #xcdc1618c2a 2 #x47a3ef4c4b8704609cb 1 #x4c789b7232ea0b556746e8 0 #x49ab2e6604450faa1b20bf364) 27 (3 #x94e09973af 2 #x-1b775895e63078fe152 1 #x9426e1970be159e9f7297a 0 #x-5572b2e4b8f27f6bb98c3d438) 26 (3 #x-4f5a25af96e 2 #x-2dabf5304eea4c76b24 1 #x-fdfdeaeb749a181c742b4 0 #x-1fbf512fbe71347a7ea146cb8) 25 (3 #x4fed7e3b749 2 #xa158dacdf44e5244a5 1 #x-2b39ef3bb3a0bc6b2f6c62 0 #x3de3b35f71a53073c5c4f50c0) 24 (3 #xa62cf5cb25e 2 #x18551646351b8459e02 1 #x-272c5bdf04e95e78e46e0c 0 #x60b14abb03c954db89f73201) 23 (3 #x-1a6a6345a453 2 #x-2fedd472473faef54e 1 #x2b3e0ace374d66e9e8eaf5 0 #x-29fe497b5acb3bacd16232c90) 22 (3 #x1d9a3e7c3a1 2 #x-a68dcb43351656b3ac 1 #x19d9c2f9e24a067309a38f 0 #xbafe4f9a3ae9e5cb12378f90) 21 (3 #x357ef6c443d9 2 #x33208b0784fe22d17 1 #x-242a5aee7589451f794792 0 #x132f2b9cebdc6cfa8ef63fcc0) 20 (3 #x-2fba970fb9de 2 #x3a6d7faf0d85f0f707 1 #x-1ff224520d6dc57549f46 0 #x-e83c8f8eeecaa53087b480e0) 19 (3 #x-2e97ffb9a5bd 2 #x75673dc4f22531606 1 #xf0c60aa074bfbaa7096c8 0 #x-28b7a85f8dd1fee1930f6700) 18 (3 #x5ed22bf26422 2 #x-11abdc7c6c14d4dc3d 1 #x-304fa09cfbc2b772fc704 0 #x7628f62b123a40bd22ad7500) 17 (3 #x-5646e228e7b 2 #x-51a451d3272c9fafa 1 #x-2cd150cc93de1e2a475f0 0 #x-25566932f276d88433994c00) 16 (3 #x-59cac4136300 2 #x4c814160ad9abeee3 1 #x6b1e0daed9cefd1aadb0 0 #x-190b8d8a3617523d85b58100) 15 (3 #x32acc847d936 2 #x1e8368c0f52dfa054 1 #x6a619233752e35b28200 0 #x169cef86718724bde1326000) 14 (3 #x288fcc591cfd 2 #x-12bd075eb32c48004 1 #x7079d5de0b7cb8b97500 0 #x-22bc8f9b07e321dc4aee000) 13 (3 #x-30866f2dcfff 2 #x-6e7cb5a4b2d56490 1 #x-5d38e267caceb86a1000 0 #x-506d913222e15b87ac88000) 12 (3 #x-19a5953cd37 2 #x419e41a6875a6356 1 #x-1e32f49af74c12c54800 0 #x270d128c5b93e582f2bc000) 11 (3 #x15ac8fec2983 2 #x283e1a3946d44d0 1 #x298b94a9253c105e1000 0 #x2c6747db3627022d1a0000) 10 (3 #x-6ce3e548a21 2 #x-31d4faee06ca010 1 #x-4ca2409b0a8651ff800 0 #x-87321298e61586a1260000) 9 (3 #x-4507107672a 2 #x579890d6d8ef7c0 1 #x-66a3b714a6eb1982000 0 #x256a04b3adc7a3e6280000) 8 (3 #x2e7ced271c2 2 #x-7a221f8a6e52e60 1 #x20702355e55840a2000 0 #x8db47619a63e74b0f0000) 7 (3 #xd369e2d78 2 #x2f224f07a6ed600 1 #x4e251f5655222d0000 0 #x-7b28e769ec08edcd00000) 6 (3 #x-7341390064 2 #x117b81293306e00 1 #x-24ec817666089a0000 0 #x11ca70f4c7f2c47500000) 5 (3 #x185bad9dd0 2 #x-1b2a919b8359800 1 #x-b6f64b6554e360000 0 #x7dd54d79e0818fc00000) 4 (3 #x49c520ef0 2 #xe7c1cbc3986a00 1 #x472210d28bf460000 0 #x-372c8cae8bf7fce00000) 3 (3 #x-22ab6d200 2 #x-492f53015c7000 1 #x114217dc7d4e80000 0 #x3a754ae655df5000000) 2 (3 653027904 2 #xe683ae0af7000 1 #x-b7d95acc6fa40000 0 #x2479e5a1ddd29000000) 1 (3 95558400 2 #x-1a46080cf4000 1 #x203174c3e5900000 0 #x-96fb27d593dc000000) 0 (4 1 3 -9669888 2 #x1549a3bb6000 1 #x-1f7fba647500000 0 #xbaaae21f551000000)) 
  (svref *ec-g1* 83) 
    '(84 1 83 (2 -1 1 1487 0 -159192) 82 (2 166 1 42937560 0 #x1f7e2cfcc) 81 (2 -13197 1 #x86461fde2 0 #x-8883fc558d44) 80 (2 669561 1 #x37b7b830424 0 #x407c8d01bc06fa) 79 (2 -24377515 1 #x1c9e9e344657 0 #x-beae48698866790) 78 (2 679087989 1 #x-635aac8a2edb9 0 #x11e8f48324e556b26) 77 (2 #x-3826ba9d5 1 #x30f43905978eeb 0 #x-ff0a5830460c9cde0) 76 (2 #x3fd3d9aa5f 1 #x11d71f027f81da8 0 #xa5032c32b7046f62ef) 75 (2 #x-3caf992b398 1 #x-22bf6d845aa4b1d9 0 #x-55a43b15423cad408cc) 74 (2 #x31084fa4af1b 1 #x15ebe9611f8f38b22 0 #x258ee59a080d8099b8ec) 73 (2 #x-22188ac4333f6 1 #x-84b3792d4e3ba5c80 0 #x-e58b0e3cd3a0423ce4fc) 72 (2 #x149eb2d5278510 1 #x1ddf75dd6acaa835bb 0 #x4de02ea96a127f03b305b) 71 (2 #x-af11f2d65da257 1 #x-eea0dfd0d45b67488 0 #x-17c832e46370e83ff82258) 70 (2 #x5225057817c155c 1 #x-298a2502d385ec1d43d 0 #x699748b473f6566505a492) 69 (2 #x-22503cb9dc5a9187 1 #x16cd44d005cd0dd88c77 0 #x-1ace245b50c47be2abe5f50) 68 (2 #xcd6bb6e2904b25f7 1 #x-8040b38c11bf94136837 0 #x6414c8bb71e99282734a3c5) 67 (2 #x-453b226b466e3616c 1 #x23a068755aa4946d56b7b 0 #x-158a46e0cf0e841eeb8f2bb4) 66 (2 #x151fcdf7fd2a734bb5 1 #x-8619c137e5b4009e34549 0 #x4491aed5f19e44d6d84000a4) 65 (2 #x-5dd0b0257c5010000a 1 #x1baaa35a59074526d2f8e4 0 #x-ca0c3bd15c636f24af2c79dc) 64 (2 #x17cb40a31d509f6ea40 1 #x-51e42dbbe4bd9c5b14cdea 0 #x2276704fa2fa01573ba4fc24b) 63 (2 #x-58985da56e7c199b574 1 #xdd04b047d524534b9354a2 0 #x-57186e42de7fa01410263ba68) 62 (2 #x12fddfd9762b31ca67a4 1 #x-227c847ad8a00192d7b04ec 0 #xcbad8d40de0c59e88e942ff12) 61 (2 #x-3c3953443eb3d96ebbea 1 #x50b8d779bf845511f35c21f 0 #x-1b82597685bc5b771726475b88) 60 (2 #xb12e3bea972e69c2cdca 1 #x-b378d5b343bd4a486683834 0 #x36d27569e063e5a04bbe88e7c4) 59 (2 #x-1e535d8c4142ad0ba6f4d 1 #x17f9905e39a2072b374862fc 0 #x-647921da25b758832920e1c09c) 58 (2 #x4d8aadc57a3f7b26a1986 1 #x-31bc7c7140c4882182df768c 0 #xa8b73618b40b0430fa5a0c21a4) 57 (2 #x-b9ab6652370d36c1825c1 1 #x64b2c134bad5f15a00d8dd54 0 #x-10256daa6ddd9e6e0eb93de8308) 56 (2 #x1a17758f16581e481e9763 1 #x-c714a41d5f2e990fe920703f 0 #x16692c32ae4928a319edb3e51a7) 55 (2 #x-373b220a909d90043dbf24 1 #x17ecb89c34a95105b01cafe57 0 #x-1c040334db0985874ac5ea4fb40) 54 (2 #x6e565c7f49675607c1af77 1 #x-2c6f86a4f1f89dc1be7d45c1e 0 #x1f6cd59f6f5bb80465ab9dd075c) 53 (2 #x-d080bc4660c3542645ce7e 1 #x4f166f78ad1bb218d3edb4c80 0 #x-1ff921690b0912ab51778190520) 52 (2 #x1757d5bf48db85d18a2583a 1 #x-85d5af9cc17e7ee97a91d02fd 0 #x1f53133255b46a8148d88725357) 51 (2 #x-27b754c39872632fc0c220d 1 #xd5c00b157815025087b094437 0 #x-2273c35d920b8ce1fa1e59385d0) 50 (2 #x404d2e0e7af1636f705f1e4 1 #x-13fdbebff89a1e9a80fb6a711d 0 #x30e8ed1f7a1f34f64817af68b44) 49 (2 #x-633c2e5f095c35593639a37 1 #x1bccca473a46312840de8c26a2 0 #x-519b858a1bd3b0e595f0afd88cc) 48 (2 #x92369d6e91f94c6aca9efb3 1 #x-2387f6a5c8967563c778541987 0 #x85c309a586a5c1e12d69cca7374) 47 (2 #x-cdfa0bf8b2696d1d2afda1a 1 #x28ff7331ac377554f95babbce9 0 #x-c4a3ae83c04322160308becca40) 46 (2 #x115cda728d4ab70caca212fd 1 #x-293a957cdb067f3d73a9db5784 0 #xfbc19dc1ce7ba35b10b0f4da1c2) 45 (2 #x-16725a499b6310e15987e446 1 #x21009edbd6ef67f9a702b7411d 0 #x-115e2efeb785765da05a1aa0b830) 44 (2 #x1bd8e147818a62dd26ffd5a8 1 #x-dbc27d9f1d50493b6db239aa9 0 #x107512430efde5a1db59f6b6040b) 43 (2 #x-212f40e3c14c8f817ec72eb6 1 #x-117cde838cc67036e747717087 0 #x-d92a611ad0a0845059a5c8564b4) 42 (2 #x2604f3614c28d64659f71d14 1 #x3b1729b27e8cd59989b3a449e7 0 #xab9cb1266d53b18eb9dc79a9204) 41 (3 83 2 #x-29e9457d74b124726af514fa 1 #x-6ac55f02b947feaad038846550 0 #x-aa3caf83e29d854a1202ca0317c) 40 (3 17181 2 #x2c7c3f36f3763c319b084f0f 1 #x9a11a43315786893a26355622e 0 #xf5ac27e1979885e1bd389c0ee05) 39 (3 528378 2 #x-2d7dc6d90058d6cdb086b2e6 1 #x-c1aed97d8b47f420bf35ab9054 0 #x-18dedd8b34d841f30b6124ccc5f8) 38 (3 -1790559 2 #x2cd7b60936b873fbe45ccfba 1 #xdb2ee69fe362a7820ca8dde9e8 0 #x24b1e41ff4bb88b81d590a28dc72) 37 (3 -51218387 2 #x-2aa0baf1c88b3fa9a09c9292 1 #x-e295db924b152bb2de5b34e74d 0 #x-2ebcb470a3f31eea997464f2be10) 36 (3 434554219 2 #x271793304b45552bcd29be3e 1 #xd748a258d6fb3ac957b7bd51c6 0 #x333ac10cf53bbffc3da407b1d33b) 35 (3 #x-34A31940 2 #x-2297f16db194f4c6214d182a 1 #x-bc0f9c81df8473e1a9835b7039 0 #x-30ab4b3ab04993f1d37c79116584) 34 (3 #x-1444c90fd 2 #x1d8bb0e0ffadcfb215fa277a 1 #x963889b3b83908a119951b0cce 0 #x28ae0dd095bda5fb7acf4c7f82cc) 33 (3 #xb0bd79d61 2 #x-185b86cab78d579d85699d7c 1 #x-6c2c476a5d22daec16e149c4e8 0 #x-1f45aafc8dc935d3865987e43c74) 32 (3 #x-2bde4a1c88 2 #x136218156953a6b6e90b1f14 1 #x43f0702d30f2d280f037d588c9 0 #x18e46a78ea27ed85c1547a7a20cf) 31 (3 #x729b3a82cf 2 #x-ee368d264c7c48a560a01af 1 #x-2201c8d27ffb8010d5e25052ea 0 #x-18540d820d860c6a7d123fbbfc48) 30 (3 #x-d097ef5a1c 2 #xb095d455b7ef6019da7ef34 1 #x8c6306727f058e9c31a149c7d 0 #x1d8f23f7fbad6752ee81516c4f96) 29 (3 #xe928edf212 2 #x-7e4d8541b1a0a023bd541c7 1 #x76545934f42227b557be46c31 0 #x-2608c38e1129556c6bb70f01f728) 28 (3 #x166bf6c774 2 #x572318452e0ea08b1435ea4 1 #x-fac1ec1119a7cb4a769a29e77 0 #x2e1145cd14daafda28e88b62b8ca) 27 (3 #x-36dd8be3d79 2 #x-39f64f6b20a56914291a97d 1 #x12100f933d122977106a3071f4 0 #x-328210c38cb87c9d1f076f3a1e04) 26 (3 #xa749b09e709 2 #x2527952386a7be2b90c5d4b 1 #x-10c02918239934609933abba69 0 #x31de884a5d9c78b6e6319e2ff0ec) 25 (3 #x-1603c8b3300a 2 #x-16efdc9344300b54c5fb383 1 #xda03a497f3a804f62dd577c2c 0 #x-2c88450b8d48f1b52084c7d59c20) 24 (3 #x25d68edca053 2 #xda06d714bf80bf54bd35b9 1 #x-a0cecb38403f6d2cc74416a76 0 #x242ba361b913ff35e36456dfa371) 23 (3 #x-38330cec3151 2 #x-7c8aa2ec953cd2f4f10b97 1 #x6d44873740be8996dc8b2f98d 0 #x-1ada5c27223be92473cb4ac215f0) 22 (3 #x4a1dbc1e9af3 2 #x44551ceb1cda292e729c1d 1 #x-44f8224e082127feeed16f2a1 0 #x1249f63ccb77c0a7813c68367710) 21 (3 #x-581e05378d38 2 #x-23f83f3c27adf3a1a8a765 1 #x289e6a144b5abc54cbb86357e 0 #x-b74ca2d7c2e888898f092160ec0) 20 (3 #x5f4efa308502 2 #x122407cc3522769c04ede6 1 #x-165e394d470ac10c83a2df7e6 0 #x69c3de57bc65b32ba1f31eefe20) 19 (3 #x-5e4bbc88f318 2 #x-8c0802b70d6bcde49483c 1 #xb8623a3a447db2cd08490228 0 #x-3841347e20adcbaf59adc7ded00) 18 (3 #x5595ee72e6d3 2 #x4082b30eacc4de1bf5273 1 #x-58d1362ac6ace2488ef14194 0 #x1b949dde4d9aba34277bde04900) 17 (3 #x-47527050d928 2 #x-1c5209b13df462bd4ba8a 1 #x27ef811cd17d9ab388cf7a50 0 #x-c74cde4cf793bf2bc536eb7400) 16 (3 #x368381e7c2f6 2 #xbd1daa5b892c32cb0635 1 #x-10b7c01168fcbdbf9c8e6db0 0 #x52cfe4ca4776adb6d04a63ff00) 15 (3 #x-26190d45c88e 2 #x-4ad51aa8e00bbf3da5d8 1 #x67df6277872d7de4caf7e00 0 #x-1f99cc92bf26dd569085296000) 14 (3 #x1834b6777822 2 #x1bfc4d35f3f3490ed090 1 #x-253d7aa49de7473ca8ad700 0 #xb0c6621ff01037be7c7de2000) 13 (3 #x-dd91f396cc7 2 #x-9dae7f57b9c5b412870 1 #xc3ff912cd2c092d2d71000 0 #x-38767aa7a65c90149e8c38000) 12 (3 #x704a11a29df 2 #x340fb5e999aae22f386 1 #x-3aad246bfe9f2e0555c000 0 #x106b182fbf94cbc8c8607c000) 11 (3 #x-30e944fc491 2 #x-1008aa1d3d6dcd95350 1 #xfd0a2c3ecef6ea7a19000 0 #x-454118a15aa137887d3e0000) 10 (3 #x111e7757e23 2 #x49404659c942052070 1 #x-3c7cecc48d3a6cd83d800 0 #x1078e8d7d1684a3c69860000) 9 (3 #x-3d60888032 2 #x-133f8f96d4613e5dc0 1 #xc8a7bb979346c3f86000 0 #x-383ad922a1a50a49f080000) 8 (3 #x-5980c89d6 2 #x49ccfcf4762ee53a0 1 #x-22c3ea7f99743f892000 0 #xaaf6dd3123be2f6bff0000) 7 (3 #xf775d8cd8 2 #x-ff1e894be184ca00 1 #x4aa78f7f35185390000 0 #x-1caf26341bac5ce9b00000) 6 (3 #x-a257493f4 2 #x30f8bb5418121200 1 #x-61de40ecfcc1660000 0 #x4339096b571694cd00000) 5 (3 #x48ac70cd0 2 #x-830cdf7641a2800 1 #x-314a40234d3460000 0 #x-8777ce228659c9c00000) 4 (3 #x-18b6d9ff0 2 #x1296df69442da00 1 #x2b0f9474fc5ce0000 0 #xe5ccabc6deca2200000) 3 (3 #x66BD9900 2 #x-2264de1d499000 1 #x-7ff30bdda5f80000 0 #x-13dcddd93f7c1000000) 2 (3 #x-138735C0 2 #x30b402a677000 1 #xdc044dd3c4c0000 0 #x153f46fdfbc5000000) 1 (3 40902400 2 #x-2eff39d2c000 1 #x-dbe11f1b300000 0 #x-fe83d7f924000000) 0 (4 1 3 -2528000 2 #x173acdd6000 1 #x61ed79a500000 0 #x671e50e71000000)) 
  (svref *ec-g1* 89) 
    '(90 1 89 (2 -1 1 1487 0 -159204) 88 (2 178 1 42919716 0 #x1f7fff60a) 87 (2 -15219 1 #x845ac9205 0 #x-889b9b402c2c) 86 (2 832684 1 #x31713b460d1 0 #x46e2f7e5194f57) 85 (2 -32771135 1 #x-c2dd5be6f49 0 #x-f00bb1a32c281e0) 84 (2 988730726 1 #x-71ee2a50675c5 0 #x1b4ca5627d06dc730) 83 (2 #x-58aa1cd99 1 #x8125014a58df96 0 #x-1e99abd03c8ef9d2a0) 82 (2 #x6d5f9d0a24 1 #x-1e136f077e73a72 0 #x17d4f903358287a2377) 81 (2 #x-70d2c5811a4 1 #x-2f1c2341d6e490aa 0 #x-e13c5f1bf9c8711dee4) 80 (2 #x62c5a3344234 1 #x35968b0cc075375b9 0 #x6b5bfb34934893ccef76) 79 (2 #x-4a3ad221bec1c 1 #x-1cafea0c07338a4064 0 #x-2b169bbc322c100b8bfc4) 78 (2 #x3052450496d3e0 1 #x8e7fa7a29d3b6b4570 0 #xef789d596e3f34c8abcbb) 77 (2 #x-1b717a073b45e4a 1 #x-10fe84702a296392905 0 #x-4933b37e0ba71fad6cd028) 76 (2 #xdad2c022b7a2d60 1 #x-7cabe9ca61015b96c39 0 #x13e2b1c71c1c99bc8a5cf00) 75 (2 #x-6022ba3b2c6ab752 1 #x5a176438233ac8ed62a9 0 #x-4d39aac0519766f6c5566e0) 74 (2 #x255ee39da7c3229bc 1 #x-207dd56e20edc37ce26eb 0 #x10c6bf1b2151110c093ae376) 73 (2 #x-ce40b4ed72bce2b1a 1 #x84bf9e7e2b3e061ae5078 0 #x-340f2ba50e2e427d1527cb78) 72 (2 #x3f447e59b80393975c 1 #x-19ef4820c1f3a5279324c4 0 #x8f0ac80c72a33d66cb116540) 71 (2 #x-11488754962c82a28da 1 #x3f31c6b61e0d8d5f86d6e5 0 #x-1560a9b4db19f99badf982560) 70 (2 #x43542c53180bb78bd54 1 #x-766ad2224d0e377cae6c9b 0 #x2ae902a6bfeba457f71042db6) 69 (2 #x-e9cb10206c4c0aca9a4 1 #xa236bed03340118706bed1 0 #x-42044561189f0662649d93c20) 68 (2 #x2d333b41e0c6ac9aaf2c 1 #x-930cb9e6b1b92773552b97 0 #x3446fc1e0fa9d963e6f5b30e0) 67 (2 #x-7c6269f89eb11c3f1028 1 #x71264a33e472d6f4e3af32 0 #x605f7719f71ba9bb8889f70c0) 66 (2 #x12fd219e79e433d0a1af0 1 #x-1a4d171e341e8e90ac8f6ee 0 #x-2161555032a33233c7bb6facdf) 65 (2 #x-29098e915d660d38e23cd 1 #x79881fb6a6d95fc5012de14 0 #x53691c1a3103cb9310c1f7e914) 64 (2 #x4e222cfbc8b0f4f907756 1 #x-16a60b379f869981e1a0279d 0 #x-841899d3191a13fd405f44908e) 63 (2 #x-825db07a250cee27bd3b3 1 #x2f7f4517dc99167fb85473e4 0 #x604cc99d0447b897e194cf7974) 62 (2 #xbd79460af94772b4f18b0 1 #x-478f12c3a3e1bc1b4369bd5e 0 #x9dcf7bdbe0c073f30311950781) 61 (2 #x-ee92bb2eacb89721b078b 1 #x425faf711ad38573ea53d91d 0 #x-2b4608e7bef56787d4268e7ff28) 60 (2 #x103dc50eaf4c62ea7af37e 1 #xcf959f32215b84c1335aee3 0 #x4e4d0695fc2c883361baefc7fe0) 59 (2 #x-f7486067e0cd1d5d40ee5 1 #x-d15907c36b4a2267304c7fd1 0 #x-45770a2a0da16df0487a76124a0) 58 (2 #xd3d13123d58efeb5c2a80 1 #x206b50dca9fdab4ffb82f01a7 0 #x-2432c733a411a3735cefcaeb21f) 57 (2 #x-a90c4ed2e1cca1214c9a4 1 #x-336dcb842d53aa9fa50319c7b 0 #xe9350ccdce3a020e4e7168f397c) 56 (2 #x772f0d474a09d87bfe568 1 #x34ff66ff9aed58882da22329a 0 #x-1881f315fa840258eed54c690402) 55 (2 #x-2fdb8f6e781cbe03890f4 1 #x-fd36e96507151e32dc18e77c 0 #x12504e35bf96e5ff61ac97fa811c) 54 (2 #x-2ab45713e1912560f3ff0 1 #x-42fd26417fecce34931b78cd6 0 #xb9693c39df7b366efc32e9026f3) 53 (2 #x6f11d4d98a051549356c4 1 #xa452fb52f2258accdf47451d8 0 #x-343b7262abf0866d125841909640) 52 (2 #x-6e4d544d23b8d2d1ecaa8 1 #x-cc33db66fb4b25f3f6d887b16 0 #x45faa41c4cf5778bc7ddf4f79c30) 51 (2 #x34b6e72460a98b7ced0b4 1 #x74a4b897c7b01297fcbdf4372 0 #x-22e1fd22e6f2458c3273127f0420) 50 (2 #x-bdc7d62da7449329ebe0 1 #x5bdac13ecfcae9c903b734fd2 0 #x-2d2bf4d2b70e44dd6c0e2041e56c) 49 (2 #x20567a93ac518ae82f3dc 1 #x-12baf5bbbddbbd8315d65e2640 0 #x738a4f967cf77804e35a91b59750) 48 (2 #x-3ea205e6ef5353aa70468 1 #x150041cf8ebc98e9ca363c4a20 0 #x-703db15823b81cf74b7a0eff5cc0) 47 (2 #x199167ca6371a023d0a94 1 #x-81fe036ac57ed35914b091d06 0 #x155ba676e6b0dc262d455521a9c0) 46 (2 #x3981b5d5f791edec36670 1 #x-bddf05be3efcf1a027ad9ada6 0 #x60762a4af0d51b9d6f9a96b18914) 45 (2 #x-51c610350bef021ad45c2 1 #x175f87753fc643dad41fe736ba 0 #x-959e8d94370978c9a8ae186efe60) 44 (3 89 2 #xc217da27fce8d83df13d 1 #x-10dc09b2a79af68e071c7ebd76 0 #x5e7d4fcf8b99aa6b3e0f7bb8f810) 43 (3 21716 2 #x374a4dc073892716fdd90 1 #x-1b4f6b2defef2905844b50104 0 #x182833fec3530226e40dc12fb4e0) 42 (3 857515 2 #x-1ec64c514d6f42651c839 1 #x101e11123a022216c7e7ad7fc4 0 #x-7024d8f1f8341c7158e8df3215d5) 41 (3 128338 2 #x-25fc640d3c2d0e790ca3f 1 #x-f493e110ef15d928357905031 0 #x6bf526a2167fb8f104f16fe45a84) 40 (3 #x-7122D45 2 #x2ccf3299f00682d3468c7 1 #x2e8769953b57b82bd6fd98942 0 #x-1e5cdae627f37dce021eba0d2192) 39 (3 612705014 2 #xde4372b991cf4d7d01e9 1 #x8196a84c4812cc285e75760fd 0 #x-3098c75ef6089e2789a06ba12b04) 38 (3 #x6EBB8D6F 2 #x-2e3e987399cb6a43d9a16 1 #x-92006dc5f1be3b6d6081590b3 0 #x4794cebc3969ec252cee61355189) 37 (3 #x-663d57523 2 #xc0c58dcd248ba92cb8a7 1 #x29a37d31995cad96877d76bc9 0 #x-2654a379a7cdf42926dc7f0ee630) 36 (3 #x181f9a9eea 2 #x1c9ec3988bfcbaa449078 1 #x3549bbf2c849a14a42efadec1 0 #x-913a9a343330a4e7f8513d13150) 35 (3 #x-22547c95a6 2 #x-14a3b661bcfb34bd4a4e7 1 #x-400c0f32c5223c42969f5c724 0 #x1fbbd2cbc0c6ca9cfa138dfc5ba0) 34 (3 #x-1d0580c68b 2 #x-b05ac518f5572756247a 1 #x126139a0bfb3b0700520eafe4 0 #x-1723db5afab19d4037aa3c8c7497) 33 (3 #xac8e994d0e 2 #x1181b8edf39f711b698f6 1 #x1339daf45573f1243ba976580 0 #x28c490867b65775e12dcb77f0d4) 32 (3 #x-ca5a1d6fbc 2 #xa075ebe4c6a07d69abf 1 #x-1548601bda76b7bad46d4de4b 0 #x9f41a90314f4decca0701b2c932) 31 (3 #x-388a0ad6d 2 #x-ade0a66b1ee1fda8c9c0 1 #x4cc958712cf0f4e6859d6f3c 0 #x-941f99241edccb83f4d8c352e4c) 30 (3 #x6d41200e11 2 #x3739d5dbea6a992e7a51 1 #x601cec120205572b672b47b4 0 #x27b381a1d9a336ece042981db79) 29 (3 #x-3efde1a702 2 #x4cd301c86ab29ae809fe 1 #x-542cd5fde28039f0b4f66f15 0 #x248c194a451cd37ec857c5ebd38) 28 (3 #x38c3c645a7a 2 #x-36520bbf6732a18be051 1 #x9b75b6bb1cd77f9cf9770a3 0 #x-2affb9e324e9ecf68bfa6573cb0) 27 (3 #x-b640d2af56c 2 #x-1444890694cf8d647b94 1 #x17fcc8ec4264d1bc4835a7a5 0 #xef6a36c66b775fd0b6a6c5f800) 26 (3 #xfae57714796 2 #x1f3fbdbcde0c97567e9c 1 #x-e94db3c6c2ffb9815226ee7 0 #x6691546739cd74054e49bc91d6) 25 (3 #x-c102faa6a2e 2 #x-4469ee1d9ac1392a0a 1 #x-997fdf28f295247624fd68 0 #x-96968724c8d0262752ebd27058) 24 (3 #x71464aadc7c 2 #x-cb621493de8e81158a0 1 #x450f82882b5a5a02041d404 0 #x388a55db17478a697ca3c57400) 23 (3 #x-107d221f664 2 #x373baf94ad6cacff68e 1 #x-19455838cff6fd2766f1ddf 0 #xf1916bf0a4300bd70384c58a0) 22 (3 #x-bc355a22bfc 2 #x3b6924707981d5c7128 1 #x-6e866c9d9771393ec1243f 0 #x-191b2be08430a2cdb342f662ea) 21 (3 #x154093a3f15a 2 #x-20d04e95b8e07c26e3a 1 #x80fccc2e803189524698a5 0 #x8e6adb36fa61133208623f180) 20 (3 #x-e66533f9ed9 2 #x-b15c5bf1255d4ba039 1 #x-16614bce03113eb28ad053 0 #x21a7522886d1c2bc2709f4050) 19 (3 #x877ef1e2d2 2 #xbdcea149ed4c63e000 1 #x-1038c26cff0a236d02049e 0 #x-31d4458c20c43ce8675fbf3a0) 18 (3 #x67167b659c1 2 #x892058cf075fa28a9 1 #x94c3da8cab17fcd6bc9aa 0 #xe51e874a0f1f37b53cc55ab3) 17 (3 #x-7a5a7fe5f7e 2 #x-2fa83e8b6c9eafb95b 1 #x-d1f49d28f9094447fc12 0 #x44441c2c0944b5463a1143cc) 16 (3 #x606d877e245 2 #x67798577cd05a8f91 1 #x-113780314bba34c488fc9 0 #x-4434257e3572c86ac7ff382a) 15 (3 #x-144a2bd8cc8 2 #x8731d21bef9c7d7dd 1 #xa4727891529fe13b646a 0 #xc7af09bddbe375bc55768bc) 14 (3 #x-286c7c72bc3 2 #x-264ddb0196108b922 1 #x-1f82d032774dbc35b340 0 #x62738bc6623ebd902bfdfbf) 13 (3 #x246cf9ede05 2 #x-1075a6e323b7cdff5 1 #x-15c322245d8ec51c786d 0 #x-36a77182ef2e36af5531448) 12 (3 #x-922e57f0de 2 #x7537526612e74a70 1 #x1064836449d04ba246c1 0 #x2f179548018f8231e73dc0) 11 (3 #x-367e966e3e 2 #x140cb60a078e8e9d 1 #x-122d678cb1bd4ee1aa1 0 #x4907828dc69525f7bedea0) 10 (3 #x481acdb777 2 #x-e34cd29bafbc7f6 1 #x-29ca5d530af5398b699 0 #x-11769016f11a7667a108a1) 9 (3 #x-264f6134f8 2 #x-a9ae6dc31e7d0e 1 #xca5f227481e70f7575 0 #x-1cb64a2dfc71409a4c26c) 8 (3 #x3a8f2095c 2 #x114589cb130c455 1 #x2c9328777a7c2a0958 0 #xe684e157e9334dd95a1a) 7 (3 #x6bd89043f 2 #x-2f75f24c5c518 1 #x-1d7160b219555bceec 0 #x714b19e3ccb44565af4) 6 (3 #x-30cf5e4b5 2 #x-cbdca25009801 1 #xe8fea87d09cdb532 0 #x-1e5fc9cfde9cf7c2727) 5 (3 994747126 2 #x9a8a3f04f70 1 #x1ccebb956850194a2 0 #x-20fe920dc5839029050) 4 (3 772879382 2 #x9e5a8321a019 1 #x-457534746d01c454 0 #xfa6bf88d0c82d7dc0) 3 (3 #x-10C57872 2 #x-2052924e236e 1 #x-6a3f50386cb5510 0 #x91c556a9e949ca800) 2 (3 25912350 2 #x6679b53b284 1 #x1a09f185d59cc80 0 #x297948bc5c2837000) 1 (3 4065876 2 #x-11011de7520 1 #x-7234e48eac00 0 #x33248ade199b0000) 0 (4 1 3 -578448 2 #x13b52e9840 1 #x-1055c4d446000 0 #x36cd25c06640000)) 
  (svref *ec-g1* 97) 
    nil
  (svref *ec-g1* 101) 
    '(102 1 101 (2 -1 1 1488 0 -159870) 100 (2 101 1 42837231 0 #x1fc2650c7) 99 (2 -4848 1 #x86db5d476 0 #x-8a34c551e1dc) 98 (2 147056 1 #x446bfd6fde5 0 #x3b3462c156568f) 97 (2 -3161300 1 #x8b6aa3476cf4 0 #x-82351da6206a336) 96 (2 51182760 1 #x2810d713c2ee9 0 #x524d9885fdc72075) 95 (2 #x-26935EB4 1 #x-3bd92c5f9b0565 0 #xb6a6c8a0eec07e50) 94 (2 #x185a8b864 1 #x-caa916f82f4098 0 #x123f76ee161e91e93c) 93 (2 #x-c72c771fa 1 #xbbd9e402dcd6c79 0 #x529466333eff42ae20) 92 (2 #x52ed91448a 1 #xb82be98ef0aaf3f 0 #xf2c79e503fdd85443c) 91 (2 #x-1c14cd63fb6 1 #x-114008d31e308b6d7 0 #x386d11ae953b9320a30) 90 (2 #x7a40c351d52 1 #x50df52710904cb49 0 #x-361f3baf1e834c95962) 89 (2 #x-19e2ca8be7ea 1 #xd41e54c3f89465dec 0 #x-1acedb6c3ec8d8179734) 88 (2 #x3e886a6f818e 1 #x-b7c2f5f61afc729de 0 #x145f16b88ea9a697d5e6) 87 (2 #x-493c49383d9e 1 #x-605d6fcbe6401b0357 0 #x-1661c75030d06fa2fdd8) 86 (2 #x-abe17f43c3a6 1 #x62a5791b63d9e0288b 0 #x1f0877c1db73a1fb3ed2e) 85 (2 #x4b75ae02ced05 1 #x1c3cc08f8877335cc83 0 #x913fdd5d27bb42137f33c) 84 (2 #x-d285a331f6721 1 #x-13bc28c8fb4c9696e31 0 #x-3007937c1cf432950ede12) 83 (2 #x12002c6afd5ad6 1 #x-5e09b5bce01277f029c 0 #x-4a1ba6c0569fe383570570) 82 (2 #xaf2fe814ffd4e 1 #x-2d2f0e5cb13883aafaa 0 #x22fdc53b629d78001b003e4) 81 (2 #x-76d3ee6d4c3657 1 #x107b164941372090e0bb 0 #x99759fee8340f6f6b27ec0) 80 (2 #x125a9dd99d5220b 1 #x2c233b96b0f0b4d33631 0 #x-10a1e66fb46bb8a348a4e4c4) 79 (2 #x-14700483ed93ee8 1 #x-2bd0089e84e3f0acc17d 0 #x9258fca541f0e58276a3c00) 78 (2 #x-f8d257059cd11c 1 #x-cef70bc3c1c6d149f8c1 0 #x5aa6a3ff0dd0d921202117eb) 77 (2 #x72a21f9a5847625 1 #x463557dd0c553777dd80 0 #x-72545bd84b445ef1b99facca) 76 (2 #x-eccf8851a07097d 1 #x2419414a46cf89eb18bf1 0 #x-16aa18e776f2981d4ebadec2f) 75 (2 #xca9a9bd05fb3308 1 #xe0859f6b75722754941f 0 #x2f308b4a8ac96f704ba1f3c1c) 74 (2 #x10f80332c9401830 1 #x-4315326a876d906d99dd8 0 #x401372fa7787def176d1c19d1) 73 (2 #x-4e0525b1f0730701 1 #x-860b66f1121d0b96dc505 0 #x-dd3e0747568b1ce2d44354492) 72 (2 #x7e33d55f0f92e431 1 #x4f24180c988e7458b1d42 0 #x-651ede505c6d79538f7ab8d31) 71 (2 #x-3c93d7b46e89bbcc 1 #x1f909bc7212ebe529ca24f 0 #x31ea58b3d07464e229266a0c10) 70 (2 #x-cc7241073f838030 1 #x1a6d27f8ee1ed9b9868ea 0 #x-6b71c7fae00dcf84a66c466a0) 69 (2 #x24acd9c3f1fa75faf 1 #x-480184c15f856ccff8b380 0 #x-8f4c492db070a5166deb67eae0) 68 (2 #x-2c52ca398822b3ebf 1 #x-2a442aa9f2872086673d3c 0 #x578917fe6e8d608b6c385fa688) 67 (2 #xe603d9aaa28c3da 1 #x630f5bc4e3db2ed2daf798 0 #x14aa75005b428259a326baa29a0) 66 (2 #x66fe963d150cbde92 1 #xbe16da91b53341a4a1912e 0 #x-1640c8412b73f43481f84cbacec) 65 (2 #x-c7b7834f7902b89dc 1 #x-28ce077ec010e8f38f70e0 0 #x-260bae6f5d597c03cc352906178) 64 (2 #x947cfa237754037c8 1 #x-2141a7736600a203c2055ec 0 #x3e854eab6da63b840c8cb4c30b4) 63 (2 #x8f8b1c9ac64d9a394 1 #x-c6838825ec005554c1de3e 0 #x35d3ec8563a7cef087bb0147530) 62 (2 #x-229bcbb446a064b0c4 1 #x3d247ccef7a29bdef9459de 0 #x-893fb21617813aed4934392373c) 61 (2 #x2c00ae1190369a036a 1 #x2f7f45d76ee4ee2f3345fb6 0 #x-33289372d2e4791076f7b146258) 60 (2 #x-a9ef179ce20464132 1 #x-3f627767bfef5d60444c8f2 0 #xf61f88d242d7526e7c891b218d4) 59 (2 #x-4161d4752ec9479044 1 #x-75dc0170cf91044e36fa8f0 0 #x90521826df2713c5ae377cfc60) 58 (2 #x8047088fa6951c7ecc 1 #x-ba68c38fdc5644dc326914 0 #x-17020a615ef60e93224c16dc7e98) 57 (2 #x-592da0481f4791e78e 1 #xe6b5988347b3b263445aace 0 #x53170fd83c09dc6e0aef801f080) 56 (2 #x-4d085f8d9d2cc01aca 1 #xbeb738be8767516080f77aa 0 #x1d0133a8862e9f4e2caae1a89bd8) 55 (2 #x100c93a7535d8ff14b8 1 #x-1511c49b917981ed393760e2 0 #x-d24df34efd8e3d43e066a5e7ac0) 54 (2 #x-1091f04ebc281634a50 1 #x-1ad616f85985c868a31ae6a2 0 #x-1ef38bedd2cb0ca6256c89daa879) 53 (2 #x87dd16e1e43a7bb01 1 #x129f704c42f2396b087cf7f0 0 #x14c00ce3714ef0a224fb8707b08e) 52 (2 #x185a9dbc44d983e5493 1 #x26afcac3cd86d1a109630941 0 #x1bf0a61d95d6901696033d3bc959) 51 (2 #x-24272be34e7ba9278fa 1 #x26d2d7d7eb5dd901c095bfc 0 #x-1917564207bebf4c997bf54847e4) 50 (2 #xe05cbf2c6e8f26f3c6 1 #x-2854b5798543cf96cd8277c3 0 #x-1534b8b9c4d7657f68fdea93b45f) 49 (3 101 2 #x20260e0e68287122acc 1 #x-28cfc5a5643fbf65a755c6ce 0 #x1891bd53f84f334774d87259b046) 48 (3 -4747 2 #x-3987d76e01665c1b423 1 #x1bde27dbf16afbe3c2a982cd 0 #xd59ccbe3b9757787718d8cf9783) 47 (3 99687 2 #x1d83d9ae760a908b3ec 1 #x4df52b7a2dfc7424c42ad5b9 0 #x-13ca1019c9d26517dc68f28c8fd0) 46 (3 -1186144 2 #x1ea6e9b9c682792bde4 1 #x-2e0da4c1a416b71efcd38f4 0 #x-6cd0068d919bb2e9dcd79e381e4) 45 (3 8082626 2 #x-45d6bbf065f1550fdae 1 #x-585bd8ffbea2f2747f4b402f 0 #xcfe6d5306a120f4013e92b7fe60) 44 (3 -22036685 2 #x3299d383f894487a1d2 1 #x-1a20373a5759315a48d11fd1 0 #x2aed2a16f32f182b254b217456c) 43 (3 #x-6D6252F 2 #x14e50e62584ec05a906 1 #x3d3f5b049e2f28b7713004b1 0 #x-6a2dd017e75160a6b4ec173ee50) 42 (3 #x4F3885DD 2 #x-52f67f3976019263047 1 #x2dc5facb21f5877bc9c19795 0 #x-c29c74fad8d2d90e49bcadb692) 41 (3 #x-10c555bcc 2 #x3fb52c2e41bc60aceb6 1 #x-c2d20a8efbcee0df2ef60f4 0 #x2345a7be1b145d678292c77dd6c) 40 (3 #x-c0d5dce7 2 #x1caad364dccd75e2ae1 1 #x-2e36e5cc1ac63e77de735b3e 0 #x2322a0bf9491e0d73099cc1bc6) 39 (3 #x11143acebf 2 #x-4c84808be7d5d68a430 1 #x-1d10ec22c4c413c9fb1b3bab 0 #x10c9973b3487dc024453626028) 38 (3 #x-280de8ced9 2 #x2fd105dc8a6a7d5ba8e 1 #x1dcb97b4303bbf94e1b119f7 0 #x-2147ac8288e7d2a8de408e212) 37 (3 #x-4a4fc06c7d 2 #xfba305b6e9fa9afa4d 1 #x2ad51bdf1c67da41771d0547 0 #x-c1f95746c528bf2cc2d69eac24) 36 (3 #x1e67b2d78ec 2 #x-56458589f174057bc5e 1 #x-979a327aa7361e93f50aacd 0 #x-76e605a6547bad281ab275d22) 35 (3 #x-eee69edffb 2 #x-41c33f16f9ecca78b6 1 #x-20300ee79df81c92ee939774 0 #xa8924f55453a13ec7768cb7f90) 34 (3 #x-af117e8d9be 2 #x223a40715158a55050f 1 #x-2bbd262c459a7c9d39eb3a2 0 #x1032ff9e6d8f5c830f7df7b334) 33 (3 #x110c65e43101 2 #x3d3c1edfbde25847667 1 #xe0bec8b3d15349503df3af7 0 #x-59f22a23daeea185696e276140) 32 (3 #x26cdf9132ff5 2 #x768906ef48a687fa312 1 #x4b54e3995b825e0d400baa5 0 #x-1397578c190a302d085ce6be14) 31 (3 #x-641f79add9b0 2 #x-1550c924fc542141568 1 #x-1fe5e8ccaccd9298692f221 0 #x1c9df27cdff4815dc0c20dfd40) 30 (3 #x-5d13b062e98c 2 #x-d317a5ddfe4f447be89 1 #x-2077580c78f93544b678ded 0 #xf238de111e5070932003f66ed) 29 (3 #x17283ad31f99b 2 #x-8d19b3d7e2037582833 1 #x-19f5773aca39cce74c79420 0 #xff633060b2690624cf24dffa) 28 (3 #xa48a423001cb 2 #x612e9b85805c187febe 1 #x-21cedfcf6c0dc28cd44a1 0 #x-6bf4a3efc0862cecdd856ba51) 27 (3 #x-3da2bf2bd533a 2 #xd431def562ba562ea2e 1 #x1289fab536e732d885cc50f 0 #x-7ee8d6b7e4f86cccf3f2b79dc) 26 (3 #x-103d7ffe275ba 2 #x585e6c20e7c362ba1b7 1 #x546c6ad998f7fb9135b716 0 #xab3074129d023ccdcea201f) 25 (3 #x7b91450f112e8 2 #x-6c7854168cebf0e82dd 1 #x-584f504ca3e7ee0e853421 0 #x4e12ebadbaaf61f5c245b62c2) 24 (3 #x1d97ac2478a02 2 #x-8c83fa8666c9a36f51b 1 #x-150c8c64a36b5aaac5f788 0 #x2297e6f8750e4faf9a8d04799) 23 (3 #x-bc79641d1932d 2 #x-ee9a165945b4b9ae44 1 #xec74af97a822c7dc4c85d 0 #x-e52569de4639ad42ad888110) 22 (3 #x-396f0c418692e 2 #x497328219e771a61017 1 #x-c0fb28bb8d77e40756afe 0 #x-1372e39a7e85f99d26bf47138) 21 (3 #xd83a837b743c9 2 #x2e67f4900163cc22fd3 1 #x-4c6cb9fa0dc95853a374a 0 #x-8d8e74908967f57340550fa0) 20 (3 #x5b257e98559b0 2 #x-a6c339f12ab9bd4870 1 #xe17c6687a81fac669194e 0 #x45064e7fe68b54a5ee07ed0) 19 (3 #x-b58c21f6c66d7 2 #x-17cbaa1c938ec67688e 1 #x8add95f2c0d46fe78ef0e 0 #x490c06d621eaabf587e78c00) 18 (3 #x-688b8ecb556b5 2 #x-6cf7c34505d1d7cad8 1 #x-41c89bfb543e398df14bc 0 #x3802d621960ed2c9a1a04680) 17 (3 #x6a55856441a05 2 #x4e080b1b482da145ba 1 #x-72a91b10f3e94715a2938 0 #xc7b225ce82da791fb1ab800) 16 (3 #x53a0a66caf064 2 #x3e2436f7e5743d12e0 1 #x-3388dcaa7aede62fb4478 0 #x-8c60a2e66d4190e6dbfde00) 15 (3 #x-274f0a3a28e91 2 #x2e2d7cf7248770bb2 1 #xc5654907c5a422b4bba0 0 #x-afde17bd4dd155b13f83000) 14 (3 #x-2dbc1d270e04d 2 #x-ce0b08c7196eb8871 1 #x208040e93e8fa6d2a7840 0 #x-787cca1ed4030621a8d5800) 13 (3 #x65960ebb6f04 2 #x-4a5fac6db53c8be3a 1 #x14574393413fd10a28180 0 #x-3161dc4d55b24ef2b57a000) 12 (3 #x109330ac3f61d 2 #xc4e2c742f70ab6a6 1 #x33300820a868d1c23880 0 #x18e1cecc99083b65ed5000) 11 (3 #x15adcbe34efd 2 #xdfaef928f7379c00 1 #x-461dd311c698eca02200 0 #x12d08a3e689cf9913240000) 10 (3 #x-3bea6deb066c 2 #x22b0bec0dc9a4bb8 1 #x-3dcf4cd296beb9fe8e00 0 #x10c29e814c4ca43e3a18000) 9 (3 #x-f1727b4d1a8 2 #x-d7c70b6f5e02c80 1 #x-15f2d682c20ea6963000 0 #xa8ae1b3f9cd6779c000000) 8 (3 #x75e65613b10 2 #x-5d75d64aef11df0 1 #x-2c5ba0456bc3c58800 0 #x57cb61159d589ffcb20000) 7 (3 #x33757c6e73a 2 #x-b76c4945170300 1 #x3aa024173ee53f38000 0 #x26051b044263d680700000) 6 (3 #x-4d48d28534 2 #x-2869a896e14b00 1 #x1ddc3bb178785356000 0 #xdca07ef8f9aada8f80000) 5 (3 #x-4dd6c12738 2 #x-a61add3ebd200 1 #x75bb2b0be0c6ee8000 0 #x453067a81839d3ee00000) 4 (3 #x-4dc3db468 2 #x14ca48ad3a3900 1 #xa3e1412f0180d0000 0 #x12cfda67d616150d00000) 3 (3 #x2b8ce13c0 2 #x12081b7db12000 1 #x-2a24a55d947ac0000 0 #x423b48271ee542000000) 2 (3 #x5B7B9F20 2 #x667a4d853b800 1 #x-1001f623d5ab20000 0 #xa7ce653ac2124800000) 1 (3 -65971584 2 #x122667d4ca000 1 #x-238cc1e612c80000 0 #x10628760a1efe000000) 0 (4 1 3 -9669888 2 #x1549a3bb6000 1 #x-1f7fba647500000 0 #xbaaae21f551000000)) 
  (svref *ec-g1* 103) 
    '(104 1 103 (3 -1 2 2232 1 -1069957 0 36867616) 102 (3 103 2 #x9a8c024f 1 #x817a6ac38d0 0 #x19c136dffecc8) 101 (3 -4326 2 #xb6f506645d8 1 #x-a83505faef70c41 0 #x649fb251c47ea49440) 100 (3 88271 2 #x1e6c3c146f4de3 1 #x483a52779c8bc3d3ae 0 #x11108eee9ced62db04bb4) 99 (3 -620060 2 #x1ad0cd144678a489 1 #x-30b96b254eed464e4c52 0 #xf1b076a2f545d5b7386e60) 98 (3 -8960382 2 #xb2d07d1db7eb15a75 1 #x-33efc605915bdcba3fafd 0 #x40d1d381744dff779a74ed18) 97 (3 201532375 2 #x2ac80d01425df42e6b9 1 #x711cecf70e8294de22d96f 0 #x-4639a0bba23cd5f6727171940) 96 (3 #x-224CD688 2 #x69de2dba9901b6e966e5 1 #x109ec72ce4b5f2ca317c3316 0 #x587113bbde4353f8ae7605522) 95 (3 #x-42869854e 2 #xb6f6d599ea838a46ca8cd 1 #xe0230e492b2040d3bd6f8f8c 0 #x1ac008fa50318c6d969d2fb8060) 94 (3 #x2214aca9a1 2 #xe8b37501042df314877341 1 #x47fe4bbf14b0bb7bce79af79a 0 #x-44259c41453f21488e75f8a648) 93 (3 #xaea072de6d 2 #xe1e02ebf8773fe4b5719eb1 1 #x-2232c7181464f2f1bbbe735a5f 0 #x-49d10d4a7872487fa8e7813a6d00) 92 (3 #x-abe4273acda 2 #xaba60f8409151806830f4961 1 #x-38efa151af715613d772a578e71 0 #x1ad5bd7a0ef70f5690b765a884a4) 91 (3 #x-b7bb52a06bd 2 #x67e6bddd07f86c9f3b753ffba 1 #x-27029b5ba70f9e55b516fd025d58 0 #x1363723953f205f223db98f2c4d1a0) 90 (3 #x20dd459655b11 2 #x329e35e619887e678a115cb72c 1 #x-125ddf9632bc85357cdfb27a2fe13 0 #x8839f68f08ba664ed036fd4fa18988) 89 (3 #x-bdf96186fefa 2 #x13e9062de60f10b487a6e785244 1 #x-691e4f639be51c4b7ad8f32b5ebeb 0 #x1b270bd020e001049ce3c7603a498c0) 88 (3 #x-46dd89f6c1eac2 2 #x64863498f5a262f992d2e484cf2 1 #x-1d18396669e7be77e9261290aeb1c8 0 #x4f91e0dab276bf50ea60ba6066c634f) 87 (3 #x33536858adf739 2 #x18d86370c1003e24f35fe61cb5ef 1 #x-60d2118c9d279580dbcb46219ac06d 0 #x55c6e4b6197ea3cfa21a556b39d67340) 86 (3 #x72332557f8e632b 2 #x47c2f536621e0ce63fd3ab835ddd 1 #x-e07aada82b6ef310dbc7e88637bbdc 0 #x536e691ed04617367fc8fdb6ee3d6d8b0) 85 (3 #x-317beb7487a0ac3 2 #x71cdd991ab7bd9f1ded77e8cef2b 1 #x-1816e648cb1607fa94d2be71beb5afa 0 #x3664a22891e30b10c6d4afc56cbfe9fdc0) 84 (3 #x-8a6d92cd0b960c54 2 #x-abb73a634be85a37610ba25d9343 1 #x-7f825671f2f57e57f777feeb6755d6d 0 #x1b5dfb07dbfbd4f631903fdb658dc1c03e8) 83 (3 #x-2484847a0d1bc090 2 #x-7a2e9f7c0acb575ce6aab324f757b 1 #x-576ff8cb2e97dd4a8693e9a1a1831b46 0 #xb7dd9eeb5536aa02ca079bdb9d548c6f540) 82 (3 #x796922e6540f0d09f 2 #x-1d4ca263a6c2182fcd3781c2dbfb11 1 #x-29c94ac8c8f8f961d53681d719751e0fc 0 #x433cc2319e0817fb7eafdd7c808771c4c8f0) 81 (3 #x90a20722d32e1488f 2 #x-41faddd1e128b5ae47842b80fdf4bb 1 #x-e76e7e3cee3d85385ce2e9e6ad51bacc6 0 #x15f8083159c3ce5846f45fc74e4a49c907880) 80 (3 #x-4620df776b23e0c264 2 #x-38c8bf123e17fc9746eee005fea40f 1 #x-3ea6adb0a7a5d59a12dada6ec23c9f9f9a 0 #x685a074e95dc5ea70e1d7416e61650d9e1c5c) 79 (3 #x-a7667b4bfb352c5016 2 #xdc061fc2476238d48de37e685dc3dc 1 #x-dc6b3e56cd4f2ea30f2ef9427cd719a040 0 #x1c79ff13e15feac7541f8ebc1ac0570deb0ac0) 78 (3 #x145cc81ecf02df09bf6 2 #x4900a73e29d308622d4d099f3c081e5 1 #x-27bdb4ff88463de384053102ca7b6bb9040 0 #x733ea859dc66e836a91063313b460161c249f0) 77 (3 #x645ff6af6c290e81bc8 2 #xb5a33ce37f72c61cb6b29972dc260fa 1 #x-5be9a2c1171df9f7cb803b53ddb5bde4ef6 0 #x1b2f00f7dcd520964870480c9e9fc7eb5781600) 76 (3 #x258743a5a3867a25f2b 2 #xea85a469ed0d3237e303383d4c30fb3 1 #x-9a5fb732ff9f28bc4071efc6089e9b81b5e 0 #x601bf26081efd12b21d3b70261e2614feb856e8) 75 (3 #x-1cd29456f5cf7070468d 2 #x-800ceac0b124aa9a054b299b4e7d384 1 #x-64a9c2257529172c9b1f253037ebc5c8400 0 #x13f6f6dcad1d0dab8fdb98e9d0f4d6f60a0a6d40) 74 (3 #x-4145f4c8254e85a27553 2 #x-5e5c4a9b7d581429650eccb339d6306c 1 #x1e4e10490f67949800587e19d307e89c16b2 0 #x3e8c18d71a8e8056eff7edd6ea01a0ba73788390) 73 (3 #x-4b40e3fb2de52c217be 2 #x-102fbdc1c3a8299cb9196fedd0f72d290 1 #x9efb85bae77e62830ccdab6477f4aca64d6a 0 #xb9184aef5e2455e4b7fe85c5b8362b1a93e64380) 72 (3 #x117657e7ee4c658b1fc34 2 #x-18885f188692af2b542958b4dd4432c3a 1 #x1d8806cacea12001072e3d0de0fe31a174ad0 0 #x206422bf8ac7bd67a0d3a40598e20a8fe343991af) 71 (3 #x2a570a27e3a1a931cc077 2 #x-8b5b0ebfa42375439a2d7de4fab82136 1 #x40e9c85b7e1aec329f6305a67e0e7dc479c21 0 #x55ed8f8f3b42690b31d9d1b490e6054d159841ca0) 70 (3 #x15d8b9802f0ba0db01299 2 #x426772f5772060e3692fc4b46e297c4e5 1 #x6a792ec776d3f944fb91c7dfa0008e4e3ed00 0 #xd8394dac6d9e442f8fd7ec9968a43d366e3128728) 69 (3 #x-86c5bfca7509b19456695 2 #xd933b63065a7a63c750c95f66cc07acbe 1 #x698a42da87043425497ea1ddf760c32658b7b 0 #x204a6d96d6bab6289ba535631735203ac72a4545c0) 68 (4 103 3 #x-18971c952cdaafc345dd82 2 #x1745508316ddb5343a0b17814750063447 1 #x-3c4f7c627f472fcae6e58c2e4b4bf9203825c 0 #x4957eaeca840b9fe36ed1778781f4d164c0900c3e4) 67 (4 -6695 3 #x-1503147fac3915cd811728 2 #x12fd53198aa9b36325a3463b3172e2dcd3 1 #x-25f9491ebe9fa4ebf38b05aa32cc460d7c8e6e 0 #x9e89236dfe0f6c5927789b48a8adcc8e14ceb1c8e0) 66 (4 537042 3 #x2bd1ff5ef523ad9f7276d4 2 #x-14f1da29483ddd8f3743dd6f52cd0fc659 1 #x-7045639c606478f54db4f462527f078daf0bad 0 #x14686c3f9e1c98bc76ed55b7632bd0ee33f1ff8bdf8) 65 (4 -22289921 3 #xa41f72d3d35c4a0823c6cf 2 #x-6c8e1d9b2468c9ffba5d5bfe97904e383d 1 #x-e8b7a6873a73b0b680da4c2c77a84b8f7fb7ed 0 #x281b39b78fd1bc84a7e05c9a8939913da6a3e420dc0) 64 (4 671310225 3 #xcdacf01ac36d871919968f 2 #x-d6882bcb86768180b3dc800d18008b6f72 1 #x-1702488d98df15601833060f0ee438ae03c486e 0 #x4b515c66ae9e58fe8ec2c7689fb3d8675d5f8b001a2) 63 (4 #x-36e7e7ca2 3 #x-4aefa5da75a94f44dc0340 2 #x-f20fb2c48952da59b788cb0f22a5be64b3 1 #x-19c1d071dc2792c5d0fa8e5b6ef981fef38392c 0 #x875f327ca25fe2ac8ddb41a34ed1655f08be3ab12e0) 62 (4 #x38cc397610 3 #x-3071ceadadc3e52ac08df6b 2 #x-2e62dd8efdc93a6a729db976a092b73079 1 #x-98c75e8a3a3879ab52b93006a137dfce86811e 0 #xe93b19ec13baaaa5b26806e5ec3c8396555f49633d8) 61 (4 #x-2ced911396a 3 #x-571505b7d0eac6cb5e7f725 2 #x1d1f8eaeb16e7e52126e523e048cab21385 1 #x2c7209db18fa150cc12bb390cdcceb1975be57d 0 #x181c51f3fd7831fb146784c4ba2c06a1484fdf84a300) 60 (4 #x1b4e7a9c953b 3 #x-2b7a4b86f1c710aca78bfc5 2 #x49b7cd70f0c27d061516c02b0cf97223fc9 1 #x99d8ad3b7c448d45594f65a34fa9323296467e3 0 #x2656ec703521249f316625f8394bac1686c49cd75a74) 59 (4 #x-cb25394fbaa4 3 #x94df357f3170ab69031d618 2 #x67e606d751f267f643a20f18c890aa1c5c2 1 #x140f712dd973fab20419ef23eb40e5694d3b0f28 0 #x3aaf7793de02eaf325861e020c9e896c276bc50ac320) 58 (4 #x4720a95a9b1c0 3 #x21dbf16726bf7c71dc859178 2 #x4f350cb92298ae1314788bbe0943812c1a0 1 #x201d310bdee2eafcbe984b6b23066baf235b2eb1 0 #x56906d9eea5127e30db6ee6ea76ffc5b3ea5e4d5bf68) 57 (4 #x-121de0584ba0aa 3 #x7e9fae95d05c8867eb7fefe0 2 #x-1e2b1d7c93083915b54e2e347f7f8b279c4 1 #x28a277a8e001305b3205761f196961f2fee4b2b1 0 #x7b29f9c38a234916907c72638cb3e81e1206f9ca93c0) 56 (4 #x31a9305bece4eb 3 #x28f84689c51082f2d912a4a5f 2 #x-d28dfcb40717bfc479fbdf5ff4d73d12563 1 #x254349f2c359ee945ecf60252b10e095df6bbf58 0 #xa92af6b44c584ad1986b537e6b79f90d18a7d1df66e1) 55 (4 #x-46cafa806005e8 3 #xbd291add88e415907c3a195f7 2 #x-182ac8964a9bcfdd477d11a2b8f8840c6a75 1 #xbf4591bc645e0daff9300ebf32def2471ffb671 0 #xe07544e03b9d6e300bda345395e3c1968ef542d2d400) 54 (4 #x-2c8412edbd661e 3 #x2a1c74b7450d842cf94cb0bfb0 2 #x-1b9fc95bea831a73b5b4062f6b5fc1f4f37d 1 #x-2bb1ce57866f78705f64027b4048fdb4bac83fc4 0 #x11fdb811fdb35d7f9b683316e98f9bda932f2e0e763e0) 53 (4 #x1a6754d736f2113 3 #x6e66796716d5e8e736d2889397 2 #x-117740a83aecbd6acebbddebbb9761e58459 1 #x-83fc672edf5101d342cecb95adbf6371bc9e31b0 0 #x164f8a99975bd139121b5839888e187c5d85d24dd9c40) 52 (4 #x-31d803aa99ceaeb 3 #xaba804f2c4c1ce3e27a131d872 2 #x6c5d0bac2fe4e33c713e1dd82fda9cdfd43 1 #x-f506eeff10d40ab3b4f3e22826f856733dc2abb5 0 #x1ac31b9245631792a2f273f30e1281f97e06fc3f49e80) 51 (4 #x1e352c1b8c32787 3 #x-90d630bf21b1eacde74059cf9d 2 #x260693eed5424e444b8d0a28947e57cb41ff 1 #x-16ae869319c306e5f21e251e3d7f5f67405b3f25a 0 #x1f0ecb41fcabc4f4ad6960e1108ceb206d4621d571180) 50 (4 #x2e46daf5b457db3 3 #x-87d3977e2b969ca772272905620 2 #x400f8ee3700c2e61ff38eae90d3c1e4cc999 1 #x-1c79a971dbb408e2814105fe7fbe185a6963cf2da 0 #x22dff6fd5f17d567613454e561f853de16bdab61d3f80) 49 (4 #x-97c7342d6bbb81f 3 #x-22865a0d5f2539ae8dda8241cb27 2 #x490d5db67d7defba35ed96a29bad116ed107 1 #x-1e8d23e6d5f51ff8e981c15a9af365aa7dd148eec 0 #x25e4b763058a90237a6ca66a124f2b3ad0888cc01a300) 48 (4 #x14854b03078fde47 3 #x-5809af23aaab3b99d630045f17d9 2 #x3af09c161016cbb6c0b1b79714fef14f28b6 1 #x-1b0794cbc551e21c9ae9fa55eb1c87e9d325c000e 0 #x27d6f320c696114dc21867d9ef77d5a6bb8b20f2cb900) 47 (4 #x-a8e3e1300fee69e 3 #x-81c0117461a06a80022d30ab4058 2 #x17812f1bebbe6a5667525d7f9ddafff6404a 1 #x-10d688820fa38de2163acbae9fc1a03a4805510c0 0 #x2886be84a6ebc0474ad3c9f8bee21c9492e3517887000) 46 (4 #x-80088239537794eb 3 #x269bd2fe9d8e1786afcc64ac67c5 2 #x-192a6cb6ad52416a9cdcf51c63e2f6760155 1 #x-1d1e6ae7fe011f292de987d90ebc30be9d6cc6c 0 #x27e1f666446dfb10cc1a59d65e2f64d1919868fd17800) 45 (4 #x-5832c2593759dd58 3 #x3699dee852f76f29334ccbeafcff4 2 #x-4ba49ab463b619cd02b070f6ff161c722730 1 #x15a8ff0d60c217507d3aa44bf2029ab3b80034148 0 #x25f77d91594467642691cecdb55f7064969237ff2c000) 44 (4 #x3ed5ea298b9d77480 3 #xb14ee33c2c5716312ee06588ac761 2 #x-737a2df683a7efe7f33f9286ce8b391768c9 1 #x2dd624f00c5c0c6a0413f7735523b8d12329d13bc 0 #x22f55664a78a6c28548ce91de96704d6f90148dfb9000) 43 (4 #xabaf58a8356bff543 3 #x14650d04d55a91dcb1dfd63b67840c 2 #x-84feaa2c1a5a79528dd63cbf2db20896e818 1 #x45158015f0d39d8b39354ed9356e2ccad83816a90 0 #x1f21d1ac48457563b80b2d20c02a85205adc7f74bc000) 42 (4 #x-ba9c84a345f26a015 3 #xfdf31c375123040293469d292c724 2 #x-781d79e664171c83297bd7eafbb4c439da58 1 #x5811216b543a94b4f68bfd5c09fb096a784211b30 0 #x1ad11221af9f50e773938a28ae6c42cf0e03c82468000) 41 (4 #x-5bd599166faaa59dfe 3 #x-21bf221f16d9ca82aa579678e11888 2 #x-4c516cadddc99e5be7e7cf502906462477a0 1 #x64285f1a5cca3e27239831f0b11e9e7f4834a5e00 0 #x1658fd6ca9df8dc906c1ba0c0200e0e49db9ead870000) 40 (4 #x-5ee2caee6bdcd9ee7b 3 #x-9a432443599825f6ff9882f7e91aef 2 #x-b1c1530c11e643e57c23a3b79300059a415 1 #x67fbe9ea7e5e8f48fe7753d6750f585a37e18cea0 0 #x120614a7a97a2cda3d9e2fac0bfdc91b6da8b6e3a0000) 39 (4 #x143a75f092baf1616ba 3 #x-133e61217183983cea26ace11f3285a 2 #x3a42b07752905514385aebc54d0ccb9f7674 1 #x63a71d2c9249c0b334a3d8d1d68aa3b7550fcdc00 0 #xe135c1ac0cfb5665091e7054e8e62de9b68e8b180000) 38 (4 #x3f3dd32bed28fc079fa 3 #x-14a888147d442db35e7958d77b6e76f 2 #x72014c44ba93dcf63822b244dc0c2ba51524 1 #x589950a766d945876176cf892ed03750cbfd26400 0 #xaa682213d338d377ea28ed69a75bad69e4df77f80000) 37 (4 #x11ed3b238ee5a3caac7 3 #x2793677a487b078ce449db43d4ea53 2 #x91fc0f919c451ed6eff7e39a1cf58f50d998 1 #x49227569b175b22518778df748289f8344be29800 0 #x7d039855748dc5c270edb7286bd226e6cda3ec000000) 36 (4 #x-d7ade172c3254ee4146 3 #x3b512054924d026092123685aa84175 2 #x9bd176bc3fb52baedf112f381cec43de7942 1 #x37dcb5179b026944b7db47660b5f844c0e3935400 0 #x58fb9cd6d81ce1e612fec00652f143efb67c4bf00000) 35 (4 #x-191a1297e13d265a0ab8 3 #x8329e0f9a52ece3318de2db8f5d5cb9 2 #x9ac59055b18995ae054e1badf5227e8ce540 1 #x2720aa9e943b21b6ab581991ff4817f0a11929000 0 #x3d7e0bd435602c31454136ce285508d2f78793400000) 34 (4 #x40001219d3acd285cbf 3 #xa2b3d86ee14088bdb368e299e6650fb 2 #x9d5c335cb56c7f655f1a449f1153f0be10d4 1 #x18a559242621d62d99067cadf4c674c45601ad000 0 #x29486dafa594bae192f58b88211e66e6139d89000000) 33 (5 -1442 4 #x4d61b9430916df68455e 3 #x577405155e9b2047a05e187165029ee 2 #xae805b6b0a31ee4462bbbb171519d2680068 1 #xd591f29c0ead040377a0f867166f9da3f6d4a000 0 #x1af07d7e210ad8a4941433263c51ba12dbf824000000) 32 (5 38110 4 #x659ba8eee43d0d9b0c3f 3 #x-731a06397024cccc8f59ae36cc54332 2 #xd12c75c69452712c1374e03701a12bbbb086 1 #x56e7092e9291a042c9ecd942408a061705c52000 0 #x11185727aa7ae67abb633aff5d1b63ee2a67f3000000) 31 (5 -521180 4 #x-2587b8499f6aefbd1774 3 #x-174833cca1fa1bcfbc009d4e293ea310 2 #xffa03b7042bafd2e40ed1299c026603232d0 1 #x8b55385b39a0db5e9aea725b7f2adec18a80000 0 #xa8d93775c1b563d97a04592bccfbaf22c5f78000000) 30 (5 5975442 4 #x-1098db145cb8ed704e09b 3 #x-2187c16ae352bffefc2d5a48b64a6499 2 #x12dd2fc465a11c7930b4bc8bdb26befd32ff0 1 #x-1f935e715642a6580bf17d36d96fe206d0070000 0 #x656ccb85c4f0a17e2a8c4eb799f805c05c310000000) 29 (5 -54342285 4 #x-1184a6bf77e69e64fb8b0 3 #x-1d9f553b5fd79000e11bb2f1157db788 2 #x14e0f965e83c52f396f06089ce9c6f71e1480 1 #x-2de236c2f9e48d4568d0b477fef0aaa2207c0000 0 #x3b4b56a5199bced7f559eae9d0e818a5c53a0000000) 28 (5 331659897 4 #x62f1cd29e9d2b69fcaaf 3 #x-aa8c87956248ad0940161f599940a29 2 #x1560af794f1ba783c40fe4e5acd546dfefca0 1 #x-2cefb0d9351c3ff17085263673373083fa700000 0 #x21bd4e0b4b33af28c493d449a0e93ce263dc0000000) 27 (5 #x-2DC44DAE 4 #x2454f7b504483a5219c7d 3 #xf1e38f207f5830731c2bd5710714eae 2 #x14277785a083fe6446fd4feeafac55040ee80 1 #x-24e0cb5522142784fa9d587f6330d8a17fd80000 0 #x12af9817c591066e983009e05024290bf9080000000) 26 (5 #x-18ce5840f 4 #x346d5afd8f52b1a79d8ad 3 #x2353671c583c5ee4a487b074f69387e6 2 #x117a6101beb774c7f83e4b38fba61177a4c80 1 #x-1afc370091b725c2646807c99c84e37b64600000 0 #xa1242757aa518078fd94a85d7d8969bed080000000) 25 (5 #x1037898759 4 #xafdac065cf5196c202d52 3 #x295e9d09084bf301612d0eaef2900a64 2 #xdf30b1a6882d9dd2d97774ef2d5c645e4f00 1 #x-1213e963b5047950a59519fe82bbff07b2e00000 0 #x54809d06c693b2e28d6a2842a8f8d39f9300000000) 24 (5 #x-325afc7dc7 4 #x4e9fe6f8217d76d205a5b9 3 #x212477f77cd8d0b706aa5cf6160da946 2 #xa417804638dfd9e27696e396383457147200 1 #x-b3d21e9604df6dbc98e94c1788c958bdac00000 0 #x2b1923aaf221ccdd80a41e4a9aa54b184700000000) 23 (5 #x-6102d13f70 4 #x1c26ee1f248771fac7cf34a 3 #x117c72ccb21f274c901313965f338340 2 #x6f3d6b5eb123f97794fc8a89e64b07353000 1 #x-688c269bdc74bd3298120956f2b324e39000000 0 #x155e161070e03d1c9f2e8cdbb6c4d0071800000000) 22 (5 #x42da45833f1 4 #x7ca83ff28472450a9c6dda2 3 #x2b2b795014259eb9e1ac186afdd419c 2 #x4594c9e9253abf0e37e69e969d997c8e9000 1 #x-391aa48b3095c42550e7f41b78ad863b3000000 0 #xa4a8bbed5b9239e8677330ba1f0cff91800000000) 21 (5 #x-50dd234f548 4 #x1b96f898d0c609fff1525cb8 3 #x-63bafe667ae3165e137faf21409da28 2 #x282b1a22aa3f67a92406f7594013a0b6e000 1 #x-1d618f00673a47ffe43e7fabcb165920a000000 0 #x4cf9c0e3e148bfb8eef18262a10d5a14000000000) 20 (5 #x-21eecdbb3f27 4 #x4f8d82dcefc51223cb813b86 3 #x-8d9587dda085a82573ce2e74116f544 2 #x1564f14c7ff0b6572d3f13a591c5844b0000 1 #x-e42ddbc068c43bd3cbccda4ca21ba468000000 0 #x22e480b4aaf4375e9abf31ebb43a5bd3000000000) 19 (5 #x4fc69378e83b 4 #xbcd74f4a36e9524ea22719ac 3 #x-77904a37367e8ebe6e20eaa8ae63a50 2 #xa80d2e86ea5da4b94dbf0314e3b247e0000 1 #x-688d0f9a9632c7114f9d093fb2ad8368000000 0 #xf5146981ea65adbcafaed03fd1a13cc000000000) 18 (5 #xb3c7de3dc98e 4 #x173fa4e02152b0f57da8d66e0 3 #x-4cb2193b49907245fcbc2ce7d9bb970 2 #x4bec8f2e40106600ad77ed6c0df8e3b8000 1 #x-2d38f4a9bdf1535db3729a0817619c00000000 0 #x68091e8d52292fa0c52760976028328000000000) 17 (5 #x-1f191acb54aba 4 #x2639ddb305dc8c5dbc6cd63d0 3 #x-27a8099529e0e838f238685f36f6400 2 #x1f7eaf9d54cdb452109648dfa4ddcb30000 1 #x-1274c86c23c268352aff7c44dccb6c40000000 0 #x2aa0787b42ffb2252d288bb3bae46b0000000000) 16 (5 #x-343a9337a14dd 4 #x34af55dc2305905082415ce67 3 #x-10b69379d86ee015dc1712ba2ad3420 2 #xbf5add780bfd66fad8dd576dae3bda0000 1 #x-71993fdbdeb369d0e5e57ada5b90da0000000 0 #x10d2192d58c376327483cf26489fa20000000000) 15 (5 #x655e5501393b5 4 #x3d076bbe17e6d9938dbd91c18 3 #x-59c0a25b21e821ec78e4b1537c1500 2 #x42428295e811cfe1ec5b7b40c6bfd80000 1 #x-291f8ebb1fd9921a605b6b949b75480000000 0 #x66005c980bccb2dbc6714f74c0ac80000000000) 14 (5 #xcac4ad2be8fa4 4 #x3b7d9ea445f53c8d4021cd538 3 #x-15d64e707e01a1084bee3324bfe300 2 #x14d036b68582cf594cf665933372480000 1 #x-df91016fcabe26406e32f3953c9a00000000 0 #x2501f78760b838ccab96b72e38a080000000000) 13 (5 #x-769ddb3999083 4 #x30cb4d09c0f5324986ac97630 3 #x-243f0f6807f1fed8923005d1c9e00 2 #x5e32a6e54cf59a8fb50839593cd700000 1 #x-47060545ade707d5b463b103375200000000 0 #xccd3974ba5dbcc5bbc581bd229a00000000000) 12 (5 #x-1cdac84ca91ea8 4 #x219f75183644bb31b8b335972 3 #x122cd186c76c295711bc6b6f25000 2 #x17b8a885bd6d6477e3aabe5afa9600000 1 #x-14f9d3ab7b9766b6d2575ad7f4d800000000 0 #x43389fa1533755992e58a684c2100000000000) 11 (5 #x-b494d70465bfd 4 #x1368441caa83f1b131ea11520 3 #xda47a5efb1e8747fa0563d9d5000 2 #x5367179444c2c94443abc52677800000 1 #x-5b6687fd6125e670f74e8d9394000000000 0 #x14cdd46f507b67e0124e68de38400000000000) 10 (5 #x1695d5414acbcd 4 #x9573d1b9590fdbdd9d911394 3 #x57542ec0848c5c2f9459bb0e8800 2 #xf5a160de3ec177fb1eb687224000000 1 #x-16b1411e7bac10237318370ff6000000000 0 #x606d04e826b10af04f77c10fe000000000000) 9 (5 #x1a966fd0e09233 4 #x3b9990e301af593528095bb8 3 #x1995d8876aa5153ab36eef39e000 2 #x22018f532f4c89b9d7c55e4ce000000 1 #x-50db97bfbc2b35d8532cebe70000000000 0 #x19e78374357900cf61e8376dc000000000000) 8 (5 #x6a169d704f5c2 4 #x138683e94b478d96c69d46a1 3 #x5cfef6b2a5a3b003ff19feee000 2 #x2082363606aee1f674074026000000 1 #x-fc4b5bc182d86ee266b94936000000000 0 #x660de9db60a84c4632f5d6e0000000000000) 7 (5 #x-611fce95cbf99 4 #x5322b7b8e7b6ffce83172f0 3 #x1026713597a50ab908315050000 2 #x-a0713ca9409353945cf3a88000000 1 #x-2962aaec2f3e8e9f8f3fa308000000000 0 #x16afd1dd94271215af89b9c0000000000000) 6 (5 #x-55df4f56c7a83 4 #x11b44d77737fcd36e575670 3 #x1e9be6cee6120d327fbcfa0000 2 #x-45f0cca40787d4465ee5bc8000000 1 #x-53dd7e22a93e1837e42aa80000000000 0 #x476ab1e71d0cc78fcef1d00000000000000) 5 (5 #x-1b823d0a59e38 4 #x2f50ddecb481ea4dcbc540 3 #x10b9a1c02e487ad0959460000 2 #x-fb52d7f74ff31f56477350000000 1 #x-6099c741fcf3c6b659b900000000000 0 #xc1ba9c9b046089a36ab800000000000000) 4 (5 #x-301691119ef6 4 #x6077e0741fd54c6d10260 3 #x-861622cf5a63587d12080000 2 #x-25ae0dc05ae5f3ec74a280000000 1 #x729f53bbe35e2afd3b000000000000 0 #x1b4b89cafec4bf63298000000000000000) 3 (5 #x76fcbf6db40 4 #x901502e51f8cb2992900 3 #x-24570f618660bebda8800000 2 #x-37aaeafb3037d7c804100000000 1 #x3b657cf5f945f9acf7000000000000 0 #x30a14172e8c03c3be0000000000000000) 2 (5 #x2b46eb2d9c0 4 #x93d665de5be14664300 3 #x-4d0c61bc570c594e9c80000 2 #x-fabfafb0ab1410de000000000 1 #xa26225a506b35740c000000000000 0 #x3f99a660fadd2ae00000000000000000) 1 (5 #x47d43c6140 4 #x5cab1808bedf005400 3 #x-58629ce20e31f6cfe00000 2 #x8c0265d6f2a9f881000000000 1 #xf0a8d742c23f69e0000000000000 0 #x35d9f687f98a4800000000000000000) 0 (6 1 5 #x2948b5a20 4 #x1aa15a041116ea100 3 #x-2af7d99d571d553000000 2 #x10934318b72d9364000000000 1 #x9c4b9c97d7d4a00000000000000 0 #x1605b5ca0244000000000000000000)) 
  (svref *ec-g1* 107) 
    '(108 1 107 (3 -1 2 2231 1 -1068470 0 36708372) 106 (3 321 2 #x9d1787f3 1 #x812ca5ebf8f 0 #x198859ab21bea) 105 (3 -48792 2 #xc8b24df3f58 1 #x-a8b2acf297d4709 0 #x6352a2074dd62fe4d4) 104 (3 4673118 2 #x2121670047ee2e 1 #x484baf44a4cfd18c80 0 #xca3b9a60fe8da528ebdf) 103 (3 #x-12DF0DE3 2 #x16eaba20192e9fbf 1 #x-3f5ea452d947547e3cd5 0 #x700d19ae349cf7c00fe5c0) 102 (3 #x3c296dce7 2 #x4ccc7c276b2f14f3d 1 #xd5d9737ccabd56372d3fd 0 #x-1dbde0fa0bee3b36254f948) 101 (3 #x-961024c928 2 #x29ff97465f14fe3d38 1 #x-153ca1b7726f38c57beea48 0 #x-7bdb8159c261b2923bda93cc0) 100 (3 #x12c79e0eb08c 2 #x-53779c0cddaf973c13e 1 #x13f8150371ba2ccf80305e91 0 #x1c6df72b32405fe8c9233831627) 99 (3 #x-1ebb969f543e9 2 #x-697966b0499ee98b3b7 1 #x-c381fe131a4ff9a11fb8f891 0 #x-37411a0fed8778c02e9eae3b3b44) 98 (3 #x29a2d2bc4f1e4b 2 #x2b55610d70677daad5984 1 #x4f4af8e4ae4eebbb9cac20e43 0 #x492009275f2fb7d83bd62f7467f66) 97 (3 #x-2f216dcf2ff8ac8 2 #x-13d44e139f4a78fbe449b3 1 #x-1490800b1f72be327253d8a467 0 #x-48def1d1832d8c546c97c825cc6dfc) 96 (3 #x2cdd791282263184 2 #x-ece55e42dddcb21d7d59 1 #x469b8f65edeb139839a21c777b 0 #x39d7260366617172b2699a631395163) 95 (3 #x-241095299309cc9d2 2 #x355ce99f0f2b1137f86c0e3 1 #x-32aae0cd539be564717bba65040 0 #x-25f03463234e4f212ae0accbc3c0edf8) 94 (3 #x18872b57846f3c4096 2 #x-16fd66f71db0fc14191c10bc 1 #x3085301ad7898eed4f64c208da7b 0 #x151cddf35c8304ffeb9d104070f451058) 93 (3 #x-e1b4730aa90a4cb74f 2 #x3f84e68aaaf059eb6aea6f6b 1 #x-1db78d719c4bc498e61d8bed47bc2 0 #x-a2b78c7aee5e8c8773b2d786e2a0c5bb8) 92 (3 #x6d5befdefa03151d6f5 2 #x52f19fdfeb5be39ec1c52760 1 #xb6564ae177cf1271e0f3f9cac91ce 0 #x44eac1dd05433259afefff00d606556256) 91 (3 #x-2c3f7a5fab5f0a4380d1 2 #x-5db7398709a1b112e9a6b2bd0 1 #x-209401e990f27b5e2b7de0d17f04bd 0 #x-19fe2082105961f060c495075ade4907638) 90 (3 #xead6c7a39f174fdf29f5 2 #x1b37965f41af5456516450bf8a 1 #x-afb91007cff212ccb7588ae81937e2 0 #x8d23f7fbf8a6ce593a7e0781e00c49e45e0) 89 (3 #x-3d4c547afec0e602930eb 2 #x-58b20d2f1d177cf78b3c6dca0f 1 #xcb74947e144ce524270652e8bd81d04 0 #x-2b7a2ba3a9ddb27540c3f76e522618020828) 88 (3 #xb396a7ec6a1be3e1120dd 2 #x18ccf0269655b66614773ca5c69 1 #x-6b5e63acec1b3d10d4dbe5804af2070e 0 #xc3eeb0ef695fdf705edc0ad090ba99cb2706) 87 (3 #x-ba3426c4c12f10ae76132 2 #x-c3e989c706e0c455769f5bf3277 1 #x29bd2484ff7f39a14f1155c23baf05f50 0 #x-32c6aac37b6977471df0e05e78d2513219988) 86 (3 #x-6558da03c7f11095b1410a 2 #x63942b24d5dbb1877c234703a528 1 #x-d42d004deb7214033f9209e8c99908e3d 0 #xc2c1ae17bc583810a20e0e4bfe2586c412db0) 85 (3 #x30e7a88a4b4a5e1cbe485b5 2 #x-2b9e8ebd1eecaa57df5b0dedc4ef2 1 #x39701c0c168c86008b64b466cc7370c9b8 0 #x-2b63b7441cd96c66f22b447e92cdd15ac4acd0) 84 (3 #x-c54ded7484f77d4743953a7 2 #x10bf5e64905788b06dd87e5840f26c 1 #x-d8367056acb7adb83d2cce962a7e3c09f5 0 #x9052a028b17dba397973c70e71fafbc7628de1) 83 (3 #x1e7baaabaa5334e52faa81d3 2 #x-5cd0a50fcd6ba500f225e6c30981d6 1 #x2c8cc5ae2e425c0738de795e5c54f899319 0 #x-1c1882d804a0171e633a299d4abab808548883c) 82 (3 #x-177e878fdd697ff6dcbda895 2 #x1d7bf285de50a0f83f4839f3c7d8d41 1 #x-8036453a1d5082ffd2c2a16e5079bc15e99 0 #x5234423b59e261a529a9ea98b8ea34f25cf1b62) 81 (3 #x-b7adbb2b3ec344fc96c69115 2 #x-8a7f8c804800da685152e7e1218919a 1 #x13baeea01e309bd92a79e8e432fed439a453 0 #x-e28ceec6fae7769c3ef6506bef0422c04541194) 80 (3 #x421613587c493b7119c891c27 2 #x25b901d9b908e18c608361af0fe52997 1 #x-27097718ad37f67711b39ff214e0f920aadf 0 #x24d87b20b2e806699feadca7a3ef1894ff89ad39) 79 (3 #x-c56bc199d8a90333a0515bff5 2 #x-98e9d1566b61890a0a8654a8344b7e2c 1 #x2ffbeb6e4b93529ece3c6c06d0dd77d9ad76 0 #x-5ab97910aef7844626b2d99ff5d4fc64ec207748) 78 (3 #x14f6968789e13b7de86e3949e7 2 #x241fc7f397a7bf486fb48fcd4f56d5b6c 1 #x30a41f9a670a0de2a6bc1cf69e26127b8ad5 0 #xd3c706987a21775ad0d4ab2d583341c3945041c8) 77 (3 #x14059eece8588edb6cdcca409 2 #x-7fa3c1ce4f06b64ba4bf51156a309f3ec 1 #x-24b74a3c0ae90aac348cb8fbfbdfff179aed6 0 #x-1d56e345f5c196d288b00003054b7b1b5380e2158) 76 (3 #x-8ec72030d1f99740041cf1c489 2 #x1a6a744c186676a47c10a4ba13258238c8 1 #x9f5d750a9f342e22184c399a11d7059a7fd76 0 #x3dd87c72c091ac89d8278df57a2c02898f1fbbd21) 75 (3 #x21d91731113f94e7cf17d82b97c 2 #x-522d078873cad19f34ef22a5bc2ef50e10 1 #x-2100194932593a844a448b23d828309fd485a7 0 #x-7c2177986c0098f235c7923ddec2b38ba8f5a2ddc) 74 (3 #x-4b5aed5b5274091f54baa80baca 2 #xf0bae8bdd063dcc5fd77d468283e44b747 1 #x5e17695ff03ddd1705faed9cb38985f1280551 0 #xed7b25c35555fe18f4f2d750ff55e982662153c7e) 73 (3 #x5c37adb9d8b0b04da32b121b55a 2 #x-299901ade631906e823176c1ec067a0b5c2 1 #x-f138fcb792a150fbdbd5562a25344abdbdc32f 0 #x-1b175e01e8364c145b155a0635956d692e7b211ecc) 72 (3 #x35c2e7f359edb480cbc571c95ee 2 #x6cc4ebb4e3f3803c38c6b76830e2c3327de 1 #x2382e456a08396b8b08de759a1f6cbaab867d26 0 #x2f35e024f81f6d4cdb3bcbfdd6c9f15939ce30c05b) 71 (4 107 3 #x-272586f1d10f4d692c4e45b5ef96 2 #x-10d811902d0f395f4d1481109943768b181f 1 #x-4dd08ae5518a8088c56db2d34fbe8722ea5f937 0 #x-4e9788067a8aa8cb03e60737b732aea1c787758868) 70 (4 311156 3 #x75c8f46df1324ec7b918ed950d6f 2 #x279eb59a3456f17129c11ffff0dd27856f5f 1 #x9fe8e2010422361f3dc6cd48f27806f4a377c30 0 #x7d07c42321c9686dd439f090ad65432de09269a198) 69 (4 128921732 3 #x-e0f98eedec7345e4218a446b48a6 2 #x-589e2a02a5c0e49fdbf4e279e003f84b72f1 1 #x-135e6ac95809dab9a9fed344e7e9b65661cfea18 0 #x-be1fbba07f991e773e46ddbb83b32cb503fde272d0) 68 (4 #x3a5cfcec9 3 #x102607e883f456e9710f208fc08c9 2 #xbcc660bb0b7550f3055713b3691259c16ca7 1 #x238ac294c2ebd783f05c1d50d5e3e6059c4a95cc 0 #x114569106fec20f8b198a5d7e0cf50ade6704779224) 67 (4 #x9e4eb46569 3 #x21bae7c70d36c68629fa19366008 2 #x-17f8a510989a9ed0ab3137490be00e7e08cfa 1 #x-3df1743155b0eeb2cba2cd2597a0772cfe90af56 0 #x-17fd1ef9673a041d342db01cef74f6ab385fd349830) 66 (4 #x8c03ffa2f70 3 #x-411f0fa1d26bd2f7bb01df689b041 2 #x2e8387524ea1eb20ea7687d7ccbfa72b4fed7 1 #x66c582ca50e53518df75ba8041a1bccdb55bf698 0 #x1fd31a42a3b163c70ef8ea7164d0024c76fa1124240) 65 (4 #x-b1f22f51721 3 #xc11732811e67fc560febdc136a67c 2 #x-564de355508102d53054df0f9c3e5459fdc7c 1 #x-a29e5b79661791ae193fcd97105204a06c2b973c 0 #x-284b25023771c33669284d832a5e5f7ec26fadd4c90) 64 (4 #x-2c10d2a6d6606 3 #x-1724dec0b9dc7b20469ece95702959 2 #x994c4bbf9047f25974a71dd553905c4ce3e81 1 #xf5c0e6e35eb1d74d509989c673391bae3992fdb6 0 #x30a1205ea40e4a84c35b554a4a0b71638037878a234) 63 (4 #x25b171e7125cf 3 #x1f219e7e9348f9feb66ce8f5944f0d 2 #x-104f1f83c5237ab1a9f83e5ac55a24037b4c2e 1 #x-16315c4ed43b59b321787f0c156611c65d4aecbd8 0 #x-37d8ea30716b5a84ce877a4da5f01699b3d8524dcf0) 62 (4 #x6091d59a30f7e4 3 #x-16402791bd0d6cbd3d8a51b9086fe5 2 #x1aa1390edcb0d9de5a73d8e6a69e0cdec9192a 1 #x1eaed25339f1821d735bb36c74aed836906e17fb2 0 #x3ce1a0aefeda6e1d59152dc71efcd494ea009208e30) 61 (4 #x-d1b701aab3ea23 3 #x-17eed05a76ba4ce555a3466628f008 2 #x-29beef2eff3815a39c6584112634a8043af21a 1 #x-289d0c580ff6614b5c32f4978aeade746a4734244 0 #x-3ec842f353ef822a968130a86db4d843b4998e57780) 60 (4 #x-6368149b65be9b2 3 #x7edabd65949b113e81ec45f8b1b370 2 #x3ee15f34e667b4dbbb3788b5298aa28201e369 1 #x337bc82b7702172104de46c8efd781ef051af0eea 0 #x3cef78bb6b5a3657dbc7c0ebacce1f510c968a692eb) 59 (4 #x17cdcab7a2f77211 3 #x-1212a7e89eb9403f981e0a13702af3b 2 #x-5b12bb0f66f9f27fe44f0f87d440b85a956a89 1 #x-3e818e5145115102000cc6059029d80d41b337650 0 #x-373df672e09d9c2895b6c676264236c6b755fca78e4) 58 (4 #x29c0c30dfb2fd4ac 3 #x1dc216a2dc9c69c4ccce826c957c175 2 #x7eeb4e732ed9e1c77e3817120b2461eeb9c447 1 #x48ab81279e15fb86d58aec40ceed5b7a95168af65 0 #x2e34aef675c77a298362b74ec4d8fbcd40131cf7aee) 57 (4 #x-168d1b2e9ddc133fa 3 #x-257c4b89ce6f8a8061d9f8cae8fbb8f 2 #x-aa49d37f517ed05c01f7c9d875077c567c6224 1 #x-50ddc80a4831a7af6876822deb3419e5328b690a3 0 #x-22e2e148ce810f4dc40b2af3835756fb0e1570da694) 56 (4 #x1d3f959e970d7d585 3 #x2099966febd2f9485319bf5a6bbb841 2 #xdc169b2d92d62b4e174637a49981c71ba5fdb2 1 #x5610581128515ef7fba667dbf4f086762ac787414 0 #x16b737a8ade820e5612c8450fe63d28b13fd4703c01) 55 (4 #x2c1230166f6f98645 3 #x-55bb7fa7a37b1dbe868b13762f1176 2 #x-1122395e9b53109f46a54e52a2e73f985388a0d 1 #x-577f69246acb384fc79ca640ca21bdc45609e750d 0 #x-b37df2fe65fbc40feb7718826563125268a08256d0) 54 (4 #xa464445c4fe930ce3 3 #x-330d446b6ac0f5b027a3cfdc77859af 2 #x149391e13fa4460dac1e511660d045a7895fdd9 1 #x54d45274a6cee4ba370a0ac54601cfbf2277bccbf 0 #x1b3f0341c4efcbd4047a9fde493d820e10dcad6888) 53 (4 #x-aaf6fae6f924f41b87 3 #x879319ebaadc3a9e781ddd37b8dedde 2 #x-17d57e0b618b05a2518c7e8b67aa8d6d8547d0a 1 #x-4e3c0e6dc6dd3c302f4f5e5cc87f802603f99ff28 0 #x4fca725ecb238119319b279ceac3b1681a5aa84290) 52 (4 #x3605c9238ee8af9d8c6 3 #x-eb78ec365803f210ececda40cd1c527 2 #x1aa2c7d33566cbaae77cea36848730d0e586ce9 1 #x446487911dae8ebbb41aba8523e55a27bd9a9329b 0 #x-899aae2b7aa8238793bc0a2a08262184f9698670e7) 51 (4 #x-caa8ded06b4aa43bb63 3 #x145f7b4893139bf3849dec830556c240 2 #x-1cba4532c6cf4bb6382c8d748da74802ba76d43 1 #x-38601cab2cc549109855869a131d9cd348d77b2bf 0 #x9745de5c40293908008db67d4fcc8b680fa2374244) 50 (4 #x2c4f4d9013d2a3828846 3 #x-176cf7f6dc78465189aa5a9c5c675fdd 2 #x1de885b281c5c9910d8f37ebcff4fcc76e1e7e4 1 #x2b759bddf9e1672cf2d0c79dc692acac7719e6d55 0 #x-8476b4c3419f3586bdf58793cef9d1ee799802195e) 49 (4 #x-968d4cc4470517c35793 3 #x15f54d1ecfb32a1c13fe2c147004f2bb 2 #x-1e0fe7269a37ff3c289160452deb2acff8cbb5d 1 #x-1ee814d53a09cb8c92bd53da3e166c134561786c9 0 #x5fb8e6b72243a77be3a13c3ea499b9d3e09ba7472c) 48 (4 #x1dffae927ee5b1ad73de3 3 #x-ed54d60eb5556e3fc56f11b43b718f8 2 #x1d2d530b639f47628d9914983dfb8e6917cc909 1 #x13c3a7c61d3a6466a6522088ff91f0c06362a10e3 0 #x-36bc690a701260fded9bf4ca0759ae5ad2b2df148f) 47 (4 #x-579e1e4bd9d539017265a 3 #x23c1bd5925cfefd5b15b713b784a897 2 #x-1b589a80d01f16a60343950ff81ec295ff200c7 1 #x-aba622aa173b50744637ccbdc5f799781a19e65a 0 #x1396a61a59d3ac0b6c3f5e3515f25a4b2c00c50d58) 46 (4 #xea1c8a4fa8cb05708854d 3 #xe2a6609f246448b4d93e4ff02393d66 2 #x18c064e4288e5c62199224d5ae7de3ddaf36350 1 #x417252ed0c0a0d8140652bbe9b774f2863b9e037 0 #x4710e3fc5421f4dc16ed3477dc3f48b0cca29a078) 45 (4 #x-24096f28a48f3a1cc225c2 3 #x-1f87d1062feba8a2c7a96930d2e4d432 2 #x-15a2a3eb13fb00f63d4564e8c2ea54d612e5707 1 #x39b0f844aa1e795d7c55ea6c67dda13cc788406 0 #x-108f2a54ac096fd64d5bcd0355b33db9f04881e138) 44 (4 #x526c1a798be991942ec6c4 3 #x2e96081833361a148f45468b00a69928 2 #x124337f53686eb3fd432ee72e1133647e8a168d 1 #x-2918146fb2266d50edfec1aa6dc55efea2e0e8c4 0 #x131613aa2c32f73bd188136b80b852c46577dcd796) 43 (4 #x-afebc6a5bbd773ef0def6b 3 #x-38840c158f0b8b6f35819f6ae59ec553 2 #x-ee2b0e28eb082736c66e4a1a5c9bd39c56ce7c 1 #x36f309449cbb0be1240ddaa7b27205c790f614d3 0 #x-fba417b77c7e1fc1eab50c0ab93e0a2869610ab18) 42 (4 #x15f619ae63d082e0e9570ef 3 #x3bb542768da13e6d3348ec5f7655b73d 2 #xbb6db063f153a07a421422483ebe425b23b464 1 #x-35827d8508859d5eaaf7f0056b37eb663b0b94fa 0 #xa1365bb1344271cfbe79728e57eb4ef3bef9785e0) 41 (4 #x-291f9328c06a6e2a08ea5cc 3 #x-381bad4eefaaad2bf918919879aadd08 2 #x-8e62b205e15abcad7bdc55d35ecdbd577c8129 1 #x2c0f18f7be3730c4522dc3384eb09cdb3646f940 0 #x-4b49edcb0bd21181ead516a817a2e47902600aec8) 40 (4 #x484df0e7e25a07fc6495847 3 #x2f166cd8b6dd0a66a1565c537bfc9d97 2 #x6865665756e037be98e3a0215e89523c0fe82e 1 #x-20055e9df08793f47236125571182644359f5428 0 #xe99525268fba59e890d1f799f6242cbc170548a6) 39 (4 #x-778f7a9eac0acde9f578464 3 #x-22ec541f9a39a262df989a85a908d062 2 #x-49daeef8ac1202c96f144be8cd3d3de1af935b 1 #x14c7b19d33a7c4655874e7d51836255b4ba3ff38 0 #x11269ecd681cd775e2aa46c54a664ffaaac4924f8) 38 (4 #xba3d4be252a1e9c1a35eb8c 3 #x161a5ea9cd98a4c46b96c28f941a3521 2 #x32664c26c126221b08a494f05b89e7d5de09ac 1 #x-bf49c890f228e74c5b61c6a850948bcef739a25 0 #x-1a554d0ec4ea124e1b0fc4e1a487f5c5e59f976a0) 37 (4 #x-111b787e29f2baa864a3a604 3 #x-ab42fdecd75f54188a9d1146a887f7a 2 #x-212a163cfeb0f411f92eec33bbea19c9eb0afc 1 #x5e80d2ef0ad086a57bcf866a9d534235472d20c 0 #x169937c5878f91fb176ba137c46410d0d834aff50) 36 (4 #x17c16ef8c2fd80773b952392 3 #x2030b55e0884f755bea2aa137cd0a2c 2 #x1508fde9f0b3aaa3bc35d131c019d59a73678a 1 #x-2449a7b685eb4820fb0ee4901c6c787b8f6c0f5 0 #x-e4d8e623a8e60f304ed53feae098e2a5afdba6cd) 35 (5 -1712 4 #x-1f3444352efbd6f6e7e1e729 3 #x38e8631cdf6a6c38f9f6610207a6efc 2 #x-cdabab063e614a6240ba4e114f76ef642dc10 1 #x6385ad24254e248634e47dd81e5a35c1d1a8dd 0 #x69a6ec82b1b0873236cb77e705bede4ac899b60c) 34 (5 351816 4 #x26cee7a3141019c9a13e1d85 3 #x-64a7babd621b3674385f1601d238eae 2 #x7907e9c64499f8e92ccb8d6b66df9eb97afed 1 #x6222bfd7bfc74b8efab0f3a3bb63e4bbf2e015 0 #x-18dad94621aeb9cf9060e932a475658e95bb9a7a) 33 (5 3852321 4 #x-2dbaf3c5887191350d0daea5 3 #x6e49a9dce0625b089d848f17c8f4a5a 2 #x-448c50eeddfc78b3040ca5e2dd4b541e8029e 1 #x-8f84f586a52b527d99218a92e71180dfd639d7 0 #x-d5818369d072f4c73654acebcf0b50ddc69622c) 32 (5 18038060 4 #x33151da8c7b5152f2670014a 3 #x-62e87ed2773e487c0775a0423eefd4e 2 #x2557a2f8285e50d74a044ca1a4ea0d85913d4 1 #x7b1b7a0c2121deb33ae3c4321c3803c27c97c3 0 #x16cdaaa0d09cee9019a5610767d1c497d945a907) 31 (5 #x-A4806A5 4 #x-361c0caef7ff9759fc64384a 3 #x4e0002bbab9a3cc608f80c5ae7998cc 2 #x-138d9e689166c115a77fd9cb80cf196b3688a 1 #x-550895121d5f808a35415d4bd1067473706fd4 0 #x-1286469bc4ac8f9ce687e6011e232a2c4671fb28) 30 (5 #x-533CA565 4 #x365c906ac6975421a792ff8a 3 #x-37af59bd6df2ed4f7c40f6364b91a34 2 #x9d56fa346071002cae79f233985081b7739a 1 #x32e521c7fe01a98ea63dd20c3823ab1365930f 0 #xad1f5aa9372d9c2addbf27de4bf830d83649678) 29 (5 #x278c4d0ed 4 #x-33cd63e6520c856e7a4e03e0 3 #x2480e1272a0b2a86b2fb44081e41833 2 #x-4bf0679007d768f6179de2bf72ea6c958ca2 1 #x-1b0c33822d6866f4e7b10e87618de839014e6a 0 #x-49b4a30d7b41a8c34e100fb35104aafcae9cef8) 28 (5 #xbe2bf984 4 #x2ed15a6b5f03311a0b88c158 3 #x-1623371ec4c584200d3d404085ebac8 2 #x2324578303fc2f20a1330cc12239d7303434 1 #xcd1daa242dc9be8789ac89445a29d66662496 0 #x110f70c7f4de9f62344b0dc4c73218d3e1fe9bf) 27 (5 #x-35fe0c7745 4 #x-281f46ba46a4d7ba4c93fbc4 3 #xc77a661d755b1796bc4151f484281b 2 #x-f93c773dd271705ded63cff41cb18f4d0d6 1 #x-55bc8ae06b614fc35bd03272fedc9fe8ad539 0 #x5dc2a053465a7f64966d1a104dde88e1b8c05c) 26 (5 #xd126f76001 4 #x2097a18f7a5e9411127ed9f9 3 #x-68791a8a21becfcbfabed71a0cf74c 2 #x69b57a5cced293661f3c26ea0529a114689 1 #x1e775708c0f06cb42a6d91ac4ec325f5b99c7 0 #x-a43ff6a21f490be8901e9f9940ccf1d871c7c6) 25 (5 #x-f3506987ee 4 #x-19154aa312bf333d08d900a2 3 #x32dc60620cd88b7dffdc014ee0456c 2 #x-2ad930fe2c69a7a64725c37f634df0e8dee 1 #x-8368563ec1fa6bdb6ce7058920dd34e76da1 0 #x7b0c993a197bd82299596d0cf383cf8fbf8a9c) 24 (5 #x-2e4bf124789 4 #x1246cf1b4cd9931175f41819 3 #x-16f703b710ee6400e92c700d030da7 2 #x1093d9cd246410ea69cec7343af63cc251f 1 #xcdbd9d432c66a78e4cb704bdc3f29f8897c 0 #x-426580f89b41d1a2af170ec29f39933aa3572f) 23 (5 #xf3369ad6e6b 4 #x-c98fb779c4944a2a11f73dc 3 #x9934f43ad6de10165d27f0ebfcd0b 2 #x-61cedfb37d23921d275e8a32064ca1df25 1 #xe6b01294a59040b1298e2284e6a1a9e1fe1 0 #x1b3154fa34e6ddd5b668b5f2d332505507f408) 22 (5 #x-220c65e7d44c 4 #x834a2bf947a4e588374fb13 3 #x-3a8e40111acf38a0a2f2891ffb4ce 2 #x2252b3b3d9bae7a5a68d44645a34480397 1 #x-dcd07bd834294bf0c2c1e2244f213d6e992 0 #x-77bd670b33d4f3df9e75816960493fdd05228) 21 (5 #x2ca6a5528af4 4 #x-50b6db7b1fd76ff53d8264b 3 #x1441bd360d7813108a52da5cccfa5 2 #x-b715b0deeea027abf3359b6d02edf170b 1 #x841ed627a09ef311ac5ae2fbce8cf037104 0 #x2336cf67836d8e77a5faaff54244ec87a540) 20 (5 #x-1993e7e9b3e0 4 #x2ec4427baf1b30f8d42b0e5 3 #x-63262b6e5a3ae717038bcc0d6ea7 2 #x39e0b57ce607a0364e2059151160e8820 1 #x-405cf4561ef7e77a4f9176b61586773620e 0 #x17da9b97531fd73c2c9c29e8c3f3523f0ddd0) 19 (5 #x-20a737b12b67 4 #x-197eb3b058e324e3607e1b7 3 #x198071efce5ca4c63c0615d537a2 2 #x-1150121ba55c81ce3bdcf8b0c3c93243a 1 #x1b5700bb219a142a796f3ad5bb110ce1d80 0 #x-13b8486cc84cd3f466c448a9d56b657520300) 18 (5 #x71c72b40bd55 4 #xd0d21dc8221419eebce429 3 #x-4bd18ebc57cdf6d61474ed842ca 2 #x4e378123daa930526ec40b4e6608ced3 1 #x-a67db249b2e9c4ff1a0385def4e4ff01dc 0 #xb102fa8a35ce506478d2e7a4bfed0fd33a80) 17 (5 #x-b68ac8e3f725 4 #x-6427e73d14842ece417bdb 3 #x205d215e0f26c17100d508890c 2 #x-14caa1a22579a35586c20fd072f3c148 1 #x39801ce927f2ecf127841e38fdea6a7fa8 0 #x-50c5835cc92ec62846633f00944a83297200) 16 (5 #xcfef73ca9350 4 #x2ce3f9cb7028f8dbd347cb 3 #x6a167ea9a32afe5f4eed47c758 2 #x52fbafbf2510cc5ea7ae9d8a43dbb00 1 #x-122099bda4ad13a6ce9124496f18afd178 0 #x1fabd250d699d90f5f3851296e455c500a00) 15 (5 #x-b70b792017a7 4 #x-12beff4e5b592eaef3f3ff 3 #x-407e54cc3438e90a3b74557b99 2 #x-135a5fd75bb87a128616801ad694c14 1 #x53a5e3a7239aa3d820dcdda7daedd4180 0 #x-aebab9a0119392bb5d2b6cdfc908e3b0800) 14 (5 #x7e0fe816e11a 4 #x744bd2c7ddf8114055649 3 #x1a6f2909678f216c1a5d8d9682 2 #x4336c2a360336a7ccb302516705d1c 1 #x-16107124d29353a7c622f34e2c14c3440 0 #x358de1d714bd70830a89b6255961542b800) 13 (5 #x-40d233e87562 4 #x-29b35fd1543592a580d45 3 #x-8d4aec15c59f7c83ccceb172b 2 #x-d8167f8c0666217e981a901f4d940 1 #x54fce89db615e2892de8d95dea21b880 0 #x-ea89428c46b2d5d51945e5c2c0fc758000) 12 (5 #x13a392b9d212 4 #xdc38b6e53b227f269caf 3 #x2890f27fa4b1f79344ebcc760 2 #x27ebc6c103b7d1e159a90a18aec26 1 #x-129a873d83a7774228f932314068d980 0 #x39633a9f9196c8bc0983465977adfa5000) 11 (5 #x3ba109801ab 4 #x-428ae2e33938cfa16540 3 #x-a34ce4b6bd4245fef9695307 2 #x-6b92008ca7c598aa3e1dafcfaaa8 1 #x3aedf2258bc63ab86d135f0c6d6c000 0 #x-c888ada78140656673918d5012ecb0000) 10 (5 #x-a69a8b007fb 4 #x1249b75eeee34b5ad86e 3 #x243ae68cfb9727024d096c2e 2 #x10551acdd7a24462e5b874c20808 1 #x-a7a3ba1e8b8de2e7b152639c1a8200 0 #x26f29854c7b192a50adaf9d84f0e18000) 9 (5 #x8cf472d7484 4 #x-4893b9b4e07cce0c8b0 3 #x-7150ff780453e1a2dbf5fcc 2 #x-233eb6305166959a277b07c0800 1 #x1a869e76d19e8ab08e97a263de9000 0 #x-6b03e2e892edb739a990dd63889e0000) 8 (5 #x-531d94e76fb 4 #x1017ed289de8c799bd0 3 #x1366d3943be7d70270a9802 2 #x422ed4dcfeccf7aaa58b57fa10 1 #x-3b13a82253bb701f885d6c093c800 0 #x101ebc0b34e36e711f0397a7b3ea0000) 7 (5 #x265d8a3b629 4 #x-3272f8b351bf3e8f6c 3 #x-2e0d9b20812eea5606a2d8 2 #x-68d7042920b69cc6b9f922400 1 #x7206c6449479cb997de5a58a0000 0 #x-21b6f83a458a8b10092e9864d780000) 6 (5 #x-e5544c71e1 4 #x89a8c0c826ea74bca 3 #x5d29cc3e32ea6a8c563c4 2 #x84e03cc1dbbf102e49c6c700 1 #x-bb03a4be1a43fc25d610e5d6000 0 #x3c5196f6637c1fad27f50ed7c80000) 5 (5 #x45c27729ab 4 #x-1409eca86ec4f0bb4 3 #x-9cb9688245a88b137b98 2 #x-7808309d7e6880921e85800 1 #xfdb52748c06887a01e15fb8000 0 #x-5a88e34624a62cb6a07239f800000) 4 (5 #x-111ca1d644 4 #x26c808ac60421d39 3 #xd3431dec72b1ac79e98 2 #x300e230840b34168b3c900 1 #x-111e3dc77938f7b0b64f9b0000 0 #x6ef0dc82d38662c9e341c4d00000) 3 (5 #x34cbfed09 4 #x-3bf93d3919c78f8 3 #x-d70346ae88f8ee14c0 2 #x35c31a183cfaf9f57a000 1 #xdd948eaba23987da711c0000 0 #x-6aa19150486e5c437565e000000) 2 (5 #x-79A4B2B3 4 #x45a3dd5a6af536 3 #x947c683db001f71e0 2 #x-703de537bbefc99e7800 1 #x-78f01aef258c7287ffe0000 0 #x4b6807320ab9a639b539800000) 1 (5 197295588 4 #x-3624b00de83a4 3 #x-36b7a2f1ca7dc380 2 #x5609914ca90a1bba000 1 #x23644fa1201c9919980000 0 #x-22e316257130ad9feee000000) 0 (6 1 5 -9663138 4 #x153a71e968a1 3 #x38ebd77dfb9300 2 #x-19c9fcdda65e48a000 1 #x-228d7d6fdfb77b500000 0 #x7ebc25b699e7f75f1000000)) 
  (svref *ec-g1* 109) 
    '(110 1 109 (3 -1 2 2231 1 -1068470 0 36708366) 108 (3 327 2 #x9d1753a9 1 #x812cac091d3 0 #x198858d915b51) 107 (3 -50685 2 #xc877650f010 1 #x-a8b5b3fe59bc5ba 0 #x635298742bedd183fc) 106 (3 4954813 2 #x20d60fe07ac30a 1 #x488af13b189cf5a6de 0 #xc7e7aa602d06de6e1c48) 105 (3 #x-14702CB5 2 #x1622530eddf6e0e2 1 #x-410f0e74d3cdee398428 0 #x6b42e7b2a3f962f1bbbb3c) 104 (3 #x4296bf673 2 #x43f0829cc28d1b9e5 1 #xed07749db2f661e3f01c8 0 #x-495c5bcabaabd375a86ead2) 103 (3 #x-a9c442150e 2 #xa5a3c83525a1e7240 1 #x-19b9714b284bfca87026c3c 0 #x-7c027b468cfa865960baf013c) 102 (3 #x15b4d8011b86 2 #x-6bbf3e6d7d45c4d8c2c 1 #x19feea329dfc5c7ec1ffea23 0 #x1f5f87ae34bc14c8469dc1e1cf2) 101 (3 #x-243fe079e2743 2 #x182c2d05009ce5936a47 1 #x-104146726528abfb5e51c0c4a 0 #x-40ef9d0f62266e636418781cf34c) 100 (3 #x31fff61b599c99 2 #x3b93663dbf26937d534f5 1 #x5e331b384e68371e1c528ca4e 0 #x59ccc587ae49c44f45b8c3f475ef4) 99 (3 #x-3965eaca5c4209d 2 #x-286f48328ee2e974a0671e 1 #x-a93e22578080e13b3948dcee2 0 #x-5bc23c75d05150414ec350f254aa94) 98 (3 #x37109491a445c47d 2 #xad7352396a111e936f8b7 1 #x-544da59b8d684118bf4f01c7d9 0 #x4916c3017d49bbfd6c77101aa912511) 97 (3 #x-2c2c703b5cd96ebef 2 #x8d56c4bb8c52db8596ef8ad 1 #x-76cd806cffba2efb333c18ff80 0 #x-2ee9dc89006a1d78c4857f40574ed682) 96 (3 #x1d86cff0f7fc3277b1 2 #x-38280ac2138ff9d12a096ce4 1 #x3ce672aceca0776f9b9edec43a5b 0 #x18cf88187b7ba894bdd3de084a2bdce01) 95 (3 #x-10495b2eabcc054068c 2 #x3b0915e6185f6d594b571ff 1 #x-2bb21ddff8b59246dc094ed1c63b0 0 #x-afa769e793bc7641cff1ff3b9d9c74ba0) 94 (3 #x7431977e51550d7d63c 2 #x60d3c6af7417cd7b7ac0629fb 1 #xe8542f3daccbbfc54f0264c5ec5cc 0 #x41b5c5501ef8ab6ea1c6a2cb053a45e7ba) 93 (3 #x-28046840dc4013902446 2 #x-1b29e0a1285b1c74ba46bac9db 1 #x-22e60bef1045bf428a0a4f9c3e1ec 0 #x-14e987f21a9138b186ddb61c50d3ab3de24) 92 (3 #x95f1e50b7b1910d0be0e 2 #x-7b92c759f9d1aead3a35ef03c 1 #x-2910eb4e3a4127ce8286513e1b76ece 0 #x5ac93e9ed6ad61701c375227e08f73cc072) 91 (3 #x-a7d00827bfd27979d838 2 #x1c26a11519070b465fa0364c02a 1 #x192e0b98e539969468a392c4872ed25e 0 #x-14f11be356e7b1b92404672a95e2868c9078) 90 (3 #x-950400848f359065d4244 2 #x-3df5f819d5ec0f13e688714f205 1 #x-93161e5fc772cc1853ed4fff3487946e 0 #x4107d31fc4cdeed683d0732f535578d7a51c) 89 (3 #x4f154eff6536be31accde0 2 #x-17eb18c3a9b90612c26e635cca19 1 #x24fd6969a6c30cb8b3802906aa14375b6 0 #x-a5c277ccecf4490fe1bf2e152a5b171c7340) 88 (3 #x-13e2d437ce3e21bad4b2858 2 #xc927f59f5856cbf25e671a7fa92b 1 #x-61cefa155b57eee26d1b0dea54060999a 0 #x1465f0feea57d7eb7b609bba4bfd50a770298) 87 (3 #x1b998d5959710cc911a7a3a 2 #x-32591a4c76ebbdffc4258527f6775 1 #x6136fda943da5e56be46dabcc90e0bbe4 0 #x-1940b884f2d0ee22b0466f625b3a9a67e19b8) 86 (3 #xadf974718f31852ac991106 2 #xb3c24742fd7892132c80e370fc4c0 1 #x21a576278310c50954e5520272d1f79f98 0 #x-7095a067a58fe22be62740695a12f31c28b4) 85 (3 #x-4f6db34ebe7ee14bf9e84478 2 #x-337d8d546dda5ce3e1a6990e85a80e 1 #x-da4a13bc2d6a7d35af7911820c9912f016 0 #x8926cf808e002c0c97898a21efee26aa69e78) 84 (3 #xdc69fc85ee0edc3364409814 2 #xfc412fc7af9d68a3d878406d5ac4dd 1 #x2c1293e9c866429e62738be3dc01c731c6c 0 #x-1962fefc05e4f7175c299a3d1e4b3f8a57a5b0) 83 (3 #x18bbf1b7dedba3d628da697a 2 #x-408a8a378966262f77ffc37a5075c1d 1 #x-5887216f40919b4c29d30f96cea9ea22a9c 0 #x2a43fc3d8c96c779a660a3972273eaf3daec78) 82 (3 #x-9f7a6da5ff6d56ff0f256df1a 2 #xd25cfab4dc3bff8be56d56730373369 1 #x51a43083d2d7321f595d8424a93c751b67a 0 #x-19b1455efaa15f29593dea11b12dba697d162e) 81 (3 #x2426db822c337fab2beeb9cf08 2 #x-230fa1f422fad9bffb952a708eecb759 1 #x88a41163bb922bf516b65ef2ce625ca78b0 0 #x-4e0851f867715cee8cd5a9d85a86bae0434b84) 80 (3 #x-21344ffcf053d2462e732308e8 2 #x4f61963d3fc3ff16060b6356fb525498 1 #x-2bda7b41eab3466a5fc122e27e064be0fe98 0 #x11921025c523b8566f4ee55b33c1e8bca534172) 79 (3 #x-c82477ab57302eb18e6a5e266a 2 #x-99749db4bd8efd47e992c69e72ccc7d8 1 #x522947e53c20feb0e2c6212dc4b32188098c 0 #x-1b076a9fe6035a062755270c15a301641e36820) 78 (3 #x36a711861063881676d83bd903e 2 #xe7ce0f0fceca8401d12babfac300fb11 1 #x-33e6123b3989903b9cfbeecd473e5ced6296 0 #xa1c5306e5afb31f5a5087e0a6a2b47e81fd6ab) 77 (3 #x-439ca7e92fe652dcad022871477 2 #x-ab4452845a4f812be6d19034093da38c 1 #x-8488104c2ccaecf9a53e7291287b6df32aba 0 #x351cae32140340944e36edda07794c2b55c36da) 76 (3 #x-b287ce95f9a4f35668b09c0782b 2 #x-16d0a311e79c3fdc8b7bdd5e276e76326 1 #x19fc87485b45351ab6e169fa5463762082595 0 #x-881ac8e86b03baa179dd9abf6c57916cd2a99d5) 75 (3 #x365f01ad8e974cf7c6308f414133 2 #x68d5765f6a4ce1136d49b6c57660b90df 1 #x-1c588387c1de29f0ad297da4511067234ddea 0 #x8630c68ebc4dd2df5cdfa42a0c067e798cf3614) 74 (3 #x-4480ca194ae5b970a1c8e04d9d57 2 #x-c74ded7227e7b35216f4cf390a8ad9384 1 #x-b96c7c57c0a850e2f0009707eb231fa62f5c 0 #x496416fe22bfbf0d3f259b0280ce9b2c9349c58) 73 (3 #x-7e6ce436c15800ed8951d090cb18 2 #xa34150ce768ce11b7d873eff068616950 1 #x52781bd8deb621733b62ea03ae7384d50200e 0 #x-1b409f22367626b004f88fc269b80457d071254c) 72 (4 2180 3 #x259575a3d063190ffdb10c95055ac 2 #xb1fa9cd899149a84c9fcf0689d0104071 1 #x-6847132b38b2ac7936a51b8f29b2dce706fe8 0 #x247f16b48aec2aeb3a73f01f8fa1e77ae0747a9a) 71 (4 2969814 3 #x-295c08803a3ec05c84f5b6abef9a7 2 #x-2f41772961180d4656ac26c6fee7583ed7 1 #x-8eb6cdb3365d089a5675a9d0e5bb7c7da806 0 #x-2f67ef4999badcb81a1a7c489a31465842d9514) 70 (4 827957787 3 #x-4b2ea2f7cb05d7275ee154d7209a8 2 #x404eaff8d92c569be4f0c4e9fede092cfd 1 #xca947514ce98f40c69c0142d7461896523c7b 0 #x-43919d7ba58b87623076b3b285c741887cf63cce) 69 (4 #x1181f677b1 3 #x126aa83ce134b5bd7ec86a09978a8b 2 #x-116abbd060e1bac8e2e0b138ff1a0bc34c 1 #x-f1467bfba66286c31064d0a33206b97c71e78 0 #x69cbc91699a12008936db93b9e1ffe60ba8b97e4) 68 (4 #x245cd286534 3 #x-f0579a358f25d57b784864cfcdf0d 2 #x-5dcd863235e4079735045c377fedb18792 1 #x-2b7b23b2a3d9e1b95b5821638f0f54a25943c 0 #x-1b90b24bdc1d2f79da2826c99c09b968e6258f28) 67 (4 #x15a894a454fc 3 #x-24422b5bfed28ae65950e53e1e8818 2 #xbaa0c567478a9b2a7280f39e9377925d58 1 #x1a13f5d71f7a1c5f313030fb4401bb131abe96 0 #x-91f40c792265a69ec5ef123270fef0d82708568c) 66 (4 #x-94c871e1b8e8 3 #x65ea7549fd9e11d678bb3a3ad1244d 2 #x-8a417d129d1d88f0d4d0db5224d706dac2 1 #x-167f90c5ae7c52797724a70d21ffc1bf95dde1 0 #xea1a1094120c7cd49ecd5e866dd77e7184b32d8b) 65 (4 #x-87b8044cfd8ae 3 #x-2ccf839f9eb41bcf646b0f62d90a45 2 #x-60d1ae9f1d6412f5013d231a62b3e463c2 1 #x-f4958468f8bc03d9649bbd0850f05547781f2 0 #x-3862c94e2791577fcf4b59a58f2c78b0d5bd6dc6) 64 (4 #x1cd4722bc8f08d 3 #x-d232994369706eb2b1ca59e0fa0d80 2 #x17efb0fa1e9ec383ae1418748b534a9c73d 1 #x2ba27fee8f1fe0ea24fb88aafaf588c6dddd23 0 #x-1228377b377c1b6889dbe9a378223865d58ce024d) 63 (4 #x15573db9fd6dab8 3 #x1823ac9a75f15be7ded22857fe7a547 2 #x-1a77bc10605b7719a3d19415da16cb4e330 1 #x-f17bfa0564f26bc18016376d41c4dcc5822be 0 #x19852c497c502a30d52b19fcb07d95f075b6b1a50) 62 (4 #x-48d4dacb0b45212 3 #xccd9f51f4bebc327f86e09e87a3d7 2 #x-8a606570e3984ef45a0d2c5da9abd3608 1 #x-2d593370e3abd9c6f8b1432ce2d4282375d660 0 #x-1d68f1c415f9dce67003d64fe3d1ad0da91d95ce) 61 (4 #x-1d1ccaaefc35a117 3 #x-35afdd75088a3729d66cd3192495084 2 #x2b9204571856ddeb793ceefa6dde988c097 1 #x348cd6c924bddfb2f79037e1b76dd9568c8186 0 #x-207ba7d6ef8961f105e3ba4d7bf90fc366bdae0f4) 60 (4 #x7b97f634d9335b2c 3 #x39f03cd45cf70912b0abfec2b392110 2 #x-383a74fb69968f9e308e47257eab60afd5e 1 #x1552f952f0c7829485209555ece0d1cdbba9b8 0 #x21f8b4a5db6d5240de58afae06ba06b6c38cfa0d2) 59 (4 #x15f02388cad821519 3 #x2a51762092d1b4e62366e019cd29f46 2 #x30e1f6f117904d30560db7ced1eefa2eb9 1 #x-52ee11745889dd7c9963e70791000257b44202 0 #x8d4ed1afeab798344d39b3705b0430de413f4438) 58 (4 #x-81e2ba84e117eed85 3 #x-92dd8411a2e385dad54fcc1b3c1db2a 2 #x4d00fa1ae887e7ffaa7cb299c66ac401ea2 1 #x2050bf011c7f5b280cef5d7c020ff5365e1dd6 0 #x-304e0cb380c265e758373c96fd25292700b62beb0) 57 (4 #x-9cf9695398d156dd4 3 #x42e4805a87638f64d300eac4b370db6 2 #x-54ed5a1b51062b73106d6f7f155d9b64004 1 #x500c92af507345d6a1219bd3059a7ab7ab59d2 0 #x1e8303adcc0f265cdcadfdbea822b768b84806118) 56 (4 #x6a0f3281bfb2422ef4 3 #xaedf6c6d55f03247080fcf8999c915d 2 #x-fe36e76c5f2b4588f5cab51eba1142201c 1 #x-61f2f307102792385d552f97568e3bccf6c790 0 #x1cbb3ae10570f24daa35f1dba982eb3cebca1223c) 55 (4 #x-41f9afc23a238b5704 3 #x-f954edff56db289984583a3e5ffdd01 2 #x751ef63f96afaf46dd512a4105a467977f5 1 #x-156ccd43b0b3b20919822c37e16ba6939a1ae4 0 #x-362b898de1fb0329193c0f4fe478622b3f9eb36f8) 54 (4 #x-24e7f7cc2c05e2007d8 3 #x-2f275347acc00c13759c40b99291551 2 #x-50fd1648f27177a8b3727a63c731a7a45f9 1 #x7dd5021f0a4cb5640d2e67324175dfd0ab7872 0 #xa16be8d49e145dfe9fe3b8094315c552119f7e08) 53 (4 #x10db0f1be8019e16bd6 3 #x171a253e8c769f57f371a0a1368d3539 2 #x-3e4ceda0f02830c51eec3faeefb20992189 1 #x-44b542a3437fa07cf9e95c23c02699c2e0e672 0 #x2df291e2a34f3d3f708020a076e0c68c346321860) 52 (4 #x177b9d5f39d85849ad31 3 #x-d09bdd3b9aba80d5b29e72f56a7269c 2 #x811e9c2fa7f3851d97f86fcb427755bfec4 1 #x-504d292a5ea1dab474ee1fa500e30342a55ee4 0 #x-279e41723742e346cca3ffa2bf610af48293cf6e4) 51 (4 #x-35162cf57a23fbf45759 3 #x-128bbf3a8b24f9ef38b7f20fdf57a6c4 2 #x-1e060655feeec39351d5b0a7a7d81834a30 1 #x7c8f192f71cfe2592dbb983a69572929a18e28 0 #x-10b9754e290f846ce1461a92bc9717e779201beb8) 50 (4 #x-11b0ad37234ab9666a81 3 #x1ac50960b7da7eb22db5bd9cc78342fb 2 #x-630bb2863fd464c72374fd7e7f80dba9f45 1 #x-a3e2a2e32c84de016d6687f8addc6098a6688 0 #x2c3eb770a60e9707e0d0917a37df040e9f4ce46b2) 49 (4 #xa1a496428f9f0e4b9781 3 #x31df554790fe44042238e9cd3424e74 2 #x585a77a40b17a197dda056678c01351fe8b 1 #x-69d20e2993ccd9b4cd770d044eb2e3f3b6ef12 0 #x-b00ae5ce777bf7fa866c3267f4445ef10b8a5b94) 48 (4 #x4005367750e65efaee60 3 #x-1caf491986ae44fb9375b466ea01ec7e 2 #x1e41fe8e3dd0008403cb3edccd2d7b02f73 1 #x4e2091323261b365dde4f669b170e63c718d80 0 #x-1d7bd76ac3769b23f9041f147f4e1504aac2c2b06) 47 (4 #x-2c749121db3d0094aaee2 3 #xd071384841e826045787cb5dd1191c9 2 #x-57e220f65b06c3df4767b4f484bd97f3571 1 #x267ae8697dd7ed05c7d0218d393bcaff578152 0 #x176bfd677ff412643f365d63a8e21cd85f1ae5550) 46 (4 #x84516030e441d0fe8439 3 #x12ccce2f468091bd208bbc54da45545b 2 #x18978fa145d531228865457c7deca4ba584 1 #x-55b8a5ba377e14b8058b77858473588399c3cc 0 #xa6e920e539467450749cf006d0d41facb1681d89) 45 (4 #xa3afe722159dabc90a233 3 #x-146fa2ffaa285be6992b16e002d8dcb1 2 #x33f8d118a2ca35437325f1f8165c0606339 1 #x14e305006ffa6d9b6cac4d9c6bf3ffff8e6ed4 0 #x-155408659b455df0687c65ef7670ea9c800496522) 44 (4 #x-ae133935c74ea34767a39 3 #x-552f17e654fc427a99708be8f3244ea 2 #x-2bc4b3dd71cbbe878d70979bff1a0247955 1 #x32eceb859aff07b2a9fc014cb595014becd899 0 #x22c5512d6c60efac09dde6c2cdac8365b25de731) 43 (4 #x-12894546ec942b417f3cfe 3 #x11d25058def204e2fb0cf474cc65aba6 2 #x-e42e80e939ed05b11554756f0a3bb5e9f1 1 #x-29d13e6a27dcf6f08f3042c34008236a7497a2 0 #xcf8bb0e341d625beac78d53c5e300debd5a6bdcc) 42 (4 #x281c685873329d20d2e79f 3 #x-3cb3efc3f3106537fa4b2cef1b9fd1b 2 #x23f57bc88b0e6a467db87770fd2b2640cfd 1 #x-ccf7b84b54536e6113b23eb6f5560c666e5ce 0 #x-66632ea72e51bb39f94b11385a976cfb5e9ebdcc) 41 (4 #xa0c1983287413a0781c22 3 #x-a77ac71cbe8a38b7fc19727ddda1a50 2 #x-789da5d4b03e549b58b176c47374bf0943 1 #x20cf1c39c2eb0052749dad364d81576d4127fc 0 #x-561d68aaf724dbd56cde303179c3148df948de5c) 40 (4 #x-501dd432e039b765703392 3 #x66710e1a079209712d24c5a1e29a27e 2 #x-132b1b3f65a82c6cbcc0d73b409bb4604e2 1 #x-7057d8bafb443ae42c1eade4c04f97cb57a0e 0 #x5868302fcec69d75652130ac3df76d8de9b93a4a) 39 (4 #x1bc7ebb21c925f59f65178 3 #x3f75e746b851d0eb9ccfa32ed6833f2 2 #xd244375b21711d243bf08f8a4e50fc9112 1 #x-1005febfdb1ec5cc89a6e4e9567676f788f944 0 #x11f735d78550a0ac99483ca9971cea3c41eed404) 38 (4 #x6bbd9d1c952b6b44276aee 3 #x-4f87fef3182520d1b198ab72e412f71 2 #x5b3ff761c764676e0be17a1c4712462ce4 1 #xa31911ea82400967161fa340aca275f0a1025 0 #x-33af5dfab48537f8dbbc60b19f1d142b2958100a) 37 (4 #x-55da6149adce16269c8a37 3 #x-83b3f808dacfceb6e33e9d4475c880 2 #x-a02a682ab71b92ef0d3c37338d63cadd14 1 #x4a622f8e2b0fd3213040c48961fda7302a5f2 0 #x622f47204626c26d922f5b23472d707c68d3b0c) 36 (5 109 4 #x-69ae5d1c61a8cbc690fda3 3 #x2a686cf1961beaab5b1891510f52c8b 2 #xe320cb73fd2ac1d9956a43e340e6fa991 1 #x-6a41ca104cc17f545b7b04bc67dfeeff4b062 0 #x16de293fe00c9a41d2822b1b4059ce5c1421e708) 35 (5 -103877 4 #x8d024d75753b72e5138e02 3 #x-83caa6d96d921a82025fc8a3397148 2 #x5174c8d548d115f75912445ec06ee52f69 1 #x-21691197bf06066ff927ffca4264ee1e8ec6 0 #x-8aa280468d2eeedf158b6e842300d9cdc616de4) 34 (5 120990 4 #x489f3430851de98c3ede4e 3 #x-109e44bdaace85a657cb64d12459461 2 #x-262773b6f691266f60f267db81def2f0df 1 #x30341f306795b635e85284a5228c3b1f145e5 0 #x-7c2ea2ea8bfa6fb5a7ee061486a980870d1598f) 33 (5 -3143887 4 #x-aa41ad5d7e40e81bb2d899 3 #x7a47b195d487de69f9b8b86c834939 2 #x-1b56c71aeacfa65d8d2812d38cce0eb747 1 #x-b71b314e09b10089c3b543abadbe741a40ca 0 #x54aa4059c0a9181fac946dac0dd3b8ed4a561ce) 32 (5 #x-7FCFF56 4 #x-15b91a87302ae30937211b 3 #x4b121f2d0300d6186a6778f8af1e54 2 #x1bbe2b51f98a4895745c625dd205c73cbf 1 #x-10e5d688893b549351d7055a1c37265e23065 0 #x1e8c6938f3d50d84b57d4f75d5572771ba86db9) 31 (5 424191921 4 #xa0c38de0f4e03034e5d11f 3 #x-3d9e4598fcc8508fc3575cb3a1a21e 2 #x3a4407a39cd2d20f3e4235b52c3774c9c 1 #x7d955709456fd7c44eda023652bf460952f6 0 #x-251149ee79599b1b3a1e92d2ad2f5872e8bb310) 30 (5 #x1b6efb780 4 #x-18215ae5c6ce25d9f8dd71 3 #x-cf2e876e9df12e5a41cc5668b47f0 2 #x-d40476726fc9aa8cc514829182b7b3b95 1 #x4d5591bef1b13e6ff77869df3af5225b015e 0 #x-40c2906391b2e2cd117415301fe431e559e030) 29 (5 #x-87e9b2514 4 #x-76e8a8d5a3d9e517954dd4 3 #x1652ea5365b8ee55317969f7959730 2 #x245d49fb1d4cd28054357a93552b1ade6 1 #x-386b5eb9bbb681e5de6843c370f37515681e 0 #xcd6d01c5df1cf013177684de71d6f642794ab0) 28 (5 #x-f6f92a7a0 4 #x2ddfe7fc8496187f213704 3 #x-2cc9b1796e8a982d6b8bc3a27a83 2 #x494e250b541ddfcc1cdd096b6eb326776 1 #x-12b6fd84d3d20417d6dcb5763bfbf1908baa 0 #x-a02c68e63f891163628040d89870ebe7c19c0) 27 (5 #xb82dfb6750 4 #x43a9cae676dbae668e6842 3 #x-635a36e9c4554d788a07e648559e2 2 #x-1fc10df6c3b7caf73f346aca23dd1446e 1 #x14b73b293b84274d43b145718722fd457e46 0 #x-3a7e712e19453009e12ff34601e5dfe4341e00) 26 (5 #x-15385a8752f 4 #x-2a3ad4cd7a121eb85e05ef 3 #x1055d5dd29d53bf9abd1c27eaa909 2 #x-11f578b9860877a8a16de12064e15bc17 1 #x3c914939655d953331a73610ab036ecd410 0 #x96149bddc5fcd9df3b455669cc895b8fa6cc0) 25 (5 #x-24b18ab2a15 4 #x-1ca299b6b3199f1c788247 3 #x1596ebe33fc16ba8ceac0f75fe55b 2 #xe3360d2959c118fbe99cd8d938d91b3c 1 #x-6b318d93b872387b8c6dc7b0a6ef22446ec 0 #xe0af4fb14ace49604ea0d638b23c2bcd02600) 24 (5 #xbfad7cdb408 4 #x1aa1a134a204f47bfd97b7 3 #x-68c1c81a2f06679ee32021ae5041 2 #x28f367842b0598bb5813d98267934555 1 #x-8610ea97fc98467f8fee8dcc6120175f78 0 #x-3552c6b31e6863fc4e890f7a8b85cf9836c00) 23 (5 #x-b6281ce5df5 4 #x857f347a50695e7da2bbf 3 #x-3a4bf06d09a2ececfcad102616df 2 #x-47b4652415c5efdbd85b24d5b7550546 1 #x1ef8956dc71b4c172885bba30adaf4c2d06 0 #x-2ee3e3d3c680215348b5589d53e19c2373800) 22 (5 #x-15129ba2c771 4 #x-c673e1695b54278287999 3 #x1a7e83e6a279da4da76ef5497e5c 2 #x1c4cef156aa40bac9cf97ad56ef22af 1 #x-5c44de86d7c62ac9ca8d82866630c695e 0 #xcce0716baa8d2efc55e32debce9dc2bdf000) 21 (5 #x369133728988 4 #x-13e70872f47f522dfdfde 3 #x76b807fdb6247a34ff92dac13ff 2 #x11122297bc842ea41ac958c8b06bf8e6 1 #x-7d4d684c15481dfffee3b583afb25293c4 0 #x8e530e103e3f423064b77106e69c964a6000) 20 (5 #x-f02b061f295 4 #x45f21e7bd99eb15bf6171 3 #x-4eb130c7cc5a72c5b3e845b600a 2 #x-2ec84009002e6aab8f8b5f3684df514 1 #xbec940016759784be08eb1bd960dbc346 0 #x-23c6788d6e7e7e11daadbb1477800a771000) 19 (5 #x-4dfdf506fba1 4 #x-2e31205bddcafd1bde39 3 #x-a8b05566adb817801443af19d0 2 #x-31ae8575c67fabc43d9d469e8e6640e 1 #x1ad852ddcb2a6dbba8332b26cac9bc6ed0 0 #x-19ac697d54e587ffab9a58fe6326c8500000) 18 (5 #x5342732b48ed 4 #x-12bf3e2cf4312eacecbea 3 #xb2558d2602b193ea2aebf2582a 2 #xef996e11925eda950dc0ca7c1260d1 1 #x-4b244decf6c31732ae4184872bbbea310 0 #x454cbea4eb7f7e9361e56c158612ac70000) 17 (5 #x22332f804ff7 4 #x2b060a12024447806544 3 #x7d798ed865e04f65459f4232b 2 #x6ce74c73e22cd9f22455cb07782e02 1 #x-4b72dad45f328804781f4c5bc682e4df0 0 #x46aaf852f4a16a19704bfcd95c682d30000) 16 (5 #x-68158aa725df 4 #x3caa267f87673ddf5332 3 #x-135950db43ebef772ef3b58f00 2 #x-30687a3643c37fde68bc64ac1460c5 1 #x133ae2f7672f68d0ecbb6701670c30540 0 #x-3cda82fd9e4c5fcb32b297d8010e540000) 15 (5 #x1a9a9ae88411 4 #x-d73e4de1916278d3d83 3 #x48bc1a03c0ee6e26bd25aed0 2 #x-ac0dce60e58f9cd94576007723474 1 #xa7dd1cb809084db202e4163ec251fe00 0 #x-ae64e37199d5e9a948c3d874a1c0f00000) 14 (5 #x3eb42c40bd7c 4 #x-911eec69e635c2fdb45 3 #x19314dde1eca08b987f953eed 2 #x6f6dc3975ba60b8d2dc42afd6ca8b 1 #x-39bba21390e2eff0d1899bf9a2c53980 0 #x-af339d81b794f0c39fa1ab1fa8f6c0000) 13 (5 #x-2a2defcae1bc 4 #x296b7547013adf56e26 3 #x-14a9aa01ff841b2277f5094e 2 #xaf45a6139e8e4e71c1d28852b94c 1 #x-119774263438a9541945f96785a6ec00 0 #x15c03352a227f7095f8ea552788be00000) 12 (5 #x-118701f7500e 4 #xf6a6c8bfc17e5d0938 3 #x-16ff5acee7d799c4e19388f7 2 #x-ba83567d90b6e31c4212e16b0084 1 #x8284d8a5710d9ea8ed5516c5d621400 0 #x418b4c2132066a507821fea1d25c00000) 11 (5 #x182ba678bc77 4 #x-548388f3100261d7ca 3 #x179bd08ba14484e54b132e1 2 #x-47bf5254d125bee2eb4cf7b3faa 1 #x143d66aadedbe6f180ec6a96d74fc00 0 #x-1e1a92a8ec58b83ab9d559e44b4000000) 10 (5 #x-161244fede 4 #x-112ebb2e4eda672a50 3 #xb6cd6a126658e9716da850 2 #xdf797adb8c3eb433529317dbfbd 1 #x-dd096a739c0fdfcab5c26bc846b000 0 #x-bacaf55cb668c53a6488027c34000000) 9 (5 #x-77f306c478a 4 #x70b4044c8a5b09ca1 3 #x-c9fc9a8add0158b02ac0 2 #x-49508b94dceb499636f87df97a 1 #x-c173d2d4d8c8a888075345301c000 0 #x10c6de338843efa72a406ccee0000000) 8 (5 #x18804cef5ee 4 #xa19be6cc92a7c7ed 3 #x2892fe24d896d25e703bc 2 #x-b75a54eec3272cb1409c207eff 1 #x1106a261cbdd7136648b1f17ef0000 0 #x14b6db5c8eaa6010c5710c3440000000) 7 (5 #x14eb711c62b 4 #x-5b508964255f3c32 3 #x-23e058fe6c8716b5611a4 2 #x7ec269774d751f274d2d73d20 1 #x-2ea658cc9f767d8ce019f9600000 0 #x215b7bb3553d0f22b29996800000000) 6 (5 #x-7054211e44 4 #x2fbedf96b23ecc 3 #x-7f1d320d0b757fe9f3b0 2 #x5ec3494060770ad8612576b00 1 #x-e54c011f673e7c055dd1e3000000 0 #x-136c9b4621e7fdcdacfcd4000000000) 5 (5 #x-1e71d3cff8 4 #x22a8937e4dfcbba 3 #x3320797ede7353639590 2 #x-4901af3c5d207c0784e54000 1 #x9cf3bb21e8ac4af9aa900000000 0 #x-58cd1bb996f62a550bb00000000000) 4 (5 #xd858d2fc8 4 #x-307c80a9d9e102 3 #x28409c7199dd950d2e0 2 #x-1a570345c047051c1e590000 1 #x721a5f38cfd6aeeb21100000000 0 #x5edc867895f4dfe5c00000000000) 3 (5 #x125c55984 4 #xb57495b0d6620 3 #x-1cc565f3e47288d8200 2 #x122ac14fa25e536e2200000 1 #x-4856d1387bfbbac46000000000 0 #x493fca9d64af8fae8000000000000) 2 (5 #x-a3cec500 4 #x-33b1af867b2c0 3 #x27d28bde4b3d7a2000 2 #x2b8e5149179f13cd000000 1 #x-15dd817a3492e98d0000000000 0 #xccb6c0e13d2a5f40000000000000) 1 (5 -34369008 4 #x-17ac73083ef00 3 #x3e307558e0e020000 2 #x-290bf551ce3b200000000 1 #x4e6d1fbc0fd8800000000000) 0 (6 1 5 24468000 4 #x86eaf2aea100 3 #x-e1511d4a29000000 2 #x5d3cc7697c4000000000)) 
  (svref *ec-g1* 113) 
    '(114 1 113 (4 -1 3 2975 2 -2531450 1 560377625 0 #x-1f8e74e2a) 112 (4 565 3 #x137a98c090 2 #x5168875abcd71 1 #x10804d83b6ce2617 0 #x14befe59437467c4f) 111 (4 -148595 3 #x6e84bb92e3048 2 #x-32f9a0ec63ea7e2c68 1 #xa54004908ba20d09eccf6 0 #x-48bdd76ac8a1b808cebabf94) 110 (4 24153411 3 #x44a90b469b678846 2 #x9c3ad56dce22418765d1c 1 #x2e4418680f6e2f9dda3ee1bf8 0 #x407b39f4f47741f4dc339cc9027) 109 (4 #x-a1f09eac 3 #xba62295a33efc4bec6 2 #x-3333a133ee567321038c240d 1 #xac6881a554d90a87539df2a2a37 0 #x-127c9cf7f4a3589afc4901925db132) 108 (4 #x343e863d74 3 #xc20f89017c0508c6a222 2 #x2e9cee7388e10f30529779068f 1 #x425e7a7959da560c96b108698521 0 #x18b3c9bd44261997e527029d7ae17a05) 107 (4 #x-ccfebb1fb66 3 #x5b6eab5fd5e8b231b80769 2 #x-83e9b6e7ca659d88b4d4b08587f 1 #x7b4191d82889cacda9d8742ba5bd87 0 #xbfccff64a11c201fe6f948febc29008e0) 106 (4 #x27072b8bba4c2 3 #x153fcb40508db91b31d7fe5d 2 #x1fe9f0846ecfea8b4d2460279deb 1 #xcb28f0d4e221b6a0679aa185180c73f 0 #x26da44bd2e4c2197e2501ac4d166fa622d4) 105 (4 #x-5d6da3666aba90 3 #x284e57d2d8f8979cfbab4293b 2 #x3e39168da2ff004b46195a6a4bbb0 1 #x-24fe2f6227e109cd6afc4ae65c7305529 0 #x49f9a55f77b4f0b0510ac18c5b593cd2ed20) 104 (4 #xb0bd6282411d2ac 3 #x25826cdbdd92ff9b54a36ca26a 2 #x1de2abc6d02ba419e09feeb37ac878 1 #x-64b3eef2ab07c388cb6c35d4cfb1c81604 0 #x5bb7274475d159c6de90f3f3687fb9f2222dc) 103 (4 #x-1081a1b11ed91243e 3 #xbf666a83739a98859833e88354 2 #x4ea7c357e2658bb60c167abaf812670 1 #x-5d2eb4d97eb3ac326d2539b45c5dc8b921f 0 #x4c200fba2e3d89fa19b840584091dabb825700) 102 (4 #x1359d55106165e4916 3 #x-615199ef179e35a1410c8963ad6 2 #x9d128454f7e10bc771998676037fe2e8 1 #x-22fd82b00b0f9b0b9110f433c461788c8547 0 #x29119feff57d90060c89f6add5e8ba06e4dd1a6) 101 (4 #x-1185e91fc31a0557531 3 #x-60b9c6928e63a598ab92c095b3ab 2 #xcb9b118d380119c23a413691f132562b3 1 #x829e450e6e5780451f672fe0d121b437f24e 0 #xc3bbd3129d94fea6a21142668a5bb6494632be4) 100 (4 #xbe38129ca0b9ba474f9 3 #x-1274dff5b5ea8d790372f0f151bf1 2 #xc4b356a6950938f0bc13a1d09a2c81c9f1 1 #x1199f0780351aca775bc73e521021d32f6ef09 0 #x-13e87d04a1e448443a5a2630d2ed3cdfe9132) 99 (4 #x-5aab39e971f5c1530c8f 3 #x907503a323253b5afc15df991f9bb 2 #x94955f48f5bddce73052d3c7d14b89dc1b1 1 #xb079f37208b18df5d5663114b8beba7aa089c3 0 #x-1a744247f3d44e83c553637cc18c2886e9da23dc8) 98 (4 #x19536730b3d982fb8b1e3 3 #x51c6b77fe3f3d017bc1fd6976d1c45 2 #x59c41a0944a548433bccacdc3e59cddb48a2 1 #x436059229e25e7ae654b81085919b7abfbcd9e3 0 #x-a95d8da75f230314256399d2df70cf06996262542) 97 (4 #x-7320494b04a487613415 3 #x74dfdd0ec9349961a9c1c9e8f40534 2 #x2c1c2f58bc0771ce0dd7005697aa4b90d2625 1 #x10a1b94937803cab66d974d05dbecc41ee69a9bd 0 #x-1353ebc8ac254a90a228cf499f31ab52e89dcb03fc) 96 (4 #x-29196e65790ef6ec1687ef 3 #x-58dd4e24f1ca9db4659c6d60d4facfe 2 #x11de77a666b0becbbf207c23cf0778a0ad95f5 1 #x21db592821596ae76e7e4865755351495872b812 0 #x7c3f46b3121de85a2d19af30afd6c12d342054b0f6) 95 (4 #xc3ba5f011c4e6b226a404d 3 #x-1f303fa43b53b6f76b9a0d7261da2e35 2 #x606a94151238f39aab48bc102d41f93de9ea21 1 #x-375b7b267649acb0432b7d1e1a262146a9ae54a4 0 #x3a3c0bf42d0e78e1bbee603407e737a8738d34a4d80) 94 (4 #xcba11569aee10c452e8bd3 3 #x-13d9fb0177b6e7efef10e508b738a8d5 2 #x1b364a310f6cb0de74d7e199fa586a7e74fe264 1 #x-3021871d2c2d8b09e7f6bfd8fa7bd9591cd372cea 0 #x7fe150078dbdf8fd8aa7add3e10bff3eba7081cf52c) 93 (4 #x-101821bb25977478df84769a 3 #x19ec92499f3db432750233774dcffe4f3 2 #x66ce1733f11038cb8b7abeb80aab9f75504e9f8 1 #x-d7ba35bf54da0dc315896b667fad657fd63a1f5e7 0 #x-12c1265e764ca2b8b97173fb4c877d4cb58de76ab010) 92 (4 #xca64c17b7c98c6303bc5f22 3 #x6c1cc3fe1edd67853f645ccc077e8c687 2 #x142020efa5ad7524c654ad7341c24a11adefb8b6 1 #x-2740e5244c7d079ab1c6e96d04459dd122e21289e3 0 #x-ab3d8568be020f7e44a32247f6667202df7ad4b8d0a4) 91 (4 #xe603107e77e79b3042a72e7c 3 #x2a6ae7cfb91511c34899a5666f27eb164 2 #x32f2f42eadab2ad339ac019e17a90c49a57b0754 1 #x-55febc736a8b4c2cb68b7496b03deca29cb8b00c0f 0 #x-19efadce95afccb63cf53b904bf67a309e7798cacbc30) 90 (4 #x-101f6250865188e92f1b4e3d8 3 #x-4374fbee45d5d2b15648c3ecf9d6973488 2 #x616daf09b06898097602c10629f606a16d6a0d92 1 #x-9ce91ad64e886fce4219c85cbbd08274636715f555 0 #x102e5103a7e39db6241a6a7ec7c68f8fa6054cd630263) 89 (4 #x-bb359048888a3d8557ed8979e 3 #x-f14943ba1e2b208ce92d3c99249a9e0bfe 2 #x6d5e581f4916e3058734ff3f4fe86a9b2e17011f 1 #x-aaf75379a821ede87f9a9c974755f2ce53aa561a2b 0 #x11f2ba9765dda76b6e5b71658adf2854971371c24ef2d2) 88 (4 #x7190681f7383f05e3f8bf34fa 3 #x-73b9ee583896f65949199ac4183f98f39d 2 #x-4b4378c2e29d46d5b46063d2c011fc91a08cb630 1 #x3069a017a5a14bf0bb1f04d36a3fd668efd2be49ca4 0 #x3234f982bc15b028522c9991cd47699a50febdfecf3631) 87 (4 #x8b4eb529f25220429705de0a0c 3 #x6a2e0e1fd4ef7b96f1633f299bddaba57ef 2 #x-2dc9328b30741bd409547fef31c40698372e7e099 1 #x1ad5868366d986b40c3b6f23f8dcfce52e486bb4f049 0 #x1b096516f23fa6d3e3fd37a7edafd563bcebe634f1e1f4) 86 (4 #x300157c6d9498d8cbb9a4a470c 3 #x16a23a18f61833f4f2792c58cb4a1ceb3aad 2 #x-7b9b98540d6f309e57d92edd1f2a15f70648ee26a 1 #x6ccd868c56b28894e8780e4118e51eb955b677ad5a2b 0 #x-fa19660e1f750af597652688e33ef83ddb1b9c52bbb167) 85 (4 #x-54e752a7dbba21df58b2c5e7e3b 3 #x100bfe3c4ae318ed16411dcfa33ff72ad953 2 #x-bcd021d4534f802ab0c594aabc3b312d26291dd14 1 #x10993f4dc706c2f9c4b99d8fcbddb2ea3cacfb5ad326c 0 #x-38e5ff5ec3e106aa446629b63942e98988b33dac68e0dd6) 84 (5 20905 4 #x-7e77d7f5bb3c4c08d214f3b30fc 3 #x-6812d4b62d6bff4bdf5a5be4f9c43a1ee99b 2 #x-545f7aab668bb5c033ac9004af92d2515a618bf70 1 #x142f479c1e7ad0034c75d8a1b7b2153f41757dda0e8b5 0 #x-5099fdc066f55faac502510b98fcfb1bf0f2d8ecb9f8b29) 83 (5 67356249 4 #x24c949b31e57a2f970dafa8fa109 3 #x-16eb600482c09f9dd08ab1c1d505d55ee571e 2 #x19769ae4c9375eb696350620b2a469046025ed2562 1 #x-10647f952096c4958ba03d94d6aa98fe291e3c5bd9679 0 #x33dd93db196e2174b08078ba869b9467d7141d087f6af30) 82 (5 #x931235bd0 4 #x7192566f25a491b3f869fb86dc6c 3 #x-15ab43d5846f1b9c1bacbf2b69b5e2605787d 2 #x4fd33e3cc309edd5cad38b8b08cedb70811c121961 1 #x-7d96c17974336bbf02a7441df11a0d43eaadae57eb437 0 #x1f6c6e62027e65e7d7a913f4696a10200d7ddeb9010db1b0) 81 (5 #x667ae349cf1 4 #x-7c58b3dce9abf014100de4213d77 3 #x40053cb54eca93732a3961c8e1e59002d44a5 2 #x711162b09d5319995e67d37601882110481be7b5e2 1 #x-f633a9e4278912e3415e3aba2acece79ca45cbf32eaa0 0 #x47a6c528c6235c53a10f327b894613e046ffe5174b08f950) 80 (5 #x18fe53f8c313f 4 #x-3dd734e9644f32534ff7acbe6bcff 3 #xfa8a6fad85eb227256d058a8a4b3f2b140870 2 #x1ee85daf077668d0c7cc19b5f5a23258719c4fd630 1 #x-9744c255c78ee3f514e3ed08f479c0e6af1be28ac88d9 0 #x4b99d6d6120e3010228b0b7e0a854e798f839fa1acdbe888) 79 (5 #x1d50ed1b83dbfa 4 #x-2606829ada61d5dae4e381af69f8d 3 #x11ab6bbeca83696c2680fa68ec9518fb602f04 2 #x-e595097299cfb34de808a9d276c94a49cf4b8bbada 1 #x16e95a38dfbd137361d37c62fe020d1806200a382c3f72 0 #x-1d4291ff05ca031781be166a69e8825ef4130fb0988ee640) 78 (5 #x-7255f043e92975 4 #x14a55fb31775efd3a308aa6f8338af 3 #x-18fa5ea27e7b24bbba7713f888c093a588ee3d 2 #x-2168e15b671951c270f21a47632389220832fba7b79 1 #x3f63eaeba0dfe3a764514130ba1e7e1f9850e4ea1ca038 0 #x-fa6f184a904609be076108755b6c82471779d8c9c22d945c) 77 (5 #x-10f92f484110e39b 4 #x2c555eec03260ff9a487d337f31cac 3 #x-7599b4cff6cfabc7e5ac2f690c9c959da5daa3 2 #x-1e719dbafed113fedc0c763a6d5734cbab46413d5a8 1 #x35e4f0b2e72ac0b7d6cf6a619296aa54b748e9e8b8b9fe 0 #x-1a7556fbe5bab847c7f8bab4f207e4fe561a7f96752f42c68) 76 (5 #x2668ee82b7aefa23 4 #x-2f5d0c881c2b78c2cff67f490c567f 3 #x-92a6d91eda5b5f5ba2251ab60eb2bf88a53c34 2 #x108644115b8fad3089f81dc9d7c029440454795545a 1 #x-27764d893a8cae390d6046fa3b5996fca505c0e6a850e2 0 #x-fc5e88f51d4c603f9b4f5eb98db5ffacb58ce4506f7bf4fc) 75 (5 #x2f29f15680aa89e79 4 #x-1275e3cd597bc0e84854c037788b8f1 3 #x652ed5311449815fa281e7595958e998dafc12 2 #x58a0989efc1c7171b4cc9db41a7956e19983f55bc64 1 #x-890cf5dc2af0753fe6cae86491504d2af5364ebb95b104 0 #x183eb061563ddb488437824a54394d7652015eadaebaf3b90) 74 (5 #x-50aad247be3be71e4 4 #x-c9543241f5cc89edbb9dc30f999a70 3 #x274b80285c0cf5b90bbcde36ded3f67632d8d58 2 #x72602fb557df19af38e0de6607ce50412eca7d2d865 1 #x-5c5f86a14fedef3f90be9048a67a9fb4c513c742310998 0 #x449c801d9d41c48e5726a3a169187e089ee74d08dc2996024) 73 (5 #x-3cfa59dcdb10521261 4 #x406f8e80820ebe2c198de0235e7d88b 3 #x33488290a21e76f7191e8552474be9acc5f856d 2 #x1ad73fdecc0318965b4f35f0541542f830a976db9dc 1 #x58986e2240ee409d8dd59fd778d5b0efa34d9e3abccf90 0 #x419edd80325d1dd85e0aef8a808dfec36881a9295ba91f098) 72 (5 #xefc32393ba4782b64 4 #x8ebd6d98048bceabbfc7c8a5f42ea00 3 #x-11490358722d94b27c3b339bf6aaddddc92e9c9 2 #x-9249cbfb6b8897d156e828bc3ddb8767f33c72056f1 1 #x9a9fcd4df3a3f60f4e4d7006930dcebc0ae3ddccbfad90 0 #x-d244ca9d72a60b2699ad8611aae7735c8beb462ebf03a75c) 71 (5 #x34d784311e927c13060 4 #x-38481b833ae6777f0c33f70b26f51a0 3 #x-9b69a30e9696164479efa0acd22b308b75fd314 2 #x-107fb960259532164e394e8901fcb246ba4c11651282 1 #x-42e267596a2b10e5d9939aae73b118d3987e4c07aff0d6 0 #x-768ab8fceb11bb80e8de9a17aaa91e283731d3e7d65cc44c0) 70 (5 #x4ee73cab16fd86bc70c 4 #x-255eca2df9228163b391a7f9eb6d28a2 3 #x-cab4c996a7790abf611b37cbf10fe74dee5c580 2 #x-ad8c541850aa95f1f5c526c74df238c1de58aba0c14 1 #x-118fb0106113654b758ad9924e0d58f0ecea9d0bbb02b7e 0 #x-8ced43716e352fc72aa8efd08ca258c53703dba34bacf2c08) 69 (5 #x-1b29a6b68663389c0896 4 #x-24a8456db4ba57e6bc16163997059607 3 #x2388e89ca3c4545062a794e913640904e01ee7d 2 #x8b30d72c78e0707df3874cc43ff05b0a618660a7a7a 1 #x-894da255be3fcacd83071ae12d96df70b35487c5dd01e 0 #x-12b973e2c25a172086d3039beeccbc0cb8e7268669e159120) 68 (5 #x-6206866db2fe51548ac1 4 #x49b05b24d30419f00b69d32773c9d5a7 3 #x1d513a7067d828040d16eeec9ba9c1d13e0f9fbf 2 #x1d1fe26b78b57ba16ef8f375fb91a5b3d5c5f066ad59 1 #x251409944a4f55d2137c651263222cdb54e0ef9aa3853c0 0 #xa19b1e6a8ad268b5c17d61d2ea5aabb34ef43876cb8251618) 67 (5 #x38f655ae658b03493af1 4 #xc93fbc9929977587fa11b4cac2bf8a60 3 #x2487e8479e67700a6758a71d8cf3515742e9db8a 2 #x1cb26537be994d97f3088878490ccc59ed9809878638 1 #x283468ac54efaf00081b6af1dca99fac1273c5afa36ec38 0 #xd67e7936f0af2af8b9509ca9ab9278580757fe13a8ba57460) 66 (5 #x371f51d8137ed0bed405f 4 #x1fada1a04fe27bcea830613e5fe33652 3 #x-494719c3ea53b4c7c67d7267b9341b6b05ac469 2 #x-3744c5171de4ff9a23bfe18e9a98a5d076583dd7dff 1 #x-11a8b7df0778df2665a59934e6bd41d5eb11057b3ca3290 0 #x31c5fece2303ebf941a99a6d3f2029faed31b3715df8f9d77) 65 (5 #x4f878c72a94126c06d75a 4 #x-1f19bef00a79e37c97023665fab629367 3 #x-44dba89dea7923a69b1dbff47a66377366400eeb 2 #x-2d1b6140e7c3994b3a8fd5d43ce39564365d18b6e4f2 1 #x-4dd848faf798dc16fede176e553c9df15af1f319613d527 0 #x-bfa6b729676ffeccf65ae31a9122c20ba05f96e5d23a12e26) 64 (5 #x-e1f3b860c6a71838c37ef 4 #x-27a01c0a91d7baa6a33c41c8faf058f99 3 #x-4e496071d8abeeb9647b945241a1ed57f0048d33 2 #x-31a78591992d32add0534d90f6cbec9600817c0a6874 1 #x-3aec9cc7a76c89dfac0bfd3078f6d7ddc02ce2d0961b719 0 #x-ff3d368613aca427d99bcbb8ae298819886fca4156d82bedf) 63 (5 #x-3a00b97445918fd800dfad 4 #x1e2616a015bb7e31de97dd35dbabd8a45 3 #xba2b121801784ea01f924acaf64dfca88dad78d 2 #x1bd602b0eaea656ad7dd22100bc12ca7d6bea8d7676 1 #x1e7d68c11e0295d29022f648ee8706c852a2ebc9a3ae330 0 #x-37464d6dc214a2d50ed022b9e322cfd3e208bce0ca72526ec) 62 (5 #x-aeda06042cee27f95e212 4 #x7685eb2b74da169fdedf1eacf783fa95a 3 #x7ec5002433e8680f375d70830a0d100fc4b200ae 2 #x3d3d484541907b5d7b0173d07689ec55d0fd04bb1a3b 1 #x5b963073fecc4e6ef1a89bc962ba506dab5a1930a1215de 0 #xcbbfdde14d6c8e3c2f3d1de9011d2008a077c67375549e949) 61 (5 #x12341a77c4ada5a66bf855c 4 #x3860024338cb068421cc3594a8a8c5115 3 #x7d9a31ca53fa2eba77df28a43f01e046a153516d 2 #x3a6abc1be14f96b57fe61a9aa29839d1b0d05e2e6a51 1 #x3a786005d131ac8a5264addcec2be17183d544be2a2bb01 0 #xf34c0165bd0e93114b4d6908e7cf70974031cb5c026f23102) 60 (5 #x170d9e1f27f94f9521fc301 4 #x-b01880ed707633408a5a8beaa0c90bfee 3 #x-1c429d9e7695d370412c8ee46f5b5173b6221207 2 #x-997e73f688edb5462b914a992e4a2d2701abb6e978f 1 #x-1814208696e744ae807532e69c20b672e6f6fa512de3a8f 0 #x1e25f99a8237b7719b7878d39ec01b25e8f69130ef251d623) 59 (5 #x-2d51faee0001e135152f0d8 4 #x-10aed94b412e8166b1b88fad9690902366 3 #x-b66280a560010a573545752e036673c99f5dbe43 2 #x-416169d18358cc1a9839b9a3a40a331b18e62c78f6b5 1 #x-42fd19f815d2481514ee11288540713320cf29ef6294249 0 #x-bcce62616f035050bad0f58460db0df4502350280f07f5100) 58 (5 #x-4faeb18d77254ac88406914 4 #x3fa91728e039e2f2298c756c9fb2dddd6 3 #x-96a0b249fdc05782aa914db885f9eedef0e0db62 2 #x-2e9818a742c0a5575a3a3581664d52d84e39e925de4c 1 #x-2aa4888a26936aba434286a17bf8617061f574372260015 0 #x-b6a95603232ff087f9f69a05bb24b1395a8441b196282dc2c) 57 (5 #x3237c631ed4ed0c3c694527 4 #x1e657cf68622bb6bf17c42026e53bb8fd2 3 #x33f170429f77eb30e3e34c2c23d50b0d025340fa 2 #x114b9e02025393b85b73f0e8f878202a89e5cde59f9c 1 #x536915f33cc79331d51d129df19d3634f2d08524ee2397 0 #x53410e0ab09f361011a4e22c563e7586abc223a926961f40) 56 (6 3390 5 #x-6f7a9481618bf50b1327c63 4 #x132804d79fd090f07915fbb87f3efe86d5 3 #xcb26ac306e16fddb19283432073a2d7a7532c9ce 2 #x324374f39d3013556e7cf3b5131c8b9e2d36986ed47b 1 #x1dd5a4a20159186aebb8accdb68c87fc1581b700ba61e04 0 #x8ffa7d118df1a477b1e35cd7d016af605e99a1589fed31a0c) 55 (6 -18851338 5 #x-32027ac841b5e973df3c162 4 #x-1c2742871baa007cdbabb0ba7ddb7fdb22 3 #x85fb1c585790148c786df6839a475a98fc12a558 2 #x1a221e116d6f9fe63dcfd3a59be1c8d884646113f676 1 #x188688e813c02760ac9c597fd3d2bf02a105e521d489ae3 0 #x6807ef0cea2e0a0ab85b27cb13ec864754447f039c1a26940) 54 (6 #x11a887f40 5 #xa653201bb5de1769a7fe7614 4 #x-2f4edec579d546a90fe5f008bf1fa859d4 3 #x-43fae287327694e62080b4bdd43e9998714fb4c0 2 #x-e2194c4c4c9c545d3fa91bdcb815bf1a6d6bc2101de 1 #x76d3a11b5fcccc597c12fb0552e5bafdc09028e0f6d6e3 0 #x-184ab0dcd7484947d14ff8471daa7fbb41ad6837c630a59ea) 53 (6 #x-1a99e334e5 5 #x639da6e682147c9487764c2b 4 #xb3f815533c580bd889f0cd0dcb009e24 3 #x-ad3fe280156275dde4a33be40c52f7e006778797 2 #x-1aee2a5c59c1d4111114fbda4257f9735456c5840a09 1 #x-621abf99dcb837299b88b12aabe1070f6a73e834bab9f0 0 #x-558217d972ab85c9b60d1bbccadbdc210f9da58aaf550023c) 52 (6 #x1b25fe73afa 5 #x-3ec035684e8223c534ced6e39 4 #x38be3b6845b007c9915adbec71811b1c1a 3 #x-57599a490905413c7511b5da2c37f933c437e85e 2 #x-c26f497166e713eef527fe58b5c80562b0b81b2d5f1 1 #x-af277aa85f00d3f11cd153ab8137ec130eee691be1ab37 0 #x-2b6ac401725974de2bed035eabd294d920ee3ecc20921ccf2) 51 (6 #x1c580919a75 5 #x-3e162df8cf1baac97b63715e8 4 #x260acfbb2fbd204b449e76b7c43f53bddc 3 #x3f249e7b3ce1d2f5d2354d10c6b5b74fc286044f 2 #x508f59385268a51a8a33f949a851e82d25524001521 1 #x-7f2a9d7f4f3063ba87713637694b4154da88e22adc39ed 0 #x158a88881fecd7f89eb6736114a37d677875738267f4965b8) 50 (6 #x762d8d8168eb 5 #xe6174b136e360a16652a70b72 4 #x-22a16a5f5d03c55e7573d8f248f269cffd 3 #x7004c68fc0551e301c308935313d3a7a73639c60 2 #xa0931c8371d83b7b07fbe1db8657b23008c0f59312a 1 #x-184416f68772f73b56dee497acd8ddb52242114150c7f9 0 #x2672ef38ca92c49bbccc43d4cf9b841026a41a040d6eb8ffe) 49 (6 #x2e81c13328e69 5 #x13e9ae52fe7e2cb64807ed2ddb 4 #x-3bf4b3361228797836442f3534ffc8e11d 3 #x2923a17c2243857962815c2d183ce83dec4e147e 2 #x60aef402fae9f5c7e0e79e93f2886e062d1fdb717e5 1 #x32642ea010bcb3af63a481f26ee9084348fe9d9f68b46f 0 #xd4e80b3feeb814f8f5e485eb7f0df288ef16210873dd36a4) 48 (6 #xf4c10e6c61ba8 5 #x-24909a035147d8e1579dd3d824 4 #x-50e8735a1f9720611cd10653672b294ae 3 #x-29dcacb954bf8da97cb12bef3a9aae26da121898 2 #xabb2ae083d765ad11fcc3773eacc0a40db21e915aa 1 #x3c330605f933be1cd028df7d417e95bb6649250e79b860 0 #x-aec51e98f09a12bd75c7706a91ee748ffdfaf1433efb4e7a) 47 (6 #x27e000ac179d2a 5 #x-43a019b375e1f63d59870c0dac 4 #x3199a32ccc4f655332d59ca1e2aa0abde9 3 #x-3689abcd2779eee11c48a73ed0d856e56094141f 2 #x-281c23754314f1171e319da4675a429ad394e2130fb 1 #x1cd562ee43776f1f779ab2d158f0043fb3cb0e5f3e1352 0 #x-d3a6e5306eca2b10edce93bee1fb622010c1f2e4e3ad5540) 46 (6 #x6ec0b1114876db 5 #x44406ef22895e45fbd55faa4db 4 #x21cbfa871e8cecac27a1e2fcacde6632a8 3 #x-dd1795e555e35d247bfb9ac355d5e3b3a27ef26 2 #x-30cca2b831a9d7247c5a5bdbbc9f187db57f11bcd85 1 #x-2aba7858102a4e32ab5f826b5d0052f90a07dea69d888 0 #x-34bd3a1ced12ed00955dd00d30cb093230290fe76f008924) 45 (6 #x14f38f6f5a0202a 5 #xaca5df11fc0e8e37aef215cabd 4 #x-128b4db9fd0cccd6a07f39ea2efa44d82c 3 #x13e178ac2c3240415bca8bf9fffa6402145be75d 2 #x-1a597f46ce14a22151200f558b36200ea16b186d706 1 #x-f16de05a7f9f0c11d4de3472aba4be0867fc4a8f7b0cb 0 #x3aa9ef9cb63708c4ca0942c5379d6e5df3bd6cf4c2f36130) 44 (6 #x36f942b28a63f5 5 #x-59e31d83601dc6d6d61e4fb5d8 4 #x-234620cf087713e741b664f9259970dce2 3 #x13f29d0b4774295b44faaefa2befe6adc5ced33f 2 #x3fcd0c206585a23b753db8d1d1c9347de0fb1285dd 1 #x-c59a1d3e2b1be111789a195aa1fe29b9ba6a0a1a5533d 0 #x3a2c9579122b9d20eb8a28ad70e0908c41cbbfb75369e58c) 43 (6 #x-a1be68a215aa265 5 #x-15fa7437f8b7822a74eac199b91 4 #x-7c48edd23f322e0c8ee4ef21fe7c8af47 3 #x355fa6533fa92832a4b7cb3ddbee4e25c59c88c 2 #x133146053ad9036a8582761a77932eb63dc0f341b7a 1 #x-4ced0a6f9db5ef6e3bae3851e6a2b7357010e1c98a331 0 #xd241ffbec2636732f1e13b93a4fbfe9cd70e2c0dd3d2c50) 42 (6 #x-420fc6987977fc8 5 #x363c8d6539b4b77c221ae0b675 4 #x11d2e01ab1089c97168133ec332e14178f 3 #x-6c458fd2b69b488917ffa85bc799b6fa46824df 2 #xe7bf1e733a3a135b785dacf211d35cf639903096fb 1 #xf0438e006011e0dd9dc49e0fa4cb46918b362ead70fd 0 #x-dad5f050ffa82a4b93368a49ee6af303e8c4be928ba54fb) 41 (6 #x372c56bb44844a64 5 #x23ec12b727dbf077b8e5e7265bf 4 #xed5a73d389f2ef891911e9d7ebc3aba05 3 #x-580d343547791d883b213b74296c25c0e5a408b 2 #x2376f0b0f30405f07b63d2f8d82ada9c029c817435 1 #x300afd6359a319cb17c265f4bef8f834aaab7412b0ef1 0 #x-d56ad27166121b030a3dc06fd1bf014cdbe6169c46c49c2) 40 (6 #x-2959d55220e1a396 5 #x5c8162cf702313498d00360fda 4 #x-128353ef163019bb492e1b0cefed66e3f 3 #x-a1a0cc2cde9a4cb4471877a996c405fd03424e 2 #x-4fa93f2ec0274387a13d8ceb3a0414ed7c145ee101 1 #x24eb7ecb206480edd4600baf643d2115a79a2ccd9c3b6 0 #x-3b5b44f12dc337554b548d19449e13d44994acbe55ab381) 39 (6 #x-177fdfcfd4c2bd59d 5 #x-2de8ea16c5cd1c4df556b1751f8 4 #x-8461351df3815cfc9b16ff7bb2a6ee162 3 #x1a59495f1771ac36130217b4f5cbefda2d3bfff 2 #x-4b060e251b6a9db14ed297ed4b6f06c5ec7384d2df 1 #xbc340175faf15a138bf090e79986fc00a8f4edad0ba1 0 #x213323581b044c2f2c200ff23babc8b1fb53435a83cc10c) 38 (6 #x13c6de24e209ea152 5 #x-14f5247040534c02ff5441a2085 4 #x-4727a79454588c286066fdd65bf6eb8cc 3 #x127e653b6ae9c81c8b5d83d1c312e52d117f61b 2 #x-171451677efe87d0a61a6efa13a627913071cecdf7 1 #x-51beea0ef5b293d72d1dfe1049fa5a992519339278b9 0 #x287a21ad55b6feff6f79e9f0277de8f14deb0829532f917) 37 (6 #x765d28b397066c415 5 #x2c09453998bc1838321d33760f2 4 #xfc86aa9f5954a8eb9ff127d50ee3d30c 3 #x1df290bf07de729068e8468787c441760fbccc 2 #xb21f8d189afcdb3e49b269f18acf7aea2bc7fc748 1 #x-88f2db49f4b37e9fda80922d87667c8c90e7c7831f6c 0 #x101e007638ae21c1994cb2e14a720836a88d76f51431ac6) 36 (6 #x-4b0b0077d9099a9ed 5 #x223b18e9e210e99022a60f0bf60 4 #x296cd40b976b2427ffb9ac2e63ea67ff2 3 #x-48b0ea60d65860e635222ef5e29e08a39d4195 2 #xf7f61943fbb5fe78e27e6f714943ea616bf55df17 1 #x-4c05ce508a22333f32ef1399cc43b5e2ff07242a004f 0 #x-177188924f41acaab3d003742d650cf52f292b3a05e01f) 35 (6 #x-1a7194c577468c24e1 5 #x-1d9c2b0f7577cc19919fb5f1eb3 4 #x153ff583ef52ddd63675371e828cddc31 3 #x-2fa29591b5d4a03735d99a8e906f51ce03752e 2 #x6ecde2eb701bf200579a09b9fb99829c7b1f87b00 1 #x-aa007e656a53b32c3d7cda7d3b5f1c672ab9287376d 0 #x-59fc656fe4494fba60d5af454eac60e8b2ba2ddbc52a90) 34 (6 #xd959739f7aa86bdc6 5 #x-24e8c7e24cb1ddbd52783e266be 4 #x-2db500840f4a00d16d63eaa73e4cb8d4 3 #x-606e4a60e415eb4d330d79dbc72fdeee635dd 2 #x606d72ee7a3bcbd1f1fb1a0c05b314f1c9bf538 1 #x1026e687611cfaabd1bc3d334137b2530a5ac0cab93d 0 #x-361bb41fbc9b6cb7f708e39bf6eef8a24ee68ef57a1058) 33 (6 #x48f385d2b3fae37f37 5 #xb3d96a6aec3d68cfdf8ac9b2a8 4 #x-b15abdb4d3f6c8168422a3229c9a6450 3 #x8a5cd168362782a928dd03d9ba0fa6990b6a6 2 #x-1df980596de7d2b672a79b16a5dc47cfae2d7141a 1 #xe6a017b469ea2f87e602f262de9ef50e8a1f3b72b72 0 #x-ca609197698c336d854b0657653c873f3fa3066cd85b0) 32 (6 #x-1d507d23beb7510a29 5 #x1c373fecf0ab4278fddbf08fdec 4 #x-69471b626862e2bd7b7f94019e4e8dcd 3 #x5d2df05087627daca033683217add8f78c516 2 #x-131a44f1be8afcef25278a1e2a400479e97511d8d 1 #x56073257c4e8110bdabf981016cee4866b3fe09d339 0 #x559c12e3abf4a797be6877a3f747b928c040467505790) 31 (6 #x-9e4b1853066c26dc87 5 #x150059d41288eaa3fe38c993b1 4 #x64df15c497cda3ec1844acb6968fc2 3 #x10de9199436fda65e47f53ef2d0a783d11c77 2 #x-4ce61807673d3e292c8cc2b41841edee84abf128 1 #x-29881915eba6add37298a4ccc2cc23633207f3bb2e 0 #x6e2e1d2ccc3ec8faabc63a65538215e9b4d187942b180) 30 (6 #x29b635dd10d7a6dc91 5 #x-f2b2d0445566cfbe471c9d3f25 4 #x2902865fc1d40fb4ceb4af327c33ce36 3 #x-a9c473415aa79d9fbcd42777a3466968b393 2 #x1437d14fced8e3135766ef9e61328de07faec440 1 #x-16e9bd634c3815ccd8400223ff366248694d175056c 0 #x3870f6a148bece723dd886a7eb30630b6a428a4c491c0) 29 (6 #x1044f3d169234180bd1 5 #x-4fe55a345ea1e241d3423ff2f0 4 #x19be4dfb269ddb6de71157c189533d15 3 #x-861dce71fb681a93a08a42354533cb8880e2 2 #x1bd510da44b8fbf82ec8fc4751f4e9e9caae628c 1 #x-e375f9c53a79fb56c7e108636f640bfc8adfb43394 0 #xe1a86b62c1dd35c0a18e0e91eda38ab5612178216600) 28 (7 113 6 #x-28f3aa6a0ec042f8bb 5 #x5518baca1df141785f69dc60cd 4 #x1ea05ab5cb3a99737392d327a6f41d4 3 #x-21a960d11722d4a9b9a7b27405f89f308e41 2 #xc851127f5394b742112f923b8f28b1ea9674eda 1 #x-3fe7d4afb14f3d25d372cca8a00cde3ae79ea9c388 0 #x-2b14e28cf2733d85e90871b5e56c1a4dbe4f8d5cd500) 27 (7 80682 6 #x-13de29823dadadc1976 5 #x3740ddc5936cbe322ca9e4deb3 4 #x-6c72dcc3bc69ac2a3174c513445e3f0 3 #x6e02c2a0e034a3d3009e581096a6f7f2b5a 2 #x250331b4c14a5be8576236d55d73d790bf5244a 1 #x7a9222a4dc996e16f80230d1d9b2a0e30d3d56a1e 0 #x-4fd74a8e324f332649d236de2556e733548217edc000) 26 (7 -220463 6 #x2e8f0070db7471f9d0 5 #x-f8aa302cc89e1fd7904417be7 4 #x-461a2af9f466b4ee36bd3d860291961 3 #x8997656ed27b51a300f6bf3e95f5c60ca06 2 #x-bb62ee1cf9f776063381bedbf77c2f1ffd5e6d 1 #x11ae2f694e81a4461fa534c951fc7a36fc7855c326 0 #x-30612db5e1d1fadb72514e588bb7a86f2e3273873400) 25 (7 6180309 6 #x1303ec25bd95a23f349 5 #x-160b6c73ca6c8cc1edddf1351a 4 #x-adf56a69572be80a4ee082571ee0b2 3 #x2e77381738784487d3ebbba16cc323c00b7 2 #x-bf90cab61b8163ad8b89db002c917da394124c 1 #x98efd8c75ff4c9c57be911868f52d3f6ba6f0308c 0 #x-12d3babc663cb2a9d6801c0f5372928240b619dc2000) 24 (7 -42109789 6 #x-439daa87238f972b37 5 #x-13585db6638085372b6c4a5d6 4 #xa8d36ed438fc311e3e7b9d5a9f1729 3 #x116bf5dbaba95a0487faa66050e6f92a8c 2 #x-4cbaa8707998abd9aaaabd315abb36d0b23c09 1 #x2b33eb4fdeed8adf9654320d3658aae0b37da0b06 0 #x-43e624f02f4c35355834f122ee579cb83b8aec66000) 23 (7 369095064 6 #x-fde8358ceb54a71c3a 5 #x5c973156b43835379d0869c63 4 #x7e3f64e20d8f0c652676409f7af2c2 3 #x-619e0ae7de319533ba35fbf6dc680fa9b8 2 #x-fd87b4a621c60d7e4cc1072381b050750d39c 1 #x1733fc5b39a30476aa54a690f5d67796b17ca50 0 #x7035861483831cde2ffc8a85580cc7fdd2b9c28000) 22 (7 #x41567501 6 #x3eea68f3d9ed09050c 5 #x20f056a873ca57f039d993074 4 #x209642d2759a0a39e245e17559d9dd 3 #x-3032e033d6d8f13e460827e5677f7c6996 2 #xbb7a7967c767aa758225224a3d9c16a1d64b 1 #x-717b01ce765840e3bdabb2bd774e7167956e7e00 0 #x115aa912ab122bfdfeaa25b9575bde733adae2cc000) 21 (7 -14915887 6 #xb7e82783efb9f676e1 5 #x-abbef766b3e9c9176473aa4c 4 #x-59cbbab7404238249b6386ec8ddf7 3 #x-a2a213546c4219bca3cd904754c33113e 2 #x1f1ea70aac7d9ccce78dfc5682da20fe6e340 1 #x-45feb9a068c5ac738c7aa80d1b8bf7a74f06d970 0 #xb78a12dbc9bc326194f0b3b3761e332ab447b10000) 20 (7 #x112c1a653 6 #x-178c797839dc9a7762 5 #x-a831b05dedfb02e8fea7e282 4 #x-7d8f3d908f75de20c82077aeae0d1 3 #x117e5c06bb55c6035ef51a8c3034106dc 2 #xd17de5b05d52de20b6fa1406f92f0f546090 1 #x-1a1d3f3ceb075fda2d04f12c403c320d41f8c7c0 0 #x5820d93c543f2bc70e487660f37b4b38940f630000) 19 (7 #x-26df93190 6 #x-61ee813d140247a111 5 #x-1da989ac0013b9378c0dd2e9 4 #x-2e610fdf9c6abad6830e1ecf0e6f5 3 #x1b9d36e314286f767849a5b0b0a2f5438 2 #x33a7f443acbd26e5128a75db7dde4ea05f6c 1 #x-63eb7b9153d9a065c178dcff63cfe593d3d3080 0 #x233be674e500ba316229df9b4c9b8a4d4eb7e00000) 18 (7 #x-8cc9399ec 6 #x-33ad45c9f6e7c8dfb 5 #xe1b5a5b39902ff59f941882 4 #x-4e6ebfeed49654694aa880d8426c 3 #xbabb7bdd08c1d7e581c7d4d09a8b7e7c 2 #x7b9d429e358e051dd1e171c5f0c0f1e87ce 1 #x-72ac75b33d870bcb711b0f81f88b5e53d09180 0 #xc51166cf18a64161aa34da9e63267598091d00000) 17 (7 #xb110e83fa 6 #x214444ab074757ef5c 5 #x781ebf6e828b0a59d7bfb7a 4 #x3615f575c81584e3f6af033cb365 3 #x2fbd154deb012beaced661a75cad05e7 2 #xec304f30cb34d5d84bd5d1d2df9c7a1cca 1 #x712e01b27dce8ab4a1d6ffa54b3e4833a8ad00 0 #x3da9e86e2ba08454541d568bc2470413c18900000) 16 (7 #xc9d85caee 6 #x57ce8d044263ba532 5 #x3f5540d69b55f8bd89deff 4 #x21142f65fb9f982e387df5a7df74 3 #x6a131b78aad8920c69df1814e7fe313 2 #x97c613956a1ed3375085a8171b0be3ad39 1 #x49d4180b5015fa8c985754581de1b1c6e5a400 0 #x117ef646034d48a0f40bed212ed13625cef900000) 15 (7 #x-1551b30dda 6 #x-633508f5f051fc291 5 #x-c5a4bea6677c59699d1a1e 4 #x95ef37c08e9d6869f8b91c6b8b1 3 #x-76ca48fbea1156839ba67993b37734 2 #x78d1005bf26fd5a714d17f13afba52539e 1 #x1ce1a94cdf9c162ce192982af5277d63168c00 0 #x4890c24f156710a86a6e493601a557ebb6800000) 14 (7 #x85641f21c 6 #x-111dd94bfc332bb8c 5 #x-30b8573f656f2af965f0d3 4 #x1365e42a940bfa52543437c28e0 3 #x-935bb61077d0ba8cfd00f5bdc3e217 2 #x3ed59e1c689a7367a079935bca5d316ef3 1 #x8b85fc5555938bdb9f3c4f753e4dc71536000 0 #x1142808b9952c4f12241de7b9286a97126400000) 13 (7 #x1063711e66 6 #x13019628f29deb837 5 #xf706073574e69c8060a2f 4 #x-2c2cd4ea5783fa59a833a04a6c 3 #x-30734a581bb46290373f888ce93ff2 2 #x183e8228ca8efc281ebb2cbe9aaffc9d8e 1 #x22b2d936b1f5fa9799e3aea94e05a9d77d000 0 #x3c652e1f604973ba7ee1810f06715a9b8000000) 12 (7 #x-2076e5a427 6 #x6bf01df66109ee0c 5 #xd50d06e4b4b1127413e15 4 #x-21ebc1161cbd7afb8adbcf3130 3 #x-a39a8c084ac125456842efee2d800 2 #x786855711245bf89e022c779446eaa5f9 1 #x7424b88839b3d355b37bf0cb3ef222b10000 0 #xc264ce21a381e21944f8b50aa83f8bc1000000) 11 (7 #x2e743cb39 6 #x-66ea778e9036b01 5 #x40dae4f178055988a91d6 4 #x-91763a4f3c1b5980fe3ffcaa0 3 #x-1771167c81dcf466eb92f1d5274f2 2 #x1f618afbb6d1f0d258e0883e53cb590c0 1 #x14729143fffb20cdbecb17f4e4e3dcd6c000 0 #x23ee8921bab145c37326d8969b328d00000000) 10 (7 #x1a51a8d2ad 6 #x-6b81d74ef2cdfc1 5 #x8c622f667030f45088b3 4 #x-15b51d501028e04af396b4871 3 #x-1f1fd32cd8e5117294af8d37b3c0 2 #x707bc690c442b3a5fdae816fd1eb60d8 1 #x2f93b29684ac6fdc128be9c3bc7cfc50000 0 #x616494b707041af86e78d5bddd76e5c000000) 9 (7 #x-c61676663 6 #x1d5eec42bae0c3d 5 #x-c1078da5c7060d46da3 4 #x-d9f47f0fb653ebd5e5e551c 3 #x-56725e5340828be405d4654ba8 2 #x15efb593a5a25bc4a129aa3aa50ba060 1 #x569f405aa205ca1c8dfd8e48a315c50000 0 #xf0f2e0cf94031ac8b2baffae34ab40000000) 8 (7 #x-993f7f307 6 #x20bc5d7c0578f6d 5 #x-a11ebf2d4944f79ba80 4 #x7a2e31b6adaf71cf2915b8c 3 #x-1100d26d05e584028adf742d00 2 #x3be6aeecce3ee45ae5ffb8c0949e370 1 #x66e946d9e58e3444ff1d5261f37d60000 0 #x21cdd978918731a71411c3bdb663c0000000) 7 (7 #x4e2371080 6 #x9b98caa296f55d 5 #x-260d9bd78e622442fa3 4 #x2628ae4b3d80cc5d312ce76 3 #x-2ebffd8766318f25f1144edb06 2 #x8f085938b6b4a3773b7b2546986200 1 #x-7a7b763a4f2b6d6eedf85868d6c0000 0 #x444856d2197a59208e45b71188180000000) 6 (7 #x65477157 6 #x1561033437de4b 5 #x-50783cf11986e8fb93 4 #x68d970d641fe791b6b867f 3 #x-11ea08a060ea39d54e25665f9e 2 #x1289963be8f357c290fcad67accc00 1 #x-1aa4480da8d3c857f442f5d4e8a00000 0 #x7ab51eba7ffca0a7e8731b20d240000000) 5 (7 #x-d6869849 6 #x-d3716316b37d 5 #x-5560d725910bfa0c0 4 #xc8652effae3fef2fd4da8 3 #x-3f99b15eb16989bbdcd2f7968 2 #x20eb1da75d22174c5847ff3d0ba00 1 #x-51b149043d74d0eeecfbc8ea1a00000 0 #xc114504a38f2a98b40a44fb3b00000000) 4 (7 946776715 6 #x-91282359dc95 5 #x2bcba273b6c930cd 4 #x1177106f745541c8920cd 3 #x-9be2dbe1c318253e062682f8 2 #x30e7139ff52be002a9fd5c8ff700 1 #x-9e035471fca31247177c9562400000 0 #x103fdc682b49492352a55da5800000000) 3 (7 289004845 6 #x-1fde7eecf48f 5 #x174dd577cff512a9 4 #x116fe2a0091762fa024a 3 #x-1112ac752b3b52f4cf2f4fa0 2 #x3a8a625a7d7fb7acb3e6cf94000 1 #x-da87292e958c1fa5bf9d3eb400000 0 #x12166444f82621c24dc537f000000000) 2 (7 -42764850 6 #x18435973f6d 5 #x34ead8d40985c8c 4 #xb176042058477f9d06 3 #x-14d125745a8ea24ef9d86a0 2 #x350e2f830791fe8e183178b800 1 #x-d63bef6e2d1f6da5655d65800000 0 #xfb903528bbc122563aa18000000000) 1 (7 -431886 6 #xb331cd1ee 5 #x5bacd63fd93bae 4 #x1c3f4c4d697c5875c 3 #x-100a5cdc1761d404a6d980 2 #x2065e982ce7568d4074d92000 1 #x-87fff0a9c6ec14307944a000000 0 #x9955634199303c3cf930000000000) 0 (8 1 7 431586 6 #xcdde4dac3 5 #x64a193da62542 4 #x-36b14cf3f9bf299f 3 #x-5ed5f47ecc05bba50e80 2 #x9ff470c0fa7bc2a5d369000 1 #x-2a9a4e2fd82be957e970000000 0 #x31d76f6f46260aeda40000000000)) 
  (svref *ec-g1* 127) 
    '(128 1 127 (4 -1 3 2975 2 -2531450 1 560377626 0 #x-1f8e750d8) 126 (4 508 3 #x137a9855e4 2 #x5168885f876df 1 #x10804d61698af0ff 0 #x14befe918080bdbf4) 125 (4 -120396 3 #x6eaf5ef996bca 2 #x-32f9d248de8835b59c 1 #xa53faafc84f8170249ee7 0 #x-48bdd8906bf62380d48013c0) 124 (4 17673701 3 #x45a4984d4895073c 2 #x9bfd64683323b931b3ead 1 #x2e48e9c413c5d6ff6e67be54f 0 #x406c3287c065cc0f75e713754d2) 123 (4 #x-6B3B71CE 3 #xc3c280e33644be76e1 2 #x-325a822d7d9f6c3c147e185e 1 #xaedf00748f786f5eda8528903bc 0 #x-12598c07d2cbb11d633b1cf9bceec8) 122 (4 #x1f5c5acf99 3 #xda41b0ac4618c665c4d1 2 #x2a3aed688d08d75ed7c06d2b26 1 #xf653cd7e792e748d814739e279e3 0 #x17ac968d00d27d6da9ac2738163cf998) 121 (4 #x-6fb00c935d8 3 #x7392ca02e9aed5f6f8eb6d 2 #x-4a653ab88d1f7376214c45a63dd 1 #x7b5cf415976d8f2e5a68654d8ff6bb 0 #xdf49032b52561232c1cf92d37442e5e08) 120 (4 #x134ebb337c850 3 #x2061bb9781cb20e0aa2c3df6 2 #x-55524b6ac544f77af658ead8a737 1 #x16840c474bcdda591d1f17f3a83d0e08 0 #x36cccf46cab743c258205be8c6e861f2c8f) 119 (4 #x-29ed59680317b2 3 #x52628e635247cac624bf765e5 2 #xf4cef62a571685bfc5acff1432a8 1 #x-73f82f4b427d3da8f6b03810ded9743f 0 #x832dc9723259a22d37b3f8e3cd14530f33e8) 118 (4 #x47b66805bde69e2 3 #x7c21ec7133d1eaaa54bb8e2eb3 2 #x58562c9b6abfd3d7458a60a9c31de0 1 #x-79aa6f2201f4834be535db949912cf8e86 0 #xd9eab16ade662b24a28a1b236904778a77a20) 117 (4 #x-602fcfba8dacea7d 3 #x6f76f745165de841f13cc61d843 2 #xba24f275d5852ce5e35b49cbeef875f 1 #x-fcb13ab5cb572b362426fbf1883a99d82fa 0 #x10c3b5a4170bbe322b401133ec0e0b99ded9dc8) 116 (4 #x63bcd42f8c38de96e 3 #x366c6d5d9c3de966e3b0ac521958 2 #x185295bd8e83e0126469d23da1b298fa6 1 #x-12b1e4f3cf7cca0f6f24b8fec4db8e7b88e79 0 #xfe7ebd04690ed14219647b5dd143d837c9f963e) 115 (4 #x-4d82b761ed14414076 3 #x57840c366416f0afcea3730ac91f 2 #x292fe6a1b85d0690dab7372b1e4f418bcd 1 #x-f48394d7d888f9e006a00833e69cd4e53d922 0 #xbf0ffe9881f3dfcc8905ceb94bc83b1a92fde220) 114 (4 #x2a1b61cf7b664626e49 3 #x-a6e5ed2f5be7972bbfcb9e92d68ac 2 #x36c3065ef3a912cad09b96bb5b9ad6bf06a 1 #x-94bd98e37329b44148bff98b4c69e25b1f9a85 0 #x73895d1d4c608d993da51168f518ffd3ea512f44c) 113 (4 #x-ce87f688fd9b5ca0f18 3 #x-6e96b123b0af2065341aaca038a0eb 2 #x3ab508ee8334703f4398418a1453b8822908 1 #x-45d055385a66a1d00b7e3f938fb6037fd780ed0 0 #x38e1a3de33eb838cd1a86e9fff6855390611dd31a8) 112 (4 #x-8c870d650578ad923d5 3 #x-1a26d2db64ca93178e1624b5e7dbe27 2 #x34190c43d3e43dfc91b620a0638848c7a6605 1 #x-19dcc291c5c6b28d2bb87a5ed7e9b669116fc70a 0 #x16dc8336b5bbe0cccecbe574bda94d3146f11e15ef3) 111 (4 #x25d0b5ded42df721a0664 3 #x4103ed4732fd40daa4462f9aeeb8160 2 #x271453fe44cc882b8f760abc9e600365d92eda 1 #x-7e715041134517e4f476e28803704fd1bf5fb309 0 #x76df86bc46b6419a91f58b12eb0caa0d03540e1cb40) 110 (4 #x-c62b93508d22e1e2fa294 3 #x4ddbf8e9a33757ec9b4e6b36a9d4b6b7 2 #x1934df1d962448e4610a5bfba0e37a7f1af6f54 1 #x-2598fabb290ebdb35d68e80b3b438c21977727c6f 0 #x1e28bef9db47a8908be0d14b2ee569c021feb11b7a90) 109 (4 #x-148fd0f14467a154dfcd81 3 #x175d57a3733be481461a717dcf0f1c4f2 2 #xe2f458cfcb13a9a955285484fd22fddd2346644 1 #x-f13da0c1ece9a436a091e98179c53993f6a57be37 0 #x552a7dd85001e0bad6c010a54b2b37956c8c9c261500) 108 (4 #x1a3f07c97d856c3c803e14a 3 #x1681fa5d4e142bfdeecd2444fbf5294e3 2 #x70d4a4443cd17d87fd535e7c738578e919932c48 1 #x-83206a36aa107d530738fa6c826bb5a9d57a943706 0 #x4dd917c6e24e0bf67c84dc4706d36c60e432e4d9be70) 107 (4 #x-205440b6ac23f46d8e8436d 3 #x-16a600976e5f949ee32f8b95d8636d96e9 2 #x3219ac0263ec1cecf5b60e275066120a8cab08288 1 #x-470cda647d2759f86154dac0b52a87a5dd407bd1dfd 0 #x-3214866f157df059f280895f3de6e132b4e6b3bd79cd0) 106 (4 #x-20c53dc26e36d904599e81d9 3 #x-955e1d0067a3cf930b6a0a23ad160aa837 2 #x140f6b7c9db2b038003a98a49c56bf9742e9fccc6f 1 #x-2154e244e957d94f1301dabfef7b2678bb5ee3d91ea7 0 #x-16d26ede47a19a96ba868aa5abfa9e10cd0c763ec36cc8) 105 (4 #x47e7b003363bfc631c7133d3 3 #x-195801bf5185ae5a831cf5248ca2bfd60f7 2 #x74de56778ba8e14d839acf1a2dbb8f43d5e2271357 1 #x-d4d31cc14c8c24b4083088149b7bf2aae3926ef19d79 0 #x-55d94f9981038d169544afc63e3f54985f7eae1d82d6d0) 104 (4 #x219ff4b0c455b9b223e2e532a 3 #xc947aed0a881b9fb55ca9b071b24e73bc4 2 #x26fccd362d5439cbfd00c4b0ceec44a4914e65d39e6 1 #x-4907c958ec0dd77de1c87f907b191d7aa72a968827cb6 0 #x-a2668f21f3317bcb68275526e3726b8dbc8c8d9639c978) 103 (4 #x-4340ed051307b7a9f2710620c 3 #x1a1a494cb4c6dc323866464bb9e44d527bf2 2 #xbfed7b31fb8f6a8301f86b074d8436a0350bce0ea6d 1 #x-15ce6e4c059ff0b7129e28a302628698801333de2ca565 0 #x11bb364354d7a416f511b25dd37ed1915b891074657ff00) 102 (4 #x-1f120aece708c8466d06118480 3 #x76e87349cfd69976a7efac75c6b28b75cf49 2 #x36c8cf1ed75f2a9b1f4271117519cf9d5c0dd95c37e4 1 #x-5b4b92e09b48063830dd169dcc375c4f61f8b344cbc03d 0 #xef0a27c45d2edc891579cf1a16677d0962c03311e370fe0) 101 (4 #x1a1f417a371e6a050fbb4161c9 3 #x10c2954d2767e4f5f2234cec3fc78ed004c17 2 #xe95a28bb15c6f4d91f18e01b90f2a01ff1036f267a04 1 #x-14eeeacb5315dd8d25f761f2fd051e14c0e52c464813983 0 #x45dfea533c318b8b983cb3683609509e1657411c84e8b810) 100 (4 #x17876049defa083c713686fe679 3 #x-1e2b3e7468478fab62d41892795d3f98bbd6 2 #x3a361fca1b3b7fa303a419f5139dc4c3ea17a4ca46132 1 #x-428814aab14b3c44267c1d0cda3e36cb1969ea93ccbf722 0 #xce493ff7bccf9538675f2e6f28a5620455304256531773cc) 99 (4 #x10c351b7082762031b12a50c840 3 #x-b7865851353ff0164d191c289ba41414ccb79 2 #xdaa23c0903b711a6b3834a7588ca10eb8966e6762bc72 1 #x-b0abd9671e08aadbb7e591c94280255926bab2260bfd4a9 0 #x14cc3d401bbd76fe783ffabd825661a8f1b3477f0ad1b0f30) 98 (4 #x-ba69a379765ddb8e57c96ce08c7 3 #x-3508f659d732d1e2ee86df87ec132aa735cc39 2 #x307a314f2286bd96477b3caf702c9ff950bd0fd10a49c8 1 #x-15c2138c707d403e54977d90df7cc1faab463ba43fb2752d 0 #x-16b71895882c0dbb942dca3373173e9b84f1f4a11c95fa290) 97 (4 #x-1e4b5db531ffa6caf01f7c8fb94c 3 #x-8e12f7a55bba40d79100e4c3978d1ff70a1ce9 2 #xa2ff63e7dc8d56f1b3d7ad1e016360264e55012a9f991b 1 #x-d61c8ed6af950b62ea770fbf92a2a1553be6edc217822c9 0 #x-12bce2581e643a2b56d7bf331b36b0e0779e0a4c754774c780) 96 (4 #x18fb06f1150edd52da9d1d700159 3 #x-c0f1e769e19be9f990d0076b33a76bce1831b2 2 #x20901238111cda53da548949c75844c6497aaf0ab401116 1 #x9034a7a0b60da1b786c7602e19d84adead059ed5851ab0c8 0 #x-4a1dbc5df45322c9d7a71c3bccd5802b95796f9a8582b69d5b) 95 (5 127 4 #x107cdad8cdbb775434639b2edb2b6 3 #x130b91784a2d5556f318cb58ad06e220cca3eef 2 #x63371ff978eb1da74b13b31ac6f4d462a619ab58bd7865b 1 #x3cf05483bca2003f20f594cb79a56a2debbe7cb4d321307e7 0 #x-ad4600508e78f554674d2f310e11cc36b65520311042ade6a8) 94 (5 2519934 4 #x1e8ea61abd777619d1b1b1e4cf520 3 #xb87e662eb019759af6b65fe478b1e936533ab8c 2 #x120dcce80c37a19b087aafa6e9e750e7726869588bb4c812 1 #x10948c411080c2c1ea80ca1ef8ce960fd698733a9f34e6face 0 #x-863349e9abdc35da1947dcc40328e516d39b77056f537d9234) 93 (5 #xf8946295 4 #x-108338c0737f4d41e4437e95c5f44 3 #x2b56f9f70eaade68a3080f3e54c3fca85019b4bd 2 #x32564adf84f646a9a665b5aa3ff592c9f3081b16548e9ee0 1 #x3b5d0eb115b6b7cd1af1a03edb2decaade893a1373ae54cf98 0 #x3b3cfb60b30e9967a1ce32b46bdfc8d1c9e94ea4b2c92052c10) 92 (5 #x1948dd5c13c 4 #x-e01cfa04955403ee16f37523a42fc 3 #x6e8bf7cea00d0cc793a9e9ec91fa1ee8e902827e 2 #x86aacb14b817cb6db6e798ef7deea73c203a78caae21d6f9 1 #xbb084cf72eea3ec8073e4d10959b1e82111832b487bcf49933 0 #x16b5970e6aff5e637d2f6e52d22ed36bccd73953bf20c5e0a8c2) 91 (5 #xe2a20908a0a6 4 #x-265ad75e16fb6266347eacf4e83abc 3 #xbb94e115fdfd32b0dbf2317adb9101b13c0d5dc9 2 #x15a4e087f284d870b29f8225528175973da7685aefaddbe4e 1 #x2157743e81089fa0af3e79b576e3165113cab4ff31f694b31f9 0 #x4eaced3980dca9dcbe64c47a82a7f338256476f3219d444c1458) 90 (5 #x2f030f1b2e3557 4 #x-2e773f1a5c190d2c4f5f480967dca4 3 #x4f0c4877cc58268ea504666a500914c3b893d598 2 #x3595e80c6aaf6fa13aaeff85430aaaa303969410877d264c7 1 #x574c73eebc6741e607db343a19ad6761e030b3b42a2c5c2420e 0 #xc300ac3a4122eb6bde1d1a6bc92a69d098051f4d0bf92c0d7628) 89 (5 #x2e9d6faf1884e3a 4 #x4899496dfc1dc97d605bf7260d45f8 3 #x-37118d9e3ed1f81c599287630829ff20b3c3b0c78 2 #x7fe7e63e74067aa8588931ab53b7541a728ca7886a977c21c 1 #xd335d925ab68b17d32760d9a9b7db0a0c0a38469c5b066dade2 0 #x1482cca0d9045431a2f515aeda7bbd7c2d807bd7f1c62e7b54958) 88 (5 #x-ffd1586c3c04d55 4 #x22bb933992c6e514f7a0ee506c87cd2 3 #x-10eafee06679bcebf3703b6677ffb9cd54cbbdd590 2 #x126bb1d26e039dbfb159f0bcc3312e329b4c9e11c7eaad81b6 1 #x1d8de9884b52406147d04c036ca9656a9f52ce47e7959d5d1f8a 0 #x9ec5634b6f7e85ee33f01334fac7b420aa68147c2132474d7719) 87 (5 #x-1859771a0f2097fd6 4 #x621d9f3b8034d85e231830f96b1ed06 3 #x-33fd39189a9d15f794ca0f51ae88339d712f438c89 2 #x2906269f1e441009460e0eab568dc70b031f0bddc45a474e95 1 #x3cffc3206fc3cd2953ae1a80aaf575b7c337f7eadcd8e200b7aa 0 #x-5298838d7302381a252076433faaa0da235e4358747ce49dca798) 86 (5 #x48c4580951e020482 4 #x91fb352c7122246caa3db72bdc2379a 3 #x-7ad5f3f65ac9b623716b4e3764f62147d7af0dc1bc 2 #x5864e8db43ed0ad7fce9582b4cd95bdd3fa000006f1e003740 1 #x72b9ecc1558eb5732571ca3fad88a156dc74eda852972b407b6b 0 #x-1808e8a9816afcb7e753990f4e0e9bacf00164d7df6de25f30c478) 85 (5 #x3281d2b1cfd9fbbb95 4 #x-2c577ec0edb2bca69309a601fa2ee16 3 #x-e1e6fc39ee8799d81ffdbe7fa6966241491de3df5f 2 #xb8729a2716470d265de47bd809f919d0e5975ed11cc923b00b 1 #xbf4182f606db37bfa895ef94a5926e6d1ccda7724477d09aa491 0 #x-3ec232084dec33deb24fa9db3e25073fd56b3465beceb9611faa58) 84 (5 #x-435a01269f1da6acad 4 #x-3d9cf45a0c75f0c60b709074184d684e 3 #x-1165dc289f76200d5a2c15675ac37f7236055a1fdc7 2 #x1750ae508e6587c0008bc8c92ef8b9e226bbe03989651cfde94 1 #x10687dbdcf7d4bdd7cdb53df51d02544141662b7b20ddcf0c24bb 0 #x-5dcbdefaca346af00f1f274ab0dc4aea6a78037d0850e2455147ee) 83 (5 #x-34ccbcf24bf1150749e 4 #x-d0c70cd1dcba724ad21e0bd6a96a1636 3 #x1835634b3d01abe035701b9cbd6ea1f28928af0e52 2 #x2dbd69392aaad9b98d56d48b7adf830f0b09f197ba663563f25 1 #xda491b0f02a3b0fedc7144dd8b040c2d0769dd999ffb35a56e85 0 #x3e511692477fa2782191a4d0f61c9caa12e1f415376623f1741340) 82 (5 #x-1f869e1749965f70efc 4 #x-1af51811a74cc9564de2044015b1b38d6 3 #x5c2c38a194382172226701f47aaf6bacee6ed08e3e1 2 #x571a08513ba9b7e195a18f1219a6588e09fc4a6f95b68c66cb8 1 #x-fa944fc2eb86ff4bdcd0708ceb0ed2b9cc86722dfac06eedb3da 0 #x42c84fa90762476c21f3f2b47a9166819697052041b326634b30a64) 81 (5 #x14f869617f11dfb65faa 4 #x-1e490ef0681bae93f2b94fb8a98070e36 3 #x1679b09fc6c176b64b5be512fde7acd785461c14cd54 2 #xa11aabce8836341d207056c809291d58f9bfaad1a375123c78d 1 #x-75c28aae4707c04e6cc90c6ea057a91cc2eafe990c4a89a3d1107 0 #x130dea2d7ee61ce3e09882e6e60841352a0c4c7e9e752e6825a99048) 80 (5 #x573a27541d3f21415b73 4 #x1a968db9d6d4b9bf091f9384f2412944c 3 #x3ddb8cd07d429c43b8b40bd0edecbccfa7982adf3b2f 2 #x12196f339237bfb2b680306520652ec9cbdd1f299780559b2b3f 1 #x-188ae3cf8bf1eef3b6dd09b9653c897585b55b83e500d1d6898e6c 0 #x406929500dd2e715b414d5b053fac5a2e1594333e85d9ccc9658e5ae) 79 (5 #x6760d0c6b23bf740f50e 4 #xf678174ac8ae6f0429efc3fb6e1ee3cfa 3 #x8c86dc5e05f7d65ad3e3e4c9c37161b52aedf89a2156 2 #x1fa260e2ee27eecb1037ba7e4a0ec373f5ffb136782ba581e07b 1 #x-410af6001166bb600069d0f9f113312ab03e821bfc43abdff8093a 0 #xb94130411c431ad812c5617f9f493424fdb9d5d06510c2b1c4b715b8) 78 (5 #x-23c1b62578e2b63237e36 4 #x2fedd902cb2790ee3638f74c18a98dda7d 3 #x112927aeb004a66173c2471481a37f89018df4b3fb0f1 2 #x35c95252386bbaccce0ebd9c583059ed50e0279031ebdbb66e42 1 #x-985df2c2e93e46c75a961f7a2b95e87d7919e552055bd105d72ebd 0 #x1dcdb25318293f7482bf7a56be2a6d34bed1f5d65a44438661aceae04) 77 (5 #x-4ea1579f94bddaecfd701 4 #x65e822582838bbafffd3e1e5b5e739fc9e 3 #x1cd8dfd3c03c83e5f186b798a52c18ae3242590ac44b3 2 #x58ffd26e2bd296cc8c18bf01c053ae75463dcc76d065653c4844 1 #x-1483dec00f1026e2cc22a10f1d7d14bb9ea6c23cbc6c59da6d5e44f 0 #x46684376943cfb105e02d9e8b44ffeaecb71dcfeeebd849ae6c05ab60) 76 (5 #x-88c67f91c60804c98882e 4 #x99f11d54864af989bffbaa0a5d52b74ed7 3 #x27f78ef986639435a5d33234505a13b0a543e12d22594 2 #x8f5efe8adb5261abb0c8f7a8e25bc63541c093b37f8fd6cbaf89 1 #x-2970073c294653ae3f29433128e3e628702b50bc514b497082ab54b 0 #x9aed8d2239743eb92364603b7153457575d35d2c6cdf10c48f6bd7f52) 75 (5 #x-3aab60d51b48fd540300e0 4 #x7eda138921704ebaafa1e7ba39c5638808 3 #x261df1730c4cf84a4391f3a6fce049a70a22757a139c2 2 #xe0ed446f3dd0068860cdf8fdf425ba841dffd3c8cb0af96a1e26 1 #x-4f585100f986343059e140b6ac0391294dc4e43f53907ec367a9906 0 #x140a2f5841dec7c2667342eb233250ca8841f4fca831e4825b9787bb58) 74 (5 #x38259b4e4fa9f2d808a9eb 4 #x-63bd9b27e4fc231a35b2168a5349453cc4 3 #x-55793c41805d0346012a29f9505042d7118e5864d4d4 2 #x157c23388bd93ca6548cda3f9eb672bb34c2067dfa9db5e21af08 1 #x-9107979b39494dca91be6affcb76c0c8be792abc14097c9a4c2f4f7 0 #x27464fe8dd67e847cde8ef91867e3f9c37a806549fed14e9d311272378) 73 (5 #x2addc5095a45052091c8bda 4 #x-1d51a481f097d009c63d5e999d2945f6511 3 #x-91dbcbfd8f0e56434c8ffdd07f917b24f12a4bb1dc73c 2 #x1ffee475ef446e35955b9d65cf6bbd166c77c51d4ebb3dd328591 1 #x-fe3b94793cdf30c07f0e4029bbc2197d99c7467d78bee18816fc3df 0 #x4942b483661a08b884aca26b6aedec3d68d19c6e5e7723b67de9b6d4c8) 72 (5 #xf08356613877f8d0b236cf 4 #xbb3135552594ade14d9bd64375daf44857 3 #x-1dd91a61150bfcf9b4d67d47466c59021ef6ceb9f13504 2 #x2e70a932037be0f71ab3bc36424258964ab0eca80b7eb789a1ece 1 #x-1acd1dd35df875456522b351bf89e52b297bf5c5a22eae5b94d17356 0 #x8293f270fccf3bc8f71753d23bd33e4745f7d11d0ab674c780a4de15f9) 71 (5 #x242d87e329868f702c50804 4 #x1bdf2f9fe75cedf374823b9754ce169fb5f2 3 #x-47674bd6680f82d147146a7b343f9c6babef989a747563 2 #x41b57ab9aba78ef720e3d1fbf80f25e183b1112e7c4e6a275a4d0 1 #x-2b9a59e5d9b7f8aafe27a9aaf1dbfc155e856736e93c43a4936d1ce1 0 #xdf15997988755ceec21a80416936cfd578d91cc8273ab85eb4d1357318) 70 (5 #x32caf03d43817b3f07e074d4 4 #x94e26adf135fc3acf107e6c93af81e06803b 3 #x-919a28eb25e7f0bc1e929b2d648226b8b44d0f5901b4f8 2 #x5aa5e015d7056df7d317b8f961b58247202e5457dd2368f3d1556 1 #x-448bcfca4fa41ed11befcdde3f75d51bfedf4cabbaebd9df63d49036 0 #x16e403ec456dea4e37889758c1e1e92673fdb15b6274c8cc0799097a3b8) 69 (5 #x-3078be04afe783eee15607c8 4 #x236a7aabf8f5c418c6432656b0838081d86b2 3 #x-109eb3ce8771168c80dd012c69512abdfdefd2eed192425 2 #x79f14d429692a2774fac221889c102872c36554d2c9c7a4c6a1e9 1 #x-684537d6d0d893ff1d48832a822b3ccd49b851357108d1153bb17ea2 0 #x2430f84e205d4eb5303ad3cb28a1ce5fab5e0ea9233f8b7702424ae58a8) 68 (5 #x-3b5ab05c65c2f035ad98bc0e7 4 #x7216b2651d71a9953d9a26f71cbeff86c8043 3 #x-1bc3ed4cc917ce3779148c30512ce24e3075b52729a3aa3 2 #x9ffaedf827aaf7da07d7c5b8cfef4f835702a12157e8f1941ca74 1 #x-99a514b7a926b14124342b6c1fff2faa52c5329f0803f3c1d54e05c7 0 #x373429410373dec9e669470e49c54387a0361ebd381a7a44482b4c52462) 67 (5 #x-847fe1ab0887fba57c8546c4d 4 #x14ae47246f1c601b08b641396b8517e6cc8ff6 3 #x-2ad2a1bd0eba354e80efca475d83d5b1e8608612442e6cb 2 #xccb494bb972b33c9d5a349ca83807c45986a3e0db9866e43753d7 1 #x-db7e01bb9a97f1bae51d87981d5b1b4cb15cc43d855da96b0cd52428 0 #x515cd1491e4caa671879caba16a23bb0d45d0ed7728b32b83374851b510) 66 (5 #x282786826ba9c9fcb2dc7b6fe 4 #x379e81001fcbe206ab72fc2a8fd9301eddabe7 3 #x-3d1b29ea9e65c341235bb05e91625f6e59e70fe25b21fc5 2 #xff7d4709ef9311d3e435b6e0524893fc05236029dbc20593cdac0 1 #x-130314667c08ae79d90430c19cfb2d19ff907c3f34d83dc9f49143461 0 #x74069cf95f3ffb81732559500ae7733189475ccec6e542a04bb9634091c) 65 (5 #x3de0a9914ffcafd3c9990ff42b 4 #x8cecdb6404dbac5d5fef0aeec46baf06125a71 3 #x-5055e6bc58aa3751627c2b2c6943dde147c1d93b8b4cd1b 2 #x13709f33b2d9302ffc84c25d91798b51a9a36a8c2922c961c17862 1 #x-19930ae6199d68ab9b19d8ff8c99a4374315d1a932c497c32e647d85c 0 #xa04697f4a2f1a9b13786f3308a46091eeafbab6a3da9cf3962dd1c80dd8) 64 (5 #x12648cd2ac14d87c1e35e9127cc 4 #x1536f9b1ff078ac8f7270d74c2d65e61177dc11 3 #x-60090cf43d052ecbba78255fd44cdd2050ac0d5f5d27a27 2 #x1715ee07d57854d930d5c9cec9d22c80f80ff3567a906a587a1774 1 #x-2167597c93e1ab9707f4e0c2ec3fa3bd1f066179d7295263bf05d0504 0 #xd6b0a5f26d73d6419020ed8919a1bc36fa25b725d95c81be24f2f1c96a5) 63 (6 -3810 5 #x496b98658cc8008777efc35e4b5 4 #x30d3b0037866ba976508e9ef437d9194be99dcb 3 #x-6524d980d1eb96050cd0d8963556c28e8a83be0a3783033 2 #x1abdf0d12a7c923e33b43c275d99fe372e9bffe0e1ddd342f2e340 1 #x-2a602e038c6dc41e6f557088972aeaea67895e1e60f1bc022f068e98d 0 #x1171d5c3c77f21fb5020f88da33cb84c44e4a03a39092558d312ed7da650) 62 (6 42698289 5 #xde2ae6c92e832c8bc185f788cfc 4 #x6bb540e854c0b567e890b70eb52211bbfb62042 3 #x-5612126b141a1cce30555df1366f996e0ab5bfb56064bcd 2 #x1e373e795cdb12fb3cdb0cb8a2466f8aba3f3ad775977228d0ab2a 1 #x-3438ca361d9a7e06d81d3b39354fc5200add140a5e327026eca274291 0 #x1607a3dff64e01de97bb02494e4fd8ddd502b87bf36ccac469f5bec53b20) 61 (6 #x-62d8af912 5 #x1c35712bf55f913048a46af97374 4 #xe423f0df0136586cd6fbeb38660f9a0ae505da4 3 #x-276987c7bd37869e505aefca9e8e32574948271a0cccba5 2 #x214cbec02d54f586371c6957e649e5384a2c7524217ab980b2011e 1 #x-3e86159bfbbe3223a870a18ede3c24fec28b303f1aa07e596485f4ab5 0 #x1b0aeecc98fea39c47ddb53e2a2f63c906ac82ae7fd59f8e9928acdb1f10) 60 (6 #x310c41d0969 5 #x1ab2b78323634be58d86ea1736ad 4 #x1d08fb3423ae053c09cdb7161934736c3581da59 3 #x328edee8f8799624fa9e737e370d1c4f630fb9f0f85fe01 2 #x23caa54511b1dc6fb17772104f16303dd8bec0c9900233ea3aafc2 1 #x-48baa2a41ea5632b346bc4d9a3ff5fa87ff2abd29bbce30debf0ef4b2 0 #x204a04d4ce0b4d866a96ecfd3fa96b90159b435e7913ece363786ccb3cec) 59 (6 #x-8af5e00e2e0b 5 #x-42f830a5693c8d00199b6ee2b9d3 4 #x38e3a0015865e7c291325502e3d035de31d8fde2 3 #xc1b3d7a365bb2c5b5079c735d8249fb856867452c1ee359 2 #x2583e23f03a2e65e084595488977b2210952866029df332f0aeb44 1 #x-5230bdb32f43814d240678ae09ef5b468bf7ecd9b262a2be7beb09e63 0 #x25856def3f216e699e3c1f9a4c5fae078ac7aa77d5e9af15de1d41b6e3f0) 58 (6 #xdcdc829c03d01 5 #x-1e1a1a8f5b2c8508a4a39d173dfb0 4 #x6b5379d931010a561c4845a34ad6c329e55d5f21 3 #x18b6eb77ffb06a09269903131fb48bce60cb9b5870180313 2 #x265744db898586442be49238099175be17bd9932ed7a9396f81789 1 #x-5a3a03940689de2853ce0718e424f0c46d9f18f151445a6021611dc5b 0 #x2a7480d1fd67d2cfab7c0ff4712241c9e3b4a12486b54a44a1f87e19f5a0) 57 (6 #x-aeb01e0900385e 5 #x-730b3bb9dba433c67ef10bf8ada6e 4 #xc3140f2fffedbb9ffb845ac2d13f631233301520 3 #x28e3ed0da1daef812ff19db8c6c36584e56d5746352fc4cd 2 #x2633849648132e093730bf46d931d7596bcf00b21f92a7795c0bc7 1 #x-6032c574ea91655bf16d632ac6da884e773723522951fcbda891b821f 0 #x2ecbc0b2c5ce3988b09f95f69e6ca1f99678abaff5355657a89486225e80) 56 (6 #x7e6aa5bd6912789 5 #x-15e1e7bad27713b573449f182e59cf 4 #x155cbd70b43f9785b0ab8f6e9e1ca88c53e763f54 3 #x3c006f0ef1bb3e90908fc17e26c9d2baf9578aba47aee8b8 2 #x2519870a6001e07cccdf2b4361a7355ff56bfce753a3de8a1b88c1 1 #x-6396743573fb8be88fd2be00944269762d5cabacfd5cf57157df5a722 0 #x324441db9917980b0480ec367dcd94d3fbd141916640f6e7ad9f5a6d4608) 55 (6 #x-19c66c161869d9e5 5 #x-39317009b74809663e92a5671f4c24 4 #x24189212793cacdf8168e346fe9d99e0871634378 3 #x50dba2760bc1e573b9e70f45dc50154a3612b8c02d20b90c 2 #x231c7afc5497826b385b5232a264a54ec96335f1601c91a643b695 1 #x-6411b5dc08ab1f2eb7d164feb7a5c0ab2cabed1037010b008a8fdc871 0 #x34a31520f1004744313fc938adf70c5c9b5b5c28bccdef02851f30a01710) 54 (6 #x1203fc71307a931f3 5 #x-845aa53e61067a39719c0cf3b20467 4 #x3ad7e798c60acb73e3adebdebcc69cde2099fce6f 3 #x65cc8c62a3d24e05028e71550eb8f94e10c8a20d074510ab 2 #x205fbb4fb6ea7d6a69a66cc4b47197a96a8f39e8ae91c3361d636c 1 #x-618edd040f2e207c908be19e0a7bba4b950e7444157a781b040c49db7 0 #x35bfa83bf45c3a7a582b11f0677028c5df6da4fe33c26b079c69e8453df8) 53 (6 #x28672a830151127cd 5 #x-114a6d2e3eb956232be4b076f6821f3 4 #x5c9444a93e4e253a0deca4a10840cda4684715c83 3 #x78e4bbe33c4aebe92b4fcbf5f920cd99447e8703656c33cc 2 #x1d12cb0b65f4cced7f0453f8cb11b8a6b6bc2df20d75ba1429525e 1 #x-5c3a4a0ffa32668f066ce673c7c32226b61e65925e10afced386624cd 0 #x35882918ba7d04a9de7df54f0f7a854ccd543662b91676cad6b61c878210) 52 (6 #x165d98d1598a0bfc38 5 #x-2109c7ae4bbb0c536b7d7639118da5c 4 #x8c9d5bdc0d53710bbae42334616eb9f47a34e70d6 3 #x88378ebc60b6ee222ae3db59489d6ec7076329b4c7460c90 2 #x196c0abfa3ed5f189d8f5a499cd7ccb77a3dd7d479de460f98c110 1 #x-547da75f6bcdfebd40e8a4843b1d4c0c0d80cafcec7889204aef994be 0 #x3403474c76d296b135660a644704d505b29e7f0abe7e0e125c2b89ea8a50) 51 (6 #x67bb8a32ab1259ad47 5 #x-39dd0e063826a5baa03d9886c11bf81 4 #xce3a68de6208ea7afa55b21fc5a3c0c33ab922679 3 #x922881fc3ec1b743b1f4aaf58c103ebc064e5f7dc07bebe6 2 #x15a2f7469065e39d5de2145a9ef0cd95b4b779ad4d88dd376566ae 1 #x-4af2a79778054ce6f24c7978e8e0602b677048ce0d972d4b4a61eeb5d 0 #x314f1a168b044f61f35b527b50c0028ce0bfadeadc98511721659a05e0c0) 50 (6 #x1a4638f132d28dbe508 5 #x-5c438633615243fe803c41daad2907e 4 #x1241a39994b1bbdf9745bedd49a46d639109a845ef 3 #x95aff51d47ed94d60a84d6c9df273a382c48819cc2eaf87b 2 #x11eac919c03f5c59beba750ec099111317a2d2f63db57d6664b626 1 #x-404f89836bf06c53f703a39d80202fa921b3d1fd616613a078aa75a9f 0 #x2d9d650cc5dd9b2259f691ac0265fc598f122107cfe1a9e50bd9b4324680) 49 (6 #x5da5f25e389d0e22d50 5 #x-837e0318b31a6a521a61d5badf11b97 4 #x18f9b493029164f0297c1c155e111e0df903aba124 3 #x92870340b9eba2f30b00d5a821e8f61b6ea591166a96b449 2 #xe6e2aeb68a8ab49f31a91f24d590cb72a0bed518fdd3048608881 1 #x-3550c5e2c92c3d332c5a29accd182135561eaf791a45d4a14329ffc03 0 #x292ddb157407cd3218c29d516d664f2ed2c153634e080e3bf8d345b06e30) 48 (6 #x1341bae5b663b2d517f1 5 #x-a0712efed03375060f8cbc1cc4b1757 4 #x21005105b98511d8b1474e7afec243e75b779640b9 3 #x89309090db5d9eb5c1474b10c03aea9e0bc4cda00db37e38 2 #xb4c7f42e74de89499ba87d4241778eca5f391f0c10d8ccc4d3892 1 #x-2aa3ad9bceaf52daa7d63e903f972a83ef4c193070ce355e9d77aa6c2 0 #x244743cf9719064ba8cfec13a49cd36d55937226dacc3e358194718a0933) 47 (6 #x39e4f399f65d7f5072c9 5 #x-93166f50d4cd3f19995cc9fcbc16f90 4 #x2a1db1fedb9fc47f9c1785299fe2fca944ffca5222 3 #x7addebde7ee20a7b4648f9ce1d1841436492d9a1e1353377 2 #x898def3484afcf48e3c1158063ed2d322e7d60716213f098715a5 1 #x-20d5517369616a66c53f471d403e355e23704eaa1579b2273adaf1c87 0 #x1f3080418a1016b730edea45fed5781266de9cd0dce714ef368f7594f4a8) 46 (6 #x9f253bb6475adc673ef4 5 #x-238c9e9f35c424ac72b5c689090503e 4 #x33e7c44560188262d2e8d6339866995503a755ec80 3 #x69360a15645da0cdad0b8a4dac0390858dce2786bcb41e6f 2 #x65aae91e064c79cb480731dcdedf897b01e161156472908a300e4 1 #x-1847f490898dc71e52af3d57f735bfe3eb2ccdd35ed6f99899bb3dd72 0 #x1a2a57b0e618c5b8b6db1b578a49fa134ed11888bbb97a7e3591319f64dc) 45 (6 #x197dedb3c5813680ef031 5 #x102d2de674fb2391128c90ce07f1f511 4 #x3dc3e181c83cb969ac02035d525602bb21c9291369 3 #x560ce74e3efa59e87e0dc5439ee59776f367bb0067f1ab06 2 #x48f6e56319373a33d3713831d3ecebd6b45d5886d3558e1263340 1 #x-112fd6b512b5c62a4df69706ba37bfd0891904a4b0a800e9193fb4eec 0 #x156abd24621a41c8b05b6ba2f2263d0609bac26114aec3a22a69e87c5c00) 44 (6 #x3d727c5adc0895836d044 5 #x350c331edb5b50948595d07155ff0336 4 #x46f2455e3d1d54772dff9632654f4821bd1d102017 3 #x431b39276d7dd3617304f09405b0171cb3645b90ac92a1fe 2 #x32d471a721713ca729612461c3555e012e0b84fcf8ecbafcde32d 1 #x-b96b100e3db900b2b3f48c8465602e049e477df07099626bf3a4dfe3 0 #x1119efe2f34c10f7d40b119728749851fdca7823013bcd364fb9d6b4415e) 43 (6 #x8b6f1793447f4d017177e 5 #x74908de9933371bf98af64bc05d38a49 4 #x4ea337f03a055cbeb2d350525a19da3fbfb1faeb80 3 #x31c4deb861538ea6116268922264a17a91c70fddacd08eab 2 #x225d2a6e3356a8aea5f1b8c6cb7f5488242f4324c363a87001e0e 1 #x-7642456d1a27736a7b37708fb6bb6f765ab1e627702fb6f673c5f77f 0 #xd51865b491757b5b573e3d118f2e684e0e592d08aa152a976bec80b1bf8) 42 (6 #x12a2e0af009087de7fb263 5 #xd6a7db3129124cfd0c93fc59f36396a0 4 #x541362fc56ba2f815cbfdefea0bbe7668ef0ad51c9 3 #x22f7445e41ea01268b514f1aaa81966137806722c0eee456 2 #x168b0bc95adb6700d219ce0ff364f477355813da6ce80dffce507 1 #x-468c6c7193b0a7aeebb66ffef1ccd05c6316c1acde594ac8537ccea8 0 #xa1d2ac07419d15a78705b108f2d1b808f0416b8a7e6cb0a8fb0db2ae0f0) 41 (6 #x25dd1e454d5edd5d6bb720 5 #x160e45fd75352ef0ee8367ec402d4ae9b 4 #x56aa6abea671818592a3118571f8f64e61fa36787a 3 #x1722230c38cb85f525ffe896ba821bc16c54ad80b00c580a 2 #xe59cd9a91eff8e9b7ada5399162367fe6567ac8d4cb2ddf4666a 1 #x-2697f58cb933d83f06abd93426da436b0e96e4a129e1433c327e9ff6 0 #x77c9e41bc82c62a28d02aea7cc4fb9167c23bf98994fcab18f06b25e828) 40 (6 #x4951b2ddd4852e2dea6333 5 #x213ed059ee7e7f81dbd73aaed38a6a18b 4 #x561577e3d5a3ff814c5f8d7cc669109def3241aea1 3 #xe46b7c7b18faff83b3ed82ba4ee26749f045dec1ade764a 2 #x8de0524cf4d6eecb9625e8cd3cfbe7d7da1d98f440faa851cd48 1 #x-12958ac6446e2d8a91aff21c8fe6e7f45200395b5ff67939ac1a9c84 0 #x5667fe7a9c04dac522d3f2bf64a415057e5f6a08746b58612f6f2c5c0af) 39 (6 #x85dd5bc3a639c0a636a7d8 5 #x2e9296289f831ec5aef0c614631d8ec08 4 #x525786edbffb102fa40f660f8ba3a5a8af4970dbbc 3 #x8156ab5559b61ed751a22ef88d3916c949c5287fda42a45 2 #x55201b847839924e4d874222199fd53be84fbe9c446af5d02ad1 1 #x-70aef48c794d456422c76654c9ecdbf3c612fac6dd86daa3613d224 0 #x3cb55a6a4777a72ccf4446f7778807d64f6e2b58ade28dda427c043a888) 38 (6 #xe6770c8c1efe64952d91d4 5 #x3d1b16c620af44eb1ec521ec61007ce88 4 #x4bcb38f2a0915e8d73e3126e19129f83aac197c430 3 #x410929a26cd69753beb4dedc2258f9445bfa6e53dbe28a9 2 #x319f8475d8a5f17a93c38aed61c8ee95d6bea0aadc10260b0272 1 #x-1163355f7fcedcff5af45a0a161eed9eb3f357f360ab85325dab54b 0 #x2986b68f3609f99aeae4b0a2cd0b68d3f0202e3ac93d11a607506ed9ac8) 37 (6 #x1836f09ca461ad234f0137c 5 #x4b778647225c6bbdad5bee846da4c01cf 4 #x4315265991c5c529fe7ad7b59fb1b3b6ae6ca4ad3d 3 #x1ac4b41c01ea13def3e46943ef33d279dce606b6b9ad2cc 2 #x1c1ec1132d8cda1678d8b734d3e73db2cf6302fea8356b2d1a6b 1 #x17a19b4c6fc7a99b1259304c778106946406b454bdf9f204e30f60b 0 #x1ba3c8a2d661dbeea1b15dc0149f83d2e958ef7d4c3a3d90defdfc228c8) 36 (6 #x2869b82de2187665b2044a8 5 #x580d2315c5dad8bb428c7c3d9f8411b27 4 #x3909703569134a705c171fe96f7e180737f4b8d0ca 3 #x663aaa7254a23f318a70ac7532b265944f09899d3deefc 2 #xf7e863f10991df6d30bd596c4055e909edbcf66ae0aa3b56990 1 #x22ee8b74a875cce3104e409127298650cc6fd9f476924d7c8c0b8a5 0 #x11e401fb26d4498a74109412903c18171ff0627e037e49e9349fed2e532) 35 (6 #x3e5d78b3d15b91ec26db523 5 #x615068023ea8fb3ebd4890d9d609e774f 4 #x2e8a61172b8e8a120605baced5485a1aa665d58e9d 3 #x-2c909e1348adfc14989dbb1c736aa315d45301a0ba87a9 2 #x84c298ab98f0d9d027e4fc23c475e811c24485c9fe1bd82f547 1 #x203fcf5f11480e59a26004f70222795e2f1fbcce87b8617a6dca49b 0 #xb41098c232e22b21f2ed6c955c69fb0a822a8e799b7354a75e816910a0) 34 (6 #x521dc00f994c5d68549ca2e 5 #x65ff2873353c351a2ef324f1131f02a20 4 #x246767c0005c3b9c3a0f7ca2d93f86564347c9b9ce 3 #x-5ac44b73ea0cc03d0e55c23d4c182153ee910241e2c168 2 #x44fa98ee65fd0183465b60489340381af4238c9b68d6de25058 1 #x18ae547dc6d74d37436ea3ee2649aa1c3d2a8f4d6e79c1bab80eefc 0 #x6dff5fff13b0418f34e39a64a65049102d46785d1e5aa16795f5edd444) 33 (6 #x653e973bbc333d6bfc9c6e9 5 #x6541e6dd2c44c54020666b512404b939b 4 #x1b43286bd911f062b27f7053c0e59e9230f49391a1 3 #x-5873c91c7e9659787aef50dc6969cd2ca3a77f4cb37290 2 #x22a43bd93c00a8c0de87e2553f8fd6ec9187c8ad9a86e4bcbed 1 #x10d07a0eb0f4d1cfbe3efb80d2f73ef5ec3d6d122b00fe6d39e4c8f 0 #x41338a6997070430f9069bc8785862f22b709ef35424ce0cb7ec7e6988) 32 (6 #x9b6ab3116d66f3d41b3af8a 5 #x5ed19c70faf7944150e64df2d4f7d354c 4 #x13850e52ee8216f7891f272b43946030044effe16f 3 #x-4456fe11463db605c124eba8d6c0b62dd385bd469cf76b 2 #x10b3a9fcbbad93b2ffe1395a142736cdef04f10c5d98d4b0790 1 #xa7ca52de56a8053e7f114db434d7f2b5f1acbfb47b556a663bc8b4 0 #x2577da49deb0ae507a0c02fd6326516f39e5c856624ebb504404852901) 31 (7 14478 6 #x10b4cc780425c15bb2c1821c 5 #x533c334f5392d9d07dbc24236c6105f8c 4 #xd5782aeee2753a0aef82c0fc007c45c3d3b96cc0c 3 #x-2e1afce3369e9b24184a236f65ea567ec5f44d53398d4e 2 #x7a4d319d5a455138ecff7eebf1155c54e7e98526c4022393b5 1 #x610f5223db2620e29a8de695390fa8609067e51f9b8faf6cdea3c6 0 #x14da7db8042df685462edaed05124d3d197248f2415262afa751dd5d90) 30 (7 -2821305 6 #x155ae988892f91948000f923 5 #x441cd95745691be2e11d7df24f78d731d 4 #x8b0cb74bb1320280123222702249a424765f3d421 3 #x-1c19b7f2fdb324cdbe54ae6c679b2652d416cffe34eef4 2 #x3424a6da884bd3ccb155d27a9bf481e160646336e7d2b57e43 1 #x34651a366aab560cc50b6b80cc21cdedf10f99aafac549b9496ef2 0 #xb3aa4a8c8bdb216344b1c92b824f758dd62690f05d0db996c8c5debb0) 29 (7 170461432 6 #xeaf36b25e624342fa8b2dc5 5 #x33e471e82feb818660316376a37eaca99 4 #x5627b2e81e73c5ee8c570ac2824881966e179539a 3 #x-faeb02fb8096a6edf6ba47a3b47cd6040b05356342df3 2 #x14039126a21e74bbab5ffe319267621dca98b88417d0edd176 1 #x1a73fee652202f3c435b02d9b7e04de801b363696dbe32c1b86af8 0 #x5d7e2ff86ee402e8604d77f133118e3f3f55c9b17f6489cd9ed87bd40) 28 (7 893687570 6 #x329e7e0419872c314e73639 5 #x250c0a57795be211373479d1db755e127 4 #x32abe5b6897d36629714d66055a3aaf4decc1fe90 3 #x-809e31f48cfb9886bd354835c3fe4b8dbbeb8e69567d0 2 #x6673a68349417d57852cac862ead1ead3ecb6f91374a192fa 1 #xc7b9b4a97d42e7fc121c7571b173c98fc0b5b4e7f264b3a2e9724 0 #x2ef5063c614debaf96802fef30c56c215c8735e65cfaa4dd461ace860) 27 (7 #x-15879955d7 6 #x998e96b583ca727588d8c93 5 #x1922521ebc7abb91aa6196db785bd8ac2 4 #x1c3942ae4e8ced3eb5f15f1a946f84b66ce329d1d 3 #x-3c3a717ff6f580c188227b8b16f2ac66c2aeb6ed28051 2 #x1496f9e05617b6d4ab102cda7c02a566d4a23ac72d7916fe0 1 #x57c884a8d36db4cada82ce3379c71b2240e756204138cbceb0160 0 #x16bb883aac3217f0362b85f61026a79e22858efe9fadefc2ecd8fd100) 26 (7 #xc1a3fe423 6 #x264743c7ba1a105647a06005 5 #x1068d72a89b35435e89775df9f0da8846 4 #xed97b00a5b1b5f541d3376dc4effd2f53c123506 3 #x-1955b14ad459db37a559b33cc8d6ca51011e1776bde31 2 #x-41de5ccb1ea615fd3a23f169aba0bbebf2fe009f8706df1c 1 #x23ae2b3f6a79d7de288900158cb63307818fcc50b128331bd3e40 0 #xa979fd19fcf55776b983076c5eaffaf47269d1f8cbfce218f95c8300) 25 (7 #x6dec2376086 6 #x375faeefc318a43696f8bee9 5 #xa3f42800eed9f37282bcfec5c84bdaa2 4 #x75bdfcae99d840ff1da5c6676fe41079acd68888 3 #x-9310da4c5fa6cd22756ca33110fafce7a04829630ad7 2 #x-7e2f6871cc77373349d8a79cba9518d872f4a597484677d8 1 #xd3bf4cf879976d35effc18021a6fa3fe8e67ab719efb9672e140 0 #x4be3326e80138f095920a10801c77fca796a0243966f96661d7f7400) 24 (7 #xe093d6a498 6 #x1fe272d45f4183f48fd6ad1a 5 #x5e3e1834a8d2d76372b535424fb45c1e 4 #x36c7da1657f5079f4d1c9cf3cf8861673b620b9e 3 #x-28f04a9cb8a5f475badf19160d35e686c14300f8d254 2 #x-5d09b60cf839b76628d396b7c67f5c7526ebcd36187685ec 1 #x45cf4c418b9b30cecb1725c964d16a6da6546e96aa19c810b1e0 0 #x2099bfdb858178e5fccceb7a044e1667a7c071f193b9fe2b9504a100) 23 (7 #x-b15c7d9b847c 6 #x-8e038679c337dbba9c2ce41 5 #x2e3445fc1bb73d86d8b0c7420a553a48 4 #x17d76567aeaacefab2684f6bd75c06f859f2abde 3 #x-436738ccc54f3fe76db94a782639be5b2b7cd3e61b6 2 #x-33fecbd3642e6d7f608ee8096133a568dc139d799eaaadb0 1 #x133c10d498418cffa5aa579ac8363637354f8faefdfbc6b06100 0 #xd698325d21edafe6f5d0112401cfcbc6db90f46254c5d8f1219e000) 22 (7 #x-9f5fecea192b 6 #x-14788fd543d14d72ee1d8bac 5 #x10876ab680db658646844c90ef2ec3a0 4 #x9aa6cf26c622cce508d2b272fb3dcc367c36946 3 #x4c944ccec3418e74aa23acb3331ce3e62081bf24b3e 2 #x-18685d0f82ba8820673435ea59a898299df11091bcf4fd10 1 #x393a5248961f7223e74fc6a8c54d2c266e5ee633381783bcf00 0 #x546331b0782357954954525d4f555f9f7dc2e40d008c93884f2c000) 21 (7 #x72ae602cb3645 6 #x296e804201ab7b468904cbf 5 #x1d8b2b7c6ec21d7f947240c56e5ed46 4 #x3a203f4b2d6e21eedd1db45a74091c60edf29b4 3 #x4c0959de31f5270ea1dfcdd0751f63698484daf5dd8 2 #x-9dfb3a1db5e962e473aeb15c164b8ec9fc4b0005ae269c0 1 #x-3cc8ce15e651ec11668249ddee95284383b23c2e3ca9a11000 0 #x1fa77999ce5528a80ed3f97ea92e904892c4a57dcf19b0a10d90000) 20 (7 #xa9119ffbe0494 6 #x1870c827706e1f1d55040e43 5 #x-2d9a1a04fb23688cced5b337af7c173 4 #x1423ce97e8ee84f7caf42f78f5d3e77fc13454e 3 #x2e7864fbe8934126054e72cefaf5c4728278634ae4c 2 #x-36c294e273f5d3f6a1940ca79487c6f2cf41a95bb6e9820 1 #x-ad151111044b0a782c4f10106dec7219b89c900b6823363600 0 #xb4d13add933360e6a0000cb47530ae5804dbd8f716fc9f2fc40000) 19 (7 #x-1fe8d5b1144124 6 #x15d26964fa9985b73e3ab209 5 #x-2c74c7951d31577e4f4a7d28c05f5b9 4 #x663b93f482af765013d7d481a1d27205e3f570 3 #x1699c224503877aae43c1f5d2176e9e50a2b0bb18a0 2 #x-f9d8fc8cd2890b318ffa1c12f284a7184bd81041bd7d00 1 #x-7066186fa69a374834de9b26903a92972c01b688496d282000 0 #x3d4bba2f48ec281c6fab2dca3fc49f38515cda5b1f04b372700000) 18 (7 #x-415eb0edf76c7c 6 #x6512b210e6e8d1b6239d2c1 5 #x-184736f2c8c6f0f0d359a81286e9dcc 4 #x1d71bb09ff1505ce2cb777021b104a9add37bc 3 #x93efe111f60ebf45d3479e3166a9d10cfb12cb0000 2 #x-32ca684e61ea2d80719f4edc05375102febe2ded253300 1 #x-362dd48e5a1534efb53097255d396c434925ccb074f1088000 0 #x13add9482e83fcf13b86b2ffa558f674ef4bcc8dc64fc24dd00000) 17 (7 #x3799c3935f9548 6 #x-2f057c4363cbdbe75355697 5 #x-93afba146d44cf3ec3e669f1a9fa4f 4 #x79bfafa96e716d9eaad9ae52d211a49ae0798 3 #x3345907fa3e6bcdbe2c256825714a664eebb19f440 2 #x-1ad74b84ffc0cd0dd687ffda952e9f097b6200ff2bc00 1 #x-1635f9f3565d68d3e3e86de4687a06c4e36729805c17bc0000 0 #x5f783b7148f8b0d21a2fa3e92eccb3171e2b8542b3eeec1000000) 16 (7 #xb5cf91d0d442c4 6 #x-2babb2be6b8a5a6df02beaa 5 #x-27dc3ba4fd15970cdb090b1d209308 4 #x1bc12908b6ab260d12fd2c6ed7dbf7237b836 3 #xeb648a07aa05ee52d879bc0855a4d77eb89471d60 2 #x4e594cbd12b10fd4d13d24d1fe77b2f0759231601ef00 1 #x-817f546580ef3d1ccbcd28280cc25bbdef432fca3671b0000 0 #x1b4120176eae645c6e9594db75d7a7cb5d71905e392c108000000) 15 (7 #x-3f1a0aeae1f56 6 #x-6185d9bf42c98860fcd6b 5 #x-79d29e166495da646a101f7e0a836 4 #x56f4f34de0d17f50d30e9d6a6d55c37d6530 3 #x33e82983a603bf29db75ac863a15c4ce66fefae00 2 #x327569bc2532d303996478e714dd9b07d708b97004000 1 #x-2abb61a442f094546768b34f87b76827240b9178ffbd80000 0 #x74cf9a55dac84f393d0cc919e9716fd6f0af1a1e633fe0000000) 14 (7 #x-f2fcd451466872 6 #xe539ab5694b8c99545159f 5 #x-18168df04a9e3d8bc5fd7e24aed62 4 #xdfe9995b03e10a9dc9607f4cce1cd479190 3 #x681384cf3780afb0f88911d0e66a84b8311db200 2 #x15a3cf42d457eed761f14be3e0201f259bb9ffcd00000 1 #x-ce014d33ef74ec81154116ad26ea4c8a5206ad97d6c00000 0 #x1d3fea360660ce3fb5b0cca161262aa972ded92942ae80000000) 13 (7 #x-5b123a1cf24fd4 6 #x7d7b40a669f06344b30afe 5 #x-ba306699a7f78a501c2814bee518 4 #x1b36ee30b7adb911292b659bd1319d279c0 3 #x-ebc7ceff302d11335d73f4096552c5b2ea8e000 2 #x786f336e565eccdb3ccddd5e69a713db838aab3a0000 1 #x-38d94de2061ea9380fae86eb98c465f537abd3dd41800000 0 #x6d13c3a6b51eb07ba4869ec3a05c195b5c3281b4cf600000000) 12 (7 #x9c77dc8b87d8a2 6 #x134b55286b52a8f43c12be 5 #x-63244ece928759c7eab8ce7baee4 4 #x1e8a40f78f084f7b820374089ab8756220 3 #x-e1d7caab986475ec4ba858f033b96958756b400 2 #x23fdc8d8ee272df34d9ca0ba00e44ba050f3dcaa0000 1 #x-e5dbe0f0edbff65ba67f5874ef312f7c995197532200000 0 #x178c7a358385c9b69a4932bbcec1f2a4670e10a7d1300000000) 11 (7 #x60ba39bc61a093 6 #x-806321f222ab7bb5d2a90 5 #x-21e77c7051643c917edcd82c26e0 4 #x-21f5a6e08b3277f7667714ee8fab55500 3 #x-51580b04bee7962c2c4608a1cc8c6145049c000 2 #x97845c6371c0b50c080e4570bcb8c2ced914ac80000 1 #x-35100a00a73b69d544bea30b9a2348a1f1f79fcd2000000 0 #x4aec6c6a7e79b719ac2ce0e5039ee137f86ffb2a4000000000) 10 (7 #x-2e51e22c091abb 6 #x-40f06026fc0a0ffbc4ac4 5 #x-6cf8ca338904ece1a306c8c0940 4 #x-19ea0d3c8de0ba695880bf0b801f84700 3 #x-13aab11aad691ef33c3994f26a19167f0148000 2 #x2387d195d9423ad20371ab3dd081b90aae24f000000 1 #x-b23eed19e7fb7ca9eac7540630ae9fc26e397bf8000000 0 #xda1f6e99cdc59b715d91b4cb3236e3f95356f6ac000000000) 9 (7 #x-277cc2e1fe81b9 6 #x-42554ba256d653f5cc48 5 #x-b55888d3e6b5d9a5a1b858fc40 4 #x-8788de59e5575de921fcc5efc3d5a400 3 #x-34b58b7791639be70bedf144e3b10fb0640000 2 #x7785532a5bc0b3848d8d8f918e6368fd5a82800000 1 #x-21d14745958e357629e4b329ef3405df14657e10000000 0 #x2408109f00deb1edc44541ed9f860aa81cb90f90000000000) 8 (7 #x5cda9a4146400 6 #x45f9ee45ce2245f1ecb4 5 #x-6092a5fc2746cda1de7b37260 4 #x-1a0061a99913e9bee23b0d40a794d100 3 #x-4fb35358cb4936812ee15351482b63ee40000 2 #x168e43053b0ab9c1641a29494e83352d6f2fa00000 1 #x-5bfa38ee2f5e6d1259a65edfc472973fc783740000000 0 #x55a2d893edf217317ab075df6dd390324500e40000000000) 7 (7 #x72a1caf928b46 6 #x155939a1135e37a48cf0 5 #x4ece0dc9560d799df6298c900 4 #x1cea42924e4e00e22232b61447e000 3 #x323cd947187e8f50d8a72cc4571d82580000 2 #x3ce2964380d3803453b8ba376a839b9d414000000 1 #x-dda3be097361c7a047ea200f9f233a9a38de00000000 0 #xb4dde26af1e7da6ab27388d4f251279850bf00000000000) 6 (7 #x-5b5f76e1ec6e 6 #x-18fbee69269704d1c30 5 #x3c3ba3a5afeac63eb01b8a700 4 #x174570c670c1bcbf637a544a91f4000 3 #x2a77bce5b8383826af05cff24eaccf600000 2 #x915b0b8a808a1cd8a90d8bd63908b8b194000000 1 #x-1d243b858d3bc1d4edb1e45d1eea32546a8600000000 0 #x14e5e9cfdf2dd89163faed7f309a7db4156f00000000000) 5 (7 #x-9346c3f6a9b8 6 #x-e1fcbe133a779a7140 5 #xca6883e761baa31c13657000 4 #x4d71995e554733c811e74860a50000 3 #x7b94cc83bf4aaf9e87d60f6b99651800000 2 #x12d1a0f597122b37782723de1ecb8eec90000000 1 #x-3478c4fb1c362e0821bd3f9de39c9327b8000000000 0 #x21269db4edba4bbdc142bccf0616faff0d000000000000) 4 (7 #x77cd36ac374 6 #x7d807e18e91a6cf3a0 5 #x-19d9f6279755e86bc4943600 4 #x-bba2cf766aa4ed23f22322ae0000 3 #xb0f84c7c9a162f2af01e86213580200000 2 #x20d559543d96bfa5fcdee529c50159bd0000000 1 #x-4ead296868235b0bde4ab9e04a989bb60000000000 0 #x2be7740adff74fefdb798e73a0f28be00000000000000) 3 (7 #x46a8c8041e0 6 #x-38f9a454306bc4d700 5 #x-afffb541d6e626ae0042000 4 #x-2769f384fe02d9d420dc6d1780000 3 #x1d024bf9ad7f217431d24d8d8e2000000 2 #x2e2729a84dbc538dc7d48e4c5bf45a80000000 1 #x-5e5d70f0a687506ba8e7027dd95ffcd0000000000 0 #x2ea44fcce1e0ffd457c1e232565f9500000000000000) 2 (7 #x-5aee55be00 6 #xbb15159752cec4f00 5 #xa1c1011ced8d7888db0000 4 #x-42be1985282afe7faea7eeb00000 3 #x-17681cb3caecdf2be1351cc6a08000000 2 #x30cafe2d35830c96035a735f1275200000000 1 #x-54ecaee530f6dda093185e605302c40000000000 0 #x254bee2042ee97563ac453543a80000000000000000) 1 (7 #x-56370c540 6 #x-11ae175d3407e9400 5 #x43576bd3c6be72a5880000 4 #x4c0386b3ce926f75f8fe6800000 3 #x-29399ec37ac060c451beef8b40000000 2 #x2259ecbc5220df37fa9ce9010c2c00000000 1 #x-33000a4d98d1c59615cbea88a5b400000000000 0 #x13f92469ed413452871aeee13d0000000000000000) 0 (8 1 7 #x68E2CD20 6 #xa9f887fc0866100 5 #x-64b93641bbcf379d10000 4 #xf1887c7b9dec8574625e600000 3 #x-196b0d530d11bbead768d1530000000 2 #xc0bc91667b69588c3cd9e0f5f100000000 1 #x-f55d40b4a1fe0408aac13de08000000000000 0 #x560b709712a9719f2ee1a9100000000000000000)) 
  (svref *ec-g1* 131) 
    '(132 1 131 (2 -1 1 1488 0 -159900) 130 (2 131 1 42792591 0 #x1fc6f8186) 129 (2 -8384 1 #x82127fd95 0 #x-8a7056a1cd38) 128 (2 349639 1 #x34eed6414d5 0 #x4b6a7c87e6e975) 127 (2 -10693006 1 #x1b7aa19f16c5 0 #x-1023bee5f03d3de0) 126 (2 255929067 1 #x-635990c865ac9 0 #x1c7b743dfa72d0476) 125 (2 #x-129cb8d32 1 #x2c4dea8e16fb42 0 #x-1ee4c89b975454cc7c) 124 (2 #x131012d417 1 #x1d5bca4a214d9fd 0 #x19854603b4125cfe3c2) 123 (2 #x-10bdf2a38a4 1 #x-2dd21af124e71bb2 0 #x-111c19f83cebbe9c7a34) 122 (2 #xcd1542b74d7 1 #x1b4b4cf4ade14d94b 0 #x9b902f64db348e6e782a) 121 (2 #x-8ab080e457df 1 #x-8da5dfed21054cad8 0 #x-4ce1460e4abcbedf14d98) 120 (2 #x53bffe781d904 1 #x9bbe6371f906c16c8 0 #x21a3ba33fb7d21112f83b7) 119 (2 #x-2d931c61f50c86 1 #x1255a08817b792ffec4 0 #x-d32ff0f5ad1906d9647a30) 118 (2 #x168658da18337ae 1 #x-d6bb65a149df707ede4 0 #x4b082136ea216f647b9e742) 117 (2 #x-a2e1cf5d3c48336 1 #x5f9fc7983633e5709adf 0 #x-18533a3fb143dca4092d61ac) 116 (2 #x43b86fd472a41a70 1 #x-209471221b99b9c1d496c 0 #x73e1eb4e50a03bade39f0cdc) 115 (2 #x-1a0a0500894c936c0 1 #x904576d20122f662ba83f 0 #x-1fde2447f385f4acc77521af4) 114 (2 #x94dbd527125b32fdc 1 #x-20a828082569e5ff410093 0 #x822ee6c82e9cea4ee57f892c6) 113 (2 #x-31a22d573060c88d2d 1 #x5c0d949d686bee8b58d745 0 #x-1f035b840453544a04a24f4698) 112 (2 #xf80cf3e941bbc5aab3 1 #x-9c23015eaef774553c38fc 0 #x6ed52ca469467db3c54384c6a9) 111 (2 #x-48d5f2c7b252fc777d1 1 #x-ee10304f198a2eb68a8d93 0 #x-17524e486d253c7e0a9ce499600) 110 (2 #x142b3f1223dda2eb300a 1 #xe89883cb91f380cc46b775f 0 #x4a5129d9af45d6273f3c7dd5ace) 109 (2 #x-548383aff495f7f80e4c 1 #x-546df9814681a4a1fcbb19e6 0 #x-e12cdf720d02d67dcd53da22ffc) 108 (2 #x14fd08294ef94e722887c 1 #x1746299a600a5991a4ceeb6d6 0 #x28b8885e753433292210ba9f29ca) 107 (2 #x-4f45c28f7845a10dc7f7e 1 #x-57bc02834e271f1e93232f9a2 0 #x-70f88c9d596929d5f7b5c2b00224) 106 (2 #x11d3a315926f218c121772 1 #x1273da2e76ed3db5345b7849a7 0 #x12d99e349187ee17bfb05884d2faa) 105 (2 #x-3d3a00b3ebf39ae2d4e038 1 #x-389dbaf1e4a23c05bfa1c10758 0 #x-30954443a3e930b9b0a6b578555b8) 104 (2 #xc91997ce375385dd5a0ddc 1 #xa03a1f283c0520acd01937dafd 0 #x79367b7c0a8229407a4c412fc175f) 103 (2 #x-278bd85600cecfe7704813d 1 #x-1a4f878b526f6d6418ccc099e58 0 #x-1256c170a4b2ca3900d71be408c1b0) 102 (2 #x7761e331e08d3233c6a319d 1 #x405e28b25fe7e984d896d8a36db 0 #x2b272ed934235cc5add0ea9959ca72) 101 (2 #x-15a46ca6a75a6ff3463ef2f6 1 #x-929e9dcf4baa1f84ce255ce57c7 0 #x-62db92dfdd77fcc38cbc36f29b607c) 100 (2 #x3c658fbe308796e3f46afe93 1 #x135ccb40d8108acafbfb1cd64f14 0 #xdcc28a32b30a41fca0ee606f944cb8) 99 (2 #x-a25cf6393c24efb3ecb7c4ae 1 #x-25981c5cfbc3bc905ea0b15356ef 0 #x-1e11033c4c520dbbbef165f964c2c44) 98 (2 #x1a4f135a7842de563a1a914c5 1 #x41b2ce12bc13e2b3cd3d2fc77410 0 #x3ffe199284df4ecc18e1706423849e6) 97 (2 #x-41d9cb12ccf3094ef45740f7b 1 #x-62562275bf2d02c86f96aded3907 0 #x-85219098659e168fce6ffe174c79d98) 96 (2 #x9f48bcdf9fbee44916cbe112c 1 #x6b5b950295000f8fe4dc282865a7 0 #x10ee821b727978c4268a57742b2d5129) 95 (2 #x-174aecbb4f208611f2c40fd29d 1 #x-69fa588bc2ebefae70bc9c405db 0 #x-21b7ffd7b5f63ace6f6025159a7c8760) 94 (2 #x34c2ef48f027015f08d01bbc07 1 #x-1a3b62e267661093bfb73c82e222d 0 #x41befe81a780fe8e5d74e09a2ccf5f1e) 93 (2 #x-73cc02d1d3d03564c48dc3b702 1 #x67446a2cffdc442e0230901492776 0 #x-7d8f07e38bdba8fac3a730dec493288c) 92 (2 #xf66da7a2c2120541cb2aebe907 1 #x-1241f1f5edbb5e971677e670ec12f5 0 #xeaeaaa51f1252db509817719008658ca) 91 (2 #x-1fcdf78afe72bc5c2a470561941 1 #x2c61d48e6272e8745fbb8610176d86 0 #x-1aeaba9f5b078fd398e48f6c014106964) 90 (2 #x3fc587a02b1accc9aa9dafe3036 1 #x-6208c46004abdc535f942d56085d1a 0 #x305b7e8fb8e1ff87b60d0001640a238c2) 89 (2 #x-7c3d8d917ad09191019653d9241 1 #xc9c91113849372221781a24b247566 0 #x-55232791e724d3ca44e031c5bc5f1ba78) 88 (2 #xeb522b1d184bae41fa5dbeed75b 1 #x-18865e2e0985de55210b825eef810af 0 #x92e2fd805b9a56650442691b8fb7d5993) 87 (2 #x-1b19517c974a19acd6022c5cf1b0 1 #x2d718d874f561b4f68651daf997346e 0 #x-f851aaacbfe6cb09f36321c253b285850) 86 (2 #x30990316e603bca40066cd9ea51f 1 #x-50b322e417d68c7324a8037b82b5de2 0 #x19b4716636eff0451bd975035c673b1aaa) 85 (2 #x-54df1c98744a35f64789bb8b9df6 1 #x89eafb9a7d5ddb5b845d10e571cc6d9 0 #x-29b354dad5527f165838482b8845853abc) 84 (2 #x906a0a7a36f6e0ed46affc37adf5 1 #x-e39097322c8da34700f0f11690c3613 0 #x423e3f8c70181ec9dc8ad126705f41b2aa) 83 (2 #x-ef89202aca3955375506a33ef4a9 1 #x16b71013b25d02b2e0325a9a42ebfded 0 #x-6700fe851d43f45c5f0bb4e347d4afa20c) 82 (2 #x18379e90a4150393ac407450ef190 1 #x-233065a4357a876b54ffcdf33a11672e 0 #x9cb4b327f6e5a4b4391218ecea8be30cc2) 81 (2 #x-2638beb028ce3c1f4326d09eef788 1 #x34f8e47a7952911630c403eea9994733 0 #x-e922c0de86bb437a4b0f3adbe86f53d868) 80 (2 #x3ae219327c575f907ad099ba5fcdc 1 #x-4d9c46b6ed3b67711740a1cf421de494 0 #x152f93357a8e1193168fae56b7c91690603) 79 (2 #x-58954fea8e3e4215ed1d8a502fa0a 1 #x6ed2955f4dbc23e7b9ead578b1472cd3 0 #x-1e15b3cd0df312fa241de0a2749ee5692e0) 78 (2 #x822fa74d8f987a643d98e86096644 1 #x-9a6c4d391e0776153bb2e3343f59d43c 0 #x29b1b4e05c0dbf8ebeb589afb2800a1922a) 77 (2 #x-bafb4f362fb2f4b4f8ba9ee533db4 1 #xd235b12a87897031a688dc9cf1243154 0 #x-38596608323fb675468b68b0376d5d7dcf4) 76 (2 #x1068d7877465160643cbdaab5a9162 1 #x-117d15c300fda0d5c349b4cb9e470481b 0 #x4a33ac8a59f7b7ef7cd4a76b2e5595f5bca) 75 (2 #x-1688e3d034775a3e7f7f0f184fd9ed 1 #x16c8ac61d6a7d392d7d5fb83085f38a74 0 #x-5f1df8e23d4bc24f8766f8399a5deccfd7c) 74 (2 #x1e469c4f9a68885fb54ce6c60292b9 1 #x-1d1221eb73ee6b578cd2a3f9e9e4d15bd 0 #x7692fefa23fc3367d8a1dd439bab35dde86) 73 (2 #x-27ced654cf61b1666cb51d6399da75 1 #x24593bf940f9146467e8c2c8b14226862 0 #x-8f989d20d4940eec815dfac80a8cac04728) 72 (2 #x333d75c681496cf074315651ac48fc 1 #x-2c8dea7c57fc1dc2497155a1a80f606dc 0 #xa8bbb3f5e632df8762dc61a7c566a6441b9) 71 (2 #x-40963bcb9a61efb80202b27aa85972 1 #x358cf1a82439f4bfadd1046e02694ba46 0 #x-c02006008909d057e26432d545b947a8110) 70 (2 #x4fbe44b59d80fd49e4e48f3b7f00e2 1 #x-3f1d4863708546f6690be67180639465e 0 #xd3a79b14db3fbb94fb010c12c7837c2d12e) 69 (2 #x-60772d8a35bcb6737264a4b5538c30 1 #x48eebf3ba5b229b011271e5aa89289d93 0 #x-e130a5d4096fe9fc02abd25409d791b2344) 68 (2 #x725cd3f577d609f9b1484a92e1a07e 1 #x-529a9b71ff1083a5aef0bc146f0c8f5a6 0 #xe6e338cabc9f48f4a172eb3ca42276b09f8) 67 (2 #x-84e6769eab4e4a258c44d7d6e571a2 1 #x5ba6d0343614a7746af0edca55d0f50d3 0 #x-e3828641e57337e9386b874efd33523f6fc) 66 (2 #x976ba88bf97cc89e0365e967599272 1 #x-638c55e914013410283f89efe9b27d187 0 #xd6b1a16f59d88afc308919a6620c96e89fa) 65 (2 #x-a92d187a2bd4ddd5aeefa37d730423 1 #x69c0c29cb513683841e4780cdd3022991 0 #x-c11b53e958ba01707744d080a5fd42c5168) 64 (3 131 2 #xb960ab81e42972abcad8cf5280477b 1 #x-6dc2b8c9d6a49959e9ec4f8b68b926fe2 0 #xa4707868c303ee744242b81806b118c2b2f) 63 (3 -8253 2 #x-c73fec6a7d512d753df408c09145c9 1 #x6f28152308c562c0cc3a431357d0b15c9 0 #x-833823a8f6015bb6c9f1301d0cf427f7cc0) 62 (3 247852 2 #xd2176b60e11d1ac72708e7ed9217c4 1 #x-6dac1b627ef2c232d06a90576cef4130d 0 #x60771d501f4a7dd3753f27227c743ad01f2) 61 (3 -4645391 2 #x-d9556ec1028a8f21cdc04e1aa9bda0 1 #x693b6b49a0ea89f5ca72eb8097e3867ec 0 #x-3f3e2a55752075c442fd74329edd69f6ef4) 60 (3 59621375 2 #xdc965186c6a83a86733738537536e5 1 #x-61fb6f2ad78788465018aea57f9e70ad0 0 #x22358bf5d633b79cdb3c568da91b801ff4a) 59 (3 #x-1FF16337 2 #x-dbad226f2164fb2591c8c5523a4130 1 #x584b5ae85351a4cbbc049a9d747103cf8 0 #x-b3d9bf66714c65104141e6a2edbf9469ac) 58 (3 #xbe4bdb5c 2 #xd6a781b9384882b0af17733f38b5f0 1 #x-4cbdb74e1100bca696e0f95cc7c22be89 0 #x-4c82cb8d8c1170cba8dd620b4bffc35f4a) 57 (3 #x-201b947a7 2 #x-cdcc4bc8515444b062088c95037ca4 1 #x400ab8ff10edbef75faaedb651e06090a 0 #xdfe213d47a0b4c4c859aceb6effa992ab8) 56 (3 #x-c07bb6aa9 2 #xc1953f3552e122284f0122f2b546e5 1 #x-32fd02f5fb86885506d958166383e1687 0 #x-115fa4f4e65197274d56f923ef267517647) 55 (3 #xbed298c259 2 #x-b2a4652221d3fbfd17b245086fd901 1 #x265ba0798467c478ae80160e612859eca 0 #x10742bf91d2a72cbb91a82057002e1d05f0) 54 (3 #x-51e0b4b5c61 2 #xa1b67c7a897e6e42e2f8a4b3d24157 1 #x-1ad4ab8fde824dc07a80b97f17ab2ac09 0 #x-cf43759523420e024a763e2314cf29a452) 53 (3 #x163826176c15 2 #x-8f93f36437c52df83972a67c171442 1 #x10ec098aeb188005c2fdb6a15e1bb9da1 0 #x875948f2ec0cfa955d0701a14bbf925fec) 52 (3 #x-38630e8d6e89 2 #x7d020cd67e19e43b3d255931a44bb8 1 #x-8f0e2013d19af5e4e5260ee8099b39ce 0 #x-42f8b059c3d64326037e6941098c6cb2e4) 51 (3 #x1a1639d38a 2 #x-6ab5abe0c3c34001e003cbb4f2974c 1 #x2fb20ed37d9227c5ca1c7233372a0929 0 #xdf469563fd71f6962671d2051f065d3f4) 50 (3 #x2f45ec16cde83 2 #x5948ebe0d2c4793650808102cc3f8b 1 #x10f3bfad04bb1af650f4e75cd375aeba 0 #x13473b2a6507e2e6df6bb36d3df075326a) 49 (3 #x-f7d386f7000ea 2 #x-49343c8cfd573b1d35541af42966a1 1 #x-36eba167f12b2dfe0a7a61d9f33f6b23 0 #x-2209ac2312834c1d18f0e610301af226a8) 48 (3 #x2de7567d4e826c 2 #x3acb3d335d99d8f74f0d42e6470fd6 1 #x47b7cc7e617daee1c67552f512b8c05f 0 #x2304bfd117dbdbc669b062344dcaf17707) 47 (3 #x-4ad5fa07d73d8f 2 #x-2e3d1e92f7bd92d6262d7f56c024f9 1 #x-495d9eb4b9de23a487494386982ee25f 0 #x-1c005868491187aa46673a516ac4a16b60) 46 (3 #x-16248f1004e9eb 2 #x2397f58f9ba2db6ee4e3e6d574b44b 1 #x41902700f95a8c8224d85f25847b889f 0 #x12205cbe9fe3e1becda5c14d6c46cb4b72) 45 (3 #x22531b026b5e2f1 2 #x-1ace2c8d1a8549f0bd7d12e9fe65c6 1 #x-351825e09f579318a28570d6570f5018 0 #x-8f611b6bf4d87d2f26d70ad3945f14f84) 44 (3 #x-71f39901f20c77d 2 #x13bd28f0892596915fb5f013e68f9a 1 #x2784ab5ea5b495e62828582b1e0d2ef7 0 #x24f881b4018ef7afaaf5cbb267c6260c2) 43 (3 #xd5712c829f5db64 2 #x-e34438fada27bb872fb565b582ac1 1 #x-1b1f66a19bf3ad92a46cffd810e832c8 0 #x1757cb294f3a69c2e5053769054b91154) 42 (3 #x-b7ff84157e7133b 2 #x9fb567f0b5ba3e91739077d211440 1 #x11142ddabe038bf2eea3649aa1be3cc4 0 #x-2ddf45c6362a127b60309123537391b82) 41 (3 #x-fd625faa040c62f 2 #x-6d856cc09bdef94635ac7e615e20b 1 #x-9b5f458ae78ba1b9f0ba22cae935b8c 0 #x2c6bdff8362b101b89d76138307f43978) 40 (3 #x50bf1c71aa89d65c 2 #x493aac13c7cd1b1613a2bc03ad9a4 1 #x4cc11b77946634ad06e8cae469e499d 0 #x-200fe44dd8c87888f33f0837ae34143cb) 39 (3 #x-a158acdb31741e3b 2 #x-2fb24122c0a5ee52a3620013a5462 1 #x-1d7b39a00611e26eadfba7a4d597674 0 #x120071431dd1bb98e737616ed91d31b10) 38 (3 #xb5cac718d55a75e6 2 #x1e3b1f3eeb25bc80566abd17cbd05 1 #x48371e9cb51fa1ba36e86da75441c0 0 #x-7064b044741d340d45e95bbbf519a66a) 37 (3 #x-2aa314d77643ffce 2 #x-129fe01426887510c74e8baa8805a 1 #x64396b73a0d495356970b06f5675f1 0 #x74d9211538f1c62251dc2ff6be3a2ac) 36 (3 #x-11ccd5e545e44bb38 2 #xb237142136d5f9641bdf745b7081 1 #x-9185a73de1d65e189bed23e8ef0483 0 #x25e22da78743c55d6459d7676b8a8ea1) 35 (3 #x297e0ee6761bd746e 2 #x-67509d6affc31934996acfed00d8 1 #x832d394de8dd5b28005767780e423d 0 #x-2d24c4609b870987de21967d2d951388) 34 (3 #x-32ea066a5bcf26237 2 #x39f69a74147b19e26527d4602297 1 #x-611a6d8f2d758c93474adda6fd2eaf 0 #x22ed7738b766702934602d5f052da658) 33 (3 #x1f678eec535bc79a2 2 #x-1f69d779c63dd521ab7973958ebc 1 #x3f4863e592a186810dde3d95408936 0 #x-14db6b82382ca7c69056b9920f983260) 32 (3 #xe300376efbadb60b 2 #x106947452b32d6f9eaf0fad39fec 1 #x-25431dd0bdba2255bae34962c95a27 0 #x988adfd14363dbc4306b6acff1ef710) 31 (3 #x-3e1e74cf6378e0c93 2 #x-83eb7812bf8edba71c3e834d202 1 #x1404d49d304997a7c930eb4f752126 0 #x-2ab2605b99bcca87fc2dc9c5b730980) 30 (3 #x52773c996363bed43 2 #x3f8f286e7b7b5227cd97e985e0d 1 #x-9d28af1d13de4c3b51cdf12d965dd 0 #x-7c480c927914146eaf14e181c44ec0) 29 (3 #x-3db7fdadacfde1e79 2 #x-1d45cb787e3bcca5b7751a5cdfa 1 #x45f57e9ec35527886101423e050e0 0 #x15ea942e2fa68cbad96e6b0ae66c300) 28 (3 #xd9c9245264a1cf75 2 #xcd680a2ff09e528638b72c6dbc 1 #x-1bc5402cb791bef1223599b4a8338 0 #x-13728e41dc06f3210b07389258c8900) 27 (3 #x1fcac42d02de2eaec 2 #x-556292758fb06ef6cdefcadb25 1 #x972eaaff733c6c0a0357c2e1f8d4 0 #xc6a985d73ed1b0c03e28e751ae2000) 26 (3 #x-32cd1fa04b19c2e0f 2 #x2173173340646de5b80d9c79cc 1 #x-277ba0526f96572c4e425c687a88 0 #x-64329d67abb7723d56af08328cfc00) 25 (3 #x28d775b007c003752 2 #x-c42352e86f090418817d54a18 1 #x43256f0415ad44862fd1beb3bd0 0 #x2690a2c34ca4ba6b3beae23f569000) 24 (3 #x-10eae3022781a76e4 2 #x429507e47853dae4640fbb8a6 1 #x371b4c12e080c259f53ecbb049e 0 #x-85068e30249bf558531bf809aa000) 23 (3 #x-35232fd6da90eddb 2 #x-14a4155ee4f06da2f0db50d6a 1 #x-3336eeb11d09ef0b0024c8dda20 0 #x-2d625c0396b1b355e0f9e5c6f8000) 22 (3 #xb8033aa530ad62d5 2 #x5b6b569d41b0d0db1766454a 1 #x1c1f566104fea2cff3bcff02600 0 #x4f0ffd275e93fcd5ae65b75374000) 21 (3 #x-9c220ca499e8297b 2 #x-15ae7004aa57ae0301da0392 1 #x-c07aaf4975547c54aaa68ddf80 0 #x-3e662472ef9ed70905168c9f90000) 20 (3 #x48da1541df3546c3 2 #x3fd9d36077d12a96e57b7d1 1 #x4320b3369ee415eb8ccc764480 0 #x261d8ae2ce53db6df7a642f1b0000) 19 (3 #x-9e4d45cfb6426be 2 #x-5de98ab7bcfc6bde8d3644 1 #x-127b634a5bac7e8aba4f6f1900 0 #x-13f7fadcf36940391edd288c80000) 18 (3 #x-dbf237c471108ad 2 #x-19de1d4ae181589874dbf4 1 #x35465f64b1a4eeaf5def59080 0 #x9531eeba1c9b3990cd109ef00000) 17 (3 #xce0dd2e773d41bb 2 #x1133fc03eda5d67a5d5834 1 #x218fb99c4e70378ce35da200 0 #x-3f3fb9b7fcbce1d2f68e81400000) 16 (3 #x-5cd1a113207f8ab 2 #x-5906ecee98703ae46ea8d 1 #x-719ad2329c86e35458faf800 0 #x1894e5bad1354c8f010bd1100000) 15 (3 #x129310d69303582 2 #x13885f3d4d9b07304355c 1 #x3d4331943340ac5c7320a000 0 #x-8ce172cae0b2029915d4d800000) 14 (3 #x4fea5887493d52 2 #x-2a22db3822ff2abc04be 1 #x-16c38eb1535507ad53a67000 0 #x2ea12fc2b707b2076ced2c00000) 13 (3 #x-56a6048617df5b 2 #x-16610f0d4e18d6c5bc 1 #x69d50f3c578efe485b8c000 0 #x-e457b3bee086b262a097000000) 12 (3 #x200ffe9c08c3d1 2 #x1cdc8d6a9010c3fc481 1 #x-184b3009d9b638160a74000 0 #x4091f1856043761cca65000000) 11 (3 #x-4c5aa5047fd1d 2 #x-87161b08b3d4c9e158 1 #x41e3764bfaca32d11a0000 0 #x-10d536405efce052a6e0000000) 10 (3 #x-103a5d3743897 2 #x14f20950ed7fd812a8 1 #x-5d17ee59e3c24a6ba0000 0 #x407e06b9aaa80098014000000) 9 (3 #xb34f0d05088f 2 #x-1281241d236ce9c60 1 #x-e2998077afa86fe80000 0 #x-e1c680428ad9d00d70000000) 8 (3 #x-24c464e867e0 2 #x-485c1ebbe02c9d90 1 #x876e7bcad4b35a0a0000 0 #x2ccfc8e7d3e77f3300000000) 7 (3 #x149a2fb1a4 2 #x156f14afb5bd1d00 1 #x-21da5cf2a6845cc00000 0 #x-7fd1ca4ca5dca5180000000) 6 (3 #x18b3dd3ae66 2 #x-2b350584a0ffb00 1 #x58113f89c2301700000 0 #x14311f83cb112d8c0000000) 5 (3 #x-48c969ad18 2 #x27b8236dcff800 1 #x-9004baa1120e400000 0 #x-2c60f01e868ec700000000) 4 (3 #x808823a8 2 #x1ed28a43fbf00 1 #x4b22494951cc00000 0 #x528b74a83b8d000000000) 3 (3 #x151fd3e80 2 #x-1214cfb04b800 1 #x1331fe2aa4f000000 0 #x-7cbe438aa47000000000) 2 (3 #x-1DEA7260 2 #x486b2d6e6800 1 #x-3b1ad7788e800000 0 #x8f6a962c70000000000) 1 (3 -13732992 2 #x-aafd8916000 1 #x4e01d9946000000 0 #x-6f359c370000000000) 0 (4 1 3 1753472 2 #xafac509000 1 #x-2c17a0d0000000 0 #x2b73a840000000000)) 
  (svref *ec-g1* 137) 
   '(138 1 137 (5 -1 4 3719 3 -4547966 2 #x78C2A45D 1 #x-394e23c0a3 0 #x1c721cee312) 136 (5 959 4 #x197fdbe7a63 3 #x184273e29d4eeca 2 #x14c72e8c212e6c3c42 1 #x1b12ca338a8b9798020d 0 #x10db8662b2102be879d31) 135 (5 -424152 4 #x213935f34c8f350 3 #x-6416b81001f13c2b48d3 2 #x582b4ea3e5ff62b7b8cc5909 1 #x-970ec289e8547980df143eca3f2 0 #x3547d19340847c74a9d8a3a63f5eac) 134 (5 114590910 4 #x3e41df1c177d5b4d35 3 #x611cf88cc2700d3d1d9e3210 2 #xfbb6593ff57dd0cefdfaa71a7d86 1 #x18eae67d6a0367bb3332dd3009cab37d 0 #x12a400820d42daeeb0f02ecad792223cb0) 133 (5 #x-4e9dc2c9e 4 #x1e66b01caf49b5f6e99ed 3 #x-941443c24814788a1361e0db3a4 2 #x1d756124122cef64f9533d92155d927a 1 #x-1fc4f33f5ac23ddd025957fa7c52311ab01 0 #x22cb11f363451483bbb8051e3a9d426400164) 132 (5 #x28b6368bab0 4 #x5c80abe55c531e859b3fcce 3 #x271a7b6372e22aac6bf1f67b8dcec5 2 #x480950faa4e38edcc303909aa362bccae5 1 #x-2f695d7bc997d33b54fe945faf9ea8b15831b 0 #x15ad74932dcef5cea780d9afcf467ca9dee25d8e) 131 (5 #x-f9b1b20f9bdf 4 #x874d2dbf816986b90b491aae3 3 #x-1f7eecd47b8e9c892c01084ff693044f 2 #x2151733326fb81f9d1c352c733101bde3cbe 1 #x-32a3e25e7ef12815afff80679b229c18588dd6d 0 #xba48e859452bc0674fd79ccd2ed2a6877079ac64) 130 (5 #x479c1b0873fcfd 4 #x6cbf075e15a7e86ec9147562f85 3 #x-66e29aecc82163b4f20bb3c89b1640a9 2 #xa468770c0dec65d43682d816901cbc6a971ab 1 #x1c5e03ea17c39e39d1ad4eba5c896f559870d401 0 #x14fa538235699a9d1baf0cf2093ba392b067ae3737a) 129 (5 #x-f4a8ab1da9d8582 4 #x34ec1f1613553c0f4255fb605a0bb 3 #x128aece668365d9c7bbbd33cdc2cc44cac9 2 #x-18db9d85e7040cd4e267f7330b27f9d6682035 1 #x39c97f397429bdd0a6995170ccac043dd7e515787a 0 #x12208d5bbec0e138ac3da9effafcc1d9250fabc01ca4) 128 (5 #x25eb5870a9e41a8e2 4 #x10d5804ec53885b66bfaa17ec9e2e13 3 #x2c2da42e6d9bbfd25880a06a88617c880e4b 2 #x3d356a67532769d9ba32428aaa3a4845ae8ed076 1 #x32de51fd2fefdab5f4606e878a3fa7788bb8bb2f12a 0 #x7260899f3242556db881d11fc9faa51253907a670083c) 127 (5 #x-3fc0321ccec76cb96c 4 #x3b97744850fe55474265f3e3012e38c9 3 #x294a2d97dec369d53565c63dc5a39a97f1187 2 #x2ca2dc79c0c7fa3759ee9a63425779a3b739e4f07 1 #x3dd7409b1ab31d589a1d7d44e438b10f76dba715903 0 #x869905c731183e13408ed49aacdd1c002b8d45c5e8d634) 126 (5 #x3a202c8b93d7ea0607c 4 #x9a53447dae39d49ca1742c5fd6d761341 3 #x-17875a7ead58374cbfbfe20476e6d991796a2 2 #x-e4b26d299c4c085f35cdda443a03f50787288aebf 1 #x-33e115fb51cd77af18398e048aa630e8a11d54b07a0fc 0 #x109b34ec55d0a9fae068c3b7db991065e855bb9f60abfe51) 125 (5 #xa46e790e9d11d8f23fb 4 #x130772e22dd82172f10fa7e5cc2cfffa755 3 #x-3533b1e2d2a164ef85414e58941db40ebcdd8fe 2 #x-ba6c1392917e9e5028334dda4da433e18a6a6e78fb 1 #x-38d30b1ca7614c82ca18c4dd074d17057cd54702deb5f6 0 #x1488a3b2692f3afbb38fcbe2b35389b2e52cdfd30aa3f829a) 124 (5 #x-5c86b2e08868cbd91d141 4 #x1d89f18985c8f6b31e7aed50490bda17cca7 3 #x-4ee647356f0e4fdd0570b4977cd4ce51d87acf28 2 #x1392995f4c56069894535715b3aea31ea1d11e7464a4 1 #x-2493265b66295291202fddf2c0ad1db5ee0c2a44547138c 0 #xfc81f8f763cbb174a128fc773dce88b472138fc831f319e59) 123 (5 #x472e6c26832a4babbe49aa 4 #x2504b7b3deed4361cd0665da1394a0a17af99 3 #x-48e69390bafca549d61b0d9ffb1d713b4baa3ce34 2 #x1ba205a40504bd529c48f17c601b1e6053efc0f4d3aca 1 #x-175f7ea465e490f8a6a7dc8ec0126c37a29bd560505a1884 0 #x802439f32517f8dc5dcb8b68df2ff1e6b884d9353412e57c90) 122 (5 #x3245e3205547674adcc8f7c 4 #x263b6bb08f49f7b90717dcb6970b4793156edb 3 #x-335323dde65e807cd8424d080a013aff02ef3bc58b 2 #x108dd59d7117a1fd5e36e62d6eef763f60e4ae1fc43343 1 #x-caf0804d347e5a1f2a19668940f21d52062cbf49f1ca1862 0 #x29cab5592b986b3ee7e12eb4fb7123244f1b6cfb930a391082a) 121 (5 #x-565fb928b0cd70f893f13615 4 #x211538d015436e34a1ec7f5e868c99176e95ab1 3 #x-1de0ad379668f8908699a5e19ed036f5479a8e5dc8f 2 #x5bcde88a39d55abaa51020d23c8b7be364b59d4e00272a 1 #x-3e13afdbfda2fa8cb288fa59951c6cade1854b37173c1d6c6 0 #x687eeb05f3426446571f781f67767f0110bac4d5745b46f4ff4) 120 (5 #x-121e097af60f6ee1551e461c3 4 #x184e8bc13fee7f2d6647820c04bc1a87ec879b30 3 #x-eecce0a3d7c3a5357de3dead8b1109a6f8a0c7abd4d 2 #x11608bd51285673e411c31463e6f53c43cb5d7671f7396c 1 #x-1ed3c324f44ceec5a0c72b2e3c40ac01da7f67eec54e15c80 0 #x-13586eb753b2f3b8073d98318566f6636da8fc0bff574b4ea3ae) 119 (5 #x3db87cd19ab08f2db2896dbdc5 4 #xf53b7ba8acbddd1e26caf846c728a5e5ef38182d 3 #x-66ece1dda6dcaac31b3bd99a9d6ce1f9a9b39003b29a 2 #x779bd268d1550c9eb8605a508da294b4e6e7fe01346765 1 #x58e2de97a1e00b43a1bb106f054b6c488add397441e4b420ae 0 #x-10777c1e99bbd6a563a9feb03d2767e438a9384a257b1889de778) 118 (5 #xc9ea508be70929b64e7e699ee3 4 #x85da71d9214021110d2c30c8c1cb9081797c5153b 3 #x-2594c2a034b4aa8450dcddd30887e76ce530ebaa3e83d 2 #x-87c27e6be75c641db64ecbcf41a20abaa8f973b152c6df5 1 #x1d5f4634cfb505f6ebc742014ae754018fd4d3d275d7258b460 0 #x-441b1401f09a96b16f43846dea8a4fb00d14e5e6207123455a694) 117 (5 #x-1f156ddf4e831d051605f4b253aa 4 #x3faa80b210b15b5ad6a5bec7acc0c270abfdbf8fac 3 #x-b308db730bb3736f621d13d3c9299e7c6c38a98192877 2 #x-6a58b82451e7b6bffa44d3dfd0da0716ac0d4c41f42d4b9 1 #x1f71aebbf5c39dad71ad0dde86dabcc6239937d77b9322e1dfe 0 #x-347549327811d54a704e80e6f007a326585178c9d9a08a668c220) 116 (5 #x-c9d6365cd6a4db07a1f7574c7a68 4 #x1a8548426a8ec27fc6a51bc1d76ccb5dbc9915daea9 3 #x-2859a351741a59ae95e865301d4518923ab3c1fe0ffb1b 2 #xf056a9ee444ecb65262019515a3c639d7c733c6af40ade51 1 #x-11191ba592a446d5d2a06c7f468f10e370f7db97146e3863be60 0 #x35cd9902356ab013cc53236d8f56eb4dba7c8ee7c0061edf1a0ab8) 115 (5 #x8f5c3d9bc563909a03531812daf6b 4 #x9b52c0ac7406fad2ebda11aa948e72ccf2410a295a9 3 #x-574f01ed1108dd79ec2efdc7bdfd7813f62b806d1792a7 2 #x579a1ba2be52c35a72a9f27adfd474309dcd97beb0e858752 1 #x-48cbbf6e038991a163785789c1a0fbb542361d58e2946c8bf892 0 #x117f119113a0e981e7de34a74170313032acc350a5bbb2b62d34648) 114 (5 #x781d4dd0fd534b0327e65b7f9891f7 4 #x320ae07107a37af968ee92263d6ee88ad82949154230 3 #x481d41d0a33bce9b1ffe4dd3608c9914facc91f3050e1a 2 #xa3a36aa7282309cdc0f34abf2654464a603cab09a4f468f94 1 #x-1a5f395ffac08d2020c1c6d5eac41a5c96fba586c93481555414 0 #x17e25b449ad9e071f12404303ab9fc71b77e99eb46bfeb59c73329c) 113 (5 #x1fbed1b51d5226bdd22bbb02100fe3 4 #xe2fa3cc0e8b6167a98e63d1802635aea8fc258206b31 3 #x6773cdd47eab5e138e0b1533dff276e4a06d716d63f014c 2 #x-22a3f067972b916ef33b4ee6a71b02291ef0d1fa6af1fd602f 1 #x22a0527557953ce53c853d7604eb7b9a706ab37f82acc4c2c4cf6 0 #x-82a01f6c6181ec1b0b4b38390aafe2fd69f19cd4f90ed5d550c0948) 112 (5 #x-1f1eb97ac1425282da9853514c5c8fc9 4 #x3873476bd32afb710a04eb705372d63bd4c1b532ba527 3 #x1fc9db8f0e1d81f47915dfb9d290f739ac5574023b876a95 2 #x-1290784d22d70ea045a1fdd2e31a96152cf6f29da159a88edf6 1 #x4f2b13a2e98a5c07004ef28fad64501c5982d99d1b67ab6ae5266 0 #x-2d64bff3b381be93c3bc092bfc5678884b091e34aac45f81b1e54760) 111 (5 #x-ddbd8a54f88bcebdf98e466ceefd12a0 4 #xc3c45169294432d176a487043688998b858333eb9fdbe 3 #x57915b985e5a547dead507984b16ff71e3aaa6113b17eebf 2 #x-3e33cacaa66fd6dc056dd417f596e7a5f123558e2d8e31edcd3 1 #x-84f9afb0910f64789e46028be6efa6489009461deafb3de0f4808 0 #x-3bf9af867ad19022b3af316509a69eba5ff21998d1e12460bb11a0b8) 110 (5 #xf0a36e385efc0d09568befe862a5832 4 #x2480f442410c44e98392ba6fd4b555efe40fd0fc8f418c 3 #x549de968cf0716fa38aa039fa11ff1e51300fbecaffe00a0 2 #x-7044419e680efdd2afe1a43695156966b86e9685c9842181647 1 #x-3623ae61079c5912d6e6ca7fcd24dae6c3c925292541c6e2bcc902 0 #x107123c610688fd3aa1451d0ab312bdbd48df029e42b2583208638052) 109 (6 23838 5 #x2615aa9fb312c748c502bcbb8c54e72fed 4 #x5b56939010c2a4d687706ed14317ec226c1e51b4233745 3 #x-1cf6426d2849472f22bf1b80d89045b611167b0886f5ada4c 2 #x-f2e41c044c2a2387f08499981b4cf22dcd6bf3e81c121ca14e 1 #x-21317959c11e9e3a5f901f56d1b1dcbd15abbb97819ef1e5bcd76e 0 #x5142d0bfd22da6e2520701faecf83b3a129f10fa137a59d60ee7af3b4) 108 (6 448403466 5 #x107ec469fd0117c852e3a3268ff064ff7d7 4 #xb51bd5fcba893d2479fe8784764c50463413f18d5c5ad4 3 #x-abf9864d1d9eb583b595f44d65ac278de0e20bca9a76e488b 2 #x30578c259bc0ff028cbfd2aac020b83d5fa65fcefcd974b1a96f 1 #x17f6f3136c2f9d8797a25a9eb2624ed6af3c9cf80b281b128afe70a 0 #x53a5e7f655e64cf6488ddc5fd50dde3df6f1c2263c00f098203db72a2) 107 (6 #x105343d5df5 5 #x2510de3d10bd3be63700c28878e64200fa2 4 #xeef51dff949097626825d1403b9d652b04c2a05e605703 3 #x-1d83e839cdd569065e9da2e4710f2af244685cf2668185cef1 2 #xf152dc824d5bfd826ef3b368c7dde88b8fd962e2f03ba6b45977 1 #x4b1320f8b499d33395e099bda7ff4e830d2d912ec4e14b5df11df04 0 #x-19fca9cbdc9f655bf418ad9472bb5025ad5ecf88df47b3dee3583d1900) 106 (6 #x2ffd064733de4 5 #x-c6f3138a4598e4d5201ea54c5409dcc5d93 4 #x44b38b2b422312c5803eb4f66a98024e8cc3040e9af7f 3 #x-243a8e9e10581273504b09ee1fbd4c51baa3e7efdf89566363 2 #x2e498b25fcc3c1f4a457ce278543441eb903dcb850e6d9a006bb7 1 #xa6d53a6e84ca3bb66969ea1b8c18063b8cef334c0e59b03983e702 0 #x-66daa29c2a3a14419ba8b8f96dbf9da7b49bbe2200cfe57b61f3a49af5) 105 (6 #x3a1c75fcefd59b1 5 #x-82091a5958f831d65c918100afcef9fdaa42 4 #x-42a18ede2c80e46eb167ba1dee624cf21a9f1a64732681c 3 #x3e32ca6a64e375cc6c7a69edce62f2538cba7427f6e19e1d1a 2 #x4bddd9807497475df4194c6730382d62349a587112107a721372a 1 #x-208099e3d78d0f0c69c1626721a984d36920cc192bac7ebfd20e74ab 0 #x-47bf5808a359f2f92a200c0e3ee23c4cb61a9e33bf9103642864772b5a) 104 (6 #x228edde6375c63e1a 5 #x-210db753b1564c912db4b39aafd259a731b54 4 #x-d944726f4c27bd6e8cc5ab89bbe0e083d186c1a10c2299c 3 #x1b223ab5df1afd6622b7bbe0079d20ab0a2a6c2c32cab4d74cb 2 #x-4542cddfed575db08f18a25764b262a8addd676ea7e29564f6941 1 #x-5ef4e563965fc9a6198acfb1df72e1a6478edbc122f7cadeaba681e9 0 #x1e385c8a4b8df988153b48ef61b9f784ed2e633b948b2acc997c472128b) 103 (6 #xb6e20465ca41f0bbd1 5 #x-33ff10c46b4139c99c62592b3d88494edeb30 4 #x-18c4a54a5c2e45c9b333e9dd251072797835253bf57366ef 3 #x43df3ee563735f7e0da30907a0fc0eca92156fcf51cb92a0c95 2 #x-325334e6c8992272e59474fd483e8f30099a12accdbb8976da6625 1 #x-3328bc26c5992630abfc20cab540a20f11ef6b70391432ff0bec706c 0 #x5ee7cb20df8a5de1e791f5a0a23da98b29b9ff6dfebb5f5a0b7df240924) 102 (6 #x253814b40be553e30732 5 #xb11241a548a9616ad1726f891ed9737dcc61a 4 #x-13b7b71a20dfefadcd818edc9fc4ce597b0542154775d322 3 #x4ad5e812e8313af93224c0dd3d308a22c7f55060851036074e1 2 #x-8a4d650d241315e90c113c9fb0f63df56f974d7f873f7592281437 1 #x1cc4c229e2a08580acc155435544a3d5392341b065c9b8d720bf3ff83 0 #x28a8a5918e46a9572b96e5cc36de47f082882ec1cff1e2bcf2f69c2cd50) 101 (6 #x50ff3e6ed812e3b74d793 5 #x57f1de6d83243f072aebbb02c99a2b461ba93a 4 #x244352bdfcb66ec8ab15b339f4cd8f579cff8fccbf4dc48d 3 #x-5d67059bd962636024e0f75be12a0e20b67e1d423673f2ddccd 2 #x-81c4d3aeffa7f9a216d49ae007d0fba1f74925e1407727a85638cb 1 #x62a38b8549cb361e88aec5b8823313f8fbb03276504897759ef1d0ce7 0 #x-19a7ff616c2b1aca80daef5c91ab93419d0acfa3b21a95fb95621934d714) 100 (6 #x7d915b4a94b76d93bcb9f4 5 #x10cdd6e19d6525415ae0c3354b50572f4c7914e 4 #xa3dbf7ea7eac79e4d004ff86d7cabee2c87a9627cac85bf5 3 #x-24754bff0f82e41931c561f8337f4910d7ca6a2e8935529e722b 2 #x15b75456a179e166d64342326ee8375834a2cbd210482273aa9f063 1 #x615a0e3e2b5616bbcf442a3900b6ab08939f887719fb10e883b677ddb 0 #x-42a36b0e73cd646616d0083881570234f78a1f0b6898db9291a46167f106) 99 (6 #x91664f9b1d33d4c60f99726 5 #x147046911753bf129900b27e177b43b7f0cc49c 4 #x120b0bddb043f4ae882ef40299ea6f060658759f53bdb6cd7 3 #x-4a641d25c5836077b9167132d63fadccf6f1aabec829bb171ea7 2 #x5e83fbafda19d39d3a44cf6c19881e470c850f6b3ea59732afdc0d3 1 #x-123515f7724b5d3a7a171af77e3231d2f6dbe4525d65bc7de7ee03e68b 0 #x-1184f0bfddb6e82ead17ef7cbb19762375b86264a4ab45068f72d42c16f4) 98 (6 #x8233bd75eed13c3f2b121549 5 #x-2e4dbb80ec728480182da72f58618586849bda2 4 #xa6fced5c058afff0d7d4d2f423287a35882341f3544a4041 3 #x-3702ac71767f17e86ebefd54e588c094d2a1c8c9a4eaaa735b96 2 #x8cd28d2b824aacc1f6e6bf61bbf328560a82f98aa0f3b12dcbabf85 1 #x-4d098089f0bee7847f092a6f559a8911d1d4da86270c027ddb1c9e18d5 0 #x1046d17f88d01dd5b0d011b86ed87c9d4ea5c4e222a4b9659a441a52706ca) 97 (6 #x5c7af4e91e5ad898678bcff7e 5 #x-1139d4e617d4532388ff7b2e0c6f5525872f5f34 4 #x-1f29b365c123120ed22ba5080493fc7b0d8023bcdf31b35bd 3 #x7afb71321ef4c9fa0fba8d36df36325fe64cdad50e1f26068248 2 #x-2814f2c519fc907d470cd7590e6e06ec57ea646f11ac9a4520bad45 1 #x-5f6e96afa2098af66beb3d6ad976d5f8fa4b0a117e1b35f832e08082be 0 #x2528f806f4feba21db8784756596ff79c77b5ad2bf81d7180f3fab79107e4) 96 (6 #x350dfb78eefcd753c1b6bbfb69 5 #x-228527b5574d8fd0001baa9b24f5957888bab3ea 4 #x-627bd74becc73cb367ecd4d130bc763851e088183cebafa32 3 #x1d1736a6bd8e1994f1ac1657ef5bf0d6251dbf3624f8da70c40b9 2 #x-25b29ca4948f5ac039232c1597430062cc2b4ce9d368272cf6418b2a 1 #x850c61843529416151a6e815905fa250f34717fb7dbd0ebd0c8c41b9d0 0 #x7e28f401b145b1fc74a97dc7d3d22eb24c8a2dc42257b0eee295cbabf070) 95 (6 #x18e22837232a99082aaac53af84 5 #x-5b80f89cea791965e05b60bb6464df9f8c4aba2 4 #x-76efc745c724a2497c3c780a128bff33155e2acc2b78a7d75 3 #x29b881e58a5374ee232556cbe28b502c09c9b3e98ec9bdf7715f3 2 #x-494526835115b8a0bd562faa28c9b94518ca0c8bf17608f2fbc79c7e 1 #x2bc416f4a2b3ab5d85dfaeab3291136a5ccf6d206d7a11254123689be41 0 #x-7ea7f1161a12daf3f45fa31683b896c3cf05062897e7496090de64420aff4) 94 (6 #x99ab1430adc337760f23c2d360d 5 #x95d49f89449dacf39db3ac5467d22a6b4d5677cb 4 #x196f92cf595bc55a5fa3bf121d91ee8869c550f0d65f73a39 3 #x60532e0f818dcc0fd4e64dea1752467f7d56c4f1e0ab8943fb58 2 #x-21465402fdcfb5a45cb1d127a2d907c3a38191bc973c5e748defa668 1 #x3b7da1ad7798a76ca997d77ab162fa4b390269f03622210da0e22c2c1fa 0 #x-10f32be682d4130da316cb14a6ad292195bc1d8cd47a265188d0f87c2a5b95) 93 (6 #x30d4843e3bc42df5b729d3c0b98f 5 #x181c9e8f794f89129da505b00a01533c038b44df9 4 #x163cf1d0503b2738416962c7f621ef8e7d109fa04eff0b2aed 3 #x-65d0d0ab11b98d6cdbad900ee77ca2c975291fae040c74ff891f0 2 #x9a9c527a907044aa5fca294f817b35b2bb269b0a18d334f986bd6684 1 #x-294deba6cb06191756226e8e5295a58ce4e907ef1aee16d22fd72fb6a52 0 #x-47ff95beaaea13874be81741167a205233997dfbc80ade9aff43ac38fdd72) 92 (6 #xcac085c1ef684f9bd9883e8494df 5 #x1013e2afafe10169887cc323f8e174f5eb7ef4181 4 #x25674f67a9100d6f587fc483bc2f6febd38fc6da0e74297853 3 #x-dd787f8871c50ceb3534da8a3755c995ed0adfc79c7cf9901140e 2 #x197a4135cac199a831baa1085881d35c3dda4c43f6f218984b025374f 1 #x-11eccfa878ae72f198d2e1ad61f94132abb0e3466b4a240d4d199deb28c2 0 #x2fde39cb9e19c8bc2bf21a3f0cfa5fa63928c188f87ca61c1094b5e856b13b) 91 (6 #x29fd77873584e1f3f2d951111c874 5 #x-3a5de5ec765de2e6c7dfba54418742982f181eab5 4 #xe07475f9db68cdfcd9377a6c163dc2c8ec3d0e358aa2e4228 3 #x-b52d35204dc1d172161134101dd7b3bd263bec7b42f37e5b567e9 2 #x178af6276318dabd82c8d4fa5a2886bb2a3487c770e037ec93660513e 1 #x-199f7e6ec1acdf60c5666834dd1e0669aa06458b0cc969bcde9a08dec67c 0 #x66448d66e798ea6ba6a013d8d9b33060cd635d181f4f65ca66c1f2063aa8e0) 90 (6 #x68a48b7362ff08f8679d66d6fda06 5 #x-aff4e1d1a8dc08b015371cc7e7c80598abb1e85f3 4 #x-3d73128c14eb5993720bae1baca711b632527cebb4c3d29206 3 #xb67ea05e178b91baeca6d75e1310b7cb7f1dbd6aaf13e80b9df76 2 #x-1618515eb89717d8088035cb8d466454172fe8c6f754e62b05a5fd94b 1 #x6fd330da901a26bbd645627d226c8c9969729d04c1f6ea6165d17fb68ac 0 #x2865fc1ee0aba1ed9230855877497c2f66f16ea61fb36fd921bc49ba587f62) 89 (6 #xa08d3829476826c5dc62ec4e570f5 5 #x-8b02c0e1f63b301ddb179065efa9a1013f8fcc5b7 4 #x-85633808cbf790d4e66eca3856f8db28d72a4dd7117bc32cd3 3 #x2f6bdb49b9069098ed91c5054b05ce437cf6f469033c8cfa4d02d5 2 #x-66616ea5b169c7049581b14ac5bc867fe56aea20e9a37ad9d5ec808a9 1 #x5454128300ac4d4afd5a258c40f921a1a2ae9975c491fcfd6e26f88bc2f0 0 #x-e003e7c6c78211ea5f50f6950ce2d8e7b48c7c4b6c08db270ec8993e0d893c) 88 (6 #x-290e435fb831c56a1f4e98bfc37a7 5 #x1369300eea372dc5616d9bc73399e327703fb23792 4 #x-5486a5d4a4a8a92fa945105933d84bb776137cb6f37b87b941 3 #x3db765346cfb993c964043b8b137995a50e537870562ff96bbb506 2 #x-88fda309558827b398296e1e50313ef1cb3b2386a65b83bf435774916 1 #x7ee86b2cefc077e29e8e8e4572542561a46290b219d4929397d4861c25de 0 #x-1fadf7b169738764d9309afb28f76ee30e7433be1cbfd2dcd64f8a68bdbcdee) 87 (6 #x-45dcf3500030aeab21274c87ed99b2 5 #x3bfa545faa0b667214cba89fdae9df4ca597555fc0 4 #x8cd96f286ba15f440da171b616c73b998f03342b8be7b7f83a 3 #x90a16394d1a931d55f257fc2edee52e87d02f8edc2534fc26a59b 2 #x-7e8ef7c80a1ec6ee3fb1ba939b68d5e4fae2fc6d2c1cc24024e7dda6 1 #x5fd0b97f9510014ed217e5d69bb9ecd58d88374c586e769343eae093048 0 #x-11f95d4d1467982e95ce42a6d5728ca1a12d83b36b386ad0c40bd51cc923ce8) 86 (6 #x-dda3c32152efad1088907431ed6387 5 #x2b74bf74a7d6bf477c230f721b2c7ff7bb4c1bc3dc 4 #x17acf59db184e5c727d5dbf4972cc88107e1f316e99fe5bd25b 3 #x-7191688e7886c0a9401a80d98f5cfa002c1d76e634ca72cbb2c38f 2 #x12a0fce53360c500550fef524136dad7e6daecd30a38b2f58315bbc4ee 1 #x-1191e3e5cd5ce03b69047c0871bcb39fb6f73e301c85098809d09d4d9ba52 0 #x316a78445cbbf5a1ed896fc11c81e91e288b8a69fca2a567db64c3b65c98060) 85 (6 #x-14a55c622fd455ada4a889131ab1730 5 #x-5ecb2e258903b0ef0335f54955d29ce0f71e0fc6cd 4 #x11e4515869963bb4dd9e56e6335c16af0f4ed5d51c892144cb6 3 #x-d8c2b9ed75684062a8a73a20f3997ab3e32f2aa8b505ca358f6c68 2 #x218540313cb5d7c4a3af981b6d3e2a9f8cf44b31a059037575da9802b1 1 #x-1ce58c11069d19817aac70f5146d732091adcec4c63975b1afab19dae0a9c 0 #x7eb6f6de0385293ac64e9571e63e9733c768c551aaeccc9f35152e1d3f40ee8) 84 (6 #x6f55ba41529e2aaf1cfd6398650c45 5 #x-ffa82ab18bb98e21295c11b853c036aba3b24425d1 4 #x-11f2727a42c338b8e7903a82e8dadf913390a0276f9c8be1c49 3 #x-900dc0beb3a3d07efde0f2463c5944187d5ec118a5c582b31b341c 2 #x11e207d7f2cc98ae995577569b1728952d8e39ac086524835ef38bf245 1 #x-a06bf73cbc78450c17f6a2c3fd0b240121b44a7dadc1e6cf9f2705d6e2a2 0 #x5fcbdc3e032ed5865ca6bde93c85cdf84a7ffd08f6bd30d4b286ff494073b3c) 83 (6 #x6fea1e83d3455fe2a3843b972f187d0 5 #x-86d75786d89ade97244c81ac181e9f031cdd49537f 4 #x-38343b7bee9a42745d896aecad7cea41c7b51c1de6522f4c7fd 3 #xb74edf855378a0ddcb4a86b580bdd51524f365822591ee7f5ab347 2 #x-253c195261c093ba4eee645dfb39c67f9dcd0b02755532a7eb60492bb1 1 #x270b93f1e974c12f9a85d4158d1412c21bc36c195dcaae3ce433b17f00bca 0 #x-7b8afe0684df03af1e808260ad9fe4fcc666242df4a15259ea3e553cc5b3578) 82 (7 137 6 #xff4b023d290a392e8051bd2996d953b 5 #x1a3e98f859a7b19b44a029638aa4c4590ac6e88a49f 4 #x-2c7918684ec800045e68f3d9e5d92c54a3f2ba0cd8dbd05f9b3 3 #x24336bc6e68d813eddf2322fa703063ce6a9154b9edf3d386aa0ac8 2 #x-5d394a207dbc085ce011b2bb5c83982eacb234afb24f6f9ef6cb389e26 1 #x4dc1064d5f73bb408d52b4c363dc41399402011190e971be5e8691f52f466 0 #x-18f511d965ddb9a1c09ed7a94373bc7c9c7591d4fd5ddf407a21d848de2ee728) 81 (7 -74863239 6 #xabccfecd1fd597fb8553d52fa5ac449 5 #x36da3be1ac5deefe241736ab7882753622213b3d867 4 #x228690d0772218a084d01dd71b9380e5025a3554c334a2c5127 3 #x24bef54c38403ef7178aedc5b4e7d56f5f7a468d057943755c9c175 2 #x-4e01ef36d8004b2b7c833d6e4586e357f22d3fab7e65fd3b21f2b1cf78 1 #x3560a66f0a79aeddac741650d3ddf67269ad44bb938bcdec733e420c4d810 0 #x-17a6b3836456d776e6a2ccb90b0c577e787eb50b29da5a7bb706f2eba209f9b0) 80 (7 #x5b92cea617 6 #x-22e39a4021438c4e96958673c201d283 5 #xf5f797991e50aa40f5aa7ccd3f3853cee2137a38a7 4 #x71e0263839515ad7c0f0426cea53ae88b842f319a06bbb653d1 3 #x-8bb5d8956e534795063e314a58b8504ba2c568602def0193bf142e 2 #x27a6185c0089501b3f67839adbc0c788b85240ba6e7d27caa2a0037643 1 #x-2ac09ff3c439bf765ad54c8f0f4e8a54a0c398025a54c5bb5187445096aae 0 #xb6fa0f8b1b0aa8a3d15aa10baf52e0e5666066356a5f0e83543d3e2b9a52e2c) 79 (7 #x-9dfc1f7bafd5 6 #x-772b2b77c078f172fa6e22d371cad948 5 #x-5d8a6a7263a6426c70884796bbe2b764b925307c8a6 4 #x56e5b17d4745be5ef44466e4ee7e0a93a7f0314e96597ef8fc1 3 #x-4ed6934a3aa45d9742a79f5ee644731e0c0f244330e8bec7ecffc83 2 #xb5eceeee95bb19dff298a6a8d59bc222e099b4b0872450587450e1df45 1 #x-960d6d256cfad972bbff077eb9d2f86b3c0717825f08ff3f10cec544ef90a 0 #x3c71083aa466ad100f9c865effca56a8f86c9e4f50ed6e25764e8ef2aa7aa958) 78 (7 #x4b011853e71b3 6 #x-a60c4db8d2bbc51816c81d704a008853 5 #x-9280f634e1eb5a35f566dccaddb23e63d4d01864bd9 4 #x-4014c92429ea47b6a853429e4bb9177b1dd6599bf3d5d03af84 3 #x-6587b72968da981f3788a782376bb1884e99a41ae5e62c19bd8b560 2 #xc9bb8c7f85ee9f66ef98fdaee7c132a51c42cef2c1b5cac3048a167a1e 1 #x-ae9d167d1bbd62154e012c9f70bb8cc51afab260e61203f0316d2f5f7e44a 0 #x45437e2e7ac56734a005cab7371df6d921c8907cb5eaf48a7c73a1f0084fe412) 77 (7 #x508cae52d3a7f1a 6 #x-20b7a18af5dd6d8c8939124fcf0a4d91 5 #x-5c1c6579c4a0250f347ba9a883d6c66261e8e7e112 4 #x-c60fcacfc745eacd7c79d5d5b6da8a091a406e81ccdf0c39ff9 3 #x-d890261e60e11bd40b85cdf3ba0a7e24961594a78fb67fc47b9c4c 2 #x1ea790c0e17f4756d5941125b0eee4c7178894bc7d91fa4baf536a90ef 1 #x-36d8a679bed00ca031a3a8bac457bf9b7f4dbe2acc2700308099a1d5503ec 0 #x-3db90051cc1aa96ec9c28da43cbb3894bd7c878e6f4db1e8be77444bd7017c) 76 (7 #x940ccab4fc5afa1b 6 #x1eca97f073026df0b667c81a607edba3a 5 #xee4deb3d278aff3dcf189dd463ef6b7440e625b8287 4 #x-8865e021039f9b654309966ac895e17c1cab0630b2ce51177ab 3 #x91a11420749a17c94c89c65bb723cf9f3ecddef7ef0deff11a1a5f3 2 #x-db265ebb0256c242bc65a2f71c99b6c3b4214993dac5a838a853b90814 1 #xb7a985dec415570de92f57670489f66458888eb6461fda5746d6e91193af2 0 #x-6d96988667b11b318b82ed849b0688943813da7c3af73f2caa64bce21601ef96) 75 (7 #x7a4d0fc919643b3f3 6 #x73e576cc5fbc182b880042b7d3874390b 5 #xfeebf0c46386f683007dea4e1dd2a319e3ea3d99f39 4 #x6fcaed6c1172fc7fd916f86a6b4b8dd092be6ea1f5990719b8b 3 #xd965d7c522d03ec87adffd3f8d908c99f118f98f81aa52c79cedbd9 2 #x-156016372d5320cc3320006cb6e167538bac73f90cf767dc18c068fa11c 1 #x18e070535bbac6ad514c03dccede9d2f592799ff841b1645735542e15daa78 0 #x-967fc61b65289501b7d22ad2d0cf9d931da9bee40085fa783fef78e27ff01cd0) 74 (7 #x21bdb3c394ca05ae35 6 #x10b84c139e3885554ade7bd258a1728d2a 5 #x-6a21793695f7a76ddacab8023ab28d71b46c045fb23 4 #x126f31a423a2a05e4fb95eddfd07d259de697d383402a01ba894 3 #x408ca74da864f865cb1aa94a9412f0bc7dc0bbd5a71c34c6b6d03b7 2 #x-eab6cada67a6d3adce168de2201ae742eebb11bf46742e91a4f9e15d7e 1 #x16bc9ea06e70c7d99eb4be1f61c56fb20f1c1561b84a67bb779cb7dd0a6246 0 #x-2dee52abe2f5efe29980922429df7dbb57bad0f09e3dfa0adea7e1fac6547677) 73 (7 #x-20c82afb2f10702011c 6 #x10ec01b697b79f7def4ba58751b6c311f7 5 #x-1aff111f2c6cbf1df72139b8758d630107514134d7ec 4 #xac2b94da1fdceaadb6a9342fa035115d089b0f50f142afd3423 3 #x-e9caf7c72659705f656efe02012b3b5dc8c952921d722355294c4a0 2 #x1fccb7cc26692bb3541d5b3c3819bc96b0ab567a7c6c955df3094e3fce 1 #x-3440684d7bec47e33695eaa8b65925e88ec126578a606cbf2a25d93d1ca75 0 #x8f750a7a8357bb1660377872c173ef5b434a8b7388d031d5216aec53c0aec602) 72 (7 #x-2e9b10b0da9e168f08d3 6 #x-28dd8de3801bb377e85d97a24e06eaa9af 5 #x-8dd0957cda60c984cf6917ea30e940f176fe0896369 4 #x-aece58685f48bc6dccaa914cf328b41b805640cbea0dd22b91f 3 #x-179c8eea39a6a595b1a5dce71e11dedb6400d4075306ee3a3cf591d3 2 #x1472fb302c7da73f58fb5b3f1b5f70e09c3bca179aa690505ed0cfe7576 1 #x-289ec09c3235a22d799cf14cb43315cbd8f1a156982969e6f8d3ed2c8a7fd5 0 #xf1b1ffb97e871d6164e7673bcb7847e5cf528ec5cc49956f06e953cb9dfe4031) 71 (7 #x-1f36846c50a4f9db8f8d7 6 #x-cfa56fa7e2e4db608cf62c14def1c7c46d 5 #x232525289ca3a9bf63c28c55c08435b141d5e5bfbf08 4 #x-17593301a3faf68f3233df166ad70cdf04974687fd5482e07309 3 #x-88dc9553f812ab069dc31413af9eb402e1b6db8d8c194ac44a8108f 2 #x22429b32ce25eff1a49ba3abd78b73f2b7ba93dfbd1fcd5d9635cf85a50 1 #x-377f0daa52cc7a254c90a31b448ff6bb34840140ebe84f728d1feb9e42fe60 0 #x7d5c2cbe1c8dbc03d61a4782ac81611f8a3a11f97e9a4a3f57a98de6f6b52a1c) 70 (7 #x-dfcfa098a61a5e952125d 6 #x-168aa4d078110731cda98ed581bd8bc9b35 5 #x24df96448eb0bb8bce0fbcac5d37a609c0b16cb46dba 4 #x-ac30b230349b7addeeae423d7dc1ca01a285b5bb3a71ead8545 3 #x14a17fe61d0ebe986c70d62bce68e9ba5d8614bdab34fc53390d3fd3 2 #x21b1c6ecb7dcec98b0d523d8a491f3c5aa6bb942cc915741fd3704d45ac 1 #x-14e642e796d6aed392ffd3203c40bec4767a3e1e103d14a50eca122c26afa5 0 #x-7e69268c08c1ba72af97f1469136de039391e80205dc2b86317e375041d07da4) 69 (7 #x-47ce8ef7449920cfbe6be3 6 #x-5a82ad07bcc492218e14616658835dfd2 5 #x-254b2a3ed7f9b60eff0ea701ba8da2973ecf5cee15d4 4 #xeb81bdd985a701c190e7981f900c62c727a62f77189153ea44c 3 #x21f668522c923caa66697808253496f11e142acbcc3d48835bc986ed 2 #x532f3f699bc1ec7064c32ffbf4c9fa2fcc1cf7c166221601ccfdaf5be0 1 #x2ec39f2b98a3862cbd3ad2c896af5813e4cf96b2aaf87fafeda289ce9de265 0 #x-11b391f672e60d3270312a53d70a6f81922aa23f6f63feb48a4d19523962e9664) 68 (7 #x-103032996d52aa159a4aa4d 6 #x55a18dc6c64d0fd5ca4f52ab5ffb9dbcc13 5 #x-689bc606227a47a9cdbea1dff77556262a0400399ded 4 #x18f2ecf257ce169df9c94f912ce0a2a105cc538ed048f6e88c4b 3 #xc9f0949f5aafc4da44d09e1389a24e595b6cd4a465bf78fa44b7eda 2 #x-30b329fa105087323758134033ab1dfd117c01478117d43b1b780c79774 1 #x58360e41029fe383fafa096724338470bba2631516ca7c887b464c87e8cd8b 0 #x-bf5da01c9849f66afd45ab02763e0e1ae42d563c8c4705872c70c9719623bd36) 67 (7 #x-22b16ccfc6e7ae6f94b7f84 6 #xb6ca12fc2bcb12551fe237ef587fceda19d 5 #x-27c03a7d3d0efc8a44ddd731cec15a2079245c6f0a80 4 #x83352f36fdd27528dc5b9156783b6612f00700ec4c4f609fc08 3 #x-19a7f2a091deb31fc74598eca133c46c98820537e447d24308d208da 2 #x-58f9b0aa0752788b998af5f94846f08647693a3f8f9fc46931924956d3d 1 #x36acd2cc10533a5f507d7cf732612e7b8ad2ab7a4d3e5572a4de28206d7b4f 0 #x3dadfbbc8284bc84fc121e2900d83d9d34444aff2cf451ab32c3d9f87581f1a4) 66 (7 #x680bf48e160de6ab7b98ea 6 #x56691de29bc56820dfa807836f59dc6c119 5 #x8bfcdb99dfc7edc0cc21c74cf1c028d979052bdb8dc5 4 #x-10ae0d6fa05a0b47469b9aa71dd847e01334211999d9d6753389 3 #x-28cd132d02004d1c068ff7ac01fc5c54ffe6106453d108babe8c6133 2 #x-3d9dee1fedf6d6fab6745c73e159c1cea15b1c1d5c41227cc453609ce0a 1 #x-22de9f44b5f5405462fda9d31ff469cecb3455238747eec86d2127c52942dd 0 #xebdb79043395fc7ef4296628b18c45fc9eb56b6c347c199f09e85d6500eeff7e) 65 (7 #x181cb2fd20353016996ffab4 6 #x-18265e4d67263df68885d0b0ddab405eb2f5 5 #xe2a3828ed017fc1ab06c85a7ad05f93e047f432c3a02 4 #x-164e6ffb0c84d4f76ef0a054e268c72c1537c74c8ba6dbc88b9f 3 #x-e206e179ec446ad60ba58079ad9686728ee95eea184faa3cb225045 2 #x278fe267ea11caa4bd949c8666c9fe27ffeb66e433e0337d97014352cda 1 #x-651c22ef201beb3dc34532065481d2801ed94401d3355a8be4f8f15fd06e64 0 #xbad6662781ce5a3266f6df4e995452d8ec0b4823f29b1de0356b568f931fc54c) 64 (7 #x664b20eba226931b041f7373 6 #x-39a0ad3322935127376cf92f22190d4f63c2 5 #x2cb922037583e69d3d9fa73ec9fb96f46ef9ac209923 4 #x-4446fca7021eb0e4354f5f7f4ca597d4f74bcd04ab40ef21185 3 #x1bf2e9928f809b4feb26af58db0be8a6b960f957929654cbabbe6ecf 2 #x8a53dd8f27af32578239c18f66390588a40bbc3d6b522c1b69e4ff3abe0 1 #x-5003b156bd3a2068004f85504186c0ed4d31b5067a8b91eb5ff3950a18f46a 0 #x-18a9f60da0c6b7023b8c5ec81dda4548d7274ff93134822b0729584c5d1a9f0) 63 (7 #xe3347782d0cc679d98eee2c9 6 #x-20f038c7f812af9cd48a24ca8f775b0db23e 5 #x-11bd81f1753e1cda2f53a63de429da8c1127eec080de6 4 #xfb19196070fe09b4352d3136e4041787b97a19475890ef3b836 3 #x291ba360326f7f1ca3d76725e03c78cdd88be8deb018d65411c8c0ee 2 #x84773f3cc2255bfc94c6d23616f55e922c4ad58673a226e4f96105354f9 1 #xa7d356a5b48ab9b44b8dc42e94bb9b989ffc94f700425b604d55e331ab1c1 0 #x-85dc7306667e42b26b4ccfc7be2233d61e136f1845d628678a22a34aa270d25c) 62 (7 #xa8717b86ffe64845b536037d 6 #x58c3afc0adea360641673f0dcac0b87cf922 5 #x-18c9c34f817a6b04255424660370009bdbddafd106b80 4 #x108df7db7c904517da8c6fe1aa290ce5e49db121fafde8442908 3 #xc4404232bfee22c43c3f0ee7202cd3d510619d31911a544880e1485 2 #x22392bc8a1292e3dab98f1b27ff1e7accd08ed069ac2c278fbc5cb3030 1 #x56bb1ba14d44136534fc3fed98e004c70b745bbfb5af76a6fd2562af5cb3cc 0 #x-71df6e0afb1bd3fe2427739d947af6918028757f8a8abd8fdb9b706b540cd82f) 61 (7 #x-2a919211382b3ca1749d479f8 6 #xcf524e24bc7603df416749ef5bf35102030a 5 #x-53ed270909311121d75ddabe60869037d22f0301de08 4 #xd25e00bf31bec36783857fb06b92889f03b7cd36108936b842 3 #x-1a732dda23e6fbff0295cb405d868881e7a44a3d349375b741251d12 2 #x-9504ee012a2eab62cdb776ab1c34785ef88325fb78d0c10e5e4e85fa4b2 1 #x528c11e4c7748a272f305dcd26df47c50228833587a9dc9cd416163c64c89c 0 #x-bf7706a08b8da5241b47d7cf7ae21bb31e7312805c5d29d62e2ecab4531d3f6) 60 (7 #x-ac1c3337c61352b4133e818ac 6 #x652196fd22829db5cbde5d55054bc3b8d495 5 #x19a8e5b95bceba1a38d00aaabe0b83ae9af666fcb2393 4 #x-c2bd0b8af2a35084f607a65e220fa40acc169133bb842643473 3 #x-22ce2496d2fbfcaf7da5fd07d33df26c2d4ad9741bb976cd5cd3d855 2 #x-b6785ed610798948351092ece17728d2c81f304270334b593288fb988d9 1 #xafa6e83c5c07aecb423365055f14145d7c8dadac5071edbc34bbbdd90a71c 0 #x32dc8a6b95851bddf5be3ed5e82d9cb8014bc89bafd3d7e601d64143fe917f51) 59 (7 #x-1119c8d891afe5b266b7733bbd 6 #x-11c58245dc623c6d9a80e8a6ca3243a3f2170 5 #x23fd58edbbd662bdac0f854d60cc292e795ffac7f1ca1 4 #x-a1e5c661dbbeffebf1a5c00a1291f6280b48654080d0963201d 3 #x-83524f33314b56eb8fcaf969d1b93be307d64b2aa3fad696ef5d2dd 2 #x-3d4c9625494968d930217adafebcaadb458a95944452bc39b39197abd0f 1 #x-38b40bd97f55ec19611f17f01f675ee11fc1da117cd650f727e04861e5bb20 0 #x242144b34324d8a59365491ff57f459e3c556fa51bd00ae8c677120264bcf6e0) 58 (7 #x-6fbcc08df21faff91fa2a93b 6 #x-22949b98185bdc3e6b0b810087a814699a97b 5 #xa8de5d492ef016af05447a19202933d04d9b774605a7 4 #xfde577a8e620f519e025ec6ce251635b8f83fc6cf65112bec5 3 #x159051cabb42d54cae7dfe6dd0844cc2bf90940782dbd75f535f13c4 2 #x6d43b3c3c22a72cfc52e99f9e938e29846fda3568d00902ef602a675d5d 1 #x-40b3ef0d0d057ad3532bdf5e4e0d47e3270b26d9c31c46eb68948fb8184b2e 0 #x-4f8c989d2ab80317694d8817e9160a43c75723d4d7cef52ec524a6199ae23e0) 57 (7 #x3b239908fae6140d859924792b 6 #x-9b4b6c7a8a365c4c18e706c7b78de0a4edaa 5 #x-1d54b590c72ecffed1e89d2abe556df81da0387f28555 4 #x7bdf371f39b179c44274a44d4c32d797166b2cfe5f68fcd3f12 3 #x18cee0bb670dffac0c39a1db17b8920aac31820c0c443c5f09ac73f8 2 #xb610583fcc2c2649ae659381523de914e27b852f532072fc3a0cf7861ce 1 #x-13d00b19d89a6f3f4e4ff799e04250e30a17f0e022c191cb416caa7eee7640 0 #x-11bf1be010b0be7ff26b90f55463c03c85113d0c9eee4e51e88b8584724053c0) 56 (7 #x811745b2b790ac1fabe3ab7b17 6 #x2fbebc1aa529b305e4ecb81874d72cd77b256 5 #x-2c184cfc4a78a37f0a067b0d5da514833166bd4f2eafe 4 #x50d76e9781386a4c2dd693a0d90ccc1aaa1f798e86ec7988229 3 #x414d18af2fc779aa1b22e50bb48d5c6d78ac927f1349808ca41ce35 2 #x68d7cfa5f36430cc3e350bec8f3a2fcbdd30b06f074a1dd00084e5c672a 1 #x1c25fb3c2f20cb5019e7a91683a6578adcce5756562bf182491170c5522a94 0 #x-1116bfbf59c71c0e436b8bff31b5c53107b822113762b0f8c7651e39743c000) 55 (7 #x5689ae349f7a13f56c86925490 6 #x443a8221f31ed38aa3bb40132c2f63394fbb2 5 #x-1079ec1c090dbc072182443dd773c4f137d355b255aed 4 #x-14a5c13c36fa773c5519fc10ef9235b7107aefcacf548599c15 3 #x-f0753f0cd4fdd122d40f006fd7f49032b61518c54f1cad14dbce6ff 2 #x-2a23c59ecc1f08b5f6644e1aa89e7861c3e186d14e9f6f6c3fb4c8e2146 1 #x281b4dcb1a3fbc596cd42f1abbf4baa06441f384d06aec2d96d7e9524fa1c2 0 #xdf58787cfa8ff31fe28e5670507c072c18624bdf31e9c65ad3962896d61fe00) 54 (8 734183 7 #x-d098ca561e5a988986c239a2bd 6 #x-107ff8bd2656bf93bc5c3fda07da2f932e95 5 #x1c17040a756f38e7e164ebb24e1f2b4312f5710453f47 4 #x-404d5470e6da10d9c651d8e4cf0f01e1c434af765fddd711cd0 3 #x-eedb2533a0341157194e356f111f813dd4d375e17687979cf66fb43 2 #x-84ba93083df72aec62134345121d69aae0d22fad9c0a9080d43b92aab91 1 #x11fae1ec5187c79c11d1d59ce79514a24da183c13ba9b2675004b236b73a78 0 #xa9c5440eb3a9e68e0683c9b0d1e2f9d0150b21f6493f40f97b215a3e09cec80) 53 (8 #x57905514 7 #x-2b9b78db4c465407b7fc6450c26 6 #x-6476822e4327300eaa46f76a35d81f825a3d4 5 #x2dbb946c63cb675ba8fbe1486a42d8ec39cc8f36c9a03 4 #x-20a6840f6f85fd1e93b28c9b8582f514a48d544877e38f833df 3 #x-15c76ce404f9c157b46d7386d2bacbb8ec41b06e5e1c49a8e6c28d9 2 #x-6c790c424a8739a60d5780a8bef39f4c6fce36c610e7bf90ac1da6b9172 1 #x-98bf6bc4076fcfc68b45c4b32caabe19ef609f2dc3b209e25c91e859965f4 0 #x-18b4e99bfcb018e0a646458a2a8e1e37401673f0fdf127d14461de464355200) 52 (8 #x207c95441d 7 #x-335ed48e7b528bc44a6c38a4a40 6 #x-6213caaa069d4fa26e6e2b6e19960cf0daea5 5 #x139db5841d73c28dfceaa3dbc5117b01348ee01405cd7 4 #xe037160048a7138198b444ce5f53b6182dba9c2fdcd681f639 3 #x8e1e3518f38b6d116c4801adde28645f9ee469340f95cc5963c077b 2 #x-d0774ed52140db58813439c0e009d8ad24255ce5c95645625504c7a6d9 1 #x-13a93653e7e64f0a76a1692dd9b40206a712940b1fc5628eacffceca522e18 0 #x-7b2b7703ef61e83c94673e11d40cf4c18e7043c2ed42d52b54421261a181400) 51 (8 #x-1a7b3ee5050 7 #x2a2f6f8678d478fe88efca36f46 6 #x25da118e3e51942eabaa139edd641ce1d4ee4 5 #x-1693d83b127ec08fee944a6994e7a812f1f0175aa7736 4 #x1b0f41487a722340d3f4a820263eb63407eb1a5fa96da544305 3 #x79e58d15a72d0e5ea91229db9131117f5eb56c382c1af56d68c968e 2 #x421c98d13da2022a05b11edc67aa7fb9c623d8065282e270179414f659c 1 #x-bc63378fed18270db21dcccd8589ee9775d8b5f3065f04093c108d03d5be8 0 #x-536adb8233e8c72a98aabae55356cf20498ee34942d746b1b38f15efa0e9000) 50 (8 #x-145bf260073a 7 #x11fbf2e15cc672de2d3de428e886 6 #xa04ff381ad87b27b2073ec83abfbef63597b9 5 #x-26f4d2baf8a56594fcd85f66df67622edf26982d3081a 4 #xa8035c31b1e4c35de3e92af00ff8a0469c115f3ef059751253 3 #x31db604f19a4cc8af900c7fb36953ab7ec77fb63fdafe2c6421f42 2 #x4d3832ae94585d158830b94df64ac6e0924191ba9d12e1e1241a9cb0ac3 1 #xbe5f7d0cf0884ecee392d26d1bb66179a7d8371eb8772d60af94abc4a16c 0 #x-a1c2ad8a29b8f34e5911915e92cbc36d6f3c66f90dccf1b32b8077afcdb000) 49 (8 #xd2b67087126d 7 #x1a7cb398980c294ee74bc37de26b 6 #x6df5ae601e3d70f594407cb2fe8c33ffdb81a 5 #x-116a336478d39b884c323851c3692cd6f28fd003f866c 4 #x-6a58b8c594bebb6a6b8bd74a4a54bc17d6dbcdb60b034a1681 3 #x-4679f1c71c183757c156ed7b56f1b3b765ab6fb160b2d911d85d421 2 #x219f90bc377bd706d3a7e59e0600e02986d253ac3e86c1fa5e49b310568 1 #x6ed8f6871b8526dc709a126f2e8708d0d85c795e73f65b26acae75dc07658 0 #x122c49f2a6ed129c7c25aa513658cf57baca56ca639ffc3b264307143472000) 48 (8 #x172e663bfad150 7 #x-13a14632bad9efa913ee717ecb8a 6 #x-468d02373aed17fca9f203f18c741fd716d71 5 #xf7844a95ae724474be638e1d2181e59ead38ce7798ea 4 #x-920e2b86bd525b7c40a2c5e976993ca535484aa6750eaf497e 3 #x-34f6d562dae246d377545b516efe3b288572886fd55161d87b536c4 2 #x-1086a7db51fabc3986b7291c37711a807161b5c039383d4b6eaa6aa6826 1 #x59471cd74854f120b2ba1fdfc645f56e5d38c871026925ffc604c0707a72c 0 #x8baf3f7a3aedcc578e6896a464f1ac9c5b9451052b152b3294accf9f007000) 47 (8 #xf2c2cca0816173 7 #x-85a8ad4ebb4b9bb3f5dc53b20203 6 #x-b41410ae795df1de52e14fb3826b00c776209 5 #x1af8a3b655061a4322c6930ad3d0d35e27d911015470e 4 #x-299a4ba1552424fbff98555fc5b5e924d637d057168843239d 3 #x1102cddc49b591e99202cd305d431ebae359190e53715564b46946 2 #x-254fc5bfa2cd3b56a73d6c3dff5c6370231d7ed8beea7f0c5b00a42c126 1 #x17c77fee8538bb15cc236fd485ec80cb8117d36a8d97306f2843aab0932c0 0 #x-16621404a15b232e3d6ec0badc1e9db26a0a1a495d9da8f73eebc6a4bb8000) 46 (8 #x60f34a5d27def60 7 #x-98821ac249415eca56ab8c077c7d 6 #x-710a4c0c68f18181f9858ddebddd8c52d45ce 5 #xbcd52f24da046810c044726fe4b471d6141be16a639e 4 #x259118596118316fdb5889152a222f06fa2e1985edafaa54bb 3 #x1ce3142d48935cd24e555a194145a44830bc2b5d4e2ebbabe6f4a0a 2 #x-1a80379d3e10203abaf97e1fbffad256c65a6a719c35fc29750330368e8 1 #x-12f87424a0be9157f2e11292fb8277a2b5429c94d66ca2168b51546db1480 0 #xf66b63a887d85974267dea20bc1099b7c28f5f89a8acae04cbc485d030000) 45 (8 #x18621b6d502d4e3f 7 #xc0fcc4c53caf2fc449755c81d492 6 #x1eb7da7113bc7e55400c9c62c0307d0b511d3 5 #x-8f69d89b88a62aca76e1e8da719edff0c7376015e6b8 4 #x267345e75c2050f436d975bd84a7436d832ace225b53734745 3 #x138669eaa5dd3c960dc1e62c95cfe4c49d7216914595e48597b3512 2 #x-4217aa08ac4edd868d0777d5b64711ac408405341f8ef08e0e4df7cc34 1 #x-1959c020e841ca981d19955fffd4a173065335e2ed567c7d488b07a5d4dc0 0 #x6827ae0dec83c3c3d14c4f12184ce3ea2c1cb9364d1e79d996b07d67b00000) 44 (8 #x2e8d725dc72f6a92 7 #x2d8a4c4ae458829a57d6648c6ea55 6 #x6fabae94616d873850ae3ed396cb214f9b6e4 5 #x-f2d3145e58817ee73d6a5519fe81de63f2a2bb665823 4 #x701b8be027f8e7d720f2e1a47cc61799534e0a5c7855bec52 3 #x-c62125f734060ffa4ac8f88ed22872cae23780361aa29b74387c6 2 #xa91dab76305db07b983ed5b6cbaa60c95a47457d0afdbcb4873c99d0ba 1 #x-e07a8df0ef6ff12f7f7ef9637787c3e0fc5f296600ec055c8ff5d50a7880 0 #x6dada7258ca369affdd6542eacba1ef844d46405dc6e095d6c5d1d49d00000) 43 (8 #x-5d31bf9cf901a129 7 #x1e56e6625405824906f3acdb1f9e3 6 #x7475015e5447d0ea382986023587d9c05a041 5 #x-67df61f6b6e4c4a8d25150dd51a89d37ade885c3da96 4 #x-a0b93057f241546a4a25f368355c6087e8d2fb5daa3bd9233 3 #x-9acb689a1f12080a6f30751deab8f42649aaa6dc87a72862ebe51e 2 #xc025346b4450ed893483eb526f1a05db59f8c77ac54223d4751822da52 1 #x-33bed224e8cce0316259de92a8a63a5b91df5873ddd4723c0b13334b6800 0 #x32feaf729ae90e5088d467eb495af2452df86a13952b5d1e97dd66d0800000) 42 (8 #x-37022542a66eb3e99 7 #x-47752f4e1f787763d4917cfb209b1 6 #x6093dc9c63e19803b6a250b7f90907eaf5ca9 5 #x3ee0f6b6dbb72cd46a142d9ecb0bfbe43a06ecd142f8 4 #x-759c3ba396af7bce9bf606ca7d1ea56999c654a3258a25c23 3 #x-60cf66e717fc608f1dae347d01e8715e56bc8157c4ec026c72e385 2 #x5c62af6c5df864a7a9623ab82e3be10e308a9ae6991a46bacd07afe08a 1 #x178c3ecde9f42902e25ca000dc4fc7b4df2adde1542d132c1b784fc2a000 0 #x-ae8830c73ec6c69e1879912df8c85957badaa148783425ff4d7c0a900000) 41 (8 #x-7bbf1b69a8e07ae24 7 #x-9c0eb010cfc98e014fdf43228ba78 6 #x2905bd1452a197275cdcda8435b8ab866d92d 5 #x68b345f7b60fa91bfc2b3be7368960263553147a8993 4 #x-53027f67f7643baf9e58a597f02f1b8f6b9c639cb5892982 3 #x40303960a8264ebf033ab62f12a69ccb1e0c2dff467e0f0384fae 2 #x-74852a035abcab3c14b1dcf220215a252e13802acca1c3b459901abd4 1 #x23787d3371511a39a873b1673d6fdf5669319f7caf72b47f2c3907234000 0 #x-120c087bef753135feae642298e980b0ecb5987df3c185740a65f1bb400000) 40 (8 #x9639b08b0cf1a7605 7 #x-288ff54232ac291783caa4fdc4c31 6 #x-50ba5affab208a1bd5d90e3b87e8683cf468d 5 #x2aa189297ef57a385d953502a47715f8febd4415f616 4 #x1d165dab82e82b87df185b60fa487874ad3aa673c632ad1d9 3 #x2b2b60b2a3155934e45e6fb1f93e246a0b01ca50fe4aea9804c249 2 #x-2fddbaf811e5790bc79728ea692f36339e4fa457ec66e0f98ef1e40168 1 #x1bff9651360ff2f34ebabffc216fcf5135860f655c9d73dd00e575f44000 0 #x-f794301109a6a2e33eb80288330a0d1b2b3df4fd8447d0cdf91fa00800000) 39 (8 #x5e70e643af16ef6a85 7 #xf0884d8711e875d20c33911914c27 6 #x-c4eef1ba171cf36ae6b3a57432fedd6b06c60 5 #x-1641f51d76c7c7e8e402057609ade85320ef0ecb5eb3 4 #x7f785175c19676c653d06e8ccff6fba70526decfbc0b5522 3 #x1a1e1ce134d4aea39574432523925c59d5181381ee5daff652a34f 2 #x-26b6dca71c9b6a2c21fcb55a8810d9d50a27cd27478e2d2ef220251460 1 #x1261243b785051b5630145d7020de427435d83059a5baa12d05348e78000 0 #x-a713cdeaccfc2dee3b0707c436549a34aee7e57e382de99a6d1e12e000000) 38 (8 #xbdca0eb1bed25ce8f0 7 #x14725c3b5508c521a6d82d481683e9 6 #x-afd37f53144a766231d15b5b673a342ca7f7e 5 #x-233ef1f34000e3b41d491438467995f6d4c81a4c5602 4 #x-7e7873b3b2f759ace4511efdf6d5d2dc0dbe8d47dc9f1990 3 #x-38e2914cdeda4ae61764e4c4852b000b58da8810962346a78992 2 #x-e06a5160cce1d987a502e60b756c1c938c79a1325a2a312c59829026a 1 #x964714ba5da1338434a43f2830ecc0624528419a55af469f374d9f20000 0 #x-7b853d54397fc1089334ad55dbe3b6b9bf3924cb1ace98dfcd72e45000000) 37 (8 #x-5f4a94fde09f0793ab 7 #x-1ca0d886bae10ccf1d56129d2c920 6 #x-26c1f595c74b2aa03326c5cb366855e63a05 5 #x-d323732c7b6142afc3d93afa936cba3030a79781aca 4 #x-360e4ffa75c3773efbb1e679d92d32dd1783d7f892afab48 3 #x-a38065a37270f6fba21cc12a88e484b780813022f11ac54f3b7b6 2 #x2d2ec27a81e3dc28212964ce607f17374a5992e6c2e15d96855256dfc 1 #x259a09d70db0070f9950c8ecff7e943865db758e8896c02085582d90000 0 #x-598cf1ab47b5356c3ead5495aaab8d1a1e6efe836a40c78dd2adc92000000) 36 (8 #x-45c9d37eb12757f4c41 7 #x-1e23152010504f9b13d57e0baa7b5c 6 #xac1185459b0c179c8a8fcf353db1171932c6d 5 #x6de05bb62f08731602967db1bb313d3db9b6cbdc378 4 #x5346c54356fe2963df3e9da8d2d9e092dd8de4543de8ba4d 3 #x-6c887fdaf77ea5a90c14e7f8f154e7f1af73c2a37b4a216a0e8c2 2 #x7550a0244c7aac1090152da47a43f07ee0ba577c068cea8f00a99ed56 1 #x-16a25e0d290feb6214f705cfcff46160903a7df8696e0e3e7e3951e8000 0 #x-3253597ce0ed671df332aea9f7916a211f5e5bf5930e792051e9371000000) 35 (8 #x-65e622c505ecff50752 7 #x-1a450365615a98f049c4889d4cb944 6 #xc122b3a90344572fb9cf64dc4485d1c791af1 5 #xa3878896abce9ae2720f92c40e1b60c5571d382ab45 4 #x653bd9e7a83d4cbb81ac19dbb4c806e14f1a83989f544bf4 3 #x-107b20eddf27f5f0777d0a9e606c424efccfc470970006096da02 2 #x502db579bf731a699025564a63f33ef2d2997616a380ee00f04732500 1 #x-23e4a363177e6e1ec24c42d4875951cf40c3b2d7434a227906d0e240000 0 #x-1072d01578c0b226d977fab0864b554f7955b66843e9db3893dc090000000) 34 (8 #x59d59e5cf4979355da9 7 #xaed465089db8cf4fb740fb5f802a8 6 #x428b072abf83b4330bdc04d8df39021d58535 5 #x43ce48e20a9a9bcb06e6c683fa0ff3080634ceb55de 4 #x26e2eb02a984d72e1a83ad76d554613ea747d4cd5f7b1fec 3 #x18c7765fe19ea0cb01e311cf5c4107cd860d3bc29cedd20a91550 2 #x1b2135dabe403b013d069dcb1bfe601672ce8cf1b5b608023e7f7c2c0 1 #x-1aa30197e549df54ae127106bb7b4e6d2d7b3531e28507a5bca5c700000 0 #x2cf16f24e394c5a91f0d74088cb86378b0bb33039f48bc66940480000000) 33 (8 #x1cf6b5260be0fa9c7f72 7 #x252fb6dc41fde283615bcd5ffb049d 6 #x-47d2d8776bb271a9a9025102c44b313ad64eb 5 #x-bbc4ec352cac31ffa44767ce2e73662fa0f7416eff 4 #x-62ef0a6b86ed5977839f5dfdadd2977cb319c096fa50f44 3 #x16c2598ecb1f531c61419e39dfd17832f5ec7c38a7cb3f5913dc8 2 #x-243875d42ba444a3f8be42592149dec9ee6b0c613b26f6b9cf337340 1 #x-ed8a6cbbe733652b2bfb7f0d93fe2b28f5be608f8ee2361efae4780000 0 #x93e7e35c6e1bcc7423a4e368534bb4490406452aa37ef91672d240000000) 32 (8 #x1786447cf5423d1ca87e 7 #x14a686456135ab9d1ea2b20723914f 6 #x-708e419d40c69256e1ac05e1cfc39b2eed45f 5 #x-1aa9189fe36aabec35f41f2038148032e7930541adb 4 #x-48a49cacf5f22b2bdc9e0d643a6a7dc8431db183e40ca17 3 #x94b56a6ada9e80c2508de49dc120aeadbc7dc63aeeef9e413778 2 #x-919b3f2259bf0dc97134603ee2a059b9b564f9b30875977c5466f400 1 #x-75e4d9061ced8912b701f9692290f24c2bcb5c7822c8166704f6d00000 0 #x9251e03cf7a6a8718cb95e1de7ea61a2beac8285e96c3f1e764000000000) 31 (8 #x-2b430daa87f7eb5154fb 7 #x-feb0e273f9c9f124db7cd4e0367f4 6 #x-3da75851a4706b34076c38e4510158e2627df 5 #x-a80017177f71b9a72213d91dee180513e62785c1d8 4 #xff6b69cd5c8dfee5a423d47df4675a4223d89f0fe1fb81c 3 #xd1683de4cfe38a57f873ed64e916bd5c8bc79fbf5141c95ed26 2 #x-635bc88fae8c622da9b6cb55746fccccd3673bcf5a78a8004061b200 1 #x-36b807a5971a73b4f7666a5357283e7cc8f3dcc08cdeb82d4d14000000 0 #x70b762961d770a0cd8ec56a4b52e6104e1c840ad8a735283a8ea00000000) 30 (8 #x-65e990148e304664c268 7 #x-1cbed11ac9d7e8b369e7ee5165bcde 6 #x5da891810825258674660ebb328ea440302b 5 #x1f261e18f2c37b9e887e0a7bdb23c07c96073e5380 4 #x1b147c735dcdb720cc1aebda01d2ecbe07595704a6514305 3 #x-1a274062b13b401b4e4d2d2321808b0569bfb263d2a5a22270a4 2 #x-26486aa6d17fb19959c24740b10f24a5e7d0329bb1c9c423557d5180 1 #x-130a38985054201bb652a18bbb611f15ec1c7fd20288af9ccbe1000000 0 #x4d2ea7827d59820149c6fe57db7e32658c4073f9bc61aae2c37480000000) 29 (8 #x-165a4c3a1f375db8dd15 7 #x-9ce9884b168fa5aebb82c574cfdf4 6 #x2371ff8b79dc4cb0084a62bff7043ee87f1bf 5 #x332969c98e31b26802779af582f6ee587a59702ac0 4 #x180d0431f35e9997754d062c98fd997891286f5307f1d818 3 #x-1779784e4cc35bf841cb8bf48774b9dcf55c822667bd6e9d252c 2 #x-5c7ffe28d3de7a195b463cfe4def23f045661665c48be07860aca00 1 #x10e7eeef4366bc0afd4d1a919e0dd94a57009f9a7db4bc82d96000000 0 #x30432d9167959a19b23f4298661471bed845879facb6502a982600000000) 28 (8 #x9e4be9ea27b889c8a444 7 #xbe49a0749d4a5b71c76d2d12ec8f6 6 #x1ac8c0c88721d321641e2a08edb5dc880a992 5 #x193f1aa5431671d76d67f1a6fe3b28ff75f433ede 4 #xf6bedf2d639e8f7032982c5f35b193cd2a54251bbd79f53 3 #x-dc16927f74c2779348f3740381238da6761cf29bddab0dacd28 2 #x38b2101128ac4e3d6304647c5a6f3a8f28bbf01b31288bf4c55fc00 1 #x8fc85c3c3d774545318122e513cef6da5303ba2511174f1f934000000 0 #x1ba670af0e37804a9da3b19656e119c9e61dfe7adb04ff0d55dc00000000) 27 (9 -1644 8 #xb52872af1a8b8633e69b 7 #xdeabe8998280cb20234f911502484 6 #x6ed6c086a356a9a4c042cd0c694e50038879 5 #x-1bc2f8e1221fc97f019de9906ad9063ea81564f063 4 #x86815ec1f7e4b3f72d9d0d009b3e93dfa31e7c83ffc9e06 3 #x-6bd5d2d3408b285d0e402da77b3f4b5a4e784955e8aab788158 2 #x364168307461e730f7db548625f7b3d17bdf65f3f093f3064292000 1 #x8e1668b60421014dff6e0ad1174b35427a17b0c028ff5d90248000000 0 #xe9c81d60ac1de880070a229a63f743e7ec80621dc362f20433000000000) 26 (9 -703084 8 #x-443b3ed94a05dfb0a5c4 7 #x2a1b7e6c8e38b391956dfdddad9c6 6 #x-49c07469869fa4e4d5fc032aec0d05a48bae 5 #x-18af0f3bb04112872ffa77dac47ea6de31e818ec9c 4 #x49f8156f7dba47dce26b0672ad9f04b95bdd0a8277e5f6b 3 #x-2afc3cd1ed5846da6ee95d51e243d4991cc880260e3efee1e34 2 #x19b0242d3fb30a7718921ca8ccef7c8fbd2bd795bbddb3ec3c36000 1 #x5b143dfa2ce12ae78e9035267b2d2260d9f338008db6bf80534000000 0 #x7374e610443df2938c4c021415c66a52508f652370fc35de8f000000000) 25 (9 1504260 8 #x-11edda43d8aa025b3504a 7 #x-52a785efbb42496a7b130ee0b428b 6 #x-5bc73ec050466fc7ba58233361bb1e730fb2 5 #x-a2020bdbb068de345584480844acb74191b68c57c 4 #x2d163dc70a872c5bc3c85f8d5757ed5cba1ceab9b4917d6 3 #x-a11664dc31026f05e72595ca6fa6226a79aa0f0aa73c98dba8 2 #x80444ff5f02572e7850743102ac2f7e98aaee744ed5f2fae66c000 1 #x2b5085f7b1b92f5811fc58eec9278cfde13613316055c0daed8000000 0 #x35f7277761f745d23e96468126852cba15d0b97ecb9470b996000000000) 24 (9 -52902002 8 #x-91317ef2e31df93e95b4 7 #x-43e88b0c831ee79a4f6a6e1228877 6 #x-2aaaf3ebcb9ccc761ccca79be19c866e2c5e 5 #x4de611db4f18ac0996834d9d5d76158fc030ead9 4 #x1c277eaab1a5c240684fda5e1af0fea5c62dfdefebdea1a 3 #x29a5e7a4b7169d922529b993ab0de279e9aee7858705bdb88c 2 #x175c15a0e41f6f9d212ccd7acc86888fd8c3a8b402a859fefca000 1 #xf66e39f7c25feb5493d310e7efbfd76d0375adb86323770edc000000 0 #x17febc441a031d60b0131c66e4cc4f9e2da49838daff315fb9000000000) 23 (9 #x-4711FA92 8 #xb85ba5e88d0f6b38d762 7 #x-5d67ddcece02aa9f6c67c5edc3d9 6 #x-3d5a57ef1d72d255b0892b1412dccc94e98 5 #x3a2ae1a7e5044b79f18c93223ed9c30f8454b3371 4 #xffa24e91fcd944360221ca7276e50da6f1ba43f620d866 3 #x4ad658e3f92c2095285f9a6205e353cad549bed47051d35b40 2 #x-e043d86907ad466b3299718b285c821e23fcef91e02c13590000 1 #x3ab09cffcc742de643f6289d65d557b61da7a083b5dc0a0800000000 0 #xa1eef609e3ebe3cdf3287c4d1dcf2e0b116a326b33847d5e8000000000) 22 (9 #x-f0a7624e 8 #x104258d52c639decbff45 7 #x151ac96ad75b6b663728080c7ec3c 6 #x803bc30ddf97b0a38e424c3fc0c352ceb2e 5 #x2e9d75decd0abd7dd146a2daa4b87327be9285657 4 #x7c2aaf2ae2ca80e8bd842e95f0162f7d2cee95b31b0abc 3 #x3270d70e1595e80f94459b375ace8bb803dd5d4aac4096a180 2 #x-265ccd969187969aa9b134dec719318d17124a7bfc8fc497a0000 1 #x310b8d47e75adac9c266d254aa1135abe7f2e5609b2833f80000000 0 #x4074cefd6faffc2e630c7fe74d93a424ab8a644616a958030000000000) 21 (9 #x137dc3f90 8 #x1924301d67b382cd89d0 7 #xcdf8d022fdfcd8056f8169b77435 6 #x5cf86347e1210f1b878d13f262f18d31da4 5 #x14eff9be8fb2225778cd8e42c0f3c479e736c6106 4 #x32eb4134eab1c4d35588f9dbeb0338c7897dded3920fb8 3 #x17a4e185d07d5ceb4e79c2bf73bdab47b698d316121814acc0 2 #x-eca2421b74c8db49f13dddfc914dbd20884961cb45a037040000 1 #x-58493dad4b166ed9685ea273061796bf24d5d23951a0590c0000000 0 #x182985f8b740e53d705e6848bd4e1d7a0a91668c0e5d57680000000000) 20 (9 #x76638d826 8 #x-a7421246b0e44d0c6123 7 #x7166c28043654ea35a8f40f0ee5 6 #x1da90a7c57bb5c541af8eb55fc0e5a20441 5 #x40b70e213f81bb2533032771eb7cde66070b708b 4 #x11d1874917806488cae8c665c41aab6718f5a1e0a03870 3 #x881091b4e8282fc44a2a9dc4941651a72a1d972fc69c8a580 2 #x-2c5afb6f5d1e1678765ffea09488002f184c08d25830b7e00000 1 #x-38ffb9040ce945162daf32bf94e5ab6fa16db6ce61f70aa80000000 0 #x88be77a76e8cd3ecb351ede56d065ea2db29f1eccbe03300000000000) 19 (9 #x-61d862e9f 8 #x-70730968aac032571ff9 7 #x-2ebdcbfc213cf080f24e9d87bc27 6 #x75ab9c15b5a8a08bde3e8248b756be0b7 5 #x-208a37f22bbfaa1cba023a9634043bde10ad6197 4 #x57d4bb83d245802ce0c0ab244e752a3f675d6b2c59ca2 3 #x263d842783f62374d4c727642fb351003997b677f9ba76c00 2 #x2b04247e7c58ba56e22e33805ce03b218395e52a0d926000000 1 #x-16ef897533f2fb72d28c44575a48d96115a77766ffa91a800000000 0 #x2dba455a0cb72b8fa8bf70b2f95812167f3c87918b4a7000000000000) 18 (9 #x-268a9f9228 8 #x1fa05bcd6f3d60480127 7 #x-14bb94c7997a391786dfbeb4f5f3 6 #x-441a56406d2bde61f896af5226eeb230a3 5 #x-262ec4045bef41975ecba51c1f41b898c736099c 4 #x191e10f9f08542218b6550b9e916d773d272749930524 3 #x82332b05533f7bdb087efa7ea26a69b7d4d8484ccec68500 2 #x571a372770d6827a6ec7c2c5f676d39f7e59a03e57242980000 1 #x-72e935c3ffa76239cbedadee6dbd079482f6468fdf8e1800000000 0 #xe68062489979ae5ef30e1f29f39769f21446ef35f0d8000000000000) 17 (9 #x1f1ad74abb 8 #x47d8dac21155cd063151 7 #x11f8318b1ffcc50259f022e06f5 6 #x-22701902dea026b4ad83288ba414915e58 5 #x-147711e63cafd627d0d4bc8d009e88dca04055a0 4 #x70a282620964686f7e1c45a17b1578c0365540b1e928 3 #x121cbc3b7717db373a8f4fd8a2797a0cd0d28b6705c7fc00 2 #x25f3b0283e526e8752c3283021c7f8f0ef90a92847698e00000 1 #x-1e04519bfd54c2fe41dff446c3e7c11da89dca134ec48000000000 0 #x43a4fd20e380a8bead4a23193b32d54bc32cf5db61c0000000000000) 16 (9 #xc3f7b3e588 8 #x150a5e88720ddc58159a 7 #x3e1e329608f8ab836855eb15698 6 #x-8006acf0e594f851bd8fd2f7ae3776747 5 #x-72853a807cc293f16d207c2a5f1da4d6912158b 4 #x1f1ca069b16012b8df3ded7fe8a3f85a3d0918750798 3 #x41125b778919a0c6d85d2cbbeb20e8f24ec3902e5f9800 2 #xb27811221effc4a6ec25c7627e3bfaf563d91403868bc00000 1 #x-6cbd7098c7235836b66a51707ca99b0d50d855e1b4d0000000000 0 #x122db84259dcf234decab02a461339e75a1360f6cc50000000000000) 15 (9 #x3e9f8fef30 8 #x-129c7ae03582417da2f9 7 #xec8a56820ee00fc286318f9a6a 6 #x-cda126f5d17acc3b2bc43b3de4c7c92 5 #x-189755829358b193e91e7b06916ad7983b75d22 4 #x7f5e113c6adaa4cccd4dee648ae0fc7c9165f7a2ffc 3 #x-b756b38790820ee302a867d0e0eaa401360926beaf1000 2 #x2886af37e8eda12f9f4ba21b38e441f179924cb92074000000 1 #x-15ffa23a450222c359a00d2a52533203dd5e60e71a40000000000 0 #x46411e9e32ae39009274386c5df9d2fe8cb908cdd80000000000000) 14 (9 #x-182b8a52ef5 8 #x-fe4992b1dddd7d08b89 7 #x-6bd2124e43ec8538617cba4453 6 #xa06bc276d07b36933d18c5c6b9c2951d 5 #x-c6e47f932ddb8fca9f2bb7c03764001629c14 4 #x1b7b9e5203c31608ae26503dbe6b4d886fd3e71fbe1 3 #x-3dc1b869c1ffee38f469faedef6e2a086516de8e9c6000 2 #x7638c886c36e3b7189fa20f1589312d99e12bf992dc000000 1 #x-414a5f22fc175e3359d6f92a62df7855a022f852080000000000 0 #xefe20752277cff2cfab8368d6e07c944a87d9c5500000000000000) 13 (9 #x-14fb241d5c9 8 #x-12bfbb5938d5aad9e34 7 #x-540afb35d825fd8abd955bf5fe 6 #x3ae205ba4c716c3a56d4b833c4f9ea8a 5 #x1d1ed68b5c1fd121460e5234c608648832d410 4 #x47372266e307c280d64557035b67e7e8b4b87fbc4a 3 #x-c3d8f4c09fc5aa7c3020a94030a6114e01f0466120000 2 #x115d653e64a6580d1550c1bd898aeb7fa5e3b8f6a00000000 1 #x-b42ef24c3e3f17f326d8698302ba5a2beff9c46400000000000 0 #x2c942513aae9dd705e9452491f2879d383c19e6800000000000000) 12 (9 #x13db8a7dfc5 8 #x3f5ff91c3697311365e 7 #x-12103c4709bb9d14600abcce6f 6 #xd7abbbaed9533c3dad824ad4db1fef5 5 #xdbb7f2435a835eab13e03bd07bb57f6bc27ea 4 #x68c0bd0d19d8f1c9881efdac21328f40e743bc821 3 #x-193c91f3f1e65cd1ed6708baa8f34e6c50f1b5ae80000 2 #x1ff14068ac275004ccdb1b859f37c01ea7421e8440000000 1 #x-1ca4a52ad176603cf32ede4046e10c8954d073c000000000000 0 #x72167fa6763d4bc66f2f260b6d1b1eb2691386000000000000000) 11 (9 #x1c228d5722e 8 #x2117877140be3728862 7 #x3931ff1379bfbb83543e8066a 6 #x47e675311b73d9e964ecf99294608a0 5 #x3b69b5eea32e9394b9854d47ac227b5a7c06e 4 #x-584551144e2c7eea19e385c9fd38e5aabcd841e0 3 #x-19a1d37be4963fbfa0de3b6f7c393c0339db85300000 2 #x2922eb5196b4472b54a9f8754d0d0106a4f04fc00000000 1 #x-40a9d3ca2c882b9e124551d6d8207842175aa4000000000000 0 #xf934db6cacacfb96b76507820fbd29466b388000000000000000) 10 (9 #x-75abbb1684 8 #x1f16225cdee4e16a7b 7 #x38e39fc8d6fa154841da6b822 6 #x285e12a3a9b1216c715c89e9684d556 5 #xaa1551e907b33f59a1acaa91ae3308d2005e 4 #x-3ed68b76f8664149a3624cb474a31e8587030be0 3 #x20491e427857afefe5d8e1b7bed3e47145b83e00000 2 #xfd51e1ebcfbcee2241015a0ae91d98a5bddac00000000 1 #x-78690c2dbc1f6c316c5a8977256d72aa70ee8000000000000 0 #x1cee8c2e13ebdeb949affe668e1cec15684d0000000000000000) 9 (9 #x-14748c04d79 8 #x-44fa28de964dfeebf4 7 #x128d055b426c6be0e79206ee0 6 #x131b8cec1f81a0c8bbf0f550506471e 5 #x121d18969770612a17f8a0406d0dcf2a5c58 4 #x-b38f3275d99ced68bc21bb70de8af3df0605800 3 #xc1b39b7a16601baa86321d408294a1090808000000 2 #x-655f4ffcf3e1934a1a2429f806afc17f843c000000000 1 #x-9c4e7c57dbc503a7dffc5cf32182518410c0000000000000 0 #x2de111f11d829d6d829fccf36864db8f8980000000000000000) 8 (9 #x-e8de3b2b8 8 #x-1b247b8dc5a6951446 7 #x35a8af1edc731b265a55b696 6 #x6941de554c07fcee0a44ffd15e7a43 5 #x300181d8192013d9f078336880a8a96f40 4 #x-f1f1aea03d1091bd490e919e3496dc65f00900 3 #x1947114195187013d7f09ccd871fe065d544000000 2 #x-18b7834b0046c34ac7914ff11f48d589c5a4000000000 1 #x-279734f2066103a16ee62548152456b7e00000000000000 0 #x3eed148d325e47cf7004d5431b1dd36bd00000000000000000) 7 (9 #x804a8bce60 8 #x-cc834115441d80d0 7 #x4d7e6edad8b406afb45ff72 6 #x1b19b20f9d1f243ae5ee5456f4b300 5 #x-51c0c191bbe86b2f81a116a248e888b940 4 #x3a630f68ba176327786771f16a3d047384000 3 #x1b2a733418608400aacfc4ad1c761e51590000000 2 #x-38ec9fc815830024e2e8a4bd382ba101540000000000 1 #x1c399c533b6a93db54db97efe3054525400000000000000 0 #x4bdad632d208260b7e5167d547947f2000000000000000000) 6 (9 #x11388d2480 8 #x26c2bb1efdd4be61e 7 #x4eb67ad75ea427e5c923b4 6 #x56219932142ea7a96e9651185a2b0 5 #x-fe230e9b228456274cd0d5a6210400380 4 #x3a450779037e0782b7a0b349dd719aaccc000 3 #x-df390aea9af5255258963f79ae8caca0000000 2 #x-559ea6ed708b53c5e6a8dcbce6fadf48c0000000000 1 #x5891ecdd6a6c36f63016b15f90d5144800000000000000 0 #x509392a65c6c81bf5d23d7fd97f888000000000000000000) 5 (9 #x-23e5f4dbc2 8 #xd2e2949dd2633b0c 7 #x4a4e5a70a089443c784ca0 6 #xd6a15db8c0b81c4df2bc2df4c140 5 #x-191bea642937813a9c8997a783101ec00 4 #x77ce00c29405517a802e443e2d8b8f9a0000 3 #x-470b34fbd66ec93157449893950c47a00000000 2 #x-2f8d4e3f9be211cf84311e4372de2a000000000000 1 #x98728cd0737ec5d54aeffa19185da0000000000000000 0 #x4a51378cf5c0be477880811b76f50000000000000000000) 4 (9 #x-8fe331234 8 #x19e174ea7cfe8bab 7 #x264ce3a22b65fc1ea47380 6 #x1a1e7e66931e92273d86a5144f80 5 #x-138351904274dafbcde20103e5a33800 4 #x7ee29a7de19543d0128574277d987ff0000 3 #x-bc9d933f494183dace1da3f21ba83000000000 2 #x89a085efbd74effbd2225730d064cc00000000000 1 #xa14cb129c35150e43eb67b1b46408000000000000000 0 #x3ba043aa715b7e9c8335042930b0000000000000000000) 3 (9 #x429a20714 8 #x-104393d758eefc0 7 #x9fab38217ca434de460c0 6 #x26897639c71f9d0ea1cc652e200 5 #x24a14907a285483e5d1cb1a0114000 4 #x4434f9a94d883308e244e6c0a743a00000 3 #x-1479c265df58f7cd77eb292ab48b5000000000 2 #x1a8b5521404e6460821610731b964000000000000 1 #x5780d02609dffdc0327ed5ba69c0000000000000000 0 #x2a9d0052ac429ea033833666280000000000000000000) 2 (9 #x161697a5e 8 #x-559940a0aed870 7 #x17e4ccd5f6fde12dec180 6 #x28325b79295cf67b82994e6c00 5 #x13ecf9668a406fbb09e205753b8000 4 #xac818ee596e14dc4e0512723a4200000 3 #x-17f9cea404eb383843b9dce5ae3e000000000 2 #x2361be54d9a338fafd5f428e956c000000000000 1 #x-4fb818708c902f722b1dad9c00000000000000000 0 #x18d462f4fa6989db526cc3ab00000000000000000000) 1 (9 #x-E4F20B8 8 #x22680912f5d6c0 7 #x1f1c43cf472668cf8a00 6 #x19f46ad7f60b02c8a913b3000 5 #x11234b6465555b5bfcd8343340000 4 #x-2421bf84ec411d7e6a32d16ec000000 3 #x-109be9932b4e1fdbe8364eba580000000000 2 #x188ef3a806726c2fcb2400e06e0000000000000 1 #x-21252b601fc16330509bcb5c00000000000000000 0 #xa9c77a9d5cdbef8171e72800000000000000000000) 0 (10 1 9 #x-61EC9A0 8 #x906e8a13a3080 7 #x1083641c6a62e738800 6 #x7a88cd1d80844e0ac9c1000 5 #x52f14863a221c5281a3a8980000 4 #xf596a9bd007677898dc5389000000 3 #x-50bfdbc06f9a6875072ff9040000000000 2 #x728748d82a30718a5d0a49d80000000000000 1 #x-c3d7b7aab731e4e3ee65b000000000000000000 0 #x572cf3fbc9cefa5a4121000000000000000000000)) 
  (svref *ec-g1* 139) 
   '(140 1 139 (4 -1 3 2975 2 -2531450 1 560377626 0 #x-1f8e75108) 138 (4 556 3 #x137a962815 2 #x516888d368509 1 #x10804d5b265a6408 0 #x14befe976b13d50b8) 137 (4 -146367 3 #x6e74e5395f0f3 2 #x-32fac688c8e90f833b 1 #xa53f797cc398138ed072c 0 #x-48bdd8cea6148da080796afc) 136 (4 24271763 3 #x44579329561b4746 2 #x9c966db9be5bfb6697970 1 #x2e29ee50bb3db28ebf97c6da5 0 #x41465d00da9ebe9a4c3c69d1080) 135 (4 #x-a99dfb19 3 #xb6b718db677775cd51 2 #x-342fc818c384a996fcd23843 1 #xa6378f8127a19984e55c6d44e66 0 #x-131b6a6ec132d6d2dd940180503ab0) 134 (4 #x3a6fc6c8a5 3 #xb64ff22aee90f391aed6 2 #x33d5985fb3908556ba5296a739 1 #x-107c04a26cf99495c7975a14bdf7d 0 #x1b294725d9f767bd3d3b92d3cc5b9bf2) 133 (4 #x-fbba96de9e5 3 #x4d5f65748f03e00d303c1e 2 #x-d62f2a9f42547757e0a7212f0d1 1 #x7b6302723aa60da6f4d1ece5d2f3aa 0 #x93f303ce26d5b0acd821fad1bb1ca40f8) 132 (4 #x365083306785f 3 #xdf487ab31fc4c72bdd6b2e5 2 #x144adb59a2a7034064569e2695ca9 1 #xfb3f97757e42789b18e29504ee6c07 0 #x14069bfdc46524a0c93c71e9ae44f852f94) 131 (4 #x-98e6396165b876 3 #xc5b2be617d05bdb798e06710 2 #x-c83b85607521f117c24aeea13ac53 1 #x-2bd075d4c9c87f4f1a123cbf764fd4b4f 0 #x16231e41e4d39d860066dcd7cdf2ad980074) 130 (4 #x16340a053e452da5 3 #x-ab0495c0bdb5ff65f9f841d23 2 #x3488fa9eb0f95b795a5be5564f53c2 1 #x-2196a3adf38f7bbe736a9f93e522d12912 0 #xb0b2b2676cf130eba6077b22f72f323a2588) 129 (4 #x-2aeeef5747e87767d 3 #x-100c4f2b46cf0ce8487c6bfdf03 2 #x5946c29f2907235eef714e1d20b0beb 1 #xa1e23771b1076ebb56f8a0c9ec428a137d 0 #x-1593c507b47b821dcf2e14f9610f1740be490) 128 (4 #x45752d87ad988eb266 3 #x5275da3e5c1f209a44971114d69 2 #x30e4dc5ebbeba3c18b78e26334abedc8 1 #xd09cc0580ed5a4375967357ae5b78cb2111 0 #x-44bf0be62263855750d889a6f5c6ac1f3ec849) 127 (4 #x-5e44a07c24d5decf435 3 #x7be10823b3eb319444fa4fc89f4f 2 #x30a5a55175f25e351ccfcbdf17ac954b8 1 #xd31d95c84c005345d09ed5b835a46169fb5 0 #x-151cf20c053adffedf02283521d4ba445e7a7a0) 126 (4 #x6b58b9ffa72320432543 3 #x-2120e6c9352bb2abc915a58925286 2 #x18d4b7feeec34b6b7b94ddb6dba7370997 1 #x-20c175378ac9648dacbc9e1ea29c992718726 0 #x81be63bbe03715149e282ea2e2471ee6dd09eb8) 125 (4 #x-6648a0b1f9e83e2ceaff9 3 #x-1ef335fd1b516019fc25774159bf65 2 #x384f3f3d77c0cdc8a1ffc5778776fa378c 1 #x-8ae4385a1fdfea0bb581edd78b0e30e80a960 0 #x539a74fbf625f06914600007337fb409ccc59488) 124 (4 #x5105b037fbe9241a19c343 3 #x86e19aa4d63885a549161d00bbd65f 2 #x-1c2a6f5c5ba6366a315fd4af85a5cd8d65f 1 #x1ed640b607918761039c88524b8cbfc2e691c5 0 #x-2a9ad60c9be064e4187880dc475999a7ad124682) 123 (4 #x-34b51352065f491b86b4412 3 #x4bfc82344298897b97202daa4a403e5 2 #x-e646237c3f1e6e13de85ee6a14fc426e2bd 1 #x12eb1c4d5bd9b59798b15a06230f63959d103f4 0 #x-98ebfebfa56c9cf6ca94093c0186273dfc287a460) 122 (4 #x1b872357d578aab485610549 3 #x-1562167589181852b25a0fb8c700769d 2 #x-164eacd9d20b269f7d3b18c69eb8599776b2 1 #x105ab7bde1a26289cbc7596b3b255ae65349cdd 0 #x-fb039054a08b494e128e4924b60841e4ced4f5144) 121 (4 #x-b0646302aa6536c41903d4ca 3 #x-81f27c9ea10cfe2433e448b35502a977 2 #xca2a13a8c8d5cad6e1ae755844396f9f200b 1 #x-12dabc7adbaea3b5f207a2eb6b002f7c729a7872 0 #xa422c43b24dee765bb5e3fd949bc3d3259f9da2a08) 120 (4 #x301fedfd2b1865add32fc3382 3 #x24c4aae2097a57507a73ffd1bc56072b0 2 #x3ed27d9dfa2974f3467a6027969e0958de69f 1 #x-48b6575e593a4bb16e1002d2edd8d399c0649465 0 #x22e7e4bc76d57150c1c672830438f39bab0e4b2ab6c) 119 (4 #x-4ca8929c96e18626b080de8d4 3 #xa86fe6f8d1460bcc3de11481f73026343 2 #x-1fa5ee68b2a4cabcf8dfe155ed2da1d9663f5 1 #x5ec2d5f0fae2620591c0b12395172035f14228d6 0 #x-65513c0e902d0efd54b8dd3d0f6a4faa11e95d277b8) 118 (4 #x-2ce7bcee229a3d772b9f284a62 3 #x-2dfe925045ed081f2043171152c18c929e 2 #x-380e759b223f76530595d277a5716e68cfca30 1 #x567f25831c3995119d7ec986ac413a298f6e63777 0 #x-27cbec84c486ece5c50217d43e586a232b3157b62c84) 117 (4 #x19913ef887fdd9536e678128b6c 3 #x-aeb5c0e645b2977b8ac9e7a171162400a1 2 #x-4dc2749d8dcab3f141ca6ecc0307cf5ec05551 1 #x822a26f89f231ea56253b134e645d80b42dc51ff0 0 #x115796e0c2de08f8884e74b7ef29d2064832c3c1ed10) 116 (4 #x-5619cf6802383876d9aaa673f70 3 #x2bf29f79b0dad48127dd1a6d479e43cc8af 2 #x1b5608da29fc740658030bb9cf5effeb7c77784 1 #x-38cbab73e6887cb274ec695f4ecd2f8a9c094905b3 0 #x1d3916ef5c7f5f24b09fff64650303bfa6b69b8a84f73) 115 (4 #x-48064a12b8a38ef7224b3e24b3f 3 #x95d0f8fe6226037512e98c27d76b97bea74 2 #x4eae60614aacbb3308e9c3b9f60248fa7231d93 1 #x-d784640951408bc0d1be9ec92d566e12dcd70c4fba 0 #x1fcc606287f1a87a5c5ab1c17279418407bc422e74710) 114 (4 #x77e07bdcedc973d83717ea88feb0 3 #x-2127587244560bfac3857774b6ee1b31e966 2 #x-6514548a6426481c85123ae12c05e7896da616d 1 #x131cde29b53974e99d11b2b20bbbbc256982da73d15 0 #x-e1359474698a5fe97941c9d99202d1217cf6852b37338) 113 (4 #x-19de8789a875127be53a94554968b 3 #x-6c238a33cb7c54083d752db26832cc6eac27 2 #x-25f8a070628d2cc9fe59180bb051ff9609424766 1 #xae46c3f8835cfc2dcbdf7eaac009180254546ca827c 0 #x-254b8a9fd27d14e370fbd4f2e0069915612f30a41e891c) 112 (4 #x-1609f9dbdf9b51ea7d5f9cd197887 3 #x1433521d4e6547ff84af0366aec183138bea7 2 #x-15b7c5fb57319b81a171274f87e2402282a87e67 1 #x2638812c215a963de7a21291e8bac8842b7eaeaf20c 0 #x3aecd91e62d36ac7edceab88294a079ac6b7309380ddc2) 111 (4 #x1ba8782ec542352a1b84979dbfe88d 3 #x4258b7f2330308d159c18049c04b51e432a7f 2 #x7c4928857dfc5c42fdff8655eed653eb9d7d33aa 1 #x-60816ba822e4e6ed94874f8c7a7a9d0393ef630d8b00 0 #x16a7a8b2080591a8f11a47ab348b69bde29c4e782d46990) 110 (4 #x-3eb84e7df84e07cd4f86589a62ed23 3 #x-a1922411ba11e9cba53daf854ab04897bc084 2 #x20e778df5d1a64497bf3e5eb08a401fadd8cc2b29 1 #x-7943901124cba50c95a4f1f7e62c18798a5b959d79d6 0 #x6411c1b85e39e759ea093477cfd490d72b3e42888195ca) 109 (4 #x-ad8ad5383ea17ea67fd8abfdeb49b1 3 #x-22d0f5b6cbcbdd4d6085852a3adf3f3ace2444 2 #x3576bf53c13d1cb3fd578a3647d0b5447ee1e9df4 1 #x27a9fb5f9657da05a8ce4bdb97b199cded36b4ef64060 0 #x-8db527d268ffbd7774c60d068ff561518855e15a32e2b78) 108 (4 #x45f9378e8805c546ba4710df21d5181 3 #x42f5840e84185a04eaa3366cb5f3bd78f7cc8a 2 #x-11fa2e0e157dd0fac3ed30c23d218ed1663bc8d204 1 #x594bb23a546999e793f9abe1ab3589c6ec1e0dfaaff04 0 #x-ed48257fe8447b19b3303045dc30b672f890560b9f510ab) 107 (4 #x-2242e0076f9b60f8dd3498f14550f2f 3 #xfb67ddfc3272a9fb392b03d14ec430dd7952a9 2 #x-448082a0b79a062574970abc01cea1d2dd30b20c02 1 #x-c3530c99565c8c031a4ef178060db6e71a82d96fe4179 0 #x20bb560a96a4e02ca09ca51950eaa64537cebd50c09ab56c) 106 (4 #x-26acd9a08363d13bfe01c14f418e1761 3 #x-172156ba754d52b7c94e17a8a2d9b075d1f29f8 2 #x6d3d34bfadee44f9c1f946bcd0dab545f2d2ce8075 1 #x-2c3c12d5f0408d27b2bb014282d40a4d98efba369f068d 0 #x817557d6bf9a3ef3eb294817079e9672fca19d388cbfc958) 105 (4 #x560400fcd4ac9d9b11f9e3d7001a20c9 3 #x-62268c7a16fa38ebd14537c879bd3457fe8bad0 2 #x2986e01dd95038c6910c58f67befd2e4e6c6b2baacf 1 #x299b46d7368b705ff102e82bf71a31c707193626072b5b 0 #x-67d344648a1d306560332e8a673669f9ea4490326030bac) 104 (5 139 4 #xc3259c9bc535ab1ca49971583f4720bc 3 #x6a7845b6861f8776b74e093de9514ae7b1a1253 2 #x-2024f670426c353d386c8ec1fe5ce7fdab81ff26b46 1 #x1110905939dda3b0e6c17fefd50ff9f95f0747f575efd75 0 #x-2af1ba1e41ea2697a801cb11a627101e879efa2509598b35b) 103 (5 3733679 4 #x-3bc8e912abba5d83737ebe024ede76a24 3 #x215c0cea7624e67f157c88b2d1cc9a26b377c8ec 2 #x-12d8ec9cae88753eee951eaa23c34943a2cfa6d88fe4 1 #x-3606bfb1b18844fc9884d64e39ff814aab41997c4b8269 0 #x-34fd9a278ee1323d503537d4b80e04ef6edd8bf9287c778b0) 102 (5 #x1e80e17fa 4 #x-ed94bf1341bb71adeb6a8c8a1bfb962a 3 #x-19360dafacb0bf053849254f7b8ccf9ca820478f 2 #x7632079ff50a7e7dc152bd27e5065d465fe4ca4ad24 1 #x-56a6708db534b620ea2e1a96dc27038ad59c315663c4c16 0 #x8c5fbb6c0f09b60fcef22d1935da82b9ef42ac5d65d8a127a) 101 (5 #x420dc9ed503 4 #x1b1823a77709009bd11ebf501f105020b1 3 #x-9efef8f0d4f86390d30662f8861391dbe296518d 2 #x71a95032cb09b32c40b441173382a4047e5191bf42b4 1 #x-1ddefb050fa7c224a60a2a1559b9cd0eb282c320a659708 0 #x1a0ff91c54dfb2342b5e4c8eb6a7d3aef9c7d35806e36d2438) 100 (5 #x3192910084d76 4 #x-161fcd6cd62140d3ae0e48d153e9db72c8 3 #x4bb8376f4eaadf978369e13a0f2a167851bea3fb 2 #x-12fe48c10e4f038c129b5430cb09877c3ddd1079f3ee 1 #x173e81489b93949b141e5320a540541a9aa7b32b163675ff 0 #x-7c66e738c721e3303fecd7f1dd5e9dd679132348ec32462ee) 99 (5 #xd8e64e63c8e05d 4 #x-91a8c1b23fe05ff6c183433dcd9f0eb309 3 #x29ca4d4a927a93658b24aad11b89a5bf30c48b866 2 #x-251d1668e6450fe819f205747481680833d403c34829f 1 #x12ad37807e74447ca4830e4e28625f35e804ae895bb6eb99 0 #x-788ec4cc0e0324b81b40847ed366c91d158d3c7acc0edd9b2c) 98 (5 #xdd874d6caf2a436 4 #xfd0c76a7140f20eab8d9ab93b7ca45819c 3 #x-9e9d7e79cc41426bfff957f23fce860851cb8ce5 2 #xa3c42d9c6c26e28ed4b6cdeb98adf612d032f5bf456 1 #x-55986c1518bb7e82d52ea6a04eb2ff13f81d00ad8bf210e6 0 #x-698802ce37e895f1814e76b551477fd7e8b7c8715a1b4918f8) 97 (5 #x-19fe3cbc1b293abd0 4 #x254dd90903853a7bab2cba92dd7c835428a 3 #x-9c152b2694b21b13fe2d181afe560720bf5841ce2 2 #xab9ecfaeb6a7dcdae3b2f56cd3d479e7e047491a1b9fb 1 #x-6a3ba308c6d874f4ff987f7550144107a037fbaf643b73df 0 #x169f1d0c8e2d81a60eeb26e308119735cbe5cfdbcf2552a96b8) 96 (5 #x-15e9ee8225283c1b6d 4 #x-6bfb4a958ebc0460320c84dd23db04c6183 3 #x4ca32f0494746fc423c356147efe080ac82f0be2 2 #xfc781e01c3ee0dff72fe1f79af4b1d340444d5a0c93d 1 #x110d11c544f6746d30830de6fda8baa33bc1478989128c72d 0 #x31cc282268ea60acec8766fddb1bda2330a2cc7e3ce381d2353) 95 (5 #x2348e37941a29698894 4 #x-6f565b3f8c4ff9e1784d0cd841ed841132d 3 #x208e48c027a535992862009653f28de06126415df4 2 #x-2c7249f7076a4c3fc902bb7e8b63d608bebda1fc2cddc8 1 #x1d122ec5e29b1d3bd8cc8559705e0789bb721f64a17e8aa1d 0 #x-1f8acb4a4645d5bd409582b6d6bbdbea37892d0140193d54520) 94 (5 #x-855268e0cc4f7af2e 4 #x2334337f76a877d7eb301698be8b68eea900 3 #x4e15bed50d24a814f54ddff3b4fac3f953c50705d 2 #x-7e183c712527a6cb60c559977d4bfc45aa1a8a68e8ad1 1 #x-2f5be7e88b9a7d8abd75653289fa26de359fdd4107c6bdbf6 0 #x-d2a54c50ba3bf4b86bfa73838bee91df670ba85352697309ff4) 93 (5 #x-11d025eb820efa172e9b7 4 #xb31cc1978474dd39f623f041a37cbeb9763 3 #x-619dd4227209d5d2dfb9490e0f1bfc9505b8bee1f2 2 #xa6554e5ac2fdb3088b7593d79e1d2cf24de5e2ffb46b28 1 #x-6a332dec320b34c1d9493b7bfa4098c99e6eb52ab7be8ce60 0 #x-62b1221a5ccae741b6b4ff617d8ce2b4a5f65605b6adb765948) 92 (5 #x88c9790689ce38c67b646 4 #x-9732e958bd8658f488df1cf3cf87abd98d64 3 #x-1e3a1374abad4dfeb104c0dbd5616fc7dc622a339e 2 #x29388f82281d94506e0f6d00212a7b150d8abd7546e3ff 1 #x73ce8b6a12320e9a4140ae04093ac301d242322185641a745 0 #x26396122f74949bbf4fa87d90aa7eb6d7dcb7b2694a3d8660fcc) 91 (5 #xabfdc56baad86fbfcce5c 4 #x196bfe9d5f44baaf5785538deb3a83377053 3 #x1083be38bc9b62c431d146a43e557f24f655122e2ac 2 #x-2353fd372fa58c594055f67327c6dee882f2ef2734fc3a1 1 #x150503f9f9d28e0190b0eb263b03644af80677bf9ed00982e2 0 #x37439360c5b0bf4d585c58b30303dffd057b3b48867c4c5a82d8) 90 (5 #x-1c624fd56f7c36bded725ac 4 #x2299b511d9889fb653bb16fa51bf9a74ebb23 3 #x7787ac2a255cfd47b0b5697124d3319a6f41fe4f14 2 #x-ae470325bf402b99e8d0f12758d1d5479dcdf0491e2c86 1 #x-ff3b5d59af94f8a3a09778430646699cf0a2e010d4669fb39 0 #x-46a8eb59b8e045124f8c17172aa33944777b896a9c422274f404) 89 (5 #x7e3fef53820170ba0ecaa20 4 #x-1324cc2d024afce865ccf9f388680aa7c65a1 3 #x-2882dd071dc4dd868290b6cd1c7132144a9cb1e55c1 2 #x6d77cbbdee9729c3ba18ad86bfefba4805deb747ce02fbd 1 #x-3b4f5ee3084f088f646d739c40bd66cc74a4b004f252b4a354 0 #x-e47db96c3af9f9b056bdd1c54eba026dc04367aae7f3a00467a0) 88 (5 #xa07f8ece6107fb94a797bfe 4 #x-6e1a78afa284772abc062c4be2f9076f05c1f 3 #x-1788fd5021d82306df4a789048497e1d1395a3d3155 2 #x278f5327a83ded1a3075efe92d69a61caf138372b485ea5 1 #x2156017f9bdd4a5098fdbf94bfa8f5a939a157963b8eb71205 0 #x12cd47ce9bf9e4a6c5b2d1a9920f6dd57e876b42ef804ab442fe) 87 (5 #x-bffbd6bd016ad414041fca4c 4 #x6292da5cd1fdd5b72032f0a51b816a4f52728 3 #x5a4bbccbbcf603fac0b6bb41d9e513d85febee898e9 2 #x-13651b4dc2c3a3cbdd3eee65a5c1438e70f2704a6ebc1c65 1 #x9938c42a017410ee6a9d77f0a537b351895d403dd9da9a4dc4 0 #x29a3e7a641013bc6d64369a3cd6767a9fc05d28a94f7cad8c2688) 86 (5 #x19b56641afa3c9bd607b0b6eb 4 #x133f20b0c00b3a6f5675070cc10a4600a30743 3 #x3f05b0183b3cff98bbf5e72ca0432d51f88703f825f 2 #x-7eb242d7cc9e70c1fec6a61c28c4c50d5c518cb8c00c59a 1 #x-475d5f633771fbac20dd780b5419e61508f11c4587327779ad 0 #x1c86cbc055e2236fe12fea59eddedf35dee54dca1626ad6566a08) 85 (5 #x6628c474c1a191248ba1f551f 4 #x-17ac7e287055c65d603d9e0247c0a55c565501 3 #x-b70987b3ef4bd9006406fcea4acd321d54394c5f27d 2 #x32719df1ab54681e5864685f8ab9cfc0f7ac88a589ab529b 1 #x-175508992f69922d89382fde2ab8deab5b5b5388eade6c1fcd8 0 #x-5ac9fd7ce9ebbc910e9afd223cb3e1203f5b4c630eadfa22da180) 84 (5 #x-21c0512340745ddc1420b2ce35 4 #x-2f981d0062bfaa67b9f646ecf8085f3dd8287b 3 #x-939ed5f3e7e8a611989a1116ba28a5ce24264a52360 2 #x16acad8cc777f0e44c084e5c2171461ec77c6f3aeb9acce8 1 #xa491b7ed735d25d4e80b50353ede4829b3d1c0d96bd3675c13 0 #x-895ac11944bafa39c83784494bd0443093bb81d1302ee9c27c4c9) 83 (5 #x-227f8353a50040a6d52f05179 4 #x4b9bd9adc3b7b27a4f7135f389c5f8cf3e611f 3 #x150d1c56020d18e50c5c35dac3e385232f2cdada886f 2 #x-78ae305e40971f26874fe3efa627d5364350dac10c96ea13 1 #x371772bdcacd89afa37ca9ce56031fb1d373e3661565ad3f28c 0 #x8a0beb7eeed553e16c9c9002f38e8fc62b9761788b42b37d23828) 82 (5 #x141892eb1903410e047ef3134f5 4 #x6831b5633d2095dcb965050ce8ef125ed20fd5 3 #x13343c3f33a1f33ee9d6f586d7ec621e84ebb6022930 2 #x-3a8af50c42e89a1685fb55bb64fe28aa15ccf21fe7c8b0d7 1 #x-189bf62ce97e245fe15c63b7ba6e7d924df07c2ec4700a64b33 0 #x1a5e53eee8c0be6a57af344bdcccf2133d651dcafc63f6fab1b948) 81 (5 #x-1d4f81a5ae23a5c8439eb6c5f4b 4 #x-d15032fdead983ec93d82bf90eed45d69e4c15 3 #x-22ef8869f00d608bed7007522f947fa43c65c48aa005 2 #x10a3139b857b420d38bda6f476d287e7c3cdbe45bb55f5894 1 #x-7fd722a806cc9de23b556c88a1ba4c8fd9d7f4b2723e20e9ede 0 #x-4dfe47cc4f65dc21f3ab2d5dfda483aa659eaf9c2e291c533560c) 80 (5 #x-70986c7b7786c1327c34cc7b678 4 #x-c91a8735da5f8d25ec681b79786bc7e80931d3 3 #x-23e5354c933bfea2c700b053c2e04592efe042ca6f4c 2 #x8910843eacfcad2415f949258c9f637947dd423f6b74bb42 1 #x37eac7c1c06a72c3392a60e9a5f28a466746703771f8a7084e6 0 #x-3f0d331cd616e3b76e23c1508ca190b824664511989b641ee404dc) 79 (5 #x1505ce75b7ea954bc85ee9d9543d 4 #x2012337648223094b9fa0cd92b44fdd359b9e33 3 #x33768fc26a4bd99601787482cf3495beabe38cc72775 2 #x-21e88f87ef0202086513837f77e4b153338e03d8d483dbc1e 1 #x121d64d17177eb2c5b03c2949cb8da1826872f3120e85617046e 0 #x-15cc2a6fed8f6ef9247ba7153f984fe983efd208db90d1eb51fd90) 78 (5 #x15303e4f9412eff63da13a380cf9 4 #x151d7858381f5d8c031349f4332c5edd50e73a9 3 #x3cd28709a868bc218a1058f038f134622a53f7f7d19c 2 #x-12437d8060c3ab79673fef0bb6d7d34c48eb719cdef175499 1 #x-6fbb896a90fea9669f97e86d12b86c92caff6ff991fedd754a6 0 #x7c34f2a5e84f56e93ddcf15d039accdcfbcf5456489949e8232b72) 77 (5 #x-8c8e67a2683b28a45e2e62e5bf7b 4 #x-4680e2e4176557684138730ff69d9409844b0d3 3 #x-40c97f2f2a5e0477e48949bd93a042ca6ae8dcfdf1c8 2 #x3ffc3d517325cb8d66534a6116a37913f6a793b7e30f24ee8 1 #x-27545a65255e6c93b3759162c727e2173a9f224f3a2781c58620 0 #x646e0a248dbdf1e150944ec44afa0129965ee173fddb1565bf3d78) 76 (5 #xc7f42c14dc00c6c47a632dcb6e5 4 #x-1dec4b0d50bebb17aec752d286cac5d2cfce568 3 #x-5e95df04201afefaa807d88ad549b07c4fdcad4544fc 2 #x2392488e3d0fa1d3722eb2b186606ed027fad60f74d43ae2b 1 #xb837aee9d7ba3202ece46149d8124b195836a7dccaf4171be0e 0 #x-cd26d36f0fad7bf97eed0fc31cec283a21d1fc586d248d749bc390) 75 (5 #x29d4804f1f598d759a5c7e983e5fe 4 #x8c1779b7ee9724ea7d1548224c92de39e857a80 3 #x3e7113851bd8ba810a0ad0520998c36b21682d9dd9ef 2 #x-6ffcd4e9223f7f0710ff9c1b28fa97979c050901b878bf4f2 1 #x4ff6aa6e894e62a2af93ab6a3862fca659607129060e967b9449 0 #x-10e87d1d395e5b6c7750ce9b2570e0df8b05e1631f476d2f5c1ad5c) 74 (5 #x-21b881b66f08cfe9f1103c43808b8 4 #x20cc5a812fb95e38b273e1114905def7cddd585 3 #x89c564634b24d2f54714d408757f69b846b483730cd7 2 #x-3f740d6dc31b76e2481d44ee4e2f0d2b4903c5e324d40698a 1 #x-e1dc3c44f8f153794cd61c289bd2520a727d6d221e81d314947 0 #x11a6907a9440eba9ab66646363060c99cafb27b37c77197ee222418) 73 (5 #x-977983ac2319383321c8ea1bdd14e 4 #x-fce9a343c3852639439353f2c3eaaf109314042 3 #x-17e309ae185046973df84d78945a943fca2286ceb5fb 2 #xb61302c3c282a4053ed001041cb19672a11519fbc9ba9badc 1 #x-95ad6b4135b4b0cc1f816491c7ce614a86b4ed07a7febbe7ced1 0 #x23aa2c8f6c607a91b8e6481568a33e2a37483faf10b4b05e6b0a240) 72 (5 #xdcb7bdb1239cd87cc606104e619cf 4 #x-126d3095d9c43a0ab31d142c47671d9c2c91059 3 #x-c25db02b4221b4a2f9c4442220d2df5bee069e3baa40 2 #x67e03ff0b35a6eb3a6625752c9cf97d4561e9652fa79ea1ea 1 #x80b63a5cb558f652eda085bdd9ba8a1eebc9b73b08e4f8b916e 0 #x-137243d768275c0c612ec349ad4c97315543764ee18e86585108f7f) 71 (5 #x1ab0ab31340b3592a969bea2559fe0 4 #x1a03c5deff185f0f6fde9c87dd497391b7495f9e 3 #x-4de3a83bfbcef0aa837a57046532c5a741175aff22dd 2 #x-113568bb26251b85056699615ba946495261ab4ac306f051ff 1 #xff4ce4baa1fdfeaa309c5c706d1c6bea9fbb7b843fcf7f4dcc59 0 #x-3fadb0104722586ab8ccb2d71c3058d0a06e349715878df651532b0) 70 (5 #x-3bc46a26b423e18ad94a42eed4f29f 4 #x-1ca2ce1c1104f84e472db50f03ca3698dfef06d 3 #x115a9cab4a3b485079b86f3fc0284ac2e7b01b1be2d75 2 #x-9c4a879a8df02d6b81a9ca40c3a479d72a628318d6890861b 1 #x109f4594f384a46403ab1663d43728e8b3369d5990ce45055cb1 0 #xeb314c54c9600cd9e0b4576d2995fa8016a16f8c6ca9962458d010) 69 (6 -4587 5 #x-3a311aac9c2e19c2ff54be27e8c0c6 4 #x-271bbc05065109fc9fd781b836156276b03c771b 3 #x10d514e954af1e02b1accfcbc3bc99c6f95a311a3f6eb 2 #x183a6d12c8588b06b89ccf7201a95e4329f0d575641a13225b 1 #x-18ad3775309928f9f2d9d1e2e5d7b7d48da1c3ebf4a68f92e27da 0 #x6391a4b70332a50a7ed25d0c0f295de2e1293acbf6550f0aa059a00) 68 (6 74051138 5 #xca750dbd823de59fb714cc9c42c8ea 4 #x7b8de131d46290d78bdeca8c13ef4cc418de70d 3 #x-19ff46f37b75158932905461db78845abae5261570455 2 #xd858c6a923cec57304305955c87e06b7d79b048e45797c917 1 #x-45154764cd1b7c914192fde706df616d1dceffb8f4fe2c6e59be 0 #x-a8df1d462990dbf162e28cd6438853926f80d86be667145ef1c60) 67 (6 #x-ff6b24e6d 5 #x5ba00aa17bef772e24efc8fb1814b2 4 #x35c0b01d90d20400c574d3682936955a73c3714e 3 #x-232c7519ed2f421df0440625c84f03efc77d2cbf87b33 2 #x-1fc75bc76646a4782377bd2e7009cf41e8c0e093bd601bd67e 1 #x228c0ad7b8634b6a3714b814c592a4d270e54bd4577aa47a70a54 0 #x-8aeb04c7bcb5dcefe977f56e3ccfd50a91c5ee63e522b6dcb0b3200) 66 (6 #xbd14c506738 5 #x-23f28f7bfdc926191f91b25492af010 4 #x-111ab5a716dc254c22d8d5cc5bbc1023516b5e52 3 #x28c560845774b44b9baf391dbb67e0069be9111b39b9d 2 #x-113aa8fd4b7158a88b37e0555b6244e1fe5be8e08b2b60b524 1 #x975f3faf865cab9221305583d69b6020965d65ce44cd8d83e16e 0 #x-16ec9694dc87da0b4d82bc3f86418616251c56e3e40e5efa849ff80) 65 (6 #x-34bdf8da43f69 5 #x-4220c34e660bd10d1a062c432ef773 4 #x-438b9d6dd8472d3329d41c12c1331cd6b22bd9d8 3 #x3ab9d8a214df1e0c92c689b21fd84ed905f6bca2311a9 2 #x26d868a005aa97ff35d723611e6b1ad6bdcc34a5858a79eba4 1 #x-2bce1842a66ddf32faf3c50b2aeb1ac4771ffe563d281799282ac 0 #xaefe4fe536cdf01a74898a3d47d3dba47984c3baad6f10a840fa700) 64 (6 #x83d453fb660e09 5 #x5982dbc375936ccb3a49af3eb1b8a78 4 #x1d69326eb18aeba58c22eba915accf75a7335ae8 3 #x-408849ec0f3622846733facdbf9010477bbb532403a56 2 #x1434ff56d60b2a32d735e3e9f829551cf4131115aefb802e70 1 #x-fd00e0d806c761018e1e95b314918baca82a80c3faf2cc240ab8 0 #x34c8a139c9bcace4ff3da86cc61a71da361175d11ed4793465bf000) 63 (6 #x-c819e19e1ee66b0 5 #x-c35e6d9005133c981e99367002e152 4 #x4d85f1e105b7502165d806893140b470a1c1c8f2 3 #x-539cb11e36d97cbcda1ab2f7a3c9209970feeb38e6621 2 #x-2c40e17c47437936c66326aed230fb42bc8ca077c137b9567c 1 #x32661ef8a4c27906175438b6ceda36eb604098caad143e6f53dd0 0 #x-c8a48fa55cff6b446224787d7c6b268612995e4de7ab4d5fa9dd000) 62 (6 #xe0fa4be3fa8a9cc0 5 #x-c8ffda703118077965a3ab48a7aa876 4 #x-2ae713e0d4bdf1ce2b09c0dd2410093394586161 3 #x62b69b2c14946d17d9758361dcddc15e39b70f525fbf7 2 #x-15cd18760a7cbdcedb507e72aa03512199d08a1929923d6cf2 1 #x15f5306688c8bf5864002c7b0e2ed66cbf38a5a4381fc869149b0 0 #x-52a8c6cc77182510165c871c911666d276282bf7f1a7ba864a4c800) 61 (6 #x-ac440e9e6d9ce77be 5 #x474c8e1af8a7f4305f1390de5a87a52 4 #x-511a94bd1333c68d884682576d1da55fb57a2f6a 3 #x6776f699c88b84e69ec629437e0d8f1f60dff590e87f7 2 #x2ef95c326a34e2aad8b6e1f8f7f6f70866b2d2970d44cd2380 1 #x-34c31c598a6f646fe4dcb8f91ac37b58cb92a397b5dceaaef5260 0 #xd29b4e2adbb4bdc22eff72191aa6a9f5e79950300cf24e284800000) 60 (6 #x6a9caed14e44f46c3a 5 #x19b30e5e00e8492d482a3ebf0b5828b0 4 #x36e94b1fcca47043e76c29e7c6988b27ad67e0f5 3 #x-8d7122379a27fe3539fa4ba081f824a537aa1b74a20a5 2 #x159be3bc7f6494ec6d5abeb386959a291726a2bd195e2481ef 1 #x-1a351fdcaec04f2a03f95b2d883b2d44f10105da01d1450b22ec4 0 #x69650528b8f7f51f67f854a99c876bd14c9ae9ed009ccf225f4f000) 59 (6 #x-2fdfe388bd776d7f629 5 #x-ece495464b7038bac33bc41ed22ac8f 4 #x4d17ebf41c0bfd2dce7d66b9e2f4d5a8337efb39 3 #x-6f1b2899c6262134449757f63c83e6ec114efbf417d58 2 #x-2e6f9ead427106b45e386940aea621800f6ab4e1cf3781d4bc 1 #x32723f4c36e2bd312b20451b4bba0d86370e2d98213ca88a279d0 0 #x-cb373203cb2c9bbc53fc9306d0591e99dc16f127b7b8d0d15e1c000) 58 (6 #x10f336476195865164b1 5 #x-2f6f9fd5536ea499a2403bc064ea0420 4 #x-3ea675d85d05622fd654dcae54e501f46b109f76 3 #xba7c3632750e3b59f11760ece1498789c5c06157e3db1 2 #x-13a2b210e1fa8b47189f512131381984901419d3f03d8af25c 1 #x1b55f4d0f186e17ed8c6968fb0c994999e236596cecc7d1f1e9d0 0 #x-73a89ce3e837509542a442e42cb23f58f1239eb219cda3cc84f0000) 57 (6 #x-4758c9f58504afda09a4 5 #x2754af1842c5bfdd8fe545aefaae2e7b 4 #x-424166a1dff4f70f16a0f0e008bd64cb920dc767 3 #x65655d7f9133f8331840f53b75b821a2994b7c1104abc 2 #x2ab7cc18c1eb539f781417d4c2a215a34f7f03a4f67f91caf0 1 #x-2c40289815d26ad7b746f658e421ce4683cac047a730a1f599080 0 #xb4c046c09eb70983d98ac26b88f703ecaaa28750ee72679ab880000) 56 (6 #xd06f70ac8785efb56285 5 #x4cfa8b354062329242283532c54de0b2 4 #x403cf31903d29a001614a5123a2f7efd0e5dc044 3 #x-e020c2a75a45a375e3aee98d045968717ab38726c88a4 2 #x104e02c0d48611a8e6d1f4b1b3638d0d914f674b5ebcd48c12 1 #x-192130fe72d3658378875b5d157350dcf475aacad6ef3aa4d18a0 0 #x6fea02ce507d95067d1ee19bac7e57f9e62751d7821f6e0e8040000) 55 (6 #x-143e0d684f47b4ef43ba7 5 #x-5865568446b7f411e55893cf425f88b8 4 #x33194f3ed0606f836e5be27ae2e6fbaf6f15e683 3 #x-4a05124d73c870376612a6c168c3e3e6a85f657c76fe0 2 #x-24889501e055b39280e5fae8981d3d7ce89544a46df4c48d50 1 #x23cdb5d697aa8809798ac766871f0e76107598232145d7a07b000 0 #x-946d35c1789acab821335dafd90f37fc1a245043d830ccb5f000000) 54 (6 #x-18665405c54ac620ed2e4 5 #x-697e3c71e2e9e8977a256a09dbb089c2 4 #x-3b6f71dd55b68f7328e223559501bcf540b13d8b 3 #xf43b94d1cd5e767cef72b44fa8f3043476ecc275636c7 2 #x-c5047b95964e07bee2a4664abbcf7f979fcddbc55206c409c 1 #x146dc533f2d34ea817a8323364b2be427829e04e5f5173a860000 0 #x-60ab48a51d21d6f2281570edc8a71520cd6f4f2c4367b8ccb100000) 53 (6 #xf163c9643ba5528bd4504 5 #xa9917dfd1b39cd408625f0c4b313a085 4 #x-22f3e50140535111cc5dee07ed366a7c9fd1031c 3 #x2291fbf9a042ae95749db2444b29e7ce91096d010686a 2 #x1d02d37382bbff1a82b9d07b47eea81a64d6832ca3ba6e0908 1 #x-1ae11d49703334a8b64afa449a3b313baf525658d2126d985e000 0 #x7090a0d3fac360b3e6f4f712aa9c7e4fa7c47128948d14b30600000) 52 (6 #x-27176af5583da9f170d559 5 #x71d58af3652973fc6efacca2eccfb5d7 4 #x31b45de494539d3983db0b30ee56646f63f46f11 3 #x-f05514afff2d2eb7609771e49332c1d587578114aeb28 2 #x865c45b79ea20d68283af0ce1f4737e0760c10128ea2f2fac 1 #x-eaa99030b5889351a7a5c8da6ee35151d355bd9d86db4ed65c00 0 #x4b0a32a827155b25108b2336659693fc7d5b9ee12acf966e6000000) 51 (6 #x18239f885cb8dea6f43c00 5 #x-11546975302753d09ee8ba98bfea7a724 4 #x14c93468772cf4e8c6bad15ce4c8ce1d1c65d191 3 #x7147feed1d057ff2ac2c6a531d740a322f7abbf8a2de 2 #x-155c1fa7d50b6781c101f5b6717c91f666baaf381e835426a8 1 #x12d5306f2ba112096aa2fc771d3064db65fe204ab07caf9ebf000 0 #x-4ec75a229feca3c30500bb56f7d363d1f4e7c413206cea776000000) 50 (6 #x9142e8b299d06682278a38 5 #x-4f1d0a7da930a58e59e21e736e114783 4 #x-25927c1bb57444f0127e0c20a72dc455d6048974 3 #xd4a415331a27fa08fbd36e01d00c683596a4f3248cbcb 2 #x-51cf05b0bfbf81a046599c6cdbcbc0b2342ecfcd4409ca4c0 1 #x93a941ddb66931801984a8ecc1ab0bc9e3e10caff9e55800c000 0 #x-348a43f912ec81e714ac3d928e478101b9fb20df046a044b1000000) 49 (6 #x-1c911e437177d2b0ed18f8e 5 #x1812ff097583416003ec233ea34548b01 4 #x-a575c756cf4a12a4836643544a833f3ea37c19d 3 #x-289770ef9105121cc780915f9bd2350f053bc80cf2488 2 #xe8ecba8de6e012dc64d3047b67d645beb1635354628baca00 1 #x-c5ede9853fd3844066ff57e61e18fb4bd1eca5a8d05b8a4c2000 0 #x32c82fb6792d465139d8cb20b18f277cf32a740d743355d50000000) 48 (6 #x14f059638bd84aab6a7d850 5 #x-91b7552414a3fc3153ff3a7fbd8c68f 4 #x19a618282bb6be859706dbeaca9ccbc16c0555de 3 #x-a831c3e9efa6c3b3807c97947b90fbf6e291359402758 2 #x2b987c5ec89ca9f55365f888021fa9fccaf0a3bd27d940146 1 #x-4fe73ca5e1813e3e1425295459f51542b4f83355063e09520000 0 #x213ef495f19d7dfb873264a9e7adebc0ab4f6069e1b3df10f000000) 47 (6 #x496d3cf244bbe6d49fba0b6 5 #x-1c43c9bfeebb80f4e2f5850a6ce96257c 4 #x3eae402e7370dfa726f00f68fb96adad2f7d8d4 3 #x3b38747cb3b7226596418c6d4c5bfb3788c34e22a577e 2 #x-92b3351e9f50ceab3baf188cc725d40a768ae56ef6ebb8510 1 #x7a1fc52ac3e3919bd98b4c542066fd9bcddc184b1af8e11a0000 0 #x-1e10a310251457dd16214b1a4a18d822efd66e4a748906c68000000) 46 (6 #x-cc96bb35cdc41f5e7346da9 5 #x85be8c75891bdc74a751d1ebe0ba5f98 4 #x-fcd39b8b751e03a0faa00bba76a29a0eea7bf4a 3 #x75ed92b303d07d373ce214f53e5a710e399eb03548bfe 2 #x-1383d25cc8d54bc518070b00c9a76422a65fbc653ab180110 1 #x23778ae771c3f8a2f1d80c2c3a5f745186be95f8910628930000 0 #x-130869b664518eb0b3a7505986eff5884c51b440398b11b50000000) 45 (6 #x52c6b82eb429ca35d27efb4 5 #x1bc8bf42440097f29674087ea77ff5502 4 #x-bed385ec3e16dd7fecc1ce9a7a52129952b1c4 3 #x-3df9757f1bbbda41fd7a9206f348770d9995e99cffcbc 2 #x553be4876f4e4da5b6493748bc1ef1dd12443cf420d764980 1 #x-46a4b37b1ecc0496856f3a59fd036a434746437eeddb68e40000 0 #x1049b0af8c999b333f0782a461aef551064c70723ce288700000000) 44 (6 #x1f4d32dbb2044df0f3abe2f5 5 #x-fc111c0f4619a850d214f14eadc38dd6 4 #x8ce80ab521e689d3b95f891a3be35dea69f2808 3 #x-484f39a6855134eb606ebb0ed77d6957f7002f8320b60 2 #x68cf2a7b1753694f645a2cc8a986f32947b3a4db7fc5e360 1 #x-b19eefbdccda1e8c9988048a0e98f0db08d61df06b363040000 0 #x9ddbd5d685460b79fda0f93cd6504a65c9d74ea43e941e20000000) 43 (6 #x-38478765b6be79412dc7d57c 5 #x-167168ae6a0c69a1210d939ff67747448 4 #x-5ff12e09a2d866cde74c0cd0cfeaaeabef760e 3 #x34e8ce036db7c15fb9be767fa09d76e4b42172db5ca8c 2 #x-2d9b941bddfeb987f42a92d7ed6d3772826daf6ccd1f1c600 1 #x261126f0b155b9393862d52b1915ef705f807740396de8f80000 0 #x-80a398912100ba6f5126d509ada238f4a8b08a4cc4b9ee00000000) 42 (6 #x-ade38028e3ab7be12848c45 5 #x13e8b7f1917fdde8d44a1915d45e1efc5 4 #x-47e799ea43ac569b1c79511cc1d36a75e754486 3 #x25ddbc2819e8524753920ebe6324db7e068fea05b9532 2 #x-d2cd24f37a67cb0659267ad7ae0944facae487be1666580 1 #x6e28d38ab341592f2fe93b235296e50b96e1062a8d9a200000 0 #x-4a2e67b2bdce80a0f16b7e3493dd327ea2242594489f3780000000) 41 (6 #x90b183b6072630ed4d9c37f5 5 #xe49528312f86bc1d76929d550b53c9d5 4 #x8623e869aceb8ed6b824428f0835db0f8e0ad6 3 #x-265e9edf992a61cf4e65b70cf9cec386bfe55b4e493fc 2 #x16701da9c85dffbffe99d6d3d93a4cef77369ac13c8420f00 1 #x-12e71911443ea1599aee4506ade61f7feadd8cf802b294800000 0 #x39964ffcc4c23b17bfaf506dceaa0795b6451bcb285c4300000000) 40 (6 #x-7fe3bf6ebf84935ac8880b17 5 #x-1389da57164bfd52ed97f8fa14fd04f86 4 #x22b92ac7ce1e64d905bf30e78b58b83fde72105 3 #x-1020050828b5d0d317be00fb72a5f68960a309280a860 2 #x-1010cd35c3bde1fcda4abf7143eb1471f36ec28a7570cc00 1 #x2b237e603f725e05a42bf88a8cab39f822ecfbeb0806ac00000 0 #x1faa542d9a0179649420191b1e53ff87d2eb43d52fafb000000000) 39 (6 #x-a4f3b6d9d39d6ed1cfda20bd 5 #x-65a31bba5a1a3fff8931792df94fecc1 4 #x-64474a9343a0c389148041f9f1cda860c96cc4 3 #x17fd5a9cc5e689fd222c42bf0a542a37d2e7cae466450 2 #x-a20ea426f80a17b91ff3df7081200edebfe91cea6867a000 1 #x88499fb159e1592eab181257b38e8f10e8ab8de6a55dd000000 0 #x-174521c37878ca3316d954314986544a0af84a59abdf9000000000) 38 (6 #x17fabe4ff62751e6641bed77b 5 #xf8dc6ffde3d28a9452b750e0adf98b07 4 #x-10cd3801ddae2b265dc9289f8ad867bbbdf46cc 3 #x4dc0fa5c32160085d9a950194ebb6dd573a39dd10df0 2 #x127f7eccc6d712614af49ba21568c6b2f65da33d30d0b000 1 #x-29c0bfe9e8136aa236a74661ecc36c47d42104207c628000000 0 #x-c51b718cc9cde0c4f398dadb318f14673245b3a30d62800000000) 37 (6 #x-27bea104b248d5daf70ba7c2 5 #xe30ff38e7748cb483900c093e6c7d05 4 #x45d3aaa9bea825a0e4dd701aaf27ce55a93b20 3 #x-cfa2ae66457e9544c996b08714e9b4c0d89e66af80e0 2 #x42e10c4cbe179ff913cf402a1f13007409dccaf547780000 1 #x-3690b0e025e976ef3da399d8fe77be216fa1dd80f4df6000000 0 #x87366626fd18e21fa656ed809241ce9ff579b7b9ce70000000000) 36 (6 #x-23b8c48e506ae7058f5c149eb 5 #x-a2e62fb8f12efff5a0fcc0c3f46792ff 4 #x87cf4ccabf91769a88347887eb38621850f855 3 #x-57bc4305df2e2c13b198153683cec7e55ab3a393544 2 #x-d0383325a94a86a2f662edd106f712b612b39971c8ee000 1 #x1ad4b9ae9149694ab6f9ed3ec130ac492ae9cecbc37a4000000 0 #x4636625acc172227f28c47d22713b0ac37b38349a181000000000) 35 (6 #x1d744fced6e82f928bcf27755 5 #x19763856f2e3996c033af1d40b58bda0 4 #x-36b989896a83113242596a52d173e0f8675290 3 #x60d3c4cf776984811217565c06d2bdb35f429ed9e270 2 #x-190ac098f43f6e2d8bcd778bf0e7aca7a2af98e7aa098000 1 #x12cbe4a6e27beeaf65670c0bbafd2e05b04acb0184550000000 0 #x-2bfaaab976cd47afaa46afbbb3961b4c8b0e8c86ab8c000000000) 34 (7 19738 6 #x1bff1f88d79f2de5668f813e4 5 #x5776a96ed2e648cbab53ceb4f317d395 4 #x-44625c9073ac2179c14e4c51f443a521676fbc 3 #x-c8bc63f5934a0fd56cc3d925ce3fe74dd4806e8b990 2 #x75b2086eb927418ebfb5d90f3c2fcc96c6089884e710000 1 #x-dbf8162ebb74f9bad5b48304d028808a32b4c0b41740000000 0 #x-1704685bbd293cb7f2560b8e15827eae304f1e0d9fd0000000000) 33 (7 -4162216 6 #x-362bdc4777f0b83b5d071ec70 5 #x-1ed27e6a80630287f842528c83cbf9e4 4 #x2cf4fc215b417115608477bc92dee9691f035c 3 #x-2684ee6d1e9edf8c4412bc5bf59ad6ee67079a682580 2 #x85e4038d11cb3ddd984692a62f47d7ca6f8e4608d3c0000 1 #x-53e3188ddb9992c700c01455d0829164377e2e339c40000000 0 #xcc9bdd52f14de51919e59c660e61a606766ca231080000000000) 32 (7 429805931 6 #x-c5ac79b5af555d859bdf3c 5 #x-25d04f1933c2d63b2a90a5a35355be6c 4 #x1da3522756eff05ddfc73983a7ca3db926f2be 3 #xae3c2a9d9d1f1922929aba38a4eaad988cc0de0f4a0 2 #x-39118508edb72147273828bc20fcd8fa9967b044df20000 1 #x5e422c1d9f50d92f1f0ce519d78705977ee6d4c083e0000000 0 #x6f86a5069cdc61a706766a86f92e9d608e559fad000000000000) 31 (7 #x-1d0f464e1 6 #x39563d85d00c2f35ce4a42d98 5 #x154acf096d6a4c603627b69c4dfc9348 4 #x-214401ace84cbbf9b22487566eb125c42bd168 3 #xccf7ae1aed3c0cfa6d8b0daf4102392e54e53dd4800 2 #x-268370de6b4841791f898011b6d33d44ef4e1652d600000 1 #xff2344490138c221cfc4f5ad60261bd0cda5ccd0680000000 0 #x-353563dddbed6ef696da7d8148555afd5be40437000000000000) 30 (7 #x-1c49d652ea 6 #x-1dbdb02d0a1842e49da4f4476 5 #xca9dc2f94267303f8c190d0e219c2cd 4 #x-80d09fda546defb37a28f008f7a9ff4a46ca2 3 #x-5d471aca6e4cc1bea224d90a204ffc01a1fce02cb00 2 #x182412bda3d9379401af5600c6b1c767109b3c178780000 1 #x-2231c9f3c41785866bae04cda35f1f4b1990b24f7200000000 0 #x-1f34edaf1872f8f3489cfd437433a674e232c43d000000000000) 29 (7 #x205630c26d9 6 #x-25334c8d31a879c1de868b61e 5 #x-a81ad051d66ad82b8f7516708171920 4 #x1453470edd7976567d0ac7d66220343d081188 3 #x-36c3664f3dddd117161f0a701bb8881966e4b677600 2 #x8bad5256efbb1f40e019f06df043a78eac2284d4b00000 1 #x-21fbfd48c72091d9610ebf3e49967598eab2284800000000 0 #xc68656f0cc9bb01fb77c5b015a57d5c2367ab3c000000000000) 28 (7 #x-17a1259f499 6 #x29cf80f1cb0957d528cbc78a4 5 #x-3378a69251e5d72116c7271c0549b70 4 #x-13bfedbe7ae53eb14ffebf290747555937ba4 3 #x25ebdc6ed3e69065669bd65e686be45c88962df7800 2 #x-8dc2ca06265f6e8a27b94a6eb13bd944a3c4d7f5400000 1 #xa73dc0f397f09155daf3e15800ceb70ca8dc6a64000000000 0 #x8089acfbb50e102cf295d75166b4cfce138a0b0000000000000) 27 (7 #x-3ad68334b249 6 #xa787304e48f16988baf42181 5 #x3cd6d106440777acd8426fbbbc0e935 4 #x-9cbf4a8c9c16cf7c1d0e5585143d2d1c1731c 3 #xaaafb27eec51e3dab671f593edae6a4bde73e40000 2 #x-11b7a1efc760218fb0e465b2488845a835cb475f000000 1 #x-1818ab292cdc9bd80aceb7ce9787e0a7bdcdbc80000000000 0 #x-29a6d0c95bd126e2ea6d3d9d4b127499648f900000000000000) 26 (7 #x86bd33e4c010 6 #x-21c5c6c192d34311e2bdb98df 5 #xef8b34402de2298ac953400f666114 4 #x324cb12f2cebe54dee4491e40d5a440303648 3 #x-c48e6188ea71f1bcb1bf831fc95d03af3307e7f800 2 #x2c2bfa6481155de80636391c96a80df3fd91c67c000000 1 #x-2a392b3e85e011730c3d866b80db11738cbace00000000000 0 #x-1e385757b2095f1944c4fba2ad8817bb9215a00000000000000) 25 (7 #x1e51818ef38bc 6 #x626a5477c7208e618797838a 5 #x-11e95a71518617239965984698b6e6f 4 #x38873758cc3469925ff189712b62fc6581b00 3 #x-fc3833066aab97cbb7c65abf614f792f3c980e000 2 #x-359218225c34fa5ff831b400b5897fd0e8bf040000000 1 #xca3da567a46fe5ab1bdae15299229d3a7abf800000000000 0 #x7dda63ba4cc34162ef29a4d421c4b7e2972000000000000000) 24 (7 #x-60b417bdbdd35 6 #x11e704a2b1f48edb90ff4ac46 5 #x-a9b53891f6a182a570c6d8e508035e 4 #x-2303fd39fdaa522b0094f2970a40fd7ee623f 3 #x331d9fec50e31658402ef54507152c2e3c22660000 2 #x-b36a6f4dd839c3fa523ab57f49bc30de359f2c0000000 1 #x8678eee270107891486c5e279c499f49a6cac00000000000 0 #x67298a352f75a78b2a0e52e2c365269bdb8000000000000000) 23 (7 #x-6355337b8972c 6 #x-9785376c18b6e2cd1dc5122a 5 #x8b681f52911348c172300459ad8a09 4 #x-d52f33e341715c257d8152f42586e6766280 3 #x-3e67275901e40b019ab4b5ddc9d6da48625940000 2 #x31b44b2d5af60feca19eb01ab4889ab1967a900000000 1 #x-43d427c720f1d652901e90e9afa8da35b82b000000000000 0 #x-154804911386b2fa9b6862955639d7c6bb0000000000000000) 22 (7 #x1f1013ac0c71e2 6 #x-5e4d3a53dc36568ceb03c006 5 #x72ad23d3b5491f3739334f1783663d 4 #xfc8160db815c9254665cd9465cb3fcd3e7c0 3 #x-a8484b7fe96b0af4172a81cd3aaf0904e02c80000 2 #x2219527e1ae2e63781747df2ac3e5ca52bfd400000000 1 #x-1294f16bc8a233cc42f25a560aa9d95ce224000000000000 0 #x-13f2f88772ef71e713a98ccb0ffbd9abf20000000000000000) 21 (7 #x4a4a785e2864f 6 #x61d16e9f68dc58ea5766cf0f 5 #x-7c49995e16b292cc424865a158aa7a 4 #xc7e07ffe22428ebcb229562485d4aba4680 3 #x2533474266b7c71a46a349aec0f85566348600000 2 #x-12b86b79d39fcc5245be6972ec370f6198ca000000000 1 #x10f7db8e04124080a2a7fa0eaa0a3155c4b0000000000000 0 #x33475cf8517ecf5d4444ece09934b30080000000000000000) 20 (7 #x-5a676c68d6c8ae 6 #xb0637cf34d8dab60d918d4d 5 #x-1e7d6c57664e5e1debbded663cac26 4 #x-50ba72100823e6c7af33b0264a48eb028300 3 #x1a4efb7da54767fa7655c3749aa252dfd67000000 2 #x-3b121a529930343c40d5491e162f55c565c000000000 1 #xcefbaf48660c3c978b8778cf7ec1c5ab80000000000000 0 #x382c37157c11e9089912ed932a51bbe700000000000000000) 19 (7 #x1b4228723036a7 6 #x-27deed9963f8ec2e6b2ccfd4 5 #x560b8e08d1d3b34b60b61ffca09748 4 #xe438567c830645e2f2582e732a103f27800 3 #x-a4f811185b5c9cf9a8898433485fad7e08000000 2 #x4b3d448133b062b3d7e7ec5ab94bef535f0000000000 1 #x-339d268e224619cf000d1aa92863132d800000000000000 0 #x-6fe2e98c028459fff441a40f331d73c00000000000000000) 18 (7 #xa35ac557340d1a 6 #x67a0fd52fa284144f77dde1 5 #x-13595564b0ef0b5ea4fc85e3523a94 4 #x11fd42838d37013a732f65cd7e54173b0000 3 #x-2ccf12133c08da6f4153af1c64b20fabc8000000 2 #x-413b543b6bd4b9ec6a172b96b77a2a5bc0000000000 1 #x68ba5b4a7dca6e28e71a356f0eda1c0000000000000000 0 #x-9042571acfff63c20e670d0d3611b1000000000000000000) 17 (7 #x-6288ff337df838 6 #xab00a871f17184b9c75ed1e 5 #x-2312b0042d8a9e59a59fe92658e0e0 4 #x-7298f3e2ee4b7c2a4123b353f710f810000 3 #x1f5f07c0e99567ac892c15c676272477e0000000 2 #x-cfe23913621253b9b9b3ff1a57d16c7400000000000 1 #x7223735f33d2a3f34c207061329d7c0000000000000000 0 #xebdfd77c034e4c9fdd6dc15e98018000000000000000000) 16 (7 #x-bd3fcc412d0834 6 #x-43baaa7e8eb0ae8cb5d4edd 5 #x175aaf099753cca5f78e68726e5060 4 #x-272b0e4b33ff72ba91f74ee7d81ef150000 3 #x1c37505d031833f66fa77548b6e6ab800000000 2 #x3640fe71cbf773ac1528ee1e79100dcc00000000000 1 #x-237320b25043bc68edc9ae4f736981a000000000000000 0 #x14e66b0926fc39b363ed9b72358a80000000000000000000) 15 (7 #xa3c43062ea4456 6 #x-1b85852217f17c66663d320 5 #x54ba60b8e91ecec3c0ef038904000 4 #x1e3db8f0adac18b3a35cfe877a031700000 3 #x-45db1c3a38e1f4fab866e6d4ff0019400000000 2 #x1599a53196ba8c0018b059bed661c4b000000000000 1 #x-9aa0e059e95705d7c831c4c98ecdf8000000000000000 0 #x-201969965f91770c1233ee2cf8400000000000000000000) 14 (7 #x8a8920292f61fd 6 #x14688e25efafa4f628cb334 5 #x-ad96c87c7346810bdefbeb85b6400 4 #x12afb56477623b1518f89f268a20400000 3 #x724066e3ad8b1b4b35ae386d690ec800000000 2 #x-c440d0b99d5f25929758bff3a9ca2c000000000000 1 #x641f7e99a9381b540ae4fb105d9a60000000000000000 0 #x-2ae02e67022d435bb11a9b2c06900000000000000000000) 13 (7 #x-a3a7a0b42d2740 6 #x16a3b5aea2ad75b34cdb50 5 #x23678df1814db69e95828327a9000 4 #x-501cd847f5dccadd726183c945ab800000 3 #x6e3ce347ec64bc44d140f4c8faaca000000000 2 #x-5d727b8508c7fd5569d952012ca90000000000000 1 #xc7c6e9ae987c12455c5de6fb8d80000000000000000 0 #x451777ddb8f77059faab0d08dc00000000000000000000) 12 (7 #x-3a41dfccd82003 6 #x-3b1dde679a6e923338ed7a 5 #x27eccd8c6fbb971088a4f8ca00000 4 #xb6de596bea8aa8f5ca21ee90cb7000000 3 #x-1f383401ebb197b73869e4b04e9d0000000000 2 #x18975bc43a9d22754e935e99de1b00000000000000 1 #x-b02013f29459cd0a3ed65f4c6cc00000000000000000 0 #x4dd8c1785813f98d2ee80cefd000000000000000000000) 11 (7 #x67f46ba8c8acdf 6 #x67848ea3b158948388940 5 #x-16eb987acd45cc68db1fd3d270000 4 #x81a069c714e5552577e26c99298000000 3 #x-58fd35393528b26ca98205990900000000000 2 #x-43aec28bab3b39b096ad492555400000000000000 1 #x1d3b3c27860f96711c46e48684000000000000000000 0 #x-8ac59e9e91ad58c6836f9ac8000000000000000000000) 10 (7 #x868d660d72949 6 #x65d740585afab8603e300 5 #x-1fca926b8d3826b3303338980000 4 #x-284a1823181664c2dbca2ed6b00000000 3 #x432d698016763d153654262c7c00000000000 2 #x-18509e96c66b9a54896df44e46000000000000000 1 #xaac4e805afa266c4d8da26210000000000000000000 0 #x-8227ef99aa0df86122fa8f80000000000000000000000) 9 (7 #x-29b9769beb7872 6 #x-173d17969edf50c878d80 5 #x542b7277e74468434e86e3100000 4 #x-6fd34493cf69a4ffcee18f4200000000 3 #x-67d144a90d9347312585e1fa000000000000 2 #xa4a4365d3c83c3e3f569d99a0000000000000000 1 #x-41a4fac822e996b2b79969680000000000000000000 0 #x12e55733d16790a49adc9a00000000000000000000000) 8 (7 #x3c4885335a03a 6 #x-66773f19fcfe65fc4200 5 #x-12d8cff3b4c0aa3cd8cd2c600000 4 #x488b283731f5092a8045c16000000000 3 #x-47668e46d73ffb4c757c2310000000000000 2 #x-25720d5cc07875ba58f91500000000000000000 1 #x-13a6da5faf18ead47e3fd600000000000000000000 0 #xc2e11a6cbf3c78cf4a16000000000000000000000000) 7 (7 #xa0e54cc29c2e8 6 #xc26d5fc8777e6499000 5 #x-72572459f6270b68d54a5000000 4 #x94d834795e21f45e41e28000000000 3 #x1a20a90301ef4583163a8a00000000000000 2 #x-9c04d07dd66ce6b0a6276000000000000000000 1 #x42fb8db824cc823f5480d000000000000000000000 0 #x-2efc6db304ad84ac1168000000000000000000000000) 6 (7 #x-20784f3ec3654 6 #x15d8686b9e2c22fcc000 5 #x41943833d206e187816f0000000 4 #x-6a9eb9e1d02df24fd77e40000000000 3 #x-10a37506e1e686df2986400000000000000 2 #x1cd8431fc6bad25e8a8d4000000000000000000 1 #x-9375675a56ad288fb460000000000000000000000 0 #x-b6ffdd07201ed7ab9c0000000000000000000000000) 5 (7 #x-14c2fa79e54e0 6 #x44074cfff4956028000 5 #x-4a4a3db3f9483f82c280000000 4 #x1488c23ee04929373f1800000000000 3 #x-175536754ef206db8958000000000000000 2 #x1c9c1daae83048b4a968000000000000000000 1 #x-193cf949bcec4fa1a380000000000000000000000 0 #x579923b0811835e6400000000000000000000000000) 4 (7 #x5ae559bdcde0 6 #x-b716d32869ca4600000 5 #x-3d2b8a4d086eae215400000000 4 #x4e56a277df2d4d3466000000000000 3 #x62e4daf0884dfa34290000000000000000 2 #x-13402465e857e507b180000000000000000000 1 #x8e25476268d26fe3800000000000000000000000 0 #x-3a04a8a242cb7b8000000000000000000000000000) 3 (7 #x11bec197e900 6 #x28fad018984cee00000 5 #xfeb63249e98359ac000000000 4 #x-3a44a095483822e9c0000000000000 3 #x-552f845830317b1880000000000000000 2 #x1e89f8a4ccd4dc0a200000000000000000000 1 #x-810a9b14009c616000000000000000000000000 0 #x-41e6f46f7fa83c0000000000000000000000000000) 2 (7 #x-59322836200 6 #x1fe391124b6c4000000 5 #x-8991a7c7c816d60000000000 4 #xfa158f917e80f8100000000000000 3 #x-1cfbe59eebb3620200000000000000000 2 #x199a511341dfb88000000000000000000000 1 #x-1de18a4e917c110000000000000000000000000 0 #x10f25c15f9fe800000000000000000000000000000) 1 (7 #x-2b8d495000 6 #x-1323e589549b8000000 5 #x-3a7981832f7da80000000000 4 #x-234bda26bf0def400000000000000 3 #x5944c517ac603b000000000000000000 2 #x-78e8bec6d348f8000000000000000000000 1 #x507730067e7d00000000000000000000000000 0 #x-1cc019025b4000000000000000000000000000000) 0 (8 1 7 #xe0ff30000 6 #x3170a16debc0000000 5 #x52fba1fa72a800000000000 4 #x2273fa565aedf000000000000000 3 #x-4f39dcf3dcf50000000000000000000 2 #x611c631e9f440000000000000000000000 1 #x-3b1349669e000000000000000000000000000 0 #x133e8f3040000000000000000000000000000000)) 
  (svref *ec-g1* 149) 
   '(150 1 149 (4 -1 3 2975 2 -2531449 1 560376138 0 #x-1f8e4e082) 148 (4 447 3 #x13780b2ac9 2 #x5169563a7358f 1 #x10805296dc18c826 0 #x14becb402e4759271) 147 (4 -94317 3 #x6d6b475e77adb 2 #x-3310497b970901bac2 1 #xa554d4d5356f8f063d643 0 #x-48bcca7ce9302ec8c0367294) 146 (4 12492905 3 #x4342daf2c62cbcfd 2 #x9e8da94f343fcb10019f3 1 #x2e2e240f68451b50b76815bb4 0 #x3f2c66bdf0cb1d95f3075419c74) 145 (4 #x-4576306F 3 #xb6eb83ccf344380371 2 #x-3610b06f43da529c4e5381f9 1 #xa87ab64b1c48736d51b0d416bb9 0 #x-11df3f2e7d7b7ad89f09af35a13dac) 144 (4 #x12f4b76565 3 #xc2c0d19ea8b70aca360b 2 #x360801931d0217b99b839a3e4a 1 #x-7888e3e6184a3b5c47e6807428a3 0 #x1865362b3f6a7d6e9278c7817b3def2a) 143 (4 #x-405b60be806 3 #x6054c1407b8f47386ba42f 2 #x-c0d61ea817054660774466c53ef 1 #x991191170a3f2bec8c93f48da2e8df 0 #x88ff7d3bc9cd785f533c90ec19d12754c) 142 (4 #xae1e26bf715e 3 #x1846d7c579dc3c890a389a57 2 #x9969c3b1d03601a8d0bb9676d32d 1 #x1d922f88dfb3db92997438ceacb6381 0 #x157fb106219a0f957a06c707689e9fc1ca4) 141 (4 #x-17db3bc3ad3ff2 3 #x3434eec76690a2e77f9f6022f 2 #x-7aae25be49799bacd041fb97bfc1 1 #x-3b7c86bdbdd3c4e4d0436ed319f2eb458 0 #x1e46b87459e374cadb8ad53aab15cf8cef98) 140 (4 #x2adc9436d08deee 3 #x3c37186b23f470cdc92efc583c 2 #x1836e23d31fbf92024f99998151e9e 1 #x-345b1a96bee285804c3cdd6776fbe22c5f 0 #x1800f4263c9cc6df91526f432152d1b9e63ee) 139 (4 #x-3f9848a39a046e18 3 #x231877951861dbb6e0208cf3355 2 #x4be3a6a19921058b49da1fe7c1248b0 1 #x91b7207b8a141875a7ef5bc96a47cfaa21 0 #x68b8b31c535c767241c092ad9a050192dfa44) 138 (4 #x4e4a647db96dd8324 3 #x75d76f786b580fe551565d49193 2 #x7dda6530bb4cb70162987a0b74ff71df 1 #x1b5f7dbd535ffa252f8fc96bb5e4443dc12d 0 #x-5ce57eee679aaeb17271270564a3e9ef58d38b) 137 (4 #x-502857f34f1215cabd 3 #x-1cdd2a1cc56bfc6b31086e60cb72 2 #x90e86f21423d4a288d3089ee3aff143b7 1 #xe082beee7be65bc7d032a88c44a165ce0969 0 #x-61f9ae4067ca51c473bf0b717b2a06af890b99a) 136 (4 #x44457b032987021f33b 3 #x-12ff06a80e2439cfcf0caab0fae49 2 #x7884801934c14abe54a14905e79d46938e 1 #x26f688ba0d89007efe128d3caac006636963b 0 #x-1624a1d573c67894d13bbea6c70154e2d7c426ef) 135 (4 #x-304a5c51c62bf5bfeb35 3 #x-2be7bd797c044bef5482a31e88e1e 2 #x4a25d58cf3532304f1872f720f3d4932750 1 #x-f8498be2f7921e1a41626347a210889f1799b 0 #xcc71480b5cbcac35c9cbb2dac42f4cf64e773670) 134 (4 #x1c439d1c1137cf8391341 3 #x5df305277044b4c9ccfa5019d5afb 2 #x2239a22506bf9c83cc7f53a89d2aa2849d55 1 #x-cc1b9ae5f2d451b2b2fd7f3793b0a6304e07df 0 #x87d65df7b252cb1af6c1012e715c58b48a608a9b9) 133 (4 #x-d9c31dce9f34a97f3ca67 3 #x36ec0fbebdc9a7d13b64bd92ccbc63 2 #xbd792996c48501dbf19f663806f35be3c287 1 #x-3bff299f3463eb68d3c0f88eee0b069aeb738e6 0 #xeb490b7227fc1e7855be94e6636a230aba2379a2e) 132 (4 #x558ed11b7fe5668e6e57dd 3 #x9204993d9ee8302cb87c7f96ceec78 2 #x2f6cbf4e7203f58d924875f1669084cc5913e 1 #x-1b6f1fdd4769216a7439ecea8dbf9ffe93b2e60 0 #x-bcf213347728fcb7e3a17654fbfa9a0d40a022429b) 131 (4 #x-1b1b6fa11072157aff5e7e8 3 #x-237e1b4fda1eec1f972bff378cc90b 2 #x74b41514374e7c8702c4f703324be3321bde2 1 #x561409eca91fbd539baeddeae3ab00b9f8f4b557 0 #x-4f0bd6e24db8aeb2783b05e01c012ada6ae16828bbc) 130 (4 #x6ce74bb48c385d0992a6b90 3 #x-643429d9506f31a305adcd3c3aabf62 2 #x-caae0df49872ecd1e1ed734501c4c41479f5 1 #x1e33f8a901b20176de9cc3d92379206889cae9752 0 #x-5c51a59f4492a966ac138869ef3e67929c8556e7a5a) 129 (4 #x-150e7ffc2b9f233dfb863c21 3 #x-14baa22f7faca1c257142a21380427eb 2 #x-6d15f886973fdcb25d9604eb634c5060dafd67 1 #x13953b31a8b9149ddc48a5fb9b9315d9bd952974d 0 #x47d731fe5de67675c55df800b705d0e9ca6c08b0c3a0) 128 (4 #x2f3831344d2e08c7d318690f 3 #x-10a9cb9671efe82d35cf939df17b338e 2 #x-2543d49639641adf3c36ee1dbe4bb52bc26be12 1 #x-238950674b691d254f507bb658a91bc0d6f8a995ab 0 #x1a166c1373cdac5a53883edcb79c44bd6bc978c7abe04) 127 (4 #x-3ef4a5a80db69b3385f71f6d 3 #x71751d0377ac556a003512503d11a4b9 2 #x-7332a380b85be7dd72fded098946c6137b4d1a3 1 #x-ad7d83af9817d9fff0004345274ea6794bf4c7894f 0 #x2b4fc23ae3d13d4aeb9206768372da42e0567fbbcbd1c) 126 (4 #x-10342eb262cb2134c9a38877 3 #x1f96f7f80a656f708c5761a9ba1e2ef00 2 #x-a9d05a24860cec0a64ef650a3c9785ffef9131d 1 #x3955cb350b01034df9a8dbafe03cb46944d418395 0 #x-ba71380ceb424e4c2515a34cf6ad5414377229f6bbdf2) 125 (4 #x149ea6b61c1852d580431fc10 3 #x31e73af6471a056b9f7b6a149f1b0fa09 2 #x162a53f60b15f1e9627c0903c66ce63cd38d5df1 1 #xd3783cbc6899757a68c4f441c6d70e890c04e4fc46c 0 #x-57005f0ff15379cc29a901df98ad9977c96d61b025ad0c) 124 (4 #x-366c3b0cca14f9c4581cf1580 3 #x-41874a634b51567f842e352d5b0f3c23d 2 #xcac414c2640d20473e6ea976413596d6193c5b76 1 #x393ddd47f9780bd7ce02080619a82c30ecbe1c286713 0 #x-ec5d5450555e49b05d5a54e4919fc94288df8451f388e0) 123 (4 #x3d231769b1182535c080a75df 3 #x-21f508fa76c1ee5f81db93e8a2023b0205 2 #x2bfa9f63b1b2c0e2963e6256a96b3fa4a89d2c300 1 #x26e09051b9c0129dafb285f23ba20d575c7b78f95b5b 0 #x-128a02fb2ff6afe9d85e9d407ab604d7a32654c4916c24) 122 (4 #x322fd405ed6a2e00af7c04d09 3 #x-4d786dd81bbe2c4524b81fb857360df2f6 2 #x527aebe943f528260f22db4b81d7d661cf6e7a0a9 1 #x-26ac0637f823c8307af0f7b9c8dc8bf2c0e2306b9915f 0 #x9d724988b780a940c4eedc31726eb751757e889e78541c1) 121 (4 #x-1321e6cb2b32b3bdf23dd4876b 3 #x-15b4088d38f49b341d42991eaa7bb6a944 2 #x-686156e3b8f2019011656f1e3037bfe7b44ebe25 1 #x-b26ee7cbee9bf64586e1e87216c098f7e7601b484c4fd 0 #x2afac672cf177685c1e33dc21416d0619874177dcd35a0b6) 120 (4 #x1ee407c54d2e4f9ee5276c62e1 3 #x1900208931e8c33b85237ea27f93fc1bf00 2 #x-28a4b8ac3d54993dc672afa19c8a24bf5aa79d9fe8 1 #x-ed9384bc274af6c1f89209566d42c66cd9895a2140e27 0 #x54f8591d2203adbbff385880cd7a52de62899d3829823469) 119 (4 #x-6a372e8d9bc3face9423c1588 3 #x50b1aec0ea8ad2cb924592cc61ff515f4f0 2 #x-9d3ba91909597c3cf73f73fe10d1cd46da7d3d1164 1 #x38d6f6f9891024b11c8f2d6d4b740bc89c69b27e474dc9 0 #x-2d708cd047793f6d2c3b82644fc46b092f1396dcc480d688) 118 (4 #x-5f921b5c1460c4e752b9c9fc04 3 #x5c6abac5eadc2423f1d5f982dfcd9f87ea6 2 #x-144fcaf3596ab8f24ac70ca4c71df050de10763143f 1 #x141dfb89b3151bdb197c2f0678f4f64656696f217aa2c3d 0 #x-3995c2f9122c49ca71ef22105fd6401253edf4565ad69d008) 117 (4 #xc2334cd6bc8cb82b1b9d589024 3 #x-abd92c11fe005ae533919ac383b438c1046 2 #x-bb877ddb44218b5657ab5f5758d3988fd4e88117ac 1 #x237b65be21da31bed6123d5762451b068fc2f2a78cfebf8 0 #x-cb2fc2a79bccee40a9a97a4edcae8f2bb482ffa0633c84320) 116 (4 #x12f5eef83c7d317c59a557d858 3 #x-3bbec8dafddd842f7330a3126c8f5f92b3fa 2 #x547ec0d53fc7b678819b26ca57af4dd4021364c61c3 1 #x-29b240604e6af86883941fe0c63dd40139e4fe16efc15d2 0 #x-14c37ae2588478c938cec739cb2580c658586ace7def83e448) 115 (4 #x-14f6e11a146a06a7dc81d961004 3 #x-6dcbfdd60989754e5f54fd5f718738b8ec78 2 #x1755f3d1cf2c9be79a377a67e3269aeeaffb0b23d524 1 #x-16fca730135371f9c6b5df243cdb2c58e5da94a1c206d884 0 #x1028b68972f6edf1786ea9f9fe31f6b18911362240a16aa6d0) 114 (4 #x18d54337941b62466fce1df68c0 3 #x-722c61a8008c53a8616f618e043055d9336 2 #x336bf1f022dd3d6cc757270fdd6ab61393428b19d93a 1 #x-2ffc8d0d681f9ad544d22eaf242a32c048a6267b64258f4e 0 #xceb805044667555018227f5e2f969b978cf4ef43c1eafce404) 113 (4 #x-564fe08f825cc29367cd4524c40 3 #x1eea61d57f519fd346e9fc82a7d8897f7a6b8 2 #x2f568b69e8c5a941cf54d7550762fe3fc0be736225ca 1 #x8b9478d95e41b1c73f9d0a6bf646ff24bd39a3a7d348a9e 0 #x27c699185de4bddfd2a769b49cc590e94367731487120694878) 112 (4 #x-5eec97639e43b29e97342ce6548 3 #x52f555bbc56b0f97ca8f73380620e554c42ad 2 #x-733b1041edc9d34eeec059ce61d5a6041d27d6aa8667 1 #x12877b32f18b1a8c422f26c6030b5a2ae22a77baa34e6afc0 0 #x38979b8900e920d8afa8dba77b7d3546d852e179f0f8ca0e904) 111 (5 38889 4 #x1fa155340c5a417ce1cfaa643c99 3 #x4e855b39b3437b91277414fce83a0391ffe0c 2 #x-271fbcce34a99d0ba2f6a74578a80e0e8cb21500239b0 1 #x2c06ae50f9c1caa82c2e217d2308b0276132f312c9ed272f6 0 #x-3458b9f9438b60454e37d8ea92eee225264aedd2f1bb6d31cc0) 110 (5 174500158 4 #x2e4db61bda20a6d004e68bfb32dc 3 #x-98b40fb7cbb1db8c189bbaeb6f77c332389e6 2 #x-5b89c47a47f5c4b8e3638be9c5fb0ce24e0831a21d7ad 1 #xc8753e7a4cd65cfc3985c7792558e1c5705aefab1ffb4356 0 #x-205274068fa212a72079334d5e3ba4453b55e82ada55c26f0bcc) 109 (5 #x1b59c6c4f9 4 #x-8ef886c5c8ec82a8cdf86b338f9 3 #x-2c29603b94a434b49a5d01bfdc71a7327f989c 2 #x-68f638eecf60e61e85a9692bd7b86a74b5a49830e901c 1 #x-bdacf57a10fc35a55b6746e9e731cf362c5ebcc75a4502c6e 0 #x-58998a1e2aac229820b3be6b35e27f9fe77aaba1540294a0b988) 108 (5 #x13877eb08e92 4 #x-df1b977ef8ff5675a15a97bb6e18 3 #x-472c537cf165bcdc8ac9e447cd403a57a9cccd 2 #x5e6af5406720e532c06bcf621a60e662cdac3cd74928a 1 #x-1ffbbbd1e1cc2e54350b7b50c563d3a1fdcf5b5627b16cbc98 0 #x-6d58c9d63469ef95901f75f61406d606fe1a1800e52ba7cc7e0c) 107 (5 #x448107daf5203 4 #x-25fecb17136abb880880d6a200829 3 #x-2a6cbf8e8d72dd7262f076fc63c228049b761 2 #x2fa24f823c26fb3d084874c46b2a4c02ee3f29e694b826 1 #x-13b7cf4c6088fc9823beb669da84c80f1b09891000b218750e 0 #x7c200e01fb5ec74df34d68c1236cc61ba6034d8e37e323da86d0) 106 (5 #x2f4d50b4682568 4 #x-3d2fbdb331dc8b54afc82c56556e 3 #x10533299491b997588e0863a99a1c95198bd356 2 #x774cbc92c183fda002eaee263e02c5ba5d25df8c6b3caf 1 #x63a5dec0f4355c17241041d1b8496962eeff1dd932ab19be0c 0 #x3b85a582da8256fdaf61757b3a5b3220417453fefc9fbc4dcd848) 105 (5 #x-311a0afadf04cc7 4 #xaca591e2e7d8acbb076cc69d8becc 3 #x27679c0dc91a2b0b841d003334e678a4ec9100d 2 #x9d74b85ce41544502870378ef2bfe0825b3a8d9937e918 1 #x140f9448e757fe7ba930daf1e7c2fd0eda60f4418b7f1f8ea02 0 #x909080cf0f8f59fde7be015fb422311b3e9cd6b39457dde4798c0) 104 (5 #x-2ee140dcea7cf4e 4 #x16376d2cc33104c1bdbb8d1e36982e 3 #x229685054771bbdf7de6f7f51ed14d94b696a5c 2 #x-13cc0aad3728bd8d9fb819f38c16b0730d8a203e25f635 1 #x14633768ac48afe36e750117d5295a18964df426112eb594be6 0 #x97350e46adea5eff8fc0d79e19756704d3378dc16e71fa1a4cfa0) 103 (5 #xdb39b6138a2f9a3f 4 #x1c6a846e9fbd6fc3ffb3b3e7100aa 3 #x-377effcd21b444eb28e4a7a17f2ee608c22dd58 2 #x-2a376927481bc02a2daf711b0f36201900f1a8b9f809ee2 1 #x-22eda361221ef29b79e91553f507a8581650a5d421f6ae501d2 0 #x-dc881996adfb31535e51120e955bc04c3263b237e127d86ed6690) 102 (5 #x-6ce282ab813a7da92 4 #x-5a16bda9b0895d9550609d2d78ccd3 3 #x-f266bec5de3a3f4ccacd1a990f7a1f892f67aa1 2 #x-73f51cb0842edf34588f955fed3402d83e267c549880826 1 #x-a232c0b2a1947f82c320bac4b42d6fb71ba2a44237e78c56898 0 #x-52461153cd11162fcc458df69b268a71c5d8681da612472f5d9ada) 101 (5 #x22c389ddbe85a8b6dc 4 #x-c73a995b3dec1a55f8fbb00329f3e9 3 #x-16eb75c55e9fcfc2d874bcc54e45ff595a3da59a 2 #x-ab1c0bd1a48753f85aa79fedb70018c8909c40a27e6cc9a 1 #x-f4bcd7e1b9fd96dae954e4986b7a389fa67cb3424c747013db8 0 #x-af7c7ad481337b7405ac0f2229903a35e29b2cf736a635e5aa1ccc) 100 (5 #x-94c4070e1aa3b755f1 4 #x-2a1668fefba4b8a9dfa8b02a433bfd 3 #x-344d53e47de66597fa552460bcf720f03cb182b 2 #x-3d23636e7b119e5b94e420e4c6e91e3b6c294a968c22a0f 1 #x1421a312bf93d9f70fb16125145e8bc0d9a0547dd37077147dc 0 #x-95bfac4b2c5183ea0206e99babeee1a783f3c229eb4c1e44c88922) 99 (5 #x24e5b028f2aa54b23c4 4 #x2b5d55a36777f6dc9b18f7f624bc714 3 #x3f0ed629c032f43559ceed54b9e44cb8f2ca87e4 2 #x1a8b54e3d3e03653611ecf7fc9d3c9e0c3b10f575a8884a2 1 #x3717ab5c068d470a44278547db0538a55503fe11e4d2d56de4b0 0 #x12371a4e471db7c96306cea47051f619ff10e87bb30f59b620ef6d8) 98 (5 #x-8dd93fe3d3b7d362f1e 4 #x6026a742dc4db324b795a4560bc7a95 3 #x92b3ff631d14c8eef8fc5c9e212ce54a181d3067 2 #x5475f0453ac65f4813ea968c303ad1f26cef317eb5adb288 1 #x7740c8e421d04e431d7c4a0457158b2d28b996d03459d0598d0e 0 #x554eb85b9fa4c8b60110592d0a5489fd0f7b9ba0fb8013be91f165c) 97 (5 #x1fe3da03f41a8067930e 4 #x201cc3e40aa24586f50a809552a85d3 3 #x8422cd85dafb4a80769ae8c09010da9b96598aa9 2 #x8a750f946b79379bcf7fef661a668abddcaf28b190d94cd6 1 #x5dac71523045d9a107bcffc0adc867fc81e95156aec899fa562a 0 #x9e3f755ab028f8174f06fbf4c195856d348567a18cf2a910a192bd0) 96 (5 #x-5edea6e73e112d2b6379 4 #x-11669b10fa092fd367204826fe53176c 3 #x-84ec0e93a02624f25b23faa9a3c6764d55d73434 2 #x60fbf39e0820fb1123538fbd6848897e7a307c875edd92e2 1 #x-8e14359ef19f5c7cf15762f9af814ed988c5f08f0093d8ddfbf0 0 #x6a08d9638ca8afdc91b086e43b23697070a8f2b719bdbff108acdc0) 95 (5 #xbc73333316eb8e28c0a9 4 #x-28ba8087b6996e1193bef871ef3ad3ab 3 #x-27fcbda1582a1cb09e6f471b945830439811165e0 2 #x-acbf1331737d76d0a1d2b6f0db5b8a96497dbfa7b45d7868 1 #x-226ae5e921a6eb1513fe8031735ad42f2f931dd2b8afc9ebb8142 0 #x-1130e25d84130ab63b584ea3b241d0ba3a8b29831d316929d2bca778) 94 (5 #x-2b856a48fd21af208078 4 #x-13c56c9642b37e06d2ed03a2a8d981d0 3 #x-3c95d033143e0ca0118478a06148774237165e62b 2 #x-2d9dcf5a1107ca0247ae7b579e970bad49b7e45607a95e705 1 #x-2f3e6552f7c383339a9a262b045cc2740759bcb1893ad42d69c90 0 #x-413996f87c4b514ecf66308315932862a8606ba3b1af10f061a69958) 93 (5 #x-555be94391b301351210d 4 #x5f1061bbfab895ab87c0748bd589ce0e 3 #x-1452ded89bec1f7e955fc1c68e9bceffdcfe07065 2 #x-53f80952c0a69936c9974f9ddd8b5f0d2549728e01a4ea3d6 1 #x-a9d9aa4d7e63d63e5ee2b9cf6fb1454f5c3499789c95ec8a4f22 0 #x-6a3b6b279e59b4773bcd5d2da76ee557029e1376ff18df1fb7a3c5f0) 92 (5 #x16bdfe2ae8575c36cee3f9 4 #xf0fe8ad8301d66ec507f41430729e33e 3 #x6f6c44f7adaf54f38061a9ab920fc90c9d12dbc43 2 #x-5178ad98480185b61a8bfc4f82d9ceeb372f42634ef9e3ede 1 #x54a6084aceeb5085e971c11e2ea1f0963415728d2c59004f7a282 0 #x-39881c522aabc2dc1d4958b35913ae55e8662d5a8044218a4691634c) 91 (5 #x-313390ab89b2f508f17486 4 #x9bc3b1840a1455ee0f544a574535dc2e 3 #x1100f06138f0da92e23424d021111049eed6db7210 2 #x1bc2f310653ad98f1b80c555fb5514fb5a63297f111e34c1e 1 #xaaa7d09d5cfdf6503ea157a52df7692aeb9e0a1476969c4a306f6 0 #xb1391a3e8b5771c72a6909e08b4b13251abfcf6f3b0f2fa0653d3338) 90 (5 #x223066ce3c2cdf41267f7f 4 #x-1b2e0e2b19a03f635c577980523e903b6 3 #x10f2fce5937a5eb0d8af1f7ce0c7eb329800dc89a0 2 #x11a279115d1ee8c8bbe5e0e03a2dbc7be7e441c2383a16cc48 1 #x72a86086e3def6f9d43221b046810fce5378e2a906fec78d3bc38 0 #x2468a910d761c0aabd2c9ceb04987ad57b37b3c49b5dbe5033f435fa6) 89 (5 #xa5ffca595629d5a301ca8c 4 #x-4e10c33a9c04cc73c7e95ec103ead3fbe 3 #x-65ae13f1ed99ef14b49a4c9cffce024b674d190b3 2 #x25d2da6d581e65f5841c08f9d8491e5f577f2200e612e2452e 1 #x-9496fe36f2cafeb8a8dcf17cca5c91116698d6949e1e149eca9a4 0 #x363d2a2cd1ede7732ed98cd07cfd2989eec1adbb0496bafc995b6c354) 88 (5 #x-2bde7ac2a393d3a151c1d54 4 #x-403816b115ed0c2265c9e7c60882ba4af 3 #x-3276667a2618e7ebf81f80bbdb168e3afb949b1ea3 2 #x2db79e6ba9bf06f0271a6cfcf491c87a4baba00d030f5c6748 1 #x-1abba71b56f54b5834166f6119dd496c2f8757f929de16c5dbfe92 0 #x1bfd83542adbe4269f1650d675ec36c8d28838b4c585e9b786b2ef7de) 87 (5 #x46560d3efe7e0f69e2374f0 4 #x64df637439747fb4b1e9839e6bbf3b9a8 3 #x-523c07d9c3a6027f2a74958a04be466377dcb91008 2 #xfad33d994f1a498f69f83c8f29ac69de0b7024ad590b52684 1 #x-101ef1225b6910bd89b2908131c2c7d04dcaa35a81dc5a59d51c30 0 #x-4b151c2adf1740843c0b80be3159606261cc130dff61f52ae9fa682e0) 86 (5 #x1e22e8a14ba57fb50183a20 4 #x1639761c0a476ca1b44b3b41823a11d534 3 #x-2f44cb4699ab24103ce28c6c79017de0df60c1f1bf 2 #x-46c300b2584218a059355b51308227d0c931723ca28be238b1 1 #x2c780a62c2f83d7909f4da17a6571e5a973f621fb55ed44e827f00 0 #x-ecaf0435ba11558dc54984acc6fa226703b6991715ee5c21bbd2d58e2) 85 (5 #x-14553067fcb049e99e17866c 4 #x174e972b681ecd56e7020a0cd3a0e5e963 3 #x52b0581c0720649a322b49b73151f3b7221665f9c2 2 #x-c4e3f48d3e4491f9fe83f0e79b56269ed2d0ab572657edc3ae 1 #x7ec1a9adf59df0e390a3ae929a7043a31df220dc08f3abe924ab12 0 #x-1587abb626088af8c60483cc3f18358184973d8b6f42905c3e89092bdc) 84 (5 #x1ebb02a0b28d5097babd7753 4 #x-f8843133a19ae9693c06b3942a3d6c33e 3 #xf803fd4d58a92c15946dfc3061970c85dbb3caf764 2 #x-11f65e28303a470d13d4d996954ac22da6db80702c1da437977 1 #x820a03db33b11ecdf88e101fc5e2f70b6db3ee38b0383c2114ac5c 0 #x-d26e6e36cc0e88e96e8bd17d63c1e6be025495061f9d93c2c23fefc8a) 83 (5 #x-179710f4a9cf0f29e9b748e9 4 #x-57c949c91335d5a8fe62b044dbe9962c07 3 #x122718543f8d988f8479758e1ded510bd4596e9f134 2 #x-da38ee5157b5aed8424167d614108655402fd4824fbacf633c 1 #x-44efaf45b84605104725e290561afd1095b8a89c7cb968962822a4 0 #x13121a91a8934c71f774fc04c934a58e3528db807071ff2cd4e271b138) 82 (5 #x-11deb73c76baa4de2fbfc643 4 #x-7c04aa44318acbaf6e94cf7956e05e9909 3 #x3561392aaa5baadd8d49e23077ddba1870f8f35c9e 2 #x74c7d937b7f58f3beacbca33c7ae0b7a40d6190ad45569a516 1 #x-1e6b3278e9fdeed1ee4a3a836d8cabc1ebfbd0aeec218a22c95ae3c 0 #x4485975f7a030c1e930ad64e70eccccff7717036a187ffa260269584c4) 81 (5 #x1776d524350c1d01e3f38deff 4 #x-123a2bf0124febbb3f16fac05c76eab1e7 3 #x-1b187bf60fc28746d947e1a6ada2f9159e6ca3198ad 2 #x2b492fe64a1419ef884924f222218336740515234d7695008ac 1 #x-389bcceff0aaf835207d9e90bc5095d2bf7fca64049c8a7ab3305b4 0 #x6939671a3f2f1c5f79e04a408d02364c74f7fd209ed4aae78998893c80) 80 (5 #x-237b4cd0c43a599737a4cf45c 4 #x10b47641b5e3f59792d2997881316400e7b 3 #x-348950e9e82c2bcf1ff7d75051baf4be5e51537cbd5 2 #x4e88e04e7cbd14ebd432947013860c320d059ce9c9d8ba3ffd0 1 #x-37a6c5d61b7ce04900131236ccd89d9a9380cd53950752afc6f81cc 0 #x53ea81541e67e285b3d435e206fa23d8f44bb09d915d7a63544557df28) 79 (5 #x-61e45e16f2e27b5c9d03a8af6 4 #x2431055924e218581e61b02bd1fc3937206 3 #x-2b594353e74129195808085c758e4c072505655f5dc 2 #x545376987a4699b3fe48902c0cce737c4af6a44157e7e4e262e 1 #x-1f9ff3da0766af34b36ff074cc5868e45dddca10bf87f7181c06ac 0 #x-1b16e73a50808bf28c83edc3cdef365bfbd23cda3a3da79137e9b307b8) 78 (5 #x662c9913249be120e69ca757f 4 #x222ad07d5dce04b1ff25ee9b3191ef3c90e 3 #xa49f1cb964120dd00b25ba6e2bc346cd27f0bbc4fb 2 #x202955ec74683ae0159885bbd85e6a7577a6b9501bcf2358e7f 1 #x688e79de3e9b02913349e06dfb6f628b97af2ce20ec7c22bd30fd8e 0 #x-d048f39311b81ab39dda852a51dc7705a363473162112f6d0c73c575c0) 77 (5 #x14c50c3e031f57f1e13e78fd42 4 #x-10489d0226595c157acaa99e663bac0e4a0 3 #x455ebb30232b0f2775a6c017739d0f542ddda885cee 2 #x-53b22627cb647686488c02d08f3c1cd76b4dc29efdc98878164 1 #xdf46993fcf0386827e9eaf6b59d6092b8fdf75c241a35cb6fe11dc8 0 #x-17276bcd0a3944ba23d014de84114528cdd31dbea0a262cc4edb0fdcb60) 76 (5 #x1a2965edff84a3a2a0f1875429 4 #x-7accd674df3ac6294beecb2b3e8b47d54fb 3 #x350548c5531033bc854ed9df2fee29d35ed221a7658 2 #x-e250fcd2873aba7dab6ddca551943efddd5903732c1640863a3 1 #x11a6d279d6dcf4eb094a082cf721369e7a32cb7d566e6f4be7f86446 0 #x-17e805c9ea8525acd33b89c43851695520d7251dbcc6d35a1f53ec74bb4) 75 (5 #x-269c5a0b3d51f8d6bc5584263f 4 #x-edb514058f5f0a7c8cd6f8e4ea156bdf108 3 #x-5a4f9ded9b40690c9d7246af980372b4f59664a0378 2 #x-13c2a00582ca89b3b158b1472920c88fa8ef6b0582369256fb72 1 #xd73abd66dffe5aa3fe8262a4db5a3099ec0c73c86df26b8adb0f770 0 #x-934f39c7af3994045e9f483dd831a4d89f16c1d2727ef9bee74c3085e8) 74 (6 5662 5 #x-103537a000ae0b31edaf0937257 4 #x-deeb3ff938f058d0c82efbbc330f517cfef 3 #x-1069341720624f972b153f63503413a7eb48128ec0c3 2 #x-1068a3425a4dba4ad4700b92b9ebf22c41c90e13f6d10ef067ab 1 #x258edb97b629f5cd8bdbca791d15bc62a6cf3f43223518e72cfd70 0 #x137132e86738d4f268d172c53ba2784ed92929f9a672f265540454ca8ee) 73 (6 #x-698624D 5 #x-c237738ad228d6253369adfd9c 4 #x7e02104e7a052655da8aaec0aaa8d64db2e 3 #x-804d1cad550fe22f7114e604b6aae6f41a8c95aba23 2 #x-13a50f1729a76dadfbd902fbac3c2be551f0c223abaf2a14080 1 #x-1340fc97ac8f96e7358fe4ecc5c99aadb37c785e293b2ab82d69d3a6 0 #x32aff50bc9b9f5935e3def505d55cd98f144f2f1127f879d1561ba5ba64) 72 (6 #x1cc76609db 5 #x31983bfd24346bb6266ff52825c 4 #x381632403e9ed549bc9e9dcb97d2cbde5b40 3 #x324a7fa3a086ca2ee5dad7eb4c953ec69889ca4eb380 2 #x169379a08458472db988234858df9e4fb901f703dded13de5d5d 1 #x-269d41384c03f918a7724163151f71208381dece131945089fe535b4 0 #x43164162695d87a7cc679aa8a71dfc35f59ddab51499560fbabc880cf36) 71 (6 #x-11b4771c6f0b 5 #x702c418e81ebb5f2e1333919000 4 #x6acd09dd69362c8409e94d17679e93487382 3 #xaf4a6f684cb6837a0a045b1ac98e02e07bed19c12065 2 #x2d17b659c606d273f71639d8863c141c6050056902227989d91e 1 #x-3359a6d0c0b31732c2a0069573d8e7be10392571ee2fa29592bba53a 0 #x363ff7bcb14bd7bcae6ab349eaa4aa57f1227598ae88d8a1f49c61952e0) 70 (6 #x229d0804f1c98 5 #xebc77b639ea88dea1f68d3bf26 4 #x5bf9c3f7cb32d9ea752a87e69e26cca5c434 3 #x14655a783a0d0eb7e6910feeab9165f0f8062335f75dd 2 #x352c112c1a0d926c4dcb774dc5374c682e0cdf227c64057609f1 1 #x-34cd0ffc83f30dcd3a8e41d515729d0cfc689e8051a35883e32d8174 0 #xa9b3ad214b807f55d4ce05f2e0240c3f16c04fcaeb73b6f96175b2dc70) 69 (6 #x-159c68de66d82e 5 #x-14eb186f129754e7242a93455103 4 #x-45d5296fe200f484e426ba6a9a32a5e7210d 3 #x16619c6871cd9e3848a5c6bd0d8c04a5e10ca2becc77e 2 #x25277e5cb2021bf4d0f9bd788d19a1eaa3132cd8f99009d75a9a 1 #x-28e817cc52092c1799a904fd3b3359fafb8b02989c414bc8a3554e0a 0 #x-308c5a1f2f66047f4052109ff20f7dd32e27e14ad4a41a6babef898e860) 68 (6 #x7974853ccbfd1e 5 #x-279c36cc0e308cee6285d4cbb50f 4 #x-176c6de6c123ff52499475b454a850447b4df 3 #x9da3227ebffcd5fe9cda992bbb4557cfa03c2b5f506 2 #x-26ede61b93fe770079d2bc155fcf06b25ea1db8a844751e0ac6 1 #x-f82957f3f70d20ce7d9173fb59907ba7d5dba4264eb64426489a4a0 0 #x-6084d1583572b9320987700aa133fb49941aad05395853b451373d6e2b8) 67 (6 #x-1be653e1a25bf08 5 #x-d14f62301422da7e4d1dc441db 4 #x-26cc6e0fb243d7478af9aeb0b033d7c43c62f 3 #x-3f05898c8bbc5b59e8b32758eb877d2e2972314e99518 2 #x-3465b190dc2008f679c33553a4bd4b4be9d8a9aebfd07c59d7b0 1 #x1612a18a046344c720640088374ece7714a903e09db9f27d0cbc8cd0 0 #x-6c52cdf323dd311165a216b91ae9c6f9a794de89136d93953c1b8cf1870) 66 (6 #x41ba97a1fe073f3 5 #x77bb4208add988e6a6f171a1ef9a 4 #x-1aa4087d7ff3c93f97ae4b21e7a9f2fa86eaf 3 #x-adecdc0dbff80d6c7a8e2110fd647a2c6f37695e6f2f6 2 #x-5b217fed37383e3ff6127a3355569fab397e607478d18f18c39f 1 #x440108cb2206f32c686507c3f4b3d430dd4a8cb9b1616db42bb9a7ee 0 #x-4a6ef8f8317768df44f6b904ec946452fb0721d33daacb60c78557b176c) 65 (6 #x-58175fb26b405cb 5 #xc1de7ca0eaacf6e185c4b37d4d6c 4 #x1e94d03bfccaa2d0e0985466e06691997d764 3 #x-12e78744f930571ab56aa243f82e3aa27f84e1ee9155cc 2 #x-62697f7048783ed3f2b5c9ea6c372428c7e35423c7b178f3554c 1 #x721773f1354ebbda87ec6d0beeca937b3e7c2d69896a6a2384fc583a 0 #x-70c10e89e287a02b6f6c142bcadeb703c43a520c0f0f53f6385bfc9e28) 64 (6 #x-2b7414152fb562b 5 #x-f06aa9b39d50f00a33cc0866f06 4 #x73af86db302fd5fc375d6c03c7fa72f5a61b0 3 #x-16c173d8b11ca55c64c4074c6598975e766734be3f6f95 2 #x-42006e1138f86d056caa55d7264f6f33def289d62dbc0018eee1 1 #x937f2008c6ece23d61cc4d356e73f4018773a1013b3092a8ab7856d0 0 #x4127ce089301ca271a777bd6f4a077b5d4bf6012151c0e2f4415f54c7b4) 63 (6 #x3297ba6017cc427a 5 #x-20231ca2051cd7b20ec23c9ae3650 4 #xa2bcdf83243baeaece7986650393ff72ea4f9 3 #x-dd0dbd2d0b6b49b3a7614f24a1769131979801c827070 2 #x-32afd52cc84e11f671e9a7fb041caa06b1bedd1b91103d4de50 1 #x99eaf2c7d3ed70f1ceb27ab898741a704c4c8d43d4ae6f278f8ed98a 0 #x6f1a9d72fe18c15cde8b1bfc7ca830838e6a1fb4e01ea5187d56209a240) 62 (6 #x-8a1dccb35f72cdfa 5 #x-304c517672b436d1cd720a55734d2 4 #x57725d9012d006122add220ad8ef0327c43f7 3 #x110fc66f2f0e5477362d46f567236eccf10fc4e7207c3c 2 #x426190247f6add38416ecb0b28900a8d4117296583fd86f131a6 1 #x7bc2e2cd827011d2584478b4457c39574fe5f2012bd77ad73986027a 0 #x7078714336fbce8bc463e527512d3934346e54274fc501725ba0d877184) 61 (6 #x50c64d5471c5076e 5 #x-1476d8cf3735e733577e7fbeb268 4 #x-886a5121e9177dc51de3d0a7ac4bfe899a448 3 #x49aeaf4d7487f7ac65b951e5eb1b0d3c298addb9dea6b1 2 #x730c0741460b47e2bb7896dd28650ab80c23f6817ef8ad442ac4 1 #x3a23d14231f6b158c4796ac8f57cd65df0442a20096df93e346c80be 0 #x47afca62f235946072110a3123338da1b2c58b427d147b31d2059802818) 60 (6 #x80cabad52b64e7b9 5 #x69fe918bd0c067c0237057b8326f3 4 #x-194f880f2213a01e2b6f5f46e2926213b3aa08 3 #x931bfe7ab0a0f84bca81c637b4c48e03f7c629ea2be046 2 #x7c1108b9e219d5ab1f2c9c933975b8bc8850e8a391dfa175ef3b 1 #x-1d278478c3e6849b357aa40ed5aaf126e099117aa20caa692b827550 0 #x91e272d2e889a626da8bd017856a27b74c7f947384c96731431a411164) 59 (6 #x-2168348decdee8d3a 5 #xa6cf6c93327f1a852cada64974ee2 4 #x-1f146b60b4ad1a68f52d2abd9dbb0d066ec2b3 3 #xd29e0e0a1829136f4b905097d134167f6ad66ccce67880 2 #x5be408d3a233f5e3e97c05ddce43eef7acc77df33a06696b1b14 1 #x-738e9575f0c14a8bcf0a2a08900cdfe5f1b4048d79f86c88970bb2aa 0 #x-302034c869dcdd2424d49e91de13f67aabba066d10928e9ea4f03c3a4f0) 58 (6 #xb7c903fa028f40418 5 #x24e6f6a8e0a03632904e31ea622b7 4 #x-d6a35dbab6a5f450c56c70feb9fc3b358343b 3 #xddea4b2da07d695781b9ee21139afaa7b28a715a9f0a60 2 #x22274d855ab155a4b78ebb315a1a6dce4963b0695e292465b98b 1 #x-b1f814ebeeb97e44fbfed380e3e3e0c45638e4c0a0aaa19273e922f4 0 #x-4f1a10df6dfeda7e54be4f1c7dbb9b08903479d11c9d949a0cb7053fdf8) 57 (6 #x-674efb3b9f615b0dc 5 #x-110a223fe5faebd6c2713d7d41075b 4 #x1a2fef1e2491b8480a1cd013d6c2e533150a20 3 #x87c0be5a8994fbd850e92ff6e6d47512ec316180b95e64 2 #x-183f8b30bbed5e067eed8c886e72897b634add75b054dbd5f6c4 1 #x-c94cab846f27642ce7be534c8c8b8205f71cf93278592364e564b9b2 0 #x-4d1281bcb99f1473a873d127752e354f16050b64be1fc2f82bc9ae2b7c0) 56 (6 #x-4d91b91b0d339f8600 5 #x-1dc075777bfa7409051b1d32efc7dd 4 #x42121f36653d2cac74b7aed53a3802c16cce48 3 #x-4ad5a0512fdb06502ef7931430e5562199fbe022c903ac 2 #x-3c78534f77de0baf5630d112e41a9f84dbabad423b362747a1d7 1 #x-b7463eefdf3096152eb89fa44f19e5f3ae096e928a141ed93052dc8e 0 #x-31a474ed2d854898da88337bc20b8b355e342ec7c7bf4f6dd85d704eec0) 55 (6 #x5f3ef55c05b31cab1e 5 #x-d1e6deb9dc5a2c13749f462a1b510 4 #x498f0482647e7102aecdb6e8df8775974793c0 3 #x-18c72409f428ebcf3478ce7b3874b3def0f7db5890ff3a4 2 #x-3ebd81e4e388f1988b4095ccf8a54e8b5dca4c9e4c9c48f2f8c0 1 #x-85ba3d5ff44e9a5713145eb1ea81a14c6f2f3ee37376552887c878b6 0 #x-c81c6dd0ea919546dfcea27320fe23e184f29467ce89af6f59530b0650) 54 (6 #x1e9fa3aab94ed749a4c 5 #x20a1b3fc8c422d7d60d6e3efb8d42a 4 #x1ca06454e29f58c33eba8108415597feb229e1 3 #x-2fbe52c78c7ca2aaf3dc1c36eb7992f6a9238144e890fd1 2 #x-214c764a29f65b56e28519c1a09de5f3a0c31b33327b7408da11 1 #x-457a33c233980cb0f8af3fbc191d480864978775d95c9268d64b97c8 0 #x12e00d14e1ad66f60e9b0561ca94bddf1233643ba755a6961ae83829511) 53 (6 #x-45e4077df5c006acfb6 5 #x46004dcbc164b820964a2c4be7a371 4 #x-3356cfd8c4219b3f623babd8adc7a895ae06f6 3 #x-42d109b755627fc616db9865574b9c31e931ea0238c6310 2 #xeffceec1652a519af131914d8a7611d61b179119b24e5398df3 1 #x-7b6829f5bbc23efa08cb7514c9005efe28cdaefe75ac71e06ef39aa 0 #x23624bbe08489977895b98898972dee52fe41af240da1b05fd98db3b95e) 52 (6 #x-fb7bb2731b504e27a5d 5 #x31329159ac795c4a7c600ee03d144e 4 #x-671cf65239b20b78d6af52e9b160047447a429 3 #x-4a7a93df7e0820450c37c534086064d1b4aebd4393a5141 2 #x41a585bf306bca1c8df53064c59cd8ee52d031c32cff8aee26df 1 #x2731d68c7d654791f976f81612ce2b6de7d46e3e01df34adff2562f6 0 #x23fdd9cca8297e65c3a3371f384fc55989b28094e4547705db8a5679659) 51 (6 #x276e6a8325537009072c 5 #x-27fe0f44c8e3f8ed88be099ac1b68a 4 #x-1f27d9b14060ada8cc1ed63f4d9e7e8e06f8f2 3 #x-41290fa4eab542e7658e4da0dede7707714d3061636ba1d 2 #x6937dd5aa81a995f6cb05ba217803183a0793afaebdcfc995968 1 #x41e670505badc09ff34eb535604df72e5e68b94658f622ad92f213f5 0 #x19a95b73f736df7a2a58272d4146d09fe80c6fba70a6b3f6d2df0e586bc) 50 (6 #x85d9fbf0246b5c598d1a 5 #x-8ac6359b4a2691d94f3bf684a561fe 4 #x111b21ae47112482db2d0da25c233dfa6bd0d23 3 #x-25a6de4bdd1877a6f58e2a030ecf87d5432fa4be3f6314f 2 #x7f1d082b02ddd722f7f681b98a871ff80ed997884d25c1f7abbc 1 #x496ae8510f7c61b62f38a6307cc4c4c9b1a47b9abdbcd7b53ede4aae 0 #xb803535dea46fc5e6612ae96aec3befe25e40bbf98894c8c32a9d5cf88) 49 (6 #x-c9a1b69ea4186a085eb1 5 #x-97e640b1095e0fc60ab8276fcfb12a 4 #x3af92c4e769cf42a01c9a7929bb074e44a30324 3 #x3e1fdf0dfb2b19f92f31beab690ef2c7695f0b163d19f7 2 #x83a04c05ac1c25ee1e1a9f4629d65e7cb21cffd34df30a346b1b 1 #x42c2580639cf3f81112a31aeb40f0dc0e77ae853c9c468bba1dc8e05 0 #x-9f7fd03eb2d2f149c1ec2626aac962c62b9f8334fc21a76575483e434) 48 (6 #x-39f0e254f58f513ec3dc9 5 #x-19c9db75370a24ff4ae047ee4add12 4 #x89570a020256fddffef36fc2c2e923b8b7d5946 3 #x32da147c8386081c1d864ff7989e55830423300b0275a62 2 #x7b784e75c0009cfb96e9a7f2c7380f427038d5f04f0c56dd2243 1 #x34424a3cc601ad8074900de079f7d404d532bc1197b5f23411b91f03 0 #x-7c1537df4e7899471825d2f0cce5a1ca86412741f11ff3575220f9a162) 47 (6 #x111780505f8899f614641 5 #xbff4ce929de3b540c8dd52c7baca46 4 #x1163e62152d0647519cc8f88d0496103bac63929 3 #x5cd9b56c42ad7b5efad0323eb2337eeb556d9aebc0188aa 2 #x6c9cd255e1a5c5c93e94648b00ca872297864aa9b12890a3ec8d 1 #x238a6522a16555bd38753a35e40d39fca94fd3cd88a7ff13cfd2db5b 0 #x-9c4fe6f3abbbe69f05341b712f31c33cce844c6f98bc5e02febfddaeb4) 46 (6 #x114be9fefbb0f8d6813376 5 #x16ca905fc89b3965b215fa6c5535ffa 4 #x20e9029b81382fdff07d429f88717b1cfa975fe9 3 #x78ea5de07fda7cebac744c58b23ee54a6313e52c5887867 2 #x5bebb7b010b7614bb3a50dee83479624e9a7be30162289f2fdc2 1 #x1479f50e1c768f9266435e3865fc5adf616cecbf73d77f71613b637f 0 #x-84054075c372fe070c623f8fb91240bed9b69c56904bc40fa1a728956c) 45 (6 #xd3818ae1f913cbcb3d0ad 5 #x158e52fd0373301aba49c92e0095f7d 4 #x3b2bfda71bcb845e8bce205fdb13bd9245b08333 3 #x8225dcc54520624aac5d97bfab2ea77771f34585b9d50f6 2 #x4c358e5556c457c8aacde21c51fb342671071afc7495f24e6b2b 1 #x904ef4050078d718c61f7a9e2f637d74d555e5d5d03aaecbe15acb2 0 #x-53712715f3634db07c5ba534bf72b5a8520f226b06b83cc5979c1b7ae8) 44 (6 #x-2f5a790d9e24cf5eadbe29 5 #x43c46a0df82c0aea0cc8a5f850a437 4 #x64d0960de4f649b45ddaee64f11b75788caf6a9a 3 #x78c3b0a1da647d96daa163d6997a4f1910f6ba181b2e0bf 2 #x3e767ade10a7df8ceddaac4ae58c8f6c1ca38c2c076fe9d14500 1 #x193c2f40f86ac3c8bafbb70d718ab9f4e1c589dc31bfdb53c445b9d 0 #x-23adf31e542bf7f568bdb1673e45dcfa07e7ce4e911c70bf6802250332) 43 (6 #x-5fa3bd7c4031e83fda5753 5 #x-1865a0a36961644ee2e492a87118424 4 #xa1be67e115f748ce50cf6cef20caeb67063dd3c3 3 #x615e35940ce681e33208da692ba762084f6307f66495899 2 #x329be1813bf9bfeb06c04818ae6140398f231f2b29fcd4a9f278 1 #x-26808d5735aa23e9f34c27042c23149f1d8d1495187d94b72e7e477 0 #x-1ad1f3029ef1499ae78e14e6f5d891a4435126f710a4fd6e4d8a7785c) 42 (6 #x19a04eeb87ccbf74c9c37e 5 #x-32d81f496e5279bc3b98278577befdb 4 #xf3505faf5618d094519e77d767e9f1a3ead37193 3 #x42f37ef99a6a3bc56762b2a8a5f7edfe17201f9e16a28f1 2 #x2843d6ae08402ad42d8c5d4c29a432378619e0c4d6e3a1bc1cca 1 #x-3e74aa2c99305d107c0d05bc810b265c040563c71d299ab0f5a15ed 0 #x101fee1cf682b918e4767b4fafa26e9cde04c00b0d98b3fcc0752ab4cd) 41 (6 #x11a247ec33a7ffddea20a04 5 #x-39be73382b7b5c3564895f9c3b3aed7 4 #x156a3e331dfaa0cc5765184f4f0b22467231ee5bf 3 #x248c25ba4ef51756f945cc0f9b4182be921191e8b117019 2 #x1f2b14632539a387775199311a2e29f5561bf3f15c471d3714b7 1 #x-3e78b5e45baf446ac398f7455909be7a6baa2570b02b421a0e6684d 0 #x154adbda3e0960bcd0d5d10202ef315c64bc963c51faa83782c8de29f6) 40 (6 #x1194ccd347b6b8765c4c724 5 #x-21a694bfdebe83c878bfca4c7e765d0 4 #x1c3c44311540af60d911cdf5ff8ac740a12ac7a41 3 #xb65b8a636f0e442f3dd0a2967a0bc58ff8f27e943928d3 2 #x1745f7ce9a204dbf5a21c8717031ade2b2557762429d5c1d4d85 1 #x-33320c61b0b9342c847916e6ed87b38fbcfe90da00fa3401033f931 0 #x1328882aad634b2ee289b55e697856ecae7eb11a478ed3b1bcaa160259) 39 (6 #x-112374ac80dc137c203a28d 5 #xfa0f1902e20e3f57888f3e7cfc4ee3 4 #x22e478391cacce4bedc38d6d26ea34b48d5094507 3 #x-5e45c692f9a454117090cb2a8831d40712679d8fe8469d 2 #x10a7f1eee27853d01d72566a569371283982a6032f4fa5ec274c 1 #x-24f67d028ad13f4d58cc9c8febf8bd374699a7c22d856e5712752f5 0 #xe38142511a659d152022fdd715c275c037e69404ecfd7f6612ff42af0) 38 (6 #x-38b73b4c80c08c986494069 5 #x3e8163eb505da1fbf49880f02132164 4 #x2877d3b0fb83eac710eecf18a9b7b7ac27e794219 3 #x-f317eda8b97a6abd4934b6d3501d47284f2046ebe77933 2 #xb60babf949c7b9b0c548fb0af8271112dac6bde43985db639dd 1 #x-18375b5cf20e8ac31286aa2786a034c6e746c33bacfe2965f0523f1 0 #x93b1612ac04e0d6e22b834d42d8477994014ef57eb26bff015d0fe771) 37 (7 149 6 #x-26ab1677071923ac46fadae 5 #x447915a1b6883147b82fd39d95c617c 4 #x2c1b4f540a9265bccf7e58ec5c479e18d3d5a196d 3 #x-120f6dfd02cd081e0de8b8fc1feab18ecd406863bf1130c 2 #x766d9b61901a5cc5361d0a25fbef47e6c7b7f9fc4a7085a4873 1 #x-e9c2af177aeb74d0641c49333e0c3a22e221ea30b7b2d74d72c63c 0 #x560f18571b2ffd9199eaa38c896bb5fc2832429aa8484e9c8772f451e) 36 (7 1648983 6 #x31206fefb0d2b4107419ea8 5 #x9e139a64134d44712ce8fb638032a2 4 #x2d3a10258e13db438117ccd14735fb0f9318fa145 3 #x-10be88d69f9c7f8fddade211b9ad7ae3e5fda53847eea0f 2 #x494bfd9462e70fd05e7971aecbf8bef1b9e207d8700b02adfb2 1 #x-82f18bc3faeb365261f408dc019154dbfa48920b1d1e25fcb86cd4 0 #x2d9c9440ff857623a4738b6adc37f8977d578d8801b02abae094a4ccd) 35 (7 514740764 6 #x7a3c286b7dafe6c63a86b7d 5 #x-5fcca2a6e4d8c9cb351a9a7ac16eda0 4 #x2bab53bc25c724f8fbb83b68bfd6212e085f36a3b 3 #x-d643c2759008809bb9706e4abe139ad6541415e3daafb3 2 #x2b26a0eb461953b98fbfa7a34a24876265f4ba8e3f64c739d60 1 #x-446f21b1c5e68358b5e51414aafa954005a452ea34d2ebfbac1abb 0 #x162606a9b5630240e6d36bf1bca6d23aa41b9d6ec0cc3c4a1139e50a4) 34 (7 #x63b1cc7bd 6 #x4f0235be6f11c0433fca28d 5 #x-b845da5ed8d465c495a1b79da507853 4 #x27bb2489a74a0677280ab022304d432b84e32839c 3 #x-99736d311ec6be51f935751a6779e18fbd8467b92b8c39 2 #x182b9f7673b3fbc8754ae142812e6f6e47c39450d0e58a80149 1 #x-21771f9e557f76d98d6e90daf84962828a8d0bcba7dccfc152a8ee 0 #x9e4185d7c0a175148fa69b704ba077b8f88ad5892132df4f1b13f846) 33 (7 #x60593f8381 6 #x-44e85cc0d7b2c1ba7325b7f 5 #x-aab88459417a2aa945a2a117deb22eb 4 #x22137517e837c63fa5147711ed029f2dcce0f3e16 3 #x-64284e13cbf30adad0a4009e577f04973fd34f608eb8c5 2 #xce33db6655dad1d7ba372ae01cce2aafe22720af17aaee8657 1 #x-f5669240e1a3eff5e8549857d3d2f435dc55a720529bf7d1c68e9 0 #x411688002a64a9b94a57681621e65f3453ee328d6f1fdafdb271e2e0) 32 (7 #x1d8cccef70c 6 #x-b6f230aad24fd18d9770099 5 #x2875c4e26e8b761adee2d2c2e3a6df 4 #x1b8ea817a074a1b2acb8379c64a1bb413bbeb2b27 3 #x-3c204e1acb0244ca926033bdf6db7796af566a55707d87 2 #x68b6f19d7b439cef74b21754edbc4ec214d5c15bf711d81c42 1 #x-697ac84b0164a9ff4895e88a7b819cb4528784a6d528af2860321 0 #x18a4cf36524e141b31a16505229db1ef67ac83be47ace50ce67634f4) 31 (7 #x-1ba51b279a9 6 #x-8ba073d1766725a1eb4b45a 5 #x145a898108f68367143f167da69458c3 4 #x1503acffb59e2faa3e7b4b695e1281be1b725238d 3 #x-215ab38381a828aab75cff7bf7a95e506811d5a8f4eaab 2 #x32ab460da96d1719bad24739c37c42ffa6f087cc377c56a9af 1 #x-2a83b1d02e3620617e6f1b8de2fbdab0508cd31641c40ea72b13d 0 #x8924312eff78c499745057f896dffdbc47dcb4ed0c95ebe3b2f837c) 30 (7 #x-23af354fd4a5 6 #x1f450dd4531915234c4586f 5 #x2cbe4f538972dbe094871e7c91fc29b2 4 #xf1bf459e478c7cb78dfb30f9dee0b4f9d63bed38 3 #x-112159a476afccee9ff10f6e2a0c1fb780618b81b4254d 2 #x175e6c89759b488431fb27c0e3b3ba2a62f6301467df85b2c9 1 #x-100dbca77b43971cbe813a373786c8baf1b8bf9d1665bd82e9703 0 #x2ba3aaac349bb11b1d2bf423625068aa02c2d8452e44a3d351d507a) 29 (7 #x-3334f9305560 6 #xaf36c7c75d6e0561981e2c0 5 #x41ce918dbb561ed3a0aa20dc16869faf 4 #xa3d69739ee45347d5e30e84c9cb04a3320252474 3 #x-82482e164cc884c658777f5d4ef9377cb21be49361140 2 #xa462884ec4ecf44b41216d617e3e523026df3f32ddfebfed3 1 #x-5ab2e58730b881455bfc13d38279fd7e9fdfe60b52c16199975c 0 #xc9f00a68c0ea5e0ba86834f02c87227549c1f531d8f4d0e298de5c) 28 (7 #xe4cd01c13e8d 6 #xac3114adb554bcc77e1c91f 5 #x4d29645bf57f44d1fdf722c6d3c8cf78 4 #x689ec14ffc77690e35cf9393d358f660d8a0baaa 3 #x-392c7f2ef6c16fd433ac5950a495d6d04d9bf297d31c0 2 #x44e27ded2b5ad308f3f933bc92a8a1458dbdb58a0c3f94c36 1 #x-1ddbf8c7a3801301d59463340d5c3c74c0b7f221afbc9920f451 0 #x34888166e20d6e369d02caddefa680cd5d08b6739101ef2c8e46ec) 27 (7 #x282d37ffb9f0b 6 #x2d926b4d2e0cc9e54e32516 5 #x4c48b25fd20bf15c27eaff70b6a184a7 4 #x3ee8b6840f9e6493e6fd0347dabcbd7e06d7e078 3 #x-170b8e3c70f91a75f12eae1d3438a7ee8ea6a0e59abcf 2 #x1b80941cb7b295c5ef5d120469410586d7d95f3a114cfacfa 1 #x-91f74ca40e787273cb4501cb7bb2677f6187859de3ba6241bb3 0 #xc15b8260a58283c4773119fc23dbdbcd8968f7276e3ec9df7fb0c) 26 (7 #x-1cd41b48f50f8 6 #x-538d61e935f529750b08d3c 5 #x41112747aeb6d910f6189b01e2a9af32 4 #x239868d1da6ff7d25e078a1092ae8fbe579f0f00 3 #x-873d776cf1681f6a37988ca683084df389516221b8bc 2 #xa745157eaf25a5047386efc837b0fb4f1d9f561aea6ccf63 1 #x-29194e24124a1e7bceef910806b79fd48f64ffc7666092af301 0 #x2623074813932bfee1a1c35a4f6342a3f4000e822db8da267dcf9) 25 (7 #x-c858d96614e2f 6 #x-7a03d8893ca524b8c351e4d 5 #x3043a4037efac4fc32e24310e34f5e78 4 #x12ef6d5d9c44aa258a0b1f8b8a099cef3d3c2f6f 3 #x-2c5fe348fa31b26787e452f809ac1f0c918faf3142b0 2 #x3c7a4cadd29227e202689d38ba56a08f229ef6e222ed741d 1 #x-a8bed8158b09628c0da1975790f1aa3659070dfdfbe616bb85 0 #x607389529d6793a9000d9a7e65402ab08f7d1cf69fc60f5078f6) 24 (7 #x-5ca9ece82806b 6 #x-48bb8fde43cbc6ab388b8d2 5 #x1f08ea215f6c3221988b0f2cd13ee868 4 #x975bfee8def5f875f285bb69f7c3c76fc674295 3 #x-c94b0d92f22ddb0a6f814631557efd1bacaf84a2065 2 #x14c540df04bbba1bf602203242e9e8fc688adcc05f90b020 1 #x-26ba5adf16f8f43989ba35d2a284bc5ee07e87921acaf57d55 0 #x9cba133262b8fbf1c3ad8a81b1eff59121878c750f853eeafd9) 23 (7 #x1ec67aa680bd38 6 #x-706b98d7bc3a13ea0477e 5 #x110079ef1676646508522218192a5eef 4 #x46ee1d346be9fe26b39649ccc9da55a2d74469a 3 #x-2d1d65edc69bee9087886881585f049c68e44ab634a 2 #x6c3cd8993cca589624b15d89b7c99a83d51b136cc745648 1 #x-7a9f606a2a1bb2122c2f7818837b4a11c40528c462e4e31c7 0 #x-52de6b622eb8c0d8b34b686a5cbefb60d101f76f0ed3e67378) 22 (7 #x283915a677ba1f 6 #x28c593ca8a46b472f95bcf4 5 #x79093a5b8bf5cfa1278b4001f06f3b3 4 #x1f224bdefc3945732c28489da9c8db897a09ca4 3 #x-554a972c633ff352b415012c61718f05052532e07a 2 #x215d7d70dc73cce6d60b4eeb43266a2e5df45a278fb9228 1 #x-131ea80083b9dab82d4272299f117241e56f944728cc2c679 0 #x-716028709d085d504f9909ec7dea353e0b624a37c8924c5748) 21 (7 #x-1d4e850a97a742 6 #x2a749d1bfef0fe7ed8e6b34 5 #x255219d00ee8abd26db02a53a2e31a4 4 #xcc77e8e96917939e7db25a9d356da45bd47c66 3 #x1acc201cd3ac9e3e1a1c10b836ed3bb7e7c6444d16 2 #x9b6549461667952a896a481228bdbdadb2d99f534c36ee 1 #x-194ddf6a26fb47f334b8dc0ea5fba089df2b21a2fa297026 0 #x-1ec6dd5f8aebf42944cba102ed9418d1813073824822954740) 20 (7 #x-5b8db237f74e4f 6 #x1a448f3e3b713c679a5a485 5 #xc1fd969546f4481b29ecf22f128bf 4 #x4e5570812c35f22aae4482e607123b3ddbcb68 3 #x18ff96c7f79509ff2798c8c4f05b2be9878e4afc0a 2 #x2a9a6c5a79126af9da4155af17ed6afeb12fd65c16239f 1 #x514fee9c107407c703f2f2705a22de9235dca430a72fbf2 0 #x-50b5ce4142671b4938c831dd3f71941c9cab542a11d01e970) 19 (7 #x-1ad426a8048608 6 #xd49bc35172ff09362cdaaa 5 #x-9a9ffa14d8b32723dd0c321b374e22 4 #x1bf35a8c91c669e977d2769eda53931ce4eaa2 3 #xbf5bdbb35eb3e6db66a06ef83e67191957b41c420 2 #xaf7fd7567716a6277fbc64b5e62f7a91f53a0a41382ee 1 #x33948e1d1841733ee99515755749485b4eb4e832a107ad4 0 #x-696d2c70ffc57eba3865b6f66a1760be3a84cfb6ba240f80) 18 (7 #x5c5ca77f1b57a2 6 #x99dbb858ce64449fe6213b 5 #x-91803c524f9d1d47ccc7deea7f0d5a 4 #x94418fcffa6c08031f0c2272d045366f75364 3 #x4785264c8ba1b7221731bb2569949b987a526246c 2 #x2a4b9773d3fe929c16446890fce28f28a01a6b11dfb80 1 #x1016704929ccae25fd74d75503e4097d27a1e92aacc3628 0 #xada2be0a72756ae05cd70322fbf27309eccf814a13fdb80) 17 (7 #x5cb5140aaa57ad 6 #xaced0d0f4d9bb571cd8ca4 5 #x-5c670180e9f2bde42d7987356055a2 4 #x2d8988532dcb91d42d386d21f4d46b92d064c 3 #x16cad1350db1f022b04c58e53292ce47fe677bf54 2 #x981e723f18042345abd2223163671d7aeb5714404366 1 #x3c56e97a5676fcdd197600b73a459f42d6f97b251088f0 0 #x59d3361fbfa3b9c0ad6acd073bea4775d506cb2f6110000) 16 (7 #x-11d0640fcaa01e 6 #xb6f300c6900529e218f18c 5 #x-2f4f3e002cac256d8ee3aea07c129a 4 #xceb09aec5a15e0f22c1fb39639a47c5f17c3 3 #x66481b7ee8eebf5db1e1ac0ec706da8abd3eef09 2 #x1fc50d59091e1873984a10d27298d440575cdeeacfa5 1 #xb6b2b0704c94a1b7801d4d84581fc2a46665a159120f8 0 #x106dffb4ef8f99c89f12cf00d3338f688d8ac98e5136a00) 15 (7 #x-4fda418a8c16d1 6 #x9b162ccb97a5f0b9261df2 5 #x-1494d23472f3e138fc2ab5b92c7f7f 4 #x35f56f8688c43efccfe9961712df92a0775c 3 #x199780dd6be9c3665500002c0a06be59673efa51 2 #x62367b3d268f1df6035ef51c268491e426939f16790 1 #x1be3d967c23a268add07984543277b23941eeefd5d640 0 #x16cbe6344d2defa4f11d3ed04e3694b41a954473188800) 14 (7 #x-273ebd2666ec0c 6 #x69c5ea8c699e6733c0425c 5 #x-7c4ecc9d6acec026306ec6a175a49 4 #xce8e6b6942fdfbce55b8ffbddfa48712af1 3 #x5be93688dfba1ee44b903cb8dff45194abde869 2 #x11793490e20dfc4bfab80ac64ef84d094641fed120e 1 #x33974b660be16825224b0cd7952c72b43e6913584a80 0 #x-14607e1527dc997b3512d2d210a446225dde4ef61e800) 13 (7 #x113f693f8da92e 6 #x3b5997caac049de473349c 5 #x-2914052cc50379f08c204e5bb41c6 4 #x2d136b04fb85199c7bd8ae9d02dfcb1bb46 3 #x128846269d5d6b6300fcd1d121818cb6ee5a4b8 2 #x2d9182dbf63fcbdc078a8f434faef31dc647a57d5c 1 #x363eabff63ac532867055f1e125f3278a501c916400 0 #x-bcdd3b6e8f82eeeef17ce19fc310aeb0e757d5b10000) 12 (7 #x1a7d4a3aa26c5f 6 #x1bd994358fad4f7cd79d07 5 #x-bea6522168c0c2996e361ccb7220 4 #x8ec46152ef8a56539a8e170bae6ec62797 3 #x35a15aa96ae1bc6787ece7bef0c5bf5c780ba6 2 #x6c421b2b1b13fc15915c7027df0d4bb340c0632be 1 #x-3a5c5c219a6721a94048f455dc373a2828bbd89880 0 #x-1c84234c3072293f6873753011f5e1820958edce7000) 11 (7 #x8873d36d3fe5b 6 #xb080e83047adbdbc35526 5 #x-307e9e0ac40b7e0c19a0d879eedb 4 #x1978dd8acf880ef261cba20347afecb19c 3 #x8abb06728cdf5a99df1a4b789260d37d0ec67 2 #xe8d918b3f18ac1f17453d7f91dd98d2b5e01fcc8 1 #x-1d9f23641b9462b73b03a98eaea6f42547ceddea00 0 #x-17ffce7c711ea8dea78beea17a62b9395da9caa8000) 10 (7 #x-2eedae8cff626 6 #x3b3cd7e3f4a72820a58fa 5 #x-ac6ab89b4902ea7e1cedbf4e7b0 4 #x410ba222db2e8c58d3453a92a5983c548 3 #x13f1664aff8005dd701bce308948cca3e0263 2 #x1c24b9295f4fd2847ecbb6d92af71fd41b24b578 1 #x-5719a3b26511b0b70a23840a75a720d5d4caffa00 0 #x3c9a9dd8c7570cfa7ed3c2e3af553ac3dad9108000) 9 (7 #x-3448683a8c5c6 6 #x10d5a27399742489686af 5 #x-2142fff8b01524ffa69c64eb491 4 #x934064dbad5dcb4d10fd9e36f63a3202 3 #x287ec4254bbcdb4b89235d1d9a997dc30ffe 2 #x308e39ea64f53b740a106d052ce1db31fd65620 1 #x-aa2f134e806f9a71ee9bdc57f0ba1d6625ea7000 0 #xf410330aecaadf3b3c5eaaa4c2af61525dd900000) 8 (7 #x-f4226923ffaf 6 #x4087258a46cc9ce603ed 5 #x-585a10bbb421c51da9c63ad295 4 #x1245569d37191b44a81138fc9f73291b 3 #x47edcf842352799407a12f2d260c58160de 2 #x4a1356f88a670805034416218d87f551708790 1 #x-e1623f75559a2281ee0265b69b329f4741ef800 0 #x1586a22f8cc3d0ea918e039b2711fe4073ffa0000) 7 (7 #x75a95eae32c 6 #xcec898d93ba53e5748b 5 #x-c79b3c8c6d6037ee2972959b7 4 #x1f631ada79dbb991338a95ba6e7358c 3 #x6e76329bb3f8d942cef15f016f348e3e5c 2 #x62e34965c56cea08acd1cf7c034e30f542700 1 #x-92660a6263fbadd23c1ffce645e73791a8a000 0 #x-2c89b5147d172421bee9d0883ce8ee455280000) 6 (7 #x18e873e0fd25 6 #x222ecfd480be7ebbcab 5 #x-179a2ef79a3d1640afcbc2b33 4 #x2de0e581a6da7684b935e9ab5c8526 3 #x907acf39428a0e8ac982d9f57a17e4120 2 #x720b6247fc88657c659623e1671ebb37bb00 1 #x9ef5c70b74cd93d12b650380520c00a93e000 0 #x-429986a6515ca2ea6846289ef3e8854fd780000) 5 (7 #x742f212671a 6 #x493855f08aaeb27893 5 #x-249f69571d9b1e3ee90bc582 4 #x37d38664d190a8954d1e3c9e2cc72 3 #x9dcdcf26fff4e29fe050666bd50c6d20 2 #x6fbe453a06e399eaec13ca8a01c4978ec00 1 #x28160943a9838e415dd3c90d079e6baa00000 0 #x-7377e48a3846589f6063e8ee51ac68ec400000) 4 (7 #xddb2151320 6 #x7b82615e044b81555 5 #x-2d48ba032432e0bde1e12d0 4 #x36e701a9ad58a35db812c2f60966 3 #x8c180eb9760e476c143839b6f997d08 2 #x5ade788c66b29bfdb5cf4320b798488d00 1 #x41f3bf77435c6e82e9ada6f9ea7732090000 0 #x-35fcb0c8c55fd1f7228631c96196c20700000) 3 (7 #xa2595788 6 #x9d3d8eaf352306f4 5 #x-2acab3b225fd4daef4c14c 4 #x29d34f52ae1db8c8f47cdf7b718 3 #x613368c3998f1612d284f034328460 2 #x3b2cb7e44ec0fa65c5f8e835bb89bc800 1 #x45fa789b6dcc6d10cd8491be38430120000 0 #x7a0b1e9f4bc51a0a1da6ef9ef67c41800000) 2 (7 #x-2b1c3bde4 6 #x8d1c729afe9a208 5 #x-1ced4ae2660d08c2b3f54 4 #x17190712026fc2628fda06eeed 3 #x318384c16b070fb9ccb8992abdc20 2 #x1d10558c290da46b410c9aab389eb800 1 #x31d46c670233b4ba6aa1b794fec3660000 0 #xff1e41bcb026b0b6d839c760bb971800000) 1 (7 #x-43A75718 6 #x4ee4b9d2697a7a 5 #x-c68766555e56789dc88 4 #x833d425721bdb905fac56fe6 3 #x107fd5a065279b2b57201dc31200 2 #x99a1015bc5deebb4e805b0521f4000 1 #x161dfc848e9ed8d8b92c541fe82a00000 0 #xcffb69b17c564abc7a80b1a2d916000000) 0 (8 1 7 -35684000 6 #x14789f73d095e 5 #x-286ab340b3bd933c60 4 #x166d41878359baea44b68a1 3 #x2b42398446f0800c1147c18d00 2 #x19a60e3eef51bbe1e937582396000 1 #x4b50c6a7d9386e6cd9ef96e2c500000 0 #x4462bc5075acc37ce9852f69d11000000)) 
  (svref *ec-g1* 151) 
   '(152 1 151 (3 -1 2 2231 1 -1068469 0 36707648) 150 (3 302 2 #x9d152c76 1 #x812d954396f 0 #x1988161563160) 149 (3 -43941 2 #xc82b59e4eaa 1 #x-a8e10a18881fb69 0 #x6350fc02a78b8612e8) 148 (3 4103576 2 #x20bafac0dc2144 1 #x497b1e6a2cdd82b67a 0 #xbcc46c51020a571f7588) 147 (3 #x-107AB071 2 #x15ce4537682afbaf 1 #x-45ce545336081a2ae37e 0 #x5a51b9909ac7ce21e1f730) 146 (3 #x355a052ed 2 #x3d8a2ae83862ede6e 1 #x12c37de05c15c4b8f18656 0 #x-a0aecdad9e560210435839c) 145 (3 #x-8a33238382 2 #x-1822b157a27631d86b 1 #x-29780e7da4f5923c088e8d2 0 #x-6a75a06c771b499ec35e7cf80) 144 (3 #x12650e8192eb 2 #x-86171a6685fef0af39c 1 #x396788945e3f3e5b2bd2dc36 0 #x21d90b0e594b3f7cdeaf8b3a24c) 143 (3 #x-20d7c0ec3ba09 2 #x6802c7185a78eae06e99 1 #x-36a0ddce58f76b7e1d5189eb9 0 #x-51b295dad4dc88ca19c7616ad8e8) 142 (3 #x31e298188ed82f 2 #x3d9ed0f7395602a2b17dc 1 #x25a09a343c4bad1cececd78673 0 #x8183fc7ecba6d5a0f0a6eca060860) 141 (3 #x-412f78a3b008f5f 2 #x-756a292223af96058967d5 1 #x-138769a3c69216e374649ce4e9b 0 #x-96b989cc70c4245fb68f4a582b3f50) 140 (3 #x49eba026e1a11025 2 #x35526b23b7686ffcbef451d 1 #x82c726adbff58f2bd5f2b2795a6 0 #x8856398830b030f7a826495e4c6090a) 139 (3 #x-493ec786651b5b58e 2 #x7853c8af654e8a5e7d0745c 1 #x-32ef0c835f6f19003a0de682a465 0 #x-633cf906f045c445b1c2867cb7cbcec0) 138 (3 #x3fc1228bc6b6ff6a7b 2 #x-13d16c92e0fb4cbf2bd00adb9 1 #x14db2e3a6302d629813ab856a796f 0 #x3b777a44b6bbfa30b33e6ccd711e295b0) 137 (3 #x-30f27db0d35a690aa8d 2 #x9ed3139d182d17b7af792d5fe 1 #x-77191a24d7c30d51d7fcaac029769 0 #x-1dc8f986c90a0cef1cf1328afc62eb1748) 136 (3 #x213ea8999fb8865d3340 2 #x-1f5267626eafa21d1fe33904f2 1 #xd16c107a9849d00ef23f492a79460 0 #xc968ed40b7ac81c44ce2606dcdf4f1eb66) 135 (3 #x-1403985797752a15c1714 2 #x-59efc7d13c9c0bcfdedd75ad0a 1 #x15b43c4d68b48165fab0ecab50f413e 0 #x-481fc0d1a95bdc1273274e12e72442ef750) 134 (3 #xab06e86f9ea6b48dbf372 2 #x590bb7fb9f0fd6634a00011cad1 1 #x-136cfc7385134fe519f8a61975ff3b32 0 #x15d65570420ec16d42dcbef1bc3058857134) 133 (3 #x-510317edebeef78e86c4a3 2 #x-1a520dfe222590fb2c4bc97b74c5 1 #x91469ccccf04bc537aa8857efe6ce8e0 0 #x-58689754897cedd556ad3c5045e6388f18d0) 132 (3 #x21f9fb2f7dea8e2e6a7d44a 2 #x30250235accf961a2d8d2ff99dc4 1 #x-28ebecec859c4e196836ea8d4af6c33c1 0 #x1221247ee1ffbd5a32faba9b1f9d2046be1b0) 131 (3 #x-c927ade6eed4c2a8acc9590 2 #x7ae3a47aa940449ebf5772a414d0 1 #x427299897f4a2399734274d0683922365 0 #x-2c504443f4267d580131f9f817c6adfd77498) 130 (3 #x414268a89a9df091ab65f90b 2 #x-3999d60864dea780671b6d548e124 1 #x24fbc11ecebb961235661091381fa8be9e 0 #x37d55aade0d7752aaa32798bed9e6d6f3f758) 129 (3 #x-125d4def82dd11394dad7cc0b 2 #x338b7c497815fe33d67e211239e5e 1 #x-17be6f0006b52f1e11c04c21239f7178b57 0 #x84c509ba8e34ac87ba14ec5b94c42dff839d0) 128 (3 #x465f4bb6667d439689d9353c8 2 #x3ce1e68dad3d676eb92937aefe5f07 1 #x7969d713dead24ad58073c8849b6bd5fcea 0 #x-458eecc7f296d93484a4e4467bb4f65bb09145) 127 (3 #x-dd13118b01dc046a0e57ec5c0 2 #x-1cfe1fcca056c400973f17fee08afec 1 #x-187b57c3abb52c39b211ab671cbf52ac4f24 0 #xf1104c1abdce593b9230e8bf1c0ae556aff410) 126 (3 #x20767a2ce722e65f323ead355d 2 #x8eec13d08a69fd0279e7e8bdb0e795b 1 #x27d006a3babce58e7929c668c5e544891347 0 #x-1d6eacc1165ae61b1ac17ec478fbafe420ad670) 125 (3 #x-267cf5772d9686f84cca9523d9 2 #x-27c6924d5c29bb4565d3baf415874e03 1 #x42e5f01962095ad43c760bad92844444037e 0 #x48b2bcf0df1be04bd3c80d30bb9c89fe388390) 124 (3 #x-62d114e38aee833f35148eea49 2 #xaf36a145673a733266fed70987bb0e6d 1 #x-2b625d389224502cc1856cebd6d9af09fb535 0 #xc7cbb4dad28d73b2817e6518944dc33079c022c) 123 (3 #x3013e8fccd46c29f5d713ab0314 2 #x-2e011728d84417fafea4019b555c3cdc0 1 #x963dac5260dbcbbf3dca04ba40c8347f9ed08 0 #x-317ed28d21ecb89eee5d703f811edd49614685c0) 122 (3 #x-9ef3da6ab45a93e9f9a6fa9300c 2 #xadd1a95c6fc6b1b6284f198ffe99b351e 1 #x-108072005fc7440fd8dc469943068bc271a680 0 #x60924e111b4483feaba064ec7a2e621ad2bdced8) 121 (3 #x12833166b733bdb9a6c03d75710c 2 #x-23a913992991990399af12f3fbaec649b1 1 #x-4538ea2ec237635770b355475c4b5ae2c4d6e 0 #x-13044de94e0a06c30b8bb9b59cb0696596fe4db0) 120 (3 #x-3a9f5e15a7ac445dfe8dace7b42 2 #x634e25773828432ed8af56b538aa636443 1 #x78ac049a70f39a12d94cf6204b78cf298f10a4 0 #x-21aec27d9746554dd7f6528db9320880ec20ace8b) 119 (3 #x-66cd8aad0fa9b36fcbb8cfec3f5e 2 #x-e099b70f45f9a70179acdd9a1c67e1606b 1 #x-1737ee0039e47431b6dc27660dcf97d18faca93 0 #x76526b4ec8fffd39f06556420db428963dc799f70) 118 (3 #x16f6627309d09d2e16d5c9f28d15e 2 #x166f72eaa91446ff63ffa3cb6d47ac0f6aa 1 #x1f4dbd155129428f746b0615461a5f7e5b7d0c1 0 #x-b75a70cf6527cabac0ed0319fa50a1579fa914888) 117 (3 #x-25b6ed5b7a342ea066c811cf9e015 2 #x-76043f104fc53b7a4c4d331b6a539a3a70 1 #x183c1b198ca142a2b656650a3535d9820edfab1 0 #x-5a886170462e03d71ba74f4837a731a20510ed5b8) 116 (3 #x-4a15d5f9152d653b962e0963c15e 2 #x-6dd34655a369cb21d7b71a45e637bfd4a1d 1 #x-d5ca521733c92c40751308db4fec4d17dd2e8a0 0 #x4e50c5bc6e3ee63c44751cb360c10814ef70b6d0fc) 115 (3 #xc21c583abf2f9e64cbff06863dcf8 2 #x1ed7ee02094804ccdbe013324eddc88a2f43 1 #x1d27f6aa317e77c330597c029dcb167882070522 0 #x-c6bbf81c032186539ef216469927f6ae8164bfaa60) 114 (3 #x-1f38a131bcece7866d153c37485d60 2 #x-51cc392e43021848f3e205caffd038ddee6b 1 #x-148a24191fd22aa101fc8ddc0f2cd91f114cfb04 0 #xac8a7f3fca23bf593efd65ea004e05a3d4eed209a4) 113 (3 #x1c37ca65b58ed2cfaa5f8d71e2f637 2 #x8d428fac3c8c472c1ba4ba1baa5684452c61 1 #x-3b860bdd61a62cdb1b7aaba99f1ada22b54db512 0 #x1dce71c2f04f6dad9beb555c16db03b55005e6718f0) 112 (3 #x36e3545be3adf22df95515fdfe3d7b 2 #x-5e8c9f5746bd4f9dfac3eb880ad239031e90 1 #xd3d8711043aea101163b8790797f85766f6aa5c4 0 #x-810a4dbb8584928746cceda07f7634104ced672e446) 111 (3 #x-e43188b7772ff47c6e32d85f42da39 2 #x-1557810c2de5800c8f063f650ef498146904b 1 #x-11a56a2b8f247617cf759eaa613c2eb6a1aa18411 0 #xc9cdf9815330ce0fdd78dda7d6d8c0bdeb932b401f8) 110 (3 #x12eb6e74a65e134b52f57c48efe95f6 2 #x5f948d2de66873f54533d520053169200297d 1 #x-256388d5a1324663b334a4c18df674d8f9b64df3 0 #x2b516271c86ff1489de092bf79ccfeac5770e9b22b8) 109 (3 #x6f6276849e6429e7d1e1181cd8a28b 2 #x-d14c71f2103802d1ba750f56ed0b92ae92083 1 #x37bbb5042750530b8add39fba27d38ba6b103e015 0 #x-3a7a8f51273cb7f5dfdd12adeb8818ba7b772689fb10) 108 (3 #x-45496d60c4a4707fb1aa9bc6bd4234f 2 #xfb41d0d84141646b0d38bcd8e89c765076a4d 1 #x-6b375654eb670fec2fe4e5798d4d1955ab180e06c 0 #x8071dfce588eb3429db49f3bf2e05ff3525cb01bc96a) 107 (3 #x6a54ea75f0eb6a1d59820dd60ff2db9 2 #x34eaec8121dabf0425ded05ff5a1cf637835c 1 #x46d0ac1401914618c8bbef070473020f4f5382105 0 #x-4ab64b3acfb9eb9d2101865df0da2d6fe07e3cddee90) 106 (3 #x-6855d9b7bb59569413e8bdcd225612 2 #x-4030a45d2ff5f9c2d0744bb49a92c22124990e 1 #x787547fda1676ecb624f335ce1011d103c6de2373 0 #x-12e39c89ed3bb6fb16ec90f53e9e00ed55ba774999c30) 105 (3 #x-e9f1f8ab9babd6975ce844137ea837c 2 #xa0bef4f46d33495d6b290e9ebc5ce79ad43812 1 #x-188276111ab9d247ee5866cfc5557ba1a603d9a12b 0 #x39ed68f46f8e75fb91410403c9fa0e81678fac69474d8) 104 (3 #x16702ebfa551d775e6c3bd30b580fe82 2 #x-d6ccdf6780777384f5227942b2c3d5b2a25e86 1 #x1dcfafe9faba11a024704ae7d0cf3704bb309102ec 0 #x-3be7f9032c224cfd46bf6aef5134fdbe3cc593cb645dd) 103 (3 #x-367680437e5060ba02ee22b7599e34b 2 #x3f0e39ce3111fc4731c9fe8e0ed3cd98c320f5 1 #x-37dde7094893efa12b8368209429f89a87bb2b3bd 0 #x-3fcbb4b96331ece63613b42a84da9975175d0790ecd50) 102 (3 #x-1f96ff69b03bf7949fae86e1abe6e607 2 #x1bc949d419a049ab6111bfc7624c249043c5e9c 1 #x-39e29f57838f24a8e85010922331b2c614fd8d7d23 0 #x13d667e5f699efd136b0aaf79258fdeedc5d35a94e7354) 101 (3 #x24de9e7b15c9c01869431c098e9708e5 2 #x-4bab2b730eefa15ad1c3acab41334b19a28ba8f 1 #x779519c19ce46c6c39e10bd45c505674a7fc571bbd 0 #x-1b646d2a1981c78a4fc6609e5816f96fa0e331ea79f4b8) 100 (4 3926 3 #x22943397d1ebc2a1acb9c19eb0d23ac 2 #x68417e4662e5c99bdc4c34adee2bff6337ecc90 1 #x-63416c2dc1a349a098d1d4002575b9722724c34b93 0 #x-43f80e1d2423b50cb017d3744b4c81e4c520cf0db2428) 99 (4 10114735 3 #x-1119646d7ae5cd49d66c030109c82d3b 2 #x-3736516d0fd58884a6fce65ada6a1d261d9990d 1 #x-61057293e8c2999ffa76830490495a318d7cd37429 0 #x542ec28bd5316de5e05ccdb5217dfba78603c6b636a7b8) 98 (4 #x117a2bae3 3 #x-2908785c754234dee4605804e8ba9340 2 #x-702caa3da2ad8d5099a51151b691b90f3c421e1 1 #x1ba65c8de266841b63ffed93ac06ca517266d18a0a4 0 #x-90bae138626fe598fd01857d4d1584dfc576c4ebf9a86c) 97 (4 #x93e6339206 3 #x2c138d5a5288c0af9ea0732c812cba54 2 #x1695be768621cea4bd03d2d1ffa954cafc61fc33 1 #x-253091c44d077cd6614ab4bc691ab215ab324c847ed 0 #x2e97a045d1ab513dfd90143b344f5d3e20adcb6b96c390) 96 (4 #x16ffb00981dd 3 #xab036740b510667e8f1a165e8acdcd4a 2 #x-2211b13e0e3cabc751eb2fc8174dab838ad64d8b 1 #x-49e99245116be06ae9be6dc4f0c5d5149c5f84e2ca 0 #x1121b7083d5607b928b3ef96ab3c0a54b01934c5f1f8663) 95 (4 #x-2c7b8021502a 3 #x-1809a108264d1995520cd8ff785a30e9a 2 #x1ba8d539374a7c9ecf6ad6e01d5f5a95cfc089b1 1 #x70f0e123ca1e5939d892c3ff2933f640f1c070b8bc9 0 #x-24be0b9dbfe83b98274410f0e08b06c1fe47b9155c60908) 94 (4 #x-243b33d06b2d63 3 #x42798636c4ddcca601731fd72e1b8ef1 2 #x7cdac91ee0b214211006c26815006f23d3a3dbe 1 #x-cc91dfeed25a1463203a8a70360c85ca13b9019b5a0 0 #x17be34d70185874b03b77d134d54cd2057c78c4c3b17790) 93 (4 #x108372de81aff50 3 #x2c675cea121a96136e6f5cc3cdb4211d8 2 #x-467295b5ed2ba23dfdff835b1b7fd5b3e41d502e 1 #x51aaf850863f0ff0694f38128f0fc1fa5fd0b3d9ec5 0 #x28a75b3d9e86cd6d6fa07ca06b95657bf3ea2759de0d780) 92 (4 #x10a7653974c43efd 3 #x-35f4452ef49acd974084a2d0ef3e96e1a 2 #x8765c91e8254dd401c3b4cd232c615333c493ae4 1 #x18d6baa8a3a72226b010225e841132ed40bdc9ac2e41 0 #x-74f016dc1b9edfa7f05d376d9ba28fec5b5c7a78cde1e96) 91 (4 #x-12446556d0c177c3b 3 #x-e77b3e8022c0552f8e9404240dda19f5 2 #x-98c2a94b489f7212bbd4611a5e363a7b4b05bf04 1 #x-3d283dbb672929686a958c9cfb8b844217cc9595657b 0 #x6aed0eb6a964321b27bcc7bdc891d0fdda4c5467f46e880) 90 (4 #x5171a29f4b2b7ab73 3 #x4b80b4b55f90374e912c59509168f3440 2 #x421325d5dc802f11182813371361dba2f71a7810 1 #x354c8be3cae33e8374def2194187b5773e85fb2490d9 0 #x3992fdfa3874a042b8910c1a4a24ef1c5f346117bd8d578) 89 (4 #x1d82e1fd6bc9cd699a 3 #x-18d82a29a394fbd07fd50b162089da8af 2 #x8ec62f49f75a759bc637b78e5835785f5fb2fdd1 1 #x31b37430689c5eb07a8f6deb42647acf9f7b3cd23e3b 0 #x-1227c3bc6b9291ba10c8ffca3458e01f3f0d7c3aaa13d428) 88 (4 #x-1fecf697604573a316d 3 #x-3b33fd52bb516b7c60b1695270ae0a231 2 #x-193eaa5dcbc32bb5dfbc7504752a26bc0704e8169 1 #x-da922148185973bdeb7744897e60de9f55cec362a156 0 #x158140fe988ae67a685a07e9ed8f6d005ebaeb2879e5f53a) 87 (4 #xba12db90430826f6843 3 #x-b9eef2c4a76c33388c683e7c7186854 2 #x22b4c65276288394f57ca1c10ecf4ac5b6e0651ac 1 #x11fc8d8f088a2170190ad9207d186a881eb1700803acc 0 #x-12ac33eb4fb2e61d31d9312a769ec48617e7c42d837a0a0) 86 (4 #x-1c4b0c7ce912ad32cb23 3 #x89c19a47f6d014272ce5f4699c0d37ef7 2 #x-1a32724c03f4f9d47c814961ead89d8db9ecce854 1 #x-293521fea353ba3ffa996521d83ca1b34cb1c01fbb4c 0 #x-2229ba69ec3d2dc81929c808730f0cca5f602c5e1851e25c) 85 (4 #x-3be74fc60550a73cddd2 3 #x-321e24261938c88b96b38dadd590ae0c9 2 #x-47ceb86e5f156e22da1fa3e33e7c19394f480d13 1 #x-21373f52a855b493d138788d9664107b0a6ff7547bf8e 0 #x34524452062026a7766810effab5ec37e7bf356086dce690) 84 (4 #x303b069ff8f980af5bca1 3 #x-10812ba8dfa28fbef65646e06c184e5b6f 2 #x30fa0855ae95934a864e11872580d6e598873d739 1 #x3ef0c04ef7fae2d9e9ea6adff2b29d2c7a23702bd9591 0 #x-175a6388e97bbb0f935190e86563b41f142aba6e777a2584) 83 (4 #x-bd9fab112ce458ccad595 3 #x1416d2cdcf4eafdc3d28487ff36af1793c 2 #x-56da2c8c5aa4a00a076b76fe50bd88f1897f3fe9c 1 #x-2af4cdbacb0cabd364d2b277f51535dc02386ad59c711 0 #x-2c689da2b738fe5189c6e1c200cf2cfe35255b13b21e66f8) 82 (4 #x1677728003e76efbf1a982 3 #x79868dde293a467124ded4d3e699a1333 2 #x5c6bb2776225d2cdb9eb4cd49e922ac398e8f260a 1 #x-2d4fd5ebf32949294c0552322ed9acb484275d9be7978 0 #x60a76efc7bc7bdd5f94a5f9cd2206f559eec2a1295c55a38) 81 (4 #x1ec14fea02f2085bbce26 3 #x-1f7389c8f3d1afdf356a555e733cc4d14a 2 #x-2e53c1c511761e60de638177d92f907016cf363ec 1 #x97067851f7a003cba7227c7799bd46e157d400616636b 0 #x-4a53eb9fdbb860049c716ced6838e9e873b065b72d2f7b80) 80 (4 #x-7feda59327c1676bd19ba0 3 #xda2ea02bd55c0857f66d78416e42ae01e 2 #x-3171b495f2bb16a8aad4794a247e01456f64b56c1 1 #x-a4db01e809605cd312ead08a1af5be435e42a5c0b9b98 0 #x-19a0f778a8773573ccef02b27181900a10e1405d3a1c46cb) 79 (4 #x139d2a4ee51d89d7e0ea96c 3 #x14c546ff81971cbc75aa12e3c0a715d1dc 2 #x9fe537d18b6890c5fc57b51fc2789f978b218abe8 1 #xaaa1775c961d7f47d469b3acffd290b51e22398c4d1e 0 #x82ca1eb45806132ee970230d74b912fa2b33365f78e17570) 78 (4 #x-b8722dad34e73f8aed3270 3 #x-118ccebccac20d642539424ae1afca8b23 2 #x-dee23f36c1380abb46c06a3f85c447b7bb7dc533f 1 #xf4a7915c730d4d1d17e13820f3cd91fa8791704b19a71 0 #x-924a0d469dc727ac17335511572bb54b13f58668679ad6a8) 77 (4 #x-2bf49e1685e2c7e8e2bb99f 3 #x-f2c94318ccd678c78af6c1ea6ca2fc4af 2 #xb50ed98e55f8f72da5843bbf0cbd7fdd077e777c7 1 #x-182dab65d68e3e32f093ee2b3df58a9f8145ff0547e2c4 0 #x28ef751697f534297370ad29a90675cbfce2de67ea401f80) 76 (4 #x63e8d2652454068d7ace676 3 #xee20f679dd586f33c916b2a9eb3395432 2 #x-18a1524492b4ed14cd0031a43fd0e61495716e003 1 #xd8fb195d00fe96023ce0e9a8f09b072f841fa67eb595d 0 #x7216b030144ea286abcaa5b30d9b46f2fa8182928a62172c) 75 (4 #x-260faf57a55b9d7b553f51 3 #x1b3047a4612378c1cc462632e45fcd4c6c 2 #x-bcac3fae06f94b35c28be752a2e4c5e3e5d7d2e98 1 #xe3cf6b6a03600ddc0a14cfc97af0119af9f4542b7812e 0 #x-c51071c79e161b6c32b8cc69c6103d106e97fc465bda1390) 74 (4 #x-10eebfddc76322311493c22c 3 #x-27fab794b83b08c51b53699197dd4f38e2 2 #x164af50c8f9b27fef1f4430376433dfaf250454898 1 #x-26bddbadddb3ff7d744a92c2f51c27a758cd9fbd280814 0 #x88e3b7d53b162017a4a5949aa9a4b032a2a08e7864640590) 73 (4 #x10ab741154643499d760a6cd 3 #x-cdcdae656796be4860d9f543793ba11f4 2 #x-1804d921f5bd843e65361f1fe724d6319c472dce25 1 #x23ef75a6452b2b25d28ad8c95c001bdf6cae9161a9d618 0 #x19f2f30ba878c997c9c17729fc043a671b76168ce766bdf0) 72 (4 #x234bb1ec1f950359d76d38ef 3 #x3e999dd5dc851945b586b540bd23910395 2 #xe74311be3e8ae02a9d1aabab7e8b952a703ca7cee 1 #x-11309299b7b9e728ace01c4c41c7b6f7e61bf31cd8aae 0 #x-abed8ae3d91b3058aadcda9b6b4ed2f61926e637d0bc8e85) 71 (4 #x-6731e3730915bff81fe83d33 3 #x-22ddb3fcc610a5658da1af09614eb4f59c 2 #x3f19b1858d37544916960ccdbbcf81f9560d8acb3 1 #x-29e9edd14940d3f39de50e9267f9f3b0509a280057e63d 0 #xc5caf9e886b2bbe77c9a5875e75af4b0969a9e7cfbe66100) 70 (4 #x4e155975aa2dfc4b5cf3237d 3 #x-228cd6bc957743b652ff94c1f669897d05 2 #x-17e93c122846ce811f9ba5ef0b4804149bbea1bba8 1 #x392803dd4d60d4b1b2228c77a638ee8e8ecec9c0a2b6d9 0 #x-5c9a33186c9d8ac304d9e0696c8dfe0d395b9b1363021ae8) 69 (4 #x54e5e46da758e7d3f61a1cd1 3 #x34e85c1366c1ab4a124b04745d2034bc05 2 #x23b98a89b43b4efcc7af8caa9d75771ba55fba42c6 1 #x-1bffb5d810c174d4f6decc536d99a74e5f1e7bb7f4ae21 0 #x-3f35243b2e5c94f544701f4b348a0f701c8c3cd5f1d55078) 68 (4 #x-14d90a1c898144ad8aad1388c 3 #x-71065cf1f133f2bc1d38680126ad378a0 2 #x-1fe645799f397477f01544bcaa85f85ec11770c28b 1 #x-199c3ef5bb1d47b53f876b690ae2991b5d08e26d43eb54 0 #xa4c4b485e85c7651de1cba7a9578b9b40e955d6abea06c30) 67 (4 #x2b54e266e4c290e0266be3fe4 3 #x-1c4440689a3cbdac3260dd5d9330089e0b 2 #xc40692fbfcf16843832f66217912c7cf4ef5c9655 1 #x3da29cdd813a2f57f5f59878d99d388cb0de19e51df3e0 0 #x-9c71b4f7e497bb31743e55fdcd62d7d1d78e3916590187e0) 66 (4 #x-3e77ea1b5c73b6e6cb6e0b8dd 3 #xa0724c942f37a52b0c1904e98d887df83 2 #xe9a57ffba7183f76532ff0b421006a2eb7305bf3b 1 #x-333285d07754ec212ba9b271a5814e422189c3ee64b186 0 #x3b8487b6b5b09461de9cce6fd32b24aac912ef6d8a98e9b4) 65 (4 #x3b3c6ebd644514c6c72491ff 3 #x12086aecb84471c6f58b967b33c59ff574 2 #x-2386d29829dce18f5af412adc6e35f681b77bdb7b5 1 #x32577d565b4dfa9c6e4e43c8340fa985803eb23a73388 0 #x3731c5b18db965e602d39d324ab580f7f0ab0c4a3cdade00) 64 (4 #xdf9a2c411ae03e7a7fb5819ce 3 #x-5ba54d71dcdb632d6dfc3ea85ef57b0c3 2 #x2864dc9490f2c8e622909e2b27a4f5e4d7a57e4191 1 #x2c19b2c1497e14106749de1695e361a222a7d2cae203c8 0 #x-77dd289c94542e46edb30f2a186d4371d00bfd31bafdb51a) 63 (4 #x-1ebf0f1b37a70d66382e5d848d 3 #x-1af15017cd531127fe61030d532ec03232 2 #x-1b838c343dae3e57a6f2407978de137632f763fa1d 1 #x-375e2d8b5f34037717a26d1ea093d5d679ce5c350b0d59 0 #x6cc380ebdad2569b004bbe8db41a786cf3272426aea94478) 62 (4 #x15dc07702f870f35f4be82dc56 3 #x1c90e4d8a4a05380cf3233cbbc47f9db3c 2 #x3aa642bb9c68554fadc54259d0860985051699c11 1 #x1a76fd640fa83effec10e188c44c90864fe84ce066d295 0 #x-2bb36268702c87df8202d072b3674d4876b7e0a1dec26090) 61 (4 #x219b0aeef751a3f64bab7c5315 3 #x438688a1e3ba66636d3fbf9d81f1652ab 2 #x142317e48e1a5eae520144a00408a1ef0c5aba5835 1 #x102052554218e2767a84c4597a293354880e94ab48bd61 0 #x-1d184a3ea668786e784823dee0328b6856e5ce4eba1f1ab0) 60 (4 #x-6a81e8e4bda9a2dcd67cfe005c 3 #x-1b77e7e86e06fae464c4be0f6e5ad85f33 2 #x-21e577937248081327a04191b6d146b277df2f8ab3 1 #x-280244ebdeaa9334c0f0472d64e9339df6b027b9a46ad8 0 #x463b6bf15894f45e3ce2381f18b741757ba28344f1d1660a) 59 (4 #x74dac0d50c7af22e9e97ebbf63 3 #x11640fa42181f80f433c0037087d6b210e 2 #x2098c6a0e861761843dedcb7d1c188c9f0110e71fc 1 #x204ff6900516c13f2bd1de055e6ef7afb498681bc24fc7 0 #x-42ccf2cbf1404f71612f794020b71d15761a4c13a75d5d60) 58 (4 #x3d9feca38da7f31f22715732f 3 #x-b986dca91abea29d3caa00c220cfad51 2 #x-1201066537d1ec04295a15cf432aac696ac315bae0 1 #x-55640452d4faa7db1979b75a8d8ff40f1a7c2b4149679 0 #x2059e7203975895b883e4bc025050bf87c57c3c11e212aa0) 57 (4 #x-e1aa99f51d2098db43c8b40f59 3 #xcba275b2d5cae7fb8c692f5bbf32b43c1 2 #x-24655fbf47a73f7ec5ec50de2d0d5c98221139a60 1 #x-120ee9482b8c6416da709ccb508239ce0218ac73980109 0 #x78818aeb40c110298f8c9cd6be67d375b572c185f8fbd58) 56 (4 #x174b06e76349c8f79b7a45eeddb 3 #x-2f6e075190be29a8f9435a2d775e468037 2 #x1291c5d51ae56f4f22963473018be6c06221e702fe 1 #x17721a835c842adb8cfcd747d640f62255ea14010ac2da 0 #x-20097a9282a70263a1963d9a648c23040f1e214319cb51b4) 55 (4 #x-cec7df6f1935628c413ef4ed31 3 #x3c20961f0c08d045d429891ee4f7a90efe 2 #x-182b0776c9a8163a61dd969da82f32d31fe1d1be3c 1 #x-caaf4989cc7623e862daabff99155ba8e921b7fb9f1c8 0 #x225a75c1a6106408d37c04b4834d4aa48c466c4c9883b090) 54 (4 #x-136b290b61a4f275f81c068c9c2 3 #x-9b2d00bc00d5546a949bf7d4c8399a969 2 #x128bda654a90d6a6d94e431528d869ca5b374f89de 1 #x-2461eaf1e97caa5a0b3ab314fad3614667e655f19d274 0 #x-14a1a3d5a7e8a84f554dce252024713b0722d6bc45a5f89c) 53 (4 #x31c19dcf5619ec766ee210fcf0b 3 #x-683c2ac1b027eb34657ed172d01b1745fa 2 #x-6b57d3f6f30780cf35670b6cbdc9a9a41ca4b1e8f 1 #xaa1825bafc2db613efca17495f006a5b96ec8fa807472 0 #x29814f85e1079364509839a1832c6e472c0b79c86815740) 52 (4 #x-2990e9d39946eff39bfb046795f 3 #xe5f355ee4dc2cb8c67493e3424f17345fc 2 #x-48fcc86c070da2e1d2bb10420cefa3a0b50ee69f8 1 #x-9aad6df5b0cfeac5773b5e63ae07beba238f311888f5f 0 #xa201d577d1ebec2623ac6552f2fb6196a70d99958e70208) 51 (4 #x-d826877808b99bf227cd836995 3 #x-114e8311c221a818f84b2c174f4cfdd98f2 2 #xaa11399e6066ebfb1e6ef3c027c6871c6f86c596e 1 #x38b6ba309516f4ec1398a090841c061b437b2a718a951 0 #x-dd96f959cd494f8516e598dcdf87ba2b3885e832ccf7418) 50 (5 151 4 #x48da604798fe4807f6e3731865e 3 #x9d420b3d2c6bbbfeb81269257837f604d1 2 #x-aa65ec811f38b9efec70aee8f36289d5ab4d4e7c7 1 #x206cf793f54475746f54d70838d5a8dd6c8bb923c018a 0 #xa5e3c4ebe2d3d47858dc80330254ebbf1e4701f9a285ea0) 49 (5 -660323 4 #x-4c4b97e255e529d4a63edb56ad4 3 #x91b4f8406c3479d6dd31899e8ab307469a 2 #x6aeec9437ba70e3a558b135cdfe44c306e6542f0e 1 #x-40cd608f7474c001138affcdfaacc907103c6ea74114b 0 #x-40144c61bcec1f5535364c7e4dd4dcdf152ccb8da54fc50) 48 (5 261347025 4 #x92bda5d347858dfcf28cb51a64 3 #x-2078491f5c1530fde6a861d70c0d03f6344 2 #x-1b140ccf309a3bffb0c52a29f7dc2f548a46a8d8d 1 #x2f6bf0f73a75fd3669f425fcc1a32bfb063625ccba3f6 0 #x-15ee43f2b1a8f09464382d5a1f2075e0bc26f61d8a6bf3f) 47 (5 #x-648f15703 4 #x4a24ccffcfe9ca322519a4fd941 3 #x2e3cff4333ddb7c62d00d4c9a5754115129 2 #x-2100ab8c52aa63e9e1897e017b208911114a75a82 1 #x-d608f36b943d44c83e52a52768b85c6675745f5be520 0 #x3ea6498c8f4568c5898d885a56961354ae89cf33a91c900) 46 (5 #x114b8e4e423 4 #x-61b54b752e68cd1101a10cb6d12 3 #x-25122b7c3209d26398955101c798a939347 2 #x3a5e32258571de41f9117ee1ea9833b18a18bb7f0 1 #x-a6b65d852839841512313cdee8dc35488d71c82e2dcd 0 #x-3cb6ce1a72b55bc8a6a6efd582acaeb14c26f868f44ac80) 45 (5 #x-1a8db1a568c2 4 #x25f1ef4f94497db25da6e004ab6 3 #x2cf3942017239be0ccb6176119d27ea414 2 #x-34be167d7234019df1ab095871988a86bc05fb163 1 #x10568399d326394ae10375c9f42dcf3af3da17063ee66 0 #x23e475e93955be8ba39e0305d1f7550b6777f26f62bdd80) 44 (5 #x1a5ea65562383 4 #x3375c5d64e1607673a956093e40 3 #x2a3d19ad2e387de2e37a8bf76e3ad1d1308 2 #x1e2c781b6438aa253326e41846e1b447494770aa5 1 #x-ac69735b2b9fe2e22f4c1cd1878872c981a84d3bb68b 0 #x-8c217ce94ced034bb55fd6c9463555968d3bef97475000) 43 (5 #x-12784202cb3df7 4 #x-5b3aceaaad91ded0bc1926c3f49 3 #x-493e4476fbfff2523fb0d0cb026eddbd5a4 2 #x-5fff86c8bc42dbcdd5fda4c0de45b2ead6f5c8f8 1 #x30ed8d6f6e7e2476130163879584aa39df82893b501e 0 #x-8b1bb64765f58e4c744e5edb5edce5ed0c19b72c04d180) 42 (5 #x9a0e59091a2ca4 4 #x3482b2d1e3420f590293198442a 3 #x45eeea7ef2f214c99aef1d58c332aaf7534 2 #x-9afb8c2cb89c1055437020ed2401fec27441867b 1 #x187d75a9d9b60bdac64b28bf2b0e5159abdb2be73072 0 #xe3b7f3c80ee4e3fcf095f68dd46a2ca261ed1785dcba80) 41 (5 #x-3dddfe72af71c0a 4 #x14d392f063e6f3d4f45db0300cb 3 #x-1ec402929ee3bc220d7a4db6a6af04db488 2 #xe55a5b14904da238668a6a7c2f24f8b845274c3d 1 #x-27b6c5be9dff5f85d0717247fe1b7a9929236107f2c8 0 #x-ba1d8a500378052369c2742c40f90ec46bd238b5a7e400) 40 (5 #x138d8953afbc4605 4 #x-3e1046b4b58e453d2b568b21a92 3 #x-188b9fb0979b6580a852c94f287aaf2b3d5 2 #x-b2482cbc6ced0a1b1d12e9b9f3dc9517bbe81cf4 1 #x1917b9b5eef35badf7601ffd8e465c6193baa28e813a 0 #x61627af59c8508f7366b9bd9f3bcb72906a5fbb421fc00) 39 (5 #x-4eadbaa6f9f95256 4 #x2d83cbf21c85d2d96098bb7a582 3 #x42c82bd9be65097be1f9bf0a5d00a374540 2 #x53e9d70b8e711eec5320d2f3474148dd2bff23e6 1 #x-78d9033841cdfade11868cf0c21065fdf3f57b28c80 0 #x-14a295e69912dacf76c9ba442123b700b5846a04798000) 38 (5 #xfc1a42e95c89cfc7 4 #x-3e87b009a3d7df67545402b9 3 #x-4b3b15bbfe9c83e4ea71b667b7ee0893635 2 #x-7cfbf7a008b2c824b3777bbef33d2f28253059f 1 #x-1a202d1366b4dce86683cc1c3578499a2da7c345054 0 #x-153e68fe4698beed83ae3f798f53f24a97e9c9c180c000) 37 (5 #x-27a768871b4448a3c 4 #x-1e29550eea9bc52219962aa0fd6 3 #x316126384a12492ec7c0ec361215df83d1c 2 #x-1bfacd9651612816af7fb03c534f460f1b3f02aa 1 #x33314b9528227c0990c55150a51f1910c91ff5ef898 0 #x1fb9f9f240f951bb4152ff76a5915673e30cd1ed1d6000) 36 (5 #x4b16943dbc968df24 4 #x1b5b7fa70d6daad931642ddd3b6 3 #x-6e8a584591d88c0ea13bddf04d452d4298 2 #x1f4271c815e68234715e1076c450bf1482f6698f 1 #x-19f7f17c05b0830058c17307b64bc900f72a379ffa4 0 #x-18c682bd3e7fa81765c8e767ee1136608f66260ad01000) 35 (5 #x-5d3aceeef1e5b255c 4 #x-64b46186e005c1740742dcfdfb 3 #x-1d1cb0b9e27472e806e4012106b8349ebfd 2 #x-13f13e2dd533e97e1cd9b17aa8f032eb9975625c 1 #x13522d7689ab9be48992fdcbeb91e094d976fa63c0 0 #xd37487c76898a1c61ad65d1300850953823f8ae4f0000) 34 (5 #x1896ba3a44066e998 4 #x-9e3b7b800d561cb601dd180790 3 #x2bf04aa98d52dc1a28df27237472ea577fb 2 #x7da58cd2a319f6779649bc1d600d4ba22c765f4 1 #x81965f2457529f876021e51e7e878885221b8d85c0 0 #x-4228384a71ed9b7b44c18155eb5937fed88b737530000) 33 (5 #xc87b22429b44a2aed 4 #xb95fa7ccfc2d21c88325bb00ad 3 #x-250826ba7453e0b8bca567f45778c50b44e 2 #x-9debd11406dbc85792327c3864836bd4397994 1 #x-6ae61309dd76c4300b5b53396a80f2c82bf80f3f00 0 #x-a1eeb89f02620c74c95e0670ad33c2387ecd20900000) 32 (5 #x-210bf9dc01f033fe0f 4 #x-468c285a68774d326a39286e06 3 #x125fd978ef7b691c1a3e74c1511d2876113 2 #x-1eae1b491e3ae6853603562bc4226a7349aad93 1 #x26fe82f894986c3978cd27fc6e267bce31a07de7c0 0 #x2128416c0f70a929da41a1fc3bd21012f512c64b00000) 31 (5 #x2a316f23e19aa9440c 4 #x-252f2e848a7339b0b4c45c3b5e 3 #x-c1139ed92cd0eecbb4a4a9f6717e8f63 2 #x1e4a4db361a8eb78230dd5c8099e6dba8ba37e4 1 #x739a6c0914f6a0f9c6618c8e1389bba814bd33000 0 #x-1d5d53897a743b6254fdc63c689ba4244e34211700000) 30 (5 #x-1001508a39dc63e26e 4 #x4cb9070c8826036ef07599a677 3 #x-a8add5fdc4ca48af43c7545969537eb0ed 2 #x-11e28b4c2d2505c7629c0bdd165a45faa94ee84 1 #x-1621b1bf7549df699a1a5d72b5e31f406979f3e000 0 #x1238f76563a4678549b3fa7e7b53139558ffb18300000) 29 (5 #x-2f12cb7752befc7d47 4 #x-52c34c6af591c370a1a1853c60 3 #xc795e28f0b4c307e4901a2a0a9a100a231 2 #x74cf2f3b318f38a5dbb5162c8f7b7f785e2910 1 #x132b88be6780bd0ee405dbddd61982e2fc46eb9000 0 #x-8e5433194ac63bb35beddeac200cd857c0c3dc800000) 28 (5 #x6791b90cc3bfa406ad 4 #x76fa772e355e1ab069ec5548d9 3 #x-9076eb5b79eeb84c061659a7f274194b86 2 #x-1983c63e38950b51b26edfd87b4628598156ea 1 #x-b847d4603842e2128849be45a3af67b5f60f5a000 0 #x378ef044b2591d3474cb787e5a8a1fa1d5f37d800000) 27 (5 #x-5a1c3754d4f55d9f01 4 #x-e49b5cd3263a7b81a3825ceb56 3 #x43e6046da997c11b286779315bcd57f4dc 2 #x-86d93e78c7a3785612e43b3ff62a98f19c160 1 #x56d81b258e5d4dda25041057f788a48bbc39fe000 0 #x-10972a3045b5f8d4cb7e44fa6099ae92bdc8e0000000) 26 (5 #x-71508fb522b58e092 4 #x1aba9159bc7d25eea1f84541ba8 3 #x-ad1eef3220b6c244fb5b8609d90103a9a 2 #xe766f086bf2c5541874e1caad085e3dda696c 1 #x-20e6d743ae381f6f5c56b3fba98d5bee8d8658000 0 #x3172d0c7272b9fd49f77b509a1a30b903ff08000000) 25 (5 #x727a3307937469becb 4 #x-2c9add4c1a5a8c477278bd7e2c1 3 #x-ffc59d8f8067bd31418b51d219da60605 2 #x-b3cc0abe038cb73978670ca8fb9734b371a48 1 #x99ed0c9ecebbbb4c7b9cc42c35be254f44160000 0 #x28d2e3f44269e8fbdb1dba58baf7f1cfc9bc000000) 24 (5 #x-8441a36cf096462a2c 4 #x4293f92605072448eb6ce0ab0ff 3 #x145c13fc3db5ebb633ffedc16cc3e4ef80 2 #x6deedaa12c0f07c1165da09bba659b7aff1a6 1 #x-1b02124c2de113fd7e5bcb3208f16c0142f78000 0 #x-69620f5b34699ddc7079150f2357078fdf51000000) 23 (5 #x2a8e633c7de4c7c125 4 #x-59a67be270c2988bf1acaed751d 3 #x-ea77d4b336173ca354591f1f69ca53984 2 #x-3b5222d8b07a7c11323b25f3df864642e3f80 1 #x-45c759ee1ca76cd74847e897c9ecec7c10c0000 0 #x2fe8c232e4d73e75cbf90c08de3164185860000000) 22 (5 #x424f4c2bbfc771d7a5 4 #x6d44e19e2e271041b23c10bd075 3 #x79d428f65297c214ba3d769485d593779 2 #x1db6416d307bdac7daec8a963da7a8e845080 1 #x71e39202fd6ec5e1fb1fd0ff7c9992e76b80000 0 #x-c5244923fd029e993c75e79ae986d4710e0000000) 21 (5 #x-6152744744f98b5dc9 4 #x-789432fe045ddc6ac5307447b40 3 #x-2d4812ae27d66142afbb60501adc6c15a 2 #x-e375c1ade8458427fa63f19a72a5c43bb280 1 #x-461b3d5a1b4de34c97dbcf5e3e9cc1506480000 0 #x11556af3075c9dd4f0aac3955a6f1780d80000000) 20 (5 #x2ce7d9ffbdbb4d4c5a 4 #x785caba776b6649e05535203f9a 3 #x8b3593f1967b8f66bd1839dd9c10422b 2 #x696d6d944ce2f176729f55ef24fce4eb1980 1 #x20b5a29c93a03d177186fba2e62b1583bd80000 0 #xa30bee7889e84722b1adc56c2edffd2e00000000) 19 (5 #x138ced4599110c234d 4 #x-6c89f051cb64ba2e15aefc663de 3 #x304ae6547b3483a1d70510f23cc412c6 2 #x-2f4c7b322741688ef348c81f7c745a732180 1 #x-cc18b8811db6b80172b609747ab763e8800000 0 #x-5c4bbabbe1f49dcd1815d4def446702f80000000) 18 (5 #x-274c431e75ba0490ab 4 #x58476406deedafcf7f5b5e8f42e 3 #x-425012a6f1a14404661e728f89a1179e 2 #x144662caab84aacd1cb21b0fd073cb339080 1 #x436823505b478709c5033ad4ca6286ca400000 0 #x181487e5b32582bfef508deea67a28ca80000000) 17 (5 #x1420a650567f4eeeaa 4 #x-40a18ef4cdb109d70c720ee5fdc 3 #x291c04b128056e76d722f19d305181f8 2 #x-82621be358fc01792aef17a5394ab233c00 1 #x-12607a358da6eacb116ddf6937ebaa7b000000 0 #x-25462696676daef8ad8bc244c05f5d400000000) 16 (5 #x219898f93303a9be4 4 #x2a7d54ca004dcb4adac1cca88f7 3 #x-12b53146b1db1d942f6ef10330e1c37a 2 #x30399ed326027b39bba781244db88e02c00 1 #x3d08c123712cbe65264a73bbb71709c000000 0 #x-d375cfba42fb5c85cdffd30a26549400000000) 15 (5 #x-8833436234820da3a 4 #x-1902578cee0f3b31b718b169d8c 3 #x6d6e917b3f279f6a9323cdeb2b447a0 2 #x-1028d5e3636d7353cd25ecab39656f1c000 1 #x-6f2043c4b4d8661814a8dc05185586000000 0 #x6f3bb1708bd24cfb8962279c46d20000000000) 14 (5 #x4718fa2a1def9ee96 4 #xd21fb4eec201006a74f6647cd4 3 #x-20ed8af0589c354803934db91e5729c 2 #x4d84d094bb53c3903dea68c0c556a0c000 1 #x-11bb6abcbe4219f797374a1e5bdb7c000000 0 #x-177fb9c44452cba3027a81bdd60dc000000000) 13 (5 #x-36492fcf9e3b6b5b 4 #x-6206c1f3a4d9759892c05ad868 3 #x81df196b4782a6546035d9e72f2608 2 #x-1495bcc257e7cfe358bee39af8928f4000 1 #xe8dc1cab9810f64bae42f29334528000000 0 #x1026b4f6deda9c09e182b73d705e000000000) 12 (5 #x-e3c825ee26efb38b 4 #x286ccd785310a6301e966e8c98 3 #x-1950da8d92b346a4d29779cf96f7e4 2 #x4cc4f5500efb91c75a5c22982cd40a000 1 #x-4d09a7b07cff0cad8d8e2e0f24184000000 0 #xf0b9f06713c3a579243618445b1000000000) 11 (5 #x75a92e725cf6dc05 4 #x-ea633f2e9328594d703f60038 3 #x37aaf275b2b034fb777e87b1f80c0 2 #x-f9312c41a2599fc740fa65bda3260000 1 #x1139a11c4f2cb63c398626b576200000000 0 #x-50f98f3e5ea92129fc6c5133050000000000) 10 (5 #x-f4191d24dc219b5 4 #x4a1c074753bda954fff67922c 3 #x-29c94f64a150d1802fc0da3152c0 2 #x2ba9fa8fb5abbb386e5a2b7f79d60000 1 #x-2add88c000ef6cceea5f0016e240000000 0 #xb2d88e9245fa2ed2cd67c62b90000000000) 9 (5 #x-8f844bccc298ebc 4 #x-14456223102860dca545ef720 3 #x-138f3b3928c4d05f788521614000 2 #x-69307d2883c7e4996687a7939280000 1 #x3beb46bca811aee44a5c5ee9d80000000 0 #x64f6522d593bf10841c33fa00000000000) 8 (5 #x4beec9b76d971f1 4 #x4bf3c434ea30c3321da39bb7 3 #x76eeeeb104b26aec5524b7af2c0 2 #xda4b04378ca3cafa897cb020f80000 1 #x2e461e1a2246f0f2151bc754c0000000 0 #x-7f9d15826160e145023e61900000000000) 7 (5 #x-ce2ebd825a279b 4 #x-f0853d2b1bbf45d2dc568f8 3 #x-198482c01412253387a95434500 2 #x-18dff6cc88df3121951e0900780000 1 #x-229f51437098babf188f3c9000000000 0 #x19d2ff23909117b02dbbf3000000000000) 6 (5 #x-e2f9d21ffcd53 4 #x279544b38c1bb9240b0060c 3 #x403459d3807c68608598363500 2 #x29aa231655a91285227c493380000 1 #x7246b2ed0f7b5132f2f9ec400000000 0 #x-1e86ce81af300d8b9bb3d000000000000) 5 (5 #xc52feae027c30 4 #x-54d81510edd10205bb7180 3 #x-7e3fe510ed273cc140168b000 2 #x-433d7b473fb1ea626ee7acc00000 1 #x-f90466f910d490e77fbda000000000 0 #x-440a70344dc5ad923b60000000000000) 4 (5 #x-21ef7a83b2151 4 #x8fd2c96d3f766b86df6a2 3 #xc6ba499faa4a39a71fcce800 2 #x675e2a1208ef1abbb73cfc00000 1 #x19cca3dd4f6cac9589ba8000000000 0 #x18aa686df74f168221c0000000000000) 3 (5 #x1fe53cc1bf87 4 #x-b8f6746bfea51f3700a8 3 #x-fb45242607264353884c000 2 #x-8a7eb9c184c7545341d0000000 1 #x-230ab99698d0cace78a0000000000 0 #x-38de7993365cfb3e000000000000000) 2 (5 #x1a7dea1392b 4 #xa90e87442ec4713c624 3 #xf6f993c43a6a78990a5000 2 #x90d0e0555c03b90b3d4000000 1 #x277acb6137a2a5af980000000000 0 #x4d373c1f208cd39000000000000000) 1 (5 #x-4b9be14678 4 #x-618bc9af89ab4c8808 3 #x-a8998d7cae6c4a77b8000 2 #x-6a5faa5782b01b07c0000000 1 #x-20602c3668d26c4800000000000 0 #x-3cf968edb645e0000000000000000) 0 (6 1 5 #x2948d1a5e 4 #x1aa1a24d71e73cea1 3 #x3a95231ff6ad62ad0000 2 #x2c535acca39993640000000 1 #xd5170ea94fd4a000000000000 0 #x1605b5ca02440000000000000000)) 
)
