import type { AnyFunction } from '../types.ts';
import type { AnyThread, ThreadFunctions } from '../Thread.ts';
/**
 * A strategy for managing functions across threads that manually manages memory.
 * Functions are deserialized into a proxy that can be called, and when an equal number
 * of `retain()` and `release()` calls have been made with that function, it will
 * be released and no longer callable.
 *
 * For more details on manual memory management, refer to the
 * [dedicated README section](https://github.com/lemonmade/quilt/blob/main/packages/threads/README.md#memory-management).
 *
 * @see
 */
export declare class ThreadFunctionsManualMemoryManagement implements ThreadFunctions {
    #private;
    get(id: string): Function | undefined;
    release(id: string): boolean;
    call(func: AnyFunction, args: any[], thread: AnyThread): Promise<any>;
    serialize(func: AnyFunction): string;
    deserialize(id: string, thread: AnyThread): Function;
}
//# sourceMappingURL=ThreadFunctionsManualMemoryManagement.d.ts.map