import { NS, NamespaceURI } from './constants.mjs';
import { Element } from './Element.mjs';

class SVGElement extends Element {
  [NS] = (() => NamespaceURI.SVG)();
  get ownerSVGElement() {
    let root = null;
    let parent = this.parentNode;
    while (parent instanceof SVGElement) {
      root = parent;
      parent = parent.parentNode;
    }
    return root;
  }
}

export { SVGElement };
