/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_ACCIFCLAUSELOWERING
#define GEN_PASS_DECL_ACCIMPLICITDATA
#define GEN_PASS_DECL_ACCIMPLICITDECLARE
#define GEN_PASS_DECL_ACCIMPLICITROUTINE
#define GEN_PASS_DECL_ACCLEGALIZESERIAL
#define GEN_PASS_DECL_ACCLOOPTILING
#define GEN_PASS_DECL_ACCSPECIALIZEFORDEVICE
#define GEN_PASS_DECL_ACCSPECIALIZEFORHOST
#define GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#define GEN_PASS_DECL_OFFLOADLIVEINVALUECANONICALIZATION
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// ACCIfClauseLowering
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIFCLAUSELOWERING
std::unique_ptr<::mlir::Pass> createACCIfClauseLowering();
#undef GEN_PASS_DECL_ACCIFCLAUSELOWERING
#endif // GEN_PASS_DECL_ACCIFCLAUSELOWERING
#ifdef GEN_PASS_DEF_ACCIFCLAUSELOWERING

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCIfClauseLowering();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCIfClauseLoweringBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ACCIfClauseLoweringBase;

  ACCIfClauseLoweringBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCIfClauseLoweringBase(const ACCIfClauseLoweringBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  ACCIfClauseLoweringBase& operator=(const ACCIfClauseLoweringBase &) = delete;
  ACCIfClauseLoweringBase(ACCIfClauseLoweringBase &&) = delete;
  ACCIfClauseLoweringBase& operator=(ACCIfClauseLoweringBase &&) = delete;
  ~ACCIfClauseLoweringBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-if-clause-lowering");
  }
  ::llvm::StringRef getArgument() const override { return "acc-if-clause-lowering"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Lower if clauses in ACC compute constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCIfClauseLowering");
  }
  ::llvm::StringRef getName() const override { return "ACCIfClauseLowering"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCIfClauseLoweringBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createACCIfClauseLowering() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCIfClauseLowering() {
  return impl::createACCIfClauseLowering();
}
#undef GEN_PASS_DEF_ACCIFCLAUSELOWERING
#endif // GEN_PASS_DEF_ACCIFCLAUSELOWERING

//===----------------------------------------------------------------------===//
// ACCImplicitData
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIMPLICITDATA
struct ACCImplicitDataOptions {
  bool enableImplicitReductionCopy = true;
};
std::unique_ptr<::mlir::Pass> createACCImplicitData();
std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options);
#undef GEN_PASS_DECL_ACCIMPLICITDATA
#endif // GEN_PASS_DECL_ACCIMPLICITDATA
#ifdef GEN_PASS_DEF_ACCIMPLICITDATA

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitData();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCImplicitDataBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitDataBase;

  ACCImplicitDataBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitDataBase(const ACCImplicitDataBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitDataBase& operator=(const ACCImplicitDataBase &) = delete;
  ACCImplicitDataBase(ACCImplicitDataBase &&) = delete;
  ACCImplicitDataBase& operator=(ACCImplicitDataBase &&) = delete;
  ~ACCImplicitDataBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-data");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-data"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit data attributes for OpenACC compute constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitData");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitData"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitDataBase<DerivedT>)

  ACCImplicitDataBase(ACCImplicitDataOptions options) : ACCImplicitDataBase() {
    enableImplicitReductionCopy = std::move(options.enableImplicitReductionCopy);
  }
protected:
  ::mlir::Pass::Option<bool> enableImplicitReductionCopy{*this, "enable-implicit-reduction-copy", ::llvm::cl::desc(R"PO(Enable applying implicit copy in lieu of implicit firstprivate for reduction variables. This allows uniform treatment of reduction variables between combined constructs (e.g., 'parallel loop') and separate constructs (e.g., 'parallel' followed by 'loop'), where the OpenACC spec requires copy semantics for the former but firstprivate would normally apply for the latter.)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createACCImplicitData() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCImplicitData() {
  return impl::createACCImplicitData();
}

std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options) {
  return impl::createACCImplicitData(std::move(options));
}
#undef GEN_PASS_DEF_ACCIMPLICITDATA
#endif // GEN_PASS_DEF_ACCIMPLICITDATA

//===----------------------------------------------------------------------===//
// ACCImplicitDeclare
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIMPLICITDECLARE
std::unique_ptr<::mlir::Pass> createACCImplicitDeclare();
#undef GEN_PASS_DECL_ACCIMPLICITDECLARE
#endif // GEN_PASS_DECL_ACCIMPLICITDECLARE
#ifdef GEN_PASS_DEF_ACCIMPLICITDECLARE

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitDeclare();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCImplicitDeclareBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitDeclareBase;

  ACCImplicitDeclareBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitDeclareBase(const ACCImplicitDeclareBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitDeclareBase& operator=(const ACCImplicitDeclareBase &) = delete;
  ACCImplicitDeclareBase(ACCImplicitDeclareBase &&) = delete;
  ACCImplicitDeclareBase& operator=(ACCImplicitDeclareBase &&) = delete;
  ~ACCImplicitDeclareBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-declare");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-declare"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Applies implicit acc declare to globals referenced in compute and routine acc regions)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitDeclare");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitDeclare"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitDeclareBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createACCImplicitDeclare() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCImplicitDeclare() {
  return impl::createACCImplicitDeclare();
}
#undef GEN_PASS_DEF_ACCIMPLICITDECLARE
#endif // GEN_PASS_DEF_ACCIMPLICITDECLARE

//===----------------------------------------------------------------------===//
// ACCImplicitRoutine
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIMPLICITROUTINE
struct ACCImplicitRoutineOptions {
  mlir::acc::DeviceType deviceType = mlir::acc::DeviceType::None;
};
std::unique_ptr<::mlir::Pass> createACCImplicitRoutine();
std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options);
#undef GEN_PASS_DECL_ACCIMPLICITROUTINE
#endif // GEN_PASS_DECL_ACCIMPLICITROUTINE
#ifdef GEN_PASS_DEF_ACCIMPLICITROUTINE

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitRoutine();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCImplicitRoutineBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitRoutineBase;

  ACCImplicitRoutineBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitRoutineBase(const ACCImplicitRoutineBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitRoutineBase& operator=(const ACCImplicitRoutineBase &) = delete;
  ACCImplicitRoutineBase(ACCImplicitRoutineBase &&) = delete;
  ACCImplicitRoutineBase& operator=(ACCImplicitRoutineBase &&) = delete;
  ~ACCImplicitRoutineBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-routine");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-routine"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit acc routine for functions in acc regions)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitRoutine");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitRoutine"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitRoutineBase<DerivedT>)

  ACCImplicitRoutineBase(ACCImplicitRoutineOptions options) : ACCImplicitRoutineBase() {
    deviceType = std::move(options.deviceType);
  }
protected:
  ::mlir::Pass::Option<mlir::acc::DeviceType> deviceType{*this, "device-type", ::llvm::cl::desc(R"PO(Target device type for implicit routine generation. Ensures that `acc routine` device_type clauses are properly considered not just default clauses.)PO"), ::llvm::cl::init(mlir::acc::DeviceType::None), ::llvm::cl::values(
              clEnumValN(mlir::acc::DeviceType::None, "none", "none"),
              clEnumValN(mlir::acc::DeviceType::Host, "host", "host"),
              clEnumValN(mlir::acc::DeviceType::Multicore, "multicore", "multicore"),
              clEnumValN(mlir::acc::DeviceType::Nvidia, "nvidia", "nvidia"),
              clEnumValN(mlir::acc::DeviceType::Radeon, "radeon", "radeon"))
           };
private:

  friend std::unique_ptr<::mlir::Pass> createACCImplicitRoutine() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCImplicitRoutine() {
  return impl::createACCImplicitRoutine();
}

std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options) {
  return impl::createACCImplicitRoutine(std::move(options));
}
#undef GEN_PASS_DEF_ACCIMPLICITROUTINE
#endif // GEN_PASS_DEF_ACCIMPLICITROUTINE

//===----------------------------------------------------------------------===//
// ACCLegalizeSerial
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCLEGALIZESERIAL
std::unique_ptr<::mlir::Pass> createACCLegalizeSerial();
#undef GEN_PASS_DECL_ACCLEGALIZESERIAL
#endif // GEN_PASS_DECL_ACCLEGALIZESERIAL
#ifdef GEN_PASS_DEF_ACCLEGALIZESERIAL

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCLegalizeSerial();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCLegalizeSerialBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ACCLegalizeSerialBase;

  ACCLegalizeSerialBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCLegalizeSerialBase(const ACCLegalizeSerialBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  ACCLegalizeSerialBase& operator=(const ACCLegalizeSerialBase &) = delete;
  ACCLegalizeSerialBase(ACCLegalizeSerialBase &&) = delete;
  ACCLegalizeSerialBase& operator=(ACCLegalizeSerialBase &&) = delete;
  ~ACCLegalizeSerialBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-legalize-serial");
  }
  ::llvm::StringRef getArgument() const override { return "acc-legalize-serial"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize OpenACC serial constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCLegalizeSerial");
  }
  ::llvm::StringRef getName() const override { return "ACCLegalizeSerial"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCLegalizeSerialBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createACCLegalizeSerial() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCLegalizeSerial() {
  return impl::createACCLegalizeSerial();
}
#undef GEN_PASS_DEF_ACCLEGALIZESERIAL
#endif // GEN_PASS_DEF_ACCLEGALIZESERIAL

//===----------------------------------------------------------------------===//
// ACCLoopTiling
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCLOOPTILING
struct ACCLoopTilingOptions {
  int32_t defaultTileSize = 32;
};
std::unique_ptr<::mlir::Pass> createACCLoopTiling();
std::unique_ptr<::mlir::Pass> createACCLoopTiling(ACCLoopTilingOptions options);
#undef GEN_PASS_DECL_ACCLOOPTILING
#endif // GEN_PASS_DECL_ACCLOOPTILING
#ifdef GEN_PASS_DEF_ACCLOOPTILING

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCLoopTiling();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCLoopTiling(ACCLoopTilingOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCLoopTilingBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ACCLoopTilingBase;

  ACCLoopTilingBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCLoopTilingBase(const ACCLoopTilingBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  ACCLoopTilingBase& operator=(const ACCLoopTilingBase &) = delete;
  ACCLoopTilingBase(ACCLoopTilingBase &&) = delete;
  ACCLoopTilingBase& operator=(ACCLoopTilingBase &&) = delete;
  ~ACCLoopTilingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-loop-tiling");
  }
  ::llvm::StringRef getArgument() const override { return "acc-loop-tiling"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Tile OpenACC loops with tile clauses)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCLoopTiling");
  }
  ::llvm::StringRef getName() const override { return "ACCLoopTiling"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCLoopTilingBase<DerivedT>)

  ACCLoopTilingBase(ACCLoopTilingOptions options) : ACCLoopTilingBase() {
    defaultTileSize = std::move(options.defaultTileSize);
  }
protected:
  ::mlir::Pass::Option<int32_t> defaultTileSize{*this, "default-tile-size", ::llvm::cl::desc(R"PO(Default tile size to use for wildcard ('*') tile sizes)PO"), ::llvm::cl::init(32)};
private:

  friend std::unique_ptr<::mlir::Pass> createACCLoopTiling() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCLoopTiling(ACCLoopTilingOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCLoopTiling() {
  return impl::createACCLoopTiling();
}

std::unique_ptr<::mlir::Pass> createACCLoopTiling(ACCLoopTilingOptions options) {
  return impl::createACCLoopTiling(std::move(options));
}
#undef GEN_PASS_DEF_ACCLOOPTILING
#endif // GEN_PASS_DEF_ACCLOOPTILING

//===----------------------------------------------------------------------===//
// ACCSpecializeForDevice
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCSPECIALIZEFORDEVICE
std::unique_ptr<::mlir::Pass> createACCSpecializeForDevice();
#undef GEN_PASS_DECL_ACCSPECIALIZEFORDEVICE
#endif // GEN_PASS_DECL_ACCSPECIALIZEFORDEVICE
#ifdef GEN_PASS_DEF_ACCSPECIALIZEFORDEVICE

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCSpecializeForDevice();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCSpecializeForDeviceBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ACCSpecializeForDeviceBase;

  ACCSpecializeForDeviceBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCSpecializeForDeviceBase(const ACCSpecializeForDeviceBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  ACCSpecializeForDeviceBase& operator=(const ACCSpecializeForDeviceBase &) = delete;
  ACCSpecializeForDeviceBase(ACCSpecializeForDeviceBase &&) = delete;
  ACCSpecializeForDeviceBase& operator=(ACCSpecializeForDeviceBase &&) = delete;
  ~ACCSpecializeForDeviceBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-specialize-for-device");
  }
  ::llvm::StringRef getArgument() const override { return "acc-specialize-for-device"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Strip OpenACC constructs inside device code)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCSpecializeForDevice");
  }
  ::llvm::StringRef getName() const override { return "ACCSpecializeForDevice"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCSpecializeForDeviceBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createACCSpecializeForDevice() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCSpecializeForDevice() {
  return impl::createACCSpecializeForDevice();
}
#undef GEN_PASS_DEF_ACCSPECIALIZEFORDEVICE
#endif // GEN_PASS_DEF_ACCSPECIALIZEFORDEVICE

//===----------------------------------------------------------------------===//
// ACCSpecializeForHost
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCSPECIALIZEFORHOST
struct ACCSpecializeForHostOptions {
  bool enableHostFallback = false;
};
std::unique_ptr<::mlir::Pass> createACCSpecializeForHost();
std::unique_ptr<::mlir::Pass> createACCSpecializeForHost(ACCSpecializeForHostOptions options);
#undef GEN_PASS_DECL_ACCSPECIALIZEFORHOST
#endif // GEN_PASS_DECL_ACCSPECIALIZEFORHOST
#ifdef GEN_PASS_DEF_ACCSPECIALIZEFORHOST

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCSpecializeForHost();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCSpecializeForHost(ACCSpecializeForHostOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCSpecializeForHostBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ACCSpecializeForHostBase;

  ACCSpecializeForHostBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCSpecializeForHostBase(const ACCSpecializeForHostBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  ACCSpecializeForHostBase& operator=(const ACCSpecializeForHostBase &) = delete;
  ACCSpecializeForHostBase(ACCSpecializeForHostBase &&) = delete;
  ACCSpecializeForHostBase& operator=(ACCSpecializeForHostBase &&) = delete;
  ~ACCSpecializeForHostBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-specialize-for-host");
  }
  ::llvm::StringRef getArgument() const override { return "acc-specialize-for-host"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Convert OpenACC operations for host execution)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCSpecializeForHost");
  }
  ::llvm::StringRef getName() const override { return "ACCSpecializeForHost"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCSpecializeForHostBase<DerivedT>)

  ACCSpecializeForHostBase(ACCSpecializeForHostOptions options) : ACCSpecializeForHostBase() {
    enableHostFallback = std::move(options.enableHostFallback);
  }
protected:
  ::mlir::Pass::Option<bool> enableHostFallback{*this, "enable-host-fallback", ::llvm::cl::desc(R"PO(Enable host fallback mode which converts ALL ACC operations, not just orphan operations. Use this when the `if` clause evaluates to false.)PO"), ::llvm::cl::init(false)};
private:

  friend std::unique_ptr<::mlir::Pass> createACCSpecializeForHost() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCSpecializeForHost(ACCSpecializeForHostOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCSpecializeForHost() {
  return impl::createACCSpecializeForHost();
}

std::unique_ptr<::mlir::Pass> createACCSpecializeForHost(ACCSpecializeForHostOptions options) {
  return impl::createACCSpecializeForHost(std::move(options));
}
#undef GEN_PASS_DEF_ACCSPECIALIZEFORHOST
#endif // GEN_PASS_DEF_ACCSPECIALIZEFORHOST

//===----------------------------------------------------------------------===//
// LegalizeDataValuesInRegion
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
struct LegalizeDataValuesInRegionOptions {
  bool hostToDevice = true;
  bool applyToAccDataConstruct = true;
};
std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion();
std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options);
#undef GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#ifdef GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION

namespace impl {
  std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class LegalizeDataValuesInRegionBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = LegalizeDataValuesInRegionBase;

  LegalizeDataValuesInRegionBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeDataValuesInRegionBase(const LegalizeDataValuesInRegionBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  LegalizeDataValuesInRegionBase& operator=(const LegalizeDataValuesInRegionBase &) = delete;
  LegalizeDataValuesInRegionBase(LegalizeDataValuesInRegionBase &&) = delete;
  LegalizeDataValuesInRegionBase& operator=(LegalizeDataValuesInRegionBase &&) = delete;
  ~LegalizeDataValuesInRegionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("openacc-legalize-data-values");
  }
  ::llvm::StringRef getArgument() const override { return "openacc-legalize-data-values"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalizes SSA values in compute regions with results from data clause operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeDataValuesInRegion");
  }
  ::llvm::StringRef getName() const override { return "LegalizeDataValuesInRegion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeDataValuesInRegionBase<DerivedT>)

  LegalizeDataValuesInRegionBase(LegalizeDataValuesInRegionOptions options) : LegalizeDataValuesInRegionBase() {
    hostToDevice = std::move(options.hostToDevice);
    applyToAccDataConstruct = std::move(options.applyToAccDataConstruct);
  }
protected:
  ::mlir::Pass::Option<bool> hostToDevice{*this, "host-to-device", ::llvm::cl::desc(R"PO(Replace varPtr uses with accPtr if true. Replace accPtr uses with varPtr if false)PO"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> applyToAccDataConstruct{*this, "apply-to-acc-data-construct", ::llvm::cl::desc(R"PO(Replaces varPtr uses with accPtr for acc compute regions contained within acc.data or acc.declare region.)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion() {
  return impl::createLegalizeDataValuesInRegion();
}

std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options) {
  return impl::createLegalizeDataValuesInRegion(std::move(options));
}
#undef GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION

//===----------------------------------------------------------------------===//
// OffloadLiveInValueCanonicalization
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OFFLOADLIVEINVALUECANONICALIZATION
std::unique_ptr<::mlir::Pass> createOffloadLiveInValueCanonicalization();
#undef GEN_PASS_DECL_OFFLOADLIVEINVALUECANONICALIZATION
#endif // GEN_PASS_DECL_OFFLOADLIVEINVALUECANONICALIZATION
#ifdef GEN_PASS_DEF_OFFLOADLIVEINVALUECANONICALIZATION

namespace impl {
  std::unique_ptr<::mlir::Pass> createOffloadLiveInValueCanonicalization();
} // namespace impl
namespace impl {

template <typename DerivedT>
class OffloadLiveInValueCanonicalizationBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = OffloadLiveInValueCanonicalizationBase;

  OffloadLiveInValueCanonicalizationBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OffloadLiveInValueCanonicalizationBase(const OffloadLiveInValueCanonicalizationBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  OffloadLiveInValueCanonicalizationBase& operator=(const OffloadLiveInValueCanonicalizationBase &) = delete;
  OffloadLiveInValueCanonicalizationBase(OffloadLiveInValueCanonicalizationBase &&) = delete;
  OffloadLiveInValueCanonicalizationBase& operator=(OffloadLiveInValueCanonicalizationBase &&) = delete;
  ~OffloadLiveInValueCanonicalizationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("offload-livein-value-canonicalization");
  }
  ::llvm::StringRef getArgument() const override { return "offload-livein-value-canonicalization"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Canonicalize live-in values for regions destined for outlining)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OffloadLiveInValueCanonicalization");
  }
  ::llvm::StringRef getName() const override { return "OffloadLiveInValueCanonicalization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OffloadLiveInValueCanonicalizationBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createOffloadLiveInValueCanonicalization() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createOffloadLiveInValueCanonicalization() {
  return impl::createOffloadLiveInValueCanonicalization();
}
#undef GEN_PASS_DEF_OFFLOADLIVEINVALUECANONICALIZATION
#endif // GEN_PASS_DEF_OFFLOADLIVEINVALUECANONICALIZATION
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_ACCIFCLAUSELOWERING
#define GEN_PASS_REGISTRATION_ACCIMPLICITDATA
#define GEN_PASS_REGISTRATION_ACCIMPLICITDECLARE
#define GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE
#define GEN_PASS_REGISTRATION_ACCLEGALIZESERIAL
#define GEN_PASS_REGISTRATION_ACCLOOPTILING
#define GEN_PASS_REGISTRATION_ACCSPECIALIZEFORDEVICE
#define GEN_PASS_REGISTRATION_ACCSPECIALIZEFORHOST
#define GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION
#define GEN_PASS_REGISTRATION_OFFLOADLIVEINVALUECANONICALIZATION
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ACCIfClauseLowering Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIFCLAUSELOWERING

inline void registerACCIfClauseLowering() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCIfClauseLowering();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCIfClauseLoweringPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCIfClauseLowering();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIFCLAUSELOWERING
#endif // GEN_PASS_REGISTRATION_ACCIFCLAUSELOWERING

//===----------------------------------------------------------------------===//
// ACCImplicitData Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIMPLICITDATA

inline void registerACCImplicitData() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitData();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCImplicitDataPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitData();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIMPLICITDATA
#endif // GEN_PASS_REGISTRATION_ACCIMPLICITDATA

//===----------------------------------------------------------------------===//
// ACCImplicitDeclare Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIMPLICITDECLARE

inline void registerACCImplicitDeclare() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitDeclare();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCImplicitDeclarePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitDeclare();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIMPLICITDECLARE
#endif // GEN_PASS_REGISTRATION_ACCIMPLICITDECLARE

//===----------------------------------------------------------------------===//
// ACCImplicitRoutine Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE

inline void registerACCImplicitRoutine() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitRoutine();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCImplicitRoutinePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitRoutine();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE
#endif // GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE

//===----------------------------------------------------------------------===//
// ACCLegalizeSerial Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCLEGALIZESERIAL

inline void registerACCLegalizeSerial() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCLegalizeSerial();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCLegalizeSerialPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCLegalizeSerial();
  });
}

#undef GEN_PASS_REGISTRATION_ACCLEGALIZESERIAL
#endif // GEN_PASS_REGISTRATION_ACCLEGALIZESERIAL

//===----------------------------------------------------------------------===//
// ACCLoopTiling Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCLOOPTILING

inline void registerACCLoopTiling() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCLoopTiling();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCLoopTilingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCLoopTiling();
  });
}

#undef GEN_PASS_REGISTRATION_ACCLOOPTILING
#endif // GEN_PASS_REGISTRATION_ACCLOOPTILING

//===----------------------------------------------------------------------===//
// ACCSpecializeForDevice Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCSPECIALIZEFORDEVICE

inline void registerACCSpecializeForDevice() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCSpecializeForDevice();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCSpecializeForDevicePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCSpecializeForDevice();
  });
}

#undef GEN_PASS_REGISTRATION_ACCSPECIALIZEFORDEVICE
#endif // GEN_PASS_REGISTRATION_ACCSPECIALIZEFORDEVICE

//===----------------------------------------------------------------------===//
// ACCSpecializeForHost Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCSPECIALIZEFORHOST

inline void registerACCSpecializeForHost() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCSpecializeForHost();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCSpecializeForHostPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCSpecializeForHost();
  });
}

#undef GEN_PASS_REGISTRATION_ACCSPECIALIZEFORHOST
#endif // GEN_PASS_REGISTRATION_ACCSPECIALIZEFORHOST

//===----------------------------------------------------------------------===//
// LegalizeDataValuesInRegion Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION

inline void registerLegalizeDataValuesInRegion() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeDataValuesInRegion();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerLegalizeDataValuesInRegionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeDataValuesInRegion();
  });
}

#undef GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION

//===----------------------------------------------------------------------===//
// OffloadLiveInValueCanonicalization Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_OFFLOADLIVEINVALUECANONICALIZATION

inline void registerOffloadLiveInValueCanonicalization() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOffloadLiveInValueCanonicalization();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOffloadLiveInValueCanonicalizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOffloadLiveInValueCanonicalization();
  });
}

#undef GEN_PASS_REGISTRATION_OFFLOADLIVEINVALUECANONICALIZATION
#endif // GEN_PASS_REGISTRATION_OFFLOADLIVEINVALUECANONICALIZATION
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// OpenACC Registration
//===----------------------------------------------------------------------===//

inline void registerOpenACCPasses() {
  registerACCIfClauseLowering();
  registerACCImplicitData();
  registerACCImplicitDeclare();
  registerACCImplicitRoutine();
  registerACCLegalizeSerial();
  registerACCLoopTiling();
  registerACCSpecializeForDevice();
  registerACCSpecializeForHost();
  registerLegalizeDataValuesInRegion();
  registerOffloadLiveInValueCanonicalization();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_CLASSES
#error "GEN_PASS_CLASSES is deprecated; use per-pass macros"
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
