/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: SMT.td                                                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::smt {

// smt bit-vector comparison predicate
enum class BVCmpPredicate : uint64_t {
  slt = 0,
  sle = 1,
  sgt = 2,
  sge = 3,
  ult = 4,
  ule = 5,
  ugt = 6,
  uge = 7,
};

::std::optional<BVCmpPredicate> symbolizeBVCmpPredicate(uint64_t);
::llvm::StringRef stringifyBVCmpPredicate(BVCmpPredicate);
::std::optional<BVCmpPredicate> symbolizeBVCmpPredicate(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForBVCmpPredicate() {
  return 7;
}


inline ::llvm::StringRef stringifyEnum(BVCmpPredicate enumValue) {
  return stringifyBVCmpPredicate(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<BVCmpPredicate> symbolizeEnum<BVCmpPredicate>(::llvm::StringRef str) {
  return symbolizeBVCmpPredicate(str);
}

class BVCmpPredicateAttr : public ::mlir::IntegerAttr {
public:
  using ValueType = BVCmpPredicate;
  using ::mlir::IntegerAttr::IntegerAttr;
  static bool classof(::mlir::Attribute attr);
  static BVCmpPredicateAttr get(::mlir::MLIRContext *context, BVCmpPredicate val);
  BVCmpPredicate getValue() const;
};

} // namespace mlir::smt

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<mlir::smt::BVCmpPredicate, mlir::smt::BVCmpPredicate> {
  template <typename ParserT>
  static FailureOr<mlir::smt::BVCmpPredicate> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for smt bit-vector comparison predicate");

    // Symbolize the keyword.
    if (::std::optional<mlir::smt::BVCmpPredicate> attr = mlir::smt::symbolizeEnum<mlir::smt::BVCmpPredicate>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [slt, sle, sgt, sge, ult, ule, ugt, uge] for smt bit-vector comparison predicate, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<mlir::smt::BVCmpPredicate>, std::optional<mlir::smt::BVCmpPredicate>> {
  template <typename ParserT>
  static FailureOr<std::optional<mlir::smt::BVCmpPredicate>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<mlir::smt::BVCmpPredicate>{};

    // Symbolize the keyword.
    if (::std::optional<mlir::smt::BVCmpPredicate> attr = mlir::smt::symbolizeEnum<mlir::smt::BVCmpPredicate>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [slt, sle, sgt, sge, ult, ule, ugt, uge] for smt bit-vector comparison predicate, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, mlir::smt::BVCmpPredicate value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<mlir::smt::BVCmpPredicate> {
  using StorageInfo = ::llvm::DenseMapInfo<uint64_t>;

  static inline mlir::smt::BVCmpPredicate getEmptyKey() {
    return static_cast<mlir::smt::BVCmpPredicate>(StorageInfo::getEmptyKey());
  }

  static inline mlir::smt::BVCmpPredicate getTombstoneKey() {
    return static_cast<mlir::smt::BVCmpPredicate>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const mlir::smt::BVCmpPredicate &val) {
    return StorageInfo::getHashValue(static_cast<uint64_t>(val));
  }

  static bool isEqual(const mlir::smt::BVCmpPredicate &lhs, const mlir::smt::BVCmpPredicate &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir::smt {

// smt comparison predicate for integers
enum class IntPredicate : uint64_t {
  lt = 0,
  le = 1,
  gt = 2,
  ge = 3,
};

::std::optional<IntPredicate> symbolizeIntPredicate(uint64_t);
::llvm::StringRef stringifyIntPredicate(IntPredicate);
::std::optional<IntPredicate> symbolizeIntPredicate(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForIntPredicate() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(IntPredicate enumValue) {
  return stringifyIntPredicate(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<IntPredicate> symbolizeEnum<IntPredicate>(::llvm::StringRef str) {
  return symbolizeIntPredicate(str);
}

class IntPredicateAttr : public ::mlir::IntegerAttr {
public:
  using ValueType = IntPredicate;
  using ::mlir::IntegerAttr::IntegerAttr;
  static bool classof(::mlir::Attribute attr);
  static IntPredicateAttr get(::mlir::MLIRContext *context, IntPredicate val);
  IntPredicate getValue() const;
};

} // namespace mlir::smt

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<mlir::smt::IntPredicate, mlir::smt::IntPredicate> {
  template <typename ParserT>
  static FailureOr<mlir::smt::IntPredicate> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for smt comparison predicate for integers");

    // Symbolize the keyword.
    if (::std::optional<mlir::smt::IntPredicate> attr = mlir::smt::symbolizeEnum<mlir::smt::IntPredicate>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [lt, le, gt, ge] for smt comparison predicate for integers, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<mlir::smt::IntPredicate>, std::optional<mlir::smt::IntPredicate>> {
  template <typename ParserT>
  static FailureOr<std::optional<mlir::smt::IntPredicate>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<mlir::smt::IntPredicate>{};

    // Symbolize the keyword.
    if (::std::optional<mlir::smt::IntPredicate> attr = mlir::smt::symbolizeEnum<mlir::smt::IntPredicate>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [lt, le, gt, ge] for smt comparison predicate for integers, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, mlir::smt::IntPredicate value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<mlir::smt::IntPredicate> {
  using StorageInfo = ::llvm::DenseMapInfo<uint64_t>;

  static inline mlir::smt::IntPredicate getEmptyKey() {
    return static_cast<mlir::smt::IntPredicate>(StorageInfo::getEmptyKey());
  }

  static inline mlir::smt::IntPredicate getTombstoneKey() {
    return static_cast<mlir::smt::IntPredicate>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const mlir::smt::IntPredicate &val) {
    return StorageInfo::getHashValue(static_cast<uint64_t>(val));
  }

  static bool isEqual(const mlir::smt::IntPredicate &lhs, const mlir::smt::IntPredicate &rhs) {
    return lhs == rhs;
  }
};
}

