/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution.scope.internal;

import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import org.apache.maven.di.Key;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.WeakMojoExecutionListener;
import org.apache.maven.plugin.MojoExecutionException;

public class MojoExecutionScope
extends org.apache.maven.impl.di.MojoExecutionScope
implements Scope,
MojoExecutionListener {
    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seed(clazz, () -> value.get());
    }

    public <T> Provider<T> scope(com.google.inject.Key<T> key, Provider<T> unscoped) {
        Object object;
        Annotation annotation = key.getAnnotation();
        if (annotation instanceof Named) {
            Named n = (Named)annotation;
            object = n.value();
        } else {
            object = key.getAnnotation();
        }
        Annotation qualifier = object;
        Key k = Key.ofType((Type)key.getTypeLiteral().getType(), (Object)qualifier);
        return ((Supplier)this.scope(k, () -> unscoped.get()))::get;
    }

    public static <T> Provider<T> seededKeyProvider(Class<? extends T> clazz) {
        return ((Supplier)MojoExecutionScope.seededKeySupplier(clazz))::get;
    }

    @Override
    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.beforeMojoExecution(event);
        }
    }

    @Override
    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterMojoExecutionSuccess(event);
        }
    }

    @Override
    public void afterExecutionFailure(MojoExecutionEvent event) {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterExecutionFailure(event);
        }
    }

    private Collection<WeakMojoExecutionListener> getProvidedListeners() {
        IdentityHashMap listeners = new IdentityHashMap();
        for (Object provided : this.getScopeState().provided()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            WeakMojoExecutionListener weakMojoExecutionListener = (WeakMojoExecutionListener)provided;
            listeners.put(weakMojoExecutionListener, null);
        }
        return listeners.keySet();
    }
}

