/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Event;
import org.apache.maven.api.EventType;
import org.apache.maven.api.Listener;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.internal.impl.DefaultEvent;
import org.apache.maven.internal.impl.InternalMavenSession;

@Named
@Singleton
public class EventSpyImpl
implements EventSpy {
    @Override
    public void init(EventSpy.Context context) throws Exception {
    }

    @Override
    public void onEvent(Object arg) throws Exception {
        if (arg instanceof ExecutionEvent) {
            ExecutionEvent ee = (ExecutionEvent)arg;
            InternalMavenSession session = InternalMavenSession.from(ee.getSession().getSession());
            EventType eventType = this.convert(ee.getType());
            Collection listeners = session.getListeners();
            if (!listeners.isEmpty()) {
                DefaultEvent event = new DefaultEvent(session, ee, eventType);
                for (Listener listener : listeners) {
                    listener.onEvent((Event)event);
                }
            }
        }
    }

    protected EventType convert(ExecutionEvent.Type type) {
        return EventType.values()[type.ordinal()];
    }

    @Override
    public void close() throws Exception {
    }
}

