/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnsh;

import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.mvnsh.ShellOptions;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.cling.invoker.CommonsCliOptions;
import org.apache.maven.cling.invoker.Utils;

public class CommonsCliShellOptions
extends CommonsCliOptions
implements ShellOptions {
    public static CommonsCliShellOptions parse(String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliShellOptions("CLI", cliManager, cliManager.parse(args));
    }

    protected CommonsCliShellOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        super(source, cliManager, commandLine);
    }

    private static CommonsCliShellOptions interpolate(CommonsCliShellOptions options, UnaryOperator<String> callback) {
        try {
            Interpolator interpolator = Utils.createInterpolator();
            CommandLine.Builder commandLineBuilder = new CommandLine.Builder();
            commandLineBuilder.setDeprecatedHandler(o -> {});
            for (Option option : options.commandLine.getOptions()) {
                if (!"D".equals(option.getOpt())) {
                    List values = option.getValuesList();
                    ListIterator<String> it = values.listIterator();
                    while (it.hasNext()) {
                        it.set(interpolator.interpolate((String)it.next(), callback));
                    }
                }
                commandLineBuilder.addOption(option);
            }
            for (String arg : options.commandLine.getArgList()) {
                commandLineBuilder.addArg(interpolator.interpolate(arg, callback));
            }
            return new CommonsCliShellOptions(options.source, (CLIManager)options.cliManager, commandLineBuilder.build());
        }
        catch (InterpolatorException e) {
            throw new IllegalArgumentException("Could not interpolate CommonsCliOptions", e);
        }
    }

    public ShellOptions interpolate(UnaryOperator<String> callback) {
        return CommonsCliShellOptions.interpolate(this, callback);
    }

    protected static class CLIManager
    extends CommonsCliOptions.CLIManager {
        protected CLIManager() {
        }

        @Override
        protected String commandLineSyntax(String command) {
            return command + " [options]";
        }
    }
}

