///////////////////////////////////////////////////////////////////////////////
//
// File: NodalTriSPIData.h
//
// For more information, please see: http://www.nektar.info
//
// The MIT License
//
// Copyright (c) 2006 Division of Applied Mathematics, Brown University (USA),
// Department of Aeronautics, Imperial College London (UK), and Scientific
// Computing and Imaging Institute, University of Utah (USA).
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
// Description: 2D Nodal Triangle SPI point data
//
///////////////////////////////////////////////////////////////////////////////

#ifndef NODALTRISPIDATA_H
#define NODALTRISPIDATA_H

namespace Nektar::LibUtilities
{
const size_t NodalTriSPIAvailable                         = 10;
static const size_t NodalTriSPINPTS[NodalTriSPIAvailable] = {
    1, 3, 6, 6, 7, 13, 16, 18, 22, 25};
static const NekDouble NodalTriSPIData[][3] = {
    // %%% x y w
    // 1 1 %%% Order / Number of Points
    {-0.33333333333333333333333333333333333333,
     -0.33333333333333333333333333333333333333, 2},
    // 2 3 %%% Order / Number of Points
    {-0.66666666666666666666666666666666666667,
     0.33333333333333333333333333333333333333,
     0.66666666666666666666666666666666666667},
    {0.33333333333333333333333333333333333333,
     -0.66666666666666666666666666666666666667,
     0.66666666666666666666666666666666666667},
    {-0.66666666666666666666666666666666666667,
     -0.66666666666666666666666666666666666667,
     0.66666666666666666666666666666666666667},
    // 3 6 %%% Order / Number of Points
    {-0.1081030181680702273633414922338960232,
     -0.7837939636638595452733170155322079536,
     0.44676317935602293139001401686624560874},
    {-0.7837939636638595452733170155322079536,
     -0.1081030181680702273633414922338960232,
     0.44676317935602293139001401686624560874},
    {-0.1081030181680702273633414922338960232,
     -0.1081030181680702273633414922338960232,
     0.44676317935602293139001401686624560874},
    {-0.81684757298045851308085707319559698429,
     0.63369514596091702616171414639119396858,
     0.21990348731064373527665264980042105793},
    {0.63369514596091702616171414639119396858,
     -0.81684757298045851308085707319559698429,
     0.21990348731064373527665264980042105793},
    {-0.81684757298045851308085707319559698429,
     -0.81684757298045851308085707319559698429,
     0.21990348731064373527665264980042105793},
    // 4 6 %%% Order / Number of Points
    {-0.1081030181680702273633414922338960232,
     -0.7837939636638595452733170155322079536,
     0.44676317935602293139001401686624560874},
    {-0.7837939636638595452733170155322079536,
     -0.1081030181680702273633414922338960232,
     0.44676317935602293139001401686624560874},
    {-0.1081030181680702273633414922338960232,
     -0.1081030181680702273633414922338960232,
     0.44676317935602293139001401686624560874},
    {-0.81684757298045851308085707319559698429,
     0.63369514596091702616171414639119396858,
     0.21990348731064373527665264980042105793},
    {0.63369514596091702616171414639119396858,
     -0.81684757298045851308085707319559698429,
     0.21990348731064373527665264980042105793},
    {-0.81684757298045851308085707319559698429,
     -0.81684757298045851308085707319559698429,
     0.21990348731064373527665264980042105793},
    // 5 7 %%% Order / Number of Points
    {-0.33333333333333333333333333333333333333,
     -0.33333333333333333333333333333333333333, 0.45},
    {-0.79742698535308732239802527616975234389,
     0.59485397070617464479605055233950468778,
     0.25187836108965430519136789100036266732},
    {0.59485397070617464479605055233950468778,
     -0.79742698535308732239802527616975234389,
     0.25187836108965430519136789100036266732},
    {-0.79742698535308732239802527616975234389,
     -0.79742698535308732239802527616975234389,
     0.25187836108965430519136789100036266732},
    {-0.059715871789769820459117580973104798968,
     -0.88056825642046035908176483805379040206,
     0.26478830557701236147529877566630399935},
    {-0.88056825642046035908176483805379040206,
     -0.059715871789769820459117580973104798968,
     0.26478830557701236147529877566630399935},
    {-0.059715871789769820459117580973104798968,
     -0.059715871789769820459117580973104798968,
     0.26478830557701236147529877566630399935},
    // 6 13 %%% Order / Number of Points
    {-0.3333333333333333, -0.3333333333333333, 0.4153725894804773},
    {-1, 1, 0.01668544312227965},
    {1, -1, 0.01668544312227965},
    {-1, -1, 0.01668544312227965},
    {-0.07249846092703716, -0.8550030781459257, 0.1914152449999351},
    {-0.8550030781459257, -0.07249846092703716, 0.1914152449999351},
    {-0.07249846092703716, -0.07249846092703716, 0.1914152449999351},
    {0.4693907615361228, -0.8739333400138243, 0.1600542243588131},
    {-0.8739333400138243, 0.4693907615361228, 0.1600542243588131},
    {-0.5954574215222985, -0.8739333400138243, 0.1600542243588131},
    {-0.8739333400138243, -0.5954574215222985, 0.1600542243588131},
    {-0.5954574215222985, 0.4693907615361228, 0.1600542243588131},
    {0.4693907615361228, -0.5954574215222985, 0.1600542243588131},
    // 7 16 %%% Order / Number of Points
    {-0.3333333333333333, -0.3333333333333333, 0.02890517766969565},
    {-0.05159753420403723, -0.8968049315919255, 0.1692311578402325},
    {-0.8968049315919255, -0.05159753420403723, 0.1692311578402325},
    {-0.05159753420403723, -0.05159753420403723, 0.1692311578402325},
    {-0.52840910025121, 0.05681820050242004, 0.2565587963589694},
    {0.05681820050242004, -0.52840910025121, 0.2565587963589694},
    {-0.52840910025121, -0.52840910025121, 0.2565587963589694},
    {-1, 1, 0.01018650230579353},
    {1, -1, 0.01018650230579353},
    {-1, -1, 0.01018650230579353},
    {-0.9167345590281095, 0.569735685302827, 0.1105275754692198},
    {0.569735685302827, -0.9167345590281095, 0.1105275754692198},
    {-0.6530011262747175, 0.569735685302827, 0.1105275754692198},
    {0.569735685302827, -0.6530011262747175, 0.1105275754692198},
    {-0.6530011262747175, -0.9167345590281096, 0.1105275754692198},
    {-0.9167345590281096, -0.6530011262747175, 0.1105275754692198},
    // 8 18 %%% Order / Number of Points
    {-0.5228225045348536, 0.0456450090697072, 0.2646287570910316},
    {0.0456450090697072, -0.5228225045348536, 0.2646287570910316},
    {-0.5228225045348536, -0.5228225045348536, 0.2646287570910316},
    {-0.865016154723089, 0.730032309446178, 0.05974557205954301},
    {0.730032309446178, -0.865016154723089, 0.05974557205954301},
    {-0.865016154723089, -0.865016154723089, 0.05974557205954301},
    {-0.05332197913465642, -0.8933560417306872, 0.1492582098166287},
    {-0.8933560417306872, -0.05332197913465642, 0.1492582098166287},
    {-0.05332197913465642, -0.05332197913465642, 0.1492582098166287},
    {-1, 1, 0.006236363791150692},
    {1, -1, 0.006236363791150692},
    {-1, -1, 0.006236363791150692},
    {-0.5656703440391746, 0.4848664878635023, 0.09339888195415628},
    {0.4848664878635023, -0.5656703440391746, 0.09339888195415628},
    {-0.9191961438243277, 0.4848664878635023, 0.09339888195415628},
    {0.4848664878635023, -0.9191961438243277, 0.09339888195415628},
    {-0.9191961438243277, -0.5656703440391746, 0.09339888195415628},
    {-0.5656703440391746, -0.9191961438243277, 0.09339888195415628},
    // 9 22 %%% Order / Number of Points
    {-0.3333333333333333, -0.3333333333333333, 0.2125563146250694},
    {-0.1128567802029919, -0.7742864395940161, 0.1608078833870916},
    {-0.7742864395940161, -0.1128567802029919, 0.1608078833870916},
    {-0.1128567802029919, -0.1128567802029919, 0.1608078833870916},
    {-0.6200530872876424, 0.2401061745752848, 0.1619222257331837},
    {0.2401061745752848, -0.6200530872876424, 0.1619222257331837},
    {-0.6200530872876424, -0.6200530872876424, 0.1619222257331837},
    {-1, 1, 0.000350388943572419},
    {1, -1, 0.000350388943572419},
    {-1, -1, 0.000350388943572419},
    {-0.01239829029425277, -0.9752034194114945, 0.04798535534603363},
    {-0.9752034194114945, -0.01239829029425277, 0.04798535534603363},
    {-0.01239829029425277, -0.01239829029425277, 0.04798535534603363},
    {-0.9083876895065616, 0.8167753790131231, 0.05161455087260469},
    {0.8167753790131231, -0.9083876895065616, 0.05161455087260469},
    {-0.9083876895065616, -0.9083876895065616, 0.05161455087260469},
    {-0.9263231758905274, 0.482397197568996, 0.08656707875457882},
    {0.482397197568996, -0.9263231758905274, 0.08656707875457882},
    {-0.5560740216784685, 0.4823971975689959, 0.08656707875457882},
    {0.4823971975689959, -0.5560740216784685, 0.08656707875457882},
    {-0.5560740216784685, -0.9263231758905274, 0.08656707875457882},
    {-0.9263231758905274, -0.5560740216784685, 0.08656707875457882},
    // 10 25 %%% Order / Number of Points
    {-0.3333333333333333, -0.3333333333333333, 0.1463412629389919},
    {-0.1517578857149908, -0.6964842285700183, 0.1596259407516009},
    {-0.6964842285700183, -0.1517578857149908, 0.1596259407516009},
    {-0.1517578857149908, -0.1517578857149908, 0.1596259407516009},
    {-1, 1, 0.004142056403083998},
    {1, -1, 0.004142056403083998},
    {-1, -1, 0.004142056403083998},
    {-0.6385578178947611, 0.2771156357895221, 0.1561253967816473},
    {0.2771156357895221, -0.6385578178947611, 0.1561253967816473},
    {-0.6385578178947611, -0.6385578178947611, 0.1561253967816473},
    {-0.02473842217280176, -0.9505231556543965, 0.04820131094351466},
    {-0.9505231556543965, -0.02473842217280176, 0.04820131094351466},
    {-0.02473842217280176, -0.02473842217280176, 0.04820131094351466},
    {-0.7790015033862367, 0.7167148116753153, 0.04960894888480484},
    {0.7167148116753153, -0.7790015033862367, 0.04960894888480484},
    {-0.9377133082890785, 0.7167148116753153, 0.04960894888480484},
    {0.7167148116753153, -0.9377133082890785, 0.04960894888480484},
    {-0.9377133082890785, -0.7790015033862367, 0.04960894888480484},
    {-0.7790015033862367, -0.9377133082890785, 0.04960894888480484},
    {-0.4144607978125549, 0.3389482548091939, 0.0752868215187729},
    {0.3389482548091939, -0.4144607978125549, 0.0752868215187729},
    {-0.924487456996639, 0.3389482548091939, 0.0752868215187729},
    {0.3389482548091939, -0.924487456996639, 0.0752868215187729},
    {-0.924487456996639, -0.4144607978125548, 0.0752868215187729},
    {-0.4144607978125548, -0.924487456996639, 0.0752868215187729}};

} // namespace Nektar::LibUtilities

#endif
