" Vim syntax file
" Language: PLUMED

if exists("b:current_syntax")
  finish
endif

syntax case ignore

let b:current_syntax="plumed"

if exists("g:plumed_shortcuts")
  noremap  <buffer> <F2> :PHelp<CR>
  inoremap <buffer> <F2> <Esc>:PHelp<CR>
endif

" path for plumed plugin
let s:path=expand('<sfile>:p:h:h')

" All except space and hash are in word
setlocal iskeyword=33,34,36-126

" Matching dots, possibly followed by a comment
" Only dots are part of the match
syntax match plumedDots /\v\.\.\.(\s*(#.*)*$)@=/ contained
highlight link plumedDots Type

let b:plumedActions=[]
let b:plumedDictionary={}

let b:plumedDictionary["ABMD"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MIN=","menu":"(option)"},{"word":"NOISE=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SEED=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TO=","menu":"(option)"}]
let b:plumedDictionary["ADAPTIVE_PATH"]=[{"word":"DISABLE_CHECKS","menu":"(flag)"},{"word":"FIXED=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"HALFLIFE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TOLERANCE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"UPDATE=","menu":"(option)"},{"word":"WFILE=","menu":"(option)"},{"word":"WSTRIDE=","menu":"(option)"}]
let b:plumedDictionary["ALPHABETA"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"COEFFICIENT","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE","menu":"(numbered)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ALPHARMSD"]=[{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"RESIDUES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"VERBOSE","menu":"(flag)"}]
let b:plumedDictionary["ANGLE"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["ANGLES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"GROUPC=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"SWITCHA=","menu":"(option)"},{"word":"SWITCHB=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ANTIBETARMSD"]=[{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"RESIDUES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRANDS_CUTOFF=","menu":"(option)"},{"word":"STYLE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"VERBOSE","menu":"(flag)"}]
let b:plumedDictionary["AROUND"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOM=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA=","menu":"(option)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"XLOWER=","menu":"(option)"},{"word":"XUPPER=","menu":"(option)"},{"word":"YLOWER=","menu":"(option)"},{"word":"YUPPER=","menu":"(option)"},{"word":"ZLOWER=","menu":"(option)"},{"word":"ZUPPER=","menu":"(option)"}]
let b:plumedDictionary["AVERAGE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"CLEAR=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["BIASVALUE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["BRIDGE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"BRIDGING_ATOMS=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"SWITCHA=","menu":"(option)"},{"word":"SWITCHB=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["CALIBER"]=[{"word":"ARG","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"SCALE=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TSCALE=","menu":"(option)"}]
let b:plumedDictionary["CAVITY"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"PRINT_BOX","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA=","menu":"(option)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"}]
let b:plumedDictionary["CELL"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["CENTER"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MASS","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"PHASES","menu":"(flag)"},{"word":"SET_CHARGE=","menu":"(option)"},{"word":"SET_MASS=","menu":"(option)"},{"word":"WEIGHTS=","menu":"(option)"}]
let b:plumedDictionary["CENTER_OF_MULTICOLVAR"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["COLLECT_FRAMES"]=[{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS=","menu":"(option)"},{"word":"CLEAR=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS=","menu":"(option)"}]
let b:plumedDictionary["COM"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MASS","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"PHASES","menu":"(flag)"},{"word":"SET_CHARGE=","menu":"(option)"},{"word":"SET_MASS=","menu":"(option)"},{"word":"WEIGHTS=","menu":"(option)"}]
let b:plumedDictionary["COMBINE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"COEFFICIENTS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NORMALIZE","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PARAMETERS=","menu":"(option)"},{"word":"PERIODIC=","menu":"(option)"},{"word":"POWERS=","menu":"(option)"}]
let b:plumedDictionary["COMMITTOR"]=[{"word":"ARG","menu":"(numbered)"},{"word":"BASIN_LL","menu":"(numbered)"},{"word":"BASIN_UL","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOSTOP","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["CONSTANT"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NODERIV","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"VALUE=","menu":"(option)"},{"word":"VALUES=","menu":"(option)"}]
let b:plumedDictionary["CONTACTMAP"]=[{"word":"ATOMS","menu":"(numbered)"},{"word":"CMDIST","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE","menu":"(numbered)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SUM","menu":"(flag)"},{"word":"SWITCH","menu":"(numbered)"},{"word":"WEIGHT","menu":"(numbered)"}]
let b:plumedDictionary["CONVERT_TO_FES"]=[{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MINTOZERO","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TEMP=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["COORDINATION"]=[{"word":"D_0=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MM=","menu":"(option)"},{"word":"NL_CUTOFF=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NLIST","menu":"(flag)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PAIR","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"}]
let b:plumedDictionary["COORDINATIONNUMBER"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"R_POWER=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SPECIES=","menu":"(option)"},{"word":"SPECIESA=","menu":"(option)"},{"word":"SPECIESB=","menu":"(option)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["CS2BACKBONE"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS=","menu":"(option)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"CAMSHIFT","menu":"(flag)"},{"word":"DATADIR=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NEIGH_FREQ=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOEXP","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TEMPLATE=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["CUSTOM"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FUNC=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PERIODIC=","menu":"(option)"},{"word":"VAR=","menu":"(option)"}]
let b:plumedDictionary["DEBUG"]=[{"word":"DETAILED_TIMERS","menu":"(flag)"},{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"logActivity","menu":"(flag)"},{"word":"logRequestedAtoms","menu":"(flag)"},{"word":"NOVIRIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["DENSITY"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SPECIES=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["DHENERGY"]=[{"word":"EPSILON=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"I=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NL_CUTOFF=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NLIST","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PAIR","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["DIHCOR"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["DIMER"]=[{"word":"ALLATOMS","menu":"(flag)"},{"word":"ATOMS1=","menu":"(option)"},{"word":"ATOMS2=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NOVSITES","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"Q=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["DIPOLE"]=[{"word":"COMPONENTS","menu":"(flag)"},{"word":"GROUP=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["DISTANCE"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"COMPONENTS","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SCALED_COMPONENTS","menu":"(flag)"}]
let b:plumedDictionary["DISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["DISTANCE_FROM_CONTOUR"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOM=","menu":"(option)"},{"word":"BANDWIDTH=","menu":"(option)"},{"word":"CONTOUR=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"DIR=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TOLERANCE=","menu":"(option)"}]
let b:plumedDictionary["DRMSD"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWER_CUTOFF=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"UPPER_CUTOFF=","menu":"(option)"}]
let b:plumedDictionary["DUMPATOMS"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"PRECISION=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["DUMPCUBE"]=[{"word":"COMPONENT=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"REPLICA=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["DUMPDERIVATIVES"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["DUMPFORCES"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["DUMPGRID"]=[{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"REPLICA=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["DUMPMASSCHARGE"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"ONLY_CHARGES","menu":"(flag)"},{"word":"ONLY_MASSES","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["DUMPMULTICOLVAR"]=[{"word":"DATA=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"ORIGIN=","menu":"(option)"},{"word":"PRECISION=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"}]
let b:plumedDictionary["DUMPPROJECTIONS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["EEFSOLV"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NL_BUFFER=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TEMP_CORRECTION","menu":"(flag)"}]
let b:plumedDictionary["EFFECTIVE_ENERGY_DRIFT"]=[{"word":"ENSEMBLE","menu":"(flag)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"PRINT_STRIDE=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["EMMI"]=[{"word":"ANNEAL_FACT=","menu":"(option)"},{"word":"ANNEAL=","menu":"(option)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS=","menu":"(option)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"ERR_FILE=","menu":"(option)"},{"word":"GMM_FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MC_STRIDE=","menu":"(option)"},{"word":"NL_CUTOFF=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NO_AVER","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NORM_DENSITY=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OV_FILE=","menu":"(option)"},{"word":"PRIOR=","menu":"(option)"},{"word":"REG_DSCALE=","menu":"(option)"},{"word":"REG_SCALE_MAX=","menu":"(option)"},{"word":"REG_SCALE_MIN=","menu":"(option)"},{"word":"REGRESSION=","menu":"(option)"},{"word":"RESOLUTION=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_OV_STRIDE=","menu":"(option)"},{"word":"WRITE_OV=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["ENDPLUMED"]=[{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["ENERGY"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["ENSEMBLE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"CENTRAL","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MOMENT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"POWER=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["ERMSD"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"CUTOFF=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PAIRS=","menu":"(option)"},{"word":"REFERENCE=","menu":"(option)"}]
let b:plumedDictionary["EUCLIDEAN_DISSIMILARITIES"]=[{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"METRIC=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["EXTENDED_LAGRANGIAN"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FRICTION=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TAU=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["EXTERNAL"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOSPLINE","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SCALE=","menu":"(option)"},{"word":"SPARSE","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["EXTRACV"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NAME=","menu":"(option)"}]
let b:plumedDictionary["FAKE"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"COMPONENTS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PERIODIC=","menu":"(option)"}]
let b:plumedDictionary["FIND_CONTOUR"]=[{"word":"BUFFER=","menu":"(option)"},{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"CONTOUR=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"PRECISION=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"}]
let b:plumedDictionary["FIND_CONTOUR_SURFACE"]=[{"word":"BUFFER=","menu":"(option)"},{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"CONTOUR=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"SEARCHDIR=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["FIND_SPHERICAL_CONTOUR"]=[{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"CONTOUR=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"INNER_RADIUS=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NBINS=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"NPOINTS=","menu":"(option)"},{"word":"OUTER_RADIUS=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["FIT_TO_TEMPLATE"]=[{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["FIXEDATOM"]=[{"word":"AT=","menu":"(option)"},{"word":"ATOMS=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"SCALED_COMPONENTS","menu":"(flag)"},{"word":"SET_CHARGE=","menu":"(option)"},{"word":"SET_MASS=","menu":"(option)"}]
let b:plumedDictionary["FLUSH"]=[{"word":"LABEL=","menu":"(label)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["FOURIER_TRANSFORM"]=[{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"FOURIER_PARAMETERS=","menu":"(option)"},{"word":"FT_TYPE=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["FRET"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R0=","menu":"(option)"}]
let b:plumedDictionary["FUNCPATHGENERAL"]=[{"word":"ARG","menu":"(numbered)"},{"word":"COEFFICIENTS=","menu":"(option)"},{"word":"COLUMNS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"NEIGH_SIZE=","menu":"(option)"},{"word":"NEIGH_STRIDE=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"}]
let b:plumedDictionary["FUNCPATHMSD"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"NEIGH_SIZE=","menu":"(option)"},{"word":"NEIGH_STRIDE=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["FUNCSUMHILLS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FMT=","menu":"(option)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_MAX=","menu":"(option)"},{"word":"GRID_MIN=","menu":"(option)"},{"word":"GRID_SPACING=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HILLSFILES=","menu":"(option)"},{"word":"HISTOFILES=","menu":"(option)"},{"word":"HISTOSIGMA=","menu":"(option)"},{"word":"INITSTRIDE=","menu":"(option)"},{"word":"INTERVAL=","menu":"(option)"},{"word":"ISCLTOOL","menu":"(flag)"},{"word":"KT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MINTOZERO","menu":"(flag)"},{"word":"NEGBIAS","menu":"(flag)"},{"word":"NOHISTORY","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTHILLS=","menu":"(option)"},{"word":"OUTHISTO=","menu":"(option)"},{"word":"PARALLELREAD","menu":"(flag)"},{"word":"PROJ=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["GHBFIX"]=[{"word":"C=","menu":"(option)"},{"word":"D_0=","menu":"(option)"},{"word":"D_MAX=","menu":"(option)"},{"word":"ENERGY_UNITS=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NL_CUTOFF=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NLIST","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PAIR","menu":"(flag)"},{"word":"PARAMS=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TYPES=","menu":"(option)"}]
let b:plumedDictionary["GHOST"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"COORDINATES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["GPROPERTYMAP"]=[{"word":"DISABLE_CHECKS","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NOMAPPING","menu":"(flag)"},{"word":"NOZPATH","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PROPERTY=","menu":"(option)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["GRID_TO_XYZ"]=[{"word":"COMPONENT=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"PRECISION=","menu":"(option)"},{"word":"REPLICA=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"}]
let b:plumedDictionary["GROUP"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NDX_FILE=","menu":"(option)"},{"word":"NDX_GROUP=","menu":"(option)"},{"word":"REMOVE=","menu":"(option)"},{"word":"SORT","menu":"(flag)"},{"word":"UNIQUE","menu":"(flag)"}]
let b:plumedDictionary["GYRATION"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MASS_WEIGHTED","menu":"(flag)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["HISTOGRAM"]=[{"word":"ARG","menu":"(numbered)"},{"word":"BANDWIDTH=","menu":"(option)"},{"word":"CLEAR=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_MAX=","menu":"(option)"},{"word":"GRID_MIN=","menu":"(option)"},{"word":"GRID_SPACING=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"},{"word":"VECTORS=","menu":"(option)"}]
let b:plumedDictionary["INCLUDE"]=[{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["INCYLINDER"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOM=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"DIRECTION=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWER=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"RADIUS=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA=","menu":"(option)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UPPER=","menu":"(option)"}]
let b:plumedDictionary["INENVELOPE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS=","menu":"(option)"},{"word":"BANDWIDTH=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"CONTOUR=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["INPLANEDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"VECTOREND=","menu":"(option)"},{"word":"VECTORSTART=","menu":"(option)"}]
let b:plumedDictionary["INSPHERE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOM=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"RADIUS=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["INTEGRATE_GRID"]=[{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["INTERPOLATE_GRID"]=[{"word":"CLEAR=","menu":"(option)"},{"word":"COMPONENT=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_SPACING=","menu":"(option)"},{"word":"GRID=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["JCOUPLING"]=[{"word":"A=","menu":"(option)"},{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"B=","menu":"(option)"},{"word":"C=","menu":"(option)"},{"word":"COUPLING","menu":"(numbered)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SHIFT=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["LANDMARK_SELECT_FPS"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_WEIGHTS","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NLANDMARKS=","menu":"(option)"},{"word":"NOVORONOI","menu":"(flag)"},{"word":"SEED=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["LANDMARK_SELECT_RANDOM"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_WEIGHTS","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NLANDMARKS=","menu":"(option)"},{"word":"NOVORONOI","menu":"(flag)"},{"word":"SEED=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["LANDMARK_SELECT_STAGED"]=[{"word":"GAMMA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_WEIGHTS","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NLANDMARKS=","menu":"(option)"},{"word":"NOVORONOI","menu":"(flag)"},{"word":"SEED=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["LANDMARK_SELECT_STRIDE"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_WEIGHTS","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NLANDMARKS=","menu":"(option)"},{"word":"NOVORONOI","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["LOAD"]=[{"word":"FILE=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"}]
let b:plumedDictionary["LOCALENSEMBLE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUM=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["LOCAL_AVERAGE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SPECIES=","menu":"(option)"},{"word":"SPECIESA=","menu":"(option)"},{"word":"SPECIESB=","menu":"(option)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["LOWER_WALLS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"AT=","menu":"(option)"},{"word":"EPS=","menu":"(option)"},{"word":"EXP=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["MATHEVAL"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FUNC=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PERIODIC=","menu":"(option)"},{"word":"VAR=","menu":"(option)"}]
let b:plumedDictionary["MAXENT"]=[{"word":"ALPHA=","menu":"(option)"},{"word":"APPLY_WEIGHTS=","menu":"(option)"},{"word":"ARG","menu":"(numbered)"},{"word":"AT=","menu":"(option)"},{"word":"ERROR_TYPE=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LEARN_REPLICA=","menu":"(option)"},{"word":"NO_BROADCAST","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PACE=","menu":"(option)"},{"word":"PRINT_STRIDE=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SIGMA=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TAU=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TEND=","menu":"(option)"},{"word":"TSTART=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["MCOLV_COMBINE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"COEFFICIENTS=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["MCOLV_PRODUCT"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["METAD"]=[{"word":"ACCELERATION_RFILE=","menu":"(option)"},{"word":"ACCELERATION","menu":"(flag)"},{"word":"ADAPTIVE=","menu":"(option)"},{"word":"ARG","menu":"(numbered)"},{"word":"BIASFACTOR=","menu":"(option)"},{"word":"CALC_MAX_BIAS","menu":"(flag)"},{"word":"CALC_RCT","menu":"(flag)"},{"word":"CALC_TRANSITION_BIAS","menu":"(flag)"},{"word":"CALC_WORK","menu":"(flag)"},{"word":"DAMPFACTOR=","menu":"(option)"},{"word":"FA_MAX_PACE=","menu":"(option)"},{"word":"FA_MIN_ACCELERATION=","menu":"(option)"},{"word":"FA_UPDATE_FREQUENCY=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"FLYING_GAUSSIAN","menu":"(flag)"},{"word":"FMT=","menu":"(option)"},{"word":"FREQUENCY_ADAPTIVE","menu":"(flag)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_MAX=","menu":"(option)"},{"word":"GRID_MIN=","menu":"(option)"},{"word":"GRID_NOSPLINE","menu":"(flag)"},{"word":"GRID_RFILE=","menu":"(option)"},{"word":"GRID_SPACING=","menu":"(option)"},{"word":"GRID_SPARSE","menu":"(flag)"},{"word":"GRID_WFILE=","menu":"(option)"},{"word":"GRID_WSTRIDE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HEIGHT=","menu":"(option)"},{"word":"INTERVAL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NLIST_PARAMETERS=","menu":"(option)"},{"word":"NLIST","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PACE=","menu":"(option)"},{"word":"RCT_USTRIDE=","menu":"(option)"},{"word":"RECT=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA=","menu":"(option)"},{"word":"STORE_GRIDS","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TARGET=","menu":"(option)"},{"word":"TAU=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TRANSITIONWELL","menu":"(numbered)"},{"word":"TTALPHA=","menu":"(option)"},{"word":"TTBIASFACTOR=","menu":"(option)"},{"word":"TTBIASTHRESHOLD=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"},{"word":"WALKERS_DIR=","menu":"(option)"},{"word":"WALKERS_ID=","menu":"(option)"},{"word":"WALKERS_MPI","menu":"(flag)"},{"word":"WALKERS_N=","menu":"(option)"},{"word":"WALKERS_RSTRIDE=","menu":"(option)"}]
let b:plumedDictionary["METAINFERENCE"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"PARAMETERS=","menu":"(option)"},{"word":"PARARG=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["MFILTER_BETWEEN"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BEAD=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWER=","menu":"(option)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SMEAR=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UPPER=","menu":"(option)"}]
let b:plumedDictionary["MFILTER_LESS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["MFILTER_MORE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["MOLINFO"]=[{"word":"CHAIN=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MOLTYPE=","menu":"(option)"},{"word":"PYTHON_BIN=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"STRUCTURE=","menu":"(option)"},{"word":"WHOLE","menu":"(flag)"}]
let b:plumedDictionary["MOVINGRESTRAINT"]=[{"word":"ARG","menu":"(numbered)"},{"word":"AT","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"STEP","menu":"(numbered)"},{"word":"STRIDE=","menu":"(option)"},{"word":"VERSE=","menu":"(option)"}]
let b:plumedDictionary["MTRANSFORM_BETWEEN"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"BEAD=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWER=","menu":"(option)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SMEAR=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UPPER=","menu":"(option)"}]
let b:plumedDictionary["MTRANSFORM_LESS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["MTRANSFORM_MORE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["MULTICOLVARDENS"]=[{"word":"BANDWIDTH=","menu":"(option)"},{"word":"CLEAR=","menu":"(option)"},{"word":"CONCENTRATION=","menu":"(option)"},{"word":"DATA=","menu":"(option)"},{"word":"DIR=","menu":"(option)"},{"word":"FRACTIONAL","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOGWEIGHTS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NBINS=","menu":"(option)"},{"word":"NORMALIZATION=","menu":"(option)"},{"word":"ORIGIN=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SPACING=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"XLOWER=","menu":"(option)"},{"word":"XREDUCED","menu":"(flag)"},{"word":"XUPPER=","menu":"(option)"},{"word":"YLOWER=","menu":"(option)"},{"word":"YREDUCED","menu":"(flag)"},{"word":"YUPPER=","menu":"(option)"},{"word":"ZLOWER=","menu":"(option)"},{"word":"ZREDUCED","menu":"(flag)"},{"word":"ZUPPER=","menu":"(option)"}]
let b:plumedDictionary["MULTI_RMSD"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"SQUARED","menu":"(flag)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["NLINKS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"D_0=","menu":"(option)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MM=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["NOE"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"GROUPA","menu":"(numbered)"},{"word":"GROUPB","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOEDIST","menu":"(numbered)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["OUTPUT_ANALYSIS_DATA_TO_COLVAR"]=[{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"REPLICA=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["OUTPUT_ANALYSIS_DATA_TO_PDB"]=[{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["PARABETARMSD"]=[{"word":"ALT_MIN","menu":"(numbered)"},{"word":"D_0=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MIN","menu":"(numbered)"},{"word":"MM=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NN=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"R_0=","menu":"(option)"},{"word":"RESIDUES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRANDS_CUTOFF=","menu":"(option)"},{"word":"STYLE=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"},{"word":"VERBOSE","menu":"(flag)"}]
let b:plumedDictionary["PATH"]=[{"word":"DISABLE_CHECKS","menu":"(flag)"},{"word":"GPATH","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NOSPATH","menu":"(flag)"},{"word":"NOZPATH","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["PATHMSD"]=[{"word":"DEBUG_CLOSE=","menu":"(option)"},{"word":"EPSILON=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"LOG_CLOSE=","menu":"(option)"},{"word":"NEIGH_SIZE=","menu":"(option)"},{"word":"NEIGH_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"}]
let b:plumedDictionary["PBMETAD"]=[{"word":"ADAPTIVE=","menu":"(option)"},{"word":"ARG","menu":"(numbered)"},{"word":"BIASFACTOR=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_MAX=","menu":"(option)"},{"word":"GRID_MIN=","menu":"(option)"},{"word":"GRID_NOSPLINE","menu":"(flag)"},{"word":"GRID_RFILES=","menu":"(option)"},{"word":"GRID_SPACING=","menu":"(option)"},{"word":"GRID_SPARSE","menu":"(flag)"},{"word":"GRID_WFILES=","menu":"(option)"},{"word":"GRID_WSTRIDE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HEIGHT=","menu":"(option)"},{"word":"INTERVAL_MAX=","menu":"(option)"},{"word":"INTERVAL_MIN=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PACE=","menu":"(option)"},{"word":"PF","menu":"(numbered)"},{"word":"RESTART=","menu":"(option)"},{"word":"SELECTOR_ID=","menu":"(option)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TAU=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"},{"word":"WALKERS_DIR=","menu":"(option)"},{"word":"WALKERS_ID=","menu":"(option)"},{"word":"WALKERS_MPI","menu":"(flag)"},{"word":"WALKERS_N=","menu":"(option)"},{"word":"WALKERS_RSTRIDE=","menu":"(option)"}]
let b:plumedDictionary["PCARMSD"]=[{"word":"AVERAGE=","menu":"(option)"},{"word":"EIGENVECTORS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SQUARED_ROOT","menu":"(flag)"}]
let b:plumedDictionary["PCAVARS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["PCS"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"COUPLING","menu":"(numbered)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"GYROM=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"SVD","menu":"(flag)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["PIECEWISE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"POINT","menu":"(numbered)"}]
let b:plumedDictionary["PLUMED"]=[{"word":"CHDIR=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOG=","menu":"(option)"},{"word":"NOREPLICAS","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["POSITION"]=[{"word":"ATOM=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SCALED_COMPONENTS","menu":"(flag)"}]
let b:plumedDictionary["PRE"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"GROUPA","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"INEPT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NORATIO","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OMEGA=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"PREINT","menu":"(numbered)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"RTWO","menu":"(numbered)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"SPINLABEL=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TAUC=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["PRINT"]=[{"word":"_ROTATE=","menu":"(option)"},{"word":"ARG","menu":"(numbered)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"RESTART=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"}]
let b:plumedDictionary["PRINT_DISSIMILARITY_MATRIX"]=[{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["PROJECTION_ON_AXIS"]=[{"word":"ATOM=","menu":"(option)"},{"word":"AXIS_ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["PROPERTYMAP"]=[{"word":"DEBUG_CLOSE=","menu":"(option)"},{"word":"EPSILON=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LAMBDA=","menu":"(option)"},{"word":"LOG_CLOSE=","menu":"(option)"},{"word":"NEIGH_SIZE=","menu":"(option)"},{"word":"NEIGH_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PROPERTY=","menu":"(option)"},{"word":"REFERENCE=","menu":"(option)"}]
let b:plumedDictionary["PUCKERING"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["RANDOM_EXCHANGES"]=[{"word":"LABEL=","menu":"(label)"},{"word":"SEED=","menu":"(option)"}]
let b:plumedDictionary["RDC"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"COUPLING","menu":"(numbered)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"GYROM=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"SVD","menu":"(flag)"},{"word":"TEMP=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["READ"]=[{"word":"EVERY=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_FORCES","menu":"(flag)"},{"word":"IGNORE_TIME","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"STRIDE=","menu":"(option)"},{"word":"UPDATE_FROM=","menu":"(option)"},{"word":"UPDATE_UNTIL=","menu":"(option)"},{"word":"VALUES=","menu":"(option)"}]
let b:plumedDictionary["READ_DISSIMILARITY_MATRIX"]=[{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"},{"word":"WFILE=","menu":"(option)"}]
let b:plumedDictionary["RESCALE"]=[{"word":"ARG","menu":"(numbered)"},{"word":"BFILE=","menu":"(option)"},{"word":"BIASFACTOR=","menu":"(option)"},{"word":"BSTRIDE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MAX_RESCALE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"MC_STRIDE=","menu":"(option)"},{"word":"NBIN=","menu":"(option)"},{"word":"NOT_RESCALED=","menu":"(option)"},{"word":"NOT_SHARED=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PACE=","menu":"(option)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"W0=","menu":"(option)"}]
let b:plumedDictionary["RESELECT_LANDMARKS"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"IGNORE_WEIGHTS","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LANDMARKS=","menu":"(option)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NOVORONOI","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS=","menu":"(option)"},{"word":"USE_OUTPUT_DATA_FROM=","menu":"(option)"}]
let b:plumedDictionary["RESET_CELL"]=[{"word":"LABEL=","menu":"(label)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["RESTART"]=[{"word":"LABEL=","menu":"(label)"},{"word":"NO","menu":"(flag)"}]
let b:plumedDictionary["RESTRAINT"]=[{"word":"ARG","menu":"(numbered)"},{"word":"AT=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SLOPE=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["REWEIGHT_BIAS"]=[{"word":"ARG=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["REWEIGHT_METAD"]=[{"word":"ARG=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["REWEIGHT_TEMP_PRESS"]=[{"word":"ENERGY=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"PRESSURE=","menu":"(option)"},{"word":"REWEIGHT_PRESSURE=","menu":"(option)"},{"word":"REWEIGHT_TEMP=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"VOLUME=","menu":"(option)"}]
let b:plumedDictionary["REWEIGHT_WHAM"]=[{"word":"ARG=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"MAXITER=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"WHAMTOL=","menu":"(option)"}]
let b:plumedDictionary["RMSD"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"SQUARED","menu":"(flag)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["SANS"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMISTIC","menu":"(flag)"},{"word":"ATOMS=","menu":"(option)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DEUTER_CONC=","menu":"(option)"},{"word":"DEVICEID=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"EXPINT","menu":"(numbered)"},{"word":"GPU","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MARTINI","menu":"(flag)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"ONEBEAD","menu":"(flag)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"PARAMETERS","menu":"(numbered)"},{"word":"QVALUE","menu":"(numbered)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SASA_CUTOFF=","menu":"(option)"},{"word":"SCALE_EXPINT=","menu":"(option)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"SOLVATION_CORRECTION=","menu":"(option)"},{"word":"SOLVATION_STRIDE=","menu":"(option)"},{"word":"SOLVDENS=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TEMPLATE=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["SAXS"]=[{"word":"ADDOFFSET","menu":"(flag)"},{"word":"ARG","menu":"(numbered)"},{"word":"ATOMISTIC","menu":"(flag)"},{"word":"ATOMS=","menu":"(option)"},{"word":"AVERAGING=","menu":"(option)"},{"word":"DEUTER_CONC=","menu":"(option)"},{"word":"DEVICEID=","menu":"(option)"},{"word":"DFTILDE=","menu":"(option)"},{"word":"DOFFSET=","menu":"(option)"},{"word":"DOSCORE","menu":"(flag)"},{"word":"DSCALE=","menu":"(option)"},{"word":"DSIGMA=","menu":"(option)"},{"word":"EXPINT","menu":"(numbered)"},{"word":"GPU","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LIKELIHOOD=","menu":"(option)"},{"word":"MARTINI","menu":"(flag)"},{"word":"MC_CHUNKSIZE=","menu":"(option)"},{"word":"MC_STEPS=","menu":"(option)"},{"word":"NOENSEMBLE","menu":"(flag)"},{"word":"NOISETYPE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NSELECT=","menu":"(option)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET_MAX=","menu":"(option)"},{"word":"OFFSET_MIN=","menu":"(option)"},{"word":"OFFSET_PRIOR=","menu":"(option)"},{"word":"OFFSET0=","menu":"(option)"},{"word":"ONEBEAD","menu":"(flag)"},{"word":"OPTSIGMAMEAN=","menu":"(option)"},{"word":"PARAMETERS","menu":"(numbered)"},{"word":"QVALUE","menu":"(numbered)"},{"word":"REGRES_ZERO=","menu":"(option)"},{"word":"RESTART=","menu":"(option)"},{"word":"REWEIGHT","menu":"(flag)"},{"word":"SASA_CUTOFF=","menu":"(option)"},{"word":"SCALE_EXPINT=","menu":"(option)"},{"word":"SCALE_MAX=","menu":"(option)"},{"word":"SCALE_MIN=","menu":"(option)"},{"word":"SCALE_PRIOR=","menu":"(option)"},{"word":"SCALE0=","menu":"(option)"},{"word":"SCALEDATA","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA_MAX_STEPS=","menu":"(option)"},{"word":"SIGMA_MAX=","menu":"(option)"},{"word":"SIGMA_MEAN0=","menu":"(option)"},{"word":"SIGMA_MIN=","menu":"(option)"},{"word":"SIGMA0=","menu":"(option)"},{"word":"SOLVATION_CORRECTION=","menu":"(option)"},{"word":"SOLVATION_STRIDE=","menu":"(option)"},{"word":"SOLVDENS=","menu":"(option)"},{"word":"STATUS_FILE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"},{"word":"TEMPLATE=","menu":"(option)"},{"word":"WRITE_STRIDE=","menu":"(option)"}]
let b:plumedDictionary["SELECT"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SELECTOR=","menu":"(option)"}]
let b:plumedDictionary["SELECTOR"]=[{"word":"LABEL=","menu":"(label)"},{"word":"NAME=","menu":"(option)"},{"word":"VALUE=","menu":"(option)"}]
let b:plumedDictionary["SORT"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["STATS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"PARAMETERS=","menu":"(option)"},{"word":"PARARG=","menu":"(option)"},{"word":"SQDEV","menu":"(flag)"},{"word":"SQDEVSUM","menu":"(flag)"},{"word":"UPPERDISTS","menu":"(flag)"}]
let b:plumedDictionary["TARGET"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"REFERENCE=","menu":"(option)"},{"word":"TYPE=","menu":"(option)"}]
let b:plumedDictionary["TEMPLATE"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"TEMPLATE_COMPULSORY=","menu":"(option)"},{"word":"TEMPLATE_DEFAULT_OFF_FLAG","menu":"(flag)"},{"word":"TEMPLATE_DEFAULT_ON_FLAG","menu":"(flag)"},{"word":"TEMPLATE_OPTIONAL=","menu":"(option)"}]
let b:plumedDictionary["TETRAHEDRALPORE"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS=","menu":"(option)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"DATA=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"KERNEL=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OUTSIDE","menu":"(flag)"},{"word":"PRINT_BOX","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SIGMA=","menu":"(option)"},{"word":"SUM","menu":"(numbered)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"},{"word":"UNITS=","menu":"(option)"}]
let b:plumedDictionary["TIME"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["TORSION"]=[{"word":"ATOMS=","menu":"(option)"},{"word":"AXIS=","menu":"(option)"},{"word":"COSINE","menu":"(flag)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"VECTOR1=","menu":"(option)"},{"word":"VECTOR2=","menu":"(option)"}]
let b:plumedDictionary["TORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["UNITS"]=[{"word":"CHARGE=","menu":"(option)"},{"word":"ENERGY=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"LENGTH=","menu":"(option)"},{"word":"MASS=","menu":"(option)"},{"word":"NATURAL","menu":"(flag)"},{"word":"TIME=","menu":"(option)"}]
let b:plumedDictionary["UPDATE_IF"]=[{"word":"ARG","menu":"(numbered)"},{"word":"END","menu":"(flag)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN=","menu":"(option)"},{"word":"MORE_THAN=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["UPPER_WALLS"]=[{"word":"ARG","menu":"(numbered)"},{"word":"AT=","menu":"(option)"},{"word":"EPS=","menu":"(option)"},{"word":"EXP=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"KAPPA=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"OFFSET=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["VOLUME"]=[{"word":"HAS_VALUES=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"}]
let b:plumedDictionary["WHAM_HISTOGRAM"]=[{"word":"ARG=","menu":"(option)"},{"word":"BANDWIDTH=","menu":"(option)"},{"word":"BIAS=","menu":"(option)"},{"word":"GRID_BIN=","menu":"(option)"},{"word":"GRID_MAX=","menu":"(option)"},{"word":"GRID_MIN=","menu":"(option)"},{"word":"IS_SHORTCUT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["WHAM_WEIGHTS"]=[{"word":"BIAS=","menu":"(option)"},{"word":"FILE=","menu":"(option)"},{"word":"FMT=","menu":"(option)"},{"word":"IS_SHORTCUT=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"STRIDE=","menu":"(option)"},{"word":"TEMP=","menu":"(option)"}]
let b:plumedDictionary["WHOLEMOLECULES"]=[{"word":"ADDREFERENCE","menu":"(flag)"},{"word":"EMST","menu":"(flag)"},{"word":"ENTITY","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"MOLTYPE=","menu":"(option)"},{"word":"RESIDUES=","menu":"(option)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["WRAPAROUND"]=[{"word":"AROUND=","menu":"(option)"},{"word":"ATOMS=","menu":"(option)"},{"word":"GROUPBY=","menu":"(option)"},{"word":"LABEL=","menu":"(label)"},{"word":"PAIR","menu":"(flag)"},{"word":"STRIDE=","menu":"(option)"}]
let b:plumedDictionary["XANGLES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["XDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["XYDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["XYTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["XZDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["XZTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["YANGLES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["YDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["YXTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["YZDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["YZTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ZANGLES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ZDISTANCES"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LESS_THAN","menu":"(numbered)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"MORE_THAN","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ZXTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
let b:plumedDictionary["ZYTORSIONS"]=[{"word":"ALL_INPUT_SAME_TYPE=","menu":"(option)"},{"word":"ALT_MIN","menu":"(numbered)"},{"word":"ATOMS","menu":"(numbered)"},{"word":"BETWEEN","menu":"(numbered)"},{"word":"GROUP=","menu":"(option)"},{"word":"GROUPA=","menu":"(option)"},{"word":"GROUPB=","menu":"(option)"},{"word":"HAS_VALUES=","menu":"(option)"},{"word":"HIGHEST","menu":"(numbered)"},{"word":"HISTOGRAM","menu":"(numbered)"},{"word":"LABEL=","menu":"(label)"},{"word":"LOWEST","menu":"(numbered)"},{"word":"LOWMEM","menu":"(flag)"},{"word":"MAX","menu":"(numbered)"},{"word":"MAXDERIVATIVES=","menu":"(option)"},{"word":"MEAN","menu":"(numbered)"},{"word":"MIN","menu":"(numbered)"},{"word":"MOMENTS","menu":"(numbered)"},{"word":"NL_STRIDE=","menu":"(option)"},{"word":"NOPBC","menu":"(flag)"},{"word":"NUMERICAL_DERIVATIVES","menu":"(flag)"},{"word":"SERIAL","menu":"(flag)"},{"word":"SWITCH=","menu":"(option)"},{"word":"TIMINGS","menu":"(flag)"},{"word":"TOL=","menu":"(option)"}]
function! PlumedDefineSyntax()

  for key in sort(keys(b:plumedDictionary))
    call add(b:plumedActions,{"word":key})
  endfor

for a in b:plumedActions
  let action=a["word"]
" vim variables cannot contain -
" we convert it to triple ___
  let action_=substitute(action,"-","___","g")

  for b in b:plumedDictionary[action]
    if(b["menu"]=="(numbered)")
      let string='"\v<' . b["word"] . '[0-9]*\=[^{ #]*"'
    elseif(b["menu"]=="(option)")
" this is necessary since word for option is e.g ."RESTART="
      let string='"\v<' . substitute(b["word"],"=","","") . '[0-9]*\=[^{ #]*"'
    elseif(b["menu"]=="(flag)")
      let string='"\v<' . b["word"] . '>"'
    endif
    execute 'syntax match   plumedKeywords' . action_ . ' ' . string . ' contained contains=plumedStringInKeyword,plumedFillTodo'
  endfor

" single line, with explicit LABEL
" matching action at beginning of line, till the end of the line
" can contain all the keywords associated with this action, plus strings, label, and comments
execute 'syntax region plumedLine' . action_ . ' matchgroup=plumedAction' . action_ . ' start=/\v^\s*' . action . '>/ excludenl end=/$/ contains=plumedComment,plumedKeywords' . action_ . ',plumedLabel,plumedStringOneline,plumedFillTodo fold'
" multiple line, with explicit LABEL
" first row might contain extra words before arriving at the dots
" thus continuation dots are matched by plumedDots
" matching action at beginning of line, followed by dots and possibly by a comment
" ends on dots, possibly followed by the same action name and possibly a comment
" comments and initial dots are not part of the match
" can contain all the keywords associated with this action, plus strings, label, and comments
execute 'syntax region plumedCLine' . action_ . ' matchgroup=plumedAction' . action_ . ' start=/\v^\s*' . action . '>(.+\.\.\.\s*(#.*)*$)@=/ end=/\v^\s*\.\.\.(\s+' . action . ')?\s*((#.*)*$)@=/ contains=plumedComment,plumedKeywords' . action_ . ',plumedLabel,plumedString,plumedDots,plumedFillTodo fold'
" single line, with label: syntax
" matching label followed by action
" can contain all the keywords associated with this action, plus strings and comments
" labels are not allwed
execute 'syntax region plumedLLine' . action_ . ' matchgroup=plumedAction' . action_ . ' start=/\v^\s*[^ #@][^ #]*:\s+' . action . '/ excludenl end=/$/ contains=plumedComment,plumedKeywords' . action_ . ',plumedStringOneline,plumedFillTodo fold'
" multiple line, with label: syntax
" first row might contain extra words before arriving at the dots
" thus continuation dots are matched by plumedDots
" matching label, action, dots, and possibly comment
" comments and dots are not part of the match
" ends on dots, possibly followed by the same label and possibly a comment
" comments and initial dots are not part of the match
execute 'syntax region plumedLCLine' . action_ . ' matchgroup=plumedAction' . action_ . ' start=/\v^\s*\z([^ #@][^ #]*\:)\s+' . action . '>(.+\.\.\.\s*(#.*)*$)@=/ end=/\v^\s*\.\.\.(\s+\z1)?\s*((#.*)*$)@=/ contains=plumedComment,plumedKeywords' . action_ . ',plumedString,plumedDots,plumedFillTodo fold'
" this is a hack required to match the ACTION when it is in the second line
execute 'syntax match plumedSpecial' . action_ . ' /\v(\.\.\.\s*(#.*)*\_s*)@<=' . action . '>/ contained'
execute 'highlight link plumedSpecial' . action_ . ' Type'
" multiple line, with label: syntax
" here ACTION is on the second line
" matching label, dots, possibly comments, newline, then action name
" comments, dots, and action are not part of the match
" ends on dots possibly followed by the same label and possibly a comment
execute 'syntax region plumedLCLine' . action_ . ' matchgroup=plumedAction' . action_ . ' start=/\v^\s*\z([^ #@][^ #]*\:)\s+(\.\.\.\s*(#.*)*\_s*' . action . ')@=/ end=/\v^\s*\.\.\.(\s+\z1)?\s*((#.*)*$)@=/ contains=plumedComment,plumedKeywords' . action_ . ',plumedString,plumedSpecial' . action_ . ',plumedDots,plumedFillTodo fold'
execute 'highlight link plumedAction' . action_ . ' Type'
execute 'highlight link plumedKeywords' . action_ . ' Statement'
endfor

" comments and strings last, with highest priority
syntax region  plumedString start=/\v\{/  end=/\v\}/ contained contains=ALL fold
syntax region  plumedStringOneline start=/\v\{/  end=/\v\}/ oneline contained contains=ALL fold
highlight link plumedString String
highlight link plumedStringOneline String
syntax match   plumedStringInKeyword /\v(<[^ #]+\=)@<=[^ #]+/ contained
highlight link plumedStringInKeyword String

" Matching label
syntax match   plumedLabel "\v<LABEL\=[^ #]*" contained contains=plumedLabelWrong,plumedFillTodo
highlight link plumedLabel Type

" Errors
syntax match   plumedLabelWrong "\v<LABEL\=\@[^ #]*" contained
highlight link plumedLabelWrong Error

" Todo
" This is used since the Trieste tutorials to indicate
" parts that should be filled by the user
syntax match   plumedFillTodo "__FILL__"
highlight link plumedFillTodo Todo

syntax region  plumedComment start="\v^\s*ENDPLUMED>" end="\%$" fold
syntax match   plumedComment excludenl "\v#.*$"
highlight link plumedComment Comment
endfunction

call PlumedDefineSyntax()


fun! PlumedGuessRegion()
" this is to find the match
" first, sync syntax
            syn sync fromstart
" find the syntactic attribute of the present region
            let col=col(".")
            let line=line(".")
            let key=""
            let stack=synstack(line,col)
            if(len(stack)>0)
              let key = synIDattr(stack[0], "name")
            endif
            if(key=~"^plumed[LC]*Line.*")
              return substitute(key,"^plumed[LC]*Line","","")
            endif
            return ""
endfunction

fun! PlumedContextManual()
  if(exists("b:plumed_helpfile"))
    quit
    return
  endif
  let m=PlumedGuessRegion()
  if(m=="")
    return
  else
    let name=s:path . "/help/" . m . ".txt"
    if(exists("b:plumed_helpfile_vertical"))
      execute 'rightbelow vsplit | view ' name
    else
      execute 'rightbelow split | view ' name
    endif
    let b:plumed_helpfile=1
" this is to allow closing the window with F2
    if exists("g:plumed_shortcuts")
      noremap  <buffer> <F2> :PHelp<CR>
    endif
  endif
endfunction

fun! PlumedManualV()
  let b:plumed_helpfile_vertical=1
endfunction

fun! PlumedManualH()
  unlet b:plumed_helpfile_vertical
endfunction

command! -nargs=0 PHelp call PlumedContextManual()

" autocomplete function
fun! PlumedComplete(findstart, base)
" this is to find the start of the word to be completed
          if a:findstart
            " locate the start of the word
            let line = getline('.')
            let start = col('.') - 1
            while start > 0 && line[start - 1] =~ '[a-zA-Z\_\=\-\.]'
              let start -= 1
            endwhile
            return start
          else
" this is to find the match
" first, sync syntax
            syn sync fromstart
" find the syntactic attribute of the present region
            let col=col(".")
            let line=line(".")
            let key=""
            if col!=1
              let key = synIDattr(synID(line, col-1, 1), "name")
            else
              let stack=synstack(line,col)
              if(len(stack)>0)
                let key = synIDattr(stack[0], "name")
              endif
            endif
            let comp=[]
" retrieve action name
" normalize ___ to -
            let key1=substitute(substitute(key,"^plumed[LC]*Line","",""),"___","-","g")
            if key ==""
" if outside of any region, complete with list of actions
              let comp=b:plumedActions
            elseif has_key(b:plumedDictionary,key1)
" if inside a region in the form "plumedLineXXX"
" complete with keywords associated to action XXX
              let comp=b:plumedDictionary[key1]
            endif
            " find months matching with "a:base"
            let res = []
            for m in comp
" this is to allow m to be a dictionary
" with a word and a one-liner
              if(type(m)==type({}))
                let n=m["word"]
              else
                let n=m
              endif
              if n =~ '^' . a:base
                if(n!="LABEL=" || key =~ "^plumedLine.*" || key =~ "^plumedCLine.*")
                call add(res, m)
                endif
              endif
" in principle comp could be a heterogeneous list
" so it should be unlet to iterate the loop
              unlet m
            endfor
"           if("..." =~ '^' . a:base && (key=~"^plumedLLine.*" || key=~"^plumedLine.*"))
"             call add(res,{"word":"...","menu":"(start multiline statement)"})
"           endif
"           if("..." =~ '^' . a:base && (key=~"^plumedLCLine.*" || key=~"^plumedCLine.*") && getline('.')=~'^\s*$')
"              call add(res,{"word":"...","menu":"(end multiline statement)"})
"           endif
            if("#" =~ '^' . a:base && key!="plumedComment") 
               call add(res,{"word":"#","menu":"(add comment)"})
            endif
            if("ENDPLUMED" =~ '^' . a:base && key =="")
               call add(res,{"word":"ENDPLUMED","menu":"(end input)"})
            endif
            return res
          endif
        endfun
setlocal omnifunc=PlumedComplete

" inspect the entire file to find lines containing
" non highlighted characters
fun! PlumedAnnotateSyntax()
" buffer where errors are written
  let buffer=[]
  let l=1
" loop over lines
  while l <= line("$")
    let line=getline(l)
    let p=0
" line is assumed right a priori
    let wrong=0
" position the cursor and redraw the screen
    call cursor(l,1)
    redraw! "! is required for some reason
    while p <len(line)
      let stack=synstack(l,p+1)
      if line[p] !~ "[ \t]"
        if(len(stack)==0)
          let wrong=1
        elseif(synIDattr(stack[len(stack)-1],"name")=~"^plumed[LC]*Line.*")
          let wrong=1
        endif
      endif
      let annotation=""
      for s in stack
        let annotation=annotation."+".synIDattr(s,"name")
      endfor
      call add(buffer,printf("ANNOTATION %5d %3d %s %s",l,p,line[p],annotation))
      let p=p+1
    endwhile
    
    if(wrong)
      call add(buffer,"ERROR AT LINE ".l." : ".line)
    endif
    let l=l+1
  endwhile
" dump the buffer on a new window
  new
  for l in buffer
    put=l
  endfor
endfun

