-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
-- Generated on: 2025-11-18 14:33:08
--           by: ../../utils/create_unpackaged.pl
--          for: postgis
--         from: -
--
-- Do not edit manually, your changes will be lost.
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

-- complain if script is sourced in psql
\echo Use "CREATE EXTENSION postgis" to load this file. \quit

-- Register all views.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW geography_columns;
	RAISE NOTICE 'newly registered VIEW geography_columns';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW geography_columns';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW geography_columns does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW geography_columns to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW geometry_columns;
	RAISE NOTICE 'newly registered VIEW geometry_columns';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW geometry_columns';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW geometry_columns does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW geometry_columns to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW raster_columns;
	RAISE NOTICE 'newly registered VIEW raster_columns';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW raster_columns';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW raster_columns does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW raster_columns to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW raster_overviews;
	RAISE NOTICE 'newly registered VIEW raster_overviews';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW raster_overviews';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW raster_overviews does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW raster_overviews to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all tables.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TABLE spatial_ref_sys;
	RAISE NOTICE 'newly registered TABLE spatial_ref_sys';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TABLE spatial_ref_sys';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TABLE spatial_ref_sys does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TABLE spatial_ref_sys to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all aggregates.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Extent (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Extent (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Extent (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Extent (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Extent (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_3DExtent (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_3DExtent (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_3DExtent (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_3DExtent (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_3DExtent (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MemCollect (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MemCollect (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MemCollect (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MemCollect (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MemCollect (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MemUnion (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MemUnion (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MemUnion (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MemUnion (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MemUnion (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Accum (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Accum (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Accum (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Accum (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Accum (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Union (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Union (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Union (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Union (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Union (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Collect (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Collect (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Collect (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Collect (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Collect (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_ClusterIntersecting (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_ClusterIntersecting (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_ClusterIntersecting (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_ClusterIntersecting (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_ClusterIntersecting (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_ClusterWithin (geometry, float8);
	RAISE NOTICE 'newly registered AGGREGATE ST_ClusterWithin (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_ClusterWithin (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_ClusterWithin (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_ClusterWithin (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Polygonize (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Polygonize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Polygonize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Polygonize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Polygonize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MakeLine (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MakeLine (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MakeLine (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MakeLine (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MakeLine (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text, int4);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text, int4, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text, int4, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text, int4, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text, int4, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text, int4, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsGeobuf (anyelement);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsGeobuf (anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsGeobuf (anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsGeobuf (anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsGeobuf (anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsGeobuf (anyelement, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsGeobuf (anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsGeobuf (anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsGeobuf (anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsGeobuf (anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision);
	RAISE NOTICE 'newly registered AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_summarystatsagg (raster, boolean, double precision);
	RAISE NOTICE 'newly registered AGGREGATE st_summarystatsagg (raster, boolean, double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_summarystatsagg (raster, boolean, double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_summarystatsagg (raster, boolean, double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_summarystatsagg (raster, boolean, double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_summarystatsagg (raster, int, boolean);
	RAISE NOTICE 'newly registered AGGREGATE st_summarystatsagg (raster, int, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_summarystatsagg (raster, int, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_summarystatsagg (raster, int, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_summarystatsagg (raster, int, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_countagg (raster, integer, boolean, double precision);
	RAISE NOTICE 'newly registered AGGREGATE st_countagg (raster, integer, boolean, double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_countagg (raster, integer, boolean, double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_countagg (raster, integer, boolean, double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_countagg (raster, integer, boolean, double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_countagg (raster, integer, boolean);
	RAISE NOTICE 'newly registered AGGREGATE st_countagg (raster, integer, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_countagg (raster, integer, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_countagg (raster, integer, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_countagg (raster, integer, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_countagg (raster, boolean);
	RAISE NOTICE 'newly registered AGGREGATE st_countagg (raster, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_countagg (raster, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_countagg (raster, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_countagg (raster, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_samealignment (raster);
	RAISE NOTICE 'newly registered AGGREGATE st_samealignment (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_samealignment (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_samealignment (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_samealignment (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_union (raster, unionarg[]);
	RAISE NOTICE 'newly registered AGGREGATE st_union (raster, unionarg[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_union (raster, unionarg[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_union (raster, unionarg[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_union (raster, unionarg[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_union (raster, integer, text);
	RAISE NOTICE 'newly registered AGGREGATE st_union (raster, integer, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_union (raster, integer, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_union (raster, integer, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_union (raster, integer, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_union (raster, integer);
	RAISE NOTICE 'newly registered AGGREGATE st_union (raster, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_union (raster, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_union (raster, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_union (raster, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_union (raster);
	RAISE NOTICE 'newly registered AGGREGATE st_union (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_union (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_union (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_union (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE st_union (raster, text);
	RAISE NOTICE 'newly registered AGGREGATE st_union (raster, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE st_union (raster, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE st_union (raster, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE st_union (raster, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all operators classes and families.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS btree_geometry_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR CLASS btree_geometry_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS btree_geometry_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS btree_geometry_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS btree_geometry_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY btree_geometry_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR FAMILY btree_geometry_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY btree_geometry_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY btree_geometry_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY btree_geometry_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS hash_geometry_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR CLASS hash_geometry_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS hash_geometry_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS hash_geometry_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS hash_geometry_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY hash_geometry_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR FAMILY hash_geometry_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY hash_geometry_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY hash_geometry_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY hash_geometry_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geometry_ops_2d USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geometry_ops_2d USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geometry_ops_2d USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geometry_ops_2d USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geometry_ops_2d USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geometry_ops_2d USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geometry_ops_2d USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geometry_ops_2d USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geometry_ops_2d USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geometry_ops_2d USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geometry_ops_nd USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geometry_ops_nd USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geometry_ops_nd USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geometry_ops_nd USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geometry_ops_nd USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geometry_ops_nd USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geometry_ops_nd USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geometry_ops_nd USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geometry_ops_nd USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geometry_ops_nd USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geography_ops USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geography_ops USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geography_ops USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geography_ops USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geography_ops USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geography_ops USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geography_ops USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geography_ops USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geography_ops USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geography_ops USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geography_inclusion_ops USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geography_inclusion_ops USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geography_inclusion_ops USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geography_inclusion_ops USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geography_inclusion_ops USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geography_inclusion_ops USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geography_inclusion_ops USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geography_inclusion_ops USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geography_inclusion_ops USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geography_inclusion_ops USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS btree_geography_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR CLASS btree_geography_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS btree_geography_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS btree_geography_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS btree_geography_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY btree_geography_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR FAMILY btree_geography_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY btree_geography_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY btree_geography_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY btree_geography_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS hash_raster_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR CLASS hash_raster_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS hash_raster_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS hash_raster_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS hash_raster_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY hash_raster_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR FAMILY hash_raster_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY hash_raster_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY hash_raster_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY hash_raster_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all operators.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR =  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR =  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR =  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR =  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR =  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <->  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <->  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <->  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <->  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <->  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <#>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <#>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <#>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <#>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <#>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR @  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &<  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &<|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |&>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |&>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |&>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |&>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |&>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |>>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |>>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |>>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |>>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |>>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<->>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<->>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<->>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<->>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<->>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |=|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |=|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |=|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |=|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |=|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR &&  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <->  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <->  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <->  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <->  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <->  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (gidx,geography);
	RAISE NOTICE 'newly registered OPERATOR &&  (gidx,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (gidx,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (gidx,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (gidx,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geography,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&  (geography,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geography,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geography,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geography,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (gidx,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&  (gidx,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (gidx,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (gidx,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (gidx,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <=  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <=  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <=  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <=  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <=  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR =  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR =  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR =  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR =  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR =  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >=  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR >=  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >=  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >=  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >=  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR >  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR @  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR ~  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR @  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR &&  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR &&  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR @  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR ~  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (gidx,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&&  (gidx,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (gidx,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (gidx,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (gidx,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (geometry,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&&  (geometry,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (geometry,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (geometry,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (geometry,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (gidx,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&&  (gidx,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (gidx,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (gidx,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (gidx,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &/&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &/&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &/&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &/&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &/&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @>>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR @>>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @>>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @>>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @>>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<@  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<@  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<@  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<@  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<@  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~==  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~==  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~==  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~==  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~==  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR =  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR =  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR =  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR =  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR =  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR <<  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR &<  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<|  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR <<|  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<|  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<|  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<|  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<|  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR &<|  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<|  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<|  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<|  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR &&  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &>  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR &>  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &>  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &>  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &>  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >>  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR >>  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >>  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >>  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >>  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |&>  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR |&>  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |&>  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |&>  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |&>  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |>>  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR |>>  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |>>  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |>>  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |>>  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~=  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR ~=  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~=  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~=  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~=  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR @  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (raster,raster);
	RAISE NOTICE 'newly registered OPERATOR ~  (raster,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (raster,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (raster,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (raster,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (raster,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~  (raster,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (raster,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (raster,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (raster,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (raster,geometry);
	RAISE NOTICE 'newly registered OPERATOR @  (raster,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (raster,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (raster,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (raster,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (raster,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&  (raster,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (raster,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (raster,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (raster,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (geometry,raster);
	RAISE NOTICE 'newly registered OPERATOR ~  (geometry,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (geometry,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (geometry,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (geometry,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (geometry,raster);
	RAISE NOTICE 'newly registered OPERATOR @  (geometry,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (geometry,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (geometry,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (geometry,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geometry,raster);
	RAISE NOTICE 'newly registered OPERATOR &&  (geometry,raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geometry,raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geometry,raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geometry,raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all casts.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS geometry);
	RAISE NOTICE 'newly registered CAST (geometry AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS point);
	RAISE NOTICE 'newly registered CAST (geometry AS point)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS point)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS point) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS point) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (point AS geometry);
	RAISE NOTICE 'newly registered CAST (point AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (point AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (point AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (point AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS path);
	RAISE NOTICE 'newly registered CAST (geometry AS path)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS path)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS path) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS path) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (path AS geometry);
	RAISE NOTICE 'newly registered CAST (path AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (path AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (path AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (path AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS polygon);
	RAISE NOTICE 'newly registered CAST (geometry AS polygon)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS polygon)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS polygon) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS polygon) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (polygon AS geometry);
	RAISE NOTICE 'newly registered CAST (polygon AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (polygon AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (polygon AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (polygon AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box2d);
	RAISE NOTICE 'newly registered CAST (geometry AS box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box3d);
	RAISE NOTICE 'newly registered CAST (geometry AS box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box);
	RAISE NOTICE 'newly registered CAST (geometry AS box)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS box2d);
	RAISE NOTICE 'newly registered CAST (box3d AS box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box2d AS box3d);
	RAISE NOTICE 'newly registered CAST (box2d AS box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box2d AS box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box2d AS box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box2d AS box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box2d AS geometry);
	RAISE NOTICE 'newly registered CAST (box2d AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box2d AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box2d AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box2d AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS box);
	RAISE NOTICE 'newly registered CAST (box3d AS box)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS box)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS box) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS box) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS geometry);
	RAISE NOTICE 'newly registered CAST (box3d AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (text AS geometry);
	RAISE NOTICE 'newly registered CAST (text AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (text AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (text AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (text AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS text);
	RAISE NOTICE 'newly registered CAST (geometry AS text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (bytea AS geometry);
	RAISE NOTICE 'newly registered CAST (bytea AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (bytea AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (bytea AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (bytea AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS bytea);
	RAISE NOTICE 'newly registered CAST (geometry AS bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS geography);
	RAISE NOTICE 'newly registered CAST (geography AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (bytea AS geography);
	RAISE NOTICE 'newly registered CAST (bytea AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (bytea AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (bytea AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (bytea AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS bytea);
	RAISE NOTICE 'newly registered CAST (geography AS bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS geography);
	RAISE NOTICE 'newly registered CAST (geometry AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS geometry);
	RAISE NOTICE 'newly registered CAST (geography AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (raster AS box3d);
	RAISE NOTICE 'newly registered CAST (raster AS box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (raster AS box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (raster AS box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (raster AS box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (raster AS geometry);
	RAISE NOTICE 'newly registered CAST (raster AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (raster AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (raster AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (raster AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (raster AS bytea);
	RAISE NOTICE 'newly registered CAST (raster AS bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (raster AS bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (raster AS bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (raster AS bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all functions except 26 needed for type definition.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_deprecate (oldname text, newname text, version text);
	RAISE NOTICE 'newly registered FUNCTION _postgis_deprecate (oldname text, newname text, version text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_deprecate (oldname text, newname text, version text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_deprecate (oldname text, newname text, version text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_deprecate (oldname text, newname text, version text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (geometry, integer, boolean);
	RAISE NOTICE 'newly registered FUNCTION geometry (geometry, integer, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (geometry, integer, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (geometry, integer, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (geometry, integer, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (point);
	RAISE NOTICE 'newly registered FUNCTION geometry (point)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (point)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (point) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (point) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION point (geometry);
	RAISE NOTICE 'newly registered FUNCTION point (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION point (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION point (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION point (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (path);
	RAISE NOTICE 'newly registered FUNCTION geometry (path)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (path)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (path) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (path) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION path (geometry);
	RAISE NOTICE 'newly registered FUNCTION path (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION path (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION path (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION path (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (polygon);
	RAISE NOTICE 'newly registered FUNCTION geometry (polygon)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (polygon)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (polygon) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (polygon) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION polygon (geometry);
	RAISE NOTICE 'newly registered FUNCTION polygon (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION polygon (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION polygon (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION polygon (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_X (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_X (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_X (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_X (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_X (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Y (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Y (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Y (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Y (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Y (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Z (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Z (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Z (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Z (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Z (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_M (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_M (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_M (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_M (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_M (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_lt (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_lt (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_lt (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_lt (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_lt (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_le (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_le (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_le (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_le (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_le (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gt (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_gt (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gt (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gt (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gt (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_ge (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_ge (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_ge (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_ge (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_ge (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_eq (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_eq (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_eq (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_eq (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_eq (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_cmp (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_cmp (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_cmp (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_cmp (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_cmp (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_hash (geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_hash (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_hash (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_hash (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_hash (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_distance_2d (internal,geometry,int4);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_distance_2d (internal,geometry,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_distance_2d (internal,geometry,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_distance_2d (internal,geometry,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_distance_2d (internal,geometry,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_consistent_2d (internal,geometry,int4);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_consistent_2d (internal,geometry,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_consistent_2d (internal,geometry,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_consistent_2d (internal,geometry,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_consistent_2d (internal,geometry,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_compress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_compress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_compress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_compress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_compress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_penalty_2d (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_penalty_2d (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_penalty_2d (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_penalty_2d (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_penalty_2d (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_picksplit_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_picksplit_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_picksplit_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_picksplit_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_picksplit_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_union_2d (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_union_2d (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_union_2d (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_union_2d (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_union_2d (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_decompress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_decompress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_decompress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_decompress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_decompress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_stats (tbl regclass, att_name text, text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_stats (tbl regclass, att_name text, text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_stats (tbl regclass, att_name text, text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_stats (tbl regclass, att_name text, text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_stats (tbl regclass, att_name text, text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_index_extent (tbl regclass, col text);
	RAISE NOTICE 'newly registered FUNCTION _postgis_index_extent (tbl regclass, col text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_index_extent (tbl regclass, col text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_index_extent (tbl regclass, col text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_index_extent (tbl regclass, col text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, int4);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, int4);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_same (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_same (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_same (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_same (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_same (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_left (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_left (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_left (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_left (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_left (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overleft (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overleft (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overleft (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overleft (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overleft (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_below (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_below (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_below (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_below (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_below (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overright (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overright (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overright (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overright (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overright (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_right (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_right (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_right (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_right (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_right (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overabove (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overabove (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overabove (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overabove (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overabove (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_above (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_above (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_above (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_above (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_above (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_consistent_nd (internal,geometry,int4);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_consistent_nd (internal,geometry,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_consistent_nd (internal,geometry,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_consistent_nd (internal,geometry,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_consistent_nd (internal,geometry,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_compress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_compress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_compress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_compress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_compress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_penalty_nd (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_penalty_nd (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_penalty_nd (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_penalty_nd (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_penalty_nd (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_picksplit_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_picksplit_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_picksplit_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_picksplit_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_picksplit_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_union_nd (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_union_nd (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_union_nd (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_union_nd (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_union_nd (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_same_nd (geometry, geometry, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_same_nd (geometry, geometry, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_same_nd (geometry, geometry, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_same_nd (geometry, geometry, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_same_nd (geometry, geometry, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_decompress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_decompress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_decompress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_decompress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_decompress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps_nd (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps_nd (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps_nd (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps_nd (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps_nd (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_centroid_nd (geometry,geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_centroid_nd (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_centroid_nd (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_centroid_nd (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_centroid_nd (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_cpa (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_cpa (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_cpa (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_cpa (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_cpa (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_distance_nd (internal,geometry,int4);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_distance_nd (internal,geometry,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_distance_nd (internal,geometry,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_distance_nd (internal,geometry,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_distance_nd (internal,geometry,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ShiftLongitude (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ShiftLongitude (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ShiftLongitude (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ShiftLongitude (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ShiftLongitude (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WrapX (geom geometry, wrap float8, move float8);
	RAISE NOTICE 'newly registered FUNCTION ST_WrapX (geom geometry, wrap float8, move float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WrapX (geom geometry, wrap float8, move float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WrapX (geom geometry, wrap float8, move float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WrapX (geom geometry, wrap float8, move float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Shift_Longitude (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Shift_Longitude (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Shift_Longitude (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Shift_Longitude (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Shift_Longitude (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_XMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_XMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_XMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_XMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_XMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_YMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_YMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_YMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_YMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_YMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ZMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_ZMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ZMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ZMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ZMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_XMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_XMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_XMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_XMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_XMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_YMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_YMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_YMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_YMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_YMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ZMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_ZMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ZMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ZMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ZMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box2d,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box2d,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box2d,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box2d,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box2d,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box box2d, dx float8, dy float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box box2d, dx float8, dy float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box box2d, dx float8, dy float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box box2d, dx float8, dy float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box box2d, dx float8, dy float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_getbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_getbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_getbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_getbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_getbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text,text,boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text,text,boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text,text,boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text,text,boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text,text,boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_estimated_extent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_estimated_extent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_estimated_extent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_estimated_extent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_estimated_extent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_estimated_extent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_estimated_extent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_estimated_extent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_estimated_extent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_estimated_extent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FindExtent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_FindExtent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FindExtent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FindExtent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FindExtent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_find_extent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_find_extent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_find_extent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_find_extent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_find_extent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FindExtent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_FindExtent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FindExtent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FindExtent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FindExtent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_find_extent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_find_extent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_find_extent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_find_extent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_find_extent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_addbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_addbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_addbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_addbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_addbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_dropbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_dropbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_dropbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_dropbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_dropbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_hasbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_hasbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_hasbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_hasbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_hasbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int );
	RAISE NOTICE 'newly registered FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MemSize (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MemSize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MemSize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MemSize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MemSize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_mem_size (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_mem_size (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_mem_size (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_mem_size (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_mem_size (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_summary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_summary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_summary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_summary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_summary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Npoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Npoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Npoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Npoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Npoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_nrings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_nrings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_nrings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_nrings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_nrings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLength (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLength (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLength (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLength (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLength (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Length2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Length (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LengthSpheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_LengthSpheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LengthSpheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LengthSpheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LengthSpheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLength_spheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLength_spheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLength_spheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLength_spheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLength_spheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_length_spheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_length_spheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_length_spheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_length_spheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_length_spheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length2DSpheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_Length2DSpheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length2DSpheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length2DSpheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length2DSpheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_length2d_spheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_length2d_spheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_length2d_spheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_length2d_spheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_length2d_spheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DPerimeter (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DPerimeter (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DPerimeter (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DPerimeter (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DPerimeter (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_perimeter2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_perimeter2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_perimeter2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_perimeter2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_perimeter2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Perimeter (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Perimeter (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Perimeter (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Perimeter (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Perimeter (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_area2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_area2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_area2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_area2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_area2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Area (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsPolygonCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsPolygonCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsPolygonCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsPolygonCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsPolygonCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsPolygonCCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsPolygonCCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsPolygonCCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsPolygonCCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsPolygonCCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry,spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry,spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry,spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry,spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry,spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_distance_spheroid (geom1 geometry, geom2 geometry,spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_distance_spheroid (geom1 geometry, geom2 geometry,spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_distance_spheroid (geom1 geometry, geom2 geometry,spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_distance_spheroid (geom1 geometry, geom2 geometry,spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_distance_spheroid (geom1 geometry, geom2 geometry,spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_point_inside_circle (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_point_inside_circle (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_point_inside_circle (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_point_inside_circle (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_point_inside_circle (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_azimuth (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_azimuth (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_azimuth (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_azimuth (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_azimuth (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force2D (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force2D (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force2D (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force2D (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force2D (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3DZ (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force3DZ (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3DZ (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3DZ (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3DZ (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_3dz (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_3dz (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_3dz (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_3dz (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_3dz (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3D (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force3D (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3D (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3D (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3D (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_3d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_3d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_3d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_3d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_3d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3DM (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force3DM (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3DM (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3DM (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3DM (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_3dm (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_3dm (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_3dm (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_3dm (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_3dm (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force4D (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force4D (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force4D (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force4D (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force4D (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_4d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_4d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_4d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_4d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_4d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceCollection (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceCollection (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceCollection (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceCollection (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceCollection (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_force_collection (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_force_collection (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_force_collection (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_force_collection (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_force_collection (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CollectionExtract (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_CollectionExtract (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CollectionExtract (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CollectionExtract (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CollectionExtract (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CollectionHomogenize (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CollectionHomogenize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CollectionHomogenize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CollectionHomogenize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CollectionHomogenize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Multi (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Multi (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Multi (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Multi (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Multi (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceCurve (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceCurve (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceCurve (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceCurve (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceCurve (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceSFS (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceSFS (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceSFS (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceSFS (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceSFS (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceSFS (geometry, version text);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceSFS (geometry, version text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceSFS (geometry, version text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceSFS (geometry, version text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceSFS (geometry, version text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box3d,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box3d,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box3d,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box3d,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box3d,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Envelope (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Envelope (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Envelope (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Envelope (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Envelope (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Reverse (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Reverse (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Reverse (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Reverse (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Reverse (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForcePolygonCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForcePolygonCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForcePolygonCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForcePolygonCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForcePolygonCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForcePolygonCCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForcePolygonCCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForcePolygonCCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForcePolygonCCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForcePolygonCCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceRHR (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceRHR (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceRHR (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceRHR (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceRHR (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_noop (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_noop (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_noop (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_noop (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_noop (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Normalize (geom geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Normalize (geom geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Normalize (geom geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Normalize (geom geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Normalize (geom geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_zmflag (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_zmflag (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_zmflag (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_zmflag (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_zmflag (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NDims (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NDims (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NDims (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NDims (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NDims (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsTWKB (geom geometry, prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_AsTWKB (geom geometry, prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsTWKB (geom geometry, prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsTWKB (geom geometry, prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsTWKB (geom geometry, prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec int4 , prec_z int4 , prec_m int4 , with_sizes boolean , with_boxes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKB (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKB (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKB (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKB (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKB (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsHEXEWKB (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsHEXEWKB (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsHEXEWKB (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsHEXEWKB (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsHEXEWKB (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsHEXEWKB (geometry, text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsHEXEWKB (geometry, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsHEXEWKB (geometry, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsHEXEWKB (geometry, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsHEXEWKB (geometry, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKB (geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKB (geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKB (geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKB (geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKB (geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsLatLonText (geom geometry, tmpl text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsLatLonText (geom geometry, tmpl text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsLatLonText (geom geometry, tmpl text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsLatLonText (geom geometry, tmpl text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsLatLonText (geom geometry, tmpl text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeomFromEWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION GeomFromEWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeomFromEWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeomFromEWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeomFromEWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromEWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromEWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromEWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromEWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromEWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromTWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromTWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromTWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromTWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromTWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeomFromEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION GeomFromEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeomFromEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeomFromEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeomFromEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_cache_bbox ();
	RAISE NOTICE 'newly registered FUNCTION postgis_cache_bbox ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_cache_bbox ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_cache_bbox () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_cache_bbox () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePointM (float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePointM (float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePointM (float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePointM (float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePointM (float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeLine  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeLine  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeLine  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeLine  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeLine  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromMultiPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromMultiPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromMultiPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromMultiPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromMultiPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RemovePoint (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_RemovePoint (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RemovePoint (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RemovePoint (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RemovePoint (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetPoint (geometry, integer, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SetPoint (geometry, integer, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetPoint (geometry, integer, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetPoint (geometry, integer, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetPoint (geometry, integer, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer );
	RAISE NOTICE 'newly registered FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePolygon (geometry, geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePolygon (geometry, geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePolygon (geometry, geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePolygon (geometry, geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePolygon (geometry, geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePolygon (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePolygon (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePolygon (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePolygon (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePolygon (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BuildArea (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_BuildArea (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BuildArea (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BuildArea (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BuildArea (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Polygonize  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Polygonize  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Polygonize  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Polygonize  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Polygonize  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterIntersecting (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterIntersecting (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterIntersecting (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterIntersecting (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterIntersecting (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterWithin (geometry[], float8);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterWithin (geometry[], float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterWithin (geometry[], float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterWithin (geometry[], float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterWithin (geometry[], float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineMerge (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineMerge (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineMerge (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineMerge (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineMerge (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateZ (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateZ (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateZ (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateZ (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateZ (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateX (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateX (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateX (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateX (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateX (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateY (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateY (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateY (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateY (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateY (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Translate (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Translate (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Translate (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Translate (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Translate (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Translate (geometry,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Translate (geometry,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Translate (geometry,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Translate (geometry,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Translate (geometry,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,geometry,origin geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,geometry,origin geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,geometry,origin geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,geometry,origin geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,geometry,origin geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transscale (geometry,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Transscale (geometry,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transscale (geometry,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transscale (geometry,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transscale (geometry,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Dump (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Dump (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Dump (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Dump (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Dump (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DumpRings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DumpRings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DumpRings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DumpRings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DumpRings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DumpPoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DumpPoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DumpPoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DumpPoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DumpPoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION populate_geometry_columns (use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION populate_geometry_columns (use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION populate_geometry_columns (use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION populate_geometry_columns (use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION populate_geometry_columns (use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (table_name varchar, column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (table_name varchar, column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (table_name varchar, column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (table_name varchar, column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (table_name varchar, column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (schema_name varchar, table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (schema_name varchar, table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (schema_name varchar, table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (schema_name varchar, table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (schema_name varchar, table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (varchar,varchar,integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (varchar,varchar,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (varchar,varchar,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (varchar,varchar,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (varchar,varchar,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION find_srid (varchar,varchar,varchar);
	RAISE NOTICE 'newly registered FUNCTION find_srid (varchar,varchar,varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION find_srid (varchar,varchar,varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION find_srid (varchar,varchar,varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION find_srid (varchar,varchar,varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION get_proj4_from_srid (integer);
	RAISE NOTICE 'newly registered FUNCTION get_proj4_from_srid (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION get_proj4_from_srid (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION get_proj4_from_srid (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION get_proj4_from_srid (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetSRID (geometry,int4);
	RAISE NOTICE 'newly registered FUNCTION ST_SetSRID (geometry,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetSRID (geometry,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetSRID (geometry,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetSRID (geometry,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SRID (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SRID (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SRID (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SRID (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SRID (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_transform_geometry (geometry,text,text,int);
	RAISE NOTICE 'newly registered FUNCTION postgis_transform_geometry (geometry,text,text,int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_transform_geometry (geometry,text,text,int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_transform_geometry (geometry,text,text,int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_transform_geometry (geometry,text,text,int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, to_proj text);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, to_proj text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, to_proj text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, to_proj text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, to_proj text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_liblwgeom_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_liblwgeom_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_liblwgeom_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_liblwgeom_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_liblwgeom_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_proj_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_proj_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_proj_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_proj_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_proj_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_installed ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_installed ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_installed ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_installed () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_installed () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_lib_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_lib_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_lib_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_lib_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_lib_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_released ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_released ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_released ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_released () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_released () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_geos_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_geos_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_geos_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_geos_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_geos_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_svn_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_svn_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_svn_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_svn_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_svn_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libxml_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libxml_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libxml_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libxml_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libxml_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_build_date ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_build_date ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_build_date ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_build_date () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_build_date () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_lib_build_date ();
	RAISE NOTICE 'newly registered FUNCTION postgis_lib_build_date ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_lib_build_date ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_lib_build_date () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_lib_build_date () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_scripts_pgsql_version ();
	RAISE NOTICE 'newly registered FUNCTION _postgis_scripts_pgsql_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_scripts_pgsql_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_scripts_pgsql_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_scripts_pgsql_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_pgsql_version ();
	RAISE NOTICE 'newly registered FUNCTION _postgis_pgsql_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_pgsql_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_pgsql_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_pgsql_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_extensions_upgrade ();
	RAISE NOTICE 'newly registered FUNCTION postgis_extensions_upgrade ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_extensions_upgrade ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_extensions_upgrade () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_extensions_upgrade () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_full_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_full_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_full_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_full_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_full_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION box2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d (geometry);
	RAISE NOTICE 'newly registered FUNCTION box3d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box (geometry);
	RAISE NOTICE 'newly registered FUNCTION box (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d (box3d);
	RAISE NOTICE 'newly registered FUNCTION box2d (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d (box2d);
	RAISE NOTICE 'newly registered FUNCTION box3d (box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d (box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d (box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d (box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box (box3d);
	RAISE NOTICE 'newly registered FUNCTION box (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION text (geometry);
	RAISE NOTICE 'newly registered FUNCTION text (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION text (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION text (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION text (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3dtobox (box3d);
	RAISE NOTICE 'newly registered FUNCTION box3dtobox (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3dtobox (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3dtobox (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3dtobox (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (box2d);
	RAISE NOTICE 'newly registered FUNCTION geometry (box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (box3d);
	RAISE NOTICE 'newly registered FUNCTION geometry (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (text);
	RAISE NOTICE 'newly registered FUNCTION geometry (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (bytea);
	RAISE NOTICE 'newly registered FUNCTION geometry (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION bytea (geometry);
	RAISE NOTICE 'newly registered FUNCTION bytea (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION bytea (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION bytea (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION bytea (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Simplify (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Simplify (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Simplify (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Simplify (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Simplify (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Simplify (geometry, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_Simplify (geometry, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Simplify (geometry, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Simplify (geometry, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Simplify (geometry, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SimplifyVW (geometry,  float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SimplifyVW (geometry,  float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SimplifyVW (geometry,  float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SimplifyVW (geometry,  float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SimplifyVW (geometry,  float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer );
	RAISE NOTICE 'newly registered FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Segmentize (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Segmentize (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Segmentize (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Segmentize (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Segmentize (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineInterpolatePoint (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LineInterpolatePoint (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineInterpolatePoint (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineInterpolatePoint (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineInterpolatePoint (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_line_interpolate_point (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_line_interpolate_point (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_line_interpolate_point (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_line_interpolate_point (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_line_interpolate_point (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineSubstring (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LineSubstring (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineSubstring (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineSubstring (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineSubstring (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_line_substring (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_line_substring (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_line_substring (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_line_substring (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_line_substring (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_line_locate_point (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_line_locate_point (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_line_locate_point (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_line_locate_point (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_line_locate_point (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_locate_between_measures (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_locate_between_measures (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_locate_between_measures (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_locate_between_measures (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_locate_between_measures (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_locate_along_measure (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_locate_along_measure (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_locate_along_measure (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_locate_along_measure (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_locate_along_measure (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddMeasure (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_AddMeasure (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddMeasure (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddMeasure (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddMeasure (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClosestPointOfApproach (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ClosestPointOfApproach (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClosestPointOfApproach (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClosestPointOfApproach (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClosestPointOfApproach (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceCPA (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceCPA (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceCPA (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceCPA (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceCPA (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CPAWithin (geometry, geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_CPAWithin (geometry, geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CPAWithin (geometry, geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CPAWithin (geometry, geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CPAWithin (geometry, geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidTrajectory (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidTrajectory (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidTrajectory (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidTrajectory (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidTrajectory (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Buffer (geometry,float8,cstring);
	RAISE NOTICE 'newly registered FUNCTION _ST_Buffer (geometry,float8,cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Buffer (geometry,float8,cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Buffer (geometry,float8,cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Buffer (geometry,float8,cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geometry,float8,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geometry,float8,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geometry,float8,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geometry,float8,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geometry,float8,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geometry,float8,text);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geometry,float8,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geometry,float8,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geometry,float8,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geometry,float8,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer );
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OrientedEnvelope (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_OrientedEnvelope (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OrientedEnvelope (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OrientedEnvelope (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OrientedEnvelope (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OffsetCurve (line geometry, distance float8, params text );
	RAISE NOTICE 'newly registered FUNCTION ST_OffsetCurve (line geometry, distance float8, params text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OffsetCurve (line geometry, distance float8, params text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OffsetCurve (line geometry, distance float8, params text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OffsetCurve (line geometry, distance float8, params text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeneratePoints (area geometry, npoints numeric);
	RAISE NOTICE 'newly registered FUNCTION ST_GeneratePoints (area geometry, npoints numeric)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeneratePoints (area geometry, npoints numeric)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeneratePoints (area geometry, npoints numeric) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeneratePoints (area geometry, npoints numeric) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ConvexHull (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ConvexHull (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ConvexHull (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ConvexHull (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ConvexHull (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_LineCrossingDirection (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_LineCrossingDirection (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_LineCrossingDirection (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_LineCrossingDirection (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_LineCrossingDirection (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineCrossingDirection (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineCrossingDirection (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineCrossingDirection (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineCrossingDirection (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineCrossingDirection (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SimplifyPreserveTopology (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SimplifyPreserveTopology (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SimplifyPreserveTopology (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SimplifyPreserveTopology (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SimplifyPreserveTopology (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidReason (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidReason (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidReason (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidReason (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidReason (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidDetail (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidDetail (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidDetail (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidDetail (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidDetail (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidDetail (geometry, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidDetail (geometry, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidDetail (geometry, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidDetail (geometry, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidDetail (geometry, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidReason (geometry, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidReason (geometry, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidReason (geometry, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidReason (geometry, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidReason (geometry, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValid (geometry, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValid (geometry, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValid (geometry, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValid (geometry, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValid (geometry, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Difference (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Difference (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Difference (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Difference (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Difference (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Boundary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Boundary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Boundary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Boundary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Boundary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Points (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Points (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Points (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Points (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Points (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_symmetricdifference (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_symmetricdifference (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_symmetricdifference (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_symmetricdifference (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_symmetricdifference (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Union (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Union (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Union (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Union (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Union (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_UnaryUnion (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_UnaryUnion (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_UnaryUnion (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_UnaryUnion (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_UnaryUnion (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClipByBox2d (geom geometry, box box2d);
	RAISE NOTICE 'newly registered FUNCTION ST_ClipByBox2d (geom geometry, box box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClipByBox2d (geom geometry, box box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClipByBox2d (geom geometry, box box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClipByBox2d (geom geometry, box box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Subdivide (geom geometry, maxvertices integer );
	RAISE NOTICE 'newly registered FUNCTION ST_Subdivide (geom geometry, maxvertices integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Subdivide (geom geometry, maxvertices integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Subdivide (geom geometry, maxvertices integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Subdivide (geom geometry, maxvertices integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeValid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeValid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeValid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeValid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeValid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CleanGeometry (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CleanGeometry (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CleanGeometry (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CleanGeometry (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CleanGeometry (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Split (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Split (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Split (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Split (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Split (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RelateMatch (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_RelateMatch (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RelateMatch (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RelateMatch (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RelateMatch (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Node (g geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Node (g geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Node (g geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Node (g geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Node (g geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean );
	RAISE NOTICE 'newly registered FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBBox (box3d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBBox (box3d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBBox (box3d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBBox (box3d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBBox (box3d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBBox (box3d,box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBBox (box3d,box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBBox (box3d,box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBBox (box3d,box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBBox (box3d,box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Combine_BBox (box3d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Combine_BBox (box3d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Combine_BBox (box3d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Combine_BBox (box3d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Combine_BBox (box3d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBbox (box2d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBbox (box2d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBbox (box2d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBbox (box2d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBbox (box2d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Combine_BBox (box2d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Combine_BBox (box2d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Combine_BBox (box2d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Combine_BBox (box2d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Combine_BBox (box2d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Collect (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Collect (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Collect (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Collect (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Collect (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Collect (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Collect (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Collect (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Collect (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Collect (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_collect_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_collect_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_collect_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_collect_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_collect_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_polygonize_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_polygonize_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_polygonize_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_polygonize_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_polygonize_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_clusterintersecting_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_clusterintersecting_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_clusterintersecting_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_clusterintersecting_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_clusterintersecting_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_clusterwithin_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_clusterwithin_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_clusterwithin_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_clusterwithin_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_clusterwithin_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_makeline_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_makeline_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_makeline_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_makeline_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_makeline_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Union  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Union  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Union  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Union  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Union  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterKMeans (geom geometry, k integer);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterKMeans (geom geometry, k integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterKMeans (geom geometry, k integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterKMeans (geom geometry, k integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterKMeans (geom geometry, k integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Touches (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Touches (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Touches (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Touches (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Touches (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Touches (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Touches (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Touches (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Touches (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Touches (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Crosses (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Crosses (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Crosses (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Crosses (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Crosses (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Covers (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Covers (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Covers (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Covers (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Covers (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumClearance (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumClearance (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumClearance (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumClearance (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumClearance (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumClearanceLine (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumClearanceLine (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumClearanceLine (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumClearanceLine (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumClearanceLine (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointOnSurface (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_PointOnSurface (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointOnSurface (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointOnSurface (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointOnSurface (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsSimple (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsSimple (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsSimple (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsSimple (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsSimple (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsCollection (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsCollection (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsCollection (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsCollection (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsCollection (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_GeomFromGML (text, int4);
	RAISE NOTICE 'newly registered FUNCTION _ST_GeomFromGML (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_GeomFromGML (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_GeomFromGML (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_GeomFromGML (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGML (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGML (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGML (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGML (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGML (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GMLToSQL (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GMLToSQL (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GMLToSQL (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GMLToSQL (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GMLToSQL (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GMLToSQL (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_GMLToSQL (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GMLToSQL (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GMLToSQL (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GMLToSQL (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromKML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromKML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromKML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromKML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromKML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (json);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (json)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (json)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (json) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (json) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (jsonb);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (jsonb)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (jsonb)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (jsonb) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (jsonb) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libjson_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libjson_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libjson_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libjson_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libjson_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromEncodedPolyline (text, int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromEncodedPolyline (text, int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromEncodedPolyline (text, int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromEncodedPolyline (text, int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromEncodedPolyline (text, int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEncodedPolyline (geom geometry, int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsEncodedPolyline (geom geometry, int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEncodedPolyline (geom geometry, int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEncodedPolyline (geom geometry, int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEncodedPolyline (geom geometry, int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (geom geometry,rel int4 ,maxdecimaldigits int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (geom geometry,rel int4 ,maxdecimaldigits int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (geom geometry,rel int4 ,maxdecimaldigits int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (geom geometry,rel int4 ,maxdecimaldigits int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (geom geometry,rel int4 ,maxdecimaldigits int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsGML (int4, geometry, int4, int4, text, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsGML (int4, geometry, int4, int4, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsGML (int4, geometry, int4, int4, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsGML (int4, geometry, int4, int4, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsGML (int4, geometry, int4, int4, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (geom geometry, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (geom geometry, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (geom geometry, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (geom geometry, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (geom geometry, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (version int4, geom geometry, maxdecimaldigits int4 , options int4 , nprefix text , id text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (version int4, geom geometry, maxdecimaldigits int4 , options int4 , nprefix text , id text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (version int4, geom geometry, maxdecimaldigits int4 , options int4 , nprefix text , id text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (version int4, geom geometry, maxdecimaldigits int4 , options int4 , nprefix text , id text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (version int4, geom geometry, maxdecimaldigits int4 , options int4 , nprefix text , id text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsKML (int4,geometry, int4, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsKML (int4,geometry, int4, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsKML (int4,geometry, int4, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsKML (int4,geometry, int4, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsKML (int4,geometry, int4, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (geom geometry, maxdecimaldigits int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (geom geometry, maxdecimaldigits int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (geom geometry, maxdecimaldigits int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (geom geometry, maxdecimaldigits int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (geom geometry, maxdecimaldigits int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (version int4, geom geometry, maxdecimaldigits int4 , nprefix text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (version int4, geom geometry, maxdecimaldigits int4 , nprefix text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (version int4, geom geometry, maxdecimaldigits int4 , nprefix text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (version int4, geom geometry, maxdecimaldigits int4 , nprefix text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (version int4, geom geometry, maxdecimaldigits int4 , nprefix text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsGeoJson (int4, geometry, int4, int4);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsGeoJson (int4, geometry, int4, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsGeoJson (int4, geometry, int4, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsGeoJson (int4, geometry, int4, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsGeoJson (int4, geometry, int4, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (gj_version int4, geom geometry, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (gj_version int4, geom geometry, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (gj_version int4, geom geometry, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (gj_version int4, geom geometry, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (gj_version int4, geom geometry, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text, int4, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_combinefn (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_combinefn (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_combinefn (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_combinefn (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_combinefn (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_serialfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_serialfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_serialfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_serialfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_serialfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_deserialfn (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_deserialfn (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_deserialfn (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_deserialfn (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_deserialfn (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent int4 , buffer int4 , clip_geom bool );
	RAISE NOTICE 'newly registered FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent int4 , buffer int4 , clip_geom bool )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent int4 , buffer int4 , clip_geom bool )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent int4 , buffer int4 , clip_geom bool ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent int4 , buffer int4 , clip_geom bool ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libprotobuf_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libprotobuf_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libprotobuf_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libprotobuf_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libprotobuf_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_transfn (internal, anyelement);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_transfn (internal, anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_transfn (internal, anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeoHash (geom geometry, maxchars int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_GeoHash (geom geometry, maxchars int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeoHash (geom geometry, maxchars int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeoHash (geom geometry, maxchars int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeoHash (geom geometry, maxchars int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Box2dFromGeoHash (text, int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_Box2dFromGeoHash (text, int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Box2dFromGeoHash (text, int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Box2dFromGeoHash (text, int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Box2dFromGeoHash (text, int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromGeoHash (text, int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromGeoHash (text, int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromGeoHash (text, int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromGeoHash (text, int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromGeoHash (text, int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoHash (text, int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoHash (text, int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoHash (text, int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoHash (text, int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoHash (text, int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumPoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumPoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumPoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumPoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumPoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumGeometries (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumGeometries (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumGeometries (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumGeometries (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumGeometries (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Dimension (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Dimension (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Dimension (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Dimension (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Dimension (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ExteriorRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ExteriorRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ExteriorRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ExteriorRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ExteriorRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumInteriorRings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumInteriorRings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumInteriorRings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumInteriorRings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumInteriorRings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumInteriorRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumInteriorRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumInteriorRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumInteriorRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumInteriorRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_InteriorRingN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_InteriorRingN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_InteriorRingN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_InteriorRingN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_InteriorRingN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeometryType (geometry);
	RAISE NOTICE 'newly registered FUNCTION GeometryType (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeometryType (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeometryType (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeometryType (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryType (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryType (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryType (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryType (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryType (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PointN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumPatches (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumPatches (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumPatches (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumPatches (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumPatches (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PatchN (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PatchN (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PatchN (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PatchN (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PatchN (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_StartPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_StartPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_StartPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_StartPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_StartPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EndPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_EndPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EndPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EndPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EndPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsClosed (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsClosed (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsClosed (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsClosed (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsClosed (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsEmpty (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsEmpty (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsEmpty (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsEmpty (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsEmpty (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geometry, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geometry, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geometry, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geometry, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geometry, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WKTToSQL (text);
	RAISE NOTICE 'newly registered FUNCTION ST_WKTToSQL (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WKTToSQL (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WKTToSQL (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WKTToSQL (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineStringFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineStringFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineStringFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineStringFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineStringFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineStringFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineStringFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineStringFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineStringFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineStringFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolygonFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolygonFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolygonFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolygonFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolygonFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolygonFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolygonFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolygonFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolygonFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolygonFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromText (text, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromText (text, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromText (text, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromText (text, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromText (text, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LinestringFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_LinestringFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LinestringFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LinestringFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LinestringFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LinestringFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_LinestringFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LinestringFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LinestringFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LinestringFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SwapOrdinates (geom geometry, ords cstring);
	RAISE NOTICE 'newly registered FUNCTION ST_SwapOrdinates (geom geometry, ords cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SwapOrdinates (geom geometry, ords cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SwapOrdinates (geom geometry, ords cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SwapOrdinates (geom geometry, ords cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FlipCoordinates (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_FlipCoordinates (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FlipCoordinates (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FlipCoordinates (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FlipCoordinates (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BdPolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_BdPolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BdPolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BdPolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BdPolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BdMPolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_BdMPolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BdMPolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BdMPolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BdMPolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UnlockRows (text);
	RAISE NOTICE 'newly registered FUNCTION UnlockRows (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UnlockRows (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UnlockRows (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UnlockRows (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, text, timestamp);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, text, timestamp)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, text, timestamp)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, text, timestamp) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, text, timestamp) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, text);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, timestamp);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, timestamp)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, timestamp)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, timestamp) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, timestamp) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddAuth (text);
	RAISE NOTICE 'newly registered FUNCTION AddAuth (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddAuth (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddAuth (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddAuth (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuth (text, text, text);
	RAISE NOTICE 'newly registered FUNCTION CheckAuth (text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuth (text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuth (text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuth (text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuth (text, text);
	RAISE NOTICE 'newly registered FUNCTION CheckAuth (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuth (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuth (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuth (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuthTrigger ();
	RAISE NOTICE 'newly registered FUNCTION CheckAuthTrigger ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuthTrigger ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuthTrigger () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuthTrigger () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GetTransactionID ();
	RAISE NOTICE 'newly registered FUNCTION GetTransactionID ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GetTransactionID ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GetTransactionID () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GetTransactionID () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION EnableLongTransactions ();
	RAISE NOTICE 'newly registered FUNCTION EnableLongTransactions ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION EnableLongTransactions ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION EnableLongTransactions () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION EnableLongTransactions () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LongTransactionsEnabled ();
	RAISE NOTICE 'newly registered FUNCTION LongTransactionsEnabled ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LongTransactionsEnabled ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LongTransactionsEnabled () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LongTransactionsEnabled () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DisableLongTransactions ();
	RAISE NOTICE 'newly registered FUNCTION DisableLongTransactions ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DisableLongTransactions ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DisableLongTransactions () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DisableLongTransactions () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (geography, integer, boolean);
	RAISE NOTICE 'newly registered FUNCTION geography (geography, integer, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (geography, integer, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (geography, integer, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (geography, integer, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (bytea);
	RAISE NOTICE 'newly registered FUNCTION geography (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION bytea (geography);
	RAISE NOTICE 'newly registered FUNCTION bytea (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION bytea (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION bytea (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION bytea (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geography, int4);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geography, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geography, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geography, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geography, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeographyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeographyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeographyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeographyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeographyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeogFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeogFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeogFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeogFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeogFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeogFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeogFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeogFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeogFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeogFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_dims (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_dims (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_dims (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_dims (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_dims (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_srid (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_srid (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_srid (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_srid (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_srid (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_type (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_type (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_type (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_type (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_type (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (geometry);
	RAISE NOTICE 'newly registered FUNCTION geography (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (geography);
	RAISE NOTICE 'newly registered FUNCTION geometry (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_consistent (internal,geography,int4);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_consistent (internal,geography,int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_consistent (internal,geography,int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_consistent (internal,geography,int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_consistent (internal,geography,int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_compress (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_compress (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_compress (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_compress (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_compress (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_penalty (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_penalty (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_penalty (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_penalty (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_penalty (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_picksplit (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_picksplit (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_picksplit (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_picksplit (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_picksplit (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_union (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_union (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_union (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_union (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_union (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_same (box2d, box2d, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_same (box2d, box2d, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_same (box2d, box2d, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_same (box2d, box2d, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_same (box2d, box2d, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_decompress (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_decompress (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_decompress (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_decompress (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_decompress (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_overlaps (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_overlaps (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_overlaps (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_overlaps (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_overlaps (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_distance_knn (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_distance_knn (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_distance_knn (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_distance_knn (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_distance_knn (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_distance (internal, geography, int4);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_distance (internal, geography, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_distance (internal, geography, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_distance (internal, geography, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_distance (internal, geography, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (gidx, geography);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (gidx, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (gidx, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (gidx, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (gidx, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (gidx, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (gidx, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (gidx, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (gidx, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (gidx, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (geography, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (geography, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (geography, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (geography, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (geography, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_lt (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_lt (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_lt (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_lt (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_lt (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_le (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_le (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_le (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_le (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_le (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gt (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_gt (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gt (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gt (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gt (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_ge (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_ge (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_ge (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_ge (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_ge (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_eq (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_eq (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_eq (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_eq (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_eq (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_cmp (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_cmp (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_cmp (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_cmp (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_cmp (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (geog geography,rel int4 ,maxdecimaldigits int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (geog geography,rel int4 ,maxdecimaldigits int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (geog geography,rel int4 ,maxdecimaldigits int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (geog geography,rel int4 ,maxdecimaldigits int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (geog geography,rel int4 ,maxdecimaldigits int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsGML (int4, geography, int4, int4, text, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsGML (int4, geography, int4, int4, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsGML (int4, geography, int4, int4, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsGML (int4, geography, int4, int4, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsGML (int4, geography, int4, int4, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (geog geography, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (geog geography, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (geog geography, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (geog geography, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (geog geography, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (version int4, geog geography, maxdecimaldigits int4 , options int4 , nprefix text , id text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (version int4, geog geography, maxdecimaldigits int4 , options int4 , nprefix text , id text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (version int4, geog geography, maxdecimaldigits int4 , options int4 , nprefix text , id text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (version int4, geog geography, maxdecimaldigits int4 , options int4 , nprefix text , id text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (version int4, geog geography, maxdecimaldigits int4 , options int4 , nprefix text , id text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsKML (int4, geography, int4, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsKML (int4, geography, int4, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsKML (int4, geography, int4, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsKML (int4, geography, int4, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsKML (int4, geography, int4, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (geog geography, maxdecimaldigits int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (geog geography, maxdecimaldigits int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (geog geography, maxdecimaldigits int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (geog geography, maxdecimaldigits int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (geog geography, maxdecimaldigits int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (version int4, geog geography, maxdecimaldigits int4 , nprefix text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (version int4, geog geography, maxdecimaldigits int4 , nprefix text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (version int4, geog geography, maxdecimaldigits int4 , nprefix text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (version int4, geog geography, maxdecimaldigits int4 , nprefix text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (version int4, geog geography, maxdecimaldigits int4 , nprefix text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsGeoJson (int4, geography, int4, int4);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsGeoJson (int4, geography, int4, int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsGeoJson (int4, geography, int4, int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsGeoJson (int4, geography, int4, int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsGeoJson (int4, geography, int4, int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (gj_version int4, geog geography, maxdecimaldigits int4 , options int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (gj_version int4, geog geography, maxdecimaldigits int4 , options int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (gj_version int4, geog geography, maxdecimaldigits int4 , options int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (gj_version int4, geog geography, maxdecimaldigits int4 , options int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (gj_version int4, geog geography, maxdecimaldigits int4 , options int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Distance (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_Distance (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Distance (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Distance (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Distance (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithin (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithin (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithin (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithin (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithin (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (geography, geography, boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (geography, geography, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (geography, geography, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (geography, geography, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (geography, geography, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Expand (geography, float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_Expand (geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Expand (geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Expand (geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Expand (geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (geography, geography, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (geography, geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (geography, geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (geography, geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (geography, geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (text, text, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (text, text, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (text, text, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (text, text, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (text, text, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceTree (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceTree (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceTree (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceTree (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceTree (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceTree (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceTree (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceTree (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceTree (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceTree (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithinUnCached (geography, geography, float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithinUnCached (geography, geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithinUnCached (geography, geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithinUnCached (geography, geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithinUnCached (geography, geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Area (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Area (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Length (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Length (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Project (geog geography, distance float8, azimuth float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Project (geog geography, distance float8, azimuth float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Project (geog geography, distance float8, azimuth float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Project (geog geography, distance float8, azimuth float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Project (geog geography, distance float8, azimuth float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Azimuth (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Azimuth (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Azimuth (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Azimuth (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Azimuth (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Perimeter (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Perimeter (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Perimeter (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Perimeter (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Perimeter (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_PointOutside (geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_PointOutside (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_PointOutside (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_PointOutside (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_PointOutside (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Covers (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_Covers (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Covers (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Covers (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Covers (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Segmentize (geog geography, max_segment_length float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Segmentize (geog geography, max_segment_length float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Segmentize (geog geography, max_segment_length float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Segmentize (geog geography, max_segment_length float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Segmentize (geog geography, max_segment_length float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_BestSRID (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_BestSRID (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_BestSRID (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_BestSRID (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_BestSRID (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_BestSRID (geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_BestSRID (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_BestSRID (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_BestSRID (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_BestSRID (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geography,text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geography,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geography,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geography,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geography,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeometryType (geography);
	RAISE NOTICE 'newly registered FUNCTION GeometryType (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeometryType (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeometryType (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeometryType (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Summary (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Summary (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Summary (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Summary (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Summary (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeoHash (geog geography, maxchars int4 );
	RAISE NOTICE 'newly registered FUNCTION ST_GeoHash (geog geography, maxchars int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeoHash (geog geography, maxchars int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeoHash (geog geography, maxchars int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeoHash (geog geography, maxchars int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SRID (geog geography);
	RAISE NOTICE 'newly registered FUNCTION ST_SRID (geog geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SRID (geog geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SRID (geog geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SRID (geog geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetSRID (geog geography, srid int4);
	RAISE NOTICE 'newly registered FUNCTION ST_SetSRID (geog geography, srid int4)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetSRID (geog geography, srid int4)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetSRID (geog geography, srid int4) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetSRID (geog geography, srid int4) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_distance_sphere (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_distance_sphere (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_distance_sphere (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_distance_sphere (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_distance_sphere (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean );
	RAISE NOTICE 'newly registered FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoordDim (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CoordDim (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoordDim (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoordDim (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoordDim (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer );
	RAISE NOTICE 'newly registered FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HasArc (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_HasArc (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HasArc (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HasArc (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HasArc (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineToCurve (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineToCurve (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineToCurve (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineToCurve (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineToCurve (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_OrderingEquals (GeometryA geometry, GeometryB geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_OrderingEquals (GeometryA geometry, GeometryB geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_OrderingEquals (GeometryA geometry, GeometryB geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_OrderingEquals (GeometryA geometry, GeometryB geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_OrderingEquals (GeometryA geometry, GeometryB geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OrderingEquals (GeometryA geometry, GeometryB geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_OrderingEquals (GeometryA geometry, GeometryB geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OrderingEquals (GeometryA geometry, GeometryB geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OrderingEquals (GeometryA geometry, GeometryB geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OrderingEquals (GeometryA geometry, GeometryB geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Point (float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Point (float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Point (float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Point (float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Point (float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Polygon (geometry, int);
	RAISE NOTICE 'newly registered FUNCTION ST_Polygon (geometry, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Polygon (geometry, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Polygon (geometry, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Polygon (geometry, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WKBToSQL (WKB bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_WKBToSQL (WKB bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WKBToSQL (WKB bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WKBToSQL (WKB bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WKBToSQL (WKB bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_InterpolatePoint (Line geometry, Point geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_InterpolatePoint (Line geometry, Point geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_InterpolatePoint (Line geometry, Point geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_InterpolatePoint (Line geometry, Point geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_InterpolatePoint (Line geometry, Point geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (gidx, geometry);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (gidx, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (gidx, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (gidx, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (gidx, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (gidx, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (gidx, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (gidx, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (gidx, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (gidx, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (geometry, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (geometry, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (geometry, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (geometry, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (geometry, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_concavehull (param_inputgeom geometry);
	RAISE NOTICE 'newly registered FUNCTION _st_concavehull (param_inputgeom geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_concavehull (param_inputgeom geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_concavehull (param_inputgeom geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_concavehull (param_inputgeom geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsX3D (int4, geometry, int4, int4, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsX3D (int4, geometry, int4, int4, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsX3D (int4, geometry, int4, int4, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsX3D (int4, geometry, int4, int4, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsX3D (int4, geometry, int4, int4, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Angle (line1 geometry, line2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Angle (line1 geometry, line2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Angle (line1 geometry, line2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Angle (line1 geometry, line2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Angle (line1 geometry, line2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_config_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_config_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_config_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_config_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_config_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_choose_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_choose_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_choose_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_choose_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_choose_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_picksplit_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_picksplit_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_picksplit_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_picksplit_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_picksplit_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_inner_consistent_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_inner_consistent_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_inner_consistent_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_inner_consistent_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_inner_consistent_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_compress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_compress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_compress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_compress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_compress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_config_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_config_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_config_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_config_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_config_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_choose_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_choose_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_choose_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_choose_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_choose_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_picksplit_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_picksplit_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_picksplit_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_picksplit_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_picksplit_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_inner_consistent_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_inner_consistent_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_inner_consistent_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_inner_consistent_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_inner_consistent_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_compress_3d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_compress_3d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_compress_3d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_compress_3d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_compress_3d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_raster_lib_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_raster_lib_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_raster_lib_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_raster_lib_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_raster_lib_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_raster_scripts_installed ();
	RAISE NOTICE 'newly registered FUNCTION postgis_raster_scripts_installed ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_raster_scripts_installed ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_raster_scripts_installed () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_raster_scripts_installed () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_raster_lib_build_date ();
	RAISE NOTICE 'newly registered FUNCTION postgis_raster_lib_build_date ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_raster_lib_build_date ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_raster_lib_build_date () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_raster_lib_build_date () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_gdal_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_gdal_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_gdal_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_gdal_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_gdal_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_envelope (raster);
	RAISE NOTICE 'newly registered FUNCTION st_envelope (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_envelope (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_envelope (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_envelope (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_convexhull (raster);
	RAISE NOTICE 'newly registered FUNCTION st_convexhull (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_convexhull (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_convexhull (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_convexhull (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_minconvexhull (
	rast raster,
	nband integer );
	RAISE NOTICE 'newly registered FUNCTION st_minconvexhull (
	rast raster,
	nband integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_minconvexhull (
	rast raster,
	nband integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_minconvexhull (
	rast raster,
	nband integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_minconvexhull (
	rast raster,
	nband integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d (raster);
	RAISE NOTICE 'newly registered FUNCTION box3d (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_height (raster);
	RAISE NOTICE 'newly registered FUNCTION st_height (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_height (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_height (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_height (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_numbands (raster);
	RAISE NOTICE 'newly registered FUNCTION st_numbands (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_numbands (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_numbands (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_numbands (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_scalex (raster);
	RAISE NOTICE 'newly registered FUNCTION st_scalex (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_scalex (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_scalex (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_scalex (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_scaley (raster);
	RAISE NOTICE 'newly registered FUNCTION st_scaley (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_scaley (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_scaley (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_scaley (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_skewx (raster);
	RAISE NOTICE 'newly registered FUNCTION st_skewx (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_skewx (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_skewx (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_skewx (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_skewy (raster);
	RAISE NOTICE 'newly registered FUNCTION st_skewy (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_skewy (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_skewy (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_skewy (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_srid (raster);
	RAISE NOTICE 'newly registered FUNCTION st_srid (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_srid (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_srid (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_srid (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_upperleftx (raster);
	RAISE NOTICE 'newly registered FUNCTION st_upperleftx (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_upperleftx (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_upperleftx (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_upperleftx (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_upperlefty (raster);
	RAISE NOTICE 'newly registered FUNCTION st_upperlefty (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_upperlefty (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_upperlefty (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_upperlefty (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_width (raster);
	RAISE NOTICE 'newly registered FUNCTION st_width (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_width (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_width (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_width (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_pixelwidth (raster);
	RAISE NOTICE 'newly registered FUNCTION st_pixelwidth (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_pixelwidth (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_pixelwidth (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_pixelwidth (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_pixelheight (raster);
	RAISE NOTICE 'newly registered FUNCTION st_pixelheight (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_pixelheight (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_pixelheight (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_pixelheight (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_geotransform (raster,
    OUT imag double precision,
    OUT jmag double precision,
    OUT theta_i double precision,
    OUT theta_ij double precision,
    OUT xoffset double precision,
    OUT yoffset double precision);
	RAISE NOTICE 'newly registered FUNCTION st_geotransform (raster,
    OUT imag double precision,
    OUT jmag double precision,
    OUT theta_i double precision,
    OUT theta_ij double precision,
    OUT xoffset double precision,
    OUT yoffset double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_geotransform (raster,
    OUT imag double precision,
    OUT jmag double precision,
    OUT theta_i double precision,
    OUT theta_ij double precision,
    OUT xoffset double precision,
    OUT yoffset double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_geotransform (raster,
    OUT imag double precision,
    OUT jmag double precision,
    OUT theta_i double precision,
    OUT theta_ij double precision,
    OUT xoffset double precision,
    OUT yoffset double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_geotransform (raster,
    OUT imag double precision,
    OUT jmag double precision,
    OUT theta_i double precision,
    OUT theta_ij double precision,
    OUT xoffset double precision,
    OUT yoffset double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_rotation (raster);
	RAISE NOTICE 'newly registered FUNCTION st_rotation (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_rotation (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_rotation (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_rotation (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_metadata (
	rast raster,
	OUT upperleftx double precision,
	OUT upperlefty double precision,
	OUT width int,
	OUT height int,
	OUT scalex double precision,
	OUT scaley double precision,
	OUT skewx double precision,
	OUT skewy double precision,
	OUT srid int,
	OUT numbands int
);
	RAISE NOTICE 'newly registered FUNCTION st_metadata (
	rast raster,
	OUT upperleftx double precision,
	OUT upperlefty double precision,
	OUT width int,
	OUT height int,
	OUT scalex double precision,
	OUT scaley double precision,
	OUT skewx double precision,
	OUT skewy double precision,
	OUT srid int,
	OUT numbands int
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_metadata (
	rast raster,
	OUT upperleftx double precision,
	OUT upperlefty double precision,
	OUT width int,
	OUT height int,
	OUT scalex double precision,
	OUT scaley double precision,
	OUT skewx double precision,
	OUT skewy double precision,
	OUT srid int,
	OUT numbands int
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_metadata (
	rast raster,
	OUT upperleftx double precision,
	OUT upperlefty double precision,
	OUT width int,
	OUT height int,
	OUT scalex double precision,
	OUT scaley double precision,
	OUT skewx double precision,
	OUT skewy double precision,
	OUT srid int,
	OUT numbands int
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_metadata (
	rast raster,
	OUT upperleftx double precision,
	OUT upperlefty double precision,
	OUT width int,
	OUT height int,
	OUT scalex double precision,
	OUT scaley double precision,
	OUT skewx double precision,
	OUT skewy double precision,
	OUT srid int,
	OUT numbands int
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_summary (rast raster);
	RAISE NOTICE 'newly registered FUNCTION st_summary (rast raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_summary (rast raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_summary (rast raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_summary (rast raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MemSize (raster);
	RAISE NOTICE 'newly registered FUNCTION ST_MemSize (raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MemSize (raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MemSize (raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MemSize (raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid int4 );
	RAISE NOTICE 'newly registered FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid int4 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid int4 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid int4 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid int4 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8);
	RAISE NOTICE 'newly registered FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_makeemptyraster (rast raster);
	RAISE NOTICE 'newly registered FUNCTION st_makeemptyraster (rast raster)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_makeemptyraster (rast raster)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_makeemptyraster (rast raster) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_makeemptyraster (rast raster) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (rast raster, addbandargset addbandarg[]);
	RAISE NOTICE 'newly registered FUNCTION st_addband (rast raster, addbandargset addbandarg[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (rast raster, addbandargset addbandarg[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (rast raster, addbandargset addbandarg[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (rast raster, addbandargset addbandarg[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	rast raster,
	index int,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	rast raster,
	index int,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	rast raster,
	index int,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	rast raster,
	index int,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	rast raster,
	index int,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	rast raster,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	rast raster,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	rast raster,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	rast raster,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	rast raster,
	pixeltype text,
	initialvalue float8 ,
	nodataval float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	torast raster,
	fromrast raster,
	fromband int ,
	torastindex int );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	torast raster,
	fromrast raster,
	fromband int ,
	torastindex int )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	torast raster,
	fromrast raster,
	fromband int ,
	torastindex int )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	torast raster,
	fromrast raster,
	fromband int ,
	torastindex int ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	torast raster,
	fromrast raster,
	fromband int ,
	torastindex int ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	torast raster,
	fromrasts raster[], fromband integer ,
	torastindex int );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	torast raster,
	fromrasts raster[], fromband integer ,
	torastindex int )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	torast raster,
	fromrasts raster[], fromband integer ,
	torastindex int )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	torast raster,
	fromrasts raster[], fromband integer ,
	torastindex int ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	torast raster,
	fromrasts raster[], fromband integer ,
	torastindex int ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	rast raster,
	index int,
	outdbfile text, outdbindex int[],
	nodataval double precision );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	rast raster,
	index int,
	outdbfile text, outdbindex int[],
	nodataval double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	rast raster,
	index int,
	outdbfile text, outdbindex int[],
	nodataval double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	rast raster,
	index int,
	outdbfile text, outdbindex int[],
	nodataval double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	rast raster,
	index int,
	outdbfile text, outdbindex int[],
	nodataval double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_addband (
	rast raster,
	outdbfile text, outdbindex int[],
	index int ,
	nodataval double precision );
	RAISE NOTICE 'newly registered FUNCTION st_addband (
	rast raster,
	outdbfile text, outdbindex int[],
	index int ,
	nodataval double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_addband (
	rast raster,
	outdbfile text, outdbindex int[],
	index int ,
	nodataval double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_addband (
	rast raster,
	outdbfile text, outdbindex int[],
	index int ,
	nodataval double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_addband (
	rast raster,
	outdbfile text, outdbindex int[],
	index int ,
	nodataval double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_band (rast raster, nbands int[] );
	RAISE NOTICE 'newly registered FUNCTION st_band (rast raster, nbands int[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_band (rast raster, nbands int[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_band (rast raster, nbands int[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_band (rast raster, nbands int[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_band (rast raster, nband int);
	RAISE NOTICE 'newly registered FUNCTION st_band (rast raster, nband int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_band (rast raster, nband int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_band (rast raster, nband int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_band (rast raster, nband int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_band (rast raster, nbands text, delimiter char );
	RAISE NOTICE 'newly registered FUNCTION st_band (rast raster, nbands text, delimiter char )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_band (rast raster, nbands text, delimiter char )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_band (rast raster, nbands text, delimiter char ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_band (rast raster, nbands text, delimiter char ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean );
	RAISE NOTICE 'newly registered FUNCTION st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_summarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_summarystats (
	rast raster,
	exclude_nodata_value boolean
);
	RAISE NOTICE 'newly registered FUNCTION st_summarystats (
	rast raster,
	exclude_nodata_value boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_summarystats (
	rast raster,
	exclude_nodata_value boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_summarystats (
	rast raster,
	exclude_nodata_value boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_summarystats (
	rast raster,
	exclude_nodata_value boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rast raster,
	nband int,
	sample_percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rast raster,
	nband int,
	sample_percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rast raster,
	nband int,
	sample_percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rast raster,
	nband int,
	sample_percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rast raster,
	nband int,
	sample_percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rast raster,
	exclude_nodata_value boolean,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rast raster,
	exclude_nodata_value boolean,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rast raster,
	exclude_nodata_value boolean,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rast raster,
	exclude_nodata_value boolean,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rast raster,
	exclude_nodata_value boolean,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rast raster,
	sample_percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rast raster,
	sample_percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rast raster,
	sample_percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rast raster,
	sample_percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rast raster,
	sample_percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats_transfn (
	internal,
	raster, integer,
	boolean, double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, integer,
	boolean, double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, integer,
	boolean, double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats_transfn (
	internal,
	raster, integer,
	boolean, double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats_transfn (
	internal,
	raster, integer,
	boolean, double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats_transfn (
	internal,
	raster, boolean, double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, boolean, double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, boolean, double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats_transfn (
	internal,
	raster, boolean, double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats_transfn (
	internal,
	raster, boolean, double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats_transfn (
	internal,
	raster, int, boolean
);
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, int, boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats_transfn (
	internal,
	raster, int, boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats_transfn (
	internal,
	raster, int, boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats_transfn (
	internal,
	raster, int, boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION _st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean );
	RAISE NOTICE 'newly registered FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
);
	RAISE NOTICE 'newly registered FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_summarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer,
	sample_percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer,
	sample_percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer,
	sample_percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer,
	sample_percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	nband integer,
	sample_percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
);
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	exclude_nodata_value boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	sample_percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	sample_percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	sample_percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	sample_percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxsummarystats (
	rastertable text,
	rastercolumn text,
	sample_percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean );
	RAISE NOTICE 'newly registered FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_count (rast raster, exclude_nodata_value boolean);
	RAISE NOTICE 'newly registered FUNCTION st_count (rast raster, exclude_nodata_value boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_count (rast raster, exclude_nodata_value boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_count (rast raster, exclude_nodata_value boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_count (rast raster, exclude_nodata_value boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rast raster, sample_percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rast raster, sample_percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rast raster, sample_percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rast raster, sample_percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rast raster, sample_percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_countagg_finalfn (agg agg_count);
	RAISE NOTICE 'newly registered FUNCTION _st_countagg_finalfn (agg agg_count)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_countagg_finalfn (agg agg_count)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_countagg_finalfn (agg agg_count) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_countagg_finalfn (agg agg_count) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION __st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer , exclude_nodata_value boolean ,
	sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION __st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer , exclude_nodata_value boolean ,
	sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION __st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer , exclude_nodata_value boolean ,
	sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION __st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer , exclude_nodata_value boolean ,
	sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION __st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer , exclude_nodata_value boolean ,
	sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean,
	sample_percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean,
	sample_percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean,
	sample_percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean,
	sample_percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean,
	sample_percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean
);
	RAISE NOTICE 'newly registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	nband integer, exclude_nodata_value boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	exclude_nodata_value boolean
);
	RAISE NOTICE 'newly registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	exclude_nodata_value boolean
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	exclude_nodata_value boolean
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	exclude_nodata_value boolean
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_countagg_transfn (
	agg agg_count,
	rast raster,
 	exclude_nodata_value boolean
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_count (rastertable text, rastercolumn text, nband integer , exclude_nodata_value boolean , sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION _st_count (rastertable text, rastercolumn text, nband integer , exclude_nodata_value boolean , sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_count (rastertable text, rastercolumn text, nband integer , exclude_nodata_value boolean , sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_count (rastertable text, rastercolumn text, nband integer , exclude_nodata_value boolean , sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_count (rastertable text, rastercolumn text, nband integer , exclude_nodata_value boolean , sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_count (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean );
	RAISE NOTICE 'newly registered FUNCTION st_count (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_count (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_count (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_count (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_count (rastertable text, rastercolumn text, exclude_nodata_value boolean);
	RAISE NOTICE 'newly registered FUNCTION st_count (rastertable text, rastercolumn text, exclude_nodata_value boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_count (rastertable text, rastercolumn text, exclude_nodata_value boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_count (rastertable text, rastercolumn text, exclude_nodata_value boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_count (rastertable text, rastercolumn text, exclude_nodata_value boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean , sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean , sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean , sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean , sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int , exclude_nodata_value boolean , sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int, sample_percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int, sample_percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int, sample_percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int, sample_percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rastertable text, rastercolumn text, nband int, sample_percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rastertable text, rastercolumn text, exclude_nodata_value boolean, sample_percent double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rastertable text, rastercolumn text, exclude_nodata_value boolean, sample_percent double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rastertable text, rastercolumn text, exclude_nodata_value boolean, sample_percent double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rastertable text, rastercolumn text, exclude_nodata_value boolean, sample_percent double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rastertable text, rastercolumn text, exclude_nodata_value boolean, sample_percent double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxcount (rastertable text, rastercolumn text, sample_percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxcount (rastertable text, rastercolumn text, sample_percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxcount (rastertable text, rastercolumn text, sample_percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxcount (rastertable text, rastercolumn text, sample_percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxcount (rastertable text, rastercolumn text, sample_percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	min double precision , max double precision ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	min double precision , max double precision ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	min double precision , max double precision ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	min double precision , max double precision ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	min double precision , max double precision ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rast raster, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rast raster, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rast raster, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rast raster, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rast raster, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rast raster, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rast raster, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rast raster, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rast raster, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rast raster, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster, nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rast raster, nband int,
	sample_percent double precision,
	bins int, right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_histogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_histogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_histogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_histogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_histogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int ,
	exclude_nodata_value boolean ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_histogram (
	rastertable text, rastercolumn text, nband int,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	bins int , width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	exclude_nodata_value boolean,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text,
	sample_percent double precision,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int, width double precision[] ,
	right boolean ,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxhistogram (
	rastertable text, rastercolumn text, nband int,
	sample_percent double precision,
	bins int,
	right boolean,
	OUT min double precision,
	OUT max double precision,
	OUT count bigint,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rast raster,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rast raster,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rast raster,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rast raster,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rast raster,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rast raster, nband int, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rast raster, nband int, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rast raster, nband int, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rast raster, nband int, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rast raster, nband int, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision );
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rast raster, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rast raster, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rast raster, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rast raster, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rast raster, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rast raster,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rast raster,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rast raster,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rast raster,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rast raster,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rast raster,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rast raster,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rast raster,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rast raster,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rast raster,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rast raster,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rast raster,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rast raster, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rast raster, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rast raster, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rast raster, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rast raster, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	nband int,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rastertable text, rastercolumn text, nband int, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision );
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_quantile (rastertable text, rastercolumn text, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_quantile (rastertable text, rastercolumn text, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_quantile (rastertable text, rastercolumn text, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_quantile (rastertable text, rastercolumn text, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_quantile (rastertable text, rastercolumn text, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int ,
	exclude_nodata_value boolean ,
	sample_percent double precision ,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	nband int,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	sample_percent double precision,
	quantiles double precision[] ,
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (
	rastertable text,
	rastercolumn text,
	quantiles double precision[],
	OUT quantile double precision,
	OUT value double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rastertable text, rastercolumn text, sample_percent double precision, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, sample_percent double precision, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, sample_percent double precision, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rastertable text, rastercolumn text, sample_percent double precision, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rastertable text, rastercolumn text, sample_percent double precision, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision );
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_approxquantile (rastertable text, rastercolumn text, quantile double precision);
	RAISE NOTICE 'newly registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, quantile double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_approxquantile (rastertable text, rastercolumn text, quantile double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_approxquantile (rastertable text, rastercolumn text, quantile double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_approxquantile (rastertable text, rastercolumn text, quantile double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (
	rast raster, nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_valuecount (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION _st_valuecount (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_valuecount (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_valuecount (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_valuecount (
	rastertable text,
	rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision,
	OUT count integer,
	OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT count integer
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (
	rastertable text, rastercolumn text,
	nband integer ,
	exclude_nodata_value boolean ,
	searchvalues double precision[] ,
	roundto double precision ,
	OUT value double precision, OUT percent double precision
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );
	RAISE NOTICE 'newly registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);
	RAISE NOTICE 'newly registered FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);
	RAISE NOTICE 'newly registered FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision );
	RAISE NOTICE 'newly registered FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text);
	RAISE NOTICE 'newly registered FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_colormap (
	rast raster, nband int,
	colormap text,
	method text );
	RAISE NOTICE 'newly registered FUNCTION _st_colormap (
	rast raster, nband int,
	colormap text,
	method text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_colormap (
	rast raster, nband int,
	colormap text,
	method text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_colormap (
	rast raster, nband int,
	colormap text,
	method text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_colormap (
	rast raster, nband int,
	colormap text,
	method text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_colormap (
	rast raster, nband int ,
	colormap text ,
	method text );
	RAISE NOTICE 'newly registered FUNCTION st_colormap (
	rast raster, nband int ,
	colormap text ,
	method text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_colormap (
	rast raster, nband int ,
	colormap text ,
	method text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_colormap (
	rast raster, nband int ,
	colormap text ,
	method text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_colormap (
	rast raster, nband int ,
	colormap text ,
	method text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_colormap (
	rast raster,
	colormap text,
	method text );
	RAISE NOTICE 'newly registered FUNCTION st_colormap (
	rast raster,
	colormap text,
	method text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_colormap (
	rast raster,
	colormap text,
	method text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_colormap (
	rast raster,
	colormap text,
	method text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_colormap (
	rast raster,
	colormap text,
	method text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_fromgdalraster (gdaldata bytea, srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_fromgdalraster (gdaldata bytea, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_fromgdalraster (gdaldata bytea, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_fromgdalraster (gdaldata bytea, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_fromgdalraster (gdaldata bytea, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_gdaldrivers (
	OUT idx int,
	OUT short_name text,
	OUT long_name text,
	OUT can_read boolean,
	OUT can_write boolean,
	OUT create_options text
);
	RAISE NOTICE 'newly registered FUNCTION st_gdaldrivers (
	OUT idx int,
	OUT short_name text,
	OUT long_name text,
	OUT can_read boolean,
	OUT can_write boolean,
	OUT create_options text
)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_gdaldrivers (
	OUT idx int,
	OUT short_name text,
	OUT long_name text,
	OUT can_read boolean,
	OUT can_write boolean,
	OUT create_options text
)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_gdaldrivers (
	OUT idx int,
	OUT short_name text,
	OUT long_name text,
	OUT can_read boolean,
	OUT can_write boolean,
	OUT create_options text
) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_gdaldrivers (
	OUT idx int,
	OUT short_name text,
	OUT long_name text,
	OUT can_read boolean,
	OUT can_write boolean,
	OUT create_options text
) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_astiff (rast raster, options text[] , srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_astiff (rast raster, options text[] , srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_astiff (rast raster, options text[] , srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_astiff (rast raster, options text[] , srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_astiff (rast raster, options text[] , srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_astiff (rast raster, compression text, srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_astiff (rast raster, compression text, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_astiff (rast raster, compression text, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_astiff (rast raster, compression text, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_astiff (rast raster, compression text, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer );
	RAISE NOTICE 'newly registered FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asjpeg (rast raster, options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_asjpeg (rast raster, options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asjpeg (rast raster, options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asjpeg (rast raster, options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asjpeg (rast raster, options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asjpeg (rast raster, nbands int[], options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_asjpeg (rast raster, nbands int[], options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asjpeg (rast raster, nbands int[], options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asjpeg (rast raster, nbands int[], options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asjpeg (rast raster, nbands int[], options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asjpeg (rast raster, nbands int[], quality int);
	RAISE NOTICE 'newly registered FUNCTION st_asjpeg (rast raster, nbands int[], quality int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asjpeg (rast raster, nbands int[], quality int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asjpeg (rast raster, nbands int[], quality int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asjpeg (rast raster, nbands int[], quality int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asjpeg (rast raster, nband int, options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_asjpeg (rast raster, nband int, options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asjpeg (rast raster, nband int, options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asjpeg (rast raster, nband int, options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asjpeg (rast raster, nband int, options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asjpeg (rast raster, nband int, quality int);
	RAISE NOTICE 'newly registered FUNCTION st_asjpeg (rast raster, nband int, quality int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asjpeg (rast raster, nband int, quality int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asjpeg (rast raster, nband int, quality int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asjpeg (rast raster, nband int, quality int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_aspng (rast raster, options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_aspng (rast raster, options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_aspng (rast raster, options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_aspng (rast raster, options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_aspng (rast raster, options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_aspng (rast raster, nbands int[], options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_aspng (rast raster, nbands int[], options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_aspng (rast raster, nbands int[], options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_aspng (rast raster, nbands int[], options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_aspng (rast raster, nbands int[], options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_aspng (rast raster, nbands int[], compression int);
	RAISE NOTICE 'newly registered FUNCTION st_aspng (rast raster, nbands int[], compression int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_aspng (rast raster, nbands int[], compression int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_aspng (rast raster, nbands int[], compression int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_aspng (rast raster, nbands int[], compression int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_aspng (rast raster, nband int, options text[] );
	RAISE NOTICE 'newly registered FUNCTION st_aspng (rast raster, nband int, options text[] )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_aspng (rast raster, nband int, options text[] )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_aspng (rast raster, nband int, options text[] ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_aspng (rast raster, nband int, options text[] ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_aspng (rast raster, nband int, compression int);
	RAISE NOTICE 'newly registered FUNCTION st_aspng (rast raster, nband int, compression int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_aspng (rast raster, nband int, compression int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_aspng (rast raster, nband int, compression int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_aspng (rast raster, nband int, compression int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _st_asraster (
	geom geometry,
	scalex double precision , scaley double precision ,
	width integer , height integer ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION _st_asraster (
	geom geometry,
	scalex double precision , scaley double precision ,
	width integer , height integer ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _st_asraster (
	geom geometry,
	scalex double precision , scaley double precision ,
	width integer , height integer ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _st_asraster (
	geom geometry,
	scalex double precision , scaley double precision ,
	width integer , height integer ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _st_asraster (
	geom geometry,
	scalex double precision , scaley double precision ,
	width integer , height integer ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text[],
	value double precision[] ,
	nodataval double precision[] ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	scalex double precision, scaley double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	gridx double precision, gridy double precision,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	width integer, height integer,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	upperleftx double precision , upperlefty double precision ,
	skewx double precision , skewy double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text[] ,
	value double precision[] ,
	nodataval double precision[] ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	touched boolean );
	RAISE NOTICE 'newly registered FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	touched boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	touched boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	touched boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_asraster (
	geom geometry,
	ref raster,
	pixeltype text,
	value double precision ,
	nodataval double precision ,
	touched boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_gdalwarp (
	rast raster,
	algorithm text , maxerr double precision ,
	srid integer ,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	width integer , height integer );
	RAISE NOTICE 'newly registered FUNCTION _ST_gdalwarp (
	rast raster,
	algorithm text , maxerr double precision ,
	srid integer ,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	width integer , height integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_gdalwarp (
	rast raster,
	algorithm text , maxerr double precision ,
	srid integer ,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	width integer , height integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_gdalwarp (
	rast raster,
	algorithm text , maxerr double precision ,
	srid integer ,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	width integer , height integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_gdalwarp (
	rast raster,
	algorithm text , maxerr double precision ,
	srid integer ,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	width integer , height integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_resample (
	rast raster,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_resample (
	rast raster,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_resample (
	rast raster,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_resample (
	rast raster,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_resample (
	rast raster,
	scalex double precision , scaley double precision ,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_resample (
	rast raster,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_resample (
	rast raster,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_resample (
	rast raster,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_resample (
	rast raster,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_resample (
	rast raster,
	width integer, height integer,
	gridx double precision , gridy double precision ,
	skewx double precision , skewy double precision ,
	algorithm text , maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_resample (
	rast raster,
	ref raster,
	algorithm text ,
	maxerr double precision ,
	usescale boolean );
	RAISE NOTICE 'newly registered FUNCTION st_resample (
	rast raster,
	ref raster,
	algorithm text ,
	maxerr double precision ,
	usescale boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_resample (
	rast raster,
	ref raster,
	algorithm text ,
	maxerr double precision ,
	usescale boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_resample (
	rast raster,
	ref raster,
	algorithm text ,
	maxerr double precision ,
	usescale boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_resample (
	rast raster,
	ref raster,
	algorithm text ,
	maxerr double precision ,
	usescale boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_resample (
	rast raster,
	ref raster,
	usescale boolean,
	algorithm text ,
	maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_resample (
	rast raster,
	ref raster,
	usescale boolean,
	algorithm text ,
	maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_resample (
	rast raster,
	ref raster,
	usescale boolean,
	algorithm text ,
	maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_resample (
	rast raster,
	ref raster,
	usescale boolean,
	algorithm text ,
	maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_resample (
	rast raster,
	ref raster,
	usescale boolean,
	algorithm text ,
	maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision );
	RAISE NOTICE 'newly registered FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_transform (
	rast raster,
	alignto raster,
	algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_transform (
	rast raster,
	alignto raster,
	algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_transform (
	rast raster,
	alignto raster,
	algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_transform (
	rast raster,
	alignto raster,
	algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_transform (
	rast raster,
	alignto raster,
	algorithm text , maxerr double precision ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision );
	RAISE NOTICE 'newly registered FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr