# /*##########################################################################
#
# Copyright (c) 2016-2018 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/
"""This package provides a set of Qt widgets.

It contains the following sub-packages and modules:

- silx.gui.colors: Functions to handle colors and colormap
- silx.gui.console: IPython console widget
- silx.gui.data:
  Widgets for displaying data arrays using table views and plot widgets
- silx.gui.dialog: Specific dialog widgets
- silx.gui.fit: Widgets for controlling curve fitting
- silx.gui.hdf5: Widgets for displaying content relative to HDF5 format
- silx.gui.icons: Functions to access embedded icons
- silx.gui.plot: Widgets for 1D and 2D plotting and related tools
- silx.gui.plot3d: Widgets for visualizing data in 3D based on OpenGL
- silx.gui.printer: Shared printer used by the library
- silx.gui.qt: Common wrapper over different Python Qt binding
- silx.gui.utils: Miscellaneous helpers for Qt
- silx.gui.widgets: Miscellaneous standalone widgets

See silx documentation: http://www.silx.org/doc/silx/latest/
"""

__authors__ = ["T. Vincent"]
__license__ = "MIT"
__date__ = "23/05/2016"
