'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.length-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(2) /* ./index */, exports);
    // TODO: remove this when models are split up from core
    require(91) /* ./models/main */;
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.__extends = __extends;
    exports.__rest = __rest;
    exports.__decorate = __decorate;
    exports.__param = __param;
    exports.__esDecorate = __esDecorate;
    exports.__runInitializers = __runInitializers;
    exports.__propKey = __propKey;
    exports.__setFunctionName = __setFunctionName;
    exports.__metadata = __metadata;
    exports.__awaiter = __awaiter;
    exports.__generator = __generator;
    exports.__exportStar = __exportStar;
    exports.__values = __values;
    exports.__read = __read;
    exports.__spread = __spread;
    exports.__spreadArrays = __spreadArrays;
    exports.__spreadArray = __spreadArray;
    exports.__await = __await;
    exports.__asyncGenerator = __asyncGenerator;
    exports.__asyncDelegator = __asyncDelegator;
    exports.__asyncValues = __asyncValues;
    exports.__makeTemplateObject = __makeTemplateObject;
    exports.__importStar = __importStar;
    exports.__importDefault = __importDefault;
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
    exports.__classPrivateFieldIn = __classPrivateFieldIn;
    exports.__addDisposableResource = __addDisposableResource;
    exports.__disposeResources = __disposeResources;
    exports.__rewriteRelativeImportExtension = __rewriteRelativeImportExtension;
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
        function accept(f) {
            if (f !== void 0 && typeof f !== "function")
                throw new TypeError("Function expected");
            return f;
        }
        var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
        var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
        var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
        var _, done = false;
        for (var i = decorators.length - 1; i >= 0; i--) {
            var context = {};
            for (var p in contextIn)
                context[p] = p === "access" ? {} : contextIn[p];
            for (var p in contextIn.access)
                context.access[p] = contextIn.access[p];
            context.addInitializer = function (f) {
                if (done)
                    throw new TypeError("Cannot add initializers after decoration has completed");
                extraInitializers.push(accept(f || null));
            };
            var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
            if (kind === "accessor") {
                if (result === void 0)
                    continue;
                if (result === null || typeof result !== "object")
                    throw new TypeError("Object expected");
                if (_ = accept(result.get))
                    descriptor.get = _;
                if (_ = accept(result.set))
                    descriptor.set = _;
                if (_ = accept(result.init))
                    initializers.unshift(_);
            }
            else if (_ = accept(result)) {
                if (kind === "field")
                    initializers.unshift(_);
                else
                    descriptor[key] = _;
            }
        }
        if (target)
            Object.defineProperty(target, contextIn.name, descriptor);
        done = true;
    }
    ;
    function __runInitializers(thisArg, initializers, value) {
        var useValue = arguments.length > 2;
        for (var i = 0; i < initializers.length; i++) {
            value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
        }
        return useValue ? value : void 0;
    }
    ;
    function __propKey(x) {
        return typeof x === "symbol" ? x : "".concat(x);
    }
    ;
    function __setFunctionName(f, name, prefix) {
        if (typeof name === "symbol")
            name = name.description ? "[".concat(name.description, "]") : "";
        return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    }
    ;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
        return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (g && (g = 0, op[0] && (_ = 0)), _)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                (0, exports.__createBinding)(o, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
        function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
        function verb(n, f) {
            if (g[n]) {
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
                if (f)
                    i[n] = f(i[n]);
            }
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    var ownKeys = function (o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o)
                if (Object.prototype.hasOwnProperty.call(o, k))
                    ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k = ownKeys(mod), i = 0; i < k.length; i++)
                if (k[i] !== "default")
                    (0, exports.__createBinding)(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    function __classPrivateFieldIn(state, receiver) {
        if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function"))
            throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
    }
    function __addDisposableResource(env, value, async) {
        if (value !== null && value !== void 0) {
            if (typeof value !== "object" && typeof value !== "function")
                throw new TypeError("Object expected.");
            var dispose, inner;
            if (async) {
                if (!Symbol.asyncDispose)
                    throw new TypeError("Symbol.asyncDispose is not defined.");
                dispose = value[Symbol.asyncDispose];
            }
            if (dispose === void 0) {
                if (!Symbol.dispose)
                    throw new TypeError("Symbol.dispose is not defined.");
                dispose = value[Symbol.dispose];
                if (async)
                    inner = dispose;
            }
            if (typeof dispose !== "function")
                throw new TypeError("Object not disposable.");
            if (inner)
                dispose = function () {
                    try {
                        inner.call(this);
                    }
                    catch (e) {
                        return Promise.reject(e);
                    }
                };
            env.stack.push({ value: value, dispose: dispose, async: async });
        }
        else if (async) {
            env.stack.push({ async: true });
        }
        return value;
    }
    var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    function __disposeResources(env) {
        function fail(e) {
            env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
            env.hasError = true;
        }
        var r, s = 0;
        function next() {
            while (r = env.stack.pop()) {
                try {
                    if (!r.async && s === 1)
                        return s = 0, env.stack.push(r), Promise.resolve().then(next);
                    if (r.dispose) {
                        var result = r.dispose.call(r.value);
                        if (r.async)
                            return s |= 2, Promise.resolve(result).then(next, function (e) { fail(e); return next(); });
                    }
                    else
                        s |= 1;
                }
                catch (e) {
                    fail(e);
                }
            }
            if (s === 1)
                return env.hasError ? Promise.reject(env.error) : Promise.resolve();
            if (env.hasError)
                throw env.error;
        }
        return next();
    }
    function __rewriteRelativeImportExtension(path, preserveJsx) {
        if (typeof path === "string" && /^\.\.?\//.test(path)) {
            return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
                return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
            });
        }
        return path;
    }
    exports.default = {
        __extends: __extends,
        __assign: exports.__assign,
        __rest: __rest,
        __decorate: __decorate,
        __param: __param,
        __esDecorate: __esDecorate,
        __runInitializers: __runInitializers,
        __propKey: __propKey,
        __setFunctionName: __setFunctionName,
        __metadata: __metadata,
        __awaiter: __awaiter,
        __generator: __generator,
        __createBinding: exports.__createBinding,
        __exportStar: __exportStar,
        __values: __values,
        __read: __read,
        __spread: __spread,
        __spreadArrays: __spreadArrays,
        __spreadArray: __spreadArray,
        __await: __await,
        __asyncGenerator: __asyncGenerator,
        __asyncDelegator: __asyncDelegator,
        __asyncValues: __asyncValues,
        __makeTemplateObject: __makeTemplateObject,
        __importStar: __importStar,
        __importDefault: __importDefault,
        __classPrivateFieldGet: __classPrivateFieldGet,
        __classPrivateFieldSet: __classPrivateFieldSet,
        __classPrivateFieldIn: __classPrivateFieldIn,
        __addDisposableResource: __addDisposableResource,
        __disposeResources: __disposeResources,
        __rewriteRelativeImportExtension: __rewriteRelativeImportExtension,
    };
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var version_1 = require(3) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(4) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(4) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(89) /* ./protocol */);
    var logging_1 = require(20) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(30) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(7) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(5) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(90) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "3.8.1";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.embed_item = embed_item;
    exports.embed_items = embed_items;
    const document_1 = require(5) /* ../document */;
    const settings_1 = require(30) /* ../core/settings */;
    const logging_1 = require(20) /* ../core/logging */;
    const string_1 = require(41) /* ../core/util/string */;
    const object_1 = require(9) /* ../core/util/object */;
    const types_1 = require(8) /* ../core/util/types */;
    const defer_1 = require(17) /* ../core/util/defer */;
    const standalone_1 = require(81) /* ./standalone */;
    const server_1 = require(82) /* ./server */;
    const dom_1 = require(87) /* ./dom */;
    var standalone_2 = require(81) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(82) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(88) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    async function embed_item(item, target) {
        const docs_json = {};
        const doc_id = (0, string_1.uuid4)();
        docs_json[doc_id] = item.doc;
        if (target == null) {
            target = item.target_id;
        }
        const roots = { [item.root_id]: target };
        const render_item = { roots, root_ids: [item.root_id], docid: doc_id };
        await (0, defer_1.defer)();
        const [views] = await _embed_items(docs_json, [render_item]);
        return views;
    }
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    async function embed_items(docs_json, render_items, app_path, absolute_url) {
        await (0, defer_1.defer)();
        return _embed_items(docs_json, render_items, app_path, absolute_url);
    }
    async function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if ((0, types_1.isString)(docs_json)) {
            docs_json = JSON.parse((0, string_1.unescape)(docs_json));
        }
        const docs = {};
        for (const [docid, doc_json] of (0, object_1.entries)(docs_json)) {
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        const views = [];
        for (const item of render_items) {
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            if (item.docid != null) {
                views.push(await (0, standalone_1.add_document_standalone)(docs[item.docid], element, roots, item.use_for_title));
            }
            else if (item.token != null) {
                const websocket_url = (0, server_1._get_ws_url)(app_path, absolute_url);
                logging_1.logger.debug(`embed: computed ws url: ${websocket_url}`);
                try {
                    views.push(await (0, server_1.add_document_from_session)(websocket_url, item.token, element, roots, item.use_for_title));
                    console.log("Bokeh items were rendered successfully");
                }
                catch (error) {
                    if (settings_1.settings.dev) {
                        throw error;
                    }
                    else {
                        console.error("Error rendering Bokeh items:", error);
                    }
                }
            }
            else {
                throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
            }
        }
        return views;
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(6) /* ./document */, exports);
    tslib_1.__exportStar(require(42) /* ./events */, exports);
    const base_1 = require(7) /* ../base */;
    const ConfigModels = tslib_1.__importStar(require(53) /* ./config */);
    (0, base_1.register_models)(ConfigModels);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const version_1 = require(3) /* ../version */;
    const logging_1 = require(20) /* ../core/logging */;
    const has_props_1 = require(15) /* ../core/has_props */;
    const resolvers_1 = require(47) /* ../core/resolvers */;
    const serialization_1 = require(33) /* ../core/serialization */;
    const deserializer_1 = require(48) /* ../core/serialization/deserializer */;
    const version_2 = require(50) /* ../core/util/version */;
    const signaling_1 = require(16) /* ../core/signaling */;
    const types_1 = require(8) /* ../core/util/types */;
    const eq_1 = require(27) /* ../core/util/eq */;
    const array_1 = require(10) /* ../core/util/array */;
    const object_1 = require(9) /* ../core/util/object */;
    const sets = tslib_1.__importStar(require(45) /* ../core/util/set */);
    const callbacks_1 = require(51) /* ../core/util/callbacks */;
    const assert_1 = require(12) /* ../core/util/assert */;
    const model_1 = require(52) /* ../model */;
    const config_1 = require(53) /* ./config */;
    const defs_1 = require(79) /* ./defs */;
    const bokeh_events_1 = require(80) /* ../core/bokeh_events */;
    const bokeh_events_2 = require(80) /* ../core/bokeh_events */;
    const events_1 = require(42) /* ./events */;
    deserializer_1.Deserializer.register("model", defs_1.decode_def);
    // Dispatches events to the subscribed models
    class EventManager {
        constructor(document) {
            this.subscribed_models = new Set();
            this.document = document;
        }
        send_event(bokeh_event) {
            if (bokeh_event.publish) {
                const event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event);
                this.document._trigger_on_change(event);
            }
            this.document._trigger_on_event(bokeh_event);
        }
        trigger(event) {
            for (const model of this.subscribed_models) {
                if (event.origin != null && event.origin != model) {
                    continue;
                }
                model._process_event(event);
            }
        }
    }
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    class Document {
        get config() {
            (0, assert_1.assert)(this._config != null, "configuration is missing");
            return this._config;
        }
        set config(config) {
            this.freeze_all_models(() => this._config = config);
        }
        constructor(options = {}) {
            this._notified_idle = false;
            this._hold_models_freeze = false;
            this._recompute_timer = null;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = options.resolver ?? new resolvers_1.ModelResolver(base_1.default_resolver);
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._new_models = new Set();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._document_callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakSet();
            this._interactive_timestamp = null;
            this._interactive_plot = null;
            this._recompute_timeout = options.recompute_timeout ?? 30000; /* 30s */
            if (options.roots != null) {
                this._add_roots(...options.roots);
            }
            this.on_message("bokeh_event", (event) => {
                (0, assert_1.assert)(event instanceof bokeh_events_1.ModelEvent);
                this.event_manager.trigger(event);
            });
            this.config = new config_1.DocumentConfig();
        }
        [eq_1.equals](that, _cmp) {
            return this == that;
        }
        get all_models() {
            return new Set(this._all_models.values());
        }
        get is_idle() {
            // TODO: models without views, e.g. data models
            for (const root of this.roots()) {
                if (!this._idle_roots.has(root)) {
                    return false;
                }
            }
            return true;
        }
        notify_idle(model) {
            if (this._notified_idle || !this.roots().includes(model)) {
                return;
            }
            this._idle_roots.add(model);
            if (this.is_idle) {
                logging_1.logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`);
                this.event_manager.send_event(new bokeh_events_2.DocumentReady());
                this.idle.emit();
                this._notified_idle = true;
            }
        }
        clear({ sync } = {}) {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0], { sync });
                }
                this._config = undefined;
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        interactive_start(plot, finalize = null) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_2.LODStart());
            }
            this._interactive_finalize = finalize;
            this._interactive_timestamp = Date.now();
        }
        interactive_stop() {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_2.LODEnd());
                if (this._interactive_finalize != null) {
                    this._interactive_finalize();
                }
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
            this._interactive_finalize = null;
        }
        interactive_duration() {
            if (this._interactive_timestamp == null) {
                return -1;
            }
            else {
                return Date.now() - this._interactive_timestamp;
            }
        }
        destructively_move(dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            // Don't synchronize root removal with the server, because we are rebuilding from
            // scratch and server has the complete state. However, events will be distributed
            // internally within bokehjs, because UI refresh depends on this (in standalone
            // embedding and its derivatives).
            dest_doc.clear({ sync: false });
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            const { config } = this;
            const roots = (0, array_1.copy)(this._roots);
            this.clear({ sync: false });
            for (const root of [...roots, config]) {
                if (root.document != null) {
                    throw new Error(`Somehow we didn't detach ${root}`);
                }
            }
            if (this._all_models.size != 0) {
                throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
            }
            dest_doc.config = config;
            for (const root of roots) {
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        }
        freeze_all_models(fn) {
            this._push_all_models_freeze();
            try {
                fn();
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        _push_all_models_freeze() {
            if (this._hold_models_freeze) {
                return;
            }
            this._all_models_freeze_count += 1;
        }
        _pop_all_models_freeze() {
            if (this._hold_models_freeze) {
                return;
            }
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        _cancel_recompute_all_models() {
            if (this._recompute_timer != null) {
                clearTimeout(this._recompute_timer);
                this._recompute_timer = null;
            }
        }
        _schedule_recompute_all_models() {
            const timeout = this._recompute_timeout;
            if (isNaN(timeout) || timeout <= 0) {
                this._recompute_all_models();
            }
            else if (isFinite(timeout)) {
                this._cancel_recompute_all_models();
                this._recompute_timer = setTimeout(() => {
                    this._recompute_all_models();
                }, timeout);
            }
        }
        _recompute_all_models() {
            this._cancel_recompute_all_models();
            let new_all_models_set = new Set();
            for (const r of this.all_roots) {
                new_all_models_set = sets.union(new_all_models_set, r.references());
            }
            const old_all_models_set = new Set(this._all_models.values());
            const to_detach = sets.difference(old_all_models_set, new_all_models_set);
            const to_attach = sets.difference(new_all_models_set, old_all_models_set);
            const recomputed = new Map();
            for (const model of new_all_models_set) {
                recomputed.set(model.id, model);
            }
            for (const d of to_detach) {
                d.detach_document();
            }
            for (const model of to_attach) {
                model.attach_document(this);
                this._new_models.add(model);
            }
            this._all_models = recomputed;
        }
        partially_update_all_models(value) {
            const refs = new Set();
            has_props_1.HasProps._value_record_references(value, refs, { recursive: false });
            for (const ref of refs) {
                if (!this._all_models.has(ref.id)) {
                    ref.attach_document(this);
                    this._new_models.add(ref);
                    this._all_models.set(ref.id, ref);
                }
            }
            this._schedule_recompute_all_models();
        }
        get all_roots() {
            const all_roots = [...this._roots];
            if (this._config != null) {
                all_roots.push(this._config);
            }
            return all_roots;
        }
        roots() {
            return this._roots;
        }
        _add_roots(...models) {
            models = models.filter((model) => !this._roots.includes(model));
            if (models.length == 0) {
                return false;
            }
            this._push_all_models_freeze();
            try {
                this._roots.push(...models);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _remove_root(model) {
            const i = this._roots.indexOf(model);
            if (i < 0) {
                return false;
            }
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _set_title(title) {
            const new_title = title != this._title;
            if (new_title) {
                this._title = title;
            }
            return new_title;
        }
        add_root(model, { sync } = {}) {
            if (this._add_roots(model)) {
                const event = new events_1.RootAddedEvent(this, model);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        remove_root(model, { sync } = {}) {
            if (this._remove_root(model)) {
                const event = new events_1.RootRemovedEvent(this, model);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        set_title(title, { sync } = {}) {
            if (this._set_title(title)) {
                const event = new events_1.TitleChangedEvent(this, title);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        title() {
            return this._title;
        }
        get_model_by_id(model_id) {
            return this._all_models.get(model_id) ?? null;
        }
        get_model_by_name(name) {
            const found = [];
            for (const model of this._all_models.values()) {
                if (model instanceof model_1.Model && model.name == name) {
                    found.push(model);
                }
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error(`Multiple models are named '${name}'`);
            }
        }
        on_message(msg_type, callback) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null) {
                this._message_callbacks.set(msg_type, new Set([callback]));
            }
            else {
                message_callbacks.add(callback);
            }
        }
        remove_on_message(msg_type, callback) {
            this._message_callbacks.get(msg_type)?.delete(callback);
        }
        _trigger_on_message(msg_type, msg_data) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                for (const cb of message_callbacks) {
                    cb(msg_data);
                }
            }
        }
        on_change(callback, allow_batches = false) {
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        }
        remove_on_change(callback) {
            this._callbacks.delete(callback);
        }
        _trigger_on_change(event) {
            for (const [callback, allow_batches] of this._callbacks) {
                if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                    for (const ev of event.events) {
                        callback(ev);
                    }
                }
                else {
                    callback(event); // TODO
                }
            }
        }
        _trigger_on_event(event) {
            const callbacks = this._document_callbacks.get(event.event_name);
            if (callbacks != null) {
                for (const callback of callbacks) {
                    void (0, callbacks_1.execute)(callback, this, event);
                }
            }
        }
        on_event(event, ...callbacks) {
            const name = (0, types_1.isString)(event) ? event : event.prototype.event_name;
            const existing = this._document_callbacks.get(name) ?? [];
            const added = callbacks;
            this._document_callbacks.set(name, [...existing, ...added]);
        }
        to_json_string(include_defaults = true) {
            return JSON.stringify(this.to_json(include_defaults));
        }
        to_json(include_defaults = true) {
            const serializer = new serialization_1.Serializer({ include_defaults });
            const config = serializer.encode(this.config);
            const roots = serializer.encode(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                config,
                roots,
            };
        }
        static from_json_string(s, events) {
            const json = JSON.parse(s);
            return Document.from_json(json, events);
        }
        static _handle_version(json) {
            if (json.version == null) {
                logging_1.logger.warn("'version' field is missing");
            }
            const py_version = json.version ?? "0.0.0";
            const py_ver = version_2.Version.from(py_version);
            const js_ver = version_2.Version.from(version_1.version);
            const message = `new document using Bokeh ${py_version} and BokehJS ${version_1.version}`;
            if ((0, eq_1.is_equal)(py_ver, js_ver)) {
                logging_1.logger.debug(message);
            }
            else {
                logging_1.logger.warn(`Bokeh/BokehJS version mismatch: ${message}`);
            }
        }
        static from_json(doc_json, events) {
            logging_1.logger.debug("Creating Document from JSON");
            Document._handle_version(doc_json);
            const resolver = new resolvers_1.ModelResolver(base_1.default_resolver);
            if (doc_json.defs != null) {
                const deserializer = new deserializer_1.Deserializer(resolver);
                deserializer.decode(doc_json.defs);
            }
            const doc = new Document({ resolver });
            doc._push_all_models_freeze();
            const listener = (event) => events?.push(event);
            doc.on_change(listener, true);
            const deserializer = new deserializer_1.Deserializer(resolver, doc._all_models, (obj) => obj.attach_document(doc));
            const config = deserializer.decode(doc_json.config);
            (0, assert_1.assert)(config instanceof config_1.DocumentConfig || config == null);
            if (config != null) {
                doc.config = config;
            }
            const roots = deserializer.decode(doc_json.roots);
            const callbacks = (() => {
                if (doc_json.callbacks != null) {
                    return deserializer.decode(doc_json.callbacks);
                }
                else {
                    return {};
                }
            })();
            doc.remove_on_change(listener);
            for (const [event, event_callbacks] of (0, object_1.entries)(callbacks)) {
                doc.on_event(event, ...event_callbacks);
            }
            for (const root of roots) {
                doc.add_root(root);
            }
            if (doc_json.title != null) {
                doc.set_title(doc_json.title);
            }
            doc._pop_all_models_freeze();
            return doc;
        }
        replace_with_json(json) {
            const replacement = Document.from_json(json);
            replacement.destructively_move(this);
        }
        create_json_patch(events) {
            for (const event of events) {
                if (event.document != this) {
                    throw new Error("Cannot create a patch using events from a different document");
                }
            }
            const references = new Map();
            for (const model of this._all_models.values()) {
                if (!this._new_models.has(model)) {
                    references.set(model, model.ref());
                }
            }
            const serializer = new serialization_1.Serializer({ references, binary: true });
            const patch = { events: serializer.encode(events) };
            this._new_models.clear();
            return patch;
        }
        apply_json_patch(patch, buffers = new Map()) {
            const { _hold_models_freeze } = this;
            this._hold_models_freeze = true;
            try {
                this._apply_json_patch(patch, buffers);
            }
            finally {
                this._hold_models_freeze = _hold_models_freeze;
            }
            this._schedule_recompute_all_models();
        }
        _apply_json_patch(patch, buffers = new Map()) {
            const finalize = (obj) => {
                obj.attach_document(this);
                this._new_models.add(obj);
                this._all_models.set(obj.id, obj);
            };
            const deserializer = new deserializer_1.Deserializer(this._resolver, this._all_models, finalize);
            const events = deserializer.decode(patch.events, buffers);
            for (const event of events) {
                switch (event.kind) {
                    case "MessageSent": {
                        const { msg_type, msg_data } = event;
                        this._trigger_on_message(msg_type, msg_data);
                        break;
                    }
                    case "ModelChanged": {
                        const { model, attr, new: value } = event;
                        model.setv({ [attr]: value }, { sync: false });
                        break;
                    }
                    case "ColumnDataChanged": {
                        const { model, attr, data, cols } = event;
                        if (cols != null) {
                            const new_data = (0, object_1.dict)(data);
                            const current_data = (0, object_1.dict)(model.property(attr).get_value());
                            for (const [name, column] of current_data) {
                                if (!new_data.has(name)) {
                                    new_data.set(name, column);
                                }
                            }
                        }
                        model.setv({ data }, { sync: false, check_eq: false });
                        break;
                    }
                    case "ColumnsStreamed": {
                        const { model, attr, data, rollover } = event;
                        const prop = model.property(attr);
                        model.stream_to(prop, data, rollover, { sync: false });
                        break;
                    }
                    case "ColumnsPatched": {
                        const { model, attr, patches } = event;
                        const prop = model.property(attr);
                        model.patch_to(prop, patches, { sync: false });
                        break;
                    }
                    case "RootAdded": {
                        this.add_root(event.model, { sync: false });
                        break;
                    }
                    case "RootRemoved": {
                        this.remove_root(event.model, { sync: false });
                        break;
                    }
                    case "TitleChanged": {
                        this.set_title(event.title, { sync: false });
                        break;
                    }
                    default: {
                        throw new Error(`unknown patch event type '${event.kind}'`); // XXX
                    }
                }
            }
        }
    }
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.register_models = register_models;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const types_2 = require(8) /* ./core/util/types */;
    const has_props_1 = require(15) /* ./core/has_props */;
    const resolvers_1 = require(47) /* ./core/resolvers */;
    exports.default_resolver = new resolvers_1.ModelResolver(null);
    exports.Models = new Proxy(exports.default_resolver, {
        get(target, name, receiver) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return model;
                }
            }
            return Reflect.get(target, name, receiver);
        },
        has(target, name) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return true;
                }
            }
            return Reflect.has(target, name);
        },
        ownKeys(target) {
            return target.names;
        },
        getOwnPropertyDescriptor(target, name) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return { configurable: true, enumerable: true, writable: false, value: model };
                }
            }
            return Reflect.getOwnPropertyDescriptor(target, name);
        },
    });
    function is_HasProps(obj) {
        return (0, types_1.isObject)(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    function register_models(models, force = false) {
        for (const model of (0, types_1.isArray)(models) ? models : (0, object_1.values)(models)) {
            if (is_HasProps(model)) {
                exports.default_resolver.register(model, force);
            }
        }
    }
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_undefined = is_undefined;
    exports.is_defined = is_defined;
    exports.is_nullish = is_nullish;
    exports.isBoolean = isBoolean;
    exports.isNumber = isNumber;
    exports.isInteger = isInteger;
    exports.isString = isString;
    exports.isSymbol = isSymbol;
    exports.isPrimitive = isPrimitive;
    exports.isFunction = isFunction;
    exports.isArray = isArray;
    exports.isArrayOf = isArrayOf;
    exports.isArrayableOf = isArrayableOf;
    exports.isTypedArray = isTypedArray;
    exports.isObject = isObject;
    exports.isBasicObject = isBasicObject;
    exports.isPlainObject = isPlainObject;
    exports.isDict = isDict;
    exports.isIterable = isIterable;
    exports.isArrayable = isArrayable;
    exports.is_ArrayBufferLike = is_ArrayBufferLike;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const { toString } = Object.prototype;
    function is_undefined(obj) {
        return typeof obj === "undefined";
    }
    function is_defined(obj) {
        return typeof obj !== "undefined";
    }
    // XXX: use only to work around strict conditional expressions
    function is_nullish(obj) {
        return obj == null;
    }
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === "[object Boolean]";
    }
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    function isSymbol(obj) {
        return typeof obj === "symbol";
    }
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj) || isSymbol(obj);
    }
    function isFunction(obj) {
        const rep = toString.call(obj);
        switch (rep) {
            case "[object Function]":
            case "[object AsyncFunction]":
            case "[object GeneratorFunction]":
            case "[object AsyncGeneratorFunction]":
                return true;
            default:
                return false;
        }
    }
    function isArray(obj) {
        return Array.isArray(obj);
    }
    function isArrayOf(array, predicate) {
        if (!isArray(array)) {
            return false;
        }
        for (const item of array) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function isArrayableOf(array, predicate) {
        if (!isArrayable(array)) {
            return false;
        }
        for (const item of array) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    function isObject(obj) {
        const tp = typeof obj;
        return tp === "function" || tp === "object" && !!obj;
    }
    function isBasicObject(obj) {
        return isObject(obj) && is_nullish(obj.constructor);
    }
    function isPlainObject(obj) {
        return isObject(obj) && (is_nullish(obj.constructor) || obj.constructor === Object);
    }
    function isDict(obj) {
        return obj instanceof Map || isPlainObject(obj);
    }
    function isIterable(obj) {
        return isObject(obj) && Symbol.iterator in obj;
    }
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    function is_ArrayBufferLike(obj) {
        // SharedArrayBuffer is only available in cross origin isolated environments, otherwise it's undefined
        return obj instanceof ArrayBuffer || (typeof SharedArrayBuffer !== "undefined" && obj instanceof SharedArrayBuffer);
    }
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.to_object = to_object;
    exports.keys = keys;
    exports.values = values;
    exports.entries = entries;
    exports.clone = clone;
    exports.merge = merge;
    exports.size = size;
    exports.is_empty = is_empty;
    exports.dict = dict;
    const types_1 = require(8) /* ./types */;
    const array_1 = require(10) /* ./array */;
    exports.assign = Object.assign;
    exports.extend = exports.assign;
    function to_object(obj) {
        return (0, types_1.isPlainObject)(obj) ? obj : Object.fromEntries(obj);
    }
    function keys(obj) {
        return obj instanceof Map ? [...obj.keys()] : Object.keys(obj);
    }
    function values(obj) {
        return obj instanceof Map ? [...obj.values()] : Object.values(obj);
    }
    function entries(obj) {
        return obj instanceof Map ? [...obj.entries()] : Object.entries(obj);
    }
    exports.typed_keys = Object.keys;
    exports.typed_values = Object.values;
    exports.typed_entries = Object.entries;
    function clone(obj) {
        return obj instanceof Map ? new Map(obj) : { ...obj };
    }
    function merge(obj0, obj1) {
        /*
        * Returns an object with the array values for obj1 and obj2 unioned by key.
        */
        const result = new Map();
        const keys = [...obj0.keys(), ...obj1.keys()];
        for (const key of keys) {
            const v0 = obj0.get(key);
            const v1 = obj1.get(key);
            const arr0 = v0 === undefined ? [] : v0;
            const arr1 = v1 === undefined ? [] : v1;
            result.set(key, (0, array_1.union)(arr0, arr1));
        }
        return result;
    }
    function size(obj) {
        return obj instanceof Map ? obj.size : Object.keys(obj).length;
    }
    function is_empty(obj) {
        return size(obj) == 0;
    }
    const { hasOwnProperty } = Object.prototype;
    class PlainObjectProxy {
        constructor(obj) {
            this[_a] = "PlainObjectProxy";
            this.obj = obj;
        }
        clear() {
            for (const key of this.keys()) {
                delete this.obj[key];
            }
        }
        delete(key) {
            const exists = this.has(key);
            if (exists) {
                delete this.obj[key];
            }
            return exists;
        }
        has(key) {
            return hasOwnProperty.call(this.obj, key);
        }
        get(key) {
            return this.has(key) ? this.obj[key] : undefined;
        }
        set(key, value) {
            this.obj[key] = value;
            return this;
        }
        get size() {
            return size(this.obj);
        }
        [(_a = Symbol.toStringTag, Symbol.iterator)]() {
            return this.entries();
        }
        *keys() {
            yield* keys(this.obj);
        }
        *values() {
            yield* values(this.obj);
        }
        *entries() {
            yield* entries(this.obj);
        }
        forEach(callback, that) {
            for (const [key, value] of this.entries()) {
                callback.call(that, value, key, this);
            }
        }
    }
    exports.PlainObjectProxy = PlainObjectProxy;
    PlainObjectProxy.__name__ = "PlainObjectProxy";
    function dict(obj) {
        return (0, types_1.isPlainObject)(obj) ? new PlainObjectProxy(obj) : obj;
    }
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.head = head;
    exports.last = last;
    exports.copy = copy;
    exports.concat = concat;
    exports.nth = nth;
    exports.zip = zip;
    exports.unzip = unzip;
    exports.range = range;
    exports.linspace = linspace;
    exports.logspace = logspace;
    exports.transpose = transpose;
    exports.argmin = argmin;
    exports.argmax = argmax;
    exports.argsort = argsort;
    exports.uniq = uniq;
    exports.uniq_by = uniq_by;
    exports._union = _union;
    exports.union = union;
    exports.intersection = intersection;
    exports.difference = difference;
    exports.symmetric_difference = symmetric_difference;
    exports.remove_at = remove_at;
    exports.remove = remove;
    exports.remove_by = remove_by;
    exports.clear = clear;
    exports.split = split;
    exports.shuffle = shuffle;
    exports.pairwise = pairwise;
    exports.elementwise = elementwise;
    exports.reversed = reversed;
    exports.repeat = repeat;
    exports.resize = resize;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const math_1 = require(11) /* ./math */;
    const assert_1 = require(12) /* ./assert */;
    const types_1 = require(8) /* ./types */;
    const arrayable_1 = require(13) /* ./arrayable */;
    var arrayable_2 = require(13) /* ./arrayable */;
    __esExport("map", arrayable_2.map);
    __esExport("reduce", arrayable_2.reduce);
    __esExport("min", arrayable_2.min);
    __esExport("min_by", arrayable_2.min_by);
    __esExport("max", arrayable_2.max);
    __esExport("max_by", arrayable_2.max_by);
    __esExport("sum", arrayable_2.sum);
    __esExport("cumsum", arrayable_2.cumsum);
    __esExport("every", arrayable_2.every);
    __esExport("some", arrayable_2.some);
    __esExport("find", arrayable_2.find);
    __esExport("find_last", arrayable_2.find_last);
    __esExport("find_index", arrayable_2.find_index);
    __esExport("find_last_index", arrayable_2.find_last_index);
    __esExport("sorted_index", arrayable_2.sorted_index);
    __esExport("is_empty", arrayable_2.is_empty);
    __esExport("includes", arrayable_2.includes);
    __esExport("contains", arrayable_2.contains);
    __esExport("sort_by", arrayable_2.sort_by);
    const { slice } = Array.prototype;
    function head(array) {
        if (array.length != 0) {
            return array[0];
        }
        else {
            throw new Error("out of bounds access");
        }
    }
    function last(array) {
        if (array.length != 0) {
            return array[array.length - 1];
        }
        else {
            throw new Error("out of bounds access");
        }
    }
    function copy(array) {
        return slice.call(array);
    }
    function concat(arrays) {
        return [].concat(...arrays);
    }
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    function zip(...arrays) {
        if (arrays.length == 0) {
            return [];
        }
        const n = (0, arrayable_1.min)(arrays.map((a) => a.length));
        const k = arrays.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (let j = 0; j < k; j++) {
                result[i][j] = arrays[j][i];
            }
        }
        return result;
    }
    function unzip(array) {
        const n = array.length;
        if (n == 0) {
            return [];
        }
        const k = (0, arrayable_1.min)(array.map((a) => a.length));
        const results = Array(k);
        for (let j = 0; j < k; j++) {
            results[j] = new Array(n);
        }
        for (let i = 0; i < n; i++) {
            for (let j = 0; j < k; j++) {
                results[j][i] = array[i][j];
            }
        }
        return results;
    }
    function range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const { max, ceil, abs } = Math;
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        const range = new Array(length);
        for (let i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    function linspace(start, stop, num = 100) {
        const step = num == 1 ? 0 : (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = start + i * step;
        }
        return array;
    }
    function logspace(start, stop, num = 100, base = 10) {
        const step = num == 1 ? 0 : (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = base ** (start + i * step);
        }
        return array;
    }
    function transpose(array) {
        const rows = array.length;
        const cols = array[0].length;
        const transposed = [];
        for (let j = 0; j < cols; j++) {
            transposed[j] = [];
            for (let i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    function argmin(array) {
        return (0, arrayable_1.min_by)(range(array.length), (i) => array[i]);
    }
    function argmax(array) {
        return (0, arrayable_1.max_by)(range(array.length), (i) => array[i]);
    }
    /**
     * Return the permutation indices for sorting an array.
     */
    function argsort(array) {
        const indices = Array.from(array.keys());
        indices.sort((a, b) => array[a] - array[b]);
        return indices;
    }
    function uniq(array) {
        const result = new Set();
        for (const value of array) {
            result.add(value);
        }
        return [...result];
    }
    function uniq_by(array, key) {
        const result = [];
        const seen = [];
        for (const value of array) {
            const computed = key(value);
            if (!(0, arrayable_1.includes)(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    function _union(arrays) {
        const result = new Set();
        for (const array of arrays) {
            for (const value of array) {
                result.add(value);
            }
        }
        return result;
    }
    function union(...arrays) {
        return [..._union(arrays)];
    }
    function intersection(array, ...arrays) {
        const result = [];
        top: for (const item of array) {
            if ((0, arrayable_1.includes)(result, item)) {
                continue;
            }
            for (const other of arrays) {
                if (!(0, arrayable_1.includes)(other, item)) {
                    continue top;
                }
            }
            result.push(item);
        }
        return result;
    }
    function difference(array, ...arrays) {
        const rest = _union(arrays);
        return (0, arrayable_1.filter)(array, (value) => !rest.has(value));
    }
    function symmetric_difference(array0, array1) {
        const set0 = new Set(array0);
        const set1 = new Set(array1);
        const result = [];
        for (const val of set0) {
            if (!set1.has(val)) {
                result.push(val);
            }
        }
        for (const val of set1) {
            if (!set0.has(val)) {
                result.push(val);
            }
        }
        return result;
    }
    function remove_at(array, i) {
        (0, assert_1.assert)((0, types_1.isInteger)(i) && i >= 0);
        const result = copy(array);
        result.splice(i, 1);
        return result;
    }
    function remove(array, item) {
        remove_by(array, (value) => value == item);
    }
    function remove_by(array, key) {
        for (let i = 0; i < array.length;) {
            if (key(array[i])) {
                array.splice(i, 1);
            }
            else {
                i++;
            }
        }
    }
    function clear(array) {
        array.splice(0, array.length);
    }
    function split(array, separator) {
        const chunks = [];
        const n = array.length;
        let i = 0;
        let j = 0;
        while (j < n) {
            if (array[j] === separator) {
                chunks.push(array.slice(i, j));
                i = ++j;
            }
            else {
                ++j;
            }
        }
        chunks.push(array.slice(i));
        return chunks;
    }
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        const length = array.length;
        const shuffled = new Array(length);
        for (let i = 0; i < length; i++) {
            const rand = (0, math_1.randomIn)(0, i);
            if (rand !== i) {
                shuffled[i] = shuffled[rand];
            }
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    function pairwise(array, fn) {
        const n = array.length;
        const result = new Array(n - 1);
        for (let i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    function elementwise(array0, array1, fn) {
        const n = Math.min(array0.length, array1.length);
        const result = Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array0[i], array1[i]);
        }
        return result;
    }
    function reversed(array) {
        const n = array.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    function repeat(value, n) {
        const result = new Array(n).fill(value);
        return result;
    }
    function resize(array, new_length, fill_value) {
        if (array.length >= new_length) {
            return array.slice(0, new_length);
        }
        else {
            const suffix = new Array(new_length - array.length);
            if (fill_value !== undefined) {
                suffix.fill(fill_value);
            }
            return array.concat(suffix);
        }
    }
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.angle_norm = angle_norm;
    exports.angle_dist = angle_dist;
    exports.angle_between = angle_between;
    exports.randomIn = randomIn;
    exports.atan2 = atan2;
    exports.radians = radians;
    exports.degrees = degrees;
    exports.compute_angle = compute_angle;
    exports.invert_angle = invert_angle;
    exports.to_radians_coeff = to_radians_coeff;
    exports.minmax = minmax;
    exports.clamp = clamp;
    exports.cycle = cycle;
    exports.log = log;
    exports.gcd = gcd;
    exports.lcm = lcm;
    exports.is_Floating = is_Floating;
    exports.factorial = factorial;
    exports.hermite = hermite;
    exports.eval_poly = eval_poly;
    const types_1 = require(8) /* ./types */;
    const assert_1 = require(12) /* ./assert */;
    const { PI, abs, sign, sqrt } = Math;
    exports.PI = PI;
    exports.abs = abs;
    exports.sqrt = sqrt;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    function angle_between(mid, lhs, rhs, anticlock = false) {
        const d = angle_dist(lhs, rhs);
        if (d == 0) {
            return false;
        }
        if (d == 2 * PI) {
            return true;
        }
        const norm_mid = angle_norm(mid);
        const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    function degrees(radians) {
        return radians / (PI / 180);
    }
    function compute_angle(angle, units, dir = "anticlock") {
        /**
         * Convert math CCW(default)/CW angle with units to CW radians (canvas).
         */
        const sign = dir == "anticlock" ? 1 : -1;
        return -sign * angle * to_radians_coeff(units);
    }
    exports.resolve_angle = compute_angle;
    function invert_angle(angle, units, dir = "anticlock") {
        /**
         * Convert CW radians (canvas) to math CCW(default)/CW angle with units.
         */
        const sign = dir == "anticlock" ? 1 : -1;
        return -sign * angle / to_radians_coeff(units);
    }
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    function minmax(v0, v1) {
        return v0 <= v1 ? [v0, v1] : [v1, v0];
    }
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    function cycle(val, min, max) {
        if (val > max) {
            return min;
        }
        if (val < min) {
            return max;
        }
        return val;
    }
    function log(x, base = Math.E) {
        return Math.log(x) / Math.log(base);
    }
    function gcd(a, b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            [a, b] = [b, a % b];
        }
        return a;
    }
    function lcm(a, ...rest) {
        for (const b of rest) {
            a = Math.floor((a * b) / gcd(a, b));
        }
        return a;
    }
    exports.float = Symbol("float");
    function is_Floating(obj) {
        return (0, types_1.isObject)(obj) && exports.float in obj;
    }
    class Fraction {
        constructor(numer, denom) {
            (0, assert_1.assert)(denom != 0, "Zero divisor");
            const div = gcd(numer, denom);
            const sgn = sign(numer) * sign(denom);
            this.numer = sgn * abs(numer) / div;
            this.denom = abs(denom) / div;
        }
        [exports.float]() {
            return this.numer / this.denom;
        }
        toString() {
            return `${this.numer}/${this.denom}`;
        }
    }
    exports.Fraction = Fraction;
    Fraction.__name__ = "Fraction";
    exports.float32_epsilon = 1.1920928955078125e-7; // IEEE-754
    function factorial(x) {
        let y = 1;
        for (let i = 2; i <= x; i++) {
            y *= i;
        }
        return y;
    }
    function hermite(n) {
        const poly = new Array(n + 1);
        poly.fill(0);
        const fn = factorial(n);
        for (let k = 0; k <= Math.floor(n / 2); k++) {
            const c = (-1) ** k * fn / (factorial(k) * factorial(n - 2 * k)) * 2 ** (n - 2 * k);
            poly[2 * k] = c;
        }
        return poly;
    }
    function eval_poly(poly, x) {
        const n = poly.length - 1;
        let y = 0;
        let x_n = 1;
        for (let i = n; i >= 0; i--) {
            y += x_n * poly[i];
            x_n *= x;
        }
        return y;
    }
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.assert = assert;
    exports.assert_debug = assert_debug;
    exports.unreachable = unreachable;
    class AssertionError extends Error {
    }
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    class UnreachableError extends Error {
    }
    exports.UnreachableError = UnreachableError;
    UnreachableError.__name__ = "UnreachableError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition())) {
            return;
        }
        throw new AssertionError(message ?? "Assertion failed");
    }
    function assert_debug(condition, message) {
        if (typeof DEBUG !== "undefined" && DEBUG) {
            assert(condition, message);
        }
    }
    function unreachable(msg) {
        const suffix = msg != null ? `: ${msg}` : "";
        throw new UnreachableError(`unreachable code${suffix}`);
    }
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_empty = is_empty;
    exports.is_sorted = is_sorted;
    exports.copy = copy;
    exports.splice = splice;
    exports.head = head;
    exports.insert = insert;
    exports.append = append;
    exports.prepend = prepend;
    exports.index_of = index_of;
    exports.includes = includes;
    exports.subselect = subselect;
    exports.mul = mul;
    exports.map = map;
    exports.inplace_map = inplace_map;
    exports.filter = filter;
    exports.reduce = reduce;
    exports.sort_by = sort_by;
    exports.minmax2 = minmax2;
    exports.min_by = min_by;
    exports.max_by = max_by;
    exports.sum = sum;
    exports.cumsum = cumsum;
    exports.every = every;
    exports.some = some;
    exports.find = find;
    exports.find_last = find_last;
    exports.bisect_left_by = bisect_left_by;
    exports.bisect_right_by = bisect_right_by;
    exports.bisect_left = bisect_left;
    exports.bisect_right = bisect_right;
    exports.binary_search = binary_search;
    exports.bin_counts = bin_counts;
    exports.interpolate = interpolate;
    exports.left_edge_index = left_edge_index;
    exports.norm = norm;
    const math_1 = require(11) /* ./math */;
    const assert_1 = require(12) /* ./assert */;
    var iterator_1 = require(14) /* ./iterator */;
    __esExport("min", iterator_1.min);
    __esExport("max", iterator_1.max);
    __esExport("minmax", iterator_1.minmax);
    const { floor } = Math;
    function is_empty(array) {
        return array.length == 0;
    }
    function is_sorted(array) {
        const n = array.length;
        if (n == 0) {
            return true;
        }
        let prev = array[0];
        for (let i = 1; i < n; i++) {
            const curr = array[i];
            if (prev <= curr) {
                prev = curr;
            }
            else {
                return false;
            }
        }
        return true;
    }
    function copy(array) {
        if (Array.isArray(array)) {
            return array.slice();
        }
        else {
            return new array.constructor(array);
        }
    }
    function splice(array, start, k, ...items) {
        if (Array.isArray(array)) {
            const result = copy(array);
            if (k === undefined) {
                result.splice(start);
            }
            else {
                result.splice(start, k, ...items);
            }
            return result;
        }
        const len = array.length;
        if (start < 0) {
            start += len;
        }
        if (start < 0) {
            start = 0;
        }
        else if (start > len) {
            start = len;
        }
        if (k == null || k > len - start) {
            k = len - start;
        }
        else if (k < 0) {
            k = 0;
        }
        const n = len - k + items.length;
        const result = new array.constructor(n);
        let i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (const item of items) {
            result[i++] = item;
        }
        for (let j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    function index_of(array, item) {
        return array.indexOf(item);
    }
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.contains = includes;
    function subselect(array, indices) {
        const n = indices.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    function mul(array, coeff, output) {
        const n = array.length;
        const result = output ?? new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    function map(array, fn) {
        const n = array.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    function inplace_map(array, fn, output) {
        const n = array.length;
        const result = output ?? array;
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    function filter(array, pred) {
        const n = array.length;
        const result = new array.constructor(n);
        let k = 0;
        for (let i = 0; i < n; i++) {
            const value = array[i];
            if (pred(value, i, array)) {
                result[k++] = value;
            }
        }
        return head(result, k);
    }
    function reduce(array, fn, initial) {
        const n = array.length;
        if (initial === undefined && n == 0) {
            throw new Error("can't reduce an empty array without an initial value");
        }
        let value;
        let i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    function sort_by(array, key) {
        const tmp = Array.from(array, (value, index) => {
            return { index, key: key(value) };
        });
        tmp.sort((left, right) => {
            const a = left.key;
            const b = right.key;
            if (a !== b) {
                if (a > b) {
                    return 1;
                }
                if (a < b) {
                    return -1;
                }
            }
            return left.index - right.index;
        });
        return map(array, (_, i) => array[tmp[i].index]);
    }
    function minmax2(arr, brr) {
        let a;
        let b;
        let a_min = +Infinity;
        let a_max = -Infinity;
        let b_min = +Infinity;
        let b_max = -Infinity;
        const n = Math.min(arr.length, brr.length);
        for (let i = 0; i < n; i++) {
            a = arr[i];
            b = brr[i];
            if (!isNaN(a) && !isNaN(b)) {
                if (a < a_min) {
                    a_min = a;
                }
                if (a > a_max) {
                    a_max = a;
                }
                if (b < b_min) {
                    b_min = b;
                }
                if (b > b_max) {
                    b_max = b;
                }
            }
        }
        return [a_min, a_max, b_min, b_max];
    }
    function min_by(array, key) {
        if (array.length == 0) {
            throw new Error("min_by() called with an empty array");
        }
        let result = array[0];
        let result_computed = key(result, 0);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value, i);
            if (computed < result_computed) {
                result = value;
                result_computed = computed;
            }
        }
        return result;
    }
    function max_by(array, key) {
        if (array.length == 0) {
            throw new Error("max_by() called with an empty array");
        }
        let result = array[0];
        let result_computed = key(result, 0);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value, i);
            if (computed > result_computed) {
                result = value;
                result_computed = computed;
            }
        }
        return result;
    }
    function sum(array) {
        let result = 0;
        for (let i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    function cumsum(array) {
        const result = new array.constructor(array.length);
        reduce(array, (a, b, i) => result[i] = a + b, 0);
        return result;
    }
    function every(iter, predicate) {
        for (const item of iter) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function some(iter, predicate) {
        for (const item of iter) {
            if (predicate(item)) {
                return true;
            }
        }
        return false;
    }
    function _find_index(dir) {
        return function (array, predicate) {
            const length = array.length;
            let index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index])) {
                    return index;
                }
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        const index = (0, exports.find_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    function find_last(array, predicate) {
        const index = (0, exports.find_last_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    function bisect_left_by(array, value, fn, low = 0, high = array.length) {
        (0, assert_1.assert_debug)(() => is_sorted(array));
        (0, assert_1.assert)(0 <= low && high <= array.length);
        while (low < high) {
            const mid = floor((low + high) / 2);
            if (fn(array[mid]) < value) {
                low = mid + 1;
            }
            else {
                high = mid;
            }
        }
        return low;
    }
    function bisect_right_by(array, value, fn, low = 0, high = array.length) {
        (0, assert_1.assert_debug)(() => is_sorted(array));
        (0, assert_1.assert)(0 <= low && high <= array.length);
        while (low < high) {
            const mid = floor((low + high) / 2);
            if (fn(array[mid]) <= value) {
                low = mid + 1;
            }
            else {
                high = mid;
            }
        }
        return low;
    }
    function bisect_left(array, value, low = 0, high) {
        return bisect_left_by(array, value, (item) => item, low, high);
    }
    function bisect_right(array, value, low = 0, high) {
        return bisect_right_by(array, value, (item) => item, low, high);
    }
    function binary_search(array, value) {
        const i = bisect_left(array, value);
        return i != array.length && array[i] == value ? i : null;
    }
    exports.sorted_index = bisect_left;
    function bin_counts(data, bin_edges) {
        const nbins = bin_edges.length - 1;
        const counts = Array(nbins).fill(0);
        for (let i = 0; i < data.length; i++) {
            const sample = data[i];
            const index = (0, exports.sorted_index)(bin_edges, sample);
            const bin = (0, math_1.clamp)(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        const n = points.length;
        const results = new Array(n);
        for (let i = 0; i < n; i++) {
            const point = points[i];
            if (isNaN(point) || x_values.length == 0) {
                results[i] = NaN;
                continue;
            }
            const index = left_edge_index(point, x_values);
            if (index == -1) {
                results[i] = y_values[0];
            }
            else if (index == x_values.length) {
                results[i] = y_values[y_values.length - 1];
            }
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                const x0 = x_values[index];
                const y0 = y_values[index];
                const x1 = x_values[index + 1];
                const y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    function lerp(x, x0, y0, x1, y1) {
        const slope = (y1 - y0) / (x1 - x0);
        let res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1)) {
                res = y0;
            }
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0]) {
            return -1;
        }
        if (point > intervals[intervals.length - 1]) {
            return intervals.length;
        }
        if (intervals.length == 1) {
            // Implies point == intervals[0]
            return 0;
        }
        let leftEdgeIndex = 0;
        let rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare]) {
                leftEdgeIndex = indexOfNumberToCompare;
            }
            else {
                rightEdgeIndex = indexOfNumberToCompare;
            }
        }
        return leftEdgeIndex;
    }
    function norm(array, start, end) {
        const span = end - start;
        return map(array, (x) => (x - start) / span);
    }
},
/* core/util/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.iter = iter;
    exports.range = range;
    exports.reverse = reverse;
    exports.enumerate = enumerate;
    exports.take = take;
    exports.skip = skip;
    exports.tail = tail;
    exports.join = join;
    exports.zip = zip;
    exports.interleave = interleave;
    exports.map = map;
    exports.flat_map = flat_map;
    exports.filter = filter;
    exports.no_repeated = no_repeated;
    exports.every = every;
    exports.some = some;
    exports.combinations = combinations;
    exports.subsets = subsets;
    exports.min = min;
    exports.max = max;
    exports.minmax = minmax;
    const assert_1 = require(12) /* ./assert */;
    const types_1 = require(8) /* ./types */;
    function* iter(obj) {
        if ((0, types_1.isIterable)(obj)) {
            yield* obj;
        }
        else {
            yield obj;
        }
    }
    function* range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0);
        const { abs, ceil, max } = Math;
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / abs(step)), 0);
        for (let i = 0; i < length; i++, start += delta) {
            yield start;
        }
    }
    function* reverse(array) {
        const n = array.length;
        for (let i = 0; i < n; i++) {
            yield array[n - i - 1];
        }
    }
    function* enumerate(seq) {
        let i = 0;
        for (const item of seq) {
            yield [item, i++];
        }
    }
    function* take(seq, n) {
        (0, assert_1.assert)(n >= 0);
        let i = 0;
        for (const item of seq) {
            if (i++ < n) {
                yield item;
            }
            else {
                break;
            }
        }
    }
    function* skip(seq, n) {
        (0, assert_1.assert)(n >= 0);
        for (const value of seq) {
            if (n == 0) {
                yield value;
            }
            else {
                n -= 1;
            }
        }
    }
    function* tail(seq) {
        yield* skip(seq, 1);
    }
    function* join(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first) {
                first = false;
            }
            else if (separator != null) {
                yield separator();
            }
            yield* entry;
        }
    }
    function* zip(iterable0, iterable1) {
        const it0 = iterable0[Symbol.iterator]();
        const it1 = iterable1[Symbol.iterator]();
        do {
            const r0 = it0.next();
            const r1 = it1.next();
            if (r0.done === true || r1.done === true) {
                break;
            }
            else {
                yield [r0.value, r1.value];
            }
        } while (true);
    }
    function* interleave(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first) {
                first = false;
            }
            else {
                yield separator();
            }
            yield entry;
        }
    }
    function* map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield fn(item, i++);
        }
    }
    function* flat_map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield* fn(item, i++);
        }
    }
    function* filter(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            if (fn(item, i++)) {
                yield item;
            }
        }
    }
    const nothing = Symbol("nothing");
    function* no_repeated(iterable) {
        let last = nothing;
        for (const item of iterable) {
            if (item !== last) {
                yield item;
            }
            last = item;
        }
    }
    function every(iterable, predicate) {
        for (const item of iterable) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function some(iterable, predicate) {
        for (const item of iterable) {
            if (predicate(item)) {
                return true;
            }
        }
        return false;
    }
    // https://docs.python.org/3.8/library/itertools.html#itertools.combinations
    function* combinations(seq, r) {
        const n = seq.length;
        if (r > n) {
            return;
        }
        const indices = [...range(r)];
        yield indices.map((i) => seq[i]);
        while (true) {
            let k;
            for (const i of range(r - 1, -1)) {
                if (indices[i] != i + n - r) {
                    k = i;
                    break;
                }
            }
            if (k == null) {
                return;
            }
            indices[k] += 1;
            for (const j of range(k + 1, r)) {
                indices[j] = indices[j - 1] + 1;
            }
            yield indices.map((i) => seq[i]);
        }
    }
    function* subsets(seq) {
        for (const k of range(seq.length + 1)) {
            yield* combinations(seq, k);
        }
    }
    function min(iterable) {
        let result = Infinity;
        for (const value of iterable) {
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    function max(iterable) {
        let result = -Infinity;
        for (const value of iterable) {
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    function minmax(iterable) {
        let min = +Infinity;
        let max = -Infinity;
        for (const value of iterable) {
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(16) /* ./signaling */;
    const refs_1 = require(18) /* ./util/refs */;
    const p = tslib_1.__importStar(require(19) /* ./properties */);
    const k = tslib_1.__importStar(require(22) /* ./kinds */);
    const assert_1 = require(12) /* ./util/assert */;
    const string_1 = require(41) /* ./util/string */;
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const serialization_1 = require(33) /* ./serialization */;
    const events_1 = require(42) /* ../document/events */;
    const eq_1 = require(27) /* ./util/eq */;
    const pretty_1 = require(43) /* ./util/pretty */;
    const cloneable_1 = require(32) /* ./util/cloneable */;
    const kinds = tslib_1.__importStar(require(22) /* ./kinds */);
    const vectorization_1 = require(29) /* ./vectorization */;
    const patching_1 = require(44) /* ./patching */;
    const _qualified_names = new WeakMap();
    class HasProps extends (0, signaling_1.Signalable)() {
        get is_syncable() {
            return true;
        }
        get type() {
            return this.constructor.__qualified__;
        }
        static get __qualified__() {
            let qualified = _qualified_names.get(this);
            if (qualified == null) {
                const { __module__, __name__ } = this;
                qualified = __module__ != null ? `${__module__}.${__name__}` : __name__;
                _qualified_names.set(this, qualified);
            }
            return qualified;
        }
        static set __qualified__(qualified) {
            _qualified_names.set(this, qualified);
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__qualified__;
        }
        static _fix_default(default_value, _attr) {
            if (default_value === undefined || default_value === p.unset) {
                return () => p.unset;
            }
            else if ((0, types_1.isFunction)(default_value)) {
                return default_value;
            }
            else if ((0, types_1.isPrimitive)(default_value)) {
                return () => default_value;
            }
            else {
                const cloner = new cloneable_1.Cloner();
                return () => cloner.clone(default_value);
            }
        }
        // TODO: don't use Partial<>, but exclude inherited properties
        static define(obj) {
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                if (name in this.prototype._props) {
                    throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
                }
                if (name in this.prototype) {
                    throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
                }
                Object.defineProperty(this.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get() {
                        const value = this.properties[name].get_value();
                        return value;
                    },
                    set(value) {
                        this.setv({ [name]: value });
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                const [type, default_value, options = {}] = prop;
                const refined_prop = {
                    type,
                    default_value: this._fix_default(default_value, name),
                    options,
                };
                this.prototype._props = {
                    ...this.prototype._props,
                    [name]: refined_prop,
                };
            }
        }
        static internal(obj) {
            const _object = {};
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                const [type, default_value, options = {}] = prop;
                _object[name] = [type, default_value, { ...options, internal: true }];
            }
            this.define(_object);
        }
        static mixins(defs) {
            function rename(prefix, mixin) {
                const result = {};
                for (const [name, prop] of (0, object_1.entries)(mixin)) {
                    result[prefix + name] = prop;
                }
                return result;
            }
            const mixin_defs = {};
            const mixins = [];
            for (const def of (0, types_1.isArray)(defs) ? defs : [defs]) {
                if ((0, types_1.isArray)(def)) {
                    const [prefix, mixin] = def;
                    (0, object_1.extend)(mixin_defs, rename(prefix, mixin));
                    mixins.push([prefix, mixin]);
                }
                else {
                    const mixin = def;
                    (0, object_1.extend)(mixin_defs, mixin);
                    mixins.push(["", mixin]);
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = [...this.prototype._mixins, ...mixins];
        }
        static override(obj) {
            for (const [name, prop] of (0, object_1.entries)(obj)) {
                const default_value = this._fix_default(prop, name);
                if (!(name in this.prototype._props)) {
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                }
                const value = this.prototype._props[name];
                const props = { ...this.prototype._props };
                props[name] = { ...value, default_value };
                this.prototype._props = props;
            }
        }
        static override_options(obj) {
            for (const [name, options] of (0, object_1.entries)(obj)) {
                if (!(name in this.prototype._props)) {
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                }
                const current = this.prototype._props[name];
                const props = {
                    ...this.prototype._props,
                    [name]: { ...current, options: { ...current.options, ...options } },
                };
                this.prototype._props = props;
            }
        }
        static toString() {
            return this.__qualified__;
        }
        toString() {
            return `${this.type}(${this.id})`;
        }
        property(name) {
            if (name in this.properties) {
                return this.properties[name];
            }
            else {
                throw new Error(`unknown property ${this.type}.${name}`);
            }
        }
        /**
         * Gets values of all set properties.
         */
        get attributes() {
            const attrs = {};
            for (const prop of this) {
                if (!prop.is_unset) {
                    attrs[prop.attr] = prop.get_value();
                }
            }
            return attrs;
        }
        /**
         * Gets values of all set and dirty (modified) properties.
         */
        get dirty_attributes() {
            const attrs = {};
            for (const prop of this) {
                if (!prop.is_unset && prop.dirty) {
                    attrs[prop.attr] = prop.get_value();
                }
            }
            return attrs;
        }
        [cloneable_1.clone](cloner) {
            const attrs = new Map();
            for (const prop of this) {
                if (prop.dirty) {
                    attrs.set(prop.attr, cloner.clone(prop.get_value()));
                }
            }
            return new this.constructor(attrs);
        }
        [eq_1.equals](that, cmp) {
            for (const p0 of this) {
                const p1 = that.property(p0.attr);
                if (!cmp.eq(p0.get_value(), p1.get_value())) {
                    return false;
                }
            }
            return true;
        }
        [pretty_1.pretty](printer) {
            const T = printer.token;
            const items = [];
            for (const prop of this) {
                if (prop.dirty) {
                    const value = prop.get_value();
                    items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
                }
            }
            const cls = this.constructor.__qualified__;
            return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
        }
        [serialization_1.serialize](serializer) {
            const ref = this.ref();
            serializer.add_ref(this, ref);
            const attributes = {};
            for (const prop of this) {
                if (prop.syncable && (serializer.include_defaults || prop.dirty) && !(prop.readonly && prop.is_unset)) {
                    const value = prop.get_value();
                    attributes[prop.attr] = serializer.encode(value);
                }
            }
            const { type: name, id } = this;
            const rep = { type: "object", name, id };
            return (0, object_1.is_empty)(attributes) ? rep : { ...rep, attributes };
        }
        constructor(attrs = {}) {
            super();
            this.document = null;
            this.destroyed = new signaling_1.Signal0(this, "destroyed");
            this.change = new signaling_1.Signal0(this, "change");
            this.transformchange = new signaling_1.Signal0(this, "transformchange");
            this.exprchange = new signaling_1.Signal0(this, "exprchange");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
            this.properties = {};
            this._watchers = new WeakMap();
            this._pending = false;
            this._changing = false;
            const deferred = (0, types_1.isPlainObject)(attrs) && "id" in attrs;
            this.id = deferred ? attrs.id : (0, string_1.unique_id)();
            for (const [name, { type, default_value, options }] of (0, object_1.entries)(this._props)) {
                let property;
                if (type instanceof p.PropertyAlias) {
                    const property = this.properties[type.attr];
                    if (typeof property === "undefined") {
                        throw new Error(`can't resolve ${type.attr} before ${name} to create an alias`);
                    }
                    Object.defineProperty(this.properties, name, {
                        get: () => property,
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind) {
                        property = new p.PrimitiveProperty(this, name, type, default_value, options);
                    }
                    else {
                        property = new type(this, name, k.Any, default_value, options);
                    }
                    this.properties[name] = property;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (deferred) {
                (0, assert_1.assert)((0, object_1.keys)(attrs).length == 1, "'id' cannot be used together with property initializers");
            }
            else {
                this.initialize_props(attrs);
                this.finalize();
                this.connect_signals();
            }
        }
        initialize_props(vals) {
            const vals_proxy = (0, object_1.dict)(vals);
            const visited = new Set();
            for (const prop of this) {
                const val = vals_proxy.get(prop.attr);
                prop.initialize(val);
                visited.add(prop.attr);
            }
            for (const [attr, val] of vals_proxy) {
                if (!visited.has(attr)) {
                    // either throws for unknown properties or updates aliased properties
                    this.property(attr).set_value(val);
                }
            }
        }
        finalize() {
            this.initialize();
        }
        initialize() { }
        assert_initialized() {
            for (const prop of this) {
                if (prop.syncable && !prop.readonly) {
                    prop.get_value();
                }
            }
        }
        connect_signals() {
            for (const prop of this) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)) {
                    continue;
                }
                if (prop.is_unset) {
                    continue;
                }
                const value = prop.get_value();
                if (value.transform != null) {
                    this.connect(value.transform.change, () => this.transformchange.emit());
                }
                if ((0, vectorization_1.isExpr)(value)) {
                    this.connect(value.expr.change, () => this.exprchange.emit());
                }
            }
        }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        destroy() {
            this.disconnect_signals();
            this.destroyed.emit();
        }
        // Create a new model with exact attribute values to this one, but new identity.
        clone(attrs) {
            const cloner = new cloneable_1.Cloner();
            const that = cloner.clone(this);
            if (attrs != null) {
                that.setv(attrs);
            }
            return that;
        }
        _clear_watchers() {
            this._watchers = new WeakMap();
        }
        changed_for(obj) {
            const changed = this._watchers.get(obj);
            this._watchers.set(obj, false);
            return changed ?? true;
        }
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        _setv(changes, options) {
            // Extract attributes and options.
            const check_eq = options.check_eq;
            const changed = new Set();
            const changing = this._changing;
            this._changing = true;
            for (const [prop, value] of changes) {
                if (check_eq === false || prop.is_unset || !(0, eq_1.is_equal)(prop.get_value(), value)) {
                    prop.set_value(value);
                    changed.add(prop);
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.size > 0) {
                this._clear_watchers();
                this._pending = true;
            }
            for (const prop of changed) {
                prop.change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (!changing) {
                if (!(options.no_change ?? false)) {
                    while (this._pending) {
                        this._pending = false;
                        this.change.emit();
                    }
                }
                this._pending = false;
                this._changing = false;
            }
            return changed;
        }
        setv(changed_attrs, options = {}) {
            const changes = (0, object_1.entries)(changed_attrs);
            if (changes.length == 0) {
                return;
            }
            if (options.silent ?? false) {
                this._clear_watchers();
                for (const [attr, value] of changes) {
                    this.properties[attr].set_value(value);
                }
                return;
            }
            const changed = new Map();
            const previous = new Map();
            for (const [attr, value] of changes) {
                const prop = this.properties[attr];
                changed.set(prop, value);
                previous.set(prop, prop.is_unset ? undefined : prop.get_value());
            }
            const updated = this._setv(changed, options);
            const { document } = this;
            if (document != null) {
                const changed = [];
                for (const [prop, value] of previous) {
                    if (updated.has(prop)) {
                        changed.push([prop, value, prop.get_value()]);
                    }
                }
                for (const [prop, _, new_value] of changed) {
                    if (prop.may_have_refs) {
                        document.partially_update_all_models(new_value);
                        break;
                    }
                }
                const sync = options.sync ?? true;
                this._push_changes(changed, sync);
            }
        }
        ref() {
            return { id: this.id };
        }
        *[Symbol.iterator]() {
            yield* (0, object_1.values)(this.properties);
        }
        *syncable_properties() {
            for (const prop of this) {
                if (prop.syncable) {
                    yield prop;
                }
            }
        }
        *own_properties() {
            const self = Object.getPrototypeOf(this);
            const base = Object.getPrototypeOf(self);
            const exclude = new Set((0, object_1.keys)(base._props));
            for (const prop of this) {
                if (!exclude.has(prop.attr)) {
                    yield prop;
                }
            }
        }
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        static _value_record_references(value, refs, options) {
            if (!(0, types_1.isObject)(value) || !(0, refs_1.may_have_refs)(value)) {
                return;
            }
            const { recursive } = options;
            if (value instanceof _a) {
                if (!refs.has(value)) {
                    refs.add(value);
                    if (recursive) {
                        for (const prop of value.syncable_properties()) {
                            if (!prop.is_unset && prop.may_have_refs) {
                                const value = prop.get_value();
                                _a._value_record_references(value, refs, { recursive });
                            }
                        }
                    }
                }
            }
            else if ((0, types_1.isIterable)(value)) {
                for (const elem of value) {
                    _a._value_record_references(elem, refs, { recursive });
                }
            }
            else if ((0, types_1.isPlainObject)(value)) {
                for (const elem of (0, object_1.values)(value)) {
                    _a._value_record_references(elem, refs, { recursive });
                }
            }
        }
        static references(value, options) {
            const refs = new Set();
            _a._value_record_references(value, refs, options);
            return refs;
        }
        references() {
            return _a.references(this, { recursive: true });
        }
        _doc_attached() { }
        _doc_detached() { }
        attach_document(doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null) {
                if (this.document == doc) {
                    return;
                }
                else {
                    throw new Error("models must be owned by only a single document");
                }
            }
            this.document = doc;
            this._doc_attached();
        }
        detach_document() {
            // This should only be called by the Document implementation to unset the document field
            if (this.document != null) {
                this._doc_detached();
                this.document = null;
            }
        }
        _push_changes(changes, sync) {
            if (!this.is_syncable) {
                return;
            }
            const { document } = this;
            if (document == null) {
                return;
            }
            const events = [];
            for (const [prop, , new_value] of changes) {
                if (prop.syncable) {
                    const event = new events_1.ModelChangedEvent(document, this, prop.attr, new_value);
                    event.sync = sync;
                    events.push(event);
                }
            }
            if (events.length != 0) {
                let event;
                if (events.length == 1) {
                    [event] = events;
                }
                else {
                    event = new events_1.DocumentEventBatch(document, events);
                }
                document._trigger_on_change(event);
            }
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        stream_to(prop, new_data, rollover, { sync } = {}) {
            const data = prop.get_value();
            (0, patching_1.stream_to_columns)(data, new_data, rollover);
            this._clear_watchers();
            prop.set_value(data);
            this.streaming.emit();
            if (this.document != null) {
                const event = new events_1.ColumnsStreamedEvent(this.document, this, prop.attr, new_data, rollover);
                event.sync = sync ?? true;
                this.document._trigger_on_change(event);
            }
        }
        patch_to(prop, patches, { sync } = {}) {
            const data = prop.get_value();
            const patched = (0, patching_1.patch_to_columns)(data, patches);
            this._clear_watchers();
            prop.set_value(data);
            this.patching.emit([...patched]);
            if (this.document != null) {
                const event = new events_1.ColumnsPatchedEvent(this.document, this, prop.attr, patches);
                event.sync = sync ?? true;
                this.document._trigger_on_change(event);
            }
        }
    }
    exports.HasProps = HasProps;
    _a = HasProps;
    (() => {
        _a.prototype._props = {};
        _a.prototype._mixins = [];
    })();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.Signalable = Signalable;
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    const defer_1 = require(17) /* ./util/defer */;
    const array_1 = require(10) /* ./util/array */;
    class Signal {
        constructor(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        connect(slot, context = null) {
            if (!exports.receivers_for_sender.has(this.sender)) {
                exports.receivers_for_sender.set(this.sender, []);
            }
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            const receiver = context ?? slot;
            if (!senders_for_receiver.has(receiver)) {
                senders_for_receiver.set(receiver, []);
            }
            const senders = senders_for_receiver.get(receiver);
            const connection = { signal: this, slot, context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        }
        disconnect(slot, context = null) {
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            const connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            const receiver = context ?? slot;
            const senders = senders_for_receiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        }
        emit(args) {
            const receivers = exports.receivers_for_sender.get(this.sender) ?? [];
            for (const { signal, slot, context } of receivers) {
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        }
    }
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    class Signal0 extends Signal {
        emit() {
            super.emit(undefined);
        }
    }
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0) {
                return;
            }
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0) {
                return;
            }
            for (const connection of senders) {
                if (connection.signal == null) {
                    return;
                }
                if (connection.signal.sender === sender) {
                    connection.signal = null;
                }
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0) {
                return;
            }
            for (const connection of receivers) {
                if (connection.signal == null) {
                    return;
                }
                const receiver = connection.context ?? connection.slot;
                connection.signal = null;
                schedule_cleanup(senders_for_receiver.get(receiver));
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0) {
                return;
            }
            for (const connection of senders) {
                if (connection.signal == null) {
                    return;
                }
                if (slot != null && connection.slot != slot) {
                    continue;
                }
                const sender = connection.signal.sender;
                if (except_senders != null && except_senders.has(sender)) {
                    continue;
                }
                connection.signal = null;
                schedule_cleanup(exports.receivers_for_sender.get(sender));
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            const receivers = exports.receivers_for_sender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (const connection of receivers) {
                    connection.signal = null;
                }
                schedule_cleanup(receivers);
            }
            const senders = senders_for_receiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (const connection of senders) {
                    connection.signal = null;
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return class {
            connect(signal, slot) {
                return signal.connect(slot, this);
            }
            disconnect(signal, slot) {
                return signal.disconnect(slot, this);
            }
        };
    }
    /** @internal */
    exports.receivers_for_sender = new WeakMap();
    const senders_for_receiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return (0, array_1.find)(conns, conn => conn.signal === signal && conn.slot === slot && conn.context === context);
    }
    const dirty_set = new Set();
    function schedule_cleanup(connections) {
        if (dirty_set.size == 0) {
            void (async () => {
                await (0, defer_1.defer)();
                cleanup_dirty_set();
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        for (const connections of dirty_set) {
            (0, array_1.remove_by)(connections, (connection) => connection.signal == null);
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.defer = defer;
    exports.delay = delay;
    exports.poll = poll;
    exports.paint = paint;
    exports.idle = idle;
    const channel = new MessageChannel();
    const tasks = new Map();
    channel.port1.onmessage = (event) => {
        const handle = event.data;
        const fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    let counter = 1;
    function defer() {
        return new Promise((resolve) => {
            const handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    function delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    async function poll(fn, interval = 50, timeout = 500) {
        while (!fn() && timeout >= 0) {
            await delay(interval);
            timeout -= interval;
        }
    }
    function paint() {
        return new Promise((resolve) => {
            requestAnimationFrame(() => resolve());
        });
    }
    function idle() {
        return new Promise((resolve) => {
            requestIdleCallback(() => resolve());
        });
    }
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_ref = is_ref;
    exports.is_HasRefs = is_HasRefs;
    exports.may_have_refs = may_have_refs;
    const types_1 = require(8) /* ./types */;
    function is_ref(obj) {
        return (0, types_1.isPlainObject)(obj) && "id" in obj && !("type" in obj);
    }
    exports.has_refs = Symbol("has_refs");
    function _is_HasRefs(v) {
        return exports.has_refs in v;
    }
    function is_HasRefs(v) {
        return (0, types_1.isObject)(v) && _is_HasRefs(v);
    }
    function may_have_refs(obj) {
        if (_is_HasRefs(obj)) {
            return obj[exports.has_refs];
        }
        const type = obj.constructor;
        if (is_HasRefs(type)) {
            return type[exports.has_refs];
        }
        return true;
    }
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ExtMarkerType = exports.ArraySpec = exports.NullStringSpec = exports.StringSpec = void 0;
    exports.isSpec = isSpec;
    exports.use_theme = use_theme;
    exports.Alias = Alias;
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(16) /* ./signaling */;
    const logging_1 = require(20) /* ./logging */;
    const enums = tslib_1.__importStar(require(21) /* ./enums */);
    const types_1 = require(25) /* ./types */;
    const array_1 = require(10) /* ./util/array */;
    const arrayable_1 = require(13) /* ./util/arrayable */;
    const math_1 = require(11) /* ./util/math */;
    const color_1 = require(23) /* ./util/color */;
    const platform_1 = require(28) /* ./util/platform */;
    const types_2 = require(8) /* ./util/types */;
    const vectorization_1 = require(29) /* ./vectorization */;
    const settings_1 = require(30) /* ./settings */;
    const kinds_1 = require(22) /* ./kinds */;
    const ndarray_1 = require(31) /* ./util/ndarray */;
    const diagnostics_1 = require(39) /* ./diagnostics */;
    const assert_1 = require(12) /* ./util/assert */;
    const serialization_1 = require(33) /* ./serialization */;
    const uniforms_1 = require(40) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    class ValidationError extends Error {
    }
    exports.ValidationError = ValidationError;
    ValidationError.__name__ = "ValidationError";
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return (0, types_2.isPlainObject)(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    let global_theme = null;
    function use_theme(theme = null) {
        global_theme = theme;
    }
    exports.unset = Symbol("unset");
    class UnsetValueError extends Error {
    }
    exports.UnsetValueError = UnsetValueError;
    UnsetValueError.__name__ = "UnsetValueError";
    class Property {
        get syncable() {
            return !this.internal;
        }
        get is_unset() {
            return this._value === exports.unset;
        }
        get initialized() {
            return this._initialized;
        }
        initialize(initial_value = exports.unset) {
            if (this._initialized) {
                throw new Error("already initialized");
            }
            let attr_value = exports.unset;
            if (initial_value !== exports.unset) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                const value = this._default_override();
                if (value !== exports.unset) {
                    attr_value = value;
                }
                else {
                    let themed = false;
                    if (global_theme != null) {
                        const value = global_theme.get(this.obj, this.attr);
                        if (value !== undefined) {
                            attr_value = value;
                            themed = true;
                        }
                    }
                    if (!themed) {
                        attr_value = this.default_value(this.obj);
                    }
                }
            }
            if (attr_value !== exports.unset) {
                if (this.kind.coerce != null) {
                    attr_value = this.kind.coerce(attr_value);
                }
                this._update(attr_value);
            }
            else {
                this._value = exports.unset;
            }
            this._initialized = true;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new UnsetValueError(`${this.obj}.${this.attr} is unset`);
            }
        }
        set_value(val) {
            if (!this._initialized) {
                this.initialize(val);
            }
            else {
                this._update(val);
                this._dirty = true;
            }
            diagnostics_1.diagnostics.report(this);
        }
        // abstract _intrinsic_default(): T
        _default_override() {
            return exports.unset;
        }
        get dirty() {
            return this._dirty;
        }
        constructor(obj, attr, kind, default_value, options = {}) {
            this._value = exports.unset;
            this._initialized = false;
            this._dirty = false;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = options.internal ?? false;
            this.readonly = options.readonly ?? false;
            this.convert = options.convert;
            this.on_update = options.on_update;
            this.may_have_refs = kind.may_have_refs();
        }
        //protected abstract _update(attr_value: T): void
        _update(attr_value) {
            this.validate(attr_value);
            if (this.convert != null) {
                const converted = this.convert(attr_value, this.obj);
                if (converted !== undefined) {
                    attr_value = converted;
                }
            }
            this._value = attr_value;
            this.on_update?.(attr_value, this.obj);
        }
        toString() {
            /*${this.name}*/
            return `Prop(${this.obj}.${this.attr}, value: ${valueToString(this._value)})`;
        }
        // ----- customizable policies
        normalize(values) {
            return values;
        }
        validate(value) {
            if (!this.valid(value)) {
                throw new ValidationError(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
            }
        }
        valid(value) {
            return this.kind.valid(value);
        }
    }
    exports.Property = Property;
    Property.__name__ = "Property";
    class PropertyAlias {
        constructor(attr) {
            this.attr = attr;
        }
    }
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    //
    // Primitive Properties
    //
    class PrimitiveProperty extends Property {
    }
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    class Font extends PrimitiveProperty {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // DataSpec properties
    //
    class ScalarSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
        _update(attr_value) {
            if (isSpec(attr_value)) {
                this._value = attr_value;
            }
            else {
                this._value = { value: attr_value }; // Value<T>
            }
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined) {
                            return { type: "value", value, transform, units };
                        }
                        else if (field !== undefined) {
                            return { type: "field", field, transform, units };
                        }
                        else {
                            return { type: "expr", expr, transform, units };
                        }
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value)) {
                this.validate(this._value.value);
            }
        }
        materialize(value) {
            return value;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        uniform(source) {
            const obj = this.get_value();
            const n = source.get_length() ?? 1;
            if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let result = expr.compute(source);
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                const { value, transform } = obj;
                let result = value;
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        }
    }
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    /** @deprecated */
    class AnyScalar extends ScalarSpec {
    }
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    class DictScalar extends ScalarSpec {
    }
    exports.DictScalar = DictScalar;
    DictScalar.__name__ = "DictScalar";
    class ColorScalar extends ScalarSpec {
    }
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    class NumberScalar extends ScalarSpec {
    }
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    class StringScalar extends ScalarSpec {
    }
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    class NullStringScalar extends ScalarSpec {
    }
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    class ArrayScalar extends ScalarSpec {
    }
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    class LineJoinScalar extends ScalarSpec {
    }
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    class LineCapScalar extends ScalarSpec {
    }
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    class LineDashScalar extends ScalarSpec {
    }
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    class FontScalar extends ScalarSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    class FontSizeScalar extends ScalarSpec {
    }
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    class FontStyleScalar extends ScalarSpec {
    }
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    class TextAlignScalar extends ScalarSpec {
    }
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    class TextBaselineScalar extends ScalarSpec {
    }
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    class VectorSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
        _update(attr_value) {
            if (isSpec(attr_value)) {
                this._value = attr_value;
            }
            else {
                this._value = { value: attr_value };
            } // Value<T>
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined) {
                            return { type: "value", value, transform, units };
                        }
                        else if (field !== undefined) {
                            return { type: "field", field, transform, units };
                        }
                        else {
                            return { type: "expr", expr, transform, units };
                        }
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value)) {
                this.validate(this._value.value);
            }
        }
        materialize(value) {
            return value;
        }
        v_materialize(values) {
            return values;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        vector(values) {
            return new uniforms_1.UniformVector(values);
        }
        uniform(source) {
            const obj = this.get_value();
            const n = source.get_length() ?? 1;
            if ((0, vectorization_1.isField)(obj)) {
                const { field, transform } = obj;
                let array = source.get_column(field);
                if (array != null) {
                    if (transform != null) {
                        array = transform.v_compute(array);
                    }
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    const message = `attempted to retrieve property array for nonexistent field '${field}'`;
                    if (settings_1.settings.force_fields) {
                        throw new Error(message);
                    }
                    else {
                        logging_1.logger.warn(message);
                    }
                    return this.scalar(null, n);
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let array = expr.v_compute(source);
                if (transform != null) {
                    array = transform.v_compute(array);
                }
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else if ((0, vectorization_1.isValue)(obj)) {
                const { value, transform } = obj;
                let result = value;
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                (0, assert_1.unreachable)();
            }
        }
        array(source) {
            let array;
            const length = source.get_length() ?? 1;
            const obj = this.get_value();
            if ((0, vectorization_1.isField)(obj)) {
                const { field } = obj;
                const column = source.get_column(field);
                if (column != null) {
                    array = this.normalize(column);
                }
                else {
                    const message = `attempted to retrieve property array for nonexistent field '${field}'`;
                    if (settings_1.settings.force_fields) {
                        throw new Error(message);
                    }
                    else {
                        logging_1.logger.warn(message);
                    }
                    const missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr } = obj;
                array = this.normalize(expr.v_compute(source));
            }
            else {
                const value = this.normalize([obj.value])[0];
                if ((0, types_2.isNumber)(value)) {
                    const values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else {
                    array = (0, array_1.repeat)(value, length);
                }
            }
            const { transform } = obj;
            if (transform != null) {
                array = transform.v_compute(array);
            }
            return array;
        }
    }
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    class DataSpec extends VectorSpec {
    }
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    class UnitsSpec extends VectorSpec {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        _update(attr_value) {
            super._update(attr_value);
            if (this._value !== exports.unset) {
                const { units } = this._value;
                if (units != null && !(0, array_1.includes)(this.valid_units, units)) {
                    throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units}`);
                }
            }
        }
        get units() {
            return this._value !== exports.unset ? this._value.units ?? this.default_units : this.default_units;
        }
        set units(units) {
            if (this._value !== exports.unset) {
                if (units != this.default_units) {
                    this._value.units = units;
                }
                else {
                    delete this._value.units;
                }
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
    }
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    class NumberUnitsSpec extends UnitsSpec {
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    class BaseCoordinateSpec extends DataSpec {
    }
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    class CoordinateSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    class CoordinateSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    class XCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    class YCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    class XCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    class YCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    class AngleSpec extends NumberUnitsSpec {
        get default_units() {
            return "rad";
        }
        get valid_units() {
            return [...enums.AngleUnits];
        }
        materialize(value) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            return value * coeff;
        }
        v_materialize(values) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            const result = new Float32Array(values.length);
            (0, arrayable_1.mul)(values, coeff, result); // TODO: in-place?
            return result;
        }
        array(_source) {
            throw new Error("not supported");
        }
    }
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    class DistanceSpec extends NumberUnitsSpec {
        get default_units() {
            return "data";
        }
        get valid_units() {
            return [...enums.SpatialUnits];
        }
    }
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    class NullDistanceSpec extends DistanceSpec {
        materialize(value) {
            return value ?? NaN;
        }
    }
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    class BooleanSpec extends DataSpec {
        v_materialize(values) {
            return new Uint8Array(values);
        }
        array(source) {
            return new Uint8Array(super.array(source));
        }
    }
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    class IntSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Int32Array(values);
        }
        array(source) {
            return new Int32Array(super.array(source));
        }
    }
    exports.IntSpec = IntSpec;
    IntSpec.__name__ = "IntSpec";
    class NumberSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Float64Array(values);
        }
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    class ScreenSizeSpec extends NumberSpec {
        valid(value) {
            return (0, types_2.isNumber)(value) && value >= 0;
        }
    }
    exports.ScreenSizeSpec = ScreenSizeSpec;
    ScreenSizeSpec.__name__ = "ScreenSizeSpec";
    class ColorSpec extends DataSpec {
        materialize(color) {
            return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
        }
        v_materialize(colors) {
            if ((0, ndarray_1.is_NDArray)(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return (0, platform_1.to_big_endian)(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    const [n] = colors.shape;
                    const array = new types_1.RGBAArray(4 * n);
                    let j = 0;
                    for (const gray of colors) {
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = 255;
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 3 || d == 4) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if (colors.dtype == "object" && colors.dimension == 1) {
                    return this._from_css_array(colors);
                }
            }
            else {
                return this._from_css_array(colors);
            }
            throw new Error("invalid color array");
        }
        _from_css_array(colors) {
            const n = colors.length;
            const array = new types_1.RGBAArray(4 * n);
            let j = 0;
            for (const color of colors) {
                const [r, g, b, a] = (0, color_1.color2rgba)(color);
                array[j++] = r;
                array[j++] = g;
                array[j++] = b;
                array[j++] = a;
            }
            return new types_1.ColorArray(array.buffer);
        }
        vector(values) {
            return new uniforms_1.ColorUniformVector(values);
        }
    }
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    class NDArraySpec extends DataSpec {
    }
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    /** @deprecated */
    class AnySpec extends DataSpec {
    }
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    class StringSpec extends DataSpec {
    }
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    class NullStringSpec extends DataSpec {
    }
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    class ArraySpec extends DataSpec {
    }
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    exports.ExtMarkerType = (0, kinds_1.PrefixedStr)("@");
    class MarkerSpec extends DataSpec {
    }
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    class LineJoinSpec extends DataSpec {
    }
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    class LineCapSpec extends DataSpec {
    }
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    class LineDashSpec extends DataSpec {
    }
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    class FontSpec extends DataSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    class FontSizeSpec extends DataSpec {
    }
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    class FontStyleSpec extends DataSpec {
    }
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    class TextAlignSpec extends DataSpec {
    }
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    class TextBaselineSpec extends DataSpec {
    }
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.set_log_level = set_log_level;
    exports.with_log_level = with_log_level;
    // This is based on https://github.com/pimterry/loglevel
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const version_1 = require(3) /* ../version */;
    const _loggers = {};
    class LogLevel {
        constructor(name, level, method) {
            this.name = name;
            this.level = level;
            this.method = method;
        }
    }
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    class Logger {
        static get levels() {
            return Object.keys(Logger.log_levels);
        }
        static get(name, level = Logger.INFO) {
            if (name.length > 0) {
                if (name in _loggers) {
                    return _loggers[name];
                }
                else {
                    return _loggers[name] = new Logger(name, level);
                }
            }
            else {
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
            }
        }
        constructor(name, level = Logger.INFO) {
            this._name = name;
            this.set_level(level);
        }
        get level() {
            return this.get_level();
        }
        get_level() {
            return this._log_level;
        }
        set_level(log_level) {
            if (log_level instanceof LogLevel) {
                this._log_level = log_level;
            }
            else if (Logger.log_levels.hasOwnProperty(log_level)) {
                this._log_level = Logger.log_levels[log_level];
            }
            else {
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            }
            const prefix = `[${this._name}]`;
            for (const { level, method } of (0, object_1.values)(Logger.log_levels)) {
                if (level < this._log_level.level || this._log_level.level === Logger.OFF.level) {
                    this[method] = function () { };
                }
                else {
                    this[method] = _method_factory(method, prefix);
                }
            }
            this.log = _method_factory("log", prefix);
        }
        log(..._args) { }
        trace(..._args) { }
        debug(..._args) { }
        info(..._args) { }
        warn(..._args) { }
        error(..._args) { }
    }
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0, "trace");
    Logger.DEBUG = new LogLevel("debug", 1, "debug");
    Logger.INFO = new LogLevel("info", 2, "info");
    Logger.WARN = new LogLevel("warn", 6, "warn");
    Logger.ERROR = new LogLevel("error", 7, "error");
    Logger.FATAL = new LogLevel("fatal", 8, "error");
    Logger.OFF = new LogLevel("off", 9, "log");
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, prefix) {
        const method = console[method_name];
        const fn = typeof method != "undefined" ? method : console.log;
        return fn.bind(console, prefix);
    }
    exports.logger = Logger.get(`bokeh ${version_1.version}`);
    function set_log_level(level) {
        const previous_level = exports.logger.level;
        if ((0, types_1.isString)(level) && !(level in Logger.log_levels)) {
            exports.logger.log(`unrecognized logging level '${level}' passed to Bokeh.set_log_level(), ignoring`);
            exports.logger.log(`valid log levels are: ${Logger.levels.join(", ")}`);
        }
        else {
            exports.logger.log(`setting log level to: '${(0, types_1.isString)(level) ? level : level.level}'`);
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    function with_log_level(level, fn) {
        const original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.ToolName = exports.ToolIcon = exports.WindowAxis = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.LabelOrientation = exports.TimedeltaResolutionType = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapGesture = exports.TapBehavior = exports.StepMode = exports.StartEnd = exports.SpatialUnits = exports.Sort = exports.SizingMode = exports.Side = exports.SelectionMode = exports.RegionSelectionMode = exports.ScrollbarPolicy = void 0;
    const kinds_1 = require(22) /* ./kinds */;
    exports.Align = (0, kinds_1.Enum)("start", "center", "end");
    exports.HAlign = (0, kinds_1.Enum)("left", "center", "right");
    exports.VAlign = (0, kinds_1.Enum)("top", "center", "bottom");
    exports.Anchor = (0, kinds_1.Enum)("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = (0, kinds_1.Enum)("deg", "rad", "grad", "turn");
    exports.AlternationPolicy = (0, kinds_1.Enum)("none", "even", "odd", "every");
    exports.AxisLabelStandoffMode = (0, kinds_1.Enum)("tick_labels", "axis");
    exports.BoxOrigin = (0, kinds_1.Enum)("corner", "center");
    exports.ButtonType = (0, kinds_1.Enum)("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = (0, kinds_1.Enum)("auto", "above", "below");
    exports.Clock = (0, kinds_1.Enum)("12h", "24h");
    exports.CoordinateUnits = (0, kinds_1.Enum)("canvas", "screen", "data");
    exports.ContextWhich = (0, kinds_1.Enum)("start", "center", "end", "all");
    exports.Dimension = (0, kinds_1.Enum)("width", "height");
    exports.Dimensions = (0, kinds_1.Enum)("width", "height", "both");
    exports.Direction = (0, kinds_1.Enum)("clock", "anticlock");
    exports.Distribution = (0, kinds_1.Enum)("uniform", "normal");
    exports.Face = (0, kinds_1.Enum)("front", "back");
    exports.FlowMode = (0, kinds_1.Enum)("block", "inline");
    exports.FontStyle = (0, kinds_1.Enum)("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = (0, kinds_1.Enum)("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
    exports.BuiltinFormatter = (0, kinds_1.Enum)("raw", "basic", "numeral", "printf", "datetime");
    exports.HTTPMethod = (0, kinds_1.Enum)("POST", "GET");
    exports.HexTileOrientation = (0, kinds_1.Enum)("pointytop", "flattop");
    exports.HoverMode = (0, kinds_1.Enum)("mouse", "hline", "vline");
    exports.ImageOrigin = (0, kinds_1.Enum)("bottom_left", "top_left", "bottom_right", "top_right");
    exports.LatLon = (0, kinds_1.Enum)("lat", "lon");
    exports.LegendClickPolicy = (0, kinds_1.Enum)("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = (0, kinds_1.Enum)("butt", "round", "square");
    exports.LineDash = (0, kinds_1.Enum)("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LineJoin = (0, kinds_1.Enum)("miter", "round", "bevel");
    exports.LinePolicy = (0, kinds_1.Enum)("prev", "next", "nearest", "interp", "none");
    exports.Location = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.Logo = (0, kinds_1.Enum)("normal", "grey");
    exports.MapType = (0, kinds_1.Enum)("satellite", "roadmap", "terrain", "hybrid");
    exports.MarkerType = (0, kinds_1.Enum)("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = (0, kinds_1.Enum)("show", "ignore");
    exports.Orientation = (0, kinds_1.Enum)("vertical", "horizontal");
    exports.OutlineShapeName = (0, kinds_1.Enum)("none", "box", "rectangle", "square", "circle", "ellipse", "trapezoid", "parallelogram", "diamond", "triangle");
    exports.OutputBackend = (0, kinds_1.Enum)("canvas", "svg", "webgl");
    exports.PaddingUnits = (0, kinds_1.Enum)("percent", "absolute");
    exports.PanDirection = (0, kinds_1.Enum)("left", "right", "up", "down", "west", "east", "north", "south");
    exports.Place = (0, kinds_1.Enum)("above", "below", "left", "right", "center");
    exports.PointPolicy = (0, kinds_1.Enum)("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = (0, kinds_1.Enum)("x", "y", "max", "min");
    exports.RenderLevel = (0, kinds_1.Enum)("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.ResetPolicy = (0, kinds_1.Enum)("standard", "event_only");
    exports.ResolutionType = (0, kinds_1.Enum)("microseconds", "milliseconds", "seconds", "minsec", "minutes", "hourmin", "hours", "days", "months", "years");
    exports.RoundingFunction = (0, kinds_1.Enum)("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.ScrollbarPolicy = (0, kinds_1.Enum)("auto", "visible", "hidden");
    exports.RegionSelectionMode = (0, kinds_1.Enum)("replace", "append", "intersect", "subtract", "xor");
    exports.SelectionMode = (0, kinds_1.Enum)(...exports.RegionSelectionMode, "toggle");
    exports.Side = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.SizingMode = (0, kinds_1.Enum)("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed", "inherit");
    exports.Sort = (0, kinds_1.Enum)("ascending", "descending");
    exports.SpatialUnits = (0, kinds_1.Enum)("screen", "data");
    exports.StartEnd = (0, kinds_1.Enum)("start", "end");
    exports.StepMode = (0, kinds_1.Enum)("after", "before", "center");
    exports.TapBehavior = (0, kinds_1.Enum)("select", "inspect");
    exports.TapGesture = (0, kinds_1.Enum)("tap", "doubletap");
    exports.TextAlign = (0, kinds_1.Enum)("left", "right", "center");
    exports.TextBaseline = (0, kinds_1.Enum)("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = (0, kinds_1.Enum)("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TimedeltaResolutionType = (0, kinds_1.Enum)("nanoseconds", "microseconds", "milliseconds", "seconds", "minsec", "minutes", "hourmin", "hours", "days");
    exports.LabelOrientation = (0, kinds_1.Enum)("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = (0, kinds_1.Enum)("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = (0, kinds_1.Enum)("replace", "append");
    exports.VerticalAlign = (0, kinds_1.Enum)("top", "middle", "bottom");
    exports.WindowAxis = (0, kinds_1.Enum)("none", "x", "y");
    // Keep this in sync with bokehjs/src/less/icons.less
    exports.ToolIcon = (0, kinds_1.Enum)("append_mode", "arrow_down_to_bar", "arrow_up_from_bar", "auto_box_zoom", "bold", "box_edit", "box_select", "box_zoom", "caret_down", "caret_left", "caret_right", "caret_up", "check", "chevron_down", "chevron_left", "chevron_right", "chevron_up", "clear_selection", "copy", "crosshair", "dark_theme", "delete", "freehand_draw", "fullscreen", "help", "hover", "intersect_mode", "invert_selection", "italic", "lasso_select", "light_theme", "line_edit", "maximize", "minimize", "pan", "pin", "point_draw", "pointer", "poly_draw", "poly_edit", "polygon_select", "range", "redo", "replace_mode", "reset", "save", "see_off", "see_on", "settings", "square", "square_check", "subtract_mode", "tap_select", "text_align_center", "text_align_left", "text_align_right", "undo", "unknown", "unpin", "wheel_pan", "wheel_zoom", "x_box_select", "x_box_zoom", "x_grip", "x_pan", "xor_mode", "y_box_select", "y_box_zoom", "y_grip", "y_pan", "zoom_in", "zoom_out");
    exports.ToolName = (0, kinds_1.Enum)("auto_box_zoom", "box_select", "box_zoom", "click", "copy", "crosshair", "doubletap", "examine", "freehand_draw", "fullscreen", "help", "hover", "lasso_select", "pan", "pan_down", "pan_east", "pan_left", "pan_north", "pan_right", "pan_south", "pan_up", "pan_west", "poly_select", "redo", "reset", "save", "tap", "undo", "wheel_zoom", "xbox_select", "xbox_zoom", "xcrosshair", "xpan", "xwheel_pan", "xwheel_zoom", "xzoom_in", "xzoom_out", "ybox_select", "ybox_zoom", "ycrosshair", "ypan", "ywheel_pan", "ywheel_zoom", "yzoom_in", "yzoom_out", "zoom_in", "zoom_out");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const tp = tslib_1.__importStar(require(8) /* ./util/types */);
    const color_1 = require(23) /* ./util/color */;
    const object_1 = require(9) /* ./util/object */;
    const refs_1 = require(18) /* ./util/refs */;
    const ESMap = globalThis.Map;
    const ESSet = globalThis.Set;
    const DOMNode = globalThis.Node;
    class Kind {
    }
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        class Primitive extends Kind {
            may_have_refs() {
                return false;
            }
        }
        Primitive.__name__ = "Primitive";
        Kinds.Primitive = Primitive;
        class Any extends Primitive {
            valid(value) {
                return value !== undefined;
            }
            toString() {
                return "Any";
            }
            may_have_refs() {
                return true;
            }
        }
        Any.__name__ = "Any";
        Kinds.Any = Any;
        class Unknown extends Primitive {
            valid(value) {
                return value !== undefined;
            }
            toString() {
                return "Unknown";
            }
            may_have_refs() {
                return true;
            }
        }
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        class Bool extends Primitive {
            valid(value) {
                return tp.isBoolean(value);
            }
            toString() {
                return "Bool";
            }
        }
        Bool.__name__ = "Bool";
        Kinds.Bool = Bool;
        class Ref extends Kind {
            constructor(obj_type) {
                super();
                this.obj_type = obj_type;
            }
            valid(value) {
                return value instanceof this.obj_type;
            }
            toString() {
                const tp = this.obj_type;
                // NOTE: `__name__` is injected by a compiler transform
                const name = tp.__name__ ?? tp.toString();
                return `Ref(${name})`;
            }
            may_have_refs() {
                const { obj_type } = this;
                return refs_1.has_refs in obj_type ? obj_type[refs_1.has_refs] : true;
            }
        }
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        class AnyRef extends Kind {
            valid(value) {
                return tp.isObject(value);
            }
            toString() {
                return "AnyRef";
            }
            may_have_refs() {
                return true;
            }
        }
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        class Float extends Primitive {
            valid(value) {
                return tp.isNumber(value);
            }
            toString() {
                return "Float";
            }
        }
        Float.__name__ = "Float";
        Kinds.Float = Float;
        class Int extends Float {
            valid(value) {
                return super.valid(value) && tp.isInteger(value);
            }
            toString() {
                return "Int";
            }
        }
        Int.__name__ = "Int";
        Kinds.Int = Int;
        class Percent extends Float {
            valid(value) {
                return super.valid(value) && 0 <= value && value <= 1;
            }
            toString() {
                return "Percent";
            }
        }
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        class Or extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                return this.types.some((type) => type.valid(value));
            }
            toString() {
                return `Or(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        Or.__name__ = "Or";
        Kinds.Or = Or;
        class And extends Kind {
            constructor(type0, type1) {
                super();
                this.types = [type0, type1];
            }
            valid(value) {
                return this.types.some((type) => type.valid(value)); // TODO not sure if this is correct, probably not
            }
            toString() {
                return `And(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        And.__name__ = "And";
        Kinds.And = And;
        class Tuple extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                if (!tp.isArray(value)) {
                    return false;
                }
                for (let i = 0; i < this.types.length; i++) {
                    const type = this.types[i];
                    const item = value[i];
                    if (!type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Tuple(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        class Struct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value)) {
                    return false;
                }
                const struct_type_proxy = new object_1.PlainObjectProxy(this.struct_type);
                for (const key of (0, object_1.keys)(value)) {
                    if (!struct_type_proxy.has(key)) {
                        return false;
                    }
                }
                for (const [key, item_type] of struct_type_proxy) {
                    const item = value[key];
                    if (!item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                const items = (0, object_1.typed_entries)(this.struct_type).map(([key, kind]) => `${key.toString()}: ${kind}`).join(", ");
                return `Struct({${items}})`;
            }
            may_have_refs() {
                return (0, object_1.typed_values)(this.struct_type).some((kind) => kind.may_have_refs());
            }
        }
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        class PartialStruct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value)) {
                    return false;
                }
                const value_proxy = new object_1.PlainObjectProxy(value);
                const struct_type_proxy = new object_1.PlainObjectProxy(this.struct_type);
                for (const key of value_proxy.keys()) {
                    if (!struct_type_proxy.has(key)) {
                        return false;
                    }
                }
                for (const [key, item_type] of struct_type_proxy) {
                    const item = value_proxy.get(key);
                    if (item === undefined) {
                        continue;
                    }
                    if (!item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                const items = (0, object_1.typed_entries)(this.struct_type).map(([key, kind]) => `${key.toString()}?: ${kind}`).join(", ");
                return `Struct({${items}})`;
            }
            may_have_refs() {
                return (0, object_1.typed_values)(this.struct_type).some((kind) => kind.may_have_refs());
            }
        }
        PartialStruct.__name__ = "PartialStruct";
        Kinds.PartialStruct = PartialStruct;
        class Iterable extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isIterable(value);
            }
            toString() {
                return `Iterable(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Iterable.__name__ = "Iterable";
        Kinds.Iterable = Iterable;
        class Arrayable extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            }
            toString() {
                return `Arrayable(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        class List extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) && value.every((item) => this.item_type.valid(item));
            }
            toString() {
                return `List(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        List.__name__ = "List";
        Kinds.List = List;
        class NonEmptyList extends List {
            valid(value) {
                return super.valid(value) && value.length != 0;
            }
            toString() {
                return `NonEmptyList(${this.item_type.toString()})`;
            }
        }
        NonEmptyList.__name__ = "NonEmptyList";
        Kinds.NonEmptyList = NonEmptyList;
        class Null extends Primitive {
            valid(value) {
                return value === null;
            }
            toString() {
                return "Null";
            }
        }
        Null.__name__ = "Null";
        Kinds.Null = Null;
        class Nullable extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === null || this.base_type.valid(value);
            }
            toString() {
                return `Nullable(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        class Opt extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === undefined || this.base_type.valid(value);
            }
            toString() {
                return `Opt(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        class Bytes extends Kind {
            valid(value) {
                return value instanceof ArrayBuffer;
            }
            toString() {
                return "Bytes";
            }
            may_have_refs() {
                return false;
            }
        }
        Bytes.__name__ = "Bytes";
        Kinds.Bytes = Bytes;
        class Str extends Primitive {
            valid(value) {
                return tp.isString(value);
            }
            toString() {
                return "Str";
            }
        }
        Str.__name__ = "Str";
        Kinds.Str = Str;
        class PrefixedStr extends Primitive {
            constructor(prefix) {
                super();
                this.prefix = prefix;
            }
            valid(value) {
                return tp.isString(value) && value.startsWith(this.prefix);
            }
            toString() {
                return `PrefixedStr('${this.prefix}')`;
            }
        }
        PrefixedStr.__name__ = "PrefixedStr";
        Kinds.PrefixedStr = PrefixedStr;
        class Regex extends Str {
            constructor(regex) {
                super();
                this.regex = regex;
            }
            valid(value) {
                return super.valid(value) && this.regex.test(value);
            }
            toString() {
                return `Regex(${this.regex.toString()})`;
            }
        }
        Regex.__name__ = "Regex";
        Kinds.Regex = Regex;
        class Enum extends Primitive {
            constructor(values) {
                super();
                this.values = new ESSet(values);
            }
            valid(value) {
                return this.values.has(value);
            }
            *[Symbol.iterator]() {
                yield* this.values;
            }
            toString() {
                return `Enum(${[...this.values].map((v) => v.toString()).join(", ")})`;
            }
        }
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        class Dict extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap || tp.isPlainObject(value))) {
                    return false;
                }
                for (const item of (0, object_1.values)(value)) {
                    if (!this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Dict(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        class KeyVal extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap || tp.isPlainObject(value))) {
                    return false;
                }
                for (const [key, item] of (0, object_1.entries)(value)) {
                    if (!this.key_type.valid(key) || !this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `KeyVal(${this.key_type.toString()}, ${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.key_type.may_have_refs() || this.item_type.may_have_refs();
            }
        }
        KeyVal.__name__ = "KeyVal";
        Kinds.KeyVal = KeyVal;
        class Mapping extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            coerce(value) {
                // HACK accommodate for deserialization of {type: "map"}
                if (tp.isPlainObject(value) && (0, object_1.is_empty)(value)) {
                    return new ESMap();
                }
                else {
                    return value;
                }
            }
            valid(value) {
                if (!(value instanceof ESMap)) {
                    return false;
                }
                for (const [key, item] of value.entries()) {
                    if (!(this.key_type.valid(key) && this.item_type.valid(item))) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Mapping(${this.key_type.toString()}, ${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.key_type.may_have_refs() || this.item_type.may_have_refs();
            }
        }
        Mapping.__name__ = "Mapping";
        Kinds.Mapping = Mapping;
        class Set extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESSet)) {
                    return false;
                }
                for (const item of value) {
                    if (!this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Set(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Set.__name__ = "Set";
        Kinds.Set = Set;
        class Color extends Kind {
            valid(value) {
                return (0, color_1.is_Color)(value);
            }
            toString() {
                return "Color";
            }
            may_have_refs() {
                return false;
            }
        }
        Color.__name__ = "Color";
        Kinds.Color = Color;
        class CSSLength extends Str {
            /*
            override valid(value: unknown): value is string {
              return super.valid(value) // TODO: && this._parse(value)
            }
            */
            toString() {
                return "CSSLength";
            }
        }
        CSSLength.__name__ = "CSSLength";
        Kinds.CSSLength = CSSLength;
        class Func extends Kind {
            constructor(args_types, ret_type) {
                super();
                this.args_types = args_types;
                this.ret_type = ret_type;
            }
            valid(value) {
                return tp.isFunction(value);
            }
            toString() {
                const { args_types, ret_type } = this;
                const args = args_types == null ? "?" : args_types.map((type) => type.toString()).join(", ");
                const ret = ret_type == null ? "?" : ret_type.toString();
                return `Func((${args}), ${ret})`;
            }
            may_have_refs() {
                return false;
            }
        }
        Func.__name__ = "Func";
        Kinds.Func = Func;
        class NonNegative extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value >= 0;
            }
            toString() {
                return `NonNegative(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        NonNegative.__name__ = "NonNegative";
        Kinds.NonNegative = NonNegative;
        class Positive extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value > 0;
            }
            toString() {
                return `Positive(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Positive.__name__ = "Positive";
        Kinds.Positive = Positive;
        class Node extends Kind {
            valid(value) {
                return value instanceof DOMNode;
            }
            toString() {
                return "Node";
            }
            may_have_refs() {
                return false;
            }
        }
        Node.__name__ = "Node";
        Kinds.Node = Node;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Bool = new exports.Kinds.Bool();
    exports.Float = new exports.Kinds.Float();
    exports.Int = new exports.Kinds.Int();
    exports.Bytes = new exports.Kinds.Bytes();
    exports.Str = new exports.Kinds.Str();
    const PrefixedStr = (prefix) => new exports.Kinds.PrefixedStr(prefix);
    exports.PrefixedStr = PrefixedStr;
    const Regex = (regex) => new exports.Kinds.Regex(regex);
    exports.Regex = Regex;
    exports.Null = new exports.Kinds.Null();
    const Nullable = (base_type) => new exports.Kinds.Nullable(base_type);
    exports.Nullable = Nullable;
    const Opt = (base_type) => new exports.Kinds.Opt(base_type);
    exports.Opt = Opt;
    const Or = (...types) => new exports.Kinds.Or(types);
    exports.Or = Or;
    const And = (type0, type1) => new exports.Kinds.And(type0, type1);
    exports.And = And;
    const Tuple = (...types) => new exports.Kinds.Tuple(types);
    exports.Tuple = Tuple;
    const Struct = (struct_type) => new exports.Kinds.Struct(struct_type);
    exports.Struct = Struct;
    const PartialStruct = (struct_type) => new exports.Kinds.PartialStruct(struct_type);
    exports.PartialStruct = PartialStruct;
    const Iterable = (item_type) => new exports.Kinds.Iterable(item_type);
    exports.Iterable = Iterable;
    const Arrayable = (item_type) => new exports.Kinds.Arrayable(item_type);
    exports.Arrayable = Arrayable;
    const List = (item_type) => new exports.Kinds.List(item_type);
    exports.List = List;
    const NonEmptyList = (item_type) => new exports.Kinds.NonEmptyList(item_type);
    exports.NonEmptyList = NonEmptyList;
    const Dict = (item_type) => new exports.Kinds.Dict(item_type);
    exports.Dict = Dict;
    const KeyVal = (key_type, item_type) => new exports.Kinds.KeyVal(key_type, item_type);
    exports.KeyVal = KeyVal;
    const Mapping = (key_type, item_type) => new exports.Kinds.Mapping(key_type, item_type);
    exports.Mapping = Mapping;
    const Set = (item_type) => new exports.Kinds.Set(item_type);
    exports.Set = Set;
    const Enum = (...values) => new exports.Kinds.Enum(values);
    exports.Enum = Enum;
    const Ref = (obj_type) => new exports.Kinds.Ref(obj_type);
    exports.Ref = Ref;
    const AnyRef = () => new exports.Kinds.AnyRef();
    exports.AnyRef = AnyRef;
    const Func = (args_types, ret_type) => new exports.Kinds.Func(args_types, ret_type);
    exports.Func = Func;
    const Func0 = (ret_type) => new exports.Kinds.Func([], ret_type);
    exports.Func0 = Func0;
    exports.Node = new exports.Kinds.Node();
    const NonNegative = (base_type) => new exports.Kinds.NonNegative(base_type);
    exports.NonNegative = NonNegative;
    const Positive = (base_type) => new exports.Kinds.Positive(base_type);
    exports.Positive = Positive;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = (0, exports.Enum)("auto");
    exports.CSSLength = new exports.Kinds.CSSLength();
    exports.FontSize = exports.Str;
    exports.Font = exports.Str;
    exports.Angle = exports.Float;
    // backwards compatibility aliases (these collide with built-in types)
    /** @deprecated */
    exports.Boolean = exports.Bool;
    /** @deprecated */
    exports.String = exports.Str;
    /** @deprecated */
    exports.Number = exports.Float;
    /** @deprecated */
    exports.Array = exports.List;
    /** @deprecated */
    exports.Map = exports.Mapping;
    /** @deprecated */
    exports.Function = exports.Func;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.byte = byte;
    exports.transparent = transparent;
    exports.encode_rgba = encode_rgba;
    exports.decode_rgba = decode_rgba;
    exports.color2rgba = color2rgba;
    exports.rgba2css = rgba2css;
    exports.color2css = color2css;
    exports.color2hex = color2hex;
    exports.color2hexrgb = color2hexrgb;
    exports.css4_parse = css4_parse;
    exports.is_Color = is_Color;
    exports.is_dark = is_dark;
    exports.brightness = brightness;
    exports.luminance = luminance;
    const svg_colors_1 = require(24) /* ./svg_colors */;
    const math_1 = require(11) /* ./math */;
    const types_1 = require(8) /* ./types */;
    const { round, sqrt } = Math;
    function byte(v) {
        return (0, math_1.clamp)(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    function encode_rgba([r, g, b, a]) {
        return r << 24 | g << 16 | b << 8 | a;
    }
    function decode_rgba(rgba) {
        const r = (rgba >> 24) & 0xff;
        const g = (rgba >> 16) & 0xff;
        const b = (rgba >> 8) & 0xff;
        const a = rgba & 0xff;
        return [r, g, b, a];
    }
    function color2rgba(color, alpha = 1.0) {
        const [r, g, b, a] = (() => {
            if (color == null) {
                return transparent();
            }
            else if ((0, types_1.isInteger)(color)) {
                return decode_rgba(color);
            }
            else if ((0, types_1.isString)(color)) {
                const [r, g, b, a] = css4_parse(color) ?? transparent();
                return [r, g, b, byte(a * 255)];
            }
            else {
                if (color.length == 2) {
                    const [name, alpha] = color;
                    return color2rgba(name, alpha);
                }
                else {
                    const [r, g, b, a = 1.0] = color;
                    return [r, g, b, byte(a * 255)];
                }
            }
        })();
        return [r, g, b, byte(alpha * a)];
    }
    const _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function rgba2css([r, g, b, a]) {
        const alpha = a == 255 ? "" : ` / ${a / 255}`;
        return `rgb(${r} ${g} ${b}${alpha})`;
    }
    function color2css(color, alpha) {
        if ((0, types_1.isString)(color) && (alpha == null || alpha == 1.0)) {
            return color; // passthrough to persist color in its original form
        }
        else {
            const [r, g, b, a] = color2rgba(color, alpha);
            return rgba2css([r, g, b, a]);
        }
    }
    function color2hex(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        const rgb = `#${hex(r)}${hex(g)}${hex(b)}`;
        return a == 255 ? rgb : `${rgb}${hex(a)}`;
    }
    function color2hexrgb(color) {
        const [r, g, b] = color2rgba(color);
        return `#${hex(r)}${hex(g)}${hex(b)}`;
    }
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    const rgb_modern = /^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/;
    const rgb_legacy = /^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/;
    const css4_normalize = (() => {
        const canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        const ctx = canvas.getContext("2d");
        const gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return (color) => {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            const style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (color == "") {
            return null;
        }
        else if (color == "transparent") {
            return transparent();
        }
        else if ((0, svg_colors_1.is_named_color)(color)) {
            const [r, g, b, a] = decode_rgba(svg_colors_1.named_colors[color]);
            return [r, g, b, a / 255];
        }
        else if (color[0] == "#") {
            const v = Number(`0x${color.substring(1)}`);
            if (isNaN(v)) {
                return null;
            }
            switch (color.length - 1) {
                case 3: {
                    const r = (v >> 8) & 0xf;
                    const g = (v >> 4) & 0xf;
                    const b = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    return [rr, gg, bb, 1.0];
                }
                case 4: {
                    const r = (v >> 12) & 0xf;
                    const g = (v >> 8) & 0xf;
                    const b = (v >> 4) & 0xf;
                    const a = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    const aa = (a << 4) | a;
                    return [rr, gg, bb, aa / 255];
                }
                case 6: {
                    const rr = (v >> 16) & 0xff;
                    const gg = (v >> 8) & 0xff;
                    const bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 1.0];
                }
                case 8: {
                    const rr = (v >> 24) & 0xff;
                    const gg = (v >> 16) & 0xff;
                    const bb = (v >> 8) & 0xff;
                    const aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa / 255];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            const result = color.match(rgb_modern) ?? color.match(rgb_legacy);
            if (result?.groups != null) {
                let { r, g, b, a = "1" } = result.groups;
                const rp = r.endsWith("%");
                const gp = g.endsWith("%");
                const bp = b.endsWith("%");
                const ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp))) {
                    return null;
                }
                if (rp) {
                    r = r.slice(0, -1);
                }
                if (gp) {
                    g = g.slice(0, -1);
                }
                if (bp) {
                    b = b.slice(0, -1);
                }
                if (ap) {
                    a = a.slice(0, -1);
                }
                let R = Number(r);
                let G = Number(g);
                let B = Number(b);
                let A = Number(a);
                if (isNaN(R + G + B + A)) {
                    return null;
                }
                if (rp) {
                    R = 255 * (R / 100);
                }
                if (gp) {
                    G = 255 * (G / 100);
                }
                if (bp) {
                    B = 255 * (B / 100);
                }
                A = ap ? A / 100 : A;
                R = byte(R);
                G = byte(G);
                B = byte(B);
                return [R, G, B, A];
            }
        }
        else {
            const style = css4_normalize(color);
            if (style != null) {
                return css4_parse(style);
            }
        }
        return null;
    }
    function is_Color(value) {
        if ((0, types_1.isInteger)(value)) {
            return true;
        }
        if ((0, types_1.isString)(value) && css4_parse(value) != null) {
            return true;
        }
        if ((0, types_1.isArray)(value) && (value.length == 3 || value.length == 4)) {
            return true;
        }
        return false;
    }
    function is_dark([r, g, b]) {
        const l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    function brightness(color) {
        // Perceived brightness of a color in [0, 1] range.
        // http://alienryderflex.com/hsp.html
        const [r, g, b] = color2rgba(color);
        return sqrt(0.299 * r ** 2 + 0.587 * g ** 2 + 0.114 * b ** 2) / 255;
    }
    function luminance(color) {
        // Relative luminance of a color in [0, 1] range.
        // https://en.wikipedia.org/wiki/Relative_luminance
        const [r, g, b] = color2rgba(color);
        return (0.2126 * r ** 2.2 + 0.7152 * g ** 2.2 + 0.0722 * b ** 2.2) / 255 ** 2.2;
    }
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_named_color = is_named_color;
    const _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.infer_type = infer_type;
    exports.to_screen = to_screen;
    exports.GeneratorFunction = Object.getPrototypeOf(function* () { }).constructor;
    exports.AsyncGeneratorFunction = Object.getPrototypeOf(async function* () { }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array) {
            return Float64Array;
        }
        if (a1 instanceof Float64Array || a1 instanceof Array) {
            return Float64Array;
        }
        return Float32Array;
    }
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array)) {
            return Float32Array.from(array);
        }
        else {
            return array;
        }
    }
    var bitset_1 = require(26) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const eq_1 = require(27) /* ./eq */;
    const assert_1 = require(12) /* ./assert */;
    const refs_1 = require(18) /* ./refs */;
    const logging_1 = require(20) /* ../logging */;
    class BitSet {
        constructor(size, init = 0) {
            this[_a] = "BitSet";
            this._count = null;
            this.size = size;
            this._nwords = Math.ceil(size / BitSet._word_length);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                (0, assert_1.assert)(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        clone() {
            return new BitSet(this.size, new Uint32Array(this._array));
        }
        [(_a = Symbol.toStringTag, _b = refs_1.has_refs, eq_1.equals)](that, cmp) {
            if (!cmp.eq(this.size, that.size)) {
                return false;
            }
            const { _nwords } = this;
            const trailing = this.size % BitSet._word_length;
            const n = trailing == 0 ? _nwords : _nwords - 1;
            for (let i = 0; i < n; i++) {
                if (this._array[i] != that._array[i]) {
                    return false;
                }
            }
            if (trailing == 0) {
                return true;
            }
            else {
                const msb = 1 << (trailing - 1);
                const mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        }
        static all_set(size) {
            return new BitSet(size, 1);
        }
        static all_unset(size) {
            return new BitSet(size, 0);
        }
        static from_indices(size, indices) {
            const bits = new BitSet(size);
            for (const i of indices) {
                bits.set(i);
            }
            return bits;
        }
        static from_booleans(size, booleans) {
            const bits = new BitSet(size);
            let i = 0;
            for (const boolean of booleans) {
                if (i == size) {
                    break;
                }
                if (boolean) {
                    bits.set(i);
                }
                i += 1;
            }
            return bits;
        }
        get_unchecked(k) {
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            return ((this._array[i] >> j) & 0b1) == 0b1;
        }
        set_unchecked(k, v = true) {
            this._count = null;
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            if (v) {
                this._array[i] |= 0b1 << j;
            }
            else {
                this._array[i] &= ~(0b1 << j);
            }
        }
        get(k) {
            const { size } = this;
            if (0 <= k && k < size) {
                return this.get_unchecked(k);
            }
            else if (-size <= k && k <= -1) {
                return this.get_unchecked(size + k);
            }
            else {
                return false;
            }
        }
        set(k, v = true) {
            const { size } = this;
            if (0 <= k && k < size) {
                this.set_unchecked(k, v);
            }
            else if (-size <= k && k <= -1) {
                this.set_unchecked(size + k, v);
            }
            else {
                logging_1.logger.warn(`out of bounds access: index=${k >= 0 ? k : size + k} >= size=${size}`);
            }
        }
        unset(k) {
            this.set(k, false);
        }
        *[Symbol.iterator]() {
            yield* this.ones();
        }
        get count() {
            let count = this._count;
            if (count == null) {
                this._count = count = this._get_count();
            }
            return count;
        }
        _get_count() {
            const { _array, _nwords, size } = this;
            let c = 0;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += BitSet._word_length;
                }
                else {
                    for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                        if (((word >>> j) & 0b1) == 0b1) {
                            c += 1;
                        }
                    }
                }
            }
            return c;
        }
        ones() {
            const indices = new Array(this.count);
            let index = 0;
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += BitSet._word_length;
                    continue;
                }
                for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                    if (((word >>> j) & 0b1) == 0b1) {
                        indices[index++] = k;
                    }
                }
            }
            return indices;
        }
        zeros() {
            const indices = new Array(this.count);
            let index = 0;
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0xffffffff) {
                    k += BitSet._word_length;
                    continue;
                }
                for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                    if (((word >>> j) & 0b1) == 0b0) {
                        indices[index++] = k;
                    }
                }
            }
            return indices;
        }
        _check_size(other) {
            (0, assert_1.assert)(this.size == other.size, `Size mismatch (${this.size} != ${other.size})`);
        }
        invert() {
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] = ~this._array[i] >>> 0;
            }
        }
        add(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        }
        intersect(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        }
        subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        }
        symmetric_subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] ^= other._array[i];
            }
        }
        inversion() {
            const result = this.clone();
            result.invert();
            return result;
        }
        union(other) {
            const result = this.clone();
            result.add(other);
            return result;
        }
        intersection(other) {
            const result = this.clone();
            result.intersect(other);
            return result;
        }
        difference(other) {
            const result = this.clone();
            result.subtract(other);
            return result;
        }
        symmetric_difference(other) {
            const result = this.clone();
            result.symmetric_subtract(other);
            return result;
        }
        select(array) {
            (0, assert_1.assert)(this.size <= array.length, "Size mismatch");
            const n = this.count;
            const result = new array.constructor(n);
            const indices = this.ones();
            let i = 0;
            for (let j = 0; j < indices.length; j++) {
                result[i++] = array[indices[j]];
            }
            return result;
        }
    }
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
    BitSet[_b] = false;
    BitSet._word_length = 32;
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_equal = is_equal;
    exports.is_structurally_equal = is_structurally_equal;
    exports.is_similar = is_similar;
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    const types_1 = require(8) /* ./types */;
    const { hasOwnProperty } = Object.prototype;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return (0, types_1.isObject)(obj) && exports.equals in obj;
    }
    exports.wildcard = Symbol("wildcard");
    const toString = Object.prototype.toString;
    class EqNotImplemented extends Error {
    }
    exports.EqNotImplemented = EqNotImplemented;
    EqNotImplemented.__name__ = "EqNotImplemented";
    class Comparator {
        constructor(options) {
            this.a_stack = [];
            this.b_stack = [];
            this.structural = options?.structural ?? false;
        }
        eq(a, b) {
            if (a === b || Object.is(a, b)) {
                return true;
            }
            if (a === exports.wildcard || b === exports.wildcard) {
                return true;
            }
            if (a == null || b == null) {
                return a === b;
            }
            const class_name = toString.call(a);
            if (class_name != toString.call(b)) {
                return false;
            }
            switch (class_name) {
                case "[object Number]":
                    return this.numbers(a, b);
                case "[object Symbol]":
                    return a === b;
                case "[object RegExp]":
                case "[object String]":
                    return `${a}` == `${b}`;
                case "[object Date]":
                case "[object Boolean]":
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            const { a_stack, b_stack } = this;
            let length = a_stack.length;
            while (length-- > 0) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a) {
                    return b_stack[length] === b;
                }
            }
            a_stack.push(a);
            b_stack.push(b);
            const result = (() => {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return this.arrays(a, b);
                    }
                    case "[object ArrayBuffer]":
                    case "[object SharedArrayBuffer]": {
                        return this.array_buffers(a, b);
                    }
                    case "[object Map]": {
                        return this.maps(a, b);
                    }
                    case "[object Set]": {
                        return this.sets(a, b);
                    }
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return this.eq(`${a}`, `${b}`);
                        }
                    }
                }
                if (typeof Node !== "undefined" && a instanceof Node) {
                    return this.nodes(a, b);
                }
                throw new EqNotImplemented(`can't compare objects of type ${class_name}`);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        }
        numbers(a, b) {
            return a === b || Object.is(a, b);
        }
        arrays(a, b) {
            const { length } = a;
            if (length != b.length) {
                return false;
            }
            for (let i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i])) {
                    return false;
                }
            }
            return true;
        }
        array_buffers(a, b) {
            // compare array buffers byte-wise; this doesn't allocate any memory
            return this.arrays(new Uint8Array(a), new Uint8Array(b));
        }
        iterables(a, b) {
            const ai = a[Symbol.iterator]();
            const bi = b[Symbol.iterator]();
            while (true) {
                const an = ai.next();
                const bn = bi.next();
                const an_done = an.done ?? false;
                const bn_done = bn.done ?? false;
                if (an_done && bn_done) {
                    return true;
                }
                if (an_done || bn_done) {
                    return false;
                }
                if (!this.eq(an.value, bn.value)) {
                    return false;
                }
            }
        }
        maps(a, b) {
            if (a.size != b.size) {
                return false;
            }
            if (this.structural) {
                return this.iterables(a.entries(), b.entries());
            }
            else {
                for (const [key, val] of a) {
                    if (!b.has(key) || !this.eq(val, b.get(key))) {
                        return false;
                    }
                }
                return true;
            }
        }
        sets(a, b) {
            if (a.size != b.size) {
                return false;
            }
            if (this.structural) {
                return this.iterables(a.entries(), b.entries());
            }
            else {
                for (const key of a) {
                    if (!b.has(key)) {
                        return false;
                    }
                }
                return true;
            }
        }
        objects(a, b) {
            const keys = Object.keys(a);
            if (keys.length != Object.keys(b).length) {
                return false;
            }
            for (const key of keys) {
                if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key])) {
                    return false;
                }
            }
            return true;
        }
        nodes(a, b) {
            if (this.structural) {
                if (a.nodeType != b.nodeType) {
                    return false;
                }
                if (a.textContent != b.textContent) {
                    return false;
                }
                if (!this.iterables(a.childNodes, b.childNodes)) {
                    return false;
                }
                return true;
            }
            else {
                return a === b;
            }
        }
    }
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    const { abs } = Math;
    class SimilarComparator extends Comparator {
        constructor(tolerance = 1e-4) {
            super();
            this.tolerance = tolerance;
        }
        numbers(a, b) {
            return super.numbers(a, b) || abs(a - b) < this.tolerance;
        }
    }
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        const comparator = new Comparator();
        return comparator.eq(a, b);
    }
    function is_structurally_equal(a, b) {
        const comparator = new Comparator({ structural: true });
        return comparator.eq(a, b);
    }
    function is_similar(a, b, tolerance) {
        const comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.to_big_endian = to_big_endian;
    exports.is_mobile = (() => {
        return "ontouchstart" in globalThis || (typeof navigator !== "undefined" && navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (() => {
        const buf = new ArrayBuffer(4);
        const buf8 = new Uint8Array(buf);
        const buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        let little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        if (exports.is_little_endian) {
            const result = new Uint32Array(values.length);
            const view = new DataView(result.buffer);
            let j = 0;
            for (const color of values) {
                view.setUint32(j, color);
                j += 4;
            }
            return result;
        }
        else {
            return values;
        }
    }
},
/* core/vectorization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.isValue = isValue;
    exports.isField = isField;
    exports.isExpr = isExpr;
    exports.isVectorized = isVectorized;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    function is_of_type(obj, field) {
        if (!(0, types_1.isPlainObject)(obj)) {
            return false;
        }
        if (!(field in obj)) {
            return false;
        }
        let n = (0, object_1.size)(obj) - 1;
        if ("transform" in obj) {
            n -= 1;
        }
        if ("units" in obj) {
            n -= 1;
        }
        return n == 0;
    }
    function isValue(obj) {
        return is_of_type(obj, "value");
    }
    function isField(obj) {
        return is_of_type(obj, "field");
    }
    function isExpr(obj) {
        return is_of_type(obj, "expr");
    }
    function isVectorized(obj) {
        return isValue(obj) || isField(obj) || isExpr(obj);
    }
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Settings {
        constructor() {
            this._dev = false;
            this._wireframe = false;
            this._force_webgl = false;
            this._force_fields = false;
        }
        set dev(dev) {
            this._dev = dev;
        }
        get dev() {
            return this._dev;
        }
        set wireframe(wireframe) {
            this._wireframe = wireframe;
        }
        get wireframe() {
            return this._wireframe;
        }
        set force_webgl(force_webgl) {
            this._force_webgl = force_webgl;
        }
        get force_webgl() {
            return this._force_webgl;
        }
        set force_fields(force_fields) {
            this._force_fields = force_fields;
        }
        get force_fields() {
            return this._force_fields;
        }
    }
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    __esModule();
    exports.is_NDArray = is_NDArray;
    exports.ndarray = ndarray;
    const types_1 = require(8) /* ./types */;
    const platform_1 = require(28) /* ./platform */;
    const eq_1 = require(27) /* ./eq */;
    const cloneable_1 = require(32) /* ./cloneable */;
    const serialization_1 = require(33) /* ../serialization */;
    const __ndarray__ = Symbol("__ndarray__");
    function encode_NDArray(array, serializer) {
        const encoded = serializer.encode(array.dtype == "object" ? Array.from(array) : array.buffer);
        return {
            type: "ndarray",
            array: encoded,
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
    }
    class BoolNDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_a] = true;
            this.dtype = "bool";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_a = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new BoolNDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i] == 1;
        }
    }
    exports.BoolNDArray = BoolNDArray;
    BoolNDArray.__name__ = "BoolNDArray";
    class Uint8NDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_b] = true;
            this.dtype = "uint8";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_b = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint8NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    class Int8NDArray extends Int8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_c] = true;
            this.dtype = "int8";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_c = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int8NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    class Uint16NDArray extends Uint16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_d] = true;
            this.dtype = "uint16";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_d = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint16NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    class Int16NDArray extends Int16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_e] = true;
            this.dtype = "int16";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_e = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int16NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    class Uint32NDArray extends Uint32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_f] = true;
            this.dtype = "uint32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_f = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    class Int32NDArray extends Int32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_g] = true;
            this.dtype = "int32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_g = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    class Float32NDArray extends Float32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_h] = true;
            this.dtype = "float32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_h = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Float32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    class Float64NDArray extends Float64Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_j] = true;
            this.dtype = "float64";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_j = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Float64NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    class ObjectNDArray extends Array {
        get shape() {
            return this._shape ?? [this.length];
        }
        get dimension() {
            return this.shape.length;
        }
        constructor(init_, shape) {
            const init = (0, types_1.is_ArrayBufferLike)(init_) ? new Float64Array(init_) : init_;
            const size = (0, types_1.isNumber)(init) ? init : init.length;
            super(size);
            this[_k] = true;
            this.dtype = "object";
            if (!(0, types_1.isNumber)(init)) {
                for (let i = 0; i < init.length; i++) {
                    this[i] = init[i];
                }
            }
            this._shape = shape ?? (is_NDArray(init) ? init.shape : undefined);
        }
        [(_k = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new ObjectNDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.ObjectNDArray = ObjectNDArray;
    ObjectNDArray.__name__ = "ObjectNDArray";
    function is_NDArray(v) {
        return (0, types_1.isObject)(v) && __ndarray__ in v;
    }
    function ndarray(init, { dtype, shape } = {}) {
        if (dtype == null) {
            dtype = (() => {
                switch (true) {
                    case init instanceof Uint8Array: return "uint8";
                    case init instanceof Int8Array: return "int8";
                    case init instanceof Uint16Array: return "uint16";
                    case init instanceof Int16Array: return "int16";
                    case init instanceof Uint32Array: return "uint32";
                    case init instanceof Int32Array: return "int32";
                    case init instanceof Float32Array: return "float32";
                    case init instanceof Float64Array: return "float64";
                    default: {
                        if ((0, types_1.is_ArrayBufferLike)(init)) {
                            return "float64";
                        }
                        else {
                            return "object";
                        }
                    }
                }
            })();
        }
        switch (dtype) {
            case "bool": return new BoolNDArray(init, shape);
            case "uint8": return new Uint8NDArray(init, shape);
            case "int8": return new Int8NDArray(init, shape);
            case "uint16": return new Uint16NDArray(init, shape);
            case "int16": return new Int16NDArray(init, shape);
            case "uint32": return new Uint32NDArray(init, shape);
            case "int32": return new Int32NDArray(init, shape);
            case "float32": return new Float32NDArray(init, shape);
            case "float64": return new Float64NDArray(init, shape);
            case "object": return new ObjectNDArray(init, shape);
        }
    }
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_Cloneable = is_Cloneable;
    const object_1 = require(9) /* ./object */;
    const types_1 = require(8) /* ./types */;
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return (0, types_1.isObject)(obj) && exports.clone in obj;
    }
    class CloningError extends Error {
    }
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    class Cloner {
        constructor() { }
        clone(obj) {
            if (is_Cloneable(obj)) {
                return obj[exports.clone](this);
            }
            else if ((0, types_1.isPrimitive)(obj) || (0, types_1.isFunction)(obj)) {
                return obj;
            }
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const result = {};
                for (const [key, value] of (0, object_1.entries)(obj)) {
                    result[key] = this.clone(value);
                }
                return result;
            }
            else if (obj instanceof Map) {
                return new Map([...obj].map(([k, v]) => [this.clone(k), this.clone(v)]));
            }
            else if (obj instanceof Set) {
                return new Set([...obj].map((v) => this.clone(v)));
            }
            else {
                throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
            }
        }
    }
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* core/serialization/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var serializer_1 = require(34) /* ./serializer */;
    __esExport("Serializer", serializer_1.Serializer);
    __esExport("SerializationError", serializer_1.SerializationError);
    __esExport("serialize", serializer_1.serialize);
    var buffer_1 = require(35) /* ./buffer */;
    __esExport("Buffer", buffer_1.Buffer);
    __esExport("Base64Buffer", buffer_1.Base64Buffer);
    tslib_1.__exportStar(require(38) /* ./reps */, exports);
},
/* core/serialization/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(12) /* ../util/assert */;
    const object_1 = require(9) /* ../util/object */;
    const types_1 = require(8) /* ../util/types */;
    const iterator_1 = require(14) /* ../util/iterator */;
    const platform_1 = require(28) /* ../util/platform */;
    const buffer_1 = require(35) /* ./buffer */;
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return (0, types_1.isObject)(obj) && exports.serialize in obj;
    }
    class SerializationError extends Error {
    }
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    class Serialized {
        constructor(value) {
            this.value = value;
        }
        to_json() {
            return JSON.stringify(this.value);
        }
    }
    Serialized.__name__ = "Serialized";
    class Serializer {
        constructor(options) {
            this._circular = new WeakSet();
            this.binary = options?.binary ?? false;
            this.include_defaults = options?.include_defaults ?? false;
            const references = options?.references;
            this._references = references != null ? new Map(references) : new Map();
        }
        get_ref(obj) {
            return this._references.get(obj);
        }
        add_ref(obj, ref) {
            (0, assert_1.assert)(!this._references.has(obj));
            this._references.set(obj, ref);
        }
        to_serializable(obj) {
            return new Serialized(this.encode(obj));
        }
        encode(obj) {
            const ref = this.get_ref(obj);
            if (ref != null) {
                return ref;
            }
            if (!(0, types_1.isObject)(obj)) {
                return this._encode(obj);
            }
            else {
                if (this._circular.has(obj)) {
                    this.error("circular reference");
                }
                this._circular.add(obj);
                try {
                    return this._encode(obj);
                }
                finally {
                    this._circular.delete(obj);
                }
            }
        }
        _encode(obj) {
            if (is_Serializable(obj)) {
                return obj[exports.serialize](this);
            }
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.encode(value);
                }
                return result;
            }
            else if ((0, types_1.isTypedArray)(obj)) {
                return this._encode_typed_array(obj);
            }
            else if (obj instanceof ArrayBuffer) {
                const data = this.binary ? new buffer_1.Buffer(obj) : new buffer_1.Base64Buffer(obj);
                return { type: "bytes", data };
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const items = (0, object_1.entries)(obj);
                if (items.length == 0) {
                    return { type: "map" };
                }
                else {
                    return { type: "map", entries: [...(0, iterator_1.map)(items, ([key, val]) => [this.encode(key), this.encode(val)])] };
                }
            }
            else if (obj === null || (0, types_1.isBoolean)(obj) || (0, types_1.isString)(obj)) {
                return obj;
            }
            else if ((0, types_1.isNumber)(obj)) {
                if (isNaN(obj)) {
                    return { type: "number", value: "nan" };
                }
                else if (!isFinite(obj)) {
                    return { type: "number", value: `${obj < 0 ? "-" : "+"}inf` };
                }
                else {
                    return obj;
                }
            }
            else if (obj instanceof Date) {
                const iso = obj.toISOString();
                return { type: "date", iso };
            }
            else if (obj instanceof Set) {
                if (obj.size == 0) {
                    return { type: "set" };
                }
                else {
                    return { type: "set", entries: [...(0, iterator_1.map)(obj.values(), (val) => this.encode(val))] };
                }
            }
            else if (obj instanceof Map) {
                if (obj.size == 0) {
                    return { type: "map" };
                }
                else {
                    return { type: "map", entries: [...(0, iterator_1.map)(obj.entries(), ([key, val]) => [this.encode(key), this.encode(val)])] };
                }
            }
            else if ((0, types_1.isSymbol)(obj) && obj.description != null) {
                return { type: "symbol", name: obj.description };
            }
            else {
                throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
            }
        }
        encode_struct(struct) {
            const result = {};
            for (const [key, val] of (0, object_1.entries)(struct)) {
                if (val !== undefined) {
                    result[key] = this.encode(val);
                }
            }
            return result;
        }
        error(message) {
            throw new SerializationError(message);
        }
        _encode_typed_array(obj) {
            const array = this.encode(obj.buffer);
            const dtype = (() => {
                switch (obj.constructor) {
                    case Uint8Array: return "uint8";
                    case Int8Array: return "int8";
                    case Uint16Array: return "uint16";
                    case Int16Array: return "int16";
                    case Uint32Array: return "uint32";
                    case Int32Array: return "int32";
                    // case BigUint64Array: return "uint64"
                    // case BigInt64Array: return "int64"
                    case Float32Array: return "float32";
                    case Float64Array: return "float64";
                    default:
                        this.error(`can't serialize typed array of type '${obj[Symbol.toStringTag]}'`);
                }
            })();
            return {
                type: "typed_array",
                array,
                order: platform_1.BYTE_ORDER,
                dtype,
            };
        }
    }
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/serialization/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const buffer_1 = require(36) /* ../util/buffer */;
    const eq_1 = require(27) /* ../util/eq */;
    class Buffer {
        constructor(buffer) {
            this.buffer = buffer;
        }
        to_base64() {
            return (0, buffer_1.buffer_to_base64)(this.buffer);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.buffer, that.buffer);
        }
    }
    exports.Buffer = Buffer;
    Buffer.__name__ = "Buffer";
    class Base64Buffer extends Buffer {
        toJSON() {
            return this.to_base64();
        }
    }
    exports.Base64Buffer = Base64Buffer;
    Base64Buffer.__name__ = "Base64Buffer";
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.b64encode = b64encode;
    exports.b64decode = b64decode;
    exports.buffer_to_base64 = buffer_to_base64;
    exports.base64_to_buffer = base64_to_buffer;
    exports.swap = swap;
    const fflate_1 = require(37) /* fflate */;
    function b64encode(data) {
        const chars = Array.from(data).map((b) => String.fromCharCode(b));
        return btoa(chars.join(""));
    }
    function b64decode(data) {
        const binary_string = atob(data);
        const len = binary_string.length;
        const bytes = new Uint8Array(len);
        for (let i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes;
    }
    function buffer_to_base64(buffer) {
        const bytes = new Uint8Array(buffer);
        // we do not want the result to be different depending on mtime, since that is
        // irrelevant and also makes things harder to test, so set mtime=0 here
        const compressed = (0, fflate_1.gzipSync)(bytes, { mtime: 0 });
        return b64encode(compressed);
    }
    function base64_to_buffer(base64) {
        const bytes = b64decode(base64);
        return (0, fflate_1.gunzipSync)(bytes).buffer;
    }
    // NOTE: swap{16,32,64} assume byteOffset == 0
    function swap16(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 2) {
            const t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 4) {
            let t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 8) {
            let t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(buffer, dtype) {
        switch (dtype) {
            case "uint16":
            case "int16":
                swap16(buffer);
                break;
            case "uint32":
            case "int32":
            case "float32":
                swap32(buffer);
                break;
            case "float64":
                swap64(buffer);
                break;
            case "object":
            case "uint8":
            case "int8":
            case "bool":
                break;
        }
    }
},
/* fflate/esm/browser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.deflate = deflate;
    exports.deflateSync = deflateSync;
    exports.inflate = inflate;
    exports.inflateSync = inflateSync;
    exports.gzip = gzip;
    exports.compress = gzip;
    exports.gzipSync = gzipSync;
    exports.compressSync = gzipSync;
    exports.gunzip = gunzip;
    exports.gunzipSync = gunzipSync;
    exports.zlib = zlib;
    exports.zlibSync = zlibSync;
    exports.unzlib = unzlib;
    exports.unzlibSync = unzlibSync;
    exports.decompress = decompress;
    exports.decompressSync = decompressSync;
    exports.strToU8 = strToU8;
    exports.strFromU8 = strFromU8;
    exports.zip = zip;
    exports.zipSync = zipSync;
    exports.unzip = unzip;
    exports.unzipSync = unzipSync;
    // DEFLATE is a complex format; to read this code, you should probably check the RFC first:
    // https://tools.ietf.org/html/rfc1951
    // You may also wish to take a look at the guide I made about this program:
    // https://gist.github.com/101arrowz/253f31eb5abc3d9275ab943003ffecad
    // Some of the following code is similar to that of UZIP.js:
    // https://github.com/photopea/UZIP.js
    // However, the vast majority of the codebase has diverged from UZIP.js to increase performance and reduce bundle size.
    // Sometimes 0 will appear where -1 would be more appropriate. This is because using a uint
    // is better for memory in most engines (I *think*).
    var ch2 = {};
    var wk = (function (c, id, msg, transfer, cb) {
        var w = new Worker(ch2[id] || (ch2[id] = URL.createObjectURL(new Blob([
            c + ';addEventListener("error",function(e){e=e.error;postMessage({$e$:[e.message,e.code,e.stack]})})'
        ], { type: 'text/javascript' }))));
        w.onmessage = function (e) {
            var d = e.data, ed = d.$e$;
            if (ed) {
                var err = new Error(ed[0]);
                err['code'] = ed[1];
                err.stack = ed[2];
                cb(err, null);
            }
            else
                cb(null, d);
        };
        w.postMessage(msg, transfer);
        return w;
    });
    // aliases for shorter compressed code (most minifers don't do this)
    var u8 = Uint8Array, u16 = Uint16Array, i32 = Int32Array;
    // fixed length extra bits
    var fleb = new u8([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, /* unused */ 0, 0, /* impossible */ 0]);
    // fixed distance extra bits
    var fdeb = new u8([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, /* unused */ 0, 0]);
    // code length index map
    var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
    // get base, reverse index map from extra bits
    var freb = function (eb, start) {
        var b = new u16(31);
        for (var i = 0; i < 31; ++i) {
            b[i] = start += 1 << eb[i - 1];
        }
        // numbers here are at max 18 bits
        var r = new i32(b[30]);
        for (var i = 1; i < 30; ++i) {
            for (var j = b[i]; j < b[i + 1]; ++j) {
                r[j] = ((j - b[i]) << 5) | i;
            }
        }
        return { b: b, r: r };
    };
    var _a = freb(fleb, 2), fl = _a.b, revfl = _a.r;
    // we can ignore the fact that the other numbers are wrong; they never happen anyway
    fl[28] = 258, revfl[258] = 28;
    var _b = freb(fdeb, 0), fd = _b.b, revfd = _b.r;
    // map of value to reverse (assuming 16 bits)
    var rev = new u16(32768);
    for (var i = 0; i < 32768; ++i) {
        // reverse table algorithm from SO
        var x = ((i & 0xAAAA) >> 1) | ((i & 0x5555) << 1);
        x = ((x & 0xCCCC) >> 2) | ((x & 0x3333) << 2);
        x = ((x & 0xF0F0) >> 4) | ((x & 0x0F0F) << 4);
        rev[i] = (((x & 0xFF00) >> 8) | ((x & 0x00FF) << 8)) >> 1;
    }
    // create huffman tree from u8 "map": index -> code length for code index
    // mb (max bits) must be at most 15
    // TODO: optimize/split up?
    var hMap = (function (cd, mb, r) {
        var s = cd.length;
        // index
        var i = 0;
        // u16 "map": index -> # of codes with bit length = index
        var l = new u16(mb);
        // length of cd must be 288 (total # of codes)
        for (; i < s; ++i) {
            if (cd[i])
                ++l[cd[i] - 1];
        }
        // u16 "map": index -> minimum code for bit length = index
        var le = new u16(mb);
        for (i = 1; i < mb; ++i) {
            le[i] = (le[i - 1] + l[i - 1]) << 1;
        }
        var co;
        if (r) {
            // u16 "map": index -> number of actual bits, symbol for code
            co = new u16(1 << mb);
            // bits to remove for reverser
            var rvb = 15 - mb;
            for (i = 0; i < s; ++i) {
                // ignore 0 lengths
                if (cd[i]) {
                    // num encoding both symbol and bits read
                    var sv = (i << 4) | cd[i];
                    // free bits
                    var r_1 = mb - cd[i];
                    // start value
                    var v = le[cd[i] - 1]++ << r_1;
                    // m is end value
                    for (var m = v | ((1 << r_1) - 1); v <= m; ++v) {
                        // every 16 bit value starting with the code yields the same result
                        co[rev[v] >> rvb] = sv;
                    }
                }
            }
        }
        else {
            co = new u16(s);
            for (i = 0; i < s; ++i) {
                if (cd[i]) {
                    co[i] = rev[le[cd[i] - 1]++] >> (15 - cd[i]);
                }
            }
        }
        return co;
    });
    // fixed length tree
    var flt = new u8(288);
    for (var i = 0; i < 144; ++i)
        flt[i] = 8;
    for (var i = 144; i < 256; ++i)
        flt[i] = 9;
    for (var i = 256; i < 280; ++i)
        flt[i] = 7;
    for (var i = 280; i < 288; ++i)
        flt[i] = 8;
    // fixed distance tree
    var fdt = new u8(32);
    for (var i = 0; i < 32; ++i)
        fdt[i] = 5;
    // fixed length map
    var flm = /*#__PURE__*/ hMap(flt, 9, 0), flrm = /*#__PURE__*/ hMap(flt, 9, 1);
    // fixed distance map
    var fdm = /*#__PURE__*/ hMap(fdt, 5, 0), fdrm = /*#__PURE__*/ hMap(fdt, 5, 1);
    // find max of array
    var max = function (a) {
        var m = a[0];
        for (var i = 1; i < a.length; ++i) {
            if (a[i] > m)
                m = a[i];
        }
        return m;
    };
    // read d, starting at bit p and mask with m
    var bits = function (d, p, m) {
        var o = (p / 8) | 0;
        return ((d[o] | (d[o + 1] << 8)) >> (p & 7)) & m;
    };
    // read d, starting at bit p continuing for at least 16 bits
    var bits16 = function (d, p) {
        var o = (p / 8) | 0;
        return ((d[o] | (d[o + 1] << 8) | (d[o + 2] << 16)) >> (p & 7));
    };
    // get end of byte
    var shft = function (p) { return ((p + 7) / 8) | 0; };
    // typed array slice - allows garbage collector to free original reference,
    // while being more compatible than .slice
    var slc = function (v, s, e) {
        if (s == null || s < 0)
            s = 0;
        if (e == null || e > v.length)
            e = v.length;
        // can't use .constructor in case user-supplied
        return new u8(v.subarray(s, e));
    };
    /**
     * Codes for errors generated within this library
     */
    exports.FlateErrorCode = {
        UnexpectedEOF: 0,
        InvalidBlockType: 1,
        InvalidLengthLiteral: 2,
        InvalidDistance: 3,
        StreamFinished: 4,
        NoStreamHandler: 5,
        InvalidHeader: 6,
        NoCallback: 7,
        InvalidUTF8: 8,
        ExtraFieldTooLong: 9,
        InvalidDate: 10,
        FilenameTooLong: 11,
        StreamFinishing: 12,
        InvalidZipData: 13,
        UnknownCompressionMethod: 14
    };
    // error codes
    var ec = [
        'unexpected EOF',
        'invalid block type',
        'invalid length/literal',
        'invalid distance',
        'stream finished',
        'no stream handler',
        ,
        'no callback',
        'invalid UTF-8 data',
        'extra field too long',
        'date not in range 1980-2099',
        'filename too long',
        'stream finishing',
        'invalid zip data'
        // determined by unknown compression method
    ];
    ;
    var err = function (ind, msg, nt) {
        var e = new Error(msg || ec[ind]);
        e.code = ind;
        if (Error.captureStackTrace)
            Error.captureStackTrace(e, err);
        if (!nt)
            throw e;
        return e;
    };
    // expands raw DEFLATE data
    var inflt = function (dat, st, buf, dict) {
        // source length       dict length
        var sl = dat.length, dl = dict ? dict.length : 0;
        if (!sl || st.f && !st.l)
            return buf || new u8(0);
        var noBuf = !buf;
        // have to estimate size
        var resize = noBuf || st.i != 2;
        // no state
        var noSt = st.i;
        // Assumes roughly 33% compression ratio average
        if (noBuf)
            buf = new u8(sl * 3);
        // ensure buffer can fit at least l elements
        var cbuf = function (l) {
            var bl = buf.length;
            // need to increase size to fit
            if (l > bl) {
                // Double or set to necessary, whichever is greater
                var nbuf = new u8(Math.max(bl * 2, l));
                nbuf.set(buf);
                buf = nbuf;
            }
        };
        //  last chunk         bitpos           bytes
        var final = st.f || 0, pos = st.p || 0, bt = st.b || 0, lm = st.l, dm = st.d, lbt = st.m, dbt = st.n;
        // total bits
        var tbts = sl * 8;
        do {
            if (!lm) {
                // BFINAL - this is only 1 when last chunk is next
                final = bits(dat, pos, 1);
                // type: 0 = no compression, 1 = fixed huffman, 2 = dynamic huffman
                var type = bits(dat, pos + 1, 3);
                pos += 3;
                if (!type) {
                    // go to end of byte boundary
                    var s = shft(pos) + 4, l = dat[s - 4] | (dat[s - 3] << 8), t = s + l;
                    if (t > sl) {
                        if (noSt)
                            err(0);
                        break;
                    }
                    // ensure size
                    if (resize)
                        cbuf(bt + l);
                    // Copy over uncompressed data
                    buf.set(dat.subarray(s, t), bt);
                    // Get new bitpos, update byte count
                    st.b = bt += l, st.p = pos = t * 8, st.f = final;
                    continue;
                }
                else if (type == 1)
                    lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
                else if (type == 2) {
                    //  literal                            lengths
                    var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
                    var tl = hLit + bits(dat, pos + 5, 31) + 1;
                    pos += 14;
                    // length+distance tree
                    var ldt = new u8(tl);
                    // code length tree
                    var clt = new u8(19);
                    for (var i = 0; i < hcLen; ++i) {
                        // use index map to get real code
                        clt[clim[i]] = bits(dat, pos + i * 3, 7);
                    }
                    pos += hcLen * 3;
                    // code lengths bits
                    var clb = max(clt), clbmsk = (1 << clb) - 1;
                    // code lengths map
                    var clm = hMap(clt, clb, 1);
                    for (var i = 0; i < tl;) {
                        var r = clm[bits(dat, pos, clbmsk)];
                        // bits read
                        pos += r & 15;
                        // symbol
                        var s = r >> 4;
                        // code length to copy
                        if (s < 16) {
                            ldt[i++] = s;
                        }
                        else {
                            //  copy   count
                            var c = 0, n = 0;
                            if (s == 16)
                                n = 3 + bits(dat, pos, 3), pos += 2, c = ldt[i - 1];
                            else if (s == 17)
                                n = 3 + bits(dat, pos, 7), pos += 3;
                            else if (s == 18)
                                n = 11 + bits(dat, pos, 127), pos += 7;
                            while (n--)
                                ldt[i++] = c;
                        }
                    }
                    //    length tree                 distance tree
                    var lt = ldt.subarray(0, hLit), dt = ldt.subarray(hLit);
                    // max length bits
                    lbt = max(lt);
                    // max dist bits
                    dbt = max(dt);
                    lm = hMap(lt, lbt, 1);
                    dm = hMap(dt, dbt, 1);
                }
                else
                    err(1);
                if (pos > tbts) {
                    if (noSt)
                        err(0);
                    break;
                }
            }
            // Make sure the buffer can hold this + the largest possible addition
            // Maximum chunk size (practically, theoretically infinite) is 2^17
            if (resize)
                cbuf(bt + 131072);
            var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
            var lpos = pos;
            for (;; lpos = pos) {
                // bits read, code
                var c = lm[bits16(dat, pos) & lms], sym = c >> 4;
                pos += c & 15;
                if (pos > tbts) {
                    if (noSt)
                        err(0);
                    break;
                }
                if (!c)
                    err(2);
                if (sym < 256)
                    buf[bt++] = sym;
                else if (sym == 256) {
                    lpos = pos, lm = null;
                    break;
                }
                else {
                    var add = sym - 254;
                    // no extra bits needed if less
                    if (sym > 264) {
                        // index
                        var i = sym - 257, b = fleb[i];
                        add = bits(dat, pos, (1 << b) - 1) + fl[i];
                        pos += b;
                    }
                    // dist
                    var d = dm[bits16(dat, pos) & dms], dsym = d >> 4;
                    if (!d)
                        err(3);
                    pos += d & 15;
                    var dt = fd[dsym];
                    if (dsym > 3) {
                        var b = fdeb[dsym];
                        dt += bits16(dat, pos) & (1 << b) - 1, pos += b;
                    }
                    if (pos > tbts) {
                        if (noSt)
                            err(0);
                        break;
                    }
                    if (resize)
                        cbuf(bt + 131072);
                    var end = bt + add;
                    if (bt < dt) {
                        var shift = dl - dt, dend = Math.min(dt, end);
                        if (shift + bt < 0)
                            err(3);
                        for (; bt < dend; ++bt)
                            buf[bt] = dict[shift + bt];
                    }
                    for (; bt < end; ++bt)
                        buf[bt] = buf[bt - dt];
                }
            }
            st.l = lm, st.p = lpos, st.b = bt, st.f = final;
            if (lm)
                final = 1, st.m = lbt, st.d = dm, st.n = dbt;
        } while (!final);
        // don't reallocate for streams or user buffers
        return bt != buf.length && noBuf ? slc(buf, 0, bt) : buf.subarray(0, bt);
    };
    // starting at p, write the minimum number of bits that can hold v to d
    var wbits = function (d, p, v) {
        v <<= p & 7;
        var o = (p / 8) | 0;
        d[o] |= v;
        d[o + 1] |= v >> 8;
    };
    // starting at p, write the minimum number of bits (>8) that can hold v to d
    var wbits16 = function (d, p, v) {
        v <<= p & 7;
        var o = (p / 8) | 0;
        d[o] |= v;
        d[o + 1] |= v >> 8;
        d[o + 2] |= v >> 16;
    };
    // creates code lengths from a frequency table
    var hTree = function (d, mb) {
        // Need extra info to make a tree
        var t = [];
        for (var i = 0; i < d.length; ++i) {
            if (d[i])
                t.push({ s: i, f: d[i] });
        }
        var s = t.length;
        var t2 = t.slice();
        if (!s)
            return { t: et, l: 0 };
        if (s == 1) {
            var v = new u8(t[0].s + 1);
            v[t[0].s] = 1;
            return { t: v, l: 1 };
        }
        t.sort(function (a, b) { return a.f - b.f; });
        // after i2 reaches last ind, will be stopped
        // freq must be greater than largest possible number of symbols
        t.push({ s: -1, f: 25001 });
        var l = t[0], r = t[1], i0 = 0, i1 = 1, i2 = 2;
        t[0] = { s: -1, f: l.f + r.f, l: l, r: r };
        // efficient algorithm from UZIP.js
        // i0 is lookbehind, i2 is lookahead - after processing two low-freq
        // symbols that combined have high freq, will start processing i2 (high-freq,
        // non-composite) symbols instead
        // see https://reddit.com/r/photopea/comments/ikekht/uzipjs_questions/
        while (i1 != s - 1) {
            l = t[t[i0].f < t[i2].f ? i0++ : i2++];
            r = t[i0 != i1 && t[i0].f < t[i2].f ? i0++ : i2++];
            t[i1++] = { s: -1, f: l.f + r.f, l: l, r: r };
        }
        var maxSym = t2[0].s;
        for (var i = 1; i < s; ++i) {
            if (t2[i].s > maxSym)
                maxSym = t2[i].s;
        }
        // code lengths
        var tr = new u16(maxSym + 1);
        // max bits in tree
        var mbt = ln(t[i1 - 1], tr, 0);
        if (mbt > mb) {
            // more algorithms from UZIP.js
            // TODO: find out how this code works (debt)
            //  ind    debt
            var i = 0, dt = 0;
            //    left            cost
            var lft = mbt - mb, cst = 1 << lft;
            t2.sort(function (a, b) { return tr[b.s] - tr[a.s] || a.f - b.f; });
            for (; i < s; ++i) {
                var i2_1 = t2[i].s;
                if (tr[i2_1] > mb) {
                    dt += cst - (1 << (mbt - tr[i2_1]));
                    tr[i2_1] = mb;
                }
                else
                    break;
            }
            dt >>= lft;
            while (dt > 0) {
                var i2_2 = t2[i].s;
                if (tr[i2_2] < mb)
                    dt -= 1 << (mb - tr[i2_2]++ - 1);
                else
                    ++i;
            }
            for (; i >= 0 && dt; --i) {
                var i2_3 = t2[i].s;
                if (tr[i2_3] == mb) {
                    --tr[i2_3];
                    ++dt;
                }
            }
            mbt = mb;
        }
        return { t: new u8(tr), l: mbt };
    };
    // get the max length and assign length codes
    var ln = function (n, l, d) {
        return n.s == -1
            ? Math.max(ln(n.l, l, d + 1), ln(n.r, l, d + 1))
            : (l[n.s] = d);
    };
    // length codes generation
    var lc = function (c) {
        var s = c.length;
        // Note that the semicolon was intentional
        while (s && !c[--s])
            ;
        var cl = new u16(++s);
        //  ind      num         streak
        var cli = 0, cln = c[0], cls = 1;
        var w = function (v) { cl[cli++] = v; };
        for (var i = 1; i <= s; ++i) {
            if (c[i] == cln && i != s)
                ++cls;
            else {
                if (!cln && cls > 2) {
                    for (; cls > 138; cls -= 138)
                        w(32754);
                    if (cls > 2) {
                        w(cls > 10 ? ((cls - 11) << 5) | 28690 : ((cls - 3) << 5) | 12305);
                        cls = 0;
                    }
                }
                else if (cls > 3) {
                    w(cln), --cls;
                    for (; cls > 6; cls -= 6)
                        w(8304);
                    if (cls > 2)
                        w(((cls - 3) << 5) | 8208), cls = 0;
                }
                while (cls--)
                    w(cln);
                cls = 1;
                cln = c[i];
            }
        }
        return { c: cl.subarray(0, cli), n: s };
    };
    // calculate the length of output from tree, code lengths
    var clen = function (cf, cl) {
        var l = 0;
        for (var i = 0; i < cl.length; ++i)
            l += cf[i] * cl[i];
        return l;
    };
    // writes a fixed block
    // returns the new bit pos
    var wfblk = function (out, pos, dat) {
        // no need to write 00 as type: TypedArray defaults to 0
        var s = dat.length;
        var o = shft(pos + 2);
        out[o] = s & 255;
        out[o + 1] = s >> 8;
        out[o + 2] = out[o] ^ 255;
        out[o + 3] = out[o + 1] ^ 255;
        for (var i = 0; i < s; ++i)
            out[o + i + 4] = dat[i];
        return (o + 4 + s) * 8;
    };
    // writes a block
    var wblk = function (dat, out, final, syms, lf, df, eb, li, bs, bl, p) {
        wbits(out, p++, final);
        ++lf[256];
        var _a = hTree(lf, 15), dlt = _a.t, mlb = _a.l;
        var _b = hTree(df, 15), ddt = _b.t, mdb = _b.l;
        var _c = lc(dlt), lclt = _c.c, nlc = _c.n;
        var _d = lc(ddt), lcdt = _d.c, ndc = _d.n;
        var lcfreq = new u16(19);
        for (var i = 0; i < lclt.length; ++i)
            ++lcfreq[lclt[i] & 31];
        for (var i = 0; i < lcdt.length; ++i)
            ++lcfreq[lcdt[i] & 31];
        var _e = hTree(lcfreq, 7), lct = _e.t, mlcb = _e.l;
        var nlcc = 19;
        for (; nlcc > 4 && !lct[clim[nlcc - 1]]; --nlcc)
            ;
        var flen = (bl + 5) << 3;
        var ftlen = clen(lf, flt) + clen(df, fdt) + eb;
        var dtlen = clen(lf, dlt) + clen(df, ddt) + eb + 14 + 3 * nlcc + clen(lcfreq, lct) + 2 * lcfreq[16] + 3 * lcfreq[17] + 7 * lcfreq[18];
        if (bs >= 0 && flen <= ftlen && flen <= dtlen)
            return wfblk(out, p, dat.subarray(bs, bs + bl));
        var lm, ll, dm, dl;
        wbits(out, p, 1 + (dtlen < ftlen)), p += 2;
        if (dtlen < ftlen) {
            lm = hMap(dlt, mlb, 0), ll = dlt, dm = hMap(ddt, mdb, 0), dl = ddt;
            var llm = hMap(lct, mlcb, 0);
            wbits(out, p, nlc - 257);
            wbits(out, p + 5, ndc - 1);
            wbits(out, p + 10, nlcc - 4);
            p += 14;
            for (var i = 0; i < nlcc; ++i)
                wbits(out, p + 3 * i, lct[clim[i]]);
            p += 3 * nlcc;
            var lcts = [lclt, lcdt];
            for (var it = 0; it < 2; ++it) {
                var clct = lcts[it];
                for (var i = 0; i < clct.length; ++i) {
                    var len = clct[i] & 31;
                    wbits(out, p, llm[len]), p += lct[len];
                    if (len > 15)
                        wbits(out, p, (clct[i] >> 5) & 127), p += clct[i] >> 12;
                }
            }
        }
        else {
            lm = flm, ll = flt, dm = fdm, dl = fdt;
        }
        for (var i = 0; i < li; ++i) {
            var sym = syms[i];
            if (sym > 255) {
                var len = (sym >> 18) & 31;
                wbits16(out, p, lm[len + 257]), p += ll[len + 257];
                if (len > 7)
                    wbits(out, p, (sym >> 23) & 31), p += fleb[len];
                var dst = sym & 31;
                wbits16(out, p, dm[dst]), p += dl[dst];
                if (dst > 3)
                    wbits16(out, p, (sym >> 5) & 8191), p += fdeb[dst];
            }
            else {
                wbits16(out, p, lm[sym]), p += ll[sym];
            }
        }
        wbits16(out, p, lm[256]);
        return p + ll[256];
    };
    // deflate options (nice << 13) | chain
    var deo = /*#__PURE__*/ new i32([65540, 131080, 131088, 131104, 262176, 1048704, 1048832, 2114560, 2117632]);
    // empty
    var et = /*#__PURE__*/ new u8(0);
    // compresses data into a raw DEFLATE buffer
    var dflt = function (dat, lvl, plvl, pre, post, st) {
        var s = st.z || dat.length;
        var o = new u8(pre + s + 5 * (1 + Math.ceil(s / 7000)) + post);
        // writing to this writes to the output buffer
        var w = o.subarray(pre, o.length - post);
        var lst = st.l;
        var pos = (st.r || 0) & 7;
        if (lvl) {
            if (pos)
                w[0] = st.r >> 3;
            var opt = deo[lvl - 1];
            var n = opt >> 13, c = opt & 8191;
            var msk_1 = (1 << plvl) - 1;
            //    prev 2-byte val map    curr 2-byte val map
            var prev = st.p || new u16(32768), head = st.h || new u16(msk_1 + 1);
            var bs1_1 = Math.ceil(plvl / 3), bs2_1 = 2 * bs1_1;
            var hsh = function (i) { return (dat[i] ^ (dat[i + 1] << bs1_1) ^ (dat[i + 2] << bs2_1)) & msk_1; };
            // 24576 is an arbitrary number of maximum symbols per block
            // 424 buffer for last block
            var syms = new i32(25000);
            // length/literal freq   distance freq
            var lf = new u16(288), df = new u16(32);
            //  l/lcnt  exbits  index          l/lind  waitdx          blkpos
            var lc_1 = 0, eb = 0, i = st.i || 0, li = 0, wi = st.w || 0, bs = 0;
            for (; i + 2 < s; ++i) {
                // hash value
                var hv = hsh(i);
                // index mod 32768    previous index mod
                var imod = i & 32767, pimod = head[hv];
                prev[imod] = pimod;
                head[hv] = imod;
                // We always should modify head and prev, but only add symbols if
                // this data is not yet processed ("wait" for wait index)
                if (wi <= i) {
                    // bytes remaining
                    var rem = s - i;
                    if ((lc_1 > 7000 || li > 24576) && (rem > 423 || !lst)) {
                        pos = wblk(dat, w, 0, syms, lf, df, eb, li, bs, i - bs, pos);
                        li = lc_1 = eb = 0, bs = i;
                        for (var j = 0; j < 286; ++j)
                            lf[j] = 0;
                        for (var j = 0; j < 30; ++j)
                            df[j] = 0;
                    }
                    //  len    dist   chain
                    var l = 2, d = 0, ch_1 = c, dif = imod - pimod & 32767;
                    if (rem > 2 && hv == hsh(i - dif)) {
                        var maxn = Math.min(n, rem) - 1;
                        var maxd = Math.min(32767, i);
                        // max possible length
                        // not capped at dif because decompressors implement "rolling" index population
                        var ml = Math.min(258, rem);
                        while (dif <= maxd && --ch_1 && imod != pimod) {
                            if (dat[i + l] == dat[i + l - dif]) {
                                var nl = 0;
                                for (; nl < ml && dat[i + nl] == dat[i + nl - dif]; ++nl)
                                    ;
                                if (nl > l) {
                                    l = nl, d = dif;
                                    // break out early when we reach "nice" (we are satisfied enough)
                                    if (nl > maxn)
                                        break;
                                    // now, find the rarest 2-byte sequence within this
                                    // length of literals and search for that instead.
                                    // Much faster than just using the start
                                    var mmd = Math.min(dif, nl - 2);
                                    var md = 0;
                                    for (var j = 0; j < mmd; ++j) {
                                        var ti = i - dif + j & 32767;
                                        var pti = prev[ti];
                                        var cd = ti - pti & 32767;
                                        if (cd > md)
                                            md = cd, pimod = ti;
                                    }
                                }
                            }
                            // check the previous match
                            imod = pimod, pimod = prev[imod];
                            dif += imod - pimod & 32767;
                        }
                    }
                    // d will be nonzero only when a match was found
                    if (d) {
                        // store both dist and len data in one int32
                        // Make sure this is recognized as a len/dist with 28th bit (2^28)
                        syms[li++] = 268435456 | (revfl[l] << 18) | revfd[d];
                        var lin = revfl[l] & 31, din = revfd[d] & 31;
                        eb += fleb[lin] + fdeb[din];
                        ++lf[257 + lin];
                        ++df[din];
                        wi = i + l;
                        ++lc_1;
                    }
                    else {
                        syms[li++] = dat[i];
                        ++lf[dat[i]];
                    }
                }
            }
            for (i = Math.max(i, wi); i < s; ++i) {
                syms[li++] = dat[i];
                ++lf[dat[i]];
            }
            pos = wblk(dat, w, lst, syms, lf, df, eb, li, bs, i - bs, pos);
            if (!lst) {
                st.r = (pos & 7) | w[(pos / 8) | 0] << 3;
                // shft(pos) now 1 less if pos & 7 != 0
                pos -= 7;
                st.h = head, st.p = prev, st.i = i, st.w = wi;
            }
        }
        else {
            for (var i = st.w || 0; i < s + lst; i += 65535) {
                // end
                var e = i + 65535;
                if (e >= s) {
                    // write final block
                    w[(pos / 8) | 0] = lst;
                    e = s;
                }
                pos = wfblk(w, pos + 1, dat.subarray(i, e));
            }
            st.i = s;
        }
        return slc(o, 0, pre + shft(pos) + post);
    };
    // CRC32 table
    var crct = /*#__PURE__*/ (function () {
        var t = new Int32Array(256);
        for (var i = 0; i < 256; ++i) {
            var c = i, k = 9;
            while (--k)
                c = ((c & 1) && -306674912) ^ (c >>> 1);
            t[i] = c;
        }
        return t;
    })();
    // CRC32
    var crc = function () {
        var c = -1;
        return {
            p: function (d) {
                // closures have awful performance
                var cr = c;
                for (var i = 0; i < d.length; ++i)
                    cr = crct[(cr & 255) ^ d[i]] ^ (cr >>> 8);
                c = cr;
            },
            d: function () { return ~c; }
        };
    };
    // Adler32
    var adler = function () {
        var a = 1, b = 0;
        return {
            p: function (d) {
                // closures have awful performance
                var n = a, m = b;
                var l = d.length | 0;
                for (var i = 0; i != l;) {
                    var e = Math.min(i + 2655, l);
                    for (; i < e; ++i)
                        m += n += d[i];
                    n = (n & 65535) + 15 * (n >> 16), m = (m & 65535) + 15 * (m >> 16);
                }
                a = n, b = m;
            },
            d: function () {
                a %= 65521, b %= 65521;
                return (a & 255) << 24 | (a & 0xFF00) << 8 | (b & 255) << 8 | (b >> 8);
            }
        };
    };
    ;
    // deflate with opts
    var dopt = function (dat, opt, pre, post, st) {
        if (!st) {
            st = { l: 1 };
            if (opt.dictionary) {
                var dict = opt.dictionary.subarray(-32768);
                var newDat = new u8(dict.length + dat.length);
                newDat.set(dict);
                newDat.set(dat, dict.length);
                dat = newDat;
                st.w = dict.length;
            }
        }
        return dflt(dat, opt.level == null ? 6 : opt.level, opt.mem == null ? (st.l ? Math.ceil(Math.max(8, Math.min(13, Math.log(dat.length))) * 1.5) : 20) : (12 + opt.mem), pre, post, st);
    };
    // Walmart object spread
    var mrg = function (a, b) {
        var o = {};
        for (var k in a)
            o[k] = a[k];
        for (var k in b)
            o[k] = b[k];
        return o;
    };
    // worker clone
    // This is possibly the craziest part of the entire codebase, despite how simple it may seem.
    // The only parameter to this function is a closure that returns an array of variables outside of the function scope.
    // We're going to try to figure out the variable names used in the closure as strings because that is crucial for workerization.
    // We will return an object mapping of true variable name to value (basically, the current scope as a JS object).
    // The reason we can't just use the original variable names is minifiers mangling the toplevel scope.
    // This took me three weeks to figure out how to do.
    var wcln = function (fn, fnStr, td) {
        var dt = fn();
        var st = fn.toString();
        var ks = st.slice(st.indexOf('[') + 1, st.lastIndexOf(']')).replace(/\s+/g, '').split(',');
        for (var i = 0; i < dt.length; ++i) {
            var v = dt[i], k = ks[i];
            if (typeof v == 'function') {
                fnStr += ';' + k + '=';
                var st_1 = v.toString();
                if (v.prototype) {
                    // for global objects
                    if (st_1.indexOf('[native code]') != -1) {
                        var spInd = st_1.indexOf(' ', 8) + 1;
                        fnStr += st_1.slice(spInd, st_1.indexOf('(', spInd));
                    }
                    else {
                        fnStr += st_1;
                        for (var t in v.prototype)
                            fnStr += ';' + k + '.prototype.' + t + '=' + v.prototype[t].toString();
                    }
                }
                else
                    fnStr += st_1;
            }
            else
                td[k] = v;
        }
        return fnStr;
    };
    var ch = [];
    // clone bufs
    var cbfs = function (v) {
        var tl = [];
        for (var k in v) {
            if (v[k].buffer) {
                tl.push((v[k] = new v[k].constructor(v[k])).buffer);
            }
        }
        return tl;
    };
    // use a worker to execute code
    var wrkr = function (fns, init, id, cb) {
        if (!ch[id]) {
            var fnStr = '', td_1 = {}, m = fns.length - 1;
            for (var i = 0; i < m; ++i)
                fnStr = wcln(fns[i], fnStr, td_1);
            ch[id] = { c: wcln(fns[m], fnStr, td_1), e: td_1 };
        }
        var td = mrg({}, ch[id].e);
        return wk(ch[id].c + ';onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage=' + init.toString() + '}', id, td, cbfs(td), cb);
    };
    // base async inflate fn
    var bInflt = function () { return [u8, u16, i32, fleb, fdeb, clim, fl, fd, flrm, fdrm, rev, ec, hMap, max, bits, bits16, shft, slc, err, inflt, inflateSync, pbf, gopt]; };
    var bDflt = function () { return [u8, u16, i32, fleb, fdeb, clim, revfl, revfd, flm, flt, fdm, fdt, rev, deo, et, hMap, wbits, wbits16, hTree, ln, lc, clen, wfblk, wblk, shft, slc, dflt, dopt, deflateSync, pbf]; };
    // gzip extra
    var gze = function () { return [gzh, gzhl, wbytes, crc, crct]; };
    // gunzip extra
    var guze = function () { return [gzs, gzl]; };
    // zlib extra
    var zle = function () { return [zlh, wbytes, adler]; };
    // unzlib extra
    var zule = function () { return [zls]; };
    // post buf
    var pbf = function (msg) { return postMessage(msg, [msg.buffer]); };
    // get opts
    var gopt = function (o) {
        return o && {
            out: o.size && new u8(o.size),
            dictionary: o.dictionary
        };
    };
    // async helper
    var cbify = function (dat, opts, fns, init, id, cb) {
        var w = wrkr(fns, init, id, function (err, dat) {
            w.terminate();
            cb(err, dat);
        });
        w.postMessage([dat, opts], opts.consume ? [dat.buffer] : []);
        return function () { w.terminate(); };
    };
    // auto stream
    var astrm = function (strm) {
        strm.ondata = function (dat, final) { return postMessage([dat, final], [dat.buffer]); };
        return function (ev) {
            if (ev.data.length) {
                strm.push(ev.data[0], ev.data[1]);
                postMessage([ev.data[0].length]);
            }
            else
                strm.flush();
        };
    };
    // async stream attach
    var astrmify = function (fns, strm, opts, init, id, flush, ext) {
        var t;
        var w = wrkr(fns, init, id, function (err, dat) {
            if (err)
                w.terminate(), strm.ondata.call(strm, err);
            else if (!Array.isArray(dat))
                ext(dat);
            else if (dat.length == 1) {
                strm.queuedSize -= dat[0];
                if (strm.ondrain)
                    strm.ondrain(dat[0]);
            }
            else {
                if (dat[1])
                    w.terminate();
                strm.ondata.call(strm, err, dat[0], dat[1]);
            }
        });
        w.postMessage(opts);
        strm.queuedSize = 0;
        strm.push = function (d, f) {
            if (!strm.ondata)
                err(5);
            if (t)
                strm.ondata(err(4, 0, 1), null, !!f);
            strm.queuedSize += d.length;
            w.postMessage([d, t = f], [d.buffer]);
        };
        strm.terminate = function () { w.terminate(); };
        if (flush) {
            strm.flush = function () { w.postMessage([]); };
        }
    };
    // read 2 bytes
    var b2 = function (d, b) { return d[b] | (d[b + 1] << 8); };
    // read 4 bytes
    var b4 = function (d, b) { return (d[b] | (d[b + 1] << 8) | (d[b + 2] << 16) | (d[b + 3] << 24)) >>> 0; };
    var b8 = function (d, b) { return b4(d, b) + (b4(d, b + 4) * 4294967296); };
    // write bytes
    var wbytes = function (d, b, v) {
        for (; v; ++b)
            d[b] = v, v >>>= 8;
    };
    // gzip header
    var gzh = function (c, o) {
        var fn = o.filename;
        c[0] = 31, c[1] = 139, c[2] = 8, c[8] = o.level < 2 ? 4 : o.level == 9 ? 2 : 0, c[9] = 3; // assume Unix
        if (o.mtime != 0)
            wbytes(c, 4, Math.floor(new Date(o.mtime || Date.now()) / 1000));
        if (fn) {
            c[3] = 8;
            for (var i = 0; i <= fn.length; ++i)
                c[i + 10] = fn.charCodeAt(i);
        }
    };
    // gzip footer: -8 to -4 = CRC, -4 to -0 is length
    // gzip start
    var gzs = function (d) {
        if (d[0] != 31 || d[1] != 139 || d[2] != 8)
            err(6, 'invalid gzip data');
        var flg = d[3];
        var st = 10;
        if (flg & 4)
            st += (d[10] | d[11] << 8) + 2;
        for (var zs = (flg >> 3 & 1) + (flg >> 4 & 1); zs > 0; zs -= !d[st++])
            ;
        return st + (flg & 2);
    };
    // gzip length
    var gzl = function (d) {
        var l = d.length;
        return (d[l - 4] | d[l - 3] << 8 | d[l - 2] << 16 | d[l - 1] << 24) >>> 0;
    };
    // gzip header length
    var gzhl = function (o) { return 10 + (o.filename ? o.filename.length + 1 : 0); };
    // zlib header
    var zlh = function (c, o) {
        var lv = o.level, fl = lv == 0 ? 0 : lv < 6 ? 1 : lv == 9 ? 3 : 2;
        c[0] = 120, c[1] = (fl << 6) | (o.dictionary && 32);
        c[1] |= 31 - ((c[0] << 8) | c[1]) % 31;
        if (o.dictionary) {
            var h = adler();
            h.p(o.dictionary);
            wbytes(c, 2, h.d());
        }
    };
    // zlib start
    var zls = function (d, dict) {
        if ((d[0] & 15) != 8 || (d[0] >> 4) > 7 || ((d[0] << 8 | d[1]) % 31))
            err(6, 'invalid zlib data');
        if ((d[1] >> 5 & 1) == +!dict)
            err(6, 'invalid zlib data: ' + (d[1] & 32 ? 'need' : 'unexpected') + ' dictionary');
        return (d[1] >> 3 & 4) + 2;
    };
    function StrmOpt(opts, cb) {
        if (typeof opts == 'function')
            cb = opts, opts = {};
        this.ondata = cb;
        return opts;
    }
    /**
     * Streaming DEFLATE compression
     */
    var Deflate = /*#__PURE__*/ (function () {
        function Deflate(opts, cb) {
            if (typeof opts == 'function')
                cb = opts, opts = {};
            this.ondata = cb;
            this.o = opts || {};
            this.s = { l: 0, i: 32768, w: 32768, z: 32768 };
            // Buffer length must always be 0 mod 32768 for index calculations to be correct when modifying head and prev
            // 98304 = 32768 (lookback) + 65536 (common chunk size)
            this.b = new u8(98304);
            if (this.o.dictionary) {
                var dict = this.o.dictionary.subarray(-32768);
                this.b.set(dict, 32768 - dict.length);
                this.s.i = 32768 - dict.length;
            }
        }
        Deflate.prototype.p = function (c, f) {
            this.ondata(dopt(c, this.o, 0, 0, this.s), f);
        };
        /**
         * Pushes a chunk to be deflated
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Deflate.prototype.push = function (chunk, final) {
            if (!this.ondata)
                err(5);
            if (this.s.l)
                err(4);
            var endLen = chunk.length + this.s.z;
            if (endLen > this.b.length) {
                if (endLen > 2 * this.b.length - 32768) {
                    var newBuf = new u8(endLen & -32768);
                    newBuf.set(this.b.subarray(0, this.s.z));
                    this.b = newBuf;
                }
                var split = this.b.length - this.s.z;
                this.b.set(chunk.subarray(0, split), this.s.z);
                this.s.z = this.b.length;
                this.p(this.b, false);
                this.b.set(this.b.subarray(-32768));
                this.b.set(chunk.subarray(split), 32768);
                this.s.z = chunk.length - split + 32768;
                this.s.i = 32766, this.s.w = 32768;
            }
            else {
                this.b.set(chunk, this.s.z);
                this.s.z += chunk.length;
            }
            this.s.l = final & 1;
            if (this.s.z > this.s.w + 8191 || final) {
                this.p(this.b, final || false);
                this.s.w = this.s.i, this.s.i -= 2;
            }
        };
        /**
         * Flushes buffered uncompressed data. Useful to immediately retrieve the
         * deflated output for small inputs.
         */
        Deflate.prototype.flush = function () {
            if (!this.ondata)
                err(5);
            if (this.s.l)
                err(4);
            this.p(this.b, false);
            this.s.w = this.s.i, this.s.i -= 2;
        };
        return Deflate;
    }());
    exports.Deflate = Deflate;
    /**
     * Asynchronous streaming DEFLATE compression
     */
    var AsyncDeflate = /*#__PURE__*/ (function () {
        function AsyncDeflate(opts, cb) {
            astrmify([
                bDflt,
                function () { return [astrm, Deflate]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Deflate(ev.data);
                onmessage = astrm(strm);
            }, 6, 1);
        }
        return AsyncDeflate;
    }());
    exports.AsyncDeflate = AsyncDeflate;
    function deflate(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bDflt,
        ], function (ev) { return pbf(deflateSync(ev.data[0], ev.data[1])); }, 0, cb);
    }
    /**
     * Compresses data with DEFLATE without any wrapper
     * @param data The data to compress
     * @param opts The compression options
     * @returns The deflated version of the data
     */
    function deflateSync(data, opts) {
        return dopt(data, opts || {}, 0, 0);
    }
    /**
     * Streaming DEFLATE decompression
     */
    var Inflate = /*#__PURE__*/ (function () {
        function Inflate(opts, cb) {
            // no StrmOpt here to avoid adding to workerizer
            if (typeof opts == 'function')
                cb = opts, opts = {};
            this.ondata = cb;
            var dict = opts && opts.dictionary && opts.dictionary.subarray(-32768);
            this.s = { i: 0, b: dict ? dict.length : 0 };
            this.o = new u8(32768);
            this.p = new u8(0);
            if (dict)
                this.o.set(dict);
        }
        Inflate.prototype.e = function (c) {
            if (!this.ondata)
                err(5);
            if (this.d)
                err(4);
            if (!this.p.length)
                this.p = c;
            else if (c.length) {
                var n = new u8(this.p.length + c.length);
                n.set(this.p), n.set(c, this.p.length), this.p = n;
            }
        };
        Inflate.prototype.c = function (final) {
            this.s.i = +(this.d = final || false);
            var bts = this.s.b;
            var dt = inflt(this.p, this.s, this.o);
            this.ondata(slc(dt, bts, this.s.b), this.d);
            this.o = slc(dt, this.s.b - 32768), this.s.b = this.o.length;
            this.p = slc(this.p, (this.s.p / 8) | 0), this.s.p &= 7;
        };
        /**
         * Pushes a chunk to be inflated
         * @param chunk The chunk to push
         * @param final Whether this is the final chunk
         */
        Inflate.prototype.push = function (chunk, final) {
            this.e(chunk), this.c(final);
        };
        return Inflate;
    }());
    exports.Inflate = Inflate;
    /**
     * Asynchronous streaming DEFLATE decompression
     */
    var AsyncInflate = /*#__PURE__*/ (function () {
        function AsyncInflate(opts, cb) {
            astrmify([
                bInflt,
                function () { return [astrm, Inflate]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Inflate(ev.data);
                onmessage = astrm(strm);
            }, 7, 0);
        }
        return AsyncInflate;
    }());
    exports.AsyncInflate = AsyncInflate;
    function inflate(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bInflt
        ], function (ev) { return pbf(inflateSync(ev.data[0], gopt(ev.data[1]))); }, 1, cb);
    }
    /**
     * Expands DEFLATE data with no wrapper
     * @param data The data to decompress
     * @param opts The decompression options
     * @returns The decompressed version of the data
     */
    function inflateSync(data, opts) {
        return inflt(data, { i: 2 }, opts && opts.out, opts && opts.dictionary);
    }
    // before you yell at me for not just using extends, my reason is that TS inheritance is hard to workerize.
    /**
     * Streaming GZIP compression
     */
    var Gzip = /*#__PURE__*/ (function () {
        function Gzip(opts, cb) {
            this.c = crc();
            this.l = 0;
            this.v = 1;
            Deflate.call(this, opts, cb);
        }
        /**
         * Pushes a chunk to be GZIPped
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Gzip.prototype.push = function (chunk, final) {
            this.c.p(chunk);
            this.l += chunk.length;
            Deflate.prototype.push.call(this, chunk, final);
        };
        Gzip.prototype.p = function (c, f) {
            var raw = dopt(c, this.o, this.v && gzhl(this.o), f && 8, this.s);
            if (this.v)
                gzh(raw, this.o), this.v = 0;
            if (f)
                wbytes(raw, raw.length - 8, this.c.d()), wbytes(raw, raw.length - 4, this.l);
            this.ondata(raw, f);
        };
        /**
         * Flushes buffered uncompressed data. Useful to immediately retrieve the
         * GZIPped output for small inputs.
         */
        Gzip.prototype.flush = function () {
            Deflate.prototype.flush.call(this);
        };
        return Gzip;
    }());
    exports.Gzip = Gzip;
    exports.Compress = Gzip;
    /**
     * Asynchronous streaming GZIP compression
     */
    var AsyncGzip = /*#__PURE__*/ (function () {
        function AsyncGzip(opts, cb) {
            astrmify([
                bDflt,
                gze,
                function () { return [astrm, Deflate, Gzip]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Gzip(ev.data);
                onmessage = astrm(strm);
            }, 8, 1);
        }
        return AsyncGzip;
    }());
    exports.AsyncGzip = AsyncGzip;
    exports.AsyncCompress = AsyncGzip;
    function gzip(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bDflt,
            gze,
            function () { return [gzipSync]; }
        ], function (ev) { return pbf(gzipSync(ev.data[0], ev.data[1])); }, 2, cb);
    }
    /**
     * Compresses data with GZIP
     * @param data The data to compress
     * @param opts The compression options
     * @returns The gzipped version of the data
     */
    function gzipSync(data, opts) {
        if (!opts)
            opts = {};
        var c = crc(), l = data.length;
        c.p(data);
        var d = dopt(data, opts, gzhl(opts), 8), s = d.length;
        return gzh(d, opts), wbytes(d, s - 8, c.d()), wbytes(d, s - 4, l), d;
    }
    /**
     * Streaming single or multi-member GZIP decompression
     */
    var Gunzip = /*#__PURE__*/ (function () {
        function Gunzip(opts, cb) {
            this.v = 1;
            this.r = 0;
            Inflate.call(this, opts, cb);
        }
        /**
         * Pushes a chunk to be GUNZIPped
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Gunzip.prototype.push = function (chunk, final) {
            Inflate.prototype.e.call(this, chunk);
            this.r += chunk.length;
            if (this.v) {
                var p = this.p.subarray(this.v - 1);
                var s = p.length > 3 ? gzs(p) : 4;
                if (s > p.length) {
                    if (!final)
                        return;
                }
                else if (this.v > 1 && this.onmember) {
                    this.onmember(this.r - p.length);
                }
                this.p = p.subarray(s), this.v = 0;
            }
            // necessary to prevent TS from using the closure value
            // This allows for workerization to function correctly
            Inflate.prototype.c.call(this, final);
            // process concatenated GZIP
            if (this.s.f && !this.s.l && !final) {
                this.v = shft(this.s.p) + 9;
                this.s = { i: 0 };
                this.o = new u8(0);
                this.push(new u8(0), final);
            }
        };
        return Gunzip;
    }());
    exports.Gunzip = Gunzip;
    /**
     * Asynchronous streaming single or multi-member GZIP decompression
     */
    var AsyncGunzip = /*#__PURE__*/ (function () {
        function AsyncGunzip(opts, cb) {
            var _this = this;
            astrmify([
                bInflt,
                guze,
                function () { return [astrm, Inflate, Gunzip]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Gunzip(ev.data);
                strm.onmember = function (offset) { return postMessage(offset); };
                onmessage = astrm(strm);
            }, 9, 0, function (offset) { return _this.onmember && _this.onmember(offset); });
        }
        return AsyncGunzip;
    }());
    exports.AsyncGunzip = AsyncGunzip;
    function gunzip(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bInflt,
            guze,
            function () { return [gunzipSync]; }
        ], function (ev) { return pbf(gunzipSync(ev.data[0], ev.data[1])); }, 3, cb);
    }
    /**
     * Expands GZIP data
     * @param data The data to decompress
     * @param opts The decompression options
     * @returns The decompressed version of the data
     */
    function gunzipSync(data, opts) {
        var st = gzs(data);
        if (st + 8 > data.length)
            err(6, 'invalid gzip data');
        return inflt(data.subarray(st, -8), { i: 2 }, opts && opts.out || new u8(gzl(data)), opts && opts.dictionary);
    }
    /**
     * Streaming Zlib compression
     */
    var Zlib = /*#__PURE__*/ (function () {
        function Zlib(opts, cb) {
            this.c = adler();
            this.v = 1;
            Deflate.call(this, opts, cb);
        }
        /**
         * Pushes a chunk to be zlibbed
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Zlib.prototype.push = function (chunk, final) {
            this.c.p(chunk);
            Deflate.prototype.push.call(this, chunk, final);
        };
        Zlib.prototype.p = function (c, f) {
            var raw = dopt(c, this.o, this.v && (this.o.dictionary ? 6 : 2), f && 4, this.s);
            if (this.v)
                zlh(raw, this.o), this.v = 0;
            if (f)
                wbytes(raw, raw.length - 4, this.c.d());
            this.ondata(raw, f);
        };
        /**
         * Flushes buffered uncompressed data. Useful to immediately retrieve the
         * zlibbed output for small inputs.
         */
        Zlib.prototype.flush = function () {
            Deflate.prototype.flush.call(this);
        };
        return Zlib;
    }());
    exports.Zlib = Zlib;
    /**
     * Asynchronous streaming Zlib compression
     */
    var AsyncZlib = /*#__PURE__*/ (function () {
        function AsyncZlib(opts, cb) {
            astrmify([
                bDflt,
                zle,
                function () { return [astrm, Deflate, Zlib]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Zlib(ev.data);
                onmessage = astrm(strm);
            }, 10, 1);
        }
        return AsyncZlib;
    }());
    exports.AsyncZlib = AsyncZlib;
    function zlib(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bDflt,
            zle,
            function () { return [zlibSync]; }
        ], function (ev) { return pbf(zlibSync(ev.data[0], ev.data[1])); }, 4, cb);
    }
    /**
     * Compress data with Zlib
     * @param data The data to compress
     * @param opts The compression options
     * @returns The zlib-compressed version of the data
     */
    function zlibSync(data, opts) {
        if (!opts)
            opts = {};
        var a = adler();
        a.p(data);
        var d = dopt(data, opts, opts.dictionary ? 6 : 2, 4);
        return zlh(d, opts), wbytes(d, d.length - 4, a.d()), d;
    }
    /**
     * Streaming Zlib decompression
     */
    var Unzlib = /*#__PURE__*/ (function () {
        function Unzlib(opts, cb) {
            Inflate.call(this, opts, cb);
            this.v = opts && opts.dictionary ? 2 : 1;
        }
        /**
         * Pushes a chunk to be unzlibbed
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Unzlib.prototype.push = function (chunk, final) {
            Inflate.prototype.e.call(this, chunk);
            if (this.v) {
                if (this.p.length < 6 && !final)
                    return;
                this.p = this.p.subarray(zls(this.p, this.v - 1)), this.v = 0;
            }
            if (final) {
                if (this.p.length < 4)
                    err(6, 'invalid zlib data');
                this.p = this.p.subarray(0, -4);
            }
            // necessary to prevent TS from using the closure value
            // This allows for workerization to function correctly
            Inflate.prototype.c.call(this, final);
        };
        return Unzlib;
    }());
    exports.Unzlib = Unzlib;
    /**
     * Asynchronous streaming Zlib decompression
     */
    var AsyncUnzlib = /*#__PURE__*/ (function () {
        function AsyncUnzlib(opts, cb) {
            astrmify([
                bInflt,
                zule,
                function () { return [astrm, Inflate, Unzlib]; }
            ], this, StrmOpt.call(this, opts, cb), function (ev) {
                var strm = new Unzlib(ev.data);
                onmessage = astrm(strm);
            }, 11, 0);
        }
        return AsyncUnzlib;
    }());
    exports.AsyncUnzlib = AsyncUnzlib;
    function unzlib(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return cbify(data, opts, [
            bInflt,
            zule,
            function () { return [unzlibSync]; }
        ], function (ev) { return pbf(unzlibSync(ev.data[0], gopt(ev.data[1]))); }, 5, cb);
    }
    /**
     * Expands Zlib data
     * @param data The data to decompress
     * @param opts The decompression options
     * @returns The decompressed version of the data
     */
    function unzlibSync(data, opts) {
        return inflt(data.subarray(zls(data, opts && opts.dictionary), -4), { i: 2 }, opts && opts.out, opts && opts.dictionary);
    }
    /**
     * Streaming GZIP, Zlib, or raw DEFLATE decompression
     */
    var Decompress = /*#__PURE__*/ (function () {
        function Decompress(opts, cb) {
            this.o = StrmOpt.call(this, opts, cb) || {};
            this.G = Gunzip;
            this.I = Inflate;
            this.Z = Unzlib;
        }
        // init substream
        // overriden by AsyncDecompress
        Decompress.prototype.i = function () {
            var _this = this;
            this.s.ondata = function (dat, final) {
                _this.ondata(dat, final);
            };
        };
        /**
         * Pushes a chunk to be decompressed
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Decompress.prototype.push = function (chunk, final) {
            if (!this.ondata)
                err(5);
            if (!this.s) {
                if (this.p && this.p.length) {
                    var n = new u8(this.p.length + chunk.length);
                    n.set(this.p), n.set(chunk, this.p.length);
                }
                else
                    this.p = chunk;
                if (this.p.length > 2) {
                    this.s = (this.p[0] == 31 && this.p[1] == 139 && this.p[2] == 8)
                        ? new this.G(this.o)
                        : ((this.p[0] & 15) != 8 || (this.p[0] >> 4) > 7 || ((this.p[0] << 8 | this.p[1]) % 31))
                            ? new this.I(this.o)
                            : new this.Z(this.o);
                    this.i();
                    this.s.push(this.p, final);
                    this.p = null;
                }
            }
            else
                this.s.push(chunk, final);
        };
        return Decompress;
    }());
    exports.Decompress = Decompress;
    /**
     * Asynchronous streaming GZIP, Zlib, or raw DEFLATE decompression
     */
    var AsyncDecompress = /*#__PURE__*/ (function () {
        function AsyncDecompress(opts, cb) {
            Decompress.call(this, opts, cb);
            this.queuedSize = 0;
            this.G = AsyncGunzip;
            this.I = AsyncInflate;
            this.Z = AsyncUnzlib;
        }
        AsyncDecompress.prototype.i = function () {
            var _this = this;
            this.s.ondata = function (err, dat, final) {
                _this.ondata(err, dat, final);
            };
            this.s.ondrain = function (size) {
                _this.queuedSize -= size;
                if (_this.ondrain)
                    _this.ondrain(size);
            };
        };
        /**
         * Pushes a chunk to be decompressed
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        AsyncDecompress.prototype.push = function (chunk, final) {
            this.queuedSize += chunk.length;
            Decompress.prototype.push.call(this, chunk, final);
        };
        return AsyncDecompress;
    }());
    exports.AsyncDecompress = AsyncDecompress;
    function decompress(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        return (data[0] == 31 && data[1] == 139 && data[2] == 8)
            ? gunzip(data, opts, cb)
            : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
                ? inflate(data, opts, cb)
                : unzlib(data, opts, cb);
    }
    /**
     * Expands compressed GZIP, Zlib, or raw DEFLATE data, automatically detecting the format
     * @param data The data to decompress
     * @param opts The decompression options
     * @returns The decompressed version of the data
     */
    function decompressSync(data, opts) {
        return (data[0] == 31 && data[1] == 139 && data[2] == 8)
            ? gunzipSync(data, opts)
            : ((data[0] & 15) != 8 || (data[0] >> 4) > 7 || ((data[0] << 8 | data[1]) % 31))
                ? inflateSync(data, opts)
                : unzlibSync(data, opts);
    }
    // flatten a directory structure
    var fltn = function (d, p, t, o) {
        for (var k in d) {
            var val = d[k], n = p + k, op = o;
            if (Array.isArray(val))
                op = mrg(o, val[1]), val = val[0];
            if (val instanceof u8)
                t[n] = [val, op];
            else {
                t[n += '/'] = [new u8(0), op];
                fltn(val, n, t, o);
            }
        }
    };
    // text encoder
    var te = typeof TextEncoder != 'undefined' && /*#__PURE__*/ new TextEncoder();
    // text decoder
    var td = typeof TextDecoder != 'undefined' && /*#__PURE__*/ new TextDecoder();
    // text decoder stream
    var tds = 0;
    try {
        td.decode(et, { stream: true });
        tds = 1;
    }
    catch (e) { }
    // decode UTF8
    var dutf8 = function (d) {
        for (var r = '', i = 0;;) {
            var c = d[i++];
            var eb = (c > 127) + (c > 223) + (c > 239);
            if (i + eb > d.length)
                return { s: r, r: slc(d, i - 1) };
            if (!eb)
                r += String.fromCharCode(c);
            else if (eb == 3) {
                c = ((c & 15) << 18 | (d[i++] & 63) << 12 | (d[i++] & 63) << 6 | (d[i++] & 63)) - 65536,
                    r += String.fromCharCode(55296 | (c >> 10), 56320 | (c & 1023));
            }
            else if (eb & 1)
                r += String.fromCharCode((c & 31) << 6 | (d[i++] & 63));
            else
                r += String.fromCharCode((c & 15) << 12 | (d[i++] & 63) << 6 | (d[i++] & 63));
        }
    };
    /**
     * Streaming UTF-8 decoding
     */
    var DecodeUTF8 = /*#__PURE__*/ (function () {
        /**
         * Creates a UTF-8 decoding stream
         * @param cb The callback to call whenever data is decoded
         */
        function DecodeUTF8(cb) {
            this.ondata = cb;
            if (tds)
                this.t = new TextDecoder();
            else
                this.p = et;
        }
        /**
         * Pushes a chunk to be decoded from UTF-8 binary
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        DecodeUTF8.prototype.push = function (chunk, final) {
            if (!this.ondata)
                err(5);
            final = !!final;
            if (this.t) {
                this.ondata(this.t.decode(chunk, { stream: true }), final);
                if (final) {
                    if (this.t.decode().length)
                        err(8);
                    this.t = null;
                }
                return;
            }
            if (!this.p)
                err(4);
            var dat = new u8(this.p.length + chunk.length);
            dat.set(this.p);
            dat.set(chunk, this.p.length);
            var _a = dutf8(dat), s = _a.s, r = _a.r;
            if (final) {
                if (r.length)
                    err(8);
                this.p = null;
            }
            else
                this.p = r;
            this.ondata(s, final);
        };
        return DecodeUTF8;
    }());
    exports.DecodeUTF8 = DecodeUTF8;
    /**
     * Streaming UTF-8 encoding
     */
    var EncodeUTF8 = /*#__PURE__*/ (function () {
        /**
         * Creates a UTF-8 decoding stream
         * @param cb The callback to call whenever data is encoded
         */
        function EncodeUTF8(cb) {
            this.ondata = cb;
        }
        /**
         * Pushes a chunk to be encoded to UTF-8
         * @param chunk The string data to push
         * @param final Whether this is the last chunk
         */
        EncodeUTF8.prototype.push = function (chunk, final) {
            if (!this.ondata)
                err(5);
            if (this.d)
                err(4);
            this.ondata(strToU8(chunk), this.d = final || false);
        };
        return EncodeUTF8;
    }());
    exports.EncodeUTF8 = EncodeUTF8;
    /**
     * Converts a string into a Uint8Array for use with compression/decompression methods
     * @param str The string to encode
     * @param latin1 Whether or not to interpret the data as Latin-1. This should
     *               not need to be true unless decoding a binary string.
     * @returns The string encoded in UTF-8/Latin-1 binary
     */
    function strToU8(str, latin1) {
        if (latin1) {
            var ar_1 = new u8(str.length);
            for (var i = 0; i < str.length; ++i)
                ar_1[i] = str.charCodeAt(i);
            return ar_1;
        }
        if (te)
            return te.encode(str);
        var l = str.length;
        var ar = new u8(str.length + (str.length >> 1));
        var ai = 0;
        var w = function (v) { ar[ai++] = v; };
        for (var i = 0; i < l; ++i) {
            if (ai + 5 > ar.length) {
                var n = new u8(ai + 8 + ((l - i) << 1));
                n.set(ar);
                ar = n;
            }
            var c = str.charCodeAt(i);
            if (c < 128 || latin1)
                w(c);
            else if (c < 2048)
                w(192 | (c >> 6)), w(128 | (c & 63));
            else if (c > 55295 && c < 57344)
                c = 65536 + (c & 1023 << 10) | (str.charCodeAt(++i) & 1023),
                    w(240 | (c >> 18)), w(128 | ((c >> 12) & 63)), w(128 | ((c >> 6) & 63)), w(128 | (c & 63));
            else
                w(224 | (c >> 12)), w(128 | ((c >> 6) & 63)), w(128 | (c & 63));
        }
        return slc(ar, 0, ai);
    }
    /**
     * Converts a Uint8Array to a string
     * @param dat The data to decode to string
     * @param latin1 Whether or not to interpret the data as Latin-1. This should
     *               not need to be true unless encoding to binary string.
     * @returns The original UTF-8/Latin-1 string
     */
    function strFromU8(dat, latin1) {
        if (latin1) {
            var r = '';
            for (var i = 0; i < dat.length; i += 16384)
                r += String.fromCharCode.apply(null, dat.subarray(i, i + 16384));
            return r;
        }
        else if (td) {
            return td.decode(dat);
        }
        else {
            var _a = dutf8(dat), s = _a.s, r = _a.r;
            if (r.length)
                err(8);
            return s;
        }
    }
    ;
    // deflate bit flag
    var dbf = function (l) { return l == 1 ? 3 : l < 6 ? 2 : l == 9 ? 1 : 0; };
    // skip local zip header
    var slzh = function (d, b) { return b + 30 + b2(d, b + 26) + b2(d, b + 28); };
    // read zip header
    var zh = function (d, b, z) {
        var fnl = b2(d, b + 28), fn = strFromU8(d.subarray(b + 46, b + 46 + fnl), !(b2(d, b + 8) & 2048)), es = b + 46 + fnl, bs = b4(d, b + 20);
        var _a = z && bs == 4294967295 ? z64e(d, es) : [bs, b4(d, b + 24), b4(d, b + 42)], sc = _a[0], su = _a[1], off = _a[2];
        return [b2(d, b + 10), sc, su, fn, es + b2(d, b + 30) + b2(d, b + 32), off];
    };
    // read zip64 extra field
    var z64e = function (d, b) {
        for (; b2(d, b) != 1; b += 4 + b2(d, b + 2))
            ;
        return [b8(d, b + 12), b8(d, b + 4), b8(d, b + 20)];
    };
    // extra field length
    var exfl = function (ex) {
        var le = 0;
        if (ex) {
            for (var k in ex) {
                var l = ex[k].length;
                if (l > 65535)
                    err(9);
                le += l + 4;
            }
        }
        return le;
    };
    // write zip header
    var wzh = function (d, b, f, fn, u, c, ce, co) {
        var fl = fn.length, ex = f.extra, col = co && co.length;
        var exl = exfl(ex);
        wbytes(d, b, ce != null ? 0x2014B50 : 0x4034B50), b += 4;
        if (ce != null)
            d[b++] = 20, d[b++] = f.os;
        d[b] = 20, b += 2; // spec compliance? what's that?
        d[b++] = (f.flag << 1) | (c < 0 && 8), d[b++] = u && 8;
        d[b++] = f.compression & 255, d[b++] = f.compression >> 8;
        var dt = new Date(f.mtime == null ? Date.now() : f.mtime), y = dt.getFullYear() - 1980;
        if (y < 0 || y > 119)
            err(10);
        wbytes(d, b, (y << 25) | ((dt.getMonth() + 1) << 21) | (dt.getDate() << 16) | (dt.getHours() << 11) | (dt.getMinutes() << 5) | (dt.getSeconds() >> 1)), b += 4;
        if (c != -1) {
            wbytes(d, b, f.crc);
            wbytes(d, b + 4, c < 0 ? -c - 2 : c);
            wbytes(d, b + 8, f.size);
        }
        wbytes(d, b + 12, fl);
        wbytes(d, b + 14, exl), b += 16;
        if (ce != null) {
            wbytes(d, b, col);
            wbytes(d, b + 6, f.attrs);
            wbytes(d, b + 10, ce), b += 14;
        }
        d.set(fn, b);
        b += fl;
        if (exl) {
            for (var k in ex) {
                var exf = ex[k], l = exf.length;
                wbytes(d, b, +k);
                wbytes(d, b + 2, l);
                d.set(exf, b + 4), b += 4 + l;
            }
        }
        if (col)
            d.set(co, b), b += col;
        return b;
    };
    // write zip footer (end of central directory)
    var wzf = function (o, b, c, d, e) {
        wbytes(o, b, 0x6054B50); // skip disk
        wbytes(o, b + 8, c);
        wbytes(o, b + 10, c);
        wbytes(o, b + 12, d);
        wbytes(o, b + 16, e);
    };
    /**
     * A pass-through stream to keep data uncompressed in a ZIP archive.
     */
    var ZipPassThrough = /*#__PURE__*/ (function () {
        /**
         * Creates a pass-through stream that can be added to ZIP archives
         * @param filename The filename to associate with this data stream
         */
        function ZipPassThrough(filename) {
            this.filename = filename;
            this.c = crc();
            this.size = 0;
            this.compression = 0;
        }
        /**
         * Processes a chunk and pushes to the output stream. You can override this
         * method in a subclass for custom behavior, but by default this passes
         * the data through. You must call this.ondata(err, chunk, final) at some
         * point in this method.
         * @param chunk The chunk to process
         * @param final Whether this is the last chunk
         */
        ZipPassThrough.prototype.process = function (chunk, final) {
            this.ondata(null, chunk, final);
        };
        /**
         * Pushes a chunk to be added. If you are subclassing this with a custom
         * compression algorithm, note that you must push data from the source
         * file only, pre-compression.
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        ZipPassThrough.prototype.push = function (chunk, final) {
            if (!this.ondata)
                err(5);
            this.c.p(chunk);
            this.size += chunk.length;
            if (final)
                this.crc = this.c.d();
            this.process(chunk, final || false);
        };
        return ZipPassThrough;
    }());
    exports.ZipPassThrough = ZipPassThrough;
    // I don't extend because TypeScript extension adds 1kB of runtime bloat
    /**
     * Streaming DEFLATE compression for ZIP archives. Prefer using AsyncZipDeflate
     * for better performance
     */
    var ZipDeflate = /*#__PURE__*/ (function () {
        /**
         * Creates a DEFLATE stream that can be added to ZIP archives
         * @param filename The filename to associate with this data stream
         * @param opts The compression options
         */
        function ZipDeflate(filename, opts) {
            var _this = this;
            if (!opts)
                opts = {};
            ZipPassThrough.call(this, filename);
            this.d = new Deflate(opts, function (dat, final) {
                _this.ondata(null, dat, final);
            });
            this.compression = 8;
            this.flag = dbf(opts.level);
        }
        ZipDeflate.prototype.process = function (chunk, final) {
            try {
                this.d.push(chunk, final);
            }
            catch (e) {
                this.ondata(e, null, final);
            }
        };
        /**
         * Pushes a chunk to be deflated
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        ZipDeflate.prototype.push = function (chunk, final) {
            ZipPassThrough.prototype.push.call(this, chunk, final);
        };
        return ZipDeflate;
    }());
    exports.ZipDeflate = ZipDeflate;
    /**
     * Asynchronous streaming DEFLATE compression for ZIP archives
     */
    var AsyncZipDeflate = /*#__PURE__*/ (function () {
        /**
         * Creates an asynchronous DEFLATE stream that can be added to ZIP archives
         * @param filename The filename to associate with this data stream
         * @param opts The compression options
         */
        function AsyncZipDeflate(filename, opts) {
            var _this = this;
            if (!opts)
                opts = {};
            ZipPassThrough.call(this, filename);
            this.d = new AsyncDeflate(opts, function (err, dat, final) {
                _this.ondata(err, dat, final);
            });
            this.compression = 8;
            this.flag = dbf(opts.level);
            this.terminate = this.d.terminate;
        }
        AsyncZipDeflate.prototype.process = function (chunk, final) {
            this.d.push(chunk, final);
        };
        /**
         * Pushes a chunk to be deflated
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        AsyncZipDeflate.prototype.push = function (chunk, final) {
            ZipPassThrough.prototype.push.call(this, chunk, final);
        };
        return AsyncZipDeflate;
    }());
    exports.AsyncZipDeflate = AsyncZipDeflate;
    // TODO: Better tree shaking
    /**
     * A zippable archive to which files can incrementally be added
     */
    var Zip = /*#__PURE__*/ (function () {
        /**
         * Creates an empty ZIP archive to which files can be added
         * @param cb The callback to call whenever data for the generated ZIP archive
         *           is available
         */
        function Zip(cb) {
            this.ondata = cb;
            this.u = [];
            this.d = 1;
        }
        /**
         * Adds a file to the ZIP archive
         * @param file The file stream to add
         */
        Zip.prototype.add = function (file) {
            var _this = this;
            if (!this.ondata)
                err(5);
            // finishing or finished
            if (this.d & 2)
                this.ondata(err(4 + (this.d & 1) * 8, 0, 1), null, false);
            else {
                var f = strToU8(file.filename), fl_1 = f.length;
                var com = file.comment, o = com && strToU8(com);
                var u = fl_1 != file.filename.length || (o && (com.length != o.length));
                var hl_1 = fl_1 + exfl(file.extra) + 30;
                if (fl_1 > 65535)
                    this.ondata(err(11, 0, 1), null, false);
                var header = new u8(hl_1);
                wzh(header, 0, file, f, u, -1);
                var chks_1 = [header];
                var pAll_1 = function () {
                    for (var _i = 0, chks_2 = chks_1; _i < chks_2.length; _i++) {
                        var chk = chks_2[_i];
                        _this.ondata(null, chk, false);
                    }
                    chks_1 = [];
                };
                var tr_1 = this.d;
                this.d = 0;
                var ind_1 = this.u.length;
                var uf_1 = mrg(file, {
                    f: f,
                    u: u,
                    o: o,
                    t: function () {
                        if (file.terminate)
                            file.terminate();
                    },
                    r: function () {
                        pAll_1();
                        if (tr_1) {
                            var nxt = _this.u[ind_1 + 1];
                            if (nxt)
                                nxt.r();
                            else
                                _this.d = 1;
                        }
                        tr_1 = 1;
                    }
                });
                var cl_1 = 0;
                file.ondata = function (err, dat, final) {
                    if (err) {
                        _this.ondata(err, dat, final);
                        _this.terminate();
                    }
                    else {
                        cl_1 += dat.length;
                        chks_1.push(dat);
                        if (final) {
                            var dd = new u8(16);
                            wbytes(dd, 0, 0x8074B50);
                            wbytes(dd, 4, file.crc);
                            wbytes(dd, 8, cl_1);
                            wbytes(dd, 12, file.size);
                            chks_1.push(dd);
                            uf_1.c = cl_1, uf_1.b = hl_1 + cl_1 + 16, uf_1.crc = file.crc, uf_1.size = file.size;
                            if (tr_1)
                                uf_1.r();
                            tr_1 = 1;
                        }
                        else if (tr_1)
                            pAll_1();
                    }
                };
                this.u.push(uf_1);
            }
        };
        /**
         * Ends the process of adding files and prepares to emit the final chunks.
         * This *must* be called after adding all desired files for the resulting
         * ZIP file to work properly.
         */
        Zip.prototype.end = function () {
            var _this = this;
            if (this.d & 2) {
                this.ondata(err(4 + (this.d & 1) * 8, 0, 1), null, true);
                return;
            }
            if (this.d)
                this.e();
            else
                this.u.push({
                    r: function () {
                        if (!(_this.d & 1))
                            return;
                        _this.u.splice(-1, 1);
                        _this.e();
                    },
                    t: function () { }
                });
            this.d = 3;
        };
        Zip.prototype.e = function () {
            var bt = 0, l = 0, tl = 0;
            for (var _i = 0, _a = this.u; _i < _a.length; _i++) {
                var f = _a[_i];
                tl += 46 + f.f.length + exfl(f.extra) + (f.o ? f.o.length : 0);
            }
            var out = new u8(tl + 22);
            for (var _b = 0, _c = this.u; _b < _c.length; _b++) {
                var f = _c[_b];
                wzh(out, bt, f, f.f, f.u, -f.c - 2, l, f.o);
                bt += 46 + f.f.length + exfl(f.extra) + (f.o ? f.o.length : 0), l += f.b;
            }
            wzf(out, bt, this.u.length, tl, l);
            this.ondata(null, out, true);
            this.d = 2;
        };
        /**
         * A method to terminate any internal workers used by the stream. Subsequent
         * calls to add() will fail.
         */
        Zip.prototype.terminate = function () {
            for (var _i = 0, _a = this.u; _i < _a.length; _i++) {
                var f = _a[_i];
                f.t();
            }
            this.d = 2;
        };
        return Zip;
    }());
    exports.Zip = Zip;
    function zip(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        var r = {};
        fltn(data, '', r, opts);
        var k = Object.keys(r);
        var lft = k.length, o = 0, tot = 0;
        var slft = lft, files = new Array(lft);
        var term = [];
        var tAll = function () {
            for (var i = 0; i < term.length; ++i)
                term[i]();
        };
        var cbd = function (a, b) {
            mt(function () { cb(a, b); });
        };
        mt(function () { cbd = cb; });
        var cbf = function () {
            var out = new u8(tot + 22), oe = o, cdl = tot - o;
            tot = 0;
            for (var i = 0; i < slft; ++i) {
                var f = files[i];
                try {
                    var l = f.c.length;
                    wzh(out, tot, f, f.f, f.u, l);
                    var badd = 30 + f.f.length + exfl(f.extra);
                    var loc = tot + badd;
                    out.set(f.c, loc);
                    wzh(out, o, f, f.f, f.u, l, tot, f.m), o += 16 + badd + (f.m ? f.m.length : 0), tot = loc + l;
                }
                catch (e) {
                    return cbd(e, null);
                }
            }
            wzf(out, o, files.length, cdl, oe);
            cbd(null, out);
        };
        if (!lft)
            cbf();
        var _loop_1 = function (i) {
            var fn = k[i];
            var _a = r[fn], file = _a[0], p = _a[1];
            var c = crc(), size = file.length;
            c.p(file);
            var f = strToU8(fn), s = f.length;
            var com = p.comment, m = com && strToU8(com), ms = m && m.length;
            var exl = exfl(p.extra);
            var compression = p.level == 0 ? 0 : 8;
            var cbl = function (e, d) {
                if (e) {
                    tAll();
                    cbd(e, null);
                }
                else {
                    var l = d.length;
                    files[i] = mrg(p, {
                        size: size,
                        crc: c.d(),
                        c: d,
                        f: f,
                        m: m,
                        u: s != fn.length || (m && (com.length != ms)),
                        compression: compression
                    });
                    o += 30 + s + exl + l;
                    tot += 76 + 2 * (s + exl) + (ms || 0) + l;
                    if (!--lft)
                        cbf();
                }
            };
            if (s > 65535)
                cbl(err(11, 0, 1), null);
            if (!compression)
                cbl(null, file);
            else if (size < 160000) {
                try {
                    cbl(null, deflateSync(file, p));
                }
                catch (e) {
                    cbl(e, null);
                }
            }
            else
                term.push(deflate(file, p, cbl));
        };
        // Cannot use lft because it can decrease
        for (var i = 0; i < slft; ++i) {
            _loop_1(i);
        }
        return tAll;
    }
    /**
     * Synchronously creates a ZIP file. Prefer using `zip` for better performance
     * with more than one file.
     * @param data The directory structure for the ZIP archive
     * @param opts The main options, merged with per-file options
     * @returns The generated ZIP archive
     */
    function zipSync(data, opts) {
        if (!opts)
            opts = {};
        var r = {};
        var files = [];
        fltn(data, '', r, opts);
        var o = 0;
        var tot = 0;
        for (var fn in r) {
            var _a = r[fn], file = _a[0], p = _a[1];
            var compression = p.level == 0 ? 0 : 8;
            var f = strToU8(fn), s = f.length;
            var com = p.comment, m = com && strToU8(com), ms = m && m.length;
            var exl = exfl(p.extra);
            if (s > 65535)
                err(11);
            var d = compression ? deflateSync(file, p) : file, l = d.length;
            var c = crc();
            c.p(file);
            files.push(mrg(p, {
                size: file.length,
                crc: c.d(),
                c: d,
                f: f,
                m: m,
                u: s != fn.length || (m && (com.length != ms)),
                o: o,
                compression: compression
            }));
            o += 30 + s + exl + l;
            tot += 76 + 2 * (s + exl) + (ms || 0) + l;
        }
        var out = new u8(tot + 22), oe = o, cdl = tot - o;
        for (var i = 0; i < files.length; ++i) {
            var f = files[i];
            wzh(out, f.o, f, f.f, f.u, f.c.length);
            var badd = 30 + f.f.length + exfl(f.extra);
            out.set(f.c, f.o + badd);
            wzh(out, o, f, f.f, f.u, f.c.length, f.o, f.m), o += 16 + badd + (f.m ? f.m.length : 0);
        }
        wzf(out, o, files.length, cdl, oe);
        return out;
    }
    /**
     * Streaming pass-through decompression for ZIP archives
     */
    var UnzipPassThrough = /*#__PURE__*/ (function () {
        function UnzipPassThrough() {
        }
        UnzipPassThrough.prototype.push = function (data, final) {
            this.ondata(null, data, final);
        };
        UnzipPassThrough.compression = 0;
        return UnzipPassThrough;
    }());
    exports.UnzipPassThrough = UnzipPassThrough;
    /**
     * Streaming DEFLATE decompression for ZIP archives. Prefer AsyncZipInflate for
     * better performance.
     */
    var UnzipInflate = /*#__PURE__*/ (function () {
        /**
         * Creates a DEFLATE decompression that can be used in ZIP archives
         */
        function UnzipInflate() {
            var _this = this;
            this.i = new Inflate(function (dat, final) {
                _this.ondata(null, dat, final);
            });
        }
        UnzipInflate.prototype.push = function (data, final) {
            try {
                this.i.push(data, final);
            }
            catch (e) {
                this.ondata(e, null, final);
            }
        };
        UnzipInflate.compression = 8;
        return UnzipInflate;
    }());
    exports.UnzipInflate = UnzipInflate;
    /**
     * Asynchronous streaming DEFLATE decompression for ZIP archives
     */
    var AsyncUnzipInflate = /*#__PURE__*/ (function () {
        /**
         * Creates a DEFLATE decompression that can be used in ZIP archives
         */
        function AsyncUnzipInflate(_, sz) {
            var _this = this;
            if (sz < 320000) {
                this.i = new Inflate(function (dat, final) {
                    _this.ondata(null, dat, final);
                });
            }
            else {
                this.i = new AsyncInflate(function (err, dat, final) {
                    _this.ondata(err, dat, final);
                });
                this.terminate = this.i.terminate;
            }
        }
        AsyncUnzipInflate.prototype.push = function (data, final) {
            if (this.i.terminate)
                data = slc(data, 0);
            this.i.push(data, final);
        };
        AsyncUnzipInflate.compression = 8;
        return AsyncUnzipInflate;
    }());
    exports.AsyncUnzipInflate = AsyncUnzipInflate;
    /**
     * A ZIP archive decompression stream that emits files as they are discovered
     */
    var Unzip = /*#__PURE__*/ (function () {
        /**
         * Creates a ZIP decompression stream
         * @param cb The callback to call whenever a file in the ZIP archive is found
         */
        function Unzip(cb) {
            this.onfile = cb;
            this.k = [];
            this.o = {
                0: UnzipPassThrough
            };
            this.p = et;
        }
        /**
         * Pushes a chunk to be unzipped
         * @param chunk The chunk to push
         * @param final Whether this is the last chunk
         */
        Unzip.prototype.push = function (chunk, final) {
            var _this = this;
            if (!this.onfile)
                err(5);
            if (!this.p)
                err(4);
            if (this.c > 0) {
                var len = Math.min(this.c, chunk.length);
                var toAdd = chunk.subarray(0, len);
                this.c -= len;
                if (this.d)
                    this.d.push(toAdd, !this.c);
                else
                    this.k[0].push(toAdd);
                chunk = chunk.subarray(len);
                if (chunk.length)
                    return this.push(chunk, final);
            }
            else {
                var f = 0, i = 0, is = void 0, buf = void 0;
                if (!this.p.length)
                    buf = chunk;
                else if (!chunk.length)
                    buf = this.p;
                else {
                    buf = new u8(this.p.length + chunk.length);
                    buf.set(this.p), buf.set(chunk, this.p.length);
                }
                var l = buf.length, oc = this.c, add = oc && this.d;
                var _loop_2 = function () {
                    var _a;
                    var sig = b4(buf, i);
                    if (sig == 0x4034B50) {
                        f = 1, is = i;
                        this_1.d = null;
                        this_1.c = 0;
                        var bf = b2(buf, i + 6), cmp_1 = b2(buf, i + 8), u = bf & 2048, dd = bf & 8, fnl = b2(buf, i + 26), es = b2(buf, i + 28);
                        if (l > i + 30 + fnl + es) {
                            var chks_3 = [];
                            this_1.k.unshift(chks_3);
                            f = 2;
                            var sc_1 = b4(buf, i + 18), su_1 = b4(buf, i + 22);
                            var fn_1 = strFromU8(buf.subarray(i + 30, i += 30 + fnl), !u);
                            if (sc_1 == 4294967295) {
                                _a = dd ? [-2] : z64e(buf, i), sc_1 = _a[0], su_1 = _a[1];
                            }
                            else if (dd)
                                sc_1 = -1;
                            i += es;
                            this_1.c = sc_1;
                            var d_1;
                            var file_1 = {
                                name: fn_1,
                                compression: cmp_1,
                                start: function () {
                                    if (!file_1.ondata)
                                        err(5);
                                    if (!sc_1)
                                        file_1.ondata(null, et, true);
                                    else {
                                        var ctr = _this.o[cmp_1];
                                        if (!ctr)
                                            file_1.ondata(err(14, 'unknown compression type ' + cmp_1, 1), null, false);
                                        d_1 = sc_1 < 0 ? new ctr(fn_1) : new ctr(fn_1, sc_1, su_1);
                                        d_1.ondata = function (err, dat, final) { file_1.ondata(err, dat, final); };
                                        for (var _i = 0, chks_4 = chks_3; _i < chks_4.length; _i++) {
                                            var dat = chks_4[_i];
                                            d_1.push(dat, false);
                                        }
                                        if (_this.k[0] == chks_3 && _this.c)
                                            _this.d = d_1;
                                        else
                                            d_1.push(et, true);
                                    }
                                },
                                terminate: function () {
                                    if (d_1 && d_1.terminate)
                                        d_1.terminate();
                                }
                            };
                            if (sc_1 >= 0)
                                file_1.size = sc_1, file_1.originalSize = su_1;
                            this_1.onfile(file_1);
                        }
                        return "break";
                    }
                    else if (oc) {
                        if (sig == 0x8074B50) {
                            is = i += 12 + (oc == -2 && 8), f = 3, this_1.c = 0;
                            return "break";
                        }
                        else if (sig == 0x2014B50) {
                            is = i -= 4, f = 3, this_1.c = 0;
                            return "break";
                        }
                    }
                };
                var this_1 = this;
                for (; i < l - 4; ++i) {
                    var state_1 = _loop_2();
                    if (state_1 === "break")
                        break;
                }
                this.p = et;
                if (oc < 0) {
                    var dat = f ? buf.subarray(0, is - 12 - (oc == -2 && 8) - (b4(buf, is - 16) == 0x8074B50 && 4)) : buf.subarray(0, i);
                    if (add)
                        add.push(dat, !!f);
                    else
                        this.k[+(f == 2)].push(dat);
                }
                if (f & 2)
                    return this.push(buf.subarray(i), final);
                this.p = buf.subarray(i);
            }
            if (final) {
                if (this.c)
                    err(13);
                this.p = null;
            }
        };
        /**
         * Registers a decoder with the stream, allowing for files compressed with
         * the compression type provided to be expanded correctly
         * @param decoder The decoder constructor
         */
        Unzip.prototype.register = function (decoder) {
            this.o[decoder.compression] = decoder;
        };
        return Unzip;
    }());
    exports.Unzip = Unzip;
    var mt = typeof queueMicrotask == 'function' ? queueMicrotask : typeof setTimeout == 'function' ? setTimeout : function (fn) { fn(); };
    function unzip(data, opts, cb) {
        if (!cb)
            cb = opts, opts = {};
        if (typeof cb != 'function')
            err(7);
        var term = [];
        var tAll = function () {
            for (var i = 0; i < term.length; ++i)
                term[i]();
        };
        var files = {};
        var cbd = function (a, b) {
            mt(function () { cb(a, b); });
        };
        mt(function () { cbd = cb; });
        var e = data.length - 22;
        for (; b4(data, e) != 0x6054B50; --e) {
            if (!e || data.length - e > 65558) {
                cbd(err(13, 0, 1), null);
                return tAll;
            }
        }
        ;
        var lft = b2(data, e + 8);
        if (lft) {
            var c = lft;
            var o = b4(data, e + 16);
            var z = o == 4294967295 || c == 65535;
            if (z) {
                var ze = b4(data, e - 12);
                z = b4(data, ze) == 0x6064B50;
                if (z) {
                    c = lft = b4(data, ze + 32);
                    o = b4(data, ze + 48);
                }
            }
            var fltr = opts && opts.filter;
            var _loop_3 = function (i) {
                var _a = zh(data, o, z), c_1 = _a[0], sc = _a[1], su = _a[2], fn = _a[3], no = _a[4], off = _a[5], b = slzh(data, off);
                o = no;
                var cbl = function (e, d) {
                    if (e) {
                        tAll();
                        cbd(e, null);
                    }
                    else {
                        if (d)
                            files[fn] = d;
                        if (!--lft)
                            cbd(null, files);
                    }
                };
                if (!fltr || fltr({
                    name: fn,
                    size: sc,
                    originalSize: su,
                    compression: c_1
                })) {
                    if (!c_1)
                        cbl(null, slc(data, b, b + sc));
                    else if (c_1 == 8) {
                        var infl = data.subarray(b, b + sc);
                        // Synchronously decompress under 512KB, or barely-compressed data
                        if (su < 524288 || sc > 0.8 * su) {
                            try {
                                cbl(null, inflateSync(infl, { out: new u8(su) }));
                            }
                            catch (e) {
                                cbl(e, null);
                            }
                        }
                        else
                            term.push(inflate(infl, { size: su }, cbl));
                    }
                    else
                        cbl(err(14, 'unknown compression type ' + c_1, 1), null);
                }
                else
                    cbl(null, null);
            };
            for (var i = 0; i < c; ++i) {
                _loop_3(i);
            }
        }
        else
            cbd(null, {});
        return tAll;
    }
    /**
     * Synchronously decompresses a ZIP archive. Prefer using `unzip` for better
     * performance with more than one file.
     * @param data The raw compressed ZIP file
     * @param opts The ZIP extraction options
     * @returns The decompressed files
     */
    function unzipSync(data, opts) {
        var files = {};
        var e = data.length - 22;
        for (; b4(data, e) != 0x6054B50; --e) {
            if (!e || data.length - e > 65558)
                err(13);
        }
        ;
        var c = b2(data, e + 8);
        if (!c)
            return {};
        var o = b4(data, e + 16);
        var z = o == 4294967295 || c == 65535;
        if (z) {
            var ze = b4(data, e - 12);
            z = b4(data, ze) == 0x6064B50;
            if (z) {
                c = b4(data, ze + 32);
                o = b4(data, ze + 48);
            }
        }
        var fltr = opts && opts.filter;
        for (var i = 0; i < c; ++i) {
            var _a = zh(data, o, z), c_2 = _a[0], sc = _a[1], su = _a[2], fn = _a[3], no = _a[4], off = _a[5], b = slzh(data, off);
            o = no;
            if (!fltr || fltr({
                name: fn,
                size: sc,
                originalSize: su,
                compression: c_2
            })) {
                if (!c_2)
                    files[fn] = slc(data, b, b + sc);
                else if (c_2 == 8)
                    files[fn] = inflateSync(data.subarray(b, b + sc), { out: new u8(su) });
                else
                    err(14, 'unknown compression type ' + c_2);
            }
        }
        return files;
    }
},
/* core/serialization/reps.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
},
/* core/diagnostics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Diagnostics {
        constructor() {
            this.listeners = new Set();
        }
        connect(listener) {
            this.listeners.add(listener);
        }
        disconnect(listener) {
            this.listeners.delete(listener);
        }
        report(obj) {
            for (const listener of this.listeners) {
                listener(obj);
            }
        }
    }
    exports.Diagnostics = Diagnostics;
    Diagnostics.__name__ = "Diagnostics";
    exports.diagnostics = new Diagnostics();
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.min = min;
    exports.max = max;
    exports.some = some;
    exports.every = every;
    const tslib_1 = require(1) /* tslib */;
    const eq_1 = require(27) /* ./util/eq */;
    const arrayable = tslib_1.__importStar(require(13) /* ./util/arrayable */);
    class Uniform {
        is_Scalar() {
            return this.is_scalar;
        }
        is_Vector() {
            return !this.is_scalar;
        }
    }
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    class UniformScalar extends Uniform {
        constructor(value, length) {
            super();
            this.is_scalar = true;
            this.value = value;
            this.length = length;
        }
        get(_i) {
            return this.value;
        }
        *[Symbol.iterator]() {
            const { length, value } = this;
            for (let i = 0; i < length; i++) {
                yield value;
            }
        }
        select(indices) {
            return new UniformScalar(this.value, indices.count);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        }
        map(fn) {
            return new UniformScalar(fn(this.value), this.length);
        }
        unique() {
            return [this.value];
        }
    }
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    class UniformVector extends Uniform {
        constructor(array) {
            super();
            this.is_scalar = false;
            this.array = array;
            this.length = this.array.length;
        }
        get(i) {
            return this.array[i];
        }
        *[Symbol.iterator]() {
            yield* this.array;
        }
        select(indices) {
            const array = indices.select(this.array);
            return new this.constructor(array);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        }
        map(fn) {
            return new UniformVector(arrayable.map(this.array, fn));
        }
        unique() {
            return [...new Set(this.array)];
        }
    }
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    class ColorUniformVector extends UniformVector {
        constructor(array) {
            super(array);
            this.array = array;
            this._view = new DataView(array.buffer);
        }
        get(i) {
            return this._view.getUint32(4 * i);
        }
        *[Symbol.iterator]() {
            const n = this.length;
            for (let i = 0; i < n; i++) {
                yield this.get(i);
            }
        }
        copy_buffer() {
            return this.array.buffer.slice();
        }
    }
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
    function min(u) {
        return u.is_Scalar() ? u.value : arrayable.min(u.array);
    }
    function max(u) {
        return u.is_Scalar() ? u.value : arrayable.max(u.array);
    }
    function some(u, predicate) {
        return u.is_Scalar() ? predicate(u.value) : arrayable.some(u.array, predicate);
    }
    function every(u, predicate) {
        return u.is_Scalar() ? predicate(u.value) : arrayable.every(u.array, predicate);
    }
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.uuid4 = uuid4;
    exports.unique_id = unique_id;
    exports.escape = escape;
    exports.unescape = unescape;
    exports.use_strict = use_strict;
    exports.to_fixed = to_fixed;
    exports.insert_text_on_position = insert_text_on_position;
    const settings_1 = require(30) /* ../settings */;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        const s = new Array(32);
        const hex_digits = "0123456789ABCDEF";
        for (let i = 0; i < 32; i++) {
            s[i] = hex_digits[Math.floor(Math.random() * 0x10)];
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hex_digits[(s[16].charCodeAt(0) & 0x3) | 0x8]; // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    let counter = 1000;
    function unique_id(prefix) {
        const id = settings_1.settings.dev ? `j${counter++}` : uuid4();
        if (prefix != null) {
            return `${prefix}-${id}`;
        }
        else {
            return id;
        }
    }
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, (ch) => {
            switch (ch) {
                case "&": return "&amp;";
                case "<": return "&lt;";
                case ">": return "&gt;";
                case '"': return "&quot;";
                case "'": return "&#x27;";
                case "`": return "&#x60;";
                default: return ch;
            }
        });
    }
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_, entity) => {
            switch (entity) {
                case "amp": return "&";
                case "lt": return "<";
                case "gt": return ">";
                case "quot": return '"';
                case "#x27": return "'";
                case "#x60": return "`";
                default: return entity;
            }
        });
    }
    function use_strict(code) {
        return `'use strict';\n${code}`;
    }
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    function insert_text_on_position(destination, position, text_to_be_inserted) {
        const result_text = [];
        result_text.push(destination.slice(0, position));
        result_text.push(text_to_be_inserted);
        result_text.push(destination.slice(position));
        return result_text.join("");
    }
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(27) /* ../core/util/eq */;
    const serialization_1 = require(33) /* ../core/serialization */;
    class DocumentEvent {
        constructor(document) {
            /**
             * Indicates whether this event should be emitted internally within bokehjs,
             * or whether it should also be synchronized with the server, if any session
             * is listening for such events.
             */
            this.sync = true;
            this.document = document;
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__name__;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.document, that.document);
        }
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    class DocumentEventBatch extends DocumentEvent {
        constructor(document, events) {
            super(document);
            this.events = events;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.events, that.events);
        }
    }
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    class DocumentChangedEvent extends DocumentEvent {
    }
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    class MessageSentEvent extends DocumentChangedEvent {
        constructor(document, msg_type, msg_data) {
            super(document);
            this.kind = "MessageSent";
            this.msg_type = msg_type;
            this.msg_data = msg_data;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.msg_type, that.msg_type) &&
                cmp.eq(this.msg_data, that.msg_data);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                msg_type: this.msg_type,
                msg_data: serializer.encode(this.msg_data),
            };
        }
    }
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    class ModelChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, value) {
            super(document);
            this.kind = "ModelChanged";
            this.model = model;
            this.attr = attr;
            this.value = value;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.value, that.value);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                new: serializer.encode(this.value),
            };
        }
    }
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    class ColumnDataChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, cols) {
            super(document);
            this.kind = "ColumnDataChanged";
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.cols = cols;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.cols, that.cols);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                cols: this.cols,
            };
        }
    }
    exports.ColumnDataChangedEvent = ColumnDataChangedEvent;
    ColumnDataChangedEvent.__name__ = "ColumnDataChangedEvent";
    class ColumnsStreamedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, rollover) {
            super(document);
            this.kind = "ColumnsStreamed";
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.rollover = rollover;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.rollover, that.rollover);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                rollover: this.rollover,
            };
        }
    }
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    class ColumnsPatchedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, patches) {
            super(document);
            this.kind = "ColumnsPatched";
            this.model = model;
            this.attr = attr;
            this.patches = patches;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.patches, that.patches);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                attr: this.attr,
                model: this.model.ref(),
                patches: serializer.encode(this.patches),
            };
        }
    }
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    class TitleChangedEvent extends DocumentChangedEvent {
        constructor(document, title) {
            super(document);
            this.kind = "TitleChanged";
            this.title = title;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.title, that.title);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                title: this.title,
            };
        }
    }
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    class RootAddedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.kind = "RootAdded";
            this.model = model;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: serializer.encode(this.model),
            };
        }
    }
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    class RootRemovedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.kind = "RootRemoved";
            this.model = model;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
            };
        }
    }
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.to_string = to_string;
    const types_1 = require(8) /* ./types */;
    const object_1 = require(9) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return (0, types_1.isObject)(obj) && exports.pretty in obj;
    }
    class Printer {
        constructor(options) {
            this.visited = new Set();
            this.precision = options?.precision;
        }
        to_string(obj) {
            if ((0, types_1.isObject)(obj)) {
                if (this.visited.has(obj)) {
                    return "<circular>";
                }
                else {
                    this.visited.add(obj);
                }
            }
            if (is_Printable(obj)) {
                return obj[exports.pretty](this);
            }
            else if ((0, types_1.isBoolean)(obj)) {
                return this.boolean(obj);
            }
            else if ((0, types_1.isNumber)(obj)) {
                return this.number(obj);
            }
            else if ((0, types_1.isString)(obj)) {
                return this.string(obj);
            }
            else if ((0, types_1.isArray)(obj)) {
                return this.array(obj);
            }
            else if ((0, types_1.isIterable)(obj)) {
                return this.iterable(obj);
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                return this.object(obj);
            }
            else if ((0, types_1.isSymbol)(obj)) {
                return this.symbol(obj);
            }
            else if (obj instanceof ArrayBuffer) {
                return this.array_buffer(obj);
            }
            else {
                return `${obj}`;
            }
        }
        token(val) {
            return val;
        }
        boolean(val) {
            return `${val}`;
        }
        number(val) {
            if (this.precision != null) {
                return val.toFixed(this.precision);
            }
            else {
                return `${val}`;
            }
        }
        string(val) {
            const sq = val.includes("'");
            const dq = val.includes('"');
            if (sq && dq) {
                return `\`${val.replace(/`/g, "\\`")}\``;
            }
            else if (dq) {
                return `'${val}'`;
            }
            else {
                return `"${val}"`;
            }
        }
        symbol(val) {
            return val.toString();
        }
        array(obj) {
            const T = this.token;
            const items = [];
            for (const entry of obj) {
                items.push(this.to_string(entry));
            }
            return `${T("[")}${items.join(`${T(",")} `)}${T("]")}`;
        }
        iterable(obj) {
            const T = this.token;
            const tag = Object(obj)[Symbol.toStringTag] ?? "Object";
            const items = this.array(obj);
            return `${tag}${T("(")}${items}${T(")")}`;
        }
        object(obj) {
            const T = this.token;
            const items = [];
            for (const [key, val] of (0, object_1.entries)(obj)) {
                items.push(`${key}${T(":")} ${this.to_string(val)}`);
            }
            return `${T("{")}${items.join(`${T(",")} `)}${T("}")}`;
        }
        array_buffer(obj) {
            return `ArrayBuffer(#${obj.byteLength})`;
        }
    }
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        const printer = new Printer(options);
        return printer.to_string(obj);
    }
},
/* core/patching.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.stream_to_column = stream_to_column;
    exports.slice = slice;
    exports.patch_to_column = patch_to_column;
    exports.stream_to_columns = stream_to_columns;
    exports.patch_to_columns = patch_to_columns;
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const set_1 = require(45) /* ./util/set */;
    const typed_array = tslib_1.__importStar(require(46) /* ./util/typed_array */);
    // exported for testing
    function stream_to_column(col, new_col, rollover) {
        if ((0, types_1.isArray)(col) && (0, types_1.isArray)(new_col)) {
            const result = col.concat(new_col);
            if (rollover != null && result.length > rollover) {
                return result.slice(-rollover);
            }
            else {
                return result;
            }
        }
        const total_len = col.length + new_col.length;
        // handle rollover case for typed arrays
        if (rollover != null && total_len > rollover) {
            const start = total_len - rollover;
            const end = col.length;
            // resize col if it is shorter than the rollover length
            const result = (() => {
                if (col.length < rollover) {
                    const ctor = (() => {
                        if ((0, types_1.isTypedArray)(col)) {
                            return col.constructor;
                        }
                        else if ((0, types_1.isTypedArray)(new_col)) {
                            return new_col.constructor;
                        }
                        else {
                            throw new Error("unsupported array types");
                        }
                    })();
                    const result = new ctor(rollover);
                    result.set(col, 0);
                    return result;
                }
                else {
                    return col;
                }
            })();
            // shift values in original col to accommodate new_col
            for (let i = start, endi = end; i < endi; i++) {
                result[i - start] = result[i];
            }
            // update end values in col with new_col
            for (let i = 0, endi = new_col.length; i < endi; i++) {
                result[i + (end - start)] = new_col[i];
            }
            return result;
        }
        else {
            const col_ = (() => {
                if ((0, types_1.isTypedArray)(col)) {
                    return col;
                }
                else if ((0, types_1.isTypedArray)(new_col)) {
                    return new new_col.constructor(col);
                }
                else {
                    throw new Error("unsupported array types");
                }
            })();
            return typed_array.concat(col_, new_col);
        }
    }
    // exported for testing
    function slice(ind, length) {
        let start, step, stop;
        if ((0, types_1.isNumber)(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    // exported for testing
    function patch_to_column(col, patch) {
        const patched = new Set();
        let patched_range = false;
        for (const [ind, val] of patch) {
            // make the single index case look like the length-3 multi-index case
            let shape;
            let item;
            let index;
            let value;
            if ((0, types_1.isArray)(ind)) {
                const [i] = ind;
                patched.add(i);
                shape = col[i].shape;
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else {
                    index = ind;
                }
            }
            else {
                if ((0, types_1.isNumber)(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            let flat_index = 0;
            const [istart, istop, istep] = slice(index[1], shape[0]);
            const [jstart, jstop, jstep] = slice(index[2], shape[1]);
            for (let i = istart; i < istop; i += istep) {
                for (let j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    function stream_to_columns(old_data, new_data, rollover) {
        const data = (0, object_1.dict)(old_data);
        for (const [name, new_column] of (0, object_1.dict)(new_data)) {
            const old_column = data.get(name) ?? [];
            data.set(name, stream_to_column(old_column, new_column, rollover));
        }
    }
    function patch_to_columns(old_data, patches) {
        const data = (0, object_1.dict)(old_data);
        let patched = new Set();
        for (const [name, patch] of (0, object_1.dict)(patches)) {
            const old_column = data.get(name) ?? [];
            patched = (0, set_1.union)(patched, patch_to_column(old_column, patch)); // XXX: any
        }
        return patched;
    }
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.union = union;
    exports.intersection = intersection;
    exports.difference = difference;
    function union(...sets) {
        const result = new Set();
        for (const set of sets) {
            for (const item of set) {
                result.add(item);
            }
        }
        return result;
    }
    function intersection(set, ...sets) {
        const result = new Set();
        top: for (const item of set) {
            for (const other of sets) {
                if (!other.has(item)) {
                    continue top;
                }
            }
            result.add(item);
        }
        return result;
    }
    function difference(set, ...sets) {
        const result = new Set(set);
        for (const item of union(...sets)) {
            result.delete(item);
        }
        return result;
    }
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.concat = concat;
    function concat(array0, ...arrays) {
        let n = array0.length;
        for (const array of arrays) {
            n += array.length;
        }
        const result = new array0.constructor(n);
        result.set(array0, 0);
        let i = array0.length;
        for (const array of arrays) {
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
},
/* core/resolvers.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class ModelResolver {
        constructor(parent, models = []) {
            this._known_models = new Map();
            this.parent = parent;
            for (const model of models) {
                this.register(model);
            }
        }
        get(name) {
            return this._known_models.get(name) ?? this.parent?.get(name) ?? null;
        }
        register(model, force = false) {
            const name = model.__qualified__;
            if (force || this.get(name) == null) {
                this._known_models.set(name, model);
            }
            else {
                console.warn(`Model '${name}' was already registered with this resolver`);
            }
        }
        get names() {
            return [...this._known_models.keys()].sort();
        }
    }
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
},
/* core/serialization/deserializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const logging_1 = require(20) /* ../logging */;
    const refs_1 = require(18) /* ../util/refs */;
    const ndarray_1 = require(31) /* ../util/ndarray */;
    const object_1 = require(9) /* ../util/object */;
    const array_1 = require(10) /* ../util/array */;
    const platform_1 = require(28) /* ../util/platform */;
    const buffer_1 = require(36) /* ../util/buffer */;
    const types_1 = require(8) /* ../util/types */;
    const slice_1 = require(49) /* ../util/slice */;
    const _decoders = new Map();
    class DeserializationError extends Error {
    }
    exports.DeserializationError = DeserializationError;
    DeserializationError.__name__ = "DeserializationError";
    class Deserializer {
        static register(type, decoder) {
            if (!_decoders.has(type)) {
                _decoders.set(type, decoder);
            }
            else {
                throw new Error(`'${type}' already registered for decoding`);
            }
        }
        constructor(resolver, references = new Map(), finalize) {
            this._decoding = false;
            this._buffers = new Map();
            this._finalizable = new Set();
            this.resolver = resolver;
            this.references = references;
            this.finalize = finalize;
        }
        decode(obj /*AnyVal*/, buffers) {
            if (buffers != null) {
                for (const [id, buffer] of buffers) {
                    this._buffers.set(id, buffer);
                }
            }
            if (this._decoding) {
                return this._decode(obj);
            }
            this._decoding = true;
            let finalizable;
            const decoded = (() => {
                try {
                    return this._decode(obj);
                }
                finally {
                    finalizable = new Set(this._finalizable);
                    this._decoding = false;
                    this._buffers.clear();
                    this._finalizable.clear();
                }
            })();
            for (const instance of finalizable) {
                this.finalize?.(instance);
                instance.finalize();
                instance.assert_initialized();
            }
            // `connect_signals` has to be executed last because it may rely on properties
            // of dependencies that are initialized only in `finalize`. It's a problem
            // that appears when there are circular references, e.g. as in
            // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
            for (const instance of finalizable) {
                instance.connect_signals();
            }
            return decoded;
        }
        _decode(obj /*AnyVal*/) {
            if ((0, types_1.isArray)(obj)) {
                return this._decode_plain_array(obj);
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                if ((0, types_1.isString)(obj.type)) {
                    const decoder = _decoders.get(obj.type);
                    if (decoder != null) {
                        return decoder(obj, this);
                    }
                    switch (obj.type) {
                        case "ref":
                            return this._decode_ref(obj);
                        case "symbol":
                            return this._decode_symbol(obj);
                        case "number":
                            return this._decode_number(obj);
                        case "array":
                            return this._decode_array(obj);
                        case "set":
                            return this._decode_set(obj);
                        case "map":
                            return this._decode_map(obj);
                        case "bytes":
                            return this._decode_bytes(obj);
                        case "slice":
                            return this._decode_slice(obj);
                        case "date":
                            return this._decode_date(obj);
                        case "value":
                            return this._decode_value(obj);
                        case "field":
                            return this._decode_field(obj);
                        case "expr":
                            return this._decode_expr(obj);
                        case "typed_array":
                            return this._decode_typed_array(obj);
                        case "ndarray":
                            return this._decode_ndarray(obj);
                        case "object": {
                            if ((0, types_1.isString)(obj.id)) {
                                return this._decode_object_ref(obj);
                            }
                            else {
                                return this._decode_object(obj);
                            }
                        }
                        default: {
                            this.error(`unable to decode an object of type '${obj.type}'`);
                        }
                    }
                }
                else if ((0, types_1.isString)(obj.id)) {
                    return this._decode_ref(obj);
                }
                else {
                    return this._decode_plain_object(obj);
                }
            }
            else {
                return obj;
            }
        }
        _decode_symbol(obj) {
            this.error(`can't resolve named symbol '${obj.name}'`); // TODO: implement symbol resolution
        }
        _decode_number(obj) {
            if ("value" in obj) {
                const { value } = obj;
                if ((0, types_1.isString)(value)) {
                    switch (value) {
                        case "nan": return NaN;
                        case "+inf": return +Infinity;
                        case "-inf": return -Infinity;
                    }
                }
                else if ((0, types_1.isNumber)(value)) {
                    return value;
                }
            }
            this.error(`invalid number representation '${obj}'`);
        }
        _decode_plain_array(obj) {
            return (0, array_1.map)(obj, (item) => this._decode(item));
        }
        _decode_plain_object(obj) {
            const decoded = {};
            for (const [key, val] of (0, object_1.entries)(obj)) {
                decoded[key] = this._decode(val);
            }
            return decoded;
        }
        _decode_array(obj) {
            const decoded = [];
            for (const entry of obj.entries ?? []) {
                decoded.push(this._decode(entry));
            }
            return decoded;
        }
        _decode_set(obj) {
            const decoded = new Set();
            for (const entry of obj.entries ?? []) {
                decoded.add(this._decode(entry));
            }
            return decoded;
        }
        _decode_map(obj) {
            const entries = (0, array_1.map)(obj.entries ?? [], ([key, val]) => [this._decode(key), this._decode(val)]);
            const is_plain = entries.every(([key, _val]) => (0, types_1.isString)(key));
            // An empty container will result in a plain object, not a Map, thus in the case of
            // kinds.Mapping property type, one needs to accommodate for this in all instances.
            // Fortunately there are few of these scattered across `src/lib/models/`. See HACK
            // in `Mapping.coerce()` in `core/util/kinds`.
            if (is_plain) {
                return Object.fromEntries(entries);
            }
            else {
                return new Map(entries);
            }
        }
        _decode_bytes(obj) {
            const { data } = obj;
            if ((0, refs_1.is_ref)(data)) {
                const buffer = this._buffers.get(data.id);
                if (buffer != null) {
                    return buffer;
                }
                else {
                    this.error(`buffer for id=${data.id} not found`);
                }
            }
            else if ((0, types_1.isString)(data)) {
                return (0, buffer_1.base64_to_buffer)(data);
            }
            else {
                return data.buffer;
            }
        }
        _decode_slice(obj) {
            const start = this._decode(obj.start);
            const stop = this._decode(obj.stop);
            const step = this._decode(obj.step);
            return new slice_1.Slice({ start, stop, step });
        }
        _decode_date(obj) {
            const iso = this._decode(obj.iso);
            return new Date(iso);
        }
        _decode_value(obj) {
            const value = this._decode(obj.value);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { value, transform, units };
        }
        _decode_field(obj) {
            const field = this._decode(obj.field);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { field, transform, units };
        }
        _decode_expr(obj) {
            const expr = this._decode(obj.expr);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { expr, transform, units };
        }
        _decode_typed_array(obj) {
            const { array, order, dtype } = obj;
            const buffer = this._decode(array);
            if (order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(buffer, dtype);
            }
            switch (dtype) {
                case "uint8": return new Uint8Array(buffer);
                case "int8": return new Int8Array(buffer);
                case "uint16": return new Uint16Array(buffer);
                case "int16": return new Int16Array(buffer);
                case "uint32": return new Uint32Array(buffer);
                case "int32": return new Int32Array(buffer);
                // case "uint64": return new BigInt64Array(buffer)
                // case "int64":  return new BigInt64Array(buffer)
                case "float32": return new Float32Array(buffer);
                case "float64": return new Float64Array(buffer);
                default:
                    this.error(`unsupported dtype '${dtype}'`);
            }
        }
        _decode_ndarray(obj) {
            const { array, order, dtype, shape } = obj;
            const decoded = this._decode(array);
            if (decoded instanceof ArrayBuffer && order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(decoded, dtype);
            }
            return (0, ndarray_1.ndarray)(decoded /*XXX*/, { dtype, shape });
        }
        _decode_object(obj) {
            const { name: type, attributes } = obj;
            const cls = this._resolve_type(type);
            if (attributes != null) {
                return new cls(this._decode(attributes));
            }
            else {
                return new cls();
            }
        }
        _decode_ref(obj) {
            const instance = this.references.get(obj.id);
            if (instance != null) {
                return instance;
            }
            else {
                this.error(`reference ${obj.id} isn't known`);
            }
        }
        _decode_object_ref(obj) {
            const { id, name: type, attributes } = obj;
            const ref = this.references.get(id);
            if (ref != null) {
                if (ref.type == type) {
                    const decoded_attributes = this._decode(attributes ?? {});
                    ref.setv(decoded_attributes, { sync: false });
                    return ref;
                }
                else {
                    this.error(`type mismatch for an existing reference '${ref}', expected '${type}'`);
                }
            }
            else {
                const cls = this._resolve_type(type);
                const instance = new cls({ id });
                this.references.set(id, instance);
                const decoded_attributes = this._decode(attributes ?? {});
                instance.initialize_props(decoded_attributes);
                this._finalizable.add(instance);
                return instance;
            }
        }
        error(message) {
            throw new DeserializationError(message);
        }
        warning(message) {
            logging_1.logger.warn(message);
        }
        _resolve_type(type) {
            const cls = this.resolver.get(type);
            if (cls != null) {
                return cls;
            }
            else {
                this.error(`could not resolve type '${type}', which could be due to a widget or a custom model not being registered before first usage`);
            }
        }
    }
    exports.Deserializer = Deserializer;
    Deserializer.__name__ = "Deserializer";
},
/* core/util/slice.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(33) /* ../serialization */;
    class Slice {
        constructor({ start, stop, step } = {}) {
            this.start = start ?? null;
            this.stop = stop ?? null;
            this.step = step ?? null;
        }
        [serialization_1.serialize](serializer) {
            return {
                type: "slice",
                start: serializer.encode(this.start),
                stop: serializer.encode(this.stop),
                step: serializer.encode(this.step),
            };
        }
    }
    exports.Slice = Slice;
    Slice.__name__ = "Slice";
},
/* core/util/version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(27) /* ./eq */;
    const version_re = /^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(?:(?<type>-dev\.|-rc\.|.dev|rc)(?<revision>\d+))?(?:\+(?<build>\d+)\..+)?$/;
    (function (ReleaseType) {
        ReleaseType[ReleaseType["Dev"] = 0] = "Dev";
        ReleaseType[ReleaseType["Candidate"] = 1] = "Candidate";
        ReleaseType[ReleaseType["Release"] = 2] = "Release";
    })(exports.ReleaseType || (exports.ReleaseType = {}));
    class Version {
        constructor(major, minor, patch, type = exports.ReleaseType.Release, revision = 0, build = 0) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.type = type;
            this.revision = revision;
            this.build = build;
        }
        static from(version) {
            return parse_version(version);
        }
        toString() {
            const { major, minor, patch, type, revision, build } = this;
            let version = `${major}.${minor}.${patch}`;
            switch (type) {
                case exports.ReleaseType.Dev: version += `-dev.${revision}`;
                case exports.ReleaseType.Candidate: version += `-rc.${revision}`;
                case exports.ReleaseType.Release:
            }
            if (build != 0) {
                version += `+${build}`;
            }
            return version;
        }
        [eq_1.equals](that) {
            // ignore build field, because bokehjs doesn't provide it
            const { major, minor, patch, type, revision } = this;
            return major == that.major &&
                minor == that.minor &&
                patch == that.patch &&
                type == that.type &&
                revision == that.revision;
        }
    }
    exports.Version = Version;
    Version.__name__ = "Version";
    function parse_version(version) {
        const result = version_re.exec(version);
        if (result == null || result.groups == null) {
            return null;
        }
        const { groups } = result;
        const major = Number(groups.major);
        const minor = Number(groups.minor);
        const patch = Number(groups.patch);
        const type = (() => {
            switch (groups.type) {
                case "-dev.":
                case ".dev": return exports.ReleaseType.Dev;
                case "-rc.":
                case "rc": return exports.ReleaseType.Candidate;
                default: return exports.ReleaseType.Release;
            }
        })();
        // typeof due to bad stdlib typings or enable exactOptionalPropertyTypes
        const revision = typeof groups.revision == "undefined" ? 0 : Number(groups.revision);
        const build = typeof groups.build == "undefined" ? 0 : Number(groups.build);
        return new Version(major, minor, patch, type, revision, build);
    }
},
/* core/util/callbacks.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.execute = execute;
    exports.execute_sync = execute_sync;
    const types_1 = require(8) /* ./types */;
    function execute(cb, obj, ...args) {
        if ((0, types_1.isFunction)(cb)) {
            return cb(obj, ...args);
        }
        else {
            return cb.execute(obj, ...args);
        }
    }
    function execute_sync(cb, obj, ...args) {
        if ((0, types_1.isFunction)(cb)) {
            return cb(obj, ...args);
        }
        else {
            return cb.execute_sync(obj, ...args);
        }
    }
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const has_props_1 = require(15) /* ./core/has_props */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const eq_1 = require(27) /* ./core/util/eq */;
    const logging_1 = require(20) /* ./core/logging */;
    const callbacks_1 = require(51) /* ./core/util/callbacks */;
    class Model extends has_props_1.HasProps {
        get is_syncable() {
            return this.syncable;
        }
        [eq_1.equals](that, cmp) {
            return (cmp.structural ? true : cmp.eq(this.id, that.id)) && super[eq_1.equals](that, cmp);
        }
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this._js_callbacks = new Map();
        }
        connect_signals() {
            super.connect_signals();
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
            this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
            this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
        }
        /*protected*/ _process_event(event) {
            for (const callback of (0, object_1.dict)(this.js_event_callbacks).get(event.event_name) ?? []) {
                void (0, callbacks_1.execute)(callback, event);
            }
            if (this.document != null && this.subscribed_events.has(event.event_name)) {
                this.document.event_manager.send_event(event);
            }
        }
        trigger_event(event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        }
        _update_event_callbacks() {
            if (this.document == null) {
                logging_1.logger.warn("WARNING: Document not defined for updating event callbacks");
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        }
        _update_property_callbacks() {
            const signal_for = (event) => {
                const [evt, attr = null] = event.split(":");
                return attr != null ? this.properties[attr][evt] : this[evt];
            };
            for (const [event, callbacks] of this._js_callbacks) {
                const signal = signal_for(event);
                for (const cb of callbacks) {
                    this.disconnect(signal, cb);
                }
            }
            this._js_callbacks.clear();
            for (const [event, callbacks] of (0, object_1.dict)(this.js_property_callbacks)) {
                const wrappers = callbacks.map((cb) => () => (0, callbacks_1.execute)(cb, this));
                this._js_callbacks.set(event, wrappers);
                const signal = signal_for(event);
                for (const cb of wrappers) {
                    this.connect(signal, cb);
                }
            }
        }
        _doc_attached() {
            super._doc_attached();
            if (this.js_event_callbacks.size != 0 || this.subscribed_events.size != 0) {
                this._update_event_callbacks();
            }
        }
        _doc_detached() {
            super._doc_detached();
            this.document?.event_manager.subscribed_models.delete(this);
        }
        select(selector) {
            if ((0, types_1.isString)(selector)) {
                return [...this.references()].filter((ref) => ref instanceof _a && ref.name === selector);
            }
            else if ((0, types_1.isPlainObject)(selector) && "type" in selector) {
                return [...this.references()].filter((ref) => ref.type == selector.type);
            }
            else if (selector.prototype instanceof has_props_1.HasProps) {
                return [...this.references()].filter((ref) => ref instanceof selector);
            }
            else {
                throw new Error(`invalid selector ${selector}`);
            }
        }
        select_one(selector) {
            const result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error(`found multiple objects matching the given selector ${selector}`);
            }
        }
        get_one(selector) {
            const result = this.select_one(selector);
            if (result != null) {
                return result;
            }
            else {
                throw new Error(`could not find any objects matching the given selector ${selector}`);
            }
        }
        on_event(event, callback) {
            const name = (0, types_1.isString)(event) ? event : event.prototype.event_name;
            const js_event_callbacks = (0, object_1.dict)(this.js_event_callbacks);
            const callbacks = js_event_callbacks.get(name) ?? [];
            js_event_callbacks.set(name, [...callbacks, callback]);
        }
    }
    exports.Model = Model;
    _a = Model;
    Model.__name__ = "Model";
    (() => {
        _a.define(({ Any, Unknown, Bool, Str, List, Set, Dict, Nullable }) => ({
            tags: [List(Unknown), []],
            name: [Nullable(Str), null],
            js_property_callbacks: [Dict(List(Any /*TODO*/)), {}],
            js_event_callbacks: [Dict(List(Any /*TODO*/)), {}],
            subscribed_events: [Set(Str), new globalThis.Set()],
            syncable: [Bool, true],
        }));
    })();
},
/* document/config.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../model */;
    const notifications_1 = require(54) /* ../models/ui/notifications */;
    class DocumentConfig extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DocumentConfig = DocumentConfig;
    _a = DocumentConfig;
    DocumentConfig.__name__ = "DocumentConfig";
    (() => {
        _a.define(({ Bool, Ref, Nullable }) => ({
            reconnect_session: [Bool, true],
            notify_connection_status: [Bool, true],
            notifications: [Nullable(Ref(notifications_1.Notifications)), () => new notifications_1.Notifications()],
        }));
    })();
},
/* models/ui/notifications.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const ui_element_1 = require(55) /* ./ui_element */;
    const dom_1 = require(61) /* ../../core/dom */;
    const signaling_1 = require(16) /* ../../core/signaling */;
    const base_css = tslib_1.__importStar(require(70) /* ../../styles/base.css */);
    const icons_css = tslib_1.__importStar(require(76) /* ../../styles/icons.css */);
    const buttons_css = tslib_1.__importStar(require(77) /* ../../styles/buttons.css */);
    const notifications_css = tslib_1.__importStar(require(78) /* ../../styles/notifications.css */);
    exports.notifications_el = (() => {
        const el = (0, dom_1.div)();
        const shadow_el = el.attachShadow({ mode: "open" });
        new dom_1.InlineStyleSheet(base_css.default).install(shadow_el);
        new dom_1.InlineStyleSheet(icons_css.default).install(shadow_el);
        new dom_1.InlineStyleSheet(buttons_css.default).install(shadow_el);
        new dom_1.InlineStyleSheet(notifications_css.default).install(shadow_el);
        const entries_el = (0, dom_1.div)({ class: "entries" });
        shadow_el.append(entries_el);
        void (0, dom_1.dom_ready)().then(() => document.body.append(el));
        return entries_el;
    })();
    class NotificationsView extends ui_element_1.UIElementView {
        constructor() {
            super(...arguments);
            this._connection_el = null;
            this._connection_timer = null;
        }
        initialize() {
            super.initialize();
            this.model.push.connect((message) => {
                const dismiss_el = (0, dom_1.div)({ class: "close", title: "Close" });
                const message_el = (0, dom_1.div)({ class: message.type }, message.text, dismiss_el);
                exports.notifications_el.append(message_el);
                const clear = () => message_el.remove();
                dismiss_el.addEventListener("click", clear);
                const timeout = message.timeout ?? 5000;
                if (isFinite(timeout)) {
                    setTimeout(clear, timeout);
                }
            });
            const { document } = this.model;
            if (document == null) {
                return; // this shouldn't happen
            }
            document.on_event("connection_lost", (_, event) => {
                if (!document.config.notify_connection_status) {
                    return;
                }
                this._connection_el?.remove();
                if (this._connection_timer != null) {
                    clearTimeout(this._connection_timer);
                    this._connection_timer = null;
                }
                const { timeout } = event;
                if (timeout == null) {
                    const try_el = (0, dom_1.span)({ class: "try" }, "Try");
                    try_el.addEventListener("click", () => {
                        this._connection_el?.remove();
                        event.reconnect();
                    });
                    const dismiss_el = (0, dom_1.div)({ class: "close", title: "Close" });
                    dismiss_el.addEventListener("click", () => this._connection_el?.remove());
                    this._connection_el = (0, dom_1.div)({ class: "error" }, "Client connection was lost permanently. ", try_el, " to reconnect manually.", dismiss_el);
                    exports.notifications_el.append(this._connection_el);
                }
                else {
                    let current_timeout = timeout;
                    const timeout_el = (0, dom_1.span)();
                    const set_timeout = () => {
                        const timeout = Math.max(0, Math.round(current_timeout / 1000));
                        if (timeout == 0) {
                            timeout_el.textContent = "Reconnecting now.";
                        }
                        else {
                            timeout_el.textContent = `Reconnection will be attempted in ${timeout} s.`;
                        }
                    };
                    set_timeout();
                    this._connection_el = (0, dom_1.div)({ class: "error" }, "Client connection was lost. ", timeout_el);
                    exports.notifications_el.append(this._connection_el);
                    this._connection_timer = setInterval(() => { current_timeout -= 1000; set_timeout(); }, 1000);
                }
            });
            document.on_event("client_reconnected", (_, _event) => {
                if (!document.config.notify_connection_status) {
                    return;
                }
                this._connection_el?.remove();
                if (this._connection_timer != null) {
                    clearTimeout(this._connection_timer);
                    this._connection_timer = null;
                }
                this._connection_el = (0, dom_1.div)({ class: "success" }, "Client connect was reestablished.");
                exports.notifications_el.append(this._connection_el);
                this._connection_timer = setTimeout(() => this._connection_el?.remove(), 5000);
            });
        }
    }
    exports.NotificationsView = NotificationsView;
    NotificationsView.__name__ = "NotificationsView";
    class Notifications extends ui_element_1.UIElement {
        constructor(attrs) {
            super(attrs);
            this.push = new signaling_1.Signal(this, "push");
        }
    }
    exports.Notifications = Notifications;
    _a = Notifications;
    Notifications.__name__ = "Notifications";
    (() => {
        _a.prototype.default_view = NotificationsView;
        _a.define(() => ({}));
    })();
},
/* models/ui/ui_element.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const styled_element_1 = require(56) /* ./styled_element */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const dom_1 = require(61) /* ../../core/dom */;
    const canvas_1 = require(71) /* ../../core/util/canvas */;
    const bbox_1 = require(62) /* ../../core/util/bbox */;
    const types_1 = require(8) /* ../../core/util/types */;
    const defer_1 = require(17) /* ../../core/util/defer */;
    const ui_css_1 = tslib_1.__importDefault(require(75) /* ../../styles/ui.css */);
    const { round, floor } = Math;
    class UIElementView extends styled_element_1.StyledElementView {
        constructor() {
            super(...arguments);
            this.display = new dom_1.InlineStyleSheet("", "display");
            this._bbox = new bbox_1.BBox();
            this._context_menu = null;
            this._resized = false;
            this._is_displayed = false;
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.display];
        }
        stylesheets() {
            return [...super.stylesheets(), ui_css_1.default];
        }
        update_style() {
            this.style.clear();
        }
        box_sizing() {
            return {
                width_policy: "auto", height_policy: "auto",
                width: null, height: null,
                aspect_ratio: null,
            };
        }
        get bbox() {
            return this._bbox;
        }
        update_bbox() {
            return this._update_bbox();
        }
        _update_bbox() {
            const displayed = (() => {
                // Consider using Element.checkVisibility() in the future.
                // https://w3c.github.io/csswg-drafts/cssom-view-1/#dom-element-checkvisibility
                if (!this.el.isConnected) {
                    return false;
                }
                else if (this.el.offsetParent != null) {
                    return true;
                }
                else {
                    const { position, display } = getComputedStyle(this.el);
                    return position == "fixed" && display != "none";
                }
            })();
            const bbox = !displayed ? new bbox_1.BBox() : (() => {
                const self = this.el.getBoundingClientRect();
                const { left, top } = (() => {
                    if (this.parent != null) {
                        const parent = this.parent.el.getBoundingClientRect();
                        return {
                            left: self.left - parent.left,
                            top: self.top - parent.top,
                        };
                    }
                    else {
                        return { left: 0, top: 0 };
                    }
                })();
                return new bbox_1.BBox({
                    left: round(left),
                    top: round(top),
                    width: floor(self.width),
                    height: floor(self.height),
                });
            })();
            const changed = !this._bbox.equals(bbox);
            this._bbox = bbox;
            this._is_displayed = displayed;
            return changed;
        }
        /**
         * Allows to provide a context dependent menu when `UIElement.context_menu` is `"auto"`.
         */
        _provide_context_menu() {
            return null;
        }
        initialize() {
            super.initialize();
            this._resize_observer = new ResizeObserver((_entries) => this.after_resize());
            this._resize_observer.observe(this.el, { box: "border-box" });
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const menu = (() => {
                const { context_menu } = this.model;
                if (context_menu == "auto") {
                    return this._provide_context_menu();
                }
                else {
                    return context_menu;
                }
            })();
            if (menu != null) {
                this._context_menu = await (0, build_views_1.build_view)(menu, { parent: this });
            }
        }
        connect_signals() {
            super.connect_signals();
            const { visible } = this.model.properties;
            this.on_change(visible, () => this._update_visible());
            this.el.addEventListener("contextmenu", (event) => this.show_context_menu(event));
        }
        get_context_menu(_xy) {
            return this._context_menu;
        }
        show_context_menu(event) {
            if (!event.shiftKey) {
                const rect = this.el.getBoundingClientRect();
                const x = event.x - rect.x;
                const y = event.y - rect.y;
                const context_menu = this.get_context_menu({ x, y });
                if (context_menu != null) {
                    if (context_menu.show({ x, y })) {
                        event.stopPropagation();
                        event.preventDefault();
                    }
                }
            }
        }
        remove() {
            this._resize_observer.disconnect();
            this._context_menu?.remove();
            super.remove();
        }
        _after_resize() { }
        after_resize() {
            this._resized = true;
            if (this.update_bbox()) {
                this._after_resize();
            }
            this.finish();
        }
        render() {
            super.render();
            this._apply_visible();
        }
        _after_render() {
            this.update_style();
            this.update_bbox();
        }
        after_render() {
            super.after_render();
            this._after_render();
            if (!this._has_finished) {
                // If not displayed, then after_resize() will not be called.
                if (!this.is_displayed) {
                    this.force_finished();
                }
                else {
                    // In case after_resize() wasn't called (see regression test for issue
                    // #9113), then wait one macro task and consider this view finished.
                    void (0, defer_1.defer)().then(() => {
                        if (!this._resized) {
                            this.finish();
                        }
                    });
                }
            }
        }
        get is_displayed() {
            return this._is_displayed;
        }
        _apply_visible() {
            if (this.model.visible) {
                this.display.clear();
            }
            else {
                this.display.replace(":host { display: none; }");
            }
        }
        _update_visible() {
            this._apply_visible();
        }
        export(type = "auto", hidpi = true) {
            const output_backend = type == "auto" || type == "png" ? "canvas" : "svg";
            const canvas = new canvas_1.CanvasLayer(output_backend, hidpi);
            const { width, height } = this.bbox;
            canvas.resize(width, height);
            return canvas;
        }
        resolve_symbol(node) {
            const value = this.bbox.resolve(node.symbol);
            const { offset } = node;
            if ((0, types_1.isNumber)(value)) {
                return value + offset;
            }
            else {
                const { x, y } = value;
                return { x: x + offset, y: y + offset };
            }
        }
    }
    exports.UIElementView = UIElementView;
    UIElementView.__name__ = "UIElementView";
    class UIElement extends styled_element_1.StyledElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.UIElement = UIElement;
    _a = UIElement;
    UIElement.__name__ = "UIElement";
    (() => {
        _a.define(({ Bool, AnyRef, Nullable, Or, Auto }) => ({
            visible: [Bool, true],
            context_menu: [Nullable(Or(AnyRef(), Auto)), null],
        }));
    })();
},
/* models/ui/styled_element.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../model */;
    const node_1 = require(57) /* ../coordinates/node */;
    const styles_1 = require(59) /* ../dom/styles */;
    const stylesheets_1 = require(60) /* ../dom/stylesheets */;
    const dom_view_1 = require(64) /* ../../core/dom_view */;
    const css_1 = require(63) /* ../../core/css */;
    const dom_1 = require(61) /* ../../core/dom */;
    const object_1 = require(9) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    exports.StylesLike = (0, kinds_1.Or)((0, kinds_1.Dict)((0, kinds_1.Nullable)(kinds_1.Str)), (0, kinds_1.Ref)(styles_1.Styles)); // TODO: add validation for CSSStyles
    exports.StyleSheets = (0, kinds_1.List)((0, kinds_1.Or)((0, kinds_1.Ref)(stylesheets_1.StyleSheet), kinds_1.Str, (0, kinds_1.Dict)(exports.StylesLike)));
    exports.CSSVariables = (0, kinds_1.Dict)((0, kinds_1.Or)((0, kinds_1.Ref)(node_1.Node), kinds_1.Str));
    class StyledElementView extends dom_view_1.DOMComponentView {
        constructor() {
            super(...arguments);
            /**
             * Computed styles applied to self.
             */
            this.style = new dom_1.InlineStyleSheet("", "style"); // TODO rename to `self_style`
            /**
             * Computed styles append by the parent.
             */
            this.parent_style = new dom_1.InlineStyleSheet("", "parent", true);
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.style, this.parent_style];
        }
        connect_signals() {
            super.connect_signals();
            const { html_attributes, html_id, styles, css_classes, css_variables, stylesheets } = this.model.properties;
            this.on_change([html_attributes, html_id, css_classes, styles], () => this._apply_html_attributes());
            this.on_transitive_change(css_variables, () => this._apply_html_attributes());
            this.on_transitive_change(stylesheets, () => this._update_stylesheets());
        }
        *_css_classes() {
            yield* super._css_classes();
            yield* this.model.css_classes;
        }
        *_css_variables() {
            yield* super._css_variables();
            for (const [key, val] of (0, object_1.entries)(this.model.css_variables)) {
                if (val instanceof node_1.Node) {
                    const value = this.resolve_coordinate(val);
                    if ((0, types_1.isNumber)(value)) {
                        yield [key, `${value}px`];
                    }
                    else if ((0, types_1.isString)(value)) {
                        yield [key, value];
                    }
                }
                else {
                    yield [key, val];
                }
            }
        }
        user_stylesheets() {
            return [...super.user_stylesheets(), ...this._user_stylesheets()];
        }
        *_user_stylesheets() {
            for (const stylesheet of this.model.stylesheets) {
                if (stylesheet instanceof stylesheets_1.StyleSheet) {
                    yield stylesheet.underlying();
                }
                else {
                    yield new dom_1.InlineStyleSheet(stylesheet);
                }
            }
        }
        _apply_html_attributes() {
            for (const key of this._applied_html_attributes) {
                this.el.removeAttribute(key);
            }
            this._applied_html_attributes = [];
            this._update_css_classes();
            for (const [key, val] of (0, object_1.entries)(this.model.html_attributes)) {
                if (key == "class") {
                    const classes = val.split(/ +/);
                    this._applied_css_classes.push(...classes);
                    this.class_list.add(...classes);
                }
                else {
                    this.el.setAttribute(key, val);
                    this._applied_html_attributes.push(key);
                }
            }
            const id = this.model.html_id;
            if (id != null) {
                this.el.setAttribute("id", id);
                this._applied_html_attributes.push("id");
            }
            this._apply_styles();
            this._update_css_variables();
        }
        _apply_styles() {
            (0, css_1.apply_styles)(this.el.style, this.model.styles);
        }
    }
    exports.StyledElementView = StyledElementView;
    StyledElementView.__name__ = "StyledElementView";
    class StyledElement extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.StyledElement = StyledElement;
    _a = StyledElement;
    StyledElement.__name__ = "StyledElement";
    (() => {
        _a.define({
            html_attributes: [(0, kinds_1.Dict)(kinds_1.Str), {}],
            html_id: [(0, kinds_1.Nullable)(kinds_1.Str), null],
            css_classes: [(0, kinds_1.List)(kinds_1.Str), []],
            css_variables: [exports.CSSVariables, {}],
            styles: [exports.StylesLike, {}],
            stylesheets: [exports.StyleSheets, []],
        });
    })();
},
/* models/coordinates/node.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(58) /* ./coordinate */;
    const model_1 = require(52) /* ../../model */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    exports.ImplicitTarget = (0, kinds_1.Enum)("canvas", "plot", "frame", "parent");
    exports.NodeTarget = (0, kinds_1.Or)((0, kinds_1.Ref)(model_1.Model), exports.ImplicitTarget);
    class BoxNodes {
        constructor(target, frozen = false) {
            this._left = null;
            this._right = null;
            this._top = null;
            this._bottom = null;
            this.target = target;
            this.frozen = frozen;
        }
        _node(symbol) {
            const { target, frozen } = this;
            const node = new Node({ target, symbol });
            if (frozen) {
                this[`_${symbol}`] = node;
            }
            return node;
        }
        get left() {
            return this._left ?? this._node("left");
        }
        get right() {
            return this._right ?? this._node("right");
        }
        get top() {
            return this._top ?? this._node("top");
        }
        get bottom() {
            return this._bottom ?? this._node("bottom");
        }
        freeze() {
            return new BoxNodes(this.target, true);
        }
    }
    exports.BoxNodes = BoxNodes;
    BoxNodes.__name__ = "BoxNodes";
    class Node extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
        static get frame() {
            return this._frame_nodes;
        }
        static get canvas() {
            return this._canvas_nodes;
        }
    }
    exports.Node = Node;
    _a = Node;
    Node.__name__ = "Node";
    (() => {
        _a.define(({ Str, Int }) => ({
            target: [exports.NodeTarget],
            symbol: [Str],
            offset: [Int, 0],
        }));
    })();
    Node._frame_nodes = new BoxNodes("frame");
    Node._canvas_nodes = new BoxNodes("canvas");
},
/* models/coordinates/coordinate.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(52) /* ../../model */;
    class Coordinate extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Coordinate = Coordinate;
    Coordinate.__name__ = "Coordinate";
},
/* models/dom/styles.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../model */;
    class Styles extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Styles = Styles;
    _a = Styles;
    Styles.__name__ = "Styles";
    (() => {
        _a.define(({ Str, Nullable }) => ({
            align_content: [Nullable(Str), null],
            align_items: [Nullable(Str), null],
            align_self: [Nullable(Str), null],
            alignment_baseline: [Nullable(Str), null],
            all: [Nullable(Str), null],
            animation: [Nullable(Str), null],
            animation_delay: [Nullable(Str), null],
            animation_direction: [Nullable(Str), null],
            animation_duration: [Nullable(Str), null],
            animation_fill_mode: [Nullable(Str), null],
            animation_iteration_count: [Nullable(Str), null],
            animation_name: [Nullable(Str), null],
            animation_play_state: [Nullable(Str), null],
            animation_timing_function: [Nullable(Str), null],
            aspect_ratio: [Nullable(Str), null],
            backface_visibility: [Nullable(Str), null],
            background: [Nullable(Str), null],
            background_attachment: [Nullable(Str), null],
            background_clip: [Nullable(Str), null],
            background_color: [Nullable(Str), null],
            background_image: [Nullable(Str), null],
            background_origin: [Nullable(Str), null],
            background_position: [Nullable(Str), null],
            background_position_x: [Nullable(Str), null],
            background_position_y: [Nullable(Str), null],
            background_repeat: [Nullable(Str), null],
            background_size: [Nullable(Str), null],
            baseline_shift: [Nullable(Str), null],
            block_size: [Nullable(Str), null],
            border: [Nullable(Str), null],
            border_block_end: [Nullable(Str), null],
            border_block_end_color: [Nullable(Str), null],
            border_block_end_style: [Nullable(Str), null],
            border_block_end_width: [Nullable(Str), null],
            border_block_start: [Nullable(Str), null],
            border_block_start_color: [Nullable(Str), null],
            border_block_start_style: [Nullable(Str), null],
            border_block_start_width: [Nullable(Str), null],
            border_bottom: [Nullable(Str), null],
            border_bottom_color: [Nullable(Str), null],
            border_bottom_left_radius: [Nullable(Str), null],
            border_bottom_right_radius: [Nullable(Str), null],
            border_bottom_style: [Nullable(Str), null],
            border_bottom_width: [Nullable(Str), null],
            border_collapse: [Nullable(Str), null],
            border_color: [Nullable(Str), null],
            border_image: [Nullable(Str), null],
            border_image_outset: [Nullable(Str), null],
            border_image_repeat: [Nullable(Str), null],
            border_image_slice: [Nullable(Str), null],
            border_image_source: [Nullable(Str), null],
            border_image_width: [Nullable(Str), null],
            border_inline_end: [Nullable(Str), null],
            border_inline_end_color: [Nullable(Str), null],
            border_inline_end_style: [Nullable(Str), null],
            border_inline_end_width: [Nullable(Str), null],
            border_inline_start: [Nullable(Str), null],
            border_inline_start_color: [Nullable(Str), null],
            border_inline_start_style: [Nullable(Str), null],
            border_inline_start_width: [Nullable(Str), null],
            border_left: [Nullable(Str), null],
            border_left_color: [Nullable(Str), null],
            border_left_style: [Nullable(Str), null],
            border_left_width: [Nullable(Str), null],
            border_radius: [Nullable(Str), null],
            border_right: [Nullable(Str), null],
            border_right_color: [Nullable(Str), null],
            border_right_style: [Nullable(Str), null],
            border_right_width: [Nullable(Str), null],
            border_spacing: [Nullable(Str), null],
            border_style: [Nullable(Str), null],
            border_top: [Nullable(Str), null],
            border_top_color: [Nullable(Str), null],
            border_top_left_radius: [Nullable(Str), null],
            border_top_right_radius: [Nullable(Str), null],
            border_top_style: [Nullable(Str), null],
            border_top_width: [Nullable(Str), null],
            border_width: [Nullable(Str), null],
            bottom: [Nullable(Str), null],
            box_shadow: [Nullable(Str), null],
            box_sizing: [Nullable(Str), null],
            break_after: [Nullable(Str), null],
            break_before: [Nullable(Str), null],
            break_inside: [Nullable(Str), null],
            caption_side: [Nullable(Str), null],
            caret_color: [Nullable(Str), null],
            clear: [Nullable(Str), null],
            clip: [Nullable(Str), null],
            clip_path: [Nullable(Str), null],
            clip_rule: [Nullable(Str), null],
            color: [Nullable(Str), null],
            color_interpolation: [Nullable(Str), null],
            color_interpolation_filters: [Nullable(Str), null],
            column_count: [Nullable(Str), null],
            column_fill: [Nullable(Str), null],
            column_gap: [Nullable(Str), null],
            column_rule: [Nullable(Str), null],
            column_rule_color: [Nullable(Str), null],
            column_rule_style: [Nullable(Str), null],
            column_rule_width: [Nullable(Str), null],
            column_span: [Nullable(Str), null],
            column_width: [Nullable(Str), null],
            columns: [Nullable(Str), null],
            content: [Nullable(Str), null],
            counter_increment: [Nullable(Str), null],
            counter_reset: [Nullable(Str), null],
            cursor: [Nullable(Str), null],
            direction: [Nullable(Str), null],
            display: [Nullable(Str), null],
            dominant_baseline: [Nullable(Str), null],
            empty_cells: [Nullable(Str), null],
            fill: [Nullable(Str), null],
            fill_opacity: [Nullable(Str), null],
            fill_rule: [Nullable(Str), null],
            filter: [Nullable(Str), null],
            flex: [Nullable(Str), null],
            flex_basis: [Nullable(Str), null],
            flex_direction: [Nullable(Str), null],
            flex_flow: [Nullable(Str), null],
            flex_grow: [Nullable(Str), null],
            flex_shrink: [Nullable(Str), null],
            flex_wrap: [Nullable(Str), null],
            float: [Nullable(Str), null],
            flood_color: [Nullable(Str), null],
            flood_opacity: [Nullable(Str), null],
            font: [Nullable(Str), null],
            font_family: [Nullable(Str), null],
            font_feature_settings: [Nullable(Str), null],
            font_kerning: [Nullable(Str), null],
            font_size: [Nullable(Str), null],
            font_size_adjust: [Nullable(Str), null],
            font_stretch: [Nullable(Str), null],
            font_style: [Nullable(Str), null],
            font_synthesis: [Nullable(Str), null],
            font_variant: [Nullable(Str), null],
            font_variant_caps: [Nullable(Str), null],
            font_variant_east_asian: [Nullable(Str), null],
            font_variant_ligatures: [Nullable(Str), null],
            font_variant_numeric: [Nullable(Str), null],
            font_variant_position: [Nullable(Str), null],
            font_weight: [Nullable(Str), null],
            gap: [Nullable(Str), null],
            glyph_orientation_vertical: [Nullable(Str), null],
            grid: [Nullable(Str), null],
            grid_area: [Nullable(Str), null],
            grid_auto_columns: [Nullable(Str), null],
            grid_auto_flow: [Nullable(Str), null],
            grid_auto_rows: [Nullable(Str), null],
            grid_column: [Nullable(Str), null],
            grid_column_end: [Nullable(Str), null],
            grid_column_gap: [Nullable(Str), null],
            grid_column_start: [Nullable(Str), null],
            grid_gap: [Nullable(Str), null],
            grid_row: [Nullable(Str), null],
            grid_row_end: [Nullable(Str), null],
            grid_row_gap: [Nullable(Str), null],
            grid_row_start: [Nullable(Str), null],
            grid_template: [Nullable(Str), null],
            grid_template_areas: [Nullable(Str), null],
            grid_template_columns: [Nullable(Str), null],
            grid_template_rows: [Nullable(Str), null],
            height: [Nullable(Str), null],
            hyphens: [Nullable(Str), null],
            image_orientation: [Nullable(Str), null],
            image_rendering: [Nullable(Str), null],
            inline_size: [Nullable(Str), null],
            justify_content: [Nullable(Str), null],
            justify_items: [Nullable(Str), null],
            justify_self: [Nullable(Str), null],
            left: [Nullable(Str), null],
            letter_spacing: [Nullable(Str), null],
            lighting_color: [Nullable(Str), null],
            line_break: [Nullable(Str), null],
            line_height: [Nullable(Str), null],
            list_style: [Nullable(Str), null],
            list_style_image: [Nullable(Str), null],
            list_style_position: [Nullable(Str), null],
            list_style_type: [Nullable(Str), null],
            margin: [Nullable(Str), null],
            margin_block_end: [Nullable(Str), null],
            margin_block_start: [Nullable(Str), null],
            margin_bottom: [Nullable(Str), null],
            margin_inline_end: [Nullable(Str), null],
            margin_inline_start: [Nullable(Str), null],
            margin_left: [Nullable(Str), null],
            margin_right: [Nullable(Str), null],
            margin_top: [Nullable(Str), null],
            marker: [Nullable(Str), null],
            marker_end: [Nullable(Str), null],
            marker_mid: [Nullable(Str), null],
            marker_start: [Nullable(Str), null],
            mask: [Nullable(Str), null],
            mask_composite: [Nullable(Str), null],
            mask_image: [Nullable(Str), null],
            mask_position: [Nullable(Str), null],
            mask_repeat: [Nullable(Str), null],
            mask_size: [Nullable(Str), null],
            mask_type: [Nullable(Str), null],
            max_block_size: [Nullable(Str), null],
            max_height: [Nullable(Str), null],
            max_inline_size: [Nullable(Str), null],
            max_width: [Nullable(Str), null],
            min_block_size: [Nullable(Str), null],
            min_height: [Nullable(Str), null],
            min_inline_size: [Nullable(Str), null],
            min_width: [Nullable(Str), null],
            object_fit: [Nullable(Str), null],
            object_position: [Nullable(Str), null],
            opacity: [Nullable(Str), null],
            order: [Nullable(Str), null],
            orphans: [Nullable(Str), null],
            outline: [Nullable(Str), null],
            outline_color: [Nullable(Str), null],
            outline_offset: [Nullable(Str), null],
            outline_style: [Nullable(Str), null],
            outline_width: [Nullable(Str), null],
            overflow: [Nullable(Str), null],
            overflow_anchor: [Nullable(Str), null],
            overflow_wrap: [Nullable(Str), null],
            overflow_x: [Nullable(Str), null],
            overflow_y: [Nullable(Str), null],
            overscroll_behavior: [Nullable(Str), null],
            overscroll_behavior_block: [Nullable(Str), null],
            overscroll_behavior_inline: [Nullable(Str), null],
            overscroll_behavior_x: [Nullable(Str), null],
            overscroll_behavior_y: [Nullable(Str), null],
            padding: [Nullable(Str), null],
            padding_block_end: [Nullable(Str), null],
            padding_block_start: [Nullable(Str), null],
            padding_bottom: [Nullable(Str), null],
            padding_inline_end: [Nullable(Str), null],
            padding_inline_start: [Nullable(Str), null],
            padding_left: [Nullable(Str), null],
            padding_right: [Nullable(Str), null],
            padding_top: [Nullable(Str), null],
            page_break_after: [Nullable(Str), null],
            page_break_before: [Nullable(Str), null],
            page_break_inside: [Nullable(Str), null],
            paint_order: [Nullable(Str), null],
            perspective: [Nullable(Str), null],
            perspective_origin: [Nullable(Str), null],
            place_content: [Nullable(Str), null],
            place_items: [Nullable(Str), null],
            place_self: [Nullable(Str), null],
            pointer_events: [Nullable(Str), null],
            position: [Nullable(Str), null],
            quotes: [Nullable(Str), null],
            resize: [Nullable(Str), null],
            right: [Nullable(Str), null],
            rotate: [Nullable(Str), null],
            row_gap: [Nullable(Str), null],
            ruby_align: [Nullable(Str), null],
            ruby_position: [Nullable(Str), null],
            scale: [Nullable(Str), null],
            scroll_behavior: [Nullable(Str), null],
            shape_rendering: [Nullable(Str), null],
            stop_color: [Nullable(Str), null],
            stop_opacity: [Nullable(Str), null],
            stroke: [Nullable(Str), null],
            stroke_dasharray: [Nullable(Str), null],
            stroke_dashoffset: [Nullable(Str), null],
            stroke_linecap: [Nullable(Str), null],
            stroke_linejoin: [Nullable(Str), null],
            stroke_miterlimit: [Nullable(Str), null],
            stroke_opacity: [Nullable(Str), null],
            stroke_width: [Nullable(Str), null],
            tab_size: [Nullable(Str), null],
            table_layout: [Nullable(Str), null],
            text_align: [Nullable(Str), null],
            text_align_last: [Nullable(Str), null],
            text_anchor: [Nullable(Str), null],
            text_combine_upright: [Nullable(Str), null],
            text_decoration: [Nullable(Str), null],
            text_decoration_color: [Nullable(Str), null],
            text_decoration_line: [Nullable(Str), null],
            text_decoration_style: [Nullable(Str), null],
            text_emphasis: [Nullable(Str), null],
            text_emphasis_color: [Nullable(Str), null],
            text_emphasis_position: [Nullable(Str), null],
            text_emphasis_style: [Nullable(Str), null],
            text_indent: [Nullable(Str), null],
            text_justify: [Nullable(Str), null],
            text_orientation: [Nullable(Str), null],
            text_overflow: [Nullable(Str), null],
            text_rendering: [Nullable(Str), null],
            text_shadow: [Nullable(Str), null],
            text_transform: [Nullable(Str), null],
            text_underline_position: [Nullable(Str), null],
            top: [Nullable(Str), null],
            touch_action: [Nullable(Str), null],
            transform: [Nullable(Str), null],
            transform_box: [Nullable(Str), null],
            transform_origin: [Nullable(Str), null],
            transform_style: [Nullable(Str), null],
            transition: [Nullable(Str), null],
            transition_delay: [Nullable(Str), null],
            transition_duration: [Nullable(Str), null],
            transition_property: [Nullable(Str), null],
            transition_timing_function: [Nullable(Str), null],
            translate: [Nullable(Str), null],
            unicode_bidi: [Nullable(Str), null],
            user_select: [Nullable(Str), null],
            vertical_align: [Nullable(Str), null],
            visibility: [Nullable(Str), null],
            white_space: [Nullable(Str), null],
            widows: [Nullable(Str), null],
            width: [Nullable(Str), null],
            will_change: [Nullable(Str), null],
            word_break: [Nullable(Str), null],
            word_spacing: [Nullable(Str), null],
            word_wrap: [Nullable(Str), null],
            writing_mode: [Nullable(Str), null],
            z_index: [Nullable(Str), null],
        }));
    })();
},
/* models/dom/stylesheets.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(52) /* ../../model */;
    const dom = tslib_1.__importStar(require(61) /* ../../core/dom */);
    class StyleSheet extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    class InlineStyleSheet extends StyleSheet {
        constructor(attrs) {
            super(attrs);
        }
        underlying() {
            return new dom.InlineStyleSheet(this.css);
        }
    }
    exports.InlineStyleSheet = InlineStyleSheet;
    _a = InlineStyleSheet;
    InlineStyleSheet.__name__ = "InlineStyleSheet";
    (() => {
        _a.define(({ Str }) => ({
            css: [Str],
        }));
    })();
    class ImportedStyleSheet extends StyleSheet {
        constructor(attrs) {
            super(attrs);
        }
        underlying() {
            return new dom.ImportedStyleSheet(this.url);
        }
    }
    exports.ImportedStyleSheet = ImportedStyleSheet;
    _b = ImportedStyleSheet;
    ImportedStyleSheet.__name__ = "ImportedStyleSheet";
    (() => {
        _b.define(({ Str }) => ({
            url: [Str],
        }));
    })();
    class GlobalInlineStyleSheet extends InlineStyleSheet {
        constructor(attrs) {
            super(attrs);
            this._underlying = null;
        }
        underlying() {
            if (this._underlying == null) {
                this._underlying = new dom.GlobalInlineStyleSheet(this.css);
            }
            return this._underlying;
        }
    }
    exports.GlobalInlineStyleSheet = GlobalInlineStyleSheet;
    GlobalInlineStyleSheet.__name__ = "GlobalInlineStyleSheet";
    class GlobalImportedStyleSheet extends ImportedStyleSheet {
        constructor(attrs) {
            super(attrs);
            this._underlying = null;
        }
        underlying() {
            if (this._underlying == null) {
                this._underlying = new dom.GlobalImportedStyleSheet(this.url);
            }
            return this._underlying;
        }
    }
    exports.GlobalImportedStyleSheet = GlobalImportedStyleSheet;
    GlobalImportedStyleSheet.__name__ = "GlobalImportedStyleSheet";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.textarea = exports.template = exports.td = exports.tbody = exports.table = exports.sup = exports.summary = exports.sub = exports.style = exports.strong = exports.span = exports.source = exports.small = exports.slot = exports.select = exports.section = exports.search = exports.script = exports.samp = exports.s = exports.ruby = exports.rt = exports.rp = exports.q = exports.progress = exports.pre = exports.picture = exports.p = exports.output = exports.option = exports.optgroup = exports.ol = exports.object = exports.noscript = exports.nav = exports.meter = exports.meta = exports.menu = exports.mark = exports.map = exports.main = exports.link = exports.li = exports.legend = exports.label = exports.kbd = exports.ins = exports.input = exports.img = exports.iframe = void 0;
    exports.supports_adopted_stylesheets = exports.GlobalImportedStyleSheet = exports.ImportedStyleSheet = exports.GlobalInlineStyleSheet = exports.InlineStyleSheet = exports.StyleSheet = exports.MouseButton = exports.ClassList = exports.wbr = exports.video = exports.ul = exports.u = exports.track = exports.tr = exports.title = exports.time = exports.thead = exports.th = exports.tfoot = void 0;
    exports.create_element = create_element;
    exports.createSVGElement = createSVGElement;
    exports.text = text;
    exports.nbsp = nbsp;
    exports.prepend = prepend;
    exports.empty = empty;
    exports.contains = contains;
    exports.display = display;
    exports.undisplay = undisplay;
    exports.show = show;
    exports.hide = hide;
    exports.offset_bbox = offset_bbox;
    exports.parent = parent;
    exports.extents = extents;
    exports.size = size;
    exports.scroll_size = scroll_size;
    exports.outer_size = outer_size;
    exports.content_size = content_size;
    exports.bounding_box = bounding_box;
    exports.box_size = box_size;
    exports.position = position;
    exports.classes = classes;
    exports.toggle_attribute = toggle_attribute;
    exports.dom_ready = dom_ready;
    exports.px = px;
    exports.has_focus = has_focus;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const bbox_1 = require(62) /* ./util/bbox */;
    const css_1 = require(63) /* ./css */;
    const logging_1 = require(20) /* ./logging */;
    const _element = (tag) => {
        return (attrs = {}, ...children) => {
            const element = document.createElement(tag);
            if (!(0, types_1.isPlainObject)(attrs)) {
                children = [attrs, ...children];
                attrs = {};
            }
            else {
                attrs = { ...attrs };
            }
            if (attrs.class != null) {
                const classes = (() => {
                    if ((0, types_1.isString)(attrs.class)) {
                        return attrs.class.split(/\s+/);
                    }
                    else {
                        return attrs.class;
                    }
                })();
                for (const cls of classes) {
                    if (cls != null) {
                        element.classList.add(cls);
                    }
                }
                delete attrs.class;
            }
            if (attrs.style != null) {
                if ((0, types_1.isString)(attrs.style)) {
                    element.setAttribute("style", attrs.style);
                }
                else {
                    (0, css_1.apply_styles)(element.style, attrs.style);
                }
                delete attrs.style;
            }
            if (attrs.data != null) {
                for (const [key, data] of (0, object_1.entries)(attrs.data)) {
                    if (data != null) {
                        element.dataset[key] = data;
                    }
                }
                delete attrs.data;
            }
            for (const [attr, value] of (0, object_1.entries)(attrs)) {
                if (value == null) {
                    continue;
                }
                else if ((0, types_1.isBoolean)(value)) {
                    element.toggleAttribute(attr, value);
                }
                else if ((0, types_1.isNumber)(value)) {
                    element.setAttribute(attr, `${value}`);
                }
                else if ((0, types_1.isString)(value)) {
                    element.setAttribute(attr, value);
                }
                else {
                    logging_1.logger.warn(`unable to set attribute: ${attr} = ${value}`);
                }
            }
            function append(child) {
                if ((0, types_1.isString)(child)) {
                    element.append(document.createTextNode(child));
                }
                else if (child instanceof Node) {
                    element.append(child);
                }
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    element.append(...child);
                }
                else if (child != null && child !== false) {
                    throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
                }
            }
            for (const child of children) {
                if ((0, types_1.isArray)(child)) {
                    for (const _child of child) {
                        append(_child);
                    }
                }
                else {
                    append(child);
                }
            }
            return element;
        };
    };
    function create_element(tag, attrs, ...children) {
        return _element(tag)(attrs, ...children);
    }
    exports.a = _element("a");
    exports.abbr = _element("abbr");
    exports.address = _element("address");
    exports.area = _element("area");
    exports.article = _element("article");
    exports.aside = _element("aside");
    exports.audio = _element("audio");
    exports.b = _element("b");
    exports.base = _element("base");
    exports.bdi = _element("bdi");
    exports.bdo = _element("bdo");
    exports.blockquote = _element("blockquote");
    exports.body = _element("body");
    exports.br = _element("br");
    exports.button = _element("button");
    exports.canvas = _element("canvas");
    exports.caption = _element("caption");
    exports.cite = _element("cite");
    exports.code = _element("code");
    exports.col = _element("col");
    exports.colgroup = _element("colgroup");
    exports.data = _element("data");
    exports.datalist = _element("datalist");
    exports.dd = _element("dd");
    exports.del = _element("del");
    exports.details = _element("details");
    exports.dfn = _element("dfn");
    exports.dialog = _element("dialog");
    exports.div = _element("div");
    exports.dl = _element("dl");
    exports.dt = _element("dt");
    exports.em = _element("em");
    exports.embed = _element("embed");
    exports.fieldset = _element("fieldset");
    exports.figcaption = _element("figcaption");
    exports.figure = _element("figure");
    exports.footer = _element("footer");
    exports.form = _element("form");
    exports.h1 = _element("h1");
    exports.h2 = _element("h2");
    exports.h3 = _element("h3");
    exports.h4 = _element("h4");
    exports.h5 = _element("h5");
    exports.h6 = _element("h6");
    exports.head = _element("head");
    exports.header = _element("header");
    exports.hgroup = _element("hgroup");
    exports.hr = _element("hr");
    exports.html = _element("html");
    exports.i = _element("i");
    exports.iframe = _element("iframe");
    exports.img = _element("img");
    exports.input = _element("input");
    exports.ins = _element("ins");
    exports.kbd = _element("kbd");
    exports.label = _element("label");
    exports.legend = _element("legend");
    exports.li = _element("li");
    exports.link = _element("link");
    exports.main = _element("main");
    exports.map = _element("map");
    exports.mark = _element("mark");
    exports.menu = _element("menu");
    exports.meta = _element("meta");
    exports.meter = _element("meter");
    exports.nav = _element("nav");
    exports.noscript = _element("noscript");
    exports.object = _element("object");
    exports.ol = _element("ol");
    exports.optgroup = _element("optgroup");
    exports.option = _element("option");
    exports.output = _element("output");
    exports.p = _element("p");
    exports.picture = _element("picture");
    exports.pre = _element("pre");
    exports.progress = _element("progress");
    exports.q = _element("q");
    exports.rp = _element("rp");
    exports.rt = _element("rt");
    exports.ruby = _element("ruby");
    exports.s = _element("s");
    exports.samp = _element("samp");
    exports.script = _element("script");
    exports.search = _element("search");
    exports.section = _element("section");
    exports.select = _element("select");
    exports.slot = _element("slot");
    exports.small = _element("small");
    exports.source = _element("source");
    exports.span = _element("span");
    exports.strong = _element("strong");
    exports.style = _element("style");
    exports.sub = _element("sub");
    exports.summary = _element("summary");
    exports.sup = _element("sup");
    exports.table = _element("table");
    exports.tbody = _element("tbody");
    exports.td = _element("td");
    exports.template = _element("template");
    exports.textarea = _element("textarea");
    exports.tfoot = _element("tfoot");
    exports.th = _element("th");
    exports.thead = _element("thead");
    exports.time = _element("time");
    exports.title = _element("title");
    exports.tr = _element("tr");
    exports.track = _element("track");
    exports.u = _element("u");
    exports.ul = _element("ul");
    exports.video = _element("video");
    exports.wbr = _element("wbr");
    function createSVGElement(tag, attrs = null, ...children) {
        const element = document.createElementNS("http://www.w3.org/2000/svg", tag);
        for (const [attr, value] of (0, object_1.entries)(attrs ?? {})) {
            if (value == null || value === false) {
                continue;
            }
            element.setAttribute(attr, value);
        }
        function append(child) {
            if ((0, types_1.isString)(child)) {
                element.appendChild(document.createTextNode(child));
            }
            else if (child instanceof Node) {
                element.appendChild(child);
            }
            else if (child instanceof NodeList || child instanceof HTMLCollection) {
                for (const el of child) {
                    element.appendChild(el);
                }
            }
            else if (child != null && child !== false) {
                throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
            }
        }
        for (const child of children) {
            if ((0, types_1.isArray)(child)) {
                for (const _child of child) {
                    append(_child);
                }
            }
            else {
                append(child);
            }
        }
        return element;
    }
    function text(str) {
        return document.createTextNode(str);
    }
    function nbsp() {
        return text("\u00a0");
    }
    function prepend(element, ...nodes) {
        const first = element.firstChild;
        for (const node of nodes) {
            element.insertBefore(node, first);
        }
    }
    function empty(node, attrs = false) {
        let child;
        while ((child = node.firstChild) != null) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            for (const attr of node.attributes) {
                node.removeAttributeNode(attr);
            }
        }
    }
    function contains(element, child) {
        /**
         * Like Node.contains(), but traverses Shadow DOM boundaries.
         */
        let current = child;
        while (current.parentNode != null) {
            const parent = current.parentNode;
            if (parent == element) {
                return true;
            }
            else if (parent instanceof ShadowRoot) {
                current = parent.host;
            }
            else {
                current = parent;
            }
        }
        return false;
    }
    function display(element, display = true) {
        element.style.display = display ? "" : "none";
    }
    function undisplay(element) {
        element.style.display = "none";
    }
    function show(element) {
        element.style.visibility = "";
    }
    function hide(element) {
        element.style.visibility = "hidden";
    }
    function offset_bbox(element) {
        const { top, left, width, height } = element.getBoundingClientRect();
        return new bbox_1.BBox({
            left: left + scrollX - document.documentElement.clientLeft,
            top: top + scrollY - document.documentElement.clientTop,
            width,
            height,
        });
    }
    function parent(el, selector) {
        let node = el;
        while ((node = node.parentElement) != null) {
            if (node.matches(selector)) {
                return node;
            }
        }
        return null;
    }
    function num(value) {
        const num = parseFloat(value);
        return isFinite(num) ? num : 0;
    }
    function extents(el) {
        const style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    function size(el) {
        const rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    function outer_size(el) {
        const { margin: { left, right, top, bottom } } = extents(el);
        const { width, height } = size(el);
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    function content_size(el) {
        const { left, top } = el.getBoundingClientRect();
        const { padding } = extents(el);
        let width = 0;
        let height = 0;
        for (const child of (el.shadowRoot ?? el).children) {
            const rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width, height };
    }
    function bounding_box(el) {
        const { x, y, width, height } = el.getBoundingClientRect();
        return new bbox_1.BBox({ x, y, width, height });
    }
    function box_size(el) {
        const { width, height } = el.getBoundingClientRect();
        return { width, height };
    }
    function position(el, box, margin) {
        const { style } = el;
        style.left = `${box.x}px`;
        style.top = `${box.y}px`;
        style.width = `${box.width}px`;
        style.height = `${box.height}px`;
        if (margin == null) {
            style.margin = "";
        }
        else {
            const { top, right, bottom, left } = margin;
            style.margin = `${top}px ${right}px ${bottom}px ${left}px`;
        }
    }
    class ClassList {
        constructor(class_list) {
            this.class_list = class_list;
        }
        get values() {
            const values = [];
            for (let i = 0; i < this.class_list.length; i++) {
                const item = this.class_list.item(i);
                if (item != null) {
                    values.push(item);
                }
            }
            return values;
        }
        has(cls) {
            return this.class_list.contains(cls);
        }
        add(...classes) {
            for (const cls of classes) {
                this.class_list.add(cls);
            }
            return this;
        }
        remove(...classes) {
            for (const cls of classes) {
                if ((0, types_1.isArray)(cls)) {
                    cls.forEach((cls) => this.class_list.remove(cls));
                }
                else {
                    this.class_list.remove(cls);
                }
            }
            return this;
        }
        clear() {
            for (const cls of this.values) {
                this.class_list.remove(cls);
            }
            return this;
        }
        toggle(cls, activate) {
            return this.class_list.toggle(cls, activate);
        }
    }
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el.classList);
    }
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state) {
            el.setAttribute(attr, "true");
        }
        else {
            el.removeAttribute(attr);
        }
    }
    (function (MouseButton) {
        MouseButton[MouseButton["None"] = 0] = "None";
        MouseButton[MouseButton["Primary"] = 1] = "Primary";
        MouseButton[MouseButton["Secondary"] = 2] = "Secondary";
        MouseButton[MouseButton["Auxiliary"] = 4] = "Auxiliary";
        MouseButton[MouseButton["Left"] = 1] = "Left";
        MouseButton[MouseButton["Right"] = 2] = "Right";
        MouseButton[MouseButton["Middle"] = 4] = "Middle";
    })(exports.MouseButton || (exports.MouseButton = {}));
    class StyleSheet {
        install(el) {
            el.append(this.el);
        }
        uninstall() {
            this.el.remove();
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    class InlineStyleSheet extends StyleSheet {
        constructor(css, id, persistent = false) {
            super();
            this.el = (0, exports.style)();
            this.persistent = persistent;
            if ((0, types_1.isString)(css)) {
                this._update(css);
            }
            else if (css != null) {
                this._update((0, css_1.compose_stylesheet)(css));
            }
            if (id != null) {
                this.el.dataset.css = id;
            }
        }
        get css() {
            return this.el.textContent;
        }
        _update(css) {
            this.el.textContent = css;
        }
        clear() {
            this.replace("");
        }
        _to_css(css, styles) {
            if (styles == null) {
                return css;
            }
            else {
                return (0, css_1.compose_stylesheet)({ [css]: styles });
            }
        }
        replace(css, styles) {
            this._update(this._to_css(css, styles));
        }
        prepend(css, styles) {
            this._update(`${this._to_css(css, styles)}\n${this.css}`);
        }
        append(css, styles) {
            this._update(`${this.css}\n${this._to_css(css, styles)}`);
        }
        remove() {
            this.el.remove();
        }
    }
    exports.InlineStyleSheet = InlineStyleSheet;
    InlineStyleSheet.__name__ = "InlineStyleSheet";
    class GlobalInlineStyleSheet extends InlineStyleSheet {
        install() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalInlineStyleSheet = GlobalInlineStyleSheet;
    GlobalInlineStyleSheet.__name__ = "GlobalInlineStyleSheet";
    class ImportedStyleSheet extends StyleSheet {
        constructor(url) {
            super();
            this.el = (0, exports.link)({ rel: "stylesheet", href: url });
        }
        replace(url) {
            this.el.href = url;
        }
        remove() {
            this.el.remove();
        }
    }
    exports.ImportedStyleSheet = ImportedStyleSheet;
    ImportedStyleSheet.__name__ = "ImportedStyleSheet";
    class GlobalImportedStyleSheet extends ImportedStyleSheet {
        install() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalImportedStyleSheet = GlobalImportedStyleSheet;
    GlobalImportedStyleSheet.__name__ = "GlobalImportedStyleSheet";
    async function dom_ready() {
        if (document.readyState == "loading") {
            return new Promise((resolve, _reject) => {
                document.addEventListener("DOMContentLoaded", () => resolve(), { once: true });
            });
        }
    }
    function px(value) {
        return (0, types_1.isNumber)(value) ? `${value}px` : value;
    }
    exports.supports_adopted_stylesheets = "adoptedStyleSheets" in ShadowRoot.prototype;
    function has_focus(el) {
        const root = el.getRootNode();
        if (root instanceof ShadowRoot || root instanceof Document) {
            return root.activeElement === el;
        }
        else {
            return false;
        }
    }
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.empty = empty;
    exports.full = full;
    exports.x_range = x_range;
    exports.y_range = y_range;
    exports.positive_x = positive_x;
    exports.negative_x = negative_x;
    exports.positive_y = positive_y;
    exports.negative_y = negative_y;
    exports.union = union;
    exports.isXY = isXY;
    const types_1 = require(25) /* ../types */;
    const eq_1 = require(27) /* ./eq */;
    const arrayable_1 = require(13) /* ./arrayable */;
    const types_2 = require(8) /* ./types */;
    const { min, max, round } = Math;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    function full() {
        return {
            x0: -Infinity,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    function x_range(x0, x1) {
        return {
            x0,
            y0: -Infinity,
            x1,
            y1: Infinity,
        };
    }
    function y_range(y0, y1) {
        return {
            x0: -Infinity,
            y0,
            x1: Infinity,
            y1,
        };
    }
    function positive_x() {
        return x_range(Number.MIN_VALUE, Infinity);
    }
    function negative_x() {
        return x_range(-Infinity, -Number.MIN_VALUE);
    }
    function positive_y() {
        return y_range(Number.MIN_VALUE, Infinity);
    }
    function negative_y() {
        return y_range(-Infinity, -Number.MIN_VALUE);
    }
    function _min(a, b) {
        if (isNaN(a)) {
            return b;
        }
        else if (isNaN(b)) {
            return a;
        }
        else {
            return min(a, b);
        }
    }
    function _max(a, b) {
        if (isNaN(a)) {
            return b;
        }
        else if (isNaN(b)) {
            return a;
        }
        else {
            return max(a, b);
        }
    }
    function union(a, b) {
        return {
            x0: _min(a.x0, b.x0),
            x1: _max(a.x1, b.x1),
            y0: _min(a.y0, b.y0),
            y1: _max(a.y1, b.y1),
        };
    }
    function isXY(obj) {
        return (0, types_2.isPlainObject)(obj) && "x" in obj && "y" in obj;
    }
    class BBox {
        constructor(box, correct = false) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ("x0" in box) {
                const { x0, y0, x1, y1 } = box;
                if (!isFinite(x0 + y0 + x1 + y1)) {
                    this.x0 = NaN;
                    this.y0 = NaN;
                    this.x1 = NaN;
                    this.y1 = NaN;
                }
                else {
                    if (!(x0 <= x1 && y0 <= y1)) {
                        throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
                    }
                    this.x0 = x0;
                    this.y0 = y0;
                    this.x1 = x1;
                    this.y1 = y1;
                }
            }
            else if ("x" in box) {
                const { x, y, width, height, origin = "top_left" } = box;
                if (!(width >= 0 && height >= 0)) {
                    throw new Error(`invalid bbox {x: ${x}, y: ${y}, width: ${width}, height: ${height}}`);
                }
                const base_origin = (() => {
                    switch (origin) {
                        case "left": return "center_left";
                        case "right": return "center_right";
                        case "top": return "top_center";
                        case "bottom": return "bottom_center";
                        case "center": return "center_center";
                        default: return origin;
                    }
                })();
                const [y_align, x_align] = base_origin.split("_", 2);
                const y_coeff = (() => {
                    switch (y_align) {
                        case "top": return 0.0;
                        case "center": return 0.5;
                        case "bottom": return 1.0;
                    }
                })();
                const x_coeff = (() => {
                    switch (x_align) {
                        case "left": return 0.0;
                        case "center": return 0.5;
                        case "right": return 1.0;
                    }
                })();
                const d_width = x_coeff * width;
                const d_height = y_coeff * height;
                const x0 = x - d_width;
                const y0 = y - d_height;
                const x1 = x0 + width;
                const y1 = y0 + height;
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else {
                let left, right;
                let top, bottom;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        const w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        const h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (left > right || top > bottom) {
                    if (correct) {
                        if (left > right) {
                            left = right;
                        }
                        if (top > bottom) {
                            top = bottom;
                        }
                    }
                    else {
                        throw new Error(`invalid bbox {left: ${left}, top: ${top}, right: ${right}, bottom: ${bottom}}`);
                    }
                }
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        static from_lrtb({ left, right, top, bottom }) {
            return new BBox({
                x0: min(left, right),
                y0: min(top, bottom),
                x1: max(left, right),
                y1: max(top, bottom),
            });
        }
        static from_rect({ x0, y0, x1, y1 }) {
            return new BBox({
                x0: min(x0, x1),
                y0: min(y0, y1),
                x1: max(x0, x1),
                y1: max(y0, y1),
            });
        }
        static empty() {
            return new BBox({ x0: 0, y0: 0, x1: 0, y1: 0 });
        }
        static invalid() {
            return new BBox({ x0: NaN, y0: NaN, x1: NaN, y1: NaN });
        }
        clone() {
            return new BBox(this);
        }
        equals(that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        }
        toString() {
            return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
        }
        get is_valid() {
            const { x0, x1, y0, y1 } = this;
            return isFinite(x0 + x1 + y0 + y1);
        }
        get is_empty() {
            const { x0, x1, y0, y1 } = this;
            return x0 == 0 && x1 == 0 && y0 == 0 && y1 == 0;
        }
        get left() {
            return this.x0;
        }
        get top() {
            return this.y0;
        }
        get right() {
            return this.x1;
        }
        get bottom() {
            return this.y1;
        }
        get p0() {
            return { x: this.x0, y: this.y0 };
        }
        get p1() {
            return { x: this.x1, y: this.y1 };
        }
        get x() {
            return this.x0;
        }
        get y() {
            return this.y0;
        }
        get width() {
            return this.x1 - this.x0;
        }
        get height() {
            return this.y1 - this.y0;
        }
        get size() {
            return { width: this.width, height: this.height };
        }
        get rect() {
            const { x0, y0, x1, y1 } = this;
            return {
                p0: { x: x0, y: y0 },
                p1: { x: x1, y: y0 },
                p2: { x: x1, y: y1 },
                p3: { x: x0, y: y1 },
            };
        }
        get box() {
            const { x, y, width, height } = this;
            return { x, y, width, height };
        }
        get lrtb() {
            const { left, right, top, bottom } = this;
            return { left, right, top, bottom };
        }
        get args() {
            const { x, y, width, height } = this;
            return [x, y, width, height];
        }
        get x_range() {
            return { start: this.x0, end: this.x1 };
        }
        get y_range() {
            return { start: this.y0, end: this.y1 };
        }
        get h_range() {
            return this.x_range;
        }
        get v_range() {
            return this.y_range;
        }
        get ranges() {
            return [this.x_range, this.y_range];
        }
        get aspect() {
            return this.width / this.height;
        }
        get x_center() {
            return (this.left + this.right) / 2;
        }
        get y_center() {
            return (this.top + this.bottom) / 2;
        }
        get hcenter() {
            return this.x_center;
        }
        get vcenter() {
            return this.y_center;
        }
        get area() {
            return this.width * this.height;
        }
        resolve(symbol) {
            switch (symbol) {
                case "top_left": return this.top_left;
                case "top_center": return this.top_center;
                case "top_right": return this.top_right;
                case "center_left": return this.center_left;
                case "center_center": return this.center_center;
                case "center_right": return this.center_right;
                case "bottom_left": return this.bottom_left;
                case "bottom_center": return this.bottom_center;
                case "bottom_right": return this.bottom_right;
                case "center": return this.center;
                case "top": return this.top;
                case "left": return this.left;
                case "right": return this.right;
                case "bottom": return this.bottom;
                case "width": return this.width;
                case "height": return this.height;
                default: return { x: NaN, y: NaN };
            }
        }
        get top_left() {
            return { x: this.left, y: this.top };
        }
        get top_center() {
            return { x: this.hcenter, y: this.top };
        }
        get top_right() {
            return { x: this.right, y: this.top };
        }
        get center_left() {
            return { x: this.left, y: this.vcenter };
        }
        get center_center() {
            return { x: this.hcenter, y: this.vcenter };
        }
        get center_right() {
            return { x: this.right, y: this.vcenter };
        }
        get bottom_left() {
            return { x: this.left, y: this.bottom };
        }
        get bottom_center() {
            return { x: this.hcenter, y: this.bottom };
        }
        get bottom_right() {
            return { x: this.right, y: this.bottom };
        }
        get center() {
            return { x: this.hcenter, y: this.vcenter };
        }
        round() {
            return new BBox({
                x0: round(this.x0),
                x1: round(this.x1),
                y0: round(this.y0),
                y1: round(this.y1),
            });
        }
        relative() {
            const { width, height } = this;
            return new BBox({ x: 0, y: 0, width, height });
        }
        relative_to(to) {
            const { x, y, width, height } = this;
            return new BBox({ x: x - to.x, y: y - to.y, width, height });
        }
        translate(tx, ty) {
            const { x, y, width, height } = this;
            return new BBox({ x: tx + x, y: ty + y, width, height });
        }
        scale(factor) {
            return new BBox({
                x0: this.x0 * factor,
                x1: this.x1 * factor,
                y0: this.y0 * factor,
                y1: this.y1 * factor,
            });
        }
        relativize(x, y) {
            return [x - this.x, y - this.y];
        }
        contains(x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        }
        clip(x, y) {
            if (x < this.x0) {
                x = this.x0;
            }
            else if (x > this.x1) {
                x = this.x1;
            }
            if (y < this.y0) {
                y = this.y0;
            }
            else if (y > this.y1) {
                y = this.y1;
            }
            return [x, y];
        }
        grow_by(size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        }
        shrink_by(size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            }, true);
        }
        union(that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        }
        intersection(that) {
            if (!this.intersects(that)) {
                return null;
            }
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        }
        intersects(that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        }
        get x_percent() {
            const self = this;
            return this._x_percent ?? (this._x_percent = {
                compute(x) {
                    return self.left + x * self.width;
                },
                invert(sx) {
                    return (sx - self.left) / self.width;
                },
                v_compute(xs) {
                    const { left, width } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x * width));
                },
                v_invert(sxs) {
                    const { left, width } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => (sx - left) / width);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_percent() {
            const self = this;
            return this._y_percent ?? (this._y_percent = {
                compute(y) {
                    return self.top + y * self.height;
                },
                invert(sy) {
                    return (sy - self.top) / self.height;
                },
                v_compute(ys) {
                    const { top, height } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => top + y * height));
                },
                v_invert(sys) {
                    const { top, height } = self;
                    return (0, arrayable_1.map)(sys, (sy) => (sy - top) / height);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return self.y_range;
                },
            });
        }
        get x_screen() {
            const self = this;
            return this._x_screen ?? (this._x_screen = {
                compute(x) {
                    return self.left + x;
                },
                invert(sx) {
                    return sx - self.left;
                },
                v_compute(xs) {
                    const { left } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x));
                },
                v_invert(sxs) {
                    const { left } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => sx - left);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_screen() {
            const self = this;
            return this._y_screen ?? (this._y_screen = {
                compute(y) {
                    return self.top + y;
                },
                invert(sy) {
                    return sy - self.top;
                },
                v_compute(ys) {
                    const { top } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => top + y));
                },
                v_invert(sys) {
                    const { top } = self;
                    return (0, arrayable_1.map)(sys, (sy) => sy - top);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return self.y_range;
                },
            });
        }
        get x_view() {
            const self = this;
            return this._x_view ?? (this._x_view = {
                compute(x) {
                    return self.left + x;
                },
                invert(sx) {
                    return sx - self.left;
                },
                v_compute(xs) {
                    const { left } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x));
                },
                v_invert(sxs) {
                    const { left } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => sx - left);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_view() {
            const self = this;
            return this._y_view ?? (this._y_view = {
                compute(y) {
                    return self.bottom - y;
                },
                invert(sy) {
                    return self.bottom - sy;
                },
                v_compute(ys) {
                    const { bottom } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => bottom - y));
                },
                v_invert(sys) {
                    const { bottom } = self;
                    return (0, arrayable_1.map)(sys, (sy) => bottom - sy);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return { start: self.bottom, end: self.top };
                },
            });
        }
        get xview() {
            return this.x_view;
        }
        get yview() {
            return this.y_view;
        }
    }
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* core/css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.apply_styles = apply_styles;
    exports.compose_stylesheet = compose_stylesheet;
    const logging_1 = require(20) /* ./logging */;
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const _style_decl = document.createElement("div").style;
    function _css_name(attr) {
        if (attr.startsWith("--")) {
            return attr;
        }
        const name = attr.replaceAll(/_/g, "-").replaceAll(/[A-Z]/g, (c) => `-${c.toLowerCase()}`);
        // XXX hasOwnProperty() doesn't work for unknown reasons (e.g. in Firefox)
        if (name in _style_decl) {
            return name;
        }
        const webkit_name = `-webkit-${name}`;
        if (webkit_name in _style_decl) {
            return webkit_name;
        }
        const moz_name = `-moz-${name}`;
        if (moz_name in _style_decl) {
            return moz_name;
        }
        logging_1.logger.warn(`unknown CSS property '${attr}'`);
        return null;
    }
    function* _iter_styles(styles) {
        if ((0, types_1.isPlainObject)(styles) || styles instanceof Map) {
            for (const [key, val] of (0, object_1.entries)(styles)) {
                const name = _css_name(key);
                if (name != null) {
                    yield [name, val];
                }
            }
        }
        else {
            for (const prop of styles.own_properties()) {
                if (prop.dirty) {
                    const name = _css_name(prop.attr);
                    if (name != null) {
                        yield [name, prop.get_value()];
                    }
                }
            }
        }
    }
    function apply_styles(declaration, styles) {
        for (const [name, value] of _iter_styles(styles)) {
            if ((0, types_1.isString)(value)) {
                declaration.setProperty(name, value);
            }
            else {
                declaration.removeProperty(name);
            }
        }
    }
    function compose_stylesheet(stylesheet) {
        const css = [];
        for (const [selector, styles] of (0, object_1.entries)(stylesheet)) {
            css.push(`${selector} {`);
            for (const [name, value] of _iter_styles(styles)) {
                if ((0, types_1.isString)(value) && value.length != 0) {
                    css.push(`  ${name}: ${value};`);
                }
            }
            css.push("}");
        }
        return css.join("\n");
    }
},
/* core/dom_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const view_1 = require(65) /* ./view */;
    const dom_1 = require(61) /* ./dom */;
    const types_1 = require(8) /* ./util/types */;
    const assert_1 = require(12) /* ./util/assert */;
    const base_css_1 = tslib_1.__importDefault(require(70) /* ../styles/base.css */);
    class DOMView extends view_1.View {
        constructor() {
            super(...arguments);
            this._was_built = false;
        }
        get bbox() {
            return undefined;
        }
        serializable_state() {
            const state = super.serializable_state();
            const { bbox } = this;
            return bbox != null ? { ...state, bbox: bbox.round() } : state;
        }
        get children_el() {
            return this.shadow_el ?? this.el;
        }
        initialize() {
            super.initialize();
            this.el = this._create_element();
        }
        remove() {
            this.el.remove();
            super.remove();
        }
        stylesheets() {
            return [];
        }
        css_classes() {
            return [];
        }
        rerender() {
            this.render();
            this.r_after_render();
        }
        render_to(target) {
            this.render();
            target.appendChild(this.el);
        }
        after_render() {
            this.reposition();
        }
        r_after_render() {
            for (const child_view of this.children()) {
                if (child_view instanceof DOMView) {
                    child_view.r_after_render();
                }
            }
            this.after_render();
            this._was_built = true;
        }
        _create_element() {
            return (0, dom_1.create_element)(this.constructor.tag_name, {});
        }
        reposition(_displayed) { }
        /**
         * Build a top-level DOM view (e.g. during embedding).
         */
        build(target) {
            (0, assert_1.assert)(this.is_root);
            this.render_to(target);
            this.r_after_render();
            this.notify_finished();
        }
        /**
         * Define where to render this element or let the parent decide.
         *
         * This is useful when creating "floating" components or adding
         * components to canvas' layers.
         */
        rendering_target() {
            return null;
        }
    }
    exports.DOMView = DOMView;
    DOMView.__name__ = "DOMView";
    DOMView.tag_name = "div";
    class DOMElementView extends DOMView {
        initialize() {
            super.initialize();
            this.class_list = new dom_1.ClassList(this.el.classList);
        }
        get self_target() {
            return this.el;
        }
    }
    exports.DOMElementView = DOMElementView;
    DOMElementView.__name__ = "DOMElementView";
    class DOMComponentView extends DOMElementView {
        constructor() {
            super(...arguments);
            this._base_style = new dom_1.InlineStyleSheet(base_css_1.default, "base");
            this._css_vars = new dom_1.InlineStyleSheet("", "vars");
            this._applied_html_attributes = [];
            this._applied_stylesheets = [];
            this._applied_css_classes = [];
        }
        get self_target() {
            return this.shadow_el;
        }
        initialize() {
            super.initialize();
            this.shadow_el = this.el.attachShadow({ mode: "open" });
        }
        stylesheets() {
            return [...super.stylesheets(), this._base_style];
        }
        /**
         * Baseline stylesheets, e.g. imported CSS modules.
         */
        static_stylesheets() {
            return this.stylesheets();
        }
        /**
         * Stylesheets computed by the component.
         */
        computed_stylesheets() {
            return [this._css_vars];
        }
        /**
         * Other stylesheets, e.g. provided by user.
         */
        user_stylesheets() {
            return [];
        }
        empty() {
            (0, dom_1.empty)(this.shadow_el);
            this.class_list.clear();
            this._applied_css_classes = [];
            this._applied_stylesheets = [];
            for (const stylesheet of this.computed_stylesheets()) {
                if (!stylesheet.persistent) {
                    stylesheet.clear();
                }
            }
        }
        render() {
            this.empty();
            this._update_stylesheets();
            this._apply_html_attributes();
        }
        _apply_html_attributes() {
            this._update_css_classes();
        }
        reposition(_displayed) {
            this._update_css_variables(); // TODO remove this when node invalidation is implemented
        }
        *_stylesheets() {
            yield* this.static_stylesheets();
            yield* this.computed_stylesheets();
            yield* this.user_stylesheets();
        }
        *_css_classes() {
            yield `bk-${this.model.type.replace(/\./g, "-")}`;
            yield* this.css_classes();
        }
        *_css_variables() { }
        _apply_stylesheets(stylesheets) {
            const resolved_stylesheets = stylesheets.map((style) => (0, types_1.isString)(style) ? new dom_1.InlineStyleSheet(style) : style);
            this._applied_stylesheets.push(...resolved_stylesheets);
            resolved_stylesheets.forEach((stylesheet) => stylesheet.install(this.shadow_el));
        }
        _apply_css_classes(classes) {
            this._applied_css_classes.push(...classes);
            this.class_list.add(...classes);
        }
        _update_stylesheets() {
            this._applied_stylesheets.forEach((stylesheet) => stylesheet.uninstall());
            this._applied_stylesheets = [];
            this._apply_stylesheets([...this._stylesheets()]);
        }
        _update_css_classes() {
            this.class_list.remove(this._applied_css_classes);
            this._applied_css_classes = [];
            this._apply_css_classes([...this._css_classes()]);
        }
        _update_css_variables() {
            const vars = [];
            for (const [name, value] of this._css_variables()) {
                const full_name = name.startsWith("--") ? name : `--${name}`;
                vars.push(`${full_name}: ${value};\n`);
            }
            if (vars.length == 0) {
                this._css_vars.clear();
            }
            else {
                this._css_vars.replace(`:host {\n${vars}}`);
            }
        }
    }
    exports.DOMComponentView = DOMComponentView;
    DOMComponentView.__name__ = "DOMComponentView";
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const has_props_1 = require(15) /* ./has_props */;
    const signaling_1 = require(16) /* ./signaling */;
    const types_1 = require(8) /* ./util/types */;
    const node_1 = require(57) /* ../models/coordinates/node */;
    const xy_1 = require(66) /* ../models/coordinates/xy */;
    const indexed_1 = require(67) /* ../models/coordinates/indexed */;
    const view_manager_1 = require(68) /* ./view_manager */;
    const eq_1 = require(27) /* ./util/eq */;
    class View {
        get ready() {
            return this._ready;
        }
        _await_ready(promise) {
            this._ready = this._ready.then(() => promise);
            if (this.root != this) {
                this.root._ready = this.root._ready.then(() => this._ready);
            }
        }
        connect(signal, slot) {
            let new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = (args, sender) => {
                    this._await_ready(Promise.resolve(slot.call(this, args, sender)));
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        }
        disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        constructor(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this.views = new view_manager_1.ViewQuery(this);
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            this._destroyed = false;
            this._has_finished = false;
            this._idle_notified = false;
            const { model, parent, owner } = options;
            this.model = model;
            this.parent = (0, types_1.isFunction)(parent) ? parent(this.model) : parent;
            if (this.parent == null) {
                this.root = this;
                this.owner = owner ?? new view_manager_1.ViewManager([this]);
            }
            else {
                this.root = this.parent.root;
                this.owner = this.root.owner;
            }
        }
        initialize() { }
        async lazy_initialize() { }
        remove() {
            this.disconnect_signals();
            this.owner.remove(this);
            this.removed.emit();
            this._destroyed = true;
        }
        get is_destroyed() {
            return this._destroyed;
        }
        toString() {
            return `${this.model.type}View(${this.model.id})`;
        }
        [eq_1.equals](that, _cmp) {
            return Object.is(this, that);
        }
        *children() { }
        mark_finished() {
            this._has_finished = true;
        }
        /**
         * Mark as finished even if e.g. external resources were not loaded yet.
         */
        force_finished() {
            this.mark_finished();
        }
        finish() {
            this.mark_finished();
            this.notify_finished();
        }
        notify_finished() {
            if (!this.is_root) {
                this.root.notify_finished();
            }
            else {
                if (!this._idle_notified && this.has_finished()) {
                    const { document } = this.model;
                    if (document != null) {
                        this._idle_notified = true;
                        document.notify_idle(this.model);
                    }
                }
            }
        }
        serializable_children() {
            return [...this.children()].filter((view) => view.model.is_syncable);
        }
        serializable_state() {
            const children = this.serializable_children()
                .map((view) => view.serializable_state())
                .filter((item) => item.bbox != null && item.bbox.is_valid && !item.bbox.is_empty); // TODO move this to a common base class for UI views
            return {
                type: this.model.type,
                children,
            };
        }
        get is_root() {
            return this.parent == null;
        }
        has_finished() {
            return this._has_finished;
        }
        get is_idle() {
            return this.has_finished();
        }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        on_transitive_change(property, fn, { recursive = false, signal = (obj) => obj.change } = {}) {
            const collect = () => {
                const value = property.is_unset ? [] : property.get_value();
                return has_props_1.HasProps.references(value, { recursive });
            };
            const connect = (models) => {
                for (const model of models) {
                    this.connect(signal(model), () => fn());
                }
            };
            const disconnect = (models) => {
                for (const model of models) {
                    this.disconnect(signal(model), () => fn());
                }
            };
            let models = collect();
            connect(models);
            this.on_change(property, () => {
                disconnect(models);
                models = collect();
                connect(models);
                fn();
            });
        }
        cursor(_sx, _sy) {
            return null;
        }
        resolve_frame() {
            return null;
        }
        resolve_canvas() {
            return null;
        }
        resolve_plot() {
            return null;
        }
        resolve_target(target) {
            if ((0, types_1.isString)(target)) {
                const ascend = (fn) => {
                    let obj = this;
                    while (obj != null) {
                        const view = fn(obj);
                        if (view != null) {
                            return view;
                        }
                        else {
                            obj = obj.parent;
                        }
                    }
                    return null;
                };
                switch (target) {
                    case "parent": return this.parent;
                    case "frame": return ascend((view) => view.resolve_frame());
                    case "canvas": return ascend((view) => view.resolve_canvas());
                    case "plot": return ascend((view) => view.resolve_plot());
                }
            }
            else {
                const queue = [this.root];
                while (true) {
                    const child = queue.shift();
                    if (child == null) {
                        break;
                    }
                    else if (child.model == target) {
                        return child;
                    }
                    else {
                        queue.push(...child.children());
                    }
                }
                return null;
            }
        }
        resolve_symbol(_node) {
            return { x: NaN, y: NaN };
        }
        resolve_node(node) {
            const target = this.resolve_target(node.target);
            if (target != null) {
                return target.resolve_symbol(node);
            }
            else {
                return { x: NaN, y: NaN };
            }
        }
        resolve_coordinate(coord) {
            if (coord instanceof xy_1.XY) {
                let obj = this;
                while (obj != null && obj.resolve_xy == null) {
                    obj = obj.parent;
                }
                return obj?.resolve_xy?.(coord) ?? { x: NaN, y: NaN };
            }
            else if (coord instanceof indexed_1.Indexed) {
                let obj = this;
                while (obj != null && obj.resolve_indexed == null) {
                    obj = obj.parent;
                }
                return obj?.resolve_indexed?.(coord) ?? { x: NaN, y: NaN };
            }
            else if (coord instanceof node_1.Node) {
                return this.resolve_node(coord);
            }
            else {
                return { x: NaN, y: NaN };
            }
        }
        resolve_as_xy(coord) {
            const value = this.resolve_coordinate(coord);
            return (0, types_1.isNumber)(value) ? { x: NaN, y: NaN } : value;
        }
        resolve_as_scalar(coord, dim) {
            const value = this.resolve_coordinate(coord);
            return (0, types_1.isNumber)(value) ? value : value[dim];
        }
    }
    exports.View = View;
    View.__name__ = "View";
},
/* models/coordinates/xy.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(58) /* ./coordinate */;
    class XY extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.XY = XY;
    _a = XY;
    XY.__name__ = "XY";
    (() => {
        _a.define(({ Float }) => ({
            x: [Float],
            y: [Float],
        }));
    })();
},
/* models/coordinates/indexed.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(58) /* ./coordinate */;
    class Indexed extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Indexed = Indexed;
    _a = Indexed;
    Indexed.__name__ = "Indexed";
    (() => {
        _a.define(({ Int, AnyRef }) => ({
            index: [Int],
            renderer: [AnyRef()],
        }));
    })();
},
/* core/view_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const build_views_1 = require(69) /* ./build_views */;
    class AbstractViewQuery {
        *all_views() {
            yield* this.query(() => true);
        }
        *query(fn) {
            const visited = new Set();
            function* descend(view) {
                if (visited.has(view)) {
                    return;
                }
                visited.add(view);
                if (fn(view)) {
                    yield view;
                }
                for (const child of view.children()) {
                    yield* descend(child);
                }
            }
            for (const view of this) {
                yield* descend(view);
            }
        }
        query_one(fn) {
            for (const view of this.query(fn)) {
                return view;
            }
            return null;
        }
        *find(model) {
            yield* this.query((view) => view.model == model);
        }
        *find_by_id(id) {
            yield* this.query((view) => view.model.id == id);
        }
        find_one(model) {
            for (const view of this.find(model)) {
                return view;
            }
            return null;
        }
        find_one_by_id(id) {
            for (const view of this.find_by_id(id)) {
                return view;
            }
            return null;
        }
        get_one(model) {
            const view = this.find_one(model);
            if (view != null) {
                return view;
            }
            else {
                throw new Error(`cannot find a view for ${model}`);
            }
        }
        get_one_by_id(id) {
            const view = this.find_one_by_id(id);
            if (view != null) {
                return view;
            }
            else {
                throw new Error(`cannot find a view for a model with '${id}' identity`);
            }
        }
        find_all(model) {
            return [...this.find(model)];
        }
        find_all_by_id(id) {
            return [...this.find_by_id(id)];
        }
        select(models) {
            return models.map((model) => this.find_one(model)).filter((view) => view != null);
        }
    }
    AbstractViewQuery.__name__ = "AbstractViewQuery";
    class ViewQuery extends AbstractViewQuery {
        constructor(view) {
            super();
            this.view = view;
        }
        *[Symbol.iterator]() {
            yield this.view;
        }
        toString() {
            return `ViewQuery(${this.view})`;
        }
    }
    exports.ViewQuery = ViewQuery;
    ViewQuery.__name__ = "ViewQuery";
    class ViewManager extends AbstractViewQuery {
        constructor(roots = [], global) {
            super();
            this.global = global;
            this._roots = new Set(roots);
        }
        toString() {
            const views = [...this._roots].map((view) => `${view}`).join(", ");
            return `ViewManager(${views})`;
        }
        async build_view(model, parent = null) {
            const view = await (0, build_views_1.build_view)(model, { owner: this, parent });
            if (parent == null) {
                this.add(view);
            }
            return view;
        }
        get(model) {
            for (const view of this._roots) {
                if (view.model == model) {
                    return view;
                }
            }
            return null;
        }
        get_by_id(id) {
            for (const view of this._roots) {
                if (view.model.id == id) {
                    return view;
                }
            }
            return null;
        }
        add(view) {
            this._roots.add(view);
            this.global?.add(view);
        }
        delete(view) {
            this._roots.delete(view);
            this.global?.delete(view);
        }
        remove(view) {
            this.delete(view);
        }
        clear() {
            for (const view of this) {
                view.remove();
            }
        }
        /* TODO (TS 5.2)
        [Symbol.dispose](): void {
          this.clear()
        }
        */
        get roots() {
            return [...this._roots];
        }
        *[Symbol.iterator]() {
            yield* this._roots;
        }
    }
    exports.ViewManager = ViewManager;
    ViewManager.__name__ = "ViewManager";
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.build_view = build_view;
    exports.build_views = build_views;
    exports.remove_views = remove_views;
    exports.traverse_views = traverse_views;
    const array_1 = require(10) /* ./util/array */;
    const assert_1 = require(12) /* ./util/assert */;
    async function _build_view(view_cls, model, options) {
        (0, assert_1.assert)(view_cls != null, "model doesn't implement a view");
        const view = new view_cls({ ...options, model });
        view.initialize();
        await view.lazy_initialize();
        return view;
    }
    async function build_view(model, options = { parent: null }, cls = (model) => model.default_view) {
        const view = await _build_view(cls(model), model, options);
        view.connect_signals();
        return view;
    }
    async function build_views(view_storage, models, options = { parent: null }, cls = (model) => model.default_view) {
        const to_remove = (0, array_1.difference)([...view_storage.keys()], models);
        const removed_views = [];
        for (const model of to_remove) {
            const view = view_storage.get(model);
            if (view != null) {
                view_storage.delete(model);
                removed_views.push(view);
                view.remove();
            }
        }
        const created_views = [];
        const new_models = models.filter((model) => !view_storage.has(model));
        for (const model of new_models) {
            const view = await _build_view(cls(model), model, options);
            view_storage.set(model, view);
            created_views.push(view);
        }
        for (const view of created_views) {
            view.connect_signals();
        }
        return {
            created: created_views,
            removed: removed_views,
        };
    }
    function remove_views(view_storage) {
        for (const [model, view] of view_storage) {
            view.remove();
            view_storage.delete(model);
        }
    }
    function traverse_views(views, fn) {
        const visited = new Set();
        const queue = [...views];
        while (true) {
            const view = queue.shift();
            if (view === undefined) {
                break;
            }
            if (visited.has(view)) {
                continue;
            }
            visited.add(view);
            queue.push(...view.children());
            fn(view);
        }
    }
},
/* styles/base.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:var(--bokeh-font-size, 12px);--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;--bokeh-top-level:10000;--color:#18191d;--background-color:#ffffff;--hover-color:#f9f9f9;--disabled-color:#808080;--border-color:#cccccc;--divider-color:#e5e5e5;--shortcut-color:#808080;--highlight-color:#26aae1;--active-bg:#c2d5f7;--active-fg:#3b80f0;--inactive-bg:#e5e5e5;--inactive-fg:#adadad;--icon-color:var(--bokeh-icon-color, #a1a6a9);--icon-color-disabled:var(--bokeh-icon-color-disabled, #d4d9db);--error:red;--inverted-color:#fff;--placeholder-color:#999;--surface-background-color:#e6e6e6;--disabled-background-color:#eee;--input-focus-border-color:#66afe9;--input-focus-halo-color:rgba(102, 175, 233, 0.6);--border-style:solid;--border-width:1px;--border:var(--border-color) var(--border-style) var(--border-width);--box-shadow-color:rgba(0, 0, 0, 0.175);--box-shadow-inset:inset 0 3px 5px rgba(0, 0, 0, 0.125);--box-shadow-x-symmetric:0 6px 12px var(--box-shadow-color);--box-shadow:2px 4px 8px var(--box-shadow-color);--divider-width:1px;--divider:1px var(--divider-color) solid;--outline-color:#ccc;--outline-style:dotted;--outline-width:1px;--outline:var(--outline-color) var(--outline-style) var(--outline-width);}:host{box-sizing:border-box;font-family:var(--base-font);font-size:var(--font-size);line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre,code,tt{font-family:var(--mono-font);margin:0;}`;
},
/* core/util/canvas.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_Exportable = is_Exportable;
    const svg_1 = require(72) /* ./svg */;
    const bbox_1 = require(62) /* ./bbox */;
    const dom_1 = require(61) /* ../dom */;
    const types_1 = require(8) /* ./types */;
    exports.exportable = Symbol("exportable");
    function is_Exportable(obj) {
        return (0, types_1.isObject)(obj) && exports.exportable in obj;
    }
    class CanvasLayer {
        get canvas() {
            return this._canvas;
        }
        get ctx() {
            return this._ctx;
        }
        get el() {
            return this._el;
        }
        get pixel_ratio() {
            return this._pixel_ratio;
        }
        constructor(backend, hidpi) {
            this._pixel_ratio = 1;
            this.bbox = new bbox_1.BBox();
            this.backend = backend;
            this.hidpi = hidpi;
            switch (backend) {
                case "webgl":
                case "canvas": {
                    this._el = this._canvas = (0, dom_1.canvas)({ class: "bk-layer" });
                    const ctx = this.canvas.getContext("2d");
                    if (ctx == null) {
                        throw new Error("unable to obtain 2D rendering context");
                    }
                    this._ctx = ctx;
                    if (hidpi) {
                        this._pixel_ratio = devicePixelRatio;
                    }
                    break;
                }
                case "svg": {
                    const ctx = new svg_1.SVGRenderingContext2D();
                    this._ctx = ctx;
                    this._canvas = ctx.get_svg();
                    this._el = (0, dom_1.div)({ class: "bk-layer" });
                    const shadow_el = this._el.attachShadow({ mode: "open" });
                    shadow_el.appendChild(this._canvas);
                    break;
                }
            }
            Object.assign(this._ctx, {
                layer: this,
                rect_bbox(bbox) {
                    const { x, y, width, height } = bbox;
                    this.rect(x, y, width, height);
                },
            });
        }
        get pixel_ratio_changed() {
            if (this.hidpi && (this.backend == "canvas" || this.backend == "webgl")) {
                return this.pixel_ratio != devicePixelRatio;
            }
            else {
                return false;
            }
        }
        resize(width, height) {
            const size_changed = this.bbox.width != width || this.bbox.height != height;
            const { pixel_ratio_changed } = this;
            if (!size_changed && !pixel_ratio_changed) {
                return;
            }
            if (pixel_ratio_changed) {
                this._pixel_ratio = devicePixelRatio;
            }
            this.bbox = new bbox_1.BBox({ left: 0, top: 0, width, height });
            const { target } = this;
            target.width = width * this.pixel_ratio;
            target.height = height * this.pixel_ratio;
        }
        get target() {
            return this._ctx instanceof svg_1.SVGRenderingContext2D ? this._ctx : this.canvas;
        }
        undo_transform(fn) {
            const { ctx } = this;
            const current_transform = ctx.getTransform();
            ctx.resetTransform();
            try {
                fn(ctx);
            }
            finally {
                ctx.setTransform(current_transform);
            }
        }
        prepare() {
            const { ctx, hidpi, pixel_ratio } = this;
            ctx.save();
            if (hidpi) {
                ctx.scale(pixel_ratio, pixel_ratio);
                ctx.translate(0.5, 0.5);
            }
            this.clear();
            return ctx;
        }
        clear() {
            const { x, y, width, height } = this.bbox;
            this.ctx.clearRect(x, y, width, height);
        }
        finish() {
            this.ctx.restore();
        }
        to_blob() {
            const { _canvas } = this;
            if (_canvas instanceof HTMLCanvasElement) {
                return new Promise((resolve, reject) => {
                    _canvas.toBlob((blob) => blob != null ? resolve(blob) : reject(), "image/png");
                });
            }
            else {
                const ctx = this._ctx;
                const svg = ctx.get_serialized_svg(true);
                const blob = new Blob([svg], { type: "image/svg+xml" });
                return Promise.resolve(blob);
            }
        }
    }
    exports.CanvasLayer = CanvasLayer;
    CanvasLayer.__name__ = "CanvasLayer";
},
/* core/util/svg.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    /**
     * Based on https://github.com/gliffy/canvas2svg
     */
    const affine_1 = require(73) /* ./affine */;
    const types_1 = require(8) /* ./types */;
    const color_1 = require(23) /* ./color */;
    const object_1 = require(9) /* ./object */;
    const random_1 = require(74) /* ./random */;
    const math_1 = require(11) /* ./math */;
    const dom_1 = require(61) /* ../dom */;
    // helper function to map named to numbered entities
    function createNamedToNumberedLookup(input, radix) {
        const lookup = new Map();
        const items = input.split(",");
        radix = radix ?? 10;
        // Map from named to numbered entities.
        for (let i = 0; i < items.length; i += 2) {
            const entity = `&${items[i + 1]};`;
            const base10 = parseInt(items[i], radix);
            lookup.set(entity, `&#${base10};`);
        }
        // FF and IE need to create a regex from hex values ie &nbsp; == \xa0
        lookup.set("\\xa0", "&#160;");
        return lookup;
    }
    // helper function to map canvas-textAlign to svg-textAnchor
    function getTextAnchor(textAlign) {
        // TODO: support rtl languages
        const mapping = { left: "start", right: "end", center: "middle", start: "start", end: "end" };
        return textAlign in mapping ? mapping[textAlign] : mapping.start;
    }
    // helper function to map canvas-textBaseline to svg-dominantBaseline
    function getDominantBaseline(textBaseline) {
        // INFO: not supported in all browsers
        const mapping = { alphabetic: "alphabetic", hanging: "hanging", top: "text-before-edge", bottom: "text-after-edge", middle: "central" };
        return textBaseline in mapping ? mapping[textBaseline] : mapping.alphabetic;
    }
    // Unpack entities lookup where the numbers are in radix 32 to reduce the size
    // entity mapping courtesy of tinymce
    const namedEntities = createNamedToNumberedLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy," +
        "5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute," +
        "5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34," +
        "5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil," +
        "68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde," +
        "6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute," +
        "6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml," +
        "75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc," +
        "7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash," +
        "7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta," +
        "sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu," +
        "st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi," +
        "t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota," +
        "tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau," +
        "u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip," +
        "81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym," +
        "8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr," +
        "8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod," +
        "8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup," +
        "8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4," +
        "nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob," +
        "rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0," +
        "Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm," +
        "80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger," +
        "811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro", 32);
    // Some basic mappings for attributes and default values.
    const STYLES = {
        strokeStyle: {
            svgAttr: "stroke", // corresponding svg attribute
            canvas: "#000000", // canvas default
            svg: "none", // svg default
            apply: "stroke", // apply on stroke() or fill()
        },
        fillStyle: {
            svgAttr: "fill",
            canvas: "#000000",
            svg: null, // svg default is black, but we need to special case this to handle canvas stroke without fill
            apply: "fill",
        },
        lineCap: {
            svgAttr: "stroke-linecap",
            canvas: "butt",
            svg: "butt",
            apply: "stroke",
        },
        lineJoin: {
            svgAttr: "stroke-linejoin",
            canvas: "miter",
            svg: "miter",
            apply: "stroke",
        },
        miterLimit: {
            svgAttr: "stroke-miterlimit",
            canvas: 10,
            svg: 4,
            apply: "stroke",
        },
        lineWidth: {
            svgAttr: "stroke-width",
            canvas: 1,
            svg: 1,
            apply: "stroke",
        },
        globalAlpha: {
            svgAttr: "opacity",
            canvas: 1,
            svg: 1,
            apply: "fill stroke",
        },
        shadowColor: {
            canvas: "#000000",
        },
        shadowOffsetX: {
            canvas: 0,
        },
        shadowOffsetY: {
            canvas: 0,
        },
        shadowBlur: {
            canvas: 0,
        },
        lineDash: {
            svgAttr: "stroke-dasharray",
            canvas: [],
            svg: null,
            apply: "stroke",
        },
        lineDashOffset: {
            svgAttr: "stroke-dashoffset",
            canvas: 0,
            svg: 0,
            apply: "stroke",
        },
        direction: {
            canvas: "inherit",
        },
        font: {
            // font converts to multiple svg attributes, there is custom logic for this
            canvas: "10px sans-serif",
        },
        fontKerning: {
            canvas: "auto",
        },
        fontStretch: {
            canvas: "normal",
        },
        fontVariantCaps: {
            canvas: "normal",
        },
        letterSpacing: {
            canvas: "0px",
        },
        textAlign: {
            canvas: "start",
        },
        textBaseline: {
            canvas: "alphabetic",
        },
        textRendering: {
            canvas: "auto",
        },
        wordSpacing: {
            canvas: "0px",
        },
    };
    function is_VideoFrame(image) {
        return typeof VideoFrame !== "undefined" && image instanceof VideoFrame;
    }
    function width_height(image) {
        if (is_VideoFrame(image)) {
            return [image.codedWidth, image.codedHeight]; // TODO not sure if this makes any sense
        }
        else {
            function to_number(val) {
                return (0, types_1.isNumber)(val) ? val : val.baseVal.value;
            }
            const { width, height } = image;
            return [to_number(width), to_number(height)];
        }
    }
    class CanvasGradient {
        constructor(gradientNode, ctx) {
            this.__root = gradientNode;
            this.__ctx = ctx;
        }
        /**
         * Adds a color stop to the gradient root
         */
        addColorStop(offset, color) {
            if (this.__root.nodeName === "linearGradient" &&
                this.__root.getAttribute("x1") === this.__root.getAttribute("x2") &&
                this.__root.getAttribute("y1") === this.__root.getAttribute("y2")) {
                return;
            }
            if (this.__root.nodeName === "radialGradient" &&
                this.__root.getAttribute("cx") === this.__root.getAttribute("fx") &&
                this.__root.getAttribute("cy") === this.__root.getAttribute("fy") &&
                this.__root.getAttribute("r") === this.__root.getAttribute("r0")) {
                return;
            }
            const stop = this.__ctx.__createElement("stop");
            stop.setAttribute("offset", `${offset}`);
            if (color.indexOf("rgba") !== -1) {
                // separate alpha value, since webkit can't handle it
                const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                const matches = regex.exec(color);
                const [, r, g, b, a] = matches;
                stop.setAttribute("stop-color", `rgb(${r},${g},${b})`);
                stop.setAttribute("stop-opacity", a);
            }
            else {
                stop.setAttribute("stop-color", color);
            }
            this.__root.appendChild(stop);
        }
    }
    CanvasGradient.__name__ = "CanvasGradient";
    class CanvasPattern {
        constructor(pattern, ctx) {
            this.__root = pattern;
            this.__ctx = ctx;
        }
        setTransform(_transform) {
            throw new Error("not implemented");
        }
    }
    CanvasPattern.__name__ = "CanvasPattern";
    class SVGRenderingContext2D {
        get canvas() {
            // XXX: point back to this instance
            return this;
        }
        get width() {
            return this._width;
        }
        set width(width) {
            this._width = width;
            this.__root.setAttribute("width", `${width}`);
        }
        get height() {
            return this._height;
        }
        set height(height) {
            this._height = height;
            this.__root.setAttribute("height", `${height}`);
        }
        constructor(options) {
            this.__currentDefaultPath = "";
            this.__currentPosition = null;
            this.globalAlpha = 1.0;
            this._transform = new affine_1.AffineTransform();
            this._clip_path = null;
            this.__document = options?.document ?? document;
            // allow passing in an existing context to wrap around
            // if a context is passed in, we know a canvas already exist
            if (options?.ctx != null) {
                this.__ctx = options.ctx;
            }
            else {
                this.__canvas = this.__document.createElement("canvas");
                this.__ctx = this.__canvas.getContext("2d");
            }
            this.reset();
            // the root svg element
            this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg");
            this.__root.setAttribute("version", "1.1");
            this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            this.__currentElement = this.__root;
            this.width = options?.width ?? 500;
            this.height = options?.height ?? 500;
            // make sure we don't generate the same ids in defs
            this.__ids = new Set();
            // defs tag
            this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs");
            this.__root.appendChild(this.__defs);
        }
        // helper function that generates a random string
        _random_string() {
            const chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
            let str;
            do {
                str = SVGRenderingContext2D.__random.choices(12, chars).join("");
            } while (this.__ids.has(str));
            return str;
        }
        /**
         * Creates the specified svg element
         */
        __createElement(elementName, properties = {}, resetFill = false) {
            const element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);
            if (resetFill) {
                // if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
                element.setAttribute("fill", "none");
                element.setAttribute("stroke", "none");
            }
            const keys = Object.keys(properties);
            for (const key of keys) {
                element.setAttribute(key, `${properties[key]}`);
            }
            return element;
        }
        /**
         * Applies default canvas styles to the context
         */
        __setDefaultStyles() {
            // default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
            for (const [key, val] of (0, object_1.typed_entries)(STYLES)) {
                this[key] = val.canvas;
            }
        }
        /**
         * Applies styles on restore
         */
        __applyStyleState(style_state) {
            for (const [key, val] of (0, object_1.typed_entries)(style_state)) {
                this[key] = val;
            }
        }
        /**
         * Gets the current style state
         */
        __getStyleState() {
            const style_state = {};
            for (const [key, _val] of (0, object_1.typed_entries)(STYLES)) {
                style_state[key] = this[key];
            }
            return style_state;
        }
        /**
         * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
         */
        __applyStyleToCurrentElement(type) {
            const currentElement = this.__currentElement;
            /*
            const currentStyleGroup = this.__currentElementsToStyle
            if (currentStyleGroup != null) {
              currentElement.setAttribute(type, "")
              currentElement = currentStyleGroup.element
              for (const node of currentStyleGroup.children) {
                node.setAttribute(type, "")
              }
            }
            */
            for (const [key, style] of (0, object_1.typed_entries)(STYLES)) {
                const value = this[key];
                if (style.apply != null && style.apply.includes(type)) {
                    if (value instanceof CanvasPattern) {
                        for (const def of [...value.__ctx.__defs.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids.add(id);
                                this.__defs.appendChild(def);
                            }
                        }
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (value instanceof CanvasGradient) {
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (style.svg !== value) {
                        if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && (0, types_1.isString)(value) && value.indexOf("rgb") !== -1) {
                            // convert CSS4 -> CSS3 and separate alpha value, since illustrator can't handle it
                            const [r, g, b, a] = (0, color_1.css4_parse)(value) ?? (0, color_1.transparent)();
                            const opacity = a * this.globalAlpha;
                            currentElement.setAttribute(style.svgAttr, `rgb(${r},${g},${b})`);
                            currentElement.setAttribute(`${style.svgAttr}-opacity`, `${opacity}`);
                        }
                        else {
                            let attr = style.svgAttr;
                            if (key === "globalAlpha") {
                                attr = `${type}-${style.svgAttr}`;
                                if (currentElement.getAttribute(attr) != null) {
                                    // fill-opacity or stroke-opacity has already been set by stroke or fill.
                                    continue;
                                }
                            }
                            // otherwise only update attribute if right type, and not svg default
                            currentElement.setAttribute(attr, `${value}`);
                        }
                    }
                }
            }
        }
        /**
          * Returns the serialized value of the svg so far
          * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
          *                           If true, we attempt to find all named entities and encode it as a numeric entity.
          * @return serialized svg
          */
        get_serialized_svg(fixNamedEntities = false) {
            let serialized = new XMLSerializer().serializeToString(this.__root);
            if (fixNamedEntities) {
                // loop over each named entity and replace with the proper equivalent.
                for (const [key, value] of namedEntities) {
                    const regexp = new RegExp(key, "gi");
                    if (regexp.test(serialized)) {
                        serialized = serialized.replace(regexp, value);
                    }
                }
            }
            return serialized;
        }
        get_svg() {
            return this.__root;
        }
        /**
          * Will generate a group tag.
          */
        save() {
            this.__stack.push({
                transform: this._transform,
                clip_path: this._clip_path,
                attributes: this.__getStyleState(),
            });
            this._transform = this._transform.clone();
        }
        /**
          * Sets current element to parent, or just root if already root
          */
        restore() {
            if (this.__stack.length == 0) {
                return;
            }
            const { transform, clip_path, attributes } = this.__stack.pop();
            this._transform = transform;
            this._clip_path = clip_path;
            this.__applyStyleState(attributes);
        }
        isContextLost() {
            return false;
        }
        reset() {
            this.__setDefaultStyles();
            this.__stack = [];
        }
        _apply_transform(element, transform = this._transform) {
            if (!transform.is_identity) {
                element.setAttribute("transform", transform.toString());
            }
        }
        _apply_global_alpha(element) {
            if (this.globalAlpha != 1.0) {
                element.setAttribute("opacity", `${this.globalAlpha}`);
            }
        }
        _apply_clip_path(element) {
            if (this._clip_path != null) {
                element.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          *  scales the current element
          */
        scale(x, y) {
            if (!isFinite(x) || (y != null && !isFinite(y))) {
                return;
            }
            this._transform.scale(x, y ?? x);
        }
        /**
          * rotates the current element
          */
        rotate(angle) {
            if (!isFinite(angle)) {
                return;
            }
            this._transform.rotate(angle);
        }
        /**
          * translates the current element
          */
        translate(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this._transform.translate(x, y);
        }
        /**
          * applies a transform to the current element
          */
        transform(a, b, c, d, e, f) {
            if (!isFinite(a + b + c + d + e + f)) {
                return;
            }
            this._transform.transform(a, b, c, d, e, f);
        }
        /**
          * Create a new Path Element
          */
        beginPath() {
            // Note that there is only one current default path, it is not part of the drawing state.
            // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path
            this.__currentDefaultPath = "";
            this.__currentPosition = null;
            this.__init_element();
        }
        __init_element() {
            const path = this.__createElement("path", {}, true);
            this.__root.appendChild(path);
            this.__currentElement = path;
        }
        /**
          * Helper function to apply currentDefaultPath to current path element
          */
        __applyCurrentDefaultPath() {
            const currentElement = this.__currentElement;
            if (currentElement.nodeName === "path") {
                currentElement.setAttribute("d", this.__currentDefaultPath);
            }
            else {
                console.error("Attempted to apply path command to node", currentElement.nodeName);
            }
        }
        /**
          * Helper function to add path command
          */
        __addPathCommand(x, y, path) {
            const separator = this.__currentDefaultPath == "" ? "" : " ";
            this.__currentDefaultPath += separator + path;
            this.__currentPosition = { x, y };
        }
        get _hasCurrentDefaultPath() {
            return this.__currentDefaultPath != "";
        }
        /**
          * Adds the move command to the current path element,
          * if the currentPathElement is not empty create a new path element
          */
        moveTo(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            const currentElement = this.__currentElement;
            if (currentElement.nodeName !== "path") {
                this.beginPath();
            }
            // creates a new subpath with the given point
            const [tx, ty] = this._transform.apply(x, y);
            this.__addPathCommand(tx, ty, `M ${tx} ${ty}`);
        }
        /**
          * Closes the current path
          */
        closePath() {
            if (this._hasCurrentDefaultPath) {
                this.__addPathCommand(NaN, NaN, "Z");
            }
        }
        /**
          * Adds a line to command
          */
        lineTo(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            if (!this._hasCurrentDefaultPath) {
                this.moveTo(x, y);
            }
            else {
                const [tx, ty] = this._transform.apply(x, y);
                this.__addPathCommand(tx, ty, `L ${tx} ${ty}`);
            }
        }
        /**
          * Add a bezier command
          */
        bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
            if (!isFinite(cp1x + cp1y + cp2x + cp2y + x + y)) {
                return;
            }
            const [tx, ty] = this._transform.apply(x, y);
            const [tcp1x, tcp1y] = this._transform.apply(cp1x, cp1y);
            const [tcp2x, tcp2y] = this._transform.apply(cp2x, cp2y);
            this.__addPathCommand(tx, ty, `C ${tcp1x} ${tcp1y} ${tcp2x} ${tcp2y} ${tx} ${ty}`);
        }
        /**
          * Adds a quadratic curve to command
          */
        quadraticCurveTo(cpx, cpy, x, y) {
            if (!isFinite(cpx + cpy + x + y)) {
                return;
            }
            const [tx, ty] = this._transform.apply(x, y);
            const [tcpx, tcpy] = this._transform.apply(cpx, cpy);
            this.__addPathCommand(tx, ty, `Q ${tcpx} ${tcpy} ${tx} ${ty}`);
        }
        /**
          * Adds the arcTo to the current path
          *
          * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
          */
        arcTo(x1, y1, x2, y2, radius) {
            if (!isFinite(x1 + y1 + x2 + y2 + radius)) {
                return;
            }
            // Let the point (x0, y0) be the last point in the subpath.
            if (this.__currentPosition == null) {
                return;
            }
            // Issue #12699.
            // this.__currentPosition has already been transformed using this._transform.
            // Arguments to this function have not been transformed, so to compare the two need
            // to inverse transform this.__currentPosition.
            const inverse = this._transform.inverse();
            const [x0, y0] = inverse.apply(this.__currentPosition.x, this.__currentPosition.y);
            // Negative values for radius must cause the implementation to throw an IndexSizeError exception.
            if (radius < 0) {
                throw new Error(`IndexSizeError: The radius provided (${radius}) is negative.`);
            }
            // If the point (x0, y0) is equal to the point (x1, y1),
            // or if the point (x1, y1) is equal to the point (x2, y2),
            // or if the radius radius is zero,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            if (((x0 === x1) && (y0 === y1)) || ((x1 === x2) && (y1 === y2)) || (radius === 0)) {
                this.lineTo(x1, y1);
                return;
            }
            function normalize([x, y]) {
                const len = Math.sqrt(x ** 2 + y ** 2);
                return [x / len, y / len];
            }
            // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            const unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
            const unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);
            if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
                this.lineTo(x1, y1);
                return;
            }
            // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
            // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
            // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
            // The points at which this circle touches these two lines are called the start and end tangent points respectively.
            // note that both vectors are unit vectors, so the length is 1
            const cos = (unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1]);
            const theta = Math.acos(Math.abs(cos));
            // Calculate origin
            const unit_vec_p1_origin = normalize([
                unit_vec_p1_p0[0] + unit_vec_p1_p2[0],
                unit_vec_p1_p0[1] + unit_vec_p1_p2[1],
            ]);
            const len_p1_origin = radius / Math.sin(theta / 2);
            const x = x1 + len_p1_origin * unit_vec_p1_origin[0];
            const y = y1 + len_p1_origin * unit_vec_p1_origin[1];
            // Calculate start angle and end angle
            // rotate 90deg clockwise (note that y axis points to its down)
            const unit_vec_origin_start_tangent = [
                -unit_vec_p1_p0[1],
                unit_vec_p1_p0[0],
            ];
            // rotate 90deg counter clockwise (note that y axis points to its down)
            const unit_vec_origin_end_tangent = [
                unit_vec_p1_p2[1],
                -unit_vec_p1_p2[0],
            ];
            function getAngle(vector) {
                // get angle (clockwise) between vector and (1, 0)
                const x = vector[0];
                const y = vector[1];
                if (y >= 0) { // note that y axis points to its down
                    return Math.acos(x);
                }
                else {
                    return -Math.acos(x);
                }
            }
            const startAngle = getAngle(unit_vec_origin_start_tangent);
            const endAngle = getAngle(unit_vec_origin_end_tangent);
            // Connect the point (x0, y0) to the start tangent point by a straight line
            this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius);
            // Connect the start tangent point to the end tangent point by arc
            // and adding the end tangent point to the subpath.
            this.arc(x, y, radius, startAngle, endAngle);
        }
        /**
          * Sets the stroke property on the current element
          */
        stroke() {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "fill");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("stroke");
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        fill(path_or_fill_rule, fill_rule) {
            let path = null;
            if (path_or_fill_rule instanceof Path2D) {
                path = path_or_fill_rule;
            }
            else if (fill_rule == null) {
                fill_rule = path_or_fill_rule;
            }
            else {
                throw new Error("invalid arguments");
            }
            if (path != null) {
                throw new Error("not implemented");
            }
            // XXX: hack (?) to allow fill and hatch visuals on same canvas path
            if (this.__currentElement.getAttribute("fill") != "none") {
                this.__init_element();
            }
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "stroke");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("fill");
            if (fill_rule != null && fill_rule != "nonzero") { // don't apply the default
                this.__currentElement.setAttribute("fill-rule", fill_rule);
            }
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          *  Adds a rectangle to the path.
          */
        rect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.moveTo(x, y);
            this.lineTo(x + width, y);
            this.lineTo(x + width, y + height);
            this.lineTo(x, y + height);
            this.lineTo(x, y);
            this.closePath();
        }
        /**
          * adds a rectangle element
          */
        fillRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.beginPath();
            this.rect(x, y, width, height);
            this.fill();
        }
        /**
          * Draws a rectangle with no fill
          * @param x
          * @param y
          * @param width
          * @param height
          */
        strokeRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.beginPath();
            this.rect(x, y, width, height);
            this.stroke();
        }
        /**
          * Clear entire canvas:
          * 1. save current transforms
          * 2. remove all the childNodes of the root g element
          */
        __clearCanvas() {
            (0, dom_1.empty)(this.__defs);
            (0, dom_1.empty)(this.__root);
            this.__root.appendChild(this.__defs);
            this.__currentElement = this.__root;
        }
        /**
          * "Clears" a canvas by just drawing a white rectangle in the current group.
          */
        clearRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            if (x === 0 && y === 0 && width === this.width && height === this.height) {
                this.__clearCanvas();
                return;
            }
            const rect = this.__createElement("rect", { x, y, width, height, fill: "#FFFFFF" }, true);
            this._apply_transform(rect);
            this.__root.appendChild(rect);
        }
        roundRect(_x, _y, _w, _h, _radii) {
            throw new Error("not implemented");
        }
        /**
          * Adds a linear gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createLinearGradient(x1, y1, x2, y2) {
            if (!isFinite(x1 + y1 + x2 + y2)) {
                throw new Error("The provided double value is non-finite");
            }
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const [tx2, ty2] = this._transform.apply(x2, y2);
            const grad = this.__createElement("linearGradient", {
                id: this._random_string(),
                x1: `${tx1}px`,
                x2: `${tx2}px`,
                y1: `${ty1}px`,
                y2: `${ty2}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        /**
          * Adds a radial gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createRadialGradient(x0, y0, r0, x1, y1, r1) {
            if (!isFinite(x0 + y0 + r0 + x1 + y1 + r1)) {
                throw new Error("The provided double value is non-finite");
            }
            const [tx0, ty0] = this._transform.apply(x0, y0);
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const grad = this.__createElement("radialGradient", {
                id: this._random_string(),
                cx: `${tx1}px`,
                cy: `${ty1}px`,
                r: `${r1}px`,
                r0: `${r0}px`,
                fx: `${tx0}px`,
                fy: `${ty0}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        createConicGradient(_start_angle, _x, _y) {
            throw Error("not implemented");
        }
        /**
          * Parses the font string and returns svg mapping
          */
        __parseFont() {
            const regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
            const [, style, decoration, weight, size, , family] = regex.exec(this.font); // XXX: RegExpExecArray is incorrecdt
            const data = {
                style: style ?? "normal",
                size: size ?? "10px",
                family: family ?? "sans-serif",
                weight: weight ?? "normal",
                decoration: decoration ?? "normal",
            };
            return data;
        }
        /**
          * Fills or strokes text
          */
        __applyText(text, x, y, action) {
            const font = this.__parseFont();
            const text_el = this.__createElement("text", {
                "font-family": font.family,
                "font-size": font.size,
                "font-style": font.style,
                "font-weight": font.weight,
                "text-decoration": font.decoration,
                x,
                y,
                "text-anchor": getTextAnchor(this.textAlign),
                "dominant-baseline": getDominantBaseline(this.textBaseline),
            }, true);
            text_el.appendChild(this.__document.createTextNode(text));
            this._apply_transform(text_el);
            this.__currentElement = text_el;
            this.__applyStyleToCurrentElement(action);
            const el = (() => {
                if (this._clip_path != null) {
                    const g = this.__createElement("g");
                    g.setAttribute("clip-path", this._clip_path);
                    g.appendChild(text_el);
                    return g;
                }
                else {
                    return text_el;
                }
            })();
            this.__root.appendChild(el);
        }
        /**
          * Creates a text element, in position x,y
          */
        fillText(text, x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this.__applyText(text, x, y, "fill");
        }
        /**
          * Strokes text
          */
        strokeText(text, x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this.__applyText(text, x, y, "stroke");
        }
        /**
          * No need to implement this for svg.
          */
        measureText(text) {
            this.__ctx.font = this.font;
            return this.__ctx.measureText(text);
        }
        arc(x, y, radius, start_angle, end_angle, counterclockwise = false) {
            this.ellipse(x, y, radius, radius, 0, start_angle, end_angle, counterclockwise);
        }
        ellipse(x, y, radius_x, radius_y, rotation, start_angle, end_angle, counterclockwise = false) {
            if (!isFinite(x + y + radius_x + radius_y + rotation + start_angle + end_angle)) {
                return;
            }
            if (radius_x < 0 || radius_y < 0) {
                throw new DOMException("IndexSizeError, radius can't be negative");
            }
            const initial_diff = counterclockwise ? end_angle - start_angle : start_angle - end_angle;
            start_angle = start_angle % (2 * Math.PI);
            end_angle = end_angle % (2 * Math.PI);
            const transform = new affine_1.AffineTransform().translate(x, y).rotate(rotation);
            const dx = radius_x * Math.cos(start_angle);
            const dy = radius_y * Math.sin(start_angle);
            const [start_x, start_y] = transform.apply(dx, dy);
            this.lineTo(start_x, start_y);
            // Canvas ellipse defines rotation in radians and SVG elliptical arc is defined in degrees
            const rotation_in_degrees = rotation * 180 / Math.PI;
            const sweep_flag = counterclockwise ? 0 : 1;
            /**
             * Check if need to draw full ellipse (issue #11475). When testing if angular difference is
             * equal to an integer multiple of 2*pi radians, need to account for float64 to float32 rounding
             * error on both the start and end angles, hence the factor of 2. Do not assume full circle if
             * start and end angles are close, but test here depends on combination of sign of angular
             * difference and wedge direction (clockwise/counterclockwise) to obtain the same results as on
             * canvas.
             */
            if (Math.abs(start_angle - end_angle) < 2 * math_1.float32_epsilon &&
                !(Math.abs(initial_diff) < 2 * math_1.float32_epsilon && initial_diff < 0)) {
                // Draw full ellipse. SVG elliptical arc cannot do this, so instead use two semi ellipses.
                const [tstart_x, tstart_y] = this._transform.apply(start_x, start_y);
                const dx = radius_x * Math.cos(start_angle + Math.PI);
                const dy = radius_y * Math.sin(start_angle + Math.PI);
                const [mid_x, mid_y] = transform.apply(dx, dy);
                const [tmid_x, tmid_y] = this._transform.apply(mid_x, mid_y);
                this.__addPathCommand(tstart_x, tstart_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tmid_x} ${tmid_y} A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tstart_x} ${tstart_y}`);
            }
            else {
                // Draw partial ellipse only.
                const dx = radius_x * Math.cos(end_angle);
                const dy = radius_y * Math.sin(end_angle);
                const [end_x, end_y] = transform.apply(dx, dy);
                let diff = end_angle - start_angle;
                // https://github.com/gliffy/canvas2svg/issues/4
                if (diff < 0) {
                    diff += 2 * Math.PI;
                }
                const large_arc_flag = (counterclockwise !== diff > Math.PI) ? 1 : 0; // imitation xor
                const [tend_x, tend_y] = this._transform.apply(end_x, end_y);
                this.__addPathCommand(tend_x, tend_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} ${large_arc_flag} ${sweep_flag} ${tend_x} ${tend_y}`);
            }
        }
        clip(path_or_fill_rule, fill_rule) {
            let path = null;
            if (path_or_fill_rule instanceof Path2D) {
                path = path_or_fill_rule;
            }
            else if (fill_rule == null) {
                fill_rule = path_or_fill_rule;
            }
            else {
                throw new Error("invalid arguments");
            }
            if (path != null) {
                throw new Error("not implemented");
            }
            const clip_path = this.__createElement("clipPath");
            const id = this._random_string();
            this.__applyCurrentDefaultPath();
            if (fill_rule != null) {
                this.__currentElement.setAttribute("clip-rule", fill_rule);
            }
            clip_path.setAttribute("id", id);
            clip_path.appendChild(this.__currentElement);
            this.__defs.appendChild(clip_path);
            this._clip_path = `url(#${id})`;
        }
        /**
          * Draws a canvas, image or mock context to this canvas.
          * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
          * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
          */
        drawImage(image, ...args) {
            let dx, dy;
            let dw, dh;
            let sx, sy;
            let sw, sh;
            if (args.length == 2) {
                [dx, dy] = args;
                if (!isFinite(dx + dy)) {
                    return;
                }
                sx = 0;
                sy = 0;
                const [w, h] = width_height(image);
                dw = sw = w;
                dh = sh = h;
            }
            else if (args.length == 4) {
                [dx, dy, dw, dh] = args;
                if (!isFinite(dx + dy + dw + dh)) {
                    return;
                }
                sx = 0;
                sy = 0;
                const [w, h] = width_height(image);
                sw = w;
                sh = h;
            }
            else if (args.length === 8) {
                [sx, sy, sw, sh, dx, dy, dw, dh] = args;
                if (!isFinite(sx + sy + sw + sh + dx + dy + dw + dh)) {
                    return;
                }
            }
            else {
                throw new Error(`Invalid number of arguments passed to drawImage: ${arguments.length}`);
            }
            // parent, svg, defs, group, currentElement, svgImage, canvas, context, id
            const parent = this.__root;
            const transform = this._transform.clone().translate(dx, dy);
            if (image instanceof SVGRenderingContext2D || image instanceof SVGSVGElement) {
                // In the future we may want to clone nodes instead.
                // also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
                const svg_node = image instanceof SVGSVGElement ? image : image.get_svg();
                const svg = svg_node.cloneNode(true);
                let scope;
                if (transform.is_identity && this.globalAlpha == 1.0 && this._clip_path == null) {
                    scope = parent;
                }
                else {
                    scope = this.__createElement("g");
                    parent.appendChild(scope);
                    // `transform` affects `clip-path`, so if both are present, then apply
                    // them separately in `clip-path`, `transform` order.
                    if (this._clip_path != null) {
                        this._apply_clip_path(scope);
                        if (!transform.is_identity) {
                            const outer = scope;
                            scope = this.__createElement("g");
                            outer.appendChild(scope);
                        }
                    }
                    this._apply_transform(scope, transform);
                    this._apply_global_alpha(scope);
                }
                for (const child of [...svg.childNodes]) {
                    if (child instanceof SVGDefsElement) {
                        for (const def of [...child.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids.add(id);
                                this.__defs.appendChild(def.cloneNode(true));
                            }
                        }
                    }
                    else {
                        scope.appendChild(child.cloneNode(true));
                    }
                }
            }
            else if (image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (this.globalAlpha != 1.0) {
                    svgImage.setAttribute("opacity", `${this.globalAlpha}`);
                }
                if (sx != 0 || sy != 0 || sw !== image.width || sh !== image.height) {
                    // crop the image using a temporary canvas
                    const canvas = this.__document.createElement("canvas");
                    canvas.width = dw;
                    canvas.height = dh;
                    const context = canvas.getContext("2d");
                    context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                    image = canvas;
                }
                this._apply_transform(svgImage, transform);
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                svgImage.setAttribute("href", url);
                if (this._clip_path != null) {
                    const scope = this.__createElement("g");
                    scope.setAttribute("clip-path", this._clip_path);
                    scope.appendChild(svgImage);
                    parent.appendChild(scope);
                }
                else {
                    parent.appendChild(svgImage);
                }
            }
            else if (image instanceof HTMLCanvasElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (this.globalAlpha != 1.0) {
                    svgImage.setAttribute("opacity", `${this.globalAlpha}`);
                }
                // draw canvas onto temporary canvas so that smoothing can be handled
                const canvas = this.__document.createElement("canvas");
                canvas.width = dw;
                canvas.height = dh;
                const context = canvas.getContext("2d");
                context.imageSmoothingEnabled = false;
                context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                image = canvas;
                this._apply_transform(svgImage, transform);
                svgImage.setAttribute("href", image.toDataURL());
                if (this._clip_path != null) {
                    const scope = this.__createElement("g");
                    scope.setAttribute("clip-path", this._clip_path);
                    scope.appendChild(svgImage);
                    parent.appendChild(scope);
                }
                else {
                    parent.appendChild(svgImage);
                }
            }
        }
        /**
          * Generates a pattern tag
          */
        createPattern(image, _repetition) {
            const pattern = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern");
            const id = this._random_string();
            const [width, height] = width_height(image);
            pattern.setAttribute("id", id);
            pattern.setAttribute("width", `${width}`);
            pattern.setAttribute("height", `${height}`);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            if (image instanceof HTMLCanvasElement || image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const img = this.__document.createElementNS("http://www.w3.org/2000/svg", "image");
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                img.setAttribute("href", url);
                pattern.appendChild(img);
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGRenderingContext2D) {
                for (const child of [...image.__root.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child.cloneNode(true));
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGSVGElement) {
                for (const child of [...image.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child.cloneNode(true));
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else {
                throw new Error("unsupported");
            }
            return new CanvasPattern(pattern, this);
        }
        getLineDash() {
            const { lineDash } = this;
            if ((0, types_1.isString)(lineDash)) {
                return lineDash.split(",").map((v) => parseInt(v));
            }
            else if (lineDash == null) {
                return [];
            }
            else {
                return lineDash;
            }
        }
        setLineDash(segments) {
            if (segments.length > 0) {
                this.lineDash = segments.join(",");
            }
            else {
                this.lineDash = null;
            }
        }
        getTransform() {
            return this._transform.to_DOMMatrix();
        }
        setTransform(...args) {
            let matrix;
            if ((0, types_1.isNumber)(args[0])) {
                matrix = new DOMMatrix(args);
            }
            else if (args[0] instanceof DOMMatrix) {
                matrix = args[0];
            }
            else {
                matrix = new DOMMatrix(Object.values(args[0] == null));
            }
            this._transform = affine_1.AffineTransform.from_DOMMatrix(matrix);
        }
        resetTransform() {
            this._transform = new affine_1.AffineTransform();
        }
        isPointInPath(..._args) {
            throw new Error("not implemented");
        }
        isPointInStroke(..._args) {
            throw new Error("not implemented");
        }
        createImageData(..._args) {
            throw new Error("not implemented");
        }
        getImageData(_sx, _sy, _sw, _sh) {
            throw new Error("not implemented");
        }
        putImageData(..._args) {
            throw new Error("not implemented");
        }
        drawFocusIfNeeded(..._args) {
            throw new Error("not implemented");
        }
        scrollPathIntoView(..._args) {
            throw new Error("not implemented");
        }
    }
    exports.SVGRenderingContext2D = SVGRenderingContext2D;
    SVGRenderingContext2D.__name__ = "SVGRenderingContext2D";
    //__currentElementsToStyle: {element: SVGElement, children: SVGElement[]} | null = null
    SVGRenderingContext2D.__random = random_1.random;
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.rotate_around = rotate_around;
    const eq_1 = require(27) /* ./eq */;
    const { sin, cos } = Math;
    class AffineTransform {
        constructor(a = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        toString() {
            const { a, b, c, d, e, f } = this;
            return `matrix(${a}, ${b}, ${c}, ${d}, ${e}, ${f})`;
        }
        static from_DOMMatrix(matrix) {
            const { a, b, c, d, e, f } = matrix;
            return new AffineTransform(a, b, c, d, e, f);
        }
        to_DOMMatrix() {
            const { a, b, c, d, e, f } = this;
            return new DOMMatrix([a, b, c, d, e, f]);
        }
        clone() {
            const { a, b, c, d, e, f } = this;
            return new AffineTransform(a, b, c, d, e, f);
        }
        [eq_1.equals](that, cmp) {
            return (cmp.eq(this.a, that.a) &&
                cmp.eq(this.b, that.b) &&
                cmp.eq(this.c, that.c) &&
                cmp.eq(this.d, that.d) &&
                cmp.eq(this.e, that.e) &&
                cmp.eq(this.f, that.f));
        }
        reset() {
            this.a = 1;
            this.b = 0;
            this.c = 0;
            this.d = 1;
            this.e = 0;
            this.f = 0;
        }
        get is_identity() {
            const { a, b, c, d, e, f } = this;
            return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
        }
        apply_point(p) {
            const [x, y] = this.apply(p.x, p.y);
            return { x, y };
        }
        apply_rect(rect) {
            const p0 = this.apply_point(rect.p0);
            const p1 = this.apply_point(rect.p1);
            const p2 = this.apply_point(rect.p2);
            const p3 = this.apply_point(rect.p3);
            return { p0, p1, p2, p3 };
        }
        apply(x, y) {
            const { a, b, c, d, e, f } = this;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        }
        iv_apply(xs, ys) {
            const { a, b, c, d, e, f } = this;
            const n = xs.length;
            for (let i = 0; i < n; i++) {
                const x = xs[i];
                const y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        }
        transform(A, B, C, D, E, F) {
            const { a, b, c, d, e, f } = this;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        }
        translate(tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        }
        scale(cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        }
        skew(sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        }
        rotate(angle) {
            if (angle == 0) {
                return this;
            }
            const s = sin(angle);
            const c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        }
        rotate_ccw(angle) {
            return this.rotate(-angle);
        }
        rotate_around(x, y, angle) {
            this.translate(x, y);
            this.rotate(angle);
            this.translate(-x, -y);
            return this;
        }
        translate_x(tx) {
            return this.translate(tx, 0);
        }
        translate_y(ty) {
            return this.translate(0, ty);
        }
        flip() {
            return this.scale(-1, -1);
        }
        flip_x() {
            return this.scale(1, -1);
        }
        flip_y() {
            return this.scale(-1, 1);
        }
        inverse() {
            return AffineTransform.from_DOMMatrix(this.to_DOMMatrix().inverse());
        }
    }
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
    function rotate_around(point, center, angle) {
        if (angle == 0) {
            return point;
        }
        else {
            const tr = new AffineTransform();
            tr.rotate_around(center.x, center.y, angle);
            const [x, y] = tr.apply(point.x, point.y);
            return { x, y };
        }
    }
},
/* core/util/random.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { PI, log, sin, cos, sqrt, floor } = Math;
    exports.MAX_INT32 = 2147483647;
    class AbstractRandom {
        float() {
            return (this.integer() - 1) / (exports.MAX_INT32 - 1);
        }
        floats(n, a = 0, b = 1) {
            const result = new Array(n);
            for (let i = 0; i < n; i++) {
                result[i] = a + this.float() * (b - a);
            }
            return result;
        }
        choices(n, items) {
            const k = items.length;
            const result = new Array(n);
            for (let i = 0; i < n; i++) {
                result[i] = items[this.integer() % k];
            }
            return result;
        }
        uniform(loc, scale) {
            return loc + (this.float() - 0.5) * scale;
        }
        uniforms(loc, scale, size) {
            return Float64Array.from({ length: size }, () => this.uniform(loc, scale));
        }
        normal(loc, scale) {
            return this.normals(loc, scale, 1)[0];
        }
        normals(loc, scale, size) {
            const [mu, sigma] = [loc, scale];
            const array = new Float64Array(size);
            for (let i = 0; i < size; i += 2) {
                // Box-Muller transform from uniform to normal distribution.
                const u = this.float();
                const v = this.float();
                const common = sqrt(-2.0 * log(u));
                array[i] = mu + sigma * (common * cos(2.0 * PI * v));
                if (i + 1 < size) {
                    array[i + 1] = mu + sigma * (common * sin(2.0 * PI * v));
                }
            }
            return array;
        }
    }
    exports.AbstractRandom = AbstractRandom;
    AbstractRandom.__name__ = "AbstractRandom";
    class SystemRandom extends AbstractRandom {
        integer() {
            return floor(Math.random() * exports.MAX_INT32);
        }
    }
    exports.SystemRandom = SystemRandom;
    SystemRandom.__name__ = "SystemRandom";
    // Park-Miller LCG
    class LCGRandom extends AbstractRandom {
        constructor(seed) {
            super();
            this._seed = seed % exports.MAX_INT32;
            if (this._seed <= 0) {
                this._seed += exports.MAX_INT32 - 1;
            }
        }
        integer() {
            this._seed = (48271 * this._seed) % exports.MAX_INT32;
            return this._seed;
        }
    }
    exports.LCGRandom = LCGRandom;
    LCGRandom.__name__ = "LCGRandom";
    class Random extends LCGRandom {
    } // for compatibility
    exports.Random = Random;
    Random.__name__ = "Random";
    exports.random = new Random(Date.now());
},
/* styles/ui.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{position:relative;pointer-events:auto;}`;
},
/* styles/icons.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.tool_icon_dark_theme = exports.tool_icon_light_theme = exports.tool_icon_list = exports.tool_icon_square_check = exports.tool_icon_square = exports.tool_icon_check = exports.tool_icon_text_align_right = exports.tool_icon_text_align_center = exports.tool_icon_text_align_left = exports.tool_icon_italic = exports.tool_icon_bold = exports.tool_icon_delete = exports.tool_icon_pointer = exports.tool_icon_unpin = exports.tool_icon_pin = exports.tool_icon_maximize = exports.tool_icon_minimize = exports.tool_icon_arrow_up_from_bar = exports.tool_icon_arrow_down_to_bar = exports.tool_icon_y_grip = exports.tool_icon_x_grip = exports.tool_icon_see_off = exports.tool_icon_see_on = exports.tool_icon_caret_right = exports.tool_icon_caret_left = exports.tool_icon_caret_down = exports.tool_icon_caret_up = exports.tool_icon_chevron_right = exports.tool_icon_chevron_left = void 0;
    exports.tool_icon_copy = "bk-tool-icon-copy";
    exports.tool_icon_open = "bk-tool-icon-open";
    exports.tool_icon_replace_mode = "bk-tool-icon-replace-mode";
    exports.tool_icon_toggle_mode = "bk-tool-icon-toggle-mode";
    exports.tool_icon_append_mode = "bk-tool-icon-append-mode";
    exports.tool_icon_intersect_mode = "bk-tool-icon-intersect-mode";
    exports.tool_icon_subtract_mode = "bk-tool-icon-subtract-mode";
    exports.tool_icon_xor_mode = "bk-tool-icon-xor-mode";
    exports.tool_icon_invert_selection = "bk-tool-icon-invert-selection";
    exports.tool_icon_clear_selection = "bk-tool-icon-clear-selection";
    exports.tool_icon_box_select = "bk-tool-icon-box-select";
    exports.tool_icon_x_box_select = "bk-tool-icon-x-box-select";
    exports.tool_icon_y_box_select = "bk-tool-icon-y-box-select";
    exports.tool_icon_box_zoom = "bk-tool-icon-box-zoom";
    exports.tool_icon_x_box_zoom = "bk-tool-icon-x-box-zoom";
    exports.tool_icon_y_box_zoom = "bk-tool-icon-y-box-zoom";
    exports.tool_icon_auto_box_zoom = "bk-tool-icon-auto-box-zoom";
    exports.tool_icon_zoom_in = "bk-tool-icon-zoom-in";
    exports.tool_icon_zoom_out = "bk-tool-icon-zoom-out";
    exports.tool_icon_help = "bk-tool-icon-help";
    exports.tool_icon_hover = "bk-tool-icon-hover";
    exports.tool_icon_crosshair = "bk-tool-icon-crosshair";
    exports.tool_icon_lasso_select = "bk-tool-icon-lasso-select";
    exports.tool_icon_pan = "bk-tool-icon-pan";
    exports.tool_icon_x_pan = "bk-tool-icon-x-pan";
    exports.tool_icon_y_pan = "bk-tool-icon-y-pan";
    exports.tool_icon_pan_left = "bk-tool-icon-pan-left";
    exports.tool_icon_pan_right = "bk-tool-icon-pan-right";
    exports.tool_icon_pan_up = "bk-tool-icon-pan-up";
    exports.tool_icon_pan_down = "bk-tool-icon-pan-down";
    exports.tool_icon_range = "bk-tool-icon-range";
    exports.tool_icon_polygon_select = "bk-tool-icon-polygon-select";
    exports.tool_icon_redo = "bk-tool-icon-redo";
    exports.tool_icon_reset = "bk-tool-icon-reset";
    exports.tool_icon_save = "bk-tool-icon-save";
    exports.tool_icon_tap_select = "bk-tool-icon-tap-select";
    exports.tool_icon_undo = "bk-tool-icon-undo";
    exports.tool_icon_wheel_pan = "bk-tool-icon-wheel-pan";
    exports.tool_icon_wheel_zoom = "bk-tool-icon-wheel-zoom";
    exports.tool_icon_box_edit = "bk-tool-icon-box-edit";
    exports.tool_icon_freehand_draw = "bk-tool-icon-freehand-draw";
    exports.tool_icon_poly_draw = "bk-tool-icon-poly-draw";
    exports.tool_icon_point_draw = "bk-tool-icon-point-draw";
    exports.tool_icon_poly_edit = "bk-tool-icon-poly-edit";
    exports.tool_icon_line_edit = "bk-tool-icon-line-edit";
    exports.tool_icon_settings = "bk-tool-icon-settings";
    exports.tool_icon_unknown = "bk-tool-icon-unknown";
    exports.tool_icon_fullscreen = "bk-tool-icon-fullscreen";
    exports.tool_icon_chevron_up = "bk-tool-icon-chevron-up";
    exports.tool_icon_chevron_down = "bk-tool-icon-chevron-down";
    exports.tool_icon_chevron_left = "bk-tool-icon-chevron-left";
    exports.tool_icon_chevron_right = "bk-tool-icon-chevron-right";
    exports.tool_icon_caret_up = "bk-tool-icon-caret-up";
    exports.tool_icon_caret_down = "bk-tool-icon-caret-down";
    exports.tool_icon_caret_left = "bk-tool-icon-caret-left";
    exports.tool_icon_caret_right = "bk-tool-icon-caret-right";
    exports.tool_icon_see_on = "bk-tool-icon-see-on";
    exports.tool_icon_see_off = "bk-tool-icon-see-off";
    exports.tool_icon_x_grip = "bk-tool-icon-x-grip";
    exports.tool_icon_y_grip = "bk-tool-icon-y-grip";
    exports.tool_icon_arrow_down_to_bar = "bk-tool-icon-arrow-down-to-bar";
    exports.tool_icon_arrow_up_from_bar = "bk-tool-icon-arrow-up-from-bar";
    exports.tool_icon_minimize = "bk-tool-icon-minimize";
    exports.tool_icon_maximize = "bk-tool-icon-maximize";
    exports.tool_icon_pin = "bk-tool-icon-pin";
    exports.tool_icon_unpin = "bk-tool-icon-unpin";
    exports.tool_icon_pointer = "bk-tool-icon-pointer";
    exports.tool_icon_delete = "bk-tool-icon-delete";
    exports.tool_icon_bold = "bk-tool-icon-bold";
    exports.tool_icon_italic = "bk-tool-icon-italic";
    exports.tool_icon_text_align_left = "bk-tool-icon-text-align-left";
    exports.tool_icon_text_align_center = "bk-tool-icon-text-align-center";
    exports.tool_icon_text_align_right = "bk-tool-icon-text-align-right";
    exports.tool_icon_check = "bk-tool-icon-check";
    exports.tool_icon_square = "bk-tool-icon-square";
    exports.tool_icon_square_check = "bk-tool-icon-square-check";
    exports.tool_icon_list = "bk-tool-icon-list";
    exports.tool_icon_light_theme = "bk-tool-icon-light-theme";
    exports.tool_icon_dark_theme = "bk-tool-icon-dark-theme";
    exports.default = `.bk-tool-icon-copy{background-color:var(--icon-color);mask-image:var(--bokeh-icon-copy);-webkit-mask-image:var(--bokeh-icon-copy);}.bk-tool-icon-open{background-color:var(--icon-color);mask-image:var(--bokeh-icon-open);-webkit-mask-image:var(--bokeh-icon-open);}.bk-tool-icon-replace-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-replace-mode);-webkit-mask-image:var(--bokeh-icon-replace-mode);}.bk-tool-icon-toggle-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-toggle-mode);-webkit-mask-image:var(--bokeh-icon-toggle-mode);}.bk-tool-icon-append-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-append-mode);-webkit-mask-image:var(--bokeh-icon-append-mode);}.bk-tool-icon-intersect-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-intersect-mode);-webkit-mask-image:var(--bokeh-icon-intersect-mode);}.bk-tool-icon-subtract-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-subtract-mode);-webkit-mask-image:var(--bokeh-icon-subtract-mode);}.bk-tool-icon-xor-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-xor-mode);-webkit-mask-image:var(--bokeh-icon-xor-mode);}.bk-tool-icon-invert-selection{background-color:var(--icon-color);mask-image:var(--bokeh-icon-invert-selection);-webkit-mask-image:var(--bokeh-icon-invert-selection);}.bk-tool-icon-clear-selection{background-color:var(--icon-color);mask-image:var(--bokeh-icon-clear-selection);-webkit-mask-image:var(--bokeh-icon-clear-selection);}.bk-tool-icon-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-select);-webkit-mask-image:var(--bokeh-icon-box-select);}.bk-tool-icon-x-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-select);-webkit-mask-image:var(--bokeh-icon-x-box-select);}.bk-tool-icon-y-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-select);-webkit-mask-image:var(--bokeh-icon-y-box-select);}.bk-tool-icon-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-zoom);-webkit-mask-image:var(--bokeh-icon-box-zoom);}.bk-tool-icon-x-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-zoom);-webkit-mask-image:var(--bokeh-icon-x-box-zoom);}.bk-tool-icon-y-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-zoom);-webkit-mask-image:var(--bokeh-icon-y-box-zoom);}.bk-tool-icon-auto-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-auto-box-zoom);-webkit-mask-image:var(--bokeh-icon-auto-box-zoom);}.bk-tool-icon-zoom-in{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-in);-webkit-mask-image:var(--bokeh-icon-zoom-in);}.bk-tool-icon-zoom-out{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-out);-webkit-mask-image:var(--bokeh-icon-zoom-out);}.bk-tool-icon-help{background-color:var(--icon-color);mask-image:var(--bokeh-icon-help);-webkit-mask-image:var(--bokeh-icon-help);}.bk-tool-icon-hover{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hover);-webkit-mask-image:var(--bokeh-icon-hover);}.bk-tool-icon-crosshair{background-color:var(--icon-color);mask-image:var(--bokeh-icon-crosshair);-webkit-mask-image:var(--bokeh-icon-crosshair);}.bk-tool-icon-lasso-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-lasso-select);-webkit-mask-image:var(--bokeh-icon-lasso-select);}.bk-tool-icon-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan);-webkit-mask-image:var(--bokeh-icon-pan);}.bk-tool-icon-x-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-pan);-webkit-mask-image:var(--bokeh-icon-x-pan);}.bk-tool-icon-y-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-pan);-webkit-mask-image:var(--bokeh-icon-y-pan);}.bk-tool-icon-pan-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-left);-webkit-mask-image:var(--bokeh-icon-pan-left);}.bk-tool-icon-pan-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-right);-webkit-mask-image:var(--bokeh-icon-pan-right);}.bk-tool-icon-pan-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-up);-webkit-mask-image:var(--bokeh-icon-pan-up);}.bk-tool-icon-pan-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-down);-webkit-mask-image:var(--bokeh-icon-pan-down);}.bk-tool-icon-range{background-color:var(--icon-color);mask-image:var(--bokeh-icon-range);-webkit-mask-image:var(--bokeh-icon-range);}.bk-tool-icon-polygon-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-polygon-select);-webkit-mask-image:var(--bokeh-icon-polygon-select);}.bk-tool-icon-redo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-redo);-webkit-mask-image:var(--bokeh-icon-redo);}.bk-tool-icon-reset{background-color:var(--icon-color);mask-image:var(--bokeh-icon-reset);-webkit-mask-image:var(--bokeh-icon-reset);}.bk-tool-icon-save{background-color:var(--icon-color);mask-image:var(--bokeh-icon-save);-webkit-mask-image:var(--bokeh-icon-save);}.bk-tool-icon-tap-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-tap-select);-webkit-mask-image:var(--bokeh-icon-tap-select);}.bk-tool-icon-undo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-undo);-webkit-mask-image:var(--bokeh-icon-undo);}.bk-tool-icon-wheel-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-wheel-pan);-webkit-mask-image:var(--bokeh-icon-wheel-pan);}.bk-tool-icon-wheel-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-wheel-zoom);-webkit-mask-image:var(--bokeh-icon-wheel-zoom);}.bk-tool-icon-box-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-edit);-webkit-mask-image:var(--bokeh-icon-box-edit);}.bk-tool-icon-freehand-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-freehand-draw);-webkit-mask-image:var(--bokeh-icon-freehand-draw);}.bk-tool-icon-poly-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-poly-draw);-webkit-mask-image:var(--bokeh-icon-poly-draw);}.bk-tool-icon-point-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-point-draw);-webkit-mask-image:var(--bokeh-icon-point-draw);}.bk-tool-icon-poly-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-poly-edit);-webkit-mask-image:var(--bokeh-icon-poly-edit);}.bk-tool-icon-line-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-line-edit);-webkit-mask-image:var(--bokeh-icon-line-edit);}.bk-tool-icon-settings{background-color:var(--icon-color);mask-image:var(--bokeh-icon-settings);-webkit-mask-image:var(--bokeh-icon-settings);}.bk-tool-icon-unknown{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unknown);-webkit-mask-image:var(--bokeh-icon-unknown);}.bk-tool-icon-fullscreen{background-color:var(--icon-color);mask-image:var(--bokeh-icon-fullscreen);-webkit-mask-image:var(--bokeh-icon-fullscreen);}.bk-tool-icon-chevron-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}.bk-tool-icon-chevron-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-tool-icon-chevron-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}.bk-tool-icon-chevron-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}.bk-tool-icon-caret-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-up);-webkit-mask-image:var(--bokeh-icon-caret-up);}.bk-tool-icon-caret-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-down);-webkit-mask-image:var(--bokeh-icon-caret-down);}.bk-tool-icon-caret-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-left);-webkit-mask-image:var(--bokeh-icon-caret-left);}.bk-tool-icon-caret-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);}.bk-tool-icon-see-on{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-on);-webkit-mask-image:var(--bokeh-icon-see-on);}.bk-tool-icon-see-off{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-off);-webkit-mask-image:var(--bokeh-icon-see-off);}.bk-tool-icon-x-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-grip);-webkit-mask-image:var(--bokeh-icon-x-grip);}.bk-tool-icon-y-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-arrow-down-to-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}.bk-tool-icon-arrow-up-from-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-tool-icon-minimize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-tool-icon-maximize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}.bk-tool-icon-pin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}.bk-tool-icon-unpin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-tool-icon-pointer{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hand-pointing);-webkit-mask-image:var(--bokeh-icon-hand-pointing);}.bk-tool-icon-delete{background-color:var(--icon-color);mask-image:var(--bokeh-icon-trash);-webkit-mask-image:var(--bokeh-icon-trash);}.bk-tool-icon-bold{background-color:var(--icon-color);mask-image:var(--bokeh-icon-bold);-webkit-mask-image:var(--bokeh-icon-bold);}.bk-tool-icon-italic{background-color:var(--icon-color);mask-image:var(--bokeh-icon-italic);-webkit-mask-image:var(--bokeh-icon-italic);}.bk-tool-icon-text-align-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-left);-webkit-mask-image:var(--bokeh-icon-text-align-left);}.bk-tool-icon-text-align-center{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-center);-webkit-mask-image:var(--bokeh-icon-text-align-center);}.bk-tool-icon-text-align-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-right);-webkit-mask-image:var(--bokeh-icon-text-align-right);}.bk-tool-icon-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);}.bk-tool-icon-square{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square);-webkit-mask-image:var(--bokeh-icon-square);}.bk-tool-icon-square-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square-check);-webkit-mask-image:var(--bokeh-icon-square-check);}.bk-tool-icon-list{background-color:var(--icon-color);mask-image:var(--bokeh-icon-list);-webkit-mask-image:var(--bokeh-icon-list);}.bk-tool-icon-light-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-light-theme);-webkit-mask-image:var(--bokeh-icon-light-theme);}.bk-tool-icon-dark-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-dark-theme);-webkit-mask-image:var(--bokeh-icon-dark-theme);}:host{--bokeh-icon-question-mark:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%208a3.5%203%200%200%201%203.5%20-3h1a3.5%203%200%200%201%203.5%203a3%203%200%200%201%20-2%203a3%204%200%200%200%20-2%204%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2219%22%20x2%3D%2212%22%20y2%3D%2219.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-help:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2217%22%20x2%3D%2212%22%20y2%3D%2217.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2013.5a1.5%201.5%200%200%201%201%20-1.5a2.6%202.6%200%201%200%20-3%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%206l-12%2012%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%206l12%2012%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-settings:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M10.325%204.317c.426%20-1.756%202.924%20-1.756%203.35%200a1.724%201.724%200%200%200%202.573%201.066c1.543%20-.94%203.31%20.826%202.37%202.37a1.724%201.724%200%200%200%201.065%202.572c1.756%20.426%201.756%202.924%200%203.35a1.724%201.724%200%200%200%20-1.066%202.573c.94%201.543%20-.826%203.31%20-2.37%202.37a1.724%201.724%200%200%200%20-2.572%201.065c-.426%201.756%20-2.924%201.756%20-3.35%200a1.724%201.724%200%200%200%20-2.573%20-1.066c-1.543%20.94%20-3.31%20-.826%20-2.37%20-2.37a1.724%201.724%200%200%200%20-1.065%20-2.572c-1.756%20-.426%20-1.756%20-2.924%200%20-3.35a1.724%201.724%200%200%200%201.066%20-2.573c-.94%20-1.543%20.826%20-3.31%202.37%20-2.37c1%20.608%202.296%20.07%202.572%20-1.065z%22%3E%3C%2Fpath%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%223%22%3E%3C%2Fcircle%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unknown:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14%203v4a1%201%200%200%200%201%201h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2021h-10a2%202%200%200%201%20-2%20-2v-14a2%202%200%200%201%202%20-2h7l5%205v11a2%202%200%200%201%20-2%202z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2017v.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2014a1.5%201.5%200%201%200%20-1.14%20-2.474%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-fullscreen:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%223%22%20y%3D%2216%22%20width%3D%225%22%20height%3D%225%22%20rx%3D%221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012v-6a2%202%200%200%201%202%20-2h12a2%202%200%200%201%202%202v12a2%202%200%200%201%20-2%202h-6%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%208h4v4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208l-5%205%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-save:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2017v2a2%202%200%200%200%202%202h12a2%202%200%200%200%202%20-2v-2%22%20%2F%3E%0A%20%20%3Cpolyline%20points%3D%227%2011%2012%2016%2017%2011%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%224%22%20x2%3D%2212%22%20y2%3D%2216%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-copy:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228%22%20y%3D%228%22%20width%3D%2212%22%20height%3D%2212%22%20rx%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208v-2a2%202%200%200%200%20-2%20-2h-8a2%202%200%200%200%20-2%202v8a2%202%200%200%200%202%202h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-open:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%204h3l2%202h5a2%202%200%200%201%202%202v7a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2017v2a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-tap-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%2212%22%20x2%3D%226%22%20y2%3D%2212%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%223%22%20x2%3D%2212%22%20y2%3D%226%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%227.8%22%20x2%3D%225.6%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2216.2%22%20y1%3D%227.8%22%20x2%3D%2218.4%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%2216.2%22%20x2%3D%225.6%22%20y2%3D%2218.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012l9%203l-4%202l-2%204l-3%20-9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-lasso-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.028%2013.252c-.657%20-.972%20-1.028%20-2.078%20-1.028%20-3.252c0%20-3.866%204.03%20-7%209%20-7s9%203.134%209%207s-4.03%207%20-9%207c-1.913%200%20-3.686%20-.464%20-5.144%20-1.255%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%225%22%20cy%3D%2215%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2017c0%201.42%20.316%202.805%201%204%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-polygon-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M21.0003%2011.341L18.6863%204.27072L5.18848%205.42767L4.03152%2019.6968L12.664%2018.2014%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.7174%2018.8084C14.7166%2018.9614%2014.7627%2019.111%2014.8494%2019.2371C14.936%2019.3631%2015.0592%2019.4597%2015.2023%2019.5138C15.3455%2019.5679%2015.5017%2019.5769%2015.6501%2019.5396C15.7985%2019.5024%2015.9319%2019.4207%2016.0326%2019.3054L17.7357%2017.7103L20.0454%2021.3822C20.092%2021.4564%2020.1528%2021.5206%2020.2243%2021.5713C20.2957%2021.6219%2020.3765%2021.658%2020.4619%2021.6774C20.5473%2021.6969%2020.6357%2021.6993%2020.722%2021.6846C20.8084%2021.6699%2020.891%2021.6383%2020.9651%2021.5917L21.7486%2021.0989C21.8227%2021.0522%2021.8869%2020.9914%2021.9376%2020.92C21.9883%2020.8485%2022.0243%2020.7678%2022.0438%2020.6824C22.0632%2020.597%2022.0657%2020.5086%2022.051%2020.4222C22.0362%2020.3359%2022.0047%2020.2533%2021.958%2020.1791L19.6484%2016.5073L21.8358%2015.6655C21.9833%2015.6247%2022.1147%2015.5397%2022.2125%2015.422C22.3103%2015.3044%2022.3698%2015.1596%2022.383%2015.0071C22.3961%2014.8547%2022.3624%2014.7018%2022.2862%2014.5691C22.21%2014.4364%2022.095%2014.3302%2021.9567%2014.2647L14.2205%2010L14.7174%2018.8084Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2015h-8v3.586a1%201%200%200%201%20-1.707%20.707l-6.586%20-6.586a1%201%200%200%201%200%20-1.414l6.586%20-6.586a1%201%200%200%201%201.707%20.707v3.586h8a1%201%200%200%201%201%201v4a1%201%200%200%201%20-1%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%209h8v-3.586a1%201%200%200%201%201.707%20-.707l6.586%206.586a1%201%200%200%201%200%201.414l-6.586%206.586a1%201%200%200%201%20-1.707%20-.707v-3.586h-8a1%201%200%200%201%20-1%20-1v-4a1%201%200%200%201%201%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2020v-8h-3.586a1%201%200%200%201%20-.707%20-1.707l6.586%20-6.586a1%201%200%200%201%201.414%200l6.586%206.586a1%201%200%200%201%20-.707%201.707h-3.586v8a1%201%200%200%201%20-1%201h-4a1%201%200%200%201%20-1%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204v8h3.586a1%201%200%200%201%20.707%201.707l-6.586%206.586a1%201%200%200%201%20-1.414%200l-6.586%20-6.586a1%201%200%200%201%20.707%20-1.707h3.586v-8a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-wheel-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14.5%207L17%209.5M17%209.5L14.5%2012M17%209.5H12M4.5%207L2%209.5M2%209.5L4.5%2012M2%209.5H7M7%2014.5L9.5%2017M9.5%2017L12%2014.5M9.5%2017V12M12%204.5L9.5%202M9.5%202L7%204.5M9.5%202V7%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015.1519C15.5%2014.5812%2015.7267%2014.0338%2016.1303%2013.6303C16.5338%2013.2267%2017.0812%2013%2017.6519%2013H19.8037C20.3744%2013%2020.9218%2013.2267%2021.3253%2013.6303C21.7289%2014.0338%2021.9556%2014.5812%2021.9556%2015.1519V20.5315C21.9556%2021.1022%2021.7289%2021.6496%2021.3253%2022.0531C20.9218%2022.4567%2020.3744%2022.6834%2019.8037%2022.6834H17.6519C17.0812%2022.6834%2016.5338%2022.4567%2016.1303%2022.0531C15.7267%2021.6496%2015.5%2021.1022%2015.5%2020.5315V15.1519Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.7278%2016V18.0541Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.7278%2016V18.0541M15.5%2015.1519C15.5%2014.5812%2015.7267%2014.0338%2016.1303%2013.6303C16.5338%2013.2267%2017.0812%2013%2017.6519%2013H19.8037C20.3744%2013%2020.9218%2013.2267%2021.3253%2013.6303C21.7289%2014.0338%2021.9556%2014.5812%2021.9556%2015.1519V20.5315C21.9556%2021.1022%2021.7289%2021.6496%2021.3253%2022.0531C20.9218%2022.4567%2020.3744%2022.6834%2019.8037%2022.6834H17.6519C17.0812%2022.6834%2016.5338%2022.4567%2016.1303%2022.0531C15.7267%2021.6496%2015.5%2021.1022%2015.5%2020.5315V15.1519Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-auto-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-wheel-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8.681%2020.8339V14.1905M4.80569%204.77905C4.29678%205.28797%203.89309%205.89213%203.61767%206.55706C3.34225%207.22199%203.20049%207.93465%203.20049%208.65436C3.20049%209.37407%203.34225%2010.0867%203.61767%2010.7517C3.89309%2011.4166%204.29678%2012.0208%204.80569%2012.5297C5.31461%2013.0386%205.91877%2013.4423%206.5837%2013.7177C7.24863%2013.9931%207.96129%2014.1349%208.681%2014.1349C9.40071%2014.1349%2010.1134%2013.9931%2010.7783%2013.7177C11.4432%2013.4423%2012.0474%2013.0386%2012.5563%2012.5297C13.0652%2012.0208%2013.4689%2011.4166%2013.7443%2010.7517C14.0198%2010.0867%2014.1615%209.37407%2014.1615%208.65436C14.1615%207.93465%2014.0198%207.22199%2013.7443%206.55706C13.4689%205.89213%2013.0652%205.28797%2012.5563%204.77905C12.0474%204.27014%2011.4432%203.86645%2010.7783%203.59103C10.1134%203.31561%209.40071%203.17385%208.681%203.17385C7.96129%203.17385%207.24863%203.31561%206.5837%203.59103C5.91877%203.86645%205.31461%204.27014%204.80569%204.77905Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.1824%2013.8968C15.1824%2013.3711%2015.3912%2012.867%2015.7629%2012.4953C16.1346%2012.1236%2016.6388%2011.9147%2017.1644%2011.9147H19.1465C19.6721%2011.9147%2020.1763%2012.1236%2020.548%2012.4953C20.9197%2012.867%2021.1285%2013.3711%2021.1285%2013.8968V18.8519C21.1285%2019.3775%2020.9197%2019.8817%2020.548%2020.2534C20.1763%2020.6251%2019.6721%2020.8339%2019.1465%2020.8339H17.1644C16.6388%2020.8339%2016.1346%2020.6251%2015.7629%2020.2534C15.3912%2019.8817%2015.1824%2019.3775%2015.1824%2018.8519V13.8968Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.1555%2013.8968V16.6519Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.1555%2013.8968V16.6519M15.1824%2013.8968C15.1824%2013.3711%2015.3912%2012.867%2015.7629%2012.4953C16.1346%2012.1236%2016.6388%2011.9147%2017.1644%2011.9147H19.1465C19.6721%2011.9147%2020.1763%2012.1236%2020.548%2012.4953C20.9197%2012.867%2021.1285%2013.3711%2021.1285%2013.8968V18.8519C21.1285%2019.3775%2020.9197%2019.8817%2020.548%2020.2534C20.1763%2020.6251%2019.6721%2020.8339%2019.1465%2020.8339H17.1644C16.6388%2020.8339%2016.1346%2020.6251%2015.7629%2020.2534C15.3912%2019.8817%2015.1824%2019.3775%2015.1824%2018.8519V13.8968Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5.90637%208.8085H11.4556M8.681%206.03387V11.5831%22%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%205V5.00874M8.5%205V5.00874M12%205V5.00874M15.5%205V5.00874M19%205V5.00874M5%2018.9913V19M8.5%2018.9913V19M12%2018.9913V19M19%2011.9956V12.0044M19%208.49781V8.50656M5%2015.4934V15.5022M5%2011.9956V12.0044M5%208.49781V8.50656%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.42%2015.6151C18.615%2015.4201%2018.8465%2015.2654%2019.1013%2015.1599C19.3561%2015.0543%2019.6292%2015%2019.905%2015C20.1808%2015%2020.4539%2015.0543%2020.7087%2015.1599C20.9635%2015.2654%2021.195%2015.4201%2021.39%2015.6151C21.585%2015.8101%2021.7397%2016.0416%2021.8452%2016.2964C21.9508%2016.5512%2022.0051%2016.8243%2022.0051%2017.1001C22.0051%2017.3759%2021.9508%2017.649%2021.8452%2017.9038C21.7397%2018.1586%2021.585%2018.3901%2021.39%2018.5851L18%2022.0051H15V19.0051L18.42%2015.6151Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-poly-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17.6568%2014.1213L17.3033%209.52513M15.182%205.98959L12%204.92893M8.818%205.98959L5.63602%2012.7071M7.05024%2014.8284L15.5355%2016.2426M18.3639%208.46447C17.9889%208.83954%2017.4802%209.05025%2016.9497%209.05025C16.4193%209.05025%2015.9106%208.83954%2015.5355%208.46447C15.1604%208.08939%2014.9497%207.58069%2014.9497%207.05025C14.9497%206.51982%2015.1604%206.01111%2015.5355%205.63604C15.9106%205.26097%2016.4193%205.05025%2016.9497%205.05025C17.4802%205.05025%2017.9889%205.26097%2018.3639%205.63604C18.739%206.01111%2018.9497%206.51982%2018.9497%207.05025C18.9497%207.58069%2018.739%208.08939%2018.3639%208.46447ZM11.2929%205.63604C10.9178%206.01111%2010.4091%206.22183%209.87866%206.22183C9.34823%206.22183%208.83952%206.01111%208.46445%205.63604C8.08938%205.26097%207.87866%204.75226%207.87866%204.22183C7.87866%203.69139%208.08938%203.18269%208.46445%202.80761C8.83952%202.43254%209.34823%202.22183%209.87866%202.22183C10.4091%202.22183%2010.9178%202.43254%2011.2929%202.80761C11.6679%203.18269%2011.8787%203.69139%2011.8787%204.22183C11.8787%204.75226%2011.6679%205.26097%2011.2929%205.63604ZM19.0711%2017.6569C18.696%2018.0319%2018.1873%2018.2426%2017.6568%2018.2426C17.1264%2018.2426%2016.6177%2018.0319%2016.2426%2017.6569C15.8676%2017.2818%2015.6568%2016.7731%2015.6568%2016.2426C15.6568%2015.7122%2015.8676%2015.2035%2016.2426%2014.8284C16.6177%2014.4534%2017.1264%2014.2426%2017.6568%2014.2426C18.1873%2014.2426%2018.696%2014.4534%2019.0711%2014.8284C19.4461%2015.2035%2019.6568%2015.7122%2019.6568%2016.2426C19.6568%2016.7731%2019.4461%2017.2818%2019.0711%2017.6569ZM6.34313%2016.2426C5.96806%2016.6177%205.45935%2016.8284%204.92892%2016.8284C4.39848%2016.8284%203.88978%2016.6177%203.5147%2016.2426C3.13963%2015.8676%202.92892%2015.3589%202.92892%2014.8284C2.92892%2014.298%203.13963%2013.7893%203.5147%2013.4142C3.88978%2013.0391%204.39848%2012.8284%204.92892%2012.8284C5.45935%2012.8284%205.96806%2013.0391%206.34313%2013.4142C6.7182%2013.7893%206.92892%2014.298%206.92892%2014.8284C6.92892%2015.3589%206.7182%2015.8676%206.34313%2016.2426Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17.4057%2012.7025C17.6284%2012.4798%2017.8928%2012.3031%2018.1838%2012.1826C18.4748%2012.062%2018.7867%2012%2019.1016%2012C19.4166%2012%2019.7285%2012.062%2020.0194%2012.1826C20.3104%2012.3031%2020.5748%2012.4798%2020.7975%2012.7025C21.0202%2012.9252%2021.1969%2013.1896%2021.3174%2013.4806C21.438%2013.7715%2021.5%2014.0834%2021.5%2014.3984C21.5%2014.7133%2021.438%2015.0252%2021.3174%2015.3162C21.1969%2015.6072%2021.0202%2015.8716%2020.7975%2016.0943L18.8618%2018.0471L16.9261%2020H13.5V16.5739L17.4057%2012.7025Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-line-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2213.9036%22%20cy%3D%224.82583%22%20r%3D%222%22%20transform%3D%22rotate(47.4551%2013.9036%204.82583)%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%224.32583%22%20cy%3D%2213.616%22%20r%3D%222%22%20transform%3D%22rotate(47.4551%204.32583%2013.616)%22%20%2F%3E%0A%20%20%3Crect%20x%3D%2212.4301%22%20y%3D%226.17816%22%20width%3D%220%22%20height%3D%229%22%20transform%3D%22rotate(47.4551%2012.4301%206.17816)%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13.9404%2020.4782C13.9736%2020.6275%2014.0517%2020.7631%2014.1643%2020.8668C14.2768%2020.9705%2014.4183%2021.0373%2014.5699%2021.0582C14.7214%2021.0792%2014.8758%2021.0533%2015.0122%2020.984C15.1486%2020.9148%2015.2606%2020.8054%2015.3331%2020.6707L16.6395%2018.7373L19.7069%2021.8046C19.7688%2021.8666%2019.8424%2021.9157%2019.9233%2021.9492C20.0042%2021.9827%2020.0909%2022%2020.1785%2022C20.2661%2022%2020.3528%2021.9827%2020.4338%2021.9492C20.5147%2021.9157%2020.5882%2021.8666%2020.6502%2021.8046L21.3046%2021.1502C21.3666%2021.0882%2021.4157%2021.0147%2021.4492%2020.9338C21.4827%2020.8528%2021.5%2020.7661%2021.5%2020.6785C21.5%2020.5909%2021.4827%2020.5042%2021.4492%2020.4233C21.4157%2020.3424%2021.3666%2020.2688%2021.3046%2020.2069L18.2373%2017.1395L20.1832%2015.8331C20.3179%2015.7605%2020.4272%2015.6485%2020.4965%2015.512C20.5657%2015.3756%2020.5915%2015.2212%2020.5705%2015.0696C20.5495%2014.9181%2020.4826%2014.7765%2020.3789%2014.6641C20.2751%2014.5516%2020.1394%2014.4735%2019.9901%2014.4404L11.5%2012L13.9404%2020.4782Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-clear-selection:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%205V5.00874M8.5%205V5.00874M12%205V5.00874M15.5%205V5.00874M19%205V5.00874M5%2018.9913V19M8.5%2018.9913V19M12%2018.9913V19M19%2011.9956V12.0044M19%208.49781V8.50656M5%2015.4934V15.5022M5%2011.9956V12.0044M5%208.49781V8.50656%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%224%204%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015L21.5%2021Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M21.5%2015L15.5%2021Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015L21.5%2021M21.5%2015L15.5%2021%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-invert-selection:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%204.5V19L8.46484%2015.5352C7.56002%2014.6303%207%2013.3807%207%2012C7%209.23858%209.23858%207%2012%207C13.3807%207%2014.6303%207.56002%2015.5352%208.46484L19.5%204.5H5Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8.46484%2015.5352C9.36967%2016.44%2010.6193%2017%2012%2017C14.7614%2017%2017%2014.7614%2017%2012C17%2010.6193%2016.44%209.36967%2015.5352%208.46484L8.46484%2015.5352Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3.99997%205.77778C3.99997%205.30628%204.18727%204.8541%204.52067%204.5207C4.85407%204.1873%205.30625%204%205.77775%204H18.2222C18.6937%204%2019.1459%204.1873%2019.4793%204.5207C19.8127%204.8541%2020%205.30628%2020%205.77778V18.2222C20%2018.6937%2019.8127%2019.1459%2019.4793%2019.4793C19.1459%2019.8127%2018.6937%2020%2018.2222%2020H5.77775C5.30625%2020%204.85407%2019.8127%204.52067%2019.4793C4.18727%2019.1459%203.99997%2018.6937%203.99997%2018.2222V5.77778Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4.29477%2019.6812L19.7451%204.23096%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-point-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%223.73807%22%20cy%3D%2217.2381%22%20r%3D%222%22%20transform%3D%22rotate(7.30509%203.73807%2017.2381)%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2219.7381%22%20cy%3D%228.23807%22%20r%3D%222%22%20transform%3D%22rotate(7.30509%2019.7381%208.23807)%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M11.3341%209.83406C11.9487%209.21945%2012.3268%208.40774%2012.4019%207.5418C12.477%206.67586%2012.2443%205.81118%2011.7447%205.09993C11.245%204.38868%2010.5106%203.87645%209.67048%203.65338C8.83039%203.43031%207.93855%203.51071%207.15191%203.88042C6.36526%204.25013%205.73423%204.88545%205.36986%205.67459C5.00549%206.46372%204.93114%207.35609%205.1599%208.19464C5.38865%209.03319%205.90585%209.76418%206.62047%2010.259C7.33509%2010.7538%208.20133%2010.9806%209.06675%2010.8997V8.30035L11.3341%209.83406Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M11.3341%209.83406C11.9382%209.22991%2012.3142%208.43497%2012.3979%207.58468C12.4817%206.7344%2012.268%205.88138%2011.7933%205.17098C11.3187%204.46057%2010.6123%203.93673%209.79474%203.68872C8.97713%203.4407%208.09882%203.48385%207.30946%203.81081C6.5201%204.13777%205.86853%204.72832%205.46577%205.48183C5.06301%206.23534%204.93398%207.1052%205.10067%207.94318C5.26735%208.78116%205.71944%209.53542%206.3799%2010.0774C7.04035%2010.6195%207.86832%2010.9157%208.72272%2010.9157%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.30866%2018.2265C9.30141%2018.3958%209.34612%2018.5633%209.4368%2018.7065C9.52748%2018.8498%209.65978%2018.9618%209.81596%2019.0277C9.97215%2019.0936%2010.1447%2019.1101%2010.3106%2019.0751C10.4765%2019.0401%2010.6276%2018.9552%2010.7439%2018.8318L12.6964%2017.1374L15.0994%2021.2995C15.1479%2021.3835%2015.2125%2021.4572%2015.2895%2021.5163C15.3664%2021.5753%2015.4543%2021.6187%2015.5481%2021.6438C15.6418%2021.6689%2015.7396%2021.6753%2015.8358%2021.6627C15.932%2021.65%2016.0248%2021.6185%2016.1088%2021.57L16.9969%2021.0572C17.0809%2021.0087%2017.1546%2020.9441%2017.2136%2020.8671C17.2727%2020.7902%2017.316%2020.7023%2017.3412%2020.6085C17.3663%2020.5148%2017.3727%2020.417%2017.36%2020.3208C17.3474%2020.2246%2017.3159%2020.1318%2017.2673%2020.0478L14.8644%2015.8857L17.3214%2015.0456C17.4864%2015.0066%2017.6355%2014.918%2017.7487%2014.7919C17.8619%2014.6657%2017.9338%2014.5079%2017.9548%2014.3396C17.9758%2014.1714%2017.9448%2014.0008%2017.866%2013.8507C17.7872%2013.7006%2017.6644%2013.5781%2017.5141%2013.4998L9.12817%208.45374L9.30866%2018.2265Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-poly-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8.41421%2010.4142C8.03914%2010.7893%207.53043%2011%207%2011C6.46957%2011%205.96086%2010.7893%205.58579%2010.4142C5.21071%2010.0391%205%209.53043%205%209C5%208.46957%205.21071%207.96086%205.58579%207.58579C5.96086%207.21071%206.46957%207%207%207C7.53043%207%208.03914%207.21071%208.41421%207.58579C8.78929%207.96086%209%208.46957%209%209C9%209.53043%208.78929%2010.0391%208.41421%2010.4142ZM8.41421%2010.4142L10%2012M15.5858%2015.5858C15.9609%2015.2107%2016.4696%2015%2017%2015C17.5304%2015%2018.0391%2015.2107%2018.4142%2015.5858C18.7893%2015.9609%2019%2016.4696%2019%2017C19%2017.5304%2018.7893%2018.0391%2018.4142%2018.4142C18.0391%2018.7893%2017.5304%2019%2017%2019C16.4696%2019%2015.9609%2018.7893%2015.5858%2018.4142C15.2107%2018.0391%2015%2017.5304%2015%2017C15%2016.4696%2015.2107%2015.9609%2015.5858%2015.5858ZM15.5858%2015.5858L13.2431%2014.3522M8.5%207.5L10.25%206L11.2679%205M15%204.5L18%206M19.5%209L18%2015M11%204C11%204.53043%2011.2107%205.03914%2011.5858%205.41421C11.9609%205.78929%2012.4696%206%2013%206C13.5304%206%2014.0391%205.78929%2014.4142%205.41421C14.7893%205.03914%2015%204.53043%2015%204C15%203.46957%2014.7893%202.96086%2014.4142%202.58579C14.0391%202.21071%2013.5304%202%2013%202C12.4696%202%2011.9609%202.21071%2011.5858%202.58579C11.2107%202.96086%2011%203.46957%2011%204ZM18%207C18%207.53043%2018.2107%208.03914%2018.5858%208.41421C18.9609%208.78929%2019.4696%209%2020%209C20.5304%209%2021.0391%208.78929%2021.4142%208.41421C21.7893%208.03914%2022%207.53043%2022%207C22%206.46957%2021.7893%205.96086%2021.4142%205.58579C21.0391%205.21071%2020.5304%205%2020%205C19.4696%205%2018.9609%205.21071%2018.5858%205.58579C18.2107%205.96086%2018%206.46957%2018%207Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.6386%2020.3576C10.6105%2020.5046%2010.5382%2020.6394%2010.4313%2020.7441C10.3244%2020.8487%2010.1881%2020.9182%2010.0406%2020.9431C9.89312%2020.9681%209.74152%2020.9474%209.60615%2020.8837C9.47077%2020.82%209.35811%2020.7165%209.28326%2020.587L7.9493%2018.7362L5.04245%2021.8246C4.98375%2021.8869%204.91335%2021.9371%204.83526%2021.9723C4.75717%2022.0074%204.67292%2022.0268%204.58732%2022.0294C4.50172%2022.032%204.41644%2022.0177%204.33637%2021.9874C4.25629%2021.957%204.18298%2021.9112%204.12062%2021.8525L3.46166%2021.2322C3.3993%2021.1735%203.34911%2021.1031%203.31395%2021.0251C3.2788%2020.947%203.25937%2020.8627%203.25678%2020.7771C3.25419%2020.6915%203.26848%2020.6062%203.29885%2020.5262C3.32921%2020.4461%203.37505%2020.3728%203.43375%2020.3104L6.3406%2017.222L4.40026%2016.0029C4.26645%2015.9359%204.15631%2015.8297%204.08462%2015.6984C4.01293%2015.5671%203.98311%2015.417%203.99917%2015.2682C4.01522%2015.1195%204.07639%2014.9792%204.17446%2014.8662C4.27253%2014.7532%204.40281%2014.6729%204.54781%2014.6361L12.7726%2012L10.6386%2020.3576Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-freehand-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.5%2018C4.5%2019.6667%204.5%2022%208.5%2020C13.5%2017.5%2013.5%2020%2013.5%2021%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5.20734%2016.0852H4.20734V17.0852H5.20734V16.0852ZM8.62197%2016.0852V17.0852H9.0362L9.32909%2016.7923L8.62197%2016.0852ZM17.5854%207.12183L18.2925%207.82893L18.2925%207.82893L17.5854%207.12183ZM15.8781%203V2V3ZM14.1708%203.70719L13.4636%203.00009L13.4636%203.00009L14.1708%203.70719ZM5.20734%2012.6706L4.50023%2011.9635L4.20734%2012.2564V12.6706H5.20734ZM14.0242%203.8537C13.6337%203.46317%2013.0005%203.46317%2012.61%203.8537C12.2195%204.24422%2012.2195%204.87739%2012.61%205.26791L14.0242%203.8537ZM16.0246%208.68254C16.4151%209.07307%2017.0483%209.07307%2017.4388%208.68254C17.8294%208.29202%2017.8294%207.65885%2017.4388%207.26833L16.0246%208.68254ZM7.19493%2010.683C6.80441%2010.2924%206.17124%2010.2924%205.78072%2010.683C5.39019%2011.0735%205.39019%2011.7067%205.78072%2012.0972L7.19493%2010.683ZM13.7439%2010.9633L14.451%2011.6704L14.451%2011.6704L13.7439%2010.9633ZM5.20734%2016.0852V17.0852H8.62197V16.0852V15.0852H5.20734V16.0852ZM17.5854%207.12183L18.2925%207.82893C18.9328%207.18859%2019.2926%206.32009%2019.2926%205.41451H18.2926H17.2926C17.2926%205.78966%2017.1436%206.14945%2016.8783%206.41472L17.5854%207.12183ZM18.2926%205.41451H19.2926C19.2926%204.50893%2018.9328%203.64043%2018.2925%203.00009L17.5854%203.70719L16.8783%204.4143C17.1436%204.67957%2017.2926%205.03936%2017.2926%205.41451H18.2926ZM17.5854%203.70719L18.2925%203.00009C17.6521%202.35974%2016.7837%202%2015.8781%202L15.8781%203L15.8781%204C16.2532%204%2016.613%204.14903%2016.8783%204.4143L17.5854%203.70719ZM15.8781%203V2C14.9725%202%2014.104%202.35974%2013.4636%203.00009L14.1708%203.70719L14.8779%204.4143C15.1431%204.14903%2015.5029%204%2015.8781%204V3ZM14.1708%203.70719L13.4636%203.00009L4.50023%2011.9635L5.20734%2012.6706L5.91444%2013.3777L14.8779%204.4143L14.1708%203.70719ZM5.20734%2012.6706H4.20734V16.0852H5.20734H6.20734V12.6706H5.20734ZM13.3171%204.5608L12.61%205.26791L16.0246%208.68254L16.7317%207.97544L17.4388%207.26833L14.0242%203.8537L13.3171%204.5608ZM13.7439%2010.9633L14.451%2011.6704L18.2925%207.82893L17.5854%207.12183L16.8783%206.41472L13.0368%2010.2562L13.7439%2010.9633ZM8.62197%2016.0852L9.32909%2016.7923L10.6096%2015.5118L9.90246%2014.8047L9.19534%2014.0976L7.91485%2015.3782L8.62197%2016.0852ZM6.48782%2011.3901L5.78072%2012.0972L9.19535%2015.5118L9.90246%2014.8047L10.6096%2014.0976L7.19493%2010.683L6.48782%2011.3901ZM13.7439%2010.9633L13.0368%2010.2562L9.19536%2014.0976L9.90246%2014.8047L10.6096%2015.5118L14.451%2011.6704L13.7439%2010.9633Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-append-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-intersect-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228.08807%22%20y%3D%228.02829%22%20width%3D%227.93701%22%20height%3D%227.93702%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015L15%209M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6ZM4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-subtract-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.26016%2019.6422V9.19123L7.92544%208.39874L8.91606%2015.9274L16.0485%2016.1751L15.5532%2019.9394L4.26016%2019.6422Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%2016V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H8M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-xor-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15.9778%208.01522H8.10718V4.50302H19.7862V15.8436H15.9778V8.01522Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8.06036%2016.03H15.931V19.5422H4.25198V8.20167H8.06036V16.03Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%2016V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H8M16%2016H18C18.5304%2016%2019.0391%2015.7893%2019.4142%2015.4142C19.7893%2015.0391%2020%2014.5304%2020%2014V6C20%205.46957%2019.7893%204.96086%2019.4142%204.58579C19.0391%204.21071%2018.5304%204%2018%204H10C9.46957%204%208.96086%204.21071%208.58579%204.58579C8.21071%204.96086%208%205.46957%208%206V8M16%2016V14M16%2016H14M8%208H10M8%208V10M8%2014V16H10M14%208H16V10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-replace-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M21%2011V8C21%207.46957%2020.7893%206.96086%2020.4142%206.58579C20.0391%206.21071%2019.5304%206%2019%206H13M13%206L16%209M13%206L16%203M3%2013V16C3%2016.5304%203.21071%2017.0391%203.58579%2017.4142C3.96086%2017.7893%204.46957%2018%205%2018H11M11%2018L8%2015M11%2018L8%2021M3%204C3%203.73478%203.10536%203.48043%203.29289%203.29289C3.48043%203.10536%203.73478%203%204%203H8C8.26522%203%208.51957%203.10536%208.70711%203.29289C8.89464%203.48043%209%203.73478%209%204V8C9%208.26522%208.89464%208.51957%208.70711%208.70711C8.51957%208.89464%208.26522%209%208%209H4C3.73478%209%203.48043%208.89464%203.29289%208.70711C3.10536%208.51957%203%208.26522%203%208V4ZM15%2016C15%2015.7348%2015.1054%2015.4804%2015.2929%2015.2929C15.4804%2015.1054%2015.7348%2015%2016%2015H20C20.2652%2015%2020.5196%2015.1054%2020.7071%2015.2929C20.8946%2015.4804%2021%2015.7348%2021%2016V20C21%2020.2652%2020.8946%2020.5196%2020.7071%2020.7071C20.5196%2020.8946%2020.2652%2021%2020%2021H16C15.7348%2021%2015.4804%2020.8946%2015.2929%2020.7071C15.1054%2020.5196%2015%2020.2652%2015%2020V16Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-toggle-mode:url("data:image/svg+xml,%3Csvg%20width%3D%2233%22%20height%3D%2232%22%20viewBox%3D%220%200%2033%2032%22%20fill%3D%22none%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%3E%0A%3Crect%20x%3D%220.5%22%20width%3D%2232%22%20height%3D%2232%22%20fill%3D%22url(%23pattern0_195_301)%22%2F%3E%0A%3Cdefs%3E%0A%3Cpattern%20id%3D%22pattern0_195_301%22%20patternContentUnits%3D%22objectBoundingBox%22%20width%3D%221%22%20height%3D%221%22%3E%0A%3Cuse%20xlink%3Ahref%3D%22%23image0_195_301%22%20transform%3D%22scale(0.03125)%22%2F%3E%0A%3C%2Fpattern%3E%0A%3Cimage%20id%3D%22image0_195_301%22%20width%3D%2232%22%20height%3D%2232%22%20preserveAspectRatio%3D%22none%22%20xlink%3Ahref%3D%22data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADP3pUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHja7ZZbsiMnDIbfWUWWgCRAYjlcq2YHWX5%2B6HYf2%2BOpiieepxyoRrRQC6EPsN34%2B8d0f6GwZ3YhqqWckkcJOWQu6Jg%2FStkt%2BbDbXfgcwvuD3l0DDJVAyvFq6bS%2F6elycIiCXrxzZO0cqI8DOZz%2B7cnROZGsiFYU%2FXSUT0fCxwCdDsqxLJ%2By6f0S6jhkv63EjsetRvRY%2Bs3J83tQZK9HKIV5CIlHK3IGIOsJTgo6abfCh7rAVNEGuUWChLzK01UyIpor1PDS6IHK1aPXevdMK%2FBpIk9JTpd8qXcUX1PZqb%2BbOdjZ40d9tsOV80%2FZX8%2Bc3eZeM1ZRQkKq07mo21J2D3YVU6ypzcFf8oonwoXumlENu7qBWvfNV9RGmRi4JgXqVGjS2LJRQ4iBh2NdJ4Uby1aaKGduYEeLmgSarJKli4Fo29iD8BUL7Wmzb27PZpi5E0yZ4IzwydvVvfvBnOsoEHm7coW4cPoXB1pplNXCDERonkmNO8G3%2BlwWVwHBuLK8jkhGYuvhokb6uglkgxYYRsjjuJD20wFShKkjgiEBAVAjiZTIK7MSIZEGQAWh4wBxBQGKkTuC5CCSwMZ4TY1PlLYpR4baQY%2FLDCQiTpyCTZYCWCFE7B8Nhj1UosQQY0xRo8UcS5IUUkwpaVqXYlHR4DRqUlXTrMXEgkVLpmaWrWTOgksz5pQ1W865FMxZ4Lng6wKDUipXqaFGV1PVajXX0rB9WmixpabNWm6lc5eO%2B6Onrt167mXQwFYaYcSRhg4beZSJrTbFzTDjTFOnzTzLRe3E%2BlN9gxqd1HiTWoZ6UYNW9eaC1nUSFzMAw68IgbguBNjQvJh5oxB4kVvMfGacisgIMi5mnRYxEAyDOE66sXN8EF3k%2FhM3p%2BGBG%2F8uObfQvUnuZ26vqPX1M9Q2seMUrqR6wekbOVlhQ0T4sVsdfy%2Fds%2BJ35bejb0ffjv5vjkYtqzdcSF8vL%2Fo10x%2BNqJZRMNcSp9aVxL7srv%2BSpw0E%2FkL9O%2B%2FuI%2BEgGveRcCDdR8JBFO4j4dh29H44e3%2BsbXLXd78YWPvnrTW7D5yOb0fvOsL%2FkOz%2BAVNjw%2BbixfXWAAABhGlDQ1BJQ0MgcHJvZmlsZQAAeJx9kT1Iw0AcxV9TtSIVRTuIOGSoThZERRy1CkWoEGqFVh1MLv0QmjQkKS6OgmvBwY%2FFqoOLs64OroIg%2BAHi7OCk6CIl%2Fi8ptIjx4Lgf7%2B497t4BQq3ENKttDNB020wl4mImuyKGXtGBIPoQRq%2FMLGNWkpLwHV%2F3CPD1Lsaz%2FM%2F9ObrVnMWAgEg8wwzTJl4nntq0Dc77xBFWlFXic%2BJRky5I%2FMh1xeM3zgWXBZ4ZMdOpOeIIsVhoYaWFWdHUiCeJo6qmU76Q8VjlvMVZK1VY4578heGcvrzEdZpDSGABi5AgQkEFGyjBRoxWnRQLKdqP%2B%2FgHXb9ELoVcG2DkmEcZGmTXD%2F4Hv7u18hPjXlI4DrS%2FOM7HMBDaBepVx%2Fk%2Bdpz6CRB8Bq70pr9cA6Y%2FSa82tegR0LMNXFw3NWUPuNwBBp4M2ZRdKUhTyOeB9zP6pizQfwt0rXq9NfZx%2BgCkqavkDXBwCIwUKHvN592drb39e6bR3w%2F9qXJ4zBnVPwAADRppVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw%2FeHBhY2tldCBiZWdpbj0i77u%2FIiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8%2BCjx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDQuNC4wLUV4aXYyIj4KIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI%2BCiAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZUV2ZW50IyIKICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgIHhtbG5zOkdJTVA9Imh0dHA6Ly93d3cuZ2ltcC5vcmcveG1wLyIKICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIgogICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIgogICB4bXBNTTpEb2N1bWVudElEPSJnaW1wOmRvY2lkOmdpbXA6MjFjNTkwNzMtOTc1Zi00ZjAxLTljMDktYzY2NWY3NTBhMDA2IgogICB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjdhODY1NGM1LTZiYTktNDkwMi1iZWNmLTAyMGE3Y2I1MTI5NCIKICAgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ4bXAuZGlkOmNmNDY3MmE2LTRjN2ItNDAwYi04N2U4LWExMjFjY2ZlZjI1YSIKICAgZGM6Rm9ybWF0PSJpbWFnZS9wbmciCiAgIEdJTVA6QVBJPSIyLjAiCiAgIEdJTVA6UGxhdGZvcm09IkxpbnV4IgogICBHSU1QOlRpbWVTdGFtcD0iMTcxNzQzODY2NDU5OTYwMiIKICAgR0lNUDpWZXJzaW9uPSIyLjEwLjMwIgogICB0aWZmOk9yaWVudGF0aW9uPSIxIgogICB4bXA6Q3JlYXRvclRvb2w9IkdJTVAgMi4xMCI%2BCiAgIDx4bXBNTTpIaXN0b3J5PgogICAgPHJkZjpTZXE%2BCiAgICAgPHJkZjpsaQogICAgICBzdEV2dDphY3Rpb249InNhdmVkIgogICAgICBzdEV2dDpjaGFuZ2VkPSIvIgogICAgICBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjAyOTk4NWE4LThlMjItNGI2NS1hNTQwLTE3MWI2NjU3YTYxOCIKICAgICAgc3RFdnQ6c29mdHdhcmVBZ2VudD0iR2ltcCAyLjEwIChMaW51eCkiCiAgICAgIHN0RXZ0OndoZW49IjIwMjQtMDYtMDNUMjA6MTc6NDQrMDI6MDAiLz4KICAgIDwvcmRmOlNlcT4KICAgPC94bXBNTTpIaXN0b3J5PgogIDwvcmRmOkRlc2NyaXB0aW9uPgogPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8%2BrdIyIAAAAAZiS0dEAP8A%2FwD%2FoL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB%2BgGAxIRLNWVUewAAAB9SURBVFjDY2AYBaNggAEjNsGFy1b%2BR%2BbHR4UzUlMcGTANymBZuGzlf3TX08o8ptFUOJoGBtrxTNS2HFd%2Bp7kDyLF80KYZkiyhieXEWkas5VTLBciVDLXinOREiGwhNRIcCzmaBiSlj9YFw7Y9wEJK8Uppm3C0RTQKRgE2AAByVIRiIg%2Bg0AAAAABJRU5ErkJggg%3D%3D%22%2F%3E%0A%3C%2Fdefs%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-in:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2210%22%20y1%3D%227%22%20x2%3D%2210%22%20y2%3D%2213%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-out:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-undo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2014L5%2010M5%2010L9%206M5%2010H16C17.0609%2010%2018.0783%2010.4214%2018.8284%2011.1716C19.5786%2011.9217%2020%2012.9391%2020%2014C20%2015.0609%2019.5786%2016.0783%2018.8284%2016.8284C18.0783%2017.5786%2017.0609%2018%2016%2018H15%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-redo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2013L19%209M19%209L15%205M19%209L8%209C6.93913%209%205.92172%209.42143%205.17157%2010.1716C4.42143%2010.9217%204%2011.9391%204%2013C4%2014.0609%204.42143%2015.0783%205.17157%2015.8284C5.92172%2016.5786%206.93913%2017%208%2017H9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-reset:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3.06006%2013.0001C3.30547%2015.1939%204.34865%2017.2211%205.9912%2018.696C7.63374%2020.1709%209.76108%2020.9907%2011.9686%2020.9995C14.1762%2021.0082%2016.3099%2020.2053%2017.9641%2018.7434C19.6183%2017.2816%2020.6775%2015.2628%2020.9403%2013.0709C21.2031%2010.879%2020.6511%208.66702%2019.3894%206.85557C18.1276%205.04412%2016.2441%203.75958%2014.0971%203.24624C11.95%202.7329%209.68922%203.02658%207.74457%204.07141C5.79993%205.11625%204.30712%206.83937%203.55006%208.91306M3%204.00098V9.00098H8M11%2012C11%2012.2652%2011.1054%2012.5196%2011.2929%2012.7071C11.4804%2012.8946%2011.7348%2013%2012%2013C12.2652%2013%2012.5196%2012.8946%2012.7071%2012.7071C12.8946%2012.5196%2013%2012.2652%2013%2012C13%2011.7348%2012.8946%2011.4804%2012.7071%2011.2929C12.5196%2011.1054%2012.2652%2011%2012%2011C11.7348%2011%2011.4804%2011.1054%2011.2929%2011.2929C11.1054%2011.4804%2011%2011.7348%2011%2012Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hover:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2020l-3%20-3h-2a3%203%200%200%201%20-3%20-3v-6a3%203%200%200%201%203%20-3h10a3%203%200%200%201%203%203v6a3%203%200%200%201%20-3%203h-2l-3%203%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%229%22%20x2%3D%2216%22%20y2%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%2213%22%20x2%3D%2214%22%20y2%3D%2213%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-crosshair:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M20%2012h-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2020v-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%204v4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%2015%2012%209%2018%2015%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%209%2012%2015%2018%209%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%2215%206%209%2012%2015%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%229%206%2015%2012%209%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(180%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(270%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(90%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-on:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2012c-2.667%204.667%20-6%207%20-10%207s-7.333%20-2.333%20-10%20-7c2.667%20-4.667%206%20-7%2010%20-7s7.333%202.333%2010%207%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-off:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%223%22%20x2%3D%2221%22%20y2%3D%2221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.584%2010.587a2%202%200%200%200%202.828%202.83%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.363%205.365a9.466%209.466%200%200%201%202.637%20-.365c4%200%207.333%202.333%2010%207c-.778%201.361%20-1.612%202.524%20-2.503%203.488m-2.14%201.861c-1.631%201.1%20-3.415%201.651%20-5.357%201.651c-4%200%20-7.333%20-2.333%20-10%20-7c1.369%20-2.395%202.913%20-4.175%204.632%20-5.341%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-cursor-rotate:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%3E%0A%20%20%3Cg%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%224%22%20stroke%3D%22white%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%222%22%20stroke%3D%22black%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A") 12 12, auto;--bokeh-icon-x-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-down-to-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l0%20-10%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l4%20-4%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l-4%20-4%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-up-from-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%204l0%2010%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l-4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-minimize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2019v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%209h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-maximize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%208v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2016v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%204h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%2020h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-4%204l-4%201.5l-1.5%201.5l7%207l1.5%20-1.5l1.5%20-4l4%20-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unpin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203l18%2018%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-3.249%203.249m-2.57%201.433l-2.181%20.818l-1.5%201.5l7%207l1.5%20-1.5l.82%20-2.186m1.43%20-2.563l3.25%20-3.251%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hand-pointing:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%2013v-8.5a1.5%201.5%200%200%201%203%200v7.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M11%2011.5v-2a1.5%201.5%200%201%201%203%200v2.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2010.5a1.5%201.5%200%200%201%203%200v1.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M17%2011.5a1.5%201.5%200%200%201%203%200v4.5a6%206%200%200%201%20-6%206h-2h.208a6%206%200%200%201%20-5.012%20-2.7a69.74%2069.74%200%200%201%20-.196%20-.3c-.312%20-.479%20-1.407%20-2.388%20-3.286%20-5.728a1.5%201.5%200%200%201%20.536%20-2.022a1.867%201.867%200%200%201%202.28%20.28l1.47%201.47%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-trash:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%207l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M10%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%207l1%2012a2%202%200%200%200%202%202h8a2%202%200%200%200%202%20-2l1%20-12%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%207v-3a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201v3%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-bold:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M7%205h6a3.5%203.5%200%200%201%200%207h-6z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2012h1a3.5%203.5%200%200%201%200%207h-7v-7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-italic:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M11%205l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M7%2019l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14%205l-4%2014%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-center:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%2012l8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l12%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l5%205l10%20-10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l2%202l4%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-list:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%206l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%206l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2018l0%20.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-range:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M16.375%2014.625L19%2012M19%2012L16.375%209.375M19%2012H12H5M5%2012L7.625%209.375M5%2012L7.625%2014.625%22%20%2F%3E%0A%20%20%3Crect%20x%3D%222%22%20y%3D%226%22%20width%3D%220%22%20height%3D%2212%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%20%20%3Crect%20x%3D%2222%22%20y%3D%226%22%20width%3D%220%22%20height%3D%2212%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-light-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2012m-4%200a4%204%200%201%200%208%200a4%204%200%201%200%20-8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h1m8%20-9v1m8%208h1m-9%208v1m-6.4%20-15.4l.7%20.7m12.1%20-.7l-.7%20.7m0%2011.4l.7%20.7m-12.1%20-.7l-.7%20.7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-dark-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%203c.132%200%20.263%200%20.393%200a7.5%207.5%200%200%200%207.92%2012.446a9%209%200%201%201%20-8.313%20-12.454z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");}`;
},
/* styles/buttons.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.btn = "bk-btn";
    exports.active = "bk-active";
    exports.btn_default = "bk-btn-default";
    exports.btn_primary = "bk-btn-primary";
    exports.btn_success = "bk-btn-success";
    exports.btn_warning = "bk-btn-warning";
    exports.btn_danger = "bk-btn-danger";
    exports.btn_light = "bk-btn-light";
    exports.btn_group = "bk-btn-group";
    exports.vertical = "bk-vertical";
    exports.horizontal = "bk-horizontal";
    exports.dropdown_toggle = "bk-dropdown-toggle";
    exports.default = `:host{--file:#fff;--file-border:#ccc;--file-hover:#f5f5f5;--file-hover-border:#b8b8b8;--file-active:#ebebeb;--file-active-border:#adadad;--file-disabled:#e6e6e6;--file-disabled-border:#ccc;--default:#fff;--default-border:#ccc;--default-hover:#f5f5f5;--default-hover-border:#b8b8b8;--default-active:#ebebeb;--default-active-border:#adadad;--default-disabled:#e6e6e6;--default-disabled-border:#ccc;--primary:#428bca;--primary-border:#357ebd;--primary-hover:#3681c1;--primary-hover-border:#2c699e;--primary-active:#3276b1;--primary-active-border:#285e8e;--primary-disabled:#506f89;--primary-disabled-border:#357ebd;--success:#5cb85c;--success-border:#4cae4c;--success-hover:#4eb24e;--success-hover-border:#409240;--success-active:#47a447;--success-active-border:#398439;--success-disabled:#667b66;--success-disabled-border:#4cae4c;--warning:#f0ad4e;--warning-border:#eea236;--warning-hover:#eea43b;--warning-hover-border:#e89014;--warning-active:#ed9c28;--warning-active-border:#d58512;--warning-disabled:#c89143;--warning-disabled-border:#eea236;--danger:#d9534f;--danger-border:#d43f3a;--danger-hover:#d5433e;--danger-hover-border:#bd2d29;--danger-active:#d2322d;--danger-active-border:#ac2925;--danger-disabled:#a55350;--danger-disabled-border:#d43f3a;--light:#fff;--light-border:#ccc;--light-hover:#f5f5f5;--light-hover-border:#b8b8b8;--light-active:#ebebeb;--light-active-border:#adadad;--light-disabled:#e6e6e6;--light-disabled-border:#ccc;}.bk-btn,::file-selector-button{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:var(--padding-vertical) var(--padding-horizontal);font-size:var(--font-size);border:var(--border-width) var(--border-style) transparent;border-radius:var(--border-radius);outline:0;outline-offset:-5px;user-select:none;-webkit-user-select:none;}.bk-btn:hover,::file-selector-button:hover,.bk-btn:focus,::file-selector-button:focus{text-decoration:none;}.bk-btn:active,::file-selector-button:active,.bk-active.bk-btn,.bk-active::file-selector-button{background-image:none;box-shadow:var(--box-shadow-inset);}.bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}::file-selector-button{color:var(--color);background-color:var(--file);border-color:var(--file-border);}::file-selector-button:hover{background-color:var(--file-hover);border-color:var(--file-hover-border);}.bk-active::file-selector-button{background-color:var(--file-active);border-color:var(--file-active-border);}::file-selector-button[disabled],::file-selector-button[disabled]:hover,::file-selector-button[disabled]:focus,::file-selector-button[disabled]:active,.bk-active::file-selector-button[disabled]{background-color:var(--file-disabled);border-color:var(--file-disabled-border);}::file-selector-button:focus,::file-selector-button:active{outline:var(--outline);}.bk-btn-default{color:var(--color);background-color:var(--default);border-color:var(--default-border);}.bk-btn-default:hover{background-color:var(--default-hover);border-color:var(--default-hover-border);}.bk-active.bk-btn-default{background-color:var(--default-active);border-color:var(--default-active-border);}.bk-btn-default[disabled],.bk-btn-default[disabled]:hover,.bk-btn-default[disabled]:focus,.bk-btn-default[disabled]:active,.bk-active.bk-btn-default[disabled]{background-color:var(--default-disabled);border-color:var(--default-disabled-border);}.bk-btn-default:focus,.bk-btn-default:active{outline:var(--outline);}.bk-btn-primary{color:var(--inverted-color);background-color:var(--primary);border-color:var(--primary-border);}.bk-btn-primary:hover{background-color:var(--primary-hover);border-color:var(--primary-hover-border);}.bk-active.bk-btn-primary{background-color:var(--primary-active);border-color:var(--primary-active-border);}.bk-btn-primary[disabled],.bk-btn-primary[disabled]:hover,.bk-btn-primary[disabled]:focus,.bk-btn-primary[disabled]:active,.bk-active.bk-btn-primary[disabled]{background-color:var(--primary-disabled);border-color:var(--primary-disabled-border);}.bk-btn-primary:focus,.bk-btn-primary:active{outline:var(--outline);}.bk-btn-success{color:var(--inverted-color);background-color:var(--success);border-color:var(--success-border);}.bk-btn-success:hover{background-color:var(--success-hover);border-color:var(--success-hover-border);}.bk-active.bk-btn-success{background-color:var(--success-active);border-color:var(--success-active-border);}.bk-btn-success[disabled],.bk-btn-success[disabled]:hover,.bk-btn-success[disabled]:focus,.bk-btn-success[disabled]:active,.bk-active.bk-btn-success[disabled]{background-color:var(--success-disabled);border-color:var(--success-disabled-border);}.bk-btn-success:focus,.bk-btn-success:active{outline:var(--outline);}.bk-btn-warning{color:var(--inverted-color);background-color:var(--warning);border-color:var(--warning-border);}.bk-btn-warning:hover{background-color:var(--warning-hover);border-color:var(--warning-hover-border);}.bk-active.bk-btn-warning{background-color:var(--warning-active);border-color:var(--warning-active-border);}.bk-btn-warning[disabled],.bk-btn-warning[disabled]:hover,.bk-btn-warning[disabled]:focus,.bk-btn-warning[disabled]:active,.bk-active.bk-btn-warning[disabled]{background-color:var(--warning-disabled);border-color:var(--warning-disabled-border);}.bk-btn-warning:focus,.bk-btn-warning:active{outline:var(--outline);}.bk-btn-danger{color:var(--inverted-color);background-color:var(--danger);border-color:var(--danger-border);}.bk-btn-danger:hover{background-color:var(--danger-hover);border-color:var(--danger-hover-border);}.bk-active.bk-btn-danger{background-color:var(--danger-active);border-color:var(--danger-active-border);}.bk-btn-danger[disabled],.bk-btn-danger[disabled]:hover,.bk-btn-danger[disabled]:focus,.bk-btn-danger[disabled]:active,.bk-active.bk-btn-danger[disabled]{background-color:var(--danger-disabled);border-color:var(--danger-disabled-border);}.bk-btn-danger:focus,.bk-btn-danger:active{outline:var(--outline);}.bk-btn-light{color:var(--color);background-color:var(--light);border-color:var(--light-border);border-color:transparent;}.bk-btn-light:hover{background-color:var(--light-hover);border-color:var(--light-hover-border);}.bk-active.bk-btn-light{background-color:var(--light-active);border-color:var(--light-active-border);}.bk-btn-light[disabled],.bk-btn-light[disabled]:hover,.bk-btn-light[disabled]:focus,.bk-btn-light[disabled]:active,.bk-active.bk-btn-light[disabled]{background-color:var(--light-disabled);border-color:var(--light-disabled-border);}.bk-btn-light:focus,.bk-btn-light:active{outline:var(--outline);}.bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-btn-group:not(.bk-vertical),.bk-btn-group.bk-horizontal{flex-direction:row;}.bk-btn-group.bk-vertical{flex-direction:column;}.bk-btn-group > .bk-btn{flex-grow:1;}.bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:var(--padding-vertical) calc(var(--padding-horizontal)/2);}`;
},
/* styles/notifications.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{position:fixed;left:50%;top:0.5em;transform:translate(-50%, 0);width:max-content;height:max-content;max-width:50%;}:host > .entries:empty{display:none;}.entries{display:flex;flex-direction:column;flex-wrap:nowrap;gap:0.5em;}.entries > *{padding:0.5em;border:1px solid gray;border-radius:0.5em;}.error{background-color:var(--danger);border-color:var(--danger-border);}.success{background-color:var(--success);border-color:var(--success-border);}.try{font-weight:bold;cursor:pointer;}.try:hover{text-decoration:underline;}.close{display:inline-block;vertical-align:middle;margin-left:1em;width:1em;height:1em;cursor:pointer;mask-image:var(--bokeh-icon-x);-webkit-mask-image:var(--bokeh-icon-x);mask-size:contain;-webkit-mask-size:contain;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-color:black;}.close:hover{background-color:var(--hover-color);}`;
},
/* document/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.decode_def = decode_def;
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(52) /* ../model */;
    const kinds = tslib_1.__importStar(require(22) /* ../core/kinds */);
    const types_1 = require(8) /* ../core/util/types */;
    const object_1 = require(9) /* ../core/util/object */;
    function decode_def(def, deserializer) {
        var _a;
        function kind_of(ref) {
            if ((0, types_1.isString)(ref)) {
                switch (ref) {
                    case "Any": return kinds.Any;
                    case "Unknown": return kinds.Unknown;
                    case "Bool": return kinds.Bool;
                    case "Float": return kinds.Float;
                    case "Int": return kinds.Int;
                    case "Bytes": return kinds.Bytes;
                    case "Str": return kinds.Str;
                    case "Null": return kinds.Null;
                }
            }
            else {
                switch (ref[0]) {
                    case "Regex": {
                        const [, regex, flags] = ref;
                        return kinds.Regex(new RegExp(regex, flags));
                    }
                    case "Nullable": {
                        const [, sub_ref] = ref;
                        return kinds.Nullable(kind_of(sub_ref));
                    }
                    case "Or": {
                        const [, sub_ref, ...sub_refs] = ref;
                        return kinds.Or(kind_of(sub_ref), ...sub_refs.map(kind_of));
                    }
                    case "Tuple": {
                        const [, sub_ref, ...sub_refs] = ref;
                        return kinds.Tuple(kind_of(sub_ref), ...sub_refs.map(kind_of));
                    }
                    case "List": {
                        const [, sub_ref] = ref;
                        return kinds.List(kind_of(sub_ref));
                    }
                    case "Struct": {
                        const [, ...entry_refs] = ref;
                        const entries = entry_refs.map(([key, val_ref]) => [key, kind_of(val_ref)]);
                        return kinds.Struct((0, object_1.to_object)(entries));
                    }
                    case "Dict": {
                        const [, val_ref] = ref;
                        return kinds.Dict(kind_of(val_ref));
                    }
                    case "Mapping": {
                        const [, key_ref, val_ref] = ref;
                        return kinds.Mapping(kind_of(key_ref), kind_of(val_ref));
                    }
                    case "Enum": {
                        const [, ...items] = ref;
                        return kinds.Enum(...items);
                    }
                    case "Ref": {
                        const [, model_ref] = ref;
                        const model = deserializer.resolver.get(model_ref.id);
                        if (model != null) {
                            return kinds.Ref(model);
                        }
                        else {
                            throw new Error(`${model_ref.id} wasn't defined before referencing it`);
                        }
                    }
                    case "AnyRef": {
                        return kinds.AnyRef();
                    }
                }
            }
        }
        const base = (() => {
            const name = def.extends?.id ?? "Model";
            if (name == "Model") {
                // TODO: support base classes in general
                return model_1.Model;
            }
            const base = deserializer.resolver.get(name);
            if (base != null) {
                return base;
            }
            else {
                throw new Error(`base model ${name} of ${def.name} is not defined`);
            }
        })();
        const model = (_a = class extends base {
        },
            tslib_1.__setFunctionName(_a, "model"),
            _a.__qualified__ = def.name,
            _a);
        function decode(value) {
            if (value === undefined) {
                return value;
            }
            else {
                return deserializer.decode(value);
            }
        }
        for (const prop of def.properties ?? []) {
            const kind = kind_of(prop.kind);
            model.define({ [prop.name]: [kind, decode(prop.default)] });
        }
        for (const prop of def.overrides ?? []) {
            model.override({ [prop.name]: decode(prop.default) });
        }
        deserializer.resolver.register(model);
        return model;
    }
},
/* core/bokeh_events.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6;
    __esModule();
    exports.server_event = server_event;
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    const model_1 = require(52) /* ../model */;
    const types_1 = require(8) /* ./util/types */;
    const assert_1 = require(12) /* ./util/assert */;
    const serialization_1 = require(33) /* ./serialization */;
    const deserializer_1 = require(48) /* ./serialization/deserializer */;
    const eq_1 = require(27) /* ./util/eq */;
    deserializer_1.Deserializer.register("event", (rep, deserializer) => {
        const cls = deserializable_events.get(rep.name);
        if (cls !== undefined && cls.from_values != null) {
            const values = deserializer.decode(rep.values);
            (0, assert_1.assert)((0, types_1.isPlainObject)(values));
            return cls.from_values(values);
        }
        else {
            deserializer.error(`deserialization of '${rep.name}' event is not supported`);
        }
    });
    function event(event_name) {
        return (cls) => {
            cls.prototype.event_name = event_name;
        };
    }
    const deserializable_events = new Map();
    /**
     * Marks and registers a class as a one way (server -> client) event.
     */
    function server_event(event_name) {
        return (cls) => {
            if (deserializable_events.has(event_name)) {
                throw new Error(`'${event_name}' event is already registered`);
            }
            deserializable_events.set(event_name, cls);
            cls.prototype.event_name = event_name;
            cls.prototype.publish = false;
        };
    }
    class BokehEvent {
        [serialization_1.serialize](serializer) {
            const { event_name: name, event_values } = this;
            const values = serializer.encode(event_values);
            return { type: "event", name, values };
        }
        [eq_1.equals](that, cmp) {
            return this.event_name == that.event_name && cmp.eq(this.event_values, that.event_values);
        }
    }
    exports.BokehEvent = BokehEvent;
    _a = BokehEvent;
    BokehEvent.__name__ = "BokehEvent";
    (() => {
        _a.prototype.publish = true;
    })();
    class ModelEvent extends BokehEvent {
        constructor() {
            super(...arguments);
            this.origin = null;
        }
        get event_values() {
            return { model: this.origin };
        }
    }
    exports.ModelEvent = ModelEvent;
    ModelEvent.__name__ = "ModelEvent";
    class UserEvent extends ModelEvent {
        constructor(values) {
            super();
            this.values = values;
        }
        get event_values() {
            return { ...super.event_values, ...this.values };
        }
        static from_values(values) {
            const origin = (() => {
                if ("model" in values) {
                    const { model } = values;
                    (0, assert_1.assert)(model === null || model instanceof model_1.Model);
                    delete values.model;
                    return model;
                }
                else {
                    return null;
                }
            })();
            const event = new this(values);
            event.origin = origin;
            return event;
        }
    }
    exports.UserEvent = UserEvent;
    UserEvent.__name__ = "UserEvent";
    class DocumentEvent extends BokehEvent {
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    let DocumentReady = (_b = class DocumentReady extends DocumentEvent {
        get event_values() {
            return {};
        }
    },
        _b.__name__ = "DocumentReady",
        _b);
    exports.DocumentReady = DocumentReady;
    exports.DocumentReady = DocumentReady = __decorate([
        event("document_ready")
    ], DocumentReady);
    class ConnectionEvent extends DocumentEvent {
    }
    exports.ConnectionEvent = ConnectionEvent;
    ConnectionEvent.__name__ = "ConnectionEvent";
    /**
     * Announce when a WebSocket connection was disconnected.
     *
     * @member timestamp when the last connection attempt was made
     * @member attempts  the number of times reconnection was attempted
     * @member timeout   milliseconds till next reconnection attempt or `null`
     *                   indicating that no further attempts will be made
     */
    class ConnectionLost extends ConnectionEvent {
        constructor(connection, attempts, timeout) {
            super();
            this.timestamp = Date.now();
            this.connection = connection;
            this.attempts = attempts;
            this.timeout = timeout;
        }
        get event_values() {
            const { timestamp, attempts, timeout } = this;
            return { timestamp, attempts, timeout };
        }
        reconnect() {
            void this.connection.deref()?.reconnect();
        }
    }
    exports.ConnectionLost = ConnectionLost;
    _c = ConnectionLost;
    ConnectionLost.__name__ = "ConnectionLost";
    (() => {
        _c.prototype.event_name = "connection_lost";
        _c.prototype.publish = false;
    })();
    /**
     * Announce when a connection to the client has been reconnected.
     */
    class ClientReconnected extends ConnectionEvent {
        get event_values() {
            return {};
        }
    }
    exports.ClientReconnected = ClientReconnected;
    _d = ClientReconnected;
    ClientReconnected.__name__ = "ClientReconnected";
    (() => {
        _d.prototype.event_name = "client_reconnected";
    })();
    let AxisClick = (_e = class AxisClick extends ModelEvent {
        constructor(model, value) {
            super();
            this.model = model;
            this.value = value;
        }
        get event_values() {
            const { value } = this;
            return { ...super.event_values, value };
        }
    },
        _e.__name__ = "AxisClick",
        _e);
    exports.AxisClick = AxisClick;
    exports.AxisClick = AxisClick = __decorate([
        event("axis_click")
    ], AxisClick);
    let ButtonClick = (_f = class ButtonClick extends ModelEvent {
    },
        _f.__name__ = "ButtonClick",
        _f);
    exports.ButtonClick = ButtonClick;
    exports.ButtonClick = ButtonClick = __decorate([
        event("button_click")
    ], ButtonClick);
    let LegendItemClick = (_g = class LegendItemClick extends ModelEvent {
        constructor(model, item) {
            super();
            this.model = model;
            this.item = item;
        }
        get event_values() {
            const { item } = this;
            return { ...super.event_values, item };
        }
    },
        _g.__name__ = "LegendItemClick",
        _g);
    exports.LegendItemClick = LegendItemClick;
    exports.LegendItemClick = LegendItemClick = __decorate([
        event("legend_item_click")
    ], LegendItemClick);
    let MenuItemClick = (_h = class MenuItemClick extends ModelEvent {
        constructor(item) {
            super();
            this.item = item;
        }
        get event_values() {
            const { item } = this;
            return { ...super.event_values, item };
        }
    },
        _h.__name__ = "MenuItemClick",
        _h);
    exports.MenuItemClick = MenuItemClick;
    exports.MenuItemClick = MenuItemClick = __decorate([
        event("menu_item_click")
    ], MenuItemClick);
    let ValueSubmit = (_j = class ValueSubmit extends ModelEvent {
        constructor(value) {
            super();
            this.value = value;
        }
        get event_values() {
            const { value } = this;
            return { ...super.event_values, value };
        }
    },
        _j.__name__ = "ValueSubmit",
        _j);
    exports.ValueSubmit = ValueSubmit;
    exports.ValueSubmit = ValueSubmit = __decorate([
        event("value_submit")
    ], ValueSubmit);
    // A UIEvent is an event originating on a canvas this includes.
    // DOM events such as keystrokes as well as hammer, LOD, and range events.
    class UIEvent extends ModelEvent {
    }
    exports.UIEvent = UIEvent;
    UIEvent.__name__ = "UIEvent";
    let LODStart = (_k = class LODStart extends UIEvent {
    },
        _k.__name__ = "LODStart",
        _k);
    exports.LODStart = LODStart;
    exports.LODStart = LODStart = __decorate([
        event("lodstart")
    ], LODStart);
    let LODEnd = (_l = class LODEnd extends UIEvent {
    },
        _l.__name__ = "LODEnd",
        _l);
    exports.LODEnd = LODEnd;
    exports.LODEnd = LODEnd = __decorate([
        event("lodend")
    ], LODEnd);
    let RangesUpdate = (_m = class RangesUpdate extends UIEvent {
        constructor(x0, x1, y0, y1) {
            super();
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
        }
        get event_values() {
            const { x0, x1, y0, y1 } = this;
            return { ...super.event_values, x0, x1, y0, y1 };
        }
    },
        _m.__name__ = "RangesUpdate",
        _m);
    exports.RangesUpdate = RangesUpdate;
    exports.RangesUpdate = RangesUpdate = __decorate([
        event("rangesupdate")
    ], RangesUpdate);
    let SelectionGeometry = (_o = class SelectionGeometry extends UIEvent {
        constructor(geometry, final) {
            super();
            this.geometry = geometry;
            this.final = final;
        }
        get event_values() {
            const { geometry, final } = this;
            return { ...super.event_values, geometry, final };
        }
    },
        _o.__name__ = "SelectionGeometry",
        _o);
    exports.SelectionGeometry = SelectionGeometry;
    exports.SelectionGeometry = SelectionGeometry = __decorate([
        event("selectiongeometry")
    ], SelectionGeometry);
    let Reset = (_p = class Reset extends UIEvent {
    },
        _p.__name__ = "Reset",
        _p);
    exports.Reset = Reset;
    exports.Reset = Reset = __decorate([
        event("reset")
    ], Reset);
    class PointEvent extends UIEvent {
        constructor(sx, sy, x, y, modifiers) {
            super();
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.modifiers = modifiers;
        }
        get event_values() {
            const { sx, sy, x, y, modifiers } = this;
            return { ...super.event_values, sx, sy, x, y, modifiers };
        }
    }
    exports.PointEvent = PointEvent;
    PointEvent.__name__ = "PointEvent";
    let Pan = (_q = class Pan extends PointEvent {
        /* TODO: direction: -1 | 1 */
        constructor(sx, sy, x, y, delta_x, delta_y, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.delta_x = delta_x;
            this.delta_y = delta_y;
        }
        get event_values() {
            const { delta_x, delta_y /*, direction*/ } = this;
            return { ...super.event_values, delta_x, delta_y /*, direction*/ };
        }
    },
        _q.__name__ = "Pan",
        _q);
    exports.Pan = Pan;
    exports.Pan = Pan = __decorate([
        event("pan")
    ], Pan);
    let Pinch = (_r = class Pinch extends PointEvent {
        constructor(sx, sy, x, y, scale, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.scale = scale;
        }
        get event_values() {
            const { scale } = this;
            return { ...super.event_values, scale };
        }
    },
        _r.__name__ = "Pinch",
        _r);
    exports.Pinch = Pinch;
    exports.Pinch = Pinch = __decorate([
        event("pinch")
    ], Pinch);
    let Rotate = (_s = class Rotate extends PointEvent {
        constructor(sx, sy, x, y, rotation, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.rotation = rotation;
        }
        get event_values() {
            const { rotation } = this;
            return { ...super.event_values, rotation };
        }
    },
        _s.__name__ = "Rotate",
        _s);
    exports.Rotate = Rotate;
    exports.Rotate = Rotate = __decorate([
        event("rotate")
    ], Rotate);
    let MouseWheel = (_t = class MouseWheel extends PointEvent {
        constructor(sx, sy, x, y, delta, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.delta = delta;
        }
        get event_values() {
            const { delta } = this;
            return { ...super.event_values, delta };
        }
    },
        _t.__name__ = "MouseWheel",
        _t);
    exports.MouseWheel = MouseWheel;
    exports.MouseWheel = MouseWheel = __decorate([
        event("wheel")
    ], MouseWheel);
    let MouseMove = (_u = class MouseMove extends PointEvent {
    },
        _u.__name__ = "MouseMove",
        _u);
    exports.MouseMove = MouseMove;
    exports.MouseMove = MouseMove = __decorate([
        event("mousemove")
    ], MouseMove);
    let MouseEnter = (_v = class MouseEnter extends PointEvent {
    },
        _v.__name__ = "MouseEnter",
        _v);
    exports.MouseEnter = MouseEnter;
    exports.MouseEnter = MouseEnter = __decorate([
        event("mouseenter")
    ], MouseEnter);
    let MouseLeave = (_w = class MouseLeave extends PointEvent {
    },
        _w.__name__ = "MouseLeave",
        _w);
    exports.MouseLeave = MouseLeave;
    exports.MouseLeave = MouseLeave = __decorate([
        event("mouseleave")
    ], MouseLeave);
    let Tap = (_x = class Tap extends PointEvent {
    },
        _x.__name__ = "Tap",
        _x);
    exports.Tap = Tap;
    exports.Tap = Tap = __decorate([
        event("tap")
    ], Tap);
    let DoubleTap = (_y = class DoubleTap extends PointEvent {
    },
        _y.__name__ = "DoubleTap",
        _y);
    exports.DoubleTap = DoubleTap;
    exports.DoubleTap = DoubleTap = __decorate([
        event("doubletap")
    ], DoubleTap);
    let Press = (_z = class Press extends PointEvent {
    },
        _z.__name__ = "Press",
        _z);
    exports.Press = Press;
    exports.Press = Press = __decorate([
        event("press")
    ], Press);
    let PressUp = (_0 = class PressUp extends PointEvent {
    },
        _0.__name__ = "PressUp",
        _0);
    exports.PressUp = PressUp;
    exports.PressUp = PressUp = __decorate([
        event("pressup")
    ], PressUp);
    let PanStart = (_1 = class PanStart extends PointEvent {
    },
        _1.__name__ = "PanStart",
        _1);
    exports.PanStart = PanStart;
    exports.PanStart = PanStart = __decorate([
        event("panstart")
    ], PanStart);
    let PanEnd = (_2 = class PanEnd extends PointEvent {
    },
        _2.__name__ = "PanEnd",
        _2);
    exports.PanEnd = PanEnd;
    exports.PanEnd = PanEnd = __decorate([
        event("panend")
    ], PanEnd);
    let PinchStart = (_3 = class PinchStart extends PointEvent {
    },
        _3.__name__ = "PinchStart",
        _3);
    exports.PinchStart = PinchStart;
    exports.PinchStart = PinchStart = __decorate([
        event("pinchstart")
    ], PinchStart);
    let PinchEnd = (_4 = class PinchEnd extends PointEvent {
    },
        _4.__name__ = "PinchEnd",
        _4);
    exports.PinchEnd = PinchEnd;
    exports.PinchEnd = PinchEnd = __decorate([
        event("pinchend")
    ], PinchEnd);
    let RotateStart = (_5 = class RotateStart extends PointEvent {
    },
        _5.__name__ = "RotateStart",
        _5);
    exports.RotateStart = RotateStart;
    exports.RotateStart = RotateStart = __decorate([
        event("rotatestart")
    ], RotateStart);
    let RotateEnd = (_6 = class RotateEnd extends PointEvent {
    },
        _6.__name__ = "RotateEnd",
        _6);
    exports.RotateEnd = RotateEnd;
    exports.RotateEnd = RotateEnd = __decorate([
        event("rotateend")
    ], RotateEnd);
},
/* embed/standalone.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.add_document_standalone = add_document_standalone;
    const document_1 = require(5) /* ../document */;
    const view_manager_1 = require(68) /* ../core/view_manager */;
    const dom_view_1 = require(64) /* ../core/dom_view */;
    const types_1 = require(8) /* ../core/util/types */;
    const assert_1 = require(12) /* ../core/util/assert */;
    // A map from the root model IDs to their views.
    exports.index = new Proxy(new view_manager_1.ViewManager(), {
        get(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return view;
                }
            }
            return Reflect.get(manager, property);
        },
        has(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return true;
                }
            }
            return Reflect.has(manager, property);
        },
        ownKeys(manager) {
            return manager.roots.map((root) => root.model.id);
        },
        getOwnPropertyDescriptor(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return { configurable: true, enumerable: true, writable: false, value: view };
                }
            }
            return Reflect.getOwnPropertyDescriptor(manager, property);
        },
    });
    async function add_document_standalone(document, element, roots = [], use_for_title = false) {
        // this is a LOCAL index of views used only by this particular rendering
        // call, so we can remove the views we create.
        (0, assert_1.assert)(document.views_manager == null);
        const views = new view_manager_1.ViewManager([], exports.index);
        document.views_manager = views;
        async function render_view(model) {
            const view = await views.build_view(model);
            if (view instanceof dom_view_1.DOMView) {
                const i = document.all_roots.indexOf(model);
                const root_el = roots[i] ?? element;
                view.build(root_el);
            }
            return view;
        }
        async function render_model(model) {
            if (model.default_view != null) {
                const view = await render_view(model);
                exports.index.add(view);
            }
            else {
                document.notify_idle(model);
            }
        }
        function unrender_model(model) {
            const view = views.get(model);
            view?.remove();
        }
        for (const model of document.all_roots) {
            await render_model(model);
        }
        const { notifications } = document.config;
        if (notifications != null) {
            await render_view(notifications);
        }
        if (use_for_title) {
            window.document.title = document.title();
        }
        document.on_change((event) => {
            if (event instanceof document_1.RootAddedEvent) {
                void render_model(event.model);
            }
            else if (event instanceof document_1.RootRemovedEvent) {
                unrender_model(event.model);
            }
            else if (use_for_title && event instanceof document_1.TitleChangedEvent) {
                window.document.title = event.title;
            }
        });
        return views;
    }
},
/* embed/server.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports._get_ws_url = _get_ws_url;
    exports.add_document_from_session = add_document_from_session;
    const connection_1 = require(83) /* ../client/connection */;
    const logging_1 = require(20) /* ../core/logging */;
    const standalone_1 = require(81) /* ./standalone */;
    // @internal
    function _get_ws_url(app_path, absolute_url) {
        // if in an `srcdoc` iframe, try to get the absolute URL
        // from the `data-absolute-url` attribute if not passed explicitly
        if (absolute_url === undefined && _is_frame_HTMLElement(frameElement) && frameElement.dataset.absoluteUrl !== undefined) {
            absolute_url = frameElement.dataset.absoluteUrl;
        }
        let loc;
        if (absolute_url != null) {
            loc = document.createElement("a");
            loc.href = absolute_url;
        }
        else {
            loc = window.location;
        }
        const protocol = loc.protocol == "https:" ? "wss:" : "ws:";
        if (app_path != null) {
            if (app_path == "/") {
                app_path = "";
            }
        }
        else {
            app_path = loc.pathname.replace(/\/+$/, "");
        }
        return `${protocol}//${loc.host}${app_path}/ws`;
    }
    function _is_frame_HTMLElement(frame) {
        // `frameElement` is a delicate construct; it allows the document inside the frame to access
        // some (but not all) properties of the parent element in which the frame document is embedded.
        // Because it lives in a different DOM context than the frame's `window`, we cannot just use
        // `frameElement instanceof HTMLIFrameElement`; we could use `window.parent.HTMLIFrameElement`
        // but this can be blocked by CORS policy and throw an exception.
        if (frame === null) {
            return false;
        }
        if (frame.tagName.toUpperCase() === "IFRAME") {
            return true;
        }
        return false;
    }
    const _sessions = new Map();
    function _get_session(websocket_url, token, args_string) {
        const session_id = (0, connection_1.parse_token)(token).session_id;
        if (!_sessions.has(websocket_url)) {
            _sessions.set(websocket_url, new Map());
        }
        const subsessions = _sessions.get(websocket_url);
        if (!subsessions.has(session_id)) {
            subsessions.set(session_id, (0, connection_1.pull_session)(websocket_url, token, args_string));
        }
        return subsessions.get(session_id);
    }
    // Fill element with the roots from token
    async function add_document_from_session(websocket_url, token, element, roots = [], use_for_title = false) {
        const args_string = window.location.search.substring(1);
        let session;
        try {
            session = await _get_session(websocket_url, token, args_string);
        }
        catch (error) {
            const session_id = (0, connection_1.parse_token)(token).session_id;
            logging_1.logger.error(`Failed to load Bokeh session ${session_id}: ${error}`);
            throw error;
        }
        return (0, standalone_1.add_document_standalone)(session.document, element, roots, use_for_title);
    }
},
/* client/connection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parse_token = parse_token;
    exports.pull_session = pull_session;
    const bokeh_events_1 = require(80) /* ../core/bokeh_events */;
    const logging_1 = require(20) /* ../core/logging */;
    const document_1 = require(5) /* ../document */;
    const message_1 = require(84) /* ../protocol/message */;
    const receiver_1 = require(85) /* ../protocol/receiver */;
    const session_1 = require(86) /* ./session */;
    const assert_1 = require(12) /* ../core/util/assert */;
    exports.DEFAULT_SERVER_WEBSOCKET_URL = "ws://localhost:5006/ws";
    exports.DEFAULT_TOKEN = "eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";
    const MAX_RECONNECTION_ATTEMPTS = 5;
    const RECONNECT_BASE_DELAY = 1000;
    let _connection_count = 0;
    function parse_token(token) {
        let payload = token.split(".")[0];
        const mod = payload.length % 4;
        if (mod != 0) {
            payload = payload + "=".repeat(4 - mod);
        }
        return JSON.parse(atob(payload.replace(/_/g, "/").replace(/-/g, "+")));
    }
    // WebSocket close event is emitted before page is destroyed, resulting in an
    // unnecessary reconnect attempt and a UI notification just before page reloads.
    let _prevent_reconnect = false;
    addEventListener("beforeunload", () => {
        _prevent_reconnect = true;
    });
    class ClientConnection {
        get reconnection_attempts() {
            return MAX_RECONNECTION_ATTEMPTS - this._reconnection_attempts_left;
        }
        constructor(url = exports.DEFAULT_SERVER_WEBSOCKET_URL, token = exports.DEFAULT_TOKEN, args_string = null) {
            this._number = _connection_count++;
            this.socket = null;
            this.session = null;
            this.closed_permanently = false;
            this._reconnection_attempts_left = MAX_RECONNECTION_ATTEMPTS;
            this._current_handler = null;
            this._pending_replies = new Map();
            this._pending_messages = [];
            this._receiver = new receiver_1.Receiver();
            this.url = url;
            this.token = token;
            this.args_string = args_string;
            this.id = parse_token(token).session_id.split(".")[0];
            logging_1.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`);
        }
        async reconnect() {
            this._try_reconnect(true);
        }
        async connect() {
            if (this.closed_permanently) {
                throw new Error("Cannot connect() a closed ClientConnection");
            }
            if (this.socket != null) {
                throw new Error("Already connected");
            }
            this._current_handler = null;
            this._pending_replies.clear();
            this._pending_messages = [];
            try {
                let versioned_url = `${this.url}`;
                if (this.args_string != null && this.args_string.length > 0) {
                    versioned_url += `?${this.args_string}`;
                }
                this.socket = new WebSocket(versioned_url, ["bokeh", this.token]);
                return new Promise((resolve, reject) => {
                    (0, assert_1.assert)(this.socket != null);
                    // "arraybuffer" gives us binary data we can look at;
                    // if we just needed an opaque blob we could use "blob"
                    this.socket.binaryType = "arraybuffer";
                    this.socket.onopen = () => this._on_open(resolve, reject);
                    this.socket.onmessage = (event) => this._on_message(event);
                    this.socket.onclose = (event) => this._on_close(event, reject);
                    this.socket.onerror = () => this._on_error(reject);
                });
            }
            catch (error) {
                logging_1.logger.error(`websocket creation failed to url: ${this.url}`);
                logging_1.logger.error(` - ${error}`);
                throw error;
            }
        }
        close() {
            if (!this.closed_permanently) {
                logging_1.logger.debug(`Permanently closing websocket connection ${this._number}`);
                this.closed_permanently = true;
                if (this.socket != null) {
                    this.socket.close(1000, `close method called on ClientConnection ${this._number}`);
                }
                this.session._connection_closed();
            }
        }
        _try_reconnect(force = false) {
            if (this.closed_permanently) {
                logging_1.logger.info(`Websocket connection ${this._number} permanently disconnected, will not attempt to reconnect`);
            }
            else if (!force && this._reconnection_attempts_left <= 0) {
                logging_1.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to automatically reconnect`);
            }
            else {
                if (this.socket?.readyState !== WebSocket.OPEN && this.socket?.readyState !== WebSocket.CONNECTING) {
                    this._reconnection_attempts_left -= 1;
                    logging_1.logger.debug(`Attempting to reconnect websocket ${this._number}, ${this._reconnection_attempts_left} attempts left`);
                    this.connect().then(() => {
                        logging_1.logger.info(`Reconnected websocket ${this._number}`);
                        this._reconnection_attempts_left = MAX_RECONNECTION_ATTEMPTS;
                        this.session?.document.event_manager.send_event(new bokeh_events_1.ClientReconnected());
                    }).catch(err => {
                        logging_1.logger.debug(`Could not reconnect ${this._number}, ${err}`);
                    });
                }
            }
        }
        _schedule_reconnect(milliseconds) {
            if (this.session == null) {
                return;
            }
            const { document } = this.session;
            const should_reconnect = document.config.reconnect_session && this._reconnection_attempts_left > 0;
            const timeout = should_reconnect ? milliseconds : null;
            const event = new bokeh_events_1.ConnectionLost(new WeakRef(this), this.reconnection_attempts, timeout);
            document.event_manager.send_event(event);
            if (should_reconnect) {
                setTimeout(() => this._try_reconnect(), milliseconds);
            }
        }
        send(message) {
            if (this.socket != null) {
                message.send(this.socket);
            }
            else {
                logging_1.logger.error("not connected so cannot send", message);
            }
        }
        async send_with_reply(message) {
            const reply = await new Promise((resolve, reject) => {
                this._pending_replies.set(message.msgid(), { resolve, reject });
                this.send(message);
            });
            if (reply.msgtype() == "ERROR") {
                throw new Error(`Error reply ${reply.content.text}`);
            }
            else {
                return reply;
            }
        }
        async _pull_doc_json() {
            const message = message_1.Message.create("PULL-DOC-REQ", {}, {});
            const reply = await this.send_with_reply(message);
            if (!("doc" in reply.content)) {
                throw new Error("No 'doc' field in PULL-DOC-REPLY");
            }
            return reply.content.doc;
        }
        async _repull_session_doc(resolve, reject) {
            logging_1.logger.debug(this.session != null ? "Repulling session" : "Pulling session for first time");
            try {
                const doc_json = await this._pull_doc_json();
                if (this.session == null) {
                    if (this.closed_permanently) {
                        logging_1.logger.debug("Got new document after connection was already closed");
                        reject(new Error("The connection has been closed"));
                    }
                    else {
                        const events = [];
                        const document = document_1.Document.from_json(doc_json, events);
                        this.session = new session_1.ClientSession(this, document);
                        // Send back change events that happened during model initialization.
                        for (const event of events) {
                            document._trigger_on_change(event);
                        }
                        for (const msg of this._pending_messages) {
                            this.session.handle(msg);
                        }
                        this._pending_messages = [];
                        logging_1.logger.debug("Created a new session from new pulled doc");
                        resolve(this.session);
                    }
                }
                else {
                    this.session.document.replace_with_json(doc_json);
                    logging_1.logger.debug("Updated existing session with new pulled doc");
                    resolve(this.session);
                }
            }
            catch (error) {
                console.trace(error);
                logging_1.logger.error(`Failed to repull session ${error}`);
                reject(error instanceof Error ? error : `${error}`);
            }
        }
        _on_open(resolve, reject) {
            logging_1.logger.info(`Websocket connection ${this._number} is now open`);
            this._current_handler = (message) => {
                this._awaiting_ack_handler(message, resolve, reject);
            };
        }
        _on_message(event) {
            if (this._current_handler == null) {
                logging_1.logger.error("Got a message with no current handler set");
            }
            try {
                this._receiver.consume(event.data);
            }
            catch (e) {
                this._close_bad_protocol(`${e}`);
            }
            const msg = this._receiver.message;
            if (msg != null) {
                const problem = msg.problem();
                if (problem != null) {
                    this._close_bad_protocol(problem);
                }
                this._current_handler(msg);
            }
        }
        /**
         * The reconnect delay exponentially increases after each attempt. The
         * first attempt is done immediately.
         */
        _reconnect_delay() {
            const retries = MAX_RECONNECTION_ATTEMPTS - this._reconnection_attempts_left;
            return retries == 0 ? 0 : RECONNECT_BASE_DELAY * 2 ** retries;
        }
        _on_close(event, reject) {
            logging_1.logger.info(`Lost websocket ${this._number} connection, ${event.code} (${event.reason})`);
            this.socket = null;
            this._pending_replies.forEach((pr) => pr.reject("Disconnected"));
            this._pending_replies.clear();
            if (!this.closed_permanently && !_prevent_reconnect) {
                logging_1.logger.debug(`Pending schedule_reconnect for ${this._number}`);
                this._schedule_reconnect(this._reconnect_delay());
            }
            reject(new Error(`Lost websocket connection, ${event.code} (${event.reason})`));
        }
        _on_error(reject) {
            logging_1.logger.debug(`Websocket error on socket ${this._number}`);
            const msg = "Could not open websocket";
            logging_1.logger.error(`Failed to connect to Bokeh server: ${msg}`);
            reject(new Error(msg));
        }
        _close_bad_protocol(detail) {
            logging_1.logger.error(`Closing connection: ${detail}`);
            if (this.socket != null) {
                this.socket.close(1002, detail);
            } // 1002 = protocol error
        }
        _awaiting_ack_handler(message, resolve, reject) {
            if (message.msgtype() === "ACK") {
                this._current_handler = (message) => this._steady_state_handler(message);
                // Reload any sessions
                void this._repull_session_doc(resolve, reject);
            }
            else {
                this._close_bad_protocol("First message was not an ACK");
            }
        }
        _steady_state_handler(message) {
            const reqid = message.reqid();
            const pr = this._pending_replies.get(reqid);
            if (pr != null) {
                this._pending_replies.delete(reqid);
                pr.resolve(message);
            }
            else if (this.session != null) {
                this.session.handle(message);
            }
            else if (message.msgtype() != "PATCH-DOC") {
                // This branch can be executed only before we get the document.
                // When we get the document, all of the patches will already be incorporated.
                // In general, it's not possible to apply patches received before the document,
                // since they may change some models that were removed before serving the document.
                this._pending_messages.push(message);
            }
        }
    }
    exports.ClientConnection = ClientConnection;
    ClientConnection.__name__ = "ClientConnection";
    function pull_session(url, token, args_string) {
        const connection = new ClientConnection(url, token, args_string);
        return connection.connect();
    }
},
/* protocol/message.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(33) /* ../core/serialization */;
    const string_1 = require(41) /* ../core/util/string */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Message {
        get buffers() {
            return this._buffers;
        }
        constructor(header, metadata, content) {
            this._buffers = new Map();
            this.header = header;
            this.metadata = metadata;
            this.content = content;
        }
        static assemble(header_json, metadata_json, content_json) {
            const header = JSON.parse(header_json);
            const metadata = JSON.parse(metadata_json);
            const content = JSON.parse(content_json);
            return new Message(header, metadata, content);
        }
        assemble_buffer(buf_header, buf_payload) {
            const nb = this.header.num_buffers ?? 0;
            if (nb <= this._buffers.size) {
                throw new Error(`too many buffers received, expecting ${nb}`);
            }
            const { id } = JSON.parse(buf_header);
            this._buffers.set(id, buf_payload);
        }
        static create(msgtype, metadata, content) {
            const header = Message.create_header(msgtype);
            return new Message(header, metadata, content);
        }
        static create_header(msgtype) {
            return {
                msgid: (0, string_1.unique_id)(),
                msgtype,
            };
        }
        complete() {
            const { num_buffers } = this.header;
            return num_buffers == null || this._buffers.size == num_buffers;
        }
        send(socket) {
            (0, assert_1.assert)(this.header.num_buffers == null);
            const buffers = [];
            const content_json = JSON.stringify(this.content, (_, val) => {
                if (val instanceof serialization_1.Buffer) {
                    const ref = { id: `${buffers.length}` };
                    buffers.push([ref, val.buffer]);
                    return ref;
                }
                else {
                    return val;
                }
            });
            const num_buffers = buffers.length;
            if (num_buffers > 0) {
                this.header.num_buffers = num_buffers;
            }
            const header_json = JSON.stringify(this.header);
            const metadata_json = JSON.stringify(this.metadata);
            socket.send(header_json);
            socket.send(metadata_json);
            socket.send(content_json);
            for (const [ref, buffer] of buffers) {
                socket.send(JSON.stringify(ref));
                socket.send(buffer);
            }
        }
        msgid() {
            return this.header.msgid;
        }
        msgtype() {
            return this.header.msgtype;
        }
        reqid() {
            return this.header.reqid;
        }
        // return the reason we should close on bad protocol, if there is one
        problem() {
            if (!("msgid" in this.header)) {
                return "No msgid in header";
            }
            else if (!("msgtype" in this.header)) {
                return "No msgtype in header";
            }
            else {
                return null;
            }
        }
    }
    exports.Message = Message;
    Message.__name__ = "Message";
},
/* protocol/receiver.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const message_1 = require(84) /* ./message */;
    const types_1 = require(8) /* ../core/util/types */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Receiver {
        constructor() {
            this.message = null;
            this._partial = null;
            this._fragments = [];
            this._buf_header = null;
            this._current_consumer = this._HEADER;
        }
        consume(fragment) {
            this._current_consumer(fragment);
        }
        _HEADER(fragment) {
            this._assume_text(fragment);
            this.message = null;
            this._partial = null;
            this._fragments = [fragment];
            this._buf_header = null;
            this._current_consumer = this._METADATA;
        }
        _METADATA(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            this._current_consumer = this._CONTENT;
        }
        _CONTENT(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            const [header_json, metadata_json, content_json] = this._fragments;
            (0, assert_1.assert)(header_json != null && metadata_json != null && content_json != null);
            this._partial = message_1.Message.assemble(header_json, metadata_json, content_json);
            this._check_complete();
        }
        _BUFFER_HEADER(fragment) {
            this._assume_text(fragment);
            this._buf_header = fragment;
            this._current_consumer = this._BUFFER_PAYLOAD;
        }
        _BUFFER_PAYLOAD(fragment) {
            this._assume_binary(fragment);
            (0, assert_1.assert)(this._partial != null && this._buf_header != null);
            this._partial.assemble_buffer(this._buf_header, fragment);
            this._check_complete();
        }
        _assume_text(fragment) {
            if (!(0, types_1.isString)(fragment)) {
                throw new Error("Expected text fragment but received binary fragment");
            }
        }
        _assume_binary(fragment) {
            if (!(fragment instanceof ArrayBuffer)) {
                throw new Error("Expected binary fragment but received text fragment");
            }
        }
        _check_complete() {
            if (this._partial.complete()) {
                this.message = this._partial;
                this._current_consumer = this._HEADER;
            }
            else {
                this._current_consumer = this._BUFFER_HEADER;
            }
        }
    }
    exports.Receiver = Receiver;
    Receiver.__name__ = "Receiver";
},
/* client/session.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const message_1 = require(84) /* ../protocol/message */;
    const logging_1 = require(20) /* ../core/logging */;
    class ClientSession {
        constructor(_connection, document) {
            this._document_listener = (event) => {
                this._document_changed(event);
            };
            this._connection = _connection;
            this.document = document;
            this.document.on_change(this._document_listener, true);
        }
        // XXX: this is only needed in tests
        get id() {
            return this._connection.id;
        }
        handle(message) {
            const msgtype = message.msgtype();
            switch (msgtype) {
                case "PATCH-DOC": {
                    this._handle_patch(message);
                    break;
                }
                case "OK": {
                    this._handle_ok(message);
                    break;
                }
                case "ERROR": {
                    this._handle_error(message);
                    break;
                }
                default:
                    logging_1.logger.debug(`Doing nothing with message '${msgtype}'`);
            }
        }
        // TODO: notify_connection_retry ?
        // data: time (ms) to next retry, connection attempt number
        close() {
            this._connection.close();
        }
        /*protected*/ _connection_closed() {
            this.document.remove_on_change(this._document_listener);
        }
        // Sends a request to the server for info about the server, such as its Bokeh
        // version. Returns a promise, the value of the promise is a free-form dictionary
        // of server details.
        async request_server_info() {
            const message = message_1.Message.create("SERVER-INFO-REQ", {}, {});
            const reply = await this._connection.send_with_reply(message);
            return reply.content;
        }
        // Sends some request to the server (no guarantee about which one) and returns
        // a promise which is completed when the server replies. The purpose of this
        // is that if you wait for the promise to be completed, you know the server
        // has processed the request. This is useful when writing tests because once
        // the server has processed this request it should also have processed any
        // events or requests you sent previously, which means you can check for the
        // results of that processing without a race condition. (This assumes the
        // server processes events in sequence, which it mostly has to semantically,
        // since reordering events might change the final state.)
        async force_roundtrip() {
            await this.request_server_info();
        }
        _document_changed(event) {
            const events = (() => {
                const events = event instanceof document_1.DocumentEventBatch ? (event.sync ? event.events : []) : [event];
                return events.filter((event) => event.sync);
            })();
            if (events.length == 0) {
                return;
            }
            const patch = this.document.create_json_patch(events);
            // TODO (havocp) the connection may be closed here, which will
            // cause this send to throw an error - need to deal with it more cleanly.
            const message = message_1.Message.create("PATCH-DOC", {}, patch);
            this._connection.send(message);
        }
        _handle_patch(message) {
            this.document.apply_json_patch(message.content, message.buffers);
        }
        _handle_ok(message) {
            logging_1.logger.trace(`Unhandled OK reply to ${message.reqid()}`);
        }
        _handle_error(message) {
            logging_1.logger.error(`Unhandled ERROR reply to ${message.reqid()}: ${message.content.text}`);
        }
    }
    exports.ClientSession = ClientSession;
    ClientSession.__name__ = "ClientSession";
},
/* embed/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports._resolve_element = _resolve_element;
    exports._resolve_root_elements = _resolve_root_elements;
    const dom_1 = require(61) /* ../core/dom */;
    const types_1 = require(8) /* ../core/util/types */;
    function _get_element(target) {
        let element = (0, types_1.isString)(target) ? document.getElementById(target) : target;
        if (element == null) {
            throw new Error(`Error rendering Bokeh model: could not find ${(0, types_1.isString)(target) ? `#${target}` : target} HTML tag`);
        }
        if (!(0, dom_1.contains)(document.body, element)) {
            throw new Error(`Error rendering Bokeh model: element ${(0, types_1.isString)(target) ? `#${target}` : target} must be under <body>`);
        }
        // If autoload script, replace script tag with div for embedding.
        if (element instanceof HTMLElement && element.tagName == "SCRIPT") {
            const root_el = (0, dom_1.div)();
            element.replaceWith(root_el);
            element = root_el;
        }
        return element;
    }
    function _resolve_element(item) {
        const { elementid } = item;
        if (elementid != null) {
            return _get_element(elementid);
        }
        else {
            return document.body;
        }
    }
    function _resolve_root_elements(item) {
        const roots = [];
        if (item.root_ids != null && item.roots != null) {
            for (const root_id of item.root_ids) {
                roots.push(_get_element(item.roots[root_id]));
            }
        }
        return roots;
    }
},
/* embed/notebook.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.embed_items_notebook = embed_items_notebook;
    const document_1 = require(5) /* ../document */;
    const receiver_1 = require(85) /* ../protocol/receiver */;
    const logging_1 = require(20) /* ../core/logging */;
    const object_1 = require(9) /* ../core/util/object */;
    const standalone_1 = require(81) /* ./standalone */;
    const dom_1 = require(87) /* ./dom */;
    // This exists to allow the @bokeh/jupyter_bokeh extension to store the
    // notebook kernel so that _init_comms can register the comms target.
    // This has to be available at Bokeh.embed.kernels in JupyterLab.
    exports.kernels = {};
    function _handle_notebook_comms(receiver, comm_msg) {
        if (comm_msg.buffers.length > 0) {
            receiver.consume(comm_msg.buffers[0].buffer);
        }
        else {
            receiver.consume(comm_msg.content.data);
        }
        const msg = receiver.message;
        if (msg != null) {
            this.apply_json_patch(msg.content, msg.buffers);
        }
    }
    function _init_comms(target, doc) {
        if (typeof Jupyter !== "undefined" && Jupyter.notebook.kernel != null) {
            logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
            const comm_manager = Jupyter.notebook.kernel.comm_manager;
            try {
                comm_manager.register_target(target, (comm) => {
                    logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.on_msg(_handle_notebook_comms.bind(doc, r));
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (doc.roots()[0].id in exports.kernels) {
            logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
            const kernel = exports.kernels[doc.roots()[0].id];
            try {
                kernel.registerCommTarget(target, (comm) => {
                    logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.onMsg = _handle_notebook_comms.bind(doc, r);
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (typeof google != "undefined" && google.colab.kernel != null) {
            logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
            const comm_manager = google.colab.kernel.comms;
            try {
                comm_manager.registerTarget(target, async (comm) => {
                    logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    for await (const message of comm.messages) {
                        const content = { data: message.data };
                        const buffers = [];
                        for (const buffer of message.buffers ?? []) {
                            buffers.push(new DataView(buffer));
                        }
                        const msg = { content, buffers };
                        _handle_notebook_comms.bind(doc)(r, msg);
                    }
                });
            }
            catch (e) {
                logging_1.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else {
            console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.");
        }
    }
    async function embed_items_notebook(docs_json, render_items) {
        if ((0, object_1.size)(docs_json) != 1) {
            throw new Error("embed_items_notebook expects exactly one document in docs_json");
        }
        const document = document_1.Document.from_json((0, object_1.values)(docs_json)[0]);
        for (const item of render_items) {
            if (item.notebook_comms_target != null) {
                _init_comms(item.notebook_comms_target, document);
            }
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            await (0, standalone_1.add_document_standalone)(document, element, roots);
            for (const root of roots) {
                if (root instanceof HTMLElement) {
                    root.removeAttribute("id");
                }
            }
        }
    }
},
/* protocol/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(84) /* ./message */, exports);
    tslib_1.__exportStar(require(85) /* ./receiver */, exports);
},
/* safely.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.safely = safely;
    // Keep this code as terse and as close to vanila JS as possible. If we
    // arrived here, it means we should trust no one and need to act properly.
    function _burst_into_flames(error) {
        // Make box
        const box = document.createElement("div");
        box.style.backgroundColor = "#f2dede";
        box.style.border = "1px solid #a94442";
        box.style.borderRadius = "4px";
        box.style.display = "inline-block";
        box.style.fontFamily = "sans-serif";
        box.style.marginTop = "5px";
        box.style.minWidth = "200px";
        box.style.padding = "5px 5px 5px 10px";
        box.classList.add("bokeh-error-box-into-flames");
        // Make button
        const button = document.createElement("span");
        button.style.backgroundColor = "#a94442";
        button.style.borderRadius = "0px 4px 0px 0px";
        button.style.color = "white";
        button.style.cursor = "pointer";
        button.style.cssFloat = "right";
        button.style.fontSize = "0.8em";
        button.style.margin = "-6px -6px 0px 0px";
        button.style.padding = "2px 5px 4px 5px";
        button.title = "close";
        button.setAttribute("aria-label", "close");
        button.appendChild(document.createTextNode("x"));
        button.addEventListener("click", () => body.removeChild(box));
        // Make title
        const title = document.createElement("h3");
        title.style.color = "#a94442";
        title.style.margin = "8px 0px 0px 0px";
        title.style.padding = "0px";
        title.appendChild(document.createTextNode("Bokeh Error"));
        // Make message
        const message = document.createElement("pre");
        message.style.whiteSpace = "unset";
        message.style.overflowX = "auto";
        message.appendChild(document.createTextNode(error));
        // Add pieces to box
        box.appendChild(button);
        box.appendChild(title);
        box.appendChild(message);
        // Put box in doc
        const body = document.getElementsByTagName("body")[0];
        body.insertBefore(box, body.firstChild);
    }
    function safely(fn, silent = false) {
        try {
            return fn();
        }
        catch (error) {
            const text = error instanceof Error && error.stack != null ? error.stack : `${error}`;
            _burst_into_flames(text);
            if (!silent) {
                throw error;
            }
            else {
                return;
            }
        }
    }
},
/* models/main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const AllModels = tslib_1.__importStar(require(92) /* ./ */);
    (0, base_1.register_models)(AllModels);
    const DOMModels = tslib_1.__importStar(require(559) /* ./dom */);
    (0, base_1.register_models)(DOMModels);
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(93) /* ./annotations */, exports);
    tslib_1.__exportStar(require(278) /* ./axes */, exports);
    tslib_1.__exportStar(require(352) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(362) /* ./canvas */, exports);
    tslib_1.__exportStar(require(363) /* ./comparisons */, exports);
    tslib_1.__exportStar(require(367) /* ./coordinates */, exports);
    tslib_1.__exportStar(require(368) /* ./expressions */, exports);
    tslib_1.__exportStar(require(377) /* ./filters */, exports);
    tslib_1.__exportStar(require(256) /* ./formatters */, exports);
    tslib_1.__exportStar(require(386) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(428) /* ./graphics */, exports);
    tslib_1.__exportStar(require(429) /* ./graphs */, exports);
    tslib_1.__exportStar(require(433) /* ./grids */, exports);
    tslib_1.__exportStar(require(434) /* ./layouts */, exports);
    tslib_1.__exportStar(require(284) /* ./mappers */, exports);
    tslib_1.__exportStar(require(453) /* ./misc */, exports);
    tslib_1.__exportStar(require(455) /* ./text */, exports);
    tslib_1.__exportStar(require(456) /* ./transforms */, exports);
    tslib_1.__exportStar(require(465) /* ./plots */, exports);
    tslib_1.__exportStar(require(471) /* ./policies */, exports);
    tslib_1.__exportStar(require(472) /* ./random */, exports);
    tslib_1.__exportStar(require(271) /* ./ranges */, exports);
    tslib_1.__exportStar(require(474) /* ./renderers */, exports);
    tslib_1.__exportStar(require(269) /* ./scales */, exports);
    tslib_1.__exportStar(require(477) /* ./selections */, exports);
    tslib_1.__exportStar(require(478) /* ./selectors */, exports);
    tslib_1.__exportStar(require(483) /* ./sources */, exports);
    tslib_1.__exportStar(require(213) /* ./tickers */, exports);
    tslib_1.__exportStar(require(488) /* ./tiles */, exports);
    tslib_1.__exportStar(require(497) /* ./textures */, exports);
    tslib_1.__exportStar(require(501) /* ./ui */, exports);
    tslib_1.__exportStar(require(512) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var area_visuals_1 = require(94) /* ./area_visuals */;
    __esExport("AreaVisuals", area_visuals_1.AreaVisuals);
    var annotation_1 = require(96) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(140) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(182) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(182) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(182) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(182) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(182) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var base_color_bar_1 = require(184) /* ./base_color_bar */;
    __esExport("BaseColorBar", base_color_bar_1.BaseColorBar);
    var band_1 = require(273) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(275) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    __esExport("BoxInteractionHandles", box_annotation_1.BoxInteractionHandles);
    var color_bar_1 = require(277) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var contour_color_bar_1 = require(294) /* ./contour_color_bar */;
    __esExport("ContourColorBar", contour_color_bar_1.ContourColorBar);
    var label_1 = require(295) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(296) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(297) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(298) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(300) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var scale_bar_1 = require(301) /* ./scale_bar */;
    __esExport("ScaleBar", scale_bar_1.ScaleBar);
    var dimensional_1 = require(302) /* ./dimensional */;
    __esExport("Metric", dimensional_1.Metric);
    __esExport("ReciprocalMetric", dimensional_1.ReciprocalMetric);
    __esExport("MetricLength", dimensional_1.MetricLength);
    __esExport("ReciprocalMetricLength", dimensional_1.ReciprocalMetricLength);
    __esExport("ImperialLength", dimensional_1.ImperialLength);
    __esExport("Angular", dimensional_1.Angular);
    var size_bar_1 = require(303) /* ./size_bar */;
    __esExport("SizeBar", size_bar_1.SizeBar);
    var slope_1 = require(344) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(345) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(186) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(185) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(334) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var whisker_1 = require(346) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
    tslib_1.__exportStar(require(347) /* ./html */, exports);
},
/* models/annotations/area_visuals.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(52) /* ../../model */;
    const mixins = tslib_1.__importStar(require(95) /* ../../core/property_mixins */);
    class AreaVisuals extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        clone(attrs) {
            return super.clone(attrs);
        }
    }
    exports.AreaVisuals = AreaVisuals;
    _a = AreaVisuals;
    AreaVisuals.__name__ = "AreaVisuals";
    (() => {
        _a.mixins([
            mixins.Line,
            mixins.Fill,
            mixins.Hatch,
            ["hover_", mixins.Line],
            ["hover_", mixins.Fill],
            ["hover_", mixins.Hatch],
        ]);
    })();
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.attrs_of = attrs_of;
    const tslib_1 = require(1) /* tslib */;
    const p = tslib_1.__importStar(require(19) /* ./properties */);
    const enums_1 = require(21) /* ./enums */;
    const k = tslib_1.__importStar(require(22) /* ./kinds */);
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Float, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Float)), []],
        line_dash_offset: [k.Float, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Image = {
        global_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Float, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.Str)), null],
        hatch_weight: [k.Float, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}], // XXX: recursive imports
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_outline_color: [k.Nullable(k.Color), null],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Float, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.ImageScalar = {
        global_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.DictScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_outline_color: [p.ColorScalar, null],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.ImageVector = {
        global_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.DictScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_outline_color: [p.ColorSpec, null],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, new_prefix = false) {
        const attrs = {};
        for (const attr of (0, object_1.keys)(mixin)) {
            const prefixed_attr = `${prefix}${attr}`;
            const value = model[prefixed_attr];
            const new_attr = (() => {
                if ((0, types_1.isString)(new_prefix)) {
                    return `${new_prefix}${attr}`;
                }
                else if (new_prefix) {
                    return prefixed_attr;
                }
                else {
                    return attr;
                }
            })();
            attrs[new_attr] = value;
        }
        return attrs;
    }
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const composite_renderer_1 = require(97) /* ../renderers/composite_renderer */;
    class AnnotationView extends composite_renderer_1.CompositeRendererView {
        get bbox() {
            return super.bbox ?? this.layout?.bbox;
        }
        get_size() {
            if (this.displayed) {
                const { width, height } = this._get_size();
                return { width: Math.round(width), height: Math.round(height) };
            }
            else {
                return { width: 0, height: 0 };
            }
        }
        _get_size() {
            throw new Error("not implemented");
        }
        connect_signals() {
            super.connect_signals();
            const p = this.model.properties;
            this.on_change(p.visible, () => {
                if (this.layout != null) {
                    this.layout.visible = this.model.visible;
                    this.plot_view.request_layout();
                }
            });
        }
        get needs_clip() {
            return this.layout == null; // TODO: change this, when center layout is fully implemented
        }
    }
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    class Annotation extends composite_renderer_1.CompositeRenderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Annotation = Annotation;
    _a = Annotation;
    Annotation.__name__ = "Annotation";
    (() => {
        _a.override({
            level: "annotation",
        });
    })();
},
/* models/renderers/composite_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const renderer_1 = require(98) /* ./renderer */;
    const ui_element_1 = require(55) /* ../ui/ui_element */;
    const dom_node_1 = require(130) /* ../dom/dom_node */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const layout_dom_1 = require(131) /* ../layouts/layout_dom */;
    // TODO UIElement needs to inherit from DOMNode
    exports.ElementLike = (0, kinds_1.Or)((0, kinds_1.Ref)(ui_element_1.UIElement), (0, kinds_1.Ref)(dom_node_1.DOMNode));
    class CompositeRendererView extends renderer_1.RendererView {
        constructor() {
            super(...arguments);
            this._renderer_views = new Map();
            this._element_views = new Map();
            this._computed_renderers = [];
            this._computed_elements = [];
        }
        get renderer_views() {
            return this.computed_renderer_views;
        }
        get element_views() {
            return this.computed_element_views;
        }
        *children() {
            yield* super.children();
            yield* this.renderer_views;
            yield* this.element_views;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._build_renderers();
            await this._build_elements();
        }
        get computed_renderers() {
            return [...this.model.renderers, ...this._computed_renderers];
        }
        get computed_renderer_views() {
            return this.computed_renderers.map((item) => this._renderer_views.get(item)).filter((rv) => rv != null);
        }
        async _build_renderers() {
            return await (0, build_views_1.build_views)(this._renderer_views, this.computed_renderers, { parent: this.plot_view });
        }
        get computed_elements() {
            return [...this.model.elements, ...this._computed_elements];
        }
        get computed_element_views() {
            return this.computed_elements.map((item) => this._element_views.get(item)).filter((ev) => ev != null);
        }
        async _build_elements() {
            return await (0, build_views_1.build_views)(this._element_views, this.computed_elements, { parent: (model) => model instanceof layout_dom_1.LayoutDOM ? null : this.plot_view });
        }
        async _update_renderers() {
            await this._build_renderers();
        }
        async _update_elements() {
            const { created } = await this._build_elements();
            const created_views = new Set(created);
            // Since appending to a DOM node will move the node to the end if it has
            // already been added appending all the children in order will result in
            // correct ordering.
            for (const view of this.element_views) {
                const is_new = created_views.has(view);
                const target = view.rendering_target() ?? this.self_target;
                if (is_new) {
                    view.render_to(target);
                }
                else {
                    target.append(view.el);
                }
            }
            this.r_after_render();
        }
        render() {
            super.render();
            for (const element_view of this.element_views) {
                const target = element_view.rendering_target() ?? this.self_target;
                element_view.render_to(target);
            }
        }
        remove() {
            (0, build_views_1.remove_views)(this._renderer_views);
            (0, build_views_1.remove_views)(this._element_views);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { renderers, elements } = this.model.properties;
            this.on_change(renderers, async () => {
                await this._update_renderers();
            });
            this.on_change(elements, async () => {
                await this._update_elements();
            });
        }
        paint(ctx) {
            super.paint(ctx);
            if (this.displayed && this.is_renderable) {
                for (const renderer of this.computed_renderer_views) {
                    renderer.paint(ctx);
                }
            }
            const { displayed } = this;
            for (const element_view of this.element_views) {
                element_view.reposition(displayed);
            }
        }
        has_finished() {
            if (!super.has_finished()) {
                return false;
            }
            for (const renderer_view of this.renderer_views) {
                if (!renderer_view.has_finished()) {
                    return false;
                }
            }
            for (const element_view of this.element_views) {
                if (!element_view.has_finished()) {
                    return false;
                }
            }
            return true;
        }
    }
    exports.CompositeRendererView = CompositeRendererView;
    CompositeRendererView.__name__ = "CompositeRendererView";
    class CompositeRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CompositeRenderer = CompositeRenderer;
    _a = CompositeRenderer;
    CompositeRenderer.__name__ = "CompositeRenderer";
    (() => {
        _a.define(({ List, Ref }) => ({
            renderers: [List(Ref(renderer_1.Renderer)), []],
            elements: [List(exports.ElementLike), []],
        }));
    })();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const styled_element_1 = require(56) /* ../ui/styled_element */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const visuals = tslib_1.__importStar(require(99) /* ../../core/visuals */);
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const coordinate_mapping_1 = require(107) /* ../coordinates/coordinate_mapping */;
    const menu_1 = require(122) /* ../ui/menus/menu */;
    const renderer_group_1 = require(129) /* ./renderer_group */;
    const dom_1 = require(61) /* ../../core/dom */;
    class RendererView extends styled_element_1.StyledElementView {
        constructor() {
            super(...arguments);
            this._panel = null;
            this.position = new dom_1.InlineStyleSheet("", "position");
            this._context_menu = null;
            this._custom_coordinates = null;
        }
        get panel() {
            return this._panel;
        }
        set panel(panel) {
            this._panel = panel;
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.position];
        }
        rendering_target() {
            return this.plot_view.canvas_view.underlays_el;
        }
        get context_menu() {
            return this._context_menu;
        }
        get coordinates() {
            const { _coordinates } = this;
            if (_coordinates != null) {
                return _coordinates;
            }
            else {
                return this._coordinates = this._initialize_coordinates();
            }
        }
        set coordinates(custom_coordinates) {
            this._custom_coordinates = custom_coordinates;
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { context_menu } = this.model;
            if (context_menu != null) {
                this._context_menu = await (0, build_views_1.build_view)(context_menu, { parent: this.plot_view });
            }
        }
        remove() {
            this._context_menu?.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { group } = this.model;
            if (group != null) {
                this.on_change(group.properties.visible, () => {
                    this.model.visible = group.visible;
                });
            }
            const { x_range_name, y_range_name } = this.model.properties;
            this.on_change([x_range_name, y_range_name], () => delete this._coordinates);
            this.connect(this.plot_view.frame.model.change, () => delete this._coordinates);
        }
        _initialize_coordinates() {
            if (this._custom_coordinates != null) {
                return this._custom_coordinates;
            }
            const { coordinates } = this.model;
            const { frame } = this.plot_view;
            if (coordinates != null) {
                return coordinates.get_transform(frame);
            }
            else {
                const { x_range_name, y_range_name } = this.model;
                const x_scale = frame.x_scales.get(x_range_name);
                const y_scale = frame.y_scales.get(y_range_name);
                (0, assert_1.assert)(x_scale != null, `missing '${x_range_name}' range`);
                (0, assert_1.assert)(y_scale != null, `missing '${y_range_name}' range`);
                return new coordinate_mapping_1.CoordinateTransform(x_scale, y_scale);
            }
        }
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        get layer() {
            const { overlays, primary } = this.canvas;
            return this.model.level == "overlay" ? overlays : primary;
        }
        get canvas() {
            return this.plot_view.canvas_view;
        }
        request_paint() {
            this.plot_view.request_paint(this);
        }
        request_layout() {
            this.plot_view.request_layout();
        }
        notify_finished() {
            this.plot_view.notify_finished();
        }
        notify_finished_after_paint() {
            this.plot_view.notify_finished_after_paint();
        }
        get needs_clip() {
            return false;
        }
        get has_webgl() {
            return false;
        }
        /*
        get visible(): boolean {
          const {visible, group} = this.model
          return !visible ? false : (group?.visible ?? true)
        }
        */
        get displayed() {
            return this.model.visible;
        }
        get is_renderable() {
            return true;
        }
        get is_dual_renderer() {
            return false;
        }
        paint(ctx) {
            // It would be better to update geometry (the internal layout) only when
            // necessary, but conditions for that are not clear, so for now update
            // at every paint.
            this.update_geometry();
            this.compute_geometry();
            this.update_position();
            if (this.displayed && this.is_renderable) {
                this._paint(ctx);
            }
            this.mark_finished();
        }
        renderer_view(_renderer) {
            return undefined;
        }
        /**
         * Geometry setup that doesn't change between paints.
         */
        update_geometry() { }
        /**
         * Geometry setup that changes between paints.
         */
        compute_geometry() { }
        /**
         * Updates the position of the associated DOM element.
         */
        update_position() {
            const { bbox, position } = this;
            if (bbox != null && bbox.is_valid) {
                if (this.panel != null) {
                    position.replace(`
        :host {
          position: relative;
          width:    ${bbox.width}px;
          height:   ${bbox.height}px;
        }
        `);
                }
                else {
                    position.replace(`
        :host {
          position: absolute;
          left:     ${bbox.left}px;
          top:      ${bbox.top}px;
          width:    ${bbox.width}px;
          height:   ${bbox.height}px;
        }
        `);
                }
            }
            else {
                position.replace(`
      :host {
        display: none;
      }
      `);
            }
        }
        resolve_frame() {
            return this.plot_view.frame; // TODO CartesianFrameView (PR #13286)
        }
        resolve_canvas() {
            return this.plot_view.canvas;
        }
        resolve_plot() {
            return this.plot_view;
        }
        resolve_symbol(node) {
            const target = this;
            const { bbox } = target;
            if (bbox == null) {
                return { x: NaN, y: NaN };
            }
            else {
                const value = bbox.resolve(node.symbol);
                const { offset } = node;
                if ((0, types_1.isNumber)(value)) {
                    return value + offset;
                }
                else {
                    const { x, y } = value;
                    return { x: x + offset, y: y + offset };
                }
            }
        }
        get attribution() {
            return null;
        }
    }
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    class Renderer extends styled_element_1.StyledElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Renderer = Renderer;
    _a = Renderer;
    Renderer.__name__ = "Renderer";
    (() => {
        _a.define(({ Bool, Str, Ref, Nullable }) => ({
            group: [Nullable(Ref(renderer_group_1.RendererGroup)), null],
            level: [enums_1.RenderLevel, "image"],
            visible: [Bool, true],
            x_range_name: [Str, "default"],
            y_range_name: [Str, "default"],
            coordinates: [Nullable(Ref(coordinate_mapping_1.CoordinateMapping)), null],
            propagate_hover: [Bool, false],
            context_menu: [Nullable(Ref(menu_1.Menu)), null],
        }));
    })();
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const line_1 = require(100) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    const fill_1 = require(102) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    const text_1 = require(103) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    const hatch_1 = require(104) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    const image_1 = require(106) /* ./image */;
    __esExport("Image", image_1.Image);
    __esExport("ImageScalar", image_1.ImageScalar);
    __esExport("ImageVector", image_1.ImageVector);
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    const visual_1 = require(101) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    class Visuals {
        *[Symbol.iterator]() {
            yield* this._visuals;
        }
        constructor(view) {
            this._visuals = [];
            for (const [prefix, mixin] of view.model._mixins) {
                const visual = (() => {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        case mixins.Image: return new image_1.Image(view, prefix);
                        case mixins.ImageScalar: return new image_1.ImageScalar(view, prefix);
                        case mixins.ImageVector: return new image_1.ImageVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                if (visual instanceof visual_1.VisualProperties) {
                    visual.update();
                }
                this._visuals.push(visual);
                Object.defineProperty(this, prefix + visual.type, {
                    get() {
                        return visual;
                    },
                    configurable: false,
                    enumerable: true,
                });
            }
        }
    }
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.resolve_line_dash = resolve_line_dash;
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(101) /* ./visual */;
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    const enums_1 = require(21) /* ../enums */;
    const color_1 = require(23) /* ../util/color */;
    const types_1 = require(8) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if ((0, types_1.isArray)(line_dash)) {
            return line_dash;
        }
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    class Line extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_line_color();
            const alpha = this.get_line_alpha();
            const width = this.get_line_width();
            return !(color == null || alpha == 0 || width == 0);
        }
        apply(ctx, path) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.get_line_color(),
                alpha: this.get_line_alpha(),
                width: this.get_line_width(),
                join: this.get_line_join(),
                cap: this.get_line_cap(),
                dash: this.get_line_dash(),
                offset: this.get_line_dash_offset(),
            };
        }
        computed_values() {
            const color = this.get_line_color();
            const alpha = this.get_line_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
                width: this.get_line_width(),
                join: this.get_line_join(),
                cap: this.get_line_cap(),
                dash: this.get_line_dash(),
                offset: this.get_line_dash_offset(),
            };
        }
        set_value(ctx) {
            const { color, width, join, cap, dash, offset } = this.computed_values();
            ctx.strokeStyle = color;
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.setLineDash(resolve_line_dash(dash));
            ctx.lineDashOffset = offset;
        }
        get_line_color() {
            const css_color = this._get_css_value("line-color");
            if (css_color != "") {
                return css_color;
            }
            return this.line_color.get_value();
        }
        get_line_alpha() {
            const css_alpha = this._get_css_value("line-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.line_alpha.get_value();
        }
        get_line_width() {
            const css_width = this._get_css_value("line-width");
            if (css_width != "") {
                const width = Number(css_width);
                if (isFinite(width)) {
                    return width;
                }
            }
            return this.line_width.get_value();
        }
        get_line_join() {
            const css_join = this._get_css_value("line-join");
            if (enums_1.LineJoin.valid(css_join)) {
                return css_join;
            }
            return this.line_join.get_value();
        }
        get_line_cap() {
            const css_cap = this._get_css_value("line-cap");
            if (enums_1.LineCap.valid(css_cap)) {
                return css_cap;
            }
            return this.line_cap.get_value();
        }
        get_line_dash() {
            const css_dash = this._get_css_value("line-dash");
            if (enums_1.LineDash.valid(css_dash)) {
                return css_dash;
            }
            return this.line_dash.get_value();
        }
        get_line_dash_offset() {
            const css_dash_offset = this._get_css_value("line-dash-offset");
            if (css_dash_offset != "") {
                const dash_offset = Number(css_dash_offset);
                if (isFinite(dash_offset)) {
                    return dash_offset;
                }
            }
            return this.line_dash_offset.get_value();
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    class LineScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            const width = this.line_width.value;
            return !(color == 0 || alpha == 0 || width == 0);
        }
        apply(ctx, path) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.value,
                alpha: this.line_alpha.value,
                width: this.line_width.value,
                join: this.line_join.value,
                cap: this.line_cap.value,
                dash: this.line_dash.value,
                offset: this.line_dash_offset.value,
            };
        }
        set_value(ctx) {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.setLineDash(resolve_line_dash(this.line_dash.value));
            ctx.lineDashOffset = this.line_dash_offset.value;
        }
    }
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    class LineVector extends visual_1.VisualUniforms {
        get doit() {
            const { line_color } = this;
            if (line_color.is_Scalar() && line_color.value == 0) {
                return false;
            }
            const { line_alpha } = this;
            if (line_alpha.is_Scalar() && line_alpha.value == 0) {
                return false;
            }
            const { line_width } = this;
            if (line_width.is_Scalar() && line_width.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.line_color.get(i) == 0) {
                return false;
            }
            if (this.line_alpha.get(i) == 0) {
                return false;
            }
            if (this.line_width.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values(i) {
            return {
                color: this.line_color.get(i),
                alpha: this.line_alpha.get(i),
                width: this.line_width.get(i),
                join: this.line_join.get(i),
                cap: this.line_cap.get(i),
                dash: this.line_dash.get(i),
                offset: this.line_dash_offset.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.line_color.get(i);
            const alpha = this.line_alpha.get(i);
            const width = this.line_width.get(i);
            const join = this.line_join.get(i);
            const cap = this.line_cap.get(i);
            const dash = this.line_dash.get(i);
            const offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.setLineDash(resolve_line_dash(dash));
            ctx.lineDashOffset = offset;
        }
    }
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const global_css_prefix = "--bk-";
    class VisualProperties {
        *[Symbol.iterator]() {
            yield* this._props;
        }
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            this.css_prefix = `${global_css_prefix}${prefix.replaceAll("_", "-")}`;
            const self = this;
            this._props = [];
            for (const attr of this.attrs) {
                const prop = obj.model.properties[prefix + attr];
                prop.change.connect(() => this.update());
                self[attr] = prop;
                this._props.push(prop);
            }
        }
        update() { }
        _get_css_value(name) {
            const style = getComputedStyle(this.obj.el);
            return style.getPropertyValue(`${this.css_prefix}${name}`);
        }
    }
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    class VisualUniforms {
        *[Symbol.iterator]() {
            for (const attr of this.attrs) {
                yield this.obj.model.properties[this.prefix + attr];
            }
        }
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            for (const attr of this.attrs) {
                Object.defineProperty(this, attr, {
                    get() {
                        return obj[prefix + attr];
                    },
                });
            }
        }
        update() { }
    }
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(101) /* ./visual */;
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    const color_1 = require(23) /* ../util/color */;
    class Fill extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_fill_color();
            const alpha = this.get_fill_alpha();
            return !(color == null || alpha == 0);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.get_fill_color(),
                alpha: this.get_fill_alpha(),
            };
        }
        computed_values() {
            const color = this.get_fill_color();
            const alpha = this.get_fill_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
            };
        }
        set_value(ctx) {
            const { color } = this.computed_values();
            ctx.fillStyle = color;
        }
        get_fill_color() {
            const css_color = this._get_css_value("fill-color");
            if (css_color != "") {
                return css_color;
            }
            return this.fill_color.get_value();
        }
        get_fill_alpha() {
            const css_alpha = this._get_css_value("fill-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.fill_alpha.get_value();
        }
    }
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    class FillScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.value,
                alpha: this.fill_alpha.value,
            };
        }
        set_value(ctx) {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    class FillVector extends visual_1.VisualUniforms {
        get doit() {
            const { fill_color } = this;
            if (fill_color.is_Scalar() && fill_color.value == 0) {
                return false;
            }
            const { fill_alpha } = this;
            if (fill_alpha.is_Scalar() && fill_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.fill_color.get(i) == 0) {
                return false;
            }
            if (this.fill_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path_or_rule, rule = "nonzero") {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values(i) {
            return {
                color: this.fill_color.get(i),
                alpha: this.fill_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.fill_color.get(i);
            const alpha = this.fill_alpha.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(101) /* ./visual */;
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    const enums_1 = require(21) /* ../enums */;
    const color_1 = require(23) /* ../util/color */;
    const _font_cache = new Map();
    function load_font(font, obj) {
        const objs = _font_cache.get(font);
        if (objs == null) {
            const objs = new WeakSet([obj]);
            _font_cache.set(font, objs);
        }
        else if (!objs.has(obj)) {
            objs.add(obj);
        }
        else {
            return;
        }
        const { fonts } = document;
        if (!fonts.check(font)) {
            void fonts.load(font).then(() => obj.request_paint());
        }
    }
    class Text extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_text_color();
            const alpha = this.get_text_alpha();
            return !(color == null || alpha == 0);
        }
        update() {
            if (!this.doit) {
                return;
            }
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.get_text_color(),
                outline_color: this.get_text_outline_color(),
                alpha: this.get_text_alpha(),
                font: this.get_text_font(),
                font_size: this.get_text_font_size(),
                font_style: this.get_text_font_style(),
                align: this.get_text_align(),
                baseline: this.get_text_baseline(),
                line_height: this.get_text_line_height(),
            };
        }
        computed_values() {
            const color = this.get_text_color();
            const outline_color = this.get_text_outline_color();
            const alpha = this.get_text_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
                outline_color: (0, color_1.color2css)(outline_color, alpha),
                font: this.font_value(),
                text_align: this.get_text_align(),
                text_baseline: this.get_text_baseline(),
                line_height: this.get_text_line_height(),
            };
        }
        set_value(ctx) {
            const { color, outline_color, font, text_align, text_baseline, } = this.computed_values();
            ctx.fillStyle = color;
            ctx.strokeStyle = outline_color;
            ctx.font = font;
            ctx.textAlign = text_align;
            ctx.textBaseline = text_baseline;
        }
        font_value() {
            const style = this.get_text_font_style();
            const size = this.get_text_font_size();
            const face = this.get_text_font();
            return `${style} ${size} ${face}`;
        }
        get_text_color() {
            const css_color = this._get_css_value("text-color");
            if (css_color != "") {
                return css_color;
            }
            return this.text_color.get_value();
        }
        get_text_outline_color() {
            const css_color = this._get_css_value("text-outline-color");
            if (css_color != "") {
                return css_color;
            }
            return this.text_outline_color.get_value();
        }
        get_text_alpha() {
            const css_alpha = this._get_css_value("text-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.text_alpha.get_value();
        }
        get_text_font() {
            const css_font = this._get_css_value("text-font");
            if (css_font != "") {
                return css_font;
            }
            return this.text_font.get_value();
        }
        get_text_font_size() {
            const css_font_size = this._get_css_value("text-font-size");
            if (css_font_size != "") {
                return css_font_size;
            }
            return this.text_font_size.get_value();
        }
        get_text_font_style() {
            const css_font_style = this._get_css_value("text-font-style");
            if (enums_1.FontStyle.valid(css_font_style)) {
                return css_font_style;
            }
            return this.text_font_style.get_value();
        }
        get_text_align() {
            const css_align = this._get_css_value("text-align");
            if (enums_1.TextAlign.valid(css_align)) {
                return css_align;
            }
            return this.text_align.get_value();
        }
        get_text_baseline() {
            const css_baseline = this._get_css_value("text-baseline");
            if (enums_1.TextBaseline.valid(css_baseline)) {
                return css_baseline;
            }
            return this.text_baseline.get_value();
        }
        get_text_line_height() {
            const css_line_height = this._get_css_value("line-height");
            if (css_line_height != "") {
                const line_height = Number(css_line_height);
                if (isFinite(line_height)) {
                    return line_height;
                }
            }
            return this.text_line_height.get_value();
        }
    }
    exports.Text = Text;
    Text.__name__ = "Text";
    class TextScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        update() {
            if (!this.doit) {
                return;
            }
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.text_color.value,
                outline_color: this.text_outline_color.value,
                alpha: this.text_alpha.value,
                font: this.text_font.value,
                font_size: this.text_font_size.value,
                font_style: this.text_font_style.value,
                align: this.text_align.value,
                baseline: this.text_baseline.value,
                line_height: this.text_line_height.value,
            };
        }
        set_value(ctx) {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            const outline_color = this.text_outline_color.value;
            const font = this.font_value();
            const align = this.text_align.value;
            const baseline = this.text_baseline.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value() {
            const style = this.text_font_style.value;
            const size = this.text_font_size.value;
            const face = this.text_font.value;
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    class TextVector extends visual_1.VisualUniforms {
        _assert_font(i) {
            const font = this.font_value(i);
            load_font(font, this.obj);
        }
        values(i) {
            this._assert_font(i);
            return {
                color: this.text_color.get(i),
                outline_color: this.text_outline_color.get(i),
                alpha: this.text_alpha.get(i),
                font: this.text_font.get(i),
                font_size: this.text_font_size.get(i),
                font_style: this.text_font_style.get(i),
                align: this.text_align.get(i),
                baseline: this.text_baseline.get(i),
                line_height: this.text_line_height.get(i),
            };
        }
        get doit() {
            const { text_color } = this;
            if (text_color.is_Scalar() && text_color.value == 0) {
                return false;
            }
            const { text_alpha } = this;
            if (text_alpha.is_Scalar() && text_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.text_color.get(i) == 0) {
                return false;
            }
            if (this.text_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            this._assert_font(i);
            const color = this.text_color.get(i);
            const outline_color = this.text_outline_color.get(i);
            const alpha = this.text_alpha.get(i);
            const font = this.font_value(i);
            const align = this.text_align.get(i);
            const baseline = this.text_baseline.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value(i) {
            const style = this.text_font_style.get(i);
            const size = this.text_font_size.get(i);
            const face = this.text_font.get(i);
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(101) /* ./visual */;
    const patterns_1 = require(105) /* ./patterns */;
    const p = tslib_1.__importStar(require(19) /* ../properties */);
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    const object_1 = require(9) /* ../util/object */;
    class Hatch extends visual_1.VisualProperties {
        constructor() {
            super(...arguments);
            this._update_iteration = 0;
        }
        update() {
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit) {
                return;
            }
            const color = this.get_hatch_color();
            const alpha = this.get_hatch_alpha();
            const scale = this.get_hatch_scale();
            const pattern = this.get_hatch_pattern();
            const weight = this.get_hatch_weight();
            const finalize = (image) => {
                this._hatch_image = image;
            };
            const textures = (0, object_1.dict)(this.get_hatch_extra());
            const texture = textures.get(pattern);
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    void image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_paint();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            const color = this.get_hatch_color();
            const alpha = this.get_hatch_alpha();
            const pattern = this.get_hatch_pattern();
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_value(ctx) {
            const pattern = this.pattern(ctx);
            ctx.fillStyle = pattern ?? "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image;
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition());
            }
        }
        repetition() {
            const pattern = this.get_hatch_pattern();
            const textures = (0, object_1.dict)(this.get_hatch_extra());
            const texture = textures.get(pattern);
            if (texture == null) {
                return "repeat";
            }
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
        get_hatch_color() {
            const css_color = this._get_css_value("hatch-color");
            if (css_color != "") {
                return css_color;
            }
            return this.hatch_color.get_value();
        }
        get_hatch_alpha() {
            const css_alpha = this._get_css_value("hatch-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.hatch_alpha.get_value();
        }
        get_hatch_scale() {
            const css_scale = this._get_css_value("hatch-scale");
            if (css_scale != "") {
                const scale = Number(css_scale);
                if (isFinite(scale)) {
                    return scale;
                }
            }
            return this.hatch_scale.get_value();
        }
        get_hatch_pattern() {
            const css_pattern = this._get_css_value("hatch-pattern");
            if (css_pattern != "") {
                if (css_pattern == "none") {
                    return null;
                }
                else {
                    return css_pattern;
                }
            }
            return this.hatch_pattern.get_value();
        }
        get_hatch_weight() {
            const css_weight = this._get_css_value("hatch-weight");
            if (css_weight != "") {
                const weight = Number(css_weight);
                if (isFinite(weight)) {
                    return weight;
                }
            }
            return this.hatch_weight.get_value();
        }
        get_hatch_extra() {
            return this.hatch_extra.get_value();
        }
    }
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    class HatchScalar extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const pattern = this.hatch_pattern.value;
            return !(color == 0 || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit) {
                return;
            }
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const scale = this.hatch_scale.value;
            const pattern = this.hatch_pattern.value;
            const weight = this.hatch_weight.value;
            const finalize = (image) => {
                this._hatch_image = new p.UniformScalar(image, n);
            };
            const textures = (0, object_1.dict)(this.hatch_extra.value);
            const texture = textures.get(pattern);
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    void image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_paint();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            return this._static_doit;
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_value(ctx) {
            ctx.fillStyle = this.pattern(ctx) ?? "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image.value;
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition());
            }
        }
        repetition() {
            const pattern = this.hatch_pattern.value;
            if (pattern != null) {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    switch (texture.repetition) {
                        case "repeat": return "repeat";
                        case "repeat_x": return "repeat-x";
                        case "repeat_y": return "repeat-y";
                        case "no_repeat": return "no-repeat";
                    }
                }
            }
            return "repeat";
        }
    }
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    class HatchVector extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const { hatch_color } = this;
            if (hatch_color.is_Scalar() && hatch_color.value == 0) {
                return false;
            }
            const { hatch_alpha } = this;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0) {
                return false;
            }
            const { hatch_pattern } = this;
            if (hatch_pattern.is_Scalar()) {
                const pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null) {
                    return false;
                }
            }
            return true;
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit) {
                return;
            }
            const resolve_image = (pattern, color, alpha, scale, weight, finalize) => {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    const image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        const { _update_iteration } = this;
                        void image.then((image) => {
                            if (this._update_iteration == _update_iteration) {
                                finalize(image);
                                this.obj.request_paint();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    const layer = this.obj.canvas.create_layer();
                    const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                const color = this.hatch_color.value;
                const alpha = this.hatch_alpha.value;
                const scale = this.hatch_scale.value;
                const pattern = this.hatch_pattern.value;
                const weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, (image) => {
                    this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                const images = new Array(n);
                images.fill(null);
                this._hatch_image = new p.UniformVector(images);
                for (let i = 0; i < n; i++) {
                    const color = this.hatch_color.get(i);
                    const alpha = this.hatch_alpha.get(i);
                    const scale = this.hatch_scale.get(i);
                    const pattern = this.hatch_pattern.get(i);
                    const weight = this.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, (image) => {
                        images[i] = image;
                    });
                }
            }
        }
        get doit() {
            return this._static_doit;
        }
        v_doit(i) {
            if (!this.doit) {
                return false;
            }
            if (this.hatch_color.get(i) == 0) {
                return false;
            }
            if (this.hatch_alpha.get(i) == 0) {
                return false;
            }
            const pattern = this.hatch_pattern.get(i);
            if (pattern == " " || pattern == "blank" || pattern == null) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path_or_rule, rule = "nonzero") {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            ctx.fillStyle = this.pattern(ctx, i) ?? "transparent";
        }
        pattern(ctx, i) {
            const image = this._hatch_image.get(i);
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition(i));
            }
        }
        repetition(i) {
            const pattern = this.hatch_pattern.get(i);
            if (pattern != null) {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    switch (texture.repetition) {
                        case "repeat": return "repeat";
                        case "repeat_x": return "repeat-x";
                        case "repeat_y": return "repeat-y";
                        case "no_repeat": return "no-repeat";
                    }
                }
            }
            return "repeat";
        }
    }
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.get_pattern = get_pattern;
    const logging_1 = require(20) /* ../logging */;
    const color_1 = require(23) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        const h = hatch_scale;
        const h2 = h / 2;
        const h4 = h2 / 2;
        const color = (0, color_1.color2css)(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch (exports.hatch_aliases[hatch_pattern] ?? hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                const h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (let i = 0; i < 360; i++) {
                    const angle = 0.1 * i;
                    const x = h2 + (h30 * angle) * Math.cos(angle);
                    const y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            default:
                logging_1.logger.warn(`unknown hatch pattern: ${hatch_pattern}`);
        }
    }
},
/* core/visuals/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(101) /* ./visual */;
    const mixins = tslib_1.__importStar(require(95) /* ../property_mixins */);
    class Image extends visual_1.VisualProperties {
        get doit() {
            const alpha = this.global_alpha.get_value();
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.get_value(),
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.get_value();
            ctx.globalAlpha = alpha;
        }
    }
    exports.Image = Image;
    Image.__name__ = "Image";
    class ImageScalar extends visual_1.VisualUniforms {
        get doit() {
            const alpha = this.global_alpha.value;
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.value,
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.value;
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageScalar = ImageScalar;
    ImageScalar.__name__ = "ImageScalar";
    class ImageVector extends visual_1.VisualUniforms {
        get doit() {
            const { global_alpha } = this;
            if (global_alpha.is_Scalar() && global_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.global_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        values(i) {
            return {
                alpha: this.global_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const alpha = this.global_alpha.get(i);
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageVector = ImageVector;
    ImageVector.__name__ = "ImageVector";
    Image.prototype.type = "image";
    Image.prototype.attrs = Object.keys(mixins.Image);
    ImageScalar.prototype.type = "image";
    ImageScalar.prototype.attrs = Object.keys(mixins.ImageScalar);
    ImageVector.prototype.type = "image";
    ImageVector.prototype.attrs = Object.keys(mixins.ImageVector);
},
/* models/coordinates/coordinate_mapping.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../model */;
    const scale_1 = require(108) /* ../scales/scale */;
    const linear_scale_1 = require(113) /* ../scales/linear_scale */;
    const log_scale_1 = require(115) /* ../scales/log_scale */;
    const categorical_scale_1 = require(116) /* ../scales/categorical_scale */;
    const composite_scale_1 = require(117) /* ../scales/composite_scale */;
    const range_1 = require(110) /* ../ranges/range */;
    const data_range1d_1 = require(118) /* ../ranges/data_range1d */;
    const factor_range_1 = require(121) /* ../ranges/factor_range */;
    class CoordinateTransform {
        constructor(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_source = this.x_scale.source_range;
            this.y_source = this.y_scale.source_range;
            this.ranges = [this.x_source, this.y_source];
            this.scales = [this.x_scale, this.y_scale];
        }
        map_to_screen(xs, ys) {
            const sxs = this.x_scale.v_compute(xs);
            const sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        }
        map_from_screen(sxs, sys) {
            const xs = this.x_scale.v_invert(sxs);
            const ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        }
    }
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
    class CoordinateMapping extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get x_ranges() {
            return new Map([["default", this.x_source]]);
        }
        get y_ranges() {
            return new Map([["default", this.y_source]]);
        }
        _get_scale(range, scale, target) {
            const factor_range = range instanceof factor_range_1.FactorRange;
            const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
            if (factor_range != categorical_scale) {
                throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
            }
            if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d) {
                range.scale_hint = "log";
            }
            const derived_scale = scale.clone();
            derived_scale.setv({ source_range: range, target_range: target });
            return derived_scale;
        }
        get_transform(frame) {
            const { x_source, x_scale, x_target } = this;
            const x_source_scale = this._get_scale(x_source, x_scale, x_target);
            const { y_source, y_scale, y_target } = this;
            const y_source_scale = this._get_scale(y_source, y_scale, y_target);
            const xscale = new composite_scale_1.CompositeScale({
                source_scale: x_source_scale, source_range: x_source_scale.source_range,
                target_scale: frame.x_scale, target_range: frame.x_target,
            });
            const yscale = new composite_scale_1.CompositeScale({
                source_scale: y_source_scale, source_range: y_source_scale.source_range,
                target_scale: frame.y_scale, target_range: frame.y_target,
            });
            return new CoordinateTransform(xscale, yscale);
        }
    }
    exports.CoordinateMapping = CoordinateMapping;
    _a = CoordinateMapping;
    CoordinateMapping.__name__ = "CoordinateMapping";
    (() => {
        _a.define(({ Ref }) => ({
            x_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            y_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            x_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            y_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            x_target: [Ref(range_1.Range)],
            y_target: [Ref(range_1.Range)],
        }));
    })();
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const transform_1 = require(109) /* ../transforms/transform */;
    const range_1 = require(110) /* ../ranges/range */;
    const range1d_1 = require(111) /* ../ranges/range1d */;
    const types_1 = require(25) /* ../../core/types */;
    class Scale extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const result = new types_1.ScreenArray(xs.length);
            const { s_compute } = this;
            for (let i = 0; i < xs.length; i++) {
                result[i] = s_compute(xs[i]);
            }
            return result;
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const result = new Float64Array(sxs.length);
            const { s_invert } = this;
            for (let i = 0; i < sxs.length; i++) {
                result[i] = s_invert(sxs[i]);
            }
            return result;
        }
        r_compute(x0, x1) {
            const { s_compute } = this;
            if (this.target_range.is_reversed) {
                return [s_compute(x1), s_compute(x0)];
            }
            else {
                return [s_compute(x0), s_compute(x1)];
            }
        }
        r_invert(sx0, sx1) {
            const { s_invert } = this;
            if (this.target_range.is_reversed) {
                return [s_invert(sx1), s_invert(sx0)];
            }
            else {
                return [s_invert(sx0), s_invert(sx1)];
            }
        }
    }
    exports.Scale = Scale;
    _a = Scale;
    Scale.__name__ = "Scale";
    (() => {
        _a.internal(({ Ref }) => ({
            source_range: [Ref(range_1.Range)],
            target_range: [Ref(range1d_1.Range1d)],
        }));
    })();
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(52) /* ../../model */;
    class Transform extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../model */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const iterator_1 = require(14) /* ../../core/util/iterator */;
    const Bounds = (0, kinds_1.Nullable)((0, kinds_1.Or)((0, kinds_1.Tuple)((0, kinds_1.Nullable)(kinds_1.Float), (0, kinds_1.Nullable)(kinds_1.Float)), kinds_1.Auto));
    class Range extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
            /** @internal */
            this.frames = new Set();
        }
        get computed_bounds() {
            return this._computed_bounds;
        }
        get is_reversed() {
            return this.start > this.end;
        }
        get is_valid() {
            return isFinite(this.min) && isFinite(this.max);
        }
        get interval() {
            return [this.start, this.end];
        }
        get span() {
            return Math.abs(this.end - this.start);
        }
        get linked_plots() {
            return new Set((0, iterator_1.map)(this.frames, (frame) => frame.parent));
        }
    }
    exports.Range = Range;
    _a = Range;
    Range.__name__ = "Range";
    (() => {
        _a.define(({ Float, Nullable }) => ({
            bounds: [Bounds, null, {
                    on_update(bounds, obj) {
                        const [lower, upper] = bounds == "auto" || bounds == null ? [null, null] : bounds;
                        obj._computed_bounds = [lower ?? -Infinity, upper ?? Infinity];
                    },
                }],
            min_interval: [Nullable(Float), null],
            max_interval: [Nullable(Float), null],
        }));
    })();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const numerical_range_1 = require(112) /* ./numerical_range */;
    class Range1d extends numerical_range_1.NumericalRange {
        constructor(attrs) {
            super(attrs);
        }
        _set_auto_bounds() {
            if (this.bounds == "auto") {
                const min = Math.min(this._reset_start, this._reset_end);
                const max = Math.max(this._reset_start, this._reset_end);
                this._computed_bounds = [min, max];
            }
        }
        initialize() {
            super.initialize();
            this._set_auto_bounds();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        reset() {
            this._set_auto_bounds();
            const { _reset_start, _reset_end } = this;
            if (this.start != _reset_start || this.end != _reset_end) {
                this.setv({ start: _reset_start, end: _reset_end });
            }
            else {
                this.change.emit();
            }
        }
        map(fn) {
            return new _a({ start: fn(this.start), end: fn(this.end) });
        }
        widen(v) {
            let { start, end } = this;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new _a({ start, end });
        }
    }
    exports.Range1d = Range1d;
    _a = Range1d;
    Range1d.__name__ = "Range1d";
    (() => {
        _a.define(({ Float, Nullable }) => ({
            reset_start: [Nullable(Float), null, {
                    on_update(reset_start, self) {
                        self._reset_start = reset_start ?? self.start;
                    },
                }],
            reset_end: [Nullable(Float), null, {
                    on_update(reset_end, self) {
                        self._reset_end = reset_end ?? self.end;
                    },
                }],
        }));
        _a.override({
            start: 0,
            end: 1,
        });
    })();
},
/* models/ranges/numerical_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const range_1 = require(110) /* ./range */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const math_1 = require(11) /* ../../core/util/math */;
    class NumericalRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.NumericalRange = NumericalRange;
    _a = NumericalRange;
    NumericalRange.__name__ = "NumericalRange";
    (() => {
        _a.define(({ Float }) => ({
            start: [Float, p.unset, {
                    convert(value, obj) {
                        const [lower, upper] = obj.computed_bounds;
                        return (0, math_1.clamp)(value, lower, upper);
                    },
                }],
            end: [Float, p.unset, {
                    convert(value, obj) {
                        const [lower, upper] = obj.computed_bounds;
                        return (0, math_1.clamp)(value, lower, upper);
                    },
                }],
        }));
    })();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(114) /* ./continuous_scale */;
    class LinearScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = this._linear_compute_state();
            return (x) => factor * x + offset;
        }
        get s_invert() {
            const [factor, offset] = this._linear_compute_state();
            return (sx) => (sx - offset) / factor;
        }
        /*protected*/ _linear_compute_state() {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const factor = (target_end - target_start) / (source_end - source_start);
            const offset = -(factor * source_start) + target_start;
            return [factor, offset];
        }
    }
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(108) /* ./scale */;
    class ContinuousScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(114) /* ./continuous_scale */;
    class LogScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (x) => {
                if (inter_factor == 0) {
                    return 0;
                }
                else {
                    const _x = (Math.log(x) - inter_offset) / inter_factor;
                    return isFinite(_x) ? _x * factor + offset : NaN;
                }
            };
        }
        get s_invert() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (xprime) => {
                const value = (xprime - offset) / factor;
                return Math.exp(inter_factor * value + inter_offset);
            };
        }
        _get_safe_factor(orig_start, orig_end) {
            let start = orig_start < 0 ? 0 : orig_start;
            let end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0) {
                    [start, end] = [1, 10];
                }
                else {
                    const log_val = Math.log10(start);
                    start = 10 ** Math.floor(log_val);
                    if (Math.ceil(log_val) != Math.floor(log_val)) {
                        end = 10 ** Math.ceil(log_val);
                    }
                    else {
                        end = 10 ** (Math.ceil(log_val) + 1);
                    }
                }
            }
            return [start, end];
        }
        /*protected*/ _compute_state() {
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const screen_range = target_end - target_start;
            const [start, end] = this._get_safe_factor(source_start, source_end);
            let inter_factor;
            let inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end / start);
                inter_offset = Math.log(start);
            }
            const factor = screen_range;
            const offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        }
    }
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(108) /* ./scale */;
    const linear_scale_1 = require(113) /* ./linear_scale */;
    const { _linear_compute_state } = linear_scale_1.LinearScale.prototype;
    class CategoricalScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = _linear_compute_state.call(this);
            const range = this.source_range;
            return (x) => factor * range.synthetic(x) + offset;
        }
        get s_invert() {
            const [factor, offset] = _linear_compute_state.call(this);
            return (sx) => (sx - offset) / factor;
        }
    }
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/scales/composite_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const scale_1 = require(108) /* ../scales/scale */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    class CompositeScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const source_compute = this.source_scale.s_compute;
            const target_compute = this.target_scale.s_compute;
            return (x) => target_compute(source_compute(x));
        }
        get s_invert() {
            const source_invert = this.source_scale.s_invert;
            const target_invert = this.target_scale.s_invert;
            return (sx) => source_invert(target_invert(sx));
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const { s_compute } = this;
            return (0, arrayable_1.map)(xs, s_compute); // XXX
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const { s_invert } = this;
            return (0, arrayable_1.map)(sxs, s_invert); // XXX
        }
    }
    exports.CompositeScale = CompositeScale;
    _a = CompositeScale;
    CompositeScale.__name__ = "CompositeScale";
    (() => {
        _a.define(({ Ref }) => ({
            source_scale: [Ref(scale_1.Scale)],
            target_scale: [Ref(scale_1.Scale)],
        }));
    })();
},
/* models/ranges/data_range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.is_auto_ranged = is_auto_ranged;
    const tslib_1 = require(1) /* tslib */;
    const data_range_1 = require(119) /* ./data_range */;
    const enums_1 = require(21) /* ../../core/enums */;
    const iterator_1 = require(14) /* ../../core/util/iterator */;
    const math_1 = require(11) /* ../../core/util/math */;
    const logging_1 = require(20) /* ../../core/logging */;
    const bbox = tslib_1.__importStar(require(62) /* ../../core/util/bbox */);
    const util_1 = require(120) /* ../util */;
    exports.auto_ranged = Symbol("auto_ranged");
    function is_auto_ranged(r) {
        return exports.auto_ranged in r;
    }
    class DataRange1d extends data_range_1.DataRange {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        initialize() {
            super.initialize();
            this._initial_start = isNaN(this.start) ? null : this.start;
            this._initial_end = isNaN(this.end) ? null : this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
            this._plot_bounds = new Map();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        computed_renderers() {
            // TODO (bev) check that renderers actually configured with this range
            const { renderers } = this;
            const all_renderers = (0, iterator_1.flat_map)(this.linked_plots, (plot) => plot.auto_ranged_renderers.map((r) => r.model));
            return (0, util_1.compute_renderers)(renderers.length == 0 ? "auto" : renderers, [...all_renderers]);
        }
        /*protected*/ _compute_plot_bounds(renderers, bounds) {
            let result = bbox.empty();
            for (const r of renderers) {
                const rect = bounds.get(r);
                if (rect != null && (r.visible || !this.only_visible)) {
                    result = bbox.union(result, rect);
                }
            }
            return result;
        }
        adjust_bounds_for_aspect(bounds, ratio) {
            const result = bbox.empty();
            let width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            let height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            const xcenter = 0.5 * (bounds.x1 + bounds.x0);
            const ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        }
        /*protected*/ _compute_min_max(plot_bounds, dimension) {
            let overall = bbox.empty();
            for (const [plot, rect] of plot_bounds) {
                if (plot.model.visible) {
                    overall = bbox.union(overall, rect);
                }
            }
            let min, max;
            if (dimension == 0) {
                [min, max] = [overall.x0, overall.x1];
            }
            else {
                [min, max] = [overall.y0, overall.y1];
            }
            return [min, max];
        }
        /*protected*/ _compute_range(min, max) {
            const { range_padding } = this;
            const min_interval = this.min_interval ?? 0;
            const max_interval = this.max_interval ?? Infinity;
            let start, end;
            if (this._initial_start != null) {
                min = this._initial_start;
            }
            if (this._initial_end != null) {
                max = this._initial_end;
            }
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0) {
                        min = 0.1;
                    }
                    else {
                        min = max / 100;
                    }
                    logging_1.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${min}`);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0) {
                        max = 10;
                    }
                    else {
                        max = min * 100;
                    }
                    logging_1.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${max}`);
                }
                let center, span;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log10(min);
                }
                else {
                    let log_min, log_max;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log10(min);
                        log_max = Math.log10(max);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log10(min - range_padding);
                        log_max = Math.log10(max + range_padding);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                span = (0, math_1.clamp)(span, min_interval, max_interval);
                start = 10 ** (center - span / 2.0);
                end = 10 ** (center + span / 2.0);
            }
            else {
                let span;
                if (max == min) {
                    span = this.default_span;
                }
                else {
                    if (this.range_padding_units == "percent") {
                        span = (max - min) * (1 + range_padding);
                    }
                    else {
                        span = (max - min) + 2 * range_padding;
                    }
                }
                span = (0, math_1.clamp)(span, min_interval, max_interval);
                const center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            let follow_sign = +1;
            if (this.flipped) {
                [start, end] = [end, start];
                follow_sign = -1;
            }
            const follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == "start") {
                    end = start + follow_sign * follow_interval;
                }
                else if (this.follow == "end") {
                    start = end - follow_sign * follow_interval;
                }
            }
            return [start, end];
        }
        update(bounds, dimension, plot, ratio) {
            if (this.have_updated_interactively) {
                return;
            }
            const renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            let total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null) {
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            }
            this._plot_bounds.set(plot, total_bounds);
            // compute the min/mix for our specified dimension
            const [min, max] = this._compute_min_max(this._plot_bounds.entries(), dimension);
            // derive start, end from bounds and data range config
            let [start, end] = this._compute_range(min, max);
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0) {
                        start = this._initial_start;
                    }
                }
                else {
                    start = this._initial_start;
                }
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0) {
                        end = this._initial_end;
                    }
                }
                else {
                    end = this._initial_end;
                }
            }
            let needs_emit = false;
            if (this.bounds == "auto") {
                this._computed_bounds = [start, end];
                needs_emit = true;
            }
            // only trigger updates when there are changes
            const [_start, _end] = [this.start, this.end];
            if (start != _start || end != _end) {
                const new_range = {};
                if (start != _start) {
                    new_range.start = start;
                }
                if (end != _end) {
                    new_range.end = end;
                }
                this.setv(new_range);
                needs_emit = false;
            }
            if (needs_emit) {
                this.change.emit();
            }
        }
        reset() {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        }
    }
    exports.DataRange1d = DataRange1d;
    _a = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    (() => {
        _a.define(({ Bool, Float, Nullable }) => ({
            range_padding: [Float, 0.1],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            flipped: [Bool, false],
            follow: [Nullable(enums_1.StartEnd), null],
            follow_interval: [Nullable(Float), null],
            default_span: [Float, 2.0],
            only_visible: [Bool, false],
        }));
        _a.internal(({ Enum }) => ({
            scale_hint: [Enum("log", "auto"), "auto"],
        }));
    })();
},
/* models/ranges/data_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const numerical_range_1 = require(112) /* ./numerical_range */;
    class DataRange extends numerical_range_1.NumericalRange {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataRange = DataRange;
    _a = DataRange;
    DataRange.__name__ = "DataRange";
    (() => {
        _a.define(({ List, AnyRef, Or, Auto }) => ({
            renderers: [Or(List(AnyRef()), Auto), []],
        }));
        _a.override({
            start: NaN,
            end: NaN,
        });
    })();
},
/* models/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.compute_renderers = compute_renderers;
    function compute_renderers(renderers, all_renderers) {
        return renderers == "auto" ? all_renderers : renderers ?? [];
    }
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.map_one_level = map_one_level;
    exports.map_two_levels = map_two_levels;
    exports.map_three_levels = map_three_levels;
    const tslib_1 = require(1) /* tslib */;
    const range_1 = require(110) /* ./range */;
    const enums_1 = require(21) /* ../../core/enums */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const signaling_1 = require(16) /* ../../core/signaling */;
    const types_1 = require(25) /* ../../core/types */;
    const array_1 = require(10) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    exports.L1Factor = kinds_1.Str;
    exports.L2Factor = (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str);
    exports.L3Factor = (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str, kinds_1.Str);
    exports.L1FactorSeq = (0, kinds_1.List)(exports.L1Factor);
    exports.L2FactorSeq = (0, kinds_1.List)(exports.L2Factor);
    exports.L3FactorSeq = (0, kinds_1.List)(exports.L3Factor);
    exports.L1OffsetFactor = (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Float);
    exports.L2OffsetFactor = (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str, kinds_1.Float);
    exports.L3OffsetFactor = (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str, kinds_1.Str, kinds_1.Float);
    exports.Factor = (0, kinds_1.Or)(exports.L1Factor, exports.L2Factor, exports.L3Factor);
    exports.FactorSeq = (0, kinds_1.Or)(exports.L1FactorSeq, exports.L2FactorSeq, exports.L3FactorSeq);
    exports.OffsetFactor = (0, kinds_1.Or)(exports.L1OffsetFactor, exports.L2OffsetFactor, exports.L3OffsetFactor);
    exports.FactorLike = (0, kinds_1.Or)(kinds_1.Float, exports.Factor, exports.OffsetFactor);
    function map_one_level(factors, padding, offset = 0) {
        const mapping = new Map();
        for (let i = 0; i < factors.length; i++) {
            const factor = factors[i];
            if (mapping.has(factor)) {
                throw new Error(`duplicate factor or subfactor: ${factor}`);
            }
            mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
        }
        const inner_padding = (factors.length - 1) * padding;
        return { mapping, inner_padding };
    }
    function map_two_levels(factors, outer_pad, factor_pad, offset = 0) {
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1] of factors) {
            const top = tops.get(f0) ?? [];
            tops.set(f0, [...top, f1]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const sub = map_one_level(top, factor_pad, suboffset);
            total_subpad += sub.inner_padding;
            const subtot = (0, array_1.sum)(top.map((f1) => sub.mapping.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: sub.mapping });
            suboffset += n + outer_pad + sub.inner_padding;
        }
        const inner_padding = (tops.size - 1) * outer_pad + total_subpad;
        return { mapping, tops: [...mapping.keys()], inner_padding };
    }
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset = 0) {
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1, f2] of factors) {
            const top = tops.get(f0) ?? [];
            tops.set(f0, [...top, [f1, f2]]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const sub = map_two_levels(top, inner_pad, factor_pad, suboffset);
            total_subpad += sub.inner_padding;
            const subtot = (0, array_1.sum)(top.map(([f1]) => sub.mapping.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: sub.mapping });
            suboffset += n + outer_pad + sub.inner_padding;
        }
        const mids = [];
        for (const [f0, L2] of mapping) {
            for (const f1 of L2.mapping.keys()) {
                mids.push([f0, f1]);
            }
        }
        const inner_padding = (tops.size - 1) * outer_pad + total_subpad;
        return { mapping, tops: [...mapping.keys()], mids, inner_padding };
    }
    const is_l1 = (x) => (0, types_2.isString)(x);
    const is_l2 = (x) => (0, types_2.isArray)(x) && x.length == 2 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]);
    const is_l3 = (x) => (0, types_2.isArray)(x) && x.length == 3 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]) && (0, types_2.isString)(x[2]);
    class FactorMapper {
        constructor({ levels, mapping, tops = null, mids = null, inner_padding }) {
            this.levels = levels;
            this.mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            this.inner_padding = inner_padding;
        }
        static compute_levels(factors) {
            if ((0, array_1.every)(factors, is_l1)) {
                return 1;
            }
            if ((0, array_1.every)(factors, is_l2)) {
                return 2;
            }
            if ((0, array_1.every)(factors, is_l3)) {
                return 3;
            }
            throw TypeError("factor levels are inconsistent");
        }
        static for(range) {
            switch (this.compute_levels(range.factors)) {
                case 1: {
                    return new L1FactorMapper(range);
                }
                case 2: {
                    return new L2FactorMapper(range);
                }
                case 3: {
                    return new L3FactorMapper(range);
                }
            }
        }
        map(x) {
            if ((0, types_2.isNumber)(x)) {
                return x;
            }
            const [boxed, offset] = (() => {
                if ((0, types_2.isString)(x)) {
                    return [[x], 0];
                }
                const last = x[x.length - 1];
                if ((0, types_2.isNumber)(last)) {
                    return [x.slice(0, -1), last];
                }
                return [x, 0];
            })();
            if (boxed.length > this.levels) {
                throw new Error(`Attempted to map ${boxed.length} levels of factors with an L${this.levels}FactorMap`);
            }
            return this.lookup_value(boxed) + offset;
        }
        lookup_value(x) {
            return this.lookup_entry(x)?.value ?? NaN;
        }
    }
    exports.FactorMapper = FactorMapper;
    FactorMapper.__name__ = "FactorMapper";
    class L1FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, factor_padding } = range;
            const spec = map_one_level(factors, factor_padding);
            super({ levels: 1, ...spec });
        }
        lookup_entry(x) {
            const [f0] = x;
            return this.mapping.get(f0) ?? null;
        }
    }
    L1FactorMapper.__name__ = "L1FactorMapper";
    class L2FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, group_padding, factor_padding } = range;
            const spec = map_two_levels(factors, group_padding, factor_padding);
            super({ levels: 2, ...spec });
        }
        lookup_entry(x) {
            if (x.length == 1) {
                const [f0] = x;
                return this.mapping.get(f0) ?? null;
            }
            else {
                const [f0, f1] = x;
                return this.mapping.get(f0)?.mapping.get(f1) ?? null;
            }
        }
    }
    L2FactorMapper.__name__ = "L2FactorMapper";
    class L3FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, group_padding, subgroup_padding, factor_padding } = range;
            const spec = map_three_levels(factors, group_padding, subgroup_padding, factor_padding);
            super({ levels: 3, ...spec });
        }
        lookup_entry(x) {
            if (x.length == 1) {
                const [f0] = x;
                return this.mapping.get(f0) ?? null;
            }
            else if (x.length == 2) {
                const [f0, f1] = x;
                return this.mapping.get(f0)?.mapping.get(f1) ?? null;
            }
            else {
                const [f0, f1, f2] = x;
                return this.mapping.get(f0)?.mapping.get(f1)?.mapping.get(f2) ?? null;
            }
        }
    }
    L3FactorMapper.__name__ = "L3FactorMapper";
    class FactorRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
            this.invalidate_synthetic = new signaling_1.Signal0(this, "invalidate_synthetic");
        }
        get min() {
            return this.start;
        }
        get max() {
            return this.end;
        }
        initialize() {
            super.initialize();
            this.configure();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.factors.change, () => this.reset());
            this.connect(this.properties.factor_padding.change, () => this.reset());
            this.connect(this.properties.group_padding.change, () => this.reset());
            this.connect(this.properties.subgroup_padding.change, () => this.reset());
            this.connect(this.properties.range_padding.change, () => this.reset());
            this.connect(this.properties.range_padding_units.change, () => this.reset());
        }
        reset() {
            this.configure();
            this.invalidate_synthetic.emit();
        }
        /** Convert a categorical factor into a synthetic coordinate. */
        synthetic(x) {
            return this.mapper.map(x);
        }
        /** Convert an array of categorical factors into synthetic coordinates. */
        v_synthetic(xs) {
            return types_1.ScreenArray.from(xs, (x) => this.synthetic(x));
        }
        /** Convert a synthetic coordinate into a categorical factor. */
        factor(x) {
            for (const f of this.factors) {
                const v = this.mapper.map(f);
                if (x >= (v - 0.5) && x < (v + 0.5)) {
                    return f;
                }
            }
            return null;
        }
        compute_bounds(inner_padding) {
            const interval = this.factors.length + inner_padding;
            const padding = (() => {
                switch (this.range_padding_units) {
                    case "percent": {
                        return interval * this.range_padding / 2;
                    }
                    case "absolute": {
                        return this.range_padding;
                    }
                }
            })();
            return [-padding, interval + padding];
        }
        configure() {
            this.mapper = FactorMapper.for(this);
            const [start, end] = this.compute_bounds(this.mapper.inner_padding);
            this.setv({ start, end }, { silent: true });
            if (this.bounds == "auto") {
                this._computed_bounds = [start, end];
            }
        }
    }
    exports.FactorRange = FactorRange;
    _a = FactorRange;
    FactorRange.__name__ = "FactorRange";
    (() => {
        _a.define(({ Float }) => ({
            factors: [exports.FactorSeq, []],
            factor_padding: [Float, 0],
            subgroup_padding: [Float, 0.8],
            group_padding: [Float, 1.4],
            range_padding: [Float, 0],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            start: [Float, p.unset, { readonly: true }],
            end: [Float, p.unset, { readonly: true }],
        }));
    })();
},
/* models/ui/menus/menu.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const ui_element_1 = require(55) /* ../ui_element */;
    const menu_item_1 = require(123) /* ./menu_item */;
    const divider_item_1 = require(126) /* ./divider_item */;
    const resolve_1 = require(127) /* ../../common/resolve */;
    const types_1 = require(8) /* ../../../core/util/types */;
    const dom_1 = require(61) /* ../../../core/dom */;
    const kinds_1 = require(22) /* ../../../core/kinds */;
    const build_views_1 = require(69) /* ../../../core/build_views */;
    const array_1 = require(10) /* ../../../core/util/array */;
    const callbacks_1 = require(51) /* ../../../core/util/callbacks */;
    const menus_css_1 = tslib_1.__importStar(require(128) /* ../../../styles/menus.css */), menus = menus_css_1;
    const icons_css_1 = tslib_1.__importDefault(require(76) /* ../../../styles/icons.css */);
    function to_val(val) {
        return (0, types_1.isFunction)(val) ? val() : val;
    }
    exports.MenuItemLike = (0, kinds_1.Or)((0, kinds_1.Ref)(menu_item_1.MenuItem), (0, kinds_1.Ref)(divider_item_1.DividerItem), kinds_1.Null);
    class MenuView extends ui_element_1.UIElementView {
        constructor() {
            super(...arguments);
            this._menu_views = new Map();
            this._menu_items = [];
            this._open = false;
            this._item_click = (item) => {
                if (!to_val(item.disabled)) {
                    const { action } = item;
                    if (action != null) {
                        void (0, callbacks_1.execute)(action, this.model, { item });
                    }
                    this.hide();
                }
            };
            this._on_mousedown = (event) => {
                if (event.composedPath().includes(this.el)) {
                    return;
                }
                if (this.prevent_hide?.(event) ?? false) {
                    return;
                }
                this.hide();
            };
            this._on_keydown = (event) => {
                switch (event.key) {
                    case "Escape": {
                        this.hide();
                        break;
                    }
                    default:
                }
            };
            this._on_blur = () => {
                this.hide();
            };
        }
        *children() {
            yield* super.children();
            yield* this._menu_views.values();
        }
        get menu_items() {
            const items = this._menu_items;
            const { reversed } = this.model;
            return reversed ? (0, array_1.reversed)(items) : items;
        }
        _compute_menu_items() {
            return this.model.items;
        }
        _update_menu_items() {
            this._menu_items = this._compute_menu_items();
        }
        get is_empty() {
            return this.menu_items.length == 0;
        }
        initialize() {
            super.initialize();
            this._update_menu_items();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const menus = this.menu_items
                .filter((item) => item instanceof menu_item_1.MenuItem)
                .map((item) => item.menu)
                .filter((menu) => menu != null);
            await (0, build_views_1.build_views)(this._menu_views, menus, { parent: this });
        }
        connect_signals() {
            super.connect_signals();
            const { items } = this.model.properties;
            this.on_change(items, () => this._update_menu_items());
        }
        get is_open() {
            return this._open;
        }
        remove() {
            this._unlisten();
            (0, build_views_1.remove_views)(this._menu_views);
            super.remove();
        }
        _listen() {
            document.addEventListener("mousedown", this._on_mousedown);
            document.addEventListener("keydown", this._on_keydown);
            window.addEventListener("blur", this._on_blur);
        }
        _unlisten() {
            document.removeEventListener("mousedown", this._on_mousedown);
            document.removeEventListener("keydown", this._on_keydown);
            window.removeEventListener("blur", this._on_blur);
        }
        stylesheets() {
            return [...super.stylesheets(), menus_css_1.default, icons_css_1.default];
        }
        render() {
            super.render();
            const items = this.menu_items;
            const entries = [];
            if (items.length == 0) {
                return;
            }
            for (const item of items) {
                if (item instanceof menu_item_1.MenuItem) {
                    const check_el = (0, dom_1.div)({ class: menus.check });
                    const label_el = (0, dom_1.div)({ class: menus.label }, item.label);
                    const shortcut_el = (0, dom_1.div)({ class: menus.shortcut }, item.shortcut);
                    const chevron_el = (0, dom_1.div)({ class: menus.chevron });
                    const icon_el = (() => {
                        const { icon } = item;
                        if (icon != null) {
                            const icon_el = (0, dom_1.div)({ class: menus.icon });
                            (0, resolve_1.apply_icon)(icon_el, icon);
                            return icon_el;
                        }
                        else {
                            return null;
                        }
                    })();
                    const item_el = (0, dom_1.div)({ class: menus.item, title: item.tooltip, tabIndex: 0 }, check_el, icon_el, label_el, shortcut_el, chevron_el);
                    const has_menu = item.menu != null && !this._menu_views.get(item.menu).is_empty;
                    item_el.classList.toggle(menus.menu, has_menu);
                    item_el.classList.toggle(menus.disabled, to_val(item.disabled));
                    if (item.checked != null) {
                        item_el.classList.add(menus.checkable);
                        item_el.classList.toggle(menus.checked, to_val(item.checked));
                    }
                    const show_submenu = (item) => {
                        if (item.menu != null) {
                            const menu_view = this._menu_views.get(item.menu);
                            menu_view._show_submenu(item_el);
                        }
                    };
                    const hide_submenu = (item) => {
                        if (item.menu != null) {
                            const menu_view = this._menu_views.get(item.menu);
                            menu_view.hide();
                        }
                    };
                    function is_target(event) {
                        const { currentTarget, target } = event;
                        return currentTarget instanceof Node && target instanceof Node && currentTarget.contains(target);
                    }
                    item_el.addEventListener("click", (event) => {
                        if (is_target(event)) {
                            this._item_click(item);
                        }
                        else {
                            this.hide();
                        }
                    });
                    item_el.addEventListener("keydown", (event) => {
                        // TODO https://github.com/bokeh/bokeh/issues/14241
                        switch (event.key) {
                            case "Enter": {
                                this._item_click(item);
                                break;
                            }
                            case "ArrowDown": {
                                break;
                            }
                            case "ArrowUp": {
                                break;
                            }
                            case "ArrowLeft": {
                                break;
                            }
                            case "ArrowRight": {
                                break;
                            }
                            default:
                        }
                    });
                    const { menu } = item;
                    if (menu != null) {
                        item_el.addEventListener("pointerenter", () => {
                            show_submenu(item);
                        });
                        item_el.addEventListener("pointerleave", () => {
                            hide_submenu(item);
                        });
                    }
                    this.shadow_el.append(item_el);
                    entries.push({ item, el: item_el });
                }
                else {
                    const item_el = (0, dom_1.div)({ class: menus.divider });
                    this.shadow_el.append(item_el);
                }
            }
        }
        _show_submenu(target) {
            if (this.is_empty) {
                this.hide();
                return;
            }
            this.render();
            target.append(this.el);
            const { style } = this.el;
            style.left = "100%";
            style.top = "0";
            this._listen();
            this._open = true;
        }
        show(at) {
            if (this.is_empty) {
                this.hide();
                return false;
            }
            const { parent } = this;
            if (parent == null) {
                // TODO position: fixed
                this.hide();
                return false;
            }
            this.render();
            const target = parent.el.shadowRoot ?? parent.el;
            target.append(this.el);
            const { style } = this.el;
            style.left = (0, dom_1.px)(at.x);
            style.top = (0, dom_1.px)(at.y);
            this._listen();
            this._open = true;
            return true;
        }
        hide() {
            if (this._open) {
                this._open = false;
                this._unlisten();
                this.el.remove();
            }
        }
    }
    exports.MenuView = MenuView;
    MenuView.__name__ = "MenuView";
    class Menu extends ui_element_1.UIElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Menu = Menu;
    _a = Menu;
    Menu.__name__ = "Menu";
    (() => {
        _a.prototype.default_view = MenuView;
        _a.define(({ Bool, List }) => ({
            items: [List(exports.MenuItemLike), []],
            reversed: [Bool, false],
        }));
    })();
},
/* models/ui/menus/menu_item.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../../model */;
    const kinds_1 = require(124) /* ../../common/kinds */;
    const callback_1 = require(125) /* ../../callbacks/callback */;
    class MenuItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MenuItem = MenuItem;
    _a = MenuItem;
    MenuItem.__name__ = "MenuItem";
    (() => {
        _a.define(({ Bool, Str, Nullable, AnyRef, Ref, Func, Func0, Or }) => ({
            checked: [Nullable(Or(Bool, Func0(Bool))), null],
            icon: [Nullable(kinds_1.IconLike), null],
            label: [Str],
            tooltip: [Nullable(Str), null],
            shortcut: [Nullable(Str), null],
            menu: [Nullable(AnyRef()), null],
            disabled: [Or(Bool, Func0(Bool)), false],
            action: [Nullable(Or(Ref(callback_1.Callback), Func())), null],
        }));
    })();
},
/* models/common/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const enums = tslib_1.__importStar(require(21) /* ../../core/enums */);
    exports.Length = (0, kinds_1.NonNegative)(kinds_1.Int);
    const XY = (type) => (0, kinds_1.PartialStruct)({ x: type, y: type });
    const LRTB = (type) => (0, kinds_1.PartialStruct)({ left: type, right: type, top: type, bottom: type });
    exports.HAnchor = (0, kinds_1.Or)(enums.Align, enums.HAlign, kinds_1.Percent);
    exports.VAnchor = (0, kinds_1.Or)(enums.Align, enums.VAlign, kinds_1.Percent);
    exports.Anchor = (0, kinds_1.Or)(enums.Anchor, (0, kinds_1.Tuple)(exports.HAnchor, exports.VAnchor));
    exports.AutoAnchor = (0, kinds_1.Or)(kinds_1.Auto, enums.Anchor, (0, kinds_1.Tuple)((0, kinds_1.Or)(exports.HAnchor, kinds_1.Auto), (0, kinds_1.Or)(exports.VAnchor, kinds_1.Auto)));
    exports.TextAnchor = (0, kinds_1.Or)(exports.Anchor, kinds_1.Auto);
    exports.Padding = ((0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length), XY(exports.Length), (0, kinds_1.Tuple)(exports.Length, exports.Length, exports.Length, exports.Length), LRTB(exports.Length)));
    exports.BorderRadius = ((0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length, exports.Length, exports.Length), (0, kinds_1.PartialStruct)({
        top_left: exports.Length,
        top_right: exports.Length,
        bottom_right: exports.Length,
        bottom_left: exports.Length,
    })));
    exports.Index = (0, kinds_1.NonNegative)(kinds_1.Int);
    exports.Span = (0, kinds_1.NonNegative)(kinds_1.Int);
    const GridChild = (child) => (0, kinds_1.Tuple)((0, kinds_1.Ref)(child), exports.Index, exports.Index, (0, kinds_1.Opt)(exports.Span), (0, kinds_1.Opt)(exports.Span));
    exports.GridChild = GridChild;
    exports.GridSpacing = (0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length));
    exports.TrackAlign = (0, kinds_1.Enum)("start", "center", "end", "auto");
    exports.TrackSize = kinds_1.Str;
    exports.TrackSizing = (0, kinds_1.PartialStruct)({ size: exports.TrackSize, align: exports.TrackAlign });
    exports.TrackSizingLike = (0, kinds_1.Or)(exports.TrackSize, exports.TrackSizing);
    exports.TracksSizing = (0, kinds_1.Or)(exports.TrackSizingLike, (0, kinds_1.List)(exports.TrackSizingLike), (0, kinds_1.Mapping)(kinds_1.Int, exports.TrackSizingLike));
    exports.IconLike = (0, kinds_1.Or)(enums.ToolIcon, (0, kinds_1.PrefixedStr)("--"), (0, kinds_1.PrefixedStr)("."), (0, kinds_1.PrefixedStr)("data:image"));
},
/* models/callbacks/callback.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(52) /* ../../model */;
    class Callback extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Callback = Callback;
    Callback.__name__ = "Callback";
},
/* models/ui/menus/divider_item.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(52) /* ../../../model */;
    class DividerItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DividerItem = DividerItem;
    DividerItem.__name__ = "DividerItem";
},
/* models/common/resolve.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.normalized_anchor = normalized_anchor;
    exports.anchor = anchor;
    exports.text_anchor = text_anchor;
    exports.padding = padding;
    exports.border_radius = border_radius;
    exports.apply_icon = apply_icon;
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const logging_1 = require(20) /* ../../core/logging */;
    function normalized_anchor(anchor) {
        if (anchor == "auto") {
            return { x: "auto", y: "auto" };
        }
        const normalized = (() => {
            switch (anchor) {
                case "top": return "top_center";
                case "bottom": return "bottom_center";
                case "left": return "center_left";
                case "center": return "center_center";
                case "right": return "center_right";
                default: return anchor;
            }
        })();
        if ((0, types_1.isString)(normalized)) {
            const [y, x] = normalized.split("_");
            return { x, y };
        }
        else {
            const [x, y] = normalized;
            return { x, y };
        }
    }
    function anchor(anchor) {
        const { x, y } = normalized_anchor(anchor);
        const x_anchor = (() => {
            switch (x) {
                case "start":
                case "left": return 0.0;
                case "center": return 0.5;
                case "end":
                case "right": return 1.0;
                default: return x;
            }
        })();
        const y_anchor = (() => {
            switch (y) {
                case "start":
                case "top": return 0.0;
                case "center": return 0.5;
                case "end":
                case "bottom": return 1.0;
                default: return y;
            }
        })();
        return { x: x_anchor, y: y_anchor };
    }
    function text_anchor(text_anchor, align, baseline) {
        if (text_anchor != "auto") {
            return anchor(text_anchor);
        }
        else {
            const x_anchor = (() => {
                switch (align) {
                    case "left": return "start";
                    case "center": return "center";
                    case "right": return "end";
                }
            })();
            const y_anchor = (() => {
                switch (baseline) {
                    case "alphabetic":
                    case "ideographic":
                    case "hanging":
                        return "center";
                    case "top": return "start";
                    case "middle": return "center";
                    case "bottom": return "end";
                }
            })();
            return anchor([x_anchor, y_anchor]);
        }
    }
    function padding(padding) {
        if ((0, types_1.isNumber)(padding)) {
            return { left: padding, right: padding, top: padding, bottom: padding };
        }
        else if ((0, types_1.isPlainObject)(padding)) {
            if ("x" in padding || "y" in padding) {
                const { x = 0, y = 0 } = padding;
                return { left: x, right: x, top: y, bottom: y };
            }
            else if ("left" in padding || "right" in padding || "top" in padding || "bottom" in padding) {
                const { left = 0, right = 0, top = 0, bottom = 0 } = padding;
                return { left, right, top, bottom };
            }
            else {
                (0, assert_1.unreachable)(); // TODO: TypeScript 4.9
            }
        }
        else {
            if (padding.length == 2) {
                const [x = 0, y = 0] = padding;
                return { left: x, right: x, top: y, bottom: y };
            }
            else {
                const [left = 0, right = 0, top = 0, bottom = 0] = padding;
                return { left, right, top, bottom };
            }
        }
    }
    function border_radius(border_radius) {
        if ((0, types_1.isNumber)(border_radius)) {
            return {
                top_left: border_radius,
                top_right: border_radius,
                bottom_right: border_radius,
                bottom_left: border_radius,
            };
        }
        else if ((0, types_1.isPlainObject)(border_radius)) {
            return {
                top_left: border_radius.top_left ?? 0,
                top_right: border_radius.top_right ?? 0,
                bottom_right: border_radius.bottom_right ?? 0,
                bottom_left: border_radius.bottom_left ?? 0,
            };
        }
        else {
            const [top_left = 0, top_right = 0, bottom_right = 0, bottom_left = 0] = border_radius;
            return { top_left, top_right, bottom_right, bottom_left };
        }
    }
    function apply_icon(el, icon) {
        if (icon.startsWith("data:image")) {
            const url = `url("${encodeURI(icon)}")`;
            el.style.backgroundImage = url;
        }
        else if (icon.startsWith("--")) {
            el.style.backgroundImage = `var(${icon})`;
        }
        else if (icon.startsWith(".")) {
            const cls = icon.substring(1);
            el.classList.add(cls);
        }
        else if (enums_1.ToolIcon.valid(icon)) {
            const cls = `bk-tool-icon-${icon.replace(/_/g, "-")}`;
            el.classList.add(cls);
        }
        else {
            logging_1.logger.warn(`unable to resolve icon: ${icon}`);
        }
    }
},
/* styles/menus.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.item = "bk-item";
    exports.divider = "bk-divider";
    exports.check = "bk-check";
    exports.icon = "bk-icon";
    exports.label = "bk-label";
    exports.shortcut = "bk-shortcut";
    exports.chevron = "bk-chevron";
    exports.disabled = "bk-disabled";
    exports.menu = "bk-menu";
    exports.checkable = "bk-checkable";
    exports.checked = "bk-checked";
    exports.default = `:host{position:absolute;display:inline-grid;grid-template-columns:repeat(5, max-content);grid-template-rows:auto;user-select:none;-webkit-user-select:none;cursor:pointer;width:auto;height:auto;z-index:var(--bokeh-top-level);font-size:var(--font-size);background-color:var(--background-color);border:1px solid var(--border-color);border-radius:var(--border-radius);box-shadow:var(--box-shadow);}.bk-item,.bk-divider{position:relative;display:grid;grid-template-columns:subgrid;grid-column:span 5;align-items:center;}.bk-check{grid-column:1;}.bk-icon{grid-column:2;}.bk-label{grid-column:3;}.bk-shortcut{grid-column:4;}.bk-chevron{grid-column:5;}.bk-divider{cursor:default;overflow:hidden;background-color:var(--divider-color);height:1px;margin:1px 5px;}.bk-item{padding:0.5em;}.bk-item:hover{background-color:var(--hover-color);}.bk-item:focus,.bk-item:focus-visible{outline:1px dotted var(--highlight-color);outline-offset:-1px;}.bk-item::-moz-focus-inner{border:0;}.bk-item.bk-disabled{color:var(--disabled-color);cursor:not-allowed;}.bk-item.bk-disabled .bk-icon{color:var(--icon-color-disabled);}.bk-item:first-of-type{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}.bk-item:last-of-type{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}.bk-icon{position:relative;width:16px;height:16px;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-size:100% 100%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}.bk-label{padding:0 0.5em;}.bk-shortcut{text-align:right;font-size:90%;color:var(--shortcut-color);}.bk-chevron{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;width:12px;height:12px;}.bk-item:not(.bk-menu) .bk-chevron{display:none;}.bk-item.bk-checkable .bk-check{width:16px;height:16px;}.bk-item.bk-checkable.bk-checked .bk-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;}`;
},
/* models/renderers/renderer_group.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(52) /* ../../model */;
    class RendererGroup extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.RendererGroup = RendererGroup;
    _a = RendererGroup;
    RendererGroup.__name__ = "RendererGroup";
    (() => {
        _a.define(({ Bool }) => ({
            visible: [Bool, true],
        }));
    })();
},
/* models/dom/dom_node.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const dom_view_1 = require(64) /* ../../core/dom_view */;
    const model_1 = require(52) /* ../../model */;
    class DOMNodeView extends dom_view_1.DOMView {
    }
    exports.DOMNodeView = DOMNodeView;
    DOMNodeView.__name__ = "DOMNodeView";
    class DOMNode extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DOMNode = DOMNode;
    DOMNode.__name__ = "DOMNode";
    DOMNode.__module__ = "bokeh.models.dom";
},
/* models/layouts/layout_dom.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const pane_1 = require(132) /* ../ui/pane */;
    const logging_1 = require(20) /* ../../core/logging */;
    const signaling_1 = require(16) /* ../../core/signaling */;
    const enums_1 = require(21) /* ../../core/enums */;
    const dom_1 = require(61) /* ../../core/dom */;
    const types_1 = require(8) /* ../../core/util/types */;
    const iterator_1 = require(14) /* ../../core/util/iterator */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const layout_1 = require(135) /* ../../core/layout */;
    const canvas_1 = require(71) /* ../../core/util/canvas */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    class LayoutDOMView extends pane_1.PaneView {
        constructor() {
            super(...arguments);
            this._child_views = new Map();
            this.mouseenter = new signaling_1.Signal(this, "mouseenter");
            this.mouseleave = new signaling_1.Signal(this, "mouseleave");
            this.disabled = new signaling_1.Signal(this, "disabled");
            this._auto_width = "fit-content";
            this._auto_height = "fit-content";
            this._layout_computed = false;
        }
        get is_layout_root() {
            return this.is_root || !(this.parent instanceof LayoutDOMView);
        }
        _after_resize() {
            super._after_resize();
            if (this.is_layout_root && !this._was_built) {
                // This can happen only in pathological cases primarily in tests.
                logging_1.logger.warn(`${this} wasn't built properly`);
                this.render();
                this.r_after_render();
            }
            else {
                this.compute_layout();
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this.build_child_views();
        }
        remove() {
            for (const child_view of this.child_views) {
                child_view.remove();
            }
            this._child_views.clear();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            this.el.addEventListener("mouseenter", (event) => {
                this.mouseenter.emit(event);
            });
            this.el.addEventListener("mouseleave", (event) => {
                this.mouseleave.emit(event);
            });
            if (this.parent instanceof LayoutDOMView) {
                this.connect(this.parent.disabled, (disabled) => {
                    this.disabled.emit(disabled || this.model.disabled);
                });
            }
            const p = this.model.properties;
            this.on_change(p.disabled, () => {
                this.disabled.emit(this.model.disabled);
            });
            this.on_change([
                p.css_classes,
                p.stylesheets,
                p.width, p.height,
                p.min_width, p.min_height,
                p.max_width, p.max_height,
                p.margin,
                p.width_policy, p.height_policy,
                p.flow_mode, p.sizing_mode,
                p.aspect_ratio,
                p.visible,
            ], () => this.invalidate_layout());
        }
        *children() {
            yield* super.children();
            yield* this.child_views;
        }
        get child_views() {
            // TODO In case of a race condition somewhere between layout, resize and children updates,
            // child_models and _child_views may be temporarily inconsistent, resulting in undefined
            // values. Eventually this shouldn't happen and undefined should be treated as a bug.
            return this.child_models.map((child) => this._child_views.get(child)).filter((view) => view != null);
        }
        get layoutable_views() {
            return this.child_views.filter((c) => c instanceof LayoutDOMView);
        }
        async build_child_views() {
            const { created, removed } = await (0, build_views_1.build_views)(this._child_views, this.child_models, { parent: this });
            for (const view of removed) {
                this._resize_observer.unobserve(view.el);
            }
            for (const view of created) {
                this._resize_observer.observe(view.el, { box: "border-box" });
            }
            return created;
        }
        render() {
            super.render();
            for (const child_view of this.child_views) {
                const target = child_view.rendering_target() ?? this.shadow_el;
                child_view.render_to(target);
            }
        }
        rerender() {
            super.rerender();
            this.update_layout();
            this.compute_layout();
        }
        _update_children() { }
        async update_children() {
            const created = await this.build_child_views();
            const created_views = new Set(created);
            // Find index up to which the order of the existing views
            // matches the order of the new views. This allows us to
            // skip re-inserting the views up to this point
            const current_views = Array.from(this.shadow_el.children).flatMap(el => {
                const view = this.child_views.find(view => view.el === el);
                return view === undefined ? [] : [view];
            });
            let matching_index = null;
            for (let i = 0; i < current_views.length; i++) {
                if (current_views[i] === this.child_views[i]) {
                    matching_index = i;
                }
                else {
                    break;
                }
            }
            // Since appending to a DOM node will move the node to the end if it has
            // already been added appending all the children in order will result in
            // correct ordering.
            for (const [view, i] of (0, iterator_1.enumerate)(this.child_views)) {
                const is_new = created_views.has(view);
                const target = view.rendering_target() ?? this.self_target;
                if (is_new) {
                    view.render_to(target);
                }
                else if (matching_index === null || i > matching_index) {
                    target.append(view.el);
                }
            }
            this.r_after_render();
            this._update_children();
            this.invalidate_layout();
        }
        _intrinsic_display() {
            return { inner: this.model.flow_mode, outer: "flow" };
        }
        _update_layout() {
            function css_sizing(policy, size, auto_size, margin) {
                switch (policy) {
                    case "auto":
                        return size != null ? (0, dom_1.px)(size) : auto_size;
                    case "fixed":
                        return size != null ? (0, dom_1.px)(size) : "fit-content";
                    case "fit":
                        return "fit-content";
                    case "min":
                        return "min-content";
                    case "max":
                        return margin == null ? "100%" : `calc(100% - ${margin})`;
                }
            }
            function css_display(display) {
                // Convert to legacy values due to limited browser support.
                const { inner, outer } = display;
                switch (`${inner} ${outer}`) {
                    case "block flow": return "block";
                    case "inline flow": return "inline";
                    case "block flow-root": return "flow-root";
                    case "inline flow-root": return "inline-block";
                    case "block flex": return "flex";
                    case "inline flex": return "inline-flex";
                    case "block grid": return "grid";
                    case "inline grid": return "inline-grid";
                    case "block table": return "table";
                    case "inline table": return "inline-table";
                    default: (0, assert_1.unreachable)();
                }
            }
            function to_css(value) {
                return (0, types_1.isNumber)(value) ? (0, dom_1.px)(value) : `${value.percent}%`;
            }
            const styles = {};
            const display = this._intrinsic_display();
            styles.display = css_display(display);
            const sizing = this.box_sizing();
            const { width_policy, height_policy, width, height, aspect_ratio } = sizing;
            const computed_aspect = (() => {
                if (aspect_ratio == "auto") {
                    if (width != null && height != null) {
                        return width / height;
                    }
                }
                else if ((0, types_1.isNumber)(aspect_ratio)) {
                    return aspect_ratio;
                }
                return null;
            })();
            if (aspect_ratio == "auto") {
                if (width != null && height != null) {
                    styles.aspect_ratio = `${width} / ${height}`;
                }
                else {
                    styles.aspect_ratio = "auto";
                }
            }
            else if ((0, types_1.isNumber)(aspect_ratio)) {
                styles.aspect_ratio = `${aspect_ratio}`;
            }
            const { margin } = this.model;
            const margins = (() => {
                if (margin != null) {
                    if ((0, types_1.isNumber)(margin)) {
                        styles.margin = (0, dom_1.px)(margin);
                        return { width: (0, dom_1.px)(2 * margin), height: (0, dom_1.px)(2 * margin) };
                    }
                    else if (margin.length == 2) {
                        const [vertical, horizontal] = margin;
                        styles.margin = `${(0, dom_1.px)(vertical)} ${(0, dom_1.px)(horizontal)}`;
                        return { width: (0, dom_1.px)(2 * horizontal), height: (0, dom_1.px)(2 * vertical) };
                    }
                    else {
                        const [top, right, bottom, left] = margin;
                        styles.margin = `${(0, dom_1.px)(top)} ${(0, dom_1.px)(right)} ${(0, dom_1.px)(bottom)} ${(0, dom_1.px)(left)}`;
                        return { width: (0, dom_1.px)(left + right), height: (0, dom_1.px)(top + bottom) };
                    }
                }
                else {
                    return { width: null, height: null };
                }
            })();
            const [css_width, css_height] = (() => {
                const css_width = css_sizing(width_policy, width, this._auto_width, margins.width);
                const css_height = css_sizing(height_policy, height, this._auto_height, margins.height);
                if (aspect_ratio != null) {
                    if (width_policy != height_policy) {
                        if (width_policy == "fixed") {
                            return [css_width, "auto"];
                        }
                        if (height_policy == "fixed") {
                            return ["auto", css_height];
                        }
                        if (width_policy == "max") {
                            return [css_width, "auto"];
                        }
                        if (height_policy == "max") {
                            return ["auto", css_height];
                        }
                        return ["auto", "auto"];
                    }
                    else {
                        if (width_policy != "fixed" && height_policy != "fixed") {
                            if (computed_aspect != null) {
                                if (computed_aspect >= 1) {
                                    return [css_width, "auto"];
                                }
                                else {
                                    return ["auto", css_height];
                                }
                            }
                        }
                    }
                }
                return [css_width, css_height];
            })();
            styles.width = css_width;
            styles.height = css_height;
            const { min_width, max_width } = this.model;
            const { min_height, max_height } = this.model;
            if (min_width != null) {
                styles.min_width = to_css(min_width);
            }
            if (min_height != null) {
                styles.min_height = to_css(min_height);
            }
            if (this.is_layout_root) {
                if (max_width != null) {
                    styles.max_width = to_css(max_width);
                }
                if (max_height != null) {
                    styles.max_height = to_css(max_height);
                }
            }
            else {
                if (max_width != null) {
                    styles.max_width = `min(${to_css(max_width)}, 100%)`;
                }
                else if (width_policy != "fixed") {
                    styles.max_width = "100%";
                }
                if (max_height != null) {
                    styles.max_height = `min(${to_css(max_height)}, 100%)`;
                }
                else if (height_policy != "fixed") {
                    styles.max_height = "100%";
                }
            }
            const { resizable } = this.model;
            if (resizable !== false) {
                const resize = (() => {
                    switch (resizable) {
                        case "width": return "horizontal";
                        case "height": return "vertical";
                        case true:
                        case "both": return "both";
                    }
                })();
                styles.resize = resize;
                styles.overflow = "auto";
            }
            this.style.append(":host", styles);
        }
        update_layout() {
            this.update_style();
            for (const child_view of this.child_views) {
                child_view.parent_style.clear();
            }
            for (const child_view of this.layoutable_views) {
                child_view.update_layout();
            }
            this._update_layout();
        }
        get is_managed() {
            return this.parent instanceof LayoutDOMView;
        }
        /**
         * Update CSS layout with computed values from canvas layout.
         * This can be done more frequently than `_update_layout()`.
         */
        _measure_layout() { }
        measure_layout() {
            for (const child_view of this.layoutable_views) {
                child_view.measure_layout();
            }
            this._measure_layout();
        }
        compute_layout() {
            if (this.parent instanceof LayoutDOMView) { // TODO: this.is_managed
                this.parent.compute_layout();
            }
            else {
                this.measure_layout();
                this.update_bbox();
                this._compute_layout();
                this.after_layout();
            }
            this._layout_computed = true;
        }
        _compute_layout() {
            if (this.layout != null) {
                this.layout.compute(this.bbox.size);
                for (const child_view of this.layoutable_views) {
                    if (child_view.layout == null) {
                        child_view._compute_layout();
                    }
                    else {
                        child_view._propagate_layout();
                    }
                }
            }
            else {
                for (const child_view of this.layoutable_views) {
                    child_view._compute_layout();
                }
            }
        }
        _propagate_layout() {
            for (const child_view of this.layoutable_views) {
                if (child_view.layout == null) {
                    child_view._compute_layout();
                }
            }
        }
        update_bbox() {
            for (const child_view of this.layoutable_views) {
                child_view.update_bbox();
            }
            const changed = super.update_bbox();
            if (this.layout != null) {
                this.layout.visible = this.is_displayed;
            }
            return changed;
        }
        _after_layout() { }
        after_layout() {
            for (const child_view of this.layoutable_views) {
                child_view.after_layout();
            }
            this._after_layout();
        }
        _after_render() {
            // XXX no super
            if (!this.is_managed) {
                this.invalidate_layout();
            }
        }
        invalidate_layout() {
            // TODO: it would be better and more efficient to do a localized
            // update, but for now this guarantees consistent state of layout.
            if (this.parent instanceof LayoutDOMView) {
                this.parent.invalidate_layout();
            }
            else {
                this.update_layout();
                this.compute_layout();
            }
        }
        invalidate_render() {
            this.render();
            this.r_after_render();
            this.invalidate_layout();
        }
        has_finished() {
            if (!super.has_finished()) {
                return false;
            }
            if (this.is_layout_root && !this._layout_computed) {
                return false;
            }
            for (const child_view of this.child_views) {
                if (!child_view.has_finished()) {
                    return false;
                }
            }
            return true;
        }
        box_sizing() {
            let { width_policy, height_policy, aspect_ratio } = this.model;
            const { sizing_mode } = this.model;
            if (sizing_mode != null) {
                if (sizing_mode == "inherit") {
                    if (this.parent instanceof LayoutDOMView) {
                        const sizing = this.parent.box_sizing();
                        width_policy = sizing.width_policy;
                        height_policy = sizing.height_policy;
                        if (aspect_ratio == null) {
                            aspect_ratio = sizing.aspect_ratio;
                        }
                    }
                }
                else if (sizing_mode == "fixed") {
                    width_policy = height_policy = "fixed";
                }
                else if (sizing_mode == "stretch_both") {
                    width_policy = height_policy = "max";
                }
                else if (sizing_mode == "stretch_width") {
                    width_policy = "max";
                }
                else if (sizing_mode == "stretch_height") {
                    height_policy = "max";
                }
                else {
                    if (aspect_ratio == null) {
                        aspect_ratio = "auto";
                    }
                    switch (sizing_mode) {
                        case "scale_width":
                            width_policy = "max";
                            height_policy = "min";
                            break;
                        case "scale_height":
                            width_policy = "min";
                            height_policy = "max";
                            break;
                        case "scale_both":
                            width_policy = "max";
                            height_policy = "max";
                            break;
                    }
                }
            }
            const [halign, valign] = (() => {
                const { align } = this.model;
                if (align == "auto") {
                    return [undefined, undefined];
                }
                else if ((0, types_1.isArray)(align)) {
                    return align;
                }
                else {
                    return [align, align];
                }
            })();
            const { width, height } = this.model;
            return {
                width_policy,
                height_policy,
                width,
                height,
                aspect_ratio,
                halign,
                valign,
            };
        }
        export(type = "auto", hidpi = true) {
            const output_backend = (() => {
                switch (type) {
                    case "auto": // TODO: actually infer the best type
                    case "png": return "canvas";
                    case "svg": return "svg";
                }
            })();
            const composite = new canvas_1.CanvasLayer(output_backend, hidpi);
            const { x, y, width, height } = this.bbox;
            composite.resize(width, height);
            const bg_color = getComputedStyle(this.el).backgroundColor;
            composite.ctx.fillStyle = bg_color;
            composite.ctx.fillRect(x, y, width, height);
            for (const view of this.child_views) {
                const region = view.export(type, hidpi);
                const { x, y } = view.bbox.scale(composite.pixel_ratio);
                composite.ctx.drawImage(region.canvas, x, y);
            }
            return composite;
        }
    }
    exports.LayoutDOMView = LayoutDOMView;
    LayoutDOMView.__name__ = "LayoutDOMView";
    class LayoutDOM extends pane_1.Pane {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LayoutDOM = LayoutDOM;
    _a = LayoutDOM;
    LayoutDOM.__name__ = "LayoutDOM";
    (() => {
        _a.define((types) => {
            const { Bool, Float, Auto, Tuple, Or, Null, Nullable } = types;
            const Number2 = Tuple(Float, Float);
            const Number4 = Tuple(Float, Float, Float, Float);
            return {
                width: [Nullable(Float), null],
                height: [Nullable(Float), null],
                min_width: [Nullable(Float), null],
                min_height: [Nullable(Float), null],
                max_width: [Nullable(Float), null],
                max_height: [Nullable(Float), null],
                margin: [Nullable(Or(Float, Number2, Number4)), null],
                width_policy: [Or(layout_1.SizingPolicy, Auto), "auto"],
                height_policy: [Or(layout_1.SizingPolicy, Auto), "auto"],
                aspect_ratio: [Or(Float, Auto, Null), null],
                flow_mode: [enums_1.FlowMode, "block"],
                sizing_mode: [Nullable(enums_1.SizingMode), null],
                disabled: [Bool, false],
                align: [Or(enums_1.Align, Tuple(enums_1.Align, enums_1.Align), Auto), "auto"],
                resizable: [Or(Bool, enums_1.Dimensions), false],
            };
        });
    })();
},
/* models/ui/pane.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const ui_element_1 = require(55) /* ./ui_element */;
    const dom_node_1 = require(130) /* ../dom/dom_node */;
    const html_1 = require(133) /* ../dom/html */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    // TODO UIElement needs to inherit from DOMNode
    exports.ElementLike = (0, kinds_1.Or)((0, kinds_1.Ref)(ui_element_1.UIElement), (0, kinds_1.Ref)(dom_node_1.DOMNode), (0, kinds_1.Ref)(html_1.HTML));
    class PaneView extends ui_element_1.UIElementView {
        constructor() {
            super(...arguments);
            this._element_views = new Map();
        }
        get elements() {
            return this.model.elements;
        }
        get element_views() {
            return this.elements.map((element) => this._element_views.get(element)).filter((view) => view != null);
        }
        *children() {
            yield* super.children();
            yield* this.element_views;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._build_elements();
        }
        async _build_elements() {
            return await (0, build_views_1.build_views)(this._element_views, this.elements, { parent: this });
        }
        async _update_elements() {
            const { created } = await this._build_elements();
            const created_views = new Set(created);
            // Since appending to a DOM node will move the node to the end if it has
            // already been added appending all the children in order will result in
            // correct ordering.
            for (const view of this.element_views) {
                const is_new = created_views.has(view);
                const target = view.rendering_target() ?? this.self_target;
                if (is_new) {
                    view.render_to(target);
                }
                else {
                    target.append(view.el);
                }
            }
            this.r_after_render();
        }
        remove() {
            (0, build_views_1.remove_views)(this._element_views);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { elements } = this.model.properties;
            this.on_change(elements, async () => {
                await this._update_elements();
            });
        }
        render() {
            super.render();
            for (const element_view of this.element_views) {
                const target = element_view.rendering_target() ?? this.self_target;
                element_view.render_to(target);
            }
        }
        has_finished() {
            if (!super.has_finished()) {
                return false;
            }
            for (const element_view of this.element_views) {
                if (!element_view.has_finished()) {
                    return false;
                }
            }
            return true;
        }
    }
    exports.PaneView = PaneView;
    PaneView.__name__ = "PaneView";
    class Pane extends ui_element_1.UIElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Pane = Pane;
    _a = Pane;
    Pane.__name__ = "Pane";
    (() => {
        _a.prototype.default_view = PaneView;
        _a.define(({ List }) => ({
            elements: [List(exports.ElementLike), []],
        }));
    })();
},
/* models/dom/html.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const dom_element_1 = require(134) /* ./dom_element */;
    const ui_element_1 = require(55) /* ../ui/ui_element */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const dom_1 = require(61) /* ../../core/dom */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const types_1 = require(8) /* ../../core/util/types */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const HTMLRef = (0, kinds_1.Or)((0, kinds_1.Ref)(dom_element_1.DOMElement), (0, kinds_1.Ref)(ui_element_1.UIElement));
    const HTMLMarkup = kinds_1.Str;
    class HTMLView extends dom_element_1.DOMElementView {
        constructor() {
            super(...arguments);
            this._refs = new Map();
        }
        get refs() {
            const { html, refs } = this.model;
            return [
                ...(0, types_1.isArray)(html) ? html.filter((item) => !(0, types_1.isString)(item)) : [],
                ...refs,
            ];
        }
        async _update_refs() {
            await (0, build_views_1.build_views)(this._refs, this.refs);
        }
        *children() {
            yield* super.children();
            yield* this._refs.values();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._update_refs();
        }
        remove() {
            (0, build_views_1.remove_views)(this._refs);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { refs, html } = this.model.properties;
            this.on_change([refs, html], async () => {
                await this._update_refs();
                this.render();
            });
        }
        render() {
            super.render();
            const html = (() => {
                const { html } = this.model;
                if ((0, types_1.isArray)(html)) {
                    return html.map((item) => (0, types_1.isString)(item) ? item : `<ref id="${item.id}"></ref>`).join("");
                }
                else {
                    return html;
                }
            })();
            const nodes = (() => {
                if ((0, types_1.isString)(html)) {
                    return this.parse_html(html);
                }
                else {
                    return [html];
                }
            })();
            this.el.append(...nodes);
            this.finish();
        }
        parse_html(html) {
            const parser = new DOMParser();
            const document = parser.parseFromString(html, "text/html");
            const iter = document.createNodeIterator(document, NodeFilter.SHOW_ELEMENT, (node) => {
                return node.nodeName.toLowerCase() == "ref" ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_REJECT;
            });
            let node;
            next_node: while ((node = iter.nextNode()) != null) {
                (0, assert_1.assert)(node instanceof Element);
                const id = node.getAttribute("id");
                if (id != null) {
                    for (const [model, view] of this._refs) {
                        if (model.id == id) {
                            view.render();
                            node.replaceWith(view.el);
                            continue next_node;
                        }
                    }
                    node.replaceWith((0, dom_1.span)(`<not found: id=${id}>`));
                    continue;
                }
                const name = node.getAttribute("name");
                if (name != null) {
                    for (const [model, view] of this._refs) {
                        if (model.name == name) {
                            view.render();
                            node.replaceWith(view.el);
                            continue next_node;
                        }
                    }
                    node.replaceWith((0, dom_1.span)(`<not found: name=${name}>`));
                    continue;
                }
            }
            return [...document.body.childNodes];
        }
    }
    exports.HTMLView = HTMLView;
    HTMLView.__name__ = "HTMLView";
    class HTML extends dom_element_1.DOMElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.HTML = HTML;
    _a = HTML;
    HTML.__name__ = "HTML";
    (() => {
        _a.prototype.default_view = HTMLView;
        _a.define(({ Node, List, Or }) => ({
            html: [Or(Node, HTMLMarkup, List(Or(HTMLMarkup, HTMLRef)))],
            refs: [List(HTMLRef), []],
        }));
    })();
},
/* models/dom/dom_element.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const dom_node_1 = require(130) /* ./dom_node */;
    const styled_element_1 = require(56) /* ../ui/styled_element */;
    const ui_element_1 = require(55) /* ../ui/ui_element */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const types_1 = require(8) /* ../../core/util/types */;
    const css_1 = require(63) /* ../../core/css */;
    const dom_1 = require(61) /* ../../core/dom */;
    class DOMElementView extends dom_node_1.DOMNodeView {
        constructor() {
            super(...arguments);
            this.child_views = new Map();
        }
        get bbox() {
            return (0, dom_1.bounding_box)(this.el).relative();
        }
        get self_target() {
            return this.el;
        }
        *children() {
            yield* super.children();
            yield* this.child_views.values();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const children = this.model.children.filter((obj) => !(0, types_1.isString)(obj));
            await (0, build_views_1.build_views)(this.child_views, children, { parent: this });
        }
        remove() {
            (0, build_views_1.remove_views)(this.child_views);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { children, style } = this.model.properties;
            this.on_change(children, async () => {
                await this._update_children();
            });
            this.on_change(style, () => {
                this.el.removeAttribute("style");
                (0, css_1.apply_styles)(this.el.style, this.model.style);
            });
        }
        async _build_children() {
            const children = this.model.children.filter((obj) => !(0, types_1.isString)(obj));
            return await (0, build_views_1.build_views)(this.child_views, children, { parent: this });
        }
        async _update_children() {
            const { created } = await this._build_children();
            const created_views = new Set(created);
            // Since appending to a DOM node will move the node to the end if it has
            // already been added appending all the children in order will result in
            // correct ordering.
            for (const child of this.model.children) {
                if ((0, types_1.isString)(child)) {
                    const node = document.createTextNode(child);
                    this.self_target.append(node);
                }
                else {
                    const view = this.child_views.get(child);
                    if (view == null) {
                        continue;
                    }
                    const is_new = created_views.has(view);
                    const target = view.rendering_target() ?? this.self_target;
                    if (is_new) {
                        view.render_to(target);
                    }
                    else {
                        target.append(view.el);
                    }
                }
            }
            this.r_after_render();
        }
        render() {
            (0, dom_1.empty)(this.el);
            (0, css_1.apply_styles)(this.el.style, this.model.style);
            for (const child of this.model.children) {
                if ((0, types_1.isString)(child)) {
                    const node = document.createTextNode(child);
                    this.el.append(node);
                }
                else {
                    const child_view = this.child_views.get(child);
                    if (child_view == null) {
                        continue;
                    }
                    const target = child_view.rendering_target() ?? this.self_target;
                    child_view.render_to(target);
                }
            }
            this.finish();
        }
    }
    exports.DOMElementView = DOMElementView;
    DOMElementView.__name__ = "DOMElementView";
    class DOMElement extends dom_node_1.DOMNode {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DOMElement = DOMElement;
    _a = DOMElement;
    DOMElement.__name__ = "DOMElement";
    (() => {
        _a.define(({ Str, List, Or, Ref }) => {
            return {
                style: [styled_element_1.StylesLike, {}],
                children: [List(Or(Str, Ref(dom_node_1.DOMNode), Ref(ui_element_1.UIElement))), []],
            };
        });
    })();
},
/* core/layout/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(136) /* ./types */;
    __esExport("Sizeable", types_1.Sizeable);
    __esExport("SizingPolicy", types_1.SizingPolicy);
    var layoutable_1 = require(137) /* ./layoutable */;
    __esExport("Layoutable", layoutable_1.Layoutable);
    __esExport("ContentLayoutable", layoutable_1.ContentLayoutable);
    __esExport("ElementLayout", layoutable_1.ElementLayout);
    __esExport("TextLayout", layoutable_1.TextLayout);
    __esExport("FixedLayout", layoutable_1.FixedLayout);
    var alignments_1 = require(138) /* ./alignments */;
    __esExport("HStack", alignments_1.HStack);
    __esExport("VStack", alignments_1.VStack);
    var grid_1 = require(139) /* ./grid */;
    __esExport("Grid", grid_1.Grid);
    __esExport("Row", grid_1.Row);
    __esExport("Column", grid_1.Column);
},
/* core/layout/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const kinds_1 = require(22) /* ../kinds */;
    const { min, max } = Math;
    class Sizeable {
        constructor(size = {}) {
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        bounded_to({ width, height }) {
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        }
        expanded_to({ width, height }) {
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        }
        expand_to({ width, height }) {
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        }
        narrowed_to({ width, height }) {
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        }
        narrow_to({ width, height }) {
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        }
        grow_by({ left, right, top, bottom }) {
            const width = this.width + left + right;
            const height = this.height + top + bottom;
            return new Sizeable({ width, height });
        }
        shrink_by({ left, right, top, bottom }) {
            const width = max(this.width - left - right, 0);
            const height = max(this.height - top - bottom, 0);
            return new Sizeable({ width, height });
        }
        map(w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        }
    }
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
    exports.SizingPolicy = (0, kinds_1.Enum)("fixed", "fit", "min", "max");
},
/* core/layout/layoutable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(136) /* ./types */;
    const bbox_1 = require(62) /* ../util/bbox */;
    const types_2 = require(8) /* ../util/types */;
    const assert_1 = require(12) /* ../util/assert */;
    const { abs, min, max, round } = Math;
    class Layoutable {
        constructor() {
            this.absolute = false;
            this.position = { left: 0, top: 0 };
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            this._sizing = null;
            this._dirty = false;
            this._handlers = [];
        }
        *[Symbol.iterator]() { }
        get bbox() {
            return this._bbox;
        }
        get inner_bbox() {
            return this._inner_bbox;
        }
        get sizing() {
            (0, assert_1.assert)(this._sizing != null);
            return this._sizing;
        }
        set dirty(dirty) {
            this._dirty = dirty;
        }
        get dirty() {
            return this._dirty;
        }
        get visible() {
            return this.sizing.visible;
        }
        set visible(visible) {
            if (this.sizing.visible != visible) {
                this.sizing.visible = visible;
                this._dirty = true;
            }
        }
        set_sizing(sizing = {}) {
            const width_policy = sizing.width_policy ?? "fit";
            const width = sizing.width;
            const min_width = sizing.min_width;
            const max_width = sizing.max_width;
            const height_policy = sizing.height_policy ?? "fit";
            const height = sizing.height;
            const min_height = sizing.min_height;
            const max_height = sizing.max_height;
            const aspect = sizing.aspect;
            const margin = sizing.margin ?? { top: 0, right: 0, bottom: 0, left: 0 };
            const visible = sizing.visible ?? true;
            const halign = sizing.halign ?? "start";
            const valign = sizing.valign ?? "start";
            this._sizing = {
                width_policy, min_width, width, max_width,
                height_policy, min_height, height, max_height,
                aspect,
                margin,
                visible,
                halign,
                valign,
                size: { width, height },
            };
            this._init();
        }
        _init() { }
        _set_geometry(outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        }
        set_geometry(outer, inner) {
            const { fixup_geometry } = this;
            if (fixup_geometry != null) {
                [outer, inner] = fixup_geometry(outer, inner);
            }
            this._set_geometry(outer, inner ?? outer);
            for (const handler of this._handlers) {
                handler(this._bbox, this._inner_bbox);
            }
        }
        on_resize(handler) {
            this._handlers.push(handler);
        }
        is_width_expanding() {
            return this.sizing.width_policy == "max";
        }
        is_height_expanding() {
            return this.sizing.height_policy == "max";
        }
        apply_aspect(viewport, { width, height }) {
            const { aspect } = this.sizing;
            if (aspect != null) {
                const { width_policy, height_policy } = this.sizing;
                const gt = (width, height) => {
                    const policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        const w_width = width;
                        const w_height = round(width / aspect);
                        const h_width = round(height * aspect);
                        const h_height = height;
                        const w_diff = abs(viewport.width - w_width) + abs(viewport.height - w_height);
                        const h_diff = abs(viewport.width - h_width) + abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width, height };
        }
        measure(viewport_size) {
            if (this._sizing == null) {
                this.set_sizing();
            }
            if (!this.sizing.visible) {
                return { width: 0, height: 0 };
            }
            const exact_width = (width) => {
                return this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : width;
            };
            const exact_height = (height) => {
                return this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : height;
            };
            const viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            const computed = this._measure(viewport);
            const clipped = this.clip_size(computed, viewport);
            const width = exact_width(clipped.width);
            const height = exact_height(clipped.height);
            const size = this.apply_aspect(viewport, { width, height });
            return { ...computed, ...size };
        }
        _compute(viewport) {
            const size_hint = this.measure({
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            });
            const { width, height } = size_hint;
            const { left, top } = this.position;
            const outer = new bbox_1.BBox({ left, top, width, height });
            let inner = undefined;
            if (size_hint.inner != null) {
                const { left, top, right, bottom } = size_hint.inner;
                inner = new bbox_1.BBox({ left, top, right: width - right, bottom: height - bottom });
            }
            return { outer, inner };
        }
        compute(viewport = {}) {
            const { outer, inner } = this._compute(viewport);
            this.set_geometry(outer, inner);
        }
        get xview() {
            return this.bbox.xview;
        }
        get yview() {
            return this.bbox.yview;
        }
        clip_size(size, viewport) {
            function clip(size, vsize, min_size, max_size) {
                if (min_size == null) {
                    min_size = 0;
                }
                else if (!(0, types_2.isNumber)(min_size)) {
                    min_size = round(min_size.percent * vsize);
                }
                if (max_size == null) {
                    max_size = Infinity;
                }
                else if (!(0, types_2.isNumber)(max_size)) {
                    max_size = round(max_size.percent * vsize);
                }
                return max(min_size, min(size, max_size));
            }
            return {
                width: clip(size.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
                height: clip(size.height, viewport.height, this.sizing.min_height, this.sizing.max_height),
            };
        }
        has_size_changed() {
            const { _dirty } = this;
            this._dirty = false;
            return _dirty;
        }
    }
    exports.Layoutable = Layoutable;
    Layoutable.__name__ = "Layoutable";
    class ContentLayoutable extends Layoutable {
        _measure(viewport) {
            const content_size = this._content_size();
            const bounds = viewport
                .bounded_to(this.sizing.size)
                .bounded_to(content_size);
            const width = (() => {
                switch (this.sizing.width_policy) {
                    case "fixed":
                        return this.sizing.width != null ? this.sizing.width : content_size.width;
                    case "min":
                        return content_size.width;
                    case "fit":
                        return bounds.width;
                    case "max":
                        return max(content_size.width, bounds.width);
                }
            })();
            const height = (() => {
                switch (this.sizing.height_policy) {
                    case "fixed":
                        return this.sizing.height != null ? this.sizing.height : content_size.height;
                    case "min":
                        return content_size.height;
                    case "fit":
                        return bounds.height;
                    case "max":
                        return max(content_size.height, bounds.height);
                }
            })();
            return { width, height };
        }
    }
    exports.ContentLayoutable = ContentLayoutable;
    ContentLayoutable.__name__ = "ContentLayoutable";
    class ElementLayout extends ContentLayoutable {
        constructor(el) {
            super();
            this.el = el;
        }
        _content_size() {
            const { width, height } = this.el.getBoundingClientRect();
            return new types_1.Sizeable({ width, height });
        }
    }
    exports.ElementLayout = ElementLayout;
    ElementLayout.__name__ = "ElementLayout";
    class TextLayout extends ContentLayoutable {
        constructor(text) {
            super();
            this.text = text;
        }
        _content_size() {
            return new types_1.Sizeable(this.text.size());
        }
    }
    exports.TextLayout = TextLayout;
    TextLayout.__name__ = "TextLayout";
    class FixedLayout extends ContentLayoutable {
        constructor(size = {}) {
            super();
            this.size = size;
        }
        _content_size() {
            return new types_1.Sizeable(this.size);
        }
    }
    exports.FixedLayout = FixedLayout;
    FixedLayout.__name__ = "FixedLayout";
},
/* core/layout/alignments.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const layoutable_1 = require(137) /* ./layoutable */;
    const bbox_1 = require(62) /* ../util/bbox */;
    const { max, round } = Math;
    class Stack extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
    }
    exports.Stack = Stack;
    Stack.__name__ = "Stack";
    class HStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width += size_hint.width;
                height = max(height, size_hint.height);
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const top = this.absolute ? outer.top : 0;
                let left = this.absolute ? outer.left : 0;
                const { height } = outer;
                for (const child of this.children) {
                    const { width } = child.measure({ width: 0, height: 0 });
                    child.set_geometry(new bbox_1.BBox({ left, width, top, height }));
                    left += width;
                }
            }
        }
    }
    exports.HStack = HStack;
    HStack.__name__ = "HStack";
    class VStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width = max(width, size_hint.width);
                height += size_hint.height;
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const left = this.absolute ? outer.left : 0;
                let top = this.absolute ? outer.top : 0;
                const { width } = outer;
                for (const child of this.children) {
                    const size_hint = child.measure({ width: 0, height: 0 });
                    const { height } = size_hint;
                    child.set_geometry(new bbox_1.BBox({ top, height, left, width }));
                    top += height;
                }
            }
        }
    }
    exports.VStack = VStack;
    VStack.__name__ = "VStack";
    class NodeLayout extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
        _measure(viewport) {
            const { width_policy, height_policy } = this.sizing;
            const { min, max } = Math;
            let max_width = 0;
            let max_height = 0;
            for (const layout of this.children) {
                const { width, height } = layout.measure(viewport);
                max_width = max(max_width, width);
                max_height = max(max_height, height);
            }
            const width = (() => {
                const { width } = this.sizing;
                if (viewport.width == Infinity) {
                    return width_policy == "fixed" ? width ?? max_width : max_width;
                }
                else {
                    switch (width_policy) {
                        case "fixed": return width ?? max_width;
                        case "min": return /*width != null ? min(viewport.width, width) :*/ max_width;
                        case "fit": return width != null ? min(viewport.width, width) : viewport.width;
                        case "max": return width != null ? max(viewport.width, width) : viewport.width;
                    }
                }
            })();
            const height = (() => {
                const { height } = this.sizing;
                if (viewport.height == Infinity) {
                    return height_policy == "fixed" ? height ?? max_height : max_height;
                }
                else {
                    switch (height_policy) {
                        case "fixed": return height ?? max_height;
                        case "min": return /*height != null ? min(viewport.height, height) :*/ max_height;
                        case "fit": return height != null ? min(viewport.height, height) : viewport.height;
                        case "max": return height != null ? max(viewport.height, height) : viewport.height;
                    }
                }
            })();
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const bbox = this.absolute ? outer : outer.relative();
                const { left, right, top, bottom } = bbox;
                const vcenter = round(bbox.vcenter);
                const hcenter = round(bbox.hcenter);
                for (const layout of this.children) {
                    const { margin, halign = "start", valign = "start" } = layout.sizing;
                    const { width, height, inner } = layout.measure(outer);
                    const bbox = (() => {
                        const anchor = `${valign}_${halign}`;
                        switch (anchor) {
                            case "start_start": // "top_left"
                                return new bbox_1.BBox({ left: left + margin.left, top: top + margin.top, width, height });
                            case "start_center": // "top_center"
                                return new bbox_1.BBox({ hcenter, top: top + margin.top, width, height });
                            case "start_end": // "top_right"
                                return new bbox_1.BBox({ right: right - margin.right, top: top + margin.top, width, height });
                            case "center_start": // "center_left"
                                return new bbox_1.BBox({ left: left + margin.left, vcenter, width, height });
                            case "center_center": // "center"
                                return new bbox_1.BBox({ hcenter, vcenter, width, height });
                            case "center_end": // "center_right"
                                return new bbox_1.BBox({ right: right - margin.right, vcenter, width, height });
                            case "end_start": // "bottom_left"
                                return new bbox_1.BBox({ left: left + margin.left, bottom: bottom - margin.bottom, width, height });
                            case "end_center": // "bottom_center"
                                return new bbox_1.BBox({ hcenter, bottom: bottom - margin.bottom, width, height });
                            case "end_end": // "bottom_right"
                                return new bbox_1.BBox({ right: right - margin.right, bottom: bottom - margin.bottom, width, height });
                        }
                    })();
                    const inner_bbox = inner == null ? bbox : new bbox_1.BBox({
                        left: bbox.left + inner.left,
                        top: bbox.top + inner.top,
                        right: bbox.right - inner.right,
                        bottom: bbox.bottom - inner.bottom,
                    });
                    layout.set_geometry(bbox, inner_bbox);
                }
            }
        }
    }
    exports.NodeLayout = NodeLayout;
    NodeLayout.__name__ = "NodeLayout";
},
/* core/layout/grid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(136) /* ./types */;
    const layoutable_1 = require(137) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    const bbox_1 = require(62) /* ../util/bbox */;
    const array_1 = require(10) /* ../util/array */;
    const { max, round } = Math;
    class DefaultMap {
        constructor(def) {
            this._map = new Map();
            this.def = def;
        }
        get(key) {
            let value = this._map.get(key);
            if (value === undefined) {
                value = this.def();
                this._map.set(key, value);
            }
            return value;
        }
        apply(key, fn) {
            const value = this.get(key);
            this._map.set(key, fn(value));
        }
    }
    exports.DefaultMap = DefaultMap;
    DefaultMap.__name__ = "DefaultMap";
    class Container {
        constructor() {
            this._items = [];
            this._nrows = 0;
            this._ncols = 0;
        }
        get size() {
            return this._items.length;
        }
        get nrows() {
            return this._nrows;
        }
        get ncols() {
            return this._ncols;
        }
        add(span, data) {
            const { r1, c1 } = span;
            this._nrows = max(this._nrows, r1 + 1);
            this._ncols = max(this._ncols, c1 + 1);
            this._items.push({ span, data });
        }
        at(r, c) {
            const selected = this._items.filter(({ span }) => {
                return span.r0 <= r && r <= span.r1 &&
                    span.c0 <= c && c <= span.c1;
            });
            return selected.map(({ data }) => data);
        }
        row(r) {
            const selected = this._items.filter(({ span }) => span.r0 <= r && r <= span.r1);
            return selected.map(({ data }) => data);
        }
        col(c) {
            const selected = this._items.filter(({ span }) => span.c0 <= c && c <= span.c1);
            return selected.map(({ data }) => data);
        }
        *[Symbol.iterator]() {
            yield* this._items;
        }
        foreach(fn) {
            for (const { span, data } of this._items) {
                fn(span, data);
            }
        }
        map(fn) {
            const result = new Container();
            for (const { span, data } of this._items) {
                result.add(span, fn(span, data));
            }
            return result;
        }
    }
    exports.Container = Container;
    Container.__name__ = "Container";
    class Grid extends layoutable_1.Layoutable {
        *[Symbol.iterator]() {
            for (const { layout } of this.items) {
                yield layout;
            }
        }
        constructor(items = []) {
            super();
            this.rows = "auto";
            this.cols = "auto";
            this.spacing = 0;
            this.items = items;
        }
        is_width_expanding() {
            if (super.is_width_expanding()) {
                return true;
            }
            if (this.sizing.width_policy == "fixed") {
                return false;
            }
            const { cols } = this._state;
            return (0, array_1.some)(cols, (col) => col.policy == "max");
        }
        is_height_expanding() {
            if (super.is_height_expanding()) {
                return true;
            }
            if (this.sizing.height_policy == "fixed") {
                return false;
            }
            const { rows } = this._state;
            return (0, array_1.some)(rows, (row) => row.policy == "max");
        }
        _init() {
            super._init();
            const items = new Container();
            for (const { layout, row, col, row_span = 1, col_span = 1 } of this.items) {
                if (layout.sizing.visible) {
                    const r0 = row;
                    const c0 = col;
                    const r1 = row + row_span - 1;
                    const c1 = col + col_span - 1;
                    items.add({ r0, c0, r1, c1 }, layout);
                }
            }
            const { nrows, ncols } = items;
            const rows = new Array(nrows);
            for (let y = 0; y < nrows; y++) {
                const row = (() => {
                    const sizing = (0, types_2.isPlainObject)(this.rows) ? this.rows[y] ?? this.rows["*"] : this.rows;
                    if (sizing == null) {
                        return { policy: "auto" };
                    }
                    else if ((0, types_2.isNumber)(sizing)) {
                        return { policy: "fixed", height: sizing };
                    }
                    else if ((0, types_2.isString)(sizing)) {
                        return { policy: sizing };
                    }
                    else {
                        return sizing;
                    }
                })();
                const align = row.align ?? "auto";
                if (row.policy == "fixed") {
                    rows[y] = { policy: "fixed", height: row.height, align };
                }
                else if (row.policy == "min") {
                    rows[y] = { policy: "min", align };
                }
                else if (row.policy == "fit" || row.policy == "max") {
                    rows[y] = { policy: row.policy, flex: row.flex ?? 1, align };
                }
                else {
                    if ((0, array_1.some)(items.row(y), (layout) => layout.is_height_expanding())) {
                        rows[y] = { policy: "max", flex: 1, align };
                    }
                    else {
                        rows[y] = { policy: "min", align };
                    }
                }
            }
            const cols = new Array(ncols);
            for (let x = 0; x < ncols; x++) {
                const col = (() => {
                    const sizing = (0, types_2.isPlainObject)(this.cols) ? this.cols[x] ?? this.cols["*"] : this.cols;
                    if (sizing == null) {
                        return { policy: "auto" };
                    }
                    else if ((0, types_2.isNumber)(sizing)) {
                        return { policy: "fixed", width: sizing };
                    }
                    else if ((0, types_2.isString)(sizing)) {
                        return { policy: sizing };
                    }
                    else {
                        return sizing;
                    }
                })();
                const align = col.align ?? "auto";
                if (col.policy == "fixed") {
                    cols[x] = { policy: "fixed", width: col.width, align };
                }
                else if (col.policy == "min") {
                    cols[x] = { policy: "min", align };
                }
                else if (col.policy == "fit" || col.policy == "max") {
                    cols[x] = { policy: col.policy, flex: col.flex ?? 1, align };
                }
                else {
                    if ((0, array_1.some)(items.col(x), (layout) => layout.is_width_expanding())) {
                        cols[x] = { policy: "max", flex: 1, align };
                    }
                    else {
                        cols[x] = { policy: "min", align };
                    }
                }
            }
            const [rspacing, cspacing] = (0, types_2.isNumber)(this.spacing) ? [this.spacing, this.spacing] : this.spacing;
            this._state = { items, nrows, ncols, rows, cols, rspacing, cspacing };
        }
        _measure_totals(row_heights, col_widths) {
            const { nrows, ncols, rspacing, cspacing } = this._state;
            return {
                height: (0, array_1.sum)(row_heights) + (nrows - 1) * rspacing,
                width: (0, array_1.sum)(col_widths) + (ncols - 1) * cspacing,
            };
        }
        _measure_cells(cell_viewport) {
            const { items, nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const row_heights = new Array(nrows);
            for (let r = 0; r < nrows; r++) {
                const row = rows[r];
                row_heights[r] = row.policy == "fixed" ? row.height : 0;
            }
            const col_widths = new Array(ncols);
            for (let c = 0; c < ncols; c++) {
                const col = cols[c];
                col_widths[c] = col.policy == "fixed" ? col.width : 0;
            }
            const size_hints = new Container();
            items.foreach((span, layout) => {
                const { r0, c0, r1, c1 } = span;
                const rspace = (r1 - r0) * rspacing;
                const cspace = (c1 - c0) * cspacing;
                let height = 0;
                for (let r = r0; r <= r1; r++) {
                    height += cell_viewport(r, c0).height;
                }
                height += rspace;
                let width = 0;
                for (let c = c0; c <= c1; c++) {
                    width += cell_viewport(r0, c).width;
                }
                width += cspace;
                const size_hint = layout.measure({ width, height });
                size_hints.add(span, { layout, size_hint });
                const size = new types_1.Sizeable(size_hint).grow_by(layout.sizing.margin);
                size.height -= rspace;
                size.width -= cspace;
                const radjustable = [];
                for (let r = r0; r <= r1; r++) {
                    const row = rows[r];
                    if (row.policy == "fixed") {
                        size.height -= row.height;
                    }
                    else {
                        radjustable.push(r);
                    }
                }
                if (size.height > 0) {
                    const rheight = round(size.height / radjustable.length);
                    for (const r of radjustable) {
                        row_heights[r] = max(row_heights[r], rheight);
                    }
                }
                const cadjustable = [];
                for (let c = c0; c <= c1; c++) {
                    const col = cols[c];
                    if (col.policy == "fixed") {
                        size.width -= col.width;
                    }
                    else {
                        cadjustable.push(c);
                    }
                }
                if (size.width > 0) {
                    const cwidth = round(size.width / cadjustable.length);
                    for (const c of cadjustable) {
                        col_widths[c] = max(col_widths[c], cwidth);
                    }
                }
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure_grid(viewport) {
            const { nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const preferred = this._measure_cells((y, x) => {
                const row = rows[y];
                const col = cols[x];
                return {
                    width: col.policy == "fixed" ? col.width : Infinity,
                    height: row.policy == "fixed" ? row.height : Infinity,
                };
            });
            let available_height;
            if (this.sizing.height_policy == "fixed" && this.sizing.height != null) {
                available_height = this.sizing.height;
            }
            else if (viewport.height != Infinity && this.is_height_expanding()) {
                available_height = viewport.height;
            }
            else {
                available_height = preferred.size.height;
            }
            let height_flex = 0;
            for (let y = 0; y < nrows; y++) {
                const row = rows[y];
                if (row.policy == "fit" || row.policy == "max") {
                    height_flex += row.flex;
                }
                else {
                    available_height -= preferred.row_heights[y];
                }
            }
            available_height -= (nrows - 1) * rspacing;
            if (height_flex != 0 && available_height > 0) {
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy == "fit" || row.policy == "max") {
                        const height = round(available_height * (row.flex / height_flex));
                        available_height -= height;
                        preferred.row_heights[y] = height;
                        height_flex -= row.flex;
                    }
                }
            }
            else if (available_height < 0) {
                let nadjustable = 0;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed") {
                        nadjustable++;
                    }
                }
                let overflow_height = -available_height;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed") {
                        const height = preferred.row_heights[y];
                        const cutoff = round(overflow_height / nadjustable);
                        preferred.row_heights[y] = max(height - cutoff, 0);
                        overflow_height -= cutoff > height ? height : cutoff;
                        nadjustable--;
                    }
                }
            }
            let available_width;
            if (this.sizing.width_policy == "fixed" && this.sizing.width != null) {
                available_width = this.sizing.width;
            }
            else if (viewport.width != Infinity && this.is_width_expanding()) {
                available_width = viewport.width;
            }
            else {
                available_width = preferred.size.width;
            }
            let width_flex = 0;
            for (let x = 0; x < ncols; x++) {
                const col = cols[x];
                if (col.policy == "fit" || col.policy == "max") {
                    width_flex += col.flex;
                }
                else {
                    available_width -= preferred.col_widths[x];
                }
            }
            available_width -= (ncols - 1) * cspacing;
            if (width_flex != 0 && available_width > 0) {
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy == "fit" || col.policy == "max") {
                        const width = round(available_width * (col.flex / width_flex));
                        available_width -= width;
                        preferred.col_widths[x] = width;
                        width_flex -= col.flex;
                    }
                }
            }
            else if (available_width < 0) {
                let nadjustable = 0;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed") {
                        nadjustable++;
                    }
                }
                let overflow_width = -available_width;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed") {
                        const width = preferred.col_widths[x];
                        const cutoff = round(overflow_width / nadjustable);
                        preferred.col_widths[x] = max(width - cutoff, 0);
                        overflow_width -= cutoff > width ? width : cutoff;
                        nadjustable--;
                    }
                }
            }
            const { row_heights, col_widths, size_hints } = this._measure_cells((y, x) => {
                return {
                    width: preferred.col_widths[x],
                    height: preferred.row_heights[y],
                };
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure(viewport) {
            const { size } = this._measure_grid(viewport);
            return size;
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const { nrows, ncols, rspacing, cspacing } = this._state;
            const { row_heights, col_widths, size_hints } = this._measure_grid(outer);
            const rows = this._state.rows.map((row, r) => {
                return { ...row, top: 0, height: row_heights[r], get bottom() {
                        return this.top + this.height;
                    } };
            });
            const cols = this._state.cols.map((col, c) => {
                return { ...col, left: 0, width: col_widths[c], get right() {
                        return this.left + this.width;
                    } };
            });
            const items = size_hints.map((_, item) => {
                return { ...item, outer: new bbox_1.BBox(), inner: new bbox_1.BBox() };
            });
            for (let r = 0, top = !this.absolute ? this.position.top : outer.top; r < nrows; r++) {
                const row = rows[r];
                row.top = top;
                top += row.height + rspacing;
            }
            for (let c = 0, left = !this.absolute ? this.position.left : outer.left; c < ncols; c++) {
                const col = cols[c];
                col.left = left;
                left += col.width + cspacing;
            }
            function span_width(c0, c1) {
                let width = (c1 - c0) * cspacing;
                for (let c = c0; c <= c1; c++) {
                    width += cols[c].width;
                }
                return width;
            }
            function span_height(r0, r1) {
                let height = (r1 - r0) * rspacing;
                for (let r = r0; r <= r1; r++) {
                    height += rows[r].height;
                }
                return height;
            }
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { layout, size_hint } = item;
                const { sizing } = layout;
                const { width, height } = size_hint;
                const span = {
                    width: span_width(c0, c1),
                    height: span_height(r0, r1),
                };
                const halign = c0 == c1 && cols[c0].align != "auto" ? cols[c0].align : sizing.halign;
                const valign = r0 == r1 && rows[r0].align != "auto" ? rows[r0].align : sizing.valign;
                let left = cols[c0].left;
                if (halign == "start") {
                    left += sizing.margin.left;
                }
                else if (halign == "center") {
                    left += round((span.width - width) / 2);
                }
                else if (halign == "end") {
                    left += span.width - sizing.margin.right - width;
                }
                let top = rows[r0].top;
                if (valign == "start") {
                    top += sizing.margin.top;
                }
                else if (valign == "center") {
                    top += round((span.height - height) / 2);
                }
                else if (valign == "end") {
                    top += span.height - sizing.margin.bottom - height;
                }
                item.outer = new bbox_1.BBox({ left, top, width, height });
            });
            const row_aligns = rows.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            const col_aligns = cols.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            items.foreach(({ r0, c0, r1, c1 }, { size_hint, outer }) => {
                const { inner } = size_hint;
                if (inner != null) {
                    row_aligns[r0].start.apply(outer.top, (v) => max(v, inner.top));
                    row_aligns[r1].end.apply(rows[r1].bottom - outer.bottom, (v) => max(v, inner.bottom));
                    col_aligns[c0].start.apply(outer.left, (v) => max(v, inner.left));
                    col_aligns[c1].end.apply(cols[c1].right - outer.right, (v) => max(v, inner.right));
                }
            });
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { size_hint, outer } = item;
                const inner_bbox = (extents) => {
                    const outer_bbox = this.absolute ? outer : outer.relative();
                    const left = outer_bbox.left + extents.left;
                    const top = outer_bbox.top + extents.top;
                    const right = outer_bbox.right - extents.right;
                    const bottom = outer_bbox.bottom - extents.bottom;
                    return new bbox_1.BBox({ left, top, right, bottom });
                };
                if (size_hint.inner != null) {
                    let inner = inner_bbox(size_hint.inner);
                    //if (size_hint.align !== false) {
                    const top = row_aligns[r0].start.get(outer.top);
                    const bottom = row_aligns[r1].end.get(rows[r1].bottom - outer.bottom);
                    const left = col_aligns[c0].start.get(outer.left);
                    const right = col_aligns[c1].end.get(cols[c1].right - outer.right);
                    try {
                        inner = inner_bbox({ top, bottom, left, right });
                    }
                    catch { }
                    //}
                    item.inner = inner;
                }
                else {
                    item.inner = outer;
                }
            });
            items.foreach((_, { layout, outer, inner }) => {
                layout.set_geometry(outer, inner);
            });
        }
    }
    exports.Grid = Grid;
    Grid.__name__ = "Grid";
    class Row extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: 0, col: i }));
            this.rows = "fit";
        }
    }
    exports.Row = Row;
    Row.__name__ = "Row";
    class Column extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: i, col: 0 }));
            this.cols = "fit";
        }
    }
    exports.Column = Column;
    Column.__name__ = "Column";
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const data_annotation_1 = require(141) /* ./data_annotation */;
    const arrow_head_1 = require(182) /* ./arrow_head */;
    const property_mixins_1 = require(95) /* ../../core/property_mixins */;
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(25) /* ../../core/types */;
    const build_views_1 = require(69) /* ../../core/build_views */;
    const types_2 = require(25) /* ../../core/types */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const math_1 = require(11) /* ../../core/util/math */;
    class ArrowView extends data_annotation_1.DataAnnotationView {
        *children() {
            yield* super.children();
            const { start, end } = this;
            if (start != null) {
                yield start;
            }
            if (end != null) {
                yield end;
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { start, end } = this.model;
            if (start != null) {
                this.start = await (0, build_views_1.build_view)(start, { parent: this });
            }
            if (end != null) {
                this.end = await (0, build_views_1.build_view)(end, { parent: this });
            }
        }
        set_data(source) {
            super.set_data(source);
            const indices = types_2.Indices.all_set(this._x_start.length);
            this.start?.set_data(source, indices);
            this.end?.set_data(source, indices);
        }
        remove() {
            this.start?.remove();
            this.end?.remove();
            super.remove();
        }
        map_data() {
            const { frame } = this.plot_view;
            const [sx_start, sy_start] = (() => {
                switch (this.model.start_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_start),
                            new types_1.ScreenArray(this._y_start),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_start),
                            frame.bbox.yview.v_compute(this._y_start),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_start),
                            this.coordinates.y_scale.v_compute(this._y_start),
                        ];
                    }
                }
            })();
            const [sx_end, sy_end] = (() => {
                switch (this.model.end_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_end),
                            new types_1.ScreenArray(this._y_end),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_end),
                            frame.bbox.yview.v_compute(this._y_end),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_end),
                            this.coordinates.y_scale.v_compute(this._y_end),
                        ];
                    }
                }
            })();
            this._sx_start = sx_start;
            this._sy_start = sy_start;
            this._sx_end = sx_end;
            this._sy_end = sy_end;
            const n = sx_start.length;
            const angles = this._angles = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + (0, math_1.atan2)([sx_start[i], sy_start[i]], [sx_end[i], sy_end[i]]);
            }
        }
        _paint_data(ctx) {
            const { start, end } = this;
            const { _sx_start, _sy_start, _sx_end, _sy_end, _angles } = this;
            const { x, y, width, height } = this.plot_view.frame.bbox;
            for (let i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.paint(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.paint(ctx, i);
                    ctx.restore();
                }
                if (!this.visuals.line.doit) {
                    continue;
                }
                ctx.save();
                if (start != null || end != null) {
                    ctx.beginPath();
                    ctx.rect(x, y, width, height);
                    if (end != null) {
                        ctx.save();
                        ctx.translate(_sx_end[i], _sy_end[i]);
                        ctx.rotate(_angles[i]);
                        end.clip(ctx, i);
                        ctx.restore();
                    }
                    if (start != null) {
                        ctx.save();
                        ctx.translate(_sx_start[i], _sy_start[i]);
                        ctx.rotate(_angles[i] + Math.PI);
                        start.clip(ctx, i);
                        ctx.restore();
                    }
                    ctx.closePath();
                    ctx.clip();
                }
                ctx.beginPath();
                ctx.moveTo(_sx_start[i], _sy_start[i]);
                ctx.lineTo(_sx_end[i], _sy_end[i]);
                this.visuals.line.apply(ctx, i);
                ctx.restore();
            }
        }
    }
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    class Arrow extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Arrow = Arrow;
    _a = Arrow;
    Arrow.__name__ = "Arrow";
    (() => {
        _a.prototype.default_view = ArrowView;
        _a.mixins(property_mixins_1.LineVector);
        _a.define(({ Ref, Nullable }) => ({
            x_start: [p.XCoordinateSpec, { field: "x_start" }],
            y_start: [p.YCoordinateSpec, { field: "y_start" }],
            start_units: [enums_1.CoordinateUnits, "da