# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.preview.trusted_comms.business.brand.branded_channel import BrandedChannelList


class BrandList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, business_sid):
        """
        Initialize the BrandList

        :param Version version: Version that contains the resource
        :param business_sid: Business Sid.

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandList
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandList
        """
        super(BrandList, self).__init__(version)

        # Path Solution
        self._solution = {'business_sid': business_sid, }

    def get(self, sid):
        """
        Constructs a BrandContext

        :param sid: Brand Sid.

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        """
        return BrandContext(self._version, business_sid=self._solution['business_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a BrandContext

        :param sid: Brand Sid.

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        """
        return BrandContext(self._version, business_sid=self._solution['business_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandList>'


class BrandPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the BrandPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param business_sid: Business Sid.

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandPage
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandPage
        """
        super(BrandPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of BrandInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        """
        return BrandInstance(self._version, payload, business_sid=self._solution['business_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandPage>'


class BrandContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, business_sid, sid):
        """
        Initialize the BrandContext

        :param Version version: Version that contains the resource
        :param business_sid: Business Sid.
        :param sid: Brand Sid.

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        """
        super(BrandContext, self).__init__(version)

        # Path Solution
        self._solution = {'business_sid': business_sid, 'sid': sid, }
        self._uri = '/Businesses/{business_sid}/Brands/{sid}'.format(**self._solution)

        # Dependents
        self._branded_channels = None

    def fetch(self):
        """
        Fetch the BrandInstance

        :returns: The fetched BrandInstance
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return BrandInstance(
            self._version,
            payload,
            business_sid=self._solution['business_sid'],
            sid=self._solution['sid'],
        )

    @property
    def branded_channels(self):
        """
        Access the branded_channels

        :returns: twilio.rest.preview.trusted_comms.business.brand.branded_channel.BrandedChannelList
        :rtype: twilio.rest.preview.trusted_comms.business.brand.branded_channel.BrandedChannelList
        """
        if self._branded_channels is None:
            self._branded_channels = BrandedChannelList(
                self._version,
                business_sid=self._solution['business_sid'],
                brand_sid=self._solution['sid'],
            )
        return self._branded_channels

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.TrustedComms.BrandContext {}>'.format(context)


class BrandInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, business_sid, sid=None):
        """
        Initialize the BrandInstance

        :returns: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        """
        super(BrandInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'business_sid': payload.get('business_sid'),
            'sid': payload.get('sid'),
            'links': payload.get('links'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'business_sid': business_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: BrandContext for this BrandInstance
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandContext
        """
        if self._context is None:
            self._context = BrandContext(
                self._version,
                business_sid=self._solution['business_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def business_sid(self):
        """
        :returns: Business Sid.
        :rtype: unicode
        """
        return self._properties['business_sid']

    @property
    def sid(self):
        """
        :returns: Brand Sid.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def links(self):
        """
        :returns: Nested resource URLs.
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the BrandInstance

        :returns: The fetched BrandInstance
        :rtype: twilio.rest.preview.trusted_comms.business.brand.BrandInstance
        """
        return self._proxy.fetch()

    @property
    def branded_channels(self):
        """
        Access the branded_channels

        :returns: twilio.rest.preview.trusted_comms.business.brand.branded_channel.BrandedChannelList
        :rtype: twilio.rest.preview.trusted_comms.business.brand.branded_channel.BrandedChannelList
        """
        return self._proxy.branded_channels

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.TrustedComms.BrandInstance {}>'.format(context)
