
#line 1 "../gen/tmpl/lib.c"
/*
  gsl_cdf.c
  Ruby/Numo::GSL - GSL wrapper for Ruby/Numo::NArray

  created on: 2017-03-11
  Copyright (C) 2017 Masahiro Tanaka
*/

#include <ruby.h>
#include <assert.h>
#include "numo/narray.h"
#include "numo/template.h"
#include "../numo_gsl.h"
#line 15 "../gen/tmpl/lib.c"
#include <gsl/gsl_cdf.h>

#line 18 "../gen/tmpl/lib.c"
static VALUE mG;



#line 1 "../gen/tmpl/module.c"
/*
  module definition: Numo::GSL::Cdf
*/

#line 6 "../gen/tmpl/module.c"
static VALUE mCdf;


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_gaussian_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gaussian_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gaussian_P(x,sigma)
  @param  [DFloat]   x
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Gaussian
distribution with standard deviation sigma.
*/
static VALUE
cdf_s_gaussian_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gaussian_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_gaussian_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gaussian_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gaussian_Q(x,sigma)
  @param  [DFloat]   x
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Gaussian
distribution with standard deviation sigma.
*/
static VALUE
cdf_s_gaussian_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gaussian_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_gaussian_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gaussian_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gaussian_Pinv(P,sigma)
  @param  [DFloat]   P
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Gaussian
distribution with standard deviation sigma.
*/
static VALUE
cdf_s_gaussian_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gaussian_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_gaussian_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gaussian_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gaussian_Qinv(Q,sigma)
  @param  [DFloat]   Q
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Gaussian
distribution with standard deviation sigma.
*/
static VALUE
cdf_s_gaussian_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gaussian_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_cdf_s_ugaussian_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_ugaussian_P(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ugaussian_P(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the unit Gaussian
distribution.
*/
static VALUE
cdf_s_ugaussian_P(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_ugaussian_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_cdf_s_ugaussian_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_ugaussian_Q(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ugaussian_Q(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the unit Gaussian
distribution.
*/
static VALUE
cdf_s_ugaussian_Q(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_ugaussian_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_cdf_s_ugaussian_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_ugaussian_Pinv(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ugaussian_Pinv(P)
  @param  [DFloat]   P
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the unit Gaussian
distribution.
*/
static VALUE
cdf_s_ugaussian_Pinv(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_ugaussian_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_cdf_s_ugaussian_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_ugaussian_Qinv(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ugaussian_Qinv(Q)
  @param  [DFloat]   Q
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the unit Gaussian
distribution.
*/
static VALUE
cdf_s_ugaussian_Qinv(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_ugaussian_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_exponential_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exponential_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exponential_P(x,mu)
  @param  [DFloat]   x
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the exponential
distribution with mean mu.
*/
static VALUE
cdf_s_exponential_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exponential_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_exponential_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exponential_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exponential_Q(x,mu)
  @param  [DFloat]   x
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the exponential
distribution with mean mu.
*/
static VALUE
cdf_s_exponential_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exponential_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_exponential_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exponential_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exponential_Pinv(P,mu)
  @param  [DFloat]   P
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the exponential
distribution with mean mu.
*/
static VALUE
cdf_s_exponential_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exponential_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_exponential_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exponential_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exponential_Qinv(Q,mu)
  @param  [DFloat]   Q
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the exponential
distribution with mean mu.
*/
static VALUE
cdf_s_exponential_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exponential_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_laplace_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_laplace_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload laplace_P(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Laplace
distribution with width a.
*/
static VALUE
cdf_s_laplace_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_laplace_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_laplace_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_laplace_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload laplace_Q(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Laplace
distribution with width a.
*/
static VALUE
cdf_s_laplace_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_laplace_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_laplace_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_laplace_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload laplace_Pinv(P,a)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Laplace
distribution with width a.
*/
static VALUE
cdf_s_laplace_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_laplace_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_laplace_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_laplace_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload laplace_Qinv(Q,a)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Laplace
distribution with width a.
*/
static VALUE
cdf_s_laplace_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_laplace_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_exppow_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exppow_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exppow_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) for the exponential power distribution with
parameters a and b.
*/
static VALUE
cdf_s_exppow_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exppow_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_exppow_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_exppow_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exppow_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) for the exponential power distribution with
parameters a and b.
*/
static VALUE
cdf_s_exppow_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_exppow_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_cauchy_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_cauchy_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload cauchy_P(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Cauchy
distribution with scale parameter a.
*/
static VALUE
cdf_s_cauchy_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_cauchy_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_cauchy_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_cauchy_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload cauchy_Q(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Cauchy
distribution with scale parameter a.
*/
static VALUE
cdf_s_cauchy_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_cauchy_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_cauchy_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_cauchy_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload cauchy_Pinv(P,a)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Cauchy
distribution with scale parameter a.
*/
static VALUE
cdf_s_cauchy_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_cauchy_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_cauchy_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_cauchy_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload cauchy_Qinv(Q,a)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Cauchy
distribution with scale parameter a.
*/
static VALUE
cdf_s_cauchy_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_cauchy_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_rayleigh_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_rayleigh_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload rayleigh_P(x,sigma)
  @param  [DFloat]   x
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Rayleigh
distribution with scale parameter sigma.
*/
static VALUE
cdf_s_rayleigh_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_rayleigh_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_rayleigh_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_rayleigh_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload rayleigh_Q(x,sigma)
  @param  [DFloat]   x
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Rayleigh
distribution with scale parameter sigma.
*/
static VALUE
cdf_s_rayleigh_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_rayleigh_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_rayleigh_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_rayleigh_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload rayleigh_Pinv(P,sigma)
  @param  [DFloat]   P
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Rayleigh
distribution with scale parameter sigma.
*/
static VALUE
cdf_s_rayleigh_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_rayleigh_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_rayleigh_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_rayleigh_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload rayleigh_Qinv(Q,sigma)
  @param  [DFloat]   Q
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Rayleigh
distribution with scale parameter sigma.
*/
static VALUE
cdf_s_rayleigh_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_rayleigh_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gamma_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gamma_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gamma_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the gamma
distribution with parameters a and b.
*/
static VALUE
cdf_s_gamma_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gamma_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gamma_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gamma_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gamma_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the gamma
distribution with parameters a and b.
*/
static VALUE
cdf_s_gamma_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gamma_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gamma_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gamma_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gamma_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the gamma
distribution with parameters a and b.
*/
static VALUE
cdf_s_gamma_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gamma_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gamma_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gamma_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gamma_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the gamma
distribution with parameters a and b.
*/
static VALUE
cdf_s_gamma_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gamma_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_flat_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_flat_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload flat_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for a uniform distribution
from a to b.
*/
static VALUE
cdf_s_flat_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_flat_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_flat_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_flat_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload flat_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for a uniform distribution
from a to b.
*/
static VALUE
cdf_s_flat_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_flat_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_flat_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_flat_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload flat_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for a uniform distribution
from a to b.
*/
static VALUE
cdf_s_flat_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_flat_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_flat_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_flat_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload flat_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for a uniform distribution
from a to b.
*/
static VALUE
cdf_s_flat_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_flat_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_lognormal_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_lognormal_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lognormal_P(x,zeta,sigma)
  @param  [DFloat]   x
  @param  [Float]    zeta parameter
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the lognormal
distribution with parameters zeta and sigma.
*/
static VALUE
cdf_s_lognormal_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_lognormal_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_lognormal_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_lognormal_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lognormal_Q(x,zeta,sigma)
  @param  [DFloat]   x
  @param  [Float]    zeta parameter
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the lognormal
distribution with parameters zeta and sigma.
*/
static VALUE
cdf_s_lognormal_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_lognormal_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_lognormal_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_lognormal_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lognormal_Pinv(P,zeta,sigma)
  @param  [DFloat]   P
  @param  [Float]    zeta parameter
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the lognormal
distribution with parameters zeta and sigma.
*/
static VALUE
cdf_s_lognormal_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_lognormal_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_lognormal_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_lognormal_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lognormal_Qinv(Q,zeta,sigma)
  @param  [DFloat]   Q
  @param  [Float]    zeta parameter
  @param  [Float]    sigma parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the lognormal
distribution with parameters zeta and sigma.
*/
static VALUE
cdf_s_lognormal_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_lognormal_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_chisq_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_chisq_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload chisq_P(x,nu)
  @param  [DFloat]   x
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the chi-squared
distribution with nu degrees of freedom.
*/
static VALUE
cdf_s_chisq_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_chisq_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_chisq_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_chisq_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload chisq_Q(x,nu)
  @param  [DFloat]   x
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the chi-squared
distribution with nu degrees of freedom.
*/
static VALUE
cdf_s_chisq_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_chisq_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_chisq_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_chisq_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload chisq_Pinv(P,nu)
  @param  [DFloat]   P
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the chi-squared
distribution with nu degrees of freedom.
*/
static VALUE
cdf_s_chisq_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_chisq_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_chisq_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_chisq_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload chisq_Qinv(Q,nu)
  @param  [DFloat]   Q
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the chi-squared
distribution with nu degrees of freedom.
*/
static VALUE
cdf_s_chisq_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_chisq_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_fdist_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_fdist_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fdist_P(x,nu1,nu2)
  @param  [DFloat]   x
  @param  [Float]    nu1 parameter
  @param  [Float]    nu2 parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the F-distribution
with nu1 and nu2 degrees of freedom.
*/
static VALUE
cdf_s_fdist_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_fdist_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_fdist_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_fdist_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fdist_Q(x,nu1,nu2)
  @param  [DFloat]   x
  @param  [Float]    nu1 parameter
  @param  [Float]    nu2 parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the F-distribution
with nu1 and nu2 degrees of freedom.
*/
static VALUE
cdf_s_fdist_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_fdist_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_fdist_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_fdist_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fdist_Pinv(P,nu1,nu2)
  @param  [DFloat]   P
  @param  [Float]    nu1 parameter
  @param  [Float]    nu2 parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the F-distribution
with nu1 and nu2 degrees of freedom.
*/
static VALUE
cdf_s_fdist_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_fdist_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_fdist_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_fdist_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fdist_Qinv(Q,nu1,nu2)
  @param  [DFloat]   Q
  @param  [Float]    nu1 parameter
  @param  [Float]    nu2 parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the F-distribution
with nu1 and nu2 degrees of freedom.
*/
static VALUE
cdf_s_fdist_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_fdist_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_tdist_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_tdist_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload tdist_P(x,nu)
  @param  [DFloat]   x
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the t-distribution
with nu degrees of freedom.
*/
static VALUE
cdf_s_tdist_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_tdist_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_tdist_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_tdist_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload tdist_Q(x,nu)
  @param  [DFloat]   x
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the t-distribution
with nu degrees of freedom.
*/
static VALUE
cdf_s_tdist_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_tdist_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_tdist_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_tdist_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload tdist_Pinv(P,nu)
  @param  [DFloat]   P
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the t-distribution
with nu degrees of freedom.
*/
static VALUE
cdf_s_tdist_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_tdist_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_tdist_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_tdist_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload tdist_Qinv(Q,nu)
  @param  [DFloat]   Q
  @param  [Float]    nu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the t-distribution
with nu degrees of freedom.
*/
static VALUE
cdf_s_tdist_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_tdist_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_beta_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_beta_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload beta_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the beta
distribution with parameters a and b.
*/
static VALUE
cdf_s_beta_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_beta_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_beta_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_beta_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload beta_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the beta
distribution with parameters a and b.
*/
static VALUE
cdf_s_beta_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_beta_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_beta_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_beta_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload beta_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the beta
distribution with parameters a and b.
*/
static VALUE
cdf_s_beta_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_beta_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_beta_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_beta_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload beta_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the beta
distribution with parameters a and b.
*/
static VALUE
cdf_s_beta_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_beta_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_logistic_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_logistic_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload logistic_P(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the logistic
distribution with scale parameter a.
*/
static VALUE
cdf_s_logistic_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_logistic_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_logistic_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_logistic_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload logistic_Q(x,a)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the logistic
distribution with scale parameter a.
*/
static VALUE
cdf_s_logistic_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_logistic_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_logistic_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_logistic_Pinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload logistic_Pinv(P,a)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the logistic
distribution with scale parameter a.
*/
static VALUE
cdf_s_logistic_Pinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_logistic_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double.c"
static void
iter_cdf_s_logistic_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_logistic_Qinv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload logistic_Qinv(Q,a)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the logistic
distribution with scale parameter a.
*/
static VALUE
cdf_s_logistic_Qinv(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_logistic_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_pareto_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pareto_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pareto_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Pareto
distribution with exponent a and scale b.
*/
static VALUE
cdf_s_pareto_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pareto_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_pareto_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pareto_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pareto_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Pareto
distribution with exponent a and scale b.
*/
static VALUE
cdf_s_pareto_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pareto_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_pareto_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pareto_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pareto_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Pareto
distribution with exponent a and scale b.
*/
static VALUE
cdf_s_pareto_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pareto_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_pareto_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pareto_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pareto_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Pareto
distribution with exponent a and scale b.
*/
static VALUE
cdf_s_pareto_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pareto_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_weibull_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_weibull_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload weibull_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Weibull
distribution with scale a and exponent b.
*/
static VALUE
cdf_s_weibull_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_weibull_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_weibull_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_weibull_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload weibull_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Weibull
distribution with scale a and exponent b.
*/
static VALUE
cdf_s_weibull_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_weibull_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_weibull_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_weibull_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload weibull_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Weibull
distribution with scale a and exponent b.
*/
static VALUE
cdf_s_weibull_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_weibull_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_weibull_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_weibull_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload weibull_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Weibull
distribution with scale a and exponent b.
*/
static VALUE
cdf_s_weibull_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_weibull_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel1_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel1_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel1_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-1 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel1_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel1_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel1_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel1_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel1_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-1 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel1_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel1_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel1_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel1_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel1_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-1 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel1_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel1_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel1_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel1_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel1_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-1 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel1_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel1_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel2_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel2_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel2_P(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-2 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel2_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel2_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel2_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel2_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel2_Q(x,a,b)
  @param  [DFloat]   x
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-2 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel2_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel2_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel2_Pinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel2_Pinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel2_Pinv(P,a,b)
  @param  [DFloat]   P
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-2 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel2_Pinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel2_Pinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_double_x2.c"
static void
iter_cdf_s_gumbel2_Qinv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_gumbel2_Qinv(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gumbel2_Qinv(Q,a,b)
  @param  [DFloat]   Q
  @param  [Float]    a parameter
  @param  [Float]    b parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(x), Q(x) and their inverses for the Type-2 Gumbel
distribution with parameters a and b.
*/
static VALUE
cdf_s_gumbel2_Qinv(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_gumbel2_Qinv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double.c"
static void
iter_cdf_s_poisson_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_cdf_poisson_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload poisson_P(k,mu)
  @param  [UInt]     k
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the Poisson distribution with parameter
mu.
*/
static VALUE
cdf_s_poisson_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_poisson_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double.c"
static void
iter_cdf_s_poisson_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_cdf_poisson_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload poisson_Q(k,mu)
  @param  [UInt]     k
  @param  [Float]    mu parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the Poisson distribution with parameter
mu.
*/
static VALUE
cdf_s_poisson_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_poisson_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_uint.c"
static void
iter_cdf_s_binomial_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    char *opt;
    double c1;
    unsigned int c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (char*)(lp->opt_ptr);
    c1 = *(double*)opt;
    c2 = *(unsigned int*)(opt+sizeof(double));

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_binomial_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload binomial_P(k,p,n)
  @param  [UInt]     k
  @param  [Integer]  p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k)  for the binomial
distribution with parameters p and n.
*/
static VALUE
cdf_s_binomial_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_binomial_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    char *opt;
    opt = ALLOCA_N(char,sizeof(double)+sizeof(unsigned int));

    *(double*)opt = NUM2DBL(v1);
    *(unsigned int*)(opt+sizeof(double)) = NUM2UINT(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_uint.c"
static void
iter_cdf_s_binomial_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    char *opt;
    double c1;
    unsigned int c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (char*)(lp->opt_ptr);
    c1 = *(double*)opt;
    c2 = *(unsigned int*)(opt+sizeof(double));

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_binomial_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload binomial_Q(k,p,n)
  @param  [UInt]     k
  @param  [Integer]  p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k)  for the binomial
distribution with parameters p and n.
*/
static VALUE
cdf_s_binomial_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_binomial_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    char *opt;
    opt = ALLOCA_N(char,sizeof(double)+sizeof(unsigned int));

    *(double*)opt = NUM2DBL(v1);
    *(unsigned int*)(opt+sizeof(double)) = NUM2UINT(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_x2.c"
static void
iter_cdf_s_negative_binomial_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_negative_binomial_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload negative_binomial_P(k,p,n)
  @param  [UInt]     k
  @param  [Float]    p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the negative binomial distribution with
parameters p and n.
*/
static VALUE
cdf_s_negative_binomial_P(VALUE mod , VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_negative_binomial_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_x2.c"
static void
iter_cdf_s_negative_binomial_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double  *opt;
    double   c1, c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (double*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_negative_binomial_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload negative_binomial_Q(k,p,n)
  @param  [UInt]     k
  @param  [Float]    p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the negative binomial distribution with
parameters p and n.
*/
static VALUE
cdf_s_negative_binomial_Q(VALUE mod , VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_negative_binomial_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double opt[2];

    opt[0] = NUM2DBL(v1);
    opt[1] = NUM2DBL(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_uint.c"
static void
iter_cdf_s_pascal_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    char *opt;
    double c1;
    unsigned int c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (char*)(lp->opt_ptr);
    c1 = *(double*)opt;
    c2 = *(unsigned int*)(opt+sizeof(double));

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pascal_P(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pascal_P(k,p,n)
  @param  [UInt]     k
  @param  [Integer]  p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the Pascal distribution with
parameters p and n.
*/
static VALUE
cdf_s_pascal_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pascal_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    char *opt;
    opt = ALLOCA_N(char,sizeof(double)+sizeof(unsigned int));

    *(double*)opt = NUM2DBL(v1);
    *(unsigned int*)(opt+sizeof(double)) = NUM2UINT(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double_uint.c"
static void
iter_cdf_s_pascal_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    char *opt;
    double c1;
    unsigned int c2;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (char*)(lp->opt_ptr);
    c1 = *(double*)opt;
    c2 = *(unsigned int*)(opt+sizeof(double));

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_pascal_Q(x, c1, c2);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload pascal_Q(k,p,n)
  @param  [UInt]     k
  @param  [Integer]  p parameter
  @param  [Float]    n parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the Pascal distribution with
parameters p and n.
*/
static VALUE
cdf_s_pascal_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_pascal_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    char *opt;
    opt = ALLOCA_N(char,sizeof(double)+sizeof(unsigned int));

    *(double*)opt = NUM2DBL(v1);
    *(unsigned int*)(opt+sizeof(double)) = NUM2UINT(v2);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double.c"
static void
iter_cdf_s_geometric_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_cdf_geometric_P(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload geometric_P(k,p)
  @param  [UInt]     k
  @param  [Float]    p parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the geometric distribution with parameter
p.
*/
static VALUE
cdf_s_geometric_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_geometric_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_double.c"
static void
iter_cdf_s_geometric_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    double   c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(double*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_cdf_geometric_Q(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload geometric_Q(k,p)
  @param  [UInt]     k
  @param  [Float]    p parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the geometric distribution with parameter
p.
*/
static VALUE
cdf_s_geometric_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_geometric_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    double c1;

    c1 = NUM2DBL(v1);

    return na_ndloop3(&ndf, &c1, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_uint_x3.c"
static void
iter_cdf_s_hypergeometric_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    unsigned int *opt;
    unsigned int c1, c2, c3;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (unsigned int*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];
    c3 = opt[2];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_hypergeometric_P(x, c1, c2, c3);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload hypergeometric_P(k,n1,n2,t)
  @param  [UInt]     k
  @param  [Integer]  n1 parameter
  @param  [Integer]  n2 parameter
  @param  [Integer]  t parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the hypergeometric distribution with
parameters n1, n2 and t.
*/
static VALUE
cdf_s_hypergeometric_P(VALUE mod, VALUE v0, VALUE v1, VALUE v2, VALUE v3)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_hypergeometric_P, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    unsigned int opt[3];

    opt[0] = NUM2UINT(v1);
    opt[1] = NUM2UINT(v2);
    opt[2] = NUM2UINT(v3);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt_uint_x3.c"
static void
iter_cdf_s_hypergeometric_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;
    unsigned int *opt;
    unsigned int c1, c2, c3;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    opt = (unsigned int*)(lp->opt_ptr);
    c1 = opt[0];
    c2 = opt[1];
    c3 = opt[2];

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_cdf_hypergeometric_Q(x, c1, c2, c3);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload hypergeometric_Q(k,n1,n2,t)
  @param  [UInt]     k
  @param  [Integer]  n1 parameter
  @param  [Integer]  n2 parameter
  @param  [Integer]  t parameter
  @return [DFloat]   result

  These functions compute the cumulative distribution functions
P(k), Q(k) for the hypergeometric distribution with
parameters n1, n2 and t.
*/
static VALUE
cdf_s_hypergeometric_Q(VALUE mod, VALUE v0, VALUE v1, VALUE v2, VALUE v3)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_cdf_s_hypergeometric_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    unsigned int opt[3];

    opt[0] = NUM2UINT(v1);
    opt[1] = NUM2UINT(v2);
    opt[2] = NUM2UINT(v3);

    return na_ndloop3(&ndf, opt, 1, v0);
}


#line 28 "../gen/tmpl/lib.c"
void
Init_cdf(void)
{
    VALUE mN;
    mN = rb_define_module("Numo");
    mG = rb_define_module_under(mN, "GSL");

    


#line 1 "../gen/tmpl/init_module.c"

    /*
      Document-module: Numo::GSL::Cdf
      
    */
    {
    
    mCdf = rb_define_module_under(mG, "Cdf");
    
    
    rb_define_module_function(mCdf, "gaussian_P", cdf_s_gaussian_P, 2);
    rb_define_module_function(mCdf, "gaussian_Q", cdf_s_gaussian_Q, 2);
    rb_define_module_function(mCdf, "gaussian_Pinv", cdf_s_gaussian_Pinv, 2);
    rb_define_module_function(mCdf, "gaussian_Qinv", cdf_s_gaussian_Qinv, 2);
    rb_define_module_function(mCdf, "ugaussian_P", cdf_s_ugaussian_P, 1);
    rb_define_module_function(mCdf, "ugaussian_Q", cdf_s_ugaussian_Q, 1);
    rb_define_module_function(mCdf, "ugaussian_Pinv", cdf_s_ugaussian_Pinv, 1);
    rb_define_module_function(mCdf, "ugaussian_Qinv", cdf_s_ugaussian_Qinv, 1);
    rb_define_module_function(mCdf, "exponential_P", cdf_s_exponential_P, 2);
    rb_define_module_function(mCdf, "exponential_Q", cdf_s_exponential_Q, 2);
    rb_define_module_function(mCdf, "exponential_Pinv", cdf_s_exponential_Pinv, 2);
    rb_define_module_function(mCdf, "exponential_Qinv", cdf_s_exponential_Qinv, 2);
    rb_define_module_function(mCdf, "laplace_P", cdf_s_laplace_P, 2);
    rb_define_module_function(mCdf, "laplace_Q", cdf_s_laplace_Q, 2);
    rb_define_module_function(mCdf, "laplace_Pinv", cdf_s_laplace_Pinv, 2);
    rb_define_module_function(mCdf, "laplace_Qinv", cdf_s_laplace_Qinv, 2);
    rb_define_module_function(mCdf, "exppow_P", cdf_s_exppow_P, 3);
    rb_define_module_function(mCdf, "exppow_Q", cdf_s_exppow_Q, 3);
    rb_define_module_function(mCdf, "cauchy_P", cdf_s_cauchy_P, 2);
    rb_define_module_function(mCdf, "cauchy_Q", cdf_s_cauchy_Q, 2);
    rb_define_module_function(mCdf, "cauchy_Pinv", cdf_s_cauchy_Pinv, 2);
    rb_define_module_function(mCdf, "cauchy_Qinv", cdf_s_cauchy_Qinv, 2);
    rb_define_module_function(mCdf, "rayleigh_P", cdf_s_rayleigh_P, 2);
    rb_define_module_function(mCdf, "rayleigh_Q", cdf_s_rayleigh_Q, 2);
    rb_define_module_function(mCdf, "rayleigh_Pinv", cdf_s_rayleigh_Pinv, 2);
    rb_define_module_function(mCdf, "rayleigh_Qinv", cdf_s_rayleigh_Qinv, 2);
    rb_define_module_function(mCdf, "gamma_P", cdf_s_gamma_P, 3);
    rb_define_module_function(mCdf, "gamma_Q", cdf_s_gamma_Q, 3);
    rb_define_module_function(mCdf, "gamma_Pinv", cdf_s_gamma_Pinv, 3);
    rb_define_module_function(mCdf, "gamma_Qinv", cdf_s_gamma_Qinv, 3);
    rb_define_module_function(mCdf, "flat_P", cdf_s_flat_P, 3);
    rb_define_module_function(mCdf, "flat_Q", cdf_s_flat_Q, 3);
    rb_define_module_function(mCdf, "flat_Pinv", cdf_s_flat_Pinv, 3);
    rb_define_module_function(mCdf, "flat_Qinv", cdf_s_flat_Qinv, 3);
    rb_define_module_function(mCdf, "lognormal_P", cdf_s_lognormal_P, 3);
    rb_define_module_function(mCdf, "lognormal_Q", cdf_s_lognormal_Q, 3);
    rb_define_module_function(mCdf, "lognormal_Pinv", cdf_s_lognormal_Pinv, 3);
    rb_define_module_function(mCdf, "lognormal_Qinv", cdf_s_lognormal_Qinv, 3);
    rb_define_module_function(mCdf, "chisq_P", cdf_s_chisq_P, 2);
    rb_define_module_function(mCdf, "chisq_Q", cdf_s_chisq_Q, 2);
    rb_define_module_function(mCdf, "chisq_Pinv", cdf_s_chisq_Pinv, 2);
    rb_define_module_function(mCdf, "chisq_Qinv", cdf_s_chisq_Qinv, 2);
    rb_define_module_function(mCdf, "fdist_P", cdf_s_fdist_P, 3);
    rb_define_module_function(mCdf, "fdist_Q", cdf_s_fdist_Q, 3);
    rb_define_module_function(mCdf, "fdist_Pinv", cdf_s_fdist_Pinv, 3);
    rb_define_module_function(mCdf, "fdist_Qinv", cdf_s_fdist_Qinv, 3);
    rb_define_module_function(mCdf, "tdist_P", cdf_s_tdist_P, 2);
    rb_define_module_function(mCdf, "tdist_Q", cdf_s_tdist_Q, 2);
    rb_define_module_function(mCdf, "tdist_Pinv", cdf_s_tdist_Pinv, 2);
    rb_define_module_function(mCdf, "tdist_Qinv", cdf_s_tdist_Qinv, 2);
    rb_define_module_function(mCdf, "beta_P", cdf_s_beta_P, 3);
    rb_define_module_function(mCdf, "beta_Q", cdf_s_beta_Q, 3);
    rb_define_module_function(mCdf, "beta_Pinv", cdf_s_beta_Pinv, 3);
    rb_define_module_function(mCdf, "beta_Qinv", cdf_s_beta_Qinv, 3);
    rb_define_module_function(mCdf, "logistic_P", cdf_s_logistic_P, 2);
    rb_define_module_function(mCdf, "logistic_Q", cdf_s_logistic_Q, 2);
    rb_define_module_function(mCdf, "logistic_Pinv", cdf_s_logistic_Pinv, 2);
    rb_define_module_function(mCdf, "logistic_Qinv", cdf_s_logistic_Qinv, 2);
    rb_define_module_function(mCdf, "pareto_P", cdf_s_pareto_P, 3);
    rb_define_module_function(mCdf, "pareto_Q", cdf_s_pareto_Q, 3);
    rb_define_module_function(mCdf, "pareto_Pinv", cdf_s_pareto_Pinv, 3);
    rb_define_module_function(mCdf, "pareto_Qinv", cdf_s_pareto_Qinv, 3);
    rb_define_module_function(mCdf, "weibull_P", cdf_s_weibull_P, 3);
    rb_define_module_function(mCdf, "weibull_Q", cdf_s_weibull_Q, 3);
    rb_define_module_function(mCdf, "weibull_Pinv", cdf_s_weibull_Pinv, 3);
    rb_define_module_function(mCdf, "weibull_Qinv", cdf_s_weibull_Qinv, 3);
    rb_define_module_function(mCdf, "gumbel1_P", cdf_s_gumbel1_P, 3);
    rb_define_module_function(mCdf, "gumbel1_Q", cdf_s_gumbel1_Q, 3);
    rb_define_module_function(mCdf, "gumbel1_Pinv", cdf_s_gumbel1_Pinv, 3);
    rb_define_module_function(mCdf, "gumbel1_Qinv", cdf_s_gumbel1_Qinv, 3);
    rb_define_module_function(mCdf, "gumbel2_P", cdf_s_gumbel2_P, 3);
    rb_define_module_function(mCdf, "gumbel2_Q", cdf_s_gumbel2_Q, 3);
    rb_define_module_function(mCdf, "gumbel2_Pinv", cdf_s_gumbel2_Pinv, 3);
    rb_define_module_function(mCdf, "gumbel2_Qinv", cdf_s_gumbel2_Qinv, 3);
    rb_define_module_function(mCdf, "poisson_P", cdf_s_poisson_P, 2);
    rb_define_module_function(mCdf, "poisson_Q", cdf_s_poisson_Q, 2);
    rb_define_module_function(mCdf, "binomial_P", cdf_s_binomial_P, 3);
    rb_define_module_function(mCdf, "binomial_Q", cdf_s_binomial_Q, 3);
    rb_define_module_function(mCdf, "negative_binomial_P", cdf_s_negative_binomial_P, 3);
    rb_define_module_function(mCdf, "negative_binomial_Q", cdf_s_negative_binomial_Q, 3);
    rb_define_module_function(mCdf, "pascal_P", cdf_s_pascal_P, 3);
    rb_define_module_function(mCdf, "pascal_Q", cdf_s_pascal_Q, 3);
    rb_define_module_function(mCdf, "geometric_P", cdf_s_geometric_P, 2);
    rb_define_module_function(mCdf, "geometric_Q", cdf_s_geometric_Q, 2);
    rb_define_module_function(mCdf, "hypergeometric_P", cdf_s_hypergeometric_P, 4);
    rb_define_module_function(mCdf, "hypergeometric_Q", cdf_s_hypergeometric_Q, 4);
#line 12 "../gen/tmpl/init_module.c"
    }
#line 41 "../gen/tmpl/lib.c"
}
