
#line 1 "../gen/tmpl/lib.c"
/*
  gsl_Sf.c
  Ruby/Numo::GSL - GSL wrapper for Ruby/Numo::NArray

  created on: 2017-03-11
  Copyright (C) 2017 Masahiro Tanaka
*/

#include <ruby.h>
#include <assert.h>
#include "numo/narray.h"
#include "numo/template.h"
#include "../numo_gsl.h"
#line 15 "../gen/tmpl/lib.c"
#include <gsl/gsl_sf.h>

#line 18 "../gen/tmpl/lib.c"
static VALUE mG;



#line 1 "../gen/tmpl/module.c"
/*
  module definition: Numo::GSL::Sf
*/

#line 6 "../gen/tmpl/module.c"
static VALUE mSf;


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_log(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_log(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload log(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of x, \log(x), for
x > 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_log, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_log_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_log_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload log_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of x, \log(x), for
x > 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_log_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_log_abs(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_log_abs(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload log_abs(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of the magnitude of x,
\log(|x|), for x \ne 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_abs(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_log_abs, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_log_abs_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_log_abs_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload log_abs_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the magnitude of x,
\log(|x|), for x \ne 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_abs_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_log_abs_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_complex_log_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //zr
    c1 = *(double*)GET_PTR(lp,1); //zi
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_complex_log_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //lnr
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //theta
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload complex_log_e(zr,zi)
  
  @param [Numo::DFloat] zr
  @param [Numo::DFloat] zi
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [lnr.val, lnr.err, theta.val, theta.err, return]

  This routine computes the complex logarithm of z = z_r + i
z_i. The results are returned as lnr, theta such that
\exp(lnr + i \theta) = z_r + i z_i, where \theta lies in
the range [-\pi,\pi].
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_complex_log_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_complex_log_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_log_1plusx(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_log_1plusx(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload log_1plusx(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute \log(1 + x) for x > -1 using an
algorithm that is accurate for small x.
Domain: x > -1.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_1plusx(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_log_1plusx, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_log_1plusx_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_log_1plusx_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload log_1plusx_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \log(1 + x) for x > -1 using an
algorithm that is accurate for small x.
Domain: x > -1.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_1plusx_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_log_1plusx_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_log_1plusx_mx(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_log_1plusx_mx(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload log_1plusx_mx(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute \log(1 + x) - x for x > -1 using an
algorithm that is accurate for small x.
Domain: x > -1.0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_1plusx_mx(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_log_1plusx_mx, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_log_1plusx_mx_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_log_1plusx_mx_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload log_1plusx_mx_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \log(1 + x) - x for x > -1 using an
algorithm that is accurate for small x.
Domain: x > -1.0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_log_1plusx_mx_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_log_1plusx_mx_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_sin(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_sin(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload sin(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the sine function \sin(x).
Exceptional Return Values:
*/
static VALUE
sf_s_sin(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_sin, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_sin_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_sin_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload sin_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the sine function \sin(x).
Exceptional Return Values:
*/
static VALUE
sf_s_sin_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_sin_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_cos(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_cos(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload cos(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the cosine function \cos(x).
Exceptional Return Values:
*/
static VALUE
sf_s_cos(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_cos, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_cos_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_cos_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload cos_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the cosine function \cos(x).
Exceptional Return Values:
*/
static VALUE
sf_s_cos_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_cos_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_hypot(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_hypot(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload hypot(x, y)
  @param  [DFloat]   x
  @param  [DFloat]   y
  @return [DFloat]   result

  These routines compute the hypotenuse function $\sqrt{x^2 + y^2}$
\sqrt[x^2 + y^2] avoiding overflow and underflow.
Exceptional Return Values:
*/
static VALUE
sf_s_hypot(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hypot, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hypot_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hypot_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hypot_e(x,y)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the hypotenuse function $\sqrt{x^2 + y^2}$
\sqrt[x^2 + y^2] avoiding overflow and underflow.
Exceptional Return Values:
*/
static VALUE
sf_s_hypot_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hypot_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_sinc(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_sinc(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload sinc(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute \sinc(x) = \sin(\pi x) / (\pi x) for any
value of x.
Exceptional Return Values: none
*/
static VALUE
sf_s_sinc(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_sinc, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_sinc_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_sinc_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload sinc_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \sinc(x) = \sin(\pi x) / (\pi x) for any
value of x.
Exceptional Return Values: none
*/
static VALUE
sf_s_sinc_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_sinc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_complex_sin_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //zr
    c1 = *(double*)GET_PTR(lp,1); //zi
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_complex_sin_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //szr
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //szi
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload complex_sin_e(zr,zi)
  
  @param [Numo::DFloat] zr
  @param [Numo::DFloat] zi
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [szr.val, szr.err, szi.val, szi.err, return]

  This function computes the complex sine, \sin(z_r + i z_i) storing
the real and imaginary parts in szr, szi.
Exceptional Return Values: GSL_EOVRFLW
*/
static VALUE
sf_s_complex_sin_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_complex_sin_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_complex_cos_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //zr
    c1 = *(double*)GET_PTR(lp,1); //zi
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_complex_cos_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //czr
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //czi
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload complex_cos_e(zr,zi)
  
  @param [Numo::DFloat] zr
  @param [Numo::DFloat] zi
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [czr.val, czr.err, czi.val, czi.err, return]

  This function computes the complex cosine, \cos(z_r + i z_i) storing
the real and imaginary parts in czr, czi.
Exceptional Return Values: GSL_EOVRFLW
*/
static VALUE
sf_s_complex_cos_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_complex_cos_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_complex_logsin_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //zr
    c1 = *(double*)GET_PTR(lp,1); //zi
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_complex_logsin_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //lszr
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //lszi
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload complex_logsin_e(zr,zi)
  
  @param [Numo::DFloat] zr
  @param [Numo::DFloat] zi
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [lszr.val, lszr.err, lszi.val, lszi.err, return]

  This function computes the logarithm of the complex sine,
\log(\sin(z_r + i z_i)) storing the real and imaginary parts in
lszr, lszi.
Exceptional Return Values: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_complex_logsin_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_complex_logsin_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_lnsinh(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_lnsinh(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lnsinh(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute \log(\sinh(x)) for x > 0.
Domain: x > 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_lnsinh(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lnsinh, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnsinh_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lnsinh_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnsinh_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \log(\sinh(x)) for x > 0.
Domain: x > 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_lnsinh_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnsinh_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_lncosh(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_lncosh(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lncosh(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute \log(\cosh(x)) for any x.
Exceptional Return Values: none
*/
static VALUE
sf_s_lncosh(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lncosh, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lncosh_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lncosh_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lncosh_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \log(\cosh(x)) for any x.
Exceptional Return Values: none
*/
static VALUE
sf_s_lncosh_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lncosh_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_polar_to_rect(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //r
    c1 = *(double*)GET_PTR(lp,1); //theta
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_polar_to_rect(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //x
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //y
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload polar_to_rect(r,theta)
  
  @param [Numo::DFloat] r
  @param [Numo::DFloat] theta
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [x.val, x.err, y.val, y.err, return]

  This function converts the polar coordinates (r,theta) to
rectilinear coordinates (x,y), x = r\cos(\theta),
y = r\sin(\theta).
Exceptional Return Values: GSL_ELOSS
*/
static VALUE
sf_s_polar_to_rect(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_polar_to_rect,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_rect_to_polar(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_rect_to_polar(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //r
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //theta
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload rect_to_polar(x,y)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [r.val, r.err, theta.val, theta.err, return]

  This function converts the rectilinear coordinates (x,y) to
polar coordinates (r,theta), such that x =
r\cos(\theta), y = r\sin(\theta).  The argument theta
lies in the range [-\pi, \pi].
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_rect_to_polar(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_rect_to_polar,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_angle_restrict_symm(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_angle_restrict_symm(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload angle_restrict_symm(theta)
  @param  [DFloat]   theta
  @return [DFloat]   result

  These routines force the angle theta to lie in the range
(-\pi,\pi].  

Note that the mathematical value of \pi is slightly greater
than M_PI, so the machine numbers M_PI and -M_PI
are included in the range.
Exceptional Return Values: GSL_ELOSS
*/
static VALUE
sf_s_angle_restrict_symm(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_angle_restrict_symm, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_angle_restrict_pos(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_angle_restrict_pos(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload angle_restrict_pos(theta)
  @param  [DFloat]   theta
  @return [DFloat]   result

  These routines force the angle theta to lie in the range [0,
2\pi). 

Note that the mathematical value of 2\pi is slightly greater
than 2*M_PI, so the machine number 2*M_PI is included in
the range.

Exceptional Return Values: GSL_ELOSS
*/
static VALUE
sf_s_angle_restrict_pos(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_angle_restrict_pos, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_sin_err_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_sin_err_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload sin_err_e(x,dx)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This routine computes the sine of an angle x with an associated 
absolute error dx,
$\sin(x \pm dx)$
\sin(x \pm dx).  Note that this function is provided in the error-handling form only since
its purpose is to compute the propagated error.
*/
static VALUE
sf_s_sin_err_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_sin_err_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_cos_err_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_cos_err_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload cos_err_e(x,dx)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This routine computes the cosine of an angle x with an associated
absolute error dx, 
$\cos(x \pm dx)$
\cos(x \pm dx).  Note that this function is provided in the error-handling form only since
its purpose is to compute the propagated error.
*/
static VALUE
sf_s_cos_err_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_cos_err_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_gamma(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_gamma(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gamma(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Gamma function \Gamma(x), subject to x
not being a negative integer or zero.  The function is computed using the real
Lanczos method. The maximum value of x such that \Gamma(x) is not
considered an overflow is given by the macro GSL_SF_GAMMA_XMAX
and is 171.0.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EROUND
*/
static VALUE
sf_s_gamma(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gamma, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gamma_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_gamma_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gamma_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Gamma function \Gamma(x), subject to x
not being a negative integer or zero.  The function is computed using the real
Lanczos method. The maximum value of x such that \Gamma(x) is not
considered an overflow is given by the macro GSL_SF_GAMMA_XMAX
and is 171.0.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EROUND
*/
static VALUE
sf_s_gamma_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_lngamma(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_lngamma(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lngamma(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of the Gamma function,
\log(\Gamma(x)), subject to x not being a negative
integer or zero.  For x<0 the real part of \log(\Gamma(x)) is
returned, which is equivalent to \log(|\Gamma(x)|).  The function
is computed using the real Lanczos method.
exceptions: GSL_EDOM, GSL_EROUND
*/
static VALUE
sf_s_lngamma(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lngamma, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lngamma_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lngamma_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lngamma_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the Gamma function,
\log(\Gamma(x)), subject to x not being a negative
integer or zero.  For x<0 the real part of \log(\Gamma(x)) is
returned, which is equivalent to \log(|\Gamma(x)|).  The function
is computed using the real Lanczos method.
exceptions: GSL_EDOM, GSL_EROUND
*/
static VALUE
sf_s_lngamma_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lngamma_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lngamma_sgn_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    double c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_lngamma_sgn_e(c0,&c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result_lg
    *(double*)GET_PTR(lp,3) = c2; //sgn
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lngamma_sgn_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_lg.val, result_lg.err, sgn, return]

  This routine computes the sign of the gamma function and the logarithm of
its magnitude, subject to x not being a negative integer or zero.  The
function is computed using the real Lanczos method.  The value of the
gamma function and its error can be reconstructed using the relation 
\Gamma(x) = sgn * \exp(result\_lg), taking into account the two 
components of result_lg.
exceptions: GSL_EDOM, GSL_EROUND
*/
static VALUE
sf_s_lngamma_sgn_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lngamma_sgn_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_gammastar(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_gammastar(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gammastar(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regulated Gamma Function \Gamma^*(x)
for x > 0. The regulated gamma function is given by,

\Gamma^*(x) = \Gamma(x)/(\sqrt[2\pi] x^[(x-1/2)] \exp(-x))
            = (1 + (1/12x) + ...)  for x \to \infty
and is a useful suggestion of Temme.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gammastar(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gammastar, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gammastar_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_gammastar_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gammastar_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regulated Gamma Function \Gamma^*(x)
for x > 0. The regulated gamma function is given by,

\Gamma^*(x) = \Gamma(x)/(\sqrt[2\pi] x^[(x-1/2)] \exp(-x))
            = (1 + (1/12x) + ...)  for x \to \infty
and is a useful suggestion of Temme.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gammastar_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gammastar_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_gammainv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_gammainv(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload gammainv(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the reciprocal of the gamma function,
1/\Gamma(x) using the real Lanczos method.
exceptions: GSL_EUNDRFLW, GSL_EROUND
*/
static VALUE
sf_s_gammainv(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gammainv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gammainv_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_gammainv_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gammainv_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the reciprocal of the gamma function,
1/\Gamma(x) using the real Lanczos method.
exceptions: GSL_EUNDRFLW, GSL_EROUND
*/
static VALUE
sf_s_gammainv_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gammainv_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lngamma_complex_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //zr
    c1 = *(double*)GET_PTR(lp,1); //zi
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_lngamma_complex_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //lnr
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //arg
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lngamma_complex_e(zr,zi)
  
  @param [Numo::DFloat] zr
  @param [Numo::DFloat] zi
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [lnr.val, lnr.err, arg.val, arg.err, return]

  This routine computes \log(\Gamma(z)) for complex z=z_r+i
z_i and z not a negative integer or zero, using the complex Lanczos
method.  The returned parameters are lnr = \log|\Gamma(z)| and
arg = \arg(\Gamma(z)) in (-\pi,\pi].  Note that the phase
part (arg) is not well-determined when |z| is very large,
due to inevitable roundoff in restricting to (-\pi,\pi].  This
will result in a GSL_ELOSS error when it occurs.  The absolute
value part (lnr), however, never suffers from loss of precision.
exceptions: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_lngamma_complex_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lngamma_complex_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_fact(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_fact(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fact(n)
  @param  [UInt]     n
  @return [DFloat]   result

  These routines compute the factorial n!.  The factorial is
related to the Gamma function by n! = \Gamma(n+1).
The maximum value of n such that n! is not
considered an overflow is given by the macro GSL_SF_FACT_NMAX
and is 170.
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_fact(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fact, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fact_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fact_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fact_e(n)
  
  @param [Numo::UInt] n
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the factorial n!.  The factorial is
related to the Gamma function by n! = \Gamma(n+1).
The maximum value of n such that n! is not
considered an overflow is given by the macro GSL_SF_FACT_NMAX
and is 170.
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_fact_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fact_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_doublefact(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_doublefact(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload doublefact(n)
  @param  [UInt]     n
  @return [DFloat]   result

  These routines compute the double factorial n!! = n(n-2)(n-4) \dots. 
The maximum value of n such that n!! is not
considered an overflow is given by the macro GSL_SF_DOUBLEFACT_NMAX
and is 297.
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_doublefact(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_doublefact, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_doublefact_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_doublefact_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload doublefact_e(n)
  
  @param [Numo::UInt] n
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the double factorial n!! = n(n-2)(n-4) \dots. 
The maximum value of n such that n!! is not
considered an overflow is given by the macro GSL_SF_DOUBLEFACT_NMAX
and is 297.
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_doublefact_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_doublefact_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_lnfact(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_lnfact(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lnfact(n)
  @param  [UInt]     n
  @return [DFloat]   result

  These routines compute the logarithm of the factorial of n,
\log(n!).  The algorithm is faster than computing
\ln(\Gamma(n+1)) via gsl_sf_lngamma for n < 170,
but defers for larger n.
exceptions: none
*/
static VALUE
sf_s_lnfact(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lnfact, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnfact_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lnfact_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnfact_e(n)
  
  @param [Numo::UInt] n
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the factorial of n,
\log(n!).  The algorithm is faster than computing
\ln(\Gamma(n+1)) via gsl_sf_lngamma for n < 170,
but defers for larger n.
exceptions: none
*/
static VALUE
sf_s_lnfact_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnfact_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_lndoublefact(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_lndoublefact(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lndoublefact(n)
  @param  [UInt]     n
  @return [DFloat]   result

  These routines compute the logarithm of the double factorial of n,
\log(n!!).
exceptions: none
*/
static VALUE
sf_s_lndoublefact(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lndoublefact, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lndoublefact_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lndoublefact_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lndoublefact_e(n)
  
  @param [Numo::UInt] n
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the double factorial of n,
\log(n!!).
exceptions: none
*/
static VALUE
sf_s_lndoublefact_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lndoublefact_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_choose(na_loop_t *const lp)
{
    
    unsigned int c0;
    unsigned int c1;
    double c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    c1 = *(unsigned int*)GET_PTR(lp,1); //m
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_choose(c0,c1);
    
    *(double*)GET_PTR(lp,2) = c2; //return
}

/*
  @overload choose(n,m)
  
  @param [Numo::UInt] n
  @param [Numo::UInt] m
  @return [Numo::DFloat]  return

  These routines compute the combinatorial factor n choose m
= n!/(m!(n-m)!)
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_choose(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cUI,0},{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_choose,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_choose_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    unsigned int c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    c1 = *(unsigned int*)GET_PTR(lp,1); //m
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_choose_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload choose_e(n,m)
  
  @param [Numo::UInt] n
  @param [Numo::UInt] m
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the combinatorial factor n choose m
= n!/(m!(n-m)!)
exceptions: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_choose_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cUI,0},{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_choose_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnchoose(na_loop_t *const lp)
{
    
    unsigned int c0;
    unsigned int c1;
    double c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    c1 = *(unsigned int*)GET_PTR(lp,1); //m
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lnchoose(c0,c1);
    
    *(double*)GET_PTR(lp,2) = c2; //return
}

/*
  @overload lnchoose(n,m)
  
  @param [Numo::UInt] n
  @param [Numo::UInt] m
  @return [Numo::DFloat]  return

  These routines compute the logarithm of n choose m.  This is
equivalent to the sum \log(n!) - \log(m!) - \log((n-m)!).
exceptions: GSL_EDOM 
*/
static VALUE
sf_s_lnchoose(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cUI,0},{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lnchoose,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnchoose_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    unsigned int c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //n
    c1 = *(unsigned int*)GET_PTR(lp,1); //m
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_lnchoose_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnchoose_e(n,m)
  
  @param [Numo::UInt] n
  @param [Numo::UInt] m
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of n choose m.  This is
equivalent to the sum \log(n!) - \log(m!) - \log((n-m)!).
exceptions: GSL_EDOM 
*/
static VALUE
sf_s_lnchoose_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cUI,0},{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnchoose_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_taylorcoeff(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_taylorcoeff(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload taylorcoeff(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the Taylor coefficient x^n / n! for 
$x \ge 0$
x >= 0, 
$n \ge 0$
n >= 0.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_taylorcoeff(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_taylorcoeff, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_taylorcoeff_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_taylorcoeff_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload taylorcoeff_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Taylor coefficient x^n / n! for 
$x \ge 0$
x >= 0, 
$n \ge 0$
n >= 0.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_taylorcoeff_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_taylorcoeff_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_poch(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_poch(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload poch(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Pochhammer symbol (a)_x = \Gamma(a +
x)/\Gamma(a).  The Pochhammer symbol is also known as the Apell symbol and
sometimes written as (a,x).  When a and a+x 
are negative integers or zero, the limiting value of the ratio is returned. 
exceptions:  GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_poch(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_poch, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_poch_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_poch_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload poch_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Pochhammer symbol (a)_x = \Gamma(a +
x)/\Gamma(a).  The Pochhammer symbol is also known as the Apell symbol and
sometimes written as (a,x).  When a and a+x 
are negative integers or zero, the limiting value of the ratio is returned. 
exceptions:  GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_poch_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_poch_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_lnpoch(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_lnpoch(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload lnpoch(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of the Pochhammer symbol,
\log((a)_x) = \log(\Gamma(a + x)/\Gamma(a)).
exceptions:  GSL_EDOM
*/
static VALUE
sf_s_lnpoch(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lnpoch, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnpoch_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_lnpoch_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnpoch_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the Pochhammer symbol,
\log((a)_x) = \log(\Gamma(a + x)/\Gamma(a)).
exceptions:  GSL_EDOM
*/
static VALUE
sf_s_lnpoch_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnpoch_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnpoch_sgn_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    double c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_lnpoch_sgn_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(double*)GET_PTR(lp,4) = c3; //sgn
    *(int*)GET_PTR(lp,5) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnpoch_sgn_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, sgn, return]

  These routines compute the sign of the Pochhammer symbol and the
logarithm of its magnitude.  The computed parameters are result =
\log(|(a)_x|) with a corresponding error term,  
and sgn = \sgn((a)_x) where (a)_x =
\Gamma(a + x)/\Gamma(a).
exceptions:  GSL_EDOM
*/
static VALUE
sf_s_lnpoch_sgn_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnpoch_sgn_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_pochrel(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_pochrel(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload pochrel(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the relative Pochhammer symbol ((a)_x -
1)/x where (a)_x = \Gamma(a + x)/\Gamma(a).
exceptions:  GSL_EDOM
*/
static VALUE
sf_s_pochrel(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_pochrel, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_pochrel_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_pochrel_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload pochrel_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the relative Pochhammer symbol ((a)_x -
1)/x where (a)_x = \Gamma(a + x)/\Gamma(a).
exceptions:  GSL_EDOM
*/
static VALUE
sf_s_pochrel_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_pochrel_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gamma_inc(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gamma_inc(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gamma_inc(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions compute the unnormalized incomplete Gamma Function
$\Gamma(a,x) = \int_x^\infty dt\, t^{(a-1)} \exp(-t)$
\Gamma(a,x) = \int_x^\infty dt t^[a-1] \exp(-t)
for a real and $x \ge 0$
x >= 0.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gamma_inc_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gamma_inc_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gamma_inc_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions compute the unnormalized incomplete Gamma Function
$\Gamma(a,x) = \int_x^\infty dt\, t^{(a-1)} \exp(-t)$
\Gamma(a,x) = \int_x^\infty dt t^[a-1] \exp(-t)
for a real and $x \ge 0$
x >= 0.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gamma_inc_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gamma_inc_Q(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gamma_inc_Q(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the normalized incomplete Gamma Function
$Q(a,x) = 1/\Gamma(a) \int_x^\infty dt\, t^{(a-1)} \exp(-t)$
Q(a,x) = 1/\Gamma(a) \int_x^\infty dt t^[a-1] \exp(-t)
for a > 0, $x \ge 0$
x >= 0.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc_Q(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc_Q, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gamma_inc_Q_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gamma_inc_Q_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gamma_inc_Q_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the normalized incomplete Gamma Function
$Q(a,x) = 1/\Gamma(a) \int_x^\infty dt\, t^{(a-1)} \exp(-t)$
Q(a,x) = 1/\Gamma(a) \int_x^\infty dt t^[a-1] \exp(-t)
for a > 0, $x \ge 0$
x >= 0.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc_Q_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc_Q_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gamma_inc_P(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gamma_inc_P(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gamma_inc_P(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complementary normalized incomplete Gamma Function
$P(a,x) = 1 - Q(a,x) = 1/\Gamma(a) \int_0^x dt\, t^{(a-1)} \exp(-t)$
P(a,x) = 1 - Q(a,x) = 1/\Gamma(a) \int_0^x dt t^[a-1] \exp(-t)
for a > 0, $x \ge 0$
x >= 0. 

Note that Abramowitz & Stegun call P(a,x) the incomplete gamma
function (section 6.5).
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc_P(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc_P, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gamma_inc_P_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gamma_inc_P_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gamma_inc_P_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complementary normalized incomplete Gamma Function
$P(a,x) = 1 - Q(a,x) = 1/\Gamma(a) \int_0^x dt\, t^{(a-1)} \exp(-t)$
P(a,x) = 1 - Q(a,x) = 1/\Gamma(a) \int_0^x dt t^[a-1] \exp(-t)
for a > 0, $x \ge 0$
x >= 0. 

Note that Abramowitz & Stegun call P(a,x) the incomplete gamma
function (section 6.5).
exceptions: GSL_EDOM
*/
static VALUE
sf_s_gamma_inc_P_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gamma_inc_P_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_beta(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_beta(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload beta(a, b)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @return [DFloat]   result

  These routines compute the Beta Function, B(a,b) =
\Gamma(a)\Gamma(b)/\Gamma(a+b) subject to a and b not
being negative integers.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_beta(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_beta, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_beta_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_beta_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload beta_e(a,b)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Beta Function, B(a,b) =
\Gamma(a)\Gamma(b)/\Gamma(a+b) subject to a and b not
being negative integers.
exceptions: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_beta_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_beta_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_lnbeta(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_lnbeta(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload lnbeta(a, b)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @return [DFloat]   result

  These routines compute the logarithm of the Beta Function, \log(B(a,b))
subject to a and b not
being negative integers.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_lnbeta(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lnbeta, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lnbeta_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_lnbeta_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lnbeta_e(a,b)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the Beta Function, \log(B(a,b))
subject to a and b not
being negative integers.
exceptions: GSL_EDOM
*/
static VALUE
sf_s_lnbeta_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lnbeta_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x3.c"
static void
iter_sf_s_beta_inc(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3, *p4;
    ssize_t  s1, s2, s3, s4;
    double   x1, x2, x3, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    INIT_PTR(lp, 3, p4, s4);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x1);
        GET_DATA_STRIDE(p2,s2,double,x2);
        GET_DATA_STRIDE(p3,s3,double,x3);
        y = gsl_sf_beta_inc(x1,x2,x3);
        SET_DATA_STRIDE(p4,s4,double,y);
    }
}

/*
  @overload beta_inc(a, b, x)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the normalized incomplete Beta function
I_x(a,b)=B_x(a,b)/B(a,b) where $B_x(a,b) = \int_0^x t^{a-1} (1-t)^{b-1} dt$
B_x(a,b) = \int_0^x t^[a-1] (1-t)^[b-1] dt
for $0 \le x \le 1$
0 <= x <= 1.   For a > 0, b > 0 the value is computed using
a continued fraction expansion.  For all other values it is computed using 
the relation $I_x(a,b,x) = (1/a) x^a {}_2F_1(a,1-b,a+1,x)/B(a,b)$
I_x(a,b,x) = (1/a) x^a 2F1(a,1-b,a+1,x)/B(a,b).
*/
static VALUE
sf_s_beta_inc(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_beta_inc, STRIDE_LOOP|NDF_EXTRACT, 3,1, ain,aout};

    return na_ndloop(&ndf, 3, v0, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_beta_inc_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_beta_inc_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,3) = c3.val; *(double*)GET_PTR(lp,4) = c3.err; //result
    *(int*)GET_PTR(lp,5) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload beta_inc_e(a,b,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the normalized incomplete Beta function
I_x(a,b)=B_x(a,b)/B(a,b) where $B_x(a,b) = \int_0^x t^{a-1} (1-t)^{b-1} dt$
B_x(a,b) = \int_0^x t^[a-1] (1-t)^[b-1] dt
for $0 \le x \le 1$
0 <= x <= 1.   For a > 0, b > 0 the value is computed using
a continued fraction expansion.  For all other values it is computed using 
the relation $I_x(a,b,x) = (1/a) x^a {}_2F_1(a,1-b,a+1,x)/B(a,b)$
I_x(a,b,x) = (1/a) x^a 2F1(a,1-b,a+1,x)/B(a,b).
*/
static VALUE
sf_s_beta_inc_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_beta_inc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,3,v0,v1,v2); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_transport_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_transport_2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload transport_2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the transport function J(2,x).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_transport_2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_transport_2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_transport_2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_transport_2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload transport_2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the transport function J(2,x).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_transport_2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_transport_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_transport_3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_transport_3(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload transport_3(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the transport function J(3,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_3(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_transport_3, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_transport_3_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_transport_3_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload transport_3_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the transport function J(3,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_3_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_transport_3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_transport_4(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_transport_4(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload transport_4(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the transport function J(4,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_4(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_transport_4, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_transport_4_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_transport_4_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload transport_4_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the transport function J(4,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_4_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_transport_4_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_transport_5(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_transport_5(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload transport_5(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the transport function J(5,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_5(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_transport_5, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_transport_5_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_transport_5_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload transport_5_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the transport function J(5,x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_transport_5_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_transport_5_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_ellint_Kcomp(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_ellint_Kcomp(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ellint_Kcomp(k[,mode])
  @param  [DFloat]   k
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the complete elliptic integral K(k) to
the accuracy specified by the mode variable mode.  
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Kcomp(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Kcomp, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_Kcomp_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //k
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_Kcomp_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_Kcomp_e(k,[mode])
  
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete elliptic integral K(k) to
the accuracy specified by the mode variable mode.  
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Kcomp_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Kcomp_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_ellint_Ecomp(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_ellint_Ecomp(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload ellint_Ecomp(k[,mode])
  @param  [DFloat]   k
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the complete elliptic integral E(k) to the
accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Ecomp(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Ecomp, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_Ecomp_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //k
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_Ecomp_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_Ecomp_e(k,[mode])
  
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete elliptic integral E(k) to the
accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Ecomp_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Ecomp_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_Pcomp(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //k
    c1 = *(double*)GET_PTR(lp,1); //n
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_Pcomp(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload ellint_Pcomp(k,n,[mode])
  
  @param [Numo::DFloat] k
  @param [Numo::DFloat] n
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the complete elliptic integral \Pi(k,n) to the
accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameters m = k^2 and \sin^2(\alpha) = k^2, with the
change of sign n \to -n.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Pcomp(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Pcomp,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_Pcomp_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //k
    c1 = *(double*)GET_PTR(lp,1); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_Pcomp_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_Pcomp_e(k,n,[mode])
  
  @param [Numo::DFloat] k
  @param [Numo::DFloat] n
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete elliptic integral \Pi(k,n) to the
accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameters m = k^2 and \sin^2(\alpha) = k^2, with the
change of sign n \to -n.
Exceptional Return Values:  GSL_EDOM
*/
static VALUE
sf_s_ellint_Pcomp_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_Pcomp_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_F(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_F(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload ellint_F(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral F(\phi,k)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_F(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_F,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_F_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_F_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_F_e(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral F(\phi,k)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_F_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_F_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_E(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_E(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload ellint_E(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral E(\phi,k)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_E(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_E,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_E_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_E_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_E_e(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral E(\phi,k)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameter m = k^2.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_E_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_E_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_P(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    double c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    c2 = *(double*)GET_PTR(lp,2); //n
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_P(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,3) = c4; //return
}

/*
  @overload ellint_P(phi,k,n,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Numo::DFloat] n
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral \Pi(\phi,k,n)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameters m = k^2 and \sin^2(\alpha) = k^2, with the
change of sign n \to -n.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_P(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_P,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,1,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_P_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    gsl_sf_result c4;
    int c5;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    c2 = *(double*)GET_PTR(lp,2); //n
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_ellint_P_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,3) = c4.val; *(double*)GET_PTR(lp,4) = c4.err; //result
    *(int*)GET_PTR(lp,5) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_P_e(phi,k,n,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Numo::DFloat] n
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral \Pi(\phi,k,n)
to the accuracy specified by the mode variable mode.
Note that Abramowitz & Stegun define this function in terms of the
parameters m = k^2 and \sin^2(\alpha) = k^2, with the
change of sign n \to -n.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_P_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_P_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_D(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_D(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload ellint_D(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These functions compute the incomplete elliptic integral
D(\phi,k) which is defined through the Carlson form RD(x,y,z)
by the following relation, 

D(\phi,k) = (1/3)(\sin(\phi))^3 RD (1-\sin^2(\phi), 1-k^2 \sin^2(\phi), 1).

Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_D(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_D,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_D_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //phi
    c1 = *(double*)GET_PTR(lp,1); //k
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_D_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_D_e(phi,k,[mode])
  
  @param [Numo::DFloat] phi
  @param [Numo::DFloat] k
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions compute the incomplete elliptic integral
D(\phi,k) which is defined through the Carlson form RD(x,y,z)
by the following relation, 

D(\phi,k) = (1/3)(\sin(\phi))^3 RD (1-\sin^2(\phi), 1-k^2 \sin^2(\phi), 1).

Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_D_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_D_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RC(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_ellint_RC(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload ellint_RC(x,y,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral RC(x,y)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RC(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RC,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RC_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_mode_t c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c2 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_RC_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_RC_e(x,y,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral RC(x,y)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RC_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RC_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    if (argc==2) {
        c2 = GSL_MODE_DEFAULT;
    } else if (argc==3) {
        c2 = NUM2INT(v[2]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 2 or 3",argc);
    }
    opt = &c2; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v[0],v[1]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RD(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    double c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_RD(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,3) = c4; //return
}

/*
  @overload ellint_RD(x,y,z,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral RD(x,y,z)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RD(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RD,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,1,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RD_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    gsl_sf_result c4;
    int c5;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_ellint_RD_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,3) = c4.val; *(double*)GET_PTR(lp,4) = c4.err; //result
    *(int*)GET_PTR(lp,5) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_RD_e(x,y,z,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral RD(x,y,z)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RD_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RD_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RF(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    double c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_ellint_RF(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,3) = c4; //return
}

/*
  @overload ellint_RF(x,y,z,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral RF(x,y,z)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RF(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RF,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,1,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RF_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_mode_t c3;
    gsl_sf_result c4;
    int c5;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_ellint_RF_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,3) = c4.val; *(double*)GET_PTR(lp,4) = c4.err; //result
    *(int*)GET_PTR(lp,5) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_RF_e(x,y,z,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral RF(x,y,z)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RF_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RF_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    void *opt;
    if (argc==3) {
        c3 = GSL_MODE_DEFAULT;
    } else if (argc==4) {
        c3 = NUM2INT(v[3]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 3 or 4",argc);
    }
    opt = &c3; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v[0],v[1],v[2]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RJ(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_mode_t c4;
    double c5;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c4 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    c3 = *(double*)GET_PTR(lp,3); //p
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_ellint_RJ(c0,c1,c2,c3,c4);
    
    *(double*)GET_PTR(lp,4) = c5; //return
}

/*
  @overload ellint_RJ(x,y,z,p,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Numo::DFloat] p
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [Numo::DFloat]  return

  These routines compute the incomplete elliptic integral RJ(x,y,z,p)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RJ(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c4;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RJ,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,1,ain,aout};
    
    void *opt;
    if (argc==4) {
        c4 = GSL_MODE_DEFAULT;
    } else if (argc==5) {
        c4 = NUM2INT(v[4]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 4 or 5",argc);
    }
    opt = &c4; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,4,v[0],v[1],v[2],v[3]); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_ellint_RJ_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_mode_t c4;
    gsl_sf_result c5;
    int c6;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c4 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    c2 = *(double*)GET_PTR(lp,2); //z
    c3 = *(double*)GET_PTR(lp,3); //p
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_ellint_RJ_e(c0,c1,c2,c3,c4,&c5);
    
    *(double*)GET_PTR(lp,4) = c5.val; *(double*)GET_PTR(lp,5) = c5.err; //result
    *(int*)GET_PTR(lp,6) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload ellint_RJ_e(x,y,z,p,[mode])
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Numo::DFloat] z
  @param [Numo::DFloat] p
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete elliptic integral RJ(x,y,z,p)
to the accuracy specified by the mode variable mode.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_ellint_RJ_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c4;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_ellint_RJ_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    void *opt;
    if (argc==4) {
        c4 = GSL_MODE_DEFAULT;
    } else if (argc==5) {
        c4 = NUM2INT(v[4]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 4 or 5",argc);
    }
    opt = &c4; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,4,v[0],v[1],v[2],v[3]); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_expint_E1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expint_E1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expint_E1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the exponential integral E_1(x),

E_1(x) := \Re \int_1^\infty dt \exp(-xt)/t.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_E1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expint_E1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expint_E1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_expint_E1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expint_E1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the exponential integral E_1(x),

E_1(x) := \Re \int_1^\infty dt \exp(-xt)/t.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_E1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expint_E1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_expint_E2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expint_E2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expint_E2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the second-order exponential integral E_2(x),

E_2(x) := \Re \int_1^\infty dt \exp(-xt)/t^2.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_E2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expint_E2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expint_E2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_expint_E2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expint_E2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the second-order exponential integral E_2(x),

E_2(x) := \Re \int_1^\infty dt \exp(-xt)/t^2.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_E2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expint_E2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_expint_En(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expint_En(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expint_En(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the exponential integral E_n(x) of order n, 

E_n(x) := \Re \int_1^\infty dt \exp(-xt)/t^n.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_En(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expint_En, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expint_En_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_expint_En_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expint_En_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the exponential integral E_n(x) of order n, 

E_n(x) := \Re \int_1^\infty dt \exp(-xt)/t^n.

Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_En_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expint_En_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_expint_Ei(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expint_Ei(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expint_Ei(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the exponential integral $\hbox{Ei}(x)$
Ei(x),

Ei(x) := - PV(\int_[-x]^\infty dt \exp(-t)/t)

where PV denotes the principal value of the integral.
Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_Ei(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expint_Ei, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expint_Ei_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_expint_Ei_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expint_Ei_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the exponential integral $\hbox{Ei}(x)$
Ei(x),

Ei(x) := - PV(\int_[-x]^\infty dt \exp(-t)/t)

where PV denotes the principal value of the integral.
Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_expint_Ei_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expint_Ei_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_Shi(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_Shi(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload Shi(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the integral $\hbox{Shi}(x) = \int_0^x dt \sinh(t)/t$
Shi(x) = \int_0^x dt \sinh(t)/t.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_Shi(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_Shi, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_Shi_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_Shi_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload Shi_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the integral $\hbox{Shi}(x) = \int_0^x dt \sinh(t)/t$
Shi(x) = \int_0^x dt \sinh(t)/t.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_Shi_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_Shi_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_Chi(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_Chi(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload Chi(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the integral $\hbox{Chi}(x) := \Re[ \gamma_E + \log(x) + \int_0^x dt (\cosh(t)-1)/t]$
 Chi(x) := \Re[ \gamma_E + \log(x) + \int_0^x dt (\cosh(t)-1)/t] , 
where \gamma_E is the Euler constant (available as the macro M_EULER).
Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_Chi(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_Chi, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_Chi_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_Chi_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload Chi_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the integral $\hbox{Chi}(x) := \Re[ \gamma_E + \log(x) + \int_0^x dt (\cosh(t)-1)/t]$
 Chi(x) := \Re[ \gamma_E + \log(x) + \int_0^x dt (\cosh(t)-1)/t] , 
where \gamma_E is the Euler constant (available as the macro M_EULER).
Domain: x != 0.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_Chi_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_Chi_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_expint_3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expint_3(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expint_3(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the third-order exponential integral ${\rm Ei}_3(x) = \int_0^xdt \exp(-t^3)$
Ei_3(x) = \int_0^xdt \exp(-t^3) for $x \ge 0$
x >= 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_expint_3(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expint_3, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expint_3_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_expint_3_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expint_3_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the third-order exponential integral ${\rm Ei}_3(x) = \int_0^xdt \exp(-t^3)$
Ei_3(x) = \int_0^xdt \exp(-t^3) for $x \ge 0$
x >= 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_expint_3_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expint_3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_Si(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_Si(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload Si(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Sine integral $\hbox{Si}(x) = \int_0^x dt \sin(t)/t$
Si(x) = \int_0^x dt \sin(t)/t.
Exceptional Return Values: none
*/
static VALUE
sf_s_Si(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_Si, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_Si_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_Si_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload Si_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Sine integral $\hbox{Si}(x) = \int_0^x dt \sin(t)/t$
Si(x) = \int_0^x dt \sin(t)/t.
Exceptional Return Values: none
*/
static VALUE
sf_s_Si_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_Si_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_Ci(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_Ci(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload Ci(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Cosine integral $\hbox{Ci}(x) = -\int_x^\infty dt \cos(t)/t$
Ci(x) = -\int_x^\infty dt \cos(t)/t for x > 0.  
Domain: x > 0.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_Ci(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_Ci, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_Ci_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_Ci_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload Ci_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Cosine integral $\hbox{Ci}(x) = -\int_x^\infty dt \cos(t)/t$
Ci(x) = -\int_x^\infty dt \cos(t)/t for x > 0.  
Domain: x > 0.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_Ci_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_Ci_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_atanint(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_atanint(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload atanint(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Arctangent integral, which is defined as $\hbox{AtanInt}(x) = \int_0^x dt \arctan(t)/t$
AtanInt(x) = \int_0^x dt \arctan(t)/t.
Domain: 
Exceptional Return Values: 
*/
static VALUE
sf_s_atanint(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_atanint, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_atanint_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_atanint_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload atanint_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Arctangent integral, which is defined as $\hbox{AtanInt}(x) = \int_0^x dt \arctan(t)/t$
AtanInt(x) = \int_0^x dt \arctan(t)/t.
Domain: 
Exceptional Return Values: 
*/
static VALUE
sf_s_atanint_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_atanint_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_laguerre_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_laguerre_1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload laguerre_1(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_laguerre_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_laguerre_2(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload laguerre_2(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_2(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_2, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_laguerre_3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_laguerre_3(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload laguerre_3(a, x)
  @param  [DFloat]   a
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_3(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_3, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_laguerre_1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_laguerre_1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload laguerre_1_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_laguerre_2_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_laguerre_2_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload laguerre_2_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_2_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_laguerre_3_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_laguerre_3_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload laguerre_3_e(a,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines evaluate the generalized Laguerre polynomials
L^a_1(x), L^a_2(x), L^a_3(x) using explicit
representations.
Exceptional Return Values: none
*/
static VALUE
sf_s_laguerre_3_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_laguerre_n(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //a
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_laguerre_n(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload laguerre_n(n,a,x)
  
  @param [Integer] n
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines evaluate the generalized Laguerre polynomials
L^a_n(x) for a > -1, 
$n \ge 0$
n >= 0.

Domain: a > -1.0, n >= 0
Evaluate generalized Laguerre polynomials.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_laguerre_n(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_n,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_laguerre_n_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //a
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_laguerre_n_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload laguerre_n_e(n,a,x)
  
  @param [Integer] n
  @param [Numo::DFloat] a
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines evaluate the generalized Laguerre polynomials
L^a_n(x) for a > -1, 
$n \ge 0$
n >= 0.

Domain: a > -1.0, n >= 0
Evaluate generalized Laguerre polynomials.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_laguerre_n_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_laguerre_n_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gegenpoly_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gegenpoly_1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gegenpoly_1(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gegenpoly_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gegenpoly_2(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gegenpoly_2(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_2(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_2, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_gegenpoly_3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_gegenpoly_3(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload gegenpoly_3(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_3(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_3, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gegenpoly_1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gegenpoly_1_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_2_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gegenpoly_2_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gegenpoly_2_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_2_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_3_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gegenpoly_3_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gegenpoly_3_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) using explicit
representations for n =1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_gegenpoly_3_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_n(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_gegenpoly_n(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload gegenpoly_n(n,lambda,x)
  
  @param [Integer] n
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These functions evaluate the Gegenbauer polynomial $C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) for a specific value of n,
lambda, x subject to \lambda > -1/2, $n \ge 0$
n >= 0.
Domain: lambda > -1/2, n >= 0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_gegenpoly_n(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_n,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_n_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_gegenpoly_n_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gegenpoly_n_e(n,lambda,x)
  
  @param [Integer] n
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Gegenbauer polynomial $C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) for a specific value of n,
lambda, x subject to \lambda > -1/2, $n \ge 0$
n >= 0.
Domain: lambda > -1/2, n >= 0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_gegenpoly_n_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_n_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_gegenpoly_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double *c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //nmax

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    c3 = (double*)GET_PTR(lp,2); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_gegenpoly_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload gegenpoly_array(nmax,lambda,x)
  
  @param [Integer] nmax
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This function computes an array of Gegenbauer polynomials
$C^{(\lambda)}_n(x)$ 
C^[(\lambda)]_n(x) for n = 0, 1, 2, \dots, nmax, subject
to \lambda > -1/2, $nmax \ge 0$
nmax >= 0.
Conditions: n = 0, 1, 2, ... nmax
Domain: lambda > -1/2, nmax >= 0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_gegenpoly_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_gegenpoly_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //nmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_elljac_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //u
    c1 = *(double*)GET_PTR(lp,1); //m
    
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_elljac_e(c0,c1,&c2,&c3,&c4);
    
    *(double*)GET_PTR(lp,2) = c2; //sn
    *(double*)GET_PTR(lp,3) = c3; //cn
    *(double*)GET_PTR(lp,4) = c4; //dn
    *(int*)GET_PTR(lp,5) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload elljac_e(u,m)
  
  @param [Numo::DFloat] u
  @param [Numo::DFloat] m
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [sn, cn, dn, return]

  This function computes the Jacobian elliptic functions sn(u|m),
cn(u|m), dn(u|m) by descending Landen
transformations.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_elljac_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_elljac_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_3j(two_ja,two_jb,two_jc,two_ma,two_mb,two_mc)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_ma
  @param [Integer] two_mb
  @param [Integer] two_mc
  @return [Float]  return

  These routines compute the Wigner 3-j coefficient, 

(ja jb jc
 ma mb mc)

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_3j(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    double c6;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c6 = gsl_sf_coupling_3j(c0,c1,c2,c3,c4,c5);
    
    return DBL2NUM(c6);
    
#line 27 "../gen/tmpl/mod_func_scalar.c"
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_3j_e(two_ja,two_jb,two_jc,two_ma,two_mb,two_mc)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_ma
  @param [Integer] two_mb
  @param [Integer] two_mc
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the Wigner 3-j coefficient, 

(ja jb jc
 ma mb mc)

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_3j_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    gsl_sf_result c6;
    int c7;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c7 = gsl_sf_coupling_3j_e(c0,c1,c2,c3,c4,c5,&c6);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c6.val));
        rb_ary_push(va,DBL2NUM(c6.err));
        rb_ary_push(va,INT2NUM(c7));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_6j(two_ja,two_jb,two_jc,two_jd,two_je,two_jf)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_jd
  @param [Integer] two_je
  @param [Integer] two_jf
  @return [Float]  return

  These routines compute the Wigner 6-j coefficient, 

[ja jb jc
 jd je jf]

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_6j(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    double c6;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c6 = gsl_sf_coupling_6j(c0,c1,c2,c3,c4,c5);
    
    return DBL2NUM(c6);
    
#line 27 "../gen/tmpl/mod_func_scalar.c"
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_6j_e(two_ja,two_jb,two_jc,two_jd,two_je,two_jf)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_jd
  @param [Integer] two_je
  @param [Integer] two_jf
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the Wigner 6-j coefficient, 

[ja jb jc
 jd je jf]

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_6j_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    gsl_sf_result c6;
    int c7;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c7 = gsl_sf_coupling_6j_e(c0,c1,c2,c3,c4,c5,&c6);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c6.val));
        rb_ary_push(va,DBL2NUM(c6.err));
        rb_ary_push(va,INT2NUM(c7));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_9j(two_ja,two_jb,two_jc,two_jd,two_je,two_jf,two_jg,two_jh,two_ji)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_jd
  @param [Integer] two_je
  @param [Integer] two_jf
  @param [Integer] two_jg
  @param [Integer] two_jh
  @param [Integer] two_ji
  @return [Float]  return

  These routines compute the Wigner 9-j coefficient, 

[ja jb jc
 jd je jf
 jg jh ji]

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_9j(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5,VALUE v6,VALUE v7,VALUE v8)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    int c6;
    int c7;
    int c8;
    double c9;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
    c6 = NUM2INT(v6);
    c7 = NUM2INT(v7);
    c8 = NUM2INT(v8);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c9 = gsl_sf_coupling_9j(c0,c1,c2,c3,c4,c5,c6,c7,c8);
    
    return DBL2NUM(c9);
    
#line 27 "../gen/tmpl/mod_func_scalar.c"
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload coupling_9j_e(two_ja,two_jb,two_jc,two_jd,two_je,two_jf,two_jg,two_jh,two_ji)
  
  @param [Integer] two_ja
  @param [Integer] two_jb
  @param [Integer] two_jc
  @param [Integer] two_jd
  @param [Integer] two_je
  @param [Integer] two_jf
  @param [Integer] two_jg
  @param [Integer] two_jh
  @param [Integer] two_ji
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the Wigner 9-j coefficient, 

[ja jb jc
 jd je jf
 jg jh ji]

where the arguments are given in half-integer units, ja =
two_ja/2, ma = two_ma/2, etc.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_coupling_9j_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4,VALUE v5,VALUE v6,VALUE v7,VALUE v8)
{
    
    int c0;
    int c1;
    int c2;
    int c3;
    int c4;
    int c5;
    int c6;
    int c7;
    int c8;
    gsl_sf_result c9;
    int c10;
    
    c0 = NUM2INT(v0);
    c1 = NUM2INT(v1);
    c2 = NUM2INT(v2);
    c3 = NUM2INT(v3);
    c4 = NUM2INT(v4);
    c5 = NUM2INT(v5);
    c6 = NUM2INT(v6);
    c7 = NUM2INT(v7);
    c8 = NUM2INT(v8);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c10 = gsl_sf_coupling_9j_e(c0,c1,c2,c3,c4,c5,c6,c7,c8,&c9);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c9.val));
        rb_ary_push(va,DBL2NUM(c9.err));
        rb_ary_push(va,INT2NUM(c10));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_Int.c"
static void
iter_sf_s_psi_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    int      x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,int,x);
        y = gsl_sf_psi_int(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi_int(n)
  @param  [Int]  n
  @return [DFloat]   result

  These routines compute the digamma function \psi(n) for positive
integer n.  The digamma function is also called the Psi function.
Domain: n integer, n > 0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_int(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload psi_int_e(n)
  
  @param [Integer] n
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the digamma function \psi(n) for positive
integer n.  The digamma function is also called the Psi function.
Domain: n integer, n > 0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_int_e(VALUE mod,VALUE v0)
{
    
    int c0;
    gsl_sf_result c1;
    int c2;
    
    c0 = NUM2INT(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_psi_int_e(c0,&c1);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c1.val));
        rb_ary_push(va,DBL2NUM(c1.err));
        rb_ary_push(va,INT2NUM(c2));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_psi(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_psi(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the digamma function \psi(x) for general
x, x \ne 0.
Domain: x != 0.0, -1.0, -2.0, ...
Exceptional Return Values: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_psi(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_psi_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_psi_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload psi_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the digamma function \psi(x) for general
x, x \ne 0.
Domain: x != 0.0, -1.0, -2.0, ...
Exceptional Return Values: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_psi_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_psi_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_psi_1piy(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_psi_1piy(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi_1piy(y)
  @param  [DFloat]   y
  @return [DFloat]   result

  These routines compute the real part of the digamma function on the line
1+i y, \Re[\psi(1 + i y)].
exceptions: none
Exceptional Return Values: none
*/
static VALUE
sf_s_psi_1piy(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi_1piy, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_psi_1piy_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_psi_1piy_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload psi_1piy_e(y)
  
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the real part of the digamma function on the line
1+i y, \Re[\psi(1 + i y)].
exceptions: none
Exceptional Return Values: none
*/
static VALUE
sf_s_psi_1piy_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_psi_1piy_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_Int.c"
static void
iter_sf_s_psi_1_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    int      x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,int,x);
        y = gsl_sf_psi_1_int(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi_1_int(n)
  @param  [Int]  n
  @return [DFloat]   result

  These routines compute the Trigamma function \psi'(n) for
positive integer n.
Domain: n integer, n > 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_1_int(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi_1_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload psi_1_int_e(n)
  
  @param [Integer] n
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the Trigamma function \psi'(n) for
positive integer n.
Domain: n integer, n > 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_1_int_e(VALUE mod,VALUE v0)
{
    
    int c0;
    gsl_sf_result c1;
    int c2;
    
    c0 = NUM2INT(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_psi_1_int_e(c0,&c1);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c1.val));
        rb_ary_push(va,DBL2NUM(c1.err));
        rb_ary_push(va,INT2NUM(c2));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_psi_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_psi_1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi_1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Trigamma function \psi'(x) for
general x.
Domain: x != 0.0, -1.0, -2.0, ...
Exceptional Return Values: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_psi_1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi_1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_psi_1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_psi_1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload psi_1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Trigamma function \psi'(x) for
general x.
Domain: x != 0.0, -1.0, -2.0, ...
Exceptional Return Values: GSL_EDOM, GSL_ELOSS
*/
static VALUE
sf_s_psi_1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_psi_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_psi_n(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_psi_n(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload psi_n(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the polygamma function $\psi^{(n)}(x)$
\psi^[(n)](x) for
$n \ge 0$
n >= 0, x > 0.  
Domain: n >= 0, x > 0.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_n(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_psi_n, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_psi_n_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_psi_n_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload psi_n_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the polygamma function $\psi^{(n)}(x)$
\psi^[(n)](x) for
$n \ge 0$
n >= 0, x > 0.  
Domain: n >= 0, x > 0.0
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_psi_n_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_psi_n_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the first-order Debye function 
D_1(x) = (1/x) \int_0^x dt (t/(e^t - 1)).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_debye_1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the first-order Debye function 
D_1(x) = (1/x) \int_0^x dt (t/(e^t - 1)).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_debye_1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the second-order Debye function 
D_2(x) = (2/x^2) \int_0^x dt (t^2/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the second-order Debye function 
D_2(x) = (2/x^2) \int_0^x dt (t^2/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_3(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_3(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the third-order Debye function 
D_3(x) = (3/x^3) \int_0^x dt (t^3/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_3(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_3, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_3_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_3_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_3_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the third-order Debye function 
D_3(x) = (3/x^3) \int_0^x dt (t^3/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_3_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_4(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_4(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_4(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the fourth-order Debye function 
D_4(x) = (4/x^4) \int_0^x dt (t^4/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_4(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_4, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_4_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_4_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_4_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the fourth-order Debye function 
D_4(x) = (4/x^4) \int_0^x dt (t^4/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_4_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_4_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_5(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_5(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_5(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the fifth-order Debye function 
D_5(x) = (5/x^5) \int_0^x dt (t^5/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_5(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_5, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_5_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_5_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_5_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the fifth-order Debye function 
D_5(x) = (5/x^5) \int_0^x dt (t^5/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_5_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_5_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_debye_6(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_debye_6(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload debye_6(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the sixth-order Debye function 
D_6(x) = (6/x^6) \int_0^x dt (t^6/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_6(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_debye_6, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_debye_6_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_debye_6_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload debye_6_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the sixth-order Debye function 
D_6(x) = (6/x^6) \int_0^x dt (t^6/(e^t - 1)).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_debye_6_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_debye_6_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_erf(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_erf(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload erf(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the error function $\erf(x)$
erf(x), where
$\erf(x) = (2/\sqrt{\pi}) \int_0^x dt \exp(-t^2)$
erf(x) = (2/\sqrt(\pi)) \int_0^x dt \exp(-t^2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erf(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_erf, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_erf_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_erf_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload erf_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the error function $\erf(x)$
erf(x), where
$\erf(x) = (2/\sqrt{\pi}) \int_0^x dt \exp(-t^2)$
erf(x) = (2/\sqrt(\pi)) \int_0^x dt \exp(-t^2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erf_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_erf_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_erfc(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_erfc(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload erfc(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complementary error function 
$\erfc(x) = 1 - \erf(x) = (2/\sqrt{\pi}) \int_x^\infty \exp(-t^2)$
erfc(x) = 1 - erf(x) = (2/\sqrt(\pi)) \int_x^\infty \exp(-t^2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erfc(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_erfc, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_erfc_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_erfc_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload erfc_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complementary error function 
$\erfc(x) = 1 - \erf(x) = (2/\sqrt{\pi}) \int_x^\infty \exp(-t^2)$
erfc(x) = 1 - erf(x) = (2/\sqrt(\pi)) \int_x^\infty \exp(-t^2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erfc_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_erfc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_log_erfc(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_log_erfc(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload log_erfc(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of the complementary error function
\log(\erfc(x)).
Exceptional Return Values: none
*/
static VALUE
sf_s_log_erfc(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_log_erfc, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_log_erfc_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_log_erfc_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload log_erfc_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the complementary error function
\log(\erfc(x)).
Exceptional Return Values: none
*/
static VALUE
sf_s_log_erfc_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_log_erfc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_erf_Z(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_erf_Z(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload erf_Z(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Gaussian probability density function 
$Z(x) = (1/\sqrt{2\pi}) \exp(-x^2/2)$ 
Z(x) = (1/\sqrt[2\pi]) \exp(-x^2/2).  
*/
static VALUE
sf_s_erf_Z(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_erf_Z, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_erf_Z_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_erf_Z_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload erf_Z_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Gaussian probability density function 
$Z(x) = (1/\sqrt{2\pi}) \exp(-x^2/2)$ 
Z(x) = (1/\sqrt[2\pi]) \exp(-x^2/2).  
*/
static VALUE
sf_s_erf_Z_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_erf_Z_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_erf_Q(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_erf_Q(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload erf_Q(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the upper tail of the Gaussian probability
function 
$Q(x) = (1/\sqrt{2\pi}) \int_x^\infty dt \exp(-t^2/2)$
Q(x) = (1/\sqrt[2\pi]) \int_x^\infty dt \exp(-t^2/2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erf_Q(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_erf_Q, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_erf_Q_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_erf_Q_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload erf_Q_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the upper tail of the Gaussian probability
function 
$Q(x) = (1/\sqrt{2\pi}) \int_x^\infty dt \exp(-t^2/2)$
Q(x) = (1/\sqrt[2\pi]) \int_x^\infty dt \exp(-t^2/2).
Exceptional Return Values: none
*/
static VALUE
sf_s_erf_Q_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_erf_Q_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_hazard(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_hazard(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload hazard(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the hazard function for the normal distribution.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_hazard(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hazard, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hazard_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_hazard_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hazard_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the hazard function for the normal distribution.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_hazard_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hazard_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_multiply_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_multiply_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload multiply_e(x,y)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This function multiplies x and y storing the product and its
associated error in result.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_multiply_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_multiply_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_multiply_err_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    c2 = *(double*)GET_PTR(lp,2); //y
    c3 = *(double*)GET_PTR(lp,3); //dy
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_multiply_err_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload multiply_err_e(x,dx,y,dy)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @param [Numo::DFloat] y
  @param [Numo::DFloat] dy
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This function multiplies x and y with associated absolute
errors dx and dy.  The product 
$xy \pm xy \sqrt{(dx/x)^2 +(dy/y)^2}$ 
xy +/- xy \sqrt((dx/x)^2 +(dy/y)^2) 
is stored in result.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_multiply_err_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_multiply_err_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_exp(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_exp(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exp(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines provide an exponential function \exp(x) using GSL
semantics and error checking.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_exp, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_exp_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines provide an exponential function \exp(x) using GSL
semantics and error checking.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_e10_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result_e10 c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_exp_e10_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; *(int*)GET_PTR(lp,3) = c1.e10; //result
    *(int*)GET_PTR(lp,4) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_e10_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This function computes the exponential \exp(x) using the
gsl_sf_result_e10 type to return a result with extended range.
This function may be useful if the value of \exp(x) would
overflow the  numeric range of double.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_e10_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_exp_mult(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_exp_mult(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload exp_mult(x, y)
  @param  [DFloat]   x
  @param  [DFloat]   y
  @return [DFloat]   result

  These routines exponentiate x and multiply by the factor y
to return the product y \exp(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_mult(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_exp_mult, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_mult_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_exp_mult_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_mult_e(x,y)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines exponentiate x and multiply by the factor y
to return the product y \exp(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_mult_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_mult_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_mult_e10_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result_e10 c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_exp_mult_e10_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; *(int*)GET_PTR(lp,4) = c2.e10; //result
    *(int*)GET_PTR(lp,5) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_mult_e10_e(x,y)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This function computes the product y \exp(x) using the
gsl_sf_result_e10 type to return a result with extended numeric
range.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_mult_e10_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_mult_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_expm1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_expm1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload expm1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the quantity \exp(x)-1 using an algorithm
that is accurate for small x.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_expm1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_expm1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_expm1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_expm1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload expm1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the quantity \exp(x)-1 using an algorithm
that is accurate for small x.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_expm1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_expm1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_exprel(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_exprel(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exprel(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the quantity (\exp(x)-1)/x using an
algorithm that is accurate for small x.  For small x the
algorithm is based on the expansion (\exp(x)-1)/x = 1 + x/2 +
x^2/(2*3) + x^3/(2*3*4) + \dots.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_exprel(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_exprel, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exprel_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_exprel_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exprel_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the quantity (\exp(x)-1)/x using an
algorithm that is accurate for small x.  For small x the
algorithm is based on the expansion (\exp(x)-1)/x = 1 + x/2 +
x^2/(2*3) + x^3/(2*3*4) + \dots.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_exprel_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exprel_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_exprel_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_exprel_2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exprel_2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the quantity 2(\exp(x)-1-x)/x^2 using an
algorithm that is accurate for small x.  For small x the
algorithm is based on the expansion 2(\exp(x)-1-x)/x^2 = 
1 + x/3 + x^2/(3*4) + x^3/(3*4*5) + \dots.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_exprel_2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_exprel_2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exprel_2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_exprel_2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exprel_2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the quantity 2(\exp(x)-1-x)/x^2 using an
algorithm that is accurate for small x.  For small x the
algorithm is based on the expansion 2(\exp(x)-1-x)/x^2 = 
1 + x/3 + x^2/(3*4) + x^3/(3*4*5) + \dots.
Exceptional Return Values:  GSL_EOVRFLW
*/
static VALUE
sf_s_exprel_2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exprel_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_exprel_n(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_exprel_n(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload exprel_n(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the N-relative exponential, which is the
n-th generalization of the functions gsl_sf_exprel and
gsl_sf_exprel_2.  The N-relative exponential is given by,

exprel_N(x) = N!/x^N (\exp(x) - \sum_[k=0]^[N-1] x^k/k!)
            = 1 + x/(N+1) + x^2/((N+1)(N+2)) + ...
            = 1F1 (1,1+N,x)
Exceptional Return Values: 
*/
static VALUE
sf_s_exprel_n(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_exprel_n, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exprel_n_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_exprel_n_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exprel_n_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the N-relative exponential, which is the
n-th generalization of the functions gsl_sf_exprel and
gsl_sf_exprel_2.  The N-relative exponential is given by,

exprel_N(x) = N!/x^N (\exp(x) - \sum_[k=0]^[N-1] x^k/k!)
            = 1 + x/(N+1) + x^2/((N+1)(N+2)) + ...
            = 1F1 (1,1+N,x)
Exceptional Return Values: 
*/
static VALUE
sf_s_exprel_n_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exprel_n_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_err_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_exp_err_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_err_e(x,dx)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This function exponentiates x with an associated absolute error
dx.
Exceptional Return Values: 
*/
static VALUE
sf_s_exp_err_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_err_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_err_e10_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result_e10 c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_exp_err_e10_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; *(int*)GET_PTR(lp,4) = c2.e10; //result
    *(int*)GET_PTR(lp,5) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_err_e10_e(x,dx)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This function exponentiates a quantity x with an associated absolute 
error dx using the gsl_sf_result_e10 type to return a result with
extended range.
Exceptional Return Values: 
*/
static VALUE
sf_s_exp_err_e10_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_err_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_mult_err_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    c2 = *(double*)GET_PTR(lp,2); //y
    c3 = *(double*)GET_PTR(lp,3); //dy
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_exp_mult_err_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_mult_err_e(x,dx,y,dy)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @param [Numo::DFloat] y
  @param [Numo::DFloat] dy
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This routine computes the product y \exp(x) for the quantities
x, y with associated absolute errors dx, dy.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_mult_err_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_mult_err_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_exp_mult_err_e10_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result_e10 c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //dx
    c2 = *(double*)GET_PTR(lp,2); //y
    c3 = *(double*)GET_PTR(lp,3); //dy
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_exp_mult_err_e10_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; *(int*)GET_PTR(lp,6) = c4.e10; //result
    *(int*)GET_PTR(lp,7) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload exp_mult_err_e10_e(x,dx,y,dy)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] dx
  @param [Numo::DFloat] y
  @param [Numo::DFloat] dy
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This routine computes the product y \exp(x) for the quantities
x, y with associated absolute errors dx, dy using the
gsl_sf_result_e10 type to return a result with extended range.
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_exp_mult_err_e10_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_exp_mult_err_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_dawson(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_dawson(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload dawson(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the value of Dawson's integral for x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_dawson(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_dawson, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_dawson_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_dawson_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload dawson_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the value of Dawson's integral for x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_dawson_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_dawson_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_Int.c"
static void
iter_sf_s_pow_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, z;
    int      y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,int,y);
        z = gsl_sf_pow_int(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload pow_int(x, n)
  @param  [DFloat]   x
  @param  [DFloat]   n
  @return [DFloat]   result

  These routines compute the power x^n for integer n.  The
power is computed using the minimum number of multiplications. For
example, x^8 is computed as ((x^2)^2)^2, requiring only 3
multiplications.  For reasons of efficiency, these functions do not
check for overflow or underflow conditions.
*/
static VALUE
sf_s_pow_int(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_pow_int, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_pow_int_e(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //n

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_pow_int_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload pow_int_e(x,n)
  
  @param [Numo::DFloat] x
  @param [Integer] n
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the power x^n for integer n.  The
power is computed using the minimum number of multiplications. For
example, x^8 is computed as ((x^2)^2)^2, requiring only 3
multiplications.  For reasons of efficiency, these functions do not
check for overflow or underflow conditions.
*/
static VALUE
sf_s_pow_int_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_pow_int_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_synchrotron_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_synchrotron_1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload synchrotron_1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the first synchrotron function 
$x \int_x^\infty dt K_{5/3}(t)$
x \int_x^\infty dt K_[5/3](t) for $x \ge 0$
x >= 0.
Domain: x >= 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_synchrotron_1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_synchrotron_1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_synchrotron_1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_synchrotron_1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload synchrotron_1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the first synchrotron function 
$x \int_x^\infty dt K_{5/3}(t)$
x \int_x^\infty dt K_[5/3](t) for $x \ge 0$
x >= 0.
Domain: x >= 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_synchrotron_1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_synchrotron_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_synchrotron_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_synchrotron_2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload synchrotron_2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the second synchrotron function 
$x K_{2/3}(x)$
x K_[2/3](x) for $x \ge 0$
x >= 0.
Domain: x >= 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_synchrotron_2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_synchrotron_2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_synchrotron_2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_synchrotron_2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload synchrotron_2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the second synchrotron function 
$x K_{2/3}(x)$
x K_[2/3](x) for $x \ge 0$
x >= 0.
Domain: x >= 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_synchrotron_2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_synchrotron_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_Int_f_int_DFloat.c"
static void
iter_sf_s_mathieu_a(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x;
    int      y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_mathieu_a(c0, x);
        SET_DATA_STRIDE(p2,s2,int,y);
    }
}

/*
  @overload mathieu_a(n, q)
  @param  [Integer]   n parameter
  @param  [DFloat]    q
  @return [Int]       result

  These routines compute the characteristic values a_n(q),
b_n(q) of the Mathieu functions ce_n(q,x) and
se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_a(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_a, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_a_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //q
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_mathieu_a_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_a_e(n,q)
  
  @param [Integer] n
  @param [Numo::DFloat] q
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the characteristic values a_n(q),
b_n(q) of the Mathieu functions ce_n(q,x) and
se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_a_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_a_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_Int_f_int_DFloat.c"
static void
iter_sf_s_mathieu_b(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x;
    int      y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_mathieu_b(c0, x);
        SET_DATA_STRIDE(p2,s2,int,y);
    }
}

/*
  @overload mathieu_b(n, q)
  @param  [Integer]   n parameter
  @param  [DFloat]    q
  @return [Int]       result

  These routines compute the characteristic values a_n(q),
b_n(q) of the Mathieu functions ce_n(q,x) and
se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_b(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_b, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_b_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //q
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_mathieu_b_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_b_e(n,q)
  
  @param [Integer] n
  @param [Numo::DFloat] q
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the characteristic values a_n(q),
b_n(q) of the Mathieu functions ce_n(q,x) and
se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_b_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_b_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_Int_f_int_DFloat_x2.c"
static void
iter_sf_s_mathieu_ce(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y;
    int      z;
    int     *opts;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    opts = (int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_mathieu_ce(opts[0],x,y);
        SET_DATA_STRIDE(p3,s3,int,z);
    }
}

/*
  @overload mathieu_ce(n,q,x)
  @param  [Integer]  n parameter
  @param  [DFloat]   q
  @param  [DFloat]   x
  @return [Int]      result

  These routines compute the angular Mathieu functions ce_n(q,x)
and se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_ce(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_ce, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};
    int opts[1];

    opts[0] = NUM2INT(v0);

    return na_ndloop3(&ndf, opts, 2, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_ce_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //q
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_mathieu_ce_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_ce_e(n,q,x)
  
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the angular Mathieu functions ce_n(q,x)
and se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_ce_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_ce_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/m_Int_f_int_DFloat_x2.c"
static void
iter_sf_s_mathieu_se(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y;
    int      z;
    int     *opts;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    opts = (int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_mathieu_se(opts[0],x,y);
        SET_DATA_STRIDE(p3,s3,int,z);
    }
}

/*
  @overload mathieu_se(n,q,x)
  @param  [Integer]  n parameter
  @param  [DFloat]   q
  @param  [DFloat]   x
  @return [Int]      result

  These routines compute the angular Mathieu functions ce_n(q,x)
and se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_se(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_se, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};
    int opts[1];

    opts[0] = NUM2INT(v0);

    return na_ndloop3(&ndf, opts, 2, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_se_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //q
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_mathieu_se_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_se_e(n,q,x)
  
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the angular Mathieu functions ce_n(q,x)
and se_n(q,x), respectively.
*/
static VALUE
sf_s_mathieu_se_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_se_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_Mc(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //j
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_mathieu_Mc(c0,c1,c2,c3);
    
    *(int*)GET_PTR(lp,2) = c4; //return
}

/*
  @overload mathieu_Mc(j,n,q,x)
  
  @param [Integer] j
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [Numo::Int]  return

  These routines compute the radial j-th kind Mathieu functions
$Mc_n^{(j)}(q,x)$
Mc_n^[(j)](q,x) and 
$Ms_n^{(j)}(q,x)$
Ms_n^[(j)](q,x) of order n.

The allowed values of j are 1 and 2.
The functions for j = 3,4 can be computed as 
$M_n^{(3)} = M_n^{(1)} + iM_n^{(2)}$
M_n^[(3)] = M_n^[(1)] + iM_n^[(2)] and 
$M_n^{(4)} = M_n^{(1)} - iM_n^{(2)}$
M_n^[(4)] = M_n^[(1)] - iM_n^[(2)],
where 
$M_n^{(j)} = Mc_n^{(j)}$
M_n^[(j)] = Mc_n^[(j)] or 
$Ms_n^{(j)}$
Ms_n^[(j)].
*/
static VALUE
sf_s_mathieu_Mc(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_Mc,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //j
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_Mc_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //j
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_mathieu_Mc_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,2) = c4.val; *(double*)GET_PTR(lp,3) = c4.err; //result
    *(int*)GET_PTR(lp,4) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_Mc_e(j,n,q,x)
  
  @param [Integer] j
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the radial j-th kind Mathieu functions
$Mc_n^{(j)}(q,x)$
Mc_n^[(j)](q,x) and 
$Ms_n^{(j)}(q,x)$
Ms_n^[(j)](q,x) of order n.

The allowed values of j are 1 and 2.
The functions for j = 3,4 can be computed as 
$M_n^{(3)} = M_n^{(1)} + iM_n^{(2)}$
M_n^[(3)] = M_n^[(1)] + iM_n^[(2)] and 
$M_n^{(4)} = M_n^{(1)} - iM_n^{(2)}$
M_n^[(4)] = M_n^[(1)] - iM_n^[(2)],
where 
$M_n^{(j)} = Mc_n^{(j)}$
M_n^[(j)] = Mc_n^[(j)] or 
$Ms_n^{(j)}$
Ms_n^[(j)].
*/
static VALUE
sf_s_mathieu_Mc_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_Mc_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //j
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_Ms(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //j
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_mathieu_Ms(c0,c1,c2,c3);
    
    *(int*)GET_PTR(lp,2) = c4; //return
}

/*
  @overload mathieu_Ms(j,n,q,x)
  
  @param [Integer] j
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [Numo::Int]  return

  These routines compute the radial j-th kind Mathieu functions
$Mc_n^{(j)}(q,x)$
Mc_n^[(j)](q,x) and 
$Ms_n^{(j)}(q,x)$
Ms_n^[(j)](q,x) of order n.

The allowed values of j are 1 and 2.
The functions for j = 3,4 can be computed as 
$M_n^{(3)} = M_n^{(1)} + iM_n^{(2)}$
M_n^[(3)] = M_n^[(1)] + iM_n^[(2)] and 
$M_n^{(4)} = M_n^{(1)} - iM_n^{(2)}$
M_n^[(4)] = M_n^[(1)] - iM_n^[(2)],
where 
$M_n^{(j)} = Mc_n^{(j)}$
M_n^[(j)] = Mc_n^[(j)] or 
$Ms_n^{(j)}$
Ms_n^[(j)].
*/
static VALUE
sf_s_mathieu_Ms(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_Ms,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //j
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_mathieu_Ms_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //j
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_mathieu_Ms_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,2) = c4.val; *(double*)GET_PTR(lp,3) = c4.err; //result
    *(int*)GET_PTR(lp,4) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload mathieu_Ms_e(j,n,q,x)
  
  @param [Integer] j
  @param [Integer] n
  @param [Numo::DFloat] q
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the radial j-th kind Mathieu functions
$Mc_n^{(j)}(q,x)$
Mc_n^[(j)](q,x) and 
$Ms_n^{(j)}(q,x)$
Ms_n^[(j)](q,x) of order n.

The allowed values of j are 1 and 2.
The functions for j = 3,4 can be computed as 
$M_n^{(3)} = M_n^{(1)} + iM_n^{(2)}$
M_n^[(3)] = M_n^[(1)] + iM_n^[(2)] and 
$M_n^{(4)} = M_n^{(1)} - iM_n^{(2)}$
M_n^[(4)] = M_n^[(1)] - iM_n^[(2)],
where 
$M_n^{(j)} = Mc_n^{(j)}$
M_n^[(j)] = Mc_n^[(j)] or 
$Ms_n^{(j)}$
Ms_n^[(j)].
*/
static VALUE
sf_s_mathieu_Ms_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_mathieu_Ms_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //j
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v2,v3); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_m1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_m1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_m1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral with an index of -1. 
This integral is given by 
$F_{-1}(x) = e^x / (1 + e^x)$
F_[-1](x) = e^x / (1 + e^x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_fermi_dirac_m1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_m1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_m1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_m1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_m1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral with an index of -1. 
This integral is given by 
$F_{-1}(x) = e^x / (1 + e^x)$
F_[-1](x) = e^x / (1 + e^x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_fermi_dirac_m1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_m1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral with an index of 0. 
This integral is given by F_0(x) = \ln(1 + e^x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_fermi_dirac_0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral with an index of 0. 
This integral is given by F_0(x) = \ln(1 + e^x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_fermi_dirac_0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral with an index of 1,
F_1(x) = \int_0^\infty dt (t /(\exp(t-x)+1)).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral with an index of 1,
F_1(x) = \int_0^\infty dt (t /(\exp(t-x)+1)).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral with an index
of 2,
F_2(x) = (1/2) \int_0^\infty dt (t^2 /(\exp(t-x)+1)).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral with an index
of 2,
F_2(x) = (1/2) \int_0^\infty dt (t^2 /(\exp(t-x)+1)).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_fermi_dirac_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_int(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_int(j, x)
  @param  [Integer]   j
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the complete Fermi-Dirac integral with an integer
index of j,
F_j(x) = (1/\Gamma(j+1)) \int_0^\infty dt (t^j /(\exp(t-x)+1)).
Complete integral F_j(x) for integer j
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_int(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_int_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //j

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_fermi_dirac_int_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_int_e(j,x)
  
  @param [Integer] j
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral with an integer
index of j,
F_j(x) = (1/\Gamma(j+1)) \int_0^\infty dt (t^j /(\exp(t-x)+1)).
Complete integral F_j(x) for integer j
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_int_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_int_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //j
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_mhalf(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_mhalf(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_mhalf(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral 
$F_{-1/2}(x)$
F_[-1/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_mhalf(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_mhalf, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_mhalf_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_mhalf_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_mhalf_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral 
$F_{-1/2}(x)$
F_[-1/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_mhalf_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_mhalf_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_half(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_half(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_half(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral 
$F_{1/2}(x)$
F_[1/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_half(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_half, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_half_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_half_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_half_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral 
$F_{1/2}(x)$
F_[1/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_half_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_half_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_fermi_dirac_3half(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_fermi_dirac_3half(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload fermi_dirac_3half(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the complete Fermi-Dirac integral 
$F_{3/2}(x)$
F_[3/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_3half(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_3half, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_3half_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_fermi_dirac_3half_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_3half_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the complete Fermi-Dirac integral 
$F_{3/2}(x)$
F_[3/2](x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_fermi_dirac_3half_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_3half_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_fermi_dirac_inc_0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_fermi_dirac_inc_0(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload fermi_dirac_inc_0(x, b)
  @param  [DFloat]   x
  @param  [DFloat]   b
  @return [DFloat]   result

  These routines compute the incomplete Fermi-Dirac integral with an index
of zero,
$F_0(x,b) = \ln(1 + e^{b-x}) - (b-x)$
F_0(x,b) = \ln(1 + e^[b-x]) - (b-x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EDOM
*/
static VALUE
sf_s_fermi_dirac_inc_0(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_inc_0, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_fermi_dirac_inc_0_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //b
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_fermi_dirac_inc_0_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload fermi_dirac_inc_0_e(x,b)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] b
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the incomplete Fermi-Dirac integral with an index
of zero,
$F_0(x,b) = \ln(1 + e^{b-x}) - (b-x)$
F_0(x,b) = \ln(1 + e^[b-x]) - (b-x).
Exceptional Return Values: GSL_EUNDRFLW, GSL_EDOM
*/
static VALUE
sf_s_fermi_dirac_inc_0_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_fermi_dirac_inc_0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_dilog(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_dilog(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload dilog(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the dilogarithm for a real argument. In Lewin's
notation this is Li_2(x), the real part of the dilogarithm of a
real x.  It is defined by the integral representation
Li_2(x) = - \Re \int_0^x ds \log(1-s) / s.  
Note that \Im(Li_2(x)) = 0 for $x \le 1$ 
x <= 1, and -\pi\log(x) for x > 1.

Note that Abramowitz & Stegun refer to the Spence integral
S(x)=Li_2(1-x) as the dilogarithm rather than Li_2(x).
*/
static VALUE
sf_s_dilog(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_dilog, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_dilog_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_dilog_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload dilog_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the dilogarithm for a real argument. In Lewin's
notation this is Li_2(x), the real part of the dilogarithm of a
real x.  It is defined by the integral representation
Li_2(x) = - \Re \int_0^x ds \log(1-s) / s.  
Note that \Im(Li_2(x)) = 0 for $x \le 1$ 
x <= 1, and -\pi\log(x) for x > 1.

Note that Abramowitz & Stegun refer to the Spence integral
S(x)=Li_2(1-x) as the dilogarithm rather than Li_2(x).
*/
static VALUE
sf_s_dilog_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_dilog_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_complex_dilog_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //r
    c1 = *(double*)GET_PTR(lp,1); //theta
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_complex_dilog_e(c0,c1,&c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result_re
    *(double*)GET_PTR(lp,4) = c3.val; *(double*)GET_PTR(lp,5) = c3.err; //result_im
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload complex_dilog_e(r,theta)
  
  @param [Numo::DFloat] r
  @param [Numo::DFloat] theta
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_re.val, result_re.err, result_im.val, result_im.err, return]

  This function computes the full complex-valued dilogarithm for the
complex argument z = r \exp(i \theta). The real and imaginary
parts of the result are returned in result_re, result_im.
*/
static VALUE
sf_s_complex_dilog_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_complex_dilog_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,5,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_J0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_J0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_J0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular cylindrical Bessel function of zeroth
order, J_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_J0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_J0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_J0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_J0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_J0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular cylindrical Bessel function of zeroth
order, J_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_J0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_J0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_J1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_J1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_J1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular cylindrical Bessel function of first
order, J_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_J1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_J1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_J1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_J1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_J1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular cylindrical Bessel function of first
order, J_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_J1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_J1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_Jn(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Jn(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Jn(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the regular cylindrical Bessel function of 
order n, J_n(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Jn(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Jn, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Jn_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Jn_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Jn_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular cylindrical Bessel function of 
order n, J_n(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Jn_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Jn_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Jn_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_Jn_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Jn_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the regular cylindrical Bessel
functions J_n(x) for n from nmin to nmax
inclusive, storing the results in the array result_array.  The
values are computed using recurrence relations for efficiency, and
therefore may differ slightly from the exact values.
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Jn_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Jn_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_Y0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Y0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Y0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular cylindrical Bessel function of zeroth
order, Y_0(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Y0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Y0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Y0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_Y0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Y0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular cylindrical Bessel function of zeroth
order, Y_0(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Y0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Y0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_Y1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Y1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Y1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular cylindrical Bessel function of first
order, Y_1(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Y1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Y1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Y1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_Y1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Y1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular cylindrical Bessel function of first
order, Y_1(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Y1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Y1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_Yn(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Yn(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Yn(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the irregular cylindrical Bessel function of 
order n, Y_n(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Yn(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Yn, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Yn_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Yn_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Yn_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular cylindrical Bessel function of 
order n, Y_n(x), for x>0.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Yn_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Yn_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Yn_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_Yn_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Yn_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the irregular cylindrical Bessel
functions Y_n(x) for n from nmin to nmax
inclusive, storing the results in the array result_array.  The
domain of the function is x>0.  The values are computed using
recurrence relations for efficiency, and therefore may differ slightly
from the exact values.
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Yn_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Yn_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_I0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_I0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_I0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular modified cylindrical Bessel function
of zeroth order, I_0(x).
Exceptional Return Values: GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_I0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_I0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_I0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_I0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular modified cylindrical Bessel function
of zeroth order, I_0(x).
Exceptional Return Values: GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_I0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_I1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_I1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_I1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular modified cylindrical Bessel function
of first order, I_1(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_I1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_I1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_I1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_I1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular modified cylindrical Bessel function
of first order, I_1(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_I1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_In(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_In(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_In(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the regular modified cylindrical Bessel function
of order n, I_n(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_In_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_In_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_In_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular modified cylindrical Bessel function
of order n, I_n(x).
Exceptional Return Values: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_In_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_In_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_In_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the regular modified cylindrical
Bessel functions I_n(x) for n from nmin to
nmax inclusive, storing the results in the array
result_array.  The start of the range nmin must be positive
or zero.  The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: nmin >=0, nmax >= nmin 
Conditions: n=nmin,...,nmax, nmin >=0, nmax >= nmin 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_I0_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_I0_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_I0_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified cylindrical Bessel
function of zeroth order \exp(-|x|) I_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_I0_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I0_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_I0_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_I0_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_I0_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified cylindrical Bessel
function of zeroth order \exp(-|x|) I_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_I0_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I0_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_I1_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_I1_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_I1_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified cylindrical Bessel
function of first order \exp(-|x|) I_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_I1_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I1_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_I1_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_I1_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_I1_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified cylindrical Bessel
function of first order \exp(-|x|) I_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_I1_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_I1_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_In_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_In_scaled(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_In_scaled(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the scaled regular modified cylindrical Bessel
function of order n, \exp(-|x|) I_n(x) 
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_In_scaled_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_In_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_In_scaled_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified cylindrical Bessel
function of order n, \exp(-|x|) I_n(x) 
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_In_scaled_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_In_scaled_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_In_scaled_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the scaled regular cylindrical
Bessel functions \exp(-|x|) I_n(x) for n from
nmin to nmax inclusive, storing the results in the array
result_array. The start of the range nmin must be positive
or zero.  The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: nmin >=0, nmax >= nmin 
Conditions:  n=nmin,...,nmax 
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_In_scaled_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_In_scaled_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_K0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_K0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_K0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular modified cylindrical Bessel
function of zeroth order, K_0(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_K0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_K0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_K0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular modified cylindrical Bessel
function of zeroth order, K_0(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_K1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_K1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_K1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular modified cylindrical Bessel
function of first order, K_1(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_K1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_K1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_K1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular modified cylindrical Bessel
function of first order, K_1(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_Kn(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Kn(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Kn(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the irregular modified cylindrical Bessel
function of order n, K_n(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Kn_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Kn_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Kn_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular modified cylindrical Bessel
function of order n, K_n(x), for x > 0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Kn_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_Kn_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Kn_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the irregular modified cylindrical
Bessel functions K_n(x) for n from nmin to
nmax inclusive, storing the results in the array
result_array. The start of the range nmin must be positive
or zero. The domain of the function is x>0. The values are
computed using recurrence relations for efficiency, and therefore
may differ slightly from the exact values.
Conditions: n=nmin,...,nmax 
Domain: x > 0.0, nmin>=0, nmax >= nmin
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_K0_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_K0_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_K0_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified cylindrical Bessel
function of zeroth order \exp(x) K_0(x) for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_K0_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K0_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_K0_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_K0_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_K0_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified cylindrical Bessel
function of zeroth order \exp(x) K_0(x) for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_K0_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K0_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_K1_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_K1_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_K1_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified cylindrical Bessel
function of first order \exp(x) K_1(x) for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K1_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K1_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_K1_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_K1_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_K1_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified cylindrical Bessel
function of first order \exp(x) K_1(x) for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_K1_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_K1_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_Kn_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_Kn_scaled(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_Kn_scaled(n, x)
  @param  [Integer]   n
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the scaled irregular modified cylindrical Bessel
function of order n, \exp(x) K_n(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Kn_scaled_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //n

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Kn_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Kn_scaled_e(n,x)
  
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified cylindrical Bessel
function of order n, \exp(x) K_n(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Kn_scaled_array(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //nmin
    c1 = *(int*)(opt[1]); //nmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_bessel_Kn_scaled_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Kn_scaled_array(nmin,nmax,x)
  
  @param [Integer] nmin
  @param [Integer] nmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the scaled irregular cylindrical
Bessel functions \exp(x) K_n(x) for n from nmin to
nmax inclusive, storing the results in the array
result_array. The start of the range nmin must be positive
or zero.  The domain of the function is x>0. The values are
computed using recurrence relations for efficiency, and therefore
may differ slightly from the exact values.
Domain: x > 0.0, nmin >=0, nmax >= nmin 
Conditions: n=nmin,...,nmax 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Kn_scaled_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Kn_scaled_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //nmin
    c1 = NUM2INT(v1); opt[1] = &c1; //nmax
    
    if (c0<0 || c1<0 || c0>c1) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = c1-c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_j0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_j0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_j0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular spherical Bessel function of zeroth
order, j_0(x) = \sin(x)/x.
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_j0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_j0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_j0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_j0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular spherical Bessel function of zeroth
order, j_0(x) = \sin(x)/x.
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_j0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_j1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_j1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_j1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular spherical Bessel function of first
order, j_1(x) = (\sin(x)/x - \cos(x))/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_j1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_j1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_j1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_j1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular spherical Bessel function of first
order, j_1(x) = (\sin(x)/x - \cos(x))/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_j1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_j2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_j2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_j2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular spherical Bessel function of second
order, j_2(x) = ((3/x^2 - 1)\sin(x) - 3\cos(x)/x)/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_j2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_j2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_j2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_j2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular spherical Bessel function of second
order, j_2(x) = ((3/x^2 - 1)\sin(x) - 3\cos(x)/x)/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_j2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_j2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_jl(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_jl(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_jl(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the regular spherical Bessel function of 
order l, j_l(x), for $l \geq 0$
l >= 0 and $x \geq 0$
x >= 0.
Domain: l >= 0, x >= 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_jl(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_jl, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_jl_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_jl_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_jl_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular spherical Bessel function of 
order l, j_l(x), for $l \geq 0$
l >= 0 and $x \geq 0$
x >= 0.
Domain: l >= 0, x >= 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_jl_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_jl_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_jl_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_jl_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_jl_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the regular spherical Bessel
functions j_l(x) for l from 0 to lmax
inclusive  for $lmax \geq 0$
lmax >= 0 and $x \geq 0$
x >= 0, storing the results in the array result_array.
The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: lmax >= 0 
Conditions: l=0,1,...,lmax 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_jl_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_jl_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be lmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_jl_steed_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_jl_steed_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_jl_steed_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine uses Steed's method to compute the values of the regular
spherical Bessel functions j_l(x) for l from 0 to
lmax inclusive for $lmax \geq 0$
lmax >= 0 and $x \geq 0$
x >= 0, storing the results in the array
result_array.
The Steed/Barnett algorithm is described in Comp. Phys. Comm. 21,
297 (1981).  Steed's method is more stable than the
recurrence used in the other functions but is also slower.
Domain: lmax >= 0 
Conditions: l=0,1,...,lmax 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_jl_steed_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_jl_steed_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be lmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_y0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_y0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_y0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular spherical Bessel function of zeroth
order, y_0(x) = -\cos(x)/x.
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_y0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_y0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_y0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_y0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular spherical Bessel function of zeroth
order, y_0(x) = -\cos(x)/x.
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_y0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_y1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_y1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_y1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular spherical Bessel function of first
order, y_1(x) = -(\cos(x)/x + \sin(x))/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_y1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_y1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_y1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_y1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular spherical Bessel function of first
order, y_1(x) = -(\cos(x)/x + \sin(x))/x.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_y1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_y2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_y2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_y2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular spherical Bessel function of second
order, y_2(x) = (-3/x^3 + 1/x)\cos(x) - (3/x^2)\sin(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_y2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_y2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_y2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_y2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular spherical Bessel function of second
order, y_2(x) = (-3/x^3 + 1/x)\cos(x) - (3/x^2)\sin(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_y2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_y2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_yl(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_yl(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_yl(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the irregular spherical Bessel function of 
order l, y_l(x), for $l \geq 0$
l >= 0.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_yl(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_yl, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_yl_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_yl_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_yl_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular spherical Bessel function of 
order l, y_l(x), for $l \geq 0$
l >= 0.
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_yl_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_yl_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_yl_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_yl_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_yl_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the irregular spherical Bessel
functions y_l(x) for l from 0 to lmax
inclusive  for $lmax \geq 0$
lmax >= 0, storing the results in the array result_array.
The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: lmax >= 0 
Conditions: l=0,1,...,lmax 
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_yl_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_yl_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be lmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_i0_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_i0_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_i0_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified spherical Bessel
function of zeroth order, \exp(-|x|) i_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_i0_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i0_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_i0_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_i0_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_i0_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified spherical Bessel
function of zeroth order, \exp(-|x|) i_0(x).
Exceptional Return Values: none
*/
static VALUE
sf_s_bessel_i0_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i0_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_i1_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_i1_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_i1_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified spherical Bessel
function of first order, \exp(-|x|) i_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_i1_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i1_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_i1_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_i1_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_i1_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified spherical Bessel
function of first order, \exp(-|x|) i_1(x).
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_i1_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i1_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_i2_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_i2_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_i2_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified spherical Bessel
function of second order,  \exp(-|x|) i_2(x)  
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_i2_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i2_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_i2_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_i2_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_i2_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified spherical Bessel
function of second order,  \exp(-|x|) i_2(x)  
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_i2_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_i2_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_il_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_il_scaled(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_il_scaled(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the scaled regular modified spherical Bessel
function of order l,  \exp(-|x|) i_l(x) 
Domain: l >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_il_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_il_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_il_scaled_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_il_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_il_scaled_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified spherical Bessel
function of order l,  \exp(-|x|) i_l(x) 
Domain: l >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_il_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_il_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_il_scaled_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_il_scaled_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_il_scaled_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the scaled regular modified
spherical Bessel functions \exp(-|x|) i_l(x) for l from
0 to lmax inclusive for $lmax \geq 0$
lmax >= 0, storing the results in
the array result_array. 
The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: lmax >= 0 
Conditions: l=0,1,...,lmax 
Exceptional Return Values: GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_il_scaled_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_il_scaled_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be lmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_k0_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_k0_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_k0_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified spherical Bessel
function of zeroth order, \exp(x) k_0(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_k0_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k0_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_k0_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_k0_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_k0_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified spherical Bessel
function of zeroth order, \exp(x) k_0(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_k0_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k0_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_k1_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_k1_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_k1_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified spherical Bessel
function of first order, \exp(x) k_1(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_k1_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k1_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_k1_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_k1_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_k1_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified spherical Bessel
function of first order, \exp(x) k_1(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_k1_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k1_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_bessel_k2_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_k2_scaled(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_k2_scaled(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified spherical Bessel
function of second order, \exp(x) k_2(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_k2_scaled(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k2_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_k2_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_k2_scaled_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_k2_scaled_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified spherical Bessel
function of second order, \exp(x) k_2(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_k2_scaled_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_k2_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_bessel_kl_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_bessel_kl_scaled(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_kl_scaled(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the scaled irregular modified spherical Bessel
function of order l, \exp(x) k_l(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_kl_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_kl_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_kl_scaled_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_kl_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_kl_scaled_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified spherical Bessel
function of order l, \exp(x) k_l(x), for x>0.
Domain: x > 0.0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_kl_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_kl_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_kl_scaled_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_kl_scaled_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_kl_scaled_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This routine computes the values of the scaled irregular modified
spherical Bessel functions \exp(x) k_l(x) for l from
0 to lmax inclusive for $lmax \geq 0$
lmax >= 0 and x>0, storing the results in
the array result_array. 
The values are computed using recurrence relations for
efficiency, and therefore may differ slightly from the exact values.
Domain: lmax >= 0 
Conditions: l=0,1,...,lmax 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_kl_scaled_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_kl_scaled_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    if (c0<0) {
        rb_raise(rb_eArgError,"should be lmax>=0");
    }
    shape[0] = c0+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Jnu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Jnu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Jnu(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular cylindrical Bessel function of
fractional order \nu, J_\nu(x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Jnu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Jnu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Jnu_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Jnu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Jnu_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular cylindrical Bessel function of
fractional order \nu, J_\nu(x).
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Jnu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Jnu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Ynu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Ynu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Ynu(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular cylindrical Bessel function of
fractional order \nu, Y_\nu(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_Ynu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Ynu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Ynu_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Ynu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Ynu_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular cylindrical Bessel function of
fractional order \nu, Y_\nu(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_Ynu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Ynu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Inu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Inu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Inu(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular modified Bessel function of
fractional order \nu, I_\nu(x) for x>0,
\nu>0.
Domain: x >= 0, nu >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_Inu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Inu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Inu_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Inu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Inu_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular modified Bessel function of
fractional order \nu, I_\nu(x) for x>0,
\nu>0.
Domain: x >= 0, nu >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_bessel_Inu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Inu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Inu_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Inu_scaled(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Inu_scaled(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled regular modified Bessel function of
fractional order \nu, \exp(-|x|)I_\nu(x) for x>0,
\nu>0.
 \exp(-|x|) I_[\nu](x)  
Domain: x >= 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_Inu_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Inu_scaled, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Inu_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Inu_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Inu_scaled_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled regular modified Bessel function of
fractional order \nu, \exp(-|x|)I_\nu(x) for x>0,
\nu>0.
 \exp(-|x|) I_[\nu](x)  
Domain: x >= 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_Inu_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Inu_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Knu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Knu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Knu(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular modified Bessel function of
fractional order \nu, K_\nu(x) for x>0,
\nu>0.
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Knu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Knu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Knu_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Knu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Knu_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular modified Bessel function of
fractional order \nu, K_\nu(x) for x>0,
\nu>0.
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW
*/
static VALUE
sf_s_bessel_Knu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Knu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_lnKnu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_lnKnu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_lnKnu(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the logarithm of the irregular modified Bessel
function of fractional order \nu, \ln(K_\nu(x)) for
x>0, \nu>0. 
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_lnKnu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_lnKnu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_lnKnu_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_lnKnu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_lnKnu_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the logarithm of the irregular modified Bessel
function of fractional order \nu, \ln(K_\nu(x)) for
x>0, \nu>0. 
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_lnKnu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_lnKnu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_bessel_Knu_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_bessel_Knu_scaled(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_Knu_scaled(nu, x)
  @param  [DFloat]   nu
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the scaled irregular modified Bessel function of
fractional order \nu, \exp(+|x|) K_\nu(x) for x>0,
\nu>0.
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_Knu_scaled(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Knu_scaled, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_Knu_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_Knu_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_Knu_scaled_e(nu,x)
  
  @param [Numo::DFloat] nu
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled irregular modified Bessel function of
fractional order \nu, \exp(+|x|) K_\nu(x) for x>0,
\nu>0.
Domain: x > 0, nu >= 0 
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_bessel_Knu_scaled_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_Knu_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_bessel_zero_J0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_bessel_zero_J0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_zero_J0(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th positive zero of
the Bessel function J_0(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_J0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_J0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_zero_J0_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_zero_J0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_zero_J0_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th positive zero of
the Bessel function J_0(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_J0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_J0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_bessel_zero_J1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_bessel_zero_J1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload bessel_zero_J1(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th positive zero of
the Bessel function J_1(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_J1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_J1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_zero_J1_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_bessel_zero_J1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_zero_J1_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th positive zero of
the Bessel function J_1(x).
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_J1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_J1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_UInt.c"
static void
iter_sf_s_bessel_zero_Jnu(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, z;
    unsigned int y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,unsigned int,y);
        z = gsl_sf_bessel_zero_Jnu(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload bessel_zero_Jnu(nu, s)
  @param  [DFloat]   nu
  @param  [DFloat]   s
  @return [DFloat]   result

  These routines compute the location of the s-th positive zero of
the Bessel function J_\nu(x).  The current implementation does not
support negative values of nu. 
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_Jnu(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cUInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_Jnu, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_bessel_zero_Jnu_e(na_loop_t *const lp)
{
    
    double c0;
    unsigned int c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //nu
    c1 = *(unsigned int*)GET_PTR(lp,1); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_bessel_zero_Jnu_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload bessel_zero_Jnu_e(nu,s)
  
  @param [Numo::DFloat] nu
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th positive zero of
the Bessel function J_\nu(x).  The current implementation does not
support negative values of nu. 
Exceptional Return Values: 
*/
static VALUE
sf_s_bessel_zero_Jnu_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_bessel_zero_Jnu_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_hydrogenicR_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_hydrogenicR_1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload hydrogenicR_1(Z, r)
  @param  [DFloat]   Z
  @param  [DFloat]   r
  @return [DFloat]   result

  These routines compute the lowest-order normalized hydrogenic bound
state radial wavefunction $R_1 := 2Z \sqrt{Z} \exp(-Z r)$
R_1 := 2Z \sqrt[Z] \exp(-Z r).
*/
static VALUE
sf_s_hydrogenicR_1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hydrogenicR_1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hydrogenicR_1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //Z
    c1 = *(double*)GET_PTR(lp,1); //r
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hydrogenicR_1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hydrogenicR_1_e(Z,r)
  
  @param [Numo::DFloat] Z
  @param [Numo::DFloat] r
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the lowest-order normalized hydrogenic bound
state radial wavefunction $R_1 := 2Z \sqrt{Z} \exp(-Z r)$
R_1 := 2Z \sqrt[Z] \exp(-Z r).
*/
static VALUE
sf_s_hydrogenicR_1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hydrogenicR_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_x2_DFloat_x2.c"
static void
iter_sf_s_hydrogenicR(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;
    int     *opts;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    opts = (int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_hydrogenicR(opts[0],opts[1],x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload hydrogenicR(n,l,Z,r)
  @param  [Integer]  n parameter
  @param  [Integer]  l parameter
  @param  [DFloat]   Z
  @param  [DFloat]   r
  @return [DFloat]   result

  These routines compute the n-th normalized hydrogenic bound state
radial wavefunction,

R_n := 2 (Z^[3/2]/n^2) \sqrt[(n-l-1)!/(n+l)!] \exp(-Z r/n) (2Zr/n)^l
          L^[2l+1]_[n-l-1](2Zr/n).  

where L^a_b(x) is the generalized Laguerre polynomial (Laguerre Functions).
The normalization is chosen such that the wavefunction \psi is
given by 
$\psi(n,l,r) = R_n Y_{lm}$
\psi(n,l,r) = R_n Y_[lm].   
*/
static VALUE
sf_s_hydrogenicR(VALUE mod, VALUE v0, VALUE v1, VALUE v2, VALUE v3)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hydrogenicR, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};
    int opts[2];

    opts[0] = NUM2INT(v0);
    opts[1] = NUM2INT(v1);

    return na_ndloop3(&ndf, opts, 2, v2, v3);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hydrogenicR_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //n
    c1 = *(int*)(opt[1]); //l
    

    
    c2 = *(double*)GET_PTR(lp,0); //Z
    c3 = *(double*)GET_PTR(lp,1); //r
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_hydrogenicR_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,2) = c4.val; *(double*)GET_PTR(lp,3) = c4.err; //result
    *(int*)GET_PTR(lp,4) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hydrogenicR_e(n,l,Z,r)
  
  @param [Integer] n
  @param [Integer] l
  @param [Numo::DFloat] Z
  @param [Numo::DFloat] r
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the n-th normalized hydrogenic bound state
radial wavefunction,

R_n := 2 (Z^[3/2]/n^2) \sqrt[(n-l-1)!/(n+l)!] \exp(-Z r/n) (2Zr/n)^l
          L^[2l+1]_[n-l-1](2Zr/n).  

where L^a_b(x) is the generalized Laguerre polynomial (Laguerre Functions).
The normalization is chosen such that the wavefunction \psi is
given by 
$\psi(n,l,r) = R_n Y_{lm}$
\psi(n,l,r) = R_n Y_[lm].   
*/
static VALUE
sf_s_hydrogenicR_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hydrogenicR_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //n
    c1 = NUM2INT(v1); opt[1] = &c1; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_wave_FG_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    int c3;
    gsl_sf_result c4;
    gsl_sf_result c5;
    gsl_sf_result c6;
    gsl_sf_result c7;
    double c8;
    double c9;
    int c10;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c3 = *(int*)(opt); //k

    
    c0 = *(double*)GET_PTR(lp,0); //eta
    c1 = *(double*)GET_PTR(lp,1); //x
    c2 = *(double*)GET_PTR(lp,2); //L_F
    
    
    
    
    
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c10 = gsl_sf_coulomb_wave_FG_e(c0,c1,c2,c3,&c4,&c5,&c6,&c7,&c8,&c9);
    
    *(double*)GET_PTR(lp,3) = c4.val; *(double*)GET_PTR(lp,4) = c4.err; //F
    *(double*)GET_PTR(lp,5) = c5.val; *(double*)GET_PTR(lp,6) = c5.err; //Fp
    *(double*)GET_PTR(lp,7) = c6.val; *(double*)GET_PTR(lp,8) = c6.err; //G
    *(double*)GET_PTR(lp,9) = c7.val; *(double*)GET_PTR(lp,10) = c7.err; //Gp
    *(double*)GET_PTR(lp,11) = c8; //exp_F
    *(double*)GET_PTR(lp,12) = c9; //exp_G
    *(int*)GET_PTR(lp,13) = c10; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_wave_FG_e(eta,x,L_F,k)
  
  @param [Numo::DFloat] eta
  @param [Numo::DFloat] x
  @param [Numo::DFloat] L_F
  @param [Integer] k
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [F.val, F.err, Fp.val, Fp.err, G.val, G.err, Gp.val, Gp.err, exp_F, exp_G, return]

  This function computes the Coulomb wave functions F_L(\eta,x),
$G_{L-k}(\eta,x)$ 
G_[L-k](\eta,x) and their derivatives 
F'_L(\eta,x), 
$G'_{L-k}(\eta,x)$
G'_[L-k](\eta,x)
with respect to x.  The parameters are restricted to L,
L-k > -1/2, x > 0 and integer k.  Note that L
itself is not restricted to being an integer. The results are stored in
the parameters F, G for the function values and Fp,
Gp for the derivative values.  If an overflow occurs,
GSL_EOVRFLW is returned and scaling exponents are stored in
the modifiable parameters exp_F, exp_G.
*/
static VALUE
sf_s_coulomb_wave_FG_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[11] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_wave_FG_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,11,ain,aout};
    
    void *opt;
    c3 = NUM2INT(v3); opt = &c3; //k
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v0,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_wave_F_array(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    double c2;
    double c3;
    double *c4;
    double c5;
    int c6;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //kmax

    
    c0 = *(double*)GET_PTR(lp,0); //L_min
    c2 = *(double*)GET_PTR(lp,1); //eta
    c3 = *(double*)GET_PTR(lp,2); //x
    
    c4 = (double*)GET_PTR(lp,3); //fc_array[]
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_coulomb_wave_F_array(c0,c1,c2,c3,c4,&c5);
    
    
    *(double*)GET_PTR(lp,4) = c5; //F_exponent
    *(int*)GET_PTR(lp,5) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_wave_F_array(L_min,kmax,eta,x)
  
  @param [Numo::DFloat] L_min
  @param [Integer] kmax
  @param [Numo::DFloat] eta
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [fc_array[], F_exponent, return]

  This function computes the Coulomb wave function F_L(\eta,x) for
L = Lmin \dots Lmin + kmax, storing the results in fc_array.
In the case of overflow the exponent is stored in F_exponent.
*/
static VALUE
sf_s_coulomb_wave_F_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c1;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_wave_F_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //kmax
    
    if (c1<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c1+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v0,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_wave_FG_array(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    double c6;
    double c7;
    int c8;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //kmax

    
    c0 = *(double*)GET_PTR(lp,0); //L_min
    c2 = *(double*)GET_PTR(lp,1); //eta
    c3 = *(double*)GET_PTR(lp,2); //x
    
    c4 = (double*)GET_PTR(lp,3); //fc_array[]
    c5 = (double*)GET_PTR(lp,4); //gc_array[]
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c8 = gsl_sf_coulomb_wave_FG_array(c0,c1,c2,c3,c4,c5,&c6,&c7);
    
    
    
    *(double*)GET_PTR(lp,5) = c6; //F_exponent
    *(double*)GET_PTR(lp,6) = c7; //G_exponent
    *(int*)GET_PTR(lp,7) = c8; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_wave_FG_array(L_min,kmax,eta,x)
  
  @param [Numo::DFloat] L_min
  @param [Integer] kmax
  @param [Numo::DFloat] eta
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [fc_array[], gc_array[], F_exponent, G_exponent, return]

  This function computes the functions F_L(\eta,x),
G_L(\eta,x) for L = Lmin \dots Lmin + kmax storing the
results in fc_array and gc_array.  In the case of overflow the
exponents are stored in F_exponent and G_exponent.
*/
static VALUE
sf_s_coulomb_wave_FG_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c1;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[5] = {{cDF,1,shape},{cDF,1,shape},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_wave_FG_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,5,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //kmax
    
    if (c1<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c1+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v0,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_wave_FGp_array(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    double *c6;
    double *c7;
    double c8;
    double c9;
    int c10;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //kmax

    
    c0 = *(double*)GET_PTR(lp,0); //L_min
    c2 = *(double*)GET_PTR(lp,1); //eta
    c3 = *(double*)GET_PTR(lp,2); //x
    
    c4 = (double*)GET_PTR(lp,3); //fc_array[]
    c5 = (double*)GET_PTR(lp,4); //fcp_array[]
    c6 = (double*)GET_PTR(lp,5); //gc_array[]
    c7 = (double*)GET_PTR(lp,6); //gcp_array[]
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c10 = gsl_sf_coulomb_wave_FGp_array(c0,c1,c2,c3,c4,c5,c6,c7,&c8,&c9);
    
    
    
    
    
    *(double*)GET_PTR(lp,7) = c8; //F_exponent
    *(double*)GET_PTR(lp,8) = c9; //G_exponent
    *(int*)GET_PTR(lp,9) = c10; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_wave_FGp_array(L_min,kmax,eta,x)
  
  @param [Numo::DFloat] L_min
  @param [Integer] kmax
  @param [Numo::DFloat] eta
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [fc_array[], fcp_array[], gc_array[], gcp_array[], F_exponent, G_exponent, return]

  This function computes the functions F_L(\eta,x),
G_L(\eta,x) and their derivatives F'_L(\eta,x),
G'_L(\eta,x) for L = Lmin \dots Lmin + kmax storing the
results in fc_array, gc_array, fcp_array and gcp_array.
In the case of overflow the exponents are stored in F_exponent 
and G_exponent.
*/
static VALUE
sf_s_coulomb_wave_FGp_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c1;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[7] = {{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_wave_FGp_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,7,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //kmax
    
    if (c1<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c1+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v0,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_wave_sphF_array(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    int c6;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //kmax

    
    c0 = *(double*)GET_PTR(lp,0); //L_min
    c2 = *(double*)GET_PTR(lp,1); //eta
    c3 = *(double*)GET_PTR(lp,2); //x
    
    c4 = (double*)GET_PTR(lp,3); //fc_array[]
    c5 = (double*)GET_PTR(lp,4); //F_exponent[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_coulomb_wave_sphF_array(c0,c1,c2,c3,c4,c5);
    
    
    
    *(int*)GET_PTR(lp,5) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_wave_sphF_array(L_min,kmax,eta,x)
  
  @param [Numo::DFloat] L_min
  @param [Integer] kmax
  @param [Numo::DFloat] eta
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [fc_array[], F_exponent[], return]

  This function computes the Coulomb wave function divided by the argument
F_L(\eta, x)/x for L = Lmin \dots Lmin + kmax, storing the
results in fc_array.  In the case of overflow the exponent is
stored in F_exponent. This function reduces to spherical Bessel
functions in the limit \eta \to 0.
*/
static VALUE
sf_s_coulomb_wave_sphF_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    int c1;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_wave_sphF_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //kmax
    
    if (c1<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c1+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,3,v0,v2,v3); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_CL_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //L
    c1 = *(double*)GET_PTR(lp,1); //eta
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_coulomb_CL_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_CL_e(L,eta)
  
  @param [Numo::DFloat] L
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  This function computes the Coulomb wave function normalization constant
C_L(\eta) for L > -1.
*/
static VALUE
sf_s_coulomb_CL_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_CL_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_coulomb_CL_array(na_loop_t *const lp)
{
    
    double c0;
    int c1;
    double c2;
    double *c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(int*)(opt); //kmax

    
    c0 = *(double*)GET_PTR(lp,0); //Lmin
    c2 = *(double*)GET_PTR(lp,1); //eta
    
    c3 = (double*)GET_PTR(lp,2); //cl[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_coulomb_CL_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload coulomb_CL_array(Lmin,kmax,eta)
  
  @param [Numo::DFloat] Lmin
  @param [Integer] kmax
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::Int]]  array of [cl[], return]

  This function computes the Coulomb wave function normalization constant
C_L(\eta) for L = Lmin \dots Lmin + kmax, Lmin > -1.
*/
static VALUE
sf_s_coulomb_CL_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c1;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_coulomb_CL_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,2,ain,aout};
    
    void *opt;
    c1 = NUM2INT(v1); opt = &c1; //kmax
    
    if (c1<0) {
        rb_raise(rb_eArgError,"should be kmax>=0");
    }
    shape[0] = c1+1;
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v0,v2); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Ai(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Ai(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Ai(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the Airy function Ai(x) with an accuracy
specified by mode.
*/
static VALUE
sf_s_airy_Ai(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Ai_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Ai_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Ai_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Airy function Ai(x) with an accuracy
specified by mode.
*/
static VALUE
sf_s_airy_Ai_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Bi(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Bi(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Bi(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the Airy function Bi(x) with an accuracy
specified by mode.
*/
static VALUE
sf_s_airy_Bi(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Bi_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Bi_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Bi_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Airy function Bi(x) with an accuracy
specified by mode.
*/
static VALUE
sf_s_airy_Bi_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Ai_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Ai_scaled(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Ai_scaled(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute a scaled version of the Airy function
S_A(x) Ai(x).  For x>0 the scaling factor S_A(x) is $\exp(+(2/3) x^{3/2})$
\exp(+(2/3) x^(3/2)), 
and is 1
for x<0.
*/
static VALUE
sf_s_airy_Ai_scaled(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Ai_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Ai_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Ai_scaled_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute a scaled version of the Airy function
S_A(x) Ai(x).  For x>0 the scaling factor S_A(x) is $\exp(+(2/3) x^{3/2})$
\exp(+(2/3) x^(3/2)), 
and is 1
for x<0.
*/
static VALUE
sf_s_airy_Ai_scaled_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Bi_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Bi_scaled(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Bi_scaled(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute a scaled version of the Airy function
S_B(x) Bi(x).  For x>0 the scaling factor S_B(x) is $\exp(-(2/3) x^{3/2})$
exp(-(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Bi_scaled(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Bi_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Bi_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Bi_scaled_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute a scaled version of the Airy function
S_B(x) Bi(x).  For x>0 the scaling factor S_B(x) is $\exp(-(2/3) x^{3/2})$
exp(-(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Bi_scaled_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Ai_deriv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Ai_deriv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Ai_deriv(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the Airy function derivative Ai'(x) with
an accuracy specified by mode.
*/
static VALUE
sf_s_airy_Ai_deriv(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_deriv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Ai_deriv_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Ai_deriv_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Ai_deriv_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Airy function derivative Ai'(x) with
an accuracy specified by mode.
*/
static VALUE
sf_s_airy_Ai_deriv_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_deriv_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Bi_deriv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Bi_deriv(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Bi_deriv(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the Airy function derivative Bi'(x) with
an accuracy specified by mode.
*/
static VALUE
sf_s_airy_Bi_deriv(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_deriv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Bi_deriv_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Bi_deriv_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Bi_deriv_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Airy function derivative Bi'(x) with
an accuracy specified by mode.
*/
static VALUE
sf_s_airy_Bi_deriv_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_deriv_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Ai_deriv_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Ai_deriv_scaled(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Ai_deriv_scaled(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the scaled Airy function derivative 
S_A(x) Ai'(x).  
For x>0 the scaling factor S_A(x) is $\exp(+(2/3) x^{3/2})$
\exp(+(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Ai_deriv_scaled(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_deriv_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Ai_deriv_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Ai_deriv_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Ai_deriv_scaled_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled Airy function derivative 
S_A(x) Ai'(x).  
For x>0 the scaling factor S_A(x) is $\exp(+(2/3) x^{3/2})$
\exp(+(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Ai_deriv_scaled_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Ai_deriv_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "tmpl/m_DFloat_f_DFloat_mode.c"
static void
iter_sf_s_airy_Bi_deriv_scaled(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    gsl_mode_t c1;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    c1 = *(gsl_mode_t*)(lp->opt_ptr);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_airy_Bi_deriv_scaled(x, c1);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_Bi_deriv_scaled(x[,mode])
  @param  [DFloat]   x
  @param  [Integer]  mode The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [DFloat]   result

  These routines compute the scaled Airy function derivative 
S_B(x) Bi'(x).
For x>0 the scaling factor S_B(x) is $\exp(-(2/3) x^{3/2})$
exp(-(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Bi_deriv_scaled(int argc, VALUE *v, VALUE mod)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_deriv_scaled, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    gsl_mode_t c1;

    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1..2",argc);
    }
    return na_ndloop3(&ndf, &c1, 1, v[0]);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_Bi_deriv_scaled_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_mode_t c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(gsl_mode_t*)(opt); //mode

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_airy_Bi_deriv_scaled_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_Bi_deriv_scaled_e(x,[mode])
  
  @param [Numo::DFloat] x
  @param [Integer] mode  The following precision levels are available: Numo::GSL::PREC_DOUBLE, Numo::GSL::PREC_SINGLE, Numo::GSL::PREC_APPROX.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the scaled Airy function derivative 
S_B(x) Bi'(x).
For x>0 the scaling factor S_B(x) is $\exp(-(2/3) x^{3/2})$
exp(-(2/3) x^(3/2)), and is 1 for x<0.
*/
static VALUE
sf_s_airy_Bi_deriv_scaled_e(int argc, VALUE *v, VALUE mod)
{
    
    gsl_mode_t c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_Bi_deriv_scaled_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    if (argc==1) {
        c1 = GSL_MODE_DEFAULT;
    } else if (argc==2) {
        c1 = NUM2INT(v[1]);
    } else {
        rb_raise(rb_eArgError,"invalid number of argument: %d for 1 or 2",argc);
    }
    opt = &c1; //mode

    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v[0]); 
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_airy_zero_Ai(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_airy_zero_Ai(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_zero_Ai(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th zero of the Airy
function Ai(x).
*/
static VALUE
sf_s_airy_zero_Ai(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Ai, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_zero_Ai_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_airy_zero_Ai_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_zero_Ai_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th zero of the Airy
function Ai(x).
*/
static VALUE
sf_s_airy_zero_Ai_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Ai_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_airy_zero_Bi(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_airy_zero_Bi(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_zero_Bi(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th zero of the Airy
function Bi(x).
*/
static VALUE
sf_s_airy_zero_Bi(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Bi, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_zero_Bi_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_airy_zero_Bi_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_zero_Bi_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th zero of the Airy
function Bi(x).
*/
static VALUE
sf_s_airy_zero_Bi_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Bi_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_airy_zero_Ai_deriv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_airy_zero_Ai_deriv(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_zero_Ai_deriv(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th zero of the Airy
function derivative Ai'(x).
*/
static VALUE
sf_s_airy_zero_Ai_deriv(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Ai_deriv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_zero_Ai_deriv_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_airy_zero_Ai_deriv_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_zero_Ai_deriv_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th zero of the Airy
function derivative Ai'(x).
*/
static VALUE
sf_s_airy_zero_Ai_deriv_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Ai_deriv_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_UInt.c"
static void
iter_sf_s_airy_zero_Bi_deriv(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    unsigned int x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--;) {
        GET_DATA_STRIDE(p1,s1,unsigned int,x);
        y = gsl_sf_airy_zero_Bi_deriv(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload airy_zero_Bi_deriv(s)
  @param  [UInt]     s
  @return [DFloat]   result

  These routines compute the location of the s-th zero of the Airy
function derivative Bi'(x).
*/
static VALUE
sf_s_airy_zero_Bi_deriv(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Bi_deriv, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_airy_zero_Bi_deriv_e(na_loop_t *const lp)
{
    
    unsigned int c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_airy_zero_Bi_deriv_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload airy_zero_Bi_deriv_e(s)
  
  @param [Numo::UInt] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the location of the s-th zero of the Airy
function derivative Bi'(x).
*/
static VALUE
sf_s_airy_zero_Bi_deriv_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_airy_zero_Bi_deriv_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_Int.c"
static void
iter_sf_s_zeta_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    int      x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,int,x);
        y = gsl_sf_zeta_int(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload zeta_int(n)
  @param  [Int]  n
  @return [DFloat]   result

  These routines compute the Riemann zeta function \zeta(n) 
for integer n,
n \ne 1.
Domain: n integer, n != 1
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zeta_int(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_zeta_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload zeta_int_e(n)
  
  @param [Integer] n
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the Riemann zeta function \zeta(n) 
for integer n,
n \ne 1.
Domain: n integer, n != 1
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zeta_int_e(VALUE mod,VALUE v0)
{
    
    int c0;
    gsl_sf_result c1;
    int c2;
    
    c0 = NUM2INT(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_zeta_int_e(c0,&c1);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c1.val));
        rb_ary_push(va,DBL2NUM(c1.err));
        rb_ary_push(va,INT2NUM(c2));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_zeta(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_zeta(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload zeta(s)
  @param  [DFloat]   s
  @return [DFloat]   result

  These routines compute the Riemann zeta function \zeta(s)
for arbitrary s,
s \ne 1.
Domain: s != 1.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zeta(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_zeta, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_zeta_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_zeta_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload zeta_e(s)
  
  @param [Numo::DFloat] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Riemann zeta function \zeta(s)
for arbitrary s,
s \ne 1.
Domain: s != 1.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zeta_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_zeta_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_Int.c"
static void
iter_sf_s_zetam1_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    int      x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,int,x);
        y = gsl_sf_zetam1_int(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload zetam1_int(n)
  @param  [Int]  n
  @return [DFloat]   result

  These routines compute \zeta(n) - 1 for integer n,
n \ne 1.
Domain: n integer, n != 1
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zetam1_int(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_zetam1_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload zetam1_int_e(n)
  
  @param [Integer] n
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute \zeta(n) - 1 for integer n,
n \ne 1.
Domain: n integer, n != 1
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zetam1_int_e(VALUE mod,VALUE v0)
{
    
    int c0;
    gsl_sf_result c1;
    int c2;
    
    c0 = NUM2INT(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_zetam1_int_e(c0,&c1);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c1.val));
        rb_ary_push(va,DBL2NUM(c1.err));
        rb_ary_push(va,INT2NUM(c2));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_zetam1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_zetam1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload zetam1(s)
  @param  [DFloat]   s
  @return [DFloat]   result

  These routines compute \zeta(s) - 1 for arbitrary s,
s \ne 1.
Domain: s != 1.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zetam1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_zetam1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_zetam1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_zetam1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload zetam1_e(s)
  
  @param [Numo::DFloat] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute \zeta(s) - 1 for arbitrary s,
s \ne 1.
Domain: s != 1.0
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_zetam1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_zetam1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_hzeta(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_hzeta(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload hzeta(s, q)
  @param  [DFloat]   s
  @param  [DFloat]   q
  @return [DFloat]   result

  These routines compute the Hurwitz zeta function \zeta(s,q) for
s > 1, q > 0.
Domain: s > 1.0, q > 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_hzeta(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hzeta, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hzeta_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //s
    c1 = *(double*)GET_PTR(lp,1); //q
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hzeta_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hzeta_e(s,q)
  
  @param [Numo::DFloat] s
  @param [Numo::DFloat] q
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Hurwitz zeta function \zeta(s,q) for
s > 1, q > 0.
Domain: s > 1.0, q > 0.0
Exceptional Return Values: GSL_EDOM, GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_hzeta_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hzeta_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_Int.c"
static void
iter_sf_s_eta_int(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    int      x;
    double   y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,int,x);
        y = gsl_sf_eta_int(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload eta_int(n)
  @param  [Int]  n
  @return [DFloat]   result

  These routines compute the eta function \eta(n) for integer n.
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_eta_int(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cInt,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_eta_int, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload eta_int_e(n)
  
  @param [Integer] n
  @return [[Float, Float, Integer]]  array of [result.val, result.err, return]

  These routines compute the eta function \eta(n) for integer n.
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_eta_int_e(VALUE mod,VALUE v0)
{
    
    int c0;
    gsl_sf_result c1;
    int c2;
    
    c0 = NUM2INT(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_eta_int_e(c0,&c1);
    
#line 20 "../gen/tmpl/mod_func_scalar.c"
    {
        VALUE va = rb_ary_new();
        
        rb_ary_push(va,DBL2NUM(c1.val));
        rb_ary_push(va,DBL2NUM(c1.err));
        rb_ary_push(va,INT2NUM(c2));
#line 24 "../gen/tmpl/mod_func_scalar.c"
        return va;
    }
    
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_eta(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_eta(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload eta(s)
  @param  [DFloat]   s
  @return [DFloat]   result

  These routines compute the eta function \eta(s) for arbitrary s.
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_eta(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_eta, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_eta_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //s
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_eta_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload eta_e(s)
  
  @param [Numo::DFloat] s
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the eta function \eta(s) for arbitrary s.
Exceptional Return Values: GSL_EUNDRFLW, GSL_EOVRFLW
*/
static VALUE
sf_s_eta_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_eta_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_legendre_P1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_P1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_P1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_legendre_P2(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_P2(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_P2(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P2(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P2, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_legendre_P3(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_P3(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_P3(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P3(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P3, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_P1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_legendre_P1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_P1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_P2_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_legendre_P2_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_P2_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P2_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P2_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_P3_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_legendre_P3_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_P3_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Legendre polynomials
$P_l(x)$ 
P_l(x) using explicit
representations for l=1, 2, 3.
Exceptional Return Values: none
*/
static VALUE
sf_s_legendre_P3_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_P3_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_legendre_Pl(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_Pl(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_Pl(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These functions evaluate the Legendre polynomial $P_l(x)$ 
P_l(x) for a specific value of l,
x subject to $l \ge 0$
l >= 0, 
$|x| \le 1$
|x| <= 1
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Pl(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Pl, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Pl_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_Pl_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Pl_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These functions evaluate the Legendre polynomial $P_l(x)$ 
P_l(x) for a specific value of l,
x subject to $l \ge 0$
l >= 0, 
$|x| \le 1$
|x| <= 1
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Pl_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Pl_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Pl_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_Pl_array(c0,c1,c2);
    
    
    *(int*)GET_PTR(lp,2) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Pl_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  
These functions compute arrays of Legendre polynomials
P_l(x) and derivatives dP_l(x)/dx, 
for l = 0, \dots, lmax, 
$|x| \le 1$
|x| <= 1
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Pl_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Pl_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c0);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Pl_deriv_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double *c2;
    double *c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    c2 = (double*)GET_PTR(lp,1); //result_array[]
    c3 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_Pl_deriv_array(c0,c1,c2,c3);
    
    
    
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Pl_deriv_array(lmax,x)
  
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], return]

  
These functions compute arrays of Legendre polynomials
P_l(x) and derivatives dP_l(x)/dx, 
for l = 0, \dots, lmax, 
$|x| \le 1$
|x| <= 1
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Pl_deriv_array(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Pl_deriv_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c0);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_legendre_Q0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_Q0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_Q0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Legendre function Q_0(x) for x >
-1, $x \ne 1$
x != 1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Q0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Q0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Q0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_legendre_Q0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Q0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Legendre function Q_0(x) for x >
-1, $x \ne 1$
x != 1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Q0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Q0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_legendre_Q1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_Q1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_Q1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Legendre function Q_1(x) for x >
-1, $x \ne 1$
x != 1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Q1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Q1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Q1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_legendre_Q1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Q1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Legendre function Q_1(x) for x >
-1, $x \ne 1$
x != 1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Q1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Q1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_int_DFloat.c"
static void
iter_sf_s_legendre_Ql(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;
    int      c0;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    c0 = *(int*)(lp->opt_ptr);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_legendre_Ql(c0, x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload legendre_Ql(l, x)
  @param  [Integer]   l
  @param  [DFloat]    x
  @return [DFloat]    result

  These routines compute the Legendre function Q_l(x) for x >
-1, $x \ne 1$
x != 1 and $l \ge 0$
l >= 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Ql(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Ql, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};
    int c0;

    c0 = NUM2INT(v0);

    return na_ndloop3(&ndf, &c0, 1, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Ql_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_Ql_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,1) = c2.val; *(double*)GET_PTR(lp,2) = c2.err; //result
    *(int*)GET_PTR(lp,3) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Ql_e(l,x)
  
  @param [Integer] l
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Legendre function Q_l(x) for x >
-1, $x \ne 1$
x != 1 and $l \ge 0$
l >= 0.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_Ql_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Ql_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_array(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double *c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,2) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_array(norm,lmax,x)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  These functions calculate all normalized associated Legendre
polynomials for 0 \le l \le lmax and
0 \le m \le l for
$|x| \le 1$
|x| <= 1.
The norm parameter specifies which normalization is used.
The normalized P_l^m(x) values are stored in result_array, whose
minimum size can be obtained from calling gsl_sf_legendre_array_n.
The array index of P_l^m(x) is obtained from calling
gsl_sf_legendre_array_index(l, m). To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_array_e(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double c3;
    double *c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    c3 = *(double*)(opt[2]); //csphase
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c4 = (double*)GET_PTR(lp,1); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_legendre_array_e(c0,c1,c2,c3,c4);
    
    
    *(int*)GET_PTR(lp,2) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_array_e(norm,lmax,x,csphase)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @param [Float] csphase  To include or exclude the Condon-Shortley phase factor of (-1)^m, set the parameter csphase to either -1 or 1 respectively.
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  These functions calculate all normalized associated Legendre
polynomials for 0 \le l \le lmax and
0 \le m \le l for
$|x| \le 1$
|x| <= 1.
The norm parameter specifies which normalization is used.
The normalized P_l^m(x) values are stored in result_array, whose
minimum size can be obtained from calling gsl_sf_legendre_array_n.
The array index of P_l^m(x) is obtained from calling
gsl_sf_legendre_array_index(l, m). To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_array_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c3;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_array_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,2,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    c3 = NUM2DBL(v3); opt[2] = &c3; //csphase
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv_array(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double *c3;
    double *c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    c4 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_legendre_deriv_array(c0,c1,c2,c3,c4);
    
    
    
    *(int*)GET_PTR(lp,3) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv_array(norm,lmax,x)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], return]

  These functions calculate all normalized associated Legendre
functions and their first derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x) values and their derivatives
dP_l^m(x)/dx are stored in result_array and
result_deriv_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv_array_e(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    int c6;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    c3 = *(double*)(opt[2]); //csphase
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c4 = (double*)GET_PTR(lp,1); //result_array[]
    c5 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_legendre_deriv_array_e(c0,c1,c2,c3,c4,c5);
    
    
    
    *(int*)GET_PTR(lp,3) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv_array_e(norm,lmax,x,csphase)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @param [Float] csphase  To include or exclude the Condon-Shortley phase factor of (-1)^m, set the parameter csphase to either -1 or 1 respectively.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], return]

  These functions calculate all normalized associated Legendre
functions and their first derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x) values and their derivatives
dP_l^m(x)/dx are stored in result_array and
result_deriv_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv_array_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c3;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv_array_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    c3 = NUM2DBL(v3); opt[2] = &c3; //csphase
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv_alt_array(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double *c3;
    double *c4;
    int c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    c4 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_legendre_deriv_alt_array(c0,c1,c2,c3,c4);
    
    
    
    *(int*)GET_PTR(lp,3) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv_alt_array(norm,lmax,x)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], return]

  These functions calculate all normalized associated Legendre
functions and their (alternate) first derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The normalized P_l^m(x) values and their derivatives
dP_l^m(\cos{\theta})/d\theta are stored in result_array and
result_deriv_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv_alt_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv_alt_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv_alt_array_e(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    int c6;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    c3 = *(double*)(opt[2]); //csphase
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c4 = (double*)GET_PTR(lp,1); //result_array[]
    c5 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_legendre_deriv_alt_array_e(c0,c1,c2,c3,c4,c5);
    
    
    
    *(int*)GET_PTR(lp,3) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv_alt_array_e(norm,lmax,x,csphase)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @param [Float] csphase  To include or exclude the Condon-Shortley phase factor of (-1)^m, set the parameter csphase to either -1 or 1 respectively.
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], return]

  These functions calculate all normalized associated Legendre
functions and their (alternate) first derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The normalized P_l^m(x) values and their derivatives
dP_l^m(\cos{\theta})/d\theta are stored in result_array and
result_deriv_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv_alt_array_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c3;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv_alt_array_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    c3 = NUM2DBL(v3); opt[2] = &c3; //csphase
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv2_array(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double *c3;
    double *c4;
    double *c5;
    int c6;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    c4 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    c5 = (double*)GET_PTR(lp,3); //result_deriv2_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_legendre_deriv2_array(c0,c1,c2,c3,c4,c5);
    
    
    
    
    *(int*)GET_PTR(lp,4) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv2_array(norm,lmax,x)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], result_deriv2_array[], return]

  These functions calculate all normalized associated Legendre
functions and their first and second derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x), their first derivatives
dP_l^m(x)/dx, and their second derivatives
d^2 P_l^m(x)/dx^2 are stored in result_array,
result_deriv_array, and result_deriv2_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv2_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv2_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv2_array_e(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    double *c6;
    int c7;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    c3 = *(double*)(opt[2]); //csphase
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c4 = (double*)GET_PTR(lp,1); //result_array[]
    c5 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    c6 = (double*)GET_PTR(lp,3); //result_deriv2_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c7 = gsl_sf_legendre_deriv2_array_e(c0,c1,c2,c3,c4,c5,c6);
    
    
    
    
    *(int*)GET_PTR(lp,4) = c7; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv2_array_e(norm,lmax,x,csphase)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @param [Float] csphase  To include or exclude the Condon-Shortley phase factor of (-1)^m, set the parameter csphase to either -1 or 1 respectively.
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], result_deriv2_array[], return]

  These functions calculate all normalized associated Legendre
functions and their first and second derivatives up to degree lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x), their first derivatives
dP_l^m(x)/dx, and their second derivatives
d^2 P_l^m(x)/dx^2 are stored in result_array,
result_deriv_array, and result_deriv2_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv2_array_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c3;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv2_array_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    c3 = NUM2DBL(v3); opt[2] = &c3; //csphase
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv2_alt_array(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double *c3;
    double *c4;
    double *c5;
    int c6;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c3 = (double*)GET_PTR(lp,1); //result_array[]
    c4 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    c5 = (double*)GET_PTR(lp,3); //result_deriv2_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c6 = gsl_sf_legendre_deriv2_alt_array(c0,c1,c2,c3,c4,c5);
    
    
    
    
    *(int*)GET_PTR(lp,4) = c6; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv2_alt_array(norm,lmax,x)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], result_deriv2_array[], return]

  These functions calculate all normalized associated Legendre
functions and their (alternate) first and second derivatives up to degree
lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x), their first derivatives
dP_l^m(\cos{\theta})/d\theta, and their second derivatives
d^2 P_l^m(\cos{\theta})/d\theta^2 are stored in result_array,
result_deriv_array, and result_deriv2_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv2_alt_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv2_alt_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_deriv2_alt_array_e(na_loop_t *const lp)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c2;
    double c3;
    double *c4;
    double *c5;
    double *c6;
    int c7;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(gsl_sf_legendre_t*)(opt[0]); //norm
    c1 = *(size_t*)(opt[1]); //lmax
    c3 = *(double*)(opt[2]); //csphase
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    c4 = (double*)GET_PTR(lp,1); //result_array[]
    c5 = (double*)GET_PTR(lp,2); //result_deriv_array[]
    c6 = (double*)GET_PTR(lp,3); //result_deriv2_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c7 = gsl_sf_legendre_deriv2_alt_array_e(c0,c1,c2,c3,c4,c5,c6);
    
    
    
    
    *(int*)GET_PTR(lp,4) = c7; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_deriv2_alt_array_e(norm,lmax,x,csphase)
  
  @param [Integer] norm Type of normalization to use. The possible values are: Numo::GSL::Sf::Legendre::NONE, Numo::GSL::Sf::Legendre::SCHMIDT, Numo::GSL::Sf::Legendre::SPHARM, Numo::GSL::Sf::Legendre::FULL
  @param [Integer] lmax
  @param [Numo::DFloat] x
  @param [Float] csphase  To include or exclude the Condon-Shortley phase factor of (-1)^m, set the parameter csphase to either -1 or 1 respectively.
  @return [[Numo::DFloat, Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result_array[], result_deriv_array[], result_deriv2_array[], return]

  These functions calculate all normalized associated Legendre
functions and their (alternate) first and second derivatives up to degree
lmax for
$|x| < 1$
|x| < 1.
The parameter norm specifies the normalization used. The
normalized P_l^m(x), their first derivatives
dP_l^m(\cos{\theta})/d\theta, and their second derivatives
d^2 P_l^m(\cos{\theta})/d\theta^2 are stored in result_array,
result_deriv_array, and result_deriv2_array respectively.
To include or exclude
the Condon-Shortley phase factor of (-1)^m, set the parameter
csphase to either -1 or 1 respectively in the
_e function. This factor is included by default.
*/
static VALUE
sf_s_legendre_deriv2_alt_array_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    gsl_sf_legendre_t c0;
    size_t c1;
    double c3;
    
#line 36 "../gen/tmpl/mod_func_noloop.c"
    size_t shape[1]; 

    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,1,shape},{cDF,1,shape},{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_deriv2_alt_array_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //norm
    c1 = NUM2SIZET(v1); opt[1] = &c1; //lmax
    c3 = NUM2DBL(v3); opt[2] = &c3; //csphase
    
    shape[0] = gsl_sf_legendre_array_n(c1);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload legendre_array_n(lmax)
  
  @param [Integer] lmax
  @return [Integer]  return

  This function returns the minimum array size for maximum degree lmax
needed for the array versions of the associated Legendre functions.
Size is calculated as the total number of P_l^m(x) functions,
plus extra space for precomputing multiplicative factors used in the
recurrence relations.
*/
static VALUE
sf_s_legendre_array_n(VALUE mod,VALUE v0)
{
    
    size_t c0;
    size_t c1;
    
    c0 = NUM2SIZET(v0);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c1 = gsl_sf_legendre_array_n(c0);
    
    return SIZET2NUM(c1);
    
#line 27 "../gen/tmpl/mod_func_scalar.c"
}


#line 1 "../gen/tmpl/mod_func_scalar.c"
/*
  @overload legendre_array_index(l,m)
  
  @param [Integer] l
  @param [Integer] m
  @return [Integer]  return

  This function returns the index into result_array,
result_deriv_array, or result_deriv2_array corresponding
to P_l^m(x), P_l^{'m}(x), or P_l^{''m}(x). The
index is given by l(l+1)/2 + m.
*/
static VALUE
sf_s_legendre_array_index(VALUE mod,VALUE v0,VALUE v1)
{
    
    size_t c0;
    size_t c1;
    size_t c2;
    
    c0 = NUM2SIZET(v0);
    c1 = NUM2SIZET(v1);
#line 16 "../gen/tmpl/mod_func_scalar.c"
    c2 = gsl_sf_legendre_array_index(c0,c1);
    
    return SIZET2NUM(c2);
    
#line 27 "../gen/tmpl/mod_func_scalar.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Plm(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //l
    c1 = *(int*)(opt[1]); //m
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_Plm(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload legendre_Plm(l,m,x)
  
  @param [Integer] l
  @param [Integer] m
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the associated Legendre polynomial
P_l^m(x) for $m \ge 0$
m >= 0, $l \ge m$
l >= m, $|x| \le 1$
|x| <= 1. 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_legendre_Plm(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Plm,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //l
    c1 = NUM2INT(v1); opt[1] = &c1; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_Plm_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //l
    c1 = *(int*)(opt[1]); //m
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_Plm_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,1) = c3.val; *(double*)GET_PTR(lp,2) = c3.err; //result
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_Plm_e(l,m,x)
  
  @param [Integer] l
  @param [Integer] m
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the associated Legendre polynomial
P_l^m(x) for $m \ge 0$
m >= 0, $l \ge m$
l >= m, $|x| \le 1$
|x| <= 1. 
Exceptional Return Values: GSL_EDOM, GSL_EOVRFLW
*/
static VALUE
sf_s_legendre_Plm_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_Plm_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //l
    c1 = NUM2INT(v1); opt[1] = &c1; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_sphPlm(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //l
    c1 = *(int*)(opt[1]); //m
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_sphPlm(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload legendre_sphPlm(l,m,x)
  
  @param [Integer] l
  @param [Integer] m
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the normalized associated Legendre polynomial
$\sqrt{(2l+1)/(4\pi)} \sqrt{(l-m)!/(l+m)!} P_l^m(x)$
\sqrt[(2l+1)/(4\pi)] \sqrt[(l-m)!/(l+m)!] P_l^m(x) suitable
for use in spherical harmonics.  The parameters must satisfy $m \ge 0$
m >= 0, $l \ge m$
l >= m, $|x| \le 1$
|x| <= 1. Theses routines avoid the overflows
that occur for the standard normalization of P_l^m(x).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_sphPlm(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_sphPlm,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //l
    c1 = NUM2INT(v1); opt[1] = &c1; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_sphPlm_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //l
    c1 = *(int*)(opt[1]); //m
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_sphPlm_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,1) = c3.val; *(double*)GET_PTR(lp,2) = c3.err; //result
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_sphPlm_e(l,m,x)
  
  @param [Integer] l
  @param [Integer] m
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the normalized associated Legendre polynomial
$\sqrt{(2l+1)/(4\pi)} \sqrt{(l-m)!/(l+m)!} P_l^m(x)$
\sqrt[(2l+1)/(4\pi)] \sqrt[(l-m)!/(l+m)!] P_l^m(x) suitable
for use in spherical harmonics.  The parameters must satisfy $m \ge 0$
m >= 0, $l \ge m$
l >= m, $|x| \le 1$
|x| <= 1. Theses routines avoid the overflows
that occur for the standard normalization of P_l^m(x).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_sphPlm_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_sphPlm_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //l
    c1 = NUM2INT(v1); opt[1] = &c1; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_conicalP_half(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_conicalP_half(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload conicalP_half(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the irregular Spherical Conical Function
$P^{1/2}_{-1/2 + i \lambda}(x)$
P^[1/2]_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_half(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_half, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_half_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_half_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_half_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the irregular Spherical Conical Function
$P^{1/2}_{-1/2 + i \lambda}(x)$
P^[1/2]_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_half_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_half_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_conicalP_mhalf(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_conicalP_mhalf(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload conicalP_mhalf(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the regular Spherical Conical Function
$P^{-1/2}_{-1/2 + i \lambda}(x)$
P^[-1/2]_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_mhalf(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_mhalf, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_mhalf_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_mhalf_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_mhalf_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the regular Spherical Conical Function
$P^{-1/2}_{-1/2 + i \lambda}(x)$
P^[-1/2]_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_mhalf_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_mhalf_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_conicalP_0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_conicalP_0(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload conicalP_0(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the conical function
$P^0_{-1/2 + i \lambda}(x)$
P^0_[-1/2 + i \lambda](x)
for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_0(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_0, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_0_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_0_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_0_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the conical function
$P^0_{-1/2 + i \lambda}(x)$
P^0_[-1/2 + i \lambda](x)
for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_0_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_conicalP_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_conicalP_1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload conicalP_1(lambda, x)
  @param  [DFloat]   lambda
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the conical function 
$P^1_{-1/2 + i \lambda}(x)$
P^1_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_1_e(lambda,x)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the conical function 
$P^1_{-1/2 + i \lambda}(x)$
P^1_[-1/2 + i \lambda](x) for x > -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_sph_reg(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_sph_reg(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload conicalP_sph_reg(l,lambda,x)
  
  @param [Integer] l
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the Regular Spherical Conical Function
$P^{-1/2-l}_{-1/2 + i \lambda}(x)$
P^[-1/2-l]_[-1/2 + i \lambda](x) for x > -1, $l \ge -1$
l >= -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_sph_reg(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_sph_reg,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_sph_reg_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_conicalP_sph_reg_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_sph_reg_e(l,lambda,x)
  
  @param [Integer] l
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Regular Spherical Conical Function
$P^{-1/2-l}_{-1/2 + i \lambda}(x)$
P^[-1/2-l]_[-1/2 + i \lambda](x) for x > -1, $l \ge -1$
l >= -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_sph_reg_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_sph_reg_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_cyl_reg(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //m

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_conicalP_cyl_reg(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload conicalP_cyl_reg(m,lambda,x)
  
  @param [Integer] m
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the Regular Cylindrical Conical Function
$P^{-m}_{-1/2 + i \lambda}(x)$
P^[-m]_[-1/2 + i \lambda](x) for x > -1, $m \ge -1$
m >= -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_cyl_reg(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_cyl_reg,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_conicalP_cyl_reg_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //m

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_conicalP_cyl_reg_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload conicalP_cyl_reg_e(m,lambda,x)
  
  @param [Integer] m
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Regular Cylindrical Conical Function
$P^{-m}_{-1/2 + i \lambda}(x)$
P^[-m]_[-1/2 + i \lambda](x) for x > -1, $m \ge -1$
m >= -1.
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_conicalP_cyl_reg_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_conicalP_cyl_reg_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //m
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_legendre_H3d_0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_legendre_H3d_0(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload legendre_H3d_0(lambda, eta)
  @param  [DFloat]   lambda
  @param  [DFloat]   eta
  @return [DFloat]   result

  These routines compute the zeroth radial eigenfunction of the Laplacian on the
3-dimensional hyperbolic space,
$$L^{H3d}_0(\lambda,\eta) := {\sin(\lambda\eta) \over \lambda\sinh(\eta)}$$
L^[H3d]_0(\lambda,\eta) := \sin(\lambda\eta)/(\lambda\sinh(\eta))
for $\eta \ge 0$
\eta >= 0.
In the flat limit this takes the form
$L^{H3d}_0(\lambda,\eta) = j_0(\lambda\eta)$
L^[H3d]_0(\lambda,\eta) = j_0(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d_0(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_0, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_H3d_0_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //eta
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_H3d_0_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_H3d_0_e(lambda,eta)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the zeroth radial eigenfunction of the Laplacian on the
3-dimensional hyperbolic space,
$$L^{H3d}_0(\lambda,\eta) := {\sin(\lambda\eta) \over \lambda\sinh(\eta)}$$
L^[H3d]_0(\lambda,\eta) := \sin(\lambda\eta)/(\lambda\sinh(\eta))
for $\eta \ge 0$
\eta >= 0.
In the flat limit this takes the form
$L^{H3d}_0(\lambda,\eta) = j_0(\lambda\eta)$
L^[H3d]_0(\lambda,\eta) = j_0(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d_0_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_legendre_H3d_1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_legendre_H3d_1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload legendre_H3d_1(lambda, eta)
  @param  [DFloat]   lambda
  @param  [DFloat]   eta
  @return [DFloat]   result

  These routines compute the first radial eigenfunction of the Laplacian on
the 3-dimensional hyperbolic space,
$$L^{H3d}_1(\lambda,\eta) := {1\over\sqrt{\lambda^2 + 1}} {\left(\sin(\lambda \eta)\over \lambda \sinh(\eta)\right)} \left(\coth(\eta) - \lambda \cot(\lambda\eta)\right)$$
L^[H3d]_1(\lambda,\eta) := 1/\sqrt[\lambda^2 + 1] \sin(\lambda \eta)/(\lambda \sinh(\eta)) (\coth(\eta) - \lambda \cot(\lambda\eta))
for $\eta \ge 0$
\eta >= 0.
In the flat limit this takes the form 
$L^{H3d}_1(\lambda,\eta) = j_1(\lambda\eta)$
L^[H3d]_1(\lambda,\eta) = j_1(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d_1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_H3d_1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //lambda
    c1 = *(double*)GET_PTR(lp,1); //eta
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_H3d_1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_H3d_1_e(lambda,eta)
  
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the first radial eigenfunction of the Laplacian on
the 3-dimensional hyperbolic space,
$$L^{H3d}_1(\lambda,\eta) := {1\over\sqrt{\lambda^2 + 1}} {\left(\sin(\lambda \eta)\over \lambda \sinh(\eta)\right)} \left(\coth(\eta) - \lambda \cot(\lambda\eta)\right)$$
L^[H3d]_1(\lambda,\eta) := 1/\sqrt[\lambda^2 + 1] \sin(\lambda \eta)/(\lambda \sinh(\eta)) (\coth(\eta) - \lambda \cot(\lambda\eta))
for $\eta \ge 0$
\eta >= 0.
In the flat limit this takes the form 
$L^{H3d}_1(\lambda,\eta) = j_1(\lambda\eta)$
L^[H3d]_1(\lambda,\eta) = j_1(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d_1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_H3d(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double c3;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //eta
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_legendre_H3d(c0,c1,c2);
    
    *(double*)GET_PTR(lp,2) = c3; //return
}

/*
  @overload legendre_H3d(l,lambda,eta)
  
  @param [Integer] l
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] eta
  @return [Numo::DFloat]  return

  These routines compute the l-th radial eigenfunction of the
Laplacian on the 3-dimensional hyperbolic space $\eta \ge 0$
\eta >= 0, $l \ge 0$
l >= 0. In the flat limit this takes the form
$L^{H3d}_l(\lambda,\eta) = j_l(\lambda\eta)$
L^[H3d]_l(\lambda,\eta) = j_l(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_H3d_e(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //l

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //eta
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_H3d_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,2) = c3.val; *(double*)GET_PTR(lp,3) = c3.err; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_H3d_e(l,lambda,eta)
  
  @param [Integer] l
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the l-th radial eigenfunction of the
Laplacian on the 3-dimensional hyperbolic space $\eta \ge 0$
\eta >= 0, $l \ge 0$
l >= 0. In the flat limit this takes the form
$L^{H3d}_l(\lambda,\eta) = j_l(\lambda\eta)$
L^[H3d]_l(\lambda,\eta) = j_l(\lambda\eta).
Exceptional Return Values: GSL_EDOM
*/
static VALUE
sf_s_legendre_H3d_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //l
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_legendre_H3d_array(na_loop_t *const lp)
{
    
    int c0;
    double c1;
    double c2;
    double *c3;
    int c4;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c0 = *(int*)(opt); //lmax

    
    c1 = *(double*)GET_PTR(lp,0); //lambda
    c2 = *(double*)GET_PTR(lp,1); //eta
    
    c3 = (double*)GET_PTR(lp,2); //result_array[]
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_legendre_H3d_array(c0,c1,c2,c3);
    
    
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload legendre_H3d_array(lmax,lambda,eta)
  
  @param [Integer] lmax
  @param [Numo::DFloat] lambda
  @param [Numo::DFloat] eta
  @return [[Numo::DFloat, Numo::Int]]  array of [result_array[], return]

  This function computes an array of radial eigenfunctions
$L^{H3d}_l( \lambda, \eta)$ 
L^[H3d]_l(\lambda, \eta) 
for $0 \le l \le lmax$
0 <= l <= lmax.
Exceptional Return Values:
*/
static VALUE
sf_s_legendre_H3d_array(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    
    size_t shape[1]; 

    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[2] = {{cDF,1,shape},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_legendre_H3d_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,2,ain,aout};
    
    void *opt;
    c0 = NUM2INT(v0); opt = &c0; //lmax
    
    shape[0] = gsl_sf_legendre_array_n(c0);    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x2.c"
static void
iter_sf_s_hyperg_0F1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3;
    ssize_t  s1, s2, s3;
    double   x, y, z;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        GET_DATA_STRIDE(p2,s2,double,y);
        z = gsl_sf_hyperg_0F1(x,y);
        SET_DATA_STRIDE(p3,s3,double,z);
    }
}

/*
  @overload hyperg_0F1(c, x)
  @param  [DFloat]   c
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the hypergeometric function ${}_0F_1(c,x)$
0F1(c,x).  
It is related to Bessel functions
0F1[c,x] =
Gamma[c]    x^(1/2(1-c)) I_(c-1)(2 Sqrt[x])
Gamma[c] (-x)^(1/2(1-c)) J_(c-1)(2 Sqrt[-x])
exceptions: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_hyperg_0F1(VALUE mod, VALUE v0, VALUE v1)
{
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_0F1, STRIDE_LOOP|NDF_EXTRACT, 2,1, ain,aout};

    return na_ndloop(&ndf, 2, v0, v1);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_0F1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    gsl_sf_result c2;
    int c3;
    

    
    c0 = *(double*)GET_PTR(lp,0); //c
    c1 = *(double*)GET_PTR(lp,1); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hyperg_0F1_e(c0,c1,&c2);
    
    *(double*)GET_PTR(lp,2) = c2.val; *(double*)GET_PTR(lp,3) = c2.err; //result
    *(int*)GET_PTR(lp,4) = c3; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_0F1_e(c,x)
  
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the hypergeometric function ${}_0F_1(c,x)$
0F1(c,x).  
It is related to Bessel functions
0F1[c,x] =
Gamma[c]    x^(1/2(1-c)) I_(c-1)(2 Sqrt[x])
Gamma[c] (-x)^(1/2(1-c)) J_(c-1)(2 Sqrt[-x])
exceptions: GSL_EOVRFLW, GSL_EUNDRFLW
*/
static VALUE
sf_s_hyperg_0F1_e(VALUE mod,VALUE v0,VALUE v1)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_0F1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,2,v0,v1); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_1F1_int(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //m
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hyperg_1F1_int(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload hyperg_1F1_int(m,n,x)
  
  @param [Integer] m
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the confluent hypergeometric function
${}_1F_1(m,n,x) = M(m,n,x)$
1F1(m,n,x) = M(m,n,x) for integer parameters m, n.
exceptions: 
*/
static VALUE
sf_s_hyperg_1F1_int(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_1F1_int,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //m
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_1F1_int_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //m
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_1F1_int_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,1) = c3.val; *(double*)GET_PTR(lp,2) = c3.err; //result
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_1F1_int_e(m,n,x)
  
  @param [Integer] m
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the confluent hypergeometric function
${}_1F_1(m,n,x) = M(m,n,x)$
1F1(m,n,x) = M(m,n,x) for integer parameters m, n.
exceptions: 
*/
static VALUE
sf_s_hyperg_1F1_int_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_1F1_int_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //m
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x3.c"
static void
iter_sf_s_hyperg_1F1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3, *p4;
    ssize_t  s1, s2, s3, s4;
    double   x1, x2, x3, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    INIT_PTR(lp, 3, p4, s4);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x1);
        GET_DATA_STRIDE(p2,s2,double,x2);
        GET_DATA_STRIDE(p3,s3,double,x3);
        y = gsl_sf_hyperg_1F1(x1,x2,x3);
        SET_DATA_STRIDE(p4,s4,double,y);
    }
}

/*
  @overload hyperg_1F1(a, b, x)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the confluent hypergeometric function
${}_1F_1(a,b,x) = M(a,b,x)$
1F1(a,b,x) = M(a,b,x) for general parameters a, b.
exceptions:
*/
static VALUE
sf_s_hyperg_1F1(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_1F1, STRIDE_LOOP|NDF_EXTRACT, 3,1, ain,aout};

    return na_ndloop(&ndf, 3, v0, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_1F1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_1F1_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,3) = c3.val; *(double*)GET_PTR(lp,4) = c3.err; //result
    *(int*)GET_PTR(lp,5) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_1F1_e(a,b,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the confluent hypergeometric function
${}_1F_1(a,b,x) = M(a,b,x)$
1F1(a,b,x) = M(a,b,x) for general parameters a, b.
exceptions:
*/
static VALUE
sf_s_hyperg_1F1_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_1F1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,3,v0,v1,v2); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_U_int(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //m
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_sf_hyperg_U_int(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload hyperg_U_int(m,n,x)
  
  @param [Integer] m
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the confluent hypergeometric function
U(m,n,x) for integer parameters m, n.
exceptions:
*/
static VALUE
sf_s_hyperg_U_int(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U_int,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //m
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_U_int_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //m
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_U_int_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,1) = c3.val; *(double*)GET_PTR(lp,2) = c3.err; //result
    *(int*)GET_PTR(lp,3) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_U_int_e(m,n,x)
  
  @param [Integer] m
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the confluent hypergeometric function
U(m,n,x) for integer parameters m, n.
exceptions:
*/
static VALUE
sf_s_hyperg_U_int_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U_int_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //m
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_U_int_e10_e(na_loop_t *const lp)
{
    
    int c0;
    int c1;
    double c2;
    gsl_sf_result_e10 c3;
    int c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c0 = *(int*)(opt[0]); //m
    c1 = *(int*)(opt[1]); //n
    

    
    c2 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_U_int_e10_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,1) = c3.val; *(double*)GET_PTR(lp,2) = c3.err; *(int*)GET_PTR(lp,3) = c3.e10; //result
    *(int*)GET_PTR(lp,4) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_U_int_e10_e(m,n,x)
  
  @param [Integer] m
  @param [Integer] n
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This routine computes the confluent hypergeometric function
U(m,n,x) for integer parameters m, n using the
gsl_sf_result_e10 type to return a result with extended range.
*/
static VALUE
sf_s_hyperg_U_int_e10_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    int c0;
    int c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U_int_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,4,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c0 = NUM2INT(v0); opt[0] = &c0; //m
    c1 = NUM2INT(v1); opt[1] = &c1; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v2); 
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x3.c"
static void
iter_sf_s_hyperg_U(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3, *p4;
    ssize_t  s1, s2, s3, s4;
    double   x1, x2, x3, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    INIT_PTR(lp, 3, p4, s4);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x1);
        GET_DATA_STRIDE(p2,s2,double,x2);
        GET_DATA_STRIDE(p3,s3,double,x3);
        y = gsl_sf_hyperg_U(x1,x2,x3);
        SET_DATA_STRIDE(p4,s4,double,y);
    }
}

/*
  @overload hyperg_U(a, b, x)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the confluent hypergeometric function U(a,b,x).
exceptions:
*/
static VALUE
sf_s_hyperg_U(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U, STRIDE_LOOP|NDF_EXTRACT, 3,1, ain,aout};

    return na_ndloop(&ndf, 3, v0, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_U_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_U_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,3) = c3.val; *(double*)GET_PTR(lp,4) = c3.err; //result
    *(int*)GET_PTR(lp,5) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_U_e(a,b,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the confluent hypergeometric function U(a,b,x).
exceptions:
*/
static VALUE
sf_s_hyperg_U_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,3,v0,v1,v2); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_U_e10_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_sf_result_e10 c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_U_e10_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,3) = c3.val; *(double*)GET_PTR(lp,4) = c3.err; *(int*)GET_PTR(lp,5) = c3.e10; //result
    *(int*)GET_PTR(lp,6) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_U_e10_e(a,b,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int, Numo::Int]]  array of [result.val, result.err, result.e10, return]

  This routine computes the confluent hypergeometric function
U(a,b,x) using the gsl_sf_result_e10 type to return a
result with extended range. 
exceptions:
*/
static VALUE
sf_s_hyperg_U_e10_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[4] = {{cDF,0},{cDF,0},{cI,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_U_e10_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,4,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,3,v0,v1,v2); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_2F1(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,4) = c4; //return
}

/*
  @overload hyperg_2F1(a,b,c,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the Gauss hypergeometric function 
${}_2F_1(a,b,c,x) = F(a,b,c,x)$
2F1(a,b,c,x) = F(a,b,c,x) for |x| < 1.  

If the arguments (a,b,c,x) are too close to a singularity then
the function can return the error code GSL_EMAXITER when the
series approximation converges too slowly.  This occurs in the region of
x=1, c - a - b = m for integer m.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_hyperg_2F1_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_2F1_e(a,b,c,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Gauss hypergeometric function 
${}_2F_1(a,b,c,x) = F(a,b,c,x)$
2F1(a,b,c,x) = F(a,b,c,x) for |x| < 1.  

If the arguments (a,b,c,x) are too close to a singularity then
the function can return the error code GSL_EMAXITER when the
series approximation converges too slowly.  This occurs in the region of
x=1, c - a - b = m for integer m.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_conj(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //aR
    c1 = *(double*)GET_PTR(lp,1); //aI
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_2F1_conj(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,4) = c4; //return
}

/*
  @overload hyperg_2F1_conj(aR,aI,c,x)
  
  @param [Numo::DFloat] aR
  @param [Numo::DFloat] aI
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the Gauss hypergeometric function
${}_2F_1(a_R + i a_I, aR - i aI, c, x)$
2F1(a_R + i a_I, a_R - i a_I, c, x) with complex parameters 
for |x| < 1.
*/
static VALUE
sf_s_hyperg_2F1_conj(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_conj,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_conj_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //aR
    c1 = *(double*)GET_PTR(lp,1); //aI
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_hyperg_2F1_conj_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_2F1_conj_e(aR,aI,c,x)
  
  @param [Numo::DFloat] aR
  @param [Numo::DFloat] aI
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Gauss hypergeometric function
${}_2F_1(a_R + i a_I, aR - i aI, c, x)$
2F1(a_R + i a_I, a_R - i a_I, c, x) with complex parameters 
for |x| < 1.
*/
static VALUE
sf_s_hyperg_2F1_conj_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_conj_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_renorm(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_2F1_renorm(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,4) = c4; //return
}

/*
  @overload hyperg_2F1_renorm(a,b,c,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the renormalized Gauss hypergeometric function
${}_2F_1(a,b,c,x) / \Gamma(c)$
2F1(a,b,c,x) / \Gamma(c) for |x| < 1.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1_renorm(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_renorm,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_renorm_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_hyperg_2F1_renorm_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_2F1_renorm_e(a,b,c,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the renormalized Gauss hypergeometric function
${}_2F_1(a,b,c,x) / \Gamma(c)$
2F1(a,b,c,x) / \Gamma(c) for |x| < 1.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1_renorm_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_renorm_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_conj_renorm(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //aR
    c1 = *(double*)GET_PTR(lp,1); //aI
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_2F1_conj_renorm(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,4) = c4; //return
}

/*
  @overload hyperg_2F1_conj_renorm(aR,aI,c,x)
  
  @param [Numo::DFloat] aR
  @param [Numo::DFloat] aI
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These routines compute the renormalized Gauss hypergeometric function
${}_2F_1(a_R + i a_I, a_R - i a_I, c, x) / \Gamma(c)$
2F1(a_R + i a_I, a_R - i a_I, c, x) / \Gamma(c) for |x| < 1.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1_conj_renorm(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_conj_renorm,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F1_conj_renorm_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    gsl_sf_result c4;
    int c5;
    

    
    c0 = *(double*)GET_PTR(lp,0); //aR
    c1 = *(double*)GET_PTR(lp,1); //aI
    c2 = *(double*)GET_PTR(lp,2); //c
    c3 = *(double*)GET_PTR(lp,3); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_sf_hyperg_2F1_conj_renorm_e(c0,c1,c2,c3,&c4);
    
    *(double*)GET_PTR(lp,4) = c4.val; *(double*)GET_PTR(lp,5) = c4.err; //result
    *(int*)GET_PTR(lp,6) = c5; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_2F1_conj_renorm_e(aR,aI,c,x)
  
  @param [Numo::DFloat] aR
  @param [Numo::DFloat] aI
  @param [Numo::DFloat] c
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the renormalized Gauss hypergeometric function
${}_2F_1(a_R + i a_I, a_R - i a_I, c, x) / \Gamma(c)$
2F1(a_R + i a_I, a_R - i a_I, c, x) / \Gamma(c) for |x| < 1.
exceptions:
*/
static VALUE
sf_s_hyperg_2F1_conj_renorm_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[4] = {{cDF,0},{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F1_conj_renorm_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    4,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,4,v0,v1,v2,v3); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat_x3.c"
static void
iter_sf_s_hyperg_2F0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2, *p3, *p4;
    ssize_t  s1, s2, s3, s4;
    double   x1, x2, x3, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);
    INIT_PTR(lp, 2, p3, s3);
    INIT_PTR(lp, 3, p4, s4);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x1);
        GET_DATA_STRIDE(p2,s2,double,x2);
        GET_DATA_STRIDE(p3,s3,double,x3);
        y = gsl_sf_hyperg_2F0(x1,x2,x3);
        SET_DATA_STRIDE(p4,s4,double,y);
    }
}

/*
  @overload hyperg_2F0(a, b, x)
  @param  [DFloat]   a
  @param  [DFloat]   b
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the hypergeometric function ${}_2F_0(a,b,x)$
2F0(a,b,x).  The series representation
is a divergent hypergeometric series.  However, for x < 0 we
have 
${}_2F_0(a,b,x) = (-1/x)^a U(a,1+a-b,-1/x)$
2F0(a,b,x) = (-1/x)^a U(a,1+a-b,-1/x)
exceptions: GSL_EDOM
*/
static VALUE
sf_s_hyperg_2F0(VALUE mod, VALUE v0, VALUE v1, VALUE v2)
{
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F0, STRIDE_LOOP|NDF_EXTRACT, 3,1, ain,aout};

    return na_ndloop(&ndf, 3, v0, v1, v2);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_hyperg_2F0_e(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    gsl_sf_result c3;
    int c4;
    

    
    c0 = *(double*)GET_PTR(lp,0); //a
    c1 = *(double*)GET_PTR(lp,1); //b
    c2 = *(double*)GET_PTR(lp,2); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_sf_hyperg_2F0_e(c0,c1,c2,&c3);
    
    *(double*)GET_PTR(lp,3) = c3.val; *(double*)GET_PTR(lp,4) = c3.err; //result
    *(int*)GET_PTR(lp,5) = c4; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload hyperg_2F0_e(a,b,x)
  
  @param [Numo::DFloat] a
  @param [Numo::DFloat] b
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the hypergeometric function ${}_2F_0(a,b,x)$
2F0(a,b,x).  The series representation
is a divergent hypergeometric series.  However, for x < 0 we
have 
${}_2F_0(a,b,x) = (-1/x)^a U(a,1+a-b,-1/x)$
2F0(a,b,x) = (-1/x)^a U(a,1+a-b,-1/x)
exceptions: GSL_EDOM
*/
static VALUE
sf_s_hyperg_2F0_e(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_hyperg_2F0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    3,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,3,v0,v1,v2); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_clausen(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_clausen(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload clausen(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These routines compute the Clausen integral Cl_2(x).
*/
static VALUE
sf_s_clausen(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_clausen, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_clausen_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_clausen_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload clausen_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These routines compute the Clausen integral Cl_2(x).
*/
static VALUE
sf_s_clausen_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_clausen_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_lambert_W0(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_lambert_W0(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lambert_W0(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These compute the principal branch of the Lambert W function, W_0(x).
exceptions: GSL_EDOM, GSL_EMAXITER
*/
static VALUE
sf_s_lambert_W0(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lambert_W0, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lambert_W0_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lambert_W0_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lambert_W0_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These compute the principal branch of the Lambert W function, W_0(x).
exceptions: GSL_EDOM, GSL_EMAXITER
*/
static VALUE
sf_s_lambert_W0_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lambert_W0_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/m_DFloat_f_DFloat.c"
static void
iter_sf_s_lambert_Wm1(na_loop_t *const lp)
{
    size_t   i;
    char    *p1, *p2;
    ssize_t  s1, s2;
    double   x, y;

    INIT_COUNTER(lp, i);
    INIT_PTR(lp, 0, p1, s1);
    INIT_PTR(lp, 1, p2, s2);

    for (; i--; ) {
        GET_DATA_STRIDE(p1,s1,double,x);
        y = gsl_sf_lambert_Wm1(x);
        SET_DATA_STRIDE(p2,s2,double,y);
    }
}

/*
  @overload lambert_Wm1(x)
  @param  [DFloat]   x
  @return [DFloat]   result

  These compute the secondary real-valued branch of the Lambert W function, 
$W_{-1}(x)$
W_[-1](x).
exceptions: GSL_EDOM, GSL_EMAXITER
*/
static VALUE
sf_s_lambert_Wm1(VALUE mod, VALUE v0)
{
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_sf_s_lambert_Wm1, STRIDE_LOOP|NDF_EXTRACT, 1,1, ain,aout};

    return na_ndloop(&ndf, 1, v0);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_sf_s_lambert_Wm1_e(na_loop_t *const lp)
{
    
    double c0;
    gsl_sf_result c1;
    int c2;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c2 = gsl_sf_lambert_Wm1_e(c0,&c1);
    
    *(double*)GET_PTR(lp,1) = c1.val; *(double*)GET_PTR(lp,2) = c1.err; //result
    *(int*)GET_PTR(lp,3) = c2; //return
#line 21 "../gen/tmpl/mod_func_noloop.c"
}

/*
  @overload lambert_Wm1_e(x)
  
  @param [Numo::DFloat] x
  @return [[Numo::DFloat, Numo::DFloat, Numo::Int]]  array of [result.val, result.err, return]

  These compute the secondary real-valued branch of the Lambert W function, 
$W_{-1}(x)$
W_[-1](x).
exceptions: GSL_EDOM, GSL_EMAXITER
*/
static VALUE
sf_s_lambert_Wm1_e(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[3] = {{cDF,0},{cDF,0},{cI,0}};
    ndfunc_t ndf = {iter_sf_s_lambert_Wm1_e,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,3,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/class.c"
/*
  class definition: Numo::GSL::Sf::Mathieu
*/

static VALUE cMathieu;

static void
sf_mathieu_free(void *ptr)
{
    gsl_sf_mathieu_free(ptr);
}

static size_t
sf_mathieu_memsize(const void *ptr)
{
    return sizeof(gsl_sf_mathieu_workspace);
}

static const rb_data_type_t sf_mathieu_data_type = {
    "Numo::GSL::Sf::Mathieu",
    {NULL, sf_mathieu_free, sf_mathieu_memsize,},
    0, 0, RUBY_TYPED_FREE_IMMEDIATELY|RUBY_TYPED_WB_PROTECTED
};



#line 1 "../gen/tmpl/c_new_sizet_double.c"

#line 5 "../gen/tmpl/c_new_sizet_double.c"
/*
  @overload new(n,qmax)
  @param  [Integer]  n
  @param  [Float]  qmax

  allocate instance of Mathieu class.

This function returns a workspace for the array versions of the
Mathieu routines.  The arguments n and qmax specify the
maximum order and q-value of Mathieu functions which can be
computed with this workspace.  

This is required in order to properly
terminate the infinite eigenvalue matrix for high precision solutions.
The characteristic values for all orders 0 \to n are stored in
the work structure array element work->char_value. */
static VALUE
sf_mathieu_s_new(VALUE self, VALUE v1, VALUE v2)
{
    gsl_sf_mathieu_workspace *w;
    w = gsl_sf_mathieu_alloc(NUM2SIZET(v1), NUM2DBL(v2));
    if (!w) {
        rb_raise(rb_eNoMemError,"fail to allocate struct");
    }
    return TypedData_Wrap_Struct(cMathieu, &sf_mathieu_data_type, (void*)w);
}


#line 1 "tmpl/c_DFloat_f_int_x2_DFloat.c"
static void
iter_sf_mathieu_a_array(na_loop_t *const lp)
{
    int    c0, c1;
    double c2, *c4;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //order_min
    c1 = *(int*)(opt[2]); //order_max
    c2 = *(double*)GET_PTR(lp,0); //q
    c4 =  (double*)GET_PTR(lp,1); //result_array[]
    gsl_sf_mathieu_a_array(c0,c1,c2,w,c4);
}

/*
  @overload a_array(order_min,order_max,q)

  @param [Integer]  order_min
  @param [Integer]  order_max
  @param [Numo::DFloat]  q
  @return [Numo::DFloat]  returns result_array[]

  These routines compute a series of Mathieu characteristic values
a_n(q), b_n(q) for n from order_min to
order_max inclusive, storing the results in the array result_array.
*/
static VALUE
sf_mathieu_a_array(VALUE self, VALUE v0, VALUE v1, VALUE v2)
{
    gsl_sf_mathieu_workspace *w;
    int nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_a_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,1,1,ain,aout};
    void *opt[3];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    nmin = NUM2INT(v0);
    nmax = NUM2INT(v1);
    opt[0] = w;
    opt[1] = &nmin;
    opt[2] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,1,v2);
}


#line 1 "tmpl/c_DFloat_f_int_x2_DFloat.c"
static void
iter_sf_mathieu_b_array(na_loop_t *const lp)
{
    int    c0, c1;
    double c2, *c4;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //order_min
    c1 = *(int*)(opt[2]); //order_max
    c2 = *(double*)GET_PTR(lp,0); //q
    c4 =  (double*)GET_PTR(lp,1); //result_array[]
    gsl_sf_mathieu_b_array(c0,c1,c2,w,c4);
}

/*
  @overload b_array(order_min,order_max,q)

  @param [Integer]  order_min
  @param [Integer]  order_max
  @param [Numo::DFloat]  q
  @return [Numo::DFloat]  returns result_array[]

  These routines compute a series of Mathieu characteristic values
a_n(q), b_n(q) for n from order_min to
order_max inclusive, storing the results in the array result_array.
*/
static VALUE
sf_mathieu_b_array(VALUE self, VALUE v0, VALUE v1, VALUE v2)
{
    gsl_sf_mathieu_workspace *w;
    int nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_b_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,1,1,ain,aout};
    void *opt[3];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    nmin = NUM2INT(v0);
    nmax = NUM2INT(v1);
    opt[0] = w;
    opt[1] = &nmin;
    opt[2] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,1,v2);
}


#line 1 "tmpl/c_DFloat_f_int_x2_DFloat_x2.c"
static void
iter_sf_mathieu_ce_array(na_loop_t *const lp)
{
    int    c0, c1;
    double c2, c3, *c5;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //nmin
    c1 = *(int*)(opt[2]); //nmax
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    c5 =  (double*)GET_PTR(lp,2); //result_array[]
    gsl_sf_mathieu_ce_array(c0,c1,c2,c3,w,c5);
}

/*
  @overload ce_array(nmin,nmax,q,x)

  @param [Integer]  nmin
  @param [Integer]  nmax
  @param [Numo::DFloat]  q
  @param [Numo::DFloat]  x
  @return [Numo::DFloat]  returns result_array[]

  These routines compute a series of the angular Mathieu functions
ce_n(q,x) and se_n(q,x) of order n from
nmin to nmax inclusive, storing the results in the array
result_array.
*/
static VALUE
sf_mathieu_ce_array(VALUE self, VALUE v0, VALUE v1, VALUE v2, VALUE v3)
{
    gsl_sf_mathieu_workspace *w;
    int nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_ce_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,2,1,ain,aout};
    void *opt[3];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    nmin = NUM2INT(v0);
    nmax = NUM2INT(v1);
    opt[0] = w;
    opt[1] = &nmin;
    opt[2] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,2,v2,v3);
}


#line 1 "tmpl/c_DFloat_f_int_x2_DFloat_x2.c"
static void
iter_sf_mathieu_se_array(na_loop_t *const lp)
{
    int    c0, c1;
    double c2, c3, *c5;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //nmin
    c1 = *(int*)(opt[2]); //nmax
    c2 = *(double*)GET_PTR(lp,0); //q
    c3 = *(double*)GET_PTR(lp,1); //x
    c5 =  (double*)GET_PTR(lp,2); //result_array[]
    gsl_sf_mathieu_se_array(c0,c1,c2,c3,w,c5);
}

/*
  @overload se_array(nmin,nmax,q,x)

  @param [Integer]  nmin
  @param [Integer]  nmax
  @param [Numo::DFloat]  q
  @param [Numo::DFloat]  x
  @return [Numo::DFloat]  returns result_array[]

  These routines compute a series of the angular Mathieu functions
ce_n(q,x) and se_n(q,x) of order n from
nmin to nmax inclusive, storing the results in the array
result_array.
*/
static VALUE
sf_mathieu_se_array(VALUE self, VALUE v0, VALUE v1, VALUE v2, VALUE v3)
{
    gsl_sf_mathieu_workspace *w;
    int nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_se_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,2,1,ain,aout};
    void *opt[3];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    nmin = NUM2INT(v0);
    nmax = NUM2INT(v1);
    opt[0] = w;
    opt[1] = &nmin;
    opt[2] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,2,v2,v3);
}


#line 1 "tmpl/c_DFloat_f_int_x3_DFloat_x2.c"
static void
iter_sf_mathieu_Mc_array(na_loop_t *const lp)
{
    int    c0, c1, c2;
    double c3, c4, *c6;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //j
    c1 = *(int*)(opt[2]); //nmin
    c2 = *(int*)(opt[3]); //nmax
    c3 = *(double*)GET_PTR(lp,0); //q
    c4 = *(double*)GET_PTR(lp,1); //x
    c6 =  (double*)GET_PTR(lp,2); //result_array[]
    gsl_sf_mathieu_Mc_array(c0,c1,c2,c3,c4,w,c6);
}

/*
  @overload Mc_array(j,nmin,nmax,q)

  @param [Integer]  j
  @param [Integer]  nmin
  @param [Numo::DFloat]  nmax
  @param [Numo::DFloat]  q
  @return [Numo::DFloat]  returns work

  These routines compute a series of the radial Mathieu functions of
kind j, with order from nmin to nmax inclusive, storing the
results in the array result_array.
*/
static VALUE
sf_mathieu_Mc_array(VALUE self, VALUE v0, VALUE v1, VALUE v2, VALUE v3, VALUE v4)
{
    gsl_sf_mathieu_workspace *w;
    int j, nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_Mc_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,2,1,ain,aout};
    void *opt[4];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    j    = NUM2INT(v0);
    nmin = NUM2INT(v1);
    nmax = NUM2INT(v2);
    opt[0] = w;
    opt[1] = &j; //j
    opt[2] = &nmin;
    opt[3] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,2,v3,v4);
}


#line 1 "tmpl/c_DFloat_f_int_x3_DFloat_x2.c"
static void
iter_sf_mathieu_Ms_array(na_loop_t *const lp)
{
    int    c0, c1, c2;
    double c3, c4, *c6;
    gsl_sf_mathieu_workspace *w;
    void **opt = (void**)(lp->opt_ptr);

    w  = (gsl_sf_mathieu_workspace*)(opt[0]);
    c0 = *(int*)(opt[1]); //j
    c1 = *(int*)(opt[2]); //nmin
    c2 = *(int*)(opt[3]); //nmax
    c3 = *(double*)GET_PTR(lp,0); //q
    c4 = *(double*)GET_PTR(lp,1); //x
    c6 =  (double*)GET_PTR(lp,2); //result_array[]
    gsl_sf_mathieu_Ms_array(c0,c1,c2,c3,c4,w,c6);
}

/*
  @overload Ms_array(j,nmin,nmax,q)

  @param [Integer]  j
  @param [Integer]  nmin
  @param [Numo::DFloat]  nmax
  @param [Numo::DFloat]  q
  @return [Numo::DFloat]  returns work

  These routines compute a series of the radial Mathieu functions of
kind j, with order from nmin to nmax inclusive, storing the
results in the array result_array.
*/
static VALUE
sf_mathieu_Ms_array(VALUE self, VALUE v0, VALUE v1, VALUE v2, VALUE v3, VALUE v4)
{
    gsl_sf_mathieu_workspace *w;
    int j, nmin, nmax;
    size_t shape[1];
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,1,shape}};
    ndfunc_t ndf = {iter_sf_mathieu_Ms_array,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,2,1,ain,aout};
    void *opt[4];

    TypedData_Get_Struct(self, gsl_sf_mathieu_workspace, &sf_mathieu_data_type, w);

    j    = NUM2INT(v0);
    nmin = NUM2INT(v1);
    nmax = NUM2INT(v2);
    opt[0] = w;
    opt[1] = &j; //j
    opt[2] = &nmin;
    opt[3] = &nmax;
    if (nmin<0 || nmax<0 || nmin>nmax) {
        rb_raise(rb_eArgError,"should be nmin>=0 && nmax>=0 && nmin<=nmax");
    }
    shape[0] = nmax-nmin+1;
    return na_ndloop3(&ndf,opt,2,v3,v4);
}


#line 28 "../gen/tmpl/lib.c"
void
Init_sf(void)
{
    VALUE mN;
    mN = rb_define_module("Numo");
    mG = rb_define_module_under(mN, "GSL");

    


#line 1 "../gen/tmpl/init_module.c"

    /*
      Document-module: Numo::GSL::Sf
      
    */
    {
    
    mSf = rb_define_module_under(mG, "Sf");
    
    
    rb_define_module_function(mSf, "log", sf_s_log, 1);
    rb_define_module_function(mSf, "log_e", sf_s_log_e, 1);
    rb_define_module_function(mSf, "log_abs", sf_s_log_abs, 1);
    rb_define_module_function(mSf, "log_abs_e", sf_s_log_abs_e, 1);
    rb_define_module_function(mSf, "complex_log_e", sf_s_complex_log_e, 2);
    rb_define_module_function(mSf, "log_1plusx", sf_s_log_1plusx, 1);
    rb_define_module_function(mSf, "log_1plusx_e", sf_s_log_1plusx_e, 1);
    rb_define_module_function(mSf, "log_1plusx_mx", sf_s_log_1plusx_mx, 1);
    rb_define_module_function(mSf, "log_1plusx_mx_e", sf_s_log_1plusx_mx_e, 1);
    rb_define_module_function(mSf, "sin", sf_s_sin, 1);
    rb_define_module_function(mSf, "sin_e", sf_s_sin_e, 1);
    rb_define_module_function(mSf, "cos", sf_s_cos, 1);
    rb_define_module_function(mSf, "cos_e", sf_s_cos_e, 1);
    rb_define_module_function(mSf, "hypot", sf_s_hypot, 2);
    rb_define_module_function(mSf, "hypot_e", sf_s_hypot_e, 2);
    rb_define_module_function(mSf, "sinc", sf_s_sinc, 1);
    rb_define_module_function(mSf, "sinc_e", sf_s_sinc_e, 1);
    rb_define_module_function(mSf, "complex_sin_e", sf_s_complex_sin_e, 2);
    rb_define_module_function(mSf, "complex_cos_e", sf_s_complex_cos_e, 2);
    rb_define_module_function(mSf, "complex_logsin_e", sf_s_complex_logsin_e, 2);
    rb_define_module_function(mSf, "lnsinh", sf_s_lnsinh, 1);
    rb_define_module_function(mSf, "lnsinh_e", sf_s_lnsinh_e, 1);
    rb_define_module_function(mSf, "lncosh", sf_s_lncosh, 1);
    rb_define_module_function(mSf, "lncosh_e", sf_s_lncosh_e, 1);
    rb_define_module_function(mSf, "polar_to_rect", sf_s_polar_to_rect, 2);
    rb_define_module_function(mSf, "rect_to_polar", sf_s_rect_to_polar, 2);
    rb_define_module_function(mSf, "angle_restrict_symm", sf_s_angle_restrict_symm, 1);
    rb_define_module_function(mSf, "angle_restrict_pos", sf_s_angle_restrict_pos, 1);
    rb_define_module_function(mSf, "sin_err_e", sf_s_sin_err_e, 2);
    rb_define_module_function(mSf, "cos_err_e", sf_s_cos_err_e, 2);
    rb_define_module_function(mSf, "gamma", sf_s_gamma, 1);
    rb_define_module_function(mSf, "gamma_e", sf_s_gamma_e, 1);
    rb_define_module_function(mSf, "lngamma", sf_s_lngamma, 1);
    rb_define_module_function(mSf, "lngamma_e", sf_s_lngamma_e, 1);
    rb_define_module_function(mSf, "lngamma_sgn_e", sf_s_lngamma_sgn_e, 1);
    rb_define_module_function(mSf, "gammastar", sf_s_gammastar, 1);
    rb_define_module_function(mSf, "gammastar_e", sf_s_gammastar_e, 1);
    rb_define_module_function(mSf, "gammainv", sf_s_gammainv, 1);
    rb_define_module_function(mSf, "gammainv_e", sf_s_gammainv_e, 1);
    rb_define_module_function(mSf, "lngamma_complex_e", sf_s_lngamma_complex_e, 2);
    rb_define_module_function(mSf, "fact", sf_s_fact, 1);
    rb_define_module_function(mSf, "fact_e", sf_s_fact_e, 1);
    rb_define_module_function(mSf, "doublefact", sf_s_doublefact, 1);
    rb_define_module_function(mSf, "doublefact_e", sf_s_doublefact_e, 1);
    rb_define_module_function(mSf, "lnfact", sf_s_lnfact, 1);
    rb_define_module_function(mSf, "lnfact_e", sf_s_lnfact_e, 1);
    rb_define_module_function(mSf, "lndoublefact", sf_s_lndoublefact, 1);
    rb_define_module_function(mSf, "lndoublefact_e", sf_s_lndoublefact_e, 1);
    rb_define_module_function(mSf, "choose", sf_s_choose, 2);
    rb_define_module_function(mSf, "choose_e", sf_s_choose_e, 2);
    rb_define_module_function(mSf, "lnchoose", sf_s_lnchoose, 2);
    rb_define_module_function(mSf, "lnchoose_e", sf_s_lnchoose_e, 2);
    rb_define_module_function(mSf, "taylorcoeff", sf_s_taylorcoeff, 2);
    rb_define_module_function(mSf, "taylorcoeff_e", sf_s_taylorcoeff_e, 2);
    rb_define_module_function(mSf, "poch", sf_s_poch, 2);
    rb_define_module_function(mSf, "poch_e", sf_s_poch_e, 2);
    rb_define_module_function(mSf, "lnpoch", sf_s_lnpoch, 2);
    rb_define_module_function(mSf, "lnpoch_e", sf_s_lnpoch_e, 2);
    rb_define_module_function(mSf, "lnpoch_sgn_e", sf_s_lnpoch_sgn_e, 2);
    rb_define_module_function(mSf, "pochrel", sf_s_pochrel, 2);
    rb_define_module_function(mSf, "pochrel_e", sf_s_pochrel_e, 2);
    rb_define_module_function(mSf, "gamma_inc", sf_s_gamma_inc, 2);
    rb_define_module_function(mSf, "gamma_inc_e", sf_s_gamma_inc_e, 2);
    rb_define_module_function(mSf, "gamma_inc_Q", sf_s_gamma_inc_Q, 2);
    rb_define_module_function(mSf, "gamma_inc_Q_e", sf_s_gamma_inc_Q_e, 2);
    rb_define_module_function(mSf, "gamma_inc_P", sf_s_gamma_inc_P, 2);
    rb_define_module_function(mSf, "gamma_inc_P_e", sf_s_gamma_inc_P_e, 2);
    rb_define_module_function(mSf, "beta", sf_s_beta, 2);
    rb_define_module_function(mSf, "beta_e", sf_s_beta_e, 2);
    rb_define_module_function(mSf, "lnbeta", sf_s_lnbeta, 2);
    rb_define_module_function(mSf, "lnbeta_e", sf_s_lnbeta_e, 2);
    rb_define_module_function(mSf, "beta_inc", sf_s_beta_inc, 3);
    rb_define_module_function(mSf, "beta_inc_e", sf_s_beta_inc_e, 3);
    rb_define_module_function(mSf, "transport_2", sf_s_transport_2, 1);
    rb_define_module_function(mSf, "transport_2_e", sf_s_transport_2_e, 1);
    rb_define_module_function(mSf, "transport_3", sf_s_transport_3, 1);
    rb_define_module_function(mSf, "transport_3_e", sf_s_transport_3_e, 1);
    rb_define_module_function(mSf, "transport_4", sf_s_transport_4, 1);
    rb_define_module_function(mSf, "transport_4_e", sf_s_transport_4_e, 1);
    rb_define_module_function(mSf, "transport_5", sf_s_transport_5, 1);
    rb_define_module_function(mSf, "transport_5_e", sf_s_transport_5_e, 1);
    rb_define_module_function(mSf, "ellint_Kcomp", sf_s_ellint_Kcomp, -1);
    rb_define_module_function(mSf, "ellint_Kcomp_e", sf_s_ellint_Kcomp_e, -1);
    rb_define_module_function(mSf, "ellint_Ecomp", sf_s_ellint_Ecomp, -1);
    rb_define_module_function(mSf, "ellint_Ecomp_e", sf_s_ellint_Ecomp_e, -1);
    rb_define_module_function(mSf, "ellint_Pcomp", sf_s_ellint_Pcomp, -1);
    rb_define_module_function(mSf, "ellint_Pcomp_e", sf_s_ellint_Pcomp_e, -1);
    rb_define_module_function(mSf, "ellint_F", sf_s_ellint_F, -1);
    rb_define_module_function(mSf, "ellint_F_e", sf_s_ellint_F_e, -1);
    rb_define_module_function(mSf, "ellint_E", sf_s_ellint_E, -1);
    rb_define_module_function(mSf, "ellint_E_e", sf_s_ellint_E_e, -1);
    rb_define_module_function(mSf, "ellint_P", sf_s_ellint_P, -1);
    rb_define_module_function(mSf, "ellint_P_e", sf_s_ellint_P_e, -1);
    rb_define_module_function(mSf, "ellint_D", sf_s_ellint_D, -1);
    rb_define_module_function(mSf, "ellint_D_e", sf_s_ellint_D_e, -1);
    rb_define_module_function(mSf, "ellint_RC", sf_s_ellint_RC, -1);
    rb_define_module_function(mSf, "ellint_RC_e", sf_s_ellint_RC_e, -1);
    rb_define_module_function(mSf, "ellint_RD", sf_s_ellint_RD, -1);
    rb_define_module_function(mSf, "ellint_RD_e", sf_s_ellint_RD_e, -1);
    rb_define_module_function(mSf, "ellint_RF", sf_s_ellint_RF, -1);
    rb_define_module_function(mSf, "ellint_RF_e", sf_s_ellint_RF_e, -1);
    rb_define_module_function(mSf, "ellint_RJ", sf_s_ellint_RJ, -1);
    rb_define_module_function(mSf, "ellint_RJ_e", sf_s_ellint_RJ_e, -1);
    rb_define_module_function(mSf, "expint_E1", sf_s_expint_E1, 1);
    rb_define_module_function(mSf, "expint_E1_e", sf_s_expint_E1_e, 1);
    rb_define_module_function(mSf, "expint_E2", sf_s_expint_E2, 1);
    rb_define_module_function(mSf, "expint_E2_e", sf_s_expint_E2_e, 1);
    rb_define_module_function(mSf, "expint_En", sf_s_expint_En, 2);
    rb_define_module_function(mSf, "expint_En_e", sf_s_expint_En_e, 2);
    rb_define_module_function(mSf, "expint_Ei", sf_s_expint_Ei, 1);
    rb_define_module_function(mSf, "expint_Ei_e", sf_s_expint_Ei_e, 1);
    rb_define_module_function(mSf, "Shi", sf_s_Shi, 1);
    rb_define_module_function(mSf, "Shi_e", sf_s_Shi_e, 1);
    rb_define_module_function(mSf, "Chi", sf_s_Chi, 1);
    rb_define_module_function(mSf, "Chi_e", sf_s_Chi_e, 1);
    rb_define_module_function(mSf, "expint_3", sf_s_expint_3, 1);
    rb_define_module_function(mSf, "expint_3_e", sf_s_expint_3_e, 1);
    rb_define_module_function(mSf, "Si", sf_s_Si, 1);
    rb_define_module_function(mSf, "Si_e", sf_s_Si_e, 1);
    rb_define_module_function(mSf, "Ci", sf_s_Ci, 1);
    rb_define_module_function(mSf, "Ci_e", sf_s_Ci_e, 1);
    rb_define_module_function(mSf, "atanint", sf_s_atanint, 1);
    rb_define_module_function(mSf, "atanint_e", sf_s_atanint_e, 1);
    rb_define_module_function(mSf, "laguerre_1", sf_s_laguerre_1, 2);
    rb_define_module_function(mSf, "laguerre_2", sf_s_laguerre_2, 2);
    rb_define_module_function(mSf, "laguerre_3", sf_s_laguerre_3, 2);
    rb_define_module_function(mSf, "laguerre_1_e", sf_s_laguerre_1_e, 2);
    rb_define_module_function(mSf, "laguerre_2_e", sf_s_laguerre_2_e, 2);
    rb_define_module_function(mSf, "laguerre_3_e", sf_s_laguerre_3_e, 2);
    rb_define_module_function(mSf, "laguerre_n", sf_s_laguerre_n, 3);
    rb_define_module_function(mSf, "laguerre_n_e", sf_s_laguerre_n_e, 3);
    rb_define_module_function(mSf, "gegenpoly_1", sf_s_gegenpoly_1, 2);
    rb_define_module_function(mSf, "gegenpoly_2", sf_s_gegenpoly_2, 2);
    rb_define_module_function(mSf, "gegenpoly_3", sf_s_gegenpoly_3, 2);
    rb_define_module_function(mSf, "gegenpoly_1_e", sf_s_gegenpoly_1_e, 2);
    rb_define_module_function(mSf, "gegenpoly_2_e", sf_s_gegenpoly_2_e, 2);
    rb_define_module_function(mSf, "gegenpoly_3_e", sf_s_gegenpoly_3_e, 2);
    rb_define_module_function(mSf, "gegenpoly_n", sf_s_gegenpoly_n, 3);
    rb_define_module_function(mSf, "gegenpoly_n_e", sf_s_gegenpoly_n_e, 3);
    rb_define_module_function(mSf, "gegenpoly_array", sf_s_gegenpoly_array, 3);
    rb_define_module_function(mSf, "elljac_e", sf_s_elljac_e, 2);
    rb_define_module_function(mSf, "coupling_3j", sf_s_coupling_3j, 6);
    rb_define_module_function(mSf, "coupling_3j_e", sf_s_coupling_3j_e, 6);
    rb_define_module_function(mSf, "coupling_6j", sf_s_coupling_6j, 6);
    rb_define_module_function(mSf, "coupling_6j_e", sf_s_coupling_6j_e, 6);
    rb_define_module_function(mSf, "coupling_9j", sf_s_coupling_9j, 9);
    rb_define_module_function(mSf, "coupling_9j_e", sf_s_coupling_9j_e, 9);
    rb_define_module_function(mSf, "psi_int", sf_s_psi_int, 1);
    rb_define_module_function(mSf, "psi_int_e", sf_s_psi_int_e, 1);
    rb_define_module_function(mSf, "psi", sf_s_psi, 1);
    rb_define_module_function(mSf, "psi_e", sf_s_psi_e, 1);
    rb_define_module_function(mSf, "psi_1piy", sf_s_psi_1piy, 1);
    rb_define_module_function(mSf, "psi_1piy_e", sf_s_psi_1piy_e, 1);
    rb_define_module_function(mSf, "psi_1_int", sf_s_psi_1_int, 1);
    rb_define_module_function(mSf, "psi_1_int_e", sf_s_psi_1_int_e, 1);
    rb_define_module_function(mSf, "psi_1", sf_s_psi_1, 1);
    rb_define_module_function(mSf, "psi_1_e", sf_s_psi_1_e, 1);
    rb_define_module_function(mSf, "psi_n", sf_s_psi_n, 2);
    rb_define_module_function(mSf, "psi_n_e", sf_s_psi_n_e, 2);
    rb_define_module_function(mSf, "debye_1", sf_s_debye_1, 1);
    rb_define_module_function(mSf, "debye_1_e", sf_s_debye_1_e, 1);
    rb_define_module_function(mSf, "debye_2", sf_s_debye_2, 1);
    rb_define_module_function(mSf, "debye_2_e", sf_s_debye_2_e, 1);
    rb_define_module_function(mSf, "debye_3", sf_s_debye_3, 1);
    rb_define_module_function(mSf, "debye_3_e", sf_s_debye_3_e, 1);
    rb_define_module_function(mSf, "debye_4", sf_s_debye_4, 1);
    rb_define_module_function(mSf, "debye_4_e", sf_s_debye_4_e, 1);
    rb_define_module_function(mSf, "debye_5", sf_s_debye_5, 1);
    rb_define_module_function(mSf, "debye_5_e", sf_s_debye_5_e, 1);
    rb_define_module_function(mSf, "debye_6", sf_s_debye_6, 1);
    rb_define_module_function(mSf, "debye_6_e", sf_s_debye_6_e, 1);
    rb_define_module_function(mSf, "erf", sf_s_erf, 1);
    rb_define_module_function(mSf, "erf_e", sf_s_erf_e, 1);
    rb_define_module_function(mSf, "erfc", sf_s_erfc, 1);
    rb_define_module_function(mSf, "erfc_e", sf_s_erfc_e, 1);
    rb_define_module_function(mSf, "log_erfc", sf_s_log_erfc, 1);
    rb_define_module_function(mSf, "log_erfc_e", sf_s_log_erfc_e, 1);
    rb_define_module_function(mSf, "erf_Z", sf_s_erf_Z, 1);
    rb_define_module_function(mSf, "erf_Z_e", sf_s_erf_Z_e, 1);
    rb_define_module_function(mSf, "erf_Q", sf_s_erf_Q, 1);
    rb_define_module_function(mSf, "erf_Q_e", sf_s_erf_Q_e, 1);
    rb_define_module_function(mSf, "hazard", sf_s_hazard, 1);
    rb_define_module_function(mSf, "hazard_e", sf_s_hazard_e, 1);
    rb_define_module_function(mSf, "multiply_e", sf_s_multiply_e, 2);
    rb_define_module_function(mSf, "multiply_err_e", sf_s_multiply_err_e, 4);
    rb_define_module_function(mSf, "exp", sf_s_exp, 1);
    rb_define_module_function(mSf, "exp_e", sf_s_exp_e, 1);
    rb_define_module_function(mSf, "exp_e10_e", sf_s_exp_e10_e, 1);
    rb_define_module_function(mSf, "exp_mult", sf_s_exp_mult, 2);
    rb_define_module_function(mSf, "exp_mult_e", sf_s_exp_mult_e, 2);
    rb_define_module_function(mSf, "exp_mult_e10_e", sf_s_exp_mult_e10_e, 2);
    rb_define_module_function(mSf, "expm1", sf_s_expm1, 1);
    rb_define_module_function(mSf, "expm1_e", sf_s_expm1_e, 1);
    rb_define_module_function(mSf, "exprel", sf_s_exprel, 1);
    rb_define_module_function(mSf, "exprel_e", sf_s_exprel_e, 1);
    rb_define_module_function(mSf, "exprel_2", sf_s_exprel_2, 1);
    rb_define_module_function(mSf, "exprel_2_e", sf_s_exprel_2_e, 1);
    rb_define_module_function(mSf, "exprel_n", sf_s_exprel_n, 2);
    rb_define_module_function(mSf, "exprel_n_e", sf_s_exprel_n_e, 2);
    rb_define_module_function(mSf, "exp_err_e", sf_s_exp_err_e, 2);
    rb_define_module_function(mSf, "exp_err_e10_e", sf_s_exp_err_e10_e, 2);
    rb_define_module_function(mSf, "exp_mult_err_e", sf_s_exp_mult_err_e, 4);
    rb_define_module_function(mSf, "exp_mult_err_e10_e", sf_s_exp_mult_err_e10_e, 4);
    rb_define_module_function(mSf, "dawson", sf_s_dawson, 1);
    rb_define_module_function(mSf, "dawson_e", sf_s_dawson_e, 1);
    rb_define_module_function(mSf, "pow_int", sf_s_pow_int, 2);
    rb_define_module_function(mSf, "pow_int_e", sf_s_pow_int_e, 2);
    rb_define_module_function(mSf, "synchrotron_1", sf_s_synchrotron_1, 1);
    rb_define_module_function(mSf, "synchrotron_1_e", sf_s_synchrotron_1_e, 1);
    rb_define_module_function(mSf, "synchrotron_2", sf_s_synchrotron_2, 1);
    rb_define_module_function(mSf, "synchrotron_2_e", sf_s_synchrotron_2_e, 1);
    rb_define_module_function(mSf, "mathieu_a", sf_s_mathieu_a, 2);
    rb_define_module_function(mSf, "mathieu_a_e", sf_s_mathieu_a_e, 2);
    rb_define_module_function(mSf, "mathieu_b", sf_s_mathieu_b, 2);
    rb_define_module_function(mSf, "mathieu_b_e", sf_s_mathieu_b_e, 2);
    rb_define_module_function(mSf, "mathieu_ce", sf_s_mathieu_ce, 3);
    rb_define_module_function(mSf, "mathieu_ce_e", sf_s_mathieu_ce_e, 3);
    rb_define_module_function(mSf, "mathieu_se", sf_s_mathieu_se, 3);
    rb_define_module_function(mSf, "mathieu_se_e", sf_s_mathieu_se_e, 3);
    rb_define_module_function(mSf, "mathieu_Mc", sf_s_mathieu_Mc, 4);
    rb_define_module_function(mSf, "mathieu_Mc_e", sf_s_mathieu_Mc_e, 4);
    rb_define_module_function(mSf, "mathieu_Ms", sf_s_mathieu_Ms, 4);
    rb_define_module_function(mSf, "mathieu_Ms_e", sf_s_mathieu_Ms_e, 4);
    rb_define_module_function(mSf, "fermi_dirac_m1", sf_s_fermi_dirac_m1, 1);
    rb_define_module_function(mSf, "fermi_dirac_m1_e", sf_s_fermi_dirac_m1_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_0", sf_s_fermi_dirac_0, 1);
    rb_define_module_function(mSf, "fermi_dirac_0_e", sf_s_fermi_dirac_0_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_1", sf_s_fermi_dirac_1, 1);
    rb_define_module_function(mSf, "fermi_dirac_1_e", sf_s_fermi_dirac_1_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_2", sf_s_fermi_dirac_2, 1);
    rb_define_module_function(mSf, "fermi_dirac_2_e", sf_s_fermi_dirac_2_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_int", sf_s_fermi_dirac_int, 2);
    rb_define_module_function(mSf, "fermi_dirac_int_e", sf_s_fermi_dirac_int_e, 2);
    rb_define_module_function(mSf, "fermi_dirac_mhalf", sf_s_fermi_dirac_mhalf, 1);
    rb_define_module_function(mSf, "fermi_dirac_mhalf_e", sf_s_fermi_dirac_mhalf_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_half", sf_s_fermi_dirac_half, 1);
    rb_define_module_function(mSf, "fermi_dirac_half_e", sf_s_fermi_dirac_half_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_3half", sf_s_fermi_dirac_3half, 1);
    rb_define_module_function(mSf, "fermi_dirac_3half_e", sf_s_fermi_dirac_3half_e, 1);
    rb_define_module_function(mSf, "fermi_dirac_inc_0", sf_s_fermi_dirac_inc_0, 2);
    rb_define_module_function(mSf, "fermi_dirac_inc_0_e", sf_s_fermi_dirac_inc_0_e, 2);
    rb_define_module_function(mSf, "dilog", sf_s_dilog, 1);
    rb_define_module_function(mSf, "dilog_e", sf_s_dilog_e, 1);
    rb_define_module_function(mSf, "complex_dilog_e", sf_s_complex_dilog_e, 2);
    rb_define_module_function(mSf, "bessel_J0", sf_s_bessel_J0, 1);
    rb_define_module_function(mSf, "bessel_J0_e", sf_s_bessel_J0_e, 1);
    rb_define_module_function(mSf, "bessel_J1", sf_s_bessel_J1, 1);
    rb_define_module_function(mSf, "bessel_J1_e", sf_s_bessel_J1_e, 1);
    rb_define_module_function(mSf, "bessel_Jn", sf_s_bessel_Jn, 2);
    rb_define_module_function(mSf, "bessel_Jn_e", sf_s_bessel_Jn_e, 2);
    rb_define_module_function(mSf, "bessel_Jn_array", sf_s_bessel_Jn_array, 3);
    rb_define_module_function(mSf, "bessel_Y0", sf_s_bessel_Y0, 1);
    rb_define_module_function(mSf, "bessel_Y0_e", sf_s_bessel_Y0_e, 1);
    rb_define_module_function(mSf, "bessel_Y1", sf_s_bessel_Y1, 1);
    rb_define_module_function(mSf, "bessel_Y1_e", sf_s_bessel_Y1_e, 1);
    rb_define_module_function(mSf, "bessel_Yn", sf_s_bessel_Yn, 2);
    rb_define_module_function(mSf, "bessel_Yn_e", sf_s_bessel_Yn_e, 2);
    rb_define_module_function(mSf, "bessel_Yn_array", sf_s_bessel_Yn_array, 3);
    rb_define_module_function(mSf, "bessel_I0", sf_s_bessel_I0, 1);
    rb_define_module_function(mSf, "bessel_I0_e", sf_s_bessel_I0_e, 1);
    rb_define_module_function(mSf, "bessel_I1", sf_s_bessel_I1, 1);
    rb_define_module_function(mSf, "bessel_I1_e", sf_s_bessel_I1_e, 1);
    rb_define_module_function(mSf, "bessel_In", sf_s_bessel_In, 2);
    rb_define_module_function(mSf, "bessel_In_e", sf_s_bessel_In_e, 2);
    rb_define_module_function(mSf, "bessel_In_array", sf_s_bessel_In_array, 3);
    rb_define_module_function(mSf, "bessel_I0_scaled", sf_s_bessel_I0_scaled, 1);
    rb_define_module_function(mSf, "bessel_I0_scaled_e", sf_s_bessel_I0_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_I1_scaled", sf_s_bessel_I1_scaled, 1);
    rb_define_module_function(mSf, "bessel_I1_scaled_e", sf_s_bessel_I1_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_In_scaled", sf_s_bessel_In_scaled, 2);
    rb_define_module_function(mSf, "bessel_In_scaled_e", sf_s_bessel_In_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_In_scaled_array", sf_s_bessel_In_scaled_array, 3);
    rb_define_module_function(mSf, "bessel_K0", sf_s_bessel_K0, 1);
    rb_define_module_function(mSf, "bessel_K0_e", sf_s_bessel_K0_e, 1);
    rb_define_module_function(mSf, "bessel_K1", sf_s_bessel_K1, 1);
    rb_define_module_function(mSf, "bessel_K1_e", sf_s_bessel_K1_e, 1);
    rb_define_module_function(mSf, "bessel_Kn", sf_s_bessel_Kn, 2);
    rb_define_module_function(mSf, "bessel_Kn_e", sf_s_bessel_Kn_e, 2);
    rb_define_module_function(mSf, "bessel_Kn_array", sf_s_bessel_Kn_array, 3);
    rb_define_module_function(mSf, "bessel_K0_scaled", sf_s_bessel_K0_scaled, 1);
    rb_define_module_function(mSf, "bessel_K0_scaled_e", sf_s_bessel_K0_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_K1_scaled", sf_s_bessel_K1_scaled, 1);
    rb_define_module_function(mSf, "bessel_K1_scaled_e", sf_s_bessel_K1_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_Kn_scaled", sf_s_bessel_Kn_scaled, 2);
    rb_define_module_function(mSf, "bessel_Kn_scaled_e", sf_s_bessel_Kn_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_Kn_scaled_array", sf_s_bessel_Kn_scaled_array, 3);
    rb_define_module_function(mSf, "bessel_j0", sf_s_bessel_j0, 1);
    rb_define_module_function(mSf, "bessel_j0_e", sf_s_bessel_j0_e, 1);
    rb_define_module_function(mSf, "bessel_j1", sf_s_bessel_j1, 1);
    rb_define_module_function(mSf, "bessel_j1_e", sf_s_bessel_j1_e, 1);
    rb_define_module_function(mSf, "bessel_j2", sf_s_bessel_j2, 1);
    rb_define_module_function(mSf, "bessel_j2_e", sf_s_bessel_j2_e, 1);
    rb_define_module_function(mSf, "bessel_jl", sf_s_bessel_jl, 2);
    rb_define_module_function(mSf, "bessel_jl_e", sf_s_bessel_jl_e, 2);
    rb_define_module_function(mSf, "bessel_jl_array", sf_s_bessel_jl_array, 2);
    rb_define_module_function(mSf, "bessel_jl_steed_array", sf_s_bessel_jl_steed_array, 2);
    rb_define_module_function(mSf, "bessel_y0", sf_s_bessel_y0, 1);
    rb_define_module_function(mSf, "bessel_y0_e", sf_s_bessel_y0_e, 1);
    rb_define_module_function(mSf, "bessel_y1", sf_s_bessel_y1, 1);
    rb_define_module_function(mSf, "bessel_y1_e", sf_s_bessel_y1_e, 1);
    rb_define_module_function(mSf, "bessel_y2", sf_s_bessel_y2, 1);
    rb_define_module_function(mSf, "bessel_y2_e", sf_s_bessel_y2_e, 1);
    rb_define_module_function(mSf, "bessel_yl", sf_s_bessel_yl, 2);
    rb_define_module_function(mSf, "bessel_yl_e", sf_s_bessel_yl_e, 2);
    rb_define_module_function(mSf, "bessel_yl_array", sf_s_bessel_yl_array, 2);
    rb_define_module_function(mSf, "bessel_i0_scaled", sf_s_bessel_i0_scaled, 1);
    rb_define_module_function(mSf, "bessel_i0_scaled_e", sf_s_bessel_i0_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_i1_scaled", sf_s_bessel_i1_scaled, 1);
    rb_define_module_function(mSf, "bessel_i1_scaled_e", sf_s_bessel_i1_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_i2_scaled", sf_s_bessel_i2_scaled, 1);
    rb_define_module_function(mSf, "bessel_i2_scaled_e", sf_s_bessel_i2_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_il_scaled", sf_s_bessel_il_scaled, 2);
    rb_define_module_function(mSf, "bessel_il_scaled_e", sf_s_bessel_il_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_il_scaled_array", sf_s_bessel_il_scaled_array, 2);
    rb_define_module_function(mSf, "bessel_k0_scaled", sf_s_bessel_k0_scaled, 1);
    rb_define_module_function(mSf, "bessel_k0_scaled_e", sf_s_bessel_k0_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_k1_scaled", sf_s_bessel_k1_scaled, 1);
    rb_define_module_function(mSf, "bessel_k1_scaled_e", sf_s_bessel_k1_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_k2_scaled", sf_s_bessel_k2_scaled, 1);
    rb_define_module_function(mSf, "bessel_k2_scaled_e", sf_s_bessel_k2_scaled_e, 1);
    rb_define_module_function(mSf, "bessel_kl_scaled", sf_s_bessel_kl_scaled, 2);
    rb_define_module_function(mSf, "bessel_kl_scaled_e", sf_s_bessel_kl_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_kl_scaled_array", sf_s_bessel_kl_scaled_array, 2);
    rb_define_module_function(mSf, "bessel_Jnu", sf_s_bessel_Jnu, 2);
    rb_define_module_function(mSf, "bessel_Jnu_e", sf_s_bessel_Jnu_e, 2);
    rb_define_module_function(mSf, "bessel_Ynu", sf_s_bessel_Ynu, 2);
    rb_define_module_function(mSf, "bessel_Ynu_e", sf_s_bessel_Ynu_e, 2);
    rb_define_module_function(mSf, "bessel_Inu", sf_s_bessel_Inu, 2);
    rb_define_module_function(mSf, "bessel_Inu_e", sf_s_bessel_Inu_e, 2);
    rb_define_module_function(mSf, "bessel_Inu_scaled", sf_s_bessel_Inu_scaled, 2);
    rb_define_module_function(mSf, "bessel_Inu_scaled_e", sf_s_bessel_Inu_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_Knu", sf_s_bessel_Knu, 2);
    rb_define_module_function(mSf, "bessel_Knu_e", sf_s_bessel_Knu_e, 2);
    rb_define_module_function(mSf, "bessel_lnKnu", sf_s_bessel_lnKnu, 2);
    rb_define_module_function(mSf, "bessel_lnKnu_e", sf_s_bessel_lnKnu_e, 2);
    rb_define_module_function(mSf, "bessel_Knu_scaled", sf_s_bessel_Knu_scaled, 2);
    rb_define_module_function(mSf, "bessel_Knu_scaled_e", sf_s_bessel_Knu_scaled_e, 2);
    rb_define_module_function(mSf, "bessel_zero_J0", sf_s_bessel_zero_J0, 1);
    rb_define_module_function(mSf, "bessel_zero_J0_e", sf_s_bessel_zero_J0_e, 1);
    rb_define_module_function(mSf, "bessel_zero_J1", sf_s_bessel_zero_J1, 1);
    rb_define_module_function(mSf, "bessel_zero_J1_e", sf_s_bessel_zero_J1_e, 1);
    rb_define_module_function(mSf, "bessel_zero_Jnu", sf_s_bessel_zero_Jnu, 2);
    rb_define_module_function(mSf, "bessel_zero_Jnu_e", sf_s_bessel_zero_Jnu_e, 2);
    rb_define_module_function(mSf, "hydrogenicR_1", sf_s_hydrogenicR_1, 2);
    rb_define_module_function(mSf, "hydrogenicR_1_e", sf_s_hydrogenicR_1_e, 2);
    rb_define_module_function(mSf, "hydrogenicR", sf_s_hydrogenicR, 4);
    rb_define_module_function(mSf, "hydrogenicR_e", sf_s_hydrogenicR_e, 4);
    rb_define_module_function(mSf, "coulomb_wave_FG_e", sf_s_coulomb_wave_FG_e, 4);
    rb_define_module_function(mSf, "coulomb_wave_F_array", sf_s_coulomb_wave_F_array, 4);
    rb_define_module_function(mSf, "coulomb_wave_FG_array", sf_s_coulomb_wave_FG_array, 4);
    rb_define_module_function(mSf, "coulomb_wave_FGp_array", sf_s_coulomb_wave_FGp_array, 4);
    rb_define_module_function(mSf, "coulomb_wave_sphF_array", sf_s_coulomb_wave_sphF_array, 4);
    rb_define_module_function(mSf, "coulomb_CL_e", sf_s_coulomb_CL_e, 2);
    rb_define_module_function(mSf, "coulomb_CL_array", sf_s_coulomb_CL_array, 3);
    rb_define_module_function(mSf, "airy_Ai", sf_s_airy_Ai, -1);
    rb_define_module_function(mSf, "airy_Ai_e", sf_s_airy_Ai_e, -1);
    rb_define_module_function(mSf, "airy_Bi", sf_s_airy_Bi, -1);
    rb_define_module_function(mSf, "airy_Bi_e", sf_s_airy_Bi_e, -1);
    rb_define_module_function(mSf, "airy_Ai_scaled", sf_s_airy_Ai_scaled, -1);
    rb_define_module_function(mSf, "airy_Ai_scaled_e", sf_s_airy_Ai_scaled_e, -1);
    rb_define_module_function(mSf, "airy_Bi_scaled", sf_s_airy_Bi_scaled, -1);
    rb_define_module_function(mSf, "airy_Bi_scaled_e", sf_s_airy_Bi_scaled_e, -1);
    rb_define_module_function(mSf, "airy_Ai_deriv", sf_s_airy_Ai_deriv, -1);
    rb_define_module_function(mSf, "airy_Ai_deriv_e", sf_s_airy_Ai_deriv_e, -1);
    rb_define_module_function(mSf, "airy_Bi_deriv", sf_s_airy_Bi_deriv, -1);
    rb_define_module_function(mSf, "airy_Bi_deriv_e", sf_s_airy_Bi_deriv_e, -1);
    rb_define_module_function(mSf, "airy_Ai_deriv_scaled", sf_s_airy_Ai_deriv_scaled, -1);
    rb_define_module_function(mSf, "airy_Ai_deriv_scaled_e", sf_s_airy_Ai_deriv_scaled_e, -1);
    rb_define_module_function(mSf, "airy_Bi_deriv_scaled", sf_s_airy_Bi_deriv_scaled, -1);
    rb_define_module_function(mSf, "airy_Bi_deriv_scaled_e", sf_s_airy_Bi_deriv_scaled_e, -1);
    rb_define_module_function(mSf, "airy_zero_Ai", sf_s_airy_zero_Ai, 1);
    rb_define_module_function(mSf, "airy_zero_Ai_e", sf_s_airy_zero_Ai_e, 1);
    rb_define_module_function(mSf, "airy_zero_Bi", sf_s_airy_zero_Bi, 1);
    rb_define_module_function(mSf, "airy_zero_Bi_e", sf_s_airy_zero_Bi_e, 1);
    rb_define_module_function(mSf, "airy_zero_Ai_deriv", sf_s_airy_zero_Ai_deriv, 1);
    rb_define_module_function(mSf, "airy_zero_Ai_deriv_e", sf_s_airy_zero_Ai_deriv_e, 1);
    rb_define_module_function(mSf, "airy_zero_Bi_deriv", sf_s_airy_zero_Bi_deriv, 1);
    rb_define_module_function(mSf, "airy_zero_Bi_deriv_e", sf_s_airy_zero_Bi_deriv_e, 1);
    rb_define_module_function(mSf, "zeta_int", sf_s_zeta_int, 1);
    rb_define_module_function(mSf, "zeta_int_e", sf_s_zeta_int_e, 1);
    rb_define_module_function(mSf, "zeta", sf_s_zeta, 1);
    rb_define_module_function(mSf, "zeta_e", sf_s_zeta_e, 1);
    rb_define_module_function(mSf, "zetam1_int", sf_s_zetam1_int, 1);
    rb_define_module_function(mSf, "zetam1_int_e", sf_s_zetam1_int_e, 1);
    rb_define_module_function(mSf, "zetam1", sf_s_zetam1, 1);
    rb_define_module_function(mSf, "zetam1_e", sf_s_zetam1_e, 1);
    rb_define_module_function(mSf, "hzeta", sf_s_hzeta, 2);
    rb_define_module_function(mSf, "hzeta_e", sf_s_hzeta_e, 2);
    rb_define_module_function(mSf, "eta_int", sf_s_eta_int, 1);
    rb_define_module_function(mSf, "eta_int_e", sf_s_eta_int_e, 1);
    rb_define_module_function(mSf, "eta", sf_s_eta, 1);
    rb_define_module_function(mSf, "eta_e", sf_s_eta_e, 1);
    rb_define_module_function(mSf, "legendre_P1", sf_s_legendre_P1, 1);
    rb_define_module_function(mSf, "legendre_P2", sf_s_legendre_P2, 1);
    rb_define_module_function(mSf, "legendre_P3", sf_s_legendre_P3, 1);
    rb_define_module_function(mSf, "legendre_P1_e", sf_s_legendre_P1_e, 1);
    rb_define_module_function(mSf, "legendre_P2_e", sf_s_legendre_P2_e, 1);
    rb_define_module_function(mSf, "legendre_P3_e", sf_s_legendre_P3_e, 1);
    rb_define_module_function(mSf, "legendre_Pl", sf_s_legendre_Pl, 2);
    rb_define_module_function(mSf, "legendre_Pl_e", sf_s_legendre_Pl_e, 2);
    rb_define_module_function(mSf, "legendre_Pl_array", sf_s_legendre_Pl_array, 2);
    rb_define_module_function(mSf, "legendre_Pl_deriv_array", sf_s_legendre_Pl_deriv_array, 2);
    rb_define_module_function(mSf, "legendre_Q0", sf_s_legendre_Q0, 1);
    rb_define_module_function(mSf, "legendre_Q0_e", sf_s_legendre_Q0_e, 1);
    rb_define_module_function(mSf, "legendre_Q1", sf_s_legendre_Q1, 1);
    rb_define_module_function(mSf, "legendre_Q1_e", sf_s_legendre_Q1_e, 1);
    rb_define_module_function(mSf, "legendre_Ql", sf_s_legendre_Ql, 2);
    rb_define_module_function(mSf, "legendre_Ql_e", sf_s_legendre_Ql_e, 2);
    rb_define_module_function(mSf, "legendre_array", sf_s_legendre_array, 3);
    rb_define_module_function(mSf, "legendre_array_e", sf_s_legendre_array_e, 4);
    rb_define_module_function(mSf, "legendre_deriv_array", sf_s_legendre_deriv_array, 3);
    rb_define_module_function(mSf, "legendre_deriv_array_e", sf_s_legendre_deriv_array_e, 4);
    rb_define_module_function(mSf, "legendre_deriv_alt_array", sf_s_legendre_deriv_alt_array, 3);
    rb_define_module_function(mSf, "legendre_deriv_alt_array_e", sf_s_legendre_deriv_alt_array_e, 4);
    rb_define_module_function(mSf, "legendre_deriv2_array", sf_s_legendre_deriv2_array, 3);
    rb_define_module_function(mSf, "legendre_deriv2_array_e", sf_s_legendre_deriv2_array_e, 4);
    rb_define_module_function(mSf, "legendre_deriv2_alt_array", sf_s_legendre_deriv2_alt_array, 3);
    rb_define_module_function(mSf, "legendre_deriv2_alt_array_e", sf_s_legendre_deriv2_alt_array_e, 4);
    rb_define_module_function(mSf, "legendre_array_n", sf_s_legendre_array_n, 1);
    rb_define_module_function(mSf, "legendre_array_index", sf_s_legendre_array_index, 2);
    rb_define_module_function(mSf, "legendre_Plm", sf_s_legendre_Plm, 3);
    rb_define_module_function(mSf, "legendre_Plm_e", sf_s_legendre_Plm_e, 3);
    rb_define_module_function(mSf, "legendre_sphPlm", sf_s_legendre_sphPlm, 3);
    rb_define_module_function(mSf, "legendre_sphPlm_e", sf_s_legendre_sphPlm_e, 3);
    rb_define_module_function(mSf, "conicalP_half", sf_s_conicalP_half, 2);
    rb_define_module_function(mSf, "conicalP_half_e", sf_s_conicalP_half_e, 2);
    rb_define_module_function(mSf, "conicalP_mhalf", sf_s_conicalP_mhalf, 2);
    rb_define_module_function(mSf, "conicalP_mhalf_e", sf_s_conicalP_mhalf_e, 2);
    rb_define_module_function(mSf, "conicalP_0", sf_s_conicalP_0, 2);
    rb_define_module_function(mSf, "conicalP_0_e", sf_s_conicalP_0_e, 2);
    rb_define_module_function(mSf, "conicalP_1", sf_s_conicalP_1, 2);
    rb_define_module_function(mSf, "conicalP_1_e", sf_s_conicalP_1_e, 2);
    rb_define_module_function(mSf, "conicalP_sph_reg", sf_s_conicalP_sph_reg, 3);
    rb_define_module_function(mSf, "conicalP_sph_reg_e", sf_s_conicalP_sph_reg_e, 3);
    rb_define_module_function(mSf, "conicalP_cyl_reg", sf_s_conicalP_cyl_reg, 3);
    rb_define_module_function(mSf, "conicalP_cyl_reg_e", sf_s_conicalP_cyl_reg_e, 3);
    rb_define_module_function(mSf, "legendre_H3d_0", sf_s_legendre_H3d_0, 2);
    rb_define_module_function(mSf, "legendre_H3d_0_e", sf_s_legendre_H3d_0_e, 2);
    rb_define_module_function(mSf, "legendre_H3d_1", sf_s_legendre_H3d_1, 2);
    rb_define_module_function(mSf, "legendre_H3d_1_e", sf_s_legendre_H3d_1_e, 2);
    rb_define_module_function(mSf, "legendre_H3d", sf_s_legendre_H3d, 3);
    rb_define_module_function(mSf, "legendre_H3d_e", sf_s_legendre_H3d_e, 3);
    rb_define_module_function(mSf, "legendre_H3d_array", sf_s_legendre_H3d_array, 3);
    rb_define_module_function(mSf, "hyperg_0F1", sf_s_hyperg_0F1, 2);
    rb_define_module_function(mSf, "hyperg_0F1_e", sf_s_hyperg_0F1_e, 2);
    rb_define_module_function(mSf, "hyperg_1F1_int", sf_s_hyperg_1F1_int, 3);
    rb_define_module_function(mSf, "hyperg_1F1_int_e", sf_s_hyperg_1F1_int_e, 3);
    rb_define_module_function(mSf, "hyperg_1F1", sf_s_hyperg_1F1, 3);
    rb_define_module_function(mSf, "hyperg_1F1_e", sf_s_hyperg_1F1_e, 3);
    rb_define_module_function(mSf, "hyperg_U_int", sf_s_hyperg_U_int, 3);
    rb_define_module_function(mSf, "hyperg_U_int_e", sf_s_hyperg_U_int_e, 3);
    rb_define_module_function(mSf, "hyperg_U_int_e10_e", sf_s_hyperg_U_int_e10_e, 3);
    rb_define_module_function(mSf, "hyperg_U", sf_s_hyperg_U, 3);
    rb_define_module_function(mSf, "hyperg_U_e", sf_s_hyperg_U_e, 3);
    rb_define_module_function(mSf, "hyperg_U_e10_e", sf_s_hyperg_U_e10_e, 3);
    rb_define_module_function(mSf, "hyperg_2F1", sf_s_hyperg_2F1, 4);
    rb_define_module_function(mSf, "hyperg_2F1_e", sf_s_hyperg_2F1_e, 4);
    rb_define_module_function(mSf, "hyperg_2F1_conj", sf_s_hyperg_2F1_conj, 4);
    rb_define_module_function(mSf, "hyperg_2F1_conj_e", sf_s_hyperg_2F1_conj_e, 4);
    rb_define_module_function(mSf, "hyperg_2F1_renorm", sf_s_hyperg_2F1_renorm, 4);
    rb_define_module_function(mSf, "hyperg_2F1_renorm_e", sf_s_hyperg_2F1_renorm_e, 4);
    rb_define_module_function(mSf, "hyperg_2F1_conj_renorm", sf_s_hyperg_2F1_conj_renorm, 4);
    rb_define_module_function(mSf, "hyperg_2F1_conj_renorm_e", sf_s_hyperg_2F1_conj_renorm_e, 4);
    rb_define_module_function(mSf, "hyperg_2F0", sf_s_hyperg_2F0, 3);
    rb_define_module_function(mSf, "hyperg_2F0_e", sf_s_hyperg_2F0_e, 3);
    rb_define_module_function(mSf, "clausen", sf_s_clausen, 1);
    rb_define_module_function(mSf, "clausen_e", sf_s_clausen_e, 1);
    rb_define_module_function(mSf, "lambert_W0", sf_s_lambert_W0, 1);
    rb_define_module_function(mSf, "lambert_W0_e", sf_s_lambert_W0_e, 1);
    rb_define_module_function(mSf, "lambert_Wm1", sf_s_lambert_Wm1, 1);
    rb_define_module_function(mSf, "lambert_Wm1_e", sf_s_lambert_Wm1_e, 1);
#line 12 "../gen/tmpl/init_module.c"
    }

#line 1 "../gen/tmpl/init_class.c"

    /*
      Document-class: Numo::GSL::Sf::Mathieu
      
    */
    {
    cMathieu = rb_define_class_under(mSf, "Mathieu", rb_cObject);
    
    rb_undef_alloc_func(cMathieu);
    rb_define_singleton_method(cMathieu, "new", sf_mathieu_s_new, 2);
    rb_define_method(cMathieu, "a_array", sf_mathieu_a_array, 3);
    rb_define_method(cMathieu, "b_array", sf_mathieu_b_array, 3);
    rb_define_method(cMathieu, "ce_array", sf_mathieu_ce_array, 4);
    rb_define_method(cMathieu, "se_array", sf_mathieu_se_array, 4);
    rb_define_method(cMathieu, "Mc_array", sf_mathieu_Mc_array, 5);
    rb_define_method(cMathieu, "Ms_array", sf_mathieu_Ms_array, 5);
#line 10 "../gen/tmpl/init_class.c"
    }
#line 41 "../gen/tmpl/lib.c"
}
