/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.citybutton;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.citybutton.AirUnitTable;
import com.unciv.ui.components.tilegroups.citybutton.CityTable;
import com.unciv.ui.components.tilegroups.citybutton.DefenceTable;
import com.unciv.ui.components.tilegroups.citybutton.InfluenceTable;
import com.unciv.ui.components.tilegroups.citybutton.StatusTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityReligionInfoTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.utils.DebugUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0010H\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\b\u0010!\u001a\u00020\u0018H\u0002J\u001a\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/CityButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "city", "Lcom/unciv/logic/city/City;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/ui/components/tilegroups/TileGroup;)V", "getCity", "()Lcom/unciv/logic/city/City;", "cityTable", "Lcom/unciv/ui/components/tilegroups/citybutton/CityTable;", "listOfHiddenUnitMarkers", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "isButtonMoved", "", "isViewable", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "getViewingPlayer", "()Lcom/unciv/logic/civilization/Civilization;", "belongsToViewingCiv", "update", "", "isCityViewable", "updateHiddenUnitMarkers", "insertHiddenUnitMarker", "pos", "Lcom/unciv/ui/components/tilegroups/citybutton/CityButton$HiddenUnitMarkerPosition;", "setButtonActions", "moveButtonDown", "moveButtonUp", "foreignCityInfoPopup", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "", "act", "delta", "Companion", "HiddenUnitMarkerPosition", "core"})
@SourceDebugExtension(value={"SMAP\nCityButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityButton.kt\ncom/unciv/ui/components/tilegroups/citybutton/CityButton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class CityButton
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final City city;
    @NotNull
    private final TileGroup tileGroup;
    private CityTable cityTable;
    @NotNull
    private final List<Actor> listOfHiddenUnitMarkers;
    private boolean isButtonMoved;
    private boolean isViewable;
    @NotNull
    private final Civilization viewingPlayer;
    @NotNull
    private static final Color ColorConstruction;
    @NotNull
    private static final Color ColorGrowth;

    public CityButton(@NotNull City city, @NotNull TileGroup tileGroup) {
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(BaseScreen.Companion.getSkin());
        this.city = city;
        this.tileGroup = tileGroup;
        this.setTouchable(Touchable.disabled);
        this.listOfHiddenUnitMarkers = new ArrayList();
        this.isViewable = true;
        this.viewingPlayer = GUI.INSTANCE.getViewingPlayer();
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @NotNull
    public final Civilization getViewingPlayer() {
        return this.viewingPlayer;
    }

    @Readonly
    private final boolean belongsToViewingCiv() {
        return Intrinsics.areEqual(this.city.getCiv(), this.viewingPlayer);
    }

    public final void update(boolean isCityViewable) {
        Civilization selectedPlayer = GUI.INSTANCE.getSelectedPlayer();
        this.isViewable = isCityViewable;
        this.clear();
        this.setButtonActions();
        if (isCityViewable && !((Collection)this.tileGroup.getTile().getAirUnits()).isEmpty()) {
            this.add((Actor)new AirUnitTable(this.city, this.tileGroup.getTile().getAirUnits().size(), 0.0f, 4, null)).padBottom(5.0f).row();
        }
        this.add((Actor)new DefenceTable(this.city, selectedPlayer)).row();
        this.cityTable = new CityTable(this.city, this.viewingPlayer, false, 4, null);
        CityTable cityTable = this.cityTable;
        if (cityTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable = null;
        }
        this.add((Actor)cityTable).row();
        if (this.city.getCiv().isCityState() && this.city.getCiv().knows(selectedPlayer)) {
            DiplomacyManager diplomacyManager = this.city.getCiv().getDiplomacyManager(selectedPlayer);
            Intrinsics.checkNotNull(diplomacyManager);
            DiplomacyManager diplomacyManager2 = diplomacyManager;
            this.add((Actor)new InfluenceTable(diplomacyManager2.getInfluence(), diplomacyManager2.relationshipLevel(), 0.0f, 0.0f, 12, null)).padTop(1.0f).row();
        }
        this.add((Actor)new StatusTable(this.city, selectedPlayer, 0.0f, 4, null)).padTop(3.0f);
        this.pack();
        if (isCityViewable && (float)this.city.getHealth() < (float)this.city.getMaxHealth$core()) {
            Table healthBar = ImageGetter.INSTANCE.getHealthBar(this.city.getHealth(), this.city.getMaxHealth$core(), 100.0f, 3.0f);
            this.addActor(healthBar);
            Scene2dExtensionsKt.center((Actor)healthBar, this);
            CityTable cityTable2 = this.cityTable;
            if (cityTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable2 = null;
            }
            float f = cityTable2.getY();
            CityTable cityTable3 = this.cityTable;
            if (cityTable3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable3 = null;
            }
            healthBar.setY(f + cityTable3.getHeight() - healthBar.getHeight() - 1.0f);
        }
        this.setOrigin(1);
        Scene2dExtensionsKt.centerX((Actor)this, this.tileGroup);
        this.updateHiddenUnitMarkers(isCityViewable);
    }

    private final void updateHiddenUnitMarkers(boolean isCityViewable) {
        for (Actor marker : this.listOfHiddenUnitMarkers) {
            CityTable cityTable = this.cityTable;
            if (cityTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable = null;
            }
            cityTable.removeActor(marker);
        }
        this.listOfHiddenUnitMarkers.clear();
        if (!isCityViewable) {
            return;
        }
        if (!this.isButtonMoved && this.tileGroup.getTile().getCivilianUnit() != null) {
            this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Center);
        }
        Iterator<Object> iterator2 = this.tileGroup.getTile().getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile tile = (Tile)iterator2.next();
            HexCoord direction = this.tileGroup.getTile().getPosition().minus(tile.getPosition());
            if (this.isButtonMoved) {
                if (tile.getCivilianUnit() != null && direction.getX() == 0 && direction.eq(0, 1)) {
                    this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Left);
                    continue;
                }
                if (tile.getMilitaryUnit() != null && !tile.hasEnemyInvisibleUnit(this.viewingPlayer) && direction.eq(1, 1)) {
                    this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Center);
                    continue;
                }
                if (tile.getCivilianUnit() == null || !direction.eq(1, 0)) continue;
                this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Right);
                continue;
            }
            if (tile.getMilitaryUnit() == null || tile.hasEnemyInvisibleUnit(this.viewingPlayer)) continue;
            if (direction.eq(0, 1)) {
                this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Left);
                continue;
            }
            if (!direction.eq(1, 0)) continue;
            this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Right);
        }
    }

    private final void insertHiddenUnitMarker(HiddenUnitMarkerPosition pos) {
        Image image;
        CityTable cityTable = this.cityTable;
        if (cityTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable = null;
        }
        float positionX = cityTable.getWidth() / (float)2 + (float)(pos.ordinal() - 1) * 60.0f;
        Image $this$insertHiddenUnitMarker_u24lambda_u240 = image = ImageGetter.INSTANCE.getTriangle();
        boolean bl = false;
        $this$insertHiddenUnitMarker_u24lambda_u240.setColor(this.city.getCiv().getNation().getInnerColor());
        $this$insertHiddenUnitMarker_u24lambda_u240.setSize(12.0f, 8.0f);
        $this$insertHiddenUnitMarker_u24lambda_u240.setOrigin(1);
        if (!this.isButtonMoved) {
            $this$insertHiddenUnitMarker_u24lambda_u240.setRotation(180.0f);
            $this$insertHiddenUnitMarker_u24lambda_u240.setPosition(positionX - $this$insertHiddenUnitMarker_u24lambda_u240.getWidth() / (float)2, -$this$insertHiddenUnitMarker_u24lambda_u240.getHeight());
        } else {
            $this$insertHiddenUnitMarker_u24lambda_u240.setPosition(positionX - $this$insertHiddenUnitMarker_u24lambda_u240.getWidth() / (float)2, -$this$insertHiddenUnitMarker_u24lambda_u240.getHeight());
        }
        Image indicator = image;
        CityTable cityTable2 = this.cityTable;
        if (cityTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable2 = null;
        }
        cityTable2.addActor(indicator);
        this.listOfHiddenUnitMarkers.add(indicator);
    }

    private final void setButtonActions() {
        UnitTable unitTable = GUI.INSTANCE.getUnitTable();
        this.setTouchable(Touchable.childrenOnly);
        ActivationExtensionsKt.onClick(this, () -> CityButton.setButtonActions$lambda$0(this, unitTable));
        ActivationExtensionsKt.onRightClick$default(this, null, new Function0<Unit>(this, unitTable){
            final /* synthetic */ CityButton this$0;
            final /* synthetic */ UnitTable $unitTable;
            {
                this.this$0 = $receiver;
                this.$unitTable = $unitTable;
                super(0, Intrinsics.Kotlin.class, "enterCityOrInfoPopup", "setButtonActions$enterCityOrInfoPopup(Lcom/unciv/ui/components/tilegroups/citybutton/CityButton;Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;)V", 0);
            }

            public final void invoke() {
                CityButton.access$setButtonActions$enterCityOrInfoPopup(this.this$0, this.$unitTable);
            }
        }, 1, null);
        if (!Intrinsics.areEqual(unitTable.getSelectedCity(), this.city)) {
            MapUnit mapUnit = unitTable.getSelectedUnit();
            if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCurrentTile() : null, this.city.getCenterTile()) && unitTable.getSelectedSpy() == null) {
                this.moveButtonUp();
            }
        }
    }

    public final void moveButtonDown() {
        if (this.isButtonMoved) {
            return;
        }
        SequenceAction moveButtonAction = Actions.sequence((Action)Actions.moveTo(this.tileGroup.getX(), this.tileGroup.getY() - this.getHeight(), 0.4f, Interpolation.swingOut), (Action)Actions.run(() -> CityButton.moveButtonDown$lambda$0(this)));
        this.getParent().addAction(moveButtonAction);
    }

    public final void moveButtonUp() {
        if (!this.isButtonMoved) {
            return;
        }
        SequenceAction moveButtonAction = Actions.sequence((Action)Actions.moveTo(this.tileGroup.getX(), this.tileGroup.getY(), 0.4f, Interpolation.sine), (Action)Actions.run(() -> CityButton.moveButtonUp$lambda$0(this)));
        this.getParent().addAction(moveButtonAction);
    }

    /*
     * Unable to fully structure code
     */
    private final void foreignCityInfoPopup() {
        if (!this.city.getCiv().getGameInfo().isEspionageEnabled()) ** GOTO lbl-1000
        v0 = this.viewingPlayer.getEspionageManager().getSpyAssignedToCity(this.city);
        v1 = v0 != null ? v0.isSetUp() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = espionageVisible = false;
        }
        if (!this.city.getCiv().getGameInfo().isReligionEnabled() && !espionageVisible) {
            CityButton.foreignCityInfoPopup$openDiplomacy(this);
            return;
        }
        $this$foreignCityInfoPopup_u24lambda_u240 = var3_2 = new Popup(GUI.INSTANCE.getWorldScreen(), null, 0.0f, 6, null);
        $i$a$-apply-CityButton$foreignCityInfoPopup$popup$1 = false;
        $this$foreignCityInfoPopup_u24lambda_u240.setName("ForeignCityInfoPopup");
        $this$foreignCityInfoPopup_u24lambda_u240.add((Actor)new CityTable(this.city, this.viewingPlayer, true)).fillX().padBottom(5.0f).colspan(3).row();
        if (this.city.getCiv().getGameInfo().isReligionEnabled()) {
            $this$foreignCityInfoPopup_u24lambda_u240.add((Actor)new CityReligionInfoTable(this.city.getReligion(), true)).colspan(3).row();
        }
        Popup.addOKButton$default($this$foreignCityInfoPopup_u24lambda_u240, "Diplomacy", null, null, null, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, foreignCityInfoPopup$lambda$0$0(com.unciv.ui.components.tilegroups.citybutton.CityButton ), ()Lkotlin/Unit;)((CityButton)this), 14, null);
        if (espionageVisible) {
            Popup.addButton$default($this$foreignCityInfoPopup_u24lambda_u240, "View", null, null, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, foreignCityInfoPopup$lambda$0$1(com.unciv.ui.components.tilegroups.citybutton.CityButton ), ()Lkotlin/Unit;)((CityButton)this), 6, null);
        }
        $this$foreignCityInfoPopup_u24lambda_u240.add().expandX();
        Popup.addCloseButton$default($this$foreignCityInfoPopup_u24lambda_u240, null, null, null, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, foreignCityInfoPopup$lambda$0$2(), ()Lkotlin/Unit;)(), 7, null);
        popup = var3_2;
        Popup.open$default(popup, false, 1, null);
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
    }

    private static final void setButtonActions$enterCityOrInfoPopup(CityButton this$0, UnitTable unitTable) {
        boolean canEnterCity;
        boolean bl = canEnterCity = DebugUtils.INSTANCE.getVISIBLE_MAP() || this$0.viewingPlayer.isSpectator() || this$0.belongsToViewingCiv() && !CollectionsKt.contains((Iterable)this$0.tileGroup.getTile().getAirUnits(), unitTable.getSelectedUnit());
        if (canEnterCity) {
            GUI.INSTANCE.pushScreen(new CityScreen(this$0.city, null, null, null, 14, null));
        } else if (this$0.viewingPlayer.knows(this$0.city.getCiv())) {
            this$0.foreignCityInfoPopup();
        }
    }

    private static final Unit setButtonActions$lambda$0(CityButton this$0, UnitTable $unitTable) {
        block5: {
            block6: {
                block4: {
                    if (!this$0.isButtonMoved) break block4;
                    CityButton.setButtonActions$enterCityOrInfoPopup(this$0, $unitTable);
                    break block5;
                }
                this$0.moveButtonDown();
                if ($unitTable.getSelectedUnit() == null) break block6;
                MapUnit mapUnit = $unitTable.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.hasMovement()) break block5;
            }
            if (this$0.belongsToViewingCiv()) {
                $unitTable.citySelected(this$0.city);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void moveButtonDown$lambda$0(CityButton this$0) {
        this$0.isButtonMoved = true;
        this$0.updateHiddenUnitMarkers(this$0.isViewable);
    }

    private static final void moveButtonUp$lambda$0(CityButton this$0) {
        this$0.isButtonMoved = false;
        this$0.updateHiddenUnitMarkers(this$0.isViewable);
    }

    private static final void foreignCityInfoPopup$openDiplomacy(CityButton this$0) {
        GUI.INSTANCE.pushScreen(new DiplomacyScreen(this$0.viewingPlayer, this$0.city.getCiv(), null, false, 12, null));
    }

    private static final Unit foreignCityInfoPopup$lambda$0$0(CityButton this$0) {
        CityButton.foreignCityInfoPopup$openDiplomacy(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit foreignCityInfoPopup$lambda$0$1(CityButton this$0) {
        GUI.INSTANCE.pushScreen(new CityScreen(this$0.city, null, null, null, 14, null));
        return Unit.INSTANCE;
    }

    private static final Unit foreignCityInfoPopup$lambda$0$2() {
        WorldScreen $this$foreignCityInfoPopup_u24lambda_u240_u242_u240 = GUI.INSTANCE.getWorldScreen();
        boolean bl = false;
        $this$foreignCityInfoPopup_u24lambda_u240_u242_u240.getNextTurnButton$core().update();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setButtonActions$enterCityOrInfoPopup(CityButton this$0, UnitTable unitTable) {
        CityButton.setButtonActions$enterCityOrInfoPopup(this$0, unitTable);
    }

    static {
        Color color = Color.valueOf("#C48C3E");
        Intrinsics.checkNotNullExpressionValue(color, "valueOf(...)");
        ColorConstruction = color;
        Color color2 = Color.valueOf("#82E14E");
        Intrinsics.checkNotNullExpressionValue(color2, "valueOf(...)");
        ColorGrowth = color2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/CityButton$Companion;", "", "<init>", "()V", "ColorConstruction", "Lcom/badlogic/gdx/graphics/Color;", "getColorConstruction", "()Lcom/badlogic/gdx/graphics/Color;", "ColorGrowth", "getColorGrowth", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getColorConstruction() {
            return ColorConstruction;
        }

        @NotNull
        public final Color getColorGrowth() {
            return ColorGrowth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/components/tilegroups/citybutton/CityButton$HiddenUnitMarkerPosition;", "", "<init>", "(Ljava/lang/String;I)V", "Left", "Center", "Right", "core"})
    private static final class HiddenUnitMarkerPosition
    extends Enum<HiddenUnitMarkerPosition> {
        public static final /* enum */ HiddenUnitMarkerPosition Left = new HiddenUnitMarkerPosition();
        public static final /* enum */ HiddenUnitMarkerPosition Center = new HiddenUnitMarkerPosition();
        public static final /* enum */ HiddenUnitMarkerPosition Right = new HiddenUnitMarkerPosition();
        private static final /* synthetic */ HiddenUnitMarkerPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HiddenUnitMarkerPosition[] values() {
            return (HiddenUnitMarkerPosition[])$VALUES.clone();
        }

        public static HiddenUnitMarkerPosition valueOf(String value) {
            return Enum.valueOf(HiddenUnitMarkerPosition.class, value);
        }

        @NotNull
        public static EnumEntries<HiddenUnitMarkerPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = hiddenUnitMarkerPositionArray = new HiddenUnitMarkerPosition[]{HiddenUnitMarkerPosition.Left, HiddenUnitMarkerPosition.Center, HiddenUnitMarkerPosition.Right};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

