/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.Multiplayer;
import com.unciv.logic.multiplayer.MultiplayerFiles;
import com.unciv.logic.multiplayer.MultiplayerGamePreview;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.AuthPopup;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.AddMultiplayerGameScreen;
import com.unciv.ui.screens.multiplayerscreens.GameList;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerHelpers;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerScreen;
import com.unciv.ui.screens.multiplayerscreens.ViewFriendsListScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020\u0007H\u0002J\b\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u001aH\u0002J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u001aH\u0002J\b\u0010)\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u0007H\u0002J\b\u0010+\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\u0007H\u0002J\b\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\b\u0010/\u001a\u00020\u0018H\u0002J\b\u00100\u001a\u00020\u0018H\u0002J\u0010\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u001aH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/MultiplayerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "<init>", "()V", "selectedGame", "Lcom/unciv/logic/multiplayer/MultiplayerGamePreview;", "copyGameIdButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "resignButton", "forceResignButton", "skipTurnButton", "deleteButton", "renameButton", "gameSpecificButtons", "", "addGameButton", "copyUserIdButton", "friendsListButton", "refreshButton", "gameList", "Lcom/unciv/ui/screens/multiplayerscreens/GameList;", "getGameList", "()Lcom/unciv/ui/screens/multiplayerscreens/GameList;", "onGameDeleted", "", "gameName", "", "setupRightSideButton", "getGeneralActionsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getGameSpecificActionsTable", "createRefreshButton", "createAddGameButton", "createResignButton", "createForceResignButton", "createSkipTurnButton", "resignPlayer", "multiplayerGamePreview", "playerCiv", "skipCurrentPlayerTurn", "playerToSkip", "createDeleteButton", "createRenameButton", "createCopyGameIdButton", "createFriendsListButton", "createCopyUserIdButton", "createMainContent", "setupHelpButton", "unselectGame", "selectGame", "name", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerScreen.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,435:1\n1#2:436\n1563#3:437\n1634#3,3:438\n774#3:441\n865#3,2:442\n*S KotlinDebug\n*F\n+ 1 MultiplayerScreen.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerScreen\n*L\n426#1:437\n426#1:438,3\n80#1:441\n80#1:442,2\n*E\n"})
public final class MultiplayerScreen
extends PickerScreen {
    @Nullable
    private MultiplayerGamePreview selectedGame;
    @NotNull
    private final TextButton copyGameIdButton = this.createCopyGameIdButton();
    @NotNull
    private final TextButton resignButton = this.createResignButton();
    @NotNull
    private final TextButton forceResignButton = this.createForceResignButton();
    @NotNull
    private final TextButton skipTurnButton = this.createSkipTurnButton();
    @NotNull
    private final TextButton deleteButton = this.createDeleteButton();
    @NotNull
    private final TextButton renameButton = this.createRenameButton();
    @NotNull
    private final List<TextButton> gameSpecificButtons;
    @NotNull
    private final TextButton addGameButton;
    @NotNull
    private final TextButton copyUserIdButton;
    @NotNull
    private final TextButton friendsListButton;
    @NotNull
    private final TextButton refreshButton;
    @NotNull
    private final GameList gameList;

    public MultiplayerScreen() {
        super(false, 1, null);
        TextButton[] textButtonArray = new TextButton[]{this.copyGameIdButton, this.resignButton, this.deleteButton, this.renameButton};
        this.gameSpecificButtons = CollectionsKt.listOf(textButtonArray);
        this.addGameButton = this.createAddGameButton();
        this.copyUserIdButton = this.createCopyUserIdButton();
        this.friendsListButton = this.createFriendsListButton();
        this.refreshButton = this.createRefreshButton();
        this.gameList = new GameList((Function1<? super String, Unit>)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MultiplayerScreen.access$selectGame((MultiplayerScreen)this.receiver, p0);
            }
        });
        this.setDefaultCloseAction();
        this.getScrollPane().setScrollingDisabled(false, true);
        this.getTopTable().add((Actor)this.createMainContent()).row();
        this.setupHelpButton();
        this.setupRightSideButton();
        Concurrency.run$default(Concurrency.INSTANCE, "Update all multiplayer games", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = Multiplayer.requestUpdate$default(this.this$0.getGame().getOnlineMultiplayer(), false, null, this, 3, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "MultiplayerScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getTopTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "MultiplayerScreen/TopTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
    }

    @NotNull
    public final GameList getGameList() {
        return this.gameList;
    }

    private final void onGameDeleted(String gameName) {
        MultiplayerGamePreview multiplayerGamePreview = this.selectedGame;
        if (Intrinsics.areEqual(multiplayerGamePreview != null ? multiplayerGamePreview.getName() : null, gameName)) {
            this.unselectGame();
        }
        this.gameList.update();
    }

    private final void setupRightSideButton() {
        this.getRightSideButton().setText(TranslationsKt.tr$default("Join game", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> MultiplayerScreen.setupRightSideButton$lambda$0(this));
    }

    private final Table getGeneralActionsTable() {
        Table table2;
        Table $this$getGeneralActionsTable_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$getGeneralActionsTable_u24lambda_u240.defaults().pad(10.0f);
        Table generalActions = table2;
        generalActions.add((Actor)this.copyUserIdButton).row();
        generalActions.add((Actor)this.addGameButton).row();
        generalActions.add((Actor)this.friendsListButton).row();
        generalActions.add((Actor)this.refreshButton).row();
        return generalActions;
    }

    private final Table getGameSpecificActionsTable() {
        Table table2;
        Table $this$getGameSpecificActionsTable_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$getGameSpecificActionsTable_u24lambda_u240.defaults().pad(10.0f);
        Table gameSpecificActions = table2;
        gameSpecificActions.add((Actor)this.copyGameIdButton).row();
        gameSpecificActions.add((Actor)this.renameButton).row();
        gameSpecificActions.add((Actor)this.skipTurnButton).row();
        gameSpecificActions.add((Actor)this.resignButton).row();
        gameSpecificActions.add((Actor)this.forceResignButton).row();
        gameSpecificActions.add((Actor)this.deleteButton).row();
        return gameSpecificActions;
    }

    private final TextButton createRefreshButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Refresh list", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createRefreshButton$lambda$0(this));
        return btn;
    }

    private final TextButton createAddGameButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Add multiplayer game", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createAddGameButton$lambda$0(this));
        return btn;
    }

    private final TextButton createResignButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createResignButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Resign", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createResignButton_u24lambda_u240);
        TextButton resignButton = textButton;
        ActivationExtensionsKt.onClick(resignButton, () -> MultiplayerScreen.createResignButton$lambda$1(this));
        return resignButton;
    }

    private final TextButton createForceResignButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createForceResignButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Force current player to resign", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        $this$createForceResignButton_u24lambda_u240.setVisible(false);
        TextButton resignButton = textButton;
        ActivationExtensionsKt.onClick(resignButton, () -> MultiplayerScreen.createForceResignButton$lambda$1(this));
        return resignButton;
    }

    private final TextButton createSkipTurnButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createSkipTurnButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Skip turn of current player", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        $this$createSkipTurnButton_u24lambda_u240.setVisible(false);
        TextButton skipTurnButton = textButton;
        ActivationExtensionsKt.onClick(skipTurnButton, () -> MultiplayerScreen.createSkipTurnButton$lambda$1(this));
        return skipTurnButton;
    }

    private final void resignPlayer(MultiplayerGamePreview multiplayerGamePreview, String playerCiv) {
        Popup popup2 = new Popup(this, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(popup2, "Working...", 0, false, null, 14, null).row();
        Popup.open$default(popup2, false, 1, null);
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("Resign", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, multiplayerGamePreview, playerCiv, popup2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerScreen this$0;
            final /* synthetic */ MultiplayerGamePreview $multiplayerGamePreview;
            final /* synthetic */ String $playerCiv;
            final /* synthetic */ Popup $popup;
            {
                this.this$0 = $receiver;
                this.$multiplayerGamePreview = $multiplayerGamePreview;
                this.$playerCiv = $playerCiv;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$runOnNonDaemonThreadPool;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().resignPlayer(this.$multiplayerGamePreview, this.$playerCiv, this);
                        ** if (v0 != var6_3) goto lbl13
lbl12:
                        // 1 sources

                        return var6_3;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            errorMessage = (String)v0;
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(errorMessage, this.$popup, null){
                                int label;
                                final /* synthetic */ String $errorMessage;
                                final /* synthetic */ Popup $popup;
                                {
                                    this.$errorMessage = $errorMessage;
                                    this.$popup = $popup;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            if (((CharSequence)this.$errorMessage).length() == 0) {
                                                this.$popup.close();
                                            } else {
                                                this.$popup.reuseWith(this.$errorMessage, true);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception ex) {
                            message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, null, 6, null).component1();
                            if (ex instanceof MultiplayerAuthException) {
                                ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$multiplayerGamePreview, this.$playerCiv, null){
                                    int label;
                                    final /* synthetic */ MultiplayerScreen this$0;
                                    final /* synthetic */ MultiplayerGamePreview $multiplayerGamePreview;
                                    final /* synthetic */ String $playerCiv;
                                    {
                                        this.this$0 = $receiver;
                                        this.$multiplayerGamePreview = $multiplayerGamePreview;
                                        this.$playerCiv = $playerCiv;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure($result);
                                                new AuthPopup(this.this$0, arg_0 -> resignPlayer.2.invokeSuspend$lambda$0(this.this$0, this.$multiplayerGamePreview, this.$playerCiv, arg_0)).open(true);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final Unit invokeSuspend$lambda$0(MultiplayerScreen this$0, MultiplayerGamePreview $multiplayerGamePreview, String $playerCiv, boolean success) {
                                        if (success) {
                                            MultiplayerScreen.access$resignPlayer(this$0, $multiplayerGamePreview, $playerCiv);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }, 1, null);
                                return Unit.INSTANCE;
                            }
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$popup, message, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ String $message;
                                {
                                    this.$popup = $popup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$popup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void skipCurrentPlayerTurn(MultiplayerGamePreview multiplayerGamePreview, String playerToSkip) {
        Popup popup2 = new Popup(this, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(popup2, "Working...", 0, false, null, 14, null).row();
        Popup.open$default(popup2, false, 1, null);
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("Skip turn", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, multiplayerGamePreview, playerToSkip, popup2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerScreen this$0;
            final /* synthetic */ MultiplayerGamePreview $multiplayerGamePreview;
            final /* synthetic */ String $playerToSkip;
            final /* synthetic */ Popup $popup;
            {
                this.this$0 = $receiver;
                this.$multiplayerGamePreview = $multiplayerGamePreview;
                this.$playerToSkip = $playerToSkip;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$runOnNonDaemonThreadPool;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().skipCurrentPlayerTurn(this.$multiplayerGamePreview, this.$playerToSkip, this);
                        ** if (v0 != var6_3) goto lbl13
lbl12:
                        // 1 sources

                        return var6_3;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            skipTurnErrorMessage = (String)v0;
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(skipTurnErrorMessage, this.$popup, this.this$0, null){
                                int label;
                                final /* synthetic */ String $skipTurnErrorMessage;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ MultiplayerScreen this$0;
                                {
                                    this.$skipTurnErrorMessage = $skipTurnErrorMessage;
                                    this.$popup = $popup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            if (this.$skipTurnErrorMessage == null) {
                                                this.$popup.close();
                                            } else {
                                                this.$popup.reuseWith(this.$skipTurnErrorMessage, true);
                                            }
                                            this.this$0.getGameList().update();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception ex) {
                            message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, null, 6, null).component1();
                            if (ex instanceof MultiplayerAuthException) {
                                ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$multiplayerGamePreview, this.$playerToSkip, null){
                                    int label;
                                    final /* synthetic */ MultiplayerScreen this$0;
                                    final /* synthetic */ MultiplayerGamePreview $multiplayerGamePreview;
                                    final /* synthetic */ String $playerToSkip;
                                    {
                                        this.this$0 = $receiver;
                                        this.$multiplayerGamePreview = $multiplayerGamePreview;
                                        this.$playerToSkip = $playerToSkip;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure($result);
                                                new AuthPopup(this.this$0, arg_0 -> skipCurrentPlayerTurn.2.invokeSuspend$lambda$0(this.this$0, this.$multiplayerGamePreview, this.$playerToSkip, arg_0)).open(true);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final Unit invokeSuspend$lambda$0(MultiplayerScreen this$0, MultiplayerGamePreview $multiplayerGamePreview, String $playerToSkip, boolean success) {
                                        if (success) {
                                            MultiplayerScreen.access$skipCurrentPlayerTurn(this$0, $multiplayerGamePreview, $playerToSkip);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }, 1, null);
                                return Unit.INSTANCE;
                            }
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$popup, message, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ String $message;
                                {
                                    this.$popup = $popup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$popup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final TextButton createDeleteButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createDeleteButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Delete save", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createDeleteButton_u24lambda_u240);
        TextButton deleteButton = textButton;
        ActivationExtensionsKt.onClick(deleteButton, () -> MultiplayerScreen.createDeleteButton$lambda$1(this));
        return deleteButton;
    }

    private final TextButton createRenameButton() {
        TextButton textButton;
        TextButton $this$createRenameButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Rename", null, false, 3, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createRenameButton_u24lambda_u240);
        TextButton btn = textButton;
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createRenameButton$lambda$1(this));
        return btn;
    }

    private final TextButton createCopyGameIdButton() {
        TextButton textButton;
        TextButton $this$createCopyGameIdButton_u24lambda_u240 = textButton = Scene2dExtensionsKt.toTextButton$default("Copy game ID", null, false, 3, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createCopyGameIdButton_u24lambda_u240);
        TextButton btn = textButton;
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createCopyGameIdButton$lambda$1(this));
        return btn;
    }

    private final TextButton createFriendsListButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Friends list", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createFriendsListButton$lambda$0(this));
        return btn;
    }

    private final TextButton createCopyUserIdButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Copy user ID", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, () -> MultiplayerScreen.createCopyUserIdButton$lambda$0(this));
        return btn;
    }

    /*
     * WARNING - void declaration
     */
    private final Table createMainContent() {
        void $this$createMainContent_u24lambda_u240;
        AutoScrollPane autoScrollPane;
        Table mainTable = new Table();
        AutoScrollPane autoScrollPane2 = autoScrollPane = new AutoScrollPane((Actor)this.gameList, null, 2, null);
        Table table2 = mainTable;
        boolean bl = false;
        $this$createMainContent_u24lambda_u240.setScrollingDisabled(true, false);
        table2.add((Actor)autoScrollPane).center();
        mainTable.add((Actor)this.getGameSpecificActionsTable());
        mainTable.add((Actor)this.getGeneralActionsTable());
        return mainTable;
    }

    private final void setupHelpButton() {
        Table tab = new Table();
        TextButton helpButton = Scene2dExtensionsKt.toTextButton$default("Help", null, false, 3, null);
        ActivationExtensionsKt.onClick(helpButton, () -> MultiplayerScreen.setupHelpButton$lambda$0(this));
        tab.add((Actor)helpButton);
        tab.setX(this.getStage().getWidth() - helpButton.getWidth());
        tab.setY(this.getStage().getHeight() - helpButton.getHeight());
        this.getStage().addActor(tab);
    }

    private final void unselectGame() {
        this.selectedGame = null;
        Scene2dExtensionsKt.disable(this.getRightSideButton());
        for (TextButton button : this.gameSpecificButtons) {
            Scene2dExtensionsKt.disable(button);
        }
        this.skipTurnButton.setVisible(false);
        this.forceResignButton.setVisible(false);
        this.getDescriptionLabel().setText("");
    }

    /*
     * WARNING - void declaration
     */
    private final void selectGame(String name) {
        Object object;
        MultiplayerGamePreview multiplayerGame = this.getGame().getOnlineMultiplayer().getMultiplayerFiles().getGameByName(name);
        if (multiplayerGame == null) {
            this.unselectGame();
            return;
        }
        this.selectedGame = multiplayerGame;
        for (TextButton button : this.gameSpecificButtons) {
            Scene2dExtensionsKt.enable(button);
        }
        GameInfoPreview preview = multiplayerGame.getPreview();
        if (preview != null) {
            Scene2dExtensionsKt.enable(this.copyGameIdButton);
            Scene2dExtensionsKt.enable(this.getRightSideButton());
        } else {
            Scene2dExtensionsKt.disable(this.copyGameIdButton);
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
        Scene2dExtensionsKt.setEnabled(this.resignButton, Intrinsics.areEqual((object = preview) != null && (object = ((GameInfoPreview)object).getCurrentPlayerCiv()) != null ? ((CivilizationInfoPreview)object).getPlayerId() : null, this.getGame().getSettings().getMultiplayer().getUserId()));
        if (Scene2dExtensionsKt.isEnabled(this.resignButton) || preview == null) {
            this.skipTurnButton.setVisible(false);
            this.forceResignButton.setVisible(false);
        } else {
            void $this$mapTo$iv$iv;
            Duration durationInactive = Duration.between(Instant.ofEpochMilli(preview.getCurrentTurnStartTime()), Instant.now());
            Duration playerDurationBeforeForceResign = Duration.ofMinutes(preview.getCurrentPlayerCiv().getPlayerMinutesBeforeForceResign());
            Iterable $this$map$iv = preview.getCivilizations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CivilizationInfoPreview civilizationInfoPreview = (CivilizationInfoPreview)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPlayerId());
            }
            boolean weAreAPlayer = ((List)destination$iv$iv).contains(this.getGame().getSettings().getMultiplayer().getUserId());
            this.skipTurnButton.setVisible(weAreAPlayer && durationInactive.compareTo(Duration.ofMinutes(preview.getGameParameters().getMinutesUntilSkipTurn())) > 0);
            this.forceResignButton.setVisible(weAreAPlayer && durationInactive.compareTo(playerDurationBeforeForceResign) > 0);
        }
        this.getDescriptionLabel().setText(MultiplayerHelpers.INSTANCE.buildDescriptionText(multiplayerGame));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setupRightSideButton$lambda$0(MultiplayerScreen this$0) {
        void $this$filterTo$iv$iv;
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        GameInfoPreview gameInfoPreview = multiplayerGamePreview.getPreview();
        Intrinsics.checkNotNull(gameInfoPreview);
        Iterable $this$filter$iv = gameInfoPreview.getGameParameters().getModsAndBaseRuleset();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!RulesetCache.INSTANCE.containsKey((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingMods = (List)destination$iv$iv;
        if (missingMods.isEmpty()) {
            BaseScreen baseScreen = this$0;
            MultiplayerGamePreview multiplayerGamePreview2 = this$0.selectedGame;
            Intrinsics.checkNotNull(multiplayerGamePreview2);
            MultiplayerHelpers.INSTANCE.loadMultiplayerGame(baseScreen, multiplayerGamePreview2);
            return Unit.INSTANCE;
        }
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("Download missing mods", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<String>)missingMods, this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<String> $missingMods;
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.$missingMods = $missingMods;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runOnNonDaemonThreadPool;
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$runOnNonDaemonThreadPool;
                        this.label = 1;
                        Object object2 = LoadGameScreen.Companion.loadMissingMods((Iterable<String>)this.$missingMods, arg_0 -> setupRightSideButton.1.1.invokeSuspend$lambda$0(this.this$0, arg_0), () -> setupRightSideButton.1.1.invokeSuspend$lambda$1(this.this$0), this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        void $this$runOnNonDaemonThreadPool;
                        try {
                            ResultKt.throwOnFailure($result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            String message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, null, 6, null).component1();
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, this.this$0, null){
                                int label;
                                final /* synthetic */ String $message;
                                final /* synthetic */ MultiplayerScreen this$0;
                                {
                                    this.$message = $message;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            new ToastPopup(this.$message, this.this$0, 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(MultiplayerScreen this$0, String it) {
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this$0, null){
                    int label;
                    final /* synthetic */ String $it;
                    final /* synthetic */ MultiplayerScreen this$0;
                    {
                        this.$it = $it;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                new ToastPopup('[' + this.$it + "] Downloaded!", this.this$0, 0L, 4, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(MultiplayerScreen this$0) {
                RulesetCache.loadRulesets$default(RulesetCache.INSTANCE, false, false, 3, null);
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                    int label;
                    final /* synthetic */ MultiplayerScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                BaseScreen baseScreen = this.this$0;
                                MultiplayerGamePreview multiplayerGamePreview = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                                Intrinsics.checkNotNull(multiplayerGamePreview);
                                MultiplayerHelpers.INSTANCE.loadMultiplayerGame(baseScreen, multiplayerGamePreview);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                return Unit.INSTANCE;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit createRefreshButton$lambda$0(MultiplayerScreen this$0) {
        Concurrency.run$default(Concurrency.INSTANCE, "Update all multiplayer games", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = Multiplayer.requestUpdate$default(this.this$0.getGame().getOnlineMultiplayer(), false, null, this, 3, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createAddGameButton$lambda$0(MultiplayerScreen this$0) {
        this$0.getGame().pushScreen(new AddMultiplayerGameScreen(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createResignButton$lambda$1(MultiplayerScreen this$0) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        GameInfoPreview gameInfoPreview = multiplayerGamePreview.getPreview();
        Intrinsics.checkNotNull(gameInfoPreview);
        String civName = gameInfoPreview.getCurrentPlayer();
        ConfirmPopup askPopup = new ConfirmPopup(this$0, "Are you sure you ([" + civName + "]) want to resign?", "Resign", false, null, () -> MultiplayerScreen.createResignButton$lambda$1$0(this$0, civName), 24, null);
        Popup.open$default(askPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createResignButton$lambda$1$0(MultiplayerScreen this$0, String $civName) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        this$0.resignPlayer(multiplayerGamePreview, $civName);
        return Unit.INSTANCE;
    }

    private static final Unit createForceResignButton$lambda$1(MultiplayerScreen this$0) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        GameInfoPreview gameInfoPreview = multiplayerGamePreview.getPreview();
        Intrinsics.checkNotNull(gameInfoPreview);
        String currentPlayer = gameInfoPreview.getCurrentPlayer();
        ConfirmPopup askPopup = new ConfirmPopup(this$0, "Are you sure you want to force the current player ([" + currentPlayer + "]) to resign?", "Yes", false, null, () -> MultiplayerScreen.createForceResignButton$lambda$1$0(this$0, currentPlayer), 24, null);
        Popup.open$default(askPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createForceResignButton$lambda$1$0(MultiplayerScreen this$0, String $currentPlayer) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        this$0.resignPlayer(multiplayerGamePreview, $currentPlayer);
        return Unit.INSTANCE;
    }

    private static final Unit createSkipTurnButton$lambda$1(MultiplayerScreen this$0) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        GameInfoPreview gameInfoPreview = multiplayerGamePreview.getPreview();
        Intrinsics.checkNotNull(gameInfoPreview);
        String civName = gameInfoPreview.getCurrentPlayer();
        ConfirmPopup askPopup = new ConfirmPopup(this$0, "Are you sure you want to skip the turn of [" + civName + "]?", "Yes", false, null, () -> MultiplayerScreen.createSkipTurnButton$lambda$1$0(this$0, civName), 24, null);
        Popup.open$default(askPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createSkipTurnButton$lambda$1$0(MultiplayerScreen this$0, String $civName) {
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        this$0.skipCurrentPlayerTurn(multiplayerGamePreview, $civName);
        return Unit.INSTANCE;
    }

    private static final Unit createDeleteButton$lambda$1(MultiplayerScreen this$0) {
        ConfirmPopup askPopup = new ConfirmPopup(this$0, "Are you sure you want to delete this save?", "Delete save", false, null, () -> MultiplayerScreen.createDeleteButton$lambda$1$0(this$0), 24, null);
        Popup.open$default(askPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createDeleteButton$lambda$1$0(MultiplayerScreen this$0) {
        try {
            MultiplayerFiles multiplayerFiles = this$0.getGame().getOnlineMultiplayer().getMultiplayerFiles();
            MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
            Intrinsics.checkNotNull(multiplayerGamePreview);
            multiplayerFiles.deleteGame(multiplayerGamePreview);
            MultiplayerGamePreview multiplayerGamePreview2 = this$0.selectedGame;
            Intrinsics.checkNotNull(multiplayerGamePreview2);
            String string = multiplayerGamePreview2.getName();
            Intrinsics.checkNotNullExpressionValue(string, "<get-name>(...)");
            this$0.onGameDeleted(string);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Could not delete game!", ex);
            new ToastPopup("Could not delete game!", this$0, 0L, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createRenameButton$lambda$1(MultiplayerScreen this$0) {
        Popup popup2;
        Popup $this$createRenameButton_u24lambda_u241_u240 = popup2 = new Popup(this$0, null, 0.0f, 6, null);
        boolean bl = false;
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        String string = multiplayerGamePreview.getName();
        Intrinsics.checkNotNullExpressionValue(string, "<get-name>(...)");
        UncivTextField textField = new UncivTextField("Game name", string, null, 4, null);
        textField.setTextFieldFilter(UncivFiles.Companion.fileNameTextFieldFilter());
        $this$createRenameButton_u24lambda_u241_u240.add((Actor)textField).width($this$createRenameButton_u24lambda_u241_u240.getStageToShowOn().getWidth() / (float)2).row();
        TextButton saveButton = Scene2dExtensionsKt.toTextButton$default("Save", null, false, 3, null);
        Function0<Unit> saveNewNameFunction = () -> MultiplayerScreen.createRenameButton$lambda$1$0$0(textField, this$0, $this$createRenameButton_u24lambda_u241_u240);
        ActivationExtensionsKt.onActivation(saveButton, saveNewNameFunction);
        ActivationExtensionsKt.getKeyShortcuts(saveButton).add(KeyCharAndCode.Companion.getRETURN());
        textField.setCursorPosition(textField.getText().length());
        this$0.getStage().setKeyboardFocus(textField);
        $this$createRenameButton_u24lambda_u241_u240.add((Actor)saveButton);
        Popup.open$default($this$createRenameButton_u24lambda_u241_u240, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createRenameButton$lambda$1$0$0(UncivTextField $textField, MultiplayerScreen this$0, Popup $this_apply) {
        String string = $textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String newName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        MultiplayerFiles multiplayerFiles = this$0.getGame().getOnlineMultiplayer().getMultiplayerFiles();
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        Intrinsics.checkNotNull(multiplayerGamePreview);
        multiplayerFiles.changeGameName(multiplayerGamePreview, newName, arg_0 -> MultiplayerScreen.createRenameButton$lambda$1$0$0$0($this_apply, arg_0));
        this$0.gameList.update();
        this$0.selectGame(newName);
        $this_apply.close();
        return Unit.INSTANCE;
    }

    private static final Unit createRenameButton$lambda$1$0$0$0(Popup $this_apply, Exception it) {
        if (it != null) {
            $this_apply.reuseWith("Could not save game!", true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCopyGameIdButton$lambda$1(MultiplayerScreen this$0) {
        GameInfoPreview gameInfo;
        MultiplayerGamePreview multiplayerGamePreview = this$0.selectedGame;
        GameInfoPreview gameInfoPreview = gameInfo = multiplayerGamePreview != null ? multiplayerGamePreview.getPreview() : null;
        if (gameInfo != null) {
            Gdx.app.getClipboard().setContents(gameInfo.getGameId());
            new ToastPopup("Game ID copied to clipboard!", this$0, 0L, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createFriendsListButton$lambda$0(MultiplayerScreen this$0) {
        this$0.getGame().pushScreen(new ViewFriendsListScreen());
        return Unit.INSTANCE;
    }

    private static final Unit createCopyUserIdButton$lambda$0(MultiplayerScreen this$0) {
        Gdx.app.getClipboard().setContents(this$0.getGame().getSettings().getMultiplayer().getUserId());
        new ToastPopup("UserID copied to clipboard", this$0, 0L, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit setupHelpButton$lambda$0(MultiplayerScreen this$0) {
        Popup helpPopup = new Popup(this$0, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(helpPopup, "To create a multiplayer game, check the 'multiplayer' toggle in the New Game screen, and for each human player insert that player's user ID.", 0, false, null, 14, null).row();
        Popup.addGoodSizedLabel$default(helpPopup, "You can assign your own user ID there easily, and other players can copy their user IDs here and send them to you for you to include them in the game.", 0, false, null, 14, null).row();
        helpPopup.row();
        Popup.addGoodSizedLabel$default(helpPopup, "Once you've created your game, the Game ID gets automatically copied to your clipboard so you can send it to the other players.", 0, false, null, 14, null).row();
        Popup.addGoodSizedLabel$default(helpPopup, "Players can enter your game by copying the game ID to the clipboard, and clicking on the 'Add multiplayer game' button", 0, false, null, 14, null).row();
        helpPopup.row();
        Popup.addGoodSizedLabel$default(helpPopup, "The symbol of your nation will appear next to the game when it's your turn", 0, false, null, 14, null).row();
        Popup.addCloseButton$default(helpPopup, null, null, null, null, 15, null);
        Popup.open$default(helpPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$resignPlayer(MultiplayerScreen $this, MultiplayerGamePreview multiplayerGamePreview, String playerCiv) {
        $this.resignPlayer(multiplayerGamePreview, playerCiv);
    }

    public static final /* synthetic */ void access$skipCurrentPlayerTurn(MultiplayerScreen $this, MultiplayerGamePreview multiplayerGamePreview, String playerToSkip) {
        $this.skipCurrentPlayerTurn(multiplayerGamePreview, playerToSkip);
    }

    public static final /* synthetic */ MultiplayerGamePreview access$getSelectedGame$p(MultiplayerScreen $this) {
        return $this.selectedGame;
    }

    public static final /* synthetic */ void access$selectGame(MultiplayerScreen $this, String name) {
        $this.selectGame(name);
    }
}

